//*****************************************************************************
//                               SimnBase.hpp                                 *
//                              --------------                                *
// Description : This class is the base class for all simulation classes.     *
// Started     : 01/05/2008                                                   *
// Last Update : 14/09/2009                                                   *
// Copyright   : (C) 2008 by MSWaters                                         *
// Email       : M.Waters@bom.gov.au                                          *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef SIMNBASE_HPP
#define SIMNBASE_HPP

// System Includes

using  namespace  std;

#include <iostream>
#include <cfloat>

// wxWindows Includes

#include <wx/wx.h>

// Application Includes

#include "TypeDefs.hpp"
#include "CmdBase.hpp"
#include "netlist/NetList.hpp"
#include "utility/ConvertType.hpp"

// Local Constant Declarations


//*****************************************************************************

struct SimnBase : public NetList
{
  protected :

    // Attribute to identify the simulation engine type
    eSimrType  m_eSimEng;

    // Error message generated by bValidate( )
    wxString   m_osErrMsg;

    // Function to extract information from the circuit description
    virtual  bool  bExtractSimrEng( void ) = 0;
    virtual  bool  bExtractSimCmds( void ) = 0;
    virtual  bool  bExtractSigSrc ( void );

  public :

    // The signal source component
    Component  m_oCpntSwpSrc;

             SimnBase( void );
    virtual ~SimnBase( );

    virtual  bool  bClear    ( void );
    virtual  bool  bClrCmds  ( void ) = 0;
    virtual  bool  bClrTstPts( void ) = 0;

    virtual  bool  bValidate( void );

    virtual  bool  bLoadFile( const wxString & rosFName=wxT("") );
    virtual  bool  bSaveFile( const wxString & rosFName=wxT("") );

    virtual  bool  bSetAnaType( eCmdType eAnaType ) = 0;
             void   SetErrMsg ( const wxString & rosErrMsg )
                                  { if( bIsValid( ) ) m_osErrMsg = rosErrMsg; }

    virtual  bool  bAddTstNode( const wxString & rosNode ) = 0;
    virtual  bool  bAddTstCpnt( const wxString & rosCpnt ) = 0;

                   eSimrType          eGetSimEng  ( void ) const { return( m_eSimEng ); }
    virtual        eCmdType           eGetAnaType ( void ) const = 0;
             const wxString &       rosGetErrMsg  ( void ) const { return( m_osErrMsg ); }
    virtual  const wxArrayString & rosaGetTstNodes( void ) = 0;
    virtual  const wxArrayString & rosaGetTstCpnts( void ) = 0;

    SimnBase & operator = ( const SimnBase & roSimn );

    virtual  void  Print( const wxString & rosPrefix=wxT("  ") );
};

//*****************************************************************************

#endif // SIMNBASE_HPP
