//*****************************************************************************
//                                 CmdBase.hpp                                *
//                                -------------                               *
// Description : This is the base class for all command classes. It has some  *
//               characteristics of structure in that some attributes have    *
//               public access; this simplifies the classes interface.        *
// Started     : 31/08/2006                                                   *
// Last Update : 16/09/2009                                                   *
// Copyright   : (C) 2006 by M.S.Waters                                       *
// Email       : M.Waters@bom.gov.au                                          *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef CMDBASE_HPP
#define CMDBASE_HPP

// System Includes

using  namespace  std;

#include <iostream>

// wxWidgets Includes

#include <wx/wx.h>

// Application Includes

#include "TypeDefs.hpp"

// Local Constant Declarations


//*****************************************************************************

struct CmdBase : public wxString
{
  protected :

    eSimrType  m_eSimEng;
    eCmdType   m_eCmdType;

    wxString   m_osErrMsg;

    virtual  bool  bValidate( void );

  public :

              CmdBase( void );
    virtual  ~CmdBase( );

    virtual  bool  bClear  ( void );
             bool  bIsValid( void ) { return( m_osErrMsg.IsEmpty( ) ); }

    virtual  bool  bParse ( void ) = 0;
    virtual  bool  bFormat( void ) = 0;

             bool  bSetString( wxString & ros );

                   eSimrType    eGetSimEng ( void ) { return( m_eSimEng  ); }
                   eCmdType     eGetCmdType( void ) { return( m_eCmdType ); }
             const wxString & rosGetErrMsg ( void ) { return( m_osErrMsg ); }

             void  SetErrMsg( const wxString & rosErrMsg )
                                  { if( bIsValid( ) ) m_osErrMsg = rosErrMsg; }

    virtual  CmdBase & operator = ( const CmdBase & roCmd  );

    virtual  void  Print( const wxString & rosPrefix=wxT("") );
};

//*****************************************************************************

#endif // CMDBASE_HPP
