//*****************************************************************************
//                               PrcNgSpice.hpp                               *
//                              ----------------                              *
//  Description : This class provides the interface to the NG-Spice circuit   *
//                simulator.                                                  *
//  Started     : 07/05/2004                                                  *
//  Last Update : 10/01/2008                                                  *
//  Copyright   : (C) 2004 by M.S.Waters                                      *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef PRCNGSPICE_HPP
#define PRCNGSPICE_HPP

// System Includes


// wxWindows Includes

#include <wx/wx.h>

// Application Includes

#include "TypeDefs.hpp"
#include "base/PrcSimrBase.hpp"
#include "netlist/Component.hpp"
#include "utility/ConvertType.hpp"
#include "ngspice/commands/CmdNgSpiceDC.hpp"
#include "ngspice/commands/CmdNgSpiceAC.hpp"
#include "ngspice/commands/CmdNgSpiceTR.hpp"
#include "ngspice/commands/CmdNgSpicePR.hpp"

// Local Constant Declarations

#define  NGSPICE_COL_WD  14  // Width of columns of data in the results files

//*****************************************************************************

class PrcNgSpice : public PrcSimrBase
{
  private:

    // Storage for the field list (used to replace NG-Spice field identifiers)
    wxString  m_osFieldLst;

    // Functions to parse simulator commands
    bool  bParseCmdOP( wxString & rosCmd, Simulation & roSim );
    bool  bParseCmdIC( wxString & rosCmd, Simulation & roSim );
    bool  bParseCmdDC( wxString & rosCmd, Simulation & roSim );
    bool  bParseCmdAC( wxString & rosCmd, Simulation & roSim );
    bool  bParseCmdTR( wxString & rosCmd, Simulation & roSim );
    bool  bParseCmdPR( wxString & rosCmd, Simulation & roSim );

    // Function to match a component to a set of node labels
    bool  bMatchCpnt( Simulation & roSim, wxString & rosToNodes );

    // Functions to create the simulator commands
    void  MakeCmdsDC( Simulation & roSim );
    void  MakeCmdsAC( Simulation & roSim );
    void  MakeCmdsTR( Simulation & roSim );
    bool  bMakeCmds ( Simulation & roSim );
    void  MakeFieldLst( CmdNgSpicePR & rtCmd_PR, Simulation & roSim );
    void  Convert2Nodes( wxArrayString & roasCpnts, Simulation & roSim );

    // Create the WIDTH command
    wxString & rosMakeCmdWIDTH( wxString & rosCmdPR );

    // Format the results file
    bool  bFmtResults  ( void );
    bool  bFmtGeneric  ( void );
    bool  bFmtColumnHdr( void );
    bool  bFmtDataLines( void );
    bool  bFmtPhaseData( void ); // ??? (02/02/2006) Not yet implemented

  public:

    PrcNgSpice( void );
   ~PrcNgSpice( );

    // Parse the simulation commands
    virtual  bool  bParseSim( Simulation & roSim );

    // Make the simulation commands
    virtual  bool  bMakeSim( Simulation & roSim );
};

//*****************************************************************************

#endif // PRCNGSPICE_HPP
