//*****************************************************************************
//                                GNetList.hpp                                *
//                               --------------                               *
//  Description : Provides a programatic interface to the utility gnetlist    *
//                which is used to generate net list file from various        *
//                schematic editor formats.                                   *
//  Started     : 29/01/2004                                                  *
//  Last Update : 18/02/2008                                                  *
//  Copyright   : (C) 2004 by MSWaters                                        *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef PRCGNETLIST_HPP
#define PRCGNETLIST_HPP

// System Includes

#include <iostream>

// wxWindows Includes

#include <wx/wx.h>
#include <wx/filename.h>
#include <wx/regex.h>
#include <wx/tokenzr.h>

// Application Includes

#include "base/PrcBase.hpp"

// Local Constant Declarations

#define  GNLST_BIN_NAME    wxT("gnetlist")       // The binary file name
#define  GNLST_LOG_FILE    wxT("gspiceui.log")   // Default log file name
#define  GNLST_GUILE_PROC  wxT("spice-sdb")      // Default Guile procedure
#define  GNLST_USE_SCHEM   wxT("use-schem-name") // Use schem name for net list
#define  GNLST_CUR_PROC    100  // A value greater than the number Guile proc's

//*****************************************************************************

class PrcGNetList : public PrcBase
{
  private :

    ArrayFileName  m_oafnSchems;    // The full names of the schematic file/s
    wxFileName     m_ofnNetList;    // The full name  of the list file
    size_t         m_sztGuileProc;  // The Guile procedure specifier
    wxArrayString  m_oasGuileProcs; // Array of all possible Guile procedures

    void  InitGuileProcs( void );

  public :

    PrcGNetList( void );
   ~PrcGNetList( );

    bool  bClear( void );

    bool  bSetGNetList ( const wxString & rosFileName );
    bool  bSetSchems   ( const wxString & rosFileNames );
    bool  bSetSchems   ( const wxArrayString & roasFileNames );
    bool  bSetNetList  ( const wxString & rosFileName=GNLST_USE_SCHEM );
    bool  bSetGuileProc( const wxString & rosGuileProc=GNLST_GUILE_PROC );

    const wxFileName    & rofnGetGNetList  ( void ) { return( rofnGetBinary( ) ); }
    const ArrayFileName & roafnGetSchems   ( void ) { return( m_oafnSchems ); }
    const wxFileName    & rofnGetSchem     ( size_t sztIndex=0 );
    const wxFileName    & rofnGetNetList   ( void ) { return( m_ofnNetList ); }
    const wxArrayString & roasGetGuileProcs( void ) { return( m_oasGuileProcs ); }
    const wxString      & rosGetGuileProc  ( size_t sztIndex=GNLST_CUR_PROC );
    size_t  sztGetGuileProcCnt( void ) { return( m_oasGuileProcs.GetCount( ) ); }
    size_t  sztGetSchemCnt    ( void ) { return( m_oafnSchems.GetCount( ) ); }

    bool  bExec( void );
};

//*****************************************************************************

#endif // PRCGNETLIST_HPP
