//*****************************************************************************
//                              DlgNgSpiceOPT.hpp                             *
//                             -------------------                            *
//  Description : This dialogue is used to enter values associated with the   *
//                NG-Spice OPTIONS command.                                   *
//  Started     : 03/03/2006                                                  *
//  Last Update : 23/08/2007                                                  *
//  Copyright   : (C) 2006 by M.S.Waters                                      *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef DLGNGSPICEOPT_HPP
#define DLGNGSPICEOPT_HPP

// System Includes

#include <iostream>
#include <climits>

// wxWidgets Includes

#include <wx/wx.h>
#include <wx/tokenzr.h>

// Application Includes

#include "utility/PnlValue.hpp"
#include "ngspice/commands/CmdNgSpiceOPT.hpp"

// Local Constant Declarations


//*****************************************************************************

class DlgNgSpiceOPT : public wxDialog, public CmdNgSpiceOPT
{
  private:

    // Value panel controls
    PnlValue  m_oPnlABSTOL; // Absolute current error tolerance
    PnlValue  m_oPnlCHGTOL; // Charge tolerance
    PnlValue  m_oPnlDEFAD;  // MOS drain diffusion area
    PnlValue  m_oPnlDEFAS;  // MOS source diffusion area
    PnlValue  m_oPnlDEFL;   // MOS channel length
    PnlValue  m_oPnlDEFW;   // MOS channel width
    PnlValue  m_oPnlGMIN;   // Minimum allowable conductance
    PnlValue  m_oPnlITL1;   // DC iteration limit
    PnlValue  m_oPnlITL2;   // DC transfer curve iteration limit
    PnlValue  m_oPnlITL4;   // TR analysis timepoint iteration limit
    PnlValue  m_oPnlPIVREL; // Relative ratio between largest column entry and an acceptable pivot value
    PnlValue  m_oPnlPIVTOL; // Abs. min. value for matrix entry as pivot
    PnlValue  m_oPnlRELTOL; // Relative error tolerance
    PnlValue  m_oPnlTEMP;   // Operating temp. of circuit
    PnlValue  m_oPnlTNOM;   // Nominal temp. at which device parameters measured
    PnlValue  m_oPnlTRTOL;  // TR error tolerance
    PnlValue  m_oPnlVNTOL;  // Abs. voltage error tolerance

    wxCheckBox  m_oCbxBADMOS3; // Use MOS3 model with "kappa" discontinuity

    wxStaticText  m_oLblMETHOD; // Numerical integration method
    wxChoice      m_oChoMETHOD;

    // Button controls
    wxButton  m_oBtnOk;
    wxButton  m_oBtnCancel;
    wxButton  m_oBtnDefaults;

    // Object initialization functions
    void  Initialize( void );
    void  Create    ( void );
    void  ToolTips  ( void );
    void  DoLayout  ( void );

    PnlValue * poGetPanel( int iPnlID );

    void  SetValues( void );
    void  GetValues( void );

  public:

    DlgNgSpiceOPT( wxWindow * poWin );
    ~DlgNgSpiceOPT( );

    bool  bClear( void );

    bool  bSetCmd( const wxString & rosCmd );

    double dfGetValue( int iPnlID );
    bool    bSetValue( int iPnlID, double dfValue,
                       const wxString & rosUnits=wxT("") );

    // Event handlers
    void  OnBtnOk      ( wxCommandEvent & roEvtCmd );
    void  OnBtnCancel  ( wxCommandEvent & roEvtCmd );
    void  OnBtnDefaults( wxCommandEvent & roEvtCmd );

    // In order to be able to react to a menu command, it must be given a
    // unique identifier such as a const or an enum.
    enum eDlgItemID
    {
      ID_PNL_ABSTOL = 0,
      ID_PNL_CHGTOL,
      ID_PNL_DEFAD,
      ID_PNL_DEFAS,
      ID_PNL_DEFL,
      ID_PNL_DEFW,
      ID_PNL_GMIN,
      ID_PNL_ITL1,
      ID_PNL_ITL2,
      ID_PNL_ITL4,
      ID_PNL_PIVREL,
      ID_PNL_PIVTOL,
      ID_PNL_RELTOL,
      ID_PNL_TEMP,
      ID_PNL_TNOM,
      ID_PNL_TRTOL,
      ID_PNL_VNTOL,

      ID_CBX_BADMOS3,

      ID_CHO_METHOD,

      ID_BTN_OK,
      ID_BTN_DEFAULTS,
      ID_BTN_CANCEL,

      ID_UNUSED,      // Assigned to controls for which events are not used

      ID_FST = ID_PNL_ABSTOL,
      ID_LST = ID_BTN_CANCEL
    };

    // Leave this as the last line as private access is envoked by macro
    DECLARE_EVENT_TABLE( )
};

//*****************************************************************************

#endif // DLGNGSPICEOPT_HPP
