//*****************************************************************************
//                              CmdNgSpicePR.hpp                              *
//                             ------------------                             *
//  Description : This class contains values associated with the NG-Spice     *
//                AC command. It inherits from the class CmdBase.             *
//  Started     : 16/10/2007                                                  *
//  Last Update : 18/01/2008                                                  *
//  Copyright   : (C) 2007 by M.S.Waters                                      *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef CMDNGSPICEPR_HPP
#define CMDNGSPICEPR_HPP

// System Includes

using  namespace  std;

#include <iostream>
#include <climits>

// wxWidgets Includes

#include <wx/wx.h>
#include <wx/tokenzr.h>

// Application Includes

#include "TypeDefs.hpp"
#include "base/CmdBase.hpp"
#include "utility/ConvertType.hpp"

// Local Macro and Constant Declarations


//*****************************************************************************

struct CmdNgSpicePR : public CmdBase
{
  public :

    eAnaType       m_eAnaType;
    wxArrayString  m_osaNodes;
    wxArrayString  m_osaCpnts;
    bool           m_bParms  [ ePAR_LST+1 ];
    bool           m_bCpxPrts[ eCPX_LST+1 ];

              CmdNgSpicePR( void );
    virtual  ~CmdNgSpicePR( );

    bool  bClear( void );

    virtual  bool  bParse ( void );
    virtual  bool  bFormat( void );

    wxString & operator = ( const wxString & ros )
                { *((wxString *) this) = ros; return( *((wxString *) this) ); }

    void  Print( const char * psPrefix="" );
};

//*****************************************************************************

#endif // CMDNGSPICEPR_HPP
