/*
*/

#include "PreferencePanel.h"
#include "GSDictParameters.h"
#include <AppKit/GSVbox.h>
#include <AppKit/GSHbox.h>
/*
 * The Memory Panel code
 */

static PreferencePanel *mp = nil;

@implementation PreferencePanel
+ (id) sharedPreferencePanel
{
  if (mp == nil)
    {
      mp = [PreferencePanel new];
    }

  return mp;
}

- (id)init
{
  NSRect winFrame;
  GSVbox *vBox = nil;
  GSHbox *hBox = nil;
	NSButton* button = nil;
	GSTable* table = nil;
	id label = nil;
	int i = 0;
	int j = 0;
	GSDictParameters* parameters = [GSDictParameters defaultParameters];
	NSAssert( parameters, @"no parameters found" );

	vBox = [GSVbox new];
	[vBox setDefaultMinYMargin: 5];
	[vBox setBorder: 5];
  [vBox setAutoresizingMask: (NSViewWidthSizable | NSViewHeightSizable)];

	hBox = [GSHbox new];
	[hBox setDefaultMinXMargin: 5];
	[hBox setBorder: 5];
  [vBox setAutoresizingMask: (NSViewWidthSizable | NSViewHeightSizable)];

  button = [[NSButton alloc] initWithFrame: NSMakeRect (0, 0, 100, 25)];
  [button setAutoresizingMask: (NSViewMinXMargin | NSViewMaxYMargin)];
	[button setTitle:@"Close"];
	[button setAction:@selector(cancelPressed:)];
	[hBox addView: button enablingXResizing:YES];
  AUTORELEASE (button);

  button = [[NSButton alloc] initWithFrame: NSMakeRect (0, 0, 100, 25)];
  [button setAutoresizingMask: (NSViewMinXMargin | NSViewMaxYMargin)];
	[button setTitle:@"Apply"];
	[button setButtonType: NSMomentaryLight];
	[button setKeyEquivalent: @"\r"];
	[button setImagePosition: NSImageRight];
	[button setImage: [NSImage imageNamed: @"common_ret"]];	
	[button setAction:@selector(okPressed:)];
	[hBox addView: button enablingXResizing:YES];
  AUTORELEASE (button);

	[vBox addView: hBox enablingYResizing:NO];
  AUTORELEASE (hBox);

  table = [[GSTable alloc] initWithNumberOfRows:4 numberOfColumns:2];
  [table setAutoresizingMask: (NSViewWidthSizable | NSViewHeightSizable)];

	// Database
	label = [[NSTextField alloc] initWithFrame:NSMakeRect (0, 0, 100, 20)];
	[label setAlignment: NSCenterTextAlignment];
	[label setBackgroundColor: [NSColor lightGrayColor]];
	[label setBezeled: NO];
	[label setEditable: NO];
	[label setSelectable: NO];
  [label setAutoresizingMask:NSViewWidthSizable];
	[label setStringValue:@"Database:"];
	[table putView:label atRow:0 column:0 withMargins:5.];
  AUTORELEASE (label);

	_databasePopup = [[NSPopUpButton alloc] initWithFrame:NSMakeRect (0, 0, 100, 20)];
	{
		id databases = [parameters databases];
		int databasesCount = [databases count];
		int databaseIndex = 0;
		NSAssert( databases, @"No databases found" );
		for ( databaseIndex = 0; databaseIndex < databasesCount; databaseIndex++ )
		{
			[_databasePopup addItemWithTitle:[databases objectAtIndex:databaseIndex]];
		}
	}
	[_databasePopup selectItemWithTitle:[parameters database]];
  [_databasePopup setAutoresizingMask:NSViewWidthSizable];
	[table putView:_databasePopup atRow:0 column:1 withMargins:5.];
  AUTORELEASE (_databasePopup);

	// Strategy
	label = [[NSTextField alloc] initWithFrame:NSMakeRect (0, 0, 100, 20)];
	[label setAlignment: NSCenterTextAlignment];
	[label setBackgroundColor: [NSColor lightGrayColor]];
	[label setBezeled: NO];
	[label setEditable: NO];
	[label setSelectable: NO];
  [label setAutoresizingMask:NSViewWidthSizable];
	[label setStringValue:@"Strategy:"];
	[table putView:label atRow:1 column:0 withMargins:5.];
  AUTORELEASE (label);

	_strategyPopup = [[NSPopUpButton alloc] initWithFrame:NSMakeRect (0, 0, 100, 20)];
	{
		id strategies = [parameters strategies];
		int strategiesCount = [strategies count];
		int strategyIndex = 0;
		NSAssert( strategies, @"No strategies found" );
		for ( strategyIndex = 0; strategyIndex < strategiesCount; strategyIndex++ )
		{
			[_strategyPopup addItemWithTitle:[strategies objectAtIndex:strategyIndex]];
		}
	}
	[_strategyPopup selectItemWithTitle:[parameters strategy]];
  [_strategyPopup setAutoresizingMask:NSViewWidthSizable];
	[table putView:_strategyPopup atRow:1 column:1 withMargins:5.];
  AUTORELEASE (_strategyPopup);

	// Port
	label = [[NSTextField alloc] initWithFrame:NSMakeRect (0, 0, 100, 20)];
	[label setAlignment: NSCenterTextAlignment];
	[label setBackgroundColor: [NSColor lightGrayColor]];
	[label setBezeled: NO];
	[label setEditable: NO];
	[label setSelectable: NO];
  [label setAutoresizingMask:NSViewWidthSizable];
	[label setStringValue:@"Port:"];
	[table putView:label atRow:2 column:0 withMargins:5.];
  AUTORELEASE (label);

	_portField = [[NSTextField alloc] initWithFrame:NSMakeRect (0, 0, 100, 20)];
	[_portField setEditable:YES];
 	[_portField setStringValue:[[NSNumber numberWithInt:j] stringValue]];
  [_portField setAutoresizingMask:NSViewWidthSizable];
	[_portField setStringValue:[[NSNumber numberWithInt:[parameters port]] stringValue]];
	[table putView:_portField atRow:2 column:1 withMargins:5.];
  AUTORELEASE (_portField);

	// HostName
	label = [[NSTextField alloc] initWithFrame:NSMakeRect (0, 0, 100, 20)];
	[label setAlignment: NSCenterTextAlignment];
	[label setBackgroundColor: [NSColor lightGrayColor]];
	[label setBezeled: NO];
	[label setEditable: NO];
	[label setSelectable: NO];
  [label setAutoresizingMask:NSViewWidthSizable];
	[label setStringValue:@"HostName:"];
	[table putView:label atRow:3 column:0 withMargins:5.];
  AUTORELEASE (label);

	_hostNameField = [[NSTextField alloc] initWithFrame:NSMakeRect (0, 0, 100, 20)];
	[_hostNameField setEditable:YES];
 	[_hostNameField setStringValue:[[NSNumber numberWithInt:j] stringValue]];
  [_hostNameField setAutoresizingMask:NSViewWidthSizable];
	[_hostNameField setStringValue:[parameters hostName]];
	[table putView:_hostNameField atRow:3 column:1 withMargins:5.];
  AUTORELEASE (_hostNameField);

	[vBox addView: table enablingYResizing:YES];
  AUTORELEASE (table);

	winFrame.size = [vBox frame].size;
	winFrame.origin = NSMakePoint (100, 200);
	self = [super initWithContentRect: winFrame
	 styleMask: (NSTitledWindowMask 
		     | NSClosableWindowMask 
		     | NSMiniaturizableWindowMask 
		     | NSResizableWindowMask)
	 backing: NSBackingStoreBuffered
	 defer: NO];
  
  [self setReleasedWhenClosed: NO];
  [self setContentView: vBox];
  RELEASE (vBox);
  [self setTitle: @"Preference Panel"];
	return self;
}

- (void) update: (id)sender
{
	GSDictParameters* parameters = [GSDictParameters defaultParameters];
	NSLog( @"update" );
	[_databasePopup selectItemWithTitle:[parameters database]];
	[_strategyPopup selectItemWithTitle:[parameters strategy]];
	[_portField setStringValue:[[NSNumber numberWithInt:[parameters port]] stringValue]];
	[_hostNameField setStringValue:[parameters hostName]];
}

- (void)cancelPressed:(id)sender
{
	[self close];
}

- (void)okPressed:(id)sender
{
	id parameters = [GSDictParameters defaultParameters];
	if ( [[_portField stringValue] intValue] == 0 )
	{
		NSRunAlertPanel(nil, @"Port can not be set to zero", @"Ok", nil, nil);
		return;
	}
	[parameters setHostName:[_hostNameField stringValue]];
	[parameters setPort:[[_portField stringValue] intValue]];
	[parameters setStrategy:[_strategyPopup titleOfSelectedItem]];
	[parameters setDatabase:[_databasePopup titleOfSelectedItem]];
	[parameters saveAsDefaults];	
}

@end

@implementation NSApplication (PreferencePanel)

- (void) orderFrontSharedPreferencePanel:(id)sender
{
  PreferencePanel* preferencePanel;
  preferencePanel = [PreferencePanel sharedPreferencePanel];
  [preferencePanel update: self];
  [preferencePanel orderFront:self];
}

@end
		
@implementation NSMenu (PreferencePanel)
- (void) addPreferencePanelSubmenu
{
	[self addItemWithTitle: @"Preference..."
		   action:@selector (orderFrontSharedPreferencePanel:) 
		   keyEquivalent: @""];
}
@end
