#include "rmfiles.h"

#ifdef HAVE_FTW_H
#include <ftw.h>
#else
#include "alt_ftw.h"
#endif
#include <stdio.h>
#include <string.h>
#include <unistd.h>

static int rmfiles_mode;
static int rmfiles_failed;
static const char *rmfiles_ext;

static int rmfiles_traverse(
	const char *filename,
	const struct stat *ptr,
	int flag)
{
	const char *str;

	if ( flag == FTW_F && ( str = strstr( filename, rmfiles_ext ) ) &&
		strlen( str ) == strlen( rmfiles_ext ) )
	{
		if ( unlink( filename ) == -1 ) {
			rmfiles_failed = 1;
			if ( rmfiles_mode == RMFILES_STOP_ON_FIRST_FAIL )
				return -1;
		}
	}

	return 0;
}

int rmfiles_byext( const char *path, const char *extension, int mode )
{
	rmfiles_failed = 0;
	rmfiles_mode = mode;
	rmfiles_ext = extension;

	/* traverse through each file in the archive path directory,
	 * and remove it if file ends on extension
	 */
#ifdef HAVE_FTW_H
	ftw( path, rmfiles_traverse, 1 );
#else
	alt_ftw( path, rmfiles_traverse, 1 );
#endif

	return rmfiles_failed ? RMFILES_FAILURE : RMFILES_SUCCESS;
}

