
/* $Id: file_data.h,v 1.3 2001/10/30 23:47:41 kordless Exp $ */

/**************************************************************************
 *                                                                        *
 *   Copyright (C) 2000 Grub, Inc.                                        *
 *                                                                        *
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 1, or (at your option)  *
 *   any later version.                                                   *
 *                                                                        *
 *   This program is distributed in the hope that it will be useful,      *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *   GNU General Public License for more details.                         *
 *                                                                        *
 *   You should have received a copy of the GNU General Public License    *
 *   along with this program; if not, write to the Free Software          *
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 *                                                                        *
 *   Author:  Ledio Ago - lajesus   (email: lajesus@yahoo.com)            *
 *                                                                        *
 **************************************************************************
 *									  *
 *   File: file_data.h							  *
 *   									  *
 *   Description: This file holds function prototypes for implementation  *
 *   	of the file data structure which will hold the crc of a block of  *
 *   	characters and the size of it.					  *
 *   									  *
 *   	- create_file_data: To create the structure itself		  *
 *	- file_data: It will calculate the crc of a block of characters.  *
 *	  If you want to calculate the crc of a file, you can spilt that  *
 *	  file in blocks.  You need to call file_data function until the  *
 *	  all file has been gonne through this function.  The crc value   *
 * 	  of the file and the size of the file will be stored in the 	  *
 * 	  stucture.							  *
 *	- destroy_file_data: This function will store the crc value and   * 
 *	  size of whatever block of data, if we used only one block, or   *
 *	  of a all group of blocks.  So after you split the file in blocks*
 *	  and everyone of those blocks has gonne through the file_data	  *
 *	  function, when the destroy_file_data function is called the crc *
 *	  value and size of the all blocks will be pulled out of the 	  *
 *	  sturcture and returned by the function.  Finaly it will free the*
 *	  memory taken by the structure.				  *
 *									  *
 *************************************************************************/

#ifndef file_data_h
#define file_data_h 1

#include <stdio.h>
#include "crc_32.h"

#define SUCCESS_CRC 0


typedef struct file_data_t {
	long size;
	unsigned long crcInit;	/* Used to initilize the crc   */
	unsigned long crc32;	/* It will hold the crc value. */
} file_data_t;

/* 
 * Function: 	create_file_data
 * Description:	Function create_file_data will create a structure called file_data_t
 * 		that will hold the the size and crc value of some buffer.
 * Input:	None
 * Output:	fdata, pointer to the structure
 */

file_data_t *create_file_data(); 

/* 
 * Function: 	file_data
 * Description:	Function file_data will calculate the crc value of whatever the buffer
 *		is holding and storing it in the structure together with the size of 
 *		buffer.
 * Input:	fdata, file_data_t type pointer that points to the structure
 *		buf, char type pointer pointing into a character string.
 *		len, integer type variable holding the length of the string.
 * Output:	Success, constant value of zero, showing that everything went fine
 *		size, and the crc value of the buffer using the pointer that are 
 *		passed into the function.
 */

int file_data( file_data_t *fdata, const char *buf, int len );

/*
 * Function:    destroy_file_data
 * Description: Function destroy_dile_data will free the memory that was allocated
 *              for the structure
 * Input:       fdata, pointer type file_data_t structure
 *              size, integer pointer will be used to return the size of the buffer
 *              crc, integer long pointer will be used to return the crc value fo the
 *              whatever the buffer is holding.
 * Output:      Success, constat value of zero, showing that everything went fine
 *              size, and the crc value of the buffer using the pointers that are
 *              passed into the function.
 *
 * Note: Kosta added const to the char *
 */                                        

int destroy_file_data( file_data_t *fdata, long *size, unsigned long *crc);

#endif
