/**************************************************************************
 *                                                                        *
 *   Copyright (C) 2001 Grub, Inc.                                        *
 *   File: gui.h                                                          *
 *   Authors: Lawrence Kincheloe, Philip McCauley, Patrick McAllister     *
 *                                                                        *
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 1, or (at your option)  *
 *   any later version.                                                   *
 *                                                                        *
 *   This program is distributed in the hope that it will be useful,      *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *   GNU General Public License for more details.                         *
 *                                                                        *
 *   You should have received a copy of the GNU General Public License    *
 *   along with this program; if not, write to the Free Software          *
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 *                                                                        *
 *                                                                        *
 **************************************************************************/

#ifndef _GUI_H_
#define _GUI_H_

#include "string" 	
#include "unistd.h" 
#include "stdio.h" 
#include "sys/time.h"  
#include "sys/resource.h" 
#include "sys/types.h"	
#include "sys/stat.h"
#include "fcntl.h"
#include "ctype.h"
#include "iostream.h"
#include "signal.h"
#include "errno.h"
#include "limits.h"
#include <stdlib.h>
#include <iterator>
#include <functional>
#include <curl/curl.h>
#include <curl/types.h>
#include <curl/easy.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <pthread.h>
#include "StatusInterface.h"
#include "clog.h"

/* make sure this includes are ALWAYS at the bottom as they define a macro
 * named `erase'. which makes a conflict with STL header file on some older
 * machines */
#include <curses.h>
#include <ncurses.h>

extern "C" {
 #include <verbose.h>
}

#define CPU_WAIT 15	//Time to wait for cpu update
#define CSTAT_CHECK_TIME 3600

size_t WriteMemoryCallback(void *ptr, size_t size, size_t nmemb, void *data);

void gui_exit(void); // clean's up gui on exit

class gui
{

public:
	gui();	

	~gui();	

	void start();					//start the gui
	void end();					//stop the gui
        void bar();                                     //prints url status bar
        void static_setup();                            //sets up static parts of gui
        void cstatus();                                 //prints client status
        void url_stats();                               //prints URL statistics
        void cstats();                                  //prints client statistics
        void title_bar();                               //prints title bar
        void setsize(int lines , int cols );            //formats bars, boxes, etc.
        void draw();                                    //prints the gui
        void connection_bar();                          //animation for connection status
        void gui_uptime();                              //calculates uptime
        void init_def_var();                            //for variables that are only initialized oncei
	void signaledEnd();
	void check_keyboard();

private:
        char month[5];                                  //month part of date in title bar

        //cstats
        int crawled_urls;
        int AveragePerHour;
        int crawled_today;
        int url_rank_overall;
        int url_rank_daily;

        struct tm *tm_pointer;                          //used in getting system time
        time_t current_time;
        time_t cbar_time;
        time_t start_time;                              //all these are used for getting and calculating uptime
        time_t total_up_time;
        struct rusage cpu_rec_used;                     //used for determining processor usage
        struct rusage cpu_rec_old;
        time_t cpu_time;
        time_t cstat_time;
        struct timeval cputime_temp;
        double user_time, system_time;

        float load;
        int start_position;                             //starting position of graph
        char gui_title[50];                             //title of gui
        int Sys_Load;                                   //all of these are statistics we print
	pid_t gui_pid;
	int bar_state;					//connection bar state, pulled from cbar value
	int bar_inc;					//current postion of connection bar arrows 
	
};

#endif
