/**************************************************************************/
/*                                                                        */
/*  Copyright (C) 2001, Grub, Inc.                                        */
/*  Author: Kosta Damevski <Kosta42@hotmail.com>                          */
/*                                                                        */
/*  This program is free software; you can redistribute it and/or modify  */
/*  it under the terms of the GNU General Public License as published by  */
/*  the Free Software Foundation; either version 2, or (at your option)   */
/*  any later version.                                                    */
/*                                                                        */
/*  This program is distributed in the hope that it will be useful,       */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of        */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         */
/*  GNU General Public License for more details.                          */
/*                                                                        */
/*  You should have received a copy of the GNU General Public License     */
/*  along with this program; if not, write to the                         */
/*  Free Software Foundation, Inc., 59 Temple Place - Suite 330,          */
/*  Boston, MA 02111-1307, USA.                                           */
/*                                                                        */
/**************************************************************************/

#include "ClientTalk.h"

using namespace std;

ClientTalk::ClientTalk(ClientDB *cDB, int new_act, unsigned int connectID, int PortNumber, double ver)
{
  quit = false;  
  act = new_act; 
  this->connectID = connectID;
  this->PortNumber = PortNumber;
  this->ver = ver;
  this->cDB = cDB;
  url_count = 0;
  comm = 0;
}

ClientTalk::~ClientTalk()
{
  if (comm != 0) delete comm;
}

void ClientTalk::setAct(int new_act) { act = new_act; }

void ClientTalk::start() throw (ProtocolExp)
{
  char out_buf[100];
  string err;
  int no_bye_num = 0;

  open_comm(HOST,PortNumber);

  sprintf(out_buf,"HELLO CLIENT ID=%d VER=%.2f", connectID, ver);
  send(out_buf);

  while(1) {
	recv();
	
	// S='WHAT?'
  	if (in_str[0] == "WHAT?") {
  		if (quit == true) {
                	// C='BYE'
  
 			send("BYE");
  			recv();
  			// S:'OK-BYE'|'NO-BYE'
  			if (in_str[0] == "OK-BYE") {
				close_comm();
   				return;
  			} else if (in_str[0] == "NO-BYE") {
  				if (no_bye_num == NO_MORE_BYES) return;
  				no_bye_num++;
  				continue;
  			} else {
  				err = "Expected:OK-BYE  Recieved:" + in_str[0];
				throw ProtocolExp(err.c_str(),BYE_ERROR);
  			}
  		}
  		
  		switch (act) {
  			// C='GET'
			case 0: send("GET");
				get();
				break;
			// C='PUT'
			case 2: send("PUT");
				put();
				break;
			default:
  				clog(GCLOG_INFO,"(protocol) Non standard action recieved from coordinator - breaking out of protocol"); 
				break;
		}
	}
	else if (in_str[0] == "PREPROCESS?") {
		send("PREPROCESS IS=NO");
	}
	else if (in_str[0] == "DELAY") {
		delay();
	}
	else if (in_str[0] == "RESET") {
		reset();
	} 
        //etcetera etcetera 
 
	//not all of the functionalities the protocol
	//has prescribed have been implemented. 
  }

}

void ClientTalk::reset()
{
  cDB->emptyArchive();
  clog(GCLOG_INFO,"(protocol) Resetting the Client DB as ordered from the server"); 
  close_comm();
  sleep(10);
  open_comm(HOST,PortNumber);
}


void ClientTalk::delay()
{
  int delay;
  int ret;
  string err;
 
  ret = sscanf(in_str[1].c_str(),"TIME=%d",delay);
  if (ret != 1) {
        err = "Expected:TIME=<?> Recieved:" + in_str[1];
        throw ProtocolExp(err.c_str());
  }
  clog(GCLOG_INFO,"(protocol) Delaying %d seconds",delay); 
  close_comm();
  sleep(delay);
  open_comm(HOST,PortNumber);
}

 
void ClientTalk::get()
{
  string err;

  recv();
  // S:'OK-GET'|'NO-GET'
  if (in_str[0] == "OK-GET") {
        Verboseprintf("Getting URLs and info from GRUB server...\n");
        prot = new GetProtocol(cDB,comm);
	try {

        	prot->protocol();
		url_count = (static_cast<GetProtocol *>(prot))->getURLCount();
	}
	catch (ProtocolExp& e) {

		if ( e.getcode() == NO_URLS ) {

			send("GOOD-GET");
			/* receive 'WHAT?' */
			recv();
			send("BYE");
			/* receive 'OK-BYE'|'NO-BYE' */
			recv();
			// S:'OK-BYE'|'NO-BYE'
			if (in_str[0] == "OK-BYE") {
				/* connection close below */

			} else if (in_str[0] == "NO-BYE") {
				/* TODO: we don't handle this situation yet */

			}
		}

		try { close_comm(); }
		catch (ProtocolExp& e) { }

		throw;
	}
        delete prot;
        Verboseprintf("\n");
        send("GOOD-GET");
  }
  else if (in_str[0] == "NO-GET") {
        return;
  }
  else {
        err = "Expected:OK-GET  Recieved:" + in_str[0];
        throw ProtocolExp(err.c_str(),GET_ERROR);
  }
  quit = true;
} 


void ClientTalk::put()
{
  int i, ret;
  string err;

  char dispose[4] = "YES";
  //variables used with <ok-put>
  char contents[10];
  char tags[4] = "NO";
  char new1[6] = "ONLY";
  char preprocess[4] = "NO";
  char redirects[4] = "YES";
  char distracts[4] = "NO";      

  i = recv();
  // S: <ok-put>
  if (in_str[0] == "OK-PUT") {
	//get other <ok-put> info
        ret = sscanf(in_str[1].c_str(),"CONTENTS=%s",contents);
        if (ret != 1) {
        	err = "Expected:CONTENTS=<?> Recieved:" + in_str[1];
        	throw ProtocolExp(err.c_str(),PUT_ERROR);
        }
        //if more than two words were read in from the
        //input then test for other information in <ok-put>
        if (i > 2)
        	okPut_Extras(in_str,tags,new1,preprocess,redirects,distracts);
        // <good-put>
        do {
        	Verboseprintf("Returning crawled URLs info to server...\n");
       		prot = new PutProtocol(cDB,comm,tags,contents,new1,preprocess,redirects,distracts);
    		prot->protocol();
    		delete prot;
    		Verboseprintf("\nEnd of Session with server...\n\n");
 		i = recv();
    	} while (in_str[0] == "BAD-PUT");
     	if (in_str[0] != "GOOD-PUT") {
    		err = "Expected:GOOD-PUT... Recieved:" + in_str[0];
      		throw ProtocolExp(err.c_str(),PUT_ERROR);
        }
        if (i > 1)
        	ret = sscanf(in_str[1].c_str(),"DISPOSE=%s",dispose);
        if (strcmp(dispose,"YES")==0) {
		cDB->emptyArchive();
        }
 
  }
  else if (in_str[0] == "NO-PUT") {
	return;
  }
  else {
	err = "Expected:OK-PUT... Recieved:" + in_str[0];
	throw ProtocolExp(err.c_str(),PUT_ERROR);
  }
  quit = true;                                                       
}


void ClientTalk::okPut_Extras(string in_str[],    char *tags,
			      char *new1, 	  char *preprocess,
			      char *redirects, 	  char *distracts )
{
int currentStr = 2;
int ret;

	//TAGS
	ret = sscanf(in_str[currentStr].c_str(),"TAGS=%s",tags);
	if (ret != 1) tags = "NO"; else currentStr++;
	//NEW
	ret = sscanf(in_str[currentStr].c_str(),"NEW=%s",new1);
	if (ret != 1) new1 = "ONLY"; else currentStr++;
        //PREPROCESS
	ret = sscanf(in_str[currentStr].c_str(),"PREPROCESS=%s",preprocess);
	if (ret != 1) preprocess = "NO"; else currentStr++;
	//REDIRECTS
	ret = sscanf(in_str[currentStr].c_str(),"REDIRECTS=%s",redirects);
	if (ret != 1) redirects = "YES"; else currentStr++;
	//DISTRACTS
	ret = sscanf(in_str[currentStr].c_str(),"DISTRACT-NEW=%s",distracts);
	if (ret != 1) distracts = "NO";
#ifdef DEBUG	
	clog(GCLOG_DEBUG,"(protocol) okPut_Extras: %s %s %s %s %s",tags,new1,preprocess,redirects,distracts);
#endif
}


void ClientTalk::open_comm(string host, int port)
{
    connfd = openConnection(host.c_str(),port);
    if (connfd == -1)
    	throw ProtocolExp("Communication Error: Could not establish connection",COMM_ERROR);
    comm = new Communication(connfd);	
    clog(GCLOG_INFO,"(protocol) Connected Successfully to %s:%d",host.c_str(),port);
}


void ClientTalk::close_comm()
{
    int i;
    i = closeConnection(connfd);
    if (i == -1)
    	throw ProtocolExp("Communication Error: Could not close connection",COMM_ERROR);
    clog(GCLOG_INFO,"(protocol) Disconnected Successfully");
}


int ClientTalk::send(const char *msg)
{
  int ret;

  //Use comm's send method since it appends a '\n' and it flushes the output
  ret = comm->send(msg,strlen(msg));
  if (ret<0) {
    	clog(GCLOG_INFO,"(protocol) Communication error: sending data to server");

	// i commented out this error, but we need to improve the reporting here - kord
  	// cout<<"Error sending: "<<comm->errmsg()<<endl;
  	throw ProtocolExp("Communication Error",COMM_ERROR);
  }

  return ret;
}


int ClientTalk::recv()
{
  int ret;
  
  ret = comm->read_spacesplit(in_str,NUM_OF_READ_WORDS,READ_LINE_LENGTH,'\n');
  if (ret<0) {
    	clog(GCLOG_INFO,"(protocol) Communication error: receiving data from server");

	// i commented out this error, but we need to improve the reporting here - kord
  	// cout<<"Error receiving: "<<comm->errmsg()<<endl;
  	throw ProtocolExp("Communication Error",COMM_ERROR);
  }

  return ret;
}

int ClientTalk::getURLCount()
{
	return url_count;
}
