#!/usr/bin/python
#
# Copyright 2009 Martin Owens
#
# This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>
#
"""Small app for selecting launchpad branches."""

# Import standard python libs
import gtk
import gtk.gdk
import sys

gtk.gdk.threads_init()

from GroundControl.branches import BranchSelection


def print_results(lpname, workname, branch):
    print _("Launchpad Name: %s") % lpname
    print _("Branch not Checkout: %s") % str(branch)
    print _("Work-name: %s") % branch

if __name__ == '__main__':
    res = BranchSelection(True, sys.argv[1], './', callback=print_results)
