/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 * --
 * "Set Away Message" window.
 */

#import <SetAwayMessage.h>
#import <ClientInstance.h>
#import <Defaults.h>
#import <String.h>
#import <ErrorWindow.h>

#import <Grouch/GrouchStringTool.h>

#import <Renaissance/Renaissance.h>

static NSString *awayMsgDefault = @"Current Away Message";

@implementation SetAwayMessage

- init
{
	NSDictionary *msgs;
	NSEnumerator *e;
	NSString *current;

	[super init];
	[NSBundle loadGSMarkupNamed:@"SetAwayMessage" owner:self];
	[window orderFront:nil];
	[window makeKeyWindow];
	[messageTextView setDefaultFont];

	msgs = [Defaults getAwayMessages];
	e = [msgs keyEnumerator];
	while( (current = [e nextObject]) )
		[titleComboBox addItemWithObjectValue:current];
	

	{
		NSArray *clients = [ClientInstance clientInstances];
		int i;
		for( i=0; i<[clients count]; ++i )
		{
			ClientInstance *cli = [clients objectAtIndex:i];
			NSString *nick = [cli nick];
			if( nick )
				[loginComboBox addItemWithObjectValue:nick];
		}
	}

	if( (current = [Defaults get:awayMsgDefault]) )
		[titleComboBox setStringValue:current];
	else
	{
		[titleComboBox selectItemAtIndex:0];
		[titleComboBox setObjectValue:
			 [titleComboBox objectValueOfSelectedItem]];
	}
	[self gotTitle];
	[loginComboBox selectItemAtIndex:0];
	[loginComboBox setObjectValue:
		 [loginComboBox objectValueOfSelectedItem]];

	return self;
}

- (void)gotTitle
{
	NSString *msg = [Defaults getAwayMessage:[titleComboBox stringValue]];
	if( !msg )
		msg = @"";
	msg = [NSString stringWithFormat:@"%@%@",
		[Defaults defaultTextTags], msg];	
	if( msg )
	{
		NSAttributedString *attributed = [msg parseHtml];
		NSTextStorage *text = [messageTextView textStorage];
		[text setAttributedString:attributed];
	}
}

- (BOOL)validate
{
	NSString *title = [titleComboBox stringValue];
	NSString *msg = [[messageTextView textStorage] string];
	if( ![title length] || ![msg length] )
	{
		[ErrorWindow errorWithString:
		 [GrouchString getString:@"vague-form"]];
		return NO;
	}
	else
		return YES;
}

- (NSString*)saveMessage
{
	NSString *title = [titleComboBox stringValue];
	NSAttributedString *attributed;
	NSString *msg;

	[[messageTextView textStorage] inferLinks];

	attributed = [messageTextView textStorage];
	msg = [attributed generateHtml];

	if( ![self validate] )
		return nil;

	[Defaults setAwayMessage:msg withTitle:title];
	return msg;
}

- (void)goAway
{
	NSString *login = [loginComboBox stringValue];
	ClientInstance *cli = [ClientInstance clientByName:login];
	NSString *msg = [self saveMessage];
	if( !msg )
		return;
	[Defaults set:[titleComboBox stringValue] forKey:awayMsgDefault];
	if( cli )
	{
		[cli setAway:msg];
		[window performClose:self];
	}
	else
		[ErrorWindow errorWithString:
		 [GrouchString getString:@"no-session"]];
}

- (void)deleteMessage
{
	[Defaults removeAwayMessage:[titleComboBox stringValue]];
}

- (void)setLogin:(NSString*)login
{
	[loginComboBox setStringValue:login];
}

- (BOOL)windowShouldClose:sender
{
	[window autorelease];
	[titleComboBox release];
	[loginComboBox release];
	[messageTextView release];
	[self release];
	return YES;
}

@end
