/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 * --
 * Info about chat rooms goes here.
 */

#import <Oscar/OscarClient.h>
#import <Oscar/OscarHandlers.h>
#import <Oscar/OscarIncomingSnac.h>
#import <Oscar/OscarTlvList.h>

// Room information
@interface OscarSnac000d0009 : NSObject <OscarSnacHandler>
- (void)handleSnacForClient:(OscarFlap*)flap
	ofFamily:(int)family andType:(int)type
	withFlags:(int)flags andTag:tag
	buffer:(OscarIncomingSnac*)buf;
@end

@implementation OscarSnac000d0009
- (void)handleSnacForClient:(OscarFlap*)flap
	ofFamily:(int)family andType:(int)type
	withFlags:(int)flags andTag:tag
	buffer:(OscarIncomingSnac*)buf
{
	OscarTlvListIn *tlv = [buf readTLVs];
	if( (buf=[tlv getTLV:0x04]) )
	{
		int exchange = [buf readInt16];
		NSString *cookie = [buf readPascalString], *room;
		int instance = [buf readInt16];
		[buf readByte];
		tlv = [buf readTlvList];	
		if( !(buf = [tlv getTLV:0xd3]) )
			return;
		room = [buf readRawString];

		[[flap client] askForChannel:room withCookie:cookie
		 andExchange:exchange andInstance:instance];
	}
}
@end

@implementation OscarChatNavHandler
+ get
{
	static id r = nil;
	if( r )
		return r;
	else
		return r = [self new];
}

- init
{
	[super init];
	[super initForFamily:0x0d andVersion:0x01 andDLL:0x0629];
	[self addHandler:[OscarSnac000d0009 new] forType:0x09];
	return self;
}
@end
