/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 * --
 * See note in OscarCache.h
 */

#import <Oscar/OscarCache.h>
#import <Grouch/GrouchTimedDictionary.h>

#import <Foundation/NSDictionary.h>
#import <Foundation/NSValue.h>

#include <stdlib.h>

static GrouchTimedDictionary *dict = NULL;
static struct node
{
	int i;
	struct node *next;
} *stack = NULL;
static int next_object = 0, objects_issued = 0;

static void init_private_data()
{
	if( !dict )
	{
		dict = [GrouchTimedDictionary new];
		[dict expireTime:10*60];
	}
	if( !objects_issued && stack )
	{
		struct node *n = stack;
		while( n )
		{
			stack = n->next;
			free( n );
			n = stack;
		}
		next_object = 0;
	}
}

@implementation OscarCache

+ (int)newTag:obj
{
	init_private_data();
	if( obj )
	{
		struct node *next = stack;
		int tag;
		NSNumber *key;
		if( next )
		{
			tag = next->i;
			stack = next;
			free( next );
		}
		else
			tag = ++next_object;
		++objects_issued;
		key = [NSNumber numberWithInt:tag];
		[dict setObject:obj forKey:key];
		return tag;
	}
	else
		return 0;
}

+ getTag:(int)tag
{
	init_private_data();
	if( tag )
	{
		NSNumber *key = [NSNumber numberWithInt:tag];
		id r = [dict objectForKey:key];
		if( r )
		{
			[r retain];
			[r autorelease];
			[dict removeObjectForKey:key];
			if( --objects_issued )
			{
				struct node *n = malloc(sizeof(struct node));
				if( n )
				{
					n->i = tag;
					n->next = stack;
					stack = n;
				}
			}
			else
				init_private_data();
		}
		return r;
	}
	else
		return nil;
}

@end
