/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 * --
 * This class is sort of like the "reading input" equivalent to OscarBuffer,
 * which generates output.  This class will help you make some sense of
 * SNAC messages.
 *
 * As more bytes are "read", more of the buffer is discarded.
 * Most of the functions are zero copy, so don't worry about any huge
 * overhead.
 *
 * Return values of static methods are not autoreleased, but everything
 * else is.
 */

#import <Foundation/NSObject.h>
#import <Foundation/NSString.h>
#include <stddef.h>

#define SNAC_SIZE		10

@class NSString;
@class OscarTlvListIn;

@interface OscarIncomingSnac : NSObject
{
	struct
	{
		int type, family, flags;
		long tid;
	} header;
	const unsigned char *buf;
	size_t len;
}

// NB: these are NOT autoreleased
+ snacAtBuffer:(const void*)buf withLength:(size_t)len;
+ snacAtHeaderlessBuffer:(const void*)buf withLength:(size_t)len;
- init;
- initWithBuffer:(const void*)buf withLength:(size_t)len;
- initWithHeaderlessBuffer:(const void*)buf withLength:(size_t)len;

- (int)type;
- (int)family;
- (int)flags;
- (long)tagID;

- (int)readInt16;
- (long)readInt32;
- (unsigned char)readByte;
- (NSString *)readPascalString;
- (NSString *)readPascalString16;
- (NSString *)readRawString;	  // interprets the WHOLE BUFFER as a string
- (NSString *)readRawStringWithEncoding:(NSStringEncoding)e;

// these ARE autoreleased, as well as the buffers they return.
- (OscarTlvListIn*)readTLVs;	  // interpret whole buffer as TLVs
- (OscarTlvListIn*)readTlvList;   // read word N, then read N TLVs
- (OscarTlvListIn*)readTlvList16; // for SSI

- (const void*)buffer;
- (size_t)bytesRemaining;

// discard n bytes.
- (void)skipBytes:(size_t)n;
@end
