/*
 $Id: IntRangeTest.java 6546 2007-06-11 08:57:40Z paulk $

 Copyright 2003 (C) James Strachan and Bob Mcwhirter. All Rights Reserved.

 Redistribution and use of this software and associated documentation
 ("Software"), with or without modification, are permitted provided
 that the following conditions are met:

 1. Redistributions of source code must retain copyright
    statements and notices.  Redistributions must also contain a
    copy of this document.

 2. Redistributions in binary form must reproduce the
    above copyright notice, this list of conditions and the
    following disclaimer in the documentation and/or other
    materials provided with the distribution.

 3. The name "groovy" must not be used to endorse or promote
    products derived from this Software without prior written
    permission of The Codehaus.  For written permission,
    please contact info@codehaus.org.

 4. Products derived from this Software may not be called "groovy"
    nor may "groovy" appear in their names without prior written
    permission of The Codehaus. "groovy" is a registered
    trademark of The Codehaus.

 5. Due credit should be given to The Codehaus -
    http://groovy.codehaus.org/

 THIS SOFTWARE IS PROVIDED BY THE CODEHAUS AND CONTRIBUTORS
 ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT
 NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL
 THE CODEHAUS OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 OF THE POSSIBILITY OF SUCH DAMAGE.

 */
package groovy.lang;

/**
 * Provides unit tests for the <code>IntRange</code> class.
 *
 * @author James Strachan
 * @version $Revision: 6546 $
 */
public class IntRangeTest extends NumberRangeTest {

    public void testCreateTooBigRange() {
        try {
            createRange(0, Integer.MAX_VALUE);
            fail("too large range accepted");
        }
        catch (IllegalArgumentException e) {
            assertTrue("expected exception thrown", true);
        }
    }

    /**
     * Tests providing invalid arguments to the protected constructor.
     */
    public void testInvalidArgumentsToConstructor() {
        try {
            new IntRange(2, 1, true);
            fail("invalid range created");
        }
        catch (IllegalArgumentException e) {
            assertTrue("expected exception thrown", true);
        }
    }

    /**
     * Tests getting the to and from values as <code>int</code>s.
     */
    public void testGetToFromInt() {
        final int from = 3, to = 7;
        final IntRange range = new IntRange(from, to);
        assertEquals("wrong 'from'", from, range.getFromInt());
        assertEquals("wrong 'to'", to, range.getToInt());
    }

    /**
     * {@inheritDoc}
     */
    protected Comparable createValue(int value) {
        return new Integer(value);
    }

    /**
     * {@inheritDoc}
     */
    protected Range createRange(int from, int to) {
        return new IntRange(from, to);
    }
}
