/* $Id: scan.c,v 1.6 2004/12/11 19:26:12 ellson Exp $ $Revision: 1.6 $ */
/* vim:set shiftwidth=4 ts=8: */

/**********************************************************
*      This software is part of the graphviz package      *
*                http://www.graphviz.org/                 *
*                                                         *
*            Copyright (c) 1994-2004 AT&T Corp.           *
*                and is licensed under the                *
*            Common Public License, Version 1.0           *
*                      by AT&T Corp.                      *
*                                                         *
*        Information and Software Systems Research        *
*              AT&T Research, Florham Park NJ             *
**********************************************************/

/* requires flex (i.e. not lex)  */
#line 13 "/home/ellson/graphviz/agraph/scan.l"
#include <grammar.h>
#include <aghdr.h>
#define GRAPH_EOF_TOKEN		'@'	/* lex class must be defined below */
	/* this is a workaround for linux flex */
static int line_num = 1;
static int html_nest = 0;	/* nesting level for html strings */
static char *InputFile;
static Agdisc_t *Disc;
static void *Ifile;

  /* Reset line number */
void agreadline(int n)
{
    line_num = n;
}

  /* (Re)set file:
   */
void agsetfile(char *f)
{
    InputFile = f;
    line_num = 1;
}

/* There is a hole here, because switching channels 
 * requires pushing back whatever was previously read.
 * There probably is a right way of doing this.
 */
void aglexinit(Agdisc_t * disc, void *ifile)
{
    Disc = disc;
    Ifile = ifile;
}

#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ((result = Disc->io->afread(Ifile, buf, max_size)) < 0) \
		YY_FATAL_ERROR( "input in flex scanner failed" )
#endif

/* buffer for arbitrary length strings (longer than BUFSIZ) */
static char *Sbuf, *Sptr, *Send;
static void beginstr(void)
{
    if (Sbuf == NIL(char *)) {
	Sbuf = malloc(BUFSIZ);
	Send = Sbuf + BUFSIZ;
    }
    Sptr = Sbuf;
    *Sptr = 0;
}

static void addstr(char *src)
{
    char c;
    if (Sptr > Sbuf)
	Sptr--;
    do {
	do {
	    c = *Sptr++ = *src++;
	} while (c && (Sptr < Send));
	if (c) {
	    long sz = Send - Sbuf;
	    long off = Sptr - Sbuf;
	    sz *= 2;
	    Sbuf = (char *) realloc(Sbuf, sz);
	    Send = Sbuf + sz;
	    Sptr = Sbuf + off;
	}
    } while (c);
}

static void endstr(void)
{
    aaglval.str = (char *) agstrdup(Ag_G_global, Sbuf);
}

/* chkNum:
 * The regexp for NUMBER allows a terminating letter.
 * This way we can catch a number immediately followed by a name
 * and report this to the user.
 */
static int chkNum(void)
{
    char c = aagtext[aagleng - 1];	/* last character */
    if (!isdigit(c) && (c != '.')) {	/* c is letter */
	char buf[BUFSIZ];
	sprintf(buf, "badly formed number '%s' in line %d\n", aagtext,
		line_num);
	strcat(buf, "Splits into two name tokens");
	agerror(AGERROR_SYNTAX, buf);
	return 1;
    } else
	return 0;
}

/* The LETTER class below consists of ascii letters, underscore, all non-ascii
 * characters. This allows identifiers to have characters from any
 * character set independent of locale. The downside is that, for certain
 * character sets, non-letter and, in fact, undefined characters will be
 * accepted. This is not likely and, from dot's stand, shouldn't do any
 * harm. (Presumably undefined characters will be ignored in display.) And,
 * it allows a greater wealth of names. */
#define comment 1

#define qstring 2

#define hstring 3

#line 543 "lex.aag.c"

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int aagwrap YY_PROTO((void));
#else
extern int aagwrap YY_PROTO((void));
#endif
#endif

#ifndef YY_NO_UNPUT
static void aagunput YY_PROTO((int c, char *buf_ptr));
#endif

#ifndef aagtext_ptr
static void aag_flex_strncpy YY_PROTO((char *, aagconst char *, int));
#endif

#ifdef YY_NEED_STRLEN
static int aag_flex_strlen YY_PROTO((aagconst char *));
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int aaginput YY_PROTO((void));
#else
static int input YY_PROTO((void));
#endif
#endif

#if YY_STACK_USED
static int aag_start_stack_ptr = 0;
static int aag_start_stack_depth = 0;
static int *aag_start_stack = 0;
#ifndef YY_NO_PUSH_STATE
static void aag_push_state YY_PROTO((int new_state));
#endif
#ifndef YY_NO_POP_STATE
static void aag_pop_state YY_PROTO((void));
#endif
#ifndef YY_NO_TOP_STATE
static int aag_top_state YY_PROTO((void));
#endif

#else
#define YY_NO_PUSH_STATE 1
#define YY_NO_POP_STATE 1
#define YY_NO_TOP_STATE 1
#endif

#ifdef YY_MALLOC_DECL
YY_MALLOC_DECL
#else
#if __STDC__
#ifndef __cplusplus
#include <stdlib.h>
#endif
#else
/* Just try to get by without declaring the routines.  This will fail
 * miserably on non-ANSI systems for which sizeof(size_t) != sizeof(int)
 * or sizeof(void*) != sizeof(int).
 */
#endif
#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */

#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO (void) fwrite( aagtext, aagleng, 1, aagout )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( aag_current_buffer->aag_is_interactive ) \
		{ \
		int c = '*', n; \
		for ( n = 0; n < max_size && \
			     (c = getc( aagin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( aagin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else if ( ((result = fread( buf, 1, max_size, aagin )) == 0) \
		  && ferror( aagin ) ) \
		YY_FATAL_ERROR( "input in flex scanner failed" );
#endif

/* No semi-colon after return; correct usage is to write "aagterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef aagterminate
#define aagterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) aag_fatal_error( msg )
#endif

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL int aaglex YY_PROTO(( void ))
#endif

/* Code executed at the beginning of each rule, after aagtext and aagleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

YY_DECL {
    register aag_state_type aag_current_state;
    register char *aag_cp = NULL, *aag_bp = NULL;
    register int aag_act;

#line 108 "/home/ellson/graphviz/agraph/scan.l"

#line 696 "lex.aag.c"

    if (aag_init) {
	aag_init = 0;

#ifdef YY_USER_INIT
	YY_USER_INIT;
#endif

	if (!aag_start)
	    aag_start = 1;	/* first start state */

	if (!aagin)
	    aagin = stdin;

	if (!aagout)
	    aagout = stdout;

	if (!aag_current_buffer)
	    aag_current_buffer = aag_create_buffer(aagin, YY_BUF_SIZE);

	aag_load_buffer_state();
    }

    while (1) {			/* loops until end-of-file is reached */
	aag_cp = aag_c_buf_p;

	/* Support of aagtext. */
	*aag_cp = aag_hold_char;

	/* aag_bp points to the position in aag_ch_buf of the start of
	 * the current run.
	 */
	aag_bp = aag_cp;

	aag_current_state = aag_start;
      aag_match:
	do {
	    register YY_CHAR aag_c = aag_ec[YY_SC_TO_UI(*aag_cp)];
	    if (aag_accept[aag_current_state]) {
		aag_last_accepting_state = aag_current_state;
		aag_last_accepting_cpos = aag_cp;
	    }
	    while (aag_chk[aag_base[aag_current_state] + aag_c] !=
		   aag_current_state) {
		aag_current_state = (int) aag_def[aag_current_state];
		if (aag_current_state >= 91)
		    aag_c = aag_meta[(unsigned int) aag_c];
	    }
	    aag_current_state =
		aag_nxt[aag_base[aag_current_state] +
			(unsigned int) aag_c];
	    ++aag_cp;
	}
	while (aag_base[aag_current_state] != 188);

      aag_find_action:
	aag_act = aag_accept[aag_current_state];
	if (aag_act == 0) {	/* have to back up */
	    aag_cp = aag_last_accepting_cpos;
	    aag_current_state = aag_last_accepting_state;
	    aag_act = aag_accept[aag_current_state];
	}

	YY_DO_BEFORE_ACTION;


      do_action:		/* This label is used only to access EOF actions. */


	switch (aag_act) {	/* beginning of action switch */
	case 0:		/* must back up */
	    /* undo the effects of YY_DO_BEFORE_ACTION */
	    *aag_cp = aag_hold_char;
	    aag_cp = aag_last_accepting_cpos;
	    aag_current_state = aag_last_accepting_state;
	    goto aag_find_action;

	case 1:
	    YY_RULE_SETUP
#line 109 "/home/ellson/graphviz/agraph/scan.l"
		return (EOF);
	YY_BREAK case 2:
	    YY_RULE_SETUP
#line 110 "/home/ellson/graphviz/agraph/scan.l"
		line_num++;
	YY_BREAK case 3:
	    YY_RULE_SETUP
#line 111 "/home/ellson/graphviz/agraph/scan.l"
		BEGIN(comment);
	YY_BREAK case 4:
	    YY_RULE_SETUP
#line 112 "/home/ellson/graphviz/agraph/scan.l"
/* eat anything not a '*' */
	YY_BREAK case 5:
	    YY_RULE_SETUP
#line 113 "/home/ellson/graphviz/agraph/scan.l"
/* eat up '*'s not followed by '/'s */
	YY_BREAK case 6:
	    YY_RULE_SETUP
#line 114 "/home/ellson/graphviz/agraph/scan.l"
		BEGIN(INITIAL);
	YY_BREAK case 7:
	    YY_RULE_SETUP
#line 115 "/home/ellson/graphviz/agraph/scan.l"
/* ignore C++-style comments */
	YY_BREAK case 8:
	    YY_RULE_SETUP
#line 116 "/home/ellson/graphviz/agraph/scan.l"
/* ignore shell-like comments */
	YY_BREAK case 9:
	    YY_RULE_SETUP
#line 117 "/home/ellson/graphviz/agraph/scan.l"
/* ignore whitespace */
	YY_BREAK case 10:
	    YY_RULE_SETUP
#line 118 "/home/ellson/graphviz/agraph/scan.l"
		return (T_node);	/* see tokens in agcanonstr */
	YY_BREAK case 11:
	    YY_RULE_SETUP
#line 119 "/home/ellson/graphviz/agraph/scan.l"
		return (T_edge);
	YY_BREAK case 12:
	    YY_RULE_SETUP
#line 120 "/home/ellson/graphviz/agraph/scan.l"
		return (T_graph);
	YY_BREAK case 13:
	    YY_RULE_SETUP
#line 121 "/home/ellson/graphviz/agraph/scan.l"
		return (T_digraph);
	YY_BREAK case 14:
	    YY_RULE_SETUP
#line 122 "/home/ellson/graphviz/agraph/scan.l"
		return (T_strict);
	YY_BREAK case 15:
	    YY_RULE_SETUP
#line 123 "/home/ellson/graphviz/agraph/scan.l"
		return (T_subgraph);
	YY_BREAK case 16:
	    YY_RULE_SETUP
#line 124 "/home/ellson/graphviz/agraph/scan.l"
		return (T_edgeop);
	YY_BREAK case 17:
	    YY_RULE_SETUP
#line 125 "/home/ellson/graphviz/agraph/scan.l"
	    {
		aaglval.str = (char *) agstrdup(Ag_G_global, aagtext);
		return (T_atom);
	    }
	YY_BREAK case 18:
	    YY_RULE_SETUP
#line 126 "/home/ellson/graphviz/agraph/scan.l"
	    {
		if (chkNum())
		    aagless(aagleng - 1);
		aaglval.str = (char *) agstrdup(Ag_G_global, aagtext);
		return (T_atom);
	    }
	YY_BREAK case 19:
	    YY_RULE_SETUP
#line 127 "/home/ellson/graphviz/agraph/scan.l"
		BEGIN(qstring);
	    beginstr();
	YY_BREAK case 20:
	    YY_RULE_SETUP
#line 128 "/home/ellson/graphviz/agraph/scan.l"
		BEGIN(INITIAL);
	    endstr();
	    return (T_qatom);
	YY_BREAK case 21:
	    YY_RULE_SETUP
#line 129 "/home/ellson/graphviz/agraph/scan.l"
		line_num++;	/* ignore escaped newlines */
	YY_BREAK case 22:
	    YY_RULE_SETUP
#line 130 "/home/ellson/graphviz/agraph/scan.l"
		addstr(aagtext);
	YY_BREAK case 23:
	    YY_RULE_SETUP
#line 131 "/home/ellson/graphviz/agraph/scan.l"
		BEGIN(hstring);
	    html_nest = 1;
	    beginstr();
	YY_BREAK case 24:
	    YY_RULE_SETUP
#line 132 "/home/ellson/graphviz/agraph/scan.l"
		html_nest--;
	    if (html_nest)
		addstr(aagtext);
	    else {
		BEGIN(INITIAL);
		endstr();
		return (T_qatom);
	    }
	YY_BREAK case 25:
	    YY_RULE_SETUP
#line 133 "/home/ellson/graphviz/agraph/scan.l"
		html_nest++;
	    addstr(aagtext);
	YY_BREAK case 26:
	    YY_RULE_SETUP
#line 134 "/home/ellson/graphviz/agraph/scan.l"
		addstr("<");
	YY_BREAK case 27:
	    YY_RULE_SETUP
#line 135 "/home/ellson/graphviz/agraph/scan.l"
		addstr(">");
	YY_BREAK case 28:
	    YY_RULE_SETUP
#line 136 "/home/ellson/graphviz/agraph/scan.l"
		line_num++;	/* ignore escaped newlines */
	YY_BREAK case 29:
	    YY_RULE_SETUP
#line 137 "/home/ellson/graphviz/agraph/scan.l"
		addstr(aagtext);
	YY_BREAK case 30:
	    YY_RULE_SETUP
#line 138 "/home/ellson/graphviz/agraph/scan.l"
		return (aagtext[0]);
	YY_BREAK case 31:
	    YY_RULE_SETUP
#line 139 "/home/ellson/graphviz/agraph/scan.l"
		ECHO;
	    YY_BREAK
#line 934 "lex.aag.c"
	case YY_STATE_EOF(INITIAL):
	case YY_STATE_EOF(comment):
	case YY_STATE_EOF(qstring):
	case YY_STATE_EOF(hstring):
	    aagterminate();

	case YY_END_OF_BUFFER:
	    {
		/* Amount of text matched not including the EOB char. */
		int aag_amount_of_matched_text =
		    (int) (aag_cp - aagtext_ptr) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*aag_cp = aag_hold_char;
		YY_RESTORE_YY_MORE_OFFSET
		    if (aag_current_buffer->aag_buffer_status ==
			YY_BUFFER_NEW) {
		    /* We're scanning a new file or input source.  It's
		     * possible that this happened because the user
		     * just pointed aagin at a new source and called
		     * aaglex().  If so, then we have to assure
		     * consistency between aag_current_buffer and our
		     * globals.  Here is the right place to do so, because
		     * this is the first action (other than possibly a
		     * back-up) that will match for the new input source.
		     */
		    aag_n_chars = aag_current_buffer->aag_n_chars;
		    aag_current_buffer->aag_input_file = aagin;
		    aag_current_buffer->aag_buffer_status =
			YY_BUFFER_NORMAL;
		}

		/* Note that here we test for aag_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since aag_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if (aag_c_buf_p <= &aag_current_buffer->aag_ch_buf[aag_n_chars]) {	/* This was really a NUL. */
		    aag_state_type aag_next_state;

		    aag_c_buf_p = aagtext_ptr + aag_amount_of_matched_text;

		    aag_current_state = aag_get_previous_state();

		    /* Okay, we're now positioned to make the NUL
		     * transition.  We couldn't have
		     * aag_get_previous_state() go ahead and do it
		     * for us because it doesn't know how to deal
		     * with the possibility of jamming (and we don't
		     * want to build jamming into it because then it
		     * will run more slowly).
		     */

		    aag_next_state = aag_try_NUL_trans(aag_current_state);

		    aag_bp = aagtext_ptr + YY_MORE_ADJ;

		    if (aag_next_state) {
			/* Consume the NUL. */
			aag_cp = ++aag_c_buf_p;
			aag_current_state = aag_next_state;
			goto aag_match;
		    }

		    else {
			aag_cp = aag_c_buf_p;
			goto aag_find_action;
		    }
		}

		else
		    switch (aag_get_next_buffer()) {
		    case EOB_ACT_END_OF_FILE:
			{
			    aag_did_buffer_switch_on_eof = 0;

			    if (aagwrap()) {
				/* Note: because we've taken care in
				 * aag_get_next_buffer() to have set up
				 * aagtext, we can now set up
				 * aag_c_buf_p so that if some total
				 * hoser (like flex itself) wants to
				 * call the scanner after we return the
				 * YY_NULL, it'll still work - another
				 * YY_NULL will get returned.
				 */
				aag_c_buf_p = aagtext_ptr + YY_MORE_ADJ;

				aag_act = YY_STATE_EOF(YY_START);
				goto do_action;
			    }

			    else {
				if (!aag_did_buffer_switch_on_eof)
				    YY_NEW_FILE;
			    }
			    break;
			}

		    case EOB_ACT_CONTINUE_SCAN:
			aag_c_buf_p =
			    aagtext_ptr + aag_amount_of_matched_text;

			aag_current_state = aag_get_previous_state();

			aag_cp = aag_c_buf_p;
			aag_bp = aagtext_ptr + YY_MORE_ADJ;
			goto aag_match;

		    case EOB_ACT_LAST_MATCH:
			aag_c_buf_p =
			    &aag_current_buffer->aag_ch_buf[aag_n_chars];

			aag_current_state = aag_get_previous_state();

			aag_cp = aag_c_buf_p;
			aag_bp = aagtext_ptr + YY_MORE_ADJ;
			goto aag_find_action;
		    }
		break;
	    }

	default:
	    YY_FATAL_ERROR
		("fatal flex scanner internal error--no action found");
	}			/* end of action switch */
    }				/* end of scanning one token */
}				/* end of aaglex */


/* aag_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */

static int aag_get_next_buffer()
{
    register char *dest = aag_current_buffer->aag_ch_buf;
    register char *source = aagtext_ptr;
    register int number_to_move, i;
    int ret_val;

    if (aag_c_buf_p > &aag_current_buffer->aag_ch_buf[aag_n_chars + 1])
	YY_FATAL_ERROR
	    ("fatal flex scanner internal error--end of buffer missed");

    if (aag_current_buffer->aag_fill_buffer == 0) {	/* Don't try to fill the buffer, so this is an EOF. */
	if (aag_c_buf_p - aagtext_ptr - YY_MORE_ADJ == 1) {
	    /* We matched a single character, the EOB, so
	     * treat this as a final EOF.
	     */
	    return EOB_ACT_END_OF_FILE;
	}

	else {
	    /* We matched some text prior to the EOB, first
	     * process it.
	     */
	    return EOB_ACT_LAST_MATCH;
	}
    }

    /* Try to read more data. */

    /* First move last chars to start of buffer. */
    number_to_move = (int) (aag_c_buf_p - aagtext_ptr) - 1;

    for (i = 0; i < number_to_move; ++i)
	*(dest++) = *(source++);

    if (aag_current_buffer->aag_buffer_status == YY_BUFFER_EOF_PENDING)
	/* don't do the read, it's not guaranteed to return an EOF,
	 * just force an EOF
	 */
	aag_current_buffer->aag_n_chars = aag_n_chars = 0;

    else {
	int num_to_read =
	    aag_current_buffer->aag_buf_size - number_to_move - 1;

	while (num_to_read <= 0) {	/* Not enough room in the buffer - grow it. */
#ifdef YY_USES_REJECT
	    YY_FATAL_ERROR
		("input buffer overflow, can't enlarge buffer because scanner uses REJECT");
#else

	    /* just a shorter name for the current buffer */
	    YY_BUFFER_STATE b = aag_current_buffer;

	    int aag_c_buf_p_offset = (int) (aag_c_buf_p - b->aag_ch_buf);

	    if (b->aag_is_our_buffer) {
		int new_size = b->aag_buf_size * 2;

		if (new_size <= 0)
		    b->aag_buf_size += b->aag_buf_size / 8;
		else
		    b->aag_buf_size *= 2;

		b->aag_ch_buf = (char *)
		    /* Include room in for 2 EOB chars. */
		    aag_flex_realloc((void *) b->aag_ch_buf,
				     b->aag_buf_size + 2);
	    } else
		/* Can't grow it, we don't own it. */
		b->aag_ch_buf = 0;

	    if (!b->aag_ch_buf)
		YY_FATAL_ERROR
		    ("fatal error - scanner input buffer overflow");

	    aag_c_buf_p = &b->aag_ch_buf[aag_c_buf_p_offset];

	    num_to_read = aag_current_buffer->aag_buf_size -
		number_to_move - 1;
#endif
	}

	if (num_to_read > YY_READ_BUF_SIZE)
	    num_to_read = YY_READ_BUF_SIZE;

	/* Read in more data. */
	YY_INPUT((&aag_current_buffer->aag_ch_buf[number_to_move]),
		 aag_n_chars, num_to_read);

	aag_current_buffer->aag_n_chars = aag_n_chars;
    }

    if (aag_n_chars == 0) {
	if (number_to_move == YY_MORE_ADJ) {
	    ret_val = EOB_ACT_END_OF_FILE;
	    aagrestart(aagin);
	}

	else {
	    ret_val = EOB_ACT_LAST_MATCH;
	    aag_current_buffer->aag_buffer_status = YY_BUFFER_EOF_PENDING;
	}
    }

    else
	ret_val = EOB_ACT_CONTINUE_SCAN;

    aag_n_chars += number_to_move;
    aag_current_buffer->aag_ch_buf[aag_n_chars] = YY_END_OF_BUFFER_CHAR;
    aag_current_buffer->aag_ch_buf[aag_n_chars + 1] =
	YY_END_OF_BUFFER_CHAR;

    aagtext_ptr = &aag_current_buffer->aag_ch_buf[0];

    return ret_val;
}


/* aag_get_previous_state - get the state just before the EOB char was reached */

static aag_state_type aag_get_previous_state()
{
    register aag_state_type aag_current_state;
    register char *aag_cp;

    aag_current_state = aag_start;

    for (aag_cp = aagtext_ptr + YY_MORE_ADJ; aag_cp < aag_c_buf_p;
	 ++aag_cp) {
	register YY_CHAR aag_c =
	    (*aag_cp ? aag_ec[YY_SC_TO_UI(*aag_cp)] : 1);
	if (aag_accept[aag_current_state]) {
	    aag_last_accepting_state = aag_current_state;
	    aag_last_accepting_cpos = aag_cp;
	}
	while (aag_chk[aag_base[aag_current_state] + aag_c] !=
	       aag_current_state) {
	    aag_current_state = (int) aag_def[aag_current_state];
	    if (aag_current_state >= 91)
		aag_c = aag_meta[(unsigned int) aag_c];
	}
	aag_current_state =
	    aag_nxt[aag_base[aag_current_state] + (unsigned int) aag_c];
    }

    return aag_current_state;
}


/* aag_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = aag_try_NUL_trans( current_state );
 */

#ifdef YY_USE_PROTOS
static aag_state_type aag_try_NUL_trans(aag_state_type aag_current_state)
#else
static aag_state_type aag_try_NUL_trans(aag_current_state)
aag_state_type aag_current_state;
#endif
{
    register int aag_is_jam;
    register char *aag_cp = aag_c_buf_p;

    register YY_CHAR aag_c = 1;
    if (aag_accept[aag_current_state]) {
	aag_last_accepting_state = aag_current_state;
	aag_last_accepting_cpos = aag_cp;
    }
    while (aag_chk[aag_base[aag_current_state] + aag_c] !=
	   aag_current_state) {
	aag_current_state = (int) aag_def[aag_current_state];
	if (aag_current_state >= 91)
	    aag_c = aag_meta[(unsigned int) aag_c];
    }
    aag_current_state =
	aag_nxt[aag_base[aag_current_state] + (unsigned int) aag_c];
    aag_is_jam = (aag_current_state == 90);

    return aag_is_jam ? 0 : aag_current_state;
}


#ifndef YY_NO_UNPUT
#ifdef YY_USE_PROTOS
static void aagunput(int c, register char *aag_bp)
#else
static void aagunput(c, aag_bp)
int c;
register char *aag_bp;
#endif
{
    register char *aag_cp = aag_c_buf_p;

    /* undo effects of setting up aagtext */
    *aag_cp = aag_hold_char;

    if (aag_cp < aag_current_buffer->aag_ch_buf + 2) {	/* need to shift things up to make room */
	/* +2 for EOB chars. */
	register int number_to_move = aag_n_chars + 2;
	register char *dest =
	    &aag_current_buffer->aag_ch_buf[aag_current_buffer->
					    aag_buf_size + 2];
	register char *source =
	    &aag_current_buffer->aag_ch_buf[number_to_move];

	while (source > aag_current_buffer->aag_ch_buf)
	    *--dest = *--source;

	aag_cp += (int) (dest - source);
	aag_bp += (int) (dest - source);
	aag_current_buffer->aag_n_chars =
	    aag_n_chars = aag_current_buffer->aag_buf_size;

	if (aag_cp < aag_current_buffer->aag_ch_buf + 2)
	    YY_FATAL_ERROR("flex scanner push-back overflow");
    }

    *--aag_cp = (char) c;


    aagtext_ptr = aag_bp;
    aag_hold_char = *aag_cp;
    aag_c_buf_p = aag_cp;
}
#endif				/* ifndef YY_NO_UNPUT */


#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int aaginput()
#else
static int input()
#endif
{
    int c;

    *aag_c_buf_p = aag_hold_char;

    if (*aag_c_buf_p == YY_END_OF_BUFFER_CHAR) {
	/* aag_c_buf_p now points to the character we want to return.
	 * If this occurs *before* the EOB characters, then it's a
	 * valid NUL; if not, then we've hit the end of the buffer.
	 */
	if (aag_c_buf_p < &aag_current_buffer->aag_ch_buf[aag_n_chars])
	    /* This was really a NUL. */
	    *aag_c_buf_p = '\0';

	else {			/* need more input */
	    int offset = aag_c_buf_p - aagtext_ptr;
	    ++aag_c_buf_p;

	    switch (aag_get_next_buffer()) {
	    case EOB_ACT_LAST_MATCH:
		/* This happens because aag_g_n_b()
		 * sees that we've accumulated a
		 * token and flags that we need to
		 * try matching the token before
		 * proceeding.  But for input(),
		 * there's no matching to consider.
		 * So convert the EOB_ACT_LAST_MATCH
		 * to EOB_ACT_END_OF_FILE.
		 */

		/* Reset buffer status. */
		aagrestart(aagin);

		/* fall through */

	    case EOB_ACT_END_OF_FILE:
		{
		    if (aagwrap())
			return EOF;

		    if (!aag_did_buffer_switch_on_eof)
			YY_NEW_FILE;
#ifdef __cplusplus
		    return aaginput();
#else
		    return input();
#endif
		}

	    case EOB_ACT_CONTINUE_SCAN:
		aag_c_buf_p = aagtext_ptr + offset;
		break;
	    }
	}
    }

    c = *(unsigned char *) aag_c_buf_p;	/* cast for 8-bit char's */
    *aag_c_buf_p = '\0';	/* preserve aagtext */
    aag_hold_char = *++aag_c_buf_p;


    return c;
}
#endif				/* YY_NO_INPUT */

#ifdef YY_USE_PROTOS
void aagrestart(FILE * input_file)
#else
void aagrestart(input_file)
FILE *input_file;
#endif
{
    if (!aag_current_buffer)
	aag_current_buffer = aag_create_buffer(aagin, YY_BUF_SIZE);

    aag_init_buffer(aag_current_buffer, input_file);
    aag_load_buffer_state();
}


#ifdef YY_USE_PROTOS
void aag_switch_to_buffer(YY_BUFFER_STATE new_buffer)
#else
void aag_switch_to_buffer(new_buffer)
YY_BUFFER_STATE new_buffer;
#endif
{
    if (aag_current_buffer == new_buffer)
	return;

    if (aag_current_buffer) {
	/* Flush out information for old buffer. */
	*aag_c_buf_p = aag_hold_char;
	aag_current_buffer->aag_buf_pos = aag_c_buf_p;
	aag_current_buffer->aag_n_chars = aag_n_chars;
    }

    aag_current_buffer = new_buffer;
    aag_load_buffer_state();

    /* We don't actually know whether we did this switch during
     * EOF (aagwrap()) processing, but the only time this flag
     * is looked at is after aagwrap() is called, so it's safe
     * to go ahead and always set it.
     */
    aag_did_buffer_switch_on_eof = 1;
}


#ifdef YY_USE_PROTOS
void aag_load_buffer_state(void)
#else
void aag_load_buffer_state()
#endif
{
    aag_n_chars = aag_current_buffer->aag_n_chars;
    aagtext_ptr = aag_c_buf_p = aag_current_buffer->aag_buf_pos;
    aagin = aag_current_buffer->aag_input_file;
    aag_hold_char = *aag_c_buf_p;
}


#ifdef YY_USE_PROTOS
YY_BUFFER_STATE aag_create_buffer(FILE * file, int size)
#else
YY_BUFFER_STATE aag_create_buffer(file, size)
FILE *file;
int size;
#endif
{
    YY_BUFFER_STATE b;

    b = (YY_BUFFER_STATE) aag_flex_alloc(sizeof(struct aag_buffer_state));
    if (!b)
	YY_FATAL_ERROR("out of dynamic memory in aag_create_buffer()");

    b->aag_buf_size = size;

    /* aag_ch_buf has to be 2 characters longer than the size given because
     * we need to put in 2 end-of-buffer characters.
     */
    b->aag_ch_buf = (char *) aag_flex_alloc(b->aag_buf_size + 2);
    if (!b->aag_ch_buf)
	YY_FATAL_ERROR("out of dynamic memory in aag_create_buffer()");

    b->aag_is_our_buffer = 1;

    aag_init_buffer(b, file);

    return b;
}


#ifdef YY_USE_PROTOS
void aag_delete_buffer(YY_BUFFER_STATE b)
#else
void aag_delete_buffer(b)
YY_BUFFER_STATE b;
#endif
{
    if (!b)
	return;

    if (b == aag_current_buffer)
	aag_current_buffer = (YY_BUFFER_STATE) 0;

    if (b->aag_is_our_buffer)
	aag_flex_free((void *) b->aag_ch_buf);

    aag_flex_free((void *) b);
}

#ifdef YY_USE_PROTOS
void aag_init_buffer(YY_BUFFER_STATE b, FILE * file)
#else
void aag_init_buffer(b, file)
YY_BUFFER_STATE b;
FILE *file;
#endif


{
    aag_flush_buffer(b);

    b->aag_input_file = file;
    b->aag_fill_buffer = 1;

#if YY_ALWAYS_INTERACTIVE
    b->aag_is_interactive = 1;
#else
#if YY_NEVER_INTERACTIVE
    b->aag_is_interactive = 0;
#else
    b->aag_is_interactive = file ? (isatty(fileno(file)) > 0) : 0;
#endif
#endif
}


#ifdef YY_USE_PROTOS
void aag_flush_buffer(YY_BUFFER_STATE b)
#else
void aag_flush_buffer(b)
YY_BUFFER_STATE b;
#endif

{
    if (!b)
	return;

    b->aag_n_chars = 0;

    /* We always need two end-of-buffer characters.  The first causes
     * a transition to the end-of-buffer state.  The second causes
     * a jam in that state.
     */
    b->aag_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
    b->aag_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

    b->aag_buf_pos = &b->aag_ch_buf[0];

    b->aag_at_bol = 1;
    b->aag_buffer_status = YY_BUFFER_NEW;

    if (b == aag_current_buffer)
	aag_load_buffer_state();
}


#ifndef YY_NO_SCAN_BUFFER
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE aag_scan_buffer(char *base, aag_size_t size)
#else
YY_BUFFER_STATE aag_scan_buffer(base, size)
char *base;
aag_size_t size;
#endif
{
    YY_BUFFER_STATE b;

    if (size < 2 ||
	base[size - 2] != YY_END_OF_BUFFER_CHAR ||
	base[size - 1] != YY_END_OF_BUFFER_CHAR)
	/* They forgot to leave room for the EOB's. */
	return 0;

    b = (YY_BUFFER_STATE) aag_flex_alloc(sizeof(struct aag_buffer_state));
    if (!b)
	YY_FATAL_ERROR("out of dynamic memory in aag_scan_buffer()");

    b->aag_buf_size = size - 2;	/* "- 2" to take care of EOB's */
    b->aag_buf_pos = b->aag_ch_buf = base;
    b->aag_is_our_buffer = 0;
    b->aag_input_file = 0;
    b->aag_n_chars = b->aag_buf_size;
    b->aag_is_interactive = 0;
    b->aag_at_bol = 1;
    b->aag_fill_buffer = 0;
    b->aag_buffer_status = YY_BUFFER_NEW;

    aag_switch_to_buffer(b);

    return b;
}
#endif


#ifndef YY_NO_SCAN_STRING
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE aag_scan_string(aagconst char *aag_str)
#else
YY_BUFFER_STATE aag_scan_string(aag_str)
aagconst char *aag_str;
#endif
{
    int len;
    for (len = 0; aag_str[len]; ++len);

    return aag_scan_bytes(aag_str, len);
}
#endif


#ifndef YY_NO_SCAN_BYTES
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE aag_scan_bytes(aagconst char *bytes, int len)
#else
YY_BUFFER_STATE aag_scan_bytes(bytes, len)
aagconst char *bytes;
int len;
#endif
{
    YY_BUFFER_STATE b;
    char *buf;
    aag_size_t n;
    int i;

    /* Get memory for full buffer, including space for trailing EOB's. */
    n = len + 2;
    buf = (char *) aag_flex_alloc(n);
    if (!buf)
	YY_FATAL_ERROR("out of dynamic memory in aag_scan_bytes()");

    for (i = 0; i < len; ++i)
	buf[i] = bytes[i];

    buf[len] = buf[len + 1] = YY_END_OF_BUFFER_CHAR;

    b = aag_scan_buffer(buf, n);
    if (!b)
	YY_FATAL_ERROR("bad buffer in aag_scan_bytes()");

    /* It's okay to grow etc. this buffer, and we should throw it
     * away when we're done.
     */
    b->aag_is_our_buffer = 1;

    return b;
}
#endif


#ifndef YY_NO_PUSH_STATE
#ifdef YY_USE_PROTOS
static void aag_push_state(int new_state)
#else
static void aag_push_state(new_state)
int new_state;
#endif
{
    if (aag_start_stack_ptr >= aag_start_stack_depth) {
	aag_size_t new_size;

	aag_start_stack_depth += YY_START_STACK_INCR;
	new_size = aag_start_stack_depth * sizeof(int);

	if (!aag_start_stack)
	    aag_start_stack = (int *) aag_flex_alloc(new_size);

	else
	    aag_start_stack = (int *) aag_flex_realloc((void *)
						       aag_start_stack,
						       new_size);

	if (!aag_start_stack)
	    YY_FATAL_ERROR
		("out of memory expanding start-condition stack");
    }

    aag_start_stack[aag_start_stack_ptr++] = YY_START;

    BEGIN(new_state);
}
#endif


#ifndef YY_NO_POP_STATE
static void aag_pop_state()
{
    if (--aag_start_stack_ptr < 0)
	YY_FATAL_ERROR("start-condition stack underflow");

    BEGIN(aag_start_stack[aag_start_stack_ptr]);
}
#endif


#ifndef YY_NO_TOP_STATE
static int aag_top_state()
{
    return aag_start_stack[aag_start_stack_ptr - 1];
}
#endif

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

#ifdef YY_USE_PROTOS
static void aag_fatal_error(aagconst char msg[])
#else
static void aag_fatal_error(msg)
char msg[];
#endif
{
    (void) fprintf(stderr, "%s\n", msg);
    exit(YY_EXIT_FAILURE);
}



/* Redefine aagless() so it works in section 3 code. */

#undef aagless
#define aagless(n) \
	do \
		{ \
		/* Undo effects of setting up aagtext. */ \
		aagtext[aagleng] = aag_hold_char; \
		aag_c_buf_p = aagtext + n; \
		aag_hold_char = *aag_c_buf_p; \
		*aag_c_buf_p = '\0'; \
		aagleng = n; \
		} \
	while ( 0 )


/* Internal utility routines. */

#ifndef aagtext_ptr
#ifdef YY_USE_PROTOS
static void aag_flex_strncpy(char *s1, aagconst char *s2, int n)
#else
static void aag_flex_strncpy(s1, s2, n)
char *s1;
aagconst char *s2;
int n;
#endif
{
    register int i;
    for (i = 0; i < n; ++i)
	s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
#ifdef YY_USE_PROTOS
static int aag_flex_strlen(aagconst char *s)
#else
static int aag_flex_strlen(s)
aagconst char *s;
#endif
{
    register int n;
    for (n = 0; s[n]; ++n);

    return n;
}
#endif


#ifdef YY_USE_PROTOS
static void *aag_flex_alloc(aag_size_t size)
#else
static void *aag_flex_alloc(size)
aag_size_t size;
#endif
{
    return (void *) malloc(size);
}

#ifdef YY_USE_PROTOS
static void *aag_flex_realloc(void *ptr, aag_size_t size)
#else
static void *aag_flex_realloc(ptr, size)
void *ptr;
aag_size_t size;
#endif
{
    /* The cast to (char *) in the following accommodates both
     * implementations that use char* generic pointers, and those
     * that use void* generic pointers.  It works with the latter
     * because both ANSI C and C++ allow castless assignment from
     * any pointer type to void*, and deal with argument conversions
     * as though doing an assignment.
     */
    return (void *) realloc((char *) ptr, size);
}

#ifdef YY_USE_PROTOS
static void aag_flex_free(void *ptr)
#else
static void aag_flex_free(ptr)
void *ptr;
#endif
{
    free(ptr);
}

#if YY_MAIN
int main()
{
    aaglex();
    return 0;
}
#endif
#line 139 "/home/ellson/graphviz/agraph/scan.l"

void aagerror(char *str)
{
    char buf[BUFSIZ];
    if (InputFile)
	sprintf(buf, "%s:%d: %s in line %d near '%s'", InputFile, line_num,
		str, line_num, aagtext);
    else
	sprintf(buf, " %s in line %d near '%s'", str, line_num, aagtext);
    agerror(AGERROR_SYNTAX, buf);
}

/* must be here to see flex's macro defns */
void aglexeof()
{
    unput(GRAPH_EOF_TOKEN);
}

#ifndef YY_CALL_ONLY_ARG
# define YY_CALL_ONLY_ARG void
#endif

int aagwrap(YY_CALL_ONLY_ARG)
{
    return 1;
}
