// -*- c++ -*-
// Generated by assa-genesis
//------------------------------------------------------------------------------
// $Id: Granule-main.cpp,v 1.14 2006/12/23 23:34:25 vlg Exp $
//------------------------------------------------------------------------------
//                            Granule-main.cpp
//------------------------------------------------------------------------------
//  Copyright (c) 2003-2006 by Vladislav Grinchenko
//
//  This program is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License   
//  as published by the Free Software Foundation; either version  
//  2 of the License, or (at your option) any later version.      
//------------------------------------------------------------------------------
//
// Date   : Wed Dec 31 23:18:34 2003
//
//------------------------------------------------------------------------------

static const char help_msg[]=
"                                                                            \n"
" NAME:                                                                      \n"
"                                                                            \n"
"   Granule - a flashcards program.                                          \n"
"                                                                            \n"
" DESCRIPTION:                                                               \n"
"                                                                            \n"
"   Granule is a flashcard program that implements Leither cardfile          \n"
"   methodology for learning new words. It features both short-term          \n"
"   and long-term memory training capabilities with scheduling.              \n"
"                                                                            \n"
" USAGE:                                                                     \n"
"                                                                            \n"
"   shell>  granule [OPTIONS]                                                \n"
"                                                                            \n"
" OPTIONS:                                                                   \n"
"                                                                            \n"
" -D, --log-file=NAME     - Write debug to NAME file                         \n"
" -z, --log-size=NUM      - Maximum size debug file can reach (dfl: is 10Mb) \n"
"                                                                            \n"
" --config-file=NAME      - Specify a fully-qualified path to the            \n"
"                           alternative configuration file.                  \n"
"                                                                            \n"
" -d, --log-stdout=YESNO  - Write debug to standard output                   \n"
"                                                                            \n"
" --with-log-server=YESNO - Redirect log messages to the log server          \n"
" --log-server=NAME       - Define assa-logd server address                  \n"
"                                                                            \n"
" -c, --log-level=NUM     - Log verbosity                                    \n"
" -m, --mask=MASK         - Mask (default: ALL = 0x7fffffff)                 \n"
"                                                                            \n"
"         0x00000002 - (GRAPP)    Log general program flow                   \n"
"         0x00000004 - (GUITRACE) Log every function entry/leave             \n"
"         0x00000008 - (DECK)     Log Deck-related operations                \n"
"         0x00000010 - (GEOM)     Log geometry changes                       \n"
"         0x02000000 - (KEYIN)    Log keyboard input activitiy               \n"
"                                                                            \n"
" --secs-in-day=NUM       - Number of seconds in a day (used for debugging)  \n"
" --secs-in-week=NUM      - Number of seconds in a week (used for debugging) \n"
" --dump-cardboxes=YESNO  - Dump content of each cardbox to a file,          \n"
"                           cardbox{1..5}.dat after every card movement.     \n"
"                                                                            \n"
" --gtk-options=OPTIONS   - A list of Gtk+ options to pass on. For example,  \n"
"                        o --g-fatal-warnings     - make all warnings fatal. \n"
"                        o --disable-crash-dialog - when application crashes \n"
"                                                   suppress GNOME crash     \n"
"                                                   dialog.                  \n"
"                                                                            \n"
" -h, --help              - Print this messag                                \n"
" -v, --version           - Print version number                             \n"
"                                                                            \n"
"                                                                           \n";
//------------------------------------------------------------------------------

#include "Granule-main.h"
#include "Granule.h"
#include "Intern.h"

#ifdef IS_HILDON
#    include <libosso.h>
#endif

#include <fstream>
using std::ofstream;

/*
#if defined (WIN32)

#include <windows.h>

struct HINSTANCE__;

int _stdcall
WinMain (struct HINSTANCE__ *hInstance,
		 struct HINSTANCE__ *hPrevInstance,
		 char *lpszCmdLine,
		 int   nCmdShow)
{
	WNDCLASS wc;
	
	wc.style=CS_HREDRAW | CS_VREDRAW;
	wc.lpfnWndProc=WindowProc;
	wc.cbClsExtra=0;
	wc.cbWndExtra=0;
	wc.hInstance=hInst;
	wc.hIcon=LoadIcon(NULL,IDI_WINLOGO);
	wc.hCursor=LoadCursor(NULL,IDC_ARROW);
	wc.hbrBackground=(HBRUSH)COLOR_WINDOWFRAME;
	wc.lpszMenuName="Granule";
	wc.lpszClassName="Granule";
	setlocale (LC_ALL, "");

	bindtextdomain (PACKAGE, LOCALEDIR);
	textdomain (PACKAGE);
	bind_textdomain_codeset(PACKAGE, "UTF-8");

    GRANULE->set_version (VERSION, 0); 
    GRANULE->set_author  ("Vladislav Grinchenko");
    GRANULE->set_flags   (ASSA::GenServer::RMLOG);

    GRANULE->init (&__argc, __argv, help_msg);
    GRANULE->init_service ();
    GRANULE->process_events ();

    return GRANULE->get_exit_value ();
}

#else

*/
/**-------------------------------------------------------------
 * POSIX
 */
int
main (int argc, char* argv[])
{
#ifdef IS_HILDON_EXTRA

	unlink ("/tmp/granule-env.dump");
	ofstream dump_env ("/tmp/granule-env.dump", std::ios::out);
	
	char* bus_address = getenv ("DBUS_SESSION_BUS_ADDRESS");
	if (bus_address != NULL) {
		dump_env  << "BUS_SESSION_BUS_ADDRESS = \"" 
				  << bus_address << "\"\n";
		std::cout << "BUS_SESSION_BUS_ADDRESS = \"" 
				  << bus_address << "\"" << std::endl;
	}
	else {
		dump_env  << "BUS_SESSION_BUS_ADDRESS = NULL!\n";
		setenv("DBUS_SESSION_BUS_ADDRESS",
			   "unix:path=/tmp/session_bus_socket-vlg", 1);
	}
	dump_env.close ();
#endif


#ifdef IS_HILDON
	/**
	 * Connect Granule to D-BUS session bus and system bus.
	 * If osso doesn't hear from us, it'll kill us right away.
	 */
	osso_context_t* osso_context; 
	osso_context = osso_initialize (PACKAGE, VERSION, TRUE, NULL );	
	if (osso_context == NULL) {
		std::cerr << "Failed to initalize osso context!\n";
		exit (1);
	}
#endif

	/** 
	 * Initialize the locale as specified in the environment.
	 * (e.g., the user sets LANG=fr_FR in the environment to
	 * get French messages.
	 */
	setlocale (LC_ALL, "");

	/**
	 * Tell Gettext where to find message catalogs for this message.
	 */

#if defined (WIN32)
	bindtextdomain (PACKAGE, "../share/locale");
#else /* POSIX */
	bindtextdomain (PACKAGE, LOCALEDIR);
#endif

	textdomain (PACKAGE);
	bind_textdomain_codeset(PACKAGE, "UTF-8");

    GRANULE->set_version ("1.2.1", 0); 
    GRANULE->set_author  ("Vladislav Grinchenko");
    GRANULE->set_flags   (ASSA::GenServer::RMLOG);

    GRANULE->init (&argc, argv, help_msg);
    GRANULE->init_service ();
    GRANULE->process_events ();

#ifdef IS_HILDON
	if (osso_context != NULL) {
		osso_deinitialize (osso_context);	 /* disconnect from the session */
	}
#endif

    return GRANULE->get_exit_value ();
}

//#endif /* ifdef Win32 */
