/*
 * GQview
 * (C) 2001 John Ellis
 *
 * Author: John Ellis
 *
 * This software is released under the GNU General Public License (GNU GPL).
 * Please read the included file COPYING for more information.
 * This software comes with no warranty of any kind, use at your own risk!
 */


#ifndef FULLSCREEN_H
#define FULLSCREEN_H

#define FULL_SCREEN_HIDE_MOUSE_DELAY 3000
#define BLACK_BACKGROUND 1


typedef struct _FullScreenData FullScreenData;
struct _FullScreenData
{
	GtkWidget *window;
	ImageWindow *imd;

	GtkWidget *normal_window;
	ImageWindow *normal_imd;

	gint hide_mouse_id;

	void (*stop_func)(FullScreenData *, gpointer);
	gpointer stop_data;
};


FullScreenData *fullscreen_start(GtkWidget *window, ImageWindow *imd,
				 void (*stop_func)(FullScreenData *, gpointer), gpointer stop_data);
void fullscreen_stop(FullScreenData *fs);


#endif

