/*
 * GQview
 * (C) 2001 John Ellis
 *
 * Author: John Ellis
 *
 * This software is released under the GNU General Public License (GNU GPL).
 * Please read the included file COPYING for more information.
 * This software comes with no warranty of any kind, use at your own risk!
 */


#ifndef FILELIST_H
#define FILELIST_H


void update_status_label(const gchar *text);

gint file_is_hidden(const gchar *name);
gint file_is_in_filter(const gchar *name);

GList *path_list_filter(GList *list, gint is_dir_list);

void rebuild_file_filter(void);

GList *path_list_sort(GList *list);
GList *path_list_recursive(const gchar *path);

gchar *text_from_size(int size);
const gchar *text_from_time(time_t t);

gint find_file_in_list(const gchar *path);
GList *file_get_complete_list(void);
GList *file_get_selected_list(void);
gint file_clicked_is_selected(void);
gchar *file_clicked_get_path(void);
gint file_count(void);
gint file_selection_count(void);
gchar *file_get_path(gint row);
gint file_is_selected(gint row);
void file_image_change_to(gint row);

void file_select_all(void);
void file_unselect_all(void);

void file_is_gone(const gchar *path, GList *ignore_list);
void file_is_renamed(const gchar *source, const gchar *dest);
void file_is_moved(const gchar *source, const gchar *dest, GList *ignore_list);

gchar *dir_get_path(gint row);

void dir_select_cb(GtkWidget *widget, gint row, gint col,
		   GdkEvent *event, gpointer data);
void dir_press_cb(GtkWidget *widget, GdkEventButton *bevent, gpointer data);
void file_press_cb(GtkWidget *widget, GdkEventButton *bevent, gpointer data);
void file_select_cb(GtkWidget *widget, gint row, gint col,
		   GdkEvent *event, gpointer data);
void file_unselect_cb(GtkWidget *widget, gint row, gint col,
		   GdkEvent *event, gpointer data);
void dir_clist_set_highlight(gint set);
void file_clist_highlight_set(void);
void file_clist_highlight_unset(void);

void path_entry_changed_cb(GtkWidget *widget, gpointer data);
void path_entry_tab_cb(const gchar *newpath, gpointer data);
void path_entry_cb(const gchar *newdir, gpointer data);

void interrupt_thumbs(void);
void filelist_populate_clist(void);
void filelist_refresh(void);
void filelist_change_to(const gchar *path);
void filelist_change_to_full_path(const gchar *path);
void filelist_set_sort_method(SortType method, gint force);


#endif

