#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <stdio.h>

#ifdef HAVE_TERMIOS_H
#  include <termios.h>
#endif

#include "app.h"

using namespace std;

#define _(str) str // TODO: gettextize

namespace GQLShell
{

string App::simple_prompt(const std::string& prompt, bool echo)
{
  string result;
  FILE *termin, *termout;
  int c;

#ifdef HAVE_TERMIOS_H
  struct termios t_orig, t;
#endif
        

  /*
   * Do not try to collapse these into one "w+" mode file. Doesn't work
   * on some platforms (eg, HPUX 10.20).
   */
  termin = fopen("/dev/tty", "r");
  termout = fopen("/dev/tty", "w");
  if (!termin || !termout)
  {
    if (termin)
      fclose(termin);
    if (termout)
      fclose(termout);
    termin = stdin;
    termout = stderr;
  }

#ifdef HAVE_TERMIOS_H
  if (!echo)
  {
    tcgetattr(fileno(termin), &t);
    t_orig = t;
    t.c_lflag &= ~ECHO;
    tcsetattr(fileno(termin), TCSAFLUSH, &t);
  }
#endif

  if (!prompt.empty())
  {
    fputs(_(prompt.c_str()), termout);
    fflush(termout);
  }

  while ((c = fgetc(termin)) != '\n' && c != EOF)
    result += c;
    
#ifdef HAVE_TERMIOS_H
  if (!echo)
  {
    tcsetattr(fileno(termin), TCSAFLUSH, &t_orig);
    fputs("\n", termout);
    fflush(termout);
  }
#endif

  if (termin != stdin)
  {
    fclose(termin);
    fclose(termout);
  }
  
  return result;
}

}
