/* This is for emacs: -*-Mode: C++;-*- */
#if !defined(__INC_SQLite_STATEMENT_H)
#define __INC_SQLite_STATEMENT_H

#include "gql++/statement.h"
#include "gql++/mod-result-set.h"

#include "connection.h"

namespace GQL
{

namespace SQLite
{

class SQLiteStatement : public Statement
{
  public:
    SQLiteStatement(SQLiteConnection *conn) : Statement(conn) {
      result_set_ = 0;
      fetch_direction_ = fetch_size_ = 0;
      max_field_size_ = max_rows_ = 0;
    }
    virtual ~SQLiteStatement();
    
    virtual bool execute(const std::string& sql);

    virtual ResultSet *execute_query(const std::string& sql);
    virtual int execute_update(const std::string& sql);

    virtual ResultSet *get_result_set() { return result_set_; }
    virtual int get_update_count() const { return update_count_; }
    virtual bool get_more_results() { return false; }
    
    virtual int get_fetch_direction() const { return fetch_direction_; }
    virtual void set_fetch_direction(int direction) {
      fetch_direction_ = direction;
    }
    virtual int get_fetch_size() const { return fetch_size_; }
    virtual void set_fetch_size(int size) { fetch_size_ = size; }

    virtual int get_max_field_size() const { return max_field_size_; }
    virtual void set_max_field_size(int size) {
      max_field_size_ = size;
    }
    
    virtual int get_max_rows() const { return max_rows_; }
    virtual void set_max_rows(int rows) { max_rows_ = rows; }
  private:
    int fetch_direction_, fetch_size_;
    int max_field_size_, max_rows_;

    ResultSet *result_set_;
    int update_count_;
};


}
}

#endif
