#include "gql++/result-set.h"
#include "gql++/object.h"

#include "connection.h"
#include "result-set-metadata.h"

namespace GQL
{
  
namespace PG
{

PGResultSetMetaData::PGResultSetMetaData(Connection *conn, PGresult *result)
{
  conn_ = conn;
  result_ = result;
  column_types_ = new SQLType[column_count()];
}

PGResultSetMetaData::~PGResultSetMetaData()
{
  delete[] column_types_;
}

int PGResultSetMetaData::column_count()
{
  return(result_ ? PQnfields(result_) : 0);
}

string PGResultSetMetaData::get_column_label(int i)
{
  string result = result_ && i >= 0 && i < column_count() ?
    PQfname(result_, i) : string();

  return(result);
}

string PGResultSetMetaData::get_column_name(int i)
{
  string result = result_ && i >= 0 && i < column_count() ?
    PQfname(result_, i) : string();

  return(result);
}

#include "type_table.cc"

const SQLType& PGResultSetMetaData::get_column_type(int i)
{
  if (conn_ && result_ && column_types_ && i >= 0 && i < column_count())
  {
    if (column_types_[i].typecode() == SQLType::VOID)
    {
      string type_name;
      char oid_string[64];
      Oid type_oid;
      SQLObject *obj = conn_->create_object();
      SQLType *the_type = &column_types_[i];
      ResultSet *rs;
      PGConnection *pg_conn = dynamic_cast<PGConnection *>(conn_);

      if (!pg_conn)
        throw(runtime_error("unable to cast a Connection to a PGConnection"));
      
      type_oid = PQftype(result_, i);
      sprintf(oid_string, "%i", type_oid);
      rs = pg_conn->exec_sql(string("SELECT typname FROM pg_type "
                                    "  WHERE oid = ") + oid_string);

      while (rs->next())
        rs->get(0, obj);

      type_name = obj->to_string();
      
      // rs->get(1, obj); len = obj->to_int();
      
      Type *type = lookup_type(type_name.c_str(), type_name.length());

      if (type)
      {
        switch (type->typecode)
        {
          case SQLType::CHARACTER_VARYING:
          case SQLType::CHARACTER:
            *the_type = SQLType(type->typecode, PQfsize(result_, i));
            break;
          case SQLType::DECIMAL:
            break;
          case SQLType::FLOAT:
            *the_type = SQLType(SQLType::FLOAT, 
				PQfsize(result_, i) == 8 ? 15 : 6);
            break;
          case SQLType::NUMERIC:
            *the_type = SQLType(SQLType::NUMERIC, 9, 0);
            break;
	default:
            *the_type = SQLType(type->typecode);
            break;
	}
      }

      delete rs;
      delete obj;
    }
    return(column_types_[i]);
  }
  
  throw SQLException("invalid call to PGResultSetMetaData::get_column_type");
}

}

}
