#include "config.h"

#include "driver.h"
#include "connection.h"
#include "gql++/exception.h"

namespace GQL
{

namespace PG
{

PGDriver::PGDriver(uC::PluginManager *mgr) : Driver(mgr, "pg", "PostgreSQL")
{
  set_version(0, 0);
};

bool PGDriver::accept_url(const string& url) const
{
  return(parse_url(url).size() > 0);
}

Connection *PGDriver::connect(const string& url,
                              const map<string, string>& info)
{
  props_ = parse_url(url, info);

  if (props_.size() == 0)
    return(0);

  return(new PGConnection(host(), port(), props_, database(), url, this));
}

vector<DriverPropertyInfo> PGDriver::get_property_info(
        const string& url,
        const map<string, string>& props) const
{
  vector<DriverPropertyInfo> prop_info;

  return(prop_info);
}
                                               
map<string, string> PGDriver::parse_url(
        const string& url,
        const map<string, string>& defaults) const
{
  map<string, string> url_props(defaults);
  string::size_type pos = 0, new_pos;
  int state = 0;
  bool ok = false, done = false;
  
  for (;;)
  {
    new_pos = url.find_first_of(":/;=&?", pos);

    switch (state)
    {
      case 0:
        // First Part must be 'gql:'
        if (url[new_pos] != ':' ||
            url.substr(pos, new_pos - pos) != "gql")
          done = true;
        state++;
        break;
      case 1:
        // Then we need 'pg:'
        if (url[new_pos] != ':' ||
            url.substr(pos, new_pos - pos) != get_id())
          done = true;
        state++;
        break;
      case 2:
        // Then we may either have the dbname or a '//' 
        if (new_pos == string::npos)
        {
          url_props["PGDBNAME"] = url.substr(pos, new_pos - pos);
          done = true;
          ok = true;
        }
        else if (url.substr(new_pos, 2) == "//")
	{
	  new_pos++;
          state++;
	}
        else
          done = true;
        break;
      case 3:
        // Wen need 'host/database' or 'host:port'
        if (url[new_pos] == '/')
          state += 2; // Jump over port
        else if (url[new_pos] == ':')
          state++;
        else
          done = true;
        
        url_props["PGHOST"] = url.substr(pos, new_pos - pos);
        break;
      case 4:
        if (url[new_pos] == '/')
          url_props["PGPORT"] = url.substr(pos, new_pos - pos);
        else
          done = true;
        break;
      case 5:
        if (new_pos == string::npos)
        {
          url_props["PGDBNAME"] = url.substr(pos, new_pos - pos);
          ok = true;
        }
        done = true;
        break;
      default:
        done = true;
    }
    
    if (done)
      break;

    pos = new_pos + 1;
  }
  
  if (!ok)
    url_props.erase(url_props.begin(), url_props.end());
  
  return(url_props);
}

static string empty_string;

const string& PGDriver::host() const
{
  map<string, string>::const_iterator i = props_.find("PGHOST");
  
  if (i == props_.end())
    return(empty_string);
  else
    return((*i).second);
}

const string& PGDriver::port() const
{
  map<string, string>::const_iterator i = props_.find("PGPORT");
  
  if (i == props_.end())
    return(empty_string);
  else
    return((*i).second);
}

const string& PGDriver::database() const
{
  map<string, string>::const_iterator i = props_.find("PGDBNAME");
  
  if (i == props_.end())
    return(empty_string);
  else
    return((*i).second);
}

extern "C" uC::Plugin *ucxx_pg_plugin_init(uC::PluginManager *mgr)
{
  Driver *driver = new PGDriver(mgr);

  manage(driver);

  return(driver);
}


}
}

