#include <stdio.h>

#include "result-set-metadata.h"

namespace GQL
{
  
namespace MySQL
{

MyResultSetMetaData::MyResultSetMetaData(Connection *conn, MYSQL_RES *result)
{
  conn_ = conn;
  result_ = result;
  fields_ = result_ ? mysql_fetch_fields(result_) : 0;
  column_types_ = new SQLType[column_count()];
}

int MyResultSetMetaData::column_count()
{
  return(result_ ? mysql_num_fields(result_) : 0);
}

string MyResultSetMetaData::get_column_label(int i)
{
  return(fields_ && i >= 0 && i < column_count() ? fields_[i].name : string());
}

string MyResultSetMetaData::get_column_name(int i)
{
  return(get_column_label(i));
}

SQLType& MyResultSetMetaData::get_column_type(int i)
{
  if (fields_ && i >= 0 && i < column_count())
  {
    if (column_types_[i].typecode() == SQLType::VOID)
    {
      SQLType *the_type = &column_types_[i];
      
      switch (fields_[i].type)
      {
        case FIELD_TYPE_DECIMAL:
          *the_type = SQLType(SQLType::DECIMAL,
			      fields_[i].length, fields_[i].decimals);
          break;
        case FIELD_TYPE_SHORT:
        case FIELD_TYPE_TINY:
          *the_type = SQLType(SQLType::SMALLINT);
          break;
        case FIELD_TYPE_LONG:
          *the_type = SQLType(SQLType::INTEGER);
          break;
        case FIELD_TYPE_LONGLONG:
          *the_type = SQLType(SQLType::DECIMAL, 19, 0);
          break;
        case FIELD_TYPE_INT24:
          *the_type = SQLType(SQLType::DECIMAL, 7, 0);
          break;
        case FIELD_TYPE_FLOAT:
          *the_type = SQLType(SQLType::FLOAT, 6);
          break;
        case FIELD_TYPE_DOUBLE:
          *the_type = SQLType(SQLType::FLOAT, 15);
          break;
        case FIELD_TYPE_TIMESTAMP:
          *the_type = SQLType(SQLType::TIMESTAMP_WITH_TZ);
          break;
        case FIELD_TYPE_DATE:
          *the_type = SQLType(SQLType::DATE);
          break;
        case FIELD_TYPE_TIME:
          *the_type = SQLType(SQLType::TIME);
          break;
        case FIELD_TYPE_DATETIME:
        case FIELD_TYPE_YEAR:
        case FIELD_TYPE_NEWDATE:
        case FIELD_TYPE_ENUM:
        case FIELD_TYPE_SET:
        case FIELD_TYPE_TINY_BLOB:
        case FIELD_TYPE_MEDIUM_BLOB:
        case FIELD_TYPE_LONG_BLOB:
        case FIELD_TYPE_BLOB:
        case FIELD_TYPE_VAR_STRING:
        case FIELD_TYPE_STRING:
        case FIELD_TYPE_NULL:
          // XXX What's that???
          *the_type = SQLType(); // void
          break;
      }
    }
   }

  return(column_types_[i]);
}


}

}
