/* This is for emacs: -*-Mode: C++;-*- */
#if !defined(__INC_PG_CONNECTION_H)
#define __INC_PG_CONNECTION_H


#include "driver.h"

#include <mysql/mysql.h>

#include "gql++/connection.h"

namespace GQL
{

class ResultSet;

namespace MySQL
{

class MyDatabaseMetaData;

class MyConnection : public Connection
{
  public:
    MyConnection(const string& host,
                 const string& port,
                 const map<string, string>& props,
                 const string& db,
                 const string& url,
                 MyDriver *driver);
    virtual ~MyConnection();

    // Methods inherited from Connection
    virtual Statement *create_statement();
    virtual PreparedStatement *prepare_statement(const string& sql);
    virtual CallableStatement *prepare_call(const string& sql);

    virtual void close();
    virtual bool is_closed() const { return(conn_ == 0); }

    virtual void commit();
    virtual bool get_auto_commit() const { return(auto_commit_); }
    virtual void set_auto_commit(bool auto_commit = true);
    virtual void rollback();
    virtual string get_catalog() const;
    
    virtual string native_sql(const string& sql) const;
    
    virtual DatabaseMetaData *get_meta_data();

    virtual void set_read_only(bool read_only = true) {
      read_only_ = read_only;
    }
    virtual bool is_read_only() const {
      return(read_only_);
    }

    // Additional methods
    ResultSet *exec_sql(const string& sql);
    MYSQL *mysql_connection() { return(conn_); }
    
#if defined(GQL_THREADS)
    static void global_lock() { global_mutex_.lock(); }
    static void global_unlock() { global_mutex_.unlock(); }
    void lock() { conn_mutex_.lock(); }
    void unlock() { conn_mutex_.unlock(); }
#else
    void global_lock() { }
    void global_unlock() { }
    void lock() { }
    void unlock() { }
#endif
  private:
#if defined(GQL_THREADS)
    SigC::Threads::Mutex conn_mutex_;
    static SigC::Threads::Mutex global_mutex_;
#endif
    MyDriver *driver_;
    MYSQL *conn_;
    string url_;
    string database_;
    string port_;
    string host_;
    bool read_only_;
    bool auto_commit_;
    MyDatabaseMetaData *metadata_;
};


}
}

#endif
