/* This is for emacs: -*-Mode: C++;-*- */
#if !defined(__INC_GDBI_TABLE_H)
#define __INC_GDBI_TABLE_H

#include <gql++/connection.h>
#include <gql++/result-set.h>
#include <gql++/result-set-metadata.h>

#include <uc++/error-handler.h>

#include <gdbi++/connection.h>

namespace gdbi
{

class DataSet;

class Table : public uC::ErrorHandler
{
    friend class Connection;
  public:
    class Column : public SigC::Object
    {
        friend class Table;
      private:
        GQL::ResultSetMetaData *metadata_;
        Table *table_;
        Property *type_; 
        int index_;
      public:
        ~Column() { if (type_) delete type_; }
        std::string name() {
          return(metadata_ ? metadata_->get_column_name(index_) : 
                 std::string());
        }
        const Property *type();
      private:
        Column(Table *table, GQL::ResultSetMetaData *metadata, int i)
            : metadata_(metadata), index_(i) {
          if (metadata_ && (i < 0 || i >= metadata_->column_count()))
              metadata_ = 0;
          type_ = 0;
          table_ = table;
        }
    };
    
    Table(const std::string& name);
    virtual ~Table();
    
    const std::string& name() const { return(name_); }
    const std::vector<Column *>& columns() const { return(columns_); }

    Connection *connection() { return(dynamic_cast<Connection *>(parent())); }
    
    DataSet *get_data();
  protected:
    /** Instanciate a table corresponding to the table \c name in \c
        conn. */
    Table(GQL::Connection *conn, const std::string& name);

    /// Insert this table into the connection (that is, create it)
    void do_insert_into(GQL::Connection *conn);

    void do_drop();
  private:
    std::string name_;
    GQL::Connection *conn_;
    std::vector<Column *> columns_;
    GQL::ResultSet *empty_table_;
    GQL::ResultSetMetaData *metadata_;
};

}

#endif
