#include "gql++/database-metadata.h"
#include "gql++/result-set.h"
#include "gql++/result-set-metadata.h"
#include "gql++/object.h"
#include "gql++/statement.h"
#include "gql++/exception.h"

#include "gdbi++/dataset.h"
#include "gdbi++/connection.h"
#include "gdbi++/table.h"

namespace gdbi
{

using namespace std;

Table::Table(const string& name)
{
  name_ = name;
  conn_ = 0;
  metadata_ = 0;
  empty_table_ = 0;
}

Table::Table(GQL::Connection *conn, const string& name)
{
  name_ = name;
  conn_ = conn;
  metadata_ = 0;
  empty_table_ = 0;

  if (conn_)
  {
    try
    {
      GQL::Statement *stmt = conn_->create_statement();

      empty_table_ = stmt->execute_query("SELECT * FROM " +
                                         name_ + " WHERE 1 = 0");
      metadata_= empty_table_->get_meta_data();
      for (int i = 0; i < metadata_->column_count(); i++)
        columns_.push_back(new Column(this, metadata_, i));
    }
    catch (GQL::SQLException& e)
    {
      error(e.get_message());
    }
  }
}

Table::~Table()
{
  for (vector<Column *>::size_type i = 0; i < columns_.size(); i++)
    delete columns_[i];

  delete empty_table_;
  delete metadata_;
}

DataSet *Table::get_data()
{
  if (conn_)
  {
    try
    {
      GQL::ResultSet *rs;
      GQL::Statement *stmt = conn_->create_statement();

      rs = stmt->execute_query("SELECT * FROM " + name_);
      delete stmt;
      
      return(new DataSet(rs, this));
    }
    catch (GQL::SQLException& e)
    {
      error(e.get_message());
    }
  }
  return(0);
}

void Table::do_drop()
{
  if (!conn_)
    return;
  
  try
  {
    GQL::Statement *stmt = conn_->create_statement();
    stmt->execute("DROP TABLE " + name_);
    delete stmt;
  }
  catch (GQL::SQLException& e)
  {
    emit_error(e.get_message());
  }
}

void Table::do_insert_into(GQL::Connection *conn)
{
  if (conn_) return;

#if 0
  conn_ = conn;

  string query = "CREATE TABLE (";
  vector<Column *>::iterator it;
  
  for (it = columns_.begin(); it != columns_.end(); ++it)
  {
    if (it != columns_.begin())
      query.append(", ");
    
    query.append((*it)->name());
    query.append(" ");
    query.append((*it)->type()->to_string());
  }
  query.append(")");

  cout << query << endl;
#endif
}

const Property *Table::Column::type()
{
  using namespace GQL;
  
  if (type_)
    return type_;
  
  SQLType gql_type = metadata_ ? metadata_->get_column_type(index_) : 
    SQLType(SQLType::VOID);

  switch (gql_type.typecode())
  {
    case SQLType::BOOLEAN:
      type_ = new Property(table_->connection()->type_schema("bool"));
      break;
    case SQLType::DATE:
      type_ = new Property(table_->connection()->type_schema("date"));
      break;
    case SQLType::INTEGER:
    case SQLType::SMALLINT:
    case SQLType::NUMERIC:
    case SQLType::FLOAT:
      type_ = new Property(table_->connection()->type_schema("number"));
      break;
    case SQLType::CHARACTER:
    case SQLType::CHARACTER_VARYING:
      type_ = new Property(table_->connection()->type_schema("string"));
      break;
    default:
      type_ = new Property(table_->connection()->type_schema("unknown"));
      break;
  }
  
  return(type_);
}

}
