#include <unistd.h>

#include <sigc++/thread_tunnel.h>

#include "gdbi++/session.h"
#include "gdbi++/connection.h"

namespace gdbi
{

using namespace std;

class SessionThread : public SigC::Threads::Thread,
                      public SigC::StandardDispatcher
{
  public:
    virtual void *main(void *arg) {
      run();
      return(0);
    }
};

Session::Session(uC::PluginManager *pm, const string& root,
                 SigC::Tunnel *tunnel, bool mt) : dm_(pm, root)
{
  mt_ = mt;
  
  if (tunnel && mt_)
  {
    // Requests are handled in seperate thread, signals in main thread
    SessionThread *thread = new SessionThread;
    requests_ = new SigC::ThreadTunnel(thread);
    signals_ = tunnel;
    thread->start();
  }
  else if (tunnel)
  {
    // All things are handled in main thread, but use tunnels
    requests_ = tunnel;
    signals_ = 0;
  }
  else
  {
    requests_ = signals_ = 0;
  }
}

Session::~Session()
{
  for (vector<Connection *>::size_type i = 0; i < connections_.size(); i++)
    delete connections_[i].connection;
}

void Session::do_open_connection(string url, string user, string passwd)
{
  Connection *conn;
  GQL::Connection *gql_conn;
  
  try
  {
    gql_conn = dm_.get_connection(url, user, passwd);
  }
  catch (GQL::SQLException& e)
  {
    SigC::pack(slot(this, &Session::do_emit_error),
               string(e.get_message()))->tunnel(signals_);
    return;
  }
  
  conn = new Connection(this, gql_conn, mt_ ? signals_ : requests_, mt_);
  Session::ConnectionInfo info = { url, conn };
  connections_.push_back(info);

  int i = connections_.size() - 1;
  conn->destroy.connect(bind(slot(this, &Session::do_close_connection), conn));
  
  // This is just to test MT
  sleep(1);
  
  SigC::pack(connection_opened.slot(), i)->tunnel(signals_);
};

void Session::do_close_connection(Connection *conn)
{
  for (ConnectionList::size_type i = 0; i < connections_.size(); i++)
    if (connections_[i].connection == conn)
    {
      SigC::pack(connection_closed.slot(), (int)i)->tunnel(signals_);
      connections_.erase(connections_.begin() + i);
      return;
    }
}


}
