#include "gdbi++/dataset.h"

namespace gdbi
{

using namespace std;

DataSet::DataSet()
{
  columns_ = 0;
  result_set_ = 0;
  rsmd_ = 0;
  table_ = 0;
  colno_ = 0;
  conn_ = 0;
}

DataSet::DataSet(GQL::ResultSet *rs, Table *table)
{
  result_set_ = rs;
  rsmd_ = table ? 0 : rs->get_meta_data();
  colno_ = table ? table->columns().size() : rsmd_->column_count();
  rs_empty_ = false;
  table_ = table;
  conn_ = rs->get_connection();
}

DataSet::~DataSet()
{
  if (columns_)
    delete columns_;
}

const vector<Table::Column *>& DataSet::columns()
{
  if (!columns_)
  {
    if (!table_)
      throw "Sorry, unimplemented feature";
  }
  
  return(table_->columns());
}

GQL::SQLObject *DataSet::get_object(int row, int col)
{
  if (row < 0 || (row >= (int)rows_.size() && rs_empty_) ||
      col < 0 || col >= colno_)
  {
    error("Attempt to access invalid field in DataSet");
    return(0);
  }
  
  while (row >= (int)rows_.size())
  {
    if (!result_set_->next())
    {
      error("Attempt to access invalid row in DataSet");
      return(0);
    }
    GQL::SQLObject **row = new GQL::SQLObject*[colno_];
    for (int i = 0; i < colno_; i++)
    {
      row[i] = conn_->create_object();
      result_set_->get(i, row[i]);
    }
    rows_.push_back(row);
  }
  
  return(rows_[row][col]);
}

int DataSet::rows()
{
  while (result_set_->next())
  {
    GQL::SQLObject **row = new GQL::SQLObject*[colno_];
    for (int i = 0; i < colno_; i++)
    {
      row[i] = conn_->create_object();
      result_set_->get(i, row[i]);
    }
    rows_.push_back(row);
  }
  return(rows_.size());
}

}

