/*
    GQ -- a GTK-based LDAP client
    Copyright (C) 1998-2001 Bert Vermeulen

    This program is released under the Gnu General Public License with
    the additional exemption that compiling, linking, and/or using
    OpenSSL is allowed.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#define MAX_SUFFIX_LEN   256

enum entry_status {
     STATUS_UNKNOWN	= 0x00,
     HAS_SUFFIXES	= 0x01,
     HAS_NO_SUFFIXES	= 0x02,
     IS_SERVER 		= 0x03,
     HAS_CHILDREN	= 0x10,
     HAS_NO_CHILDREN	= 0x20
};

struct node_entry {
     enum entry_status status;
     char *dn;
     /* cache values here */
};



void new_browsemode(GHashTable *hash);
int browse_idle_scroll(gpointer data);
void add_all_servers(GNode *root);
void gnode_to_tree(GHashTable *hash, GNode * node, GtkCTreeNode *ctree_node);
gboolean gnode_to_tree_callback(GHashTable *hash, GNode *node, gpointer ctree_node);
void remove_server_node_tree(struct ldapserver *server);

void attach_children_to_node(GHashTable *hash, GtkCTreeNode *item);
void attach_children_to_tree(GHashTable *hash, GtkCTreeNode *item);
void attach_server_suffixes(GHashTable *hash, GtkCTreeNode *item);
void descend_onelevel(GNode *node);

void tree_row_selected(GtkCTree *tree, GList *ctree_node, gint column, GHashTable *hash);
void tree_row_expanded(GtkCTree * tree, GList * ctree_node, GHashTable *hash);
void _gtk_ctree_toggle_is_leaf(GtkCTree * tree, GtkCTreeNode * node);
gboolean button_press_on_tree_item(GtkWidget *tree, GdkEventButton *event, GHashTable *hash);
void refresh_server(GtkWidget *widget, GHashTable *hash);
void refresh_subtree(GtkWidget *widget, GHashTable *hash);
void delete_browse_entry(GtkWidget *widget, GHashTable *hash);
void do_recursive_delete (LDAP* ld, char* dn);
void delete_non_leaf(GtkWidget *button, GNode *node);
void delete_browse_warning_popup(GNode *);

void server_item_selected(GHashTable *hash, GtkCTreeNode *tree_item);

struct ldapserver *server_by_node(GNode *node);
char *dn_by_node(GNode *node);
struct node_entry *new_node_entry(char *dn);

GSList *get_suffix(struct ldapserver *server);

void cleanup_browse_mode(GHashTable *hash);
gboolean node_entry_free_callback(GNode *node, gpointer dummy);
void node_entry_destroy(GNode *node, gpointer dummy);

void dump_subtree(GtkWidget *widget, GHashTable *hash);
void dump_subtree_ok_callback(GtkWidget *button, GtkWidget *filesel);
void dump_subtree_filesel_destroy(GtkWidget *button, GtkWidget *filesel);
void add_dn_to_gslist(GNode *node, gpointer *bases);
void browse_new_from_entry_callback(GtkWidget *widget, gpointer data);
void browse_new_from_template_callback(GtkWidget *widget, gpointer data);
void browse_edit_from_entry(GHashTable *hash, GNode *node, GtkCTreeNode *ctree_node);
