#ifndef _PROBLEM_ANALIZER_H
#define _PROBLEM_ANALIZER_H
#include "tabchild.h"
#include "gpsshogi/gui/board.h"
#include <boost/scoped_array.hpp>
#if QT_VERSION < 0x040000
#define Q3ListView QListView
#endif

class AnalysisViewer;
class QPushButton;
class Q3ListView;
class QTextBrowser;
class QContextMenuEvent;

class ProblemAnalyzer : public TabChild
{
Q_OBJECT
public:
  ProblemAnalyzer(QWidget *parent = 0, const char *name = 0);
  void forward();
  void backward();
  void toInitialState();
  void toLastState();
  int moveCount() const;
  osl::Player turn() const;
  const osl::state::SimpleState& getState();
  void toggleOrientation();
  osl::state::SimpleState getStateAndMovesToCurrent(osl::stl::vector<osl::Move> &moves);

  void contextMenuEvent(QContextMenuEvent *);
  bool analyze();
  QString getFilename();
  QWidget *moveGenerateDialog();
signals:
  void statusChanged();
private slots:
  bool analyzeOne();
  void next();
  void prev();
  void showProblem();
  void resetSearchParameters();
  void chooseProblem();
  void viewResult();
  void saveResult();
  void analyzeAll();
private:
  enum problem_result
  {
    NOT_TRIED,
    SUCCESS,
    FAILURE
  };
  gpsshogi::gui::Board *board;
  AnalysisViewer *analysisViewer;
  Q3ListView *moveTree;
  QPushButton *button;
  QPushButton *nextButton;
  QPushButton *prevButton;
  QPushButton *showButton;
  QTextBrowser *commentView;
  QString dirName;
  QStringList files;
  int index;
  bool analyzed;
  boost::scoped_array<problem_result> results;
};

#endif // _PROBLEM_ANALIZER_H
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
