/* gpsk31 - PSK31 for Linux with a GTK+ Interface
 * Copyright (C) 2000 Luc Langehegermann, LX2GT
 * Copyright (C) 2005 Joop Stakenborg, PG4I
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 */


 /*
  * menu.C Functions for the menus
  */


#include <gtk/gtk.h>
#include <stdio.h>
#include "main_screen.h"
#include "callback.h"
#include "call_dialog.h"
#include "misc.h"
#include "globals.h"
#include "menu.h"
#include <unistd.h>
#include <stdlib.h>
#include "file.h"
#include "server.h"
#include "text.h"

char *trx_mode_names[] = {
        "BPSK31",
        "QPSK31"
};

#define BPSK31 0
#define QPSK31 1
int mode;

static void send_call ();
static void send_name ();
static void send_qth ();
static void send_rsts ();
static void send_rstr ();
static void send_frequency ();
static void send_mycall ();
static void send_myqth ();
static void send_myname ();

static void mode_qpsk_toggled ();
static void mode_afc_toggled ();
static void mode_net_toggled ();
static void mode_cwid_toggled ();

  GtkItemFactory *item_factory;
  static GtkItemFactoryEntry menu_items[] = {
    {"/_File", NULL, NULL, 0, "<Branch>"},
    {"/File/Send File", "<ctl>S", file_send_dialog, 0, NULL},
    {"/File/sep2", NULL, NULL, 0, "<Separator>"},
    {"/File/_Log to File", "<ctl>L", save_log_dialog, 0, NULL},
    {"/File/Close Lo_gfile", "<ctl>G", close_logfile, 0, NULL},
    {"/File/sep1", NULL, NULL, 0, "<Separator>"},
    {"/File/_Quit GPSK31", "<ctl>Q", exit_dialog, 0, NULL},
    {"/S_end", NULL, NULL, 0, "<Branch>"},
    {"/Send/_Call", "<ctl>C", send_call, 0, NULL},
    {"/Send/_Name", "<ctl>N", send_name, 0, NULL},
    {"/Send/QT_H", "<ctl>H", send_qth, 0,NULL},
    {"/Send/RS_T-S", "<ctl>T", send_rsts, 0, NULL},
    {"/Send/_Frequency", "<ctl>F", send_frequency, 0, NULL},
    {"/Send/sep1", NULL, NULL, 0, "<Separator>"},
    {"/Send/MyCa_ll", "<ctl>L", send_mycall, 0, NULL},
    {"/Send/MyNa_me", "<ctl>M", send_myname, 0, NULL},
    {"/Send/M_yQTH", "<ctl>Y", send_myqth, 0, NULL},
    {"/Send/RST-_R", "<ctl>R", send_rstr, 0, NULL},
    {"/_Mode", NULL, NULL, 0, "<Branch>"},
    {"/Mode/_QPSK", "<alt>Q", mode_qpsk_toggled, 0, "<CheckItem>"},
    {"/Mode/_CW-ID", "<alt>C", mode_cwid_toggled, 0, "<CheckItem>"},
//    {"/Mode/_Beacon", "<alt>B", not_implemented, 0, "<CheckItem>"},
//    {"/Mode/Half _Duplex", "<alt>D", not_implemented, 0, "<CheckItem>"},
    {"/Mode/_AFC", "<alt>A", mode_afc_toggled, 0, "<CheckItem>"},
    {"/Mode/_NET", "<alt>N", mode_net_toggled, 0, "<CheckItem>"},
//    {"/_Settings", NULL, NULL, 0, "<Branch>"},
//    {"/_Settings/Preferences          ", NULL, not_implemented, 0, NULL},
//    {"/_Settings/sep1", NULL, NULL, 0, "<Separator>"},
//    {"/_Settings/Fixtexts", NULL, NULL, 0, "<Branch>"},
//    {"/_Settings/Fixtexts/Alt-Key-Fixtexts    ", NULL, not_implemented, 0, NULL},
//    {"/_Settings/Fixtexts/Ctl-Key-Fixtexts", NULL, not_implemented, 0, NULL},
    {"/_Window", NULL, NULL, 0, "<Branch>"},
//    {"/_Window/Contacts during this session", "<alt>F10", not_implemented, 0, "<CheckItem>"},
//    {"/_Window/Previous Contacts", "<ctl>F10", not_implemented, 0, "<CheckItem>"},
    {"/_Window/QSO Details", "<ctl>W", toggle_call_dialog, 0, "<CheckItem>"},
//    {"/L_ogbook", NULL, NULL, 0, "<Branch>"},
//    {"/Logbook/Search _Data", "<ctl>D", not_implemented, 0, NULL},
    {"/_Help", NULL, NULL, 0, "<LastBranch>"},
    {"/_Help/About GPSK31", NULL, about_dialog, 0, NULL},
    {"/_Help/Manual", "<ctl>I", help_dialog, 0, NULL},
//    {"/_Help/GPSK31 Users Guide", NULL, not_implemented, 0, NULL}
  };

void
init_menu ()
{
  GtkAccelGroup *accel_group;
  gint nmenu_items = sizeof (menu_items) / sizeof (menu_items[0]);

  accel_group = gtk_accel_group_new ();


  item_factory = gtk_item_factory_new (GTK_TYPE_MENU_BAR, "<main>",
				       accel_group);

  gtk_item_factory_create_items (item_factory, nmenu_items, menu_items, NULL);
  gtk_window_add_accel_group (GTK_WINDOW (main_screen.window), accel_group);
  main_screen.menu = gtk_item_factory_get_widget (item_factory, "<main>");
  
}

void about_dialog()
{
   static GtkWidget	*window = NULL;
   static GtkWidget	*label; 
   static GtkWidget	*ok_button;

   if (!window) {

   window = gtk_dialog_new();
   gtk_signal_connect (GTK_OBJECT (window), "destroy",
                          GTK_SIGNAL_FUNC (gtk_widget_destroyed),
                          &window);
   gtk_window_set_title (GTK_WINDOW (window),
                        "About GPSK31");
   label = gtk_label_new ("\nGPSK31 - Linux GTK+ PSK31 Terminal\n" \
		          "Version "VERSION" - "DATE"\n\n" \
			  "DSP Routines by Hansi Reiser, DL9RDZ\n" \
			  "GTK+ GUI by Luc Langehegermann, LX2GT\n" \
			  "GTK+-2.0 porting by Joop Stakenborg, PG4I\n");
   gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window)->vbox), label, TRUE, TRUE, 0);
   ok_button = gtk_button_new_with_label ("OK");
   gtk_widget_set_usize (ok_button, 75, 0);
   gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window)->action_area), ok_button, TRUE, FALSE, 0);
   gtk_window_set_policy (GTK_WINDOW (window), 0, 0, 0);
   gtk_widget_grab_focus (ok_button);

   gtk_signal_connect_object (GTK_OBJECT (ok_button), "clicked",
		       GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT (window));

   }
   if (!GTK_WIDGET_VISIBLE (window)) gtk_widget_show_all (window);
   gtk_grab_add (window);
}

void help_dialog()
{
   static GtkWidget	*window = NULL;
   static GtkWidget	*ok_button, *tv, *scrolled;
   gchar *helpfile, buf[80], *b;
   FILE *in;
   GtkTextBuffer *buffer;
   GtkTextIter start, end;
   PangoFontDescription *font_desc;

   if (!window) {

   window = gtk_dialog_new();
   gtk_widget_set_size_request (window, 650, 400);
   gtk_signal_connect (GTK_OBJECT (window), "destroy",
                          GTK_SIGNAL_FUNC (gtk_widget_destroyed),
                          &window);
   gtk_window_set_title (GTK_WINDOW (window),
                        "GPSK31	 Manual");
   scrolled = gtk_scrolled_window_new (NULL, NULL);
   gtk_container_add (GTK_CONTAINER (GTK_DIALOG(window)->vbox), scrolled);
   gtk_scrolled_window_set_policy
    (GTK_SCROLLED_WINDOW (scrolled), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
   tv = gtk_text_view_new ();
   gtk_container_add (GTK_CONTAINER (scrolled), tv);
   helpfile = g_strdup_printf
     ("%s%s%s", DATADIR, G_DIR_SEPARATOR_S, "README");
   buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW(tv));
   gtk_text_buffer_get_bounds (buffer, &start, &end);
   b = g_new0 (gchar, 100);
   in = fopen (helpfile, "r");
   if (in)
   {
      do
      {
        if (fgets (buf, 80, in) == NULL)
           break;
        else
        {
           b = g_locale_to_utf8 (buf, -1, NULL, NULL, NULL);
           gtk_text_buffer_insert (buffer, &start, b, -1);
         }
       }
       while (!feof (in));
       fclose (in);
   }
   g_free (b);
   g_free (helpfile);
   font_desc = pango_font_description_from_string ("mono");
   gtk_widget_modify_font (tv, font_desc);
   pango_font_description_free (font_desc);

   ok_button = gtk_button_new_with_label ("OK");
   gtk_widget_set_usize (ok_button, 75, 0);
   gtk_box_pack_start
     (GTK_BOX (GTK_DIALOG (window)->action_area), ok_button, TRUE, FALSE, 0);
   gtk_window_set_policy (GTK_WINDOW (window), 0, 0, 0);
   gtk_widget_grab_focus (ok_button);

   gtk_signal_connect_object (GTK_OBJECT (ok_button), "clicked",
		       GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT (window));
   }
   if (!GTK_WIDGET_VISIBLE (window)) gtk_widget_show_all (window);
   gtk_widget_grab_focus (scrolled);
}

void exit_dialog()
{
   static GtkWidget    *window = NULL;
   static GtkWidget    *label;
   static GtkWidget    *yes_button;
   static GtkWidget    *no_button;

   if (!window) {
   window = gtk_dialog_new();
   gtk_signal_connect (GTK_OBJECT (window), "destroy",
                          GTK_SIGNAL_FUNC (gtk_widget_destroyed),
                          &window);
   gtk_window_set_title (GTK_WINDOW (window),
                        "Quit GPSK31?");
   label = gtk_label_new ("\n\tDo you really want to quit?\t\n"); 
   gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window)->vbox), label, TRUE, TRUE, 0);
   yes_button = gtk_button_new_with_label ("Yes");
   gtk_widget_set_usize (yes_button, 75, 0);
   gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window)->action_area), yes_button, TRUE, FALSE, 0);
   no_button = gtk_button_new_with_label ("No");
   gtk_widget_set_usize (no_button, 75, 0);
   gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window)->action_area), no_button, TRUE, FALSE, 0);
   gtk_window_set_policy (GTK_WINDOW (window), 0, 0, 0);
   gtk_signal_connect_object (GTK_OBJECT (no_button), "clicked",
                       GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT (window));

   gtk_signal_connect (GTK_OBJECT (yes_button), "clicked",
			GTK_SIGNAL_FUNC (gtk_main_quit), NULL);
	}
   if (!GTK_WIDGET_VISIBLE (window)) gtk_widget_show_all (window);
}

void not_implemented ()
{
   static GtkWidget     *window = NULL;
   static GtkWidget     *label;
   static GtkWidget     *ok_button;

   if (!window) {
   window = gtk_dialog_new();
   gtk_window_set_title (GTK_WINDOW (window),
                        "Information");
   label = gtk_label_new ("\n  This function is not yet available!  \n");
   gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window)->vbox), label, TRUE, TRUE, 0);
   ok_button = gtk_button_new_with_label ("OK");
   gtk_widget_set_usize (ok_button, 75, 0);
   gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window)->action_area), ok_button, TRUE, FALSE, 0);
   gtk_window_set_policy (GTK_WINDOW (window), 0, 0, 0);
   gtk_widget_grab_focus (ok_button);

   gtk_signal_connect_object (GTK_OBJECT (ok_button), "clicked",
                       GTK_SIGNAL_FUNC (gtk_widget_hide), GTK_OBJECT (window));
	}
   if (!GTK_WIDGET_VISIBLE (window)) gtk_widget_show_all (window);
}

/* This unchecks the qso_details_menu */
void check_menu(char *path, int state)
{
  gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
    (gtk_item_factory_get_item (item_factory, path)), state);
}

/*
 * This functions sends the info entered in the qso details dialog
 */

void send_call ()
{
	commPutData (qsodata.call, -1);
	put_tx_window (qsodata.call);
}


void send_name ()
{
        commPutData (qsodata.name, -1);
	put_tx_window (qsodata.name);
}

void send_qth ()
{
        commPutData (qsodata.qth, -1);
	put_tx_window (qsodata.qth);
}

void send_rsts ()
{
        commPutData (qsodata.rst_s, -1);
	put_tx_window (qsodata.rst_s);
}

void send_rstr ()
{
        commPutData (qsodata.rst_r, -1);
	put_tx_window (qsodata.rst_r);
}

void send_frequency ()
{
        commPutData (qsodata.freq, -1);
	put_tx_window (qsodata.freq);
}

void send_mycall ()
{
        commPutData (ini_settings.call, -1);
	put_tx_window (ini_settings.call);
}

void send_myqth ()
{
        commPutData (ini_settings.qth, -1);
	put_tx_window (ini_settings.qth);
}

void send_myname ()
{
        commPutData (ini_settings.name, -1);
	put_tx_window (ini_settings.name);
}

char
*trx_get_mode_name(void)
{
  return trx_mode_names[mode];
}


void mode_qpsk_toggled ()
{
  if (GTK_CHECK_MENU_ITEM (gtk_item_factory_get_item
      (item_factory, "/Mode/QPSK"))->active)
  {
    gtk_toggle_button_set_active
      (GTK_TOGGLE_BUTTON (main_screen.mode_qpsk), TRUE);
    mode = QPSK31;
  }
  else
  {
    gtk_toggle_button_set_active
      (GTK_TOGGLE_BUTTON (main_screen.mode_qpsk), FALSE);
    mode = BPSK31;
  }
}
                                                        
void mode_afc_toggled ()
{
	if (GTK_CHECK_MENU_ITEM (gtk_item_factory_get_item (item_factory, "/Mode/AFC"))->active)
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (main_screen.afc), TRUE);
	else    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (main_screen.afc), FALSE);
}

void mode_net_toggled ()
{
        if (GTK_CHECK_MENU_ITEM (gtk_item_factory_get_item (item_factory, "/Mode/NET"))->active)
                gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (main_screen.net), TRUE);
        else    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (main_screen.net), FALSE);
}

void mode_cwid_toggled ()
{
	if (GTK_CHECK_MENU_ITEM (gtk_item_factory_get_item (item_factory, "/Mode/CW-ID"))->active)
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (main_screen.cwid), TRUE);
	else 
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (main_screen.cwid), FALSE);
}
