/*
 * GooCanvas. Copyright (C) 2005-6 Damon Chaplin.
 * Released under the GNU LGPL license. See COPYING for details.
 *
 * goocanvasitemviewsimple.h - abstract base class for simple item views.
 */
#ifndef __GOO_CANVAS_ITEM_VIEW_SIMPLE_H__
#define __GOO_CANVAS_ITEM_VIEW_SIMPLE_H__

#include <gtk/gtk.h>
#include "goocanvasitemsimple.h"
#include "goocanvasitemview.h"

G_BEGIN_DECLS


typedef enum
{
  /* If the view needs to recompute its bounds and redraw. */
  GOO_CANVAS_ITEM_VIEW_NEED_UPDATE		  = 1 << 0,

  /* If all descendants need to be updated.. */
  GOO_CANVAS_ITEM_VIEW_NEED_ENTIRE_SUBTREE_UPDATE = 1 << 1,

  /* If the view can take the keyboard focus. */
  GOO_CANVAS_ITEM_VIEW_CAN_FOCUS		  = 1 << 2
} GooCanvasItemViewFlags;

#define GOO_TYPE_CANVAS_ITEM_VIEW_SIMPLE            (goo_canvas_item_view_simple_get_type ())
#define GOO_CANVAS_ITEM_VIEW_SIMPLE(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GOO_TYPE_CANVAS_ITEM_VIEW_SIMPLE, GooCanvasItemViewSimple))
#define GOO_CANVAS_ITEM_VIEW_SIMPLE_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GOO_TYPE_CANVAS_ITEM_VIEW_SIMPLE, GooCanvasItemViewSimpleClass))
#define GOO_IS_CANVAS_ITEM_VIEW_SIMPLE(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GOO_TYPE_CANVAS_ITEM_VIEW_SIMPLE))
#define GOO_IS_CANVAS_ITEM_VIEW_SIMPLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GOO_TYPE_CANVAS_ITEM_VIEW_SIMPLE))
#define GOO_CANVAS_ITEM_VIEW_SIMPLE_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GOO_TYPE_CANVAS_ITEM_VIEW_SIMPLE, GooCanvasItemViewSimpleClass))


typedef struct _GooCanvasItemViewSimple       GooCanvasItemViewSimple;
typedef struct _GooCanvasItemViewSimpleClass  GooCanvasItemViewSimpleClass;

/**
 * GooCanvasItemViewSimple
 *
 * The #GooCanvasItemViewSimple-struct struct contains private data only.
 */
struct _GooCanvasItemViewSimple
{
  GObject parent_object;

  /* The canvas view. */
  GooCanvasView *canvas_view;

  /* The parent view. */
  GooCanvasItemView *parent_view;

  /* The item in the model. */
  GooCanvasItemSimple *item;

  /* The transformation matrix of this particular view, or NULL. */
  cairo_matrix_t *transform;

  /* The bounds of the item, relative to the entire canvas. */
  GooCanvasBounds bounds;

  /* A few flags. */
  GooCanvasItemViewFlags flags;
};

struct _GooCanvasItemViewSimpleClass
{
  GObjectClass parent_class;

  /* Virtual methods. */
  void		(* create_path)			(GooCanvasItemSimple *item,
						 cairo_t             *cr);
};


GType goo_canvas_item_view_simple_get_type   (void) G_GNUC_CONST;


void  goo_canvas_item_view_simple_item_changed (GooCanvasItem           *item,
						gboolean                 recompute_bounds,
						GooCanvasItemViewSimple *simple_view);

void  goo_canvas_item_view_simple_setup_accessibility (GooCanvasItemViewSimple *simple_view);

G_END_DECLS

#endif /* __GOO_CANVAS_ITEM_VIEW_SIMPLE_H__ */
