/*
 * GooCanvas. Copyright (C) 2005 Damon Chaplin.
 * Released under the GNU LGPL license. See COPYING for details.
 *
 * goocanvasgroup.h - group item.
 */
#ifndef __GOO_CANVAS_GROUP_H__
#define __GOO_CANVAS_GROUP_H__

#include <gtk/gtk.h>
#include "goocanvasmodel.h"
#include "goocanvasutils.h"

G_BEGIN_DECLS


#define GOO_TYPE_CANVAS_GROUP            (goo_canvas_group_get_type ())
#define GOO_CANVAS_GROUP(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GOO_TYPE_CANVAS_GROUP, GooCanvasGroup))
#define GOO_CANVAS_GROUP_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GOO_TYPE_CANVAS_GROUP, GooCanvasGroupClass))
#define GOO_IS_CANVAS_GROUP(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GOO_TYPE_CANVAS_GROUP))
#define GOO_IS_CANVAS_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GOO_TYPE_CANVAS_GROUP))
#define GOO_CANVAS_GROUP_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GOO_TYPE_CANVAS_GROUP, GooCanvasGroupClass))


typedef struct _GooCanvasGroup       GooCanvasGroup;
typedef struct _GooCanvasGroupClass  GooCanvasGroupClass;

/**
 * GooCanvasGroup
 *
 * The #GooCanvasGroup-struct struct contains private data only.
 */
struct _GooCanvasGroup
{
  GObject object;

  /* The canvas model. */
  GooCanvasModel *model;

  /* The parent item. */
  GooCanvasItem *parent;

  /* An array of pointers to GooCanvasItems. The first element is at the
     bottom of the display stack and the last element is at the top. */
  GPtrArray *items;

  /* The transformation matrix, or NULL. */
  cairo_matrix_t transform;

  /* If visibility is VISIBLE_ABOVE_THRESHOLD the item is visible if the canvas
     scale setting is above this threshold (or equal to it). */
  gdouble visibility_threshold;

  /* The title and description of the item for accessibility. */
  gchar *title;
  gchar *description;

  /* Whether the item is visible, invisible, or visible above a given scale. */
  GooCanvasItemVisibility visibility	: 2;

  /* What events the group should receive. */
  GooCanvasPointerEvents pointer_events : 4;
};

struct _GooCanvasGroupClass
{
  GObjectClass parent_class;
};


GType          goo_canvas_group_get_type    (void) G_GNUC_CONST;
GooCanvasItem* goo_canvas_group_new         (GooCanvasItem  *parent);


/* This is only intended to be used by implementors of GooCanvasModel, to set
   the model of the root group. */
void           goo_canvas_group_set_model   (GooCanvasGroup *group,
					     GooCanvasModel *model);

G_END_DECLS

#endif /* __GOO_CANVAS_GROUP_H__ */
