/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * GtkGauge: A simple gauge plotter
 * Copyright (C) 1999 Uwe Steinmann
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __GTK_GAUGE_H__
#define __GTK_GAUGE_H__

#include <gdk/gdk.h>
#include <gtk/gtkmisc.h>

#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */

#define GTK_TYPE_GAUGE        (gtk_gauge_get_type ())
#define GTK_GAUGE(obj)	      (G_TYPE_CHECK_INSTANCE_CAST (obj, GTK_TYPE_GAUGE, GtkGauge))
#define GTK_GAUGE_CLASS(klass)  (G_TYPE_CHECK_CLASS_CAST (klass, GTK_TYPE_GAUGE, GtkGaugeClass))
#define GTK_IS_GAUGE(obj)	      (G_TYPE_CHECK_INSTANCE_TYPE (obj, GTK_TYPE_GAUGE))
#define GTK_IS_GAUGE_CLASS(klass)      (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_GAUGE))
#define GTK_GAUGE_GET_CLASS(obj)       (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_GAUGE, GtkGaugeClass))

#define	GRAPH_WIDTH	(44)
#define	GRAPH_HEIGHT	(30)
#define	BOTTOM_SPACE	(0)

typedef struct _GtkGauge	     GtkGauge;
typedef struct _GtkGaugeClass  GtkGaugeClass;

struct _GtkGauge
{
	GtkMisc  misc;
	GdkColor fg[4];
	GdkColor bg[4];

	GdkGC    *gc;
	GdkPixmap *pixmap;
	GdkFont* font;

	gint value;
	gint min, max;
	gint autorange;
	gint quantisation;
	gint width;

	/* Old values from adjustment stored so we know when something changes */
	gfloat old_value;
	gfloat old_lower;
	gfloat old_upper;

	/* The adjustment object that stores the data for this dial */
	GtkAdjustment *adjustment;
};

struct _GtkGaugeClass
{
  GtkMiscClass parent_class;
};


GtkType gtk_gauge_get_type(void);
GtkWidget* gtk_gauge_new(GtkAdjustment *adjustment);
GtkAdjustment* gtk_gauge_get_adjustment(GtkGauge *gauge);
void gtk_gauge_set_adjustment(GtkGauge *gauge, GtkAdjustment *adjustment);
void gtk_gauge_set_state(GtkGauge *gauge, GtkStateType widget_state, gint value);
void gtk_gauge_set_value(GtkGauge *gauge, gint value);
gint gtk_gauge_get_value(GtkGauge *gauge);
void gtk_gauge_set_colors(GtkGauge *gauge, GdkColor *active, GdkColor *inactive, GdkColor *grid);
void gtk_gauge_set_range (GtkGauge *gauge, gint xmin, gint xmax);
void gtk_gauge_set_quantisation (GtkGauge *gauge, gint value);
void gtk_gauge_set_autorange (GtkGauge *gauge, gint value);

#ifdef __cplusplus
#pragma {
}
#endif /* __cplusplus */


#endif /* __GTK_GAUGE_H__ */
