/* ISDN Monitor panel applet
 * Insprired by kimon by Markus Dahlweid dahlweid@tzi.org 
 *
 * By Uwe Steinmann <Uwe.Steinmann@fernuni-hagen.de>
 *
 * Enjoy.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or 
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License  
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __GIMON_H__
#define __GIMON_H__

#include <stdio.h>
#include <stdlib.h>

typedef struct _BAT_STATUS {
	int present;
	int ac_on;
	int charging;
	int charge;
	int maxcharge;
	float current;
	float	voltage;
} BAT_STATUS;

typedef struct _PMUD_STATUS {
	BAT_STATUS batleft;
	BAT_STATUS batright;
} PMUD_STATUS;

typedef struct _PmudData {
	GtkWidget *app;
	GtkWidget *globalbox;
	GtkWidget *pb;        // Property box
	GtkWidget *bar1, *bar2;
	GtkWidget *gauge;
	GtkWidget *gaugeframe;
	GtkTooltips *tooltip;
	GNOME_Panel_OrientType orient;
	GtkWidget *status_pixmap;
	GdkPixmap *battery_in_pixmap;
	GdkBitmap *battery_in_pixmap_mask;
	GdkPixmap *ac_in_pixmap;
	GdkBitmap *ac_in_pixmap_mask;
	GdkPixmap *charge_in_pixmap;
	GdkBitmap *charge_in_pixmap_mask;
	int height, width;
	int updatetime;
	int timeout;
	int port;
	char *servername;
	int show_current;

	PMUD_STATUS *pmud_status;
	PMUD_STATUS *old_pmud_status;
	int valid_data;      /* 0 if current pmud_status is valid */
	int pmudinfo;
} PmudData;

#endif
