/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "gpc_app.h"
#include "gpc_app_intf.h"
#include "gpc_options_intf.h"
#include "support.h"

#include "pg_connection.h"


int
main (int argc, char *argv[])
{
#ifdef ENABLE_NLS
  bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
  textdomain (PACKAGE);
#endif

  gnome_init (PACKAGE, VERSION, argc, argv);

  /* First, we try to recreate connection from stored params 
     If connection can't be established with stored params,
     a dialog is shown to get params from user...           */
  if (gnome_config_get_bool ("/gphotocoll/options/auto_connect=true"))
    gpc_connection = pg_connection_new ();   
  if (!gpc_connection)
    gpc_connection = pg_connection_new_with_dialog ();
  else
  if (!pg_connection_open (gpc_connection)) {
    pg_connection_free (gpc_connection);
    gpc_connection = pg_connection_new_with_dialog ();
  }
  if (!gpc_connection) {
    gnome_dialog_run_and_close (GNOME_DIALOG (gnome_error_dialog (_("Can't create pgConnection database component !"))));
    return 1;
  }
  if (!pg_connection_open (gpc_connection)) {
    gnome_dialog_run_and_close (GNOME_DIALOG (gnome_error_dialog (_("Postgres database not available !"))));
    pg_connection_free (gpc_connection);
    gpc_connection = NULL;
    return 2;
  }
  if (!gpc_app_check_database (gpc_connection)) {
    pg_connection_free (gpc_connection);
    gpc_connection = NULL;
    return 3;
  }

  /* Then, we try to check if GPC repository is correctly defined... */
  gpc_app_read_options ();
  if (!gpc_repository) {
    gpc_options_dialog = create_gpc_options_dialog ();
    gnome_dialog_run_and_close (GNOME_DIALOG (gpc_options_dialog));
    gtk_object_destroy (GTK_OBJECT (gpc_options_dialog));
    gpc_options_dialog = NULL;
    if (!gpc_repository) {
      gnome_dialog_run_and_close (GNOME_DIALOG (gnome_error_dialog (_("GPC repository must be defined !!\nRead help for more informations..."))));
      return 4;
    }
  }

  gpc_app = create_gpc_app ();
  gtk_widget_show (gpc_app);

  gtk_main ();

  return 0;
}

