%define  RELEASE 1
%define  rel     %{?CUSTOM_RELEASE} %{!?CUSTOM_RELEASE:%RELEASE}
%define  prefix  /usr

Summary: 	GNOME Photo Collector
Name: 		gphotocoll
Version: 	0.7
Release: 	%rel
Copyright: 	GPL
Group: 		Applications/Productivity
Source: 	http://download.sourceforge.net/gpc/gphotocoll-%{version}.tar.gz
Url:		http://gpc.sourceforge.net/
BuildRoot:	/var/tmp/%{name}-%{PACKAGE_VERSION}-root
Docdir: 	%{prefix}/doc

Requires: gtk+ >= 1.2.0
Requires: gnome-libs >= 1.2.0
Requires: gnome-print >= 0.25
Requires: gdk-pixbuf >= 0.7.0
Requires: postgresql >= 6.5

%description
GPC, which stands for GNOME Photo Collector, is a graphical tool
to display and classify images and pictures. Basic features are :
    - Store images references in a PostgreSQL database.
    - Add many comments on each film and/or image.
    - Use queries to extract corresponding pictures.
    - Single click image viewing / navigation.
    - Zoom functions.
    - Availability to use an external editor. 

%prep
%setup -q

%build
%ifarch alpha
	MYARCH_FLAGS="--host=alpha-redhat-linux"
%endif

CFLAGS="$RPM_OPT_FLAGS" ./configure $MYARCH_FLAGS --prefix=%prefix 

if [ "$SMP" != "" ]; then
	make -k -j$SMP "MAKE=make -k -j$SMP"
else
	make -k
fi

%install
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT

make prefix=$RPM_BUILD_ROOT%{prefix} sysconfdir=$RPM_BUILD_ROOT%{sysconfdir} install

%clean
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT

%files 

%defattr (0555, bin, bin)
%{prefix}/bin/gphotocoll

%defattr (0444, bin, bin, 0555)
%doc AUTHORS ChangeLog NEWS README COPYING TODO
%{prefix}/share/gnome/help/gphotocoll
%config %{prefix}/share/gnome/apps/Graphics/gphotocoll.desktop
%{prefix}/share/locale/*/LC_MESSAGES/gphotocoll.mo
%{prefix}/share/pixmaps/gphotocoll
%{prefix}/share/pixmaps/gphotocoll.xpm
%{_mandir}/man1/gphotocoll.1*

%changelog
* Thu Nov 1 2001 Thierry FLORAC <tflorac@free.fr>
  - Updated to version 0.7
  - Added storing of thumbnails on disk to improve performances ;
    thumbnails are created with the help of ImageMagick package.
  - Added new options on query dialog.

* Thu Jul 19 2001 Thierry FLORAC <tflorac@free.fr>
  - Updated to version 0.6
  - Added printing of thumbnails and of a single image.
  - Corrected thumbnails handling function to reduce memory use.

* Mon Jun 18 2001 Thierry FLORAC <tflorac@free.fr>
  - Updated to version 0.5
  - Added support for thumbnails.
  - Corrected support for non english languages.

* Tue Dec 26 2000 Thierry FLORAC <tflorac@free.fr>
  - Updated to version 0.4
  - Package renamed from "gpc" to "gphotocoll", to avoid conflicts
    with the "GNU Pascal Compiler".
  - Added postgresql dependance.
  - spec file modified so that gphotocoll specific directories
    (help and pixmaps) are correctly removed when deleting package.

* Sun Dec 10 2000 Mark Kuchel <mark@kuchel.net>
  - Version 0.3
  - Initial spec file
