/*
  Gnome-o-Phone - A program for internet telephony
  Copyright (C) 1999  Roland Dreier
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  $Id: config-ui.c 1.1 Sat, 11 Dec 1999 23:53:26 -0600 dreier $
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "ui.h"

#include <gtk/gtk.h>
#ifdef HAVE_LINUX_TELEPHONY_H
#include <linux/telephony.h>
#endif
#ifdef HAVE_LINUX_IXJUSER_H
#include <linux/ixjuser.h>
#endif

#include "thread-queue.h"
#include "request.h"
#include "talk.h"
#include "listen.h"
#include "connection.h"
#include "thread.h"
#include "sound.h"

#include "gphone.h"
#include "gphone-lib.h"

static GtkWidget *Config_Window = NULL;
static GtkWidget *Receive_Port_Entry;
static GtkWidget *Send_Port_Entry;

static Sound_Device_Type Device;
static int Ixj_Port;

static void
destroy(GtkWidget *widget, gpointer data)
{
  Config_Window = NULL;
}

static void
ok_button_clicked(GtkWidget *widget, gpointer data)
{
  /* FIX: Handle Port Numbers */

  set_sound_device(Device);
  set_sound_ixj_port(Ixj_Port);

  gtk_widget_destroy(GTK_WIDGET(data));
}

static void
cancel_button_clicked(GtkWidget *widget, gpointer data)
{
  gtk_widget_destroy(GTK_WIDGET(data));
}

static void
device_menu(GtkWidget *widget, gpointer data)
{
  Device = (Sound_Device_Type) GPOINTER_TO_INT(data);
}

static void
port_menu(GtkWidget *widget, gpointer data)
{
  Ixj_Port = GPOINTER_TO_INT(data);
}

static void
add_network_page(GtkWidget *notebook)
{
  GtkWidget *label;
  GtkWidget *frame;
  GtkWidget *vbox;
  GtkWidget *table;

  vbox = gtk_vbox_new(FALSE, 5);

  table = gtk_table_new(2, 2, FALSE);

  label = gtk_label_new("Receive Port:");
  gtk_widget_show(label);
  gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 0, 1);

  gtk_widget_set_sensitive(label, FALSE);

  Receive_Port_Entry = gtk_entry_new();
  gtk_widget_show(Receive_Port_Entry);
  gtk_table_attach_defaults(GTK_TABLE(table), Receive_Port_Entry, 1, 2, 0, 1);

  gtk_widget_set_sensitive(Receive_Port_Entry, FALSE);

  label = gtk_label_new("Send Port:");
  gtk_widget_show(label);
  gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 1, 2);

  gtk_widget_set_sensitive(label, FALSE);

  Send_Port_Entry = gtk_entry_new();
  gtk_widget_show(Send_Port_Entry);
  gtk_table_attach_defaults(GTK_TABLE(table), Send_Port_Entry, 1, 2, 1, 2);

  gtk_widget_set_sensitive(Send_Port_Entry, FALSE);

  gtk_widget_show(table);
  gtk_box_pack_start(GTK_BOX(vbox), table, TRUE, FALSE, 0);

  gtk_widget_show(vbox);

  frame = gtk_frame_new("Network configuration");
  gtk_widget_show(frame);

  gtk_container_add(GTK_CONTAINER(frame), vbox);

  label = gtk_label_new("Network");
  gtk_widget_show(label);

  gtk_notebook_append_page(GTK_NOTEBOOK(notebook), frame, label);
}

static void
add_sound_page(GtkWidget *notebook)
{
  GtkWidget *label;
  GtkWidget *frame;
  GtkWidget *vbox;
  GtkWidget *table;
  GtkWidget *optionmenu;
  GtkWidget *menu;
  GtkWidget *menuitem;

  vbox = gtk_vbox_new(FALSE, 5);

  table = gtk_table_new(2, 2, FALSE);

  /* Sound device selection */

  label = gtk_label_new("Sound Device:");
  gtk_widget_show(label);
  gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 0, 1);

  optionmenu = gtk_option_menu_new();
  menu = gtk_menu_new();

  menuitem = gtk_menu_item_new_with_label("OSS: /dev/dsp");
  gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
                            GTK_SIGNAL_FUNC(device_menu),
                            GINT_TO_POINTER(OSS_DEVICE));
  gtk_widget_show(menuitem);
  gtk_menu_append(GTK_MENU(menu), menuitem);

#ifdef HAVE_LINUX_TELEPHONY_H
#ifdef HAVE_LINUX_IXJUSER_H
  menuitem = gtk_menu_item_new_with_label("IXJ: /dev/phone0");
  gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
                            GTK_SIGNAL_FUNC(device_menu),
                            GINT_TO_POINTER(IXJ_DEVICE));
  gtk_widget_show(menuitem);
  gtk_menu_append(GTK_MENU(menu), menuitem);
#endif /* HAVE_LINUX_IXJUSER_H */
#endif /* HAVE_LINUX_TELEPHONY_H */ 

  switch (Device) {
  case OSS_DEVICE:
    gtk_menu_set_active(GTK_MENU(menu), 0);
    break;
#ifdef HAVE_LINUX_TELEPHONY_H
#ifdef HAVE_LINUX_IXJUSER_H
  case IXJ_DEVICE:
    gtk_menu_set_active(GTK_MENU(menu), 1);
    break;
#endif /* HAVE_LINUX_IXJUSER_H */
#endif /* HAVE_LINUX_TELEPHONY_H */ 
  default:
    g_assert_not_reached();
    break;
  }

  gtk_option_menu_set_menu(GTK_OPTION_MENU(optionmenu), menu);

  gtk_widget_show(menu);
  gtk_widget_show(optionmenu);

  gtk_table_attach_defaults(GTK_TABLE(table), optionmenu, 1, 2, 0, 1);

  /* IXJ port selection */

#ifdef HAVE_LINUX_TELEPHONY_H
#ifdef HAVE_LINUX_IXJUSER_H
  label = gtk_label_new("IXJ Port:");
  gtk_widget_show(label);
  gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 1, 2);

  optionmenu = gtk_option_menu_new();
  menu = gtk_menu_new();

  menuitem = gtk_menu_item_new_with_label("POTS");
  gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
                     GTK_SIGNAL_FUNC(port_menu),
                     GINT_TO_POINTER(PORT_POTS));
  gtk_widget_show(menuitem);
  gtk_menu_append(GTK_MENU(menu), menuitem);

  menuitem = gtk_menu_item_new_with_label("PSTN");
  gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
                     GTK_SIGNAL_FUNC(port_menu),
                     GINT_TO_POINTER(PORT_PSTN));
  gtk_widget_show(menuitem);
  gtk_menu_append(GTK_MENU(menu), menuitem);

  menuitem = gtk_menu_item_new_with_label("Speaker");
  gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
                     GTK_SIGNAL_FUNC(port_menu),
                     GINT_TO_POINTER(PORT_SPEAKER));
  gtk_widget_show(menuitem);
  gtk_menu_append(GTK_MENU(menu), menuitem);

  menuitem = gtk_menu_item_new_with_label("Handset");
  gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
                     GTK_SIGNAL_FUNC(port_menu),
                     GINT_TO_POINTER(PORT_HANDSET));
  gtk_widget_show(menuitem);
  gtk_menu_append(GTK_MENU(menu), menuitem);

  switch (Ixj_Port) {
  case PORT_POTS:
    gtk_menu_set_active(GTK_MENU(menu), 0);
    break;
  case PORT_PSTN:
    gtk_menu_set_active(GTK_MENU(menu), 1);
    break;
  case PORT_SPEAKER:
    gtk_menu_set_active(GTK_MENU(menu), 2);
    break;
  case PORT_HANDSET:
    gtk_menu_set_active(GTK_MENU(menu), 3);
    break;
  default:
    g_assert_not_reached();
    break;
  }

  gtk_option_menu_set_menu(GTK_OPTION_MENU(optionmenu), menu);

  gtk_widget_show(menu);
  gtk_widget_show(optionmenu);

  gtk_table_attach_defaults(GTK_TABLE(table), optionmenu, 1, 2, 1, 2);
#endif /* HAVE_LINUX_IXJUSER_H */
#endif /* HAVE_LINUX_TELEPHONY_H */ 

  gtk_widget_show(table);
  gtk_box_pack_start(GTK_BOX(vbox), table, TRUE, FALSE, 0);

  gtk_widget_show(vbox);

  frame = gtk_frame_new("Sound configuration");
  gtk_widget_show(frame);

  gtk_container_add(GTK_CONTAINER(frame), vbox);

  label = gtk_label_new("Sound");
  gtk_widget_show(label);

  gtk_notebook_append_page(GTK_NOTEBOOK(notebook), frame, label);
}

void
config_open_window(void)
{
  GtkWidget *vbox;
  GtkWidget *hbox;
  GtkWidget *separator;
  GtkWidget *notebook;
  GtkWidget *button;

  if (Config_Window != NULL) {
    return;
  }

  Device = get_sound_device();
  Ixj_Port = get_sound_ixj_port();

  Config_Window = gtk_window_new(GTK_WINDOW_DIALOG);
  gtk_window_set_title(GTK_WINDOW(Config_Window), "gphone config");
  gtk_container_set_border_width(GTK_CONTAINER(Config_Window), 10);
  
  gtk_signal_connect(GTK_OBJECT(Config_Window), "destroy",
                     GTK_SIGNAL_FUNC(destroy), NULL);

  vbox = gtk_vbox_new(FALSE, 5);

  notebook = gtk_notebook_new();
  gtk_notebook_set_tab_pos(GTK_NOTEBOOK(notebook), GTK_POS_TOP);

  add_network_page(notebook);
  add_sound_page(notebook);

  gtk_widget_show(notebook);

  gtk_box_pack_start(GTK_BOX(vbox), notebook, TRUE, TRUE, 0);

  separator = gtk_hseparator_new();
  gtk_widget_show(separator);

  gtk_box_pack_start(GTK_BOX(vbox), separator, FALSE, FALSE, 0);

  hbox = gtk_hbox_new(TRUE, 5);

  button = gtk_button_new_with_label("OK");
  gtk_signal_connect(GTK_OBJECT(button), "clicked",
                     GTK_SIGNAL_FUNC(ok_button_clicked), Config_Window);
  gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 0);
  gtk_widget_show(button);

  button = gtk_button_new_with_label("Cancel");
  gtk_signal_connect(GTK_OBJECT(button), "clicked",
                     GTK_SIGNAL_FUNC(cancel_button_clicked), Config_Window);
  gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 0);
  gtk_widget_show(button);

  gtk_widget_show(hbox);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);

  gtk_container_add(GTK_CONTAINER(Config_Window), vbox);
  gtk_widget_show(vbox);
  gtk_widget_show(Config_Window);
}



/*
 * Local variables:
 *  compile-command: "make -k gphone"
 * End:
 */
