# tests/test_job.py
#
#

__copyright__ = 'this file is in the public domain'

from gozerbot.bot import Bot
from gozerbot.generic import stringinlist
from gozerbot.plugins import plugins
from gozerbot.thr import start_new_thread
from gozerbot.config import config
from gozerbot.periodical import periodical
import unittest, time

plugins.reload('gozerplugs.plugs', 'job')

def job():
    pass

class test_job(unittest.TestCase):

    b = Bot()
    b.userhosts['test'] = 'test@test'
    b.userhosts['test2'] = 'test2@test2'
    b.channels['#test'] = {}
    b.channels['#test2'] = {}

    def test_job(self):
        result = self.b.test('job')
        self.assert_(stringinlist('<job id>', result))

    def test_job2(self):
        result = self.b.test('job mekker')
        self.assert_(stringinlist('<job id>', result))

    def test_job3(self):
        periodical.addjob(60, 0, job)
        result = self.b.test('job 1')
        self.assert_(stringinlist('fires at', result))

    def test_joblist(self):
        periodical.addjob(60, 0, job)
        result = self.b.test('job-list')
        self.assert_(stringinlist('job', result))

    def test_jobgroups(self):
        periodical.addjob(60, 0, job)
        result = self.b.test('job-groups')
        self.assert_(stringinlist('test_job', result))

    def test_jobkill(self):
        result = self.b.test('job-kill')
        self.assert_(stringinlist('<job id>', result))

    def test_jobkill2(self):
        result = self.b.test('job-kill 1')
        self.assert_(stringinlist('killed', result))
