# tests/test_birthday.py
#
#

__copyright__ = 'this file is in the public domain'

from gozerbot.bot import Bot
from gozerbot.generic import stringinlist, waitforqueue
from gozerbot.plugins import plugins
from gozerbot.config import config
import unittest

if config['dbenable']:
    plugins.reload('gozerplugs.dbplugs', 'birthday')
else:
    plugins.reload('gozerplugs.plugs', 'birthday')

class test_birthday(unittest.TestCase):
    b = Bot()
    b.userhosts['test'] = 'test@test'
    b.userhosts['test2'] = 'test2@test2'
    
    def test_birthday1(self):
        result = self.b.test('bd-set')
        self.assert_(stringinlist('<date>', result))

    def test_birthday2(self):
        result = self.b.test('bd-set 3-11-1967')
        self.assert_(stringinlist('birthday set', result))

    def test_birthdaydel(self):
        self.b.test('bd-set 3-11-1967')
        result = self.b.test('bd-del')
        self.assert_(stringinlist('birthday removed', result))

    def test_birthdaydel2(self):
        self.b.test('bd-del')
        result = self.b.test('bd-del')
        self.assert_(stringinlist('no birthday', result))

    def test_bd(self):
        self.b.test('bd-set 3-11-1967')
        result = self.b.test('bd 11')
        self.assert_(stringinlist('test', result))

    def test_bd2(self):
        result = self.b.test('bd mek78ker')
        self.assert_(stringinlist("don't know", result))

    def test_bd3(self):
        result = self.b.test('bd test2')
        self.assert_(stringinlist("can't find", result))

    def test_bd4(self):
        self.b.test('bd-set 3-11-1967')
        result = self.b.test('bd test')
        self.assert_(stringinlist("birthday of", result))

    def test_bd5(self):
        self.b.test('bd-del')
        result = self.b.test('bd test')
        self.assert_(stringinlist("don't have", result))

    def test_age(self):
        self.b.test('bd-set 3-11-1967')
        result = self.b.test('age test')
        self.assert_(stringinlist('age of', result))

    def test_age2(self):
        result = self.b.test('age mek45ker')
        self.assert_(stringinlist("don't know", result))

    def test_age3(self):
        result = self.b.test('age test2')
        self.assert_(stringinlist("can't find", result))

    def test_age4(self):
        self.b.test('bd-del')
        result = self.b.test('age test')
        self.assert_(stringinlist("can't find birthday data", result))

    def test_age5(self):
        self.b.test('bd-set 9-9-9999')
        result = self.b.test('age test')
        self.assert_(stringinlist("can't make a date", result))
