// Copyright 2012 Google, Inc. All rights reserved.
//
// Use of this source code is governed by a BSD-style license
// that can be found in the LICENSE file in the root of the source
// tree.

package macs

// Created by gen.go, don't edit manually
// Generated at 2014-09-09 10:01:58.097553511 -0600 MDT
// Fetched from "http://standards.ieee.org/develop/regauth/oui/oui.txt"

// ValidMACPrefixMap maps a valid MAC address prefix to the name of the
// organization that owns the rights to use it.  We map it to a hidden
// variable so it won't show up in godoc, since it's a very large map.
var ValidMACPrefixMap = validMACPrefixMap
var validMACPrefixMap = map[[3]byte]string{
	[3]byte{0, 0, 0}:       "XEROX CORPORATION",
	[3]byte{0, 0, 1}:       "XEROX CORPORATION",
	[3]byte{0, 0, 2}:       "XEROX CORPORATION",
	[3]byte{0, 0, 3}:       "XEROX CORPORATION",
	[3]byte{0, 0, 4}:       "XEROX CORPORATION",
	[3]byte{0, 0, 5}:       "XEROX CORPORATION",
	[3]byte{0, 0, 6}:       "XEROX CORPORATION",
	[3]byte{0, 0, 7}:       "XEROX CORPORATION",
	[3]byte{0, 0, 8}:       "XEROX CORPORATION",
	[3]byte{0, 0, 9}:       "XEROX CORPORATION",
	[3]byte{0, 0, 10}:      "OMRON TATEISI ELECTRONICS CO.",
	[3]byte{0, 0, 11}:      "MATRIX CORPORATION",
	[3]byte{0, 0, 12}:      "CISCO SYSTEMS, INC.",
	[3]byte{0, 0, 13}:      "FIBRONICS LTD.",
	[3]byte{0, 0, 14}:      "FUJITSU LIMITED",
	[3]byte{0, 0, 15}:      "NEXT, INC.",
	[3]byte{0, 0, 16}:      "SYTEK INC.",
	[3]byte{0, 0, 17}:      "NORMEREL SYSTEMES",
	[3]byte{0, 0, 18}:      "INFORMATION TECHNOLOGY LIMITED",
	[3]byte{0, 0, 19}:      "CAMEX",
	[3]byte{0, 0, 20}:      "NETRONIX",
	[3]byte{0, 0, 21}:      "DATAPOINT CORPORATION",
	[3]byte{0, 0, 22}:      "DU PONT PIXEL SYSTEMS     .",
	[3]byte{0, 0, 23}:      "Oracle",
	[3]byte{0, 0, 24}:      "WEBSTER COMPUTER CORPORATION",
	[3]byte{0, 0, 25}:      "APPLIED DYNAMICS INTERNATIONAL",
	[3]byte{0, 0, 26}:      "ADVANCED MICRO DEVICES",
	[3]byte{0, 0, 27}:      "NOVELL INC.",
	[3]byte{0, 0, 28}:      "BELL TECHNOLOGIES",
	[3]byte{0, 0, 29}:      "CABLETRON SYSTEMS, INC.",
	[3]byte{0, 0, 30}:      "TELSIST INDUSTRIA ELECTRONICA",
	[3]byte{0, 0, 31}:      "Telco Systems, Inc.",
	[3]byte{0, 0, 32}:      "DATAINDUSTRIER DIAB AB",
	[3]byte{0, 0, 33}:      "SUREMAN COMP. & COMMUN. CORP.",
	[3]byte{0, 0, 34}:      "VISUAL TECHNOLOGY INC.",
	[3]byte{0, 0, 35}:      "ABB INDUSTRIAL SYSTEMS AB",
	[3]byte{0, 0, 36}:      "CONNECT AS",
	[3]byte{0, 0, 37}:      "RAMTEK CORP.",
	[3]byte{0, 0, 38}:      "SHA-KEN CO., LTD.",
	[3]byte{0, 0, 39}:      "JAPAN RADIO COMPANY",
	[3]byte{0, 0, 40}:      "PRODIGY SYSTEMS CORPORATION",
	[3]byte{0, 0, 41}:      "IMC NETWORKS CORP.",
	[3]byte{0, 0, 42}:      "TRW - SEDD/INP",
	[3]byte{0, 0, 43}:      "CRISP AUTOMATION, INC",
	[3]byte{0, 0, 44}:      "AUTOTOTE LIMITED",
	[3]byte{0, 0, 45}:      "CHROMATICS INC",
	[3]byte{0, 0, 46}:      "SOCIETE EVIRA",
	[3]byte{0, 0, 47}:      "TIMEPLEX INC.",
	[3]byte{0, 0, 48}:      "VG LABORATORY SYSTEMS LTD",
	[3]byte{0, 0, 49}:      "QPSX COMMUNICATIONS PTY LTD",
	[3]byte{0, 0, 50}:      "Marconi plc",
	[3]byte{0, 0, 51}:      "EGAN MACHINERY COMPANY",
	[3]byte{0, 0, 52}:      "NETWORK RESOURCES CORPORATION",
	[3]byte{0, 0, 53}:      "SPECTRAGRAPHICS CORPORATION",
	[3]byte{0, 0, 54}:      "ATARI CORPORATION",
	[3]byte{0, 0, 55}:      "OXFORD METRICS LIMITED",
	[3]byte{0, 0, 56}:      "CSS LABS",
	[3]byte{0, 0, 57}:      "TOSHIBA CORPORATION",
	[3]byte{0, 0, 58}:      "CHYRON CORPORATION",
	[3]byte{0, 0, 59}:      "i Controls, Inc.",
	[3]byte{0, 0, 60}:      "AUSPEX SYSTEMS INC.",
	[3]byte{0, 0, 61}:      "UNISYS",
	[3]byte{0, 0, 62}:      "SIMPACT",
	[3]byte{0, 0, 63}:      "SYNTREX, INC.",
	[3]byte{0, 0, 64}:      "APPLICON, INC.",
	[3]byte{0, 0, 65}:      "ICE CORPORATION",
	[3]byte{0, 0, 66}:      "METIER MANAGEMENT SYSTEMS LTD.",
	[3]byte{0, 0, 67}:      "MICRO TECHNOLOGY",
	[3]byte{0, 0, 68}:      "CASTELLE CORPORATION",
	[3]byte{0, 0, 69}:      "FORD AEROSPACE & COMM. CORP.",
	[3]byte{0, 0, 70}:      "OLIVETTI NORTH AMERICA",
	[3]byte{0, 0, 71}:      "NICOLET INSTRUMENTS CORP.",
	[3]byte{0, 0, 72}:      "SEIKO EPSON CORPORATION",
	[3]byte{0, 0, 73}:      "APRICOT COMPUTERS, LTD",
	[3]byte{0, 0, 74}:      "ADC CODENOLL TECHNOLOGY CORP.",
	[3]byte{0, 0, 75}:      "ICL DATA OY",
	[3]byte{0, 0, 76}:      "NEC CORPORATION",
	[3]byte{0, 0, 77}:      "DCI CORPORATION",
	[3]byte{0, 0, 78}:      "AMPEX CORPORATION",
	[3]byte{0, 0, 79}:      "LOGICRAFT, INC.",
	[3]byte{0, 0, 80}:      "RADISYS CORPORATION",
	[3]byte{0, 0, 81}:      "HOB ELECTRONIC GMBH & CO. KG",
	[3]byte{0, 0, 82}:      "Intrusion.com, Inc.",
	[3]byte{0, 0, 83}:      "COMPUCORP",
	[3]byte{0, 0, 84}:      "Schnieder Electric",
	[3]byte{0, 0, 85}:      "COMMISSARIAT A L`ENERGIE ATOM.",
	[3]byte{0, 0, 86}:      "DR. B. STRUCK",
	[3]byte{0, 0, 87}:      "SCITEX CORPORATION LTD.",
	[3]byte{0, 0, 88}:      "RACORE COMPUTER PRODUCTS INC.",
	[3]byte{0, 0, 89}:      "HELLIGE GMBH",
	[3]byte{0, 0, 90}:      "SysKonnect GmbH",
	[3]byte{0, 0, 91}:      "ELTEC ELEKTRONIK AG",
	[3]byte{0, 0, 92}:      "TELEMATICS INTERNATIONAL INC.",
	[3]byte{0, 0, 93}:      "CS TELECOM",
	[3]byte{0, 0, 94}:      "ICANN, IANA Department",
	[3]byte{0, 0, 95}:      "SUMITOMO ELECTRIC IND., LTD.",
	[3]byte{0, 0, 96}:      "KONTRON ELEKTRONIK GMBH",
	[3]byte{0, 0, 97}:      "GATEWAY COMMUNICATIONS",
	[3]byte{0, 0, 98}:      "BULL HN INFORMATION SYSTEMS",
	[3]byte{0, 0, 99}:      "BARCO CONTROL ROOMS GMBH",
	[3]byte{0, 0, 100}:     "Yokogawa Electric Corporation",
	[3]byte{0, 0, 101}:     "Network General Corporation",
	[3]byte{0, 0, 102}:     "TALARIS SYSTEMS, INC.",
	[3]byte{0, 0, 103}:     "SOFT * RITE, INC.",
	[3]byte{0, 0, 104}:     "ROSEMOUNT CONTROLS",
	[3]byte{0, 0, 105}:     "CONCORD COMMUNICATIONS INC",
	[3]byte{0, 0, 106}:     "COMPUTER CONSOLES INC.",
	[3]byte{0, 0, 107}:     "SILICON GRAPHICS INC./MIPS",
	[3]byte{0, 0, 108}:     "PRIVATE",
	[3]byte{0, 0, 109}:     "CRAY COMMUNICATIONS, LTD.",
	[3]byte{0, 0, 110}:     "ARTISOFT, INC.",
	[3]byte{0, 0, 111}:     "Madge Ltd.",
	[3]byte{0, 0, 112}:     "HCL LIMITED",
	[3]byte{0, 0, 113}:     "ADRA SYSTEMS INC.",
	[3]byte{0, 0, 114}:     "MINIWARE TECHNOLOGY",
	[3]byte{0, 0, 115}:     "SIECOR CORPORATION",
	[3]byte{0, 0, 116}:     "RICOH COMPANY LTD.",
	[3]byte{0, 0, 117}:     "Nortel Networks",
	[3]byte{0, 0, 118}:     "ABEKAS VIDEO SYSTEM",
	[3]byte{0, 0, 119}:     "INTERPHASE CORPORATION",
	[3]byte{0, 0, 120}:     "LABTAM LIMITED",
	[3]byte{0, 0, 121}:     "NETWORTH INCORPORATED",
	[3]byte{0, 0, 122}:     "DANA COMPUTER INC.",
	[3]byte{0, 0, 123}:     "RESEARCH MACHINES",
	[3]byte{0, 0, 124}:     "AMPERE INCORPORATED",
	[3]byte{0, 0, 125}:     "Oracle Corporation",
	[3]byte{0, 0, 126}:     "CLUSTRIX CORPORATION",
	[3]byte{0, 0, 127}:     "LINOTYPE-HELL AG",
	[3]byte{0, 0, 128}:     "CRAY COMMUNICATIONS A/S",
	[3]byte{0, 0, 129}:     "BAY NETWORKS",
	[3]byte{0, 0, 130}:     "LECTRA SYSTEMES SA",
	[3]byte{0, 0, 131}:     "TADPOLE TECHNOLOGY PLC",
	[3]byte{0, 0, 132}:     "SUPERNET",
	[3]byte{0, 0, 133}:     "CANON INC.",
	[3]byte{0, 0, 134}:     "MEGAHERTZ CORPORATION",
	[3]byte{0, 0, 135}:     "HITACHI, LTD.",
	[3]byte{0, 0, 136}:     "Brocade Communications Systems, Inc.",
	[3]byte{0, 0, 137}:     "CAYMAN SYSTEMS INC.",
	[3]byte{0, 0, 138}:     "DATAHOUSE INFORMATION SYSTEMS",
	[3]byte{0, 0, 139}:     "INFOTRON",
	[3]byte{0, 0, 140}:     "Alloy Computer Products (Australia) Pty Ltd",
	[3]byte{0, 0, 141}:     "Cryptek Inc.",
	[3]byte{0, 0, 142}:     "SOLBOURNE COMPUTER, INC.",
	[3]byte{0, 0, 143}:     "Raytheon",
	[3]byte{0, 0, 144}:     "MICROCOM",
	[3]byte{0, 0, 145}:     "ANRITSU CORPORATION",
	[3]byte{0, 0, 146}:     "COGENT DATA TECHNOLOGIES",
	[3]byte{0, 0, 147}:     "PROTEON INC.",
	[3]byte{0, 0, 148}:     "ASANTE TECHNOLOGIES",
	[3]byte{0, 0, 149}:     "SONY TEKTRONIX CORP.",
	[3]byte{0, 0, 150}:     "MARCONI ELECTRONICS LTD.",
	[3]byte{0, 0, 151}:     "EMC Corporation",
	[3]byte{0, 0, 152}:     "CROSSCOMM CORPORATION",
	[3]byte{0, 0, 153}:     "MTX, INC.",
	[3]byte{0, 0, 154}:     "RC COMPUTER A/S",
	[3]byte{0, 0, 155}:     "INFORMATION INTERNATIONAL, INC",
	[3]byte{0, 0, 156}:     "ROLM MIL-SPEC COMPUTERS",
	[3]byte{0, 0, 157}:     "LOCUS COMPUTING CORPORATION",
	[3]byte{0, 0, 158}:     "MARLI S.A.",
	[3]byte{0, 0, 159}:     "AMERISTAR TECHNOLOGIES INC.",
	[3]byte{0, 0, 160}:     "SANYO Electric Co., Ltd.",
	[3]byte{0, 0, 161}:     "MARQUETTE ELECTRIC CO.",
	[3]byte{0, 0, 162}:     "BAY NETWORKS",
	[3]byte{0, 0, 163}:     "NETWORK APPLICATION TECHNOLOGY",
	[3]byte{0, 0, 164}:     "ACORN COMPUTERS LIMITED",
	[3]byte{0, 0, 165}:     "Tattile SRL",
	[3]byte{0, 0, 166}:     "NETWORK GENERAL CORPORATION",
	[3]byte{0, 0, 167}:     "NETWORK COMPUTING DEVICES INC.",
	[3]byte{0, 0, 168}:     "STRATUS COMPUTER INC.",
	[3]byte{0, 0, 169}:     "NETWORK SYSTEMS CORP.",
	[3]byte{0, 0, 170}:     "XEROX CORPORATION",
	[3]byte{0, 0, 171}:     "LOGIC MODELING CORPORATION",
	[3]byte{0, 0, 172}:     "CONWARE COMPUTER CONSULTING",
	[3]byte{0, 0, 173}:     "BRUKER INSTRUMENTS INC.",
	[3]byte{0, 0, 174}:     "DASSAULT ELECTRONIQUE",
	[3]byte{0, 0, 175}:     "NUCLEAR DATA INSTRUMENTATION",
	[3]byte{0, 0, 176}:     "RND-RAD NETWORK DEVICES",
	[3]byte{0, 0, 177}:     "ALPHA MICROSYSTEMS INC.",
	[3]byte{0, 0, 178}:     "TELEVIDEO SYSTEMS, INC.",
	[3]byte{0, 0, 179}:     "CIMLINC INCORPORATED",
	[3]byte{0, 0, 180}:     "EDIMAX COMPUTER COMPANY",
	[3]byte{0, 0, 181}:     "DATABILITY SOFTWARE SYS. INC.",
	[3]byte{0, 0, 182}:     "MICRO-MATIC RESEARCH",
	[3]byte{0, 0, 183}:     "DOVE COMPUTER CORPORATION",
	[3]byte{0, 0, 184}:     "SEIKOSHA CO., LTD.",
	[3]byte{0, 0, 185}:     "MCDONNELL DOUGLAS COMPUTER SYS",
	[3]byte{0, 0, 186}:     "SIIG, INC.",
	[3]byte{0, 0, 187}:     "TRI-DATA",
	[3]byte{0, 0, 188}:     "Rockwell Automation",
	[3]byte{0, 0, 189}:     "MITSUBISHI CABLE COMPANY",
	[3]byte{0, 0, 190}:     "THE NTI GROUP",
	[3]byte{0, 0, 191}:     "SYMMETRIC COMPUTER SYSTEMS",
	[3]byte{0, 0, 192}:     "WESTERN DIGITAL CORPORATION",
	[3]byte{0, 0, 193}:     "Madge Ltd.",
	[3]byte{0, 0, 194}:     "INFORMATION PRESENTATION TECH.",
	[3]byte{0, 0, 195}:     "HARRIS CORP COMPUTER SYS DIV",
	[3]byte{0, 0, 196}:     "WATERS DIV. OF MILLIPORE",
	[3]byte{0, 0, 197}:     "FARALLON COMPUTING/NETOPIA",
	[3]byte{0, 0, 198}:     "EON SYSTEMS",
	[3]byte{0, 0, 199}:     "ARIX CORPORATION",
	[3]byte{0, 0, 200}:     "ALTOS COMPUTER SYSTEMS",
	[3]byte{0, 0, 201}:     "Emulex Corporation",
	[3]byte{0, 0, 202}:     "ARRIS International",
	[3]byte{0, 0, 203}:     "COMPU-SHACK ELECTRONIC GMBH",
	[3]byte{0, 0, 204}:     "DENSAN CO., LTD.",
	[3]byte{0, 0, 205}:     "Allied Telesis Labs Ltd",
	[3]byte{0, 0, 206}:     "MEGADATA CORP.",
	[3]byte{0, 0, 207}:     "HAYES MICROCOMPUTER PRODUCTS",
	[3]byte{0, 0, 208}:     "DEVELCON ELECTRONICS LTD.",
	[3]byte{0, 0, 209}:     "ADAPTEC INCORPORATED",
	[3]byte{0, 0, 210}:     "SBE, INC.",
	[3]byte{0, 0, 211}:     "WANG LABORATORIES INC.",
	[3]byte{0, 0, 212}:     "PURE DATA LTD.",
	[3]byte{0, 0, 213}:     "MICROGNOSIS INTERNATIONAL",
	[3]byte{0, 0, 214}:     "PUNCH LINE HOLDING",
	[3]byte{0, 0, 215}:     "DARTMOUTH COLLEGE",
	[3]byte{0, 0, 216}:     "NOVELL, INC.",
	[3]byte{0, 0, 217}:     "NIPPON TELEGRAPH & TELEPHONE",
	[3]byte{0, 0, 218}:     "ATEX",
	[3]byte{0, 0, 219}:     "British Telecommunications plc",
	[3]byte{0, 0, 220}:     "HAYES MICROCOMPUTER PRODUCTS",
	[3]byte{0, 0, 221}:     "TCL INCORPORATED",
	[3]byte{0, 0, 222}:     "CETIA",
	[3]byte{0, 0, 223}:     "BELL & HOWELL PUB SYS DIV",
	[3]byte{0, 0, 224}:     "QUADRAM CORP.",
	[3]byte{0, 0, 225}:     "GRID SYSTEMS",
	[3]byte{0, 0, 226}:     "ACER TECHNOLOGIES CORP.",
	[3]byte{0, 0, 227}:     "INTEGRATED MICRO PRODUCTS LTD",
	[3]byte{0, 0, 228}:     "IN2 GROUPE INTERTECHNIQUE",
	[3]byte{0, 0, 229}:     "SIGMEX LTD.",
	[3]byte{0, 0, 230}:     "APTOR PRODUITS DE COMM INDUST",
	[3]byte{0, 0, 231}:     "STAR GATE TECHNOLOGIES",
	[3]byte{0, 0, 232}:     "ACCTON TECHNOLOGY CORP.",
	[3]byte{0, 0, 233}:     "ISICAD, INC.",
	[3]byte{0, 0, 234}:     "UPNOD AB",
	[3]byte{0, 0, 235}:     "MATSUSHITA COMM. IND. CO. LTD.",
	[3]byte{0, 0, 236}:     "MICROPROCESS",
	[3]byte{0, 0, 237}:     "APRIL",
	[3]byte{0, 0, 238}:     "NETWORK DESIGNERS, LTD.",
	[3]byte{0, 0, 239}:     "KTI",
	[3]byte{0, 0, 240}:     "SAMSUNG ELECTRONICS CO., LTD.",
	[3]byte{0, 0, 241}:     "MAGNA COMPUTER CORPORATION",
	[3]byte{0, 0, 242}:     "SPIDER COMMUNICATIONS",
	[3]byte{0, 0, 243}:     "GANDALF DATA LIMITED",
	[3]byte{0, 0, 244}:     "Allied Telesis",
	[3]byte{0, 0, 245}:     "DIAMOND SALES LIMITED",
	[3]byte{0, 0, 246}:     "APPLIED MICROSYSTEMS CORP.",
	[3]byte{0, 0, 247}:     "YOUTH KEEP ENTERPRISE CO LTD",
	[3]byte{0, 0, 248}:     "DIGITAL EQUIPMENT CORPORATION",
	[3]byte{0, 0, 249}:     "QUOTRON SYSTEMS INC.",
	[3]byte{0, 0, 250}:     "MICROSAGE COMPUTER SYSTEMS INC",
	[3]byte{0, 0, 251}:     "RECHNER ZUR KOMMUNIKATION",
	[3]byte{0, 0, 252}:     "MEIKO",
	[3]byte{0, 0, 253}:     "HIGH LEVEL HARDWARE",
	[3]byte{0, 0, 254}:     "ANNAPOLIS MICRO SYSTEMS",
	[3]byte{0, 0, 255}:     "CAMTEC ELECTRONICS LTD.",
	[3]byte{0, 1, 0}:       "EQUIP'TRANS",
	[3]byte{0, 1, 1}:       "PRIVATE",
	[3]byte{0, 1, 2}:       "3COM CORPORATION",
	[3]byte{0, 1, 3}:       "3COM CORPORATION",
	[3]byte{0, 1, 4}:       "DVICO Co., Ltd.",
	[3]byte{0, 1, 5}:       "Beckhoff Automation GmbH",
	[3]byte{0, 1, 6}:       "Tews Datentechnik GmbH",
	[3]byte{0, 1, 7}:       "Leiser GmbH",
	[3]byte{0, 1, 8}:       "AVLAB Technology, Inc.",
	[3]byte{0, 1, 9}:       "Nagano Japan Radio Co., Ltd.",
	[3]byte{0, 1, 10}:      "CIS TECHNOLOGY INC.",
	[3]byte{0, 1, 11}:      "Space CyberLink, Inc.",
	[3]byte{0, 1, 12}:      "System Talks Inc.",
	[3]byte{0, 1, 13}:      "CORECO, INC.",
	[3]byte{0, 1, 14}:      "Bri-Link Technologies Co., Ltd",
	[3]byte{0, 1, 15}:      "Brocade Communications Systems, Inc.",
	[3]byte{0, 1, 16}:      "Gotham Networks",
	[3]byte{0, 1, 17}:      "iDigm Inc.",
	[3]byte{0, 1, 18}:      "Shark Multimedia Inc.",
	[3]byte{0, 1, 19}:      "OLYMPUS CORPORATION",
	[3]byte{0, 1, 20}:      "KANDA TSUSHIN KOGYO CO., LTD.",
	[3]byte{0, 1, 21}:      "EXTRATECH CORPORATION",
	[3]byte{0, 1, 22}:      "Netspect Technologies, Inc.",
	[3]byte{0, 1, 23}:      "CANAL +",
	[3]byte{0, 1, 24}:      "EZ Digital Co., Ltd.",
	[3]byte{0, 1, 25}:      "RTUnet (Australia)",
	[3]byte{0, 1, 26}:      "Hoffmann und Burmeister GbR",
	[3]byte{0, 1, 27}:      "Unizone Technologies, Inc.",
	[3]byte{0, 1, 28}:      "Universal Talkware Corporation",
	[3]byte{0, 1, 29}:      "Centillium Communications",
	[3]byte{0, 1, 30}:      "Precidia Technologies, Inc.",
	[3]byte{0, 1, 31}:      "RC Networks, Inc.",
	[3]byte{0, 1, 32}:      "OSCILLOQUARTZ S.A.",
	[3]byte{0, 1, 33}:      "Watchguard Technologies, Inc.",
	[3]byte{0, 1, 34}:      "Trend Communications, Ltd.",
	[3]byte{0, 1, 35}:      "DIGITAL ELECTRONICS CORP.",
	[3]byte{0, 1, 36}:      "Acer Incorporated",
	[3]byte{0, 1, 37}:      "YAESU MUSEN CO., LTD.",
	[3]byte{0, 1, 38}:      "PAC Labs",
	[3]byte{0, 1, 39}:      "OPEN Networks Pty Ltd",
	[3]byte{0, 1, 40}:      "EnjoyWeb, Inc.",
	[3]byte{0, 1, 41}:      "DFI Inc.",
	[3]byte{0, 1, 42}:      "Telematica Sistems Inteligente",
	[3]byte{0, 1, 43}:      "TELENET Co., Ltd.",
	[3]byte{0, 1, 44}:      "Aravox Technologies, Inc.",
	[3]byte{0, 1, 45}:      "Komodo Technology",
	[3]byte{0, 1, 46}:      "PC Partner Ltd.",
	[3]byte{0, 1, 47}:      "Twinhead International Corp",
	[3]byte{0, 1, 48}:      "Extreme Networks",
	[3]byte{0, 1, 49}:      "Bosch Security Systems, Inc.",
	[3]byte{0, 1, 50}:      "Dranetz - BMI",
	[3]byte{0, 1, 51}:      "KYOWA Electronic Instruments C",
	[3]byte{0, 1, 52}:      "Selectron Systems AG",
	[3]byte{0, 1, 53}:      "KDC Corp.",
	[3]byte{0, 1, 54}:      "CyberTAN Technology, Inc.",
	[3]byte{0, 1, 55}:      "IT Farm Corporation",
	[3]byte{0, 1, 56}:      "XAVi Technologies Corp.",
	[3]byte{0, 1, 57}:      "Point Multimedia Systems",
	[3]byte{0, 1, 58}:      "SHELCAD COMMUNICATIONS, LTD.",
	[3]byte{0, 1, 59}:      "BNA SYSTEMS",
	[3]byte{0, 1, 60}:      "TIW SYSTEMS",
	[3]byte{0, 1, 61}:      "RiscStation Ltd.",
	[3]byte{0, 1, 62}:      "Ascom Tateco AB",
	[3]byte{0, 1, 63}:      "Neighbor World Co., Ltd.",
	[3]byte{0, 1, 64}:      "Sendtek Corporation",
	[3]byte{0, 1, 65}:      "CABLE PRINT",
	[3]byte{0, 1, 66}:      "CISCO SYSTEMS, INC.",
	[3]byte{0, 1, 67}:      "CISCO SYSTEMS, INC.",
	[3]byte{0, 1, 68}:      "EMC Corporation",
	[3]byte{0, 1, 69}:      "WINSYSTEMS, INC.",
	[3]byte{0, 1, 70}:      "Tesco Controls, Inc.",
	[3]byte{0, 1, 71}:      "Zhone Technologies",
	[3]byte{0, 1, 72}:      "X-traWeb Inc.",
	[3]byte{0, 1, 73}:      "T.D.T. Transfer Data Test GmbH",
	[3]byte{0, 1, 74}:      "Sony Corporation",
	[3]byte{0, 1, 75}:      "Ennovate Networks, Inc.",
	[3]byte{0, 1, 76}:      "Berkeley Process Control",
	[3]byte{0, 1, 77}:      "Shin Kin Enterprises Co., Ltd",
	[3]byte{0, 1, 78}:      "WIN Enterprises, Inc.",
	[3]byte{0, 1, 79}:      "ADTRAN INC",
	[3]byte{0, 1, 80}:      "GILAT COMMUNICATIONS, LTD.",
	[3]byte{0, 1, 81}:      "Ensemble Communications",
	[3]byte{0, 1, 82}:      "CHROMATEK INC.",
	[3]byte{0, 1, 83}:      "ARCHTEK TELECOM CORPORATION",
	[3]byte{0, 1, 84}:      "G3M Corporation",
	[3]byte{0, 1, 85}:      "Promise Technology, Inc.",
	[3]byte{0, 1, 86}:      "FIREWIREDIRECT.COM, INC.",
	[3]byte{0, 1, 87}:      "SYSWAVE CO., LTD",
	[3]byte{0, 1, 88}:      "Electro Industries/Gauge Tech",
	[3]byte{0, 1, 89}:      "S1 Corporation",
	[3]byte{0, 1, 90}:      "Digital Video Broadcasting",
	[3]byte{0, 1, 91}:      "ITALTEL S.p.A/RF-UP-I",
	[3]byte{0, 1, 92}:      "CADANT INC.",
	[3]byte{0, 1, 93}:      "Oracle Corporation",
	[3]byte{0, 1, 94}:      "BEST TECHNOLOGY CO., LTD.",
	[3]byte{0, 1, 95}:      "DIGITAL DESIGN GmbH",
	[3]byte{0, 1, 96}:      "ELMEX Co., LTD.",
	[3]byte{0, 1, 97}:      "Meta Machine Technology",
	[3]byte{0, 1, 98}:      "Cygnet Technologies, Inc.",
	[3]byte{0, 1, 99}:      "CISCO SYSTEMS, INC.",
	[3]byte{0, 1, 100}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 1, 101}:     "AirSwitch Corporation",
	[3]byte{0, 1, 102}:     "TC GROUP A/S",
	[3]byte{0, 1, 103}:     "HIOKI E.E. CORPORATION",
	[3]byte{0, 1, 104}:     "VITANA CORPORATION",
	[3]byte{0, 1, 105}:     "Celestix Networks Pte Ltd.",
	[3]byte{0, 1, 106}:     "ALITEC",
	[3]byte{0, 1, 107}:     "LightChip, Inc.",
	[3]byte{0, 1, 108}:     "FOXCONN",
	[3]byte{0, 1, 109}:     "CarrierComm Inc.",
	[3]byte{0, 1, 110}:     "Conklin Corporation",
	[3]byte{0, 1, 111}:     "Inkel Corp.",
	[3]byte{0, 1, 112}:     "ESE Embedded System Engineer'g",
	[3]byte{0, 1, 113}:     "Allied Data Technologies",
	[3]byte{0, 1, 114}:     "TechnoLand Co., LTD.",
	[3]byte{0, 1, 115}:     "AMCC",
	[3]byte{0, 1, 116}:     "CyberOptics Corporation",
	[3]byte{0, 1, 117}:     "Radiant Communications Corp.",
	[3]byte{0, 1, 118}:     "Orient Silver Enterprises",
	[3]byte{0, 1, 119}:     "EDSL",
	[3]byte{0, 1, 120}:     "MARGI Systems, Inc.",
	[3]byte{0, 1, 121}:     "WIRELESS TECHNOLOGY, INC.",
	[3]byte{0, 1, 122}:     "Chengdu Maipu Electric Industrial Co., Ltd.",
	[3]byte{0, 1, 123}:     "Heidelberger Druckmaschinen AG",
	[3]byte{0, 1, 124}:     "AG-E GmbH",
	[3]byte{0, 1, 125}:     "ThermoQuest",
	[3]byte{0, 1, 126}:     "ADTEK System Science Co., Ltd.",
	[3]byte{0, 1, 127}:     "Experience Music Project",
	[3]byte{0, 1, 128}:     "AOpen, Inc.",
	[3]byte{0, 1, 129}:     "Nortel Networks",
	[3]byte{0, 1, 130}:     "DICA TECHNOLOGIES AG",
	[3]byte{0, 1, 131}:     "ANITE TELECOMS",
	[3]byte{0, 1, 132}:     "SIEB & MEYER AG",
	[3]byte{0, 1, 133}:     "Hitachi Aloka Medical, Ltd.",
	[3]byte{0, 1, 134}:     "Uwe Disch",
	[3]byte{0, 1, 135}:     "I2SE GmbH",
	[3]byte{0, 1, 136}:     "LXCO Technologies ag",
	[3]byte{0, 1, 137}:     "Refraction Technology, Inc.",
	[3]byte{0, 1, 138}:     "ROI COMPUTER AG",
	[3]byte{0, 1, 139}:     "NetLinks Co., Ltd.",
	[3]byte{0, 1, 140}:     "Mega Vision",
	[3]byte{0, 1, 141}:     "AudeSi Technologies",
	[3]byte{0, 1, 142}:     "Logitec Corporation",
	[3]byte{0, 1, 143}:     "Kenetec, Inc.",
	[3]byte{0, 1, 144}:     "SMK-M",
	[3]byte{0, 1, 145}:     "SYRED Data Systems",
	[3]byte{0, 1, 146}:     "Texas Digital Systems",
	[3]byte{0, 1, 147}:     "Hanbyul Telecom Co., Ltd.",
	[3]byte{0, 1, 148}:     "Capital Equipment Corporation",
	[3]byte{0, 1, 149}:     "Sena Technologies, Inc.",
	[3]byte{0, 1, 150}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 1, 151}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 1, 152}:     "Darim Vision",
	[3]byte{0, 1, 153}:     "HeiSei Electronics",
	[3]byte{0, 1, 154}:     "LEUNIG GmbH",
	[3]byte{0, 1, 155}:     "Kyoto Microcomputer Co., Ltd.",
	[3]byte{0, 1, 156}:     "JDS Uniphase Inc.",
	[3]byte{0, 1, 157}:     "E-Control Systems, Inc.",
	[3]byte{0, 1, 158}:     "ESS Technology, Inc.",
	[3]byte{0, 1, 159}:     "ReadyNet",
	[3]byte{0, 1, 160}:     "Infinilink Corporation",
	[3]byte{0, 1, 161}:     "Mag-Tek, Inc.",
	[3]byte{0, 1, 162}:     "Logical Co., Ltd.",
	[3]byte{0, 1, 163}:     "GENESYS LOGIC, INC.",
	[3]byte{0, 1, 164}:     "Microlink Corporation",
	[3]byte{0, 1, 165}:     "Nextcomm, Inc.",
	[3]byte{0, 1, 166}:     "Scientific-Atlanta Arcodan A/S",
	[3]byte{0, 1, 167}:     "UNEX TECHNOLOGY CORPORATION",
	[3]byte{0, 1, 168}:     "Welltech Computer Co., Ltd.",
	[3]byte{0, 1, 169}:     "BMW AG",
	[3]byte{0, 1, 170}:     "Airspan Communications, Ltd.",
	[3]byte{0, 1, 171}:     "Main Street Networks",
	[3]byte{0, 1, 172}:     "Sitara Networks, Inc.",
	[3]byte{0, 1, 173}:     "Coach Master International  d.b.a. CMI Worldwide, Inc.",
	[3]byte{0, 1, 174}:     "Trex Enterprises",
	[3]byte{0, 1, 175}:     "Artesyn Embedded Technologies",
	[3]byte{0, 1, 176}:     "Fulltek Technology Co., Ltd.",
	[3]byte{0, 1, 177}:     "General Bandwidth",
	[3]byte{0, 1, 178}:     "Digital Processing Systems, Inc.",
	[3]byte{0, 1, 179}:     "Precision Electronic Manufacturing",
	[3]byte{0, 1, 180}:     "Wayport, Inc.",
	[3]byte{0, 1, 181}:     "Turin Networks, Inc.",
	[3]byte{0, 1, 182}:     "SAEJIN T&M Co., Ltd.",
	[3]byte{0, 1, 183}:     "Centos, Inc.",
	[3]byte{0, 1, 184}:     "Netsensity, Inc.",
	[3]byte{0, 1, 185}:     "SKF Condition Monitoring",
	[3]byte{0, 1, 186}:     "IC-Net, Inc.",
	[3]byte{0, 1, 187}:     "Frequentis",
	[3]byte{0, 1, 188}:     "Brains Corporation",
	[3]byte{0, 1, 189}:     "Peterson Electro-Musical Products, Inc.",
	[3]byte{0, 1, 190}:     "Gigalink Co., Ltd.",
	[3]byte{0, 1, 191}:     "Teleforce Co., Ltd.",
	[3]byte{0, 1, 192}:     "CompuLab, Ltd.",
	[3]byte{0, 1, 193}:     "Vitesse Semiconductor Corporation",
	[3]byte{0, 1, 194}:     "ARK Research Corp.",
	[3]byte{0, 1, 195}:     "Acromag, Inc.",
	[3]byte{0, 1, 196}:     "NeoWave, Inc.",
	[3]byte{0, 1, 197}:     "Simpler Networks",
	[3]byte{0, 1, 198}:     "Quarry Technologies",
	[3]byte{0, 1, 199}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 1, 200}:     "THOMAS CONRAD CORP.",
	[3]byte{0, 1, 200}:     "CONRAD CORP.",
	[3]byte{0, 1, 201}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 1, 202}:     "Geocast Network Systems, Inc.",
	[3]byte{0, 1, 203}:     "EVR",
	[3]byte{0, 1, 204}:     "Japan Total Design Communication Co., Ltd.",
	[3]byte{0, 1, 205}:     "ARtem",
	[3]byte{0, 1, 206}:     "Custom Micro Products, Ltd.",
	[3]byte{0, 1, 207}:     "Alpha Data Parallel Systems, Ltd.",
	[3]byte{0, 1, 208}:     "VitalPoint, Inc.",
	[3]byte{0, 1, 209}:     "CoNet Communications, Inc.",
	[3]byte{0, 1, 210}:     "inXtron, Inc.",
	[3]byte{0, 1, 211}:     "PAXCOMM, Inc.",
	[3]byte{0, 1, 212}:     "Leisure Time, Inc.",
	[3]byte{0, 1, 213}:     "HAEDONG INFO & COMM CO., LTD",
	[3]byte{0, 1, 214}:     "manroland AG",
	[3]byte{0, 1, 215}:     "F5 Networks, Inc.",
	[3]byte{0, 1, 216}:     "Teltronics, Inc.",
	[3]byte{0, 1, 217}:     "Sigma, Inc.",
	[3]byte{0, 1, 218}:     "WINCOMM Corporation",
	[3]byte{0, 1, 219}:     "Freecom Technologies GmbH",
	[3]byte{0, 1, 220}:     "Activetelco",
	[3]byte{0, 1, 221}:     "Avail Networks",
	[3]byte{0, 1, 222}:     "Trango Systems, Inc.",
	[3]byte{0, 1, 223}:     "ISDN Communications, Ltd.",
	[3]byte{0, 1, 224}:     "Fast Systems, Inc.",
	[3]byte{0, 1, 225}:     "Kinpo Electronics, Inc.",
	[3]byte{0, 1, 226}:     "Ando Electric Corporation",
	[3]byte{0, 1, 227}:     "Siemens AG",
	[3]byte{0, 1, 228}:     "Sitera, Inc.",
	[3]byte{0, 1, 229}:     "Supernet, Inc.",
	[3]byte{0, 1, 230}:     "Hewlett-Packard Company",
	[3]byte{0, 1, 231}:     "Hewlett-Packard Company",
	[3]byte{0, 1, 232}:     "Force10 Networks, Inc.",
	[3]byte{0, 1, 233}:     "Litton Marine Systems B.V.",
	[3]byte{0, 1, 234}:     "Cirilium Corp.",
	[3]byte{0, 1, 235}:     "C-COM Corporation",
	[3]byte{0, 1, 236}:     "Ericsson Group",
	[3]byte{0, 1, 237}:     "SETA Corp.",
	[3]byte{0, 1, 238}:     "Comtrol Europe, Ltd.",
	[3]byte{0, 1, 239}:     "Camtel Technology Corp.",
	[3]byte{0, 1, 240}:     "Tridium, Inc.",
	[3]byte{0, 1, 241}:     "Innovative Concepts, Inc.",
	[3]byte{0, 1, 242}:     "Mark of the Unicorn, Inc.",
	[3]byte{0, 1, 243}:     "QPS, Inc.",
	[3]byte{0, 1, 244}:     "Enterasys Networks",
	[3]byte{0, 1, 245}:     "ERIM S.A.",
	[3]byte{0, 1, 246}:     "Association of Musical Electronics Industry",
	[3]byte{0, 1, 247}:     "Image Display Systems, Inc.",
	[3]byte{0, 1, 248}:     "Texio Technology Corporation",
	[3]byte{0, 1, 249}:     "TeraGlobal Communications Corp.",
	[3]byte{0, 1, 250}:     "HOROSCAS",
	[3]byte{0, 1, 251}:     "DoTop Technology, Inc.",
	[3]byte{0, 1, 252}:     "Keyence Corporation",
	[3]byte{0, 1, 253}:     "Digital Voice Systems, Inc.",
	[3]byte{0, 1, 254}:     "DIGITAL EQUIPMENT CORPORATION",
	[3]byte{0, 1, 255}:     "Data Direct Networks, Inc.",
	[3]byte{0, 2, 0}:       "Net & Sys Co., Ltd.",
	[3]byte{0, 2, 1}:       "IFM Electronic gmbh",
	[3]byte{0, 2, 2}:       "Amino Communications, Ltd.",
	[3]byte{0, 2, 3}:       "Woonsang Telecom, Inc.",
	[3]byte{0, 2, 4}:       "Bodmann Industries Elektronik GmbH",
	[3]byte{0, 2, 5}:       "Hitachi Denshi, Ltd.",
	[3]byte{0, 2, 6}:       "Telital R&D Denmark A/S",
	[3]byte{0, 2, 7}:       "VisionGlobal Network Corp.",
	[3]byte{0, 2, 8}:       "Unify Networks, Inc.",
	[3]byte{0, 2, 9}:       "Shenzhen SED Information Technology Co., Ltd.",
	[3]byte{0, 2, 10}:      "Gefran Spa",
	[3]byte{0, 2, 11}:      "Native Networks, Inc.",
	[3]byte{0, 2, 12}:      "Metro-Optix",
	[3]byte{0, 2, 13}:      "Micronpc.com",
	[3]byte{0, 2, 14}:      "ECI Telecom, Ltd",
	[3]byte{0, 2, 15}:      "AATR",
	[3]byte{0, 2, 16}:      "Fenecom",
	[3]byte{0, 2, 17}:      "Nature Worldwide Technology Corp.",
	[3]byte{0, 2, 18}:      "SierraCom",
	[3]byte{0, 2, 19}:      "S.D.E.L.",
	[3]byte{0, 2, 20}:      "DTVRO",
	[3]byte{0, 2, 21}:      "Cotas Computer Technology A/B",
	[3]byte{0, 2, 22}:      "CISCO SYSTEMS, INC.",
	[3]byte{0, 2, 23}:      "CISCO SYSTEMS, INC.",
	[3]byte{0, 2, 24}:      "Advanced Scientific Corp",
	[3]byte{0, 2, 25}:      "Paralon Technologies",
	[3]byte{0, 2, 26}:      "Zuma Networks",
	[3]byte{0, 2, 27}:      "Kollmorgen-Servotronix",
	[3]byte{0, 2, 28}:      "Network Elements, Inc.",
	[3]byte{0, 2, 29}:      "Data General Communication Ltd.",
	[3]byte{0, 2, 30}:      "SIMTEL S.R.L.",
	[3]byte{0, 2, 31}:      "Aculab PLC",
	[3]byte{0, 2, 32}:      "CANON FINETECH INC.",
	[3]byte{0, 2, 33}:      "DSP Application, Ltd.",
	[3]byte{0, 2, 34}:      "Chromisys, Inc.",
	[3]byte{0, 2, 35}:      "ClickTV",
	[3]byte{0, 2, 36}:      "C-COR",
	[3]byte{0, 2, 37}:      "One Stop Systems",
	[3]byte{0, 2, 38}:      "XESystems, Inc.",
	[3]byte{0, 2, 39}:      "ESD Electronic System Design GmbH",
	[3]byte{0, 2, 40}:      "Necsom, Ltd.",
	[3]byte{0, 2, 41}:      "Adtec Corporation",
	[3]byte{0, 2, 42}:      "Asound Electronic",
	[3]byte{0, 2, 43}:      "SAXA, Inc.",
	[3]byte{0, 2, 44}:      "ABB Bomem, Inc.",
	[3]byte{0, 2, 45}:      "Agere Systems",
	[3]byte{0, 2, 46}:      "TEAC Corp. R& D",
	[3]byte{0, 2, 47}:      "P-Cube, Ltd.",
	[3]byte{0, 2, 48}:      "Intersoft Electronics",
	[3]byte{0, 2, 49}:      "Ingersoll-Rand",
	[3]byte{0, 2, 50}:      "Avision, Inc.",
	[3]byte{0, 2, 51}:      "Mantra Communications, Inc.",
	[3]byte{0, 2, 52}:      "Imperial Technology, Inc.",
	[3]byte{0, 2, 53}:      "Paragon Networks International",
	[3]byte{0, 2, 54}:      "INIT GmbH",
	[3]byte{0, 2, 55}:      "Cosmo Research Corp.",
	[3]byte{0, 2, 56}:      "Serome Technology, Inc.",
	[3]byte{0, 2, 57}:      "Visicom",
	[3]byte{0, 2, 58}:      "ZSK Stickmaschinen GmbH",
	[3]byte{0, 2, 59}:      "Ericsson",
	[3]byte{0, 2, 60}:      "Creative Technology, Ltd.",
	[3]byte{0, 2, 61}:      "Cisco Systems, Inc.",
	[3]byte{0, 2, 62}:      "Selta Telematica S.p.a",
	[3]byte{0, 2, 63}:      "Compal Electronics, Inc.",
	[3]byte{0, 2, 64}:      "Seedek Co., Ltd.",
	[3]byte{0, 2, 65}:      "Amer.com",
	[3]byte{0, 2, 66}:      "Videoframe Systems",
	[3]byte{0, 2, 67}:      "Raysis Co., Ltd.",
	[3]byte{0, 2, 68}:      "SURECOM Technology Co.",
	[3]byte{0, 2, 69}:      "Lampus Co, Ltd.",
	[3]byte{0, 2, 70}:      "All-Win Tech Co., Ltd.",
	[3]byte{0, 2, 71}:      "Great Dragon Information Technology (Group) Co., Ltd.",
	[3]byte{0, 2, 72}:      "Pilz GmbH & Co.",
	[3]byte{0, 2, 73}:      "Aviv Infocom Co, Ltd.",
	[3]byte{0, 2, 74}:      "CISCO SYSTEMS, INC.",
	[3]byte{0, 2, 75}:      "CISCO SYSTEMS, INC.",
	[3]byte{0, 2, 76}:      "SiByte, Inc.",
	[3]byte{0, 2, 77}:      "Mannesman Dematic Colby Pty. Ltd.",
	[3]byte{0, 2, 78}:      "Datacard Group",
	[3]byte{0, 2, 79}:      "IPM Datacom S.R.L.",
	[3]byte{0, 2, 80}:      "Geyser Networks, Inc.",
	[3]byte{0, 2, 81}:      "Soma Networks, Inc.",
	[3]byte{0, 2, 82}:      "Carrier Corporation",
	[3]byte{0, 2, 83}:      "Televideo, Inc.",
	[3]byte{0, 2, 84}:      "WorldGate",
	[3]byte{0, 2, 85}:      "IBM Corp",
	[3]byte{0, 2, 86}:      "Alpha Processor, Inc.",
	[3]byte{0, 2, 87}:      "Microcom Corp.",
	[3]byte{0, 2, 88}:      "Flying Packets Communications",
	[3]byte{0, 2, 89}:      "Tsann Kuen China (Shanghai)Enterprise Co., Ltd. IT Group",
	[3]byte{0, 2, 90}:      "Catena Networks",
	[3]byte{0, 2, 91}:      "Cambridge Silicon Radio",
	[3]byte{0, 2, 92}:      "SCI Systems (Kunshan) Co., Ltd.",
	[3]byte{0, 2, 93}:      "Calix Networks",
	[3]byte{0, 2, 94}:      "High Technology Ltd",
	[3]byte{0, 2, 95}:      "Nortel Networks",
	[3]byte{0, 2, 96}:      "Accordion Networks, Inc.",
	[3]byte{0, 2, 97}:      "Tilgin AB",
	[3]byte{0, 2, 98}:      "Soyo Group Soyo Com Tech Co., Ltd",
	[3]byte{0, 2, 99}:      "UPS Manufacturing SRL",
	[3]byte{0, 2, 100}:     "AudioRamp.com",
	[3]byte{0, 2, 101}:     "Virditech Co. Ltd.",
	[3]byte{0, 2, 102}:     "Thermalogic Corporation",
	[3]byte{0, 2, 103}:     "NODE RUNNER, INC.",
	[3]byte{0, 2, 104}:     "Harris Government Communications",
	[3]byte{0, 2, 105}:     "Nadatel Co., Ltd",
	[3]byte{0, 2, 106}:     "Cocess Telecom Co., Ltd.",
	[3]byte{0, 2, 107}:     "BCM Computers Co., Ltd.",
	[3]byte{0, 2, 108}:     "Philips CFT",
	[3]byte{0, 2, 109}:     "Adept Telecom",
	[3]byte{0, 2, 110}:     "NeGeN Access, Inc.",
	[3]byte{0, 2, 111}:     "Senao International Co., Ltd.",
	[3]byte{0, 2, 112}:     "Crewave Co., Ltd.",
	[3]byte{0, 2, 113}:     "Zhone Technologies",
	[3]byte{0, 2, 114}:     "CC&C Technologies, Inc.",
	[3]byte{0, 2, 115}:     "Coriolis Networks",
	[3]byte{0, 2, 116}:     "Tommy Technologies Corp.",
	[3]byte{0, 2, 117}:     "SMART Technologies, Inc.",
	[3]byte{0, 2, 118}:     "Primax Electronics Ltd.",
	[3]byte{0, 2, 119}:     "Cash Systemes Industrie",
	[3]byte{0, 2, 120}:     "Samsung Electro-Mechanics Co., Ltd.",
	[3]byte{0, 2, 121}:     "Control Applications, Ltd.",
	[3]byte{0, 2, 122}:     "IOI Technology Corporation",
	[3]byte{0, 2, 123}:     "Amplify Net, Inc.",
	[3]byte{0, 2, 124}:     "Trilithic, Inc.",
	[3]byte{0, 2, 125}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 2, 126}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 2, 127}:     "ask-technologies.com",
	[3]byte{0, 2, 128}:     "Mu Net, Inc.",
	[3]byte{0, 2, 129}:     "Madge Ltd.",
	[3]byte{0, 2, 130}:     "ViaClix, Inc.",
	[3]byte{0, 2, 131}:     "Spectrum Controls, Inc.",
	[3]byte{0, 2, 132}:     "AREVA T&D",
	[3]byte{0, 2, 133}:     "Riverstone Networks",
	[3]byte{0, 2, 134}:     "Occam Networks",
	[3]byte{0, 2, 135}:     "Adapcom",
	[3]byte{0, 2, 136}:     "GLOBAL VILLAGE COMMUNICATION",
	[3]byte{0, 2, 137}:     "DNE Technologies",
	[3]byte{0, 2, 138}:     "Ambit Microsystems Corporation",
	[3]byte{0, 2, 139}:     "VDSL Systems OY",
	[3]byte{0, 2, 140}:     "Micrel-Synergy Semiconductor",
	[3]byte{0, 2, 141}:     "Movita Technologies, Inc.",
	[3]byte{0, 2, 142}:     "Rapid 5 Networks, Inc.",
	[3]byte{0, 2, 143}:     "Globetek, Inc.",
	[3]byte{0, 2, 144}:     "Woorigisool, Inc.",
	[3]byte{0, 2, 145}:     "Open Network Co., Ltd.",
	[3]byte{0, 2, 146}:     "Logic Innovations, Inc.",
	[3]byte{0, 2, 147}:     "Solid Data Systems",
	[3]byte{0, 2, 148}:     "Tokyo Sokushin Co., Ltd.",
	[3]byte{0, 2, 149}:     "IP.Access Limited",
	[3]byte{0, 2, 150}:     "Lectron Co,. Ltd.",
	[3]byte{0, 2, 151}:     "C-COR.net",
	[3]byte{0, 2, 152}:     "Broadframe Corporation",
	[3]byte{0, 2, 153}:     "Apex, Inc.",
	[3]byte{0, 2, 154}:     "Storage Apps",
	[3]byte{0, 2, 155}:     "Kreatel Communications AB",
	[3]byte{0, 2, 156}:     "3COM",
	[3]byte{0, 2, 157}:     "Merix Corp.",
	[3]byte{0, 2, 158}:     "Information Equipment Co., Ltd.",
	[3]byte{0, 2, 159}:     "L-3 Communication Aviation Recorders",
	[3]byte{0, 2, 160}:     "Flatstack Ltd.",
	[3]byte{0, 2, 161}:     "World Wide Packets",
	[3]byte{0, 2, 162}:     "Hilscher GmbH",
	[3]byte{0, 2, 163}:     "ABB Switzerland Ltd, Power Systems",
	[3]byte{0, 2, 164}:     "AddPac Technology Co., Ltd.",
	[3]byte{0, 2, 165}:     "Hewlett-Packard Company",
	[3]byte{0, 2, 166}:     "Effinet Systems Co., Ltd.",
	[3]byte{0, 2, 167}:     "Vivace Networks",
	[3]byte{0, 2, 168}:     "Air Link Technology",
	[3]byte{0, 2, 169}:     "RACOM, s.r.o.",
	[3]byte{0, 2, 170}:     "PLcom Co., Ltd.",
	[3]byte{0, 2, 171}:     "CTC Union Technologies Co., Ltd.",
	[3]byte{0, 2, 172}:     "3PAR data",
	[3]byte{0, 2, 173}:     "HOYA Corporation",
	[3]byte{0, 2, 174}:     "Scannex Electronics Ltd.",
	[3]byte{0, 2, 175}:     "TeleCruz Technology, Inc.",
	[3]byte{0, 2, 176}:     "Hokubu Communication & Industrial Co., Ltd.",
	[3]byte{0, 2, 177}:     "Anritsu, Ltd.",
	[3]byte{0, 2, 178}:     "Cablevision",
	[3]byte{0, 2, 179}:     "Intel Corporation",
	[3]byte{0, 2, 180}:     "DAPHNE",
	[3]byte{0, 2, 181}:     "Avnet, Inc.",
	[3]byte{0, 2, 182}:     "Acrosser Technology Co., Ltd.",
	[3]byte{0, 2, 183}:     "Watanabe Electric Industry Co., Ltd.",
	[3]byte{0, 2, 184}:     "WHI KONSULT AB",
	[3]byte{0, 2, 185}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 2, 186}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 2, 187}:     "Continuous Computing Corp",
	[3]byte{0, 2, 188}:     "LVL 7 Systems, Inc.",
	[3]byte{0, 2, 189}:     "Bionet Co., Ltd.",
	[3]byte{0, 2, 190}:     "Totsu Engineering, Inc.",
	[3]byte{0, 2, 191}:     "dotRocket, Inc.",
	[3]byte{0, 2, 192}:     "Bencent Tzeng Industry Co., Ltd.",
	[3]byte{0, 2, 193}:     "Innovative Electronic Designs, Inc.",
	[3]byte{0, 2, 194}:     "Net Vision Telecom",
	[3]byte{0, 2, 195}:     "Arelnet Ltd.",
	[3]byte{0, 2, 196}:     "Vector International BVBA",
	[3]byte{0, 2, 197}:     "Evertz Microsystems Ltd.",
	[3]byte{0, 2, 198}:     "Data Track Technology PLC",
	[3]byte{0, 2, 199}:     "ALPS ELECTRIC Co., Ltd.",
	[3]byte{0, 2, 200}:     "Technocom Communications Technology (pte) Ltd",
	[3]byte{0, 2, 201}:     "Mellanox Technologies",
	[3]byte{0, 2, 202}:     "EndPoints, Inc.",
	[3]byte{0, 2, 203}:     "TriState Ltd.",
	[3]byte{0, 2, 204}:     "M.C.C.I",
	[3]byte{0, 2, 205}:     "TeleDream, Inc.",
	[3]byte{0, 2, 206}:     "FoxJet, Inc.",
	[3]byte{0, 2, 207}:     "ZyGate Communications, Inc.",
	[3]byte{0, 2, 208}:     "Comdial Corporation",
	[3]byte{0, 2, 209}:     "Vivotek, Inc.",
	[3]byte{0, 2, 210}:     "Workstation AG",
	[3]byte{0, 2, 211}:     "NetBotz, Inc.",
	[3]byte{0, 2, 212}:     "PDA Peripherals, Inc.",
	[3]byte{0, 2, 213}:     "ACR",
	[3]byte{0, 2, 214}:     "NICE Systems",
	[3]byte{0, 2, 215}:     "EMPEG Ltd",
	[3]byte{0, 2, 216}:     "BRECIS Communications Corporation",
	[3]byte{0, 2, 217}:     "Reliable Controls",
	[3]byte{0, 2, 218}:     "ExiO Communications, Inc.",
	[3]byte{0, 2, 219}:     "NETSEC",
	[3]byte{0, 2, 220}:     "Fujitsu General Limited",
	[3]byte{0, 2, 221}:     "Bromax Communications, Ltd.",
	[3]byte{0, 2, 222}:     "Astrodesign, Inc.",
	[3]byte{0, 2, 223}:     "Net Com Systems, Inc.",
	[3]byte{0, 2, 224}:     "ETAS GmbH",
	[3]byte{0, 2, 225}:     "Integrated Network Corporation",
	[3]byte{0, 2, 226}:     "NDC Infared Engineering",
	[3]byte{0, 2, 227}:     "LITE-ON Communications, Inc.",
	[3]byte{0, 2, 228}:     "JC HYUN Systems, Inc.",
	[3]byte{0, 2, 229}:     "Timeware Ltd.",
	[3]byte{0, 2, 230}:     "Gould Instrument Systems, Inc.",
	[3]byte{0, 2, 231}:     "CAB GmbH & Co KG",
	[3]byte{0, 2, 232}:     "E.D.&A.",
	[3]byte{0, 2, 233}:     "CS Systemes De Securite - C3S",
	[3]byte{0, 2, 234}:     "Focus Enhancements",
	[3]byte{0, 2, 235}:     "Pico Communications",
	[3]byte{0, 2, 236}:     "Maschoff Design Engineering",
	[3]byte{0, 2, 237}:     "DXO Telecom Co., Ltd.",
	[3]byte{0, 2, 238}:     "Nokia Danmark A/S",
	[3]byte{0, 2, 239}:     "CCC Network Systems Group Ltd.",
	[3]byte{0, 2, 240}:     "AME Optimedia Technology Co., Ltd.",
	[3]byte{0, 2, 241}:     "Pinetron Co., Ltd.",
	[3]byte{0, 2, 242}:     "eDevice, Inc.",
	[3]byte{0, 2, 243}:     "Media Serve Co., Ltd.",
	[3]byte{0, 2, 244}:     "PCTEL, Inc.",
	[3]byte{0, 2, 245}:     "VIVE Synergies, Inc.",
	[3]byte{0, 2, 246}:     "Equipe Communications",
	[3]byte{0, 2, 247}:     "ARM",
	[3]byte{0, 2, 248}:     "SEAKR Engineering, Inc.",
	[3]byte{0, 2, 249}:     "MIMOS Berhad",
	[3]byte{0, 2, 250}:     "DX Antenna Co., Ltd.",
	[3]byte{0, 2, 251}:     "Baumuller Aulugen-Systemtechnik GmbH",
	[3]byte{0, 2, 252}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 2, 253}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 2, 254}:     "Viditec, Inc.",
	[3]byte{0, 2, 255}:     "Handan BroadInfoCom",
	[3]byte{0, 3, 0}:       "Barracuda Networks, Inc.",
	[3]byte{0, 3, 1}:       "EXFO",
	[3]byte{0, 3, 2}:       "Charles Industries, Ltd.",
	[3]byte{0, 3, 3}:       "JAMA Electronics Co., Ltd.",
	[3]byte{0, 3, 4}:       "Pacific Broadband Communications",
	[3]byte{0, 3, 5}:       "MSC Vertriebs GmbH",
	[3]byte{0, 3, 6}:       "Fusion In Tech Co., Ltd.",
	[3]byte{0, 3, 7}:       "Secure Works, Inc.",
	[3]byte{0, 3, 8}:       "AM Communications, Inc.",
	[3]byte{0, 3, 9}:       "Texcel Technology PLC",
	[3]byte{0, 3, 10}:      "Argus Technologies",
	[3]byte{0, 3, 11}:      "Hunter Technology, Inc.",
	[3]byte{0, 3, 12}:      "Telesoft Technologies Ltd.",
	[3]byte{0, 3, 13}:      "Uniwill Computer Corp.",
	[3]byte{0, 3, 14}:      "Core Communications Co., Ltd.",
	[3]byte{0, 3, 15}:      "Digital China (Shanghai) Networks Ltd.",
	[3]byte{0, 3, 16}:      "E-Globaledge Corporation",
	[3]byte{0, 3, 17}:      "Micro Technology Co., Ltd.",
	[3]byte{0, 3, 18}:      "TR-Systemtechnik GmbH",
	[3]byte{0, 3, 19}:      "Access Media SPA",
	[3]byte{0, 3, 20}:      "Teleware Network Systems",
	[3]byte{0, 3, 21}:      "Cidco Incorporated",
	[3]byte{0, 3, 22}:      "Nobell Communications, Inc.",
	[3]byte{0, 3, 23}:      "Merlin Systems, Inc.",
	[3]byte{0, 3, 24}:      "Cyras Systems, Inc.",
	[3]byte{0, 3, 25}:      "Infineon AG",
	[3]byte{0, 3, 26}:      "Beijing Broad Telecom Ltd., China",
	[3]byte{0, 3, 27}:      "Cellvision Systems, Inc.",
	[3]byte{0, 3, 28}:      "Svenska Hardvarufabriken AB",
	[3]byte{0, 3, 29}:      "Taiwan Commate Computer, Inc.",
	[3]byte{0, 3, 30}:      "Optranet, Inc.",
	[3]byte{0, 3, 31}:      "Condev Ltd.",
	[3]byte{0, 3, 32}:      "Xpeed, Inc.",
	[3]byte{0, 3, 33}:      "Reco Research Co., Ltd.",
	[3]byte{0, 3, 34}:      "IDIS Co., Ltd.",
	[3]byte{0, 3, 35}:      "Cornet Technology, Inc.",
	[3]byte{0, 3, 36}:      "SANYO Consumer Electronics Co., Ltd.",
	[3]byte{0, 3, 37}:      "Arima Computer Corp.",
	[3]byte{0, 3, 38}:      "Iwasaki Information Systems Co., Ltd.",
	[3]byte{0, 3, 39}:      "ACT'L",
	[3]byte{0, 3, 40}:      "Mace Group, Inc.",
	[3]byte{0, 3, 41}:      "F3, Inc.",
	[3]byte{0, 3, 42}:      "UniData Communication Systems, Inc.",
	[3]byte{0, 3, 43}:      "GAI Datenfunksysteme GmbH",
	[3]byte{0, 3, 44}:      "ABB Switzerland Ltd",
	[3]byte{0, 3, 45}:      "IBASE Technology, Inc.",
	[3]byte{0, 3, 46}:      "Scope Information Management, Ltd.",
	[3]byte{0, 3, 47}:      "Global Sun Technology, Inc.",
	[3]byte{0, 3, 48}:      "Imagenics, Co., Ltd.",
	[3]byte{0, 3, 49}:      "CISCO SYSTEMS, INC.",
	[3]byte{0, 3, 50}:      "CISCO SYSTEMS, INC.",
	[3]byte{0, 3, 51}:      "Digitel Co., Ltd.",
	[3]byte{0, 3, 52}:      "Newport Electronics",
	[3]byte{0, 3, 53}:      "Mirae Technology",
	[3]byte{0, 3, 54}:      "Zetes Technologies",
	[3]byte{0, 3, 55}:      "Vaone, Inc.",
	[3]byte{0, 3, 56}:      "Oak Technology",
	[3]byte{0, 3, 57}:      "Eurologic Systems, Ltd.",
	[3]byte{0, 3, 58}:      "Silicon Wave, Inc.",
	[3]byte{0, 3, 59}:      "TAMI Tech Co., Ltd.",
	[3]byte{0, 3, 60}:      "Daiden Co., Ltd.",
	[3]byte{0, 3, 61}:      "ILSHin Lab",
	[3]byte{0, 3, 62}:      "Tateyama System Laboratory Co., Ltd.",
	[3]byte{0, 3, 63}:      "BigBand Networks, Ltd.",
	[3]byte{0, 3, 64}:      "Floware Wireless Systems, Ltd.",
	[3]byte{0, 3, 65}:      "Axon Digital Design",
	[3]byte{0, 3, 66}:      "Nortel Networks",
	[3]byte{0, 3, 67}:      "Martin Professional A/S",
	[3]byte{0, 3, 68}:      "Tietech.Co., Ltd.",
	[3]byte{0, 3, 69}:      "Routrek Networks Corporation",
	[3]byte{0, 3, 70}:      "Hitachi Kokusai Electric, Inc.",
	[3]byte{0, 3, 71}:      "Intel Corporation",
	[3]byte{0, 3, 72}:      "Norscan Instruments, Ltd.",
	[3]byte{0, 3, 73}:      "Vidicode Datacommunicatie B.V.",
	[3]byte{0, 3, 74}:      "RIAS Corporation",
	[3]byte{0, 3, 75}:      "Nortel Networks",
	[3]byte{0, 3, 76}:      "Shanghai DigiVision Technology Co., Ltd.",
	[3]byte{0, 3, 77}:      "Chiaro Networks, Ltd.",
	[3]byte{0, 3, 78}:      "Pos Data Company, Ltd.",
	[3]byte{0, 3, 79}:      "Sur-Gard Security",
	[3]byte{0, 3, 80}:      "BTICINO SPA",
	[3]byte{0, 3, 81}:      "Diebold, Inc.",
	[3]byte{0, 3, 82}:      "Colubris Networks",
	[3]byte{0, 3, 83}:      "Mitac, Inc.",
	[3]byte{0, 3, 84}:      "Fiber Logic Communications",
	[3]byte{0, 3, 85}:      "TeraBeam Internet Systems",
	[3]byte{0, 3, 86}:      "Wincor Nixdorf International GmbH",
	[3]byte{0, 3, 87}:      "Intervoice-Brite, Inc.",
	[3]byte{0, 3, 88}:      "Hanyang Digitech Co., Ltd.",
	[3]byte{0, 3, 89}:      "DigitalSis",
	[3]byte{0, 3, 90}:      "Photron Limited",
	[3]byte{0, 3, 91}:      "BridgeWave Communications",
	[3]byte{0, 3, 92}:      "Saint Song Corp.",
	[3]byte{0, 3, 93}:      "Bosung Hi-Net Co., Ltd.",
	[3]byte{0, 3, 94}:      "Metropolitan Area Networks, Inc.",
	[3]byte{0, 3, 95}:      "Prüftechnik Condition Monitoring GmbH & Co. KG",
	[3]byte{0, 3, 96}:      "PAC Interactive Technology, Inc.",
	[3]byte{0, 3, 97}:      "Widcomm, Inc.",
	[3]byte{0, 3, 98}:      "Vodtel Communications, Inc.",
	[3]byte{0, 3, 99}:      "Miraesys Co., Ltd.",
	[3]byte{0, 3, 100}:     "Scenix Semiconductor, Inc.",
	[3]byte{0, 3, 101}:     "Kira Information & Communications, Ltd.",
	[3]byte{0, 3, 102}:     "ASM Pacific Technology",
	[3]byte{0, 3, 103}:     "Jasmine Networks, Inc.",
	[3]byte{0, 3, 104}:     "Embedone Co., Ltd.",
	[3]byte{0, 3, 105}:     "Nippon Antenna Co., Ltd.",
	[3]byte{0, 3, 106}:     "Mainnet, Ltd.",
	[3]byte{0, 3, 107}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 3, 108}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 3, 109}:     "Runtop, Inc.",
	[3]byte{0, 3, 110}:     "Nicon Systems (Pty) Limited",
	[3]byte{0, 3, 111}:     "Telsey SPA",
	[3]byte{0, 3, 112}:     "NXTV, Inc.",
	[3]byte{0, 3, 113}:     "Acomz Networks Corp.",
	[3]byte{0, 3, 114}:     "ULAN",
	[3]byte{0, 3, 115}:     "Aselsan A.S",
	[3]byte{0, 3, 116}:     "Control Microsystems",
	[3]byte{0, 3, 117}:     "NetMedia, Inc.",
	[3]byte{0, 3, 118}:     "Graphtec Technology, Inc.",
	[3]byte{0, 3, 119}:     "Gigabit Wireless",
	[3]byte{0, 3, 120}:     "HUMAX Co., Ltd.",
	[3]byte{0, 3, 121}:     "Proscend Communications, Inc.",
	[3]byte{0, 3, 122}:     "Taiyo Yuden Co., Ltd.",
	[3]byte{0, 3, 123}:     "IDEC IZUMI Corporation",
	[3]byte{0, 3, 124}:     "Coax Media",
	[3]byte{0, 3, 125}:     "Stellcom",
	[3]byte{0, 3, 126}:     "PORTech Communications, Inc.",
	[3]byte{0, 3, 127}:     "Atheros Communications, Inc.",
	[3]byte{0, 3, 128}:     "SSH Communications Security Corp.",
	[3]byte{0, 3, 129}:     "Ingenico International",
	[3]byte{0, 3, 130}:     "A-One Co., Ltd.",
	[3]byte{0, 3, 131}:     "Metera Networks, Inc.",
	[3]byte{0, 3, 132}:     "AETA",
	[3]byte{0, 3, 133}:     "Actelis Networks, Inc.",
	[3]byte{0, 3, 134}:     "Ho Net, Inc.",
	[3]byte{0, 3, 135}:     "Blaze Network Products",
	[3]byte{0, 3, 136}:     "Fastfame Technology Co., Ltd.",
	[3]byte{0, 3, 137}:     "Plantronics",
	[3]byte{0, 3, 138}:     "America Online, Inc.",
	[3]byte{0, 3, 139}:     "PLUS-ONE I&T, Inc.",
	[3]byte{0, 3, 140}:     "Total Impact",
	[3]byte{0, 3, 141}:     "PCS Revenue Control Systems, Inc.",
	[3]byte{0, 3, 142}:     "Atoga Systems, Inc.",
	[3]byte{0, 3, 143}:     "Weinschel Corporation",
	[3]byte{0, 3, 144}:     "Digital Video Communications, Inc.",
	[3]byte{0, 3, 145}:     "Advanced Digital Broadcast, Ltd.",
	[3]byte{0, 3, 146}:     "Hyundai Teletek Co., Ltd.",
	[3]byte{0, 3, 147}:     "Apple",
	[3]byte{0, 3, 148}:     "Connect One",
	[3]byte{0, 3, 149}:     "California Amplifier",
	[3]byte{0, 3, 150}:     "EZ Cast Co., Ltd.",
	[3]byte{0, 3, 151}:     "Watchfront Limited",
	[3]byte{0, 3, 152}:     "WISI",
	[3]byte{0, 3, 153}:     "Dongju Informations & Communications Co., Ltd.",
	[3]byte{0, 3, 154}:     "SiConnect",
	[3]byte{0, 3, 155}:     "NetChip Technology, Inc.",
	[3]byte{0, 3, 156}:     "OptiMight Communications, Inc.",
	[3]byte{0, 3, 157}:     "Qisda Corporation",
	[3]byte{0, 3, 158}:     "Tera System Co., Ltd.",
	[3]byte{0, 3, 159}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 3, 160}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 3, 161}:     "HIPER Information & Communication, Inc.",
	[3]byte{0, 3, 162}:     "Catapult Communications",
	[3]byte{0, 3, 163}:     "MAVIX, Ltd.",
	[3]byte{0, 3, 164}:     "Imation Corp.",
	[3]byte{0, 3, 165}:     "Medea Corporation",
	[3]byte{0, 3, 166}:     "Traxit Technology, Inc.",
	[3]byte{0, 3, 167}:     "Unixtar Technology, Inc.",
	[3]byte{0, 3, 168}:     "IDOT Computers, Inc.",
	[3]byte{0, 3, 169}:     "AXCENT Media AG",
	[3]byte{0, 3, 170}:     "Watlow",
	[3]byte{0, 3, 171}:     "Bridge Information Systems",
	[3]byte{0, 3, 172}:     "Fronius Schweissmaschinen",
	[3]byte{0, 3, 173}:     "Emerson Energy Systems AB",
	[3]byte{0, 3, 174}:     "Allied Advanced Manufacturing Pte, Ltd.",
	[3]byte{0, 3, 175}:     "Paragea Communications",
	[3]byte{0, 3, 176}:     "Xsense Technology Corp.",
	[3]byte{0, 3, 177}:     "Hospira Inc.",
	[3]byte{0, 3, 178}:     "Radware",
	[3]byte{0, 3, 179}:     "IA Link Systems Co., Ltd.",
	[3]byte{0, 3, 180}:     "Macrotek International Corp.",
	[3]byte{0, 3, 181}:     "Entra Technology Co.",
	[3]byte{0, 3, 182}:     "QSI Corporation",
	[3]byte{0, 3, 183}:     "ZACCESS Systems",
	[3]byte{0, 3, 184}:     "NetKit Solutions, LLC",
	[3]byte{0, 3, 185}:     "Hualong Telecom Co., Ltd.",
	[3]byte{0, 3, 186}:     "Oracle Corporation",
	[3]byte{0, 3, 187}:     "Signal Communications Limited",
	[3]byte{0, 3, 188}:     "COT GmbH",
	[3]byte{0, 3, 189}:     "OmniCluster Technologies, Inc.",
	[3]byte{0, 3, 190}:     "Netility",
	[3]byte{0, 3, 191}:     "Centerpoint Broadband Technologies, Inc.",
	[3]byte{0, 3, 192}:     "RFTNC Co., Ltd.",
	[3]byte{0, 3, 193}:     "Packet Dynamics Ltd",
	[3]byte{0, 3, 194}:     "Solphone K.K.",
	[3]byte{0, 3, 195}:     "Micronik Multimedia",
	[3]byte{0, 3, 196}:     "Tomra Systems ASA",
	[3]byte{0, 3, 197}:     "Mobotix AG",
	[3]byte{0, 3, 198}:     "ICUE Systems, Inc.",
	[3]byte{0, 3, 199}:     "hopf Elektronik GmbH",
	[3]byte{0, 3, 200}:     "CML Emergency Services",
	[3]byte{0, 3, 201}:     "TECOM Co., Ltd.",
	[3]byte{0, 3, 202}:     "MTS Systems Corp.",
	[3]byte{0, 3, 203}:     "Nippon Systems Development Co., Ltd.",
	[3]byte{0, 3, 204}:     "Momentum Computer, Inc.",
	[3]byte{0, 3, 205}:     "Clovertech, Inc.",
	[3]byte{0, 3, 206}:     "ETEN Technologies, Inc.",
	[3]byte{0, 3, 207}:     "Muxcom, Inc.",
	[3]byte{0, 3, 208}:     "KOANKEISO Co., Ltd.",
	[3]byte{0, 3, 209}:     "Takaya Corporation",
	[3]byte{0, 3, 210}:     "Crossbeam Systems, Inc.",
	[3]byte{0, 3, 211}:     "Internet Energy Systems, Inc.",
	[3]byte{0, 3, 212}:     "Alloptic, Inc.",
	[3]byte{0, 3, 213}:     "Advanced Communications Co., Ltd.",
	[3]byte{0, 3, 214}:     "RADVision, Ltd.",
	[3]byte{0, 3, 215}:     "NextNet Wireless, Inc.",
	[3]byte{0, 3, 216}:     "iMPath Networks, Inc.",
	[3]byte{0, 3, 217}:     "Secheron SA",
	[3]byte{0, 3, 218}:     "Takamisawa Cybernetics Co., Ltd.",
	[3]byte{0, 3, 219}:     "Apogee Electronics Corp.",
	[3]byte{0, 3, 220}:     "Lexar Media, Inc.",
	[3]byte{0, 3, 221}:     "Comark Corp.",
	[3]byte{0, 3, 222}:     "OTC Wireless",
	[3]byte{0, 3, 223}:     "Desana Systems",
	[3]byte{0, 3, 224}:     "ARRIS Group, Inc.",
	[3]byte{0, 3, 225}:     "Winmate Communication, Inc.",
	[3]byte{0, 3, 226}:     "Comspace Corporation",
	[3]byte{0, 3, 227}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 3, 228}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 3, 229}:     "Hermstedt SG",
	[3]byte{0, 3, 230}:     "Entone, Inc.",
	[3]byte{0, 3, 231}:     "Logostek Co. Ltd.",
	[3]byte{0, 3, 232}:     "Wavelength Digital Limited",
	[3]byte{0, 3, 233}:     "Akara Canada, Inc.",
	[3]byte{0, 3, 234}:     "Mega System Technologies, Inc.",
	[3]byte{0, 3, 235}:     "Atrica",
	[3]byte{0, 3, 236}:     "ICG Research, Inc.",
	[3]byte{0, 3, 237}:     "Shinkawa Electric Co., Ltd.",
	[3]byte{0, 3, 238}:     "MKNet Corporation",
	[3]byte{0, 3, 239}:     "Oneline AG",
	[3]byte{0, 3, 240}:     "Redfern Broadband Networks",
	[3]byte{0, 3, 241}:     "Cicada Semiconductor, Inc.",
	[3]byte{0, 3, 242}:     "Seneca Networks",
	[3]byte{0, 3, 243}:     "Dazzle Multimedia, Inc.",
	[3]byte{0, 3, 244}:     "NetBurner",
	[3]byte{0, 3, 245}:     "Chip2Chip",
	[3]byte{0, 3, 246}:     "Allegro Networks, Inc.",
	[3]byte{0, 3, 247}:     "Plast-Control GmbH",
	[3]byte{0, 3, 248}:     "SanCastle Technologies, Inc.",
	[3]byte{0, 3, 249}:     "Pleiades Communications, Inc.",
	[3]byte{0, 3, 250}:     "TiMetra Networks",
	[3]byte{0, 3, 251}:     "ENEGATE Co.,Ltd.",
	[3]byte{0, 3, 252}:     "Intertex Data AB",
	[3]byte{0, 3, 253}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 3, 254}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 3, 255}:     "Microsoft Corporation",
	[3]byte{0, 4, 0}:       "LEXMARK INTERNATIONAL, INC.",
	[3]byte{0, 4, 1}:       "Osaki Electric Co., Ltd.",
	[3]byte{0, 4, 2}:       "Nexsan Technologies, Ltd.",
	[3]byte{0, 4, 3}:       "Nexsi Corporation",
	[3]byte{0, 4, 4}:       "Makino Milling Machine Co., Ltd.",
	[3]byte{0, 4, 5}:       "ACN Technologies",
	[3]byte{0, 4, 6}:       "Fa. Metabox AG",
	[3]byte{0, 4, 7}:       "Topcon Positioning Systems, Inc.",
	[3]byte{0, 4, 8}:       "Sanko Electronics Co., Ltd.",
	[3]byte{0, 4, 9}:       "Cratos Networks",
	[3]byte{0, 4, 10}:      "Sage Systems",
	[3]byte{0, 4, 11}:      "3com Europe Ltd.",
	[3]byte{0, 4, 12}:      "Kanno Works, Ltd.",
	[3]byte{0, 4, 13}:      "Avaya, Inc.",
	[3]byte{0, 4, 14}:      "AVM GmbH",
	[3]byte{0, 4, 15}:      "Asus Network Technologies, Inc.",
	[3]byte{0, 4, 16}:      "Spinnaker Networks, Inc.",
	[3]byte{0, 4, 17}:      "Inkra Networks, Inc.",
	[3]byte{0, 4, 18}:      "WaveSmith Networks, Inc.",
	[3]byte{0, 4, 19}:      "SNOM Technology AG",
	[3]byte{0, 4, 20}:      "Umezawa Musen Denki Co., Ltd.",
	[3]byte{0, 4, 21}:      "Rasteme Systems Co., Ltd.",
	[3]byte{0, 4, 22}:      "Parks S/A Comunicacoes Digitais",
	[3]byte{0, 4, 23}:      "ELAU AG",
	[3]byte{0, 4, 24}:      "Teltronic S.A.U.",
	[3]byte{0, 4, 25}:      "Fibercycle Networks, Inc.",
	[3]byte{0, 4, 26}:      "Ines Test and Measurement GmbH & CoKG",
	[3]byte{0, 4, 27}:      "Bridgeworks Ltd.",
	[3]byte{0, 4, 28}:      "ipDialog, Inc.",
	[3]byte{0, 4, 29}:      "Corega of America",
	[3]byte{0, 4, 30}:      "Shikoku Instrumentation Co., Ltd.",
	[3]byte{0, 4, 31}:      "Sony Computer Entertainment, Inc.",
	[3]byte{0, 4, 32}:      "Slim Devices, Inc.",
	[3]byte{0, 4, 33}:      "Ocular Networks",
	[3]byte{0, 4, 34}:      "Gordon Kapes, Inc.",
	[3]byte{0, 4, 35}:      "Intel Corporation",
	[3]byte{0, 4, 36}:      "TMC s.r.l.",
	[3]byte{0, 4, 37}:      "Atmel Corporation",
	[3]byte{0, 4, 38}:      "Autosys",
	[3]byte{0, 4, 39}:      "CISCO SYSTEMS, INC.",
	[3]byte{0, 4, 40}:      "CISCO SYSTEMS, INC.",
	[3]byte{0, 4, 41}:      "Pixord Corporation",
	[3]byte{0, 4, 42}:      "Wireless Networks, Inc.",
	[3]byte{0, 4, 43}:      "IT Access Co., Ltd.",
	[3]byte{0, 4, 44}:      "Minet, Inc.",
	[3]byte{0, 4, 45}:      "Sarian Systems, Ltd.",
	[3]byte{0, 4, 46}:      "Netous Technologies, Ltd.",
	[3]byte{0, 4, 47}:      "International Communications Products, Inc.",
	[3]byte{0, 4, 48}:      "Netgem",
	[3]byte{0, 4, 49}:      "GlobalStreams, Inc.",
	[3]byte{0, 4, 50}:      "Voyetra Turtle Beach, Inc.",
	[3]byte{0, 4, 51}:      "Cyberboard A/S",
	[3]byte{0, 4, 52}:      "Accelent Systems, Inc.",
	[3]byte{0, 4, 53}:      "Comptek International, Inc.",
	[3]byte{0, 4, 54}:      "ELANsat Technologies, Inc.",
	[3]byte{0, 4, 55}:      "Powin Information Technology, Inc.",
	[3]byte{0, 4, 56}:      "Nortel Networks",
	[3]byte{0, 4, 57}:      "Rosco Entertainment Technology, Inc.",
	[3]byte{0, 4, 58}:      "Intelligent Telecommunications, Inc.",
	[3]byte{0, 4, 59}:      "Lava Computer Mfg., Inc.",
	[3]byte{0, 4, 60}:      "SONOS Co., Ltd.",
	[3]byte{0, 4, 61}:      "INDEL AG",
	[3]byte{0, 4, 62}:      "Telencomm",
	[3]byte{0, 4, 63}:      "ESTeem Wireless Modems, Inc",
	[3]byte{0, 4, 64}:      "cyberPIXIE, Inc.",
	[3]byte{0, 4, 65}:      "Half Dome Systems, Inc.",
	[3]byte{0, 4, 66}:      "NACT",
	[3]byte{0, 4, 67}:      "Agilent Technologies, Inc.",
	[3]byte{0, 4, 68}:      "Western Multiplex Corporation",
	[3]byte{0, 4, 69}:      "LMS Skalar Instruments GmbH",
	[3]byte{0, 4, 70}:      "CYZENTECH Co., Ltd.",
	[3]byte{0, 4, 71}:      "Acrowave Systems Co., Ltd.",
	[3]byte{0, 4, 72}:      "Polaroid Corporation",
	[3]byte{0, 4, 73}:      "Mapletree Networks",
	[3]byte{0, 4, 74}:      "iPolicy Networks, Inc.",
	[3]byte{0, 4, 75}:      "NVIDIA",
	[3]byte{0, 4, 76}:      "JENOPTIK",
	[3]byte{0, 4, 77}:      "CISCO SYSTEMS, INC.",
	[3]byte{0, 4, 78}:      "CISCO SYSTEMS, INC.",
	[3]byte{0, 4, 79}:      "Leukhardt Systemelektronik GmbH",
	[3]byte{0, 4, 80}:      "DMD Computers SRL",
	[3]byte{0, 4, 81}:      "Medrad, Inc.",
	[3]byte{0, 4, 82}:      "RocketLogix, Inc.",
	[3]byte{0, 4, 83}:      "YottaYotta, Inc.",
	[3]byte{0, 4, 84}:      "Quadriga UK",
	[3]byte{0, 4, 85}:      "ANTARA.net",
	[3]byte{0, 4, 86}:      "Cambium Networks Limited",
	[3]byte{0, 4, 87}:      "Universal Access Technology, Inc.",
	[3]byte{0, 4, 88}:      "Fusion X Co., Ltd.",
	[3]byte{0, 4, 89}:      "Veristar Corporation",
	[3]byte{0, 4, 90}:      "The Linksys Group, Inc.",
	[3]byte{0, 4, 91}:      "Techsan Electronics Co., Ltd.",
	[3]byte{0, 4, 92}:      "Mobiwave Pte Ltd",
	[3]byte{0, 4, 93}:      "BEKA Elektronik",
	[3]byte{0, 4, 94}:      "PolyTrax Information Technology AG",
	[3]byte{0, 4, 95}:      "Avalue Technology, Inc.",
	[3]byte{0, 4, 96}:      "Knilink Technology, Inc.",
	[3]byte{0, 4, 97}:      "EPOX Computer Co., Ltd.",
	[3]byte{0, 4, 98}:      "DAKOS Data & Communication Co., Ltd.",
	[3]byte{0, 4, 99}:      "Bosch Security Systems",
	[3]byte{0, 4, 100}:     "Pulse-Link Inc",
	[3]byte{0, 4, 101}:     "i.s.t isdn-support technik GmbH",
	[3]byte{0, 4, 102}:     "ARMITEL Co.",
	[3]byte{0, 4, 103}:     "Wuhan Research Institute of MII",
	[3]byte{0, 4, 104}:     "Vivity, Inc.",
	[3]byte{0, 4, 105}:     "Innocom, Inc.",
	[3]byte{0, 4, 106}:     "Navini Networks",
	[3]byte{0, 4, 107}:     "Palm Wireless, Inc.",
	[3]byte{0, 4, 108}:     "Cyber Technology Co., Ltd.",
	[3]byte{0, 4, 109}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 4, 110}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 4, 111}:     "Digitel S/A Industria Eletronica",
	[3]byte{0, 4, 112}:     "ipUnplugged AB",
	[3]byte{0, 4, 113}:     "IPrad",
	[3]byte{0, 4, 114}:     "Telelynx, Inc.",
	[3]byte{0, 4, 115}:     "Photonex Corporation",
	[3]byte{0, 4, 116}:     "LEGRAND",
	[3]byte{0, 4, 117}:     "3 Com Corporation",
	[3]byte{0, 4, 118}:     "3 Com Corporation",
	[3]byte{0, 4, 119}:     "Scalant Systems, Inc.",
	[3]byte{0, 4, 120}:     "G. Star Technology Corporation",
	[3]byte{0, 4, 121}:     "Radius Co., Ltd.",
	[3]byte{0, 4, 122}:     "AXXESSIT ASA",
	[3]byte{0, 4, 123}:     "Schlumberger",
	[3]byte{0, 4, 124}:     "Skidata AG",
	[3]byte{0, 4, 125}:     "Pelco",
	[3]byte{0, 4, 126}:     "Siqura B.V.",
	[3]byte{0, 4, 127}:     "Chr. Mayr GmbH & Co. KG",
	[3]byte{0, 4, 128}:     "Brocade Communications Systems, Inc",
	[3]byte{0, 4, 129}:     "Econolite Control Products, Inc.",
	[3]byte{0, 4, 130}:     "Medialogic Corp.",
	[3]byte{0, 4, 131}:     "Deltron Technology, Inc.",
	[3]byte{0, 4, 132}:     "Amann GmbH",
	[3]byte{0, 4, 133}:     "PicoLight",
	[3]byte{0, 4, 134}:     "ITTC, University of Kansas",
	[3]byte{0, 4, 135}:     "Cogency Semiconductor, Inc.",
	[3]byte{0, 4, 136}:     "Eurotherm Controls",
	[3]byte{0, 4, 137}:     "YAFO Networks, Inc.",
	[3]byte{0, 4, 138}:     "Temia Vertriebs GmbH",
	[3]byte{0, 4, 139}:     "Poscon Corporation",
	[3]byte{0, 4, 140}:     "Nayna Networks, Inc.",
	[3]byte{0, 4, 141}:     "Tone Commander Systems, Inc.",
	[3]byte{0, 4, 142}:     "Ohm Tech Labs, Inc.",
	[3]byte{0, 4, 143}:     "TD Systems Corporation",
	[3]byte{0, 4, 144}:     "Optical Access",
	[3]byte{0, 4, 145}:     "Technovision, Inc.",
	[3]byte{0, 4, 146}:     "Hive Internet, Ltd.",
	[3]byte{0, 4, 147}:     "Tsinghua Unisplendour Co., Ltd.",
	[3]byte{0, 4, 148}:     "Breezecom, Ltd.",
	[3]byte{0, 4, 149}:     "Tejas Networks India Limited",
	[3]byte{0, 4, 150}:     "Extreme Networks",
	[3]byte{0, 4, 151}:     "MacroSystem Digital Video AG",
	[3]byte{0, 4, 152}:     "Mahi Networks",
	[3]byte{0, 4, 153}:     "Chino Corporation",
	[3]byte{0, 4, 154}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 4, 155}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 4, 156}:     "Surgient Networks, Inc.",
	[3]byte{0, 4, 157}:     "Ipanema Technologies",
	[3]byte{0, 4, 158}:     "Wirelink Co., Ltd.",
	[3]byte{0, 4, 159}:     "Freescale Semiconductor",
	[3]byte{0, 4, 160}:     "Verity Instruments, Inc.",
	[3]byte{0, 4, 161}:     "Pathway Connectivity",
	[3]byte{0, 4, 162}:     "L.S.I. Japan Co., Ltd.",
	[3]byte{0, 4, 163}:     "Microchip Technology, Inc.",
	[3]byte{0, 4, 164}:     "NetEnabled, Inc.",
	[3]byte{0, 4, 165}:     "Barco Projection Systems NV",
	[3]byte{0, 4, 166}:     "SAF Tehnika Ltd.",
	[3]byte{0, 4, 167}:     "FabiaTech Corporation",
	[3]byte{0, 4, 168}:     "Broadmax Technologies, Inc.",
	[3]byte{0, 4, 169}:     "SandStream Technologies, Inc.",
	[3]byte{0, 4, 170}:     "Jetstream Communications",
	[3]byte{0, 4, 171}:     "Comverse Network Systems, Inc.",
	[3]byte{0, 4, 172}:     "IBM Corp",
	[3]byte{0, 4, 173}:     "Malibu Networks",
	[3]byte{0, 4, 174}:     "Sullair Corporation",
	[3]byte{0, 4, 175}:     "Digital Fountain, Inc.",
	[3]byte{0, 4, 176}:     "ELESIGN Co., Ltd.",
	[3]byte{0, 4, 177}:     "Signal Technology, Inc.",
	[3]byte{0, 4, 178}:     "ESSEGI SRL",
	[3]byte{0, 4, 179}:     "Videotek, Inc.",
	[3]byte{0, 4, 180}:     "CIAC",
	[3]byte{0, 4, 181}:     "Equitrac Corporation",
	[3]byte{0, 4, 182}:     "Stratex Networks, Inc.",
	[3]byte{0, 4, 183}:     "AMB i.t. Holding",
	[3]byte{0, 4, 184}:     "Kumahira Co., Ltd.",
	[3]byte{0, 4, 185}:     "S.I. Soubou, Inc.",
	[3]byte{0, 4, 186}:     "KDD Media Will Corporation",
	[3]byte{0, 4, 187}:     "Bardac Corporation",
	[3]byte{0, 4, 188}:     "Giantec, Inc.",
	[3]byte{0, 4, 189}:     "ARRIS Group, Inc.",
	[3]byte{0, 4, 190}:     "OptXCon, Inc.",
	[3]byte{0, 4, 191}:     "VersaLogic Corp.",
	[3]byte{0, 4, 192}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 4, 193}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 4, 194}:     "Magnipix, Inc.",
	[3]byte{0, 4, 195}:     "CASTOR Informatique",
	[3]byte{0, 4, 196}:     "Allen & Heath Limited",
	[3]byte{0, 4, 197}:     "ASE Technologies, USA",
	[3]byte{0, 4, 198}:     "Yamaha Motor Co., Ltd.",
	[3]byte{0, 4, 199}:     "NetMount",
	[3]byte{0, 4, 200}:     "LIBA Maschinenfabrik GmbH",
	[3]byte{0, 4, 201}:     "Micro Electron Co., Ltd.",
	[3]byte{0, 4, 202}:     "FreeMs Corp.",
	[3]byte{0, 4, 203}:     "Tdsoft Communication, Ltd.",
	[3]byte{0, 4, 204}:     "Peek Traffic B.V.",
	[3]byte{0, 4, 205}:     "Extenway Solutions Inc",
	[3]byte{0, 4, 206}:     "Patria Ailon",
	[3]byte{0, 4, 207}:     "Seagate Technology",
	[3]byte{0, 4, 208}:     "Softlink s.r.o.",
	[3]byte{0, 4, 209}:     "Drew Technologies, Inc.",
	[3]byte{0, 4, 210}:     "Adcon Telemetry GmbH",
	[3]byte{0, 4, 211}:     "Toyokeiki Co., Ltd.",
	[3]byte{0, 4, 212}:     "Proview Electronics Co., Ltd.",
	[3]byte{0, 4, 213}:     "Hitachi Information & Communication Engineering, Ltd.",
	[3]byte{0, 4, 214}:     "Takagi Industrial Co., Ltd.",
	[3]byte{0, 4, 215}:     "Omitec Instrumentation Ltd.",
	[3]byte{0, 4, 216}:     "IPWireless, Inc.",
	[3]byte{0, 4, 217}:     "Titan Electronics, Inc.",
	[3]byte{0, 4, 218}:     "Relax Technology, Inc.",
	[3]byte{0, 4, 219}:     "Tellus Group Corp.",
	[3]byte{0, 4, 220}:     "Nortel Networks",
	[3]byte{0, 4, 221}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 4, 222}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 4, 223}:     "Teracom Telematica Ltda.",
	[3]byte{0, 4, 224}:     "Procket Networks",
	[3]byte{0, 4, 225}:     "Infinior Microsystems",
	[3]byte{0, 4, 226}:     "SMC Networks, Inc.",
	[3]byte{0, 4, 227}:     "Accton Technology Corp.",
	[3]byte{0, 4, 228}:     "Daeryung Ind., Inc.",
	[3]byte{0, 4, 229}:     "Glonet Systems, Inc.",
	[3]byte{0, 4, 230}:     "Banyan Network Private Limited",
	[3]byte{0, 4, 231}:     "Lightpointe Communications, Inc",
	[3]byte{0, 4, 232}:     "IER, Inc.",
	[3]byte{0, 4, 233}:     "Infiniswitch Corporation",
	[3]byte{0, 4, 234}:     "Hewlett-Packard Company",
	[3]byte{0, 4, 235}:     "Paxonet Communications, Inc.",
	[3]byte{0, 4, 236}:     "Memobox SA",
	[3]byte{0, 4, 237}:     "Billion Electric Co., Ltd.",
	[3]byte{0, 4, 238}:     "Lincoln Electric Company",
	[3]byte{0, 4, 239}:     "Polestar Corp.",
	[3]byte{0, 4, 240}:     "International Computers, Ltd",
	[3]byte{0, 4, 241}:     "WhereNet",
	[3]byte{0, 4, 242}:     "Polycom",
	[3]byte{0, 4, 243}:     "FS FORTH-SYSTEME GmbH",
	[3]byte{0, 4, 244}:     "Infinite Electronics Inc.",
	[3]byte{0, 4, 245}:     "SnowShore Networks, Inc.",
	[3]byte{0, 4, 246}:     "Amphus",
	[3]byte{0, 4, 247}:     "Omega Band, Inc.",
	[3]byte{0, 4, 248}:     "QUALICABLE TV Industria E Com., Ltda",
	[3]byte{0, 4, 249}:     "Xtera Communications, Inc.",
	[3]byte{0, 4, 250}:     "NBS Technologies Inc.",
	[3]byte{0, 4, 251}:     "Commtech, Inc.",
	[3]byte{0, 4, 252}:     "Stratus Computer (DE), Inc.",
	[3]byte{0, 4, 253}:     "Japan Control Engineering Co., Ltd.",
	[3]byte{0, 4, 254}:     "Pelago Networks",
	[3]byte{0, 4, 255}:     "Acronet Co., Ltd.",
	[3]byte{0, 5, 0}:       "CISCO SYSTEMS, INC.",
	[3]byte{0, 5, 1}:       "CISCO SYSTEMS, INC.",
	[3]byte{0, 5, 2}:       "Apple",
	[3]byte{0, 5, 3}:       "ICONAG",
	[3]byte{0, 5, 4}:       "Naray Information & Communication Enterprise",
	[3]byte{0, 5, 5}:       "Systems Integration Solutions, Inc.",
	[3]byte{0, 5, 6}:       "Reddo Networks AB",
	[3]byte{0, 5, 7}:       "Fine Appliance Corp.",
	[3]byte{0, 5, 8}:       "Inetcam, Inc.",
	[3]byte{0, 5, 9}:       "AVOC Nishimura Ltd.",
	[3]byte{0, 5, 10}:      "ICS Spa",
	[3]byte{0, 5, 11}:      "SICOM Systems, Inc.",
	[3]byte{0, 5, 12}:      "Network Photonics, Inc.",
	[3]byte{0, 5, 13}:      "Midstream Technologies, Inc.",
	[3]byte{0, 5, 14}:      "3ware, Inc.",
	[3]byte{0, 5, 15}:      "Tanaka S/S Ltd.",
	[3]byte{0, 5, 16}:      "Infinite Shanghai Communication Terminals Ltd.",
	[3]byte{0, 5, 17}:      "Complementary Technologies Ltd",
	[3]byte{0, 5, 18}:      "MeshNetworks, Inc.",
	[3]byte{0, 5, 19}:      "VTLinx Multimedia Systems, Inc.",
	[3]byte{0, 5, 20}:      "KDT Systems Co., Ltd.",
	[3]byte{0, 5, 21}:      "Nuark Co., Ltd.",
	[3]byte{0, 5, 22}:      "SMART Modular Technologies",
	[3]byte{0, 5, 23}:      "Shellcomm, Inc.",
	[3]byte{0, 5, 24}:      "Jupiters Technology",
	[3]byte{0, 5, 25}:      "Siemens Building Technologies AG,",
	[3]byte{0, 5, 26}:      "3Com Europe Ltd.",
	[3]byte{0, 5, 27}:      "Magic Control Technology Corporation",
	[3]byte{0, 5, 28}:      "Xnet Technology Corp.",
	[3]byte{0, 5, 29}:      "Airocon, Inc.",
	[3]byte{0, 5, 30}:      "Brocade Communications Systems, Inc.",
	[3]byte{0, 5, 31}:      "Taijin Media Co., Ltd.",
	[3]byte{0, 5, 32}:      "Smartronix, Inc.",
	[3]byte{0, 5, 33}:      "Control Microsystems",
	[3]byte{0, 5, 34}:      "LEA*D Corporation, Inc.",
	[3]byte{0, 5, 35}:      "AVL List GmbH",
	[3]byte{0, 5, 36}:      "BTL System (HK) Limited",
	[3]byte{0, 5, 37}:      "Puretek Industrial Co., Ltd.",
	[3]byte{0, 5, 38}:      "IPAS GmbH",
	[3]byte{0, 5, 39}:      "SJ Tek Co. Ltd",
	[3]byte{0, 5, 40}:      "New Focus, Inc.",
	[3]byte{0, 5, 41}:      "Shanghai Broadan Communication Technology Co., Ltd",
	[3]byte{0, 5, 42}:      "Ikegami Tsushinki Co., Ltd.",
	[3]byte{0, 5, 43}:      "HORIBA, Ltd.",
	[3]byte{0, 5, 44}:      "Supreme Magic Corporation",
	[3]byte{0, 5, 45}:      "Zoltrix International Limited",
	[3]byte{0, 5, 46}:      "Cinta Networks",
	[3]byte{0, 5, 47}:      "Leviton Network Solutions",
	[3]byte{0, 5, 48}:      "Andiamo Systems, Inc.",
	[3]byte{0, 5, 49}:      "CISCO SYSTEMS, INC.",
	[3]byte{0, 5, 50}:      "CISCO SYSTEMS, INC.",
	[3]byte{0, 5, 51}:      "Brocade Communications Systems, Inc.",
	[3]byte{0, 5, 52}:      "Northstar Engineering Ltd.",
	[3]byte{0, 5, 53}:      "Chip PC Ltd.",
	[3]byte{0, 5, 54}:      "Danam Communications, Inc.",
	[3]byte{0, 5, 55}:      "Nets Technology Co., Ltd.",
	[3]byte{0, 5, 56}:      "Merilus, Inc.",
	[3]byte{0, 5, 57}:      "A Brand New World in Sweden AB",
	[3]byte{0, 5, 58}:      "Willowglen Services Pte Ltd",
	[3]byte{0, 5, 59}:      "Harbour Networks Ltd., Co. Beijing",
	[3]byte{0, 5, 60}:      "Xircom",
	[3]byte{0, 5, 61}:      "Agere Systems",
	[3]byte{0, 5, 62}:      "KID Systeme GmbH",
	[3]byte{0, 5, 63}:      "VisionTek, Inc.",
	[3]byte{0, 5, 64}:      "FAST Corporation",
	[3]byte{0, 5, 65}:      "Advanced Systems Co., Ltd.",
	[3]byte{0, 5, 66}:      "Otari, Inc.",
	[3]byte{0, 5, 67}:      "IQ Wireless GmbH",
	[3]byte{0, 5, 68}:      "Valley Technologies, Inc.",
	[3]byte{0, 5, 69}:      "Internet Photonics",
	[3]byte{0, 5, 70}:      "KDDI Network & Solultions Inc.",
	[3]byte{0, 5, 71}:      "Starent Networks",
	[3]byte{0, 5, 72}:      "Disco Corporation",
	[3]byte{0, 5, 73}:      "Salira Optical Network Systems",
	[3]byte{0, 5, 74}:      "Ario Data Networks, Inc.",
	[3]byte{0, 5, 75}:      "Eaton Automation AG",
	[3]byte{0, 5, 76}:      "RF Innovations Pty Ltd",
	[3]byte{0, 5, 77}:      "Brans Technologies, Inc.",
	[3]byte{0, 5, 78}:      "Philips",
	[3]byte{0, 5, 79}:      "PRIVATE",
	[3]byte{0, 5, 80}:      "Vcomms Connect Limited",
	[3]byte{0, 5, 81}:      "F & S Elektronik Systeme GmbH",
	[3]byte{0, 5, 82}:      "Xycotec Computer GmbH",
	[3]byte{0, 5, 83}:      "DVC Company, Inc.",
	[3]byte{0, 5, 84}:      "Rangestar Wireless",
	[3]byte{0, 5, 85}:      "Japan Cash Machine Co., Ltd.",
	[3]byte{0, 5, 86}:      "360 Systems",
	[3]byte{0, 5, 87}:      "Agile TV Corporation",
	[3]byte{0, 5, 88}:      "Synchronous, Inc.",
	[3]byte{0, 5, 89}:      "Intracom S.A.",
	[3]byte{0, 5, 90}:      "Power Dsine Ltd.",
	[3]byte{0, 5, 91}:      "Charles Industries, Ltd.",
	[3]byte{0, 5, 92}:      "Kowa Company, Ltd.",
	[3]byte{0, 5, 93}:      "D-Link Systems, Inc.",
	[3]byte{0, 5, 94}:      "CISCO SYSTEMS, INC.",
	[3]byte{0, 5, 95}:      "CISCO SYSTEMS, INC.",
	[3]byte{0, 5, 96}:      "LEADER COMM.CO., LTD",
	[3]byte{0, 5, 97}:      "nac Image Technology, Inc.",
	[3]byte{0, 5, 98}:      "Digital View Limited",
	[3]byte{0, 5, 99}:      "J-Works, Inc.",
	[3]byte{0, 5, 100}:     "Tsinghua Bitway Co., Ltd.",
	[3]byte{0, 5, 101}:     "Tailyn Communication Company Ltd.",
	[3]byte{0, 5, 102}:     "Secui.com Corporation",
	[3]byte{0, 5, 103}:     "Etymonic Design, Inc.",
	[3]byte{0, 5, 104}:     "Piltofish Networks AB",
	[3]byte{0, 5, 105}:     "VMware, Inc.",
	[3]byte{0, 5, 106}:     "Heuft Systemtechnik GmbH",
	[3]byte{0, 5, 107}:     "C.P. Technology Co., Ltd.",
	[3]byte{0, 5, 108}:     "Hung Chang Co., Ltd.",
	[3]byte{0, 5, 109}:     "Pacific Corporation",
	[3]byte{0, 5, 110}:     "National Enhance Technology, Inc.",
	[3]byte{0, 5, 111}:     "Innomedia Technologies Pvt. Ltd.",
	[3]byte{0, 5, 112}:     "Baydel Ltd.",
	[3]byte{0, 5, 113}:     "Seiwa Electronics Co.",
	[3]byte{0, 5, 114}:     "Deonet Co., Ltd.",
	[3]byte{0, 5, 115}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 5, 116}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 5, 117}:     "CDS-Electronics BV",
	[3]byte{0, 5, 118}:     "NSM Technology Ltd.",
	[3]byte{0, 5, 119}:     "SM Information & Communication",
	[3]byte{0, 5, 120}:     "PRIVATE",
	[3]byte{0, 5, 121}:     "Universal Control Solution Corp.",
	[3]byte{0, 5, 122}:     "Overture Networks",
	[3]byte{0, 5, 123}:     "Chung Nam Electronic Co., Ltd.",
	[3]byte{0, 5, 124}:     "RCO Security AB",
	[3]byte{0, 5, 125}:     "Sun Communications, Inc.",
	[3]byte{0, 5, 126}:     "Eckelmann Steuerungstechnik GmbH",
	[3]byte{0, 5, 127}:     "Acqis Technology",
	[3]byte{0, 5, 128}:     "FibroLAN Ltd.",
	[3]byte{0, 5, 129}:     "Snell",
	[3]byte{0, 5, 130}:     "ClearCube Technology",
	[3]byte{0, 5, 131}:     "ImageCom Limited",
	[3]byte{0, 5, 132}:     "AbsoluteValue Systems, Inc.",
	[3]byte{0, 5, 133}:     "Juniper Networks, Inc.",
	[3]byte{0, 5, 134}:     "Lucent Technologies",
	[3]byte{0, 5, 135}:     "Locus, Incorporated",
	[3]byte{0, 5, 136}:     "Sensoria Corp.",
	[3]byte{0, 5, 137}:     "National Datacomputer",
	[3]byte{0, 5, 138}:     "Netcom Co., Ltd.",
	[3]byte{0, 5, 139}:     "IPmental, Inc.",
	[3]byte{0, 5, 140}:     "Opentech Inc.",
	[3]byte{0, 5, 141}:     "Lynx Photonic Networks, Inc.",
	[3]byte{0, 5, 142}:     "Flextronics International GmbH & Co. Nfg. KG",
	[3]byte{0, 5, 143}:     "CLCsoft co.",
	[3]byte{0, 5, 144}:     "Swissvoice Ltd.",
	[3]byte{0, 5, 145}:     "Active Silicon Ltd",
	[3]byte{0, 5, 146}:     "Pultek Corp.",
	[3]byte{0, 5, 147}:     "Grammar Engine Inc.",
	[3]byte{0, 5, 148}:     "IXXAT Automation GmbH",
	[3]byte{0, 5, 149}:     "Alesis Corporation",
	[3]byte{0, 5, 150}:     "Genotech Co., Ltd.",
	[3]byte{0, 5, 151}:     "Eagle Traffic Control Systems",
	[3]byte{0, 5, 152}:     "CRONOS S.r.l.",
	[3]byte{0, 5, 153}:     "DRS Test and Energy Management or DRS-TEM",
	[3]byte{0, 5, 154}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 5, 155}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 5, 156}:     "Kleinknecht GmbH, Ing. Büro",
	[3]byte{0, 5, 157}:     "Daniel Computing Systems, Inc.",
	[3]byte{0, 5, 158}:     "Zinwell Corporation",
	[3]byte{0, 5, 159}:     "Yotta Networks, Inc.",
	[3]byte{0, 5, 160}:     "MOBILINE Kft.",
	[3]byte{0, 5, 161}:     "Zenocom",
	[3]byte{0, 5, 162}:     "CELOX Networks",
	[3]byte{0, 5, 163}:     "QEI, Inc.",
	[3]byte{0, 5, 164}:     "Lucid Voice Ltd.",
	[3]byte{0, 5, 165}:     "KOTT",
	[3]byte{0, 5, 166}:     "Extron Electronics",
	[3]byte{0, 5, 167}:     "Hyperchip, Inc.",
	[3]byte{0, 5, 168}:     "WYLE ELECTRONICS",
	[3]byte{0, 5, 169}:     "Princeton Networks, Inc.",
	[3]byte{0, 5, 170}:     "Moore Industries International Inc.",
	[3]byte{0, 5, 171}:     "Cyber Fone, Inc.",
	[3]byte{0, 5, 172}:     "Northern Digital, Inc.",
	[3]byte{0, 5, 173}:     "Topspin Communications, Inc.",
	[3]byte{0, 5, 174}:     "Mediaport USA",
	[3]byte{0, 5, 175}:     "InnoScan Computing A/S",
	[3]byte{0, 5, 176}:     "Korea Computer Technology Co., Ltd.",
	[3]byte{0, 5, 177}:     "ASB Technology BV",
	[3]byte{0, 5, 178}:     "Medison Co., Ltd.",
	[3]byte{0, 5, 179}:     "Asahi-Engineering Co., Ltd.",
	[3]byte{0, 5, 180}:     "Aceex Corporation",
	[3]byte{0, 5, 181}:     "Broadcom Technologies",
	[3]byte{0, 5, 182}:     "INSYS Microelectronics GmbH",
	[3]byte{0, 5, 183}:     "Arbor Technology Corp.",
	[3]byte{0, 5, 184}:     "Electronic Design Associates, Inc.",
	[3]byte{0, 5, 185}:     "Airvana, Inc.",
	[3]byte{0, 5, 186}:     "Area Netwoeks, Inc.",
	[3]byte{0, 5, 187}:     "Myspace AB",
	[3]byte{0, 5, 188}:     "Resource Data Management Ltd",
	[3]byte{0, 5, 189}:     "ROAX BV",
	[3]byte{0, 5, 190}:     "Kongsberg Seatex AS",
	[3]byte{0, 5, 191}:     "JustEzy Technology, Inc.",
	[3]byte{0, 5, 192}:     "Digital Network Alacarte Co., Ltd.",
	[3]byte{0, 5, 193}:     "A-Kyung Motion, Inc.",
	[3]byte{0, 5, 194}:     "Soronti, Inc.",
	[3]byte{0, 5, 195}:     "Pacific Instruments, Inc.",
	[3]byte{0, 5, 196}:     "Telect, Inc.",
	[3]byte{0, 5, 197}:     "Flaga HF",
	[3]byte{0, 5, 198}:     "Triz Communications",
	[3]byte{0, 5, 199}:     "I/F-COM A/S",
	[3]byte{0, 5, 200}:     "VERYTECH",
	[3]byte{0, 5, 201}:     "LG Innotek Co., Ltd.",
	[3]byte{0, 5, 202}:     "Hitron Technology, Inc.",
	[3]byte{0, 5, 203}:     "ROIS Technologies, Inc.",
	[3]byte{0, 5, 204}:     "Sumtel Communications, Inc.",
	[3]byte{0, 5, 205}:     "Denon, Ltd.",
	[3]byte{0, 5, 206}:     "Prolink Microsystems Corporation",
	[3]byte{0, 5, 207}:     "Thunder River Technologies, Inc.",
	[3]byte{0, 5, 208}:     "Solinet Systems",
	[3]byte{0, 5, 209}:     "Metavector Technologies",
	[3]byte{0, 5, 210}:     "DAP Technologies",
	[3]byte{0, 5, 211}:     "eProduction Solutions, Inc.",
	[3]byte{0, 5, 212}:     "FutureSmart Networks, Inc.",
	[3]byte{0, 5, 213}:     "Speedcom Wireless",
	[3]byte{0, 5, 214}:     "L-3 Linkabit",
	[3]byte{0, 5, 215}:     "Vista Imaging, Inc.",
	[3]byte{0, 5, 216}:     "Arescom, Inc.",
	[3]byte{0, 5, 217}:     "Techno Valley, Inc.",
	[3]byte{0, 5, 218}:     "Apex Automationstechnik",
	[3]byte{0, 5, 219}:     "PSI Nentec GmbH",
	[3]byte{0, 5, 220}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 5, 221}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 5, 222}:     "Gi Fone Korea, Inc.",
	[3]byte{0, 5, 223}:     "Electronic Innovation, Inc.",
	[3]byte{0, 5, 224}:     "Empirix Corp.",
	[3]byte{0, 5, 225}:     "Trellis Photonics, Ltd.",
	[3]byte{0, 5, 226}:     "Creativ Network Technologies",
	[3]byte{0, 5, 227}:     "LightSand Communications, Inc.",
	[3]byte{0, 5, 228}:     "Red Lion Controls Inc.",
	[3]byte{0, 5, 229}:     "Renishaw PLC",
	[3]byte{0, 5, 230}:     "Egenera, Inc.",
	[3]byte{0, 5, 231}:     "Netrake an AudioCodes Company",
	[3]byte{0, 5, 232}:     "TurboWave, Inc.",
	[3]byte{0, 5, 233}:     "Unicess Network, Inc.",
	[3]byte{0, 5, 234}:     "Rednix",
	[3]byte{0, 5, 235}:     "Blue Ridge Networks, Inc.",
	[3]byte{0, 5, 236}:     "Mosaic Systems Inc.",
	[3]byte{0, 5, 237}:     "Technikum Joanneum GmbH",
	[3]byte{0, 5, 238}:     "Siemens AB, Infrastructure & Cities, Building Technologies Division, IC BT SSP SP BA PR",
	[3]byte{0, 5, 239}:     "ADOIR Digital Technology",
	[3]byte{0, 5, 240}:     "SATEC",
	[3]byte{0, 5, 241}:     "Vrcom, Inc.",
	[3]byte{0, 5, 242}:     "Power R, Inc.",
	[3]byte{0, 5, 243}:     "Webyn",
	[3]byte{0, 5, 244}:     "System Base Co., Ltd.",
	[3]byte{0, 5, 245}:     "Geospace Technologies",
	[3]byte{0, 5, 246}:     "Young Chang Co. Ltd.",
	[3]byte{0, 5, 247}:     "Analog Devices, Inc.",
	[3]byte{0, 5, 248}:     "Real Time Access, Inc.",
	[3]byte{0, 5, 249}:     "TOA Corporation",
	[3]byte{0, 5, 250}:     "IPOptical, Inc.",
	[3]byte{0, 5, 251}:     "ShareGate, Inc.",
	[3]byte{0, 5, 252}:     "Schenck Pegasus Corp.",
	[3]byte{0, 5, 253}:     "PacketLight Networks Ltd.",
	[3]byte{0, 5, 254}:     "Traficon N.V.",
	[3]byte{0, 5, 255}:     "SNS Solutions, Inc.",
	[3]byte{0, 6, 0}:       "Toshiba Teli Corporation",
	[3]byte{0, 6, 1}:       "Otanikeiki Co., Ltd.",
	[3]byte{0, 6, 2}:       "Cirkitech Electronics Co.",
	[3]byte{0, 6, 3}:       "Baker Hughes Inc.",
	[3]byte{0, 6, 4}:       "@Track Communications, Inc.",
	[3]byte{0, 6, 5}:       "Inncom International, Inc.",
	[3]byte{0, 6, 6}:       "RapidWAN, Inc.",
	[3]byte{0, 6, 7}:       "Omni Directional Control Technology Inc.",
	[3]byte{0, 6, 8}:       "At-Sky SAS",
	[3]byte{0, 6, 9}:       "Crossport Systems",
	[3]byte{0, 6, 10}:      "Blue2space",
	[3]byte{0, 6, 11}:      "Artesyn Embedded Technologies",
	[3]byte{0, 6, 12}:      "Melco Industries, Inc.",
	[3]byte{0, 6, 13}:      "Wave7 Optics",
	[3]byte{0, 6, 14}:      "IGYS Systems, Inc.",
	[3]byte{0, 6, 15}:      "Narad Networks Inc",
	[3]byte{0, 6, 16}:      "Abeona Networks Inc",
	[3]byte{0, 6, 17}:      "Zeus Wireless, Inc.",
	[3]byte{0, 6, 18}:      "Accusys, Inc.",
	[3]byte{0, 6, 19}:      "Kawasaki Microelectronics Incorporated",
	[3]byte{0, 6, 20}:      "Prism Holdings",
	[3]byte{0, 6, 21}:      "Kimoto Electric Co., Ltd.",
	[3]byte{0, 6, 22}:      "Tel Net Co., Ltd.",
	[3]byte{0, 6, 23}:      "Redswitch Inc.",
	[3]byte{0, 6, 24}:      "DigiPower Manufacturing Inc.",
	[3]byte{0, 6, 25}:      "Connection Technology Systems",
	[3]byte{0, 6, 26}:      "Zetari Inc.",
	[3]byte{0, 6, 27}:      "Notebook Development Lab.  Lenovo Japan Ltd.",
	[3]byte{0, 6, 28}:      "Hoshino Metal Industries, Ltd.",
	[3]byte{0, 6, 29}:      "MIP Telecom, Inc.",
	[3]byte{0, 6, 30}:      "Maxan Systems",
	[3]byte{0, 6, 31}:      "Vision Components GmbH",
	[3]byte{0, 6, 32}:      "Serial System Ltd.",
	[3]byte{0, 6, 33}:      "Hinox, Co., Ltd.",
	[3]byte{0, 6, 34}:      "Chung Fu Chen Yeh Enterprise Corp.",
	[3]byte{0, 6, 35}:      "MGE UPS Systems France",
	[3]byte{0, 6, 36}:      "Gentner Communications Corp.",
	[3]byte{0, 6, 37}:      "The Linksys Group, Inc.",
	[3]byte{0, 6, 38}:      "MWE GmbH",
	[3]byte{0, 6, 39}:      "Uniwide Technologies, Inc.",
	[3]byte{0, 6, 40}:      "CISCO SYSTEMS, INC.",
	[3]byte{0, 6, 41}:      "IBM Corp",
	[3]byte{0, 6, 42}:      "CISCO SYSTEMS, INC.",
	[3]byte{0, 6, 43}:      "INTRASERVER TECHNOLOGY",
	[3]byte{0, 6, 44}:      "Bivio Networks",
	[3]byte{0, 6, 45}:      "TouchStar Technologies, L.L.C.",
	[3]byte{0, 6, 46}:      "Aristos Logic Corp.",
	[3]byte{0, 6, 47}:      "Pivotech Systems Inc.",
	[3]byte{0, 6, 48}:      "Adtranz Sweden",
	[3]byte{0, 6, 49}:      "Calix",
	[3]byte{0, 6, 50}:      "Mesco Engineering GmbH",
	[3]byte{0, 6, 51}:      "Cross Match Technologies GmbH",
	[3]byte{0, 6, 52}:      "GTE Airfone Inc.",
	[3]byte{0, 6, 53}:      "PacketAir Networks, Inc.",
	[3]byte{0, 6, 54}:      "Jedai Broadband Networks",
	[3]byte{0, 6, 55}:      "Toptrend-Meta Information (ShenZhen) Inc.",
	[3]byte{0, 6, 56}:      "Sungjin C&C Co., Ltd.",
	[3]byte{0, 6, 57}:      "Newtec",
	[3]byte{0, 6, 58}:      "Dura Micro, Inc.",
	[3]byte{0, 6, 59}:      "Arcturus Networks Inc.",
	[3]byte{0, 6, 60}:      "Intrinsyc Software International Inc.",
	[3]byte{0, 6, 61}:      "Microwave Data Systems Inc.",
	[3]byte{0, 6, 62}:      "Opthos Inc.",
	[3]byte{0, 6, 63}:      "Everex Communications Inc.",
	[3]byte{0, 6, 64}:      "White Rock Networks",
	[3]byte{0, 6, 65}:      "ITCN",
	[3]byte{0, 6, 66}:      "Genetel Systems Inc.",
	[3]byte{0, 6, 67}:      "SONO Computer Co., Ltd.",
	[3]byte{0, 6, 68}:      "Neix,Inc",
	[3]byte{0, 6, 69}:      "Meisei Electric Co. Ltd.",
	[3]byte{0, 6, 70}:      "ShenZhen XunBao Network Technology Co Ltd",
	[3]byte{0, 6, 71}:      "Etrali S.A.",
	[3]byte{0, 6, 72}:      "Seedsware, Inc.",
	[3]byte{0, 6, 73}:      "3M Deutschland GmbH",
	[3]byte{0, 6, 74}:      "Honeywell Co., Ltd. (KOREA)",
	[3]byte{0, 6, 75}:      "Alexon Co., Ltd.",
	[3]byte{0, 6, 76}:      "Invicta Networks, Inc.",
	[3]byte{0, 6, 77}:      "Sencore",
	[3]byte{0, 6, 78}:      "Broad Net Technology Inc.",
	[3]byte{0, 6, 79}:      "PRO-NETS Technology Corporation",
	[3]byte{0, 6, 80}:      "Tiburon Networks, Inc.",
	[3]byte{0, 6, 81}:      "Aspen Networks Inc.",
	[3]byte{0, 6, 82}:      "CISCO SYSTEMS, INC.",
	[3]byte{0, 6, 83}:      "CISCO SYSTEMS, INC.",
	[3]byte{0, 6, 84}:      "Winpresa Building Automation Technologies GmbH",
	[3]byte{0, 6, 85}:      "Yipee, Inc.",
	[3]byte{0, 6, 86}:      "Tactel AB",
	[3]byte{0, 6, 87}:      "Market Central, Inc.",
	[3]byte{0, 6, 88}:      "Helmut Fischer GmbH Institut für Elektronik und Messtechnik",
	[3]byte{0, 6, 89}:      "EAL (Apeldoorn) B.V.",
	[3]byte{0, 6, 90}:      "Strix Systems",
	[3]byte{0, 6, 91}:      "Dell Computer Corp.",
	[3]byte{0, 6, 92}:      "Malachite Technologies, Inc.",
	[3]byte{0, 6, 93}:      "Heidelberg Web Systems",
	[3]byte{0, 6, 94}:      "Photuris, Inc.",
	[3]byte{0, 6, 95}:      "ECI Telecom - NGTS Ltd.",
	[3]byte{0, 6, 96}:      "NADEX Co., Ltd.",
	[3]byte{0, 6, 97}:      "NIA Home Technologies Corp.",
	[3]byte{0, 6, 98}:      "MBM Technology Ltd.",
	[3]byte{0, 6, 99}:      "Human Technology Co., Ltd.",
	[3]byte{0, 6, 100}:     "Fostex Corporation",
	[3]byte{0, 6, 101}:     "Sunny Giken, Inc.",
	[3]byte{0, 6, 102}:     "Roving Networks",
	[3]byte{0, 6, 103}:     "Tripp Lite",
	[3]byte{0, 6, 104}:     "Vicon Industries Inc.",
	[3]byte{0, 6, 105}:     "Datasound Laboratories Ltd",
	[3]byte{0, 6, 106}:     "InfiniCon Systems, Inc.",
	[3]byte{0, 6, 107}:     "Sysmex Corporation",
	[3]byte{0, 6, 108}:     "Robinson Corporation",
	[3]byte{0, 6, 109}:     "Compuprint S.P.A.",
	[3]byte{0, 6, 110}:     "Delta Electronics, Inc.",
	[3]byte{0, 6, 111}:     "Korea Data Systems",
	[3]byte{0, 6, 112}:     "Upponetti Oy",
	[3]byte{0, 6, 113}:     "Softing AG",
	[3]byte{0, 6, 114}:     "Netezza",
	[3]byte{0, 6, 115}:     "TKH Security Solutions USA",
	[3]byte{0, 6, 116}:     "Spectrum Control, Inc.",
	[3]byte{0, 6, 117}:     "Banderacom, Inc.",
	[3]byte{0, 6, 118}:     "Novra Technologies Inc.",
	[3]byte{0, 6, 119}:     "SICK AG",
	[3]byte{0, 6, 120}:     "Marantz Brand Company",
	[3]byte{0, 6, 121}:     "Konami Corporation",
	[3]byte{0, 6, 122}:     "JMP Systems",
	[3]byte{0, 6, 123}:     "Toplink C&C Corporation",
	[3]byte{0, 6, 124}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 6, 125}:     "Takasago Ltd.",
	[3]byte{0, 6, 126}:     "WinCom Systems, Inc.",
	[3]byte{0, 6, 127}:     "Digeo, Inc.",
	[3]byte{0, 6, 128}:     "Card Access, Inc.",
	[3]byte{0, 6, 129}:     "Goepel Electronic GmbH",
	[3]byte{0, 6, 130}:     "Convedia",
	[3]byte{0, 6, 131}:     "Bravara Communications, Inc.",
	[3]byte{0, 6, 132}:     "Biacore AB",
	[3]byte{0, 6, 133}:     "NetNearU Corporation",
	[3]byte{0, 6, 134}:     "ZARDCOM Co., Ltd.",
	[3]byte{0, 6, 135}:     "Omnitron Systems Technology, Inc.",
	[3]byte{0, 6, 136}:     "Telways Communication Co., Ltd.",
	[3]byte{0, 6, 137}:     "yLez Technologies Pte Ltd",
	[3]byte{0, 6, 138}:     "NeuronNet Co. Ltd. R&D Center",
	[3]byte{0, 6, 139}:     "AirRunner Technologies, Inc.",
	[3]byte{0, 6, 140}:     "3Com Corporation",
	[3]byte{0, 6, 141}:     "SEPATON, Inc.",
	[3]byte{0, 6, 142}:     "HID Corporation",
	[3]byte{0, 6, 143}:     "Telemonitor, Inc.",
	[3]byte{0, 6, 144}:     "Euracom Communication GmbH",
	[3]byte{0, 6, 145}:     "PT Inovacao",
	[3]byte{0, 6, 146}:     "Intruvert Networks, Inc.",
	[3]byte{0, 6, 147}:     "Flexus Computer Technology, Inc.",
	[3]byte{0, 6, 148}:     "Mobillian Corporation",
	[3]byte{0, 6, 149}:     "Ensure Technologies, Inc.",
	[3]byte{0, 6, 150}:     "Advent Networks",
	[3]byte{0, 6, 151}:     "R & D Center",
	[3]byte{0, 6, 152}:     "egnite GmbH",
	[3]byte{0, 6, 153}:     "Vida Design Co.",
	[3]byte{0, 6, 154}:     "e & Tel",
	[3]byte{0, 6, 155}:     "AVT Audio Video Technologies GmbH",
	[3]byte{0, 6, 156}:     "Transmode Systems AB",
	[3]byte{0, 6, 157}:     "Petards Ltd",
	[3]byte{0, 6, 158}:     "UNIQA, Inc.",
	[3]byte{0, 6, 159}:     "Kuokoa Networks",
	[3]byte{0, 6, 160}:     "Mx Imaging",
	[3]byte{0, 6, 161}:     "Celsian Technologies, Inc.",
	[3]byte{0, 6, 162}:     "Microtune, Inc.",
	[3]byte{0, 6, 163}:     "Bitran Corporation",
	[3]byte{0, 6, 164}:     "INNOWELL Corp.",
	[3]byte{0, 6, 165}:     "PINON Corp.",
	[3]byte{0, 6, 166}:     "Artistic Licence Engineering Ltd",
	[3]byte{0, 6, 167}:     "Primarion",
	[3]byte{0, 6, 168}:     "KC Technology, Inc.",
	[3]byte{0, 6, 169}:     "Universal Instruments Corp.",
	[3]byte{0, 6, 170}:     "VT Miltope",
	[3]byte{0, 6, 171}:     "W-Link Systems, Inc.",
	[3]byte{0, 6, 172}:     "Intersoft Co.",
	[3]byte{0, 6, 173}:     "KB Electronics Ltd.",
	[3]byte{0, 6, 174}:     "Himachal Futuristic Communications Ltd",
	[3]byte{0, 6, 175}:     "Xalted Networks",
	[3]byte{0, 6, 176}:     "Comtech EF Data Corp.",
	[3]byte{0, 6, 177}:     "Sonicwall",
	[3]byte{0, 6, 178}:     "Linxtek Co.",
	[3]byte{0, 6, 179}:     "Diagraph Corporation",
	[3]byte{0, 6, 180}:     "Vorne Industries, Inc.",
	[3]byte{0, 6, 181}:     "Source Photonics, Inc.",
	[3]byte{0, 6, 182}:     "Nir-Or Israel Ltd.",
	[3]byte{0, 6, 183}:     "TELEM GmbH",
	[3]byte{0, 6, 184}:     "Bandspeed Pty Ltd",
	[3]byte{0, 6, 185}:     "A5TEK Corp.",
	[3]byte{0, 6, 186}:     "Westwave Communications",
	[3]byte{0, 6, 187}:     "ATI Technologies Inc.",
	[3]byte{0, 6, 188}:     "Macrolink, Inc.",
	[3]byte{0, 6, 189}:     "BNTECHNOLOGY Co., Ltd.",
	[3]byte{0, 6, 190}:     "Baumer Optronic GmbH",
	[3]byte{0, 6, 191}:     "Accella Technologies Co., Ltd.",
	[3]byte{0, 6, 192}:     "United Internetworks, Inc.",
	[3]byte{0, 6, 193}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 6, 194}:     "Smartmatic Corporation",
	[3]byte{0, 6, 195}:     "Schindler Elevator Ltd.",
	[3]byte{0, 6, 196}:     "Piolink Inc.",
	[3]byte{0, 6, 197}:     "INNOVI Technologies Limited",
	[3]byte{0, 6, 198}:     "lesswire AG",
	[3]byte{0, 6, 199}:     "RFNET Technologies Pte Ltd (S)",
	[3]byte{0, 6, 200}:     "Sumitomo Metal Micro Devices, Inc.",
	[3]byte{0, 6, 201}:     "Technical Marketing Research, Inc.",
	[3]byte{0, 6, 202}:     "American Computer & Digital Components, Inc. (ACDC)",
	[3]byte{0, 6, 203}:     "Jotron Electronics A/S",
	[3]byte{0, 6, 204}:     "JMI Electronics Co., Ltd.",
	[3]byte{0, 6, 205}:     "Leaf Imaging Ltd.",
	[3]byte{0, 6, 206}:     "DATENO",
	[3]byte{0, 6, 207}:     "Thales Avionics In-Flight Systems, LLC",
	[3]byte{0, 6, 208}:     "Elgar Electronics Corp.",
	[3]byte{0, 6, 209}:     "Tahoe Networks, Inc.",
	[3]byte{0, 6, 210}:     "Tundra Semiconductor Corp.",
	[3]byte{0, 6, 211}:     "Alpha Telecom, Inc. U.S.A.",
	[3]byte{0, 6, 212}:     "Interactive Objects, Inc.",
	[3]byte{0, 6, 213}:     "Diamond Systems Corp.",
	[3]byte{0, 6, 214}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 6, 215}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 6, 216}:     "Maple Optical Systems",
	[3]byte{0, 6, 217}:     "IPM-Net S.p.A.",
	[3]byte{0, 6, 218}:     "ITRAN Communications Ltd.",
	[3]byte{0, 6, 219}:     "ICHIPS Co., Ltd.",
	[3]byte{0, 6, 220}:     "Syabas Technology (Amquest)",
	[3]byte{0, 6, 221}:     "AT & T Laboratories - Cambridge Ltd",
	[3]byte{0, 6, 222}:     "Flash Technology",
	[3]byte{0, 6, 223}:     "AIDONIC Corporation",
	[3]byte{0, 6, 224}:     "MAT Co., Ltd.",
	[3]byte{0, 6, 225}:     "Techno Trade s.a",
	[3]byte{0, 6, 226}:     "Ceemax Technology Co., Ltd.",
	[3]byte{0, 6, 227}:     "Quantitative Imaging Corporation",
	[3]byte{0, 6, 228}:     "Citel Technologies Ltd.",
	[3]byte{0, 6, 229}:     "Fujian Newland Computer Ltd. Co.",
	[3]byte{0, 6, 230}:     "DongYang Telecom Co., Ltd.",
	[3]byte{0, 6, 231}:     "Bit Blitz Communications Inc.",
	[3]byte{0, 6, 232}:     "Optical Network Testing, Inc.",
	[3]byte{0, 6, 233}:     "Intime Corp.",
	[3]byte{0, 6, 234}:     "ELZET80 Mikrocomputer GmbH&Co. KG",
	[3]byte{0, 6, 235}:     "Global Data",
	[3]byte{0, 6, 236}:     "Harris Corporation",
	[3]byte{0, 6, 237}:     "Inara Networks",
	[3]byte{0, 6, 238}:     "Shenyang Neu-era Information & Technology Stock Co., Ltd",
	[3]byte{0, 6, 239}:     "Maxxan Systems, Inc.",
	[3]byte{0, 6, 240}:     "Digeo, Inc.",
	[3]byte{0, 6, 241}:     "Optillion",
	[3]byte{0, 6, 242}:     "Platys Communications",
	[3]byte{0, 6, 243}:     "AcceLight Networks",
	[3]byte{0, 6, 244}:     "Prime Electronics & Satellitics Inc.",
	[3]byte{0, 6, 245}:     "ALPS Co,. Ltd.",
	[3]byte{0, 6, 246}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 6, 247}:     "ALPS Co,. Ltd.",
	[3]byte{0, 6, 248}:     "The Boeing Company",
	[3]byte{0, 6, 249}:     "Mitsui Zosen Systems Research Inc.",
	[3]byte{0, 6, 250}:     "IP SQUARE Co, Ltd.",
	[3]byte{0, 6, 251}:     "Hitachi Printing Solutions, Ltd.",
	[3]byte{0, 6, 252}:     "Fnet Co., Ltd.",
	[3]byte{0, 6, 253}:     "Comjet Information Systems Corp.",
	[3]byte{0, 6, 254}:     "Ambrado, Inc",
	[3]byte{0, 6, 255}:     "Sheba Systems Co., Ltd.",
	[3]byte{0, 7, 0}:       "Zettamedia Korea",
	[3]byte{0, 7, 1}:       "RACAL-DATACOM",
	[3]byte{0, 7, 2}:       "Varian Medical Systems",
	[3]byte{0, 7, 3}:       "CSEE Transport",
	[3]byte{0, 7, 4}:       "ALPS Co,. Ltd.",
	[3]byte{0, 7, 5}:       "Endress & Hauser GmbH & Co",
	[3]byte{0, 7, 6}:       "Sanritz Corporation",
	[3]byte{0, 7, 7}:       "Interalia Inc.",
	[3]byte{0, 7, 8}:       "Bitrage Inc.",
	[3]byte{0, 7, 9}:       "Westerstrand Urfabrik AB",
	[3]byte{0, 7, 10}:      "Unicom Automation Co., Ltd.",
	[3]byte{0, 7, 11}:      "Novabase SGPS, SA",
	[3]byte{0, 7, 12}:      "SVA-Intrusion.com Co. Ltd.",
	[3]byte{0, 7, 13}:      "CISCO SYSTEMS, INC.",
	[3]byte{0, 7, 14}:      "CISCO SYSTEMS, INC.",
	[3]byte{0, 7, 15}:      "Fujant, Inc.",
	[3]byte{0, 7, 16}:      "Adax, Inc.",
	[3]byte{0, 7, 17}:      "Acterna",
	[3]byte{0, 7, 18}:      "JAL Information Technology",
	[3]byte{0, 7, 19}:      "IP One, Inc.",
	[3]byte{0, 7, 20}:      "Brightcom",
	[3]byte{0, 7, 21}:      "General Research of Electronics, Inc.",
	[3]byte{0, 7, 22}:      "J & S Marine Ltd.",
	[3]byte{0, 7, 23}:      "Wieland Electric GmbH",
	[3]byte{0, 7, 24}:      "iCanTek Co., Ltd.",
	[3]byte{0, 7, 25}:      "Mobiis Co., Ltd.",
	[3]byte{0, 7, 26}:      "Finedigital Inc.",
	[3]byte{0, 7, 27}:      "CDVI Americas Ltd",
	[3]byte{0, 7, 28}:      "AT&T Fixed Wireless Services",
	[3]byte{0, 7, 29}:      "Satelsa Sistemas Y Aplicaciones De Telecomunicaciones, S.A.",
	[3]byte{0, 7, 30}:      "Tri-M Engineering / Nupak Dev. Corp.",
	[3]byte{0, 7, 31}:      "European Systems Integration",
	[3]byte{0, 7, 32}:      "Trutzschler GmbH & Co. KG",
	[3]byte{0, 7, 33}:      "Formac Elektronik GmbH",
	[3]byte{0, 7, 34}:      "The Nielsen Company",
	[3]byte{0, 7, 35}:      "ELCON Systemtechnik GmbH",
	[3]byte{0, 7, 36}:      "Telemax Co., Ltd.",
	[3]byte{0, 7, 37}:      "Bematech International Corp.",
	[3]byte{0, 7, 38}:      "Shenzhen Gongjin Electronics Co., Ltd.",
	[3]byte{0, 7, 39}:      "Zi Corporation (HK) Ltd.",
	[3]byte{0, 7, 40}:      "Neo Telecom",
	[3]byte{0, 7, 41}:      "Kistler Instrumente AG",
	[3]byte{0, 7, 42}:      "Innovance Networks",
	[3]byte{0, 7, 43}:      "Jung Myung Telecom Co., Ltd.",
	[3]byte{0, 7, 44}:      "Fabricom",
	[3]byte{0, 7, 45}:      "CNSystems",
	[3]byte{0, 7, 46}:      "North Node AB",
	[3]byte{0, 7, 47}:      "Intransa, Inc.",
	[3]byte{0, 7, 48}:      "Hutchison OPTEL Telecom Technology Co., Ltd.",
	[3]byte{0, 7, 49}:      "Ophir-Spiricon LLC",
	[3]byte{0, 7, 50}:      "AAEON Technology Inc.",
	[3]byte{0, 7, 51}:      "DANCONTROL Engineering",
	[3]byte{0, 7, 52}:      "ONStor, Inc.",
	[3]byte{0, 7, 53}:      "Flarion Technologies, Inc.",
	[3]byte{0, 7, 54}:      "Data Video Technologies Co., Ltd.",
	[3]byte{0, 7, 55}:      "Soriya Co. Ltd.",
	[3]byte{0, 7, 56}:      "Young Technology Co., Ltd.",
	[3]byte{0, 7, 57}:      "Scotty Group Austria Gmbh",
	[3]byte{0, 7, 58}:      "Inventel Systemes",
	[3]byte{0, 7, 59}:      "Tenovis GmbH & Co KG",
	[3]byte{0, 7, 60}:      "Telecom Design",
	[3]byte{0, 7, 61}:      "Nanjing Postel Telecommunications Co., Ltd.",
	[3]byte{0, 7, 62}:      "China Great-Wall Computer Shenzhen Co., Ltd.",
	[3]byte{0, 7, 63}:      "Woojyun Systec Co., Ltd.",
	[3]byte{0, 7, 64}:      "Buffalo Inc.",
	[3]byte{0, 7, 65}:      "Sierra Automated Systems",
	[3]byte{0, 7, 66}:      "Current Technologies, LLC",
	[3]byte{0, 7, 67}:      "Chelsio Communications",
	[3]byte{0, 7, 68}:      "Unico, Inc.",
	[3]byte{0, 7, 69}:      "Radlan Computer Communications Ltd.",
	[3]byte{0, 7, 70}:      "TURCK, Inc.",
	[3]byte{0, 7, 71}:      "Mecalc",
	[3]byte{0, 7, 72}:      "The Imaging Source Europe",
	[3]byte{0, 7, 73}:      "CENiX Inc.",
	[3]byte{0, 7, 74}:      "Carl Valentin GmbH",
	[3]byte{0, 7, 75}:      "Daihen Corporation",
	[3]byte{0, 7, 76}:      "Beicom Inc.",
	[3]byte{0, 7, 77}:      "Zebra Technologies Corp.",
	[3]byte{0, 7, 78}:      "IPFRONT Inc",
	[3]byte{0, 7, 79}:      "CISCO SYSTEMS, INC.",
	[3]byte{0, 7, 80}:      "CISCO SYSTEMS, INC.",
	[3]byte{0, 7, 81}:      "m-u-t AG",
	[3]byte{0, 7, 82}:      "Rhythm Watch Co., Ltd.",
	[3]byte{0, 7, 83}:      "Beijing Qxcomm Technology Co., Ltd.",
	[3]byte{0, 7, 84}:      "Xyterra Computing, Inc.",
	[3]byte{0, 7, 85}:      "Lafon",
	[3]byte{0, 7, 86}:      "Juyoung Telecom",
	[3]byte{0, 7, 87}:      "Topcall International AG",
	[3]byte{0, 7, 88}:      "Dragonwave",
	[3]byte{0, 7, 89}:      "Boris Manufacturing Corp.",
	[3]byte{0, 7, 90}:      "Air Products and Chemicals, Inc.",
	[3]byte{0, 7, 91}:      "Gibson Guitars",
	[3]byte{0, 7, 92}:      "Eastman Kodak Company",
	[3]byte{0, 7, 93}:      "Celleritas Inc.",
	[3]byte{0, 7, 94}:      "Ametek Power Instruments",
	[3]byte{0, 7, 95}:      "VCS Video Communication Systems AG",
	[3]byte{0, 7, 96}:      "TOMIS Information & Telecom Corp.",
	[3]byte{0, 7, 97}:      "Logitech Europe SA",
	[3]byte{0, 7, 98}:      "Group Sense Limited",
	[3]byte{0, 7, 99}:      "Sunniwell Cyber Tech. Co., Ltd.",
	[3]byte{0, 7, 100}:     "YoungWoo Telecom Co. Ltd.",
	[3]byte{0, 7, 101}:     "Jade Quantum Technologies, Inc.",
	[3]byte{0, 7, 102}:     "Chou Chin Industrial Co., Ltd.",
	[3]byte{0, 7, 103}:     "Yuxing Electronics Company Limited",
	[3]byte{0, 7, 104}:     "Danfoss A/S",
	[3]byte{0, 7, 105}:     "Italiana Macchi SpA",
	[3]byte{0, 7, 106}:     "NEXTEYE Co., Ltd.",
	[3]byte{0, 7, 107}:     "Stralfors AB",
	[3]byte{0, 7, 108}:     "Daehanet, Inc.",
	[3]byte{0, 7, 109}:     "Flexlight Networks",
	[3]byte{0, 7, 110}:     "Sinetica Corporation Limited",
	[3]byte{0, 7, 111}:     "Synoptics Limited",
	[3]byte{0, 7, 112}:     "Ubiquoss Inc",
	[3]byte{0, 7, 113}:     "Embedded System Corporation",
	[3]byte{0, 7, 114}:     "Alcatel Shanghai Bell Co., Ltd.",
	[3]byte{0, 7, 115}:     "Ascom Powerline Communications Ltd.",
	[3]byte{0, 7, 116}:     "GuangZhou Thinker Technology Co. Ltd.",
	[3]byte{0, 7, 117}:     "Valence Semiconductor, Inc.",
	[3]byte{0, 7, 118}:     "Federal APD",
	[3]byte{0, 7, 119}:     "Motah Ltd.",
	[3]byte{0, 7, 120}:     "GERSTEL GmbH & Co. KG",
	[3]byte{0, 7, 121}:     "Sungil Telecom Co., Ltd.",
	[3]byte{0, 7, 122}:     "Infoware System Co., Ltd.",
	[3]byte{0, 7, 123}:     "Millimetrix Broadband Networks",
	[3]byte{0, 7, 124}:     "Westermo Teleindustri AB",
	[3]byte{0, 7, 125}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 7, 126}:     "Elrest GmbH",
	[3]byte{0, 7, 127}:     "J Communications Co., Ltd.",
	[3]byte{0, 7, 128}:     "Bluegiga Technologies OY",
	[3]byte{0, 7, 129}:     "Itron Inc.",
	[3]byte{0, 7, 130}:     "Oracle Corporation",
	[3]byte{0, 7, 131}:     "SynCom Network, Inc.",
	[3]byte{0, 7, 132}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 7, 133}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 7, 134}:     "Wireless Networks Inc.",
	[3]byte{0, 7, 135}:     "Idea System Co., Ltd.",
	[3]byte{0, 7, 136}:     "Clipcomm, Inc.",
	[3]byte{0, 7, 137}:     "DONGWON SYSTEMS",
	[3]byte{0, 7, 138}:     "Mentor Data System Inc.",
	[3]byte{0, 7, 139}:     "Wegener Communications, Inc.",
	[3]byte{0, 7, 140}:     "Elektronikspecialisten i Borlange AB",
	[3]byte{0, 7, 141}:     "NetEngines Ltd.",
	[3]byte{0, 7, 142}:     "Garz & Friche GmbH",
	[3]byte{0, 7, 143}:     "Emkay Innovative Products",
	[3]byte{0, 7, 144}:     "Tri-M Technologies (s) Limited",
	[3]byte{0, 7, 145}:     "International Data Communications, Inc.",
	[3]byte{0, 7, 146}:     "Sütron Electronic GmbH",
	[3]byte{0, 7, 147}:     "Shin Satellite Public Company Limited",
	[3]byte{0, 7, 148}:     "Simple Devices, Inc.",
	[3]byte{0, 7, 149}:     "Elitegroup Computer System Co. (ECS)",
	[3]byte{0, 7, 150}:     "LSI Systems, Inc.",
	[3]byte{0, 7, 151}:     "Netpower Co., Ltd.",
	[3]byte{0, 7, 152}:     "Selea SRL",
	[3]byte{0, 7, 153}:     "Tipping Point Technologies, Inc.",
	[3]byte{0, 7, 154}:     "Verint Systems Inc",
	[3]byte{0, 7, 155}:     "Aurora Networks",
	[3]byte{0, 7, 156}:     "Golden Electronics Technology Co., Ltd.",
	[3]byte{0, 7, 157}:     "Musashi Co., Ltd.",
	[3]byte{0, 7, 158}:     "Ilinx Co., Ltd.",
	[3]byte{0, 7, 159}:     "Action Digital Inc.",
	[3]byte{0, 7, 160}:     "e-Watch Inc.",
	[3]byte{0, 7, 161}:     "VIASYS Healthcare GmbH",
	[3]byte{0, 7, 162}:     "Opteon Corporation",
	[3]byte{0, 7, 163}:     "Ositis Software, Inc.",
	[3]byte{0, 7, 164}:     "GN Netcom Ltd.",
	[3]byte{0, 7, 165}:     "Y.D.K Co. Ltd.",
	[3]byte{0, 7, 166}:     "Home Automation, Inc.",
	[3]byte{0, 7, 167}:     "A-Z Inc.",
	[3]byte{0, 7, 168}:     "Haier Group Technologies Ltd.",
	[3]byte{0, 7, 169}:     "Novasonics",
	[3]byte{0, 7, 170}:     "Quantum Data Inc.",
	[3]byte{0, 7, 171}:     "Samsung Electronics Co.,Ltd",
	[3]byte{0, 7, 172}:     "Eolring",
	[3]byte{0, 7, 173}:     "Pentacon GmbH Foto-und Feinwerktechnik",
	[3]byte{0, 7, 174}:     "Britestream Networks, Inc.",
	[3]byte{0, 7, 175}:     "N-TRON Corporation",
	[3]byte{0, 7, 176}:     "Office Details, Inc.",
	[3]byte{0, 7, 177}:     "Equator Technologies",
	[3]byte{0, 7, 178}:     "Transaccess S.A.",
	[3]byte{0, 7, 179}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 7, 180}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 7, 181}:     "Any One Wireless Ltd.",
	[3]byte{0, 7, 182}:     "Telecom Technology Ltd.",
	[3]byte{0, 7, 183}:     "Samurai Ind. Prods Eletronicos Ltda",
	[3]byte{0, 7, 184}:     "Corvalent Corporation",
	[3]byte{0, 7, 185}:     "Ginganet Corporation",
	[3]byte{0, 7, 186}:     "UTStarcom, Inc.",
	[3]byte{0, 7, 187}:     "Candera Inc.",
	[3]byte{0, 7, 188}:     "Identix Inc.",
	[3]byte{0, 7, 189}:     "Radionet Ltd.",
	[3]byte{0, 7, 190}:     "DataLogic SpA",
	[3]byte{0, 7, 191}:     "Armillaire Technologies, Inc.",
	[3]byte{0, 7, 192}:     "NetZerver Inc.",
	[3]byte{0, 7, 193}:     "Overture Networks, Inc.",
	[3]byte{0, 7, 194}:     "Netsys Telecom",
	[3]byte{0, 7, 195}:     "Thomson",
	[3]byte{0, 7, 196}:     "JEAN Co. Ltd.",
	[3]byte{0, 7, 197}:     "Gcom, Inc.",
	[3]byte{0, 7, 198}:     "VDS Vosskuhler GmbH",
	[3]byte{0, 7, 199}:     "Synectics Systems Limited",
	[3]byte{0, 7, 200}:     "Brain21, Inc.",
	[3]byte{0, 7, 201}:     "Technol Seven Co., Ltd.",
	[3]byte{0, 7, 202}:     "Creatix Polymedia Ges Fur Kommunikaitonssysteme",
	[3]byte{0, 7, 203}:     "Freebox SA",
	[3]byte{0, 7, 204}:     "Kaba Benzing GmbH",
	[3]byte{0, 7, 205}:     "Kumoh Electronic Co, Ltd",
	[3]byte{0, 7, 206}:     "Cabletime Limited",
	[3]byte{0, 7, 207}:     "Anoto AB",
	[3]byte{0, 7, 208}:     "Automat Engenharia de Automação Ltda.",
	[3]byte{0, 7, 209}:     "Spectrum Signal Processing Inc.",
	[3]byte{0, 7, 210}:     "Logopak Systeme GmbH & Co. KG",
	[3]byte{0, 7, 211}:     "SPGPrints B.V.",
	[3]byte{0, 7, 212}:     "Zhejiang Yutong Network Communication Co Ltd.",
	[3]byte{0, 7, 213}:     "3e Technologies Int;., Inc.",
	[3]byte{0, 7, 214}:     "Commil Ltd.",
	[3]byte{0, 7, 215}:     "Caporis Networks AG",
	[3]byte{0, 7, 216}:     "Hitron Systems Inc.",
	[3]byte{0, 7, 217}:     "Splicecom",
	[3]byte{0, 7, 218}:     "Neuro Telecom Co., Ltd.",
	[3]byte{0, 7, 219}:     "Kirana Networks, Inc.",
	[3]byte{0, 7, 220}:     "Atek Co, Ltd.",
	[3]byte{0, 7, 221}:     "Cradle Technologies",
	[3]byte{0, 7, 222}:     "eCopilt AB",
	[3]byte{0, 7, 223}:     "Vbrick Systems Inc.",
	[3]byte{0, 7, 224}:     "Palm Inc.",
	[3]byte{0, 7, 225}:     "WIS Communications Co. Ltd.",
	[3]byte{0, 7, 226}:     "Bitworks, Inc.",
	[3]byte{0, 7, 227}:     "Navcom Technology, Inc.",
	[3]byte{0, 7, 228}:     "SoftRadio Co., Ltd.",
	[3]byte{0, 7, 229}:     "Coup Corporation",
	[3]byte{0, 7, 230}:     "edgeflow Canada Inc.",
	[3]byte{0, 7, 231}:     "FreeWave Technologies",
	[3]byte{0, 7, 232}:     "EdgeWave",
	[3]byte{0, 7, 233}:     "Intel Corporation",
	[3]byte{0, 7, 234}:     "Massana, Inc.",
	[3]byte{0, 7, 235}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 7, 236}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 7, 237}:     "Altera Corporation",
	[3]byte{0, 7, 238}:     "telco Informationssysteme GmbH",
	[3]byte{0, 7, 239}:     "Lockheed Martin Tactical Systems",
	[3]byte{0, 7, 240}:     "LogiSync LLC",
	[3]byte{0, 7, 241}:     "TeraBurst Networks Inc.",
	[3]byte{0, 7, 242}:     "IOA Corporation",
	[3]byte{0, 7, 243}:     "Thinkengine Networks",
	[3]byte{0, 7, 244}:     "Eletex Co., Ltd.",
	[3]byte{0, 7, 245}:     "Bridgeco Co AG",
	[3]byte{0, 7, 246}:     "Qqest Software Systems",
	[3]byte{0, 7, 247}:     "Galtronics",
	[3]byte{0, 7, 248}:     "ITDevices, Inc.",
	[3]byte{0, 7, 249}:     "Sensaphone",
	[3]byte{0, 7, 250}:     "ITT Co., Ltd.",
	[3]byte{0, 7, 251}:     "Giga Stream UMTS Technologies GmbH",
	[3]byte{0, 7, 252}:     "Adept Systems Inc.",
	[3]byte{0, 7, 253}:     "LANergy Ltd.",
	[3]byte{0, 7, 254}:     "Rigaku Corporation",
	[3]byte{0, 7, 255}:     "Gluon Networks",
	[3]byte{0, 8, 0}:       "MULTITECH SYSTEMS, INC.",
	[3]byte{0, 8, 1}:       "HighSpeed Surfing Inc.",
	[3]byte{0, 8, 2}:       "Hewlett-Packard Company",
	[3]byte{0, 8, 3}:       "Cos Tron",
	[3]byte{0, 8, 4}:       "ICA Inc.",
	[3]byte{0, 8, 5}:       "Techno-Holon Corporation",
	[3]byte{0, 8, 6}:       "Raonet Systems, Inc.",
	[3]byte{0, 8, 7}:       "Access Devices Limited",
	[3]byte{0, 8, 8}:       "PPT Vision, Inc.",
	[3]byte{0, 8, 9}:       "Systemonic AG",
	[3]byte{0, 8, 10}:      "Espera-Werke GmbH",
	[3]byte{0, 8, 11}:      "Birka BPA Informationssystem AB",
	[3]byte{0, 8, 12}:      "VDA Elettronica spa",
	[3]byte{0, 8, 13}:      "Toshiba",
	[3]byte{0, 8, 14}:      "ARRIS Group, Inc.",
	[3]byte{0, 8, 15}:      "Proximion Fiber Optics AB",
	[3]byte{0, 8, 16}:      "Key Technology, Inc.",
	[3]byte{0, 8, 17}:      "VOIX Corporation",
	[3]byte{0, 8, 18}:      "GM-2 Corporation",
	[3]byte{0, 8, 19}:      "Diskbank, Inc.",
	[3]byte{0, 8, 20}:      "TIL Technologies",
	[3]byte{0, 8, 21}:      "CATS Co., Ltd.",
	[3]byte{0, 8, 22}:      "Bluelon ApS",
	[3]byte{0, 8, 23}:      "EmergeCore Networks LLC",
	[3]byte{0, 8, 24}:      "Pixelworks, Inc.",
	[3]byte{0, 8, 25}:      "Banksys",
	[3]byte{0, 8, 26}:      "Sanrad Intelligence Storage Communications (2000) Ltd.",
	[3]byte{0, 8, 27}:      "Windigo Systems",
	[3]byte{0, 8, 28}:      "@pos.com",
	[3]byte{0, 8, 29}:      "Ipsil, Incorporated",
	[3]byte{0, 8, 30}:      "Repeatit AB",
	[3]byte{0, 8, 31}:      "Pou Yuen Tech Corp. Ltd.",
	[3]byte{0, 8, 32}:      "CISCO SYSTEMS, INC.",
	[3]byte{0, 8, 33}:      "CISCO SYSTEMS, INC.",
	[3]byte{0, 8, 34}:      "InPro Comm",
	[3]byte{0, 8, 35}:      "Texa Corp.",
	[3]byte{0, 8, 36}:      "Nuance Document Imaging",
	[3]byte{0, 8, 37}:      "Acme Packet",
	[3]byte{0, 8, 38}:      "Colorado Med Tech",
	[3]byte{0, 8, 39}:      "ADB Broadband Italia",
	[3]byte{0, 8, 40}:      "Koei Engineering Ltd.",
	[3]byte{0, 8, 41}:      "Aval Nagasaki Corporation",
	[3]byte{0, 8, 42}:      "Powerwallz Network Security",
	[3]byte{0, 8, 43}:      "Wooksung Electronics, Inc.",
	[3]byte{0, 8, 44}:      "Homag AG",
	[3]byte{0, 8, 45}:      "Indus Teqsite Private Limited",
	[3]byte{0, 8, 46}:      "Multitone Electronics PLC",
	[3]byte{0, 8, 47}:      "CISCO SYSTEMS, INC.",
	[3]byte{0, 8, 48}:      "CISCO SYSTEMS, INC.",
	[3]byte{0, 8, 49}:      "CISCO SYSTEMS, INC.",
	[3]byte{0, 8, 50}:      "Cisco",
	[3]byte{0, 8, 78}:      "DivergeNet, Inc.",
	[3]byte{0, 8, 79}:      "Qualstar Corporation",
	[3]byte{0, 8, 80}:      "Arizona Instrument Corp.",
	[3]byte{0, 8, 81}:      "Canadian Bank Note Company, Ltd.",
	[3]byte{0, 8, 82}:      "Davolink Co. Inc.",
	[3]byte{0, 8, 83}:      "Schleicher GmbH & Co. Relaiswerke KG",
	[3]byte{0, 8, 84}:      "Netronix, Inc.",
	[3]byte{0, 8, 85}:      "NASA-Goddard Space Flight Center",
	[3]byte{0, 8, 86}:      "Gamatronic Electronic Industries Ltd.",
	[3]byte{0, 8, 87}:      "Polaris Networks, Inc.",
	[3]byte{0, 8, 88}:      "Novatechnology Inc.",
	[3]byte{0, 8, 89}:      "ShenZhen Unitone Electronics Co., Ltd.",
	[3]byte{0, 8, 90}:      "IntiGate Inc.",
	[3]byte{0, 8, 91}:      "Hanbit Electronics Co., Ltd.",
	[3]byte{0, 8, 92}:      "Shanghai Dare Technologies Co. Ltd.",
	[3]byte{0, 8, 93}:      "Aastra",
	[3]byte{0, 8, 94}:      "PCO AG",
	[3]byte{0, 8, 95}:      "Picanol N.V.",
	[3]byte{0, 8, 96}:      "LodgeNet Entertainment Corp.",
	[3]byte{0, 8, 97}:      "SoftEnergy Co., Ltd.",
	[3]byte{0, 8, 98}:      "NEC Eluminant Technologies, Inc.",
	[3]byte{0, 8, 99}:      "Entrisphere Inc.",
	[3]byte{0, 8, 100}:     "Fasy S.p.A.",
	[3]byte{0, 8, 101}:     "JASCOM CO., LTD",
	[3]byte{0, 8, 102}:     "DSX Access Systems, Inc.",
	[3]byte{0, 8, 103}:     "Uptime Devices",
	[3]byte{0, 8, 104}:     "PurOptix",
	[3]byte{0, 8, 105}:     "Command-e Technology Co.,Ltd.",
	[3]byte{0, 8, 106}:     "Securiton Gmbh",
	[3]byte{0, 8, 107}:     "MIPSYS",
	[3]byte{0, 8, 108}:     "Plasmon LMS",
	[3]byte{0, 8, 109}:     "Missouri FreeNet",
	[3]byte{0, 8, 110}:     "Hyglo AB",
	[3]byte{0, 8, 111}:     "Resources Computer Network Ltd.",
	[3]byte{0, 8, 112}:     "Rasvia Systems, Inc.",
	[3]byte{0, 8, 113}:     "NORTHDATA Co., Ltd.",
	[3]byte{0, 8, 114}:     "Sorenson Communications",
	[3]byte{0, 8, 115}:     "DapTechnology B.V.",
	[3]byte{0, 8, 116}:     "Dell Computer Corp.",
	[3]byte{0, 8, 117}:     "Acorp Electronics Corp.",
	[3]byte{0, 8, 118}:     "SDSystem",
	[3]byte{0, 8, 119}:     "Liebert-Hiross Spa",
	[3]byte{0, 8, 120}:     "Benchmark Storage Innovations",
	[3]byte{0, 8, 121}:     "CEM Corporation",
	[3]byte{0, 8, 122}:     "Wipotec GmbH",
	[3]byte{0, 8, 123}:     "RTX Telecom A/S",
	[3]byte{0, 8, 124}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 8, 125}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 8, 126}:     "Bon Electro-Telecom Inc.",
	[3]byte{0, 8, 127}:     "SPAUN electronic GmbH & Co. KG",
	[3]byte{0, 8, 128}:     "BroadTel Canada Communications inc.",
	[3]byte{0, 8, 129}:     "DIGITAL HANDS CO.,LTD.",
	[3]byte{0, 8, 130}:     "SIGMA CORPORATION",
	[3]byte{0, 8, 131}:     "Hewlett-Packard Company",
	[3]byte{0, 8, 132}:     "Index Braille AB",
	[3]byte{0, 8, 133}:     "EMS Dr. Thomas Wünsche",
	[3]byte{0, 8, 134}:     "Hansung Teliann, Inc.",
	[3]byte{0, 8, 135}:     "Maschinenfabrik Reinhausen GmbH",
	[3]byte{0, 8, 136}:     "OULLIM Information Technology Inc,.",
	[3]byte{0, 8, 137}:     "Echostar Technologies Corp",
	[3]byte{0, 8, 138}:     "Minds@Work",
	[3]byte{0, 8, 139}:     "Tropic Networks Inc.",
	[3]byte{0, 8, 140}:     "Quanta Network Systems Inc.",
	[3]byte{0, 8, 141}:     "Sigma-Links Inc.",
	[3]byte{0, 8, 142}:     "Nihon Computer Co., Ltd.",
	[3]byte{0, 8, 143}:     "ADVANCED DIGITAL TECHNOLOGY",
	[3]byte{0, 8, 144}:     "AVILINKS SA",
	[3]byte{0, 8, 145}:     "Lyan Inc.",
	[3]byte{0, 8, 146}:     "EM Solutions",
	[3]byte{0, 8, 147}:     "LE INFORMATION COMMUNICATION INC.",
	[3]byte{0, 8, 148}:     "InnoVISION Multimedia Ltd.",
	[3]byte{0, 8, 149}:     "DIRC Technologie GmbH & Co.KG",
	[3]byte{0, 8, 150}:     "Printronix, Inc.",
	[3]byte{0, 8, 151}:     "Quake Technologies",
	[3]byte{0, 8, 152}:     "Gigabit Optics Corporation",
	[3]byte{0, 8, 153}:     "Netbind, Inc.",
	[3]byte{0, 8, 154}:     "Alcatel Microelectronics",
	[3]byte{0, 8, 155}:     "ICP Electronics Inc.",
	[3]byte{0, 8, 156}:     "Elecs Industry Co., Ltd.",
	[3]byte{0, 8, 157}:     "UHD-Elektronik",
	[3]byte{0, 8, 158}:     "Beijing Enter-Net co.LTD",
	[3]byte{0, 8, 159}:     "EFM Networks",
	[3]byte{0, 8, 160}:     "Stotz Feinmesstechnik GmbH",
	[3]byte{0, 8, 161}:     "CNet Technology Inc.",
	[3]byte{0, 8, 162}:     "ADI Engineering, Inc.",
	[3]byte{0, 8, 163}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 8, 164}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 8, 165}:     "Peninsula Systems Inc.",
	[3]byte{0, 8, 166}:     "Multiware & Image Co., Ltd.",
	[3]byte{0, 8, 167}:     "iLogic Inc.",
	[3]byte{0, 8, 168}:     "Systec Co., Ltd.",
	[3]byte{0, 8, 169}:     "SangSang Technology, Inc.",
	[3]byte{0, 8, 170}:     "KARAM",
	[3]byte{0, 8, 171}:     "EnerLinx.com, Inc.",
	[3]byte{0, 8, 172}:     "Eltromat GmbH",
	[3]byte{0, 8, 173}:     "Toyo-Linx Co., Ltd.",
	[3]byte{0, 8, 174}:     "PacketFront Network Products AB",
	[3]byte{0, 8, 175}:     "Novatec Corporation",
	[3]byte{0, 8, 176}:     "BKtel communications GmbH",
	[3]byte{0, 8, 177}:     "ProQuent Systems",
	[3]byte{0, 8, 178}:     "SHENZHEN COMPASS TECHNOLOGY DEVELOPMENT CO.,LTD",
	[3]byte{0, 8, 179}:     "Fastwel",
	[3]byte{0, 8, 180}:     "SYSPOL",
	[3]byte{0, 8, 181}:     "TAI GUEN ENTERPRISE CO., LTD",
	[3]byte{0, 8, 182}:     "RouteFree, Inc.",
	[3]byte{0, 8, 183}:     "HIT Incorporated",
	[3]byte{0, 8, 184}:     "E.F. Johnson",
	[3]byte{0, 8, 185}:     "KAON MEDIA Co., Ltd.",
	[3]byte{0, 8, 186}:     "Erskine Systems Ltd",
	[3]byte{0, 8, 187}:     "NetExcell",
	[3]byte{0, 8, 188}:     "Ilevo AB",
	[3]byte{0, 8, 189}:     "TEPG-US",
	[3]byte{0, 8, 190}:     "XENPAK MSA Group",
	[3]byte{0, 8, 191}:     "Aptus Elektronik AB",
	[3]byte{0, 8, 192}:     "ASA SYSTEMS",
	[3]byte{0, 8, 193}:     "Avistar Communications Corporation",
	[3]byte{0, 8, 194}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 8, 195}:     "Contex A/S",
	[3]byte{0, 8, 196}:     "Hikari Co.,Ltd.",
	[3]byte{0, 8, 197}:     "Liontech Co., Ltd.",
	[3]byte{0, 8, 198}:     "Philips Consumer Communications",
	[3]byte{0, 8, 199}:     "Hewlett-Packard Company",
	[3]byte{0, 8, 200}:     "Soneticom, Inc.",
	[3]byte{0, 8, 201}:     "TechniSat Digital GmbH",
	[3]byte{0, 8, 202}:     "TwinHan Technology Co.,Ltd",
	[3]byte{0, 8, 203}:     "Zeta Broadband Inc.",
	[3]byte{0, 8, 204}:     "Remotec, Inc.",
	[3]byte{0, 8, 205}:     "With-Net Inc",
	[3]byte{0, 8, 206}:     "IPMobileNet Inc.",
	[3]byte{0, 8, 207}:     "Nippon Koei Power Systems Co., Ltd.",
	[3]byte{0, 8, 208}:     "Musashi Engineering Co., LTD.",
	[3]byte{0, 8, 209}:     "KAREL INC.",
	[3]byte{0, 8, 210}:     "ZOOM Networks Inc.",
	[3]byte{0, 8, 211}:     "Hercules Technologies S.A.S.",
	[3]byte{0, 8, 212}:     "IneoQuest Technologies, Inc",
	[3]byte{0, 8, 213}:     "Vanguard Networks Solutions, LLC",
	[3]byte{0, 8, 214}:     "HASSNET Inc.",
	[3]byte{0, 8, 215}:     "HOW CORPORATION",
	[3]byte{0, 8, 216}:     "Dowkey Microwave",
	[3]byte{0, 8, 217}:     "Mitadenshi Co.,LTD",
	[3]byte{0, 8, 218}:     "SofaWare Technologies Ltd.",
	[3]byte{0, 8, 219}:     "Corrigent Systems",
	[3]byte{0, 8, 220}:     "Wiznet",
	[3]byte{0, 8, 221}:     "Telena Communications, Inc.",
	[3]byte{0, 8, 222}:     "3UP Systems",
	[3]byte{0, 8, 223}:     "Alistel Inc.",
	[3]byte{0, 8, 224}:     "ATO Technology Ltd.",
	[3]byte{0, 8, 225}:     "Barix AG",
	[3]byte{0, 8, 226}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 8, 227}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 8, 228}:     "Envenergy Inc",
	[3]byte{0, 8, 229}:     "IDK Corporation",
	[3]byte{0, 8, 230}:     "Littlefeet",
	[3]byte{0, 8, 231}:     "SHI ControlSystems,Ltd.",
	[3]byte{0, 8, 232}:     "Excel Master Ltd.",
	[3]byte{0, 8, 233}:     "NextGig",
	[3]byte{0, 8, 234}:     "Motion Control Engineering, Inc",
	[3]byte{0, 8, 235}:     "ROMWin Co.,Ltd.",
	[3]byte{0, 8, 236}:     "Optical Zonu Corporation",
	[3]byte{0, 8, 237}:     "ST&T Instrument Corp.",
	[3]byte{0, 8, 238}:     "Logic Product Development",
	[3]byte{0, 8, 239}:     "DIBAL,S.A.",
	[3]byte{0, 8, 240}:     "Next Generation Systems, Inc.",
	[3]byte{0, 8, 241}:     "Voltaire",
	[3]byte{0, 8, 242}:     "C&S Technology",
	[3]byte{0, 8, 243}:     "WANY",
	[3]byte{0, 8, 244}:     "Bluetake Technology Co., Ltd.",
	[3]byte{0, 8, 245}:     "YESTECHNOLOGY Co.,Ltd.",
	[3]byte{0, 8, 246}:     "Sumitomo Electric System Solutions Co., Ltd.",
	[3]byte{0, 8, 247}:     "Hitachi Ltd, Semiconductor & Integrated Circuits Gr",
	[3]byte{0, 8, 248}:     "UTC CCS",
	[3]byte{0, 8, 249}:     "Artesyn Embedded Technologies",
	[3]byte{0, 8, 250}:     "Karl E.Brinkmann GmbH",
	[3]byte{0, 8, 251}:     "SonoSite, Inc.",
	[3]byte{0, 8, 252}:     "Gigaphoton Inc.",
	[3]byte{0, 8, 253}:     "BlueKorea Co., Ltd.",
	[3]byte{0, 8, 254}:     "UNIK C&C Co.,Ltd.",
	[3]byte{0, 8, 255}:     "Trilogy Communications Ltd",
	[3]byte{0, 9, 0}:       "TMT",
	[3]byte{0, 9, 1}:       "Shenzhen Shixuntong Information & Technoligy Co",
	[3]byte{0, 9, 2}:       "Redline Communications Inc.",
	[3]byte{0, 9, 3}:       "Panasas, Inc",
	[3]byte{0, 9, 4}:       "MONDIAL electronic",
	[3]byte{0, 9, 5}:       "iTEC Technologies Ltd.",
	[3]byte{0, 9, 6}:       "Esteem Networks",
	[3]byte{0, 9, 7}:       "Chrysalis Development",
	[3]byte{0, 9, 8}:       "VTech Technology Corp.",
	[3]byte{0, 9, 9}:       "Telenor Connect A/S",
	[3]byte{0, 9, 10}:      "SnedFar Technology Co., Ltd.",
	[3]byte{0, 9, 11}:      "MTL  Instruments PLC",
	[3]byte{0, 9, 12}:      "Mayekawa Mfg. Co. Ltd.",
	[3]byte{0, 9, 13}:      "LEADER ELECTRONICS CORP.",
	[3]byte{0, 9, 14}:      "Helix Technology Inc.",
	[3]byte{0, 9, 15}:      "Fortinet Inc.",
	[3]byte{0, 9, 16}:      "Simple Access Inc.",
	[3]byte{0, 9, 17}:      "CISCO SYSTEMS, INC.",
	[3]byte{0, 9, 18}:      "CISCO SYSTEMS, INC.",
	[3]byte{0, 9, 19}:      "SystemK Corporation",
	[3]byte{0, 9, 20}:      "COMPUTROLS INC.",
	[3]byte{0, 9, 21}:      "CAS Corp.",
	[3]byte{0, 9, 22}:      "Listman Home Technologies, Inc.",
	[3]byte{0, 9, 23}:      "WEM Technology Inc",
	[3]byte{0, 9, 24}:      "SAMSUNG TECHWIN CO.,LTD",
	[3]byte{0, 9, 25}:      "MDS Gateways",
	[3]byte{0, 9, 26}:      "Macat Optics & Electronics Co., Ltd.",
	[3]byte{0, 9, 27}:      "Digital Generation Inc.",
	[3]byte{0, 9, 28}:      "CacheVision, Inc",
	[3]byte{0, 9, 29}:      "Proteam Computer Corporation",
	[3]byte{0, 9, 30}:      "Firstech Technology Corp.",
	[3]byte{0, 9, 31}:      "A&D Co., Ltd.",
	[3]byte{0, 9, 32}:      "EpoX COMPUTER CO.,LTD.",
	[3]byte{0, 9, 33}:      "Planmeca Oy",
	[3]byte{0, 9, 34}:      "TST Biometrics GmbH",
	[3]byte{0, 9, 35}:      "Heaman System Co., Ltd",
	[3]byte{0, 9, 36}:      "Telebau GmbH",
	[3]byte{0, 9, 37}:      "VSN Systemen BV",
	[3]byte{0, 9, 38}:      "YODA COMMUNICATIONS, INC.",
	[3]byte{0, 9, 39}:      "TOYOKEIKI CO.,LTD.",
	[3]byte{0, 9, 40}:      "Telecore",
	[3]byte{0, 9, 41}:      "Sanyo Industries (UK) Limited",
	[3]byte{0, 9, 42}:      "MYTECS Co.,Ltd.",
	[3]byte{0, 9, 43}:      "iQstor Networks, Inc.",
	[3]byte{0, 9, 44}:      "Hitpoint Inc.",
	[3]byte{0, 9, 45}:      "HTC Corporation",
	[3]byte{0, 9, 46}:      "B&Tech System Inc.",
	[3]byte{0, 9, 47}:      "Akom Technology Corporation",
	[3]byte{0, 9, 48}:      "AeroConcierge Inc.",
	[3]byte{0, 9, 49}:      "Future Internet, Inc.",
	[3]byte{0, 9, 50}:      "Omnilux",
	[3]byte{0, 9, 51}:      "Ophit Co.Ltd.",
	[3]byte{0, 9, 52}:      "Dream-Multimedia-Tv GmbH",
	[3]byte{0, 9, 53}:      "Sandvine Incorporated",
	[3]byte{0, 9, 54}:      "Ipetronik GmbH & Co. KG",
	[3]byte{0, 9, 55}:      "Inventec Appliance Corp",
	[3]byte{0, 9, 56}:      "Allot Communications",
	[3]byte{0, 9, 57}:      "ShibaSoku Co.,Ltd.",
	[3]byte{0, 9, 58}:      "Molex Fiber Optics",
	[3]byte{0, 9, 59}:      "HYUNDAI NETWORKS INC.",
	[3]byte{0, 9, 60}:      "Jacques Technologies P/L",
	[3]byte{0, 9, 61}:      "Newisys,Inc.",
	[3]byte{0, 9, 62}:      "C&I Technologies",
	[3]byte{0, 9, 63}:      "Double-Win Enterpirse CO., LTD",
	[3]byte{0, 9, 64}:      "AGFEO GmbH & Co. KG",
	[3]byte{0, 9, 65}:      "Allied Telesis K.K.",
	[3]byte{0, 9, 66}:      "Wireless Technologies, Inc",
	[3]byte{0, 9, 67}:      "CISCO SYSTEMS, INC.",
	[3]byte{0, 9, 68}:      "CISCO SYSTEMS, INC.",
	[3]byte{0, 9, 69}:      "Palmmicro Communications Inc",
	[3]byte{0, 9, 70}:      "Cluster Labs GmbH",
	[3]byte{0, 9, 71}:      "Aztek, Inc.",
	[3]byte{0, 9, 72}:      "Vista Control Systems, Corp.",
	[3]byte{0, 9, 73}:      "Glyph Technologies Inc.",
	[3]byte{0, 9, 74}:      "Homenet Communications",
	[3]byte{0, 9, 75}:      "FillFactory NV",
	[3]byte{0, 9, 76}:      "Communication Weaver Co.,Ltd.",
	[3]byte{0, 9, 77}:      "Braintree Communications Pty Ltd",
	[3]byte{0, 9, 78}:      "BARTECH SYSTEMS INTERNATIONAL, INC",
	[3]byte{0, 9, 79}:      "elmegt GmbH & Co. KG",
	[3]byte{0, 9, 80}:      "Independent Storage Corporation",
	[3]byte{0, 9, 81}:      "Apogee Imaging Systems",
	[3]byte{0, 9, 82}:      "Auerswald GmbH & Co. KG",
	[3]byte{0, 9, 83}:      "Linkage System Integration Co.Ltd.",
	[3]byte{0, 9, 84}:      "AMiT spol. s. r. o.",
	[3]byte{0, 9, 85}:      "Young Generation International Corp.",
	[3]byte{0, 9, 86}:      "Network Systems Group, Ltd. (NSG)",
	[3]byte{0, 9, 87}:      "Supercaller, Inc.",
	[3]byte{0, 9, 88}:      "INTELNET S.A.",
	[3]byte{0, 9, 89}:      "Sitecsoft",
	[3]byte{0, 9, 90}:      "RACEWOOD TECHNOLOGY",
	[3]byte{0, 9, 91}:      "Netgear, Inc.",
	[3]byte{0, 9, 92}:      "Philips Medical Systems - Cardiac and Monitoring Systems (CM",
	[3]byte{0, 9, 93}:      "Dialogue Technology Corp.",
	[3]byte{0, 9, 94}:      "Masstech Group Inc.",
	[3]byte{0, 9, 95}:      "Telebyte, Inc.",
	[3]byte{0, 9, 96}:      "YOZAN Inc.",
	[3]byte{0, 9, 97}:      "Switchgear and Instrumentation Ltd",
	[3]byte{0, 9, 98}:      "Sonitor Technologies AS",
	[3]byte{0, 9, 99}:      "Dominion Lasercom Inc.",
	[3]byte{0, 9, 100}:     "Hi-Techniques, Inc.",
	[3]byte{0, 9, 101}:     "HyunJu Computer Co., Ltd.",
	[3]byte{0, 9, 102}:     "Thales Navigation",
	[3]byte{0, 9, 103}:     "Tachyon, Inc",
	[3]byte{0, 9, 104}:     "TECHNOVENTURE, INC.",
	[3]byte{0, 9, 105}:     "Meret Optical Communications",
	[3]byte{0, 9, 106}:     "Cloverleaf Communications Inc.",
	[3]byte{0, 9, 107}:     "IBM Corp",
	[3]byte{0, 9, 108}:     "Imedia Semiconductor Corp.",
	[3]byte{0, 9, 109}:     "Powernet Technologies Corp.",
	[3]byte{0, 9, 110}:     "GIANT ELECTRONICS LTD.",
	[3]byte{0, 9, 111}:     "Beijing Zhongqing Elegant Tech. Corp.,Limited",
	[3]byte{0, 9, 112}:     "Vibration Research Corporation",
	[3]byte{0, 9, 113}:     "Time Management, Inc.",
	[3]byte{0, 9, 114}:     "Securebase,Inc",
	[3]byte{0, 9, 115}:     "Lenten Technology Co., Ltd.",
	[3]byte{0, 9, 116}:     "Innopia Technologies, Inc.",
	[3]byte{0, 9, 117}:     "fSONA Communications Corporation",
	[3]byte{0, 9, 118}:     "Datasoft ISDN Systems GmbH",
	[3]byte{0, 9, 119}:     "Brunner Elektronik AG",
	[3]byte{0, 9, 120}:     "AIJI System Co., Ltd.",
	[3]byte{0, 9, 121}:     "Advanced Television Systems Committee, Inc.",
	[3]byte{0, 9, 122}:     "Louis Design Labs.",
	[3]byte{0, 9, 123}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 9, 124}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 9, 125}:     "SecWell Networks Oy",
	[3]byte{0, 9, 126}:     "IMI TECHNOLOGY CO., LTD",
	[3]byte{0, 9, 127}:     "Vsecure 2000 LTD.",
	[3]byte{0, 9, 128}:     "Power Zenith Inc.",
	[3]byte{0, 9, 129}:     "Newport Networks",
	[3]byte{0, 9, 130}:     "Loewe Opta GmbH",
	[3]byte{0, 9, 131}:     "GlobalTop Technology, Inc.",
	[3]byte{0, 9, 132}:     "MyCasa Network Inc.",
	[3]byte{0, 9, 133}:     "Auto Telecom Company",
	[3]byte{0, 9, 134}:     "Metalink LTD.",
	[3]byte{0, 9, 135}:     "NISHI NIPPON ELECTRIC WIRE & CABLE CO.,LTD.",
	[3]byte{0, 9, 136}:     "Nudian Electron Co., Ltd.",
	[3]byte{0, 9, 137}:     "VividLogic Inc.",
	[3]byte{0, 9, 138}:     "EqualLogic Inc",
	[3]byte{0, 9, 139}:     "Entropic Communications, Inc.",
	[3]byte{0, 9, 140}:     "Option Wireless Sweden",
	[3]byte{0, 9, 141}:     "Velocity Semiconductor",
	[3]byte{0, 9, 142}:     "ipcas GmbH",
	[3]byte{0, 9, 143}:     "Cetacean Networks",
	[3]byte{0, 9, 144}:     "ACKSYS Communications & systems",
	[3]byte{0, 9, 145}:     "GE Fanuc Automation Manufacturing, Inc.",
	[3]byte{0, 9, 146}:     "InterEpoch Technology,INC.",
	[3]byte{0, 9, 147}:     "Visteon Corporation",
	[3]byte{0, 9, 148}:     "Cronyx Engineering",
	[3]byte{0, 9, 149}:     "Castle Technology Ltd",
	[3]byte{0, 9, 150}:     "RDI",
	[3]byte{0, 9, 151}:     "Nortel Networks",
	[3]byte{0, 9, 152}:     "Capinfo Company Limited",
	[3]byte{0, 9, 153}:     "CP GEORGES RENAULT",
	[3]byte{0, 9, 154}:     "ELMO COMPANY, LIMITED",
	[3]byte{0, 9, 155}:     "Western Telematic Inc.",
	[3]byte{0, 9, 156}:     "Naval Research Laboratory",
	[3]byte{0, 9, 157}:     "Haliplex Communications",
	[3]byte{0, 9, 158}:     "Testech, Inc.",
	[3]byte{0, 9, 159}:     "VIDEX INC.",
	[3]byte{0, 9, 160}:     "Microtechno Corporation",
	[3]byte{0, 9, 161}:     "Telewise Communications, Inc.",
	[3]byte{0, 9, 162}:     "Interface Co., Ltd.",
	[3]byte{0, 9, 163}:     "Leadfly Techologies Corp. Ltd.",
	[3]byte{0, 9, 164}:     "HARTEC Corporation",
	[3]byte{0, 9, 165}:     "HANSUNG ELETRONIC INDUSTRIES DEVELOPMENT CO., LTD",
	[3]byte{0, 9, 166}:     "Ignis Optics, Inc.",
	[3]byte{0, 9, 167}:     "Bang & Olufsen A/S",
	[3]byte{0, 9, 168}:     "Eastmode Pte Ltd",
	[3]byte{0, 9, 169}:     "Ikanos Communications",
	[3]byte{0, 9, 170}:     "Data Comm for Business, Inc.",
	[3]byte{0, 9, 171}:     "Netcontrol Oy",
	[3]byte{0, 9, 172}:     "LANVOICE",
	[3]byte{0, 9, 173}:     "HYUNDAI SYSCOMM, INC.",
	[3]byte{0, 9, 174}:     "OKANO ELECTRIC CO.,LTD",
	[3]byte{0, 9, 175}:     "e-generis",
	[3]byte{0, 9, 176}:     "Onkyo Corporation",
	[3]byte{0, 9, 177}:     "Kanematsu Electronics, Ltd.",
	[3]byte{0, 9, 178}:     "L&F Inc.",
	[3]byte{0, 9, 179}:     "MCM Systems Ltd",
	[3]byte{0, 9, 180}:     "KISAN TELECOM CO., LTD.",
	[3]byte{0, 9, 181}:     "3J Tech. Co., Ltd.",
	[3]byte{0, 9, 182}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 9, 183}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 9, 184}:     "Entise Systems",
	[3]byte{0, 9, 185}:     "Action Imaging Solutions",
	[3]byte{0, 9, 186}:     "MAKU Informationstechik GmbH",
	[3]byte{0, 9, 187}:     "MathStar, Inc.",
	[3]byte{0, 9, 188}:     "Digital Safety Technologies, Inc",
	[3]byte{0, 9, 189}:     "Epygi Technologies, Ltd.",
	[3]byte{0, 9, 190}:     "Mamiya-OP Co.,Ltd.",
	[3]byte{0, 9, 191}:     "Nintendo Co., Ltd.",
	[3]byte{0, 9, 192}:     "6WIND",
	[3]byte{0, 9, 193}:     "PROCES-DATA A/S",
	[3]byte{0, 9, 194}:     "Onity, Inc.",
	[3]byte{0, 9, 195}:     "NETAS",
	[3]byte{0, 9, 196}:     "Medicore Co., Ltd",
	[3]byte{0, 9, 197}:     "KINGENE Technology Corporation",
	[3]byte{0, 9, 198}:     "Visionics Corporation",
	[3]byte{0, 9, 199}:     "Movistec",
	[3]byte{0, 9, 200}:     "SINAGAWA TSUSHIN KEISOU SERVICE",
	[3]byte{0, 9, 201}:     "BlueWINC Co., Ltd.",
	[3]byte{0, 9, 202}:     "iMaxNetworks(Shenzhen)Limited.",
	[3]byte{0, 9, 203}:     "HBrain",
	[3]byte{0, 9, 204}:     "Moog GmbH",
	[3]byte{0, 9, 205}:     "HUDSON SOFT CO.,LTD.",
	[3]byte{0, 9, 206}:     "SpaceBridge Semiconductor Corp.",
	[3]byte{0, 9, 207}:     "iAd GmbH",
	[3]byte{0, 9, 208}:     "Solacom Technologies Inc.",
	[3]byte{0, 9, 209}:     "SERANOA NETWORKS INC",
	[3]byte{0, 9, 210}:     "Mai Logic Inc.",
	[3]byte{0, 9, 211}:     "Western DataCom Co., Inc.",
	[3]byte{0, 9, 212}:     "Transtech Networks",
	[3]byte{0, 9, 213}:     "Signal Communication, Inc.",
	[3]byte{0, 9, 214}:     "KNC One GmbH",
	[3]byte{0, 9, 215}:     "DC Security Products",
	[3]byte{0, 9, 216}:     "Fält Communications AB",
	[3]byte{0, 9, 217}:     "Neoscale Systems, Inc",
	[3]byte{0, 9, 218}:     "Control Module Inc.",
	[3]byte{0, 9, 219}:     "eSpace",
	[3]byte{0, 9, 220}:     "Galaxis Technology AG",
	[3]byte{0, 9, 221}:     "Mavin Technology Inc.",
	[3]byte{0, 9, 222}:     "Samjin Information & Communications Co., Ltd.",
	[3]byte{0, 9, 223}:     "Vestel Komunikasyon Sanayi ve Ticaret A.S.",
	[3]byte{0, 9, 224}:     "XEMICS S.A.",
	[3]byte{0, 9, 225}:     "Gemtek Technology Co., Ltd.",
	[3]byte{0, 9, 226}:     "Sinbon Electronics Co., Ltd.",
	[3]byte{0, 9, 227}:     "Angel Iglesias S.A.",
	[3]byte{0, 9, 228}:     "K Tech Infosystem Inc.",
	[3]byte{0, 9, 229}:     "Hottinger Baldwin Messtechnik GmbH",
	[3]byte{0, 9, 230}:     "Cyber Switching Inc.",
	[3]byte{0, 9, 231}:     "ADC Techonology",
	[3]byte{0, 9, 232}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 9, 233}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 9, 234}:     "YEM Inc.",
	[3]byte{0, 9, 235}:     "HuMANDATA LTD.",
	[3]byte{0, 9, 236}:     "Daktronics, Inc.",
	[3]byte{0, 9, 237}:     "CipherOptics",
	[3]byte{0, 9, 238}:     "MEIKYO ELECTRIC CO.,LTD",
	[3]byte{0, 9, 239}:     "Vocera Communications",
	[3]byte{0, 9, 240}:     "Shimizu Technology Inc.",
	[3]byte{0, 9, 241}:     "Yamaki Electric Corporation",
	[3]byte{0, 9, 242}:     "Cohu, Inc., Electronics Division",
	[3]byte{0, 9, 243}:     "WELL Communication Corp.",
	[3]byte{0, 9, 244}:     "Alcon Laboratories, Inc.",
	[3]byte{0, 9, 245}:     "Emerson Network Power Co.,Ltd",
	[3]byte{0, 9, 246}:     "Shenzhen Eastern Digital Tech Ltd.",
	[3]byte{0, 9, 247}:     "SED, a division of Calian",
	[3]byte{0, 9, 248}:     "UNIMO TECHNOLOGY CO., LTD.",
	[3]byte{0, 9, 249}:     "ART JAPAN CO., LTD.",
	[3]byte{0, 9, 251}:     "Philips Patient Monitoring",
	[3]byte{0, 9, 252}:     "IPFLEX Inc.",
	[3]byte{0, 9, 253}:     "Ubinetics Limited",
	[3]byte{0, 9, 254}:     "Daisy Technologies, Inc.",
	[3]byte{0, 9, 255}:     "X.net 2000 GmbH",
	[3]byte{0, 10, 0}:      "Mediatek Corp.",
	[3]byte{0, 10, 1}:      "SOHOware, Inc.",
	[3]byte{0, 10, 2}:      "ANNSO CO., LTD.",
	[3]byte{0, 10, 3}:      "ENDESA SERVICIOS, S.L.",
	[3]byte{0, 10, 4}:      "3Com Ltd",
	[3]byte{0, 10, 5}:      "Widax Corp.",
	[3]byte{0, 10, 6}:      "Teledex LLC",
	[3]byte{0, 10, 7}:      "WebWayOne Ltd",
	[3]byte{0, 10, 8}:      "ALPINE ELECTRONICS, INC.",
	[3]byte{0, 10, 9}:      "TaraCom Integrated Products, Inc.",
	[3]byte{0, 10, 10}:     "SUNIX Co., Ltd.",
	[3]byte{0, 10, 11}:     "Sealevel Systems, Inc.",
	[3]byte{0, 10, 12}:     "Scientific Research Corporation",
	[3]byte{0, 10, 13}:     "FCI Deutschland GmbH",
	[3]byte{0, 10, 14}:     "Invivo Research Inc.",
	[3]byte{0, 10, 15}:     "Ilryung Telesys, Inc",
	[3]byte{0, 10, 16}:     "FAST media integrations AG",
	[3]byte{0, 10, 17}:     "ExPet Technologies, Inc",
	[3]byte{0, 10, 18}:     "Azylex Technology, Inc",
	[3]byte{0, 10, 19}:     "Honeywell Video Systems",
	[3]byte{0, 10, 20}:     "TECO a.s.",
	[3]byte{0, 10, 21}:     "Silicon Data, Inc",
	[3]byte{0, 10, 22}:     "Lassen Research",
	[3]byte{0, 10, 23}:     "NESTAR COMMUNICATIONS, INC",
	[3]byte{0, 10, 24}:     "Vichel Inc.",
	[3]byte{0, 10, 25}:     "Valere Power, Inc.",
	[3]byte{0, 10, 26}:     "Imerge Ltd",
	[3]byte{0, 10, 27}:     "Stream Labs",
	[3]byte{0, 10, 28}:     "Bridge Information Co., Ltd.",
	[3]byte{0, 10, 29}:     "Optical Communications Products Inc.",
	[3]byte{0, 10, 30}:     "Red-M Products Limited",
	[3]byte{0, 10, 31}:     "ART WARE Telecommunication Co., Ltd.",
	[3]byte{0, 10, 32}:     "SVA Networks, Inc.",
	[3]byte{0, 10, 33}:     "Integra Telecom Co. Ltd",
	[3]byte{0, 10, 34}:     "Amperion Inc",
	[3]byte{0, 10, 35}:     "Parama Networks Inc",
	[3]byte{0, 10, 36}:     "Octave Communications",
	[3]byte{0, 10, 37}:     "CERAGON NETWORKS",
	[3]byte{0, 10, 38}:     "CEIA S.p.A.",
	[3]byte{0, 10, 39}:     "Apple",
	[3]byte{0, 10, 40}:     "Motorola",
	[3]byte{0, 10, 41}:     "Pan Dacom Networking AG",
	[3]byte{0, 10, 42}:     "QSI Systems Inc.",
	[3]byte{0, 10, 43}:     "Etherstuff",
	[3]byte{0, 10, 44}:     "Active Tchnology Corporation",
	[3]byte{0, 10, 45}:     "Cabot Communications Limited",
	[3]byte{0, 10, 46}:     "MAPLE NETWORKS CO., LTD",
	[3]byte{0, 10, 47}:     "Artnix Inc.",
	[3]byte{0, 10, 48}:     "Visteon Corporation",
	[3]byte{0, 10, 49}:     "HCV Consulting",
	[3]byte{0, 10, 50}:     "Xsido Corporation",
	[3]byte{0, 10, 51}:     "Emulex Corporation",
	[3]byte{0, 10, 52}:     "Identicard Systems Incorporated",
	[3]byte{0, 10, 53}:     "Xilinx",
	[3]byte{0, 10, 54}:     "Synelec Telecom Multimedia",
	[3]byte{0, 10, 55}:     "Procera Networks, Inc.",
	[3]byte{0, 10, 56}:     "Apani Networks",
	[3]byte{0, 10, 57}:     "LoPA Information Technology",
	[3]byte{0, 10, 58}:     "J-THREE INTERNATIONAL Holding Co., Ltd.",
	[3]byte{0, 10, 59}:     "GCT Semiconductor, Inc",
	[3]byte{0, 10, 60}:     "Enerpoint Ltd.",
	[3]byte{0, 10, 61}:     "Elo Sistemas Eletronicos S.A.",
	[3]byte{0, 10, 62}:     "EADS Telecom",
	[3]byte{0, 10, 63}:     "Data East Corporation",
	[3]byte{0, 10, 64}:     "Crown Audio -- Harmanm International",
	[3]byte{0, 10, 65}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 10, 66}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 10, 67}:     "Chunghwa Telecom Co., Ltd.",
	[3]byte{0, 10, 68}:     "Avery Dennison Deutschland GmbH",
	[3]byte{0, 10, 69}:     "Audio-Technica Corp.",
	[3]byte{0, 10, 70}:     "ARO WELDING TECHNOLOGIES SAS",
	[3]byte{0, 10, 71}:     "Allied Vision Technologies",
	[3]byte{0, 10, 72}:     "Albatron Technology",
	[3]byte{0, 10, 73}:     "F5 Networks, Inc.",
	[3]byte{0, 10, 74}:     "Targa Systems Ltd.",
	[3]byte{0, 10, 75}:     "DataPower Technology, Inc.",
	[3]byte{0, 10, 76}:     "Molecular Devices Corporation",
	[3]byte{0, 10, 77}:     "Noritz Corporation",
	[3]byte{0, 10, 78}:     "UNITEK Electronics INC.",
	[3]byte{0, 10, 79}:     "Brain Boxes Limited",
	[3]byte{0, 10, 80}:     "REMOTEK CORPORATION",
	[3]byte{0, 10, 81}:     "GyroSignal Technology Co., Ltd.",
	[3]byte{0, 10, 82}:     "AsiaRF Ltd.",
	[3]byte{0, 10, 83}:     "Intronics, Incorporated",
	[3]byte{0, 10, 84}:     "Laguna Hills, Inc.",
	[3]byte{0, 10, 85}:     "MARKEM Corporation",
	[3]byte{0, 10, 86}:     "HITACHI Maxell Ltd.",
	[3]byte{0, 10, 87}:     "Hewlett-Packard Company - Standards",
	[3]byte{0, 10, 88}:     "Freyer & Siegel Elektronik GmbH & Co. KG",
	[3]byte{0, 10, 89}:     "HW server",
	[3]byte{0, 10, 90}:     "GreenNET Technologies Co.,Ltd.",
	[3]byte{0, 10, 91}:     "Power-One as",
	[3]byte{0, 10, 92}:     "Carel s.p.a.",
	[3]byte{0, 10, 93}:     "FingerTec Worldwide Sdn Bhd",
	[3]byte{0, 10, 94}:     "3COM Corporation",
	[3]byte{0, 10, 95}:     "almedio inc.",
	[3]byte{0, 10, 96}:     "Autostar Technology Pte Ltd",
	[3]byte{0, 10, 97}:     "Cellinx Systems Inc.",
	[3]byte{0, 10, 98}:     "Crinis Networks, Inc.",
	[3]byte{0, 10, 99}:     "DHD GmbH",
	[3]byte{0, 10, 100}:    "Eracom Technologies",
	[3]byte{0, 10, 101}:    "GentechMedia.co.,ltd.",
	[3]byte{0, 10, 102}:    "MITSUBISHI ELECTRIC SYSTEM & SERVICE CO.,LTD.",
	[3]byte{0, 10, 103}:    "OngCorp",
	[3]byte{0, 10, 104}:    "SolarFlare Communications, Inc.",
	[3]byte{0, 10, 105}:    "SUNNY bell Technology Co., Ltd.",
	[3]byte{0, 10, 106}:    "SVM Microwaves s.r.o.",
	[3]byte{0, 10, 107}:    "Tadiran Telecom Business Systems LTD",
	[3]byte{0, 10, 108}:    "Walchem Corporation",
	[3]byte{0, 10, 109}:    "EKS Elektronikservice GmbH",
	[3]byte{0, 10, 110}:    "Harmonic, Inc",
	[3]byte{0, 10, 111}:    "ZyFLEX Technologies Inc",
	[3]byte{0, 10, 112}:    "MPLS Forum",
	[3]byte{0, 10, 113}:    "Avrio Technologies, Inc",
	[3]byte{0, 10, 114}:    "STEC, INC.",
	[3]byte{0, 10, 115}:    "Scientific Atlanta",
	[3]byte{0, 10, 116}:    "Manticom Networks Inc.",
	[3]byte{0, 10, 117}:    "Caterpillar, Inc",
	[3]byte{0, 10, 118}:    "Beida Jade Bird Huaguang Technology Co.,Ltd",
	[3]byte{0, 10, 119}:    "Bluewire Technologies LLC",
	[3]byte{0, 10, 120}:    "OLITEC",
	[3]byte{0, 10, 121}:    "corega K.K",
	[3]byte{0, 10, 122}:    "Kyoritsu Electric Co., Ltd.",
	[3]byte{0, 10, 123}:    "Cornelius Consult",
	[3]byte{0, 10, 124}:    "Tecton Ltd",
	[3]byte{0, 10, 125}:    "Valo, Inc.",
	[3]byte{0, 10, 126}:    "The Advantage Group",
	[3]byte{0, 10, 127}:    "Teradon Industries, Inc",
	[3]byte{0, 10, 128}:    "Telkonet Inc.",
	[3]byte{0, 10, 129}:    "TEIMA Audiotex S.L.",
	[3]byte{0, 10, 130}:    "TATSUTA SYSTEM ELECTRONICS CO.,LTD.",
	[3]byte{0, 10, 131}:    "SALTO SYSTEMS S.L.",
	[3]byte{0, 10, 132}:    "Rainsun Enterprise Co., Ltd.",
	[3]byte{0, 10, 133}:    "PLAT'C2,Inc",
	[3]byte{0, 10, 134}:    "Lenze",
	[3]byte{0, 10, 135}:    "Integrated Micromachines Inc.",
	[3]byte{0, 10, 136}:    "InCypher S.A.",
	[3]byte{0, 10, 137}:    "Creval Systems, Inc.",
	[3]byte{0, 10, 138}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 10, 139}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 10, 140}:    "Guardware Systems Ltd.",
	[3]byte{0, 10, 141}:    "EUROTHERM LIMITED",
	[3]byte{0, 10, 142}:    "Invacom Ltd",
	[3]byte{0, 10, 143}:    "Aska International Inc.",
	[3]byte{0, 10, 144}:    "Bayside Interactive, Inc.",
	[3]byte{0, 10, 145}:    "HemoCue AB",
	[3]byte{0, 10, 146}:    "Presonus Corporation",
	[3]byte{0, 10, 147}:    "W2 Networks, Inc.",
	[3]byte{0, 10, 148}:    "ShangHai cellink CO., LTD",
	[3]byte{0, 10, 149}:    "Apple",
	[3]byte{0, 10, 150}:    "MEWTEL TECHNOLOGY INC.",
	[3]byte{0, 10, 151}:    "SONICblue, Inc.",
	[3]byte{0, 10, 152}:    "M+F Gwinner GmbH & Co",
	[3]byte{0, 10, 153}:    "Calamp Wireless Networks Inc",
	[3]byte{0, 10, 154}:    "Aiptek International Inc",
	[3]byte{0, 10, 155}:    "TB Group Inc",
	[3]byte{0, 10, 156}:    "Server Technology, Inc.",
	[3]byte{0, 10, 157}:    "King Young Technology Co. Ltd.",
	[3]byte{0, 10, 158}:    "BroadWeb Corportation",
	[3]byte{0, 10, 159}:    "Pannaway Technologies, Inc.",
	[3]byte{0, 10, 160}:    "Cedar Point Communications",
	[3]byte{0, 10, 161}:    "V V S Limited",
	[3]byte{0, 10, 162}:    "SYSTEK INC.",
	[3]byte{0, 10, 163}:    "SHIMAFUJI ELECTRIC CO.,LTD.",
	[3]byte{0, 10, 164}:    "SHANGHAI SURVEILLANCE TECHNOLOGY CO,LTD",
	[3]byte{0, 10, 165}:    "MAXLINK INDUSTRIES LIMITED",
	[3]byte{0, 10, 166}:    "Hochiki Corporation",
	[3]byte{0, 10, 167}:    "FEI Electron Optics",
	[3]byte{0, 10, 168}:    "ePipe Pty. Ltd.",
	[3]byte{0, 10, 169}:    "Brooks Automation GmbH",
	[3]byte{0, 10, 170}:    "AltiGen Communications Inc.",
	[3]byte{0, 10, 171}:    "Toyota Technical Development Corporation",
	[3]byte{0, 10, 172}:    "TerraTec Electronic GmbH",
	[3]byte{0, 10, 173}:    "Stargames Corporation",
	[3]byte{0, 10, 174}:    "Rosemount Process Analytical",
	[3]byte{0, 10, 175}:    "Pipal Systems",
	[3]byte{0, 10, 176}:    "LOYTEC electronics GmbH",
	[3]byte{0, 10, 177}:    "GENETEC Corporation",
	[3]byte{0, 10, 178}:    "Fresnel Wireless Systems",
	[3]byte{0, 10, 179}:    "Fa. GIRA",
	[3]byte{0, 10, 180}:    "ETIC Telecommunications",
	[3]byte{0, 10, 181}:    "Digital Electronic Network",
	[3]byte{0, 10, 182}:    "COMPUNETIX, INC",
	[3]byte{0, 10, 183}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 10, 184}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 10, 185}:    "Astera Technologies Corp.",
	[3]byte{0, 10, 186}:    "Arcon Technology Limited",
	[3]byte{0, 10, 187}:    "Taiwan Secom Co,. Ltd",
	[3]byte{0, 10, 188}:    "Seabridge Ltd.",
	[3]byte{0, 10, 189}:    "Rupprecht & Patashnick Co.",
	[3]byte{0, 10, 190}:    "OPNET Technologies CO., LTD.",
	[3]byte{0, 10, 191}:    "HIROTA SS",
	[3]byte{0, 10, 192}:    "Fuyoh Video Industry CO., LTD.",
	[3]byte{0, 10, 193}:    "Futuretel",
	[3]byte{0, 10, 194}:    "FiberHome Telecommunication Technologies CO.,LTD",
	[3]byte{0, 10, 195}:    "eM Technics Co., Ltd.",
	[3]byte{0, 10, 196}:    "Daewoo Teletech Co., Ltd",
	[3]byte{0, 10, 197}:    "Color Kinetics",
	[3]byte{0, 10, 198}:    "Overture Networks.",
	[3]byte{0, 10, 199}:    "Unication Group",
	[3]byte{0, 10, 200}:    "ZPSYS CO.,LTD. (Planning&Management)",
	[3]byte{0, 10, 201}:    "Zambeel Inc",
	[3]byte{0, 10, 202}:    "YOKOYAMA SHOKAI CO.,Ltd.",
	[3]byte{0, 10, 203}:    "XPAK MSA Group",
	[3]byte{0, 10, 204}:    "Winnow Networks, Inc.",
	[3]byte{0, 10, 205}:    "Sunrich Technology Limited",
	[3]byte{0, 10, 206}:    "RADIANTECH, INC.",
	[3]byte{0, 10, 207}:    "PROVIDEO Multimedia Co. Ltd.",
	[3]byte{0, 10, 208}:    "Niigata Develoment Center,  F.I.T. Co., Ltd.",
	[3]byte{0, 10, 209}:    "MWS",
	[3]byte{0, 10, 210}:    "JEPICO Corporation",
	[3]byte{0, 10, 211}:    "INITECH Co., Ltd",
	[3]byte{0, 10, 212}:    "CoreBell Systems Inc.",
	[3]byte{0, 10, 213}:    "Brainchild Electronic Co., Ltd.",
	[3]byte{0, 10, 214}:    "BeamReach Networks",
	[3]byte{0, 10, 215}:    "Origin ELECTRIC CO.,LTD.",
	[3]byte{0, 10, 216}:    "IPCserv Technology Corp.",
	[3]byte{0, 10, 217}:    "Sony Ericsson Mobile Communications AB",
	[3]byte{0, 10, 218}:    "Vindicator Technologies",
	[3]byte{0, 10, 219}:    "SkyPilot Network, Inc",
	[3]byte{0, 10, 220}:    "RuggedCom Inc.",
	[3]byte{0, 10, 221}:    "Allworx Corp.",
	[3]byte{0, 10, 222}:    "Happy Communication Co., Ltd.",
	[3]byte{0, 10, 223}:    "Gennum Corporation",
	[3]byte{0, 10, 224}:    "Fujitsu Softek",
	[3]byte{0, 10, 225}:    "EG Technology",
	[3]byte{0, 10, 226}:    "Binatone Electronics International, Ltd",
	[3]byte{0, 10, 227}:    "YANG MEI TECHNOLOGY CO., LTD",
	[3]byte{0, 10, 228}:    "Wistron Corp.",
	[3]byte{0, 10, 229}:    "ScottCare Corporation",
	[3]byte{0, 10, 230}:    "Elitegroup Computer System Co. (ECS)",
	[3]byte{0, 10, 231}:    "ELIOP S.A.",
	[3]byte{0, 10, 232}:    "Cathay Roxus Information Technology Co. LTD",
	[3]byte{0, 10, 233}:    "AirVast Technology Inc.",
	[3]byte{0, 10, 234}:    "ADAM ELEKTRONIK LTD. ŞTI",
	[3]byte{0, 10, 235}:    "Shenzhen Tp-Link Technology Co; Ltd.",
	[3]byte{0, 10, 236}:    "Koatsu Gas Kogyo Co., Ltd.",
	[3]byte{0, 10, 237}:    "HARTING Systems GmbH & Co KG",
	[3]byte{0, 10, 238}:    "GCD Hard- & Software GmbH",
	[3]byte{0, 10, 239}:    "OTRUM ASA",
	[3]byte{0, 10, 240}:    "SHIN-OH ELECTRONICS CO., LTD. R&D",
	[3]byte{0, 10, 241}:    "Clarity Design, Inc.",
	[3]byte{0, 10, 242}:    "NeoAxiom Corp.",
	[3]byte{0, 10, 243}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 10, 244}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 10, 245}:    "Airgo Networks, Inc.",
	[3]byte{0, 10, 246}:    "Emerson Climate Technologies Retail Solutions, Inc.",
	[3]byte{0, 10, 247}:    "Broadcom Corp.",
	[3]byte{0, 10, 248}:    "American Telecare Inc.",
	[3]byte{0, 10, 249}:    "HiConnect, Inc.",
	[3]byte{0, 10, 250}:    "Traverse Technologies Australia",
	[3]byte{0, 10, 251}:    "Ambri Limited",
	[3]byte{0, 10, 252}:    "Core Tec Communications, LLC",
	[3]byte{0, 10, 253}:    "Viking Electronic Services",
	[3]byte{0, 10, 254}:    "NovaPal Ltd",
	[3]byte{0, 10, 255}:    "Kilchherr Elektronik AG",
	[3]byte{0, 11, 0}:      "FUJIAN START COMPUTER EQUIPMENT CO.,LTD",
	[3]byte{0, 11, 1}:      "DAIICHI ELECTRONICS CO., LTD.",
	[3]byte{0, 11, 2}:      "Dallmeier electronic",
	[3]byte{0, 11, 3}:      "Taekwang Industrial Co., Ltd",
	[3]byte{0, 11, 4}:      "Volktek Corporation",
	[3]byte{0, 11, 5}:      "Pacific Broadband Networks",
	[3]byte{0, 11, 6}:      "ARRIS Group, Inc.",
	[3]byte{0, 11, 7}:      "Voxpath Networks",
	[3]byte{0, 11, 8}:      "Pillar Data Systems",
	[3]byte{0, 11, 9}:      "Ifoundry Systems Singapore",
	[3]byte{0, 11, 10}:     "dBm Optics",
	[3]byte{0, 11, 11}:     "Corrent Corporation",
	[3]byte{0, 11, 12}:     "Agile Systems Inc.",
	[3]byte{0, 11, 13}:     "Air2U, Inc.",
	[3]byte{0, 11, 14}:     "Trapeze Networks",
	[3]byte{0, 11, 15}:     "Bosch Rexroth",
	[3]byte{0, 11, 16}:     "11wave Technonlogy Co.,Ltd",
	[3]byte{0, 11, 17}:     "HIMEJI ABC TRADING CO.,LTD.",
	[3]byte{0, 11, 18}:     "NURI Telecom Co., Ltd.",
	[3]byte{0, 11, 19}:     "ZETRON INC",
	[3]byte{0, 11, 20}:     "ViewSonic Corporation",
	[3]byte{0, 11, 21}:     "Platypus Technology",
	[3]byte{0, 11, 22}:     "Communication Machinery Corporation",
	[3]byte{0, 11, 23}:     "MKS Instruments",
	[3]byte{0, 11, 24}:     "PRIVATE",
	[3]byte{0, 11, 25}:     "Vernier Networks, Inc.",
	[3]byte{0, 11, 26}:     "Industrial Defender, Inc.",
	[3]byte{0, 11, 27}:     "Systronix, Inc.",
	[3]byte{0, 11, 28}:     "SIBCO bv",
	[3]byte{0, 11, 29}:     "LayerZero Power Systems, Inc.",
	[3]byte{0, 11, 30}:     "KAPPA opto-electronics GmbH",
	[3]byte{0, 11, 31}:     "I CON Computer Co.",
	[3]byte{0, 11, 32}:     "Hirata corporation",
	[3]byte{0, 11, 33}:     "G-Star Communications Inc.",
	[3]byte{0, 11, 34}:     "Environmental Systems and Services",
	[3]byte{0, 11, 35}:     "Siemens Subscriber Networks",
	[3]byte{0, 11, 36}:     "AirLogic",
	[3]byte{0, 11, 37}:     "Aeluros",
	[3]byte{0, 11, 38}:     "Wetek Corporation",
	[3]byte{0, 11, 39}:     "Scion Corporation",
	[3]byte{0, 11, 40}:     "Quatech Inc.",
	[3]byte{0, 11, 41}:     "LS(LG) Industrial Systems co.,Ltd",
	[3]byte{0, 11, 42}:     "HOWTEL Co., Ltd.",
	[3]byte{0, 11, 43}:     "HOSTNET CORPORATION",
	[3]byte{0, 11, 44}:     "Eiki Industrial Co. Ltd.",
	[3]byte{0, 11, 45}:     "Danfoss Inc.",
	[3]byte{0, 11, 46}:     "Cal-Comp Electronics (Thailand) Public Company Limited Taipe",
	[3]byte{0, 11, 47}:     "bplan GmbH",
	[3]byte{0, 11, 48}:     "Beijing Gongye Science & Technology Co.,Ltd",
	[3]byte{0, 11, 49}:     "Yantai ZhiYang Scientific and technology industry CO., LTD",
	[3]byte{0, 11, 50}:     "VORMETRIC, INC.",
	[3]byte{0, 11, 51}:     "Vivato Technologies",
	[3]byte{0, 11, 52}:     "ShangHai Broadband Technologies CO.LTD",
	[3]byte{0, 11, 53}:     "Quad Bit System co., Ltd.",
	[3]byte{0, 11, 54}:     "Productivity Systems, Inc.",
	[3]byte{0, 11, 55}:     "MANUFACTURE DES MONTRES ROLEX SA",
	[3]byte{0, 11, 56}:     "Knürr GmbH",
	[3]byte{0, 11, 57}:     "Keisoku Giken Co.,Ltd.",
	[3]byte{0, 11, 58}:     "QuStream Corporation",
	[3]byte{0, 11, 59}:     "devolo AG",
	[3]byte{0, 11, 60}:     "Cygnal Integrated Products, Inc.",
	[3]byte{0, 11, 61}:     "CONTAL OK Ltd.",
	[3]byte{0, 11, 62}:     "BittWare, Inc",
	[3]byte{0, 11, 63}:     "Anthology Solutions Inc.",
	[3]byte{0, 11, 64}:     "Oclaro",
	[3]byte{0, 11, 65}:     "Ing. Büro Dr. Beutlhauser",
	[3]byte{0, 11, 66}:     "commax Co., Ltd.",
	[3]byte{0, 11, 67}:     "Microscan Systems, Inc.",
	[3]byte{0, 11, 68}:     "Concord IDea Corp.",
	[3]byte{0, 11, 69}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 11, 70}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 11, 71}:     "Advanced Energy",
	[3]byte{0, 11, 72}:     "sofrel",
	[3]byte{0, 11, 73}:     "RF-Link System Inc.",
	[3]byte{0, 11, 74}:     "Visimetrics (UK) Ltd",
	[3]byte{0, 11, 75}:     "VISIOWAVE SA",
	[3]byte{0, 11, 76}:     "Clarion (M) Sdn Bhd",
	[3]byte{0, 11, 77}:     "Emuzed",
	[3]byte{0, 11, 78}:     "VertexRSI, General Dynamics SatCOM Technologies, Inc.",
	[3]byte{0, 11, 79}:     "Verifone, INC.",
	[3]byte{0, 11, 80}:     "Oxygnet",
	[3]byte{0, 11, 81}:     "Micetek International Inc.",
	[3]byte{0, 11, 82}:     "JOYMAX ELECTRONICS CO. LTD.",
	[3]byte{0, 11, 83}:     "INITIUM Co., Ltd.",
	[3]byte{0, 11, 84}:     "BiTMICRO Networks, Inc.",
	[3]byte{0, 11, 85}:     "ADInstruments",
	[3]byte{0, 11, 86}:     "Cybernetics",
	[3]byte{0, 11, 87}:     "Silicon Laboratories",
	[3]byte{0, 11, 88}:     "Astronautics C.A  LTD",
	[3]byte{0, 11, 89}:     "ScriptPro, LLC",
	[3]byte{0, 11, 90}:     "HyperEdge",
	[3]byte{0, 11, 91}:     "Rincon Research Corporation",
	[3]byte{0, 11, 92}:     "Newtech Co.,Ltd",
	[3]byte{0, 11, 93}:     "FUJITSU LIMITED",
	[3]byte{0, 11, 94}:     "Audio Engineering Society Inc.",
	[3]byte{0, 11, 95}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 11, 96}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 11, 97}:     "Friedrich Lütze GmbH & Co. KG",
	[3]byte{0, 11, 98}:     "ib-mohnen KG",
	[3]byte{0, 11, 99}:     "Kaleidescape",
	[3]byte{0, 11, 100}:    "Kieback & Peter GmbH & Co KG",
	[3]byte{0, 11, 101}:    "Sy.A.C. srl",
	[3]byte{0, 11, 102}:    "Teralink Communications",
	[3]byte{0, 11, 103}:    "Topview Technology Corporation",
	[3]byte{0, 11, 104}:    "Addvalue Communications Pte Ltd",
	[3]byte{0, 11, 105}:    "Franke Finland Oy",
	[3]byte{0, 11, 106}:    "Asiarock Incorporation",
	[3]byte{0, 11, 107}:    "Wistron Neweb Corp.",
	[3]byte{0, 11, 108}:    "Sychip Inc.",
	[3]byte{0, 11, 109}:    "SOLECTRON JAPAN NAKANIIDA",
	[3]byte{0, 11, 110}:    "Neff Instrument Corp.",
	[3]byte{0, 11, 111}:    "Media Streaming Networks Inc",
	[3]byte{0, 11, 112}:    "Load Technology, Inc.",
	[3]byte{0, 11, 113}:    "Litchfield Communications Inc.",
	[3]byte{0, 11, 114}:    "Lawo AG",
	[3]byte{0, 11, 115}:    "Kodeos Communications",
	[3]byte{0, 11, 116}:    "Kingwave Technology Co., Ltd.",
	[3]byte{0, 11, 117}:    "Iosoft Ltd.",
	[3]byte{0, 11, 118}:    "ET&T Technology Co. Ltd.",
	[3]byte{0, 11, 119}:    "Cogent Systems, Inc.",
	[3]byte{0, 11, 120}:    "TAIFATECH INC.",
	[3]byte{0, 11, 121}:    "X-COM, Inc.",
	[3]byte{0, 11, 122}:    "L-3 Linkabit",
	[3]byte{0, 11, 123}:    "Test-Um Inc.",
	[3]byte{0, 11, 124}:    "Telex Communications",
	[3]byte{0, 11, 125}:    "SOLOMON EXTREME INTERNATIONAL LTD.",
	[3]byte{0, 11, 126}:    "SAGINOMIYA Seisakusho Inc.",
	[3]byte{0, 11, 127}:    "Align Engineering LLC",
	[3]byte{0, 11, 128}:    "Lycium Networks",
	[3]byte{0, 11, 129}:    "Kaparel Corporation",
	[3]byte{0, 11, 130}:    "Grandstream Networks, Inc.",
	[3]byte{0, 11, 131}:    "DATAWATT B.V.",
	[3]byte{0, 11, 132}:    "BODET",
	[3]byte{0, 11, 133}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 11, 134}:    "Aruba Networks",
	[3]byte{0, 11, 135}:    "American Reliance Inc.",
	[3]byte{0, 11, 136}:    "Vidisco ltd.",
	[3]byte{0, 11, 137}:    "Top Global Technology, Ltd.",
	[3]byte{0, 11, 138}:    "MITEQ Inc.",
	[3]byte{0, 11, 139}:    "KERAJET, S.A.",
	[3]byte{0, 11, 140}:    "Flextronics",
	[3]byte{0, 11, 141}:    "Avvio Networks",
	[3]byte{0, 11, 142}:    "Ascent Corporation",
	[3]byte{0, 11, 143}:    "AKITA ELECTRONICS SYSTEMS CO.,LTD.",
	[3]byte{0, 11, 144}:    "ADVA Optical Networking Ltd.",
	[3]byte{0, 11, 145}:    "Aglaia Gesellschaft für Bildverarbeitung und Kommunikation mbH",
	[3]byte{0, 11, 146}:    "Ascom Danmark A/S",
	[3]byte{0, 11, 147}:    "Ritter Elektronik",
	[3]byte{0, 11, 148}:    "Digital Monitoring Products, Inc.",
	[3]byte{0, 11, 149}:    "eBet Gaming Systems Pty Ltd",
	[3]byte{0, 11, 150}:    "Innotrac Diagnostics Oy",
	[3]byte{0, 11, 151}:    "Matsushita Electric Industrial Co.,Ltd.",
	[3]byte{0, 11, 152}:    "NiceTechVision",
	[3]byte{0, 11, 153}:    "SensAble Technologies, Inc.",
	[3]byte{0, 11, 154}:    "Shanghai Ulink Telecom Equipment Co. Ltd.",
	[3]byte{0, 11, 155}:    "Sirius System Co, Ltd.",
	[3]byte{0, 11, 156}:    "TriBeam Technologies, Inc.",
	[3]byte{0, 11, 157}:    "TwinMOS Technologies Inc.",
	[3]byte{0, 11, 158}:    "Yasing Technology Corp.",
	[3]byte{0, 11, 159}:    "Neue ELSA GmbH",
	[3]byte{0, 11, 160}:    "T&L Information Inc.",
	[3]byte{0, 11, 161}:    "SYSCOM Ltd.",
	[3]byte{0, 11, 162}:    "Sumitomo Electric Networks, Inc",
	[3]byte{0, 11, 163}:    "Siemens AG, I&S",
	[3]byte{0, 11, 164}:    "Shiron Satellite Communications Ltd. (1996)",
	[3]byte{0, 11, 165}:    "Quasar Cipta Mandiri, PT",
	[3]byte{0, 11, 166}:    "Miyakawa Electric Works Ltd.",
	[3]byte{0, 11, 167}:    "Maranti Networks",
	[3]byte{0, 11, 168}:    "HANBACK ELECTRONICS CO., LTD.",
	[3]byte{0, 11, 169}:    "CloudShield Technologies, Inc.",
	[3]byte{0, 11, 170}:    "Aiphone co.,Ltd",
	[3]byte{0, 11, 171}:    "Advantech Technology (CHINA) Co., Ltd.",
	[3]byte{0, 11, 172}:    "3Com Ltd",
	[3]byte{0, 11, 173}:    "PC-PoS Inc.",
	[3]byte{0, 11, 174}:    "Vitals System Inc.",
	[3]byte{0, 11, 175}:    "WOOJU COMMUNICATIONS Co,.Ltd",
	[3]byte{0, 11, 176}:    "Sysnet Telematica srl",
	[3]byte{0, 11, 177}:    "Super Star Technology Co., Ltd.",
	[3]byte{0, 11, 178}:    "SMALLBIG TECHNOLOGY",
	[3]byte{0, 11, 179}:    "RiT technologies Ltd.",
	[3]byte{0, 11, 180}:    "RDC Semiconductor Inc.,",
	[3]byte{0, 11, 181}:    "nStor Technologies, Inc.",
	[3]byte{0, 11, 182}:    "Metalligence Technology Corp.",
	[3]byte{0, 11, 183}:    "Micro Systems Co.,Ltd.",
	[3]byte{0, 11, 184}:    "Kihoku Electronic Co.",
	[3]byte{0, 11, 185}:    "Imsys AB",
	[3]byte{0, 11, 186}:    "Harmonic, Inc",
	[3]byte{0, 11, 187}:    "Etin Systems Co., Ltd",
	[3]byte{0, 11, 188}:    "En Garde Systems, Inc.",
	[3]byte{0, 11, 189}:    "Connexionz Limited",
	[3]byte{0, 11, 190}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 11, 191}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 11, 192}:    "China IWNComm Co., Ltd.",
	[3]byte{0, 11, 193}:    "Bay Microsystems, Inc.",
	[3]byte{0, 11, 194}:    "Corinex Communication Corp.",
	[3]byte{0, 11, 195}:    "Multiplex, Inc.",
	[3]byte{0, 11, 196}:    "BIOTRONIK GmbH & Co",
	[3]byte{0, 11, 197}:    "SMC Networks, Inc.",
	[3]byte{0, 11, 198}:    "ISAC, Inc.",
	[3]byte{0, 11, 199}:    "ICET S.p.A.",
	[3]byte{0, 11, 200}:    "AirFlow Networks",
	[3]byte{0, 11, 201}:    "Electroline Equipment",
	[3]byte{0, 11, 202}:    "DATAVAN International Corporation",
	[3]byte{0, 11, 203}:    "Fagor Automation , S. Coop",
	[3]byte{0, 11, 204}:    "JUSAN, S.A.",
	[3]byte{0, 11, 205}:    "Hewlett-Packard Company",
	[3]byte{0, 11, 206}:    "Free2move AB",
	[3]byte{0, 11, 207}:    "AGFA NDT INC.",
	[3]byte{0, 11, 208}:    "XiMeta Technology Americas Inc.",
	[3]byte{0, 11, 209}:    "Aeronix, Inc.",
	[3]byte{0, 11, 210}:    "Remopro Technology Inc.",
	[3]byte{0, 11, 211}:    "cd3o",
	[3]byte{0, 11, 212}:    "Beijing Wise Technology & Science Development Co.Ltd",
	[3]byte{0, 11, 213}:    "Nvergence, Inc.",
	[3]byte{0, 11, 214}:    "Paxton Access Ltd",
	[3]byte{0, 11, 215}:    "DORMA Time + Access GmbH",
	[3]byte{0, 11, 216}:    "Industrial Scientific Corp.",
	[3]byte{0, 11, 217}:    "General Hydrogen",
	[3]byte{0, 11, 218}:    "EyeCross Co.,Inc.",
	[3]byte{0, 11, 219}:    "Dell Inc",
	[3]byte{0, 11, 220}:    "AKCP",
	[3]byte{0, 11, 221}:    "TOHOKU RICOH Co., LTD.",
	[3]byte{0, 11, 222}:    "TELDIX GmbH",
	[3]byte{0, 11, 223}:    "Shenzhen RouterD Networks Limited",
	[3]byte{0, 11, 224}:    "SercoNet Ltd.",
	[3]byte{0, 11, 225}:    "Nokia NET Product Operations",
	[3]byte{0, 11, 226}:    "Lumenera Corporation",
	[3]byte{0, 11, 227}:    "Key Stream Co., Ltd.",
	[3]byte{0, 11, 228}:    "Hosiden Corporation",
	[3]byte{0, 11, 229}:    "HIMS International Corporation",
	[3]byte{0, 11, 230}:    "Datel Electronics",
	[3]byte{0, 11, 231}:    "COMFLUX TECHNOLOGY INC.",
	[3]byte{0, 11, 232}:    "AOIP",
	[3]byte{0, 11, 233}:    "Actel Corporation",
	[3]byte{0, 11, 234}:    "Zultys Technologies",
	[3]byte{0, 11, 235}:    "Systegra AG",
	[3]byte{0, 11, 236}:    "NIPPON ELECTRIC INSTRUMENT, INC.",
	[3]byte{0, 11, 237}:    "ELM Inc.",
	[3]byte{0, 11, 238}:    "inc.jet, Incorporated",
	[3]byte{0, 11, 239}:    "Code Corporation",
	[3]byte{0, 11, 240}:    "MoTEX Products Co., Ltd.",
	[3]byte{0, 11, 241}:    "LAP Laser Applikations",
	[3]byte{0, 11, 242}:    "Chih-Kan Technology Co., Ltd.",
	[3]byte{0, 11, 243}:    "BAE SYSTEMS",
	[3]byte{0, 11, 244}:    "PRIVATE",
	[3]byte{0, 11, 245}:    "Shanghai Sibo Telecom Technology Co.,Ltd",
	[3]byte{0, 11, 246}:    "Nitgen Co., Ltd",
	[3]byte{0, 11, 247}:    "NIDEK CO.,LTD",
	[3]byte{0, 11, 248}:    "Infinera",
	[3]byte{0, 11, 249}:    "Gemstone communications, Inc.",
	[3]byte{0, 11, 250}:    "EXEMYS SRL",
	[3]byte{0, 11, 251}:    "D-NET International Corporation",
	[3]byte{0, 11, 252}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 11, 253}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 11, 254}:    "CASTEL Broadband Limited",
	[3]byte{0, 11, 255}:    "Berkeley Camera Engineering",
	[3]byte{0, 12, 0}:      "BEB Industrie-Elektronik AG",
	[3]byte{0, 12, 1}:      "Abatron AG",
	[3]byte{0, 12, 2}:      "ABB Oy",
	[3]byte{0, 12, 3}:      "HDMI Licensing, LLC",
	[3]byte{0, 12, 4}:      "Tecnova",
	[3]byte{0, 12, 5}:      "RPA Reserch Co., Ltd.",
	[3]byte{0, 12, 6}:      "Nixvue Systems  Pte Ltd",
	[3]byte{0, 12, 7}:      "Iftest AG",
	[3]byte{0, 12, 8}:      "HUMEX Technologies Corp.",
	[3]byte{0, 12, 9}:      "Hitachi IE Systems Co., Ltd",
	[3]byte{0, 12, 10}:     "Guangdong Province Electronic Technology Research Institute",
	[3]byte{0, 12, 11}:     "Broadbus Technologies",
	[3]byte{0, 12, 12}:     "APPRO TECHNOLOGY INC.",
	[3]byte{0, 12, 13}:     "Communications & Power Industries / Satcom Division",
	[3]byte{0, 12, 14}:     "XtremeSpectrum, Inc.",
	[3]byte{0, 12, 15}:     "Techno-One Co., Ltd",
	[3]byte{0, 12, 16}:     "PNI Corporation",
	[3]byte{0, 12, 17}:     "NIPPON DEMPA CO.,LTD.",
	[3]byte{0, 12, 18}:     "Micro-Optronic-Messtechnik GmbH",
	[3]byte{0, 12, 19}:     "MediaQ",
	[3]byte{0, 12, 20}:     "Diagnostic Instruments, Inc.",
	[3]byte{0, 12, 21}:     "CyberPower Systems, Inc.",
	[3]byte{0, 12, 22}:     "Concorde Microsystems Inc.",
	[3]byte{0, 12, 23}:     "AJA Video Systems Inc",
	[3]byte{0, 12, 24}:     "Zenisu Keisoku Inc.",
	[3]byte{0, 12, 25}:     "Telio Communications GmbH",
	[3]byte{0, 12, 26}:     "Quest Technical Solutions Inc.",
	[3]byte{0, 12, 27}:     "ORACOM Co, Ltd.",
	[3]byte{0, 12, 28}:     "MicroWeb Co., Ltd.",
	[3]byte{0, 12, 29}:     "Mettler & Fuchs AG",
	[3]byte{0, 12, 30}:     "Global Cache",
	[3]byte{0, 12, 31}:     "Glimmerglass Networks",
	[3]byte{0, 12, 32}:     "Fi WIn, Inc.",
	[3]byte{0, 12, 33}:     "Faculty of Science and Technology, Keio University",
	[3]byte{0, 12, 34}:     "Double D Electronics Ltd",
	[3]byte{0, 12, 35}:     "Beijing Lanchuan Tech. Co., Ltd.",
	[3]byte{0, 12, 36}:     "ANATOR",
	[3]byte{0, 12, 37}:     "Allied Telesis Labs, Inc.",
	[3]byte{0, 12, 38}:     "Weintek Labs. Inc.",
	[3]byte{0, 12, 39}:     "Sammy Corporation",
	[3]byte{0, 12, 40}:     "RIFATRON",
	[3]byte{0, 12, 41}:     "VMware, Inc.",
	[3]byte{0, 12, 42}:     "OCTTEL Communication Co., Ltd.",
	[3]byte{0, 12, 43}:     "ELIAS Technology, Inc.",
	[3]byte{0, 12, 44}:     "Enwiser Inc.",
	[3]byte{0, 12, 45}:     "FullWave Technology Co., Ltd.",
	[3]byte{0, 12, 46}:     "Openet information technology(shenzhen) Co., Ltd.",
	[3]byte{0, 12, 47}:     "SeorimTechnology Co.,Ltd.",
	[3]byte{0, 12, 48}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 12, 49}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 12, 50}:     "Avionic Design Development GmbH",
	[3]byte{0, 12, 51}:     "Compucase Enterprise Co. Ltd.",
	[3]byte{0, 12, 52}:     "Vixen Co., Ltd.",
	[3]byte{0, 12, 53}:     "KaVo Dental GmbH & Co. KG",
	[3]byte{0, 12, 54}:     "SHARP TAKAYA ELECTRONICS INDUSTRY CO.,LTD.",
	[3]byte{0, 12, 55}:     "Geomation, Inc.",
	[3]byte{0, 12, 56}:     "TelcoBridges Inc.",
	[3]byte{0, 12, 57}:     "Sentinel Wireless Inc.",
	[3]byte{0, 12, 58}:     "Oxance",
	[3]byte{0, 12, 59}:     "Orion Electric Co., Ltd.",
	[3]byte{0, 12, 60}:     "MediaChorus, Inc.",
	[3]byte{0, 12, 61}:     "Glsystech Co., Ltd.",
	[3]byte{0, 12, 62}:     "Crest Audio",
	[3]byte{0, 12, 63}:     "Cogent Defence & Security Networks,",
	[3]byte{0, 12, 64}:     "Altech Controls",
	[3]byte{0, 12, 65}:     "Cisco-Linksys",
	[3]byte{0, 12, 66}:     "Routerboard.com",
	[3]byte{0, 12, 67}:     "Ralink Technology, Corp.",
	[3]byte{0, 12, 68}:     "Automated Interfaces, Inc.",
	[3]byte{0, 12, 69}:     "Animation Technologies Inc.",
	[3]byte{0, 12, 70}:     "Allied Telesyn Inc.",
	[3]byte{0, 12, 71}:     "SK Teletech(R&D Planning Team)",
	[3]byte{0, 12, 72}:     "QoStek Corporation",
	[3]byte{0, 12, 73}:     "Dangaard Telecom RTC Division A/S",
	[3]byte{0, 12, 74}:     "Cygnus Microsystems (P) Limited",
	[3]byte{0, 12, 75}:     "Cheops Elektronik",
	[3]byte{0, 12, 76}:     "Arcor AG&Co.",
	[3]byte{0, 12, 77}:     "Curtiss-Wright Controls Avionics & Electronics",
	[3]byte{0, 12, 78}:     "Winbest Technology CO,LT",
	[3]byte{0, 12, 79}:     "UDTech Japan Corporation",
	[3]byte{0, 12, 80}:     "Seagate Technology",
	[3]byte{0, 12, 81}:     "Scientific Technologies Inc.",
	[3]byte{0, 12, 82}:     "Roll Systems Inc.",
	[3]byte{0, 12, 83}:     "PRIVATE",
	[3]byte{0, 12, 84}:     "Pedestal Networks, Inc",
	[3]byte{0, 12, 85}:     "Microlink Communications Inc.",
	[3]byte{0, 12, 86}:     "Megatel Computer (1986) Corp.",
	[3]byte{0, 12, 87}:     "MACKIE Engineering Services Belgium BVBA",
	[3]byte{0, 12, 88}:     "M&S Systems",
	[3]byte{0, 12, 89}:     "Indyme Electronics, Inc.",
	[3]byte{0, 12, 90}:     "IBSmm Embedded Electronics Consulting",
	[3]byte{0, 12, 91}:     "HANWANG TECHNOLOGY CO.,LTD",
	[3]byte{0, 12, 92}:     "GTN Systems B.V.",
	[3]byte{0, 12, 93}:     "CHIC TECHNOLOGY (CHINA) CORP.",
	[3]byte{0, 12, 94}:     "Calypso Medical",
	[3]byte{0, 12, 95}:     "Avtec, Inc.",
	[3]byte{0, 12, 96}:     "ACM Systems",
	[3]byte{0, 12, 97}:     "AC Tech corporation DBA Advanced Digital",
	[3]byte{0, 12, 98}:     "ABB AB, Cewe-Control",
	[3]byte{0, 12, 99}:     "Zenith Electronics Corporation",
	[3]byte{0, 12, 100}:    "X2 MSA Group",
	[3]byte{0, 12, 101}:    "Sunin Telecom",
	[3]byte{0, 12, 102}:    "Pronto Networks Inc",
	[3]byte{0, 12, 103}:    "OYO ELECTRIC CO.,LTD",
	[3]byte{0, 12, 104}:    "SigmaTel, Inc.",
	[3]byte{0, 12, 105}:    "National Radio Astronomy Observatory",
	[3]byte{0, 12, 106}:    "MBARI",
	[3]byte{0, 12, 107}:    "Kurz Industrie-Elektronik GmbH",
	[3]byte{0, 12, 108}:    "Elgato Systems LLC",
	[3]byte{0, 12, 109}:    "Edwards Ltd.",
	[3]byte{0, 12, 110}:    "ASUSTEK COMPUTER INC.",
	[3]byte{0, 12, 111}:    "Amtek system co.,LTD.",
	[3]byte{0, 12, 112}:    "ACC GmbH",
	[3]byte{0, 12, 113}:    "Wybron, Inc",
	[3]byte{0, 12, 114}:    "Tempearl Industrial Co., Ltd.",
	[3]byte{0, 12, 115}:    "TELSON ELECTRONICS CO., LTD",
	[3]byte{0, 12, 116}:    "RIVERTEC CORPORATION",
	[3]byte{0, 12, 117}:    "Oriental integrated electronics. LTD",
	[3]byte{0, 12, 118}:    "MICRO-STAR INTERNATIONAL CO., LTD.",
	[3]byte{0, 12, 119}:    "Life Racing Ltd",
	[3]byte{0, 12, 120}:    "In-Tech Electronics Limited",
	[3]byte{0, 12, 121}:    "Extel Communications P/L",
	[3]byte{0, 12, 122}:    "DaTARIUS Technologies GmbH",
	[3]byte{0, 12, 123}:    "ALPHA PROJECT Co.,Ltd.",
	[3]byte{0, 12, 124}:    "Internet Information Image Inc.",
	[3]byte{0, 12, 125}:    "TEIKOKU ELECTRIC MFG. CO., LTD",
	[3]byte{0, 12, 126}:    "Tellium Incorporated",
	[3]byte{0, 12, 127}:    "synertronixx GmbH",
	[3]byte{0, 12, 128}:    "Opelcomm Inc.",
	[3]byte{0, 12, 129}:    "Schneider Electric (Australia)",
	[3]byte{0, 12, 130}:    "NETWORK TECHNOLOGIES INC",
	[3]byte{0, 12, 131}:    "Logical Solutions",
	[3]byte{0, 12, 132}:    "Eazix, Inc.",
	[3]byte{0, 12, 133}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 12, 134}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 12, 135}:    "AMD",
	[3]byte{0, 12, 136}:    "Apache Micro Peripherals, Inc.",
	[3]byte{0, 12, 137}:    "AC Electric Vehicles, Ltd.",
	[3]byte{0, 12, 138}:    "Bose Corporation",
	[3]byte{0, 12, 139}:    "Connect Tech Inc",
	[3]byte{0, 12, 140}:    "KODICOM CO.,LTD.",
	[3]byte{0, 12, 141}:    "MATRIX VISION GmbH",
	[3]byte{0, 12, 142}:    "Mentor Engineering Inc",
	[3]byte{0, 12, 143}:    "Nergal s.r.l.",
	[3]byte{0, 12, 144}:    "Octasic Inc.",
	[3]byte{0, 12, 145}:    "Riverhead Networks Inc.",
	[3]byte{0, 12, 146}:    "WolfVision Gmbh",
	[3]byte{0, 12, 147}:    "Xeline Co., Ltd.",
	[3]byte{0, 12, 148}:    "United Electronic Industries, Inc. (EUI)",
	[3]byte{0, 12, 149}:    "PrimeNet",
	[3]byte{0, 12, 150}:    "OQO, Inc.",
	[3]byte{0, 12, 151}:    "NV ADB TTV Technologies SA",
	[3]byte{0, 12, 152}:    "LETEK Communications Inc.",
	[3]byte{0, 12, 153}:    "HITEL LINK Co.,Ltd",
	[3]byte{0, 12, 154}:    "Hitech Electronics Corp.",
	[3]byte{0, 12, 155}:    "EE Solutions, Inc",
	[3]byte{0, 12, 156}:    "Chongho information & communications",
	[3]byte{0, 12, 157}:    "UbeeAirWalk, Inc.",
	[3]byte{0, 12, 158}:    "MemoryLink Corp.",
	[3]byte{0, 12, 159}:    "NKE Corporation",
	[3]byte{0, 12, 160}:    "StorCase Technology, Inc.",
	[3]byte{0, 12, 161}:    "SIGMACOM Co., LTD.",
	[3]byte{0, 12, 162}:    "Harmonic Video Network",
	[3]byte{0, 12, 163}:    "Rancho Technology, Inc.",
	[3]byte{0, 12, 164}:    "Prompttec Product Management GmbH",
	[3]byte{0, 12, 165}:    "Naman NZ LTd",
	[3]byte{0, 12, 166}:    "Mintera Corporation",
	[3]byte{0, 12, 167}:    "Metro (Suzhou) Technologies Co., Ltd.",
	[3]byte{0, 12, 168}:    "Garuda Networks Corporation",
	[3]byte{0, 12, 169}:    "Ebtron Inc.",
	[3]byte{0, 12, 170}:    "Cubic Transportation Systems Inc",
	[3]byte{0, 12, 171}:    "COMMEND International",
	[3]byte{0, 12, 172}:    "Citizen Watch Co., Ltd.",
	[3]byte{0, 12, 173}:    "BTU International",
	[3]byte{0, 12, 174}:    "Ailocom Oy",
	[3]byte{0, 12, 175}:    "TRI TERM CO.,LTD.",
	[3]byte{0, 12, 176}:    "Star Semiconductor Corporation",
	[3]byte{0, 12, 177}:    "Salland Engineering (Europe) BV",
	[3]byte{0, 12, 178}:    "UNION co., ltd.",
	[3]byte{0, 12, 179}:    "ROUND Co.,Ltd.",
	[3]byte{0, 12, 180}:    "AutoCell Laboratories, Inc.",
	[3]byte{0, 12, 181}:    "Premier Technolgies, Inc",
	[3]byte{0, 12, 182}:    "NANJING SEU MOBILE & INTERNET TECHNOLOGY CO.,LTD",
	[3]byte{0, 12, 183}:    "Nanjing Huazhuo Electronics Co., Ltd.",
	[3]byte{0, 12, 184}:    "MEDION AG",
	[3]byte{0, 12, 185}:    "LEA",
	[3]byte{0, 12, 186}:    "Jamex, Inc.",
	[3]byte{0, 12, 187}:    "ISKRAEMECO",
	[3]byte{0, 12, 188}:    "Iscutum",
	[3]byte{0, 12, 189}:    "Interface Masters, Inc",
	[3]byte{0, 12, 190}:    "Innominate Security Technologies AG",
	[3]byte{0, 12, 191}:    "Holy Stone Ent. Co., Ltd.",
	[3]byte{0, 12, 192}:    "Genera Oy",
	[3]byte{0, 12, 193}:    "Cooper Industries Inc.",
	[3]byte{0, 12, 194}:    "ControlNet (India) Private Limited",
	[3]byte{0, 12, 195}:    "BeWAN systems",
	[3]byte{0, 12, 196}:    "Tiptel AG",
	[3]byte{0, 12, 197}:    "Nextlink Co., Ltd.",
	[3]byte{0, 12, 198}:    "Ka-Ro electronics GmbH",
	[3]byte{0, 12, 199}:    "Intelligent Computer Solutions Inc.",
	[3]byte{0, 12, 200}:    "Xytronix Research & Design, Inc.",
	[3]byte{0, 12, 201}:    "ILWOO DATA & TECHNOLOGY CO.,LTD",
	[3]byte{0, 12, 202}:    "HGST a Western Digital Company",
	[3]byte{0, 12, 203}:    "Design Combus Ltd",
	[3]byte{0, 12, 204}:    "Aeroscout Ltd.",
	[3]byte{0, 12, 205}:    "IEC - TC57",
	[3]byte{0, 12, 206}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 12, 207}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 12, 208}:    "Symetrix",
	[3]byte{0, 12, 209}:    "SFOM Technology Corp.",
	[3]byte{0, 12, 210}:    "Schaffner EMV AG",
	[3]byte{0, 12, 211}:    "Prettl Elektronik Radeberg GmbH",
	[3]byte{0, 12, 212}:    "Positron Public Safety Systems inc.",
	[3]byte{0, 12, 213}:    "Passave Inc.",
	[3]byte{0, 12, 214}:    "PARTNER TECH",
	[3]byte{0, 12, 215}:    "Nallatech Ltd",
	[3]byte{0, 12, 216}:    "M. K. Juchheim GmbH & Co",
	[3]byte{0, 12, 217}:    "Itcare Co., Ltd",
	[3]byte{0, 12, 218}:    "FreeHand Systems, Inc.",
	[3]byte{0, 12, 219}:    "Brocade Communications Systems, Inc",
	[3]byte{0, 12, 220}:    "BECS Technology, Inc",
	[3]byte{0, 12, 221}:    "AOS Technologies AG",
	[3]byte{0, 12, 222}:    "ABB STOTZ-KONTAKT GmbH",
	[3]byte{0, 12, 223}:    "PULNiX America, Inc",
	[3]byte{0, 12, 224}:    "Trek Diagnostics Inc.",
	[3]byte{0, 12, 225}:    "The Open Group",
	[3]byte{0, 12, 226}:    "Rolls-Royce",
	[3]byte{0, 12, 227}:    "Option International N.V.",
	[3]byte{0, 12, 228}:    "NeuroCom International, Inc.",
	[3]byte{0, 12, 229}:    "ARRIS Group, Inc.",
	[3]byte{0, 12, 230}:    "Meru Networks Inc",
	[3]byte{0, 12, 231}:    "MediaTek Inc.",
	[3]byte{0, 12, 232}:    "GuangZhou AnJuBao Co., Ltd",
	[3]byte{0, 12, 233}:    "BLOOMBERG L.P.",
	[3]byte{0, 12, 234}:    "aphona Kommunikationssysteme",
	[3]byte{0, 12, 235}:    "CNMP Networks, Inc.",
	[3]byte{0, 12, 236}:    "Spectracom Corp.",
	[3]byte{0, 12, 237}:    "Real Digital Media",
	[3]byte{0, 12, 238}:    "jp-embedded",
	[3]byte{0, 12, 239}:    "Open Networks Engineering Ltd",
	[3]byte{0, 12, 240}:    "M & N GmbH",
	[3]byte{0, 12, 241}:    "Intel Corporation",
	[3]byte{0, 12, 242}:    "GAMESA Eólica",
	[3]byte{0, 12, 243}:    "CALL IMAGE SA",
	[3]byte{0, 12, 244}:    "AKATSUKI ELECTRIC MFG.CO.,LTD.",
	[3]byte{0, 12, 245}:    "InfoExpress",
	[3]byte{0, 12, 246}:    "Sitecom Europe BV",
	[3]byte{0, 12, 247}:    "Nortel Networks",
	[3]byte{0, 12, 248}:    "Nortel Networks",
	[3]byte{0, 12, 249}:    "Xylem Water Solutions",
	[3]byte{0, 12, 250}:    "Digital Systems Corp",
	[3]byte{0, 12, 251}:    "Korea Network Systems",
	[3]byte{0, 12, 252}:    "S2io Technologies Corp",
	[3]byte{0, 12, 253}:    "Hyundai ImageQuest Co.,Ltd.",
	[3]byte{0, 12, 254}:    "Grand Electronic Co., Ltd",
	[3]byte{0, 12, 255}:    "MRO-TEK LIMITED",
	[3]byte{0, 13, 0}:      "Seaway Networks Inc.",
	[3]byte{0, 13, 1}:      "P&E Microcomputer Systems, Inc.",
	[3]byte{0, 13, 2}:      "NEC Platforms, Ltd.",
	[3]byte{0, 13, 3}:      "Matrics, Inc.",
	[3]byte{0, 13, 4}:      "Foxboro Eckardt Development GmbH",
	[3]byte{0, 13, 5}:      "cybernet manufacturing inc.",
	[3]byte{0, 13, 6}:      "Compulogic Limited",
	[3]byte{0, 13, 7}:      "Calrec Audio Ltd",
	[3]byte{0, 13, 8}:      "AboveCable, Inc.",
	[3]byte{0, 13, 9}:      "Yuehua(Zhuhai) Electronic CO. LTD",
	[3]byte{0, 13, 10}:     "Projectiondesign as",
	[3]byte{0, 13, 11}:     "Buffalo Inc.",
	[3]byte{0, 13, 12}:     "MDI Security Systems",
	[3]byte{0, 13, 13}:     "ITSupported, LLC",
	[3]byte{0, 13, 14}:     "Inqnet Systems, Inc.",
	[3]byte{0, 13, 15}:     "Finlux Ltd",
	[3]byte{0, 13, 16}:     "Embedtronics Oy",
	[3]byte{0, 13, 17}:     "DENTSPLY - Gendex",
	[3]byte{0, 13, 18}:     "AXELL Corporation",
	[3]byte{0, 13, 19}:     "Wilhelm Rutenbeck GmbH&Co.KG",
	[3]byte{0, 13, 20}:     "Vtech Innovation LP dba Advanced American Telephones",
	[3]byte{0, 13, 21}:     "Voipac s.r.o.",
	[3]byte{0, 13, 22}:     "UHS Systems Pty Ltd",
	[3]byte{0, 13, 23}:     "Turbo Networks Co.Ltd",
	[3]byte{0, 13, 24}:     "Mega-Trend Electronics CO., LTD.",
	[3]byte{0, 13, 25}:     "ROBE Show lighting",
	[3]byte{0, 13, 26}:     "Mustek System Inc.",
	[3]byte{0, 13, 27}:     "Kyoto Electronics Manufacturing Co., Ltd.",
	[3]byte{0, 13, 28}:     "Amesys Defense",
	[3]byte{0, 13, 29}:     "HIGH-TEK HARNESS ENT. CO., LTD.",
	[3]byte{0, 13, 30}:     "Control Techniques",
	[3]byte{0, 13, 31}:     "AV Digital",
	[3]byte{0, 13, 32}:     "ASAHIKASEI TECHNOSYSTEM CO.,LTD.",
	[3]byte{0, 13, 33}:     "WISCORE Inc.",
	[3]byte{0, 13, 34}:     "Unitronics LTD",
	[3]byte{0, 13, 35}:     "Smart Solution, Inc",
	[3]byte{0, 13, 36}:     "SENTEC E&E CO., LTD.",
	[3]byte{0, 13, 37}:     "SANDEN CORPORATION",
	[3]byte{0, 13, 38}:     "Primagraphics Limited",
	[3]byte{0, 13, 39}:     "MICROPLEX Printware AG",
	[3]byte{0, 13, 40}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 13, 41}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 13, 42}:     "Scanmatic AS",
	[3]byte{0, 13, 43}:     "Racal Instruments",
	[3]byte{0, 13, 44}:     "Patapsco Designs Ltd",
	[3]byte{0, 13, 45}:     "NCT Deutschland GmbH",
	[3]byte{0, 13, 46}:     "Matsushita Avionics Systems Corporation",
	[3]byte{0, 13, 47}:     "AIN Comm.Tech.Co., LTD",
	[3]byte{0, 13, 48}:     "IceFyre Semiconductor",
	[3]byte{0, 13, 49}:     "Compellent Technologies, Inc.",
	[3]byte{0, 13, 50}:     "DispenseSource, Inc.",
	[3]byte{0, 13, 51}:     "Prediwave Corp.",
	[3]byte{0, 13, 52}:     "Shell International Exploration and Production, Inc.",
	[3]byte{0, 13, 53}:     "PAC International Ltd",
	[3]byte{0, 13, 54}:     "Wu Han Routon Electronic Co., Ltd",
	[3]byte{0, 13, 55}:     "WIPLUG",
	[3]byte{0, 13, 56}:     "NISSIN INC.",
	[3]byte{0, 13, 57}:     "Network Electronics",
	[3]byte{0, 13, 58}:     "Microsoft Corp.",
	[3]byte{0, 13, 59}:     "Microelectronics Technology Inc.",
	[3]byte{0, 13, 60}:     "i.Tech Dynamic Ltd",
	[3]byte{0, 13, 61}:     "Hammerhead Systems, Inc.",
	[3]byte{0, 13, 62}:     "APLUX Communications Ltd.",
	[3]byte{0, 13, 63}:     "VTI Instruments Corporation",
	[3]byte{0, 13, 64}:     "Verint Loronix Video Solutions",
	[3]byte{0, 13, 65}:     "Siemens AG ICM MP UC RD IT KLF1",
	[3]byte{0, 13, 66}:     "Newbest Development Limited",
	[3]byte{0, 13, 67}:     "DRS Tactical Systems Inc.",
	[3]byte{0, 13, 68}:     "Audio BU - Logitech",
	[3]byte{0, 13, 69}:     "Tottori SANYO Electric Co., Ltd.",
	[3]byte{0, 13, 70}:     "Parker SSD Drives",
	[3]byte{0, 13, 71}:     "Collex",
	[3]byte{0, 13, 72}:     "AEWIN Technologies Co., Ltd.",
	[3]byte{0, 13, 73}:     "Triton Systems of Delaware, Inc.",
	[3]byte{0, 13, 74}:     "Steag ETA-Optik",
	[3]byte{0, 13, 75}:     "Roku, LLC",
	[3]byte{0, 13, 76}:     "Outline Electronics Ltd.",
	[3]byte{0, 13, 77}:     "Ninelanes",
	[3]byte{0, 13, 78}:     "NDR Co.,LTD.",
	[3]byte{0, 13, 79}:     "Kenwood Corporation",
	[3]byte{0, 13, 80}:     "Galazar Networks",
	[3]byte{0, 13, 81}:     "DIVR Systems, Inc.",
	[3]byte{0, 13, 82}:     "Comart system",
	[3]byte{0, 13, 83}:     "Beijing 5w Communication Corp.",
	[3]byte{0, 13, 84}:     "3Com Ltd",
	[3]byte{0, 13, 85}:     "SANYCOM Technology Co.,Ltd",
	[3]byte{0, 13, 86}:     "Dell Inc",
	[3]byte{0, 13, 87}:     "Fujitsu I-Network Systems Limited.",
	[3]byte{0, 13, 88}:     "PRIVATE",
	[3]byte{0, 13, 89}:     "Amity Systems, Inc.",
	[3]byte{0, 13, 90}:     "Tiesse SpA",
	[3]byte{0, 13, 91}:     "Smart Empire Investments Limited",
	[3]byte{0, 13, 92}:     "Robert Bosch GmbH, VT-ATMO",
	[3]byte{0, 13, 93}:     "Raritan Computer, Inc",
	[3]byte{0, 13, 94}:     "NEC Personal Products",
	[3]byte{0, 13, 95}:     "Minds Inc",
	[3]byte{0, 13, 96}:     "IBM Corp",
	[3]byte{0, 13, 97}:     "Giga-Byte Technology Co., Ltd.",
	[3]byte{0, 13, 98}:     "Funkwerk Dabendorf GmbH",
	[3]byte{0, 13, 99}:     "DENT Instruments, Inc.",
	[3]byte{0, 13, 100}:    "COMAG Handels AG",
	[3]byte{0, 13, 101}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 13, 102}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 13, 103}:    "Ericsson",
	[3]byte{0, 13, 104}:    "Vinci Systems, Inc.",
	[3]byte{0, 13, 105}:    "TMT&D Corporation",
	[3]byte{0, 13, 106}:    "Redwood Technologies LTD",
	[3]byte{0, 13, 107}:    "Mita-Teknik A/S",
	[3]byte{0, 13, 108}:    "M-Audio",
	[3]byte{0, 13, 109}:    "K-Tech Devices Corp.",
	[3]byte{0, 13, 110}:    "K-Patents Oy",
	[3]byte{0, 13, 111}:    "Ember Corporation",
	[3]byte{0, 13, 112}:    "Datamax Corporation",
	[3]byte{0, 13, 113}:    "boca systems",
	[3]byte{0, 13, 114}:    "2Wire, Inc",
	[3]byte{0, 13, 115}:    "Technical Support, Inc.",
	[3]byte{0, 13, 116}:    "Sand Network Systems, Inc.",
	[3]byte{0, 13, 117}:    "Kobian Pte Ltd - Taiwan Branch",
	[3]byte{0, 13, 118}:    "Hokuto Denshi Co,. Ltd.",
	[3]byte{0, 13, 119}:    "FalconStor Software",
	[3]byte{0, 13, 120}:    "Engineering & Security",
	[3]byte{0, 13, 121}:    "Dynamic Solutions Co,.Ltd.",
	[3]byte{0, 13, 122}:    "DiGATTO Asia Pacific Pte Ltd",
	[3]byte{0, 13, 123}:    "Consensys Computers Inc.",
	[3]byte{0, 13, 124}:    "Codian Ltd",
	[3]byte{0, 13, 125}:    "Afco Systems",
	[3]byte{0, 13, 126}:    "Axiowave Networks, Inc.",
	[3]byte{0, 13, 127}:    "MIDAS  COMMUNICATION TECHNOLOGIES PTE LTD ( Foreign Branch)",
	[3]byte{0, 13, 128}:    "Online Development Inc",
	[3]byte{0, 13, 129}:    "Pepperl+Fuchs GmbH",
	[3]byte{0, 13, 130}:    "PHS srl",
	[3]byte{0, 13, 131}:    "Sanmina-SCI Hungary  Ltd.",
	[3]byte{0, 13, 132}:    "Makus Inc.",
	[3]byte{0, 13, 133}:    "Tapwave, Inc.",
	[3]byte{0, 13, 134}:    "Huber + Suhner AG",
	[3]byte{0, 13, 135}:    "Elitegroup Computer System Co. (ECS)",
	[3]byte{0, 13, 136}:    "D-Link Corporation",
	[3]byte{0, 13, 137}:    "Bils Technology Inc",
	[3]byte{0, 13, 138}:    "Winners Electronics Co., Ltd.",
	[3]byte{0, 13, 139}:    "T&D Corporation",
	[3]byte{0, 13, 140}:    "Shanghai Wedone Digital Ltd. CO.",
	[3]byte{0, 13, 141}:    "Prosoft Technology, Inc",
	[3]byte{0, 13, 142}:    "Koden Electronics Co., Ltd.",
	[3]byte{0, 13, 143}:    "King Tsushin Kogyo Co., LTD.",
	[3]byte{0, 13, 144}:    "Factum Electronics AB",
	[3]byte{0, 13, 145}:    "Eclipse (HQ Espana) S.L.",
	[3]byte{0, 13, 146}:    "Arima Communication Corporation",
	[3]byte{0, 13, 147}:    "Apple",
	[3]byte{0, 13, 148}:    "AFAR Communications,Inc",
	[3]byte{0, 13, 149}:    "Opti-cell, Inc.",
	[3]byte{0, 13, 150}:    "Vtera Technology Inc.",
	[3]byte{0, 13, 151}:    "Tropos Networks, Inc.",
	[3]byte{0, 13, 152}:    "S.W.A.C. Schmitt-Walter Automation Consult GmbH",
	[3]byte{0, 13, 153}:    "Orbital Sciences Corp.; Launch Systems Group",
	[3]byte{0, 13, 154}:    "INFOTEC LTD",
	[3]byte{0, 13, 155}:    "Heraeus Electro-Nite International N.V.",
	[3]byte{0, 13, 156}:    "Elan GmbH & Co KG",
	[3]byte{0, 13, 157}:    "Hewlett-Packard Company",
	[3]byte{0, 13, 158}:    "TOKUDEN OHIZUMI SEISAKUSYO Co.,Ltd.",
	[3]byte{0, 13, 159}:    "RF Micro Devices",
	[3]byte{0, 13, 160}:    "NEDAP N.V.",
	[3]byte{0, 13, 161}:    "MIRAE ITS Co.,LTD.",
	[3]byte{0, 13, 162}:    "Infrant Technologies, Inc.",
	[3]byte{0, 13, 163}:    "Emerging Technologies Limited",
	[3]byte{0, 13, 164}:    "DOSCH & AMAND SYSTEMS AG",
	[3]byte{0, 13, 165}:    "Fabric7 Systems, Inc",
	[3]byte{0, 13, 166}:    "Universal Switching Corporation",
	[3]byte{0, 13, 167}:    "PRIVATE",
	[3]byte{0, 13, 168}:    "Teletronics Technology Corporation",
	[3]byte{0, 13, 169}:    "T.E.A.M. S.L.",
	[3]byte{0, 13, 170}:    "S.A.Tehnology co.,Ltd.",
	[3]byte{0, 13, 171}:    "Parker Hannifin GmbH Electromechanical Division Europe",
	[3]byte{0, 13, 172}:    "Japan CBM Corporation",
	[3]byte{0, 13, 173}:    "Dataprobe, Inc.",
	[3]byte{0, 13, 174}:    "SAMSUNG HEAVY INDUSTRIES CO., LTD.",
	[3]byte{0, 13, 175}:    "Plexus Corp (UK) Ltd",
	[3]byte{0, 13, 176}:    "Olym-tech Co.,Ltd.",
	[3]byte{0, 13, 177}:    "Japan Network Service Co., Ltd.",
	[3]byte{0, 13, 178}:    "Ammasso, Inc.",
	[3]byte{0, 13, 179}:    "SDO Communication Corperation",
	[3]byte{0, 13, 180}:    "NETASQ",
	[3]byte{0, 13, 181}:    "GLOBALSAT TECHNOLOGY CORPORATION",
	[3]byte{0, 13, 182}:    "Broadcom Corporation",
	[3]byte{0, 13, 183}:    "SANKO ELECTRIC CO,.LTD",
	[3]byte{0, 13, 184}:    "SCHILLER AG",
	[3]byte{0, 13, 185}:    "PC Engines GmbH",
	[3]byte{0, 13, 186}:    "Océ Document Technologies GmbH",
	[3]byte{0, 13, 187}:    "Nippon Dentsu Co.,Ltd.",
	[3]byte{0, 13, 188}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 13, 189}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 13, 190}:    "Bel Fuse Europe Ltd.,UK",
	[3]byte{0, 13, 191}:    "TekTone Sound & Signal Mfg., Inc.",
	[3]byte{0, 13, 192}:    "Spagat AS",
	[3]byte{0, 13, 193}:    "SafeWeb Inc",
	[3]byte{0, 13, 194}:    "PRIVATE",
	[3]byte{0, 13, 195}:    "First Communication, Inc.",
	[3]byte{0, 13, 196}:    "Emcore Corporation",
	[3]byte{0, 13, 197}:    "EchoStar Global B.V.",
	[3]byte{0, 13, 198}:    "DigiRose Technology Co., Ltd.",
	[3]byte{0, 13, 199}:    "COSMIC ENGINEERING INC.",
	[3]byte{0, 13, 200}:    "AirMagnet, Inc",
	[3]byte{0, 13, 201}:    "THALES Elektronik Systeme GmbH",
	[3]byte{0, 13, 202}:    "Tait Electronics",
	[3]byte{0, 13, 203}:    "Petcomkorea Co., Ltd.",
	[3]byte{0, 13, 204}:    "NEOSMART Corp.",
	[3]byte{0, 13, 205}:    "GROUPE TXCOM",
	[3]byte{0, 13, 206}:    "Dynavac Technology Pte Ltd",
	[3]byte{0, 13, 207}:    "Cidra Corp.",
	[3]byte{0, 13, 208}:    "TetraTec Instruments GmbH",
	[3]byte{0, 13, 209}:    "Stryker Corporation",
	[3]byte{0, 13, 210}:    "Simrad Optronics ASA",
	[3]byte{0, 13, 211}:    "SAMWOO Telecommunication Co.,Ltd.",
	[3]byte{0, 13, 212}:    "Symantec Corporation",
	[3]byte{0, 13, 213}:    "O'RITE TECHNOLOGY CO.,LTD",
	[3]byte{0, 13, 214}:    "ITI    LTD",
	[3]byte{0, 13, 215}:    "Bright",
	[3]byte{0, 13, 216}:    "BBN",
	[3]byte{0, 13, 217}:    "Anton Paar GmbH",
	[3]byte{0, 13, 218}:    "ALLIED TELESIS K.K.",
	[3]byte{0, 13, 219}:    "AIRWAVE TECHNOLOGIES INC.",
	[3]byte{0, 13, 220}:    "VAC",
	[3]byte{0, 13, 221}:    "Profilo Telra Elektronik Sanayi ve Ticaret. A.Ş",
	[3]byte{0, 13, 222}:    "Joyteck Co., Ltd.",
	[3]byte{0, 13, 223}:    "Japan Image & Network Inc.",
	[3]byte{0, 13, 224}:    "ICPDAS Co.,LTD",
	[3]byte{0, 13, 225}:    "Control Products, Inc.",
	[3]byte{0, 13, 226}:    "CMZ Sistemi Elettronici",
	[3]byte{0, 13, 227}:    "AT Sweden AB",
	[3]byte{0, 13, 228}:    "DIGINICS, Inc.",
	[3]byte{0, 13, 229}:    "Samsung Thales",
	[3]byte{0, 13, 230}:    "YOUNGBO ENGINEERING CO.,LTD",
	[3]byte{0, 13, 231}:    "Snap-on OEM Group",
	[3]byte{0, 13, 232}:    "Nasaco Electronics Pte. Ltd",
	[3]byte{0, 13, 233}:    "Napatech Aps",
	[3]byte{0, 13, 234}:    "Kingtel Telecommunication Corp.",
	[3]byte{0, 13, 235}:    "CompXs Limited",
	[3]byte{0, 13, 236}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 13, 237}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 13, 238}:    "Andrew RF Power Amplifier Group",
	[3]byte{0, 13, 239}:    "Soc. Coop. Bilanciai",
	[3]byte{0, 13, 240}:    "QCOM TECHNOLOGY INC.",
	[3]byte{0, 13, 241}:    "IONIX INC.",
	[3]byte{0, 13, 242}:    "PRIVATE",
	[3]byte{0, 13, 243}:    "Asmax Solutions",
	[3]byte{0, 13, 244}:    "Watertek Co.",
	[3]byte{0, 13, 245}:    "Teletronics International Inc.",
	[3]byte{0, 13, 246}:    "Technology Thesaurus Corp.",
	[3]byte{0, 13, 247}:    "Space Dynamics Lab",
	[3]byte{0, 13, 248}:    "ORGA Kartensysteme GmbH",
	[3]byte{0, 13, 249}:    "NDS Limited",
	[3]byte{0, 13, 250}:    "Micro Control Systems Ltd.",
	[3]byte{0, 13, 251}:    "Komax AG",
	[3]byte{0, 13, 252}:    "ITFOR Inc.",
	[3]byte{0, 13, 253}:    "Huges Hi-Tech Inc.,",
	[3]byte{0, 13, 254}:    "Hauppauge Computer Works, Inc.",
	[3]byte{0, 13, 255}:    "CHENMING MOLD INDUSTRY CORP.",
	[3]byte{0, 14, 0}:      "Atrie",
	[3]byte{0, 14, 1}:      "ASIP Technologies Inc.",
	[3]byte{0, 14, 2}:      "Advantech AMT Inc.",
	[3]byte{0, 14, 3}:      "Emulex Corporation",
	[3]byte{0, 14, 4}:      "CMA/Microdialysis AB",
	[3]byte{0, 14, 5}:      "WIRELESS MATRIX CORP.",
	[3]byte{0, 14, 6}:      "Team Simoco Ltd",
	[3]byte{0, 14, 7}:      "Sony Ericsson Mobile Communications AB",
	[3]byte{0, 14, 8}:      "Cisco Linksys LLC",
	[3]byte{0, 14, 9}:      "Shenzhen Coship Software Co.,LTD.",
	[3]byte{0, 14, 10}:     "SAKUMA DESIGN OFFICE",
	[3]byte{0, 14, 11}:     "Netac Technology Co., Ltd.",
	[3]byte{0, 14, 12}:     "Intel Corporation",
	[3]byte{0, 14, 13}:     "Hesch Schröder GmbH",
	[3]byte{0, 14, 14}:     "ESA elettronica S.P.A.",
	[3]byte{0, 14, 15}:     "ERMME",
	[3]byte{0, 14, 16}:     "C-guys, Inc.",
	[3]byte{0, 14, 17}:     "BDT Büro und Datentechnik GmbH & Co.KG",
	[3]byte{0, 14, 18}:     "Adaptive Micro Systems Inc.",
	[3]byte{0, 14, 19}:     "Accu-Sort Systems inc.",
	[3]byte{0, 14, 20}:     "Visionary Solutions, Inc.",
	[3]byte{0, 14, 21}:     "Tadlys LTD",
	[3]byte{0, 14, 22}:     "SouthWing S.L.",
	[3]byte{0, 14, 23}:     "PRIVATE",
	[3]byte{0, 14, 24}:     "MyA Technology",
	[3]byte{0, 14, 25}:     "LogicaCMG Pty Ltd",
	[3]byte{0, 14, 26}:     "JPS Communications",
	[3]byte{0, 14, 27}:     "IAV GmbH",
	[3]byte{0, 14, 28}:     "Hach Company",
	[3]byte{0, 14, 29}:     "ARION Technology Inc.",
	[3]byte{0, 14, 30}:     "QLogic Corporation",
	[3]byte{0, 14, 31}:     "TCL Networks Equipment Co., Ltd.",
	[3]byte{0, 14, 32}:     "ACCESS Systems Americas, Inc.",
	[3]byte{0, 14, 33}:     "MTU Friedrichshafen GmbH",
	[3]byte{0, 14, 34}:     "PRIVATE",
	[3]byte{0, 14, 35}:     "Incipient, Inc.",
	[3]byte{0, 14, 36}:     "Huwell Technology Inc.",
	[3]byte{0, 14, 37}:     "Hannae Technology Co., Ltd",
	[3]byte{0, 14, 38}:     "Gincom Technology Corp.",
	[3]byte{0, 14, 39}:     "Crere Networks, Inc.",
	[3]byte{0, 14, 40}:     "Dynamic Ratings P/L",
	[3]byte{0, 14, 41}:     "Shester Communications Inc",
	[3]byte{0, 14, 42}:     "PRIVATE",
	[3]byte{0, 14, 43}:     "Safari Technologies",
	[3]byte{0, 14, 44}:     "Netcodec co.",
	[3]byte{0, 14, 45}:     "Hyundai Digital Technology Co.,Ltd.",
	[3]byte{0, 14, 46}:     "Edimax Technology Co., Ltd.",
	[3]byte{0, 14, 47}:     "Roche Diagnostics GmbH",
	[3]byte{0, 14, 48}:     "AERAS Networks, Inc.",
	[3]byte{0, 14, 49}:     "Olympus Soft Imaging Solutions GmbH",
	[3]byte{0, 14, 50}:     "Kontron Medical",
	[3]byte{0, 14, 51}:     "Shuko Electronics Co.,Ltd",
	[3]byte{0, 14, 52}:     "NexGen City, LP",
	[3]byte{0, 14, 53}:     "Intel Corp",
	[3]byte{0, 14, 54}:     "HEINESYS, Inc.",
	[3]byte{0, 14, 55}:     "Harms & Wende GmbH & Co.KG",
	[3]byte{0, 14, 56}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 14, 57}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 14, 58}:     "Cirrus Logic",
	[3]byte{0, 14, 59}:     "Hawking Technologies, Inc.",
	[3]byte{0, 14, 60}:     "Transact Technologies Inc",
	[3]byte{0, 14, 61}:     "Televic N.V.",
	[3]byte{0, 14, 62}:     "Sun Optronics Inc",
	[3]byte{0, 14, 63}:     "Soronti, Inc.",
	[3]byte{0, 14, 64}:     "Nortel Networks",
	[3]byte{0, 14, 65}:     "NIHON MECHATRONICS CO.,LTD.",
	[3]byte{0, 14, 66}:     "Motic Incoporation Ltd.",
	[3]byte{0, 14, 67}:     "G-Tek Electronics Sdn. Bhd.",
	[3]byte{0, 14, 68}:     "Digital 5, Inc.",
	[3]byte{0, 14, 69}:     "Beijing Newtry Electronic Technology Ltd",
	[3]byte{0, 14, 70}:     "Niigata Seimitsu Co.,Ltd.",
	[3]byte{0, 14, 71}:     "NCI System Co.,Ltd.",
	[3]byte{0, 14, 72}:     "Lipman TransAction Solutions",
	[3]byte{0, 14, 73}:     "Forsway Scandinavia AB",
	[3]byte{0, 14, 74}:     "Changchun Huayu WEBPAD Co.,LTD",
	[3]byte{0, 14, 75}:     "atrium c and i",
	[3]byte{0, 14, 76}:     "Bermai Inc.",
	[3]byte{0, 14, 77}:     "Numesa Inc.",
	[3]byte{0, 14, 78}:     "Waveplus Technology Co., Ltd.",
	[3]byte{0, 14, 79}:     "Trajet GmbH",
	[3]byte{0, 14, 80}:     "Thomson Telecom Belgium",
	[3]byte{0, 14, 81}:     "tecna elettronica srl",
	[3]byte{0, 14, 82}:     "Optium Corporation",
	[3]byte{0, 14, 83}:     "AV TECH CORPORATION",
	[3]byte{0, 14, 84}:     "AlphaCell Wireless Ltd.",
	[3]byte{0, 14, 85}:     "AUVITRAN",
	[3]byte{0, 14, 86}:     "4G Systems GmbH & Co. KG",
	[3]byte{0, 14, 87}:     "Iworld Networking, Inc.",
	[3]byte{0, 14, 88}:     "Sonos, Inc.",
	[3]byte{0, 14, 89}:     "SAGEM SA",
	[3]byte{0, 14, 90}:     "TELEFIELD inc.",
	[3]byte{0, 14, 91}:     "ParkerVision - Direct2Data",
	[3]byte{0, 14, 92}:     "ARRIS Group, Inc.",
	[3]byte{0, 14, 93}:     "Triple Play Technologies A/S",
	[3]byte{0, 14, 94}:     "Raisecom Technology",
	[3]byte{0, 14, 95}:     "activ-net GmbH & Co. KG",
	[3]byte{0, 14, 96}:     "360SUN Digital Broadband Corporation",
	[3]byte{0, 14, 97}:     "MICROTROL LIMITED",
	[3]byte{0, 14, 98}:     "Nortel Networks",
	[3]byte{0, 14, 99}:     "Lemke Diagnostics GmbH",
	[3]byte{0, 14, 100}:    "Elphel, Inc",
	[3]byte{0, 14, 101}:    "TransCore",
	[3]byte{0, 14, 102}:    "Hitachi Industry & Control Solutions, Ltd.",
	[3]byte{0, 14, 103}:    "Eltis Microelectronics Ltd.",
	[3]byte{0, 14, 104}:    "E-TOP Network Technology Inc.",
	[3]byte{0, 14, 105}:    "China Electric Power Research Institute",
	[3]byte{0, 14, 106}:    "3Com Ltd",
	[3]byte{0, 14, 107}:    "Janitza electronics GmbH",
	[3]byte{0, 14, 108}:    "Device Drivers Limited",
	[3]byte{0, 14, 109}:    "Murata Manufacturing Co., Ltd.",
	[3]byte{0, 14, 110}:    "MAT S.A. (Mircrelec Advanced Technology)",
	[3]byte{0, 14, 111}:    "IRIS Corporation Berhad",
	[3]byte{0, 14, 112}:    "in2 Networks",
	[3]byte{0, 14, 113}:    "Gemstar Technology Development Ltd.",
	[3]byte{0, 14, 114}:    "CTS electronics",
	[3]byte{0, 14, 115}:    "Tpack A/S",
	[3]byte{0, 14, 116}:    "Solar Telecom. Tech",
	[3]byte{0, 14, 117}:    "New York Air Brake Corp.",
	[3]byte{0, 14, 118}:    "GEMSOC INNOVISION INC.",
	[3]byte{0, 14, 119}:    "Decru, Inc.",
	[3]byte{0, 14, 120}:    "Amtelco",
	[3]byte{0, 14, 121}:    "Ample Communications Inc.",
	[3]byte{0, 14, 122}:    "GemWon Communications Co., Ltd.",
	[3]byte{0, 14, 123}:    "Toshiba",
	[3]byte{0, 14, 124}:    "Televes S.A.",
	[3]byte{0, 14, 125}:    "Electronics Line 3000 Ltd.",
	[3]byte{0, 14, 126}:    "ionSign Oy",
	[3]byte{0, 14, 127}:    "Hewlett-Packard Company",
	[3]byte{0, 14, 128}:    "Thomson Technology Inc",
	[3]byte{0, 14, 129}:    "Devicescape Software, Inc.",
	[3]byte{0, 14, 130}:    "Commtech Wireless",
	[3]byte{0, 14, 131}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 14, 132}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 14, 133}:    "Catalyst Enterprises, Inc.",
	[3]byte{0, 14, 134}:    "Alcatel North America",
	[3]byte{0, 14, 135}:    "adp Gauselmann GmbH",
	[3]byte{0, 14, 136}:    "VIDEOTRON CORP.",
	[3]byte{0, 14, 137}:    "CLEMATIC",
	[3]byte{0, 14, 138}:    "Avara Technologies Pty. Ltd.",
	[3]byte{0, 14, 139}:    "Astarte Technology Co, Ltd.",
	[3]byte{0, 14, 140}:    "Siemens AG A&D ET",
	[3]byte{0, 14, 141}:    "Systems in Progress Holding GmbH",
	[3]byte{0, 14, 142}:    "SparkLAN Communications, Inc.",
	[3]byte{0, 14, 143}:    "Sercomm Corp.",
	[3]byte{0, 14, 144}:    "PONICO CORP.",
	[3]byte{0, 14, 145}:    "Navico Auckland Ltd",
	[3]byte{0, 14, 146}:    "Open Telecom",
	[3]byte{0, 14, 147}:    "Milénio 3 Sistemas Electrónicos, Lda.",
	[3]byte{0, 14, 148}:    "Maas International BV",
	[3]byte{0, 14, 149}:    "Fujiya Denki Seisakusho Co.,Ltd.",
	[3]byte{0, 14, 150}:    "Cubic Defense Applications, Inc.",
	[3]byte{0, 14, 151}:    "Ultracker Technology CO., Inc",
	[3]byte{0, 14, 152}:    "HME Clear-Com LTD.",
	[3]byte{0, 14, 153}:    "Spectrum Digital, Inc",
	[3]byte{0, 14, 154}:    "BOE TECHNOLOGY GROUP CO.,LTD",
	[3]byte{0, 14, 155}:    "Ambit Microsystems Corporation",
	[3]byte{0, 14, 156}:    "Benchmark Electronics",
	[3]byte{0, 14, 157}:    "Tiscali UK Ltd",
	[3]byte{0, 14, 158}:    "Topfield Co., Ltd",
	[3]byte{0, 14, 159}:    "TEMIC SDS GmbH",
	[3]byte{0, 14, 160}:    "NetKlass Technology Inc.",
	[3]byte{0, 14, 161}:    "Formosa Teletek Corporation",
	[3]byte{0, 14, 162}:    "McAfee, Inc",
	[3]byte{0, 14, 163}:    "CNCR-IT CO.,LTD,HangZhou P.R.CHINA",
	[3]byte{0, 14, 164}:    "Certance Inc.",
	[3]byte{0, 14, 165}:    "BLIP Systems",
	[3]byte{0, 14, 166}:    "ASUSTEK COMPUTER INC.",
	[3]byte{0, 14, 167}:    "Endace Technology",
	[3]byte{0, 14, 168}:    "United Technologists Europe Limited",
	[3]byte{0, 14, 169}:    "Shanghai Xun Shi Communications Equipment Ltd. Co.",
	[3]byte{0, 14, 170}:    "Scalent Systems, Inc.",
	[3]byte{0, 14, 171}:    "Cray Inc",
	[3]byte{0, 14, 172}:    "MINTRON ENTERPRISE CO., LTD.",
	[3]byte{0, 14, 173}:    "Metanoia Technologies, Inc.",
	[3]byte{0, 14, 174}:    "GAWELL TECHNOLOGIES CORP.",
	[3]byte{0, 14, 175}:    "CASTEL",
	[3]byte{0, 14, 176}:    "Solutions Radio BV",
	[3]byte{0, 14, 177}:    "Newcotech,Ltd",
	[3]byte{0, 14, 178}:    "Micro-Research Finland Oy",
	[3]byte{0, 14, 179}:    "Hewlett-Packard",
	[3]byte{0, 14, 180}:    "GUANGZHOU GAOKE COMMUNICATIONS TECHNOLOGY CO.LTD.",
	[3]byte{0, 14, 181}:    "Ecastle Electronics Co., Ltd.",
	[3]byte{0, 14, 182}:    "Riverbed Technology, Inc.",
	[3]byte{0, 14, 183}:    "Knovative, Inc.",
	[3]byte{0, 14, 184}:    "Iiga co.,Ltd",
	[3]byte{0, 14, 185}:    "HASHIMOTO Electronics Industry Co.,Ltd.",
	[3]byte{0, 14, 186}:    "HANMI SEMICONDUCTOR CO., LTD.",
	[3]byte{0, 14, 187}:    "Everbee Networks",
	[3]byte{0, 14, 188}:    "Paragon Fidelity GmbH",
	[3]byte{0, 14, 189}:    "Burdick, a Quinton Compny",
	[3]byte{0, 14, 190}:    "B&B Electronics Manufacturing Co.",
	[3]byte{0, 14, 191}:    "Remsdaq Limited",
	[3]byte{0, 14, 192}:    "Nortel Networks",
	[3]byte{0, 14, 193}:    "MYNAH Technologies",
	[3]byte{0, 14, 194}:    "Lowrance Electronics, Inc.",
	[3]byte{0, 14, 195}:    "Logic Controls, Inc.",
	[3]byte{0, 14, 196}:    "Iskra Transmission d.d.",
	[3]byte{0, 14, 197}:    "Digital Multitools Inc",
	[3]byte{0, 14, 198}:    "ASIX ELECTRONICS CORP.",
	[3]byte{0, 14, 199}:    "Motorola Korea",
	[3]byte{0, 14, 200}:    "Zoran Corporation",
	[3]byte{0, 14, 201}:    "YOKO Technology Corp.",
	[3]byte{0, 14, 202}:    "WTSS Inc",
	[3]byte{0, 14, 203}:    "VineSys Technology",
	[3]byte{0, 14, 204}:    "Tableau, LLC",
	[3]byte{0, 14, 205}:    "SKOV A/S",
	[3]byte{0, 14, 206}:    "S.I.T.T.I. S.p.A.",
	[3]byte{0, 14, 207}:    "PROFIBUS Nutzerorganisation e.V.",
	[3]byte{0, 14, 208}:    "Privaris, Inc.",
	[3]byte{0, 14, 209}:    "Osaka Micro Computer.",
	[3]byte{0, 14, 210}:    "Filtronic plc",
	[3]byte{0, 14, 211}:    "Epicenter, Inc.",
	[3]byte{0, 14, 212}:    "CRESITT INDUSTRIE",
	[3]byte{0, 14, 213}:    "COPAN Systems Inc.",
	[3]byte{0, 14, 214}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 14, 215}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 14, 216}:    "Aktino, Inc.",
	[3]byte{0, 14, 217}:    "Aksys, Ltd.",
	[3]byte{0, 14, 218}:    "C-TECH UNITED CORP.",
	[3]byte{0, 14, 219}:    "XiNCOM Corp.",
	[3]byte{0, 14, 220}:    "Tellion INC.",
	[3]byte{0, 14, 221}:    "SHURE INCORPORATED",
	[3]byte{0, 14, 222}:    "REMEC, Inc.",
	[3]byte{0, 14, 223}:    "PLX Technology",
	[3]byte{0, 14, 224}:    "Mcharge",
	[3]byte{0, 14, 225}:    "ExtremeSpeed Inc.",
	[3]byte{0, 14, 226}:    "Custom Engineering",
	[3]byte{0, 14, 227}:    "Chiyu Technology Co.,Ltd",
	[3]byte{0, 14, 228}:    "BOE TECHNOLOGY GROUP CO.,LTD",
	[3]byte{0, 14, 229}:    "bitWallet, Inc.",
	[3]byte{0, 14, 230}:    "Adimos Systems LTD",
	[3]byte{0, 14, 231}:    "AAC ELECTRONICS CORP.",
	[3]byte{0, 14, 232}:    "zioncom",
	[3]byte{0, 14, 233}:    "WayTech Development, Inc.",
	[3]byte{0, 14, 234}:    "Shadong Luneng Jicheng Electronics,Co.,Ltd",
	[3]byte{0, 14, 235}:    "Sandmartin(zhong shan)Electronics Co.,Ltd",
	[3]byte{0, 14, 236}:    "Orban",
	[3]byte{0, 14, 237}:    "Nokia Danmark A/S",
	[3]byte{0, 14, 238}:    "Muco Industrie BV",
	[3]byte{0, 14, 239}:    "PRIVATE",
	[3]byte{0, 14, 240}:    "Festo AG & Co. KG",
	[3]byte{0, 14, 241}:    "EZQUEST INC.",
	[3]byte{0, 14, 242}:    "Infinico Corporation",
	[3]byte{0, 14, 243}:    "Smarthome",
	[3]byte{0, 14, 244}:    "Kasda Digital Technology Co.,Ltd",
	[3]byte{0, 14, 245}:    "iPAC Technology Co., Ltd.",
	[3]byte{0, 14, 246}:    "E-TEN Information Systems Co., Ltd.",
	[3]byte{0, 14, 247}:    "Vulcan Portals Inc",
	[3]byte{0, 14, 248}:    "SBC ASI",
	[3]byte{0, 14, 249}:    "REA Elektronik GmbH",
	[3]byte{0, 14, 250}:    "Optoway Technology Incorporation",
	[3]byte{0, 14, 251}:    "Macey Enterprises",
	[3]byte{0, 14, 252}:    "JTAG Technologies B.V.",
	[3]byte{0, 14, 253}:    "FUJINON CORPORATION",
	[3]byte{0, 14, 254}:    "EndRun Technologies LLC",
	[3]byte{0, 14, 255}:    "Megasolution,Inc.",
	[3]byte{0, 15, 0}:      "Legra Systems, Inc.",
	[3]byte{0, 15, 1}:      "DIGITALKS INC",
	[3]byte{0, 15, 2}:      "Digicube Technology Co., Ltd",
	[3]byte{0, 15, 3}:      "COM&C CO., LTD",
	[3]byte{0, 15, 4}:      "cim-usa inc",
	[3]byte{0, 15, 5}:      "3B SYSTEM INC.",
	[3]byte{0, 15, 6}:      "Nortel Networks",
	[3]byte{0, 15, 7}:      "Mangrove Systems, Inc.",
	[3]byte{0, 15, 8}:      "Indagon Oy",
	[3]byte{0, 15, 9}:      "PRIVATE",
	[3]byte{0, 15, 10}:     "Clear Edge Networks",
	[3]byte{0, 15, 11}:     "Kentima Technologies AB",
	[3]byte{0, 15, 12}:     "SYNCHRONIC ENGINEERING",
	[3]byte{0, 15, 13}:     "Hunt Electronic Co., Ltd.",
	[3]byte{0, 15, 14}:     "WaveSplitter Technologies, Inc.",
	[3]byte{0, 15, 15}:     "Real ID Technology Co., Ltd.",
	[3]byte{0, 15, 16}:     "RDM Corporation",
	[3]byte{0, 15, 17}:     "Prodrive B.V.",
	[3]byte{0, 15, 18}:     "Panasonic Europe Ltd.",
	[3]byte{0, 15, 19}:     "Nisca corporation",
	[3]byte{0, 15, 20}:     "Mindray Co., Ltd.",
	[3]byte{0, 15, 21}:     "Kjaerulff1 A/S",
	[3]byte{0, 15, 22}:     "JAY HOW TECHNOLOGY CO.,",
	[3]byte{0, 15, 23}:     "Insta Elektro GmbH",
	[3]byte{0, 15, 24}:     "Industrial Control Systems",
	[3]byte{0, 15, 25}:     "Boston Scientific",
	[3]byte{0, 15, 26}:     "Gaming Support B.V.",
	[3]byte{0, 15, 27}:     "Ego Systems Inc.",
	[3]byte{0, 15, 28}:     "DigitAll World Co., Ltd",
	[3]byte{0, 15, 29}:     "Cosmo Techs Co., Ltd.",
	[3]byte{0, 15, 30}:     "Chengdu KT Electric Co.of High & New Technology",
	[3]byte{0, 15, 31}:     "Dell Inc",
	[3]byte{0, 15, 32}:     "Hewlett-Packard Company",
	[3]byte{0, 15, 33}:     "Scientific Atlanta, Inc",
	[3]byte{0, 15, 34}:     "Helius, Inc.",
	[3]byte{0, 15, 35}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 15, 36}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 15, 37}:     "AimValley B.V.",
	[3]byte{0, 15, 38}:     "WorldAccxx  LLC",
	[3]byte{0, 15, 39}:     "TEAL Electronics, Inc.",
	[3]byte{0, 15, 40}:     "Itronix Corporation",
	[3]byte{0, 15, 41}:     "Augmentix Corporation",
	[3]byte{0, 15, 42}:     "Cableware Electronics",
	[3]byte{0, 15, 43}:     "GREENBELL SYSTEMS",
	[3]byte{0, 15, 44}:     "Uplogix, Inc.",
	[3]byte{0, 15, 45}:     "CHUNG-HSIN ELECTRIC & MACHINERY MFG.CORP.",
	[3]byte{0, 15, 46}:     "Megapower International Corp.",
	[3]byte{0, 15, 47}:     "W-LINX TECHNOLOGY CO., LTD.",
	[3]byte{0, 15, 48}:     "Raza Microelectronics Inc",
	[3]byte{0, 15, 49}:     "Allied Vision Technologies Canada Inc",
	[3]byte{0, 15, 50}:     "Lootom Telcovideo Network Wuxi Co Ltd",
	[3]byte{0, 15, 51}:     "DUALi Inc.",
	[3]byte{0, 15, 52}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 15, 53}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 15, 54}:     "Accurate Techhnologies, Inc.",
	[3]byte{0, 15, 55}:     "Xambala Incorporated",
	[3]byte{0, 15, 56}:     "Netstar",
	[3]byte{0, 15, 57}:     "IRIS SENSORS",
	[3]byte{0, 15, 58}:     "HISHARP",
	[3]byte{0, 15, 59}:     "Fuji System Machines Co., Ltd.",
	[3]byte{0, 15, 60}:     "Endeleo Limited",
	[3]byte{0, 15, 61}:     "D-Link Corporation",
	[3]byte{0, 15, 62}:     "CardioNet, Inc",
	[3]byte{0, 15, 63}:     "Big Bear Networks",
	[3]byte{0, 15, 64}:     "Optical Internetworking Forum",
	[3]byte{0, 15, 65}:     "Zipher Ltd",
	[3]byte{0, 15, 66}:     "Xalyo Systems",
	[3]byte{0, 15, 67}:     "Wasabi Systems Inc.",
	[3]byte{0, 15, 68}:     "Tivella Inc.",
	[3]byte{0, 15, 69}:     "Stretch, Inc.",
	[3]byte{0, 15, 70}:     "SINAR AG",
	[3]byte{0, 15, 71}:     "ROBOX SPA",
	[3]byte{0, 15, 72}:     "Polypix Inc.",
	[3]byte{0, 15, 73}:     "Northover Solutions Limited",
	[3]byte{0, 15, 74}:     "Kyushu-kyohan co.,ltd",
	[3]byte{0, 15, 75}:     "Oracle Corporation",
	[3]byte{0, 15, 76}:     "Elextech INC",
	[3]byte{0, 15, 77}:     "TalkSwitch",
	[3]byte{0, 15, 78}:     "Cellink",
	[3]byte{0, 15, 79}:     "Cadmus Technology Ltd",
	[3]byte{0, 15, 80}:     "StreamScale Limited",
	[3]byte{0, 15, 81}:     "Azul Systems, Inc.",
	[3]byte{0, 15, 82}:     "YORK Refrigeration, Marine & Controls",
	[3]byte{0, 15, 83}:     "Solarflare Communications Inc",
	[3]byte{0, 15, 84}:     "Entrelogic Corporation",
	[3]byte{0, 15, 85}:     "Datawire Communication Networks Inc.",
	[3]byte{0, 15, 86}:     "Continuum Photonics Inc",
	[3]byte{0, 15, 87}:     "CABLELOGIC Co., Ltd.",
	[3]byte{0, 15, 88}:     "Adder Technology Limited",
	[3]byte{0, 15, 89}:     "Phonak Communications AG",
	[3]byte{0, 15, 90}:     "Peribit Networks",
	[3]byte{0, 15, 91}:     "Delta Information Systems, Inc.",
	[3]byte{0, 15, 92}:     "Day One Digital Media Limited",
	[3]byte{0, 15, 93}:     "Genexis BV",
	[3]byte{0, 15, 94}:     "Veo",
	[3]byte{0, 15, 95}:     "Nicety Technologies Inc. (NTS)",
	[3]byte{0, 15, 96}:     "Lifetron Co.,Ltd",
	[3]byte{0, 15, 97}:     "Hewlett-Packard Company",
	[3]byte{0, 15, 98}:     "Alcatel Bell Space N.V.",
	[3]byte{0, 15, 99}:     "Obzerv Technologies",
	[3]byte{0, 15, 100}:    "D&R Electronica Weesp BV",
	[3]byte{0, 15, 101}:    "icube Corp.",
	[3]byte{0, 15, 102}:    "Cisco-Linksys",
	[3]byte{0, 15, 103}:    "West Instruments",
	[3]byte{0, 15, 104}:    "Vavic Network Technology, Inc.",
	[3]byte{0, 15, 105}:    "SEW Eurodrive GmbH & Co. KG",
	[3]byte{0, 15, 106}:    "Nortel Networks",
	[3]byte{0, 15, 107}:    "GateWare Communications GmbH",
	[3]byte{0, 15, 108}:    "ADDI-DATA GmbH",
	[3]byte{0, 15, 109}:    "Midas Engineering",
	[3]byte{0, 15, 110}:    "BBox",
	[3]byte{0, 15, 111}:    "FTA Communication Technologies",
	[3]byte{0, 15, 112}:    "Wintec Industries, inc.",
	[3]byte{0, 15, 113}:    "Sanmei Electronics Co.,Ltd",
	[3]byte{0, 15, 114}:    "Sandburst",
	[3]byte{0, 15, 115}:    "RS Automation Co., Ltd",
	[3]byte{0, 15, 116}:    "Qamcom Technology AB",
	[3]byte{0, 15, 117}:    "First Silicon Solutions",
	[3]byte{0, 15, 118}:    "Digital Keystone, Inc.",
	[3]byte{0, 15, 119}:    "DENTUM CO.,LTD",
	[3]byte{0, 15, 120}:    "Datacap Systems Inc",
	[3]byte{0, 15, 121}:    "Bluetooth Interest Group Inc.",
	[3]byte{0, 15, 122}:    "BeiJing NuQX Technology CO.,LTD",
	[3]byte{0, 15, 123}:    "Arce Sistemas, S.A.",
	[3]byte{0, 15, 124}:    "ACTi Corporation",
	[3]byte{0, 15, 125}:    "Xirrus",
	[3]byte{0, 15, 126}:    "Ablerex Electronics Co., LTD",
	[3]byte{0, 15, 127}:    "UBSTORAGE Co.,Ltd.",
	[3]byte{0, 15, 128}:    "Trinity Security Systems,Inc.",
	[3]byte{0, 15, 129}:    "PAL Pacific Inc.",
	[3]byte{0, 15, 130}:    "Mortara Instrument, Inc.",
	[3]byte{0, 15, 131}:    "Brainium Technologies Inc.",
	[3]byte{0, 15, 132}:    "Astute Networks, Inc.",
	[3]byte{0, 15, 133}:    "ADDO-Japan Corporation",
	[3]byte{0, 15, 134}:    "Research In Motion Limited",
	[3]byte{0, 15, 135}:    "Maxcess International",
	[3]byte{0, 15, 136}:    "AMETEK, Inc.",
	[3]byte{0, 15, 137}:    "Winnertec System Co., Ltd.",
	[3]byte{0, 15, 138}:    "WideView",
	[3]byte{0, 15, 139}:    "Orion MultiSystems Inc",
	[3]byte{0, 15, 140}:    "Gigawavetech Pte Ltd",
	[3]byte{0, 15, 141}:    "FAST TV-Server AG",
	[3]byte{0, 15, 142}:    "DONGYANG TELECOM CO.,LTD.",
	[3]byte{0, 15, 143}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 15, 144}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 15, 145}:    "Aerotelecom Co.,Ltd.",
	[3]byte{0, 15, 146}:    "Microhard Systems Inc.",
	[3]byte{0, 15, 147}:    "Landis+Gyr Ltd.",
	[3]byte{0, 15, 148}:    "Genexis BV",
	[3]byte{0, 15, 149}:    "ELECOM Co.,LTD Laneed Division",
	[3]byte{0, 15, 150}:    "Telco Systems, Inc.",
	[3]byte{0, 15, 151}:    "Avanex Corporation",
	[3]byte{0, 15, 152}:    "Avamax Co. Ltd.",
	[3]byte{0, 15, 153}:    "APAC opto Electronics Inc.",
	[3]byte{0, 15, 154}:    "Synchrony, Inc.",
	[3]byte{0, 15, 155}:    "Ross Video Limited",
	[3]byte{0, 15, 156}:    "Panduit Corp",
	[3]byte{0, 15, 157}:    "DisplayLink (UK) Ltd",
	[3]byte{0, 15, 158}:    "Murrelektronik GmbH",
	[3]byte{0, 15, 159}:    "ARRIS Group, Inc.",
	[3]byte{0, 15, 160}:    "CANON KOREA BUSINESS SOLUTIONS INC.",
	[3]byte{0, 15, 161}:    "Gigabit Systems Inc.",
	[3]byte{0, 15, 162}:    "2xWireless",
	[3]byte{0, 15, 163}:    "Alpha Networks Inc.",
	[3]byte{0, 15, 164}:    "Sprecher Automation GmbH",
	[3]byte{0, 15, 165}:    "BWA Technology GmbH",
	[3]byte{0, 15, 166}:    "S2 Security Corporation",
	[3]byte{0, 15, 167}:    "Raptor Networks Technology",
	[3]byte{0, 15, 168}:    "Photometrics, Inc.",
	[3]byte{0, 15, 169}:    "PC Fabrik",
	[3]byte{0, 15, 170}:    "Nexus Technologies",
	[3]byte{0, 15, 171}:    "Kyushu Electronics Systems Inc.",
	[3]byte{0, 15, 172}:    "IEEE 802.11",
	[3]byte{0, 15, 173}:    "FMN communications GmbH",
	[3]byte{0, 15, 174}:    "E2O Communications",
	[3]byte{0, 15, 175}:    "Dialog Inc.",
	[3]byte{0, 15, 176}:    "Compal Electronics,INC.",
	[3]byte{0, 15, 177}:    "Cognio Inc.",
	[3]byte{0, 15, 178}:    "Broadband Pacenet (India) Pvt. Ltd.",
	[3]byte{0, 15, 179}:    "Actiontec Electronics, Inc",
	[3]byte{0, 15, 180}:    "Timespace Technology",
	[3]byte{0, 15, 181}:    "NETGEAR Inc",
	[3]byte{0, 15, 182}:    "Europlex Technologies",
	[3]byte{0, 15, 183}:    "Cavium Networks",
	[3]byte{0, 15, 184}:    "CallURL Inc.",
	[3]byte{0, 15, 185}:    "Adaptive Instruments",
	[3]byte{0, 15, 186}:    "Tevebox AB",
	[3]byte{0, 15, 187}:    "Nokia Siemens Networks GmbH & Co. KG.",
	[3]byte{0, 15, 188}:    "Onkey Technologies, Inc.",
	[3]byte{0, 15, 189}:    "MRV Communications (Networks) LTD",
	[3]byte{0, 15, 190}:    "e-w/you Inc.",
	[3]byte{0, 15, 191}:    "DGT Sp. z o.o.",
	[3]byte{0, 15, 192}:    "DELCOMp",
	[3]byte{0, 15, 193}:    "WAVE Corporation",
	[3]byte{0, 15, 194}:    "Uniwell Corporation",
	[3]byte{0, 15, 195}:    "PalmPalm Technology, Inc.",
	[3]byte{0, 15, 196}:    "NST co.,LTD.",
	[3]byte{0, 15, 197}:    "KeyMed Ltd",
	[3]byte{0, 15, 198}:    "Eurocom Industries A/S",
	[3]byte{0, 15, 199}:    "Dionica R&D Ltd.",
	[3]byte{0, 15, 200}:    "Chantry Networks",
	[3]byte{0, 15, 201}:    "Allnet GmbH",
	[3]byte{0, 15, 202}:    "A-JIN TECHLINE CO, LTD",
	[3]byte{0, 15, 203}:    "3Com Ltd",
	[3]byte{0, 15, 204}:    "Netopia, Inc.",
	[3]byte{0, 15, 205}:    "Nortel Networks",
	[3]byte{0, 15, 206}:    "Kikusui Electronics Corp.",
	[3]byte{0, 15, 207}:    "Datawind Research",
	[3]byte{0, 15, 208}:    "ASTRI",
	[3]byte{0, 15, 209}:    "Applied Wireless Identifications Group, Inc.",
	[3]byte{0, 15, 210}:    "EWA Technologies, Inc.",
	[3]byte{0, 15, 211}:    "Digium",
	[3]byte{0, 15, 212}:    "Soundcraft",
	[3]byte{0, 15, 213}:    "Schwechat - RISE",
	[3]byte{0, 15, 214}:    "Sarotech Co., Ltd",
	[3]byte{0, 15, 215}:    "Harman Music Group",
	[3]byte{0, 15, 216}:    "Force, Inc.",
	[3]byte{0, 15, 217}:    "FlexDSL Telecommunications AG",
	[3]byte{0, 15, 218}:    "YAZAKI CORPORATION",
	[3]byte{0, 15, 219}:    "Westell Technologies",
	[3]byte{0, 15, 220}:    "Ueda Japan  Radio Co., Ltd.",
	[3]byte{0, 15, 221}:    "SORDIN AB",
	[3]byte{0, 15, 222}:    "Sony Ericsson Mobile Communications AB",
	[3]byte{0, 15, 223}:    "SOLOMON Technology Corp.",
	[3]byte{0, 15, 224}:    "NComputing Co.,Ltd.",
	[3]byte{0, 15, 225}:    "ID DIGITAL CORPORATION",
	[3]byte{0, 15, 226}:    "Hangzhou H3C Technologies Co., Ltd.",
	[3]byte{0, 15, 227}:    "Damm Cellular Systems A/S",
	[3]byte{0, 15, 228}:    "Pantech Co.,Ltd",
	[3]byte{0, 15, 229}:    "MERCURY SECURITY CORPORATION",
	[3]byte{0, 15, 230}:    "MBTech Systems, Inc.",
	[3]byte{0, 15, 231}:    "Lutron Electronics Co., Inc.",
	[3]byte{0, 15, 232}:    "Lobos, Inc.",
	[3]byte{0, 15, 233}:    "GW TECHNOLOGIES CO.,LTD.",
	[3]byte{0, 15, 234}:    "Giga-Byte Technology Co.,LTD.",
	[3]byte{0, 15, 235}:    "Cylon Controls",
	[3]byte{0, 15, 236}:    "ARKUS Inc.",
	[3]byte{0, 15, 237}:    "Anam Electronics Co., Ltd",
	[3]byte{0, 15, 238}:    "XTec, Incorporated",
	[3]byte{0, 15, 239}:    "Thales e-Transactions GmbH",
	[3]byte{0, 15, 240}:    "Sunray Co. Ltd.",
	[3]byte{0, 15, 241}:    "nex-G Systems Pte.Ltd",
	[3]byte{0, 15, 242}:    "Loud Technologies Inc.",
	[3]byte{0, 15, 243}:    "Jung Myoung Communications&Technology",
	[3]byte{0, 15, 244}:    "Guntermann & Drunck GmbH",
	[3]byte{0, 15, 245}:    "GN&S company",
	[3]byte{0, 15, 246}:    "Darfon Electronics Corp.",
	[3]byte{0, 15, 247}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 15, 248}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 15, 249}:    "Valcretec, Inc.",
	[3]byte{0, 15, 250}:    "Optinel Systems, Inc.",
	[3]byte{0, 15, 251}:    "Nippon Denso Industry Co., Ltd.",
	[3]byte{0, 15, 252}:    "Merit Li-Lin Ent.",
	[3]byte{0, 15, 253}:    "Glorytek Network Inc.",
	[3]byte{0, 15, 254}:    "G-PRO COMPUTER",
	[3]byte{0, 15, 255}:    "Control4",
	[3]byte{0, 16, 0}:      "CABLE TELEVISION LABORATORIES, INC.",
	[3]byte{0, 16, 1}:      "Citel",
	[3]byte{0, 16, 2}:      "ACTIA",
	[3]byte{0, 16, 3}:      "IMATRON, INC.",
	[3]byte{0, 16, 4}:      "THE BRANTLEY COILE COMPANY,INC",
	[3]byte{0, 16, 5}:      "UEC COMMERCIAL",
	[3]byte{0, 16, 6}:      "Thales Contact Solutions Ltd.",
	[3]byte{0, 16, 7}:      "CISCO SYSTEMS, INC.",
	[3]byte{0, 16, 8}:      "VIENNA SYSTEMS CORPORATION",
	[3]byte{0, 16, 9}:      "HORO QUARTZ",
	[3]byte{0, 16, 10}:     "WILLIAMS COMMUNICATIONS GROUP",
	[3]byte{0, 16, 11}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 16, 12}:     "ITO CO., LTD.",
	[3]byte{0, 16, 13}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 16, 14}:     "MICRO LINEAR COPORATION",
	[3]byte{0, 16, 15}:     "INDUSTRIAL CPU SYSTEMS",
	[3]byte{0, 16, 16}:     "INITIO CORPORATION",
	[3]byte{0, 16, 17}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 16, 18}:     "PROCESSOR SYSTEMS (I) PVT LTD",
	[3]byte{0, 16, 19}:     "Kontron America, Inc.",
	[3]byte{0, 16, 20}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 16, 21}:     "OOmon Inc.",
	[3]byte{0, 16, 22}:     "T.SQWARE",
	[3]byte{0, 16, 23}:     "Bosch Access Systems GmbH",
	[3]byte{0, 16, 24}:     "BROADCOM CORPORATION",
	[3]byte{0, 16, 25}:     "SIRONA DENTAL SYSTEMS GmbH & Co. KG",
	[3]byte{0, 16, 26}:     "PictureTel Corp.",
	[3]byte{0, 16, 27}:     "CORNET TECHNOLOGY, INC.",
	[3]byte{0, 16, 28}:     "OHM TECHNOLOGIES INTL, LLC",
	[3]byte{0, 16, 29}:     "WINBOND ELECTRONICS CORP.",
	[3]byte{0, 16, 30}:     "MATSUSHITA ELECTRONIC INSTRUMENTS CORP.",
	[3]byte{0, 16, 31}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 16, 32}:     "Hand Held Products Inc",
	[3]byte{0, 16, 33}:     "ENCANTO NETWORKS, INC.",
	[3]byte{0, 16, 34}:     "SatCom Media Corporation",
	[3]byte{0, 16, 35}:     "Network Equipment Technologies",
	[3]byte{0, 16, 36}:     "NAGOYA ELECTRIC WORKS CO., LTD",
	[3]byte{0, 16, 37}:     "Grayhill, Inc",
	[3]byte{0, 16, 38}:     "ACCELERATED NETWORKS, INC.",
	[3]byte{0, 16, 39}:     "L-3 COMMUNICATIONS EAST",
	[3]byte{0, 16, 40}:     "COMPUTER TECHNICA, INC.",
	[3]byte{0, 16, 41}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 16, 42}:     "ZF MICROSYSTEMS, INC.",
	[3]byte{0, 16, 43}:     "UMAX DATA SYSTEMS, INC.",
	[3]byte{0, 16, 44}:     "Lasat Networks A/S",
	[3]byte{0, 16, 45}:     "HITACHI SOFTWARE ENGINEERING",
	[3]byte{0, 16, 46}:     "NETWORK SYSTEMS & TECHNOLOGIES PVT. LTD.",
	[3]byte{0, 16, 47}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 16, 48}:     "EION Inc.",
	[3]byte{0, 16, 49}:     "OBJECTIVE COMMUNICATIONS, INC.",
	[3]byte{0, 16, 50}:     "ALTA TECHNOLOGY",
	[3]byte{0, 16, 51}:     "ACCESSLAN COMMUNICATIONS, INC.",
	[3]byte{0, 16, 52}:     "GNP Computers",
	[3]byte{0, 16, 53}:     "ELITEGROUP COMPUTER SYSTEMS CO., LTD",
	[3]byte{0, 16, 54}:     "INTER-TEL INTEGRATED SYSTEMS",
	[3]byte{0, 16, 55}:     "CYQ've Technology Co., Ltd.",
	[3]byte{0, 16, 56}:     "MICRO RESEARCH INSTITUTE, INC.",
	[3]byte{0, 16, 57}:     "Vectron Systems AG",
	[3]byte{0, 16, 58}:     "DIAMOND NETWORK TECH",
	[3]byte{0, 16, 59}:     "HIPPI NETWORKING FORUM",
	[3]byte{0, 16, 60}:     "IC ENSEMBLE, INC.",
	[3]byte{0, 16, 61}:     "PHASECOM, LTD.",
	[3]byte{0, 16, 62}:     "NETSCHOOLS CORPORATION",
	[3]byte{0, 16, 63}:     "TOLLGRADE COMMUNICATIONS, INC.",
	[3]byte{0, 16, 64}:     "INTERMEC CORPORATION",
	[3]byte{0, 16, 65}:     "BRISTOL BABCOCK, INC.",
	[3]byte{0, 16, 66}:     "Alacritech, Inc.",
	[3]byte{0, 16, 67}:     "A2 CORPORATION",
	[3]byte{0, 16, 68}:     "InnoLabs Corporation",
	[3]byte{0, 16, 69}:     "Nortel Networks",
	[3]byte{0, 16, 70}:     "ALCORN MCBRIDE INC.",
	[3]byte{0, 16, 71}:     "ECHO ELETRIC CO. LTD.",
	[3]byte{0, 16, 72}:     "HTRC AUTOMATION, INC.",
	[3]byte{0, 16, 73}:     "ShoreTel, Inc",
	[3]byte{0, 16, 74}:     "The Parvus Corporation",
	[3]byte{0, 16, 75}:     "3COM CORPORATION",
	[3]byte{0, 16, 76}:     "Teledyne LeCroy, Inc",
	[3]byte{0, 16, 77}:     "SURTEC INDUSTRIES, INC.",
	[3]byte{0, 16, 78}:     "CEOLOGIC",
	[3]byte{0, 16, 79}:     "Oracle Corporation",
	[3]byte{0, 16, 80}:     "RION CO., LTD.",
	[3]byte{0, 16, 81}:     "CMICRO CORPORATION",
	[3]byte{0, 16, 82}:     "METTLER-TOLEDO (ALBSTADT) GMBH",
	[3]byte{0, 16, 83}:     "COMPUTER TECHNOLOGY CORP.",
	[3]byte{0, 16, 84}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 16, 85}:     "FUJITSU MICROELECTRONICS, INC.",
	[3]byte{0, 16, 86}:     "SODICK CO., LTD.",
	[3]byte{0, 16, 87}:     "Rebel.com, Inc.",
	[3]byte{0, 16, 88}:     "ArrowPoint Communications",
	[3]byte{0, 16, 89}:     "DIABLO RESEARCH CO. LLC",
	[3]byte{0, 16, 90}:     "3COM CORPORATION",
	[3]byte{0, 16, 91}:     "NET INSIGHT AB",
	[3]byte{0, 16, 92}:     "QUANTUM DESIGNS (H.K.) LTD.",
	[3]byte{0, 16, 93}:     "Draeger Medical",
	[3]byte{0, 16, 94}:     "Spirent plc, Service Assurance Broadband",
	[3]byte{0, 16, 95}:     "ZODIAC DATA SYSTEMS",
	[3]byte{0, 16, 96}:     "BILLIONTON SYSTEMS, INC.",
	[3]byte{0, 16, 97}:     "HOSTLINK CORP.",
	[3]byte{0, 16, 98}:     "NX SERVER, ILNC.",
	[3]byte{0, 16, 99}:     "STARGUIDE DIGITAL NETWORKS",
	[3]byte{0, 16, 100}:    "DNPG, LLC",
	[3]byte{0, 16, 101}:    "RADYNE CORPORATION",
	[3]byte{0, 16, 102}:    "ADVANCED CONTROL SYSTEMS, INC.",
	[3]byte{0, 16, 103}:    "Ericsson",
	[3]byte{0, 16, 104}:    "COMOS TELECOM",
	[3]byte{0, 16, 105}:    "HELIOSS COMMUNICATIONS, INC.",
	[3]byte{0, 16, 106}:    "DIGITAL MICROWAVE CORPORATION",
	[3]byte{0, 16, 107}:    "SONUS NETWORKS, INC.",
	[3]byte{0, 16, 108}:    "EDNT GmbH",
	[3]byte{0, 16, 109}:    "Axxcelera Broadband Wireless",
	[3]byte{0, 16, 110}:    "TADIRAN COM. LTD.",
	[3]byte{0, 16, 111}:    "TRENTON TECHNOLOGY INC.",
	[3]byte{0, 16, 112}:    "CARADON TREND LTD.",
	[3]byte{0, 16, 113}:    "ADVANET INC.",
	[3]byte{0, 16, 114}:    "GVN TECHNOLOGIES, INC.",
	[3]byte{0, 16, 115}:    "Technobox, Inc.",
	[3]byte{0, 16, 116}:    "ATEN INTERNATIONAL CO., LTD.",
	[3]byte{0, 16, 117}:    "Segate Technology LLC",
	[3]byte{0, 16, 118}:    "EUREM GmbH",
	[3]byte{0, 16, 119}:    "SAF DRIVE SYSTEMS, LTD.",
	[3]byte{0, 16, 120}:    "NUERA COMMUNICATIONS, INC.",
	[3]byte{0, 16, 121}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 16, 122}:    "AmbiCom, Inc.",
	[3]byte{0, 16, 123}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 16, 124}:    "P-COM, INC.",
	[3]byte{0, 16, 125}:    "AURORA COMMUNICATIONS, LTD.",
	[3]byte{0, 16, 126}:    "BACHMANN ELECTRONIC GmbH",
	[3]byte{0, 16, 127}:    "CRESTRON ELECTRONICS, INC.",
	[3]byte{0, 16, 128}:    "METAWAVE COMMUNICATIONS",
	[3]byte{0, 16, 129}:    "DPS, INC.",
	[3]byte{0, 16, 130}:    "JNA TELECOMMUNICATIONS LIMITED",
	[3]byte{0, 16, 131}:    "HEWLETT-PACKARD COMPANY",
	[3]byte{0, 16, 132}:    "K-BOT COMMUNICATIONS",
	[3]byte{0, 16, 133}:    "POLARIS COMMUNICATIONS, INC.",
	[3]byte{0, 16, 134}:    "ATTO Technology, Inc.",
	[3]byte{0, 16, 135}:    "Xstreamis PLC",
	[3]byte{0, 16, 136}:    "AMERICAN NETWORKS INC.",
	[3]byte{0, 16, 137}:    "WebSonic",
	[3]byte{0, 16, 138}:    "TeraLogic, Inc.",
	[3]byte{0, 16, 139}:    "LASERANIMATION SOLLINGER GmbH",
	[3]byte{0, 16, 140}:    "FUJITSU TELECOMMUNICATIONS EUROPE, LTD.",
	[3]byte{0, 16, 141}:    "Johnson Controls, Inc.",
	[3]byte{0, 16, 142}:    "HUGH SYMONS CONCEPT Technologies Ltd.",
	[3]byte{0, 16, 143}:    "RAPTOR SYSTEMS",
	[3]byte{0, 16, 144}:    "CIMETRICS, INC.",
	[3]byte{0, 16, 145}:    "NO WIRES NEEDED BV",
	[3]byte{0, 16, 146}:    "NETCORE INC.",
	[3]byte{0, 16, 147}:    "CMS COMPUTERS, LTD.",
	[3]byte{0, 16, 148}:    "Performance Analysis Broadband, Spirent plc",
	[3]byte{0, 16, 149}:    "Thomson Inc.",
	[3]byte{0, 16, 150}:    "TRACEWELL SYSTEMS, INC.",
	[3]byte{0, 16, 151}:    "WinNet Metropolitan Communications Systems, Inc.",
	[3]byte{0, 16, 152}:    "STARNET TECHNOLOGIES, INC.",
	[3]byte{0, 16, 153}:    "InnoMedia, Inc.",
	[3]byte{0, 16, 154}:    "NETLINE",
	[3]byte{0, 16, 155}:    "Emulex Corporation",
	[3]byte{0, 16, 156}:    "M-SYSTEM CO., LTD.",
	[3]byte{0, 16, 157}:    "CLARINET SYSTEMS, INC.",
	[3]byte{0, 16, 158}:    "AWARE, INC.",
	[3]byte{0, 16, 159}:    "PAVO, INC.",
	[3]byte{0, 16, 160}:    "INNOVEX TECHNOLOGIES, INC.",
	[3]byte{0, 16, 161}:    "KENDIN SEMICONDUCTOR, INC.",
	[3]byte{0, 16, 162}:    "TNS",
	[3]byte{0, 16, 163}:    "OMNITRONIX, INC.",
	[3]byte{0, 16, 164}:    "XIRCOM",
	[3]byte{0, 16, 165}:    "OXFORD INSTRUMENTS",
	[3]byte{0, 16, 166}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 16, 167}:    "UNEX TECHNOLOGY CORPORATION",
	[3]byte{0, 16, 168}:    "RELIANCE COMPUTER CORP.",
	[3]byte{0, 16, 169}:    "ADHOC TECHNOLOGIES",
	[3]byte{0, 16, 170}:    "MEDIA4, INC.",
	[3]byte{0, 16, 171}:    "KOITO ELECTRIC INDUSTRIES, LTD.",
	[3]byte{0, 16, 172}:    "IMCI TECHNOLOGIES",
	[3]byte{0, 16, 173}:    "SOFTRONICS USB, INC.",
	[3]byte{0, 16, 174}:    "SHINKO ELECTRIC INDUSTRIES CO.",
	[3]byte{0, 16, 175}:    "TAC SYSTEMS, INC.",
	[3]byte{0, 16, 176}:    "MERIDIAN TECHNOLOGY CORP.",
	[3]byte{0, 16, 177}:    "FOR-A CO., LTD.",
	[3]byte{0, 16, 178}:    "COACTIVE AESTHETICS",
	[3]byte{0, 16, 179}:    "NOKIA MULTIMEDIA TERMINALS",
	[3]byte{0, 16, 180}:    "ATMOSPHERE NETWORKS",
	[3]byte{0, 16, 181}:    "ACCTON TECHNOLOGY CORPORATION",
	[3]byte{0, 16, 182}:    "ENTRATA COMMUNICATIONS CORP.",
	[3]byte{0, 16, 183}:    "COYOTE TECHNOLOGIES, LLC",
	[3]byte{0, 16, 184}:    "ISHIGAKI COMPUTER SYSTEM CO.",
	[3]byte{0, 16, 185}:    "MAXTOR CORP.",
	[3]byte{0, 16, 186}:    "MARTINHO-DAVIS SYSTEMS, INC.",
	[3]byte{0, 16, 187}:    "DATA & INFORMATION TECHNOLOGY",
	[3]byte{0, 16, 188}:    "Aastra Telecom",
	[3]byte{0, 16, 189}:    "THE TELECOMMUNICATION TECHNOLOGY COMMITTEE (TTC)",
	[3]byte{0, 16, 190}:    "MARCH NETWORKS CORPORATION",
	[3]byte{0, 16, 191}:    "InterAir Wireless",
	[3]byte{0, 16, 192}:    "ARMA, Inc.",
	[3]byte{0, 16, 193}:    "OI ELECTRIC CO., LTD.",
	[3]byte{0, 16, 194}:    "WILLNET, INC.",
	[3]byte{0, 16, 195}:    "CSI-CONTROL SYSTEMS",
	[3]byte{0, 16, 196}:    "MEDIA LINKS CO., LTD.",
	[3]byte{0, 16, 197}:    "PROTOCOL TECHNOLOGIES, INC.",
	[3]byte{0, 16, 198}:    "Universal Global Scientific Industrial Co., Ltd.",
	[3]byte{0, 16, 199}:    "DATA TRANSMISSION NETWORK",
	[3]byte{0, 16, 200}:    "COMMUNICATIONS ELECTRONICS SECURITY GROUP",
	[3]byte{0, 16, 201}:    "MITSUBISHI ELECTRONICS LOGISTIC SUPPORT CO.",
	[3]byte{0, 16, 202}:    "Telco Systems, Inc.",
	[3]byte{0, 16, 203}:    "FACIT K.K.",
	[3]byte{0, 16, 204}:    "CLP COMPUTER LOGISTIK PLANUNG GmbH",
	[3]byte{0, 16, 205}:    "INTERFACE CONCEPT",
	[3]byte{0, 16, 206}:    "VOLAMP, LTD.",
	[3]byte{0, 16, 207}:    "FIBERLANE COMMUNICATIONS",
	[3]byte{0, 16, 208}:    "WITCOM, LTD.",
	[3]byte{0, 16, 209}:    "Top Layer Networks, Inc.",
	[3]byte{0, 16, 210}:    "NITTO TSUSHINKI CO., LTD",
	[3]byte{0, 16, 211}:    "GRIPS ELECTRONIC GMBH",
	[3]byte{0, 16, 212}:    "STORAGE COMPUTER CORPORATION",
	[3]byte{0, 16, 213}:    "IMASDE CANARIAS, S.A.",
	[3]byte{0, 16, 214}:    "Exelis",
	[3]byte{0, 16, 215}:    "ARGOSY RESEARCH INC.",
	[3]byte{0, 16, 216}:    "CALISTA",
	[3]byte{0, 16, 217}:    "IBM JAPAN, FUJISAWA MT+D",
	[3]byte{0, 16, 218}:    "Kollmorgen Corp",
	[3]byte{0, 16, 219}:    "Juniper Networks, Inc.",
	[3]byte{0, 16, 220}:    "MICRO-STAR INTERNATIONAL CO., LTD.",
	[3]byte{0, 16, 221}:    "ENABLE SEMICONDUCTOR, INC.",
	[3]byte{0, 16, 222}:    "INTERNATIONAL DATACASTING CORPORATION",
	[3]byte{0, 16, 223}:    "RISE COMPUTER INC.",
	[3]byte{0, 16, 224}:    "Oracle Corporation",
	[3]byte{0, 16, 225}:    "S.I. TECH, INC.",
	[3]byte{0, 16, 226}:    "ArrayComm, Inc.",
	[3]byte{0, 16, 227}:    "Hewlett-Packard Company",
	[3]byte{0, 16, 228}:    "NSI CORPORATION",
	[3]byte{0, 16, 229}:    "SOLECTRON TEXAS",
	[3]byte{0, 16, 230}:    "APPLIED INTELLIGENT SYSTEMS, INC.",
	[3]byte{0, 16, 231}:    "BreezeCom",
	[3]byte{0, 16, 232}:    "TELOCITY, INCORPORATED",
	[3]byte{0, 16, 233}:    "RAIDTEC LTD.",
	[3]byte{0, 16, 234}:    "ADEPT TECHNOLOGY",
	[3]byte{0, 16, 235}:    "SELSIUS SYSTEMS, INC.",
	[3]byte{0, 16, 236}:    "RPCG, LLC",
	[3]byte{0, 16, 237}:    "SUNDANCE TECHNOLOGY, INC.",
	[3]byte{0, 16, 238}:    "CTI PRODUCTS, INC.",
	[3]byte{0, 16, 239}:    "DBTEL INCORPORATED",
	[3]byte{0, 16, 240}:    "RITTAL-WERK RUDOLF LOH GmbH & Co.",
	[3]byte{0, 16, 241}:    "I-O CORPORATION",
	[3]byte{0, 16, 242}:    "ANTEC",
	[3]byte{0, 16, 243}:    "Nexcom International Co., Ltd.",
	[3]byte{0, 16, 244}:    "Vertical Communications",
	[3]byte{0, 16, 245}:    "AMHERST SYSTEMS, INC.",
	[3]byte{0, 16, 246}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 16, 247}:    "IRIICHI TECHNOLOGIES Inc.",
	[3]byte{0, 16, 248}:    "TEXIO TECHNOLOGY CORPORATION",
	[3]byte{0, 16, 249}:    "UNIQUE SYSTEMS, INC.",
	[3]byte{0, 16, 250}:    "Apple",
	[3]byte{0, 16, 251}:    "ZIDA TECHNOLOGIES LIMITED",
	[3]byte{0, 16, 252}:    "BROADBAND NETWORKS, INC.",
	[3]byte{0, 16, 253}:    "COCOM A/S",
	[3]byte{0, 16, 254}:    "DIGITAL EQUIPMENT CORPORATION",
	[3]byte{0, 16, 255}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 17, 0}:      "Schneider Electric",
	[3]byte{0, 17, 1}:      "CET Technologies Pte Ltd",
	[3]byte{0, 17, 2}:      "Aurora Multimedia Corp.",
	[3]byte{0, 17, 3}:      "kawamura electric inc.",
	[3]byte{0, 17, 4}:      "TELEXY",
	[3]byte{0, 17, 5}:      "Sunplus Technology Co., Ltd.",
	[3]byte{0, 17, 6}:      "Siemens NV (Belgium)",
	[3]byte{0, 17, 7}:      "RGB Networks Inc.",
	[3]byte{0, 17, 8}:      "Orbital Data Corporation",
	[3]byte{0, 17, 9}:      "Micro-Star International",
	[3]byte{0, 17, 10}:     "Hewlett-Packard Company",
	[3]byte{0, 17, 11}:     "Franklin Technology Systems",
	[3]byte{0, 17, 12}:     "Atmark Techno, Inc.",
	[3]byte{0, 17, 13}:     "SANBlaze Technology, Inc.",
	[3]byte{0, 17, 14}:     "Tsurusaki Sealand Transportation Co. Ltd.",
	[3]byte{0, 17, 15}:     "netplat,Inc.",
	[3]byte{0, 17, 16}:     "Maxanna Technology Co., Ltd.",
	[3]byte{0, 17, 17}:     "Intel Corporation",
	[3]byte{0, 17, 18}:     "Honeywell CMSS",
	[3]byte{0, 17, 19}:     "Fraunhofer FOKUS",
	[3]byte{0, 17, 20}:     "EverFocus Electronics Corp.",
	[3]byte{0, 17, 21}:     "EPIN Technologies, Inc.",
	[3]byte{0, 17, 22}:     "COTEAU VERT CO., LTD.",
	[3]byte{0, 17, 23}:     "CESNET",
	[3]byte{0, 17, 24}:     "BLX IC Design Corp., Ltd.",
	[3]byte{0, 17, 25}:     "Solteras, Inc.",
	[3]byte{0, 17, 26}:     "ARRIS Group, Inc.",
	[3]byte{0, 17, 27}:     "Targa Systems Div L-3 Communications Canada",
	[3]byte{0, 17, 28}:     "Pleora Technologies Inc.",
	[3]byte{0, 17, 29}:     "Hectrix Limited",
	[3]byte{0, 17, 30}:     "EPSG (Ethernet Powerlink Standardization Group)",
	[3]byte{0, 17, 31}:     "Doremi Labs, Inc.",
	[3]byte{0, 17, 32}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 17, 33}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 17, 34}:     "CIMSYS Inc",
	[3]byte{0, 17, 35}:     "Appointech, Inc.",
	[3]byte{0, 17, 36}:     "Apple",
	[3]byte{0, 17, 37}:     "IBM Corp",
	[3]byte{0, 17, 38}:     "Venstar Inc.",
	[3]byte{0, 17, 39}:     "TASI, Inc",
	[3]byte{0, 17, 40}:     "Streamit",
	[3]byte{0, 17, 41}:     "Paradise Datacom Ltd.",
	[3]byte{0, 17, 42}:     "Niko NV",
	[3]byte{0, 17, 43}:     "NetModule AG",
	[3]byte{0, 17, 44}:     "IZT GmbH",
	[3]byte{0, 17, 45}:     "iPulse Systems",
	[3]byte{0, 17, 46}:     "CEICOM",
	[3]byte{0, 17, 47}:     "ASUSTek Computer Inc.",
	[3]byte{0, 17, 48}:     "Allied Telesis (Hong Kong) Ltd.",
	[3]byte{0, 17, 49}:     "UNATECH. CO.,LTD",
	[3]byte{0, 17, 50}:     "Synology Incorporated",
	[3]byte{0, 17, 51}:     "Siemens Austria SIMEA",
	[3]byte{0, 17, 52}:     "MediaCell, Inc.",
	[3]byte{0, 17, 53}:     "Grandeye Ltd",
	[3]byte{0, 17, 54}:     "Goodrich Sensor Systems",
	[3]byte{0, 17, 55}:     "AICHI ELECTRIC CO., LTD.",
	[3]byte{0, 17, 56}:     "TAISHIN CO., LTD.",
	[3]byte{0, 17, 57}:     "STOEBER ANTRIEBSTECHNIK GmbH + Co. KG.",
	[3]byte{0, 17, 58}:     "SHINBORAM",
	[3]byte{0, 17, 59}:     "Micronet Communications Inc.",
	[3]byte{0, 17, 60}:     "Micronas GmbH",
	[3]byte{0, 17, 61}:     "KN SOLTEC CO.,LTD.",
	[3]byte{0, 17, 62}:     "JL Corporation",
	[3]byte{0, 17, 63}:     "Alcatel DI",
	[3]byte{0, 17, 64}:     "Nanometrics Inc.",
	[3]byte{0, 17, 65}:     "GoodMan Corporation",
	[3]byte{0, 17, 66}:     "e-SMARTCOM  INC.",
	[3]byte{0, 17, 67}:     "Dell Inc",
	[3]byte{0, 17, 68}:     "Assurance Technology Corp",
	[3]byte{0, 17, 69}:     "ValuePoint Networks",
	[3]byte{0, 17, 70}:     "Telecard-Pribor Ltd",
	[3]byte{0, 17, 71}:     "Secom-Industry co.LTD.",
	[3]byte{0, 17, 72}:     "Prolon Control Systems",
	[3]byte{0, 17, 73}:     "Proliphix Inc.",
	[3]byte{0, 17, 74}:     "KAYABA INDUSTRY Co,.Ltd.",
	[3]byte{0, 17, 75}:     "Francotyp-Postalia GmbH",
	[3]byte{0, 17, 76}:     "caffeina applied research ltd.",
	[3]byte{0, 17, 77}:     "Atsumi Electric Co.,LTD.",
	[3]byte{0, 17, 78}:     "690885 Ontario Inc.",
	[3]byte{0, 17, 79}:     "US Digital Television, Inc",
	[3]byte{0, 17, 80}:     "Belkin Corporation",
	[3]byte{0, 17, 81}:     "Mykotronx",
	[3]byte{0, 17, 82}:     "Eidsvoll Electronics AS",
	[3]byte{0, 17, 83}:     "Trident Tek, Inc.",
	[3]byte{0, 17, 84}:     "Webpro Technologies Inc.",
	[3]byte{0, 17, 85}:     "Sevis Systems",
	[3]byte{0, 17, 86}:     "Pharos Systems NZ",
	[3]byte{0, 17, 87}:     "OF Networks Co., Ltd.",
	[3]byte{0, 17, 88}:     "Nortel Networks",
	[3]byte{0, 17, 89}:     "MATISSE NETWORKS INC",
	[3]byte{0, 17, 90}:     "Ivoclar Vivadent AG",
	[3]byte{0, 17, 91}:     "Elitegroup Computer System Co. (ECS)",
	[3]byte{0, 17, 92}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 17, 93}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 17, 94}:     "ProMinent Dosiertechnik GmbH",
	[3]byte{0, 17, 95}:     "ITX Security Co., Ltd.",
	[3]byte{0, 17, 96}:     "ARTDIO Company Co., LTD",
	[3]byte{0, 17, 97}:     "NetStreams, LLC",
	[3]byte{0, 17, 98}:     "STAR MICRONICS CO.,LTD.",
	[3]byte{0, 17, 99}:     "SYSTEM SPA DEPT. ELECTRONICS",
	[3]byte{0, 17, 100}:    "ACARD Technology Corp.",
	[3]byte{0, 17, 101}:    "Znyx Networks",
	[3]byte{0, 17, 102}:    "Taelim Electronics Co., Ltd.",
	[3]byte{0, 17, 103}:    "Integrated System Solution Corp.",
	[3]byte{0, 17, 104}:    "HomeLogic LLC",
	[3]byte{0, 17, 105}:    "EMS Satcom",
	[3]byte{0, 17, 106}:    "Domo Ltd",
	[3]byte{0, 17, 107}:    "Digital Data Communications Asia Co.,Ltd",
	[3]byte{0, 17, 108}:    "Nanwang Multimedia Inc.,Ltd",
	[3]byte{0, 17, 109}:    "American Time and Signal",
	[3]byte{0, 17, 110}:    "PePLink Ltd.",
	[3]byte{0, 17, 111}:    "Netforyou Co., LTD.",
	[3]byte{0, 17, 112}:    "GSC SRL",
	[3]byte{0, 17, 113}:    "DEXTER Communications, Inc.",
	[3]byte{0, 17, 114}:    "COTRON CORPORATION",
	[3]byte{0, 17, 115}:    "SMART Storage Systems",
	[3]byte{0, 17, 116}:    "Wibhu Technologies, Inc.",
	[3]byte{0, 17, 117}:    "PathScale, Inc.",
	[3]byte{0, 17, 118}:    "Intellambda Systems, Inc.",
	[3]byte{0, 17, 119}:    "Coaxial Networks, Inc.",
	[3]byte{0, 17, 120}:    "Chiron Technology Ltd",
	[3]byte{0, 17, 121}:    "Singular Technology Co. Ltd.",
	[3]byte{0, 17, 122}:    "Singim International Corp.",
	[3]byte{0, 17, 123}:    "Büchi  Labortechnik AG",
	[3]byte{0, 17, 124}:    "e-zy.net",
	[3]byte{0, 17, 125}:    "ZMD America, Inc.",
	[3]byte{0, 17, 126}:    "Progeny, A division of Midmark Corp",
	[3]byte{0, 17, 127}:    "Neotune Information Technology Corporation,.LTD",
	[3]byte{0, 17, 128}:    "ARRIS Group, Inc.",
	[3]byte{0, 17, 129}:    "InterEnergy Co.Ltd,",
	[3]byte{0, 17, 130}:    "IMI Norgren Ltd",
	[3]byte{0, 17, 131}:    "Datalogic ADC, Inc.",
	[3]byte{0, 17, 132}:    "Humo Laboratory,Ltd.",
	[3]byte{0, 17, 133}:    "Hewlett-Packard Company",
	[3]byte{0, 17, 134}:    "Prime Systems, Inc.",
	[3]byte{0, 17, 135}:    "Category Solutions, Inc",
	[3]byte{0, 17, 136}:    "Enterasys",
	[3]byte{0, 17, 137}:    "Aerotech Inc",
	[3]byte{0, 17, 138}:    "Viewtran Technology Limited",
	[3]byte{0, 17, 139}:    "Alcatel-Lucent, Enterprise Business Group",
	[3]byte{0, 17, 140}:    "Missouri Department of Transportation",
	[3]byte{0, 17, 141}:    "Hanchang System Corp.",
	[3]byte{0, 17, 142}:    "Halytech Mace",
	[3]byte{0, 17, 143}:    "EUTECH INSTRUMENTS PTE. LTD.",
	[3]byte{0, 17, 144}:    "Digital Design Corporation",
	[3]byte{0, 17, 145}:    "CTS-Clima Temperatur Systeme GmbH",
	[3]byte{0, 17, 146}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 17, 147}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 17, 148}:    "Chi Mei Communication Systems, Inc.",
	[3]byte{0, 17, 149}:    "D-Link Corporation",
	[3]byte{0, 17, 150}:    "Actuality Systems, Inc.",
	[3]byte{0, 17, 151}:    "Monitoring Technologies Limited",
	[3]byte{0, 17, 152}:    "Prism Media Products Limited",
	[3]byte{0, 17, 153}:    "2wcom Systems GmbH",
	[3]byte{0, 17, 154}:    "Alkeria srl",
	[3]byte{0, 17, 155}:    "Telesynergy Research Inc.",
	[3]byte{0, 17, 156}:    "EP&T Energy",
	[3]byte{0, 17, 157}:    "Diginfo Technology Corporation",
	[3]byte{0, 17, 158}:    "Solectron Brazil",
	[3]byte{0, 17, 159}:    "Nokia Danmark A/S",
	[3]byte{0, 17, 160}:    "Vtech Engineering Canada Ltd",
	[3]byte{0, 17, 161}:    "VISION NETWARE CO.,LTD",
	[3]byte{0, 17, 162}:    "Manufacturing Technology Inc",
	[3]byte{0, 17, 163}:    "LanReady Technologies Inc.",
	[3]byte{0, 17, 164}:    "JStream Technologies Inc.",
	[3]byte{0, 17, 165}:    "Fortuna Electronic Corp.",
	[3]byte{0, 17, 166}:    "Sypixx Networks",
	[3]byte{0, 17, 167}:    "Infilco Degremont Inc.",
	[3]byte{0, 17, 168}:    "Quest Technologies",
	[3]byte{0, 17, 169}:    "MOIMSTONE Co., LTD",
	[3]byte{0, 17, 170}:    "Uniclass Technology, Co., LTD",
	[3]byte{0, 17, 171}:    "TRUSTABLE TECHNOLOGY CO.,LTD.",
	[3]byte{0, 17, 172}:    "Simtec Electronics",
	[3]byte{0, 17, 173}:    "Shanghai Ruijie Technology",
	[3]byte{0, 17, 174}:    "ARRIS Group, Inc.",
	[3]byte{0, 17, 175}:    "Medialink-i,Inc",
	[3]byte{0, 17, 176}:    "Fortelink Inc.",
	[3]byte{0, 17, 177}:    "BlueExpert Technology Corp.",
	[3]byte{0, 17, 178}:    "2001 Technology Inc.",
	[3]byte{0, 17, 179}:    "YOSHIMIYA CO.,LTD.",
	[3]byte{0, 17, 180}:    "Westermo Teleindustri AB",
	[3]byte{0, 17, 181}:    "Shenzhen Powercom Co.,Ltd",
	[3]byte{0, 17, 182}:    "Open Systems International",
	[3]byte{0, 17, 183}:    "Octalix B.V.",
	[3]byte{0, 17, 184}:    "Liebherr - Elektronik GmbH",
	[3]byte{0, 17, 185}:    "Inner Range Pty. Ltd.",
	[3]byte{0, 17, 186}:    "Elexol Pty Ltd",
	[3]byte{0, 17, 187}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 17, 188}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 17, 189}:    "Bombardier Transportation",
	[3]byte{0, 17, 190}:    "AGP Telecom Co. Ltd",
	[3]byte{0, 17, 191}:    "AESYS S.p.A.",
	[3]byte{0, 17, 192}:    "Aday Technology Inc",
	[3]byte{0, 17, 193}:    "4P MOBILE DATA PROCESSING",
	[3]byte{0, 17, 194}:    "United Fiber Optic Communication",
	[3]byte{0, 17, 195}:    "Transceiving System Technology Corporation",
	[3]byte{0, 17, 196}:    "Terminales de Telecomunicacion Terrestre, S.L.",
	[3]byte{0, 17, 197}:    "TEN Technology",
	[3]byte{0, 17, 198}:    "Seagate Technology",
	[3]byte{0, 17, 199}:    "Raymarine UK Ltd",
	[3]byte{0, 17, 200}:    "Powercom Co., Ltd.",
	[3]byte{0, 17, 201}:    "MTT Corporation",
	[3]byte{0, 17, 202}:    "Long Range Systems, Inc.",
	[3]byte{0, 17, 203}:    "Jacobsons AB",
	[3]byte{0, 17, 204}:    "Guangzhou Jinpeng Group Co.,Ltd.",
	[3]byte{0, 17, 205}:    "Axsun Technologies",
	[3]byte{0, 17, 206}:    "Ubisense Limited",
	[3]byte{0, 17, 207}:    "Thrane & Thrane A/S",
	[3]byte{0, 17, 208}:    "Tandberg Data ASA",
	[3]byte{0, 17, 209}:    "Soft Imaging System GmbH",
	[3]byte{0, 17, 210}:    "Perception Digital Ltd",
	[3]byte{0, 17, 211}:    "NextGenTel Holding ASA",
	[3]byte{0, 17, 212}:    "NetEnrich, Inc",
	[3]byte{0, 17, 213}:    "Hangzhou Sunyard System Engineering Co.,Ltd.",
	[3]byte{0, 17, 214}:    "HandEra, Inc.",
	[3]byte{0, 17, 215}:    "eWerks Inc",
	[3]byte{0, 17, 216}:    "ASUSTek Computer Inc.",
	[3]byte{0, 17, 217}:    "TiVo",
	[3]byte{0, 17, 218}:    "Vivaas Technology Inc.",
	[3]byte{0, 17, 219}:    "Land-Cellular Corporation",
	[3]byte{0, 17, 220}:    "Glunz & Jensen",
	[3]byte{0, 17, 221}:    "FROMUS TEC. Co., Ltd.",
	[3]byte{0, 17, 222}:    "EURILOGIC",
	[3]byte{0, 17, 223}:    "Current Energy",
	[3]byte{0, 17, 224}:    "U-MEDIA Communications, Inc.",
	[3]byte{0, 17, 225}:    "Arcelik A.S",
	[3]byte{0, 17, 226}:    "Hua Jung Components Co., Ltd.",
	[3]byte{0, 17, 227}:    "Thomson, Inc.",
	[3]byte{0, 17, 228}:    "Danelec Electronics A/S",
	[3]byte{0, 17, 229}:    "KCodes Corporation",
	[3]byte{0, 17, 230}:    "Scientific Atlanta",
	[3]byte{0, 17, 231}:    "WORLDSAT - Texas de France",
	[3]byte{0, 17, 232}:    "Tixi.Com",
	[3]byte{0, 17, 233}:    "STARNEX CO., LTD.",
	[3]byte{0, 17, 234}:    "IWICS Inc.",
	[3]byte{0, 17, 235}:    "Innovative Integration",
	[3]byte{0, 17, 236}:    "AVIX INC.",
	[3]byte{0, 17, 237}:    "802 Global",
	[3]byte{0, 17, 238}:    "Estari, Inc.",
	[3]byte{0, 17, 239}:    "Conitec Datensysteme GmbH",
	[3]byte{0, 17, 240}:    "Wideful Limited",
	[3]byte{0, 17, 241}:    "QinetiQ Ltd",
	[3]byte{0, 17, 242}:    "Institute of Network Technologies",
	[3]byte{0, 17, 243}:    "NeoMedia Europe AG",
	[3]byte{0, 17, 244}:    "woori-net",
	[3]byte{0, 17, 245}:    "ASKEY COMPUTER CORP.",
	[3]byte{0, 17, 246}:    "Asia Pacific Microsystems , Inc.",
	[3]byte{0, 17, 247}:    "Shenzhen Forward Industry Co., Ltd",
	[3]byte{0, 17, 248}:    "AIRAYA Corp",
	[3]byte{0, 17, 249}:    "Nortel Networks",
	[3]byte{0, 17, 250}:    "Rane Corporation",
	[3]byte{0, 17, 251}:    "Heidelberg Engineering GmbH",
	[3]byte{0, 17, 252}:    "HARTING Electric Gmbh & Co.KG",
	[3]byte{0, 17, 253}:    "KORG INC.",
	[3]byte{0, 17, 254}:    "Keiyo System Research, Inc.",
	[3]byte{0, 17, 255}:    "Digitro Tecnologia Ltda",
	[3]byte{0, 18, 0}:      "CISCO SYSTEMS, INC.",
	[3]byte{0, 18, 1}:      "CISCO SYSTEMS, INC.",
	[3]byte{0, 18, 2}:      "Decrane Aerospace - Audio International Inc.",
	[3]byte{0, 18, 3}:      "ActivNetworks",
	[3]byte{0, 18, 4}:      "u10 Networks, Inc.",
	[3]byte{0, 18, 5}:      "Terrasat Communications, Inc.",
	[3]byte{0, 18, 6}:      "iQuest (NZ) Ltd",
	[3]byte{0, 18, 7}:      "Head Strong International Limited",
	[3]byte{0, 18, 8}:      "Gantner Instruments GmbH",
	[3]byte{0, 18, 9}:      "Fastrax Ltd",
	[3]byte{0, 18, 10}:     "Emerson Climate Technologies GmbH",
	[3]byte{0, 18, 11}:     "Chinasys Technologies Limited",
	[3]byte{0, 18, 12}:     "CE-Infosys Pte Ltd",
	[3]byte{0, 18, 13}:     "Advanced Telecommunication Technologies, Inc.",
	[3]byte{0, 18, 14}:     "AboCom",
	[3]byte{0, 18, 15}:     "IEEE 802.3",
	[3]byte{0, 18, 16}:     "WideRay Corp",
	[3]byte{0, 18, 17}:     "Protechna Herbst GmbH & Co. KG",
	[3]byte{0, 18, 18}:     "PLUS  Corporation",
	[3]byte{0, 18, 19}:     "Metrohm AG",
	[3]byte{0, 18, 20}:     "Koenig & Bauer AG",
	[3]byte{0, 18, 21}:     "iStor Networks, Inc.",
	[3]byte{0, 18, 22}:     "ICP Internet Communication Payment AG",
	[3]byte{0, 18, 23}:     "Cisco-Linksys, LLC",
	[3]byte{0, 18, 24}:     "ARUZE Corporation",
	[3]byte{0, 18, 25}:     "Ahead Communication Systems Inc",
	[3]byte{0, 18, 26}:     "Techno Soft Systemnics Inc.",
	[3]byte{0, 18, 27}:     "Sound Devices, LLC",
	[3]byte{0, 18, 28}:     "PARROT S.A.",
	[3]byte{0, 18, 29}:     "Netfabric Corporation",
	[3]byte{0, 18, 30}:     "Juniper Networks, Inc.",
	[3]byte{0, 18, 31}:     "Harding Instruments",
	[3]byte{0, 18, 32}:     "Cadco Systems",
	[3]byte{0, 18, 33}:     "B.Braun Melsungen AG",
	[3]byte{0, 18, 34}:     "Skardin (UK) Ltd",
	[3]byte{0, 18, 35}:     "Pixim",
	[3]byte{0, 18, 36}:     "NexQL Corporation",
	[3]byte{0, 18, 37}:     "ARRIS Group, Inc.",
	[3]byte{0, 18, 38}:     "Japan Direx Corporation",
	[3]byte{0, 18, 39}:     "Franklin Electric Co., Inc.",
	[3]byte{0, 18, 40}:     "Data Ltd.",
	[3]byte{0, 18, 41}:     "BroadEasy Technologies Co.,Ltd",
	[3]byte{0, 18, 42}:     "VTech Telecommunications Ltd.",
	[3]byte{0, 18, 43}:     "Virbiage Pty Ltd",
	[3]byte{0, 18, 44}:     "Soenen Controls N.V.",
	[3]byte{0, 18, 45}:     "SiNett Corporation",
	[3]byte{0, 18, 46}:     "Signal Technology - AISD",
	[3]byte{0, 18, 47}:     "Sanei Electric Inc.",
	[3]byte{0, 18, 48}:     "Picaso Infocommunication CO., LTD.",
	[3]byte{0, 18, 49}:     "Motion Control Systems, Inc.",
	[3]byte{0, 18, 50}:     "LeWiz Communications Inc.",
	[3]byte{0, 18, 51}:     "JRC TOKKI Co.,Ltd.",
	[3]byte{0, 18, 52}:     "Camille Bauer",
	[3]byte{0, 18, 53}:     "Andrew Corporation",
	[3]byte{0, 18, 54}:     "ConSentry Networks",
	[3]byte{0, 18, 55}:     "Texas Instruments",
	[3]byte{0, 18, 56}:     "SetaBox Technology Co., Ltd.",
	[3]byte{0, 18, 57}:     "S Net Systems Inc.",
	[3]byte{0, 18, 58}:     "Posystech Inc., Co.",
	[3]byte{0, 18, 59}:     "KeRo Systems ApS",
	[3]byte{0, 18, 60}:     "Second Rule LLC",
	[3]byte{0, 18, 61}:     "GES",
	[3]byte{0, 18, 62}:     "ERUNE technology Co., Ltd.",
	[3]byte{0, 18, 63}:     "Dell Inc",
	[3]byte{0, 18, 64}:     "AMOI ELECTRONICS CO.,LTD",
	[3]byte{0, 18, 65}:     "a2i marketing center",
	[3]byte{0, 18, 66}:     "Millennial Net",
	[3]byte{0, 18, 67}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 18, 68}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 18, 69}:     "Zellweger Analytics, Inc.",
	[3]byte{0, 18, 70}:     "T.O.M TECHNOLOGY INC..",
	[3]byte{0, 18, 71}:     "Samsung Electronics Co., Ltd.",
	[3]byte{0, 18, 72}:     "EMC Corporation (Kashya)",
	[3]byte{0, 18, 73}:     "Delta Elettronica S.p.A.",
	[3]byte{0, 18, 74}:     "Dedicated Devices, Inc.",
	[3]byte{0, 18, 75}:     "Texas Instruments",
	[3]byte{0, 18, 76}:     "BBWM Corporation",
	[3]byte{0, 18, 77}:     "Inducon BV",
	[3]byte{0, 18, 78}:     "XAC AUTOMATION CORP.",
	[3]byte{0, 18, 79}:     "Pentair Thermal Management",
	[3]byte{0, 18, 80}:     "Tokyo Aircaft Instrument Co., Ltd.",
	[3]byte{0, 18, 81}:     "SILINK",
	[3]byte{0, 18, 82}:     "Citronix, LLC",
	[3]byte{0, 18, 83}:     "AudioDev AB",
	[3]byte{0, 18, 84}:     "Spectra Technologies Holdings Company Ltd",
	[3]byte{0, 18, 85}:     "NetEffect Incorporated",
	[3]byte{0, 18, 86}:     "LG INFORMATION & COMM.",
	[3]byte{0, 18, 87}:     "LeapComm Communication Technologies Inc.",
	[3]byte{0, 18, 88}:     "Activis Polska",
	[3]byte{0, 18, 89}:     "THERMO ELECTRON KARLSRUHE",
	[3]byte{0, 18, 90}:     "Microsoft Corporation",
	[3]byte{0, 18, 91}:     "KAIMEI ELECTRONI",
	[3]byte{0, 18, 92}:     "Green Hills Software, Inc.",
	[3]byte{0, 18, 93}:     "CyberNet Inc.",
	[3]byte{0, 18, 94}:     "CAEN",
	[3]byte{0, 18, 95}:     "AWIND Inc.",
	[3]byte{0, 18, 96}:     "Stanton Magnetics,inc.",
	[3]byte{0, 18, 97}:     "Adaptix, Inc",
	[3]byte{0, 18, 98}:     "Nokia Danmark A/S",
	[3]byte{0, 18, 99}:     "Data Voice Technologies GmbH",
	[3]byte{0, 18, 100}:    "daum electronic gmbh",
	[3]byte{0, 18, 101}:    "Enerdyne Technologies, Inc.",
	[3]byte{0, 18, 102}:    "Swisscom Hospitality Services SA",
	[3]byte{0, 18, 103}:    "Panasonic Corporation",
	[3]byte{0, 18, 104}:    "IPS d.o.o.",
	[3]byte{0, 18, 105}:    "Value Electronics",
	[3]byte{0, 18, 106}:    "OPTOELECTRONICS Co., Ltd.",
	[3]byte{0, 18, 107}:    "Ascalade Communications Limited",
	[3]byte{0, 18, 108}:    "Visonic Ltd.",
	[3]byte{0, 18, 109}:    "University of California, Berkeley",
	[3]byte{0, 18, 110}:    "Seidel Elektronik GmbH Nfg.KG",
	[3]byte{0, 18, 111}:    "Rayson Technology Co., Ltd.",
	[3]byte{0, 18, 112}:    "NGES Denro Systems",
	[3]byte{0, 18, 113}:    "Measurement Computing Corp",
	[3]byte{0, 18, 114}:    "Redux Communications Ltd.",
	[3]byte{0, 18, 115}:    "Stoke Inc",
	[3]byte{0, 18, 116}:    "NIT lab",
	[3]byte{0, 18, 117}:    "Sentilla Corporation",
	[3]byte{0, 18, 118}:    "CG Power Systems Ireland Limited",
	[3]byte{0, 18, 119}:    "Korenix Technologies Co., Ltd.",
	[3]byte{0, 18, 120}:    "International Bar Code",
	[3]byte{0, 18, 121}:    "Hewlett-Packard Company",
	[3]byte{0, 18, 122}:    "Sanyu Industry Co.,Ltd.",
	[3]byte{0, 18, 123}:    "VIA Networking Technologies, Inc.",
	[3]byte{0, 18, 124}:    "SWEGON AB",
	[3]byte{0, 18, 125}:    "MobileAria",
	[3]byte{0, 18, 126}:    "Digital Lifestyles Group, Inc.",
	[3]byte{0, 18, 127}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 18, 128}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 18, 129}:    "March Networks S.p.A.",
	[3]byte{0, 18, 130}:    "Qovia",
	[3]byte{0, 18, 131}:    "Nortel Networks",
	[3]byte{0, 18, 132}:    "Lab33 Srl",
	[3]byte{0, 18, 133}:    "Gizmondo Europe Ltd",
	[3]byte{0, 18, 134}:    "ENDEVCO CORP",
	[3]byte{0, 18, 135}:    "Digital Everywhere Unterhaltungselektronik GmbH",
	[3]byte{0, 18, 136}:    "2Wire, Inc",
	[3]byte{0, 18, 137}:    "Advance Sterilization Products",
	[3]byte{0, 18, 138}:    "ARRIS Group, Inc.",
	[3]byte{0, 18, 139}:    "Sensory Networks Inc",
	[3]byte{0, 18, 140}:    "Woodward Governor",
	[3]byte{0, 18, 141}:    "STB Datenservice GmbH",
	[3]byte{0, 18, 142}:    "Q-Free ASA",
	[3]byte{0, 18, 143}:    "Montilio",
	[3]byte{0, 18, 144}:    "KYOWA Electric & Machinery Corp.",
	[3]byte{0, 18, 145}:    "KWS Computersysteme GmbH",
	[3]byte{0, 18, 146}:    "Griffin Technology",
	[3]byte{0, 18, 147}:    "GE Energy",
	[3]byte{0, 18, 148}:    "SUMITOMO ELECTRIC DEVICE INNOVATIONS, INC",
	[3]byte{0, 18, 149}:    "Aiware Inc.",
	[3]byte{0, 18, 150}:    "Addlogix",
	[3]byte{0, 18, 151}:    "O2Micro, Inc.",
	[3]byte{0, 18, 152}:    "MICO ELECTRIC(SHENZHEN) LIMITED",
	[3]byte{0, 18, 153}:    "Ktech Telecommunications Inc",
	[3]byte{0, 18, 154}:    "IRT Electronics Pty Ltd",
	[3]byte{0, 18, 155}:    "E2S Electronic Engineering Solutions, S.L.",
	[3]byte{0, 18, 156}:    "Yulinet",
	[3]byte{0, 18, 157}:    "First International Computer do Brasil",
	[3]byte{0, 18, 158}:    "Surf Communications Inc.",
	[3]byte{0, 18, 159}:    "RAE Systems",
	[3]byte{0, 18, 160}:    "NeoMeridian Sdn Bhd",
	[3]byte{0, 18, 161}:    "BluePacket Communications Co., Ltd.",
	[3]byte{0, 18, 162}:    "VITA",
	[3]byte{0, 18, 163}:    "Trust International B.V.",
	[3]byte{0, 18, 164}:    "ThingMagic, LLC",
	[3]byte{0, 18, 165}:    "Stargen, Inc.",
	[3]byte{0, 18, 166}:    "Dolby Australia",
	[3]byte{0, 18, 167}:    "ISR TECHNOLOGIES Inc",
	[3]byte{0, 18, 168}:    "intec GmbH",
	[3]byte{0, 18, 169}:    "3Com Ltd",
	[3]byte{0, 18, 170}:    "IEE, Inc.",
	[3]byte{0, 18, 171}:    "WiLife, Inc.",
	[3]byte{0, 18, 172}:    "ONTIMETEK INC.",
	[3]byte{0, 18, 173}:    "IDS GmbH",
	[3]byte{0, 18, 174}:    "HLS HARD-LINE Solutions Inc.",
	[3]byte{0, 18, 175}:    "ELPRO Technologies",
	[3]byte{0, 18, 176}:    "Efore Oyj   (Plc)",
	[3]byte{0, 18, 177}:    "Dai Nippon Printing Co., Ltd",
	[3]byte{0, 18, 178}:    "AVOLITES LTD.",
	[3]byte{0, 18, 179}:    "Advance Wireless Technology Corp.",
	[3]byte{0, 18, 180}:    "Work Microwave GmbH",
	[3]byte{0, 18, 181}:    "Vialta, Inc.",
	[3]byte{0, 18, 182}:    "Santa Barbara Infrared, Inc.",
	[3]byte{0, 18, 183}:    "PTW Freiburg",
	[3]byte{0, 18, 184}:    "G2 Microsystems",
	[3]byte{0, 18, 185}:    "Fusion Digital Technology",
	[3]byte{0, 18, 186}:    "FSI Systems, Inc.",
	[3]byte{0, 18, 187}:    "Telecommunications Industry Association TR-41 Committee",
	[3]byte{0, 18, 188}:    "Echolab LLC",
	[3]byte{0, 18, 189}:    "Avantec Manufacturing Limited",
	[3]byte{0, 18, 190}:    "Astek Corporation",
	[3]byte{0, 18, 191}:    "Arcadyan Technology Corporation",
	[3]byte{0, 18, 192}:    "HotLava Systems, Inc.",
	[3]byte{0, 18, 193}:    "Check Point Software Technologies",
	[3]byte{0, 18, 194}:    "Apex Electronics Factory",
	[3]byte{0, 18, 195}:    "WIT S.A.",
	[3]byte{0, 18, 196}:    "Viseon, Inc.",
	[3]byte{0, 18, 197}:    "V-Show  Technology (China) Co.,Ltd",
	[3]byte{0, 18, 198}:    "TGC America, Inc",
	[3]byte{0, 18, 199}:    "SECURAY Technologies Ltd.Co.",
	[3]byte{0, 18, 200}:    "Perfect tech",
	[3]byte{0, 18, 201}:    "ARRIS Group, Inc.",
	[3]byte{0, 18, 202}:    "Mechatronic Brick Aps",
	[3]byte{0, 18, 203}:    "CSS Inc.",
	[3]byte{0, 18, 204}:    "Bitatek CO., LTD",
	[3]byte{0, 18, 205}:    "ASEM SpA",
	[3]byte{0, 18, 206}:    "Advanced Cybernetics Group",
	[3]byte{0, 18, 207}:    "Accton Technology Corporation",
	[3]byte{0, 18, 208}:    "Gossen-Metrawatt-GmbH",
	[3]byte{0, 18, 209}:    "Texas Instruments Inc",
	[3]byte{0, 18, 210}:    "Texas Instruments",
	[3]byte{0, 18, 211}:    "Zetta Systems, Inc.",
	[3]byte{0, 18, 212}:    "Princeton Technology, Ltd",
	[3]byte{0, 18, 213}:    "Motion Reality Inc.",
	[3]byte{0, 18, 214}:    "Jiangsu Yitong High-Tech Co.,Ltd",
	[3]byte{0, 18, 215}:    "Invento Networks, Inc.",
	[3]byte{0, 18, 216}:    "International Games System Co., Ltd.",
	[3]byte{0, 18, 217}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 18, 218}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 18, 219}:    "ZIEHL industrie-elektronik GmbH + Co KG",
	[3]byte{0, 18, 220}:    "SunCorp Industrial Limited",
	[3]byte{0, 18, 221}:    "Shengqu Information Technology (Shanghai) Co., Ltd.",
	[3]byte{0, 18, 222}:    "Radio Components Sweden AB",
	[3]byte{0, 18, 223}:    "Novomatic AG",
	[3]byte{0, 18, 224}:    "Codan Limited",
	[3]byte{0, 18, 225}:    "Alliant Networks, Inc",
	[3]byte{0, 18, 226}:    "ALAXALA Networks Corporation",
	[3]byte{0, 18, 227}:    "Agat-RT, Ltd.",
	[3]byte{0, 18, 228}:    "ZIEHL industrie-electronik GmbH + Co KG",
	[3]byte{0, 18, 229}:    "Time America, Inc.",
	[3]byte{0, 18, 230}:    "SPECTEC COMPUTER CO., LTD.",
	[3]byte{0, 18, 231}:    "Projectek Networking Electronics Corp.",
	[3]byte{0, 18, 232}:    "Fraunhofer IMS",
	[3]byte{0, 18, 233}:    "Abbey Systems Ltd",
	[3]byte{0, 18, 234}:    "Trane",
	[3]byte{0, 18, 235}:    "PDH Solutions, LLC",
	[3]byte{0, 18, 236}:    "Movacolor b.v.",
	[3]byte{0, 18, 237}:    "AVG Advanced Technologies",
	[3]byte{0, 18, 238}:    "Sony Ericsson Mobile Communications AB",
	[3]byte{0, 18, 239}:    "OneAccess SA",
	[3]byte{0, 18, 240}:    "Intel Corporate",
	[3]byte{0, 18, 241}:    "IFOTEC",
	[3]byte{0, 18, 242}:    "Brocade Communications Systems, Inc",
	[3]byte{0, 18, 243}:    "connectBlue AB",
	[3]byte{0, 18, 244}:    "Belco International Co.,Ltd.",
	[3]byte{0, 18, 245}:    "Imarda New Zealand Limited",
	[3]byte{0, 18, 246}:    "MDK CO.,LTD.",
	[3]byte{0, 18, 247}:    "Xiamen Xinglian Electronics Co., Ltd.",
	[3]byte{0, 18, 248}:    "WNI Resources, LLC",
	[3]byte{0, 18, 249}:    "URYU SEISAKU, LTD.",
	[3]byte{0, 18, 250}:    "THX LTD",
	[3]byte{0, 18, 251}:    "Samsung Electronics",
	[3]byte{0, 18, 252}:    "PLANET System Co.,LTD",
	[3]byte{0, 18, 253}:    "OPTIMUS IC S.A.",
	[3]byte{0, 18, 254}:    "Lenovo Mobile Communication Technology Ltd.",
	[3]byte{0, 18, 255}:    "Lely Industries N.V.",
	[3]byte{0, 19, 0}:      "IT-FACTORY, INC.",
	[3]byte{0, 19, 1}:      "IronGate S.L.",
	[3]byte{0, 19, 2}:      "Intel Corporate",
	[3]byte{0, 19, 3}:      "GateConnect",
	[3]byte{0, 19, 4}:      "Flaircomm Technologies Co. LTD",
	[3]byte{0, 19, 5}:      "Epicom, Inc.",
	[3]byte{0, 19, 6}:      "Always On Wireless",
	[3]byte{0, 19, 7}:      "Paravirtual Corporation",
	[3]byte{0, 19, 8}:      "Nuvera Fuel Cells",
	[3]byte{0, 19, 9}:      "Ocean Broadband Networks",
	[3]byte{0, 19, 10}:     "Nortel",
	[3]byte{0, 19, 11}:     "Mextal B.V.",
	[3]byte{0, 19, 12}:     "HF System Corporation",
	[3]byte{0, 19, 13}:     "GALILEO AVIONICA",
	[3]byte{0, 19, 14}:     "Focusrite Audio Engineering Limited",
	[3]byte{0, 19, 15}:     "EGEMEN Bilgisayar Muh San ve Tic LTD STI",
	[3]byte{0, 19, 16}:     "Cisco-Linksys, LLC",
	[3]byte{0, 19, 17}:     "ARRIS International",
	[3]byte{0, 19, 18}:     "Amedia Networks Inc.",
	[3]byte{0, 19, 19}:     "GuangZhou Post & Telecom Equipment ltd",
	[3]byte{0, 19, 20}:     "Asiamajor Inc.",
	[3]byte{0, 19, 21}:     "SONY Computer Entertainment inc,",
	[3]byte{0, 19, 22}:     "L-S-B Broadcast Technologies GmbH",
	[3]byte{0, 19, 23}:     "GN Netcom as",
	[3]byte{0, 19, 24}:     "DGSTATION Co., Ltd.",
	[3]byte{0, 19, 25}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 19, 26}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 19, 27}:     "BeCell Innovations Corp.",
	[3]byte{0, 19, 28}:     "LiteTouch, Inc.",
	[3]byte{0, 19, 29}:     "Scanvaegt International A/S",
	[3]byte{0, 19, 30}:     "Peiker acustic GmbH & Co. KG",
	[3]byte{0, 19, 31}:     "NxtPhase T&D, Corp.",
	[3]byte{0, 19, 32}:     "Intel Corporate",
	[3]byte{0, 19, 33}:     "Hewlett-Packard Company",
	[3]byte{0, 19, 34}:     "DAQ Electronics, Inc.",
	[3]byte{0, 19, 35}:     "Cap Co., Ltd.",
	[3]byte{0, 19, 36}:     "Schneider Electric Ultra Terminal",
	[3]byte{0, 19, 37}:     "Cortina Systems Inc",
	[3]byte{0, 19, 38}:     "ECM Systems Ltd",
	[3]byte{0, 19, 39}:     "Data Acquisitions limited",
	[3]byte{0, 19, 40}:     "Westech Korea Inc.,",
	[3]byte{0, 19, 41}:     "VSST Co., LTD",
	[3]byte{0, 19, 42}:     "Sitronics Telecom Solutions",
	[3]byte{0, 19, 43}:     "Phoenix Digital",
	[3]byte{0, 19, 44}:     "MAZ Brandenburg GmbH",
	[3]byte{0, 19, 45}:     "iWise Communications",
	[3]byte{0, 19, 46}:     "ITian Coporation",
	[3]byte{0, 19, 47}:     "Interactek",
	[3]byte{0, 19, 48}:     "EURO PROTECTION SURVEILLANCE",
	[3]byte{0, 19, 49}:     "CellPoint Connect",
	[3]byte{0, 19, 50}:     "Beijing Topsec Network Security Technology Co., Ltd.",
	[3]byte{0, 19, 51}:     "BaudTec Corporation",
	[3]byte{0, 19, 52}:     "Arkados, Inc.",
	[3]byte{0, 19, 53}:     "VS Industry Berhad",
	[3]byte{0, 19, 54}:     "Tianjin 712 Communication Broadcasting co., ltd.",
	[3]byte{0, 19, 55}:     "Orient Power Home Network Ltd.",
	[3]byte{0, 19, 56}:     "FRESENIUS-VIAL",
	[3]byte{0, 19, 57}:     "CCV Deutschland GmbH",
	[3]byte{0, 19, 58}:     "VadaTech Inc.",
	[3]byte{0, 19, 59}:     "Speed Dragon Multimedia Limited",
	[3]byte{0, 19, 60}:     "QUINTRON SYSTEMS INC.",
	[3]byte{0, 19, 61}:     "Micro Memory Curtiss Wright Co",
	[3]byte{0, 19, 62}:     "MetaSwitch",
	[3]byte{0, 19, 63}:     "Eppendorf Instrumente GmbH",
	[3]byte{0, 19, 64}:     "AD.EL s.r.l.",
	[3]byte{0, 19, 65}:     "Shandong New Beiyang Information Technology Co.,Ltd",
	[3]byte{0, 19, 66}:     "Vision Research, Inc.",
	[3]byte{0, 19, 67}:     "Matsushita Electronic Components (Europe) GmbH",
	[3]byte{0, 19, 68}:     "Fargo Electronics Inc.",
	[3]byte{0, 19, 69}:     "Eaton Corporation",
	[3]byte{0, 19, 70}:     "D-Link Corporation",
	[3]byte{0, 19, 71}:     "BlueTree Wireless Data Inc.",
	[3]byte{0, 19, 72}:     "Artila Electronics Co., Ltd.",
	[3]byte{0, 19, 73}:     "ZyXEL Communications Corporation",
	[3]byte{0, 19, 74}:     "Engim, Inc.",
	[3]byte{0, 19, 75}:     "ToGoldenNet Technology Inc.",
	[3]byte{0, 19, 76}:     "YDT Technology International",
	[3]byte{0, 19, 77}:     "Inepro BV",
	[3]byte{0, 19, 78}:     "Valox Systems, Inc.",
	[3]byte{0, 19, 79}:     "Tranzeo Wireless Technologies Inc.",
	[3]byte{0, 19, 80}:     "Silver Spring Networks, Inc",
	[3]byte{0, 19, 81}:     "Niles Audio Corporation",
	[3]byte{0, 19, 82}:     "Naztec, Inc.",
	[3]byte{0, 19, 83}:     "HYDAC Filtertechnik GMBH",
	[3]byte{0, 19, 84}:     "Zcomax Technologies, Inc.",
	[3]byte{0, 19, 85}:     "TOMEN Cyber-business Solutions, Inc.",
	[3]byte{0, 19, 86}:     "FLIR Radiation Inc",
	[3]byte{0, 19, 87}:     "Soyal Technology Co., Ltd.",
	[3]byte{0, 19, 88}:     "Realm Systems, Inc.",
	[3]byte{0, 19, 89}:     "ProTelevision Technologies A/S",
	[3]byte{0, 19, 90}:     "Project T&E Limited",
	[3]byte{0, 19, 91}:     "PanelLink Cinema, LLC",
	[3]byte{0, 19, 92}:     "OnSite Systems, Inc.",
	[3]byte{0, 19, 93}:     "NTTPC Communications, Inc.",
	[3]byte{0, 19, 94}:     "EAB/RWI/K",
	[3]byte{0, 19, 95}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 19, 96}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 19, 97}:     "Biospace Co., Ltd.",
	[3]byte{0, 19, 98}:     "ShinHeung Precision Co., Ltd.",
	[3]byte{0, 19, 99}:     "Verascape, Inc.",
	[3]byte{0, 19, 100}:    "Paradigm Technology Inc..",
	[3]byte{0, 19, 101}:    "Nortel",
	[3]byte{0, 19, 102}:    "Neturity Technologies Inc.",
	[3]byte{0, 19, 103}:    "Narayon. Co., Ltd.",
	[3]byte{0, 19, 104}:    "Saab Danmark A/S",
	[3]byte{0, 19, 105}:    "Honda Electron Co., LED.",
	[3]byte{0, 19, 106}:    "Hach Lange Sarl",
	[3]byte{0, 19, 107}:    "E-TEC",
	[3]byte{0, 19, 108}:    "TomTom",
	[3]byte{0, 19, 109}:    "Tentaculus AB",
	[3]byte{0, 19, 110}:    "Techmetro Corp.",
	[3]byte{0, 19, 111}:    "PacketMotion, Inc.",
	[3]byte{0, 19, 112}:    "Nokia Danmark A/S",
	[3]byte{0, 19, 113}:    "ARRIS Group, Inc.",
	[3]byte{0, 19, 114}:    "Dell Inc",
	[3]byte{0, 19, 115}:    "BLwave Electronics Co., Ltd",
	[3]byte{0, 19, 116}:    "Atheros Communications, Inc.",
	[3]byte{0, 19, 117}:    "American Security Products Co.",
	[3]byte{0, 19, 118}:    "Tabor Electronics Ltd.",
	[3]byte{0, 19, 119}:    "Samsung Electronics CO., LTD",
	[3]byte{0, 19, 120}:    "Qsan Technology, Inc.",
	[3]byte{0, 19, 121}:    "PONDER INFORMATION INDUSTRIES LTD.",
	[3]byte{0, 19, 122}:    "Netvox Technology Co., Ltd.",
	[3]byte{0, 19, 123}:    "Movon Corporation",
	[3]byte{0, 19, 124}:    "Kaicom co., Ltd.",
	[3]byte{0, 19, 125}:    "Dynalab, Inc.",
	[3]byte{0, 19, 126}:    "CorEdge Networks, Inc.",
	[3]byte{0, 19, 127}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 19, 128}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 19, 129}:    "CHIPS & Systems, Inc.",
	[3]byte{0, 19, 130}:    "Cetacea Networks Corporation",
	[3]byte{0, 19, 131}:    "Application Technologies and Engineering Research Laboratory",
	[3]byte{0, 19, 132}:    "Advanced Motion Controls",
	[3]byte{0, 19, 133}:    "Add-On Technology Co., LTD.",
	[3]byte{0, 19, 134}:    "ABB Inc./Totalflow",
	[3]byte{0, 19, 135}:    "27M Technologies AB",
	[3]byte{0, 19, 136}:    "WiMedia Alliance",
	[3]byte{0, 19, 137}:    "Redes de Telefonía Móvil S.A.",
	[3]byte{0, 19, 138}:    "QINGDAO GOERTEK ELECTRONICS CO.,LTD.",
	[3]byte{0, 19, 139}:    "Phantom Technologies LLC",
	[3]byte{0, 19, 140}:    "Kumyoung.Co.Ltd",
	[3]byte{0, 19, 141}:    "Kinghold",
	[3]byte{0, 19, 142}:    "FOAB Elektronik AB",
	[3]byte{0, 19, 143}:    "Asiarock Incorporation",
	[3]byte{0, 19, 144}:    "Termtek Computer Co., Ltd",
	[3]byte{0, 19, 145}:    "OUEN CO.,LTD.",
	[3]byte{0, 19, 146}:    "Ruckus Wireless",
	[3]byte{0, 19, 147}:    "Panta Systems, Inc.",
	[3]byte{0, 19, 148}:    "Infohand Co.,Ltd",
	[3]byte{0, 19, 149}:    "congatec AG",
	[3]byte{0, 19, 150}:    "Acbel Polytech Inc.",
	[3]byte{0, 19, 151}:    "Oracle Corporation",
	[3]byte{0, 19, 152}:    "TrafficSim Co.,Ltd",
	[3]byte{0, 19, 153}:    "STAC Corporation.",
	[3]byte{0, 19, 154}:    "K-ubique ID Corp.",
	[3]byte{0, 19, 155}:    "ioIMAGE Ltd.",
	[3]byte{0, 19, 156}:    "Exavera Technologies, Inc.",
	[3]byte{0, 19, 157}:    "Marvell Hispana S.L.",
	[3]byte{0, 19, 158}:    "Ciara Technologies Inc.",
	[3]byte{0, 19, 159}:    "Electronics Design Services, Co., Ltd.",
	[3]byte{0, 19, 160}:    "ALGOSYSTEM Co., Ltd.",
	[3]byte{0, 19, 161}:    "Crow Electronic Engeneering",
	[3]byte{0, 19, 162}:    "MaxStream, Inc",
	[3]byte{0, 19, 163}:    "Siemens Com CPE Devices",
	[3]byte{0, 19, 164}:    "KeyEye Communications",
	[3]byte{0, 19, 165}:    "General Solutions, LTD.",
	[3]byte{0, 19, 166}:    "Extricom Ltd",
	[3]byte{0, 19, 167}:    "BATTELLE MEMORIAL INSTITUTE",
	[3]byte{0, 19, 168}:    "Tanisys Technology",
	[3]byte{0, 19, 169}:    "Sony Corporation",
	[3]byte{0, 19, 170}:    "ALS  & TEC Ltd.",
	[3]byte{0, 19, 171}:    "Telemotive AG",
	[3]byte{0, 19, 172}:    "Sunmyung Electronics Co., LTD",
	[3]byte{0, 19, 173}:    "Sendo Ltd",
	[3]byte{0, 19, 174}:    "Radiance Technologies, Inc.",
	[3]byte{0, 19, 175}:    "NUMA Technology,Inc.",
	[3]byte{0, 19, 176}:    "Jablotron",
	[3]byte{0, 19, 177}:    "Intelligent Control Systems (Asia) Pte Ltd",
	[3]byte{0, 19, 178}:    "Carallon Limited",
	[3]byte{0, 19, 179}:    "Ecom Communications Technology Co., Ltd.",
	[3]byte{0, 19, 180}:    "Appear TV",
	[3]byte{0, 19, 181}:    "Wavesat",
	[3]byte{0, 19, 182}:    "Sling Media, Inc.",
	[3]byte{0, 19, 183}:    "Scantech ID",
	[3]byte{0, 19, 184}:    "RyCo Electronic Systems Limited",
	[3]byte{0, 19, 185}:    "BM SPA",
	[3]byte{0, 19, 186}:    "ReadyLinks Inc",
	[3]byte{0, 19, 187}:    "Smartvue Corporation",
	[3]byte{0, 19, 188}:    "Artimi Ltd",
	[3]byte{0, 19, 189}:    "HYMATOM SA",
	[3]byte{0, 19, 190}:    "Virtual Conexions",
	[3]byte{0, 19, 191}:    "Media System Planning Corp.",
	[3]byte{0, 19, 192}:    "Trix Tecnologia Ltda.",
	[3]byte{0, 19, 193}:    "Asoka USA Corporation",
	[3]byte{0, 19, 194}:    "WACOM Co.,Ltd",
	[3]byte{0, 19, 195}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 19, 196}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 19, 197}:    "LIGHTRON FIBER-OPTIC DEVICES INC.",
	[3]byte{0, 19, 198}:    "OpenGear, Inc",
	[3]byte{0, 19, 199}:    "IONOS Co.,Ltd.",
	[3]byte{0, 19, 200}:    "ADB Broadband Italia",
	[3]byte{0, 19, 201}:    "Beyond Achieve Enterprises Ltd.",
	[3]byte{0, 19, 202}:    "Pico Digital",
	[3]byte{0, 19, 203}:    "Zenitel Norway AS",
	[3]byte{0, 19, 204}:    "Tall Maple Systems",
	[3]byte{0, 19, 205}:    "MTI co. LTD",
	[3]byte{0, 19, 206}:    "Intel Corporate",
	[3]byte{0, 19, 207}:    "4Access Communications",
	[3]byte{0, 19, 208}:    "t+ Medical Ltd",
	[3]byte{0, 19, 209}:    "KIRK telecom A/S",
	[3]byte{0, 19, 210}:    "PAGE IBERICA, S.A.",
	[3]byte{0, 19, 211}:    "MICRO-STAR INTERNATIONAL CO., LTD.",
	[3]byte{0, 19, 212}:    "ASUSTek COMPUTER INC.",
	[3]byte{0, 19, 213}:    "RuggedCom",
	[3]byte{0, 19, 214}:    "TII NETWORK TECHNOLOGIES, INC.",
	[3]byte{0, 19, 215}:    "SPIDCOM Technologies SA",
	[3]byte{0, 19, 216}:    "Princeton Instruments",
	[3]byte{0, 19, 217}:    "Matrix Product Development, Inc.",
	[3]byte{0, 19, 218}:    "Diskware Co., Ltd",
	[3]byte{0, 19, 219}:    "SHOEI Electric Co.,Ltd",
	[3]byte{0, 19, 220}:    "IBTEK INC.",
	[3]byte{0, 19, 221}:    "Abbott Diagnostics",
	[3]byte{0, 19, 222}:    "Adapt4, LLC",
	[3]byte{0, 19, 223}:    "Ryvor Corp.",
	[3]byte{0, 19, 224}:    "Murata Manufacturing Co., Ltd.",
	[3]byte{0, 19, 225}:    "Iprobe AB",
	[3]byte{0, 19, 226}:    "GeoVision Inc.",
	[3]byte{0, 19, 227}:    "CoVi Technologies, Inc.",
	[3]byte{0, 19, 228}:    "YANGJAE SYSTEMS CORP.",
	[3]byte{0, 19, 229}:    "TENOSYS, INC.",
	[3]byte{0, 19, 230}:    "Technolution",
	[3]byte{0, 19, 231}:    "Halcro",
	[3]byte{0, 19, 232}:    "Intel Corporate",
	[3]byte{0, 19, 233}:    "VeriWave, Inc.",
	[3]byte{0, 19, 234}:    "Kamstrup A/S",
	[3]byte{0, 19, 235}:    "Sysmaster Corporation",
	[3]byte{0, 19, 236}:    "Sunbay Software AG",
	[3]byte{0, 19, 237}:    "PSIA",
	[3]byte{0, 19, 238}:    "JBX Designs Inc.",
	[3]byte{0, 19, 239}:    "Kingjon Digital Technology Co.,Ltd",
	[3]byte{0, 19, 240}:    "Wavefront Semiconductor",
	[3]byte{0, 19, 241}:    "AMOD Technology Co., Ltd.",
	[3]byte{0, 19, 242}:    "Klas Ltd",
	[3]byte{0, 19, 243}:    "Giga-byte Communications Inc.",
	[3]byte{0, 19, 244}:    "Psitek (Pty) Ltd",
	[3]byte{0, 19, 245}:    "Akimbi Systems",
	[3]byte{0, 19, 246}:    "Cintech",
	[3]byte{0, 19, 247}:    "SMC Networks, Inc.",
	[3]byte{0, 19, 248}:    "Dex Security Solutions",
	[3]byte{0, 19, 249}:    "Cavera Systems",
	[3]byte{0, 19, 250}:    "LifeSize Communications, Inc",
	[3]byte{0, 19, 251}:    "RKC INSTRUMENT INC.",
	[3]byte{0, 19, 252}:    "SiCortex, Inc",
	[3]byte{0, 19, 253}:    "Nokia Danmark A/S",
	[3]byte{0, 19, 254}:    "GRANDTEC ELECTRONIC CORP.",
	[3]byte{0, 19, 255}:    "Dage-MTI of MC, Inc.",
	[3]byte{0, 20, 0}:      "MINERVA KOREA CO., LTD",
	[3]byte{0, 20, 1}:      "Rivertree Networks Corp.",
	[3]byte{0, 20, 2}:      "kk-electronic a/s",
	[3]byte{0, 20, 3}:      "Renasis, LLC",
	[3]byte{0, 20, 4}:      "ARRIS Group, Inc.",
	[3]byte{0, 20, 5}:      "OpenIB, Inc.",
	[3]byte{0, 20, 6}:      "Go Networks",
	[3]byte{0, 20, 7}:      "Sperian Protection Instrumentation",
	[3]byte{0, 20, 8}:      "Eka Systems Inc.",
	[3]byte{0, 20, 9}:      "MAGNETI MARELLI   S.E. S.p.A.",
	[3]byte{0, 20, 10}:     "WEPIO Co., Ltd.",
	[3]byte{0, 20, 11}:     "FIRST INTERNATIONAL COMPUTER, INC.",
	[3]byte{0, 20, 12}:     "GKB CCTV CO., LTD.",
	[3]byte{0, 20, 13}:     "Nortel",
	[3]byte{0, 20, 14}:     "Nortel",
	[3]byte{0, 20, 15}:     "Federal State Unitary Enterprise Leningrad R&D Institute of",
	[3]byte{0, 20, 16}:     "Suzhou Keda Technology CO.,Ltd",
	[3]byte{0, 20, 17}:     "Deutschmann Automation GmbH & Co. KG",
	[3]byte{0, 20, 18}:     "S-TEC electronics AG",
	[3]byte{0, 20, 19}:     "Trebing & Himstedt Prozeßautomation GmbH & Co. KG",
	[3]byte{0, 20, 20}:     "Jumpnode Systems LLC.",
	[3]byte{0, 20, 21}:     "Intec Automation Inc.",
	[3]byte{0, 20, 22}:     "Scosche Industries, Inc.",
	[3]byte{0, 20, 23}:     "RSE Informations Technologie GmbH",
	[3]byte{0, 20, 24}:     "C4Line",
	[3]byte{0, 20, 25}:     "SIDSA",
	[3]byte{0, 20, 26}:     "DEICY CORPORATION",
	[3]byte{0, 20, 27}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 20, 28}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 20, 29}:     "LTi DRIVES GmbH",
	[3]byte{0, 20, 30}:     "P.A. Semi, Inc.",
	[3]byte{0, 20, 31}:     "SunKwang Electronics Co., Ltd",
	[3]byte{0, 20, 32}:     "G-Links networking company",
	[3]byte{0, 20, 33}:     "Total Wireless Technologies Pte. Ltd.",
	[3]byte{0, 20, 34}:     "Dell Inc",
	[3]byte{0, 20, 35}:     "J-S Co. NEUROCOM",
	[3]byte{0, 20, 36}:     "Merry Electrics CO., LTD.",
	[3]byte{0, 20, 37}:     "Galactic Computing Corp.",
	[3]byte{0, 20, 38}:     "NL Technology",
	[3]byte{0, 20, 39}:     "JazzMutant",
	[3]byte{0, 20, 40}:     "Vocollect, Inc",
	[3]byte{0, 20, 41}:     "V Center Technologies Co., Ltd.",
	[3]byte{0, 20, 42}:     "Elitegroup Computer System Co., Ltd",
	[3]byte{0, 20, 43}:     "Edata Communication Inc.",
	[3]byte{0, 20, 44}:     "Koncept International, Inc.",
	[3]byte{0, 20, 45}:     "Toradex AG",
	[3]byte{0, 20, 46}:     "77 Elektronika Kft.",
	[3]byte{0, 20, 47}:     "WildPackets",
	[3]byte{0, 20, 48}:     "ViPowER, Inc",
	[3]byte{0, 20, 49}:     "PDL Electronics Ltd",
	[3]byte{0, 20, 50}:     "Tarallax Wireless, Inc.",
	[3]byte{0, 20, 51}:     "Empower Technologies(Canada) Inc.",
	[3]byte{0, 20, 52}:     "Keri Systems, Inc",
	[3]byte{0, 20, 53}:     "CityCom Corp.",
	[3]byte{0, 20, 54}:     "Qwerty Elektronik AB",
	[3]byte{0, 20, 55}:     "GSTeletech Co.,Ltd.",
	[3]byte{0, 20, 56}:     "Hewlett-Packard Company",
	[3]byte{0, 20, 57}:     "Blonder Tongue Laboratories, Inc.",
	[3]byte{0, 20, 58}:     "RAYTALK INTERNATIONAL SRL",
	[3]byte{0, 20, 59}:     "Sensovation AG",
	[3]byte{0, 20, 60}:     "Rheinmetall Canada Inc.",
	[3]byte{0, 20, 61}:     "Aevoe Inc.",
	[3]byte{0, 20, 62}:     "AirLink Communications, Inc.",
	[3]byte{0, 20, 63}:     "Hotway Technology Corporation",
	[3]byte{0, 20, 64}:     "ATOMIC Corporation",
	[3]byte{0, 20, 65}:     "Innovation Sound Technology Co., LTD.",
	[3]byte{0, 20, 66}:     "ATTO CORPORATION",
	[3]byte{0, 20, 67}:     "Consultronics Europe Ltd",
	[3]byte{0, 20, 68}:     "Grundfos Holding",
	[3]byte{0, 20, 69}:     "Telefon-Gradnja d.o.o.",
	[3]byte{0, 20, 70}:     "SuperVision Solutions LLC",
	[3]byte{0, 20, 71}:     "BOAZ Inc.",
	[3]byte{0, 20, 72}:     "Inventec Multimedia & Telecom Corporation",
	[3]byte{0, 20, 73}:     "Sichuan Changhong Electric Ltd.",
	[3]byte{0, 20, 74}:     "Taiwan Thick-Film Ind. Corp.",
	[3]byte{0, 20, 75}:     "Hifn, Inc.",
	[3]byte{0, 20, 76}:     "General Meters Corp.",
	[3]byte{0, 20, 77}:     "Intelligent Systems",
	[3]byte{0, 20, 78}:     "SRISA",
	[3]byte{0, 20, 79}:     "Oracle Corporation",
	[3]byte{0, 20, 80}:     "Heim Systems GmbH",
	[3]byte{0, 20, 81}:     "Apple",
	[3]byte{0, 20, 82}:     "CALCULEX,INC.",
	[3]byte{0, 20, 83}:     "ADVANTECH TECHNOLOGIES CO.,LTD",
	[3]byte{0, 20, 84}:     "Symwave",
	[3]byte{0, 20, 85}:     "Coder Electronics Corporation",
	[3]byte{0, 20, 86}:     "Edge Products",
	[3]byte{0, 20, 87}:     "T-VIPS AS",
	[3]byte{0, 20, 88}:     "HS Automatic ApS",
	[3]byte{0, 20, 89}:     "Moram Co., Ltd.",
	[3]byte{0, 20, 90}:     "Neratec Solutions AG",
	[3]byte{0, 20, 91}:     "SeekerNet Inc.",
	[3]byte{0, 20, 92}:     "Intronics B.V.",
	[3]byte{0, 20, 93}:     "WJ Communications, Inc.",
	[3]byte{0, 20, 94}:     "IBM Corp",
	[3]byte{0, 20, 95}:     "ADITEC CO. LTD",
	[3]byte{0, 20, 96}:     "Kyocera Wireless Corp.",
	[3]byte{0, 20, 97}:     "CORONA CORPORATION",
	[3]byte{0, 20, 98}:     "Digiwell Technology, inc",
	[3]byte{0, 20, 99}:     "IDCS N.V.",
	[3]byte{0, 20, 100}:    "Cryptosoft",
	[3]byte{0, 20, 101}:    "Novo Nordisk A/S",
	[3]byte{0, 20, 102}:    "Kleinhenz Elektronik GmbH",
	[3]byte{0, 20, 103}:    "ArrowSpan Inc.",
	[3]byte{0, 20, 104}:    "CelPlan International, Inc.",
	[3]byte{0, 20, 105}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 20, 106}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 20, 107}:    "Anagran, Inc.",
	[3]byte{0, 20, 108}:    "Netgear Inc.",
	[3]byte{0, 20, 109}:    "RF Technologies",
	[3]byte{0, 20, 110}:    "H. Stoll GmbH & Co. KG",
	[3]byte{0, 20, 111}:    "Kohler Co",
	[3]byte{0, 20, 112}:    "Prokom Software SA",
	[3]byte{0, 20, 113}:    "Eastern Asia Technology Limited",
	[3]byte{0, 20, 114}:    "China Broadband Wireless IP Standard Group",
	[3]byte{0, 20, 115}:    "Bookham Inc",
	[3]byte{0, 20, 116}:    "K40 Electronics",
	[3]byte{0, 20, 117}:    "Wiline Networks, Inc.",
	[3]byte{0, 20, 118}:    "MultiCom Industries Limited",
	[3]byte{0, 20, 119}:    "Nertec  Inc.",
	[3]byte{0, 20, 120}:    "ShenZhen TP-LINK Technologies Co., Ltd.",
	[3]byte{0, 20, 121}:    "NEC Magnus Communications,Ltd.",
	[3]byte{0, 20, 122}:    "Eubus GmbH",
	[3]byte{0, 20, 123}:    "Iteris, Inc.",
	[3]byte{0, 20, 124}:    "3Com Ltd",
	[3]byte{0, 20, 125}:    "Aeon Digital International",
	[3]byte{0, 20, 126}:    "InnerWireless",
	[3]byte{0, 20, 127}:    "Thomson Telecom Belgium",
	[3]byte{0, 20, 128}:    "Hitachi-LG Data Storage Korea, Inc",
	[3]byte{0, 20, 129}:    "Multilink Inc",
	[3]byte{0, 20, 130}:    "Aurora Networks",
	[3]byte{0, 20, 131}:    "eXS Inc.",
	[3]byte{0, 20, 132}:    "Cermate Technologies Inc.",
	[3]byte{0, 20, 133}:    "Giga-Byte",
	[3]byte{0, 20, 134}:    "Echo Digital Audio Corporation",
	[3]byte{0, 20, 135}:    "American Technology Integrators",
	[3]byte{0, 20, 136}:    "Akorri",
	[3]byte{0, 20, 137}:    "B15402100 - JANDEI, S.L.",
	[3]byte{0, 20, 138}:    "Elin Ebg Traction Gmbh",
	[3]byte{0, 20, 139}:    "Globo Electronic GmbH & Co. KG",
	[3]byte{0, 20, 140}:    "Fortress Technologies",
	[3]byte{0, 20, 141}:    "Cubic Defense Simulation Systems",
	[3]byte{0, 20, 142}:    "Tele Power Inc.",
	[3]byte{0, 20, 143}:    "Protronic (Far East) Ltd.",
	[3]byte{0, 20, 144}:    "ASP Corporation",
	[3]byte{0, 20, 145}:    "Daniels Electronics Ltd. dbo Codan Rado Communications",
	[3]byte{0, 20, 146}:    "Liteon, Mobile Media Solution SBU",
	[3]byte{0, 20, 147}:    "Systimax Solutions",
	[3]byte{0, 20, 148}:    "ESU AG",
	[3]byte{0, 20, 149}:    "2Wire, Inc.",
	[3]byte{0, 20, 150}:    "Phonic Corp.",
	[3]byte{0, 20, 151}:    "ZHIYUAN Eletronics co.,ltd.",
	[3]byte{0, 20, 152}:    "Viking Design Technology",
	[3]byte{0, 20, 153}:    "Helicomm Inc",
	[3]byte{0, 20, 154}:    "ARRIS Group, Inc.",
	[3]byte{0, 20, 155}:    "Nokota Communications, LLC",
	[3]byte{0, 20, 156}:    "HF Company",
	[3]byte{0, 20, 157}:    "Sound ID Inc.",
	[3]byte{0, 20, 158}:    "UbONE Co., Ltd",
	[3]byte{0, 20, 159}:    "System and Chips, Inc.",
	[3]byte{0, 20, 160}:    "Accsense, Inc.",
	[3]byte{0, 20, 161}:    "Synchronous Communication Corp",
	[3]byte{0, 20, 162}:    "Core Micro Systems Inc.",
	[3]byte{0, 20, 163}:    "Vitelec BV",
	[3]byte{0, 20, 164}:    "Hon Hai Precision Ind. Co., Ltd.",
	[3]byte{0, 20, 165}:    "Gemtek Technology Co., Ltd.",
	[3]byte{0, 20, 166}:    "Teranetics, Inc.",
	[3]byte{0, 20, 167}:    "Nokia Danmark A/S",
	[3]byte{0, 20, 168}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 20, 169}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 20, 170}:    "Ashly Audio, Inc.",
	[3]byte{0, 20, 171}:    "Senhai Electronic Technology Co., Ltd.",
	[3]byte{0, 20, 172}:    "Bountiful WiFi",
	[3]byte{0, 20, 173}:    "Gassner Wiege- und Meßtechnik GmbH",
	[3]byte{0, 20, 174}:    "Wizlogics Co., Ltd.",
	[3]byte{0, 20, 175}:    "Datasym POS Inc.",
	[3]byte{0, 20, 176}:    "Naeil Community",
	[3]byte{0, 20, 177}:    "Avitec AB",
	[3]byte{0, 20, 178}:    "mCubelogics Corporation",
	[3]byte{0, 20, 179}:    "CoreStar International Corp",
	[3]byte{0, 20, 180}:    "General Dynamics United Kingdom Ltd",
	[3]byte{0, 20, 181}:    "PHYSIOMETRIX,INC",
	[3]byte{0, 20, 182}:    "Enswer Technology Inc.",
	[3]byte{0, 20, 183}:    "AR Infotek Inc.",
	[3]byte{0, 20, 184}:    "Hill-Rom",
	[3]byte{0, 20, 185}:    "MSTAR SEMICONDUCTOR",
	[3]byte{0, 20, 186}:    "Carvers SA de CV",
	[3]byte{0, 20, 187}:    "Open Interface North America",
	[3]byte{0, 20, 188}:    "SYNECTIC TELECOM EXPORTS PVT. LTD.",
	[3]byte{0, 20, 189}:    "incNETWORKS, Inc",
	[3]byte{0, 20, 190}:    "Wink communication technology CO.LTD",
	[3]byte{0, 20, 191}:    "Cisco-Linksys LLC",
	[3]byte{0, 20, 192}:    "Symstream Technology Group Ltd",
	[3]byte{0, 20, 193}:    "U.S. Robotics Corporation",
	[3]byte{0, 20, 194}:    "Hewlett-Packard Company",
	[3]byte{0, 20, 195}:    "Seagate Technology",
	[3]byte{0, 20, 196}:    "Vitelcom Mobile Technology",
	[3]byte{0, 20, 197}:    "Alive Technologies Pty Ltd",
	[3]byte{0, 20, 198}:    "Quixant Ltd",
	[3]byte{0, 20, 199}:    "Nortel",
	[3]byte{0, 20, 200}:    "Contemporary Research Corp",
	[3]byte{0, 20, 201}:    "Brocade Communications Systems, Inc.",
	[3]byte{0, 20, 202}:    "Key Radio Systems Limited",
	[3]byte{0, 20, 203}:    "LifeSync Corporation",
	[3]byte{0, 20, 204}:    "Zetec, Inc.",
	[3]byte{0, 20, 205}:    "DigitalZone Co., Ltd.",
	[3]byte{0, 20, 206}:    "NF CORPORATION",
	[3]byte{0, 20, 207}:    "INVISIO Communications",
	[3]byte{0, 20, 208}:    "BTI Systems Inc.",
	[3]byte{0, 20, 209}:    "TRENDnet",
	[3]byte{0, 20, 210}:    "Kyuden Technosystems Corporation",
	[3]byte{0, 20, 211}:    "SEPSA",
	[3]byte{0, 20, 212}:    "K Technology Corporation",
	[3]byte{0, 20, 213}:    "Datang Telecom Technology CO. , LCD,Optical Communication Br",
	[3]byte{0, 20, 214}:    "Jeongmin Electronics Co.,Ltd.",
	[3]byte{0, 20, 215}:    "Datastore Technology Corp",
	[3]byte{0, 20, 216}:    "bio-logic SA",
	[3]byte{0, 20, 217}:    "IP Fabrics, Inc.",
	[3]byte{0, 20, 218}:    "Huntleigh Healthcare",
	[3]byte{0, 20, 219}:    "Elma Trenew Electronic GmbH",
	[3]byte{0, 20, 220}:    "Communication System Design & Manufacturing (CSDM)",
	[3]byte{0, 20, 221}:    "Covergence Inc.",
	[3]byte{0, 20, 222}:    "Sage Instruments Inc.",
	[3]byte{0, 20, 223}:    "HI-P Tech Corporation",
	[3]byte{0, 20, 224}:    "LET'S Corporation",
	[3]byte{0, 20, 225}:    "Data Display AG",
	[3]byte{0, 20, 226}:    "datacom systems inc.",
	[3]byte{0, 20, 227}:    "mm-lab GmbH",
	[3]byte{0, 20, 228}:    "infinias, LLC",
	[3]byte{0, 20, 229}:    "Alticast",
	[3]byte{0, 20, 230}:    "AIM Infrarotmodule GmbH",
	[3]byte{0, 20, 231}:    "Stolinx,. Inc",
	[3]byte{0, 20, 232}:    "ARRIS Group, Inc.",
	[3]byte{0, 20, 233}:    "Nortech International",
	[3]byte{0, 20, 234}:    "S Digm Inc. (Safe Paradigm Inc.)",
	[3]byte{0, 20, 235}:    "AwarePoint Corporation",
	[3]byte{0, 20, 236}:    "Acro Telecom",
	[3]byte{0, 20, 237}:    "Airak, Inc.",
	[3]byte{0, 20, 238}:    "Western Digital Technologies, Inc.",
	[3]byte{0, 20, 239}:    "TZero Technologies, Inc.",
	[3]byte{0, 20, 240}:    "Business Security OL AB",
	[3]byte{0, 20, 241}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 20, 242}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 20, 243}:    "ViXS Systems Inc",
	[3]byte{0, 20, 244}:    "DekTec Digital Video B.V.",
	[3]byte{0, 20, 245}:    "OSI Security Devices",
	[3]byte{0, 20, 246}:    "Juniper Networks, Inc.",
	[3]byte{0, 20, 247}:    "CREVIS Co., LTD",
	[3]byte{0, 20, 248}:    "Scientific Atlanta",
	[3]byte{0, 20, 249}:    "Vantage Controls",
	[3]byte{0, 20, 250}:    "AsGa S.A.",
	[3]byte{0, 20, 251}:    "Technical Solutions Inc.",
	[3]byte{0, 20, 252}:    "Extandon, Inc.",
	[3]byte{0, 20, 253}:    "Thecus Technology Corp.",
	[3]byte{0, 20, 254}:    "Artech Electronics",
	[3]byte{0, 20, 255}:    "Precise Automation, Inc.",
	[3]byte{0, 21, 0}:      "Intel Corporate",
	[3]byte{0, 21, 1}:      "LexBox",
	[3]byte{0, 21, 2}:      "BETA tech",
	[3]byte{0, 21, 3}:      "PROFIcomms s.r.o.",
	[3]byte{0, 21, 4}:      "GAME PLUS CO., LTD.",
	[3]byte{0, 21, 5}:      "Actiontec Electronics, Inc",
	[3]byte{0, 21, 6}:      "Neo Photonics",
	[3]byte{0, 21, 7}:      "Renaissance Learning Inc",
	[3]byte{0, 21, 8}:      "Global Target Enterprise Inc",
	[3]byte{0, 21, 9}:      "Plus Technology Co., Ltd",
	[3]byte{0, 21, 10}:     "Sonoa Systems, Inc",
	[3]byte{0, 21, 11}:     "SAGE INFOTECH LTD.",
	[3]byte{0, 21, 12}:     "AVM GmbH",
	[3]byte{0, 21, 13}:     "Hoana Medical, Inc.",
	[3]byte{0, 21, 14}:     "OPENBRAIN TECHNOLOGIES CO., LTD.",
	[3]byte{0, 21, 15}:     "mingjong",
	[3]byte{0, 21, 16}:     "Techsphere Co., Ltd",
	[3]byte{0, 21, 17}:     "Data Center Systems",
	[3]byte{0, 21, 18}:     "Zurich University of Applied Sciences",
	[3]byte{0, 21, 19}:     "EFS sas",
	[3]byte{0, 21, 20}:     "Hu Zhou NAVA Networks&Electronics Ltd.",
	[3]byte{0, 21, 21}:     "Leipold+Co.GmbH",
	[3]byte{0, 21, 22}:     "URIEL SYSTEMS INC.",
	[3]byte{0, 21, 23}:     "Intel Corporate",
	[3]byte{0, 21, 24}:     "Shenzhen 10MOONS Technology Development CO.,Ltd",
	[3]byte{0, 21, 25}:     "StoreAge Networking Technologies",
	[3]byte{0, 21, 26}:     "Hunter Engineering Company",
	[3]byte{0, 21, 27}:     "Isilon Systems Inc.",
	[3]byte{0, 21, 28}:     "LENECO",
	[3]byte{0, 21, 29}:     "M2I CORPORATION",
	[3]byte{0, 21, 30}:     "Ethernet Powerlink Standardization Group (EPSG)",
	[3]byte{0, 21, 31}:     "Multivision Intelligent Surveillance (Hong Kong) Ltd",
	[3]byte{0, 21, 32}:     "Radiocrafts AS",
	[3]byte{0, 21, 33}:     "Horoquartz",
	[3]byte{0, 21, 34}:     "Dea Security",
	[3]byte{0, 21, 35}:     "Meteor Communications Corporation",
	[3]byte{0, 21, 36}:     "Numatics, Inc.",
	[3]byte{0, 21, 37}:     "Chamberlain Access Solutions",
	[3]byte{0, 21, 38}:     "Remote Technologies Inc",
	[3]byte{0, 21, 39}:     "Balboa Instruments",
	[3]byte{0, 21, 40}:     "Beacon Medical Products LLC d.b.a. BeaconMedaes",
	[3]byte{0, 21, 41}:     "N3 Corporation",
	[3]byte{0, 21, 42}:     "Nokia GmbH",
	[3]byte{0, 21, 43}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 21, 44}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 21, 45}:     "TenX Networks, LLC",
	[3]byte{0, 21, 46}:     "PacketHop, Inc.",
	[3]byte{0, 21, 47}:     "ARRIS Group, Inc.",
	[3]byte{0, 21, 48}:     "EMC Corporation",
	[3]byte{0, 21, 49}:     "KOCOM",
	[3]byte{0, 21, 50}:     "Consumer Technologies Group, LLC",
	[3]byte{0, 21, 51}:     "NADAM.CO.,LTD",
	[3]byte{0, 21, 52}:     "A Beltrónica-Companhia de Comunicações, Lda",
	[3]byte{0, 21, 53}:     "OTE Spa",
	[3]byte{0, 21, 54}:     "Powertech co.,Ltd",
	[3]byte{0, 21, 55}:     "Ventus Networks",
	[3]byte{0, 21, 56}:     "RFID, Inc.",
	[3]byte{0, 21, 57}:     "Technodrive SRL",
	[3]byte{0, 21, 58}:     "Shenzhen Syscan Technology Co.,Ltd.",
	[3]byte{0, 21, 59}:     "EMH metering GmbH & Co. KG",
	[3]byte{0, 21, 60}:     "Kprotech Co., Ltd.",
	[3]byte{0, 21, 61}:     "ELIM PRODUCT CO.",
	[3]byte{0, 21, 62}:     "Q-Matic Sweden AB",
	[3]byte{0, 21, 63}:     "Alcatel Alenia Space Italia",
	[3]byte{0, 21, 64}:     "Nortel",
	[3]byte{0, 21, 65}:     "StrataLight Communications, Inc.",
	[3]byte{0, 21, 66}:     "MICROHARD S.R.L.",
	[3]byte{0, 21, 67}:     "Aberdeen Test Center",
	[3]byte{0, 21, 68}:     "coM.s.a.t. AG",
	[3]byte{0, 21, 69}:     "SEECODE Co., Ltd.",
	[3]byte{0, 21, 70}:     "ITG Worldwide Sdn Bhd",
	[3]byte{0, 21, 71}:     "AiZen Solutions Inc.",
	[3]byte{0, 21, 72}:     "CUBE TECHNOLOGIES",
	[3]byte{0, 21, 73}:     "Dixtal Biomedica Ind. Com. Ltda",
	[3]byte{0, 21, 74}:     "WANSHIH ELECTRONIC CO., LTD",
	[3]byte{0, 21, 75}:     "Wonde Proud Technology Co., Ltd",
	[3]byte{0, 21, 76}:     "Saunders Electronics",
	[3]byte{0, 21, 77}:     "Netronome Systems, Inc.",
	[3]byte{0, 21, 78}:     "IEC",
	[3]byte{0, 21, 79}:     "one RF Technology",
	[3]byte{0, 21, 80}:     "Nits Technology Inc",
	[3]byte{0, 21, 81}:     "RadioPulse Inc.",
	[3]byte{0, 21, 82}:     "Wi-Gear Inc.",
	[3]byte{0, 21, 83}:     "Cytyc Corporation",
	[3]byte{0, 21, 84}:     "Atalum Wireless S.A.",
	[3]byte{0, 21, 85}:     "DFM GmbH",
	[3]byte{0, 21, 86}:     "SAGEM COMMUNICATION",
	[3]byte{0, 21, 87}:     "Olivetti",
	[3]byte{0, 21, 88}:     "FOXCONN",
	[3]byte{0, 21, 89}:     "Securaplane Technologies, Inc.",
	[3]byte{0, 21, 90}:     "DAINIPPON PHARMACEUTICAL CO., LTD.",
	[3]byte{0, 21, 91}:     "Sampo Corporation",
	[3]byte{0, 21, 92}:     "Dresser Wayne",
	[3]byte{0, 21, 93}:     "Microsoft Corporation",
	[3]byte{0, 21, 94}:     "Morgan Stanley",
	[3]byte{0, 21, 95}:     "GreenPeak Technologies",
	[3]byte{0, 21, 96}:     "Hewlett-Packard Company",
	[3]byte{0, 21, 97}:     "JJPlus Corporation",
	[3]byte{0, 21, 98}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 21, 99}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 21, 100}:    "BEHRINGER Spezielle Studiotechnik GmbH",
	[3]byte{0, 21, 101}:    "XIAMEN YEALINK NETWORK TECHNOLOGY CO.,LTD",
	[3]byte{0, 21, 102}:    "A-First Technology Co., Ltd.",
	[3]byte{0, 21, 103}:    "RADWIN Inc.",
	[3]byte{0, 21, 104}:    "Dilithium Networks",
	[3]byte{0, 21, 105}:    "PECO II, Inc.",
	[3]byte{0, 21, 106}:    "DG2L Technologies Pvt. Ltd.",
	[3]byte{0, 21, 107}:    "Perfisans Networks Corp.",
	[3]byte{0, 21, 108}:    "SANE SYSTEM CO., LTD",
	[3]byte{0, 21, 109}:    "Ubiquiti Networks Inc.",
	[3]byte{0, 21, 110}:    "A. W. Communication Systems Ltd",
	[3]byte{0, 21, 111}:    "Xiranet Communications GmbH",
	[3]byte{0, 21, 112}:    "Symbol TechnologiesWholly owned Subsidiary of Motorola",
	[3]byte{0, 21, 113}:    "Nolan Systems",
	[3]byte{0, 21, 114}:    "Red-Lemon",
	[3]byte{0, 21, 115}:    "NewSoft  Technology Corporation",
	[3]byte{0, 21, 116}:    "Horizon Semiconductors Ltd.",
	[3]byte{0, 21, 117}:    "Nevis Networks Inc.",
	[3]byte{0, 21, 118}:    "LABiTec - Labor Biomedical Technologies GmbH",
	[3]byte{0, 21, 119}:    "Allied Telesis",
	[3]byte{0, 21, 120}:    "Audio / Video Innovations",
	[3]byte{0, 21, 121}:    "Lunatone Industrielle Elektronik GmbH",
	[3]byte{0, 21, 122}:    "Telefin S.p.A.",
	[3]byte{0, 21, 123}:    "Leuze electronic GmbH + Co. KG",
	[3]byte{0, 21, 124}:    "Dave Networks, Inc.",
	[3]byte{0, 21, 125}:    "POSDATA CO., LTD.",
	[3]byte{0, 21, 126}:    "Weidmüller Interface GmbH & Co. KG",
	[3]byte{0, 21, 127}:    "ChuanG International Holding CO.,LTD.",
	[3]byte{0, 21, 128}:    "U-WAY CORPORATION",
	[3]byte{0, 21, 129}:    "MAKUS Inc.",
	[3]byte{0, 21, 130}:    "Pulse Eight Limited",
	[3]byte{0, 21, 131}:    "IVT corporation",
	[3]byte{0, 21, 132}:    "Schenck Process GmbH",
	[3]byte{0, 21, 133}:    "Aonvision Technolopy Corp.",
	[3]byte{0, 21, 134}:    "Xiamen Overseas Chinese Electronic Co., Ltd.",
	[3]byte{0, 21, 135}:    "Takenaka Seisakusho Co.,Ltd",
	[3]byte{0, 21, 136}:    "Salutica Allied Solutions Sdn Bhd",
	[3]byte{0, 21, 137}:    "D-MAX Technology Co.,Ltd",
	[3]byte{0, 21, 138}:    "SURECOM Technology Corp.",
	[3]byte{0, 21, 139}:    "Park Air Systems Ltd",
	[3]byte{0, 21, 140}:    "Liab ApS",
	[3]byte{0, 21, 141}:    "Jennic Ltd",
	[3]byte{0, 21, 142}:    "Plustek.INC",
	[3]byte{0, 21, 143}:    "NTT Advanced Technology Corporation",
	[3]byte{0, 21, 144}:    "Hectronic GmbH",
	[3]byte{0, 21, 145}:    "RLW Inc.",
	[3]byte{0, 21, 146}:    "Facom UK Ltd (Melksham)",
	[3]byte{0, 21, 147}:    "U4EA Technologies Inc.",
	[3]byte{0, 21, 148}:    "BIXOLON CO.,LTD",
	[3]byte{0, 21, 149}:    "Quester Tangent Corporation",
	[3]byte{0, 21, 150}:    "ARRIS International",
	[3]byte{0, 21, 151}:    "AETA AUDIO SYSTEMS",
	[3]byte{0, 21, 152}:    "Kolektor group",
	[3]byte{0, 21, 153}:    "Samsung Electronics Co., LTD",
	[3]byte{0, 21, 154}:    "ARRIS Group, Inc.",
	[3]byte{0, 21, 155}:    "Nortel",
	[3]byte{0, 21, 156}:    "B-KYUNG SYSTEM Co.,Ltd.",
	[3]byte{0, 21, 157}:    "Tripp Lite",
	[3]byte{0, 21, 158}:    "Mad Catz Interactive Inc",
	[3]byte{0, 21, 159}:    "Terascala, Inc.",
	[3]byte{0, 21, 160}:    "Nokia Danmark A/S",
	[3]byte{0, 21, 161}:    "ECA-SINTERS",
	[3]byte{0, 21, 162}:    "ARRIS International",
	[3]byte{0, 21, 163}:    "ARRIS International",
	[3]byte{0, 21, 164}:    "ARRIS International",
	[3]byte{0, 21, 165}:    "DCI Co., Ltd.",
	[3]byte{0, 21, 166}:    "Digital Electronics Products Ltd.",
	[3]byte{0, 21, 167}:    "Robatech AG",
	[3]byte{0, 21, 168}:    "ARRIS Group, Inc.",
	[3]byte{0, 21, 169}:    "KWANG WOO I&C CO.,LTD",
	[3]byte{0, 21, 170}:    "Rextechnik International Co.,",
	[3]byte{0, 21, 171}:    "PRO CO SOUND INC",
	[3]byte{0, 21, 172}:    "Capelon AB",
	[3]byte{0, 21, 173}:    "Accedian Networks",
	[3]byte{0, 21, 174}:    "kyung il",
	[3]byte{0, 21, 175}:    "AzureWave Technologies, Inc.",
	[3]byte{0, 21, 176}:    "AUTOTELENET CO.,LTD",
	[3]byte{0, 21, 177}:    "Ambient Corporation",
	[3]byte{0, 21, 178}:    "Advanced Industrial Computer, Inc.",
	[3]byte{0, 21, 179}:    "Caretech AB",
	[3]byte{0, 21, 180}:    "Polymap  Wireless LLC",
	[3]byte{0, 21, 181}:    "CI Network Corp.",
	[3]byte{0, 21, 182}:    "ShinMaywa Industries, Ltd.",
	[3]byte{0, 21, 183}:    "Toshiba",
	[3]byte{0, 21, 184}:    "Tahoe",
	[3]byte{0, 21, 185}:    "Samsung Electronics Co., Ltd.",
	[3]byte{0, 21, 186}:    "iba AG",
	[3]byte{0, 21, 187}:    "SMA Solar Technology AG",
	[3]byte{0, 21, 188}:    "Develco",
	[3]byte{0, 21, 189}:    "Group 4 Technology Ltd",
	[3]byte{0, 21, 190}:    "Iqua Ltd.",
	[3]byte{0, 21, 191}:    "technicob",
	[3]byte{0, 21, 192}:    "DIGITAL TELEMEDIA CO.,LTD.",
	[3]byte{0, 21, 193}:    "SONY Computer Entertainment inc,",
	[3]byte{0, 21, 194}:    "3M Germany",
	[3]byte{0, 21, 195}:    "Ruf Telematik AG",
	[3]byte{0, 21, 196}:    "FLOVEL CO., LTD.",
	[3]byte{0, 21, 197}:    "Dell Inc",
	[3]byte{0, 21, 198}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 21, 199}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 21, 200}:    "FlexiPanel Ltd",
	[3]byte{0, 21, 201}:    "Gumstix, Inc",
	[3]byte{0, 21, 202}:    "TeraRecon, Inc.",
	[3]byte{0, 21, 203}:    "Surf Communication Solutions Ltd.",
	[3]byte{0, 21, 204}:    "UQUEST, LTD.",
	[3]byte{0, 21, 205}:    "Exartech International Corp.",
	[3]byte{0, 21, 206}:    "ARRIS International",
	[3]byte{0, 21, 207}:    "ARRIS International",
	[3]byte{0, 21, 208}:    "ARRIS International",
	[3]byte{0, 21, 209}:    "ARRIS Group, Inc.",
	[3]byte{0, 21, 210}:    "Xantech Corporation",
	[3]byte{0, 21, 211}:    "Pantech&Curitel Communications, Inc.",
	[3]byte{0, 21, 212}:    "Emitor AB",
	[3]byte{0, 21, 213}:    "NICEVT",
	[3]byte{0, 21, 214}:    "OSLiNK Sp. z o.o.",
	[3]byte{0, 21, 215}:    "Reti Corporation",
	[3]byte{0, 21, 216}:    "Interlink Electronics",
	[3]byte{0, 21, 217}:    "PKC Electronics Oy",
	[3]byte{0, 21, 218}:    "IRITEL A.D.",
	[3]byte{0, 21, 219}:    "Canesta Inc.",
	[3]byte{0, 21, 220}:    "KT&C Co., Ltd.",
	[3]byte{0, 21, 221}:    "IP Control Systems Ltd.",
	[3]byte{0, 21, 222}:    "Nokia Danmark A/S",
	[3]byte{0, 21, 223}:    "Clivet S.p.A.",
	[3]byte{0, 21, 224}:    "Ericsson",
	[3]byte{0, 21, 225}:    "Picochip Ltd",
	[3]byte{0, 21, 226}:    "Dr.Ing. Herbert Knauer GmbH",
	[3]byte{0, 21, 227}:    "Dream Technologies Corporation",
	[3]byte{0, 21, 228}:    "Zimmer Elektromedizin",
	[3]byte{0, 21, 229}:    "Cheertek Inc.",
	[3]byte{0, 21, 230}:    "MOBILE TECHNIKA Inc.",
	[3]byte{0, 21, 231}:    "Quantec Tontechnik",
	[3]byte{0, 21, 232}:    "Nortel",
	[3]byte{0, 21, 233}:    "D-Link Corporation",
	[3]byte{0, 21, 234}:    "Tellumat (Pty) Ltd",
	[3]byte{0, 21, 235}:    "ZTE CORPORATION",
	[3]byte{0, 21, 236}:    "Boca Devices LLC",
	[3]byte{0, 21, 237}:    "Fulcrum Microsystems, Inc.",
	[3]byte{0, 21, 238}:    "Omnex Control Systems",
	[3]byte{0, 21, 239}:    "NEC TOKIN Corporation",
	[3]byte{0, 21, 240}:    "EGO BV",
	[3]byte{0, 21, 241}:    "KYLINK Communications Corp.",
	[3]byte{0, 21, 242}:    "ASUSTek COMPUTER INC.",
	[3]byte{0, 21, 243}:    "PELTOR AB",
	[3]byte{0, 21, 244}:    "Eventide",
	[3]byte{0, 21, 245}:    "Sustainable Energy Systems",
	[3]byte{0, 21, 246}:    "SCIENCE AND ENGINEERING SERVICES, INC.",
	[3]byte{0, 21, 247}:    "Wintecronics Ltd.",
	[3]byte{0, 21, 248}:    "Kingtronics Industrial Co. Ltd.",
	[3]byte{0, 21, 249}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 21, 250}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 21, 251}:    "setex schermuly textile computer gmbh",
	[3]byte{0, 21, 252}:    "Littelfuse Startco",
	[3]byte{0, 21, 253}:    "Complete Media Systems",
	[3]byte{0, 21, 254}:    "SCHILLING ROBOTICS LLC",
	[3]byte{0, 21, 255}:    "Novatel Wireless, Inc.",
	[3]byte{0, 22, 0}:      "CelleBrite Mobile Synchronization",
	[3]byte{0, 22, 1}:      "Buffalo Inc.",
	[3]byte{0, 22, 2}:      "CEYON TECHNOLOGY CO.,LTD.",
	[3]byte{0, 22, 3}:      "COOLKSKY Co., LTD",
	[3]byte{0, 22, 4}:      "Sigpro",
	[3]byte{0, 22, 5}:      "YORKVILLE SOUND INC.",
	[3]byte{0, 22, 6}:      "Ideal Industries",
	[3]byte{0, 22, 7}:      "Curves International Inc.",
	[3]byte{0, 22, 8}:      "Sequans Communications",
	[3]byte{0, 22, 9}:      "Unitech electronics co., ltd.",
	[3]byte{0, 22, 10}:     "SWEEX Europe BV",
	[3]byte{0, 22, 11}:     "TVWorks LLC",
	[3]byte{0, 22, 12}:     "LPL  DEVELOPMENT S.A. DE C.V",
	[3]byte{0, 22, 13}:     "Be Here Corporation",
	[3]byte{0, 22, 14}:     "Optica Technologies Inc.",
	[3]byte{0, 22, 15}:     "BADGER METER INC",
	[3]byte{0, 22, 16}:     "Carina Technology",
	[3]byte{0, 22, 17}:     "Altecon Srl",
	[3]byte{0, 22, 18}:     "Otsuka Electronics Co., Ltd.",
	[3]byte{0, 22, 19}:     "LibreStream Technologies Inc.",
	[3]byte{0, 22, 20}:     "Picosecond Pulse Labs",
	[3]byte{0, 22, 21}:     "Nittan Company, Limited",
	[3]byte{0, 22, 22}:     "BROWAN COMMUNICATION INC.",
	[3]byte{0, 22, 23}:     "MSI",
	[3]byte{0, 22, 24}:     "HIVION Co., Ltd.",
	[3]byte{0, 22, 25}:     "Lancelan Technologies S.L.",
	[3]byte{0, 22, 26}:     "Dametric AB",
	[3]byte{0, 22, 27}:     "Micronet Corporation",
	[3]byte{0, 22, 28}:     "e:cue",
	[3]byte{0, 22, 29}:     "Innovative Wireless Technologies, Inc.",
	[3]byte{0, 22, 30}:     "Woojinnet",
	[3]byte{0, 22, 31}:     "SUNWAVETEC Co., Ltd.",
	[3]byte{0, 22, 32}:     "Sony Ericsson Mobile Communications AB",
	[3]byte{0, 22, 33}:     "Colorado Vnet",
	[3]byte{0, 22, 34}:     "BBH SYSTEMS GMBH",
	[3]byte{0, 22, 35}:     "Interval Media",
	[3]byte{0, 22, 36}:     "Teneros, Inc.",
	[3]byte{0, 22, 37}:     "Impinj, Inc.",
	[3]byte{0, 22, 38}:     "ARRIS Group, Inc.",
	[3]byte{0, 22, 39}:     "embedded-logic DESIGN AND MORE GmbH",
	[3]byte{0, 22, 40}:     "Ultra Electronics Manufacturing and Card Systems",
	[3]byte{0, 22, 41}:     "Nivus GmbH",
	[3]byte{0, 22, 42}:     "Antik computers & communications s.r.o.",
	[3]byte{0, 22, 43}:     "Togami Electric Mfg.co.,Ltd.",
	[3]byte{0, 22, 44}:     "Xanboo",
	[3]byte{0, 22, 45}:     "STNet Co., Ltd.",
	[3]byte{0, 22, 46}:     "Space Shuttle Hi-Tech Co., Ltd.",
	[3]byte{0, 22, 47}:     "Geutebrück GmbH",
	[3]byte{0, 22, 48}:     "Vativ Technologies",
	[3]byte{0, 22, 49}:     "Xteam",
	[3]byte{0, 22, 50}:     "SAMSUNG ELECTRONICS CO., LTD.",
	[3]byte{0, 22, 51}:     "Oxford Diagnostics Ltd.",
	[3]byte{0, 22, 52}:     "Mathtech, Inc.",
	[3]byte{0, 22, 53}:     "Hewlett-Packard Company",
	[3]byte{0, 22, 54}:     "Quanta Computer Inc.",
	[3]byte{0, 22, 55}:     "CITEL SpA",
	[3]byte{0, 22, 56}:     "TECOM Co., Ltd.",
	[3]byte{0, 22, 57}:     "UBIQUAM Co.,Ltd",
	[3]byte{0, 22, 58}:     "YVES TECHNOLOGY CO., LTD.",
	[3]byte{0, 22, 59}:     "VertexRSI/General Dynamics",
	[3]byte{0, 22, 60}:     "Rebox B.V.",
	[3]byte{0, 22, 61}:     "Tsinghua Tongfang Legend Silicon Tech. Co., Ltd.",
	[3]byte{0, 22, 62}:     "Xensource, Inc.",
	[3]byte{0, 22, 63}:     "CReTE SYSTEMS Inc.",
	[3]byte{0, 22, 64}:     "Asmobile Communication Inc.",
	[3]byte{0, 22, 65}:     "Universal Global Scientific Industrial Co., Ltd.",
	[3]byte{0, 22, 66}:     "Pangolin",
	[3]byte{0, 22, 67}:     "Sunhillo Corporation",
	[3]byte{0, 22, 68}:     "LITE-ON Technology Corp.",
	[3]byte{0, 22, 69}:     "Power Distribution, Inc.",
	[3]byte{0, 22, 70}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 22, 71}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 22, 72}:     "SSD Company Limited",
	[3]byte{0, 22, 73}:     "SetOne GmbH",
	[3]byte{0, 22, 74}:     "Vibration Technology Limited",
	[3]byte{0, 22, 75}:     "Quorion Data Systems GmbH",
	[3]byte{0, 22, 76}:     "PLANET INT Co., Ltd",
	[3]byte{0, 22, 77}:     "Alcatel North America IP Division",
	[3]byte{0, 22, 78}:     "Nokia Danmark A/S",
	[3]byte{0, 22, 79}:     "World Ethnic Broadcastin Inc.",
	[3]byte{0, 22, 80}:     "Herley General Microwave Israel.",
	[3]byte{0, 22, 81}:     "Exeo Systems",
	[3]byte{0, 22, 82}:     "Hoatech Technologies, Inc.",
	[3]byte{0, 22, 83}:     "LEGO System A/S IE Electronics Division",
	[3]byte{0, 22, 84}:     "Flex-P Industries Sdn. Bhd.",
	[3]byte{0, 22, 85}:     "FUHO TECHNOLOGY Co., LTD",
	[3]byte{0, 22, 86}:     "Nintendo Co., Ltd.",
	[3]byte{0, 22, 87}:     "Aegate Ltd",
	[3]byte{0, 22, 88}:     "Fusiontech Technologies Inc.",
	[3]byte{0, 22, 89}:     "Z.M.P. RADWAG",
	[3]byte{0, 22, 90}:     "Harman Specialty Group",
	[3]byte{0, 22, 91}:     "Grip Audio",
	[3]byte{0, 22, 92}:     "Trackflow Ltd",
	[3]byte{0, 22, 93}:     "AirDefense, Inc.",
	[3]byte{0, 22, 94}:     "Precision I/O",
	[3]byte{0, 22, 95}:     "Fairmount Automation",
	[3]byte{0, 22, 96}:     "Nortel",
	[3]byte{0, 22, 97}:     "Novatium Solutions (P) Ltd",
	[3]byte{0, 22, 98}:     "Liyuh Technology Ltd.",
	[3]byte{0, 22, 99}:     "KBT Mobile",
	[3]byte{0, 22, 100}:    "Prod-El SpA",
	[3]byte{0, 22, 101}:    "Cellon France",
	[3]byte{0, 22, 102}:    "Quantier Communication Inc.",
	[3]byte{0, 22, 103}:    "A-TEC Subsystem INC.",
	[3]byte{0, 22, 104}:    "Eishin Electronics",
	[3]byte{0, 22, 105}:    "MRV Communication (Networks) LTD",
	[3]byte{0, 22, 106}:    "TPS",
	[3]byte{0, 22, 107}:    "Samsung Electronics",
	[3]byte{0, 22, 108}:    "Samsung Electonics Digital Video System Division",
	[3]byte{0, 22, 109}:    "Yulong Computer Telecommunication Scientific(shenzhen)Co.,Lt",
	[3]byte{0, 22, 110}:    "Arbitron Inc.",
	[3]byte{0, 22, 111}:    "Intel Corporate",
	[3]byte{0, 22, 112}:    "SKNET Corporation",
	[3]byte{0, 22, 113}:    "Symphox Information Co.",
	[3]byte{0, 22, 114}:    "Zenway enterprise ltd",
	[3]byte{0, 22, 115}:    "Bury GmbH & Co. KG",
	[3]byte{0, 22, 116}:    "EuroCB (Phils.), Inc.",
	[3]byte{0, 22, 117}:    "ARRIS Group, Inc.",
	[3]byte{0, 22, 118}:    "Intel Corporate",
	[3]byte{0, 22, 119}:    "Bihl + Wiedemann GmbH",
	[3]byte{0, 22, 120}:    "SHENZHEN BAOAN GAOKE ELECTRONICS CO., LTD",
	[3]byte{0, 22, 121}:    "eOn Communications",
	[3]byte{0, 22, 122}:    "Skyworth Overseas Dvelopment Ltd.",
	[3]byte{0, 22, 123}:    "Haver&Boecker",
	[3]byte{0, 22, 124}:    "iRex Technologies BV",
	[3]byte{0, 22, 125}:    "Sky-Line Information Co., Ltd.",
	[3]byte{0, 22, 126}:    "DIBOSS.CO.,LTD",
	[3]byte{0, 22, 127}:    "Bluebird Soft Inc.",
	[3]byte{0, 22, 128}:    "Bally Gaming + Systems",
	[3]byte{0, 22, 129}:    "Vector Informatik GmbH",
	[3]byte{0, 22, 130}:    "Pro Dex, Inc",
	[3]byte{0, 22, 131}:    "WEBIO International Co.,.Ltd.",
	[3]byte{0, 22, 132}:    "Donjin Co.,Ltd.",
	[3]byte{0, 22, 133}:    "Elisa Oyj",
	[3]byte{0, 22, 134}:    "Karl Storz Imaging",
	[3]byte{0, 22, 135}:    "Chubb CSC-Vendor AP",
	[3]byte{0, 22, 136}:    "ServerEngines LLC",
	[3]byte{0, 22, 137}:    "Pilkor Electronics Co., Ltd",
	[3]byte{0, 22, 138}:    "id-Confirm Inc",
	[3]byte{0, 22, 139}:    "Paralan Corporation",
	[3]byte{0, 22, 140}:    "DSL Partner AS",
	[3]byte{0, 22, 141}:    "KORWIN CO., Ltd.",
	[3]byte{0, 22, 142}:    "Vimicro corporation",
	[3]byte{0, 22, 143}:    "GN Netcom as",
	[3]byte{0, 22, 144}:    "J-TEK INCORPORATION",
	[3]byte{0, 22, 145}:    "Moser-Baer AG",
	[3]byte{0, 22, 146}:    "Scientific-Atlanta, Inc.",
	[3]byte{0, 22, 147}:    "PowerLink Technology Inc.",
	[3]byte{0, 22, 148}:    "Sennheiser Communications A/S",
	[3]byte{0, 22, 149}:    "AVC Technology (International) Limited",
	[3]byte{0, 22, 150}:    "QDI Technology (H.K.) Limited",
	[3]byte{0, 22, 151}:    "NEC Corporation",
	[3]byte{0, 22, 152}:    "T&A Mobile Phones",
	[3]byte{0, 22, 153}:    "Tonic DVB Marketing Ltd",
	[3]byte{0, 22, 154}:    "Quadrics Ltd",
	[3]byte{0, 22, 155}:    "Alstom Transport",
	[3]byte{0, 22, 156}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 22, 157}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 22, 158}:    "TV One Ltd",
	[3]byte{0, 22, 159}:    "Vimtron Electronics Co., Ltd.",
	[3]byte{0, 22, 160}:    "Auto-Maskin",
	[3]byte{0, 22, 161}:    "3Leaf Networks",
	[3]byte{0, 22, 162}:    "CentraLite Systems, Inc.",
	[3]byte{0, 22, 163}:    "Ingeteam Transmission&Distribution, S.A.",
	[3]byte{0, 22, 164}:    "Ezurio Ltd",
	[3]byte{0, 22, 165}:    "Tandberg Storage ASA",
	[3]byte{0, 22, 166}:    "Dovado FZ-LLC",
	[3]byte{0, 22, 167}:    "AWETA G&P",
	[3]byte{0, 22, 168}:    "CWT CO., LTD.",
	[3]byte{0, 22, 169}:    "2EI",
	[3]byte{0, 22, 170}:    "Kei Communication Technology Inc.",
	[3]byte{0, 22, 171}:    "Dansensor A/S",
	[3]byte{0, 22, 172}:    "Toho Technology Corp.",
	[3]byte{0, 22, 173}:    "BT-Links Company Limited",
	[3]byte{0, 22, 174}:    "INVENTEL",
	[3]byte{0, 22, 175}:    "Shenzhen Union Networks Equipment Co.,Ltd.",
	[3]byte{0, 22, 176}:    "VK Corporation",
	[3]byte{0, 22, 177}:    "KBS",
	[3]byte{0, 22, 178}:    "DriveCam Inc",
	[3]byte{0, 22, 179}:    "Photonicbridges (China) Co., Ltd.",
	[3]byte{0, 22, 180}:    "PRIVATE",
	[3]byte{0, 22, 181}:    "ARRIS Group, Inc.",
	[3]byte{0, 22, 182}:    "Cisco-Linksys",
	[3]byte{0, 22, 183}:    "Seoul Commtech",
	[3]byte{0, 22, 184}:    "Sony Ericsson Mobile Communications",
	[3]byte{0, 22, 185}:    "ProCurve Networking",
	[3]byte{0, 22, 186}:    "WEATHERNEWS INC.",
	[3]byte{0, 22, 187}:    "Law-Chain Computer Technology Co Ltd",
	[3]byte{0, 22, 188}:    "Nokia Danmark A/S",
	[3]byte{0, 22, 189}:    "ATI Industrial Automation",
	[3]byte{0, 22, 190}:    "INFRANET, Inc.",
	[3]byte{0, 22, 191}:    "PaloDEx Group Oy",
	[3]byte{0, 22, 192}:    "Semtech Corporation",
	[3]byte{0, 22, 193}:    "Eleksen Ltd",
	[3]byte{0, 22, 194}:    "Avtec Systems Inc",
	[3]byte{0, 22, 195}:    "BA Systems Inc",
	[3]byte{0, 22, 196}:    "SiRF Technology, Inc.",
	[3]byte{0, 22, 197}:    "Shenzhen Xing Feng Industry Co.,Ltd",
	[3]byte{0, 22, 198}:    "North Atlantic Industries",
	[3]byte{0, 22, 199}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 22, 200}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 22, 201}:    "NAT Seattle, Inc.",
	[3]byte{0, 22, 202}:    "Nortel",
	[3]byte{0, 22, 203}:    "Apple",
	[3]byte{0, 22, 204}:    "Xcute Mobile Corp.",
	[3]byte{0, 22, 205}:    "HIJI HIGH-TECH CO., LTD.",
	[3]byte{0, 22, 206}:    "Hon Hai Precision Ind. Co., Ltd.",
	[3]byte{0, 22, 207}:    "Hon Hai Precision Ind. Co., Ltd.",
	[3]byte{0, 22, 208}:    "ATech elektronika d.o.o.",
	[3]byte{0, 22, 209}:    "ZAT a.s.",
	[3]byte{0, 22, 210}:    "Caspian",
	[3]byte{0, 22, 211}:    "Wistron Corporation",
	[3]byte{0, 22, 212}:    "Compal Communications, Inc.",
	[3]byte{0, 22, 213}:    "Synccom Co., Ltd",
	[3]byte{0, 22, 214}:    "TDA Tech Pty Ltd",
	[3]byte{0, 22, 215}:    "Sunways AG",
	[3]byte{0, 22, 216}:    "Senea AB",
	[3]byte{0, 22, 217}:    "NINGBO BIRD CO.,LTD.",
	[3]byte{0, 22, 218}:    "Futronic Technology Co. Ltd.",
	[3]byte{0, 22, 219}:    "Samsung Electronics Co., Ltd.",
	[3]byte{0, 22, 220}:    "ARCHOS",
	[3]byte{0, 22, 221}:    "Gigabeam Corporation",
	[3]byte{0, 22, 222}:    "FAST Inc",
	[3]byte{0, 22, 223}:    "Lundinova AB",
	[3]byte{0, 22, 224}:    "3Com Ltd",
	[3]byte{0, 22, 225}:    "SiliconStor, Inc.",
	[3]byte{0, 22, 226}:    "American Fibertek, Inc.",
	[3]byte{0, 22, 227}:    "ASKEY COMPUTER CORP.",
	[3]byte{0, 22, 228}:    "VANGUARD SECURITY ENGINEERING CORP.",
	[3]byte{0, 22, 229}:    "FORDLEY DEVELOPMENT LIMITED",
	[3]byte{0, 22, 230}:    "GIGA-BYTE TECHNOLOGY CO.,LTD.",
	[3]byte{0, 22, 231}:    "Dynamix Promotions Limited",
	[3]byte{0, 22, 232}:    "Sigma Designs, Inc.",
	[3]byte{0, 22, 233}:    "Tiba Medical Inc",
	[3]byte{0, 22, 234}:    "Intel Corporate",
	[3]byte{0, 22, 235}:    "Intel Corporate",
	[3]byte{0, 22, 236}:    "Elitegroup Computer Systems Co., Ltd.",
	[3]byte{0, 22, 237}:    "Digital Safety Technologies, Inc",
	[3]byte{0, 22, 238}:    "RoyalDigital Inc.",
	[3]byte{0, 22, 239}:    "Koko Fitness, Inc.",
	[3]byte{0, 22, 240}:    "Dell",
	[3]byte{0, 22, 241}:    "OmniSense, LLC",
	[3]byte{0, 22, 242}:    "Dmobile System Co., Ltd.",
	[3]byte{0, 22, 243}:    "CAST Information Co., Ltd",
	[3]byte{0, 22, 244}:    "Eidicom Co., Ltd.",
	[3]byte{0, 22, 245}:    "Dalian Golden Hualu Digital Technology Co.,Ltd",
	[3]byte{0, 22, 246}:    "Video Products Group",
	[3]byte{0, 22, 247}:    "L-3 Communications, Aviation Recorders",
	[3]byte{0, 22, 248}:    "AVIQTECH TECHNOLOGY CO., LTD.",
	[3]byte{0, 22, 249}:    "CETRTA POT, d.o.o., Kranj",
	[3]byte{0, 22, 250}:    "ECI Telecom Ltd.",
	[3]byte{0, 22, 251}:    "SHENZHEN MTC CO.,LTD.",
	[3]byte{0, 22, 252}:    "TOHKEN CO.,LTD.",
	[3]byte{0, 22, 253}:    "Jaty Electronics",
	[3]byte{0, 22, 254}:    "Alps Electric Co., Ltd",
	[3]byte{0, 22, 255}:    "Wamin Optocomm Mfg Corp",
	[3]byte{0, 23, 0}:      "ARRIS Group, Inc.",
	[3]byte{0, 23, 1}:      "KDE, Inc.",
	[3]byte{0, 23, 2}:      "Osung Midicom Co., Ltd",
	[3]byte{0, 23, 3}:      "MOSDAN Internation Co.,Ltd",
	[3]byte{0, 23, 4}:      "Shinco Electronics Group Co.,Ltd",
	[3]byte{0, 23, 5}:      "Methode Electronics",
	[3]byte{0, 23, 6}:      "Techfaith Wireless Communication Technology Limited.",
	[3]byte{0, 23, 7}:      "InGrid, Inc",
	[3]byte{0, 23, 8}:      "Hewlett-Packard Company",
	[3]byte{0, 23, 9}:      "Exalt Communications",
	[3]byte{0, 23, 10}:     "INEW DIGITAL COMPANY",
	[3]byte{0, 23, 11}:     "Contela, Inc.",
	[3]byte{0, 23, 12}:     "Twig Com Ltd.",
	[3]byte{0, 23, 13}:     "Dust Networks Inc.",
	[3]byte{0, 23, 14}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 23, 15}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 23, 16}:     "Casa Systems Inc.",
	[3]byte{0, 23, 17}:     "GE Healthcare Bio-Sciences AB",
	[3]byte{0, 23, 18}:     "ISCO International",
	[3]byte{0, 23, 19}:     "Tiger NetCom",
	[3]byte{0, 23, 20}:     "BR Controls Nederland bv",
	[3]byte{0, 23, 21}:     "Qstik",
	[3]byte{0, 23, 22}:     "Qno Technology Inc.",
	[3]byte{0, 23, 23}:     "Leica Geosystems AG",
	[3]byte{0, 23, 24}:     "Vansco Electronics Oy",
	[3]byte{0, 23, 25}:     "AudioCodes USA, Inc",
	[3]byte{0, 23, 26}:     "Winegard Company",
	[3]byte{0, 23, 27}:     "Innovation Lab Corp.",
	[3]byte{0, 23, 28}:     "NT MicroSystems, Inc.",
	[3]byte{0, 23, 29}:     "DIGIT",
	[3]byte{0, 23, 30}:     "Theo Benning GmbH & Co. KG",
	[3]byte{0, 23, 31}:     "IMV Corporation",
	[3]byte{0, 23, 32}:     "Image Sensing Systems, Inc.",
	[3]byte{0, 23, 33}:     "FITRE S.p.A.",
	[3]byte{0, 23, 34}:     "Hanazeder Electronic GmbH",
	[3]byte{0, 23, 35}:     "Summit Data Communications",
	[3]byte{0, 23, 36}:     "Studer Professional Audio GmbH",
	[3]byte{0, 23, 37}:     "Liquid Computing",
	[3]byte{0, 23, 38}:     "m2c Electronic Technology Ltd.",
	[3]byte{0, 23, 39}:     "Thermo Ramsey Italia s.r.l.",
	[3]byte{0, 23, 40}:     "Selex Communications",
	[3]byte{0, 23, 41}:     "Ubicod Co.LTD",
	[3]byte{0, 23, 42}:     "Proware Technology Corp.(By Unifosa)",
	[3]byte{0, 23, 43}:     "Global Technologies Inc.",
	[3]byte{0, 23, 44}:     "TAEJIN INFOTECH",
	[3]byte{0, 23, 45}:     "Axcen Photonics Corporation",
	[3]byte{0, 23, 46}:     "FXC Inc.",
	[3]byte{0, 23, 47}:     "NeuLion Incorporated",
	[3]byte{0, 23, 48}:     "Automation Electronics",
	[3]byte{0, 23, 49}:     "ASUSTek COMPUTER INC.",
	[3]byte{0, 23, 50}:     "Science-Technical Center \"RISSA\"",
	[3]byte{0, 23, 51}:     "SFR",
	[3]byte{0, 23, 52}:     "ADC Telecommunications",
	[3]byte{0, 23, 53}:     "PRIVATE",
	[3]byte{0, 23, 54}:     "iiTron Inc.",
	[3]byte{0, 23, 55}:     "Industrie Dial Face S.p.A.",
	[3]byte{0, 23, 56}:     "International Business Machines",
	[3]byte{0, 23, 57}:     "Bright Headphone Electronics Company",
	[3]byte{0, 23, 58}:     "Reach Systems Inc.",
	[3]byte{0, 23, 59}:     "Cisco Systems, Inc.",
	[3]byte{0, 23, 60}:     "Extreme Engineering Solutions",
	[3]byte{0, 23, 61}:     "Neology",
	[3]byte{0, 23, 62}:     "LeucotronEquipamentos Ltda.",
	[3]byte{0, 23, 63}:     "Belkin Corporation",
	[3]byte{0, 23, 64}:     "Bluberi Gaming Technologies Inc",
	[3]byte{0, 23, 65}:     "DEFIDEV",
	[3]byte{0, 23, 66}:     "FUJITSU LIMITED",
	[3]byte{0, 23, 67}:     "Deck Srl",
	[3]byte{0, 23, 68}:     "Araneo Ltd.",
	[3]byte{0, 23, 69}:     "INNOTZ CO., Ltd",
	[3]byte{0, 23, 70}:     "Freedom9 Inc.",
	[3]byte{0, 23, 71}:     "Trimble",
	[3]byte{0, 23, 72}:     "Neokoros Brasil Ltda",
	[3]byte{0, 23, 73}:     "HYUNDAE YONG-O-SA CO.,LTD",
	[3]byte{0, 23, 74}:     "SOCOMEC",
	[3]byte{0, 23, 75}:     "Nokia Danmark A/S",
	[3]byte{0, 23, 76}:     "Millipore",
	[3]byte{0, 23, 77}:     "DYNAMIC NETWORK FACTORY, INC.",
	[3]byte{0, 23, 78}:     "Parama-tech Co.,Ltd.",
	[3]byte{0, 23, 79}:     "iCatch Inc.",
	[3]byte{0, 23, 80}:     "GSI Group, MicroE Systems",
	[3]byte{0, 23, 81}:     "Online Corporation",
	[3]byte{0, 23, 82}:     "DAGS, Inc",
	[3]byte{0, 23, 83}:     "nFore Technology Inc.",
	[3]byte{0, 23, 84}:     "Arkino HiTOP Corporation Limited",
	[3]byte{0, 23, 85}:     "GE Security",
	[3]byte{0, 23, 86}:     "Vinci Labs Oy",
	[3]byte{0, 23, 87}:     "RIX TECHNOLOGY LIMITED",
	[3]byte{0, 23, 88}:     "ThruVision Ltd",
	[3]byte{0, 23, 89}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 23, 90}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 23, 91}:     "ACS Solutions Switzerland Ltd.",
	[3]byte{0, 23, 92}:     "SHARP CORPORATION",
	[3]byte{0, 23, 93}:     "Dongseo system.",
	[3]byte{0, 23, 94}:     "Zed-3",
	[3]byte{0, 23, 95}:     "XENOLINK Communications Co., Ltd.",
	[3]byte{0, 23, 96}:     "Naito Densei Machida MFG.CO.,LTD",
	[3]byte{0, 23, 97}:     "PRIVATE",
	[3]byte{0, 23, 98}:     "Solar Technology, Inc.",
	[3]byte{0, 23, 99}:     "Essentia S.p.A.",
	[3]byte{0, 23, 100}:    "ATMedia GmbH",
	[3]byte{0, 23, 101}:    "Nortel",
	[3]byte{0, 23, 102}:    "Accense Technology, Inc.",
	[3]byte{0, 23, 103}:    "Earforce AS",
	[3]byte{0, 23, 104}:    "Zinwave Ltd",
	[3]byte{0, 23, 105}:    "Cymphonix Corp",
	[3]byte{0, 23, 106}:    "Avago Technologies",
	[3]byte{0, 23, 107}:    "Kiyon, Inc.",
	[3]byte{0, 23, 108}:    "Pivot3, Inc.",
	[3]byte{0, 23, 109}:    "CORE CORPORATION",
	[3]byte{0, 23, 110}:    "DUCATI SISTEMI",
	[3]byte{0, 23, 111}:    "PAX Computer Technology(Shenzhen) Ltd.",
	[3]byte{0, 23, 112}:    "Arti Industrial Electronics Ltd.",
	[3]byte{0, 23, 113}:    "APD Communications Ltd",
	[3]byte{0, 23, 114}:    "ASTRO Strobel Kommunikationssysteme GmbH",
	[3]byte{0, 23, 115}:    "Laketune Technologies Co. Ltd",
	[3]byte{0, 23, 116}:    "Elesta GmbH",
	[3]byte{0, 23, 117}:    "TTE Germany GmbH",
	[3]byte{0, 23, 118}:    "Meso Scale Diagnostics, LLC",
	[3]byte{0, 23, 119}:    "Obsidian Research Corporation",
	[3]byte{0, 23, 120}:    "Central Music Co.",
	[3]byte{0, 23, 121}:    "QuickTel",
	[3]byte{0, 23, 122}:    "ASSA ABLOY AB",
	[3]byte{0, 23, 123}:    "Azalea Networks inc",
	[3]byte{0, 23, 124}:    "Smartlink Network Systems Limited",
	[3]byte{0, 23, 125}:    "IDT International Limited",
	[3]byte{0, 23, 126}:    "Meshcom Technologies Inc.",
	[3]byte{0, 23, 127}:    "Worldsmart Retech",
	[3]byte{0, 23, 128}:    "Applied Biosystems B.V.",
	[3]byte{0, 23, 129}:    "Greystone Data System, Inc.",
	[3]byte{0, 23, 130}:    "LoBenn Inc.",
	[3]byte{0, 23, 131}:    "Texas Instruments",
	[3]byte{0, 23, 132}:    "ARRIS Group, Inc.",
	[3]byte{0, 23, 133}:    "Sparr Electronics Ltd",
	[3]byte{0, 23, 134}:    "wisembed",
	[3]byte{0, 23, 135}:    "Brother, Brother & Sons ApS",
	[3]byte{0, 23, 136}:    "Philips Lighting BV",
	[3]byte{0, 23, 137}:    "Zenitron Corporation",
	[3]byte{0, 23, 138}:    "DARTS TECHNOLOGIES CORP.",
	[3]byte{0, 23, 139}:    "Teledyne Technologies Incorporated",
	[3]byte{0, 23, 140}:    "Independent Witness, Inc",
	[3]byte{0, 23, 141}:    "Checkpoint Systems, Inc.",
	[3]byte{0, 23, 142}:    "Gunnebo Cash Automation AB",
	[3]byte{0, 23, 143}:    "NINGBO YIDONG ELECTRONIC CO.,LTD.",
	[3]byte{0, 23, 144}:    "HYUNDAI DIGITECH Co, Ltd.",
	[3]byte{0, 23, 145}:    "LinTech GmbH",
	[3]byte{0, 23, 146}:    "Falcom Wireless Comunications Gmbh",
	[3]byte{0, 23, 147}:    "Tigi Corporation",
	[3]byte{0, 23, 148}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 23, 149}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 23, 150}:    "Rittmeyer AG",
	[3]byte{0, 23, 151}:    "Telsy Elettronica S.p.A.",
	[3]byte{0, 23, 152}:    "Azonic Technology Co., LTD",
	[3]byte{0, 23, 153}:    "SmarTire Systems Inc.",
	[3]byte{0, 23, 154}:    "D-Link Corporation",
	[3]byte{0, 23, 155}:    "Chant Sincere CO., LTD.",
	[3]byte{0, 23, 156}:    "DEPRAG SCHULZ GMBH u. CO.",
	[3]byte{0, 23, 157}:    "Kelman Limited",
	[3]byte{0, 23, 158}:    "Sirit Inc",
	[3]byte{0, 23, 159}:    "Apricorn",
	[3]byte{0, 23, 160}:    "RoboTech srl",
	[3]byte{0, 23, 161}:    "3soft inc.",
	[3]byte{0, 23, 162}:    "Camrivox Ltd.",
	[3]byte{0, 23, 163}:    "MIX s.r.l.",
	[3]byte{0, 23, 164}:    "Hewlett-Packard Company",
	[3]byte{0, 23, 165}:    "Ralink Technology Corp",
	[3]byte{0, 23, 166}:    "YOSIN ELECTRONICS CO., LTD.",
	[3]byte{0, 23, 167}:    "Mobile Computing Promotion Consortium",
	[3]byte{0, 23, 168}:    "EDM Corporation",
	[3]byte{0, 23, 169}:    "Sentivision",
	[3]byte{0, 23, 170}:    "elab-experience inc.",
	[3]byte{0, 23, 171}:    "Nintendo Co., Ltd.",
	[3]byte{0, 23, 172}:    "O'Neil Product Development Inc.",
	[3]byte{0, 23, 173}:    "AceNet Corporation",
	[3]byte{0, 23, 174}:    "GAI-Tronics",
	[3]byte{0, 23, 175}:    "Enermet",
	[3]byte{0, 23, 176}:    "Nokia Danmark A/S",
	[3]byte{0, 23, 177}:    "ACIST Medical Systems, Inc.",
	[3]byte{0, 23, 178}:    "SK Telesys",
	[3]byte{0, 23, 179}:    "Aftek Infosys Limited",
	[3]byte{0, 23, 180}:    "Remote Security Systems, LLC",
	[3]byte{0, 23, 181}:    "Peerless Systems Corporation",
	[3]byte{0, 23, 182}:    "Aquantia",
	[3]byte{0, 23, 183}:    "Tonze Technology Co.",
	[3]byte{0, 23, 184}:    "NOVATRON CO., LTD.",
	[3]byte{0, 23, 185}:    "Gambro Lundia AB",
	[3]byte{0, 23, 186}:    "SEDO CO., LTD.",
	[3]byte{0, 23, 187}:    "Syrinx Industrial Electronics",
	[3]byte{0, 23, 188}:    "Touchtunes Music Corporation",
	[3]byte{0, 23, 189}:    "Tibetsystem",
	[3]byte{0, 23, 190}:    "Tratec Telecom B.V.",
	[3]byte{0, 23, 191}:    "Coherent Research Limited",
	[3]byte{0, 23, 192}:    "PureTech Systems, Inc.",
	[3]byte{0, 23, 193}:    "CM Precision Technology LTD.",
	[3]byte{0, 23, 194}:    "ADB Broadband Italia",
	[3]byte{0, 23, 195}:    "KTF Technologies Inc.",
	[3]byte{0, 23, 196}:    "Quanta Microsystems, INC.",
	[3]byte{0, 23, 197}:    "SonicWALL",
	[3]byte{0, 23, 198}:    "Cross Match Technologies Inc",
	[3]byte{0, 23, 199}:    "MARA Systems Consulting AB",
	[3]byte{0, 23, 200}:    "KYOCERA Document Solutions Inc.",
	[3]byte{0, 23, 201}:    "Samsung Electronics Co., Ltd.",
	[3]byte{0, 23, 202}:    "Qisda Corporation",
	[3]byte{0, 23, 203}:    "Juniper Networks",
	[3]byte{0, 23, 204}:    "Alcatel-Lucent",
	[3]byte{0, 23, 205}:    "CEC Wireless R&D Ltd.",
	[3]byte{0, 23, 206}:    "Screen Service Spa",
	[3]byte{0, 23, 207}:    "iMCA-GmbH",
	[3]byte{0, 23, 208}:    "Opticom Communications, LLC",
	[3]byte{0, 23, 209}:    "Nortel",
	[3]byte{0, 23, 210}:    "THINLINX PTY LTD",
	[3]byte{0, 23, 211}:    "Etymotic Research, Inc.",
	[3]byte{0, 23, 212}:    "Monsoon Multimedia, Inc",
	[3]byte{0, 23, 213}:    "Samsung Electronics Co., Ltd.",
	[3]byte{0, 23, 214}:    "Bluechips Microhouse Co.,Ltd.",
	[3]byte{0, 23, 215}:    "ION Geophysical Corporation Inc.",
	[3]byte{0, 23, 216}:    "Magnum Semiconductor, Inc.",
	[3]byte{0, 23, 217}:    "AAI Corporation",
	[3]byte{0, 23, 218}:    "Spans Logic",
	[3]byte{0, 23, 219}:    "CANKO TECHNOLOGIES INC.",
	[3]byte{0, 23, 220}:    "DAEMYUNG ZERO1",
	[3]byte{0, 23, 221}:    "Clipsal Australia",
	[3]byte{0, 23, 222}:    "Advantage Six Ltd",
	[3]byte{0, 23, 223}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 23, 224}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 23, 225}:    "DACOS Technologies Co., Ltd.",
	[3]byte{0, 23, 226}:    "ARRIS Group, Inc.",
	[3]byte{0, 23, 227}:    "Texas Instruments",
	[3]byte{0, 23, 228}:    "Texas Instruments",
	[3]byte{0, 23, 229}:    "Texas Instruments",
	[3]byte{0, 23, 230}:    "Texas Instruments",
	[3]byte{0, 23, 231}:    "Texas Instruments",
	[3]byte{0, 23, 232}:    "Texas Instruments",
	[3]byte{0, 23, 233}:    "Texas Instruments",
	[3]byte{0, 23, 234}:    "Texas Instruments",
	[3]byte{0, 23, 235}:    "Texas Instruments",
	[3]byte{0, 23, 236}:    "Texas Instruments",
	[3]byte{0, 23, 237}:    "WooJooIT Ltd.",
	[3]byte{0, 23, 238}:    "ARRIS Group, Inc.",
	[3]byte{0, 23, 239}:    "IBM Corp",
	[3]byte{0, 23, 240}:    "SZCOM Broadband Network Technology Co.,Ltd",
	[3]byte{0, 23, 241}:    "Renu Electronics Pvt Ltd",
	[3]byte{0, 23, 242}:    "Apple",
	[3]byte{0, 23, 243}:    "Harris Corparation",
	[3]byte{0, 23, 244}:    "ZERON ALLIANCE",
	[3]byte{0, 23, 245}:    "LIG NEOPTEK",
	[3]byte{0, 23, 246}:    "Pyramid Meriden Inc.",
	[3]byte{0, 23, 247}:    "CEM Solutions Pvt Ltd",
	[3]byte{0, 23, 248}:    "Motech Industries Inc.",
	[3]byte{0, 23, 249}:    "Forcom Sp. z o.o.",
	[3]byte{0, 23, 250}:    "Microsoft Corporation",
	[3]byte{0, 23, 251}:    "FA",
	[3]byte{0, 23, 252}:    "Suprema Inc.",
	[3]byte{0, 23, 253}:    "Amulet Hotkey",
	[3]byte{0, 23, 254}:    "TALOS SYSTEM INC.",
	[3]byte{0, 23, 255}:    "PLAYLINE Co.,Ltd.",
	[3]byte{0, 24, 0}:      "UNIGRAND LTD",
	[3]byte{0, 24, 1}:      "Actiontec Electronics, Inc",
	[3]byte{0, 24, 2}:      "Alpha Networks Inc.",
	[3]byte{0, 24, 3}:      "ArcSoft Shanghai Co. LTD",
	[3]byte{0, 24, 4}:      "E-TEK DIGITAL TECHNOLOGY LIMITED",
	[3]byte{0, 24, 5}:      "Beijing InHand Networking Technology Co.,Ltd.",
	[3]byte{0, 24, 6}:      "Hokkei Industries Co., Ltd.",
	[3]byte{0, 24, 7}:      "Fanstel Corp.",
	[3]byte{0, 24, 8}:      "SightLogix, Inc.",
	[3]byte{0, 24, 9}:      "CRESYN",
	[3]byte{0, 24, 10}:     "Meraki, Inc.",
	[3]byte{0, 24, 11}:     "Brilliant Telecommunications",
	[3]byte{0, 24, 12}:     "Optelian Access Networks",
	[3]byte{0, 24, 13}:     "Terabytes Server Storage Tech Corp",
	[3]byte{0, 24, 14}:     "Avega Systems",
	[3]byte{0, 24, 15}:     "Nokia Danmark A/S",
	[3]byte{0, 24, 16}:     "IPTrade S.A.",
	[3]byte{0, 24, 17}:     "Neuros Technology International, LLC.",
	[3]byte{0, 24, 18}:     "Beijing Xinwei Telecom Technology Co., Ltd.",
	[3]byte{0, 24, 19}:     "Sony Ericsson Mobile Communications",
	[3]byte{0, 24, 20}:     "Mitutoyo Corporation",
	[3]byte{0, 24, 21}:     "GZ Technologies, Inc.",
	[3]byte{0, 24, 22}:     "Ubixon Co., Ltd.",
	[3]byte{0, 24, 23}:     "D. E. Shaw Research, LLC",
	[3]byte{0, 24, 24}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 24, 25}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 24, 26}:     "AVerMedia Information Inc.",
	[3]byte{0, 24, 27}:     "TaiJin Metal Co., Ltd.",
	[3]byte{0, 24, 28}:     "Exterity Limited",
	[3]byte{0, 24, 29}:     "ASIA ELECTRONICS CO.,LTD",
	[3]byte{0, 24, 30}:     "GDX Technologies Ltd.",
	[3]byte{0, 24, 31}:     "Palmmicro Communications",
	[3]byte{0, 24, 32}:     "w5networks",
	[3]byte{0, 24, 33}:     "SINDORICOH",
	[3]byte{0, 24, 34}:     "CEC TELECOM CO.,LTD.",
	[3]byte{0, 24, 35}:     "Delta Electronics, Inc.",
	[3]byte{0, 24, 36}:     "Kimaldi Electronics, S.L.",
	[3]byte{0, 24, 37}:     "PRIVATE",
	[3]byte{0, 24, 38}:     "Cale Access AB",
	[3]byte{0, 24, 39}:     "NEC UNIFIED SOLUTIONS NEDERLAND B.V.",
	[3]byte{0, 24, 40}:     "e2v technologies (UK) ltd.",
	[3]byte{0, 24, 41}:     "Gatsometer",
	[3]byte{0, 24, 42}:     "Taiwan Video & Monitor",
	[3]byte{0, 24, 43}:     "Softier",
	[3]byte{0, 24, 44}:     "Ascend Networks, Inc.",
	[3]byte{0, 24, 45}:     "Artec Design",
	[3]byte{0, 24, 46}:     "XStreamHD, LLC",
	[3]byte{0, 24, 47}:     "Texas Instruments",
	[3]byte{0, 24, 48}:     "Texas Instruments",
	[3]byte{0, 24, 49}:     "Texas Instruments",
	[3]byte{0, 24, 50}:     "Texas Instruments",
	[3]byte{0, 24, 51}:     "Texas Instruments",
	[3]byte{0, 24, 52}:     "Texas Instruments",
	[3]byte{0, 24, 53}:     "Thoratec / ITC",
	[3]byte{0, 24, 54}:     "Reliance Electric Limited",
	[3]byte{0, 24, 55}:     "Universal ABIT Co., Ltd.",
	[3]byte{0, 24, 56}:     "PanAccess Communications,Inc.",
	[3]byte{0, 24, 57}:     "Cisco-Linksys LLC",
	[3]byte{0, 24, 58}:     "Westell Technologies",
	[3]byte{0, 24, 59}:     "CENITS Co., Ltd.",
	[3]byte{0, 24, 60}:     "Encore Software Limited",
	[3]byte{0, 24, 61}:     "Vertex Link Corporation",
	[3]byte{0, 24, 62}:     "Digilent, Inc",
	[3]byte{0, 24, 63}:     "2Wire, Inc",
	[3]byte{0, 24, 64}:     "3 Phoenix, Inc.",
	[3]byte{0, 24, 65}:     "High Tech Computer Corp",
	[3]byte{0, 24, 66}:     "Nokia Danmark A/S",
	[3]byte{0, 24, 67}:     "Dawevision Ltd",
	[3]byte{0, 24, 68}:     "Heads Up Technologies, Inc.",
	[3]byte{0, 24, 69}:     "Pulsar-Telecom LLC.",
	[3]byte{0, 24, 70}:     "Crypto S.A.",
	[3]byte{0, 24, 71}:     "AceNet Technology Inc.",
	[3]byte{0, 24, 72}:     "Vecima Networks Inc.",
	[3]byte{0, 24, 73}:     "Pigeon Point Systems LLC",
	[3]byte{0, 24, 74}:     "Catcher, Inc.",
	[3]byte{0, 24, 75}:     "Las Vegas Gaming, Inc.",
	[3]byte{0, 24, 76}:     "Bogen Communications",
	[3]byte{0, 24, 77}:     "Netgear Inc.",
	[3]byte{0, 24, 78}:     "Lianhe Technologies, Inc.",
	[3]byte{0, 24, 79}:     "8 Ways Technology Corp.",
	[3]byte{0, 24, 80}:     "Secfone Kft",
	[3]byte{0, 24, 81}:     "SWsoft",
	[3]byte{0, 24, 82}:     "StorLink Semiconductors, Inc.",
	[3]byte{0, 24, 83}:     "Atera Networks LTD.",
	[3]byte{0, 24, 84}:     "Argard Co., Ltd",
	[3]byte{0, 24, 85}:     "Aeromaritime Systembau GmbH",
	[3]byte{0, 24, 86}:     "EyeFi, Inc",
	[3]byte{0, 24, 87}:     "Unilever R&D",
	[3]byte{0, 24, 88}:     "TagMaster AB",
	[3]byte{0, 24, 89}:     "Strawberry Linux Co.,Ltd.",
	[3]byte{0, 24, 90}:     "uControl, Inc.",
	[3]byte{0, 24, 91}:     "Network Chemistry, Inc",
	[3]byte{0, 24, 92}:     "EDS Lab Pte Ltd",
	[3]byte{0, 24, 93}:     "TAIGUEN TECHNOLOGY (SHEN-ZHEN) CO., LTD.",
	[3]byte{0, 24, 94}:     "Nexterm Inc.",
	[3]byte{0, 24, 95}:     "TAC Inc.",
	[3]byte{0, 24, 96}:     "SIM Technology Group Shanghai Simcom Ltd.,",
	[3]byte{0, 24, 97}:     "Ooma, Inc.",
	[3]byte{0, 24, 98}:     "Seagate Technology",
	[3]byte{0, 24, 99}:     "Veritech Electronics Limited",
	[3]byte{0, 24, 100}:    "Eaton Corporation",
	[3]byte{0, 24, 101}:    "Siemens Healthcare Diagnostics Manufacturing Ltd",
	[3]byte{0, 24, 102}:    "Leutron Vision",
	[3]byte{0, 24, 103}:    "Datalogic ADC",
	[3]byte{0, 24, 104}:    "Scientific Atlanta, A Cisco Company",
	[3]byte{0, 24, 105}:    "KINGJIM",
	[3]byte{0, 24, 106}:    "Global Link Digital Technology Co,.LTD",
	[3]byte{0, 24, 107}:    "Sambu Communics CO., LTD.",
	[3]byte{0, 24, 108}:    "Neonode AB",
	[3]byte{0, 24, 109}:    "Zhenjiang Sapphire Electronic Industry CO.",
	[3]byte{0, 24, 110}:    "3Com Ltd",
	[3]byte{0, 24, 111}:    "Setha Industria Eletronica LTDA",
	[3]byte{0, 24, 112}:    "E28 Shanghai Limited",
	[3]byte{0, 24, 113}:    "Hewlett-Packard Company",
	[3]byte{0, 24, 114}:    "Expertise Engineering",
	[3]byte{0, 24, 115}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 24, 116}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 24, 117}:    "AnaCise Testnology Pte Ltd",
	[3]byte{0, 24, 118}:    "WowWee Ltd.",
	[3]byte{0, 24, 119}:    "Amplex A/S",
	[3]byte{0, 24, 120}:    "Mackware GmbH",
	[3]byte{0, 24, 121}:    "dSys",
	[3]byte{0, 24, 122}:    "Wiremold",
	[3]byte{0, 24, 123}:    "4NSYS Co. Ltd.",
	[3]byte{0, 24, 124}:    "INTERCROSS, LLC",
	[3]byte{0, 24, 125}:    "Armorlink shanghai Co. Ltd",
	[3]byte{0, 24, 126}:    "RGB Spectrum",
	[3]byte{0, 24, 127}:    "ZODIANET",
	[3]byte{0, 24, 128}:    "Maxim Integrated Products",
	[3]byte{0, 24, 129}:    "Buyang Electronics Industrial Co., Ltd",
	[3]byte{0, 24, 130}:    "Huawei Technologies Co., Ltd.",
	[3]byte{0, 24, 131}:    "FORMOSA21 INC.",
	[3]byte{0, 24, 132}:    "Fon Technology S.L.",
	[3]byte{0, 24, 133}:    "Avigilon Corporation",
	[3]byte{0, 24, 134}:    "EL-TECH, INC.",
	[3]byte{0, 24, 135}:    "Metasystem SpA",
	[3]byte{0, 24, 136}:    "GOTIVE a.s.",
	[3]byte{0, 24, 137}:    "WinNet Solutions Limited",
	[3]byte{0, 24, 138}:    "Infinova LLC",
	[3]byte{0, 24, 139}:    "Dell Inc",
	[3]byte{0, 24, 140}:    "Mobile Action Technology Inc.",
	[3]byte{0, 24, 141}:    "Nokia Danmark A/S",
	[3]byte{0, 24, 142}:    "Ekahau, Inc.",
	[3]byte{0, 24, 143}:    "Montgomery Technology, Inc.",
	[3]byte{0, 24, 144}:    "RadioCOM, s.r.o.",
	[3]byte{0, 24, 145}:    "Zhongshan General K-mate Electronics Co., Ltd",
	[3]byte{0, 24, 146}:    "ads-tec GmbH",
	[3]byte{0, 24, 147}:    "SHENZHEN PHOTON BROADBAND TECHNOLOGY CO.,LTD",
	[3]byte{0, 24, 148}:    "NPCore, Inc.",
	[3]byte{0, 24, 149}:    "Hansun Technologies Inc.",
	[3]byte{0, 24, 150}:    "Great Well Electronic LTD",
	[3]byte{0, 24, 151}:    "JESS-LINK PRODUCTS Co., LTD",
	[3]byte{0, 24, 152}:    "KINGSTATE ELECTRONICS CORPORATION",
	[3]byte{0, 24, 153}:    "ShenZhen jieshun Science&Technology Industry CO,LTD.",
	[3]byte{0, 24, 154}:    "HANA Micron Inc.",
	[3]byte{0, 24, 155}:    "Thomson Inc.",
	[3]byte{0, 24, 156}:    "Weldex Corporation",
	[3]byte{0, 24, 157}:    "Navcast Inc.",
	[3]byte{0, 24, 158}:    "OMNIKEY GmbH.",
	[3]byte{0, 24, 159}:    "Lenntek Corporation",
	[3]byte{0, 24, 160}:    "Cierma Ascenseurs",
	[3]byte{0, 24, 161}:    "Tiqit Computers, Inc.",
	[3]byte{0, 24, 162}:    "XIP Technology AB",
	[3]byte{0, 24, 163}:    "ZIPPY TECHNOLOGY CORP.",
	[3]byte{0, 24, 164}:    "ARRIS Group, Inc.",
	[3]byte{0, 24, 165}:    "ADigit Technologies Corp.",
	[3]byte{0, 24, 166}:    "Persistent Systems, LLC",
	[3]byte{0, 24, 167}:    "Yoggie Security Systems LTD.",
	[3]byte{0, 24, 168}:    "AnNeal Technology Inc.",
	[3]byte{0, 24, 169}:    "Ethernet Direct Corporation",
	[3]byte{0, 24, 170}:    "Protec Fire Detection plc",
	[3]byte{0, 24, 171}:    "BEIJING LHWT MICROELECTRONICS INC.",
	[3]byte{0, 24, 172}:    "Shanghai Jiao Da HISYS Technology Co. Ltd.",
	[3]byte{0, 24, 173}:    "NIDEC SANKYO CORPORATION",
	[3]byte{0, 24, 174}:    "TVT CO.,LTD",
	[3]byte{0, 24, 175}:    "Samsung Electronics Co., Ltd.",
	[3]byte{0, 24, 176}:    "Nortel",
	[3]byte{0, 24, 177}:    "IBM Corp",
	[3]byte{0, 24, 178}:    "ADEUNIS RF",
	[3]byte{0, 24, 179}:    "TEC WizHome Co., Ltd.",
	[3]byte{0, 24, 180}:    "Dawon Media Inc.",
	[3]byte{0, 24, 181}:    "Magna Carta",
	[3]byte{0, 24, 182}:    "S3C, Inc.",
	[3]byte{0, 24, 183}:    "D3 LED, LLC",
	[3]byte{0, 24, 184}:    "New Voice International AG",
	[3]byte{0, 24, 185}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 24, 186}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 24, 187}:    "Eliwell Controls srl",
	[3]byte{0, 24, 188}:    "ZAO NVP Bolid",
	[3]byte{0, 24, 189}:    "SHENZHEN DVBWORLD TECHNOLOGY CO., LTD.",
	[3]byte{0, 24, 190}:    "ANSA Corporation",
	[3]byte{0, 24, 191}:    "Essence Technology Solution, Inc.",
	[3]byte{0, 24, 192}:    "ARRIS Group, Inc.",
	[3]byte{0, 24, 193}:    "Almitec Informática e Comércio",
	[3]byte{0, 24, 194}:    "Firetide, Inc",
	[3]byte{0, 24, 195}:    "CS Corporation",
	[3]byte{0, 24, 196}:    "Raba Technologies LLC",
	[3]byte{0, 24, 197}:    "Nokia Danmark A/S",
	[3]byte{0, 24, 198}:    "OPW Fuel Management Systems",
	[3]byte{0, 24, 199}:    "Real Time Automation",
	[3]byte{0, 24, 200}:    "ISONAS Inc.",
	[3]byte{0, 24, 201}:    "EOps Technology Limited",
	[3]byte{0, 24, 202}:    "Viprinet GmbH",
	[3]byte{0, 24, 203}:    "Tecobest Technology Limited",
	[3]byte{0, 24, 204}:    "AXIOHM SAS",
	[3]byte{0, 24, 205}:    "Erae Electronics Industry Co., Ltd",
	[3]byte{0, 24, 206}:    "Dreamtech Co., Ltd",
	[3]byte{0, 24, 207}:    "Baldor Electric Company",
	[3]byte{0, 24, 208}:    "AtRoad,  A Trimble Company",
	[3]byte{0, 24, 209}:    "Siemens Home & Office Comm. Devices",
	[3]byte{0, 24, 210}:    "High-Gain Antennas LLC",
	[3]byte{0, 24, 211}:    "TEAMCAST",
	[3]byte{0, 24, 212}:    "Unified Display Interface SIG",
	[3]byte{0, 24, 213}:    "REIGNCOM",
	[3]byte{0, 24, 214}:    "Swirlnet A/S",
	[3]byte{0, 24, 215}:    "Javad Navigation Systems Inc.",
	[3]byte{0, 24, 216}:    "ARCH METER Corporation",
	[3]byte{0, 24, 217}:    "Santosha Internatonal, Inc",
	[3]byte{0, 24, 218}:    "AMBER wireless GmbH",
	[3]byte{0, 24, 219}:    "EPL Technology Ltd",
	[3]byte{0, 24, 220}:    "Prostar Co., Ltd.",
	[3]byte{0, 24, 221}:    "Silicondust Engineering Ltd",
	[3]byte{0, 24, 222}:    "Intel Corporate",
	[3]byte{0, 24, 223}:    "The Morey Corporation",
	[3]byte{0, 24, 224}:    "ANAVEO",
	[3]byte{0, 24, 225}:    "Verkerk Service Systemen",
	[3]byte{0, 24, 226}:    "Topdata Sistemas de Automacao Ltda",
	[3]byte{0, 24, 227}:    "Visualgate Systems, Inc.",
	[3]byte{0, 24, 228}:    "YIGUANG",
	[3]byte{0, 24, 229}:    "Adhoco AG",
	[3]byte{0, 24, 230}:    "Computer Hardware Design SIA",
	[3]byte{0, 24, 231}:    "Cameo Communications, INC.",
	[3]byte{0, 24, 232}:    "Hacetron Corporation",
	[3]byte{0, 24, 233}:    "Numata Corporation",
	[3]byte{0, 24, 234}:    "Alltec GmbH",
	[3]byte{0, 24, 235}:    "BroVis Wireless Networks",
	[3]byte{0, 24, 236}:    "Welding Technology Corporation",
	[3]byte{0, 24, 237}:    "Accutech Ultrasystems Co., Ltd.",
	[3]byte{0, 24, 238}:    "Videology Imaging Solutions, Inc.",
	[3]byte{0, 24, 239}:    "Escape Communications, Inc.",
	[3]byte{0, 24, 240}:    "JOYTOTO Co., Ltd.",
	[3]byte{0, 24, 241}:    "Chunichi Denshi Co.,LTD.",
	[3]byte{0, 24, 242}:    "Beijing Tianyu Communication Equipment Co., Ltd",
	[3]byte{0, 24, 243}:    "ASUSTek COMPUTER INC.",
	[3]byte{0, 24, 244}:    "EO TECHNICS Co., Ltd.",
	[3]byte{0, 24, 245}:    "Shenzhen Streaming Video Technology Company Limited",
	[3]byte{0, 24, 246}:    "Thomson Telecom Belgium",
	[3]byte{0, 24, 247}:    "Kameleon Technologies",
	[3]byte{0, 24, 248}:    "Cisco-Linksys LLC",
	[3]byte{0, 24, 249}:    "VVOND, Inc.",
	[3]byte{0, 24, 250}:    "Yushin Precision Equipment Co.,Ltd.",
	[3]byte{0, 24, 251}:    "Compro Technology",
	[3]byte{0, 24, 252}:    "Altec Electronic AG",
	[3]byte{0, 24, 253}:    "Optimal Technologies International Inc.",
	[3]byte{0, 24, 254}:    "Hewlett-Packard Company",
	[3]byte{0, 24, 255}:    "PowerQuattro Co.",
	[3]byte{0, 25, 0}:      "Intelliverese - DBA Voicecom",
	[3]byte{0, 25, 1}:      "F1MEDIA",
	[3]byte{0, 25, 2}:      "Cambridge Consultants Ltd",
	[3]byte{0, 25, 3}:      "Bigfoot Networks Inc",
	[3]byte{0, 25, 4}:      "WB Electronics Sp. z o.o.",
	[3]byte{0, 25, 5}:      "SCHRACK Seconet AG",
	[3]byte{0, 25, 6}:      "CISCO SYSTEMS, INC.",
	[3]byte{0, 25, 7}:      "CISCO SYSTEMS, INC.",
	[3]byte{0, 25, 8}:      "Duaxes Corporation",
	[3]byte{0, 25, 9}:      "DEVI - Danfoss A/S",
	[3]byte{0, 25, 10}:     "HASWARE INC.",
	[3]byte{0, 25, 11}:     "Southern Vision Systems, Inc.",
	[3]byte{0, 25, 12}:     "Encore Electronics, Inc.",
	[3]byte{0, 25, 13}:     "IEEE 1394c",
	[3]byte{0, 25, 14}:     "Atech Technology Co., Ltd.",
	[3]byte{0, 25, 15}:     "Advansus Corp.",
	[3]byte{0, 25, 16}:     "Knick Elektronische Messgeraete GmbH & Co. KG",
	[3]byte{0, 25, 17}:     "Just In Mobile Information Technologies (Shanghai) Co., Ltd.",
	[3]byte{0, 25, 18}:     "Welcat Inc",
	[3]byte{0, 25, 19}:     "Chuang-Yi Network Equipment Co.Ltd.",
	[3]byte{0, 25, 20}:     "Winix Co., Ltd",
	[3]byte{0, 25, 21}:     "TECOM Co., Ltd.",
	[3]byte{0, 25, 22}:     "PayTec AG",
	[3]byte{0, 25, 23}:     "Posiflex Inc.",
	[3]byte{0, 25, 24}:     "Interactive Wear AG",
	[3]byte{0, 25, 25}:     "ASTEL Inc.",
	[3]byte{0, 25, 26}:     "IRLINK",
	[3]byte{0, 25, 27}:     "Sputnik Engineering AG",
	[3]byte{0, 25, 28}:     "Sensicast Systems",
	[3]byte{0, 25, 29}:     "Nintendo Co., Ltd.",
	[3]byte{0, 25, 30}:     "Beyondwiz Co., Ltd.",
	[3]byte{0, 25, 31}:     "Microlink communications Inc.",
	[3]byte{0, 25, 32}:     "KUME electric Co.,Ltd.",
	[3]byte{0, 25, 33}:     "Elitegroup Computer System Co.",
	[3]byte{0, 25, 34}:     "CM Comandos Lineares",
	[3]byte{0, 25, 35}:     "Phonex Korea Co., LTD.",
	[3]byte{0, 25, 36}:     "LBNL  Engineering",
	[3]byte{0, 25, 37}:     "Intelicis Corporation",
	[3]byte{0, 25, 38}:     "BitsGen Co., Ltd.",
	[3]byte{0, 25, 39}:     "ImCoSys Ltd",
	[3]byte{0, 25, 40}:     "Siemens AG, Transportation Systems",
	[3]byte{0, 25, 41}:     "2M2B Montadora de Maquinas Bahia Brasil LTDA",
	[3]byte{0, 25, 42}:     "Antiope Associates",
	[3]byte{0, 25, 43}:     "Aclara RF Systems Inc.",
	[3]byte{0, 25, 44}:     "ARRIS Group, Inc.",
	[3]byte{0, 25, 45}:     "Nokia Corporation",
	[3]byte{0, 25, 46}:     "Spectral Instruments, Inc.",
	[3]byte{0, 25, 47}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 25, 48}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 25, 49}:     "Balluff GmbH",
	[3]byte{0, 25, 50}:     "Gude Analog- und Digialsysteme GmbH",
	[3]byte{0, 25, 51}:     "Strix Systems, Inc.",
	[3]byte{0, 25, 52}:     "TRENDON TOUCH TECHNOLOGY CORP.",
	[3]byte{0, 25, 53}:     "DUERR DENTAL AG",
	[3]byte{0, 25, 54}:     "STERLITE OPTICAL TECHNOLOGIES LIMITED",
	[3]byte{0, 25, 55}:     "CommerceGuard AB",
	[3]byte{0, 25, 56}:     "UMB Communications Co., Ltd.",
	[3]byte{0, 25, 57}:     "Gigamips",
	[3]byte{0, 25, 58}:     "OESOLUTIONS",
	[3]byte{0, 25, 59}:     "Wilibox Deliberant Group LLC",
	[3]byte{0, 25, 60}:     "HighPoint Technologies Incorporated",
	[3]byte{0, 25, 61}:     "GMC Guardian Mobility Corp.",
	[3]byte{0, 25, 62}:     "ADB Broadband Italia",
	[3]byte{0, 25, 63}:     "RDI technology(Shenzhen) Co.,LTD",
	[3]byte{0, 25, 64}:     "Rackable Systems",
	[3]byte{0, 25, 65}:     "Pitney Bowes, Inc",
	[3]byte{0, 25, 66}:     "ON SOFTWARE INTERNATIONAL LIMITED",
	[3]byte{0, 25, 67}:     "Belden",
	[3]byte{0, 25, 68}:     "Fossil Partners, L.P.",
	[3]byte{0, 25, 69}:     "Ten-Tec Inc.",
	[3]byte{0, 25, 70}:     "Cianet Industria e Comercio S/A",
	[3]byte{0, 25, 71}:     "Scientific Atlanta, A Cisco Company",
	[3]byte{0, 25, 72}:     "AireSpider Networks",
	[3]byte{0, 25, 73}:     "TENTEL  COMTECH CO., LTD.",
	[3]byte{0, 25, 74}:     "TESTO AG",
	[3]byte{0, 25, 75}:     "SAGEM COMMUNICATION",
	[3]byte{0, 25, 76}:     "Fujian Stelcom information & Technology CO.,Ltd",
	[3]byte{0, 25, 77}:     "Avago Technologies Sdn Bhd",
	[3]byte{0, 25, 78}:     "Ultra Electronics - TCS (Tactical Communication Systems)",
	[3]byte{0, 25, 79}:     "Nokia Danmark A/S",
	[3]byte{0, 25, 80}:     "Harman Multimedia",
	[3]byte{0, 25, 81}:     "NETCONS, s.r.o.",
	[3]byte{0, 25, 82}:     "ACOGITO Co., Ltd",
	[3]byte{0, 25, 83}:     "Chainleader Communications Corp.",
	[3]byte{0, 25, 84}:     "Leaf Corporation.",
	[3]byte{0, 25, 85}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 25, 86}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 25, 87}:     "Saafnet Canada Inc.",
	[3]byte{0, 25, 88}:     "Bluetooth SIG, Inc.",
	[3]byte{0, 25, 89}:     "Staccato Communications Inc.",
	[3]byte{0, 25, 90}:     "Jenaer Antriebstechnik GmbH",
	[3]byte{0, 25, 91}:     "D-Link Corporation",
	[3]byte{0, 25, 92}:     "Innotech Corporation",
	[3]byte{0, 25, 93}:     "ShenZhen XinHuaTong Opto Electronics Co.,Ltd",
	[3]byte{0, 25, 94}:     "ARRIS Group, Inc.",
	[3]byte{0, 25, 95}:     "Valemount Networks Corporation",
	[3]byte{0, 25, 96}:     "DoCoMo Systems, Inc.",
	[3]byte{0, 25, 97}:     "Blaupunkt  Embedded Systems GmbH",
	[3]byte{0, 25, 98}:     "Commerciant, LP",
	[3]byte{0, 25, 99}:     "Sony Ericsson Mobile Communications AB",
	[3]byte{0, 25, 100}:    "Doorking Inc.",
	[3]byte{0, 25, 101}:    "YuHua TelTech (ShangHai) Co., Ltd.",
	[3]byte{0, 25, 102}:    "Asiarock Technology Limited",
	[3]byte{0, 25, 103}:    "TELDAT Sp.J.",
	[3]byte{0, 25, 104}:    "Digital Video Networks(Shanghai) CO. LTD.",
	[3]byte{0, 25, 105}:    "Nortel",
	[3]byte{0, 25, 106}:    "MikroM GmbH",
	[3]byte{0, 25, 107}:    "Danpex Corporation",
	[3]byte{0, 25, 108}:    "ETROVISION TECHNOLOGY",
	[3]byte{0, 25, 109}:    "Raybit Systems Korea, Inc",
	[3]byte{0, 25, 110}:    "Metacom (Pty) Ltd.",
	[3]byte{0, 25, 111}:    "SensoPart GmbH",
	[3]byte{0, 25, 112}:    "Z-Com, Inc.",
	[3]byte{0, 25, 113}:    "Guangzhou Unicomp Technology Co.,Ltd",
	[3]byte{0, 25, 114}:    "Plexus (Xiamen) Co.,ltd",
	[3]byte{0, 25, 115}:    "Zeugma Systems",
	[3]byte{0, 25, 116}:    "AboCom Systems, Inc.",
	[3]byte{0, 25, 117}:    "Beijing Huisen networks technology Inc",
	[3]byte{0, 25, 118}:    "Xipher Technologies, LLC",
	[3]byte{0, 25, 119}:    "Aerohive Networks, Inc.",
	[3]byte{0, 25, 120}:    "Datum Systems, Inc.",
	[3]byte{0, 25, 121}:    "Nokia Danmark A/S",
	[3]byte{0, 25, 122}:    "MAZeT GmbH",
	[3]byte{0, 25, 123}:    "Picotest Corp.",
	[3]byte{0, 25, 124}:    "Riedel Communications GmbH",
	[3]byte{0, 25, 125}:    "Hon Hai Precision Ind. Co., Ltd",
	[3]byte{0, 25, 126}:    "Hon Hai Precision Ind. Co., Ltd",
	[3]byte{0, 25, 127}:    "PLANTRONICS, INC.",
	[3]byte{0, 25, 128}:    "Gridpoint Systems",
	[3]byte{0, 25, 129}:    "Vivox Inc",
	[3]byte{0, 25, 130}:    "SmarDTV",
	[3]byte{0, 25, 131}:    "CCT R&D Limited",
	[3]byte{0, 25, 132}:    "ESTIC Corporation",
	[3]byte{0, 25, 133}:    "IT Watchdogs, Inc",
	[3]byte{0, 25, 134}:    "Cheng Hongjian",
	[3]byte{0, 25, 135}:    "Panasonic Mobile Communications Co., Ltd.",
	[3]byte{0, 25, 136}:    "Wi2Wi, Inc",
	[3]byte{0, 25, 137}:    "Sonitrol Corporation",
	[3]byte{0, 25, 138}:    "Northrop Grumman Systems Corp.",
	[3]byte{0, 25, 139}:    "Novera Optics Korea, Inc.",
	[3]byte{0, 25, 140}:    "iXSea",
	[3]byte{0, 25, 141}:    "Ocean Optics, Inc.",
	[3]byte{0, 25, 142}:    "Oticon A/S",
	[3]byte{0, 25, 143}:    "Alcatel Bell N.V.",
	[3]byte{0, 25, 144}:    "ELM DATA Co., Ltd.",
	[3]byte{0, 25, 145}:    "avinfo",
	[3]byte{0, 25, 146}:    "ADTRAN INC.",
	[3]byte{0, 25, 147}:    "Changshu Switchgear MFG. Co.,Ltd. (Former Changshu Switchgea",
	[3]byte{0, 25, 148}:    "Jorjin Technologies Inc.",
	[3]byte{0, 25, 149}:    "Jurong Hi-Tech (Suzhou)Co.ltd",
	[3]byte{0, 25, 150}:    "TurboChef Technologies Inc.",
	[3]byte{0, 25, 151}:    "Soft Device Sdn Bhd",
	[3]byte{0, 25, 152}:    "SATO CORPORATION",
	[3]byte{0, 25, 153}:    "Fujitsu Technology Solutions",
	[3]byte{0, 25, 154}:    "EDO-EVI",
	[3]byte{0, 25, 155}:    "Diversified Technical Systems, Inc.",
	[3]byte{0, 25, 156}:    "CTRING",
	[3]byte{0, 25, 157}:    "VIZIO, Inc.",
	[3]byte{0, 25, 158}:    "Nifty",
	[3]byte{0, 25, 159}:    "DKT A/S",
	[3]byte{0, 25, 160}:    "NIHON DATA SYSTENS, INC.",
	[3]byte{0, 25, 161}:    "LG INFORMATION & COMM.",
	[3]byte{0, 25, 162}:    "ORDYN TECHNOLOGIES",
	[3]byte{0, 25, 163}:    "asteel electronique atlantique",
	[3]byte{0, 25, 164}:    "Austar Technology (hang zhou) Co.,Ltd",
	[3]byte{0, 25, 165}:    "RadarFind Corporation",
	[3]byte{0, 25, 166}:    "ARRIS Group, Inc.",
	[3]byte{0, 25, 167}:    "ITU-T",
	[3]byte{0, 25, 168}:    "WiQuest Communications",
	[3]byte{0, 25, 169}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 25, 170}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 25, 171}:    "Raycom CO ., LTD",
	[3]byte{0, 25, 172}:    "GSP SYSTEMS Inc.",
	[3]byte{0, 25, 173}:    "BOBST SA",
	[3]byte{0, 25, 174}:    "Hopling Technologies b.v.",
	[3]byte{0, 25, 175}:    "Rigol Technologies, Inc.",
	[3]byte{0, 25, 176}:    "HanYang System",
	[3]byte{0, 25, 177}:    "Arrow7 Corporation",
	[3]byte{0, 25, 178}:    "XYnetsoft Co.,Ltd",
	[3]byte{0, 25, 179}:    "Stanford Research Systems",
	[3]byte{0, 25, 180}:    "VideoCast Ltd.",
	[3]byte{0, 25, 181}:    "Famar Fueguina S.A.",
	[3]byte{0, 25, 182}:    "Euro Emme s.r.l.",
	[3]byte{0, 25, 183}:    "Nokia Danmark A/S",
	[3]byte{0, 25, 184}:    "Boundary Devices",
	[3]byte{0, 25, 185}:    "Dell Inc.",
	[3]byte{0, 25, 186}:    "Paradox Security Systems Ltd",
	[3]byte{0, 25, 187}:    "Hewlett-Packard Company",
	[3]byte{0, 25, 188}:    "ELECTRO CHANCE SRL",
	[3]byte{0, 25, 189}:    "New Media Life",
	[3]byte{0, 25, 190}:    "Altai Technologies Limited",
	[3]byte{0, 25, 191}:    "Citiway technology Co.,ltd",
	[3]byte{0, 25, 192}:    "ARRIS Group, Inc.",
	[3]byte{0, 25, 193}:    "Alps Electric Co., Ltd",
	[3]byte{0, 25, 194}:    "Equustek Solutions, Inc.",
	[3]byte{0, 25, 195}:    "Qualitrol",
	[3]byte{0, 25, 196}:    "Infocrypt Inc.",
	[3]byte{0, 25, 197}:    "SONY Computer Entertainment inc,",
	[3]byte{0, 25, 198}:    "ZTE Corporation",
	[3]byte{0, 25, 199}:    "Cambridge Industries(Group) Co.,Ltd.",
	[3]byte{0, 25, 200}:    "AnyDATA Corporation",
	[3]byte{0, 25, 201}:    "S&C ELECTRIC COMPANY",
	[3]byte{0, 25, 202}:    "Broadata Communications, Inc",
	[3]byte{0, 25, 203}:    "ZyXEL Communications Corporation",
	[3]byte{0, 25, 204}:    "RCG (HK) Ltd",
	[3]byte{0, 25, 205}:    "Chengdu ethercom information technology Ltd.",
	[3]byte{0, 25, 206}:    "Progressive Gaming International",
	[3]byte{0, 25, 207}:    "SALICRU, S.A.",
	[3]byte{0, 25, 208}:    "Cathexis",
	[3]byte{0, 25, 209}:    "Intel Corporate",
	[3]byte{0, 25, 210}:    "Intel Corporate",
	[3]byte{0, 25, 211}:    "TRAK Microwave",
	[3]byte{0, 25, 212}:    "ICX Technologies",
	[3]byte{0, 25, 213}:    "IP Innovations, Inc.",
	[3]byte{0, 25, 214}:    "LS Cable and System Ltd.",
	[3]byte{0, 25, 215}:    "FORTUNETEK CO., LTD",
	[3]byte{0, 25, 216}:    "MAXFOR",
	[3]byte{0, 25, 217}:    "Zeutschel GmbH",
	[3]byte{0, 25, 218}:    "Welltrans O&E Technology Co. , Ltd.",
	[3]byte{0, 25, 219}:    "MICRO-STAR INTERNATIONAL CO., LTD.",
	[3]byte{0, 25, 220}:    "ENENSYS Technologies",
	[3]byte{0, 25, 221}:    "FEI-Zyfer, Inc.",
	[3]byte{0, 25, 222}:    "MOBITEK",
	[3]byte{0, 25, 223}:    "Thomson Inc.",
	[3]byte{0, 25, 224}:    "TP-LINK Technologies Co., Ltd.",
	[3]byte{0, 25, 225}:    "Nortel",
	[3]byte{0, 25, 226}:    "Juniper Networks",
	[3]byte{0, 25, 227}:    "Apple",
	[3]byte{0, 25, 228}:    "2Wire, Inc",
	[3]byte{0, 25, 229}:    "Lynx Studio Technology, Inc.",
	[3]byte{0, 25, 230}:    "TOYO MEDIC CO.,LTD.",
	[3]byte{0, 25, 231}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 25, 232}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 25, 233}:    "S-Information Technolgy, Co., Ltd.",
	[3]byte{0, 25, 234}:    "TeraMage Technologies Co., Ltd.",
	[3]byte{0, 25, 235}:    "Pyronix Ltd",
	[3]byte{0, 25, 236}:    "Sagamore Systems, Inc.",
	[3]byte{0, 25, 237}:    "Axesstel Inc.",
	[3]byte{0, 25, 238}:    "CARLO GAVAZZI CONTROLS SPA-Controls Division",
	[3]byte{0, 25, 239}:    "SHENZHEN LINNKING ELECTRONICS CO.,LTD",
	[3]byte{0, 25, 240}:    "UNIONMAN TECHNOLOGY CO.,LTD",
	[3]byte{0, 25, 241}:    "Star Communication Network Technology Co.,Ltd",
	[3]byte{0, 25, 242}:    "Teradyne K.K.",
	[3]byte{0, 25, 243}:    "Cetis, Inc",
	[3]byte{0, 25, 244}:    "Convergens Oy Ltd",
	[3]byte{0, 25, 245}:    "Imagination Technologies Ltd",
	[3]byte{0, 25, 246}:    "Acconet (PTE) Ltd",
	[3]byte{0, 25, 247}:    "Onset Computer Corporation",
	[3]byte{0, 25, 248}:    "Embedded Systems Design, Inc.",
	[3]byte{0, 25, 249}:    "TDK-Lambda",
	[3]byte{0, 25, 250}:    "Cable Vision Electronics CO., LTD.",
	[3]byte{0, 25, 251}:    "BSkyB Ltd",
	[3]byte{0, 25, 252}:    "PT. Ufoakses Sukses Luarbiasa",
	[3]byte{0, 25, 253}:    "Nintendo Co., Ltd.",
	[3]byte{0, 25, 254}:    "SHENZHEN SEECOMM TECHNOLOGY CO.,LTD.",
	[3]byte{0, 25, 255}:    "Finnzymes",
	[3]byte{0, 26, 0}:      "MATRIX INC.",
	[3]byte{0, 26, 1}:      "Smiths Medical",
	[3]byte{0, 26, 2}:      "SECURE CARE PRODUCTS, INC",
	[3]byte{0, 26, 3}:      "Angel Electronics Co., Ltd.",
	[3]byte{0, 26, 4}:      "Interay Solutions BV",
	[3]byte{0, 26, 5}:      "OPTIBASE LTD",
	[3]byte{0, 26, 6}:      "OpVista, Inc.",
	[3]byte{0, 26, 7}:      "Arecont Vision",
	[3]byte{0, 26, 8}:      "Simoco Ltd.",
	[3]byte{0, 26, 9}:      "Wayfarer Transit Systems Ltd",
	[3]byte{0, 26, 10}:     "Adaptive Micro-Ware Inc.",
	[3]byte{0, 26, 11}:     "BONA TECHNOLOGY INC.",
	[3]byte{0, 26, 12}:     "Swe-Dish Satellite Systems AB",
	[3]byte{0, 26, 13}:     "HandHeld entertainment, Inc.",
	[3]byte{0, 26, 14}:     "Cheng Uei Precision Industry Co.,Ltd",
	[3]byte{0, 26, 15}:     "Sistemas Avanzados de Control, S.A.",
	[3]byte{0, 26, 16}:     "LUCENT TRANS ELECTRONICS CO.,LTD",
	[3]byte{0, 26, 17}:     "Google Inc.",
	[3]byte{0, 26, 18}:     "Essilor",
	[3]byte{0, 26, 19}:     "Wanlida Group Co., LTD",
	[3]byte{0, 26, 20}:     "Xin Hua Control Engineering Co.,Ltd.",
	[3]byte{0, 26, 21}:     "gemalto e-Payment",
	[3]byte{0, 26, 22}:     "Nokia Danmark A/S",
	[3]byte{0, 26, 23}:     "Teak Technologies, Inc.",
	[3]byte{0, 26, 24}:     "Advanced Simulation Technology inc.",
	[3]byte{0, 26, 25}:     "Computer Engineering Limited",
	[3]byte{0, 26, 26}:     "Gentex Corporation/Electro-Acoustic Products",
	[3]byte{0, 26, 27}:     "ARRIS Group, Inc.",
	[3]byte{0, 26, 28}:     "GT&T Engineering Pte Ltd",
	[3]byte{0, 26, 29}:     "PChome Online Inc.",
	[3]byte{0, 26, 30}:     "Aruba Networks",
	[3]byte{0, 26, 31}:     "Coastal Environmental Systems",
	[3]byte{0, 26, 32}:     "CMOTECH Co. Ltd.",
	[3]byte{0, 26, 33}:     "Indac B.V.",
	[3]byte{0, 26, 34}:     "eQ-3 Entwicklung GmbH",
	[3]byte{0, 26, 35}:     "Ice Qube, Inc",
	[3]byte{0, 26, 36}:     "Galaxy Telecom Technologies Ltd",
	[3]byte{0, 26, 37}:     "DELTA DORE",
	[3]byte{0, 26, 38}:     "Deltanode Solutions AB",
	[3]byte{0, 26, 39}:     "Ubistar",
	[3]byte{0, 26, 40}:     "ASWT Co., LTD. Taiwan Branch H.K.",
	[3]byte{0, 26, 41}:     "Johnson Outdoors Marine Electronics, Inc",
	[3]byte{0, 26, 42}:     "Arcadyan Technology Corporation",
	[3]byte{0, 26, 43}:     "Ayecom Technology Co., Ltd.",
	[3]byte{0, 26, 44}:     "SATEC Co.,LTD",
	[3]byte{0, 26, 45}:     "The Navvo Group",
	[3]byte{0, 26, 46}:     "Ziova Coporation",
	[3]byte{0, 26, 47}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 26, 48}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 26, 49}:     "SCAN COIN Industries AB",
	[3]byte{0, 26, 50}:     "ACTIVA MULTIMEDIA",
	[3]byte{0, 26, 51}:     "ASI Communications, Inc.",
	[3]byte{0, 26, 52}:     "Konka Group Co., Ltd.",
	[3]byte{0, 26, 53}:     "BARTEC GmbH",
	[3]byte{0, 26, 54}:     "Aipermon GmbH & Co. KG",
	[3]byte{0, 26, 55}:     "Lear Corporation",
	[3]byte{0, 26, 56}:     "Sanmina-SCI",
	[3]byte{0, 26, 57}:     "Merten GmbH&CoKG",
	[3]byte{0, 26, 58}:     "Dongahelecomm",
	[3]byte{0, 26, 59}:     "Doah Elecom Inc.",
	[3]byte{0, 26, 60}:     "Technowave Ltd.",
	[3]byte{0, 26, 61}:     "Ajin Vision Co.,Ltd",
	[3]byte{0, 26, 62}:     "Faster Technology LLC",
	[3]byte{0, 26, 63}:     "intelbras",
	[3]byte{0, 26, 64}:     "A-FOUR TECH CO., LTD.",
	[3]byte{0, 26, 65}:     "INOCOVA Co.,Ltd",
	[3]byte{0, 26, 66}:     "Techcity Technology co., Ltd.",
	[3]byte{0, 26, 67}:     "Logical Link Communications",
	[3]byte{0, 26, 68}:     "JWTrading Co., Ltd",
	[3]byte{0, 26, 69}:     "GN Netcom as",
	[3]byte{0, 26, 70}:     "Digital Multimedia Technology Co., Ltd",
	[3]byte{0, 26, 71}:     "Agami Systems, Inc.",
	[3]byte{0, 26, 72}:     "Takacom Corporation",
	[3]byte{0, 26, 73}:     "Micro Vision Co.,LTD",
	[3]byte{0, 26, 74}:     "Qumranet Inc.",
	[3]byte{0, 26, 75}:     "Hewlett-Packard Company",
	[3]byte{0, 26, 76}:     "Crossbow Technology, Inc",
	[3]byte{0, 26, 77}:     "GIGA-BYTE TECHNOLOGY CO.,LTD.",
	[3]byte{0, 26, 78}:     "NTI AG / LinMot",
	[3]byte{0, 26, 79}:     "AVM GmbH",
	[3]byte{0, 26, 80}:     "PheeNet Technology Corp.",
	[3]byte{0, 26, 81}:     "Alfred Mann Foundation",
	[3]byte{0, 26, 82}:     "Meshlinx Wireless Inc.",
	[3]byte{0, 26, 83}:     "Zylaya",
	[3]byte{0, 26, 84}:     "Hip Shing Electronics Ltd.",
	[3]byte{0, 26, 85}:     "ACA-Digital Corporation",
	[3]byte{0, 26, 86}:     "ViewTel Co,. Ltd.",
	[3]byte{0, 26, 87}:     "Matrix Design Group, LLC",
	[3]byte{0, 26, 88}:     "CCV Deutschland GmbH - Celectronic eHealth Div.",
	[3]byte{0, 26, 89}:     "Ircona",
	[3]byte{0, 26, 90}:     "Korea Electric Power Data Network  (KDN) Co., Ltd",
	[3]byte{0, 26, 91}:     "NetCare Service Co., Ltd.",
	[3]byte{0, 26, 92}:     "Euchner GmbH+Co. KG",
	[3]byte{0, 26, 93}:     "Mobinnova Corp.",
	[3]byte{0, 26, 94}:     "Thincom Technology Co.,Ltd",
	[3]byte{0, 26, 95}:     "KitWorks.fi Ltd.",
	[3]byte{0, 26, 96}:     "Wave Electronics Co.,Ltd.",
	[3]byte{0, 26, 97}:     "PacStar Corp.",
	[3]byte{0, 26, 98}:     "Data Robotics, Incorporated",
	[3]byte{0, 26, 99}:     "Elster Solutions, LLC,",
	[3]byte{0, 26, 100}:    "IBM Corp",
	[3]byte{0, 26, 101}:    "Seluxit",
	[3]byte{0, 26, 102}:    "ARRIS Group, Inc.",
	[3]byte{0, 26, 103}:    "Infinite QL Sdn Bhd",
	[3]byte{0, 26, 104}:    "Weltec Enterprise Co., Ltd.",
	[3]byte{0, 26, 105}:    "Wuhan Yangtze Optical Technology CO.,Ltd.",
	[3]byte{0, 26, 106}:    "Tranzas, Inc.",
	[3]byte{0, 26, 107}:    "Universal Global Scientific Industrial Co., Ltd.",
	[3]byte{0, 26, 108}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 26, 109}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 26, 110}:    "Impro Technologies",
	[3]byte{0, 26, 111}:    "MI.TEL s.r.l.",
	[3]byte{0, 26, 112}:    "Cisco-Linksys, LLC",
	[3]byte{0, 26, 113}:    "Diostech Co., Ltd.",
	[3]byte{0, 26, 114}:    "Mosart Semiconductor Corp.",
	[3]byte{0, 26, 115}:    "Gemtek Technology Co., Ltd.",
	[3]byte{0, 26, 116}:    "Procare International Co",
	[3]byte{0, 26, 117}:    "Sony Ericsson Mobile Communications",
	[3]byte{0, 26, 118}:    "SDT information Technology Co.,LTD.",
	[3]byte{0, 26, 119}:    "ARRIS Group, Inc.",
	[3]byte{0, 26, 120}:    "ubtos",
	[3]byte{0, 26, 121}:    "TELECOMUNICATION TECHNOLOGIES LTD.",
	[3]byte{0, 26, 122}:    "Lismore Instruments Limited",
	[3]byte{0, 26, 123}:    "Teleco, Inc.",
	[3]byte{0, 26, 124}:    "Hirschmann Multimedia B.V.",
	[3]byte{0, 26, 125}:    "cyber-blue(HK)Ltd",
	[3]byte{0, 26, 126}:    "LN Srithai Comm Ltd.",
	[3]byte{0, 26, 127}:    "GCI Science&Technology Co.,Ltd.",
	[3]byte{0, 26, 128}:    "Sony Corporation",
	[3]byte{0, 26, 129}:    "Zelax",
	[3]byte{0, 26, 130}:    "PROBA Building Automation Co.,LTD",
	[3]byte{0, 26, 131}:    "Pegasus Technologies Inc.",
	[3]byte{0, 26, 132}:    "V One Multimedia Pte Ltd",
	[3]byte{0, 26, 133}:    "NV Michel Van de Wiele",
	[3]byte{0, 26, 134}:    "AdvancedIO Systems Inc",
	[3]byte{0, 26, 135}:    "Canhold International Limited",
	[3]byte{0, 26, 136}:    "Venergy,Co,Ltd",
	[3]byte{0, 26, 137}:    "Nokia Danmark A/S",
	[3]byte{0, 26, 138}:    "Samsung Electronics Co., Ltd.",
	[3]byte{0, 26, 139}:    "CHUNIL ELECTRIC IND., CO.",
	[3]byte{0, 26, 140}:    "Sophos Ltd",
	[3]byte{0, 26, 141}:    "AVECS Bergen GmbH",
	[3]byte{0, 26, 142}:    "3Way Networks Ltd",
	[3]byte{0, 26, 143}:    "Nortel",
	[3]byte{0, 26, 144}:    "Trópico Sistemas e Telecomunicações da Amazônia LTDA.",
	[3]byte{0, 26, 145}:    "FusionDynamic Ltd.",
	[3]byte{0, 26, 146}:    "ASUSTek COMPUTER INC.",
	[3]byte{0, 26, 147}:    "ERCO Leuchten GmbH",
	[3]byte{0, 26, 148}:    "Votronic GmbH",
	[3]byte{0, 26, 149}:    "Hisense Mobile Communications Technoligy Co.,Ltd.",
	[3]byte{0, 26, 150}:    "ECLER S.A.",
	[3]byte{0, 26, 151}:    "fitivision technology Inc.",
	[3]byte{0, 26, 152}:    "Asotel Communication Limited Taiwan Branch",
	[3]byte{0, 26, 153}:    "Smarty (HZ) Information Electronics Co., Ltd",
	[3]byte{0, 26, 154}:    "Skyworth Digital technology(shenzhen)co.ltd.",
	[3]byte{0, 26, 155}:    "ADEC & Parter AG",
	[3]byte{0, 26, 156}:    "RightHand Technologies, Inc.",
	[3]byte{0, 26, 157}:    "Skipper Wireless, Inc.",
	[3]byte{0, 26, 158}:    "ICON Digital International Limited",
	[3]byte{0, 26, 159}:    "A-Link Ltd",
	[3]byte{0, 26, 160}:    "Dell Inc",
	[3]byte{0, 26, 161}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 26, 162}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 26, 163}:    "DELORME",
	[3]byte{0, 26, 164}:    "Future University-Hakodate",
	[3]byte{0, 26, 165}:    "BRN Phoenix",
	[3]byte{0, 26, 166}:    "Telefunken Radio Communication Systems GmbH &CO.KG",
	[3]byte{0, 26, 167}:    "Torian Wireless",
	[3]byte{0, 26, 168}:    "Mamiya Digital Imaging Co., Ltd.",
	[3]byte{0, 26, 169}:    "FUJIAN STAR-NET COMMUNICATION CO.,LTD",
	[3]byte{0, 26, 170}:    "Analogic Corp.",
	[3]byte{0, 26, 171}:    "eWings s.r.l.",
	[3]byte{0, 26, 172}:    "Corelatus AB",
	[3]byte{0, 26, 173}:    "ARRIS Group, Inc.",
	[3]byte{0, 26, 174}:    "Savant Systems LLC",
	[3]byte{0, 26, 175}:    "BLUSENS TECHNOLOGY",
	[3]byte{0, 26, 176}:    "Signal Networks Pvt. Ltd.,",
	[3]byte{0, 26, 177}:    "Asia Pacific Satellite Industries Co., Ltd.",
	[3]byte{0, 26, 178}:    "Cyber Solutions Inc.",
	[3]byte{0, 26, 179}:    "VISIONITE INC.",
	[3]byte{0, 26, 180}:    "FFEI Ltd.",
	[3]byte{0, 26, 181}:    "Home Network System",
	[3]byte{0, 26, 182}:    "Texas Instruments",
	[3]byte{0, 26, 183}:    "Ethos Networks LTD.",
	[3]byte{0, 26, 184}:    "Anseri Corporation",
	[3]byte{0, 26, 185}:    "PMC",
	[3]byte{0, 26, 186}:    "Caton Overseas Limited",
	[3]byte{0, 26, 187}:    "Fontal Technology Incorporation",
	[3]byte{0, 26, 188}:    "U4EA Technologies Ltd",
	[3]byte{0, 26, 189}:    "Impatica Inc.",
	[3]byte{0, 26, 190}:    "COMPUTER HI-TECH INC.",
	[3]byte{0, 26, 191}:    "TRUMPF Laser Marking Systems AG",
	[3]byte{0, 26, 192}:    "JOYBIEN TECHNOLOGIES CO., LTD.",
	[3]byte{0, 26, 193}:    "3Com Ltd",
	[3]byte{0, 26, 194}:    "YEC Co.,Ltd.",
	[3]byte{0, 26, 195}:    "Scientific-Atlanta, Inc",
	[3]byte{0, 26, 196}:    "2Wire, Inc",
	[3]byte{0, 26, 197}:    "BreakingPoint Systems, Inc.",
	[3]byte{0, 26, 198}:    "Micro Control Designs",
	[3]byte{0, 26, 199}:    "UNIPOINT",
	[3]byte{0, 26, 200}:    "ISL (Instrumentation Scientifique de Laboratoire)",
	[3]byte{0, 26, 201}:    "SUZUKEN CO.,LTD",
	[3]byte{0, 26, 202}:    "Tilera Corporation",
	[3]byte{0, 26, 203}:    "Autocom Products Ltd",
	[3]byte{0, 26, 204}:    "Celestial Semiconductor, Ltd",
	[3]byte{0, 26, 205}:    "Tidel Engineering LP",
	[3]byte{0, 26, 206}:    "YUPITERU CORPORATION",
	[3]byte{0, 26, 207}:    "C.T. ELETTRONICA",
	[3]byte{0, 26, 208}:    "Albis Technologies AG",
	[3]byte{0, 26, 209}:    "FARGO CO., LTD.",
	[3]byte{0, 26, 210}:    "Eletronica Nitron Ltda",
	[3]byte{0, 26, 211}:    "Vamp Ltd.",
	[3]byte{0, 26, 212}:    "iPOX Technology Co., Ltd.",
	[3]byte{0, 26, 213}:    "KMC CHAIN INDUSTRIAL CO., LTD.",
	[3]byte{0, 26, 214}:    "JIAGNSU AETNA ELECTRIC CO.,LTD",
	[3]byte{0, 26, 215}:    "Christie Digital Systems, Inc.",
	[3]byte{0, 26, 216}:    "AlsterAero GmbH",
	[3]byte{0, 26, 217}:    "International Broadband Electric Communications, Inc.",
	[3]byte{0, 26, 218}:    "Biz-2-Me Inc.",
	[3]byte{0, 26, 219}:    "ARRIS Group, Inc.",
	[3]byte{0, 26, 220}:    "Nokia Danmark A/S",
	[3]byte{0, 26, 221}:    "PePWave Ltd",
	[3]byte{0, 26, 222}:    "ARRIS Group, Inc.",
	[3]byte{0, 26, 223}:    "Interactivetv Pty Limited",
	[3]byte{0, 26, 224}:    "Mythology Tech Express Inc.",
	[3]byte{0, 26, 225}:    "EDGE ACCESS INC",
	[3]byte{0, 26, 226}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 26, 227}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 26, 228}:    "Medicis Technologies Corporation",
	[3]byte{0, 26, 229}:    "Mvox Technologies Inc.",
	[3]byte{0, 26, 230}:    "Atlanta Advanced Communications Holdings Limited",
	[3]byte{0, 26, 231}:    "Aztek Networks, Inc.",
	[3]byte{0, 26, 232}:    "Unify GmbH and Co KG",
	[3]byte{0, 26, 233}:    "Nintendo Co., Ltd.",
	[3]byte{0, 26, 234}:    "Radio Terminal Systems Pty Ltd",
	[3]byte{0, 26, 235}:    "Allied Telesis K.K.",
	[3]byte{0, 26, 236}:    "Keumbee Electronics Co.,Ltd.",
	[3]byte{0, 26, 237}:    "INCOTEC GmbH",
	[3]byte{0, 26, 238}:    "Shenztech Ltd",
	[3]byte{0, 26, 239}:    "Loopcomm Technology, Inc.",
	[3]byte{0, 26, 240}:    "Alcatel - IPD",
	[3]byte{0, 26, 241}:    "Embedded Artists AB",
	[3]byte{0, 26, 242}:    "Dynavisions Schweiz AG",
	[3]byte{0, 26, 243}:    "Samyoung Electronics",
	[3]byte{0, 26, 244}:    "Handreamnet",
	[3]byte{0, 26, 245}:    "PENTAONE. CO., LTD.",
	[3]byte{0, 26, 246}:    "Woven Systems, Inc.",
	[3]byte{0, 26, 247}:    "dataschalt e+a GmbH",
	[3]byte{0, 26, 248}:    "Copley Controls Corporation",
	[3]byte{0, 26, 249}:    "AeroVIronment (AV Inc)",
	[3]byte{0, 26, 250}:    "Welch Allyn, Inc.",
	[3]byte{0, 26, 251}:    "Joby Inc.",
	[3]byte{0, 26, 252}:    "ModusLink Corporation",
	[3]byte{0, 26, 253}:    "EVOLIS",
	[3]byte{0, 26, 254}:    "SOFACREAL",
	[3]byte{0, 26, 255}:    "Wizyoung Tech.",
	[3]byte{0, 27, 0}:      "Neopost Technologies",
	[3]byte{0, 27, 1}:      "Applied Radio Technologies",
	[3]byte{0, 27, 2}:      "ED Co.Ltd",
	[3]byte{0, 27, 3}:      "Action Technology (SZ) Co., Ltd",
	[3]byte{0, 27, 4}:      "Affinity International S.p.a",
	[3]byte{0, 27, 5}:      "YMC AG",
	[3]byte{0, 27, 6}:      "Ateliers R. LAUMONIER",
	[3]byte{0, 27, 7}:      "Mendocino Software",
	[3]byte{0, 27, 8}:      "Danfoss Drives A/S",
	[3]byte{0, 27, 9}:      "Matrix Telecom Pvt. Ltd.",
	[3]byte{0, 27, 10}:     "Intelligent Distributed Controls Ltd",
	[3]byte{0, 27, 11}:     "Phidgets Inc.",
	[3]byte{0, 27, 12}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 27, 13}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 27, 14}:     "InoTec GmbH Organisationssysteme",
	[3]byte{0, 27, 15}:     "Petratec",
	[3]byte{0, 27, 16}:     "ShenZhen Kang Hui Technology Co.,ltd",
	[3]byte{0, 27, 17}:     "D-Link Corporation",
	[3]byte{0, 27, 18}:     "Apprion",
	[3]byte{0, 27, 19}:     "Icron Technologies Corporation",
	[3]byte{0, 27, 20}:     "Carex Lighting Equipment Factory",
	[3]byte{0, 27, 21}:     "Voxtel, Inc.",
	[3]byte{0, 27, 22}:     "Celtro Ltd.",
	[3]byte{0, 27, 23}:     "Palo Alto Networks",
	[3]byte{0, 27, 24}:     "Tsuken Electric Ind. Co.,Ltd",
	[3]byte{0, 27, 25}:     "IEEE I&M Society TC9",
	[3]byte{0, 27, 26}:     "e-trees Japan, Inc.",
	[3]byte{0, 27, 27}:     "Siemens AG,",
	[3]byte{0, 27, 28}:     "Coherent",
	[3]byte{0, 27, 29}:     "Phoenix International Co., Ltd",
	[3]byte{0, 27, 30}:     "HART Communication Foundation",
	[3]byte{0, 27, 31}:     "DELTA - Danish Electronics, Light & Acoustics",
	[3]byte{0, 27, 32}:     "TPine Technology",
	[3]byte{0, 27, 33}:     "Intel Corporate",
	[3]byte{0, 27, 34}:     "Palit Microsystems ( H.K.) Ltd.",
	[3]byte{0, 27, 35}:     "SimpleComTools",
	[3]byte{0, 27, 36}:     "Quanta Computer Inc.",
	[3]byte{0, 27, 37}:     "Nortel",
	[3]byte{0, 27, 38}:     "RON-Telecom ZAO",
	[3]byte{0, 27, 39}:     "Merlin CSI",
	[3]byte{0, 27, 40}:     "POLYGON, JSC",
	[3]byte{0, 27, 41}:     "Avantis.Co.,Ltd",
	[3]byte{0, 27, 42}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 27, 43}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 27, 44}:     "ATRON electronic GmbH",
	[3]byte{0, 27, 45}:     "Med-Eng Systems Inc.",
	[3]byte{0, 27, 46}:     "Sinkyo Electron Inc",
	[3]byte{0, 27, 47}:     "NETGEAR Inc.",
	[3]byte{0, 27, 48}:     "Solitech Inc.",
	[3]byte{0, 27, 49}:     "Neural Image. Co. Ltd.",
	[3]byte{0, 27, 50}:     "QLogic Corporation",
	[3]byte{0, 27, 51}:     "Nokia Danmark A/S",
	[3]byte{0, 27, 52}:     "Focus System Inc.",
	[3]byte{0, 27, 53}:     "ChongQing JINOU Science & Technology Development CO.,Ltd",
	[3]byte{0, 27, 54}:     "Tsubata Engineering Co.,Ltd. (Head Office)",
	[3]byte{0, 27, 55}:     "Computec Oy",
	[3]byte{0, 27, 56}:     "COMPAL INFORMATION (KUNSHAN) CO., LTD.",
	[3]byte{0, 27, 57}:     "Proxicast",
	[3]byte{0, 27, 58}:     "SIMS Corp.",
	[3]byte{0, 27, 59}:     "Yi-Qing CO., LTD",
	[3]byte{0, 27, 60}:     "Software Technologies Group,Inc.",
	[3]byte{0, 27, 61}:     "EuroTel Spa",
	[3]byte{0, 27, 62}:     "Curtis, Inc.",
	[3]byte{0, 27, 63}:     "ProCurve Networking by HP",
	[3]byte{0, 27, 64}:     "Network Automation mxc AB",
	[3]byte{0, 27, 65}:     "General Infinity Co.,Ltd.",
	[3]byte{0, 27, 66}:     "Wise & Blue",
	[3]byte{0, 27, 67}:     "Beijing DG Telecommunications equipment Co.,Ltd",
	[3]byte{0, 27, 68}:     "SanDisk Corporation",
	[3]byte{0, 27, 69}:     "ABB AS, Division Automation Products",
	[3]byte{0, 27, 70}:     "Blueone Technology Co.,Ltd",
	[3]byte{0, 27, 71}:     "Futarque A/S",
	[3]byte{0, 27, 72}:     "Shenzhen Lantech Electronics Co., Ltd.",
	[3]byte{0, 27, 73}:     "Roberts Radio limited",
	[3]byte{0, 27, 74}:     "W&W Communications, Inc.",
	[3]byte{0, 27, 75}:     "SANION Co., Ltd.",
	[3]byte{0, 27, 76}:     "Signtech",
	[3]byte{0, 27, 77}:     "Areca Technology Corporation",
	[3]byte{0, 27, 78}:     "Navman New Zealand",
	[3]byte{0, 27, 79}:     "Avaya Inc.",
	[3]byte{0, 27, 80}:     "Nizhny Novgorod Factory named after M.Frunze, FSUE (NZiF)",
	[3]byte{0, 27, 81}:     "Vector Technology Corp.",
	[3]byte{0, 27, 82}:     "ARRIS Group, Inc.",
	[3]byte{0, 27, 83}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 27, 84}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 27, 85}:     "Hurco Automation Ltd.",
	[3]byte{0, 27, 86}:     "Tehuti Networks Ltd.",
	[3]byte{0, 27, 87}:     "SEMINDIA SYSTEMS PRIVATE LIMITED",
	[3]byte{0, 27, 88}:     "ACE CAD Enterprise Co., Ltd.",
	[3]byte{0, 27, 89}:     "Sony Ericsson Mobile Communications AB",
	[3]byte{0, 27, 90}:     "Apollo Imaging Technologies, Inc.",
	[3]byte{0, 27, 91}:     "2Wire, Inc.",
	[3]byte{0, 27, 92}:     "Azuretec Co., Ltd.",
	[3]byte{0, 27, 93}:     "Vololink Pty Ltd",
	[3]byte{0, 27, 94}:     "BPL Limited",
	[3]byte{0, 27, 95}:     "Alien Technology",
	[3]byte{0, 27, 96}:     "NAVIGON AG",
	[3]byte{0, 27, 97}:     "Digital Acoustics, LLC",
	[3]byte{0, 27, 98}:     "JHT Optoelectronics Co.,Ltd.",
	[3]byte{0, 27, 99}:     "Apple",
	[3]byte{0, 27, 100}:    "IsaacLandKorea Co., Ltd,",
	[3]byte{0, 27, 101}:    "China Gridcom Co., Ltd",
	[3]byte{0, 27, 102}:    "Sennheiser electronic GmbH & Co. KG",
	[3]byte{0, 27, 103}:    "Cisco Systems Inc",
	[3]byte{0, 27, 104}:    "Modnnet Co., Ltd",
	[3]byte{0, 27, 105}:    "Equaline Corporation",
	[3]byte{0, 27, 106}:    "Powerwave Technologies Sweden AB",
	[3]byte{0, 27, 107}:    "Swyx Solutions AG",
	[3]byte{0, 27, 108}:    "LookX Digital Media BV",
	[3]byte{0, 27, 109}:    "Midtronics, Inc.",
	[3]byte{0, 27, 110}:    "Anue Systems, Inc.",
	[3]byte{0, 27, 111}:    "Teletrak Ltd",
	[3]byte{0, 27, 112}:    "IRI Ubiteq, INC.",
	[3]byte{0, 27, 113}:    "Telular Corp.",
	[3]byte{0, 27, 114}:    "Sicep s.p.a.",
	[3]byte{0, 27, 115}:    "DTL Broadcast Ltd",
	[3]byte{0, 27, 116}:    "MiraLink Corporation",
	[3]byte{0, 27, 117}:    "Hypermedia Systems",
	[3]byte{0, 27, 118}:    "Ripcode, Inc.",
	[3]byte{0, 27, 119}:    "Intel Corporate",
	[3]byte{0, 27, 120}:    "Hewlett-Packard Company",
	[3]byte{0, 27, 121}:    "FAIVELEY TRANSPORT",
	[3]byte{0, 27, 122}:    "Nintendo Co., Ltd.",
	[3]byte{0, 27, 123}:    "The Tintometer Ltd",
	[3]byte{0, 27, 124}:    "A & R Cambridge",
	[3]byte{0, 27, 125}:    "CXR Anderson Jacobson",
	[3]byte{0, 27, 126}:    "Beckmann GmbH",
	[3]byte{0, 27, 127}:    "TMN Technologies Telecomunicacoes Ltda",
	[3]byte{0, 27, 128}:    "LORD Corporation",
	[3]byte{0, 27, 129}:    "DATAQ Instruments, Inc.",
	[3]byte{0, 27, 130}:    "Taiwan Semiconductor Co., Ltd.",
	[3]byte{0, 27, 131}:    "Finsoft Ltd",
	[3]byte{0, 27, 132}:    "Scan Engineering Telecom",
	[3]byte{0, 27, 133}:    "MAN Diesel SE",
	[3]byte{0, 27, 134}:    "Bosch Access Systems GmbH",
	[3]byte{0, 27, 135}:    "Deepsound Tech. Co., Ltd",
	[3]byte{0, 27, 136}:    "Divinet Access Technologies Ltd",
	[3]byte{0, 27, 137}:    "EMZA Visual Sense Ltd.",
	[3]byte{0, 27, 138}:    "2M Electronic A/S",
	[3]byte{0, 27, 139}:    "NEC Platforms, Ltd.",
	[3]byte{0, 27, 140}:    "JMicron Technology Corp.",
	[3]byte{0, 27, 141}:    "Electronic Computer Systems, Inc.",
	[3]byte{0, 27, 142}:    "Hulu Sweden AB",
	[3]byte{0, 27, 143}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 27, 144}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 27, 145}:    "EFKON AG",
	[3]byte{0, 27, 146}:    "l-acoustics",
	[3]byte{0, 27, 147}:    "JC Decaux SA DNT",
	[3]byte{0, 27, 148}:    "T.E.M.A. S.p.A.",
	[3]byte{0, 27, 149}:    "VIDEO SYSTEMS SRL",
	[3]byte{0, 27, 150}:    "General Sensing",
	[3]byte{0, 27, 151}:    "Violin Technologies",
	[3]byte{0, 27, 152}:    "Samsung Electronics Co., Ltd.",
	[3]byte{0, 27, 153}:    "KS System GmbH",
	[3]byte{0, 27, 154}:    "Apollo Fire Detectors Ltd",
	[3]byte{0, 27, 155}:    "Hose-McCann Communications",
	[3]byte{0, 27, 156}:    "SATEL sp. z o.o.",
	[3]byte{0, 27, 157}:    "Novus Security Sp. z o.o.",
	[3]byte{0, 27, 158}:    "ASKEY  COMPUTER  CORP",
	[3]byte{0, 27, 159}:    "Calyptech Pty Ltd",
	[3]byte{0, 27, 160}:    "Awox",
	[3]byte{0, 27, 161}:    "Åmic AB",
	[3]byte{0, 27, 162}:    "IDS Imaging Development Systems GmbH",
	[3]byte{0, 27, 163}:    "Flexit Group GmbH",
	[3]byte{0, 27, 164}:    "S.A.E Afikim",
	[3]byte{0, 27, 165}:    "MyungMin Systems, Inc.",
	[3]byte{0, 27, 166}:    "intotech inc.",
	[3]byte{0, 27, 167}:    "Lorica Solutions",
	[3]byte{0, 27, 168}:    "UBI&MOBI,.Inc",
	[3]byte{0, 27, 169}:    "BROTHER INDUSTRIES, LTD.",
	[3]byte{0, 27, 170}:    "XenICs nv",
	[3]byte{0, 27, 171}:    "Telchemy, Incorporated",
	[3]byte{0, 27, 172}:    "Curtiss Wright Controls Embedded Computing",
	[3]byte{0, 27, 173}:    "iControl Incorporated",
	[3]byte{0, 27, 174}:    "Micro Control Systems, Inc",
	[3]byte{0, 27, 175}:    "Nokia Danmark A/S",
	[3]byte{0, 27, 176}:    "BHARAT ELECTRONICS",
	[3]byte{0, 27, 177}:    "Wistron Neweb Corp.",
	[3]byte{0, 27, 178}:    "Intellect International NV",
	[3]byte{0, 27, 179}:    "Condalo GmbH",
	[3]byte{0, 27, 180}:    "Airvod Limited",
	[3]byte{0, 27, 181}:    "ZF Electronics GmbH",
	[3]byte{0, 27, 182}:    "Bird Electronic Corp.",
	[3]byte{0, 27, 183}:    "Alta Heights Technology Corp.",
	[3]byte{0, 27, 184}:    "BLUEWAY ELECTRONIC CO;LTD",
	[3]byte{0, 27, 185}:    "Elitegroup Computer System Co.",
	[3]byte{0, 27, 186}:    "Nortel",
	[3]byte{0, 27, 187}:    "RFTech Co.,Ltd",
	[3]byte{0, 27, 188}:    "Silver Peak Systems, Inc.",
	[3]byte{0, 27, 189}:    "FMC Kongsberg Subsea AS",
	[3]byte{0, 27, 190}:    "ICOP Digital",
	[3]byte{0, 27, 191}:    "SAGEM COMMUNICATION",
	[3]byte{0, 27, 192}:    "Juniper Networks",
	[3]byte{0, 27, 193}:    "HOLUX Technology, Inc.",
	[3]byte{0, 27, 194}:    "Integrated Control Technology Limitied",
	[3]byte{0, 27, 195}:    "Mobisolution Co.,Ltd",
	[3]byte{0, 27, 196}:    "Ultratec, Inc.",
	[3]byte{0, 27, 197}:    "IEEE Registration Authority",
	[3]byte{0, 27, 198}:    "Strato Rechenzentrum AG",
	[3]byte{0, 27, 199}:    "StarVedia Technology Inc.",
	[3]byte{0, 27, 200}:    "MIURA CO.,LTD",
	[3]byte{0, 27, 201}:    "FSN DISPLAY INC",
	[3]byte{0, 27, 202}:    "Beijing Run Technology LTD. Company",
	[3]byte{0, 27, 203}:    "PEMPEK SYSTEMS PTY LTD",
	[3]byte{0, 27, 204}:    "KINGTEK CCTV ALLIANCE CO., LTD.",
	[3]byte{0, 27, 205}:    "DAVISCOMMS (S) PTE LTD",
	[3]byte{0, 27, 206}:    "Measurement Devices Ltd",
	[3]byte{0, 27, 207}:    "Dataupia Corporation",
	[3]byte{0, 27, 208}:    "IDENTEC SOLUTIONS",
	[3]byte{0, 27, 209}:    "SOGESTMATIC",
	[3]byte{0, 27, 210}:    "ULTRA-X ASIA PACIFIC Inc.",
	[3]byte{0, 27, 211}:    "Panasonic Corp. AVC Company",
	[3]byte{0, 27, 212}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 27, 213}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 27, 214}:    "Kelvin Hughes Ltd",
	[3]byte{0, 27, 215}:    "Scientific Atlanta, A Cisco Company",
	[3]byte{0, 27, 216}:    "DVTel LTD",
	[3]byte{0, 27, 217}:    "Edgewater Computer Systems",
	[3]byte{0, 27, 218}:    "UTStarcom Inc",
	[3]byte{0, 27, 219}:    "Valeo VECS",
	[3]byte{0, 27, 220}:    "Vencer Co., Ltd.",
	[3]byte{0, 27, 221}:    "ARRIS Group, Inc.",
	[3]byte{0, 27, 222}:    "Renkus-Heinz, Inc.",
	[3]byte{0, 27, 223}:    "Iskra Sistemi d.d.",
	[3]byte{0, 27, 224}:    "TELENOT ELECTRONIC GmbH",
	[3]byte{0, 27, 225}:    "ViaLogy",
	[3]byte{0, 27, 226}:    "AhnLab,Inc.",
	[3]byte{0, 27, 227}:    "Health Hero Network, Inc.",
	[3]byte{0, 27, 228}:    "TOWNET SRL",
	[3]byte{0, 27, 229}:    "802automation Limited",
	[3]byte{0, 27, 230}:    "VR AG",
	[3]byte{0, 27, 231}:    "Postek Electronics Co., Ltd.",
	[3]byte{0, 27, 232}:    "Ultratronik GmbH",
	[3]byte{0, 27, 233}:    "Broadcom Corporation",
	[3]byte{0, 27, 234}:    "Nintendo Co., Ltd.",
	[3]byte{0, 27, 235}:    "DMP Electronics INC.",
	[3]byte{0, 27, 236}:    "Netio Technologies Co., Ltd",
	[3]byte{0, 27, 237}:    "Brocade Communications Systems, Inc",
	[3]byte{0, 27, 238}:    "Nokia Danmark A/S",
	[3]byte{0, 27, 239}:    "Blossoms Digital Technology Co.,Ltd.",
	[3]byte{0, 27, 240}:    "Value Platforms Limited",
	[3]byte{0, 27, 241}:    "Nanjing SilverNet Software Co., Ltd.",
	[3]byte{0, 27, 242}:    "KWORLD COMPUTER CO., LTD",
	[3]byte{0, 27, 243}:    "TRANSRADIO SenderSysteme Berlin AG",
	[3]byte{0, 27, 244}:    "KENWIN INDUSTRIAL(HK) LTD.",
	[3]byte{0, 27, 245}:    "Tellink Sistemas de Telecomunicación S.L.",
	[3]byte{0, 27, 246}:    "CONWISE Technology Corporation Ltd.",
	[3]byte{0, 27, 247}:    "Lund IP Products AB",
	[3]byte{0, 27, 248}:    "Digitrax Inc.",
	[3]byte{0, 27, 249}:    "Intellitect Water Ltd",
	[3]byte{0, 27, 250}:    "G.i.N. mbH",
	[3]byte{0, 27, 251}:    "Alps Electric Co., Ltd",
	[3]byte{0, 27, 252}:    "ASUSTek COMPUTER INC.",
	[3]byte{0, 27, 253}:    "Dignsys Inc.",
	[3]byte{0, 27, 254}:    "Zavio Inc.",
	[3]byte{0, 27, 255}:    "Millennia Media inc.",
	[3]byte{0, 28, 0}:      "Entry Point, LLC",
	[3]byte{0, 28, 1}:      "ABB Oy Drives",
	[3]byte{0, 28, 2}:      "Pano Logic",
	[3]byte{0, 28, 3}:      "Betty TV Technology AG",
	[3]byte{0, 28, 4}:      "Airgain, Inc.",
	[3]byte{0, 28, 5}:      "Nonin Medical Inc.",
	[3]byte{0, 28, 6}:      "Siemens Numerical Control Ltd., Nanjing",
	[3]byte{0, 28, 7}:      "Cwlinux Limited",
	[3]byte{0, 28, 8}:      "Echo360, Inc.",
	[3]byte{0, 28, 9}:      "SAE Electronic Co.,Ltd.",
	[3]byte{0, 28, 10}:     "Shenzhen AEE Technology Co.,Ltd.",
	[3]byte{0, 28, 11}:     "SmartAnt Telecom",
	[3]byte{0, 28, 12}:     "TANITA Corporation",
	[3]byte{0, 28, 13}:     "G-Technology, Inc.",
	[3]byte{0, 28, 14}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 28, 15}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 28, 16}:     "Cisco-Linksys, LLC",
	[3]byte{0, 28, 17}:     "ARRIS Group, Inc.",
	[3]byte{0, 28, 18}:     "ARRIS Group, Inc.",
	[3]byte{0, 28, 19}:     "OPTSYS TECHNOLOGY CO., LTD.",
	[3]byte{0, 28, 20}:     "VMware, Inc",
	[3]byte{0, 28, 21}:     "iPhotonix LLC",
	[3]byte{0, 28, 22}:     "ThyssenKrupp Elevator",
	[3]byte{0, 28, 23}:     "Nortel",
	[3]byte{0, 28, 24}:     "Sicert S.r.L.",
	[3]byte{0, 28, 25}:     "secunet Security Networks AG",
	[3]byte{0, 28, 26}:     "Thomas Instrumentation, Inc",
	[3]byte{0, 28, 27}:     "Hyperstone GmbH",
	[3]byte{0, 28, 28}:     "Center Communication Systems GmbH",
	[3]byte{0, 28, 29}:     "CHENZHOU GOSPELL DIGITAL TECHNOLOGY CO.,LTD",
	[3]byte{0, 28, 30}:     "emtrion GmbH",
	[3]byte{0, 28, 31}:     "Quest Retail Technology Pty Ltd",
	[3]byte{0, 28, 32}:     "CLB Benelux",
	[3]byte{0, 28, 33}:     "Nucsafe Inc.",
	[3]byte{0, 28, 34}:     "Aeris Elettronica s.r.l.",
	[3]byte{0, 28, 35}:     "Dell Inc",
	[3]byte{0, 28, 36}:     "Formosa Wireless Systems Corp.",
	[3]byte{0, 28, 37}:     "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{0, 28, 38}:     "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{0, 28, 39}:     "Sunell Electronics Co.",
	[3]byte{0, 28, 40}:     "Sphairon Technologies GmbH",
	[3]byte{0, 28, 41}:     "CORE DIGITAL ELECTRONICS CO., LTD",
	[3]byte{0, 28, 42}:     "Envisacor Technologies Inc.",
	[3]byte{0, 28, 43}:     "Alertme.com Limited",
	[3]byte{0, 28, 44}:     "Synapse",
	[3]byte{0, 28, 45}:     "FlexRadio Systems",
	[3]byte{0, 28, 46}:     "HPN Supply Chain",
	[3]byte{0, 28, 47}:     "Pfister GmbH",
	[3]byte{0, 28, 48}:     "Mode Lighting (UK ) Ltd.",
	[3]byte{0, 28, 49}:     "Mobile XP Technology Co., LTD",
	[3]byte{0, 28, 50}:     "Telian Corporation",
	[3]byte{0, 28, 51}:     "Sutron",
	[3]byte{0, 28, 52}:     "HUEY CHIAO INTERNATIONAL CO., LTD.",
	[3]byte{0, 28, 53}:     "Nokia Danmark A/S",
	[3]byte{0, 28, 54}:     "iNEWiT NV",
	[3]byte{0, 28, 55}:     "Callpod, Inc.",
	[3]byte{0, 28, 56}:     "Bio-Rad Laboratories, Inc.",
	[3]byte{0, 28, 57}:     "S Netsystems Inc.",
	[3]byte{0, 28, 58}:     "Element Labs, Inc.",
	[3]byte{0, 28, 59}:     "AmRoad Technology Inc.",
	[3]byte{0, 28, 60}:     "Seon Design Inc.",
	[3]byte{0, 28, 61}:     "WaveStorm",
	[3]byte{0, 28, 62}:     "ECKey Corporation",
	[3]byte{0, 28, 63}:     "International Police Technologies, Inc.",
	[3]byte{0, 28, 64}:     "VDG-Security bv",
	[3]byte{0, 28, 65}:     "scemtec Transponder Technology GmbH",
	[3]byte{0, 28, 66}:     "Parallels, Inc.",
	[3]byte{0, 28, 67}:     "Samsung Electronics Co.,Ltd",
	[3]byte{0, 28, 68}:     "Bosch Security Systems BV",
	[3]byte{0, 28, 69}:     "Chenbro Micom Co., Ltd.",
	[3]byte{0, 28, 70}:     "QTUM",
	[3]byte{0, 28, 71}:     "Hangzhou Hollysys Automation Co., Ltd",
	[3]byte{0, 28, 72}:     "WiDeFi, Inc.",
	[3]byte{0, 28, 73}:     "Zoltan Technology Inc.",
	[3]byte{0, 28, 74}:     "AVM GmbH",
	[3]byte{0, 28, 75}:     "Gener8, Inc.",
	[3]byte{0, 28, 76}:     "Petrotest Instruments",
	[3]byte{0, 28, 77}:     "Aplix IP Holdings Corporation",
	[3]byte{0, 28, 78}:     "TASA International Limited",
	[3]byte{0, 28, 79}:     "MACAB AB",
	[3]byte{0, 28, 80}:     "TCL Technoly Electronics(Huizhou)Co.,Ltd",
	[3]byte{0, 28, 81}:     "Celeno Communications",
	[3]byte{0, 28, 82}:     "VISIONEE SRL",
	[3]byte{0, 28, 83}:     "Synergy Lighting Controls",
	[3]byte{0, 28, 84}:     "Hillstone Networks Inc",
	[3]byte{0, 28, 85}:     "Shenzhen Kaifa Technology Co.",
	[3]byte{0, 28, 86}:     "Pado Systems, Inc.",
	[3]byte{0, 28, 87}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 28, 88}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 28, 89}:     "DEVON IT",
	[3]byte{0, 28, 90}:     "Advanced Relay Corporation",
	[3]byte{0, 28, 91}:     "Chubb Electronic Security Systems Ltd",
	[3]byte{0, 28, 92}:     "Integrated Medical Systems, Inc.",
	[3]byte{0, 28, 93}:     "Leica Microsystems",
	[3]byte{0, 28, 94}:     "ASTON France",
	[3]byte{0, 28, 95}:     "Winland Electronics, Inc.",
	[3]byte{0, 28, 96}:     "CSP Frontier Technologies,Inc.",
	[3]byte{0, 28, 97}:     "Galaxy  Microsystems LImited",
	[3]byte{0, 28, 98}:     "LG Electronics Inc",
	[3]byte{0, 28, 99}:     "TRUEN",
	[3]byte{0, 28, 100}:    "Landis+Gyr",
	[3]byte{0, 28, 101}:    "JoeScan, Inc.",
	[3]byte{0, 28, 102}:    "UCAMP CO.,LTD",
	[3]byte{0, 28, 103}:    "Pumpkin Networks, Inc.",
	[3]byte{0, 28, 104}:    "Anhui Sun Create Electronics Co., Ltd",
	[3]byte{0, 28, 105}:    "Packet Vision Ltd",
	[3]byte{0, 28, 106}:    "Weiss Engineering Ltd.",
	[3]byte{0, 28, 107}:    "COVAX  Co. Ltd",
	[3]byte{0, 28, 108}:    "Jabil Circuit (Guangzhou) Limited",
	[3]byte{0, 28, 109}:    "KYOHRITSU ELECTRONIC INDUSTRY CO., LTD.",
	[3]byte{0, 28, 110}:    "Newbury Networks, Inc.",
	[3]byte{0, 28, 111}:    "Emfit Ltd",
	[3]byte{0, 28, 112}:    "NOVACOMM LTDA",
	[3]byte{0, 28, 113}:    "Emergent Electronics",
	[3]byte{0, 28, 114}:    "Mayer & Cie GmbH & Co KG",
	[3]byte{0, 28, 115}:    "Arista Networks, Inc.",
	[3]byte{0, 28, 116}:    "Syswan Technologies Inc.",
	[3]byte{0, 28, 117}:    "Segnet Ltd.",
	[3]byte{0, 28, 118}:    "The Wandsworth Group Ltd",
	[3]byte{0, 28, 119}:    "Prodys",
	[3]byte{0, 28, 120}:    "WYPLAY SAS",
	[3]byte{0, 28, 121}:    "Cohesive Financial Technologies LLC",
	[3]byte{0, 28, 122}:    "Perfectone Netware Company Ltd",
	[3]byte{0, 28, 123}:    "Castlenet Technology Inc.",
	[3]byte{0, 28, 124}:    "PERQ SYSTEMS CORPORATION",
	[3]byte{0, 28, 125}:    "Excelpoint Manufacturing Pte Ltd",
	[3]byte{0, 28, 126}:    "Toshiba",
	[3]byte{0, 28, 127}:    "Check Point Software Technologies",
	[3]byte{0, 28, 128}:    "New Business Division/Rhea-Information CO., LTD.",
	[3]byte{0, 28, 129}:    "NextGen Venturi LTD",
	[3]byte{0, 28, 130}:    "Genew Technologies",
	[3]byte{0, 28, 131}:    "New Level Telecom Co., Ltd.",
	[3]byte{0, 28, 132}:    "STL Solution Co.,Ltd.",
	[3]byte{0, 28, 133}:    "Eunicorn",
	[3]byte{0, 28, 134}:    "Cranite Systems, Inc.",
	[3]byte{0, 28, 135}:    "Uriver Inc.",
	[3]byte{0, 28, 136}:    "TRANSYSTEM INC.",
	[3]byte{0, 28, 137}:    "Force Communications, Inc.",
	[3]byte{0, 28, 138}:    "Cirrascale Corporation",
	[3]byte{0, 28, 139}:    "MJ Innovations Ltd.",
	[3]byte{0, 28, 140}:    "DIAL TECHNOLOGY LTD.",
	[3]byte{0, 28, 141}:    "Mesa Imaging",
	[3]byte{0, 28, 142}:    "Alcatel-Lucent IPD",
	[3]byte{0, 28, 143}:    "Advanced Electronic Design, Inc.",
	[3]byte{0, 28, 144}:    "Empacket Corporation",
	[3]byte{0, 28, 145}:    "Gefen Inc.",
	[3]byte{0, 28, 146}:    "Tervela",
	[3]byte{0, 28, 147}:    "ExaDigm Inc",
	[3]byte{0, 28, 148}:    "LI-COR Biosciences",
	[3]byte{0, 28, 149}:    "Opticomm Corporation",
	[3]byte{0, 28, 150}:    "Linkwise Technology Pte Ltd",
	[3]byte{0, 28, 151}:    "Enzytek Technology Inc.,",
	[3]byte{0, 28, 152}:    "LUCKY TECHNOLOGY (HK) COMPANY LIMITED",
	[3]byte{0, 28, 153}:    "Shunra Software Ltd.",
	[3]byte{0, 28, 154}:    "Nokia Danmark A/S",
	[3]byte{0, 28, 155}:    "FEIG ELECTRONIC GmbH",
	[3]byte{0, 28, 156}:    "Nortel",
	[3]byte{0, 28, 157}:    "Liecthi AG",
	[3]byte{0, 28, 158}:    "Dualtech IT AB",
	[3]byte{0, 28, 159}:    "Razorstream, LLC",
	[3]byte{0, 28, 160}:    "Production Resource Group, LLC",
	[3]byte{0, 28, 161}:    "AKAMAI TECHNOLOGIES, INC.",
	[3]byte{0, 28, 162}:    "ADB Broadband Italia",
	[3]byte{0, 28, 163}:    "Terra",
	[3]byte{0, 28, 164}:    "Sony Ericsson Mobile Communications",
	[3]byte{0, 28, 165}:    "Zygo Corporation",
	[3]byte{0, 28, 166}:    "Win4NET",
	[3]byte{0, 28, 167}:    "International Quartz Limited",
	[3]byte{0, 28, 168}:    "AirTies Wireless Networks",
	[3]byte{0, 28, 169}:    "Audiomatica Srl",
	[3]byte{0, 28, 170}:    "Bellon Pty Ltd",
	[3]byte{0, 28, 171}:    "Meyer Sound Laboratories, Inc.",
	[3]byte{0, 28, 172}:    "Qniq Technology Corp.",
	[3]byte{0, 28, 173}:    "Wuhan Telecommunication Devices Co.,Ltd",
	[3]byte{0, 28, 174}:    "WiChorus, Inc.",
	[3]byte{0, 28, 175}:    "Plato Networks Inc.",
	[3]byte{0, 28, 176}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 28, 177}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 28, 178}:    "BPT SPA",
	[3]byte{0, 28, 179}:    "Apple",
	[3]byte{0, 28, 180}:    "Iridium Satellite LLC",
	[3]byte{0, 28, 181}:    "Neihua Network Technology Co.,LTD.(NHN)",
	[3]byte{0, 28, 182}:    "Duzon CNT Co., Ltd.",
	[3]byte{0, 28, 183}:    "USC DigiArk Corporation",
	[3]byte{0, 28, 184}:    "CBC Co., Ltd",
	[3]byte{0, 28, 185}:    "KWANG SUNG ELECTRONICS CO., LTD.",
	[3]byte{0, 28, 186}:    "VerScient, Inc.",
	[3]byte{0, 28, 187}:    "MusicianLink",
	[3]byte{0, 28, 188}:    "CastGrabber, LLC",
	[3]byte{0, 28, 189}:    "Ezze Mobile Tech., Inc.",
	[3]byte{0, 28, 190}:    "Nintendo Co., Ltd.",
	[3]byte{0, 28, 191}:    "Intel Corporate",
	[3]byte{0, 28, 192}:    "Intel Corporate",
	[3]byte{0, 28, 193}:    "ARRIS Group, Inc.",
	[3]byte{0, 28, 194}:    "Part II Research, Inc.",
	[3]byte{0, 28, 195}:    "Pace plc",
	[3]byte{0, 28, 196}:    "Hewlett-Packard Company",
	[3]byte{0, 28, 197}:    "3COM LTD",
	[3]byte{0, 28, 198}:    "ProStor Systems",
	[3]byte{0, 28, 199}:    "Rembrandt Technologies, LLC d/b/a REMSTREAM",
	[3]byte{0, 28, 200}:    "INDUSTRONIC Industrie-Electronic GmbH & Co. KG",
	[3]byte{0, 28, 201}:    "Kaise Electronic Technology Co., Ltd.",
	[3]byte{0, 28, 202}:    "Shanghai Gaozhi Science & Technology Development Co.",
	[3]byte{0, 28, 203}:    "Forth Corporation Public Company Limited",
	[3]byte{0, 28, 204}:    "Research In Motion Limited",
	[3]byte{0, 28, 205}:    "Alektrona Corporation",
	[3]byte{0, 28, 206}:    "By Techdesign",
	[3]byte{0, 28, 207}:    "LIMETEK",
	[3]byte{0, 28, 208}:    "Circleone Co.,Ltd.",
	[3]byte{0, 28, 209}:    "Waves Audio LTD",
	[3]byte{0, 28, 210}:    "King Champion (Hong Kong) Limited",
	[3]byte{0, 28, 211}:    "ZP Engineering SEL",
	[3]byte{0, 28, 212}:    "Nokia Danmark A/S",
	[3]byte{0, 28, 213}:    "ZeeVee, Inc.",
	[3]byte{0, 28, 214}:    "Nokia Danmark A/S",
	[3]byte{0, 28, 215}:    "Harman/Becker Automotive Systems GmbH",
	[3]byte{0, 28, 216}:    "BlueAnt Wireless",
	[3]byte{0, 28, 217}:    "GlobalTop Technology Inc.",
	[3]byte{0, 28, 218}:    "Exegin Technologies Limited",
	[3]byte{0, 28, 219}:    "CARPOINT CO.,LTD",
	[3]byte{0, 28, 220}:    "Custom Computer Services, Inc.",
	[3]byte{0, 28, 221}:    "COWBELL ENGINEERING CO., LTD.",
	[3]byte{0, 28, 222}:    "Interactive Multimedia eXchange Inc.",
	[3]byte{0, 28, 223}:    "Belkin International Inc.",
	[3]byte{0, 28, 224}:    "DASAN TPS",
	[3]byte{0, 28, 225}:    "INDRA SISTEMAS, S.A.",
	[3]byte{0, 28, 226}:    "Attero Tech, LLC.",
	[3]byte{0, 28, 227}:    "Optimedical Systems",
	[3]byte{0, 28, 228}:    "EleSy JSC",
	[3]byte{0, 28, 229}:    "MBS Electronic Systems GmbH",
	[3]byte{0, 28, 230}:    "INNES",
	[3]byte{0, 28, 231}:    "Rocon PLC Research Centre",
	[3]byte{0, 28, 232}:    "Cummins Inc",
	[3]byte{0, 28, 233}:    "Galaxy Technology Limited",
	[3]byte{0, 28, 234}:    "Scientific-Atlanta, Inc",
	[3]byte{0, 28, 235}:    "Nortel",
	[3]byte{0, 28, 236}:    "Mobilesoft (Aust.) Pty Ltd",
	[3]byte{0, 28, 237}:    "ENVIRONNEMENT SA",
	[3]byte{0, 28, 238}:    "SHARP Corporation",
	[3]byte{0, 28, 239}:    "Primax Electronics LTD",
	[3]byte{0, 28, 240}:    "D-Link Corporation",
	[3]byte{0, 28, 241}:    "SUPoX Technology Co. , LTD.",
	[3]byte{0, 28, 242}:    "Tenlon Technology Co.,Ltd.",
	[3]byte{0, 28, 243}:    "EVS BROADCAST EQUIPMENT",
	[3]byte{0, 28, 244}:    "Media Technology Systems Inc",
	[3]byte{0, 28, 245}:    "Wiseblue Technology Limited",
	[3]byte{0, 28, 246}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 28, 247}:    "AudioScience",
	[3]byte{0, 28, 248}:    "Parade Technologies, Ltd.",
	[3]byte{0, 28, 249}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 28, 250}:    "Alarm.com",
	[3]byte{0, 28, 251}:    "ARRIS Group, Inc.",
	[3]byte{0, 28, 252}:    "Suminet Communication Technologies (Shanghai) Co., Ltd.",
	[3]byte{0, 28, 253}:    "Universal Electronics",
	[3]byte{0, 28, 254}:    "Quartics Inc",
	[3]byte{0, 28, 255}:    "Napera Networks Inc",
	[3]byte{0, 29, 0}:      "Brivo Systems, LLC",
	[3]byte{0, 29, 1}:      "Neptune Digital",
	[3]byte{0, 29, 2}:      "Cybertech Telecom Development",
	[3]byte{0, 29, 3}:      "Design Solutions Inc.",
	[3]byte{0, 29, 4}:      "Zipit Wireless, Inc.",
	[3]byte{0, 29, 5}:      "Eaton Corporation",
	[3]byte{0, 29, 6}:      "HM Electronics, Inc.",
	[3]byte{0, 29, 7}:      "Shenzhen Sang Fei Consumer Communications Co.,Ltd",
	[3]byte{0, 29, 8}:      "JIANGSU YINHE ELECTRONICS CO., LTD",
	[3]byte{0, 29, 9}:      "Dell Inc",
	[3]byte{0, 29, 10}:     "Davis Instruments, Inc.",
	[3]byte{0, 29, 11}:     "Power Standards Lab",
	[3]byte{0, 29, 12}:     "MobileCompia",
	[3]byte{0, 29, 13}:     "Sony Computer Entertainment inc.",
	[3]byte{0, 29, 14}:     "Agapha Technology co., Ltd.",
	[3]byte{0, 29, 15}:     "TP-LINK Technologies Co., Ltd.",
	[3]byte{0, 29, 16}:     "LightHaus Logic, Inc.",
	[3]byte{0, 29, 17}:     "Analogue & Micro Ltd",
	[3]byte{0, 29, 18}:     "ROHM CO., LTD.",
	[3]byte{0, 29, 19}:     "NextGTV",
	[3]byte{0, 29, 20}:     "SPERADTONE INFORMATION TECHNOLOGY LIMITED",
	[3]byte{0, 29, 21}:     "Shenzhen Dolphin Electronic Co., Ltd",
	[3]byte{0, 29, 22}:     "SFR",
	[3]byte{0, 29, 23}:     "Digital Sky Corporation",
	[3]byte{0, 29, 24}:     "Power Innovation GmbH",
	[3]byte{0, 29, 25}:     "Arcadyan Technology Corporation",
	[3]byte{0, 29, 26}:     "OvisLink S.A.",
	[3]byte{0, 29, 27}:     "Sangean Electronics Inc.",
	[3]byte{0, 29, 28}:     "Gennet s.a.",
	[3]byte{0, 29, 29}:     "Inter-M Corporation",
	[3]byte{0, 29, 30}:     "KYUSHU TEN CO.,LTD",
	[3]byte{0, 29, 31}:     "Siauliu Tauro Televizoriai, JSC",
	[3]byte{0, 29, 32}:     "COMTREND CO.",
	[3]byte{0, 29, 33}:     "Alcad SL",
	[3]byte{0, 29, 34}:     "Foss Analytical A/S",
	[3]byte{0, 29, 35}:     "SENSUS",
	[3]byte{0, 29, 36}:     "Aclara Power-Line Systems Inc.",
	[3]byte{0, 29, 37}:     "Samsung Electronics Co.,Ltd",
	[3]byte{0, 29, 38}:     "Rockridgesound Technology Co.",
	[3]byte{0, 29, 39}:     "NAC-INTERCOM",
	[3]byte{0, 29, 40}:     "Sony Ericsson Mobile Communications AB",
	[3]byte{0, 29, 41}:     "Doro AB",
	[3]byte{0, 29, 42}:     "SHENZHEN BUL-TECH CO.,LTD.",
	[3]byte{0, 29, 43}:     "Wuhan Pont Technology CO. , LTD",
	[3]byte{0, 29, 44}:     "Wavetrend Technologies (Pty) Limited",
	[3]byte{0, 29, 45}:     "Pylone, Inc.",
	[3]byte{0, 29, 46}:     "Ruckus Wireless",
	[3]byte{0, 29, 47}:     "QuantumVision Corporation",
	[3]byte{0, 29, 48}:     "YX Wireless S.A.",
	[3]byte{0, 29, 49}:     "HIGHPRO INTERNATIONAL R&D CO,.LTD.",
	[3]byte{0, 29, 50}:     "Longkay Communication & Technology (Shanghai) Co. Ltd",
	[3]byte{0, 29, 51}:     "Maverick Systems Inc.",
	[3]byte{0, 29, 52}:     "SYRIS Technology Corp",
	[3]byte{0, 29, 53}:     "Viconics Electronics Inc.",
	[3]byte{0, 29, 54}:     "ELECTRONICS CORPORATION OF INDIA LIMITED",
	[3]byte{0, 29, 55}:     "Thales-Panda Transportation System",
	[3]byte{0, 29, 56}:     "Seagate Technology",
	[3]byte{0, 29, 57}:     "MOOHADIGITAL CO., LTD",
	[3]byte{0, 29, 58}:     "mh acoustics LLC",
	[3]byte{0, 29, 59}:     "Nokia Danmark A/S",
	[3]byte{0, 29, 60}:     "Muscle Corporation",
	[3]byte{0, 29, 61}:     "Avidyne Corporation",
	[3]byte{0, 29, 62}:     "SAKA TECHNO SCIENCE CO.,LTD",
	[3]byte{0, 29, 63}:     "Mitron Pty Ltd",
	[3]byte{0, 29, 64}:     "Intel – GE Care Innovations LLC",
	[3]byte{0, 29, 65}:     "Hardy Instruments",
	[3]byte{0, 29, 66}:     "Nortel",
	[3]byte{0, 29, 67}:     "Shenzhen G-link Digital Technology Co., Ltd.",
	[3]byte{0, 29, 68}:     "KROHNE Messtechnik GmbH",
	[3]byte{0, 29, 69}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 29, 70}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 29, 71}:     "Covote GmbH & Co KG",
	[3]byte{0, 29, 72}:     "Sensor-Technik Wiedemann GmbH",
	[3]byte{0, 29, 73}:     "Innovation Wireless Inc.",
	[3]byte{0, 29, 74}:     "Carestream Health, Inc.",
	[3]byte{0, 29, 75}:     "Grid Connect Inc.",
	[3]byte{0, 29, 76}:     "Alcatel-Lucent",
	[3]byte{0, 29, 77}:     "Adaptive Recognition Hungary, Inc",
	[3]byte{0, 29, 78}:     "TCM Mobile LLC",
	[3]byte{0, 29, 79}:     "Apple",
	[3]byte{0, 29, 80}:     "SPINETIX SA",
	[3]byte{0, 29, 81}:     "Babcock & Wilcox Power Generation Group, Inc",
	[3]byte{0, 29, 82}:     "Defzone B.V.",
	[3]byte{0, 29, 83}:     "S&O Electronics (Malaysia) Sdn. Bhd.",
	[3]byte{0, 29, 84}:     "Sunnic Technology & Merchandise INC.",
	[3]byte{0, 29, 85}:     "ZANTAZ, Inc",
	[3]byte{0, 29, 86}:     "Kramer Electronics Ltd.",
	[3]byte{0, 29, 87}:     "CAETEC Messtechnik",
	[3]byte{0, 29, 88}:     "CQ Inc",
	[3]byte{0, 29, 89}:     "Mitra Energy & Infrastructure",
	[3]byte{0, 29, 90}:     "2Wire Inc.",
	[3]byte{0, 29, 91}:     "Tecvan Informática Ltda",
	[3]byte{0, 29, 92}:     "Tom Communication Industrial Co.,Ltd.",
	[3]byte{0, 29, 93}:     "Control Dynamics Pty. Ltd.",
	[3]byte{0, 29, 94}:     "COMING MEDIA CORP.",
	[3]byte{0, 29, 95}:     "OverSpeed SARL",
	[3]byte{0, 29, 96}:     "ASUSTek COMPUTER INC.",
	[3]byte{0, 29, 97}:     "BIJ Corporation",
	[3]byte{0, 29, 98}:     "InPhase Technologies",
	[3]byte{0, 29, 99}:     "Miele & Cie. KG",
	[3]byte{0, 29, 100}:    "Adam Communications Systems Int Ltd",
	[3]byte{0, 29, 101}:    "Microwave Radio Communications",
	[3]byte{0, 29, 102}:    "Hyundai Telecom",
	[3]byte{0, 29, 103}:    "AMEC",
	[3]byte{0, 29, 104}:    "Thomson Telecom Belgium",
	[3]byte{0, 29, 105}:    "Knorr-Bremse IT-Services GmbH",
	[3]byte{0, 29, 106}:    "Alpha Networks Inc.",
	[3]byte{0, 29, 107}:    "ARRIS Group, Inc.",
	[3]byte{0, 29, 108}:    "ClariPhy Communications, Inc.",
	[3]byte{0, 29, 109}:    "Confidant International LLC",
	[3]byte{0, 29, 110}:    "Nokia Danmark A/S",
	[3]byte{0, 29, 111}:    "Chainzone Technology Co., Ltd",
	[3]byte{0, 29, 112}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 29, 113}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 29, 114}:    "Wistron Corporation",
	[3]byte{0, 29, 115}:    "Buffalo Inc.",
	[3]byte{0, 29, 116}:    "Tianjin China-Silicon Microelectronics Co., Ltd.",
	[3]byte{0, 29, 117}:    "Radioscape PLC",
	[3]byte{0, 29, 118}:    "Eyeheight Ltd.",
	[3]byte{0, 29, 119}:    "NSGate",
	[3]byte{0, 29, 120}:    "Invengo Information Technology Co.,Ltd",
	[3]byte{0, 29, 121}:    "SIGNAMAX LLC",
	[3]byte{0, 29, 122}:    "Wideband Semiconductor, Inc.",
	[3]byte{0, 29, 123}:    "Ice Energy, Inc.",
	[3]byte{0, 29, 124}:    "ABE Elettronica S.p.A.",
	[3]byte{0, 29, 125}:    "GIGA-BYTE TECHNOLOGY CO.,LTD.",
	[3]byte{0, 29, 126}:    "Cisco-Linksys, LLC",
	[3]byte{0, 29, 127}:    "Tekron International Ltd",
	[3]byte{0, 29, 128}:    "Beijing Huahuan Eletronics Co.,Ltd",
	[3]byte{0, 29, 129}:    "GUANGZHOU GATEWAY ELECTRONICS CO., LTD",
	[3]byte{0, 29, 130}:    "GN A/S (GN Netcom A/S)",
	[3]byte{0, 29, 131}:    "Emitech Corporation",
	[3]byte{0, 29, 132}:    "Gateway, Inc.",
	[3]byte{0, 29, 133}:    "Call Direct Cellular Solutions",
	[3]byte{0, 29, 134}:    "Shinwa Industries(China) Ltd.",
	[3]byte{0, 29, 135}:    "VigTech Labs Sdn Bhd",
	[3]byte{0, 29, 136}:    "Clearwire",
	[3]byte{0, 29, 137}:    "VaultStor Corporation",
	[3]byte{0, 29, 138}:    "TechTrex Inc",
	[3]byte{0, 29, 139}:    "ADB Broadband Italia",
	[3]byte{0, 29, 140}:    "La Crosse Technology LTD",
	[3]byte{0, 29, 141}:    "Raytek GmbH",
	[3]byte{0, 29, 142}:    "Alereon, Inc.",
	[3]byte{0, 29, 143}:    "PureWave Networks",
	[3]byte{0, 29, 144}:    "EMCO Flow Systems",
	[3]byte{0, 29, 145}:    "Digitize, Inc",
	[3]byte{0, 29, 146}:    "MICRO-STAR INT'L CO.,LTD.",
	[3]byte{0, 29, 147}:    "Modacom",
	[3]byte{0, 29, 148}:    "Climax Technology Co., Ltd",
	[3]byte{0, 29, 149}:    "Flash, Inc.",
	[3]byte{0, 29, 150}:    "WatchGuard Video",
	[3]byte{0, 29, 151}:    "Alertus Technologies LLC",
	[3]byte{0, 29, 152}:    "Nokia Danmark A/S",
	[3]byte{0, 29, 153}:    "Cyan Optic, Inc.",
	[3]byte{0, 29, 154}:    "GODEX INTERNATIONAL CO., LTD",
	[3]byte{0, 29, 155}:    "Hokuyo Automatic Co., Ltd.",
	[3]byte{0, 29, 156}:    "Rockwell Automation",
	[3]byte{0, 29, 157}:    "ARTJOY INTERNATIONAL LIMITED",
	[3]byte{0, 29, 158}:    "AXION TECHNOLOGIES",
	[3]byte{0, 29, 159}:    "MATT   R.P.Traczynscy Sp.J.",
	[3]byte{0, 29, 160}:    "Heng Yu Electronic Manufacturing Company Limited",
	[3]byte{0, 29, 161}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 29, 162}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 29, 163}:    "SabiOso",
	[3]byte{0, 29, 164}:    "Hangzhou System Technology CO., LTD",
	[3]byte{0, 29, 165}:    "WB Electronics",
	[3]byte{0, 29, 166}:    "Media Numerics Limited",
	[3]byte{0, 29, 167}:    "Seamless Internet",
	[3]byte{0, 29, 168}:    "Takahata Electronics Co.,Ltd",
	[3]byte{0, 29, 169}:    "Castles Technology, Co., LTD",
	[3]byte{0, 29, 170}:    "DrayTek Corp.",
	[3]byte{0, 29, 171}:    "SwissQual License AG",
	[3]byte{0, 29, 172}:    "Gigamon Systems LLC",
	[3]byte{0, 29, 173}:    "Sinotech Engineering Consultants, Inc.  Geotechnical Enginee",
	[3]byte{0, 29, 174}:    "CHANG TSENG TECHNOLOGY CO., LTD",
	[3]byte{0, 29, 175}:    "Nortel",
	[3]byte{0, 29, 176}:    "FuJian HengTong Information Technology Co.,Ltd",
	[3]byte{0, 29, 177}:    "Crescendo Networks",
	[3]byte{0, 29, 178}:    "HOKKAIDO ELECTRIC ENGINEERING CO.,LTD.",
	[3]byte{0, 29, 179}:    "HPN Supply Chain",
	[3]byte{0, 29, 180}:    "KUMHO ENG CO.,LTD",
	[3]byte{0, 29, 181}:    "Juniper networks",
	[3]byte{0, 29, 182}:    "BestComm Networks, Inc.",
	[3]byte{0, 29, 183}:    "Tendril Networks, Inc.",
	[3]byte{0, 29, 184}:    "Intoto Inc.",
	[3]byte{0, 29, 185}:    "Wellspring Wireless",
	[3]byte{0, 29, 186}:    "Sony Corporation",
	[3]byte{0, 29, 187}:    "Dynamic System Electronics Corp.",
	[3]byte{0, 29, 188}:    "Nintendo Co., Ltd.",
	[3]byte{0, 29, 189}:    "Versamed Inc.",
	[3]byte{0, 29, 190}:    "ARRIS Group, Inc.",
	[3]byte{0, 29, 191}:    "Radiient Technologies, Inc.",
	[3]byte{0, 29, 192}:    "Enphase Energy",
	[3]byte{0, 29, 193}:    "Audinate Pty L",
	[3]byte{0, 29, 194}:    "XORTEC OY",
	[3]byte{0, 29, 195}:    "RIKOR TV, Ltd",
	[3]byte{0, 29, 196}:    "AIOI Systems Co., Ltd.",
	[3]byte{0, 29, 197}:    "Beijing Jiaxun Feihong Electricial Co., Ltd.",
	[3]byte{0, 29, 198}:    "SNR Inc.",
	[3]byte{0, 29, 199}:    "L-3 Communications Geneva Aerospace",
	[3]byte{0, 29, 200}:    "Navionics Research Inc., dba SCADAmetrics",
	[3]byte{0, 29, 201}:    "GainSpan Corp.",
	[3]byte{0, 29, 202}:    "PAV Electronics Limited",
	[3]byte{0, 29, 203}:    "Exéns Development Oy",
	[3]byte{0, 29, 204}:    "Hetra Secure Solutions",
	[3]byte{0, 29, 205}:    "ARRIS Group, Inc.",
	[3]byte{0, 29, 206}:    "ARRIS Group, Inc.",
	[3]byte{0, 29, 207}:    "ARRIS Group, Inc.",
	[3]byte{0, 29, 208}:    "ARRIS Group, Inc.",
	[3]byte{0, 29, 209}:    "ARRIS Group, Inc.",
	[3]byte{0, 29, 210}:    "ARRIS Group, Inc.",
	[3]byte{0, 29, 211}:    "ARRIS Group, Inc.",
	[3]byte{0, 29, 212}:    "ARRIS Group, Inc.",
	[3]byte{0, 29, 213}:    "ARRIS Group, Inc.",
	[3]byte{0, 29, 214}:    "ARRIS Group, Inc.",
	[3]byte{0, 29, 215}:    "Algolith",
	[3]byte{0, 29, 216}:    "Microsoft Corporation",
	[3]byte{0, 29, 217}:    "Hon Hai Precision Ind.Co.,Ltd.",
	[3]byte{0, 29, 218}:    "Mikroelektronika spol. s r. o.",
	[3]byte{0, 29, 219}:    "C-BEL Corporation",
	[3]byte{0, 29, 220}:    "HangZhou DeChangLong Tech&Info Co.,Ltd",
	[3]byte{0, 29, 221}:    "DAT H.K. LIMITED",
	[3]byte{0, 29, 222}:    "Zhejiang Broadcast&Television Technology Co.,Ltd.",
	[3]byte{0, 29, 223}:    "Sunitec Enterprise Co., Ltd.",
	[3]byte{0, 29, 224}:    "Intel Corporate",
	[3]byte{0, 29, 225}:    "Intel Corporate",
	[3]byte{0, 29, 226}:    "Radionor Communications",
	[3]byte{0, 29, 227}:    "Intuicom",
	[3]byte{0, 29, 228}:    "Visioneered Image Systems",
	[3]byte{0, 29, 229}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 29, 230}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 29, 231}:    "Marine Sonic Technology, Ltd.",
	[3]byte{0, 29, 232}:    "Nikko Denki Tsushin Corporation(NDTC)",
	[3]byte{0, 29, 233}:    "Nokia Danmark A/S",
	[3]byte{0, 29, 234}:    "Commtest Instruments Ltd",
	[3]byte{0, 29, 235}:    "DINEC International",
	[3]byte{0, 29, 236}:    "Marusys",
	[3]byte{0, 29, 237}:    "Grid Net, Inc.",
	[3]byte{0, 29, 238}:    "NEXTVISION SISTEMAS DIGITAIS DE TELEVISÃO LTDA.",
	[3]byte{0, 29, 239}:    "TRIMM, INC.",
	[3]byte{0, 29, 240}:    "Vidient Systems, Inc.",
	[3]byte{0, 29, 241}:    "Intego Systems, Inc.",
	[3]byte{0, 29, 242}:    "Netflix, Inc.",
	[3]byte{0, 29, 243}:    "SBS Science & Technology Co., Ltd",
	[3]byte{0, 29, 244}:    "Magellan Technology Pty Limited",
	[3]byte{0, 29, 245}:    "Sunshine Co,LTD",
	[3]byte{0, 29, 246}:    "Samsung Electronics Co.,Ltd",
	[3]byte{0, 29, 247}:    "R. STAHL Schaltgeräte GmbH",
	[3]byte{0, 29, 248}:    "Webpro Vision Technology Corporation",
	[3]byte{0, 29, 249}:    "Cybiotronics (Far East) Limited",
	[3]byte{0, 29, 250}:    "Fujian LANDI Commercial Equipment Co.,Ltd",
	[3]byte{0, 29, 251}:    "NETCLEUS Systems Corporation",
	[3]byte{0, 29, 252}:    "KSIC",
	[3]byte{0, 29, 253}:    "Nokia Danmark A/S",
	[3]byte{0, 29, 254}:    "Palm, Inc",
	[3]byte{0, 29, 255}:    "Network Critical Solutions Ltd",
	[3]byte{0, 30, 0}:      "Shantou Institute of Ultrasonic Instruments",
	[3]byte{0, 30, 1}:      "Renesas Technology Sales Co., Ltd.",
	[3]byte{0, 30, 2}:      "Sougou Keikaku Kougyou Co.,Ltd.",
	[3]byte{0, 30, 3}:      "LiComm Co., Ltd.",
	[3]byte{0, 30, 4}:      "Hanson Research Corporation",
	[3]byte{0, 30, 5}:      "Xseed Technologies & Computing",
	[3]byte{0, 30, 6}:      "WIBRAIN",
	[3]byte{0, 30, 7}:      "Winy Technology Co., Ltd.",
	[3]byte{0, 30, 8}:      "Centec Networks Inc",
	[3]byte{0, 30, 9}:      "ZEFATEK Co.,LTD",
	[3]byte{0, 30, 10}:     "Syba Tech Limited",
	[3]byte{0, 30, 11}:     "Hewlett-Packard Company",
	[3]byte{0, 30, 12}:     "Sherwood Information Partners, Inc.",
	[3]byte{0, 30, 13}:     "Micran Ltd.",
	[3]byte{0, 30, 14}:     "MAXI VIEW HOLDINGS LIMITED",
	[3]byte{0, 30, 15}:     "Briot International",
	[3]byte{0, 30, 16}:     "ShenZhen Huawei Communication Technologies Co.,Ltd.",
	[3]byte{0, 30, 17}:     "ELELUX INTERNATIONAL LTD",
	[3]byte{0, 30, 18}:     "Ecolab",
	[3]byte{0, 30, 19}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 30, 20}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 30, 21}:     "Beech Hill Electronics",
	[3]byte{0, 30, 22}:     "Keytronix",
	[3]byte{0, 30, 23}:     "STN BV",
	[3]byte{0, 30, 24}:     "Radio Activity srl",
	[3]byte{0, 30, 25}:     "GTRI",
	[3]byte{0, 30, 26}:     "Best Source Taiwan Inc.",
	[3]byte{0, 30, 27}:     "Digital Stream Technology, Inc.",
	[3]byte{0, 30, 28}:     "SWS Australia Pty Limited",
	[3]byte{0, 30, 29}:     "East Coast Datacom, Inc.",
	[3]byte{0, 30, 30}:     "Honeywell Life Safety",
	[3]byte{0, 30, 31}:     "Nortel",
	[3]byte{0, 30, 32}:     "Intertain Inc.",
	[3]byte{0, 30, 33}:     "Qisda Co.",
	[3]byte{0, 30, 34}:     "ARVOO Imaging Products BV",
	[3]byte{0, 30, 35}:     "Electronic Educational Devices, Inc",
	[3]byte{0, 30, 36}:     "Zhejiang Bell Technology Co.,ltd",
	[3]byte{0, 30, 37}:     "Intek Digital Inc",
	[3]byte{0, 30, 38}:     "Digifriends Co. Ltd",
	[3]byte{0, 30, 39}:     "SBN TECH Co.,Ltd.",
	[3]byte{0, 30, 40}:     "Lumexis Corporation",
	[3]byte{0, 30, 41}:     "Hypertherm Inc",
	[3]byte{0, 30, 42}:     "Netgear Inc.",
	[3]byte{0, 30, 43}:     "Radio Systems Design, Inc.",
	[3]byte{0, 30, 44}:     "CyVerse Corporation",
	[3]byte{0, 30, 45}:     "STIM",
	[3]byte{0, 30, 46}:     "SIRTI S.p.A.",
	[3]byte{0, 30, 47}:     "DiMoto Pty Ltd",
	[3]byte{0, 30, 48}:     "Shireen Inc",
	[3]byte{0, 30, 49}:     "INFOMARK CO.,LTD.",
	[3]byte{0, 30, 50}:     "Zensys",
	[3]byte{0, 30, 51}:     "Inventec Corporation",
	[3]byte{0, 30, 52}:     "CryptoMetrics",
	[3]byte{0, 30, 53}:     "Nintendo Co., Ltd.",
	[3]byte{0, 30, 54}:     "IPTE",
	[3]byte{0, 30, 55}:     "Universal Global Scientific Industrial Co., Ltd.",
	[3]byte{0, 30, 56}:     "Bluecard Software Technology Co., Ltd.",
	[3]byte{0, 30, 57}:     "Comsys Communication Ltd.",
	[3]byte{0, 30, 58}:     "Nokia Danmark A/S",
	[3]byte{0, 30, 59}:     "Nokia Danmark A/S",
	[3]byte{0, 30, 60}:     "Lyngbox Media AB",
	[3]byte{0, 30, 61}:     "Alps Electric Co., Ltd",
	[3]byte{0, 30, 62}:     "KMW Inc.",
	[3]byte{0, 30, 63}:     "TrellisWare Technologies, Inc.",
	[3]byte{0, 30, 64}:     "Shanghai DareGlobal Technologies  Co.,Ltd.",
	[3]byte{0, 30, 65}:     "Microwave Communication & Component, Inc.",
	[3]byte{0, 30, 66}:     "Teltonika",
	[3]byte{0, 30, 67}:     "AISIN AW CO.,LTD.",
	[3]byte{0, 30, 68}:     "SANTEC",
	[3]byte{0, 30, 69}:     "Sony Ericsson Mobile Communications AB",
	[3]byte{0, 30, 70}:     "ARRIS Group, Inc.",
	[3]byte{0, 30, 71}:     "PT. Hariff Daya Tunggal Engineering",
	[3]byte{0, 30, 72}:     "Wi-Links",
	[3]byte{0, 30, 73}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 30, 74}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 30, 75}:     "City Theatrical",
	[3]byte{0, 30, 76}:     "Hon Hai Precision Ind.Co., Ltd.",
	[3]byte{0, 30, 77}:     "Welkin Sciences, LLC",
	[3]byte{0, 30, 78}:     "DAKO EDV-Ingenieur- und Systemhaus GmbH",
	[3]byte{0, 30, 79}:     "Dell Inc.",
	[3]byte{0, 30, 80}:     "BATTISTONI RESEARCH",
	[3]byte{0, 30, 81}:     "Converter Industry Srl",
	[3]byte{0, 30, 82}:     "Apple",
	[3]byte{0, 30, 83}:     "Further Tech Co., LTD",
	[3]byte{0, 30, 84}:     "TOYO ELECTRIC Corporation",
	[3]byte{0, 30, 85}:     "COWON SYSTEMS,Inc.",
	[3]byte{0, 30, 86}:     "Bally Wulff Entertainment GmbH",
	[3]byte{0, 30, 87}:     "ALCOMA, spol. s r.o.",
	[3]byte{0, 30, 88}:     "D-Link Corporation",
	[3]byte{0, 30, 89}:     "Silicon Turnkey Express, LLC",
	[3]byte{0, 30, 90}:     "ARRIS Group, Inc.",
	[3]byte{0, 30, 91}:     "Unitron Company, Inc.",
	[3]byte{0, 30, 92}:     "RB GeneralEkonomik",
	[3]byte{0, 30, 93}:     "Holosys d.o.o.",
	[3]byte{0, 30, 94}:     "COmputime Ltd.",
	[3]byte{0, 30, 95}:     "KwikByte, LLC",
	[3]byte{0, 30, 96}:     "Digital Lighting Systems, Inc",
	[3]byte{0, 30, 97}:     "ITEC GmbH",
	[3]byte{0, 30, 98}:     "Siemon",
	[3]byte{0, 30, 99}:     "Vibro-Meter SA",
	[3]byte{0, 30, 100}:    "Intel Corporate",
	[3]byte{0, 30, 101}:    "Intel Corporate",
	[3]byte{0, 30, 102}:    "RESOL Elektronische Regelungen GmbH",
	[3]byte{0, 30, 103}:    "Intel Corporate",
	[3]byte{0, 30, 104}:    "Quanta Computer",
	[3]byte{0, 30, 105}:    "Thomson Inc.",
	[3]byte{0, 30, 106}:    "Beijing Bluexon Technology Co.,Ltd",
	[3]byte{0, 30, 107}:    "Cisco SPVTG",
	[3]byte{0, 30, 108}:    "Opaque Systems",
	[3]byte{0, 30, 109}:    "IT R&D Center",
	[3]byte{0, 30, 110}:    "Shenzhen First Mile Communications Ltd",
	[3]byte{0, 30, 111}:    "Magna-Power Electronics, Inc.",
	[3]byte{0, 30, 112}:    "Cobham Defence Communications Ltd",
	[3]byte{0, 30, 113}:    "MIrcom Group of Companies",
	[3]byte{0, 30, 114}:    "PCS",
	[3]byte{0, 30, 115}:    "ZTE CORPORATION",
	[3]byte{0, 30, 116}:    "SAGEM COMMUNICATION",
	[3]byte{0, 30, 117}:    "LG Electronics",
	[3]byte{0, 30, 118}:    "Thermo Fisher Scientific",
	[3]byte{0, 30, 119}:    "Air2App",
	[3]byte{0, 30, 120}:    "Owitek Technology Ltd.,",
	[3]byte{0, 30, 121}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 30, 122}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 30, 123}:    "R.I.CO. S.r.l.",
	[3]byte{0, 30, 124}:    "Taiwick Limited",
	[3]byte{0, 30, 125}:    "Samsung Electronics Co.,Ltd",
	[3]byte{0, 30, 126}:    "Nortel",
	[3]byte{0, 30, 127}:    "CBM of America",
	[3]byte{0, 30, 128}:    "Last Mile Ltd.",
	[3]byte{0, 30, 129}:    "CNB Technology Inc.",
	[3]byte{0, 30, 130}:    "SanDisk Corporation",
	[3]byte{0, 30, 131}:    "LAN/MAN Standards Association (LMSC)",
	[3]byte{0, 30, 132}:    "Pika Technologies Inc.",
	[3]byte{0, 30, 133}:    "Lagotek Corporation",
	[3]byte{0, 30, 134}:    "MEL Co.,Ltd.",
	[3]byte{0, 30, 135}:    "Realease Limited",
	[3]byte{0, 30, 136}:    "ANDOR SYSTEM SUPPORT CO., LTD.",
	[3]byte{0, 30, 137}:    "CRFS Limited",
	[3]byte{0, 30, 138}:    "eCopy, Inc",
	[3]byte{0, 30, 139}:    "Infra Access Korea Co., Ltd.",
	[3]byte{0, 30, 140}:    "ASUSTek COMPUTER INC.",
	[3]byte{0, 30, 141}:    "ARRIS Group, Inc.",
	[3]byte{0, 30, 142}:    "Hunkeler AG",
	[3]byte{0, 30, 143}:    "CANON INC.",
	[3]byte{0, 30, 144}:    "Elitegroup Computer Systems Co",
	[3]byte{0, 30, 145}:    "KIMIN Electronic Co., Ltd.",
	[3]byte{0, 30, 146}:    "JEULIN S.A.",
	[3]byte{0, 30, 147}:    "CiriTech Systems Inc",
	[3]byte{0, 30, 148}:    "SUPERCOM TECHNOLOGY CORPORATION",
	[3]byte{0, 30, 149}:    "SIGMALINK",
	[3]byte{0, 30, 150}:    "Sepura Plc",
	[3]byte{0, 30, 151}:    "Medium Link System Technology CO., LTD,",
	[3]byte{0, 30, 152}:    "GreenLine Communications",
	[3]byte{0, 30, 153}:    "Vantanol Industrial Corporation",
	[3]byte{0, 30, 154}:    "HAMILTON Bonaduz AG",
	[3]byte{0, 30, 155}:    "San-Eisha, Ltd.",
	[3]byte{0, 30, 156}:    "Fidustron INC",
	[3]byte{0, 30, 157}:    "Recall Technologies, Inc.",
	[3]byte{0, 30, 158}:    "ddm hopt + schuler Gmbh + Co. KG",
	[3]byte{0, 30, 159}:    "Visioneering Systems, Inc.",
	[3]byte{0, 30, 160}:    "XLN-t",
	[3]byte{0, 30, 161}:    "Brunata a/s",
	[3]byte{0, 30, 162}:    "Symx Systems, Inc.",
	[3]byte{0, 30, 163}:    "Nokia Danmark A/S",
	[3]byte{0, 30, 164}:    "Nokia Danmark A/S",
	[3]byte{0, 30, 165}:    "ROBOTOUS, Inc.",
	[3]byte{0, 30, 166}:    "Best IT World (India) Pvt. Ltd.",
	[3]byte{0, 30, 167}:    "ActionTec Electronics, Inc",
	[3]byte{0, 30, 168}:    "Datang Mobile Communications Equipment CO.,LTD",
	[3]byte{0, 30, 169}:    "Nintendo Co., Ltd.",
	[3]byte{0, 30, 170}:    "E-Senza Technologies GmbH",
	[3]byte{0, 30, 171}:    "TeleWell Oy",
	[3]byte{0, 30, 172}:    "Armadeus Systems",
	[3]byte{0, 30, 173}:    "Wingtech Group Limited",
	[3]byte{0, 30, 174}:    "Continental Automotive Systems",
	[3]byte{0, 30, 175}:    "Ophir Optronics Ltd",
	[3]byte{0, 30, 176}:    "ImesD Electronica S.L.",
	[3]byte{0, 30, 177}:    "Cryptsoft Pty Ltd",
	[3]byte{0, 30, 178}:    "LG innotek",
	[3]byte{0, 30, 179}:    "Primex Wireless",
	[3]byte{0, 30, 180}:    "UNIFAT TECHNOLOGY LTD.",
	[3]byte{0, 30, 181}:    "Ever Sparkle Technologies Ltd",
	[3]byte{0, 30, 182}:    "TAG Heuer SA",
	[3]byte{0, 30, 183}:    "TBTech, Co., Ltd.",
	[3]byte{0, 30, 184}:    "Fortis, Inc.",
	[3]byte{0, 30, 185}:    "Sing Fai Technology Limited",
	[3]byte{0, 30, 186}:    "High Density Devices AS",
	[3]byte{0, 30, 187}:    "BLUELIGHT TECHNOLOGY INC.",
	[3]byte{0, 30, 188}:    "WINTECH AUTOMATION CO.,LTD.",
	[3]byte{0, 30, 189}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 30, 190}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 30, 191}:    "Haas Automation Inc.",
	[3]byte{0, 30, 192}:    "Microchip Technology Inc.",
	[3]byte{0, 30, 193}:    "3COM EUROPE LTD",
	[3]byte{0, 30, 194}:    "Apple",
	[3]byte{0, 30, 195}:    "Kozio, Inc.",
	[3]byte{0, 30, 196}:    "Celio Corp",
	[3]byte{0, 30, 197}:    "Middle Atlantic Products Inc",
	[3]byte{0, 30, 198}:    "Obvius Holdings LLC",
	[3]byte{0, 30, 199}:    "2Wire, Inc.",
	[3]byte{0, 30, 200}:    "Rapid Mobile (Pty) Ltd",
	[3]byte{0, 30, 201}:    "Dell Inc",
	[3]byte{0, 30, 202}:    "Nortel",
	[3]byte{0, 30, 203}:    "\"RPC \"Energoautomatika\" Ltd",
	[3]byte{0, 30, 204}:    "CDVI",
	[3]byte{0, 30, 205}:    "KYLAND Technology Co. LTD",
	[3]byte{0, 30, 206}:    "BISA Technologies (Hong Kong) Limited",
	[3]byte{0, 30, 207}:    "PHILIPS ELECTRONICS UK LTD",
	[3]byte{0, 30, 208}:    "Ingespace",
	[3]byte{0, 30, 209}:    "Keyprocessor B.V.",
	[3]byte{0, 30, 210}:    "Ray Shine Video Technology Inc",
	[3]byte{0, 30, 211}:    "Dot Technology Int'l Co., Ltd.",
	[3]byte{0, 30, 212}:    "Doble Engineering",
	[3]byte{0, 30, 213}:    "Tekon-Automatics",
	[3]byte{0, 30, 214}:    "Alentec & Orion AB",
	[3]byte{0, 30, 215}:    "H-Stream Wireless, Inc.",
	[3]byte{0, 30, 216}:    "Digital United Inc.",
	[3]byte{0, 30, 217}:    "Mitsubishi Precision Co.,LTd.",
	[3]byte{0, 30, 218}:    "Wesemann Elektrotechniek B.V.",
	[3]byte{0, 30, 219}:    "Giken Trastem Co., Ltd.",
	[3]byte{0, 30, 220}:    "Sony Ericsson Mobile Communications AB",
	[3]byte{0, 30, 221}:    "WASKO S.A.",
	[3]byte{0, 30, 222}:    "BYD COMPANY LIMITED",
	[3]byte{0, 30, 223}:    "Master Industrialization Center Kista",
	[3]byte{0, 30, 224}:    "Urmet Domus SpA",
	[3]byte{0, 30, 225}:    "Samsung Electronics Co.,Ltd",
	[3]byte{0, 30, 226}:    "Samsung Electronics Co.,Ltd",
	[3]byte{0, 30, 227}:    "T&W Electronics (ShenZhen) Co.,Ltd",
	[3]byte{0, 30, 228}:    "ACS Solutions France",
	[3]byte{0, 30, 229}:    "Cisco-Linksys, LLC",
	[3]byte{0, 30, 230}:    "Shenzhen Advanced Video Info-Tech Co., Ltd.",
	[3]byte{0, 30, 231}:    "Epic Systems Inc",
	[3]byte{0, 30, 232}:    "Mytek",
	[3]byte{0, 30, 233}:    "Stoneridge Electronics AB",
	[3]byte{0, 30, 234}:    "Sensor Switch, Inc.",
	[3]byte{0, 30, 235}:    "Talk-A-Phone Co.",
	[3]byte{0, 30, 236}:    "COMPAL INFORMATION (KUNSHAN) CO., LTD.",
	[3]byte{0, 30, 237}:    "Adventiq Ltd.",
	[3]byte{0, 30, 238}:    "ETL Systems Ltd",
	[3]byte{0, 30, 239}:    "Cantronic International Limited",
	[3]byte{0, 30, 240}:    "Gigafin Networks",
	[3]byte{0, 30, 241}:    "Servimat",
	[3]byte{0, 30, 242}:    "Micro Motion Inc",
	[3]byte{0, 30, 243}:    "From2",
	[3]byte{0, 30, 244}:    "L-3 Communications Display Systems",
	[3]byte{0, 30, 245}:    "Hitek Automated Inc.",
	[3]byte{0, 30, 246}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 30, 247}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 30, 248}:    "Emfinity Inc.",
	[3]byte{0, 30, 249}:    "Pascom Kommunikations systeme GmbH.",
	[3]byte{0, 30, 250}:    "PROTEI Ltd.",
	[3]byte{0, 30, 251}:    "Trio Motion Technology Ltd",
	[3]byte{0, 30, 252}:    "JSC \"MASSA-K\"",
	[3]byte{0, 30, 253}:    "Microbit 2.0 AB",
	[3]byte{0, 30, 254}:    "LEVEL s.r.o.",
	[3]byte{0, 30, 255}:    "Mueller-Elektronik GmbH & Co. KG",
	[3]byte{0, 31, 0}:      "Nokia Danmark A/S",
	[3]byte{0, 31, 1}:      "Nokia Danmark A/S",
	[3]byte{0, 31, 2}:      "Pixelmetrix Corporation Pte Ltd",
	[3]byte{0, 31, 3}:      "NUM AG",
	[3]byte{0, 31, 4}:      "Granch Ltd.",
	[3]byte{0, 31, 5}:      "iTAS Technology Corp.",
	[3]byte{0, 31, 6}:      "Integrated Dispatch Solutions",
	[3]byte{0, 31, 7}:      "AZTEQ Mobile",
	[3]byte{0, 31, 8}:      "RISCO LTD",
	[3]byte{0, 31, 9}:      "JASTEC CO., LTD.",
	[3]byte{0, 31, 10}:     "Nortel",
	[3]byte{0, 31, 11}:     "Federal State Unitary Enterprise Industrial Union\"Electropribor\"",
	[3]byte{0, 31, 12}:     "Intelligent Digital Services GmbH",
	[3]byte{0, 31, 13}:     "L3 Communications - Telemetry West",
	[3]byte{0, 31, 14}:     "Japan Kyastem Co., Ltd",
	[3]byte{0, 31, 15}:     "Select Engineered Systems",
	[3]byte{0, 31, 16}:     "TOLEDO DO BRASIL INDUSTRIA DE BALANCAS  LTDA",
	[3]byte{0, 31, 17}:     "OPENMOKO, INC.",
	[3]byte{0, 31, 18}:     "Juniper Networks",
	[3]byte{0, 31, 19}:     "S.& A.S. Ltd.",
	[3]byte{0, 31, 20}:     "NexG",
	[3]byte{0, 31, 21}:     "Bioscrypt Inc",
	[3]byte{0, 31, 22}:     "Wistron Corporation",
	[3]byte{0, 31, 23}:     "IDX Company, Ltd.",
	[3]byte{0, 31, 24}:     "Hakusan.Mfg.Co,.Ltd",
	[3]byte{0, 31, 25}:     "BEN-RI ELECTRONICA S.A.",
	[3]byte{0, 31, 26}:     "Prominvest",
	[3]byte{0, 31, 27}:     "RoyalTek Company Ltd.",
	[3]byte{0, 31, 28}:     "KOBISHI ELECTRIC Co.,Ltd.",
	[3]byte{0, 31, 29}:     "Atlas Material Testing Technology LLC",
	[3]byte{0, 31, 30}:     "Astec Technology Co., Ltd",
	[3]byte{0, 31, 31}:     "Edimax Technology Co. Ltd.",
	[3]byte{0, 31, 32}:     "Logitech Europe SA",
	[3]byte{0, 31, 33}:     "Inner Mongolia Yin An Science & Technology Development Co.,L",
	[3]byte{0, 31, 34}:     "Source Photonics, Inc.",
	[3]byte{0, 31, 35}:     "Interacoustics",
	[3]byte{0, 31, 36}:     "DIGITVIEW TECHNOLOGY CO., LTD.",
	[3]byte{0, 31, 37}:     "MBS GmbH",
	[3]byte{0, 31, 38}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 31, 39}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 31, 40}:     "HPN Supply Chain",
	[3]byte{0, 31, 41}:     "Hewlett-Packard Company",
	[3]byte{0, 31, 42}:     "ACCM",
	[3]byte{0, 31, 43}:     "Orange Logic",
	[3]byte{0, 31, 44}:     "Starbridge Networks",
	[3]byte{0, 31, 45}:     "Electro-Optical Imaging, Inc.",
	[3]byte{0, 31, 46}:     "Triangle Research Int'l Pte Ltd",
	[3]byte{0, 31, 47}:     "Berker GmbH & Co. KG",
	[3]byte{0, 31, 48}:     "Travelping",
	[3]byte{0, 31, 49}:     "Radiocomp",
	[3]byte{0, 31, 50}:     "Nintendo Co., Ltd.",
	[3]byte{0, 31, 51}:     "Netgear Inc.",
	[3]byte{0, 31, 52}:     "Lung Hwa Electronics Co., Ltd.",
	[3]byte{0, 31, 53}:     "AIR802 LLC",
	[3]byte{0, 31, 54}:     "Bellwin Information Co. Ltd.,",
	[3]byte{0, 31, 55}:     "Genesis I&C",
	[3]byte{0, 31, 56}:     "POSITRON",
	[3]byte{0, 31, 57}:     "Construcciones y Auxiliar de Ferrocarriles, S.A.",
	[3]byte{0, 31, 58}:     "Hon Hai Precision Ind.Co., Ltd.",
	[3]byte{0, 31, 59}:     "Intel Corporate",
	[3]byte{0, 31, 60}:     "Intel Corporate",
	[3]byte{0, 31, 61}:     "Qbit GmbH",
	[3]byte{0, 31, 62}:     "RP-Technik e.K.",
	[3]byte{0, 31, 63}:     "AVM GmbH",
	[3]byte{0, 31, 64}:     "Speakercraft Inc.",
	[3]byte{0, 31, 65}:     "Ruckus Wireless",
	[3]byte{0, 31, 66}:     "Etherstack plc",
	[3]byte{0, 31, 67}:     "ENTES ELEKTRONIK",
	[3]byte{0, 31, 68}:     "GE Transportation Systems",
	[3]byte{0, 31, 69}:     "Enterasys",
	[3]byte{0, 31, 70}:     "Nortel",
	[3]byte{0, 31, 71}:     "MCS Logic Inc.",
	[3]byte{0, 31, 72}:     "Mojix Inc.",
	[3]byte{0, 31, 73}:     "Eurosat Distribution Ltd",
	[3]byte{0, 31, 74}:     "Albentia Systems S.A.",
	[3]byte{0, 31, 75}:     "Lineage Power",
	[3]byte{0, 31, 76}:     "Roseman Engineering Ltd",
	[3]byte{0, 31, 77}:     "Segnetics LLC",
	[3]byte{0, 31, 78}:     "ConMed Linvatec",
	[3]byte{0, 31, 79}:     "Thinkware Co. Ltd.",
	[3]byte{0, 31, 80}:     "Swissdis AG",
	[3]byte{0, 31, 81}:     "HD Communications Corp",
	[3]byte{0, 31, 82}:     "UVT Unternehmensberatung fur Verkehr und Technik GmbH",
	[3]byte{0, 31, 83}:     "GEMAC Gesellschaft für Mikroelektronikanwendung Chemnitz mbH",
	[3]byte{0, 31, 84}:     "Lorex Technology Inc.",
	[3]byte{0, 31, 85}:     "Honeywell Security (China) Co., Ltd.",
	[3]byte{0, 31, 86}:     "DIGITAL FORECAST",
	[3]byte{0, 31, 87}:     "Phonik Innovation Co.,LTD",
	[3]byte{0, 31, 88}:     "EMH Energiemesstechnik GmbH",
	[3]byte{0, 31, 89}:     "Kronback Tracers",
	[3]byte{0, 31, 90}:     "Beckwith Electric Co.",
	[3]byte{0, 31, 91}:     "Apple",
	[3]byte{0, 31, 92}:     "Nokia Danmark A/S",
	[3]byte{0, 31, 93}:     "Nokia Danmark A/S",
	[3]byte{0, 31, 94}:     "Dyna Technology Co.,Ltd.",
	[3]byte{0, 31, 95}:     "Blatand GmbH",
	[3]byte{0, 31, 96}:     "COMPASS SYSTEMS CORP.",
	[3]byte{0, 31, 97}:     "Talent Communication Networks Inc.",
	[3]byte{0, 31, 98}:     "JSC \"Stilsoft\"",
	[3]byte{0, 31, 99}:     "JSC Goodwin-Europa",
	[3]byte{0, 31, 100}:    "Beijing Autelan Technology Inc.",
	[3]byte{0, 31, 101}:    "KOREA ELECTRIC TERMINAL CO., LTD.",
	[3]byte{0, 31, 102}:    "PLANAR LLC",
	[3]byte{0, 31, 103}:    "Hitachi,Ltd.",
	[3]byte{0, 31, 104}:    "Martinsson Elektronik AB",
	[3]byte{0, 31, 105}:    "Pingood Technology Co., Ltd.",
	[3]byte{0, 31, 106}:    "PacketFlux Technologies, Inc.",
	[3]byte{0, 31, 107}:    "LG Electronics",
	[3]byte{0, 31, 108}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 31, 109}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 31, 110}:    "Vtech Engineering Corporation",
	[3]byte{0, 31, 111}:    "Fujian Sunnada Communication Co.,Ltd.",
	[3]byte{0, 31, 112}:    "Botik Technologies LTD",
	[3]byte{0, 31, 113}:    "xG Technology, Inc.",
	[3]byte{0, 31, 114}:    "QingDao Hiphone Technology Co,.Ltd",
	[3]byte{0, 31, 115}:    "Teraview Technology Co., Ltd.",
	[3]byte{0, 31, 116}:    "Eigen Development",
	[3]byte{0, 31, 117}:    "GiBahn Media",
	[3]byte{0, 31, 118}:    "AirLogic Systems Inc.",
	[3]byte{0, 31, 119}:    "HEOL DESIGN",
	[3]byte{0, 31, 120}:    "Blue Fox Porini Textile",
	[3]byte{0, 31, 121}:    "Lodam Electronics A/S",
	[3]byte{0, 31, 122}:    "WiWide Inc.",
	[3]byte{0, 31, 123}:    "TechNexion Ltd.",
	[3]byte{0, 31, 124}:    "Witelcom AS",
	[3]byte{0, 31, 125}:    "embedded wireless GmbH",
	[3]byte{0, 31, 126}:    "ARRIS Group, Inc.",
	[3]byte{0, 31, 127}:    "Phabrix Limited",
	[3]byte{0, 31, 128}:    "Lucas Holding bv",
	[3]byte{0, 31, 129}:    "Accel Semiconductor Corp",
	[3]byte{0, 31, 130}:    "Cal-Comp Electronics & Communications Co., Ltd",
	[3]byte{0, 31, 131}:    "Teleplan Technology Services Sdn Bhd",
	[3]byte{0, 31, 132}:    "Gigle Semiconductor",
	[3]byte{0, 31, 133}:    "Apriva ISS, LLC",
	[3]byte{0, 31, 134}:    "digEcor",
	[3]byte{0, 31, 135}:    "Skydigital Inc.",
	[3]byte{0, 31, 136}:    "FMS Force Measuring Systems AG",
	[3]byte{0, 31, 137}:    "Signalion GmbH",
	[3]byte{0, 31, 138}:    "Ellion Digital Inc.",
	[3]byte{0, 31, 139}:    "Cache IQ",
	[3]byte{0, 31, 140}:    "CCS Inc.",
	[3]byte{0, 31, 141}:    "Ingenieurbuero Stark GmbH und Ko. KG",
	[3]byte{0, 31, 142}:    "Metris USA Inc.",
	[3]byte{0, 31, 143}:    "Shanghai Bellmann Digital Source Co.,Ltd.",
	[3]byte{0, 31, 144}:    "Actiontec Electronics, Inc",
	[3]byte{0, 31, 145}:    "DBS Lodging Technologies, LLC",
	[3]byte{0, 31, 146}:    "VideoIQ, Inc.",
	[3]byte{0, 31, 147}:    "Xiotech Corporation",
	[3]byte{0, 31, 148}:    "Lascar Electronics Ltd",
	[3]byte{0, 31, 149}:    "SAGEM COMMUNICATION",
	[3]byte{0, 31, 150}:    "APROTECH CO.LTD",
	[3]byte{0, 31, 151}:    "BERTANA SRL",
	[3]byte{0, 31, 152}:    "DAIICHI-DENTSU LTD.",
	[3]byte{0, 31, 153}:    "SERONICS co.ltd",
	[3]byte{0, 31, 154}:    "Nortel Networks",
	[3]byte{0, 31, 155}:    "POSBRO",
	[3]byte{0, 31, 156}:    "LEDCO",
	[3]byte{0, 31, 157}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 31, 158}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 31, 159}:    "Thomson Telecom Belgium",
	[3]byte{0, 31, 160}:    "A10 Networks",
	[3]byte{0, 31, 161}:    "Gtran Inc",
	[3]byte{0, 31, 162}:    "Datron World Communications, Inc.",
	[3]byte{0, 31, 163}:    "T&W Electronics(Shenzhen)Co.,Ltd.",
	[3]byte{0, 31, 164}:    "ShenZhen Gongjin Electronics Co.,Ltd",
	[3]byte{0, 31, 165}:    "Blue-White Industries",
	[3]byte{0, 31, 166}:    "Stilo srl",
	[3]byte{0, 31, 167}:    "Sony Computer Entertainment Inc.",
	[3]byte{0, 31, 168}:    "Smart Energy Instruments Inc.",
	[3]byte{0, 31, 169}:    "Atlanta DTH, Inc.",
	[3]byte{0, 31, 170}:    "Taseon, Inc.",
	[3]byte{0, 31, 171}:    "I.S HIGH TECH.INC",
	[3]byte{0, 31, 172}:    "Goodmill Systems Ltd",
	[3]byte{0, 31, 173}:    "Brown Innovations, Inc",
	[3]byte{0, 31, 174}:    "Blick South Africa (Pty) Ltd",
	[3]byte{0, 31, 175}:    "NextIO, Inc.",
	[3]byte{0, 31, 176}:    "TimeIPS, Inc.",
	[3]byte{0, 31, 177}:    "Cybertech Inc.",
	[3]byte{0, 31, 178}:    "Sontheim Industrie Elektronik GmbH",
	[3]byte{0, 31, 179}:    "2Wire",
	[3]byte{0, 31, 180}:    "SmartShare Systems",
	[3]byte{0, 31, 181}:    "I/O Interconnect Inc.",
	[3]byte{0, 31, 182}:    "Chi Lin Technology Co., Ltd.",
	[3]byte{0, 31, 183}:    "WiMate Technologies Corp.",
	[3]byte{0, 31, 184}:    "Universal Remote Control, Inc.",
	[3]byte{0, 31, 185}:    "Paltronics",
	[3]byte{0, 31, 186}:    "BoYoung Tech. & Marketing, Inc.",
	[3]byte{0, 31, 187}:    "Xenatech Co.,LTD",
	[3]byte{0, 31, 188}:    "EVGA Corporation",
	[3]byte{0, 31, 189}:    "Kyocera Wireless Corp.",
	[3]byte{0, 31, 190}:    "Shenzhen Mopnet Industrial Co.,Ltd",
	[3]byte{0, 31, 191}:    "Fulhua Microelectronics Corp. Taiwan Branch",
	[3]byte{0, 31, 192}:    "Control Express Finland Oy",
	[3]byte{0, 31, 193}:    "Hanlong Technology Co.,LTD",
	[3]byte{0, 31, 194}:    "Jow Tong Technology Co Ltd",
	[3]byte{0, 31, 195}:    "SmartSynch, Inc",
	[3]byte{0, 31, 196}:    "ARRIS Group, Inc.",
	[3]byte{0, 31, 197}:    "Nintendo Co., Ltd.",
	[3]byte{0, 31, 198}:    "ASUSTek COMPUTER INC.",
	[3]byte{0, 31, 199}:    "Casio Hitachi Mobile Comunications Co., Ltd.",
	[3]byte{0, 31, 200}:    "Up-Today Industrial Co., Ltd.",
	[3]byte{0, 31, 201}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 31, 202}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 31, 203}:    "NIW Solutions",
	[3]byte{0, 31, 204}:    "Samsung Electronics Co.,Ltd",
	[3]byte{0, 31, 205}:    "Samsung Electronics",
	[3]byte{0, 31, 206}:    "QTECH LLC",
	[3]byte{0, 31, 207}:    "MSI Technology GmbH",
	[3]byte{0, 31, 208}:    "GIGA-BYTE TECHNOLOGY CO.,LTD.",
	[3]byte{0, 31, 209}:    "OPTEX CO.,LTD.",
	[3]byte{0, 31, 210}:    "COMMTECH TECHNOLOGY MACAO COMMERCIAL OFFSHORE LTD.",
	[3]byte{0, 31, 211}:    "RIVA Networks Inc.",
	[3]byte{0, 31, 212}:    "4IPNET, INC.",
	[3]byte{0, 31, 213}:    "MICRORISC s.r.o.",
	[3]byte{0, 31, 214}:    "Shenzhen Allywll",
	[3]byte{0, 31, 215}:    "TELERAD SA",
	[3]byte{0, 31, 216}:    "A-TRUST COMPUTER CORPORATION",
	[3]byte{0, 31, 217}:    "RSD Communications Ltd",
	[3]byte{0, 31, 218}:    "Nortel Networks",
	[3]byte{0, 31, 219}:    "Network Supply Corp.,",
	[3]byte{0, 31, 220}:    "Mobile Safe Track Ltd",
	[3]byte{0, 31, 221}:    "GDI LLC",
	[3]byte{0, 31, 222}:    "Nokia Danmark A/S",
	[3]byte{0, 31, 223}:    "Nokia Danmark A/S",
	[3]byte{0, 31, 224}:    "EdgeVelocity Corp",
	[3]byte{0, 31, 225}:    "Hon Hai Precision Ind. Co., Ltd.",
	[3]byte{0, 31, 226}:    "Hon Hai Precision Ind. Co., Ltd.",
	[3]byte{0, 31, 227}:    "LG Electronics",
	[3]byte{0, 31, 228}:    "Sony Ericsson Mobile Communications",
	[3]byte{0, 31, 229}:    "In-Circuit GmbH",
	[3]byte{0, 31, 230}:    "Alphion Corporation",
	[3]byte{0, 31, 231}:    "Simet",
	[3]byte{0, 31, 232}:    "KURUSUGAWA Electronics Industry Inc,.",
	[3]byte{0, 31, 233}:    "Printrex, Inc.",
	[3]byte{0, 31, 234}:    "Applied Media Technologies Corporation",
	[3]byte{0, 31, 235}:    "Trio Datacom Pty Ltd",
	[3]byte{0, 31, 236}:    "Synapse Électronique",
	[3]byte{0, 31, 237}:    "Tecan Systems Inc.",
	[3]byte{0, 31, 238}:    "ubisys technologies GmbH",
	[3]byte{0, 31, 239}:    "SHINSEI INDUSTRIES CO.,LTD",
	[3]byte{0, 31, 240}:    "Audio Partnership",
	[3]byte{0, 31, 241}:    "Paradox Hellas S.A.",
	[3]byte{0, 31, 242}:    "VIA Technologies, Inc.",
	[3]byte{0, 31, 243}:    "Apple",
	[3]byte{0, 31, 244}:    "Power Monitors, Inc.",
	[3]byte{0, 31, 245}:    "Kongsberg Defence & Aerospace",
	[3]byte{0, 31, 246}:    "PS Audio International",
	[3]byte{0, 31, 247}:    "Nakajima All Precision Co., Ltd.",
	[3]byte{0, 31, 248}:    "Siemens AG, Sector Industry, Drive Technologies, Motion Control Systems",
	[3]byte{0, 31, 249}:    "Advanced Knowledge Associates",
	[3]byte{0, 31, 250}:    "Coretree, Co, Ltd",
	[3]byte{0, 31, 251}:    "Green Packet Bhd",
	[3]byte{0, 31, 252}:    "Riccius+Sohn GmbH",
	[3]byte{0, 31, 253}:    "Indigo Mobile Technologies Corp.",
	[3]byte{0, 31, 254}:    "HPN Supply Chain",
	[3]byte{0, 31, 255}:    "Respironics, Inc.",
	[3]byte{0, 32, 0}:      "LEXMARK INTERNATIONAL, INC.",
	[3]byte{0, 32, 1}:      "DSP SOLUTIONS, INC.",
	[3]byte{0, 32, 2}:      "SERITECH ENTERPRISE CO., LTD.",
	[3]byte{0, 32, 3}:      "PIXEL POWER LTD.",
	[3]byte{0, 32, 4}:      "YAMATAKE-HONEYWELL CO., LTD.",
	[3]byte{0, 32, 5}:      "SIMPLE TECHNOLOGY",
	[3]byte{0, 32, 6}:      "GARRETT COMMUNICATIONS, INC.",
	[3]byte{0, 32, 7}:      "SFA, INC.",
	[3]byte{0, 32, 8}:      "CABLE & COMPUTER TECHNOLOGY",
	[3]byte{0, 32, 9}:      "PACKARD BELL ELEC., INC.",
	[3]byte{0, 32, 10}:     "SOURCE-COMM CORP.",
	[3]byte{0, 32, 11}:     "OCTAGON SYSTEMS CORP.",
	[3]byte{0, 32, 12}:     "ADASTRA SYSTEMS CORP.",
	[3]byte{0, 32, 13}:     "CARL ZEISS",
	[3]byte{0, 32, 14}:     "SATELLITE TECHNOLOGY MGMT, INC",
	[3]byte{0, 32, 15}:     "TANBAC CO., LTD.",
	[3]byte{0, 32, 16}:     "JEOL SYSTEM TECHNOLOGY CO. LTD",
	[3]byte{0, 32, 17}:     "CANOPUS CO., LTD.",
	[3]byte{0, 32, 18}:     "CAMTRONICS MEDICAL SYSTEMS",
	[3]byte{0, 32, 19}:     "DIVERSIFIED TECHNOLOGY, INC.",
	[3]byte{0, 32, 20}:     "GLOBAL VIEW CO., LTD.",
	[3]byte{0, 32, 21}:     "ACTIS COMPUTER SA",
	[3]byte{0, 32, 22}:     "SHOWA ELECTRIC WIRE & CABLE CO",
	[3]byte{0, 32, 23}:     "ORBOTECH",
	[3]byte{0, 32, 24}:     "CIS TECHNOLOGY INC.",
	[3]byte{0, 32, 25}:     "OHLER GmbH",
	[3]byte{0, 32, 26}:     "MRV Communications, Inc.",
	[3]byte{0, 32, 27}:     "NORTHERN TELECOM/NETWORK",
	[3]byte{0, 32, 28}:     "EXCEL, INC.",
	[3]byte{0, 32, 29}:     "KATANA PRODUCTS",
	[3]byte{0, 32, 30}:     "NETQUEST CORPORATION",
	[3]byte{0, 32, 31}:     "BEST POWER TECHNOLOGY, INC.",
	[3]byte{0, 32, 32}:     "MEGATRON COMPUTER INDUSTRIES PTY, LTD.",
	[3]byte{0, 32, 33}:     "ALGORITHMS SOFTWARE PVT. LTD.",
	[3]byte{0, 32, 34}:     "NMS Communications",
	[3]byte{0, 32, 35}:     "T.C. TECHNOLOGIES PTY. LTD",
	[3]byte{0, 32, 36}:     "PACIFIC COMMUNICATION SCIENCES",
	[3]byte{0, 32, 37}:     "CONTROL TECHNOLOGY, INC.",
	[3]byte{0, 32, 38}:     "AMKLY SYSTEMS, INC.",
	[3]byte{0, 32, 39}:     "MING FORTUNE INDUSTRY CO., LTD",
	[3]byte{0, 32, 40}:     "WEST EGG SYSTEMS, INC.",
	[3]byte{0, 32, 41}:     "TELEPROCESSING PRODUCTS, INC.",
	[3]byte{0, 32, 42}:     "N.V. DZINE",
	[3]byte{0, 32, 43}:     "ADVANCED TELECOMMUNICATIONS MODULES, LTD.",
	[3]byte{0, 32, 44}:     "WELLTRONIX CO., LTD.",
	[3]byte{0, 32, 45}:     "TAIYO CORPORATION",
	[3]byte{0, 32, 46}:     "DAYSTAR DIGITAL",
	[3]byte{0, 32, 47}:     "ZETA COMMUNICATIONS, LTD.",
	[3]byte{0, 32, 48}:     "ANALOG & DIGITAL SYSTEMS",
	[3]byte{0, 32, 49}:     "Tattile SRL",
	[3]byte{0, 32, 50}:     "ALCATEL TAISEL",
	[3]byte{0, 32, 51}:     "SYNAPSE TECHNOLOGIES, INC.",
	[3]byte{0, 32, 52}:     "ROTEC INDUSTRIEAUTOMATION GMBH",
	[3]byte{0, 32, 53}:     "IBM Corp",
	[3]byte{0, 32, 54}:     "BMC SOFTWARE",
	[3]byte{0, 32, 55}:     "SEAGATE TECHNOLOGY",
	[3]byte{0, 32, 56}:     "VME MICROSYSTEMS INTERNATIONAL CORPORATION",
	[3]byte{0, 32, 57}:     "SCINETS",
	[3]byte{0, 32, 58}:     "DIGITAL BI0METRICS INC.",
	[3]byte{0, 32, 59}:     "WISDM LTD.",
	[3]byte{0, 32, 60}:     "EUROTIME AB",
	[3]byte{0, 32, 61}:     "Honeywell ECC",
	[3]byte{0, 32, 62}:     "LogiCan Technologies, Inc.",
	[3]byte{0, 32, 63}:     "JUKI CORPORATION",
	[3]byte{0, 32, 64}:     "ARRIS Group, Inc.",
	[3]byte{0, 32, 65}:     "DATA NET",
	[3]byte{0, 32, 66}:     "DATAMETRICS CORP.",
	[3]byte{0, 32, 67}:     "NEURON COMPANY LIMITED",
	[3]byte{0, 32, 68}:     "GENITECH PTY LTD",
	[3]byte{0, 32, 69}:     "ION Networks, Inc.",
	[3]byte{0, 32, 70}:     "CIPRICO, INC.",
	[3]byte{0, 32, 71}:     "STEINBRECHER CORP.",
	[3]byte{0, 32, 72}:     "Marconi Communications",
	[3]byte{0, 32, 73}:     "COMTRON, INC.",
	[3]byte{0, 32, 74}:     "PRONET GMBH",
	[3]byte{0, 32, 75}:     "AUTOCOMPUTER CO., LTD.",
	[3]byte{0, 32, 76}:     "MITRON COMPUTER PTE LTD.",
	[3]byte{0, 32, 77}:     "INOVIS GMBH",
	[3]byte{0, 32, 78}:     "NETWORK SECURITY SYSTEMS, INC.",
	[3]byte{0, 32, 79}:     "DEUTSCHE AEROSPACE AG",
	[3]byte{0, 32, 80}:     "KOREA COMPUTER INC.",
	[3]byte{0, 32, 81}:     "Verilink Corporation",
	[3]byte{0, 32, 82}:     "RAGULA SYSTEMS",
	[3]byte{0, 32, 83}:     "HUNTSVILLE MICROSYSTEMS, INC.",
	[3]byte{0, 32, 84}:     "Sycamore Networks",
	[3]byte{0, 32, 85}:     "ALTECH CO., LTD.",
	[3]byte{0, 32, 86}:     "NEOPRODUCTS",
	[3]byte{0, 32, 87}:     "TITZE DATENTECHNIK GmbH",
	[3]byte{0, 32, 88}:     "ALLIED SIGNAL INC.",
	[3]byte{0, 32, 89}:     "MIRO COMPUTER PRODUCTS AG",
	[3]byte{0, 32, 90}:     "COMPUTER IDENTICS",
	[3]byte{0, 32, 91}:     "Kentrox, LLC",
	[3]byte{0, 32, 92}:     "InterNet Systems of Florida, Inc.",
	[3]byte{0, 32, 93}:     "NANOMATIC OY",
	[3]byte{0, 32, 94}:     "CASTLE ROCK, INC.",
	[3]byte{0, 32, 95}:     "GAMMADATA COMPUTER GMBH",
	[3]byte{0, 32, 96}:     "ALCATEL ITALIA S.p.A.",
	[3]byte{0, 32, 97}:     "GarrettCom, Inc.",
	[3]byte{0, 32, 98}:     "SCORPION LOGIC, LTD.",
	[3]byte{0, 32, 99}:     "WIPRO INFOTECH LTD.",
	[3]byte{0, 32, 100}:    "PROTEC MICROSYSTEMS, INC.",
	[3]byte{0, 32, 101}:    "SUPERNET NETWORKING INC.",
	[3]byte{0, 32, 102}:    "GENERAL MAGIC, INC.",
	[3]byte{0, 32, 103}:    "PRIVATE",
	[3]byte{0, 32, 104}:    "ISDYNE",
	[3]byte{0, 32, 105}:    "ISDN SYSTEMS CORPORATION",
	[3]byte{0, 32, 106}:    "OSAKA COMPUTER CORP.",
	[3]byte{0, 32, 107}:    "KONICA MINOLTA HOLDINGS, INC.",
	[3]byte{0, 32, 108}:    "EVERGREEN TECHNOLOGY CORP.",
	[3]byte{0, 32, 109}:    "DATA RACE, INC.",
	[3]byte{0, 32, 110}:    "XACT, INC.",
	[3]byte{0, 32, 111}:    "FLOWPOINT CORPORATION",
	[3]byte{0, 32, 112}:    "HYNET, LTD.",
	[3]byte{0, 32, 113}:    "IBR GMBH",
	[3]byte{0, 32, 114}:    "WORKLINK INNOVATIONS",
	[3]byte{0, 32, 115}:    "FUSION SYSTEMS CORPORATION",
	[3]byte{0, 32, 116}:    "SUNGWOON SYSTEMS",
	[3]byte{0, 32, 117}:    "MOTOROLA COMMUNICATION ISRAEL",
	[3]byte{0, 32, 118}:    "REUDO CORPORATION",
	[3]byte{0, 32, 119}:    "KARDIOS SYSTEMS CORP.",
	[3]byte{0, 32, 120}:    "RUNTOP, INC.",
	[3]byte{0, 32, 121}:    "MIKRON GMBH",
	[3]byte{0, 32, 122}:    "WiSE Communications, Inc.",
	[3]byte{0, 32, 123}:    "Intel Corporation",
	[3]byte{0, 32, 124}:    "AUTEC GmbH",
	[3]byte{0, 32, 125}:    "ADVANCED COMPUTER APPLICATIONS",
	[3]byte{0, 32, 126}:    "FINECOM Co., Ltd.",
	[3]byte{0, 32, 127}:    "KYOEI SANGYO CO., LTD.",
	[3]byte{0, 32, 128}:    "SYNERGY (UK) LTD.",
	[3]byte{0, 32, 129}:    "TITAN ELECTRONICS",
	[3]byte{0, 32, 130}:    "ONEAC CORPORATION",
	[3]byte{0, 32, 131}:    "PRESTICOM INCORPORATED",
	[3]byte{0, 32, 132}:    "OCE PRINTING SYSTEMS, GMBH",
	[3]byte{0, 32, 133}:    "Eaton Corporation",
	[3]byte{0, 32, 134}:    "MICROTECH ELECTRONICS LIMITED",
	[3]byte{0, 32, 135}:    "MEMOTEC, INC.",
	[3]byte{0, 32, 136}:    "GLOBAL VILLAGE COMMUNICATION",
	[3]byte{0, 32, 137}:    "T3PLUS NETWORKING, INC.",
	[3]byte{0, 32, 138}:    "SONIX COMMUNICATIONS, LTD.",
	[3]byte{0, 32, 139}:    "LAPIS TECHNOLOGIES, INC.",
	[3]byte{0, 32, 140}:    "GALAXY NETWORKS, INC.",
	[3]byte{0, 32, 141}:    "CMD TECHNOLOGY",
	[3]byte{0, 32, 142}:    "CHEVIN SOFTWARE ENG. LTD.",
	[3]byte{0, 32, 143}:    "ECI TELECOM LTD.",
	[3]byte{0, 32, 144}:    "ADVANCED COMPRESSION TECHNOLOGY, INC.",
	[3]byte{0, 32, 145}:    "J125, NATIONAL SECURITY AGENCY",
	[3]byte{0, 32, 146}:    "CHESS ENGINEERING B.V.",
	[3]byte{0, 32, 147}:    "LANDINGS TECHNOLOGY CORP.",
	[3]byte{0, 32, 148}:    "CUBIX CORPORATION",
	[3]byte{0, 32, 149}:    "RIVA ELECTRONICS",
	[3]byte{0, 32, 150}:    "Invensys",
	[3]byte{0, 32, 151}:    "APPLIED SIGNAL TECHNOLOGY",
	[3]byte{0, 32, 152}:    "HECTRONIC AB",
	[3]byte{0, 32, 153}:    "BON ELECTRIC CO., LTD.",
	[3]byte{0, 32, 154}:    "THE 3DO COMPANY",
	[3]byte{0, 32, 155}:    "ERSAT ELECTRONIC GMBH",
	[3]byte{0, 32, 156}:    "PRIMARY ACCESS CORP.",
	[3]byte{0, 32, 157}:    "LIPPERT AUTOMATIONSTECHNIK",
	[3]byte{0, 32, 158}:    "BROWN'S OPERATING SYSTEM SERVICES, LTD.",
	[3]byte{0, 32, 159}:    "MERCURY COMPUTER SYSTEMS, INC.",
	[3]byte{0, 32, 160}:    "OA LABORATORY CO., LTD.",
	[3]byte{0, 32, 161}:    "DOVATRON",
	[3]byte{0, 32, 162}:    "GALCOM NETWORKING LTD.",
	[3]byte{0, 32, 163}:    "Harmonic, Inc",
	[3]byte{0, 32, 164}:    "MULTIPOINT NETWORKS",
	[3]byte{0, 32, 165}:    "API ENGINEERING",
	[3]byte{0, 32, 166}:    "Proxim Wireless",
	[3]byte{0, 32, 167}:    "PAIRGAIN TECHNOLOGIES, INC.",
	[3]byte{0, 32, 168}:    "SAST TECHNOLOGY CORP.",
	[3]byte{0, 32, 169}:    "WHITE HORSE INDUSTRIAL",
	[3]byte{0, 32, 170}:    "Ericsson Television Limited",
	[3]byte{0, 32, 171}:    "MICRO INDUSTRIES CORP.",
	[3]byte{0, 32, 172}:    "INTERFLEX DATENSYSTEME GMBH",
	[3]byte{0, 32, 173}:    "LINQ SYSTEMS",
	[3]byte{0, 32, 174}:    "ORNET DATA COMMUNICATION TECH.",
	[3]byte{0, 32, 175}:    "3COM CORPORATION",
	[3]byte{0, 32, 176}:    "GATEWAY DEVICES, INC.",
	[3]byte{0, 32, 177}:    "COMTECH RESEARCH INC.",
	[3]byte{0, 32, 178}:    "GKD Gesellschaft Fur Kommunikation Und Datentechnik",
	[3]byte{0, 32, 179}:    "Tattile SRL",
	[3]byte{0, 32, 180}:    "TERMA ELEKTRONIK AS",
	[3]byte{0, 32, 181}:    "YASKAWA ELECTRIC CORPORATION",
	[3]byte{0, 32, 182}:    "AGILE NETWORKS, INC.",
	[3]byte{0, 32, 183}:    "NAMAQUA COMPUTERWARE",
	[3]byte{0, 32, 184}:    "PRIME OPTION, INC.",
	[3]byte{0, 32, 185}:    "METRICOM, INC.",
	[3]byte{0, 32, 186}:    "CENTER FOR HIGH PERFORMANCE",
	[3]byte{0, 32, 187}:    "ZAX CORPORATION",
	[3]byte{0, 32, 188}:    "Long Reach Networks Pty Ltd",
	[3]byte{0, 32, 189}:    "NIOBRARA R & D CORPORATION",
	[3]byte{0, 32, 190}:    "LAN ACCESS CORP.",
	[3]byte{0, 32, 191}:    "AEHR TEST SYSTEMS",
	[3]byte{0, 32, 192}:    "PULSE ELECTRONICS, INC.",
	[3]byte{0, 32, 193}:    "SAXA, Inc.",
	[3]byte{0, 32, 194}:    "TEXAS MEMORY SYSTEMS, INC.",
	[3]byte{0, 32, 195}:    "COUNTER SOLUTIONS LTD.",
	[3]byte{0, 32, 196}:    "INET,INC.",
	[3]byte{0, 32, 197}:    "EAGLE TECHNOLOGY",
	[3]byte{0, 32, 198}:    "NECTEC",
	[3]byte{0, 32, 199}:    "AKAI Professional M.I. Corp.",
	[3]byte{0, 32, 200}:    "LARSCOM INCORPORATED",
	[3]byte{0, 32, 201}:    "VICTRON BV",
	[3]byte{0, 32, 202}:    "DIGITAL OCEAN",
	[3]byte{0, 32, 203}:    "PRETEC ELECTRONICS CORP.",
	[3]byte{0, 32, 204}:    "DIGITAL SERVICES, LTD.",
	[3]byte{0, 32, 205}:    "HYBRID NETWORKS, INC.",
	[3]byte{0, 32, 206}:    "LOGICAL DESIGN GROUP, INC.",
	[3]byte{0, 32, 207}:    "TEST & MEASUREMENT SYSTEMS INC",
	[3]byte{0, 32, 208}:    "VERSALYNX CORPORATION",
	[3]byte{0, 32, 209}:    "MICROCOMPUTER SYSTEMS (M) SDN.",
	[3]byte{0, 32, 210}:    "RAD DATA COMMUNICATIONS, LTD.",
	[3]byte{0, 32, 211}:    "OST (OUEST STANDARD TELEMATIQU",
	[3]byte{0, 32, 212}:    "CABLETRON - ZEITTNET INC.",
	[3]byte{0, 32, 213}:    "VIPA GMBH",
	[3]byte{0, 32, 214}:    "BREEZECOM",
	[3]byte{0, 32, 215}:    "JAPAN MINICOMPUTER SYSTEMS CO., Ltd.",
	[3]byte{0, 32, 216}:    "Nortel Networks",
	[3]byte{0, 32, 217}:    "PANASONIC TECHNOLOGIES, INC./MIECO-US",
	[3]byte{0, 32, 218}:    "Alcatel North America ESD",
	[3]byte{0, 32, 219}:    "XNET TECHNOLOGY, INC.",
	[3]byte{0, 32, 220}:    "DENSITRON TAIWAN LTD.",
	[3]byte{0, 32, 221}:    "Cybertec Pty Ltd",
	[3]byte{0, 32, 222}:    "JAPAN DIGITAL LABORAT'Y CO.LTD",
	[3]byte{0, 32, 223}:    "KYOSAN ELECTRIC MFG. CO., LTD.",
	[3]byte{0, 32, 224}:    "Actiontec Electronics, Inc.",
	[3]byte{0, 32, 225}:    "ALAMAR ELECTRONICS",
	[3]byte{0, 32, 226}:    "INFORMATION RESOURCE ENGINEERING",
	[3]byte{0, 32, 227}:    "MCD KENCOM CORPORATION",
	[3]byte{0, 32, 228}:    "HSING TECH ENTERPRISE CO., LTD",
	[3]byte{0, 32, 229}:    "APEX DATA, INC.",
	[3]byte{0, 32, 230}:    "LIDKOPING MACHINE TOOLS AB",
	[3]byte{0, 32, 231}:    "B&W NUCLEAR SERVICE COMPANY",
	[3]byte{0, 32, 232}:    "DATATREK CORPORATION",
	[3]byte{0, 32, 233}:    "DANTEL",
	[3]byte{0, 32, 234}:    "EFFICIENT NETWORKS, INC.",
	[3]byte{0, 32, 235}:    "CINCINNATI MICROWAVE, INC.",
	[3]byte{0, 32, 236}:    "TECHWARE SYSTEMS CORP.",
	[3]byte{0, 32, 237}:    "GIGA-BYTE TECHNOLOGY CO., LTD.",
	[3]byte{0, 32, 238}:    "GTECH CORPORATION",
	[3]byte{0, 32, 239}:    "USC CORPORATION",
	[3]byte{0, 32, 240}:    "UNIVERSAL MICROELECTRONICS CO.",
	[3]byte{0, 32, 241}:    "ALTOS INDIA LIMITED",
	[3]byte{0, 32, 242}:    "Oracle Corporation",
	[3]byte{0, 32, 243}:    "RAYNET CORPORATION",
	[3]byte{0, 32, 244}:    "SPECTRIX CORPORATION",
	[3]byte{0, 32, 245}:    "PANDATEL AG",
	[3]byte{0, 32, 246}:    "NET TEK  AND KARLNET, INC.",
	[3]byte{0, 32, 247}:    "CYBERDATA CORPORATION",
	[3]byte{0, 32, 248}:    "CARRERA COMPUTERS, INC.",
	[3]byte{0, 32, 249}:    "PARALINK NETWORKS, INC.",
	[3]byte{0, 32, 250}:    "GDE SYSTEMS, INC.",
	[3]byte{0, 32, 251}:    "OCTEL COMMUNICATIONS CORP.",
	[3]byte{0, 32, 252}:    "MATROX",
	[3]byte{0, 32, 253}:    "ITV TECHNOLOGIES, INC.",
	[3]byte{0, 32, 254}:    "TOPWARE INC. / GRAND COMPUTER",
	[3]byte{0, 32, 255}:    "SYMMETRICAL TECHNOLOGIES",
	[3]byte{0, 33, 0}:      "GemTek Technology Co., Ltd.",
	[3]byte{0, 33, 1}:      "Aplicaciones Electronicas Quasar (AEQ)",
	[3]byte{0, 33, 2}:      "UpdateLogic Inc.",
	[3]byte{0, 33, 3}:      "GHI Electronics, LLC",
	[3]byte{0, 33, 4}:      "Gigaset Communications GmbH",
	[3]byte{0, 33, 5}:      "Alcatel-Lucent",
	[3]byte{0, 33, 6}:      "RIM Testing Services",
	[3]byte{0, 33, 7}:      "Seowonintech Co Ltd.",
	[3]byte{0, 33, 8}:      "Nokia Danmark A/S",
	[3]byte{0, 33, 9}:      "Nokia Danmark A/S",
	[3]byte{0, 33, 10}:     "byd:sign Corporation",
	[3]byte{0, 33, 11}:     "GEMINI TRAZE RFID PVT. LTD.",
	[3]byte{0, 33, 12}:     "Cymtec Systems, Inc.",
	[3]byte{0, 33, 13}:     "SAMSIN INNOTEC",
	[3]byte{0, 33, 14}:     "Orpak Systems L.T.D.",
	[3]byte{0, 33, 15}:     "Cernium Corp",
	[3]byte{0, 33, 16}:     "Clearbox Systems",
	[3]byte{0, 33, 17}:     "Uniphone Inc.",
	[3]byte{0, 33, 18}:     "WISCOM SYSTEM CO.,LTD",
	[3]byte{0, 33, 19}:     "Padtec S/A",
	[3]byte{0, 33, 20}:     "Hylab Technology Inc.",
	[3]byte{0, 33, 21}:     "PHYWE Systeme GmbH & Co. KG",
	[3]byte{0, 33, 22}:     "Transcon Electronic Systems, spol. s r. o.",
	[3]byte{0, 33, 23}:     "Tellord",
	[3]byte{0, 33, 24}:     "Athena Tech, Inc.",
	[3]byte{0, 33, 25}:     "Samsung Electro-Mechanics",
	[3]byte{0, 33, 26}:     "LInTech Corporation",
	[3]byte{0, 33, 27}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 33, 28}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 33, 29}:     "Dataline AB",
	[3]byte{0, 33, 30}:     "ARRIS Group, Inc.",
	[3]byte{0, 33, 31}:     "SHINSUNG DELTATECH CO.,LTD.",
	[3]byte{0, 33, 32}:     "Sequel Technologies",
	[3]byte{0, 33, 33}:     "VRmagic GmbH",
	[3]byte{0, 33, 34}:     "Chip-pro Ltd.",
	[3]byte{0, 33, 35}:     "Aerosat Avionics",
	[3]byte{0, 33, 36}:     "Optos Plc",
	[3]byte{0, 33, 37}:     "KUK JE TONG SHIN Co.,LTD",
	[3]byte{0, 33, 38}:     "Shenzhen Torch Equipment Co., Ltd.",
	[3]byte{0, 33, 39}:     "TP-LINK Technology Co., Ltd.",
	[3]byte{0, 33, 40}:     "Oracle Corporation",
	[3]byte{0, 33, 41}:     "Cisco-Linksys, LLC",
	[3]byte{0, 33, 42}:     "Audiovox Corporation",
	[3]byte{0, 33, 43}:     "MSA Auer",
	[3]byte{0, 33, 44}:     "SemIndia System Private Limited",
	[3]byte{0, 33, 45}:     "SCIMOLEX CORPORATION",
	[3]byte{0, 33, 46}:     "dresden-elektronik",
	[3]byte{0, 33, 47}:     "Phoebe Micro Inc.",
	[3]byte{0, 33, 48}:     "Keico Hightech Inc.",
	[3]byte{0, 33, 49}:     "Blynke Inc.",
	[3]byte{0, 33, 50}:     "Masterclock, Inc.",
	[3]byte{0, 33, 51}:     "Building B, Inc",
	[3]byte{0, 33, 52}:     "Brandywine Communications",
	[3]byte{0, 33, 53}:     "ALCATEL-LUCENT",
	[3]byte{0, 33, 54}:     "ARRIS Group, Inc.",
	[3]byte{0, 33, 55}:     "Bay Controls, LLC",
	[3]byte{0, 33, 56}:     "Cepheid",
	[3]byte{0, 33, 57}:     "Escherlogic Inc.",
	[3]byte{0, 33, 58}:     "Winchester Systems Inc.",
	[3]byte{0, 33, 59}:     "Berkshire Products, Inc",
	[3]byte{0, 33, 60}:     "AliphCom",
	[3]byte{0, 33, 61}:     "Cermetek Microelectronics, Inc.",
	[3]byte{0, 33, 62}:     "TomTom",
	[3]byte{0, 33, 63}:     "A-Team Technology Ltd.",
	[3]byte{0, 33, 64}:     "EN Technologies Inc.",
	[3]byte{0, 33, 65}:     "RADLIVE",
	[3]byte{0, 33, 66}:     "Advanced Control Systems doo",
	[3]byte{0, 33, 67}:     "ARRIS Group, Inc.",
	[3]byte{0, 33, 68}:     "SS Telecoms",
	[3]byte{0, 33, 69}:     "Semptian Technologies Ltd.",
	[3]byte{0, 33, 70}:     "Sanmina-SCI",
	[3]byte{0, 33, 71}:     "Nintendo Co., Ltd.",
	[3]byte{0, 33, 72}:     "Kaco Solar Korea",
	[3]byte{0, 33, 73}:     "China Daheng Group ,Inc.",
	[3]byte{0, 33, 74}:     "Pixel Velocity, Inc",
	[3]byte{0, 33, 75}:     "Shenzhen HAMP Science & Technology Co.,Ltd",
	[3]byte{0, 33, 76}:     "SAMSUNG ELECTRONICS CO., LTD.",
	[3]byte{0, 33, 77}:     "Guangzhou Skytone Transmission Technology Com. Ltd.",
	[3]byte{0, 33, 78}:     "GS Yuasa Power Supply Ltd.",
	[3]byte{0, 33, 79}:     "ALPS Electric Co., Ltd",
	[3]byte{0, 33, 80}:     "EYEVIEW ELECTRONICS",
	[3]byte{0, 33, 81}:     "Millinet Co., Ltd.",
	[3]byte{0, 33, 82}:     "General Satellite Research & Development Limited",
	[3]byte{0, 33, 83}:     "SeaMicro Inc.",
	[3]byte{0, 33, 84}:     "D-TACQ Solutions Ltd",
	[3]byte{0, 33, 85}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 33, 86}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 33, 87}:     "National Datacast, Inc.",
	[3]byte{0, 33, 88}:     "Style Flying Technology Co.",
	[3]byte{0, 33, 89}:     "Juniper Networks",
	[3]byte{0, 33, 90}:     "Hewlett-Packard Company",
	[3]byte{0, 33, 91}:     "Inotive",
	[3]byte{0, 33, 92}:     "Intel Corporate",
	[3]byte{0, 33, 93}:     "Intel Corporate",
	[3]byte{0, 33, 94}:     "IBM Corp",
	[3]byte{0, 33, 95}:     "IHSE GmbH",
	[3]byte{0, 33, 96}:     "Hidea Solutions Co. Ltd.",
	[3]byte{0, 33, 97}:     "Yournet Inc.",
	[3]byte{0, 33, 98}:     "Nortel",
	[3]byte{0, 33, 99}:     "ASKEY COMPUTER CORP",
	[3]byte{0, 33, 100}:    "Special Design Bureau for Seismic Instrumentation",
	[3]byte{0, 33, 101}:    "Presstek Inc.",
	[3]byte{0, 33, 102}:    "NovAtel Inc.",
	[3]byte{0, 33, 103}:    "HWA JIN T&I Corp.",
	[3]byte{0, 33, 104}:    "iVeia, LLC",
	[3]byte{0, 33, 105}:    "Prologix, LLC.",
	[3]byte{0, 33, 106}:    "Intel Corporate",
	[3]byte{0, 33, 107}:    "Intel Corporate",
	[3]byte{0, 33, 108}:    "ODVA",
	[3]byte{0, 33, 109}:    "Soltech Co., Ltd.",
	[3]byte{0, 33, 110}:    "Function ATI (Huizhou) Telecommunications Co., Ltd.",
	[3]byte{0, 33, 111}:    "SymCom, Inc.",
	[3]byte{0, 33, 112}:    "Dell Inc",
	[3]byte{0, 33, 113}:    "Wesung TNC Co., Ltd.",
	[3]byte{0, 33, 114}:    "Seoultek Valley",
	[3]byte{0, 33, 115}:    "Ion Torrent Systems, Inc.",
	[3]byte{0, 33, 116}:    "AvaLAN Wireless",
	[3]byte{0, 33, 117}:    "Pacific Satellite International Ltd.",
	[3]byte{0, 33, 118}:    "YMax Telecom Ltd.",
	[3]byte{0, 33, 119}:    "W. L. Gore & Associates",
	[3]byte{0, 33, 120}:    "Matuschek Messtechnik GmbH",
	[3]byte{0, 33, 121}:    "IOGEAR, Inc.",
	[3]byte{0, 33, 122}:    "Sejin Electron, Inc.",
	[3]byte{0, 33, 123}:    "Bastec AB",
	[3]byte{0, 33, 124}:    "2Wire",
	[3]byte{0, 33, 125}:    "PYXIS S.R.L.",
	[3]byte{0, 33, 126}:    "Telit Communication s.p.a",
	[3]byte{0, 33, 127}:    "Intraco Technology Pte Ltd",
	[3]byte{0, 33, 128}:    "ARRIS Group, Inc.",
	[3]byte{0, 33, 129}:    "Si2 Microsystems Limited",
	[3]byte{0, 33, 130}:    "SandLinks Systems, Ltd.",
	[3]byte{0, 33, 131}:    "VATECH HYDRO",
	[3]byte{0, 33, 132}:    "POWERSOFT SRL",
	[3]byte{0, 33, 133}:    "MICRO-STAR INT'L CO.,LTD.",
	[3]byte{0, 33, 134}:    "Universal Global Scientific Industrial Co., Ltd",
	[3]byte{0, 33, 135}:    "Imacs GmbH",
	[3]byte{0, 33, 136}:    "EMC Corporation",
	[3]byte{0, 33, 137}:    "AppTech, Inc.",
	[3]byte{0, 33, 138}:    "Electronic Design and Manufacturing Company",
	[3]byte{0, 33, 139}:    "Wescon Technology, Inc.",
	[3]byte{0, 33, 140}:    "TopControl GMBH",
	[3]byte{0, 33, 141}:    "AP Router Ind. Eletronica LTDA",
	[3]byte{0, 33, 142}:    "MEKICS CO., LTD.",
	[3]byte{0, 33, 143}:    "Avantgarde Acoustic Lautsprechersysteme GmbH",
	[3]byte{0, 33, 144}:    "Goliath Solutions",
	[3]byte{0, 33, 145}:    "D-Link Corporation",
	[3]byte{0, 33, 146}:    "Baoding Galaxy Electronic Technology  Co.,Ltd",
	[3]byte{0, 33, 147}:    "Videofon MV",
	[3]byte{0, 33, 148}:    "Ping Communication",
	[3]byte{0, 33, 149}:    "GWD Media Limited",
	[3]byte{0, 33, 150}:    "Telsey  S.p.A.",
	[3]byte{0, 33, 151}:    "ELITEGROUP COMPUTER SYSTEM",
	[3]byte{0, 33, 152}:    "Thai Radio Co, LTD",
	[3]byte{0, 33, 153}:    "Vacon Plc",
	[3]byte{0, 33, 154}:    "Cambridge Visual Networks Ltd",
	[3]byte{0, 33, 155}:    "Dell Inc",
	[3]byte{0, 33, 156}:    "Honeywld Technology Corp.",
	[3]byte{0, 33, 157}:    "Adesys BV",
	[3]byte{0, 33, 158}:    "Sony Ericsson Mobile Communications",
	[3]byte{0, 33, 159}:    "SATEL OY",
	[3]byte{0, 33, 160}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 33, 161}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 33, 162}:    "EKE-Electronics Ltd.",
	[3]byte{0, 33, 163}:    "Micromint",
	[3]byte{0, 33, 164}:    "Dbii Networks",
	[3]byte{0, 33, 165}:    "ERLPhase Power Technologies Ltd.",
	[3]byte{0, 33, 166}:    "Videotec Spa",
	[3]byte{0, 33, 167}:    "Hantle System Co., Ltd.",
	[3]byte{0, 33, 168}:    "Telephonics Corporation",
	[3]byte{0, 33, 169}:    "Mobilink Telecom Co.,Ltd",
	[3]byte{0, 33, 170}:    "Nokia Danmark A/S",
	[3]byte{0, 33, 171}:    "Nokia Danmark A/S",
	[3]byte{0, 33, 172}:    "Infrared Integrated Systems Ltd",
	[3]byte{0, 33, 173}:    "Nordic ID Oy",
	[3]byte{0, 33, 174}:    "ALCATEL-LUCENT FRANCE - WTD",
	[3]byte{0, 33, 175}:    "Radio Frequency Systems",
	[3]byte{0, 33, 176}:    "Tyco Telecommunications",
	[3]byte{0, 33, 177}:    "DIGITAL SOLUTIONS LTD",
	[3]byte{0, 33, 178}:    "Fiberblaze A/S",
	[3]byte{0, 33, 179}:    "Ross Controls",
	[3]byte{0, 33, 180}:    "APRO MEDIA CO., LTD",
	[3]byte{0, 33, 181}:    "Galvanic Ltd",
	[3]byte{0, 33, 182}:    "Triacta Power Technologies Inc.",
	[3]byte{0, 33, 183}:    "Lexmark International Inc.",
	[3]byte{0, 33, 184}:    "Inphi Corporation",
	[3]byte{0, 33, 185}:    "Universal Devices Inc.",
	[3]byte{0, 33, 186}:    "Texas Instruments",
	[3]byte{0, 33, 187}:    "Riken Keiki Co., Ltd.",
	[3]byte{0, 33, 188}:    "ZALA COMPUTER",
	[3]byte{0, 33, 189}:    "Nintendo Co., Ltd.",
	[3]byte{0, 33, 190}:    "Cisco, Service Provider Video Technology Group",
	[3]byte{0, 33, 191}:    "Hitachi High-Tech Control Systems Corporation",
	[3]byte{0, 33, 192}:    "Mobile Appliance, Inc.",
	[3]byte{0, 33, 193}:    "ABB Oy / Medium Voltage Products",
	[3]byte{0, 33, 194}:    "GL Communications Inc",
	[3]byte{0, 33, 195}:    "CORNELL Communications, Inc.",
	[3]byte{0, 33, 196}:    "Consilium AB",
	[3]byte{0, 33, 197}:    "3DSP Corp",
	[3]byte{0, 33, 198}:    "CSJ Global, Inc.",
	[3]byte{0, 33, 199}:    "Russound",
	[3]byte{0, 33, 200}:    "LOHUIS Networks",
	[3]byte{0, 33, 201}:    "Wavecom Asia Pacific Limited",
	[3]byte{0, 33, 202}:    "ART System Co., Ltd.",
	[3]byte{0, 33, 203}:    "SMS TECNOLOGIA ELETRONICA LTDA",
	[3]byte{0, 33, 204}:    "Flextronics International",
	[3]byte{0, 33, 205}:    "LiveTV",
	[3]byte{0, 33, 206}:    "NTC-Metrotek",
	[3]byte{0, 33, 207}:    "The Crypto Group",
	[3]byte{0, 33, 208}:    "Global Display Solutions Spa",
	[3]byte{0, 33, 209}:    "Samsung Electronics Co.,Ltd",
	[3]byte{0, 33, 210}:    "Samsung Electronics Co.,Ltd",
	[3]byte{0, 33, 211}:    "BOCOM SECURITY(ASIA PACIFIC) LIMITED",
	[3]byte{0, 33, 212}:    "Vollmer Werke GmbH",
	[3]byte{0, 33, 213}:    "X2E GmbH",
	[3]byte{0, 33, 214}:    "LXI Consortium",
	[3]byte{0, 33, 215}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 33, 216}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 33, 217}:    "SEKONIC CORPORATION",
	[3]byte{0, 33, 218}:    "Automation Products Group Inc.",
	[3]byte{0, 33, 219}:    "Santachi Video Technology (Shenzhen) Co., Ltd.",
	[3]byte{0, 33, 220}:    "TECNOALARM S.r.l.",
	[3]byte{0, 33, 221}:    "Northstar Systems Corp",
	[3]byte{0, 33, 222}:    "Firepro Wireless",
	[3]byte{0, 33, 223}:    "Martin Christ GmbH",
	[3]byte{0, 33, 224}:    "CommAgility Ltd",
	[3]byte{0, 33, 225}:    "Nortel Networks",
	[3]byte{0, 33, 226}:    "Creative Electronic GmbH",
	[3]byte{0, 33, 227}:    "SerialTek LLC",
	[3]byte{0, 33, 228}:    "I-WIN",
	[3]byte{0, 33, 229}:    "Display Solution AG",
	[3]byte{0, 33, 230}:    "Starlight Video Limited",
	[3]byte{0, 33, 231}:    "Informatics Services Corporation",
	[3]byte{0, 33, 232}:    "Murata Manufacturing Co., Ltd.",
	[3]byte{0, 33, 233}:    "Apple",
	[3]byte{0, 33, 234}:    "Bystronic Laser AG",
	[3]byte{0, 33, 235}:    "ESP SYSTEMS, LLC",
	[3]byte{0, 33, 236}:    "Solutronic GmbH",
	[3]byte{0, 33, 237}:    "Telegesis",
	[3]byte{0, 33, 238}:    "Full Spectrum Inc.",
	[3]byte{0, 33, 239}:    "Kapsys",
	[3]byte{0, 33, 240}:    "EW3 Technologies LLC",
	[3]byte{0, 33, 241}:    "Tutus Data AB",
	[3]byte{0, 33, 242}:    "EASY3CALL Technology Limited",
	[3]byte{0, 33, 243}:    "Si14 SpA",
	[3]byte{0, 33, 244}:    "INRange Systems, Inc",
	[3]byte{0, 33, 245}:    "Western Engravers Supply, Inc.",
	[3]byte{0, 33, 246}:    "Oracle Corporation",
	[3]byte{0, 33, 247}:    "HPN Supply Chain",
	[3]byte{0, 33, 248}:    "Enseo, Inc.",
	[3]byte{0, 33, 249}:    "WIRECOM Technologies",
	[3]byte{0, 33, 250}:    "A4SP Technologies Ltd.",
	[3]byte{0, 33, 251}:    "LG Electronics",
	[3]byte{0, 33, 252}:    "Nokia Danmark A/S",
	[3]byte{0, 33, 253}:    "DSTA S.L.",
	[3]byte{0, 33, 254}:    "Nokia Danmark A/S",
	[3]byte{0, 33, 255}:    "Cyfrowy Polsat SA",
	[3]byte{0, 34, 0}:      "IBM Corp",
	[3]byte{0, 34, 1}:      "Aksys Networks Inc",
	[3]byte{0, 34, 2}:      "Excito Elektronik i Skåne AB",
	[3]byte{0, 34, 3}:      "Glensound Electronics Ltd",
	[3]byte{0, 34, 4}:      "KORATEK",
	[3]byte{0, 34, 5}:      "WeLink Solutions, Inc.",
	[3]byte{0, 34, 6}:      "Cyberdyne Inc.",
	[3]byte{0, 34, 7}:      "Inteno Broadband Technology AB",
	[3]byte{0, 34, 8}:      "Certicom Corp",
	[3]byte{0, 34, 9}:      "Omron Healthcare Co., Ltd",
	[3]byte{0, 34, 10}:     "OnLive, Inc",
	[3]byte{0, 34, 11}:     "National Source Coding Center",
	[3]byte{0, 34, 12}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 34, 13}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 34, 14}:     "Indigo Security Co., Ltd.",
	[3]byte{0, 34, 15}:     "MoCA (Multimedia over Coax Alliance)",
	[3]byte{0, 34, 16}:     "ARRIS Group, Inc.",
	[3]byte{0, 34, 17}:     "Rohati Systems",
	[3]byte{0, 34, 18}:     "CAI Networks, Inc.",
	[3]byte{0, 34, 19}:     "PCI CORPORATION",
	[3]byte{0, 34, 20}:     "RINNAI KOREA",
	[3]byte{0, 34, 21}:     "ASUSTek COMPUTER INC.",
	[3]byte{0, 34, 22}:     "SHIBAURA VENDING MACHINE CORPORATION",
	[3]byte{0, 34, 23}:     "Neat Electronics",
	[3]byte{0, 34, 24}:     "Verivue Inc.",
	[3]byte{0, 34, 25}:     "Dell Inc",
	[3]byte{0, 34, 26}:     "Audio Precision",
	[3]byte{0, 34, 27}:     "Morega Systems",
	[3]byte{0, 34, 28}:     "PRIVATE",
	[3]byte{0, 34, 29}:     "Freegene Technology LTD",
	[3]byte{0, 34, 30}:     "Media Devices Co., Ltd.",
	[3]byte{0, 34, 31}:     "eSang Technologies Co., Ltd.",
	[3]byte{0, 34, 32}:     "Mitac Technology Corp",
	[3]byte{0, 34, 33}:     "ITOH DENKI CO,LTD.",
	[3]byte{0, 34, 34}:     "Schaffner Deutschland GmbH",
	[3]byte{0, 34, 35}:     "TimeKeeping Systems, Inc.",
	[3]byte{0, 34, 36}:     "Good Will Instrument Co., Ltd.",
	[3]byte{0, 34, 37}:     "Thales Avionics Ltd",
	[3]byte{0, 34, 38}:     "Avaak, Inc.",
	[3]byte{0, 34, 39}:     "uv-electronic GmbH",
	[3]byte{0, 34, 40}:     "Breeze Innovations Ltd.",
	[3]byte{0, 34, 41}:     "Compumedics Ltd",
	[3]byte{0, 34, 42}:     "SoundEar A/S",
	[3]byte{0, 34, 43}:     "Nucomm, Inc.",
	[3]byte{0, 34, 44}:     "Ceton Corp",
	[3]byte{0, 34, 45}:     "SMC Networks Inc.",
	[3]byte{0, 34, 46}:     "maintech GmbH",
	[3]byte{0, 34, 47}:     "Open Grid Computing, Inc.",
	[3]byte{0, 34, 48}:     "FutureLogic Inc.",
	[3]byte{0, 34, 49}:     "SMT&C Co., Ltd.",
	[3]byte{0, 34, 50}:     "Design Design Technology Ltd",
	[3]byte{0, 34, 51}:     "ADB Broadband Italia",
	[3]byte{0, 34, 52}:     "Corventis Inc.",
	[3]byte{0, 34, 53}:     "Strukton Systems bv",
	[3]byte{0, 34, 54}:     "VECTOR SP. Z O.O.",
	[3]byte{0, 34, 55}:     "Shinhint Group",
	[3]byte{0, 34, 56}:     "LOGIPLUS",
	[3]byte{0, 34, 57}:     "Indiana Life Sciences Incorporated",
	[3]byte{0, 34, 58}:     "Scientific Atlanta, Cisco SPVT Group",
	[3]byte{0, 34, 59}:     "Communication Networks, LLC",
	[3]byte{0, 34, 60}:     "RATIO Entwicklungen GmbH",
	[3]byte{0, 34, 61}:     "JumpGen Systems, LLC",
	[3]byte{0, 34, 62}:     "IRTrans GmbH",
	[3]byte{0, 34, 63}:     "Netgear Inc.",
	[3]byte{0, 34, 64}:     "Universal Telecom S/A",
	[3]byte{0, 34, 65}:     "Apple",
	[3]byte{0, 34, 66}:     "Alacron Inc.",
	[3]byte{0, 34, 67}:     "AzureWave Technologies, Inc.",
	[3]byte{0, 34, 68}:     "Chengdu Linkon Communications Device Co., Ltd",
	[3]byte{0, 34, 69}:     "Leine & Linde AB",
	[3]byte{0, 34, 70}:     "Evoc Intelligent Technology Co.,Ltd.",
	[3]byte{0, 34, 71}:     "DAC ENGINEERING CO., LTD.",
	[3]byte{0, 34, 72}:     "Microsoft Corporation",
	[3]byte{0, 34, 73}:     "HOME MULTIENERGY SL",
	[3]byte{0, 34, 74}:     "RAYLASE AG",
	[3]byte{0, 34, 75}:     "AIRTECH TECHNOLOGIES, INC.",
	[3]byte{0, 34, 76}:     "Nintendo Co., Ltd.",
	[3]byte{0, 34, 77}:     "MITAC INTERNATIONAL CORP.",
	[3]byte{0, 34, 78}:     "SEEnergy Corp.",
	[3]byte{0, 34, 79}:     "Byzoro Networks Ltd.",
	[3]byte{0, 34, 80}:     "Point Six Wireless, LLC",
	[3]byte{0, 34, 81}:     "Lumasense Technologies",
	[3]byte{0, 34, 82}:     "ZOLL Lifecor Corporation",
	[3]byte{0, 34, 83}:     "Entorian Technologies",
	[3]byte{0, 34, 84}:     "Bigelow Aerospace",
	[3]byte{0, 34, 85}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 34, 86}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 34, 87}:     "3Com Europe Ltd",
	[3]byte{0, 34, 88}:     "Taiyo Yuden Co., Ltd.",
	[3]byte{0, 34, 89}:     "Guangzhou New Postcom Equipment Co.,Ltd.",
	[3]byte{0, 34, 90}:     "Garde Security AB",
	[3]byte{0, 34, 91}:     "Teradici Corporation",
	[3]byte{0, 34, 92}:     "Multimedia & Communication Technology",
	[3]byte{0, 34, 93}:     "Digicable Network India Pvt. Ltd.",
	[3]byte{0, 34, 94}:     "Uwin Technologies Co.,LTD",
	[3]byte{0, 34, 95}:     "Liteon Technology Corporation",
	[3]byte{0, 34, 96}:     "AFREEY Inc.",
	[3]byte{0, 34, 97}:     "Frontier Silicon Ltd",
	[3]byte{0, 34, 98}:     "BEP Marine",
	[3]byte{0, 34, 99}:     "Koos Technical Services, Inc.",
	[3]byte{0, 34, 100}:    "Hewlett-Packard Company",
	[3]byte{0, 34, 101}:    "Nokia Danmark A/S",
	[3]byte{0, 34, 102}:    "Nokia Danmark A/S",
	[3]byte{0, 34, 103}:    "Nortel Networks",
	[3]byte{0, 34, 104}:    "Hon Hai Precision Ind. Co., Ltd.",
	[3]byte{0, 34, 105}:    "Hon Hai Precision Ind. Co., Ltd.",
	[3]byte{0, 34, 106}:    "Honeywell",
	[3]byte{0, 34, 107}:    "Cisco-Linksys, LLC",
	[3]byte{0, 34, 108}:    "LinkSprite Technologies, Inc.",
	[3]byte{0, 34, 109}:    "Shenzhen GIEC Electronics Co., Ltd.",
	[3]byte{0, 34, 110}:    "Gowell Electronic Limited",
	[3]byte{0, 34, 111}:    "3onedata Technology Co. Ltd.",
	[3]byte{0, 34, 112}:    "ABK North America, LLC",
	[3]byte{0, 34, 113}:    "Jäger Computergesteuerte Meßtechnik GmbH.",
	[3]byte{0, 34, 114}:    "American Micro-Fuel Device Corp.",
	[3]byte{0, 34, 115}:    "Techway",
	[3]byte{0, 34, 116}:    "FamilyPhone AB",
	[3]byte{0, 34, 117}:    "Belkin International Inc.",
	[3]byte{0, 34, 118}:    "Triple EYE B.V.",
	[3]byte{0, 34, 119}:    "NEC Australia Pty Ltd",
	[3]byte{0, 34, 120}:    "Shenzhen  Tongfang Multimedia  Technology Co.,Ltd.",
	[3]byte{0, 34, 121}:    "Nippon Conlux Co., Ltd.",
	[3]byte{0, 34, 122}:    "Telecom Design",
	[3]byte{0, 34, 123}:    "Apogee Labs, Inc.",
	[3]byte{0, 34, 124}:    "Woori SMT Co.,ltd",
	[3]byte{0, 34, 125}:    "YE DATA INC.",
	[3]byte{0, 34, 126}:    "Chengdu 30Kaitian Communication Industry Co.Ltd",
	[3]byte{0, 34, 127}:    "Ruckus Wireless",
	[3]byte{0, 34, 128}:    "A2B Electronics AB",
	[3]byte{0, 34, 129}:    "Daintree Networks Pty",
	[3]byte{0, 34, 130}:    "8086 Consultancy",
	[3]byte{0, 34, 131}:    "Juniper Networks",
	[3]byte{0, 34, 132}:    "DESAY A&V SCIENCE AND TECHNOLOGY CO.,LTD",
	[3]byte{0, 34, 133}:    "NOMUS COMM SYSTEMS",
	[3]byte{0, 34, 134}:    "ASTRON",
	[3]byte{0, 34, 135}:    "Titan Wireless LLC",
	[3]byte{0, 34, 136}:    "Sagrad, Inc.",
	[3]byte{0, 34, 137}:    "Optosecurity Inc.",
	[3]byte{0, 34, 138}:    "Teratronik elektronische systeme gmbh",
	[3]byte{0, 34, 139}:    "Kensington Computer Products Group",
	[3]byte{0, 34, 140}:    "Photon Europe GmbH",
	[3]byte{0, 34, 141}:    "GBS Laboratories LLC",
	[3]byte{0, 34, 142}:    "TV-NUMERIC",
	[3]byte{0, 34, 143}:    "CNRS",
	[3]byte{0, 34, 144}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 34, 145}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 34, 146}:    "Cinetal",
	[3]byte{0, 34, 147}:    "ZTE Corporation",
	[3]byte{0, 34, 148}:    "Kyocera Corporation",
	[3]byte{0, 34, 149}:    "SGM Technology for lighting spa",
	[3]byte{0, 34, 150}:    "LinoWave Corporation",
	[3]byte{0, 34, 151}:    "XMOS Semiconductor",
	[3]byte{0, 34, 152}:    "Sony Ericsson Mobile Communications",
	[3]byte{0, 34, 153}:    "SeaMicro Inc.",
	[3]byte{0, 34, 154}:    "Lastar, Inc.",
	[3]byte{0, 34, 155}:    "AverLogic Technologies, Inc.",
	[3]byte{0, 34, 156}:    "Verismo Networks Inc",
	[3]byte{0, 34, 157}:    "PYUNG-HWA IND.CO.,LTD",
	[3]byte{0, 34, 158}:    "Social Aid Research Co., Ltd.",
	[3]byte{0, 34, 159}:    "Sensys Traffic AB",
	[3]byte{0, 34, 160}:    "Delphi Corporation",
	[3]byte{0, 34, 161}:    "Huawei Symantec Technologies Co.,Ltd.",
	[3]byte{0, 34, 162}:    "Xtramus Technologies",
	[3]byte{0, 34, 163}:    "California Eastern Laboratories",
	[3]byte{0, 34, 164}:    "2Wire",
	[3]byte{0, 34, 165}:    "Texas Instruments",
	[3]byte{0, 34, 166}:    "Sony Computer Entertainment America",
	[3]byte{0, 34, 167}:    "Tyco Electronics AMP GmbH",
	[3]byte{0, 34, 168}:    "Ouman Oy",
	[3]byte{0, 34, 169}:    "LG Electronics Inc",
	[3]byte{0, 34, 170}:    "Nintendo Co., Ltd.",
	[3]byte{0, 34, 171}:    "Shenzhen Turbosight Technology Ltd",
	[3]byte{0, 34, 172}:    "Hangzhou Siyuan Tech. Co., Ltd",
	[3]byte{0, 34, 173}:    "TELESIS TECHNOLOGIES, INC.",
	[3]byte{0, 34, 174}:    "Mattel Inc.",
	[3]byte{0, 34, 175}:    "Safety Vision",
	[3]byte{0, 34, 176}:    "D-Link Corporation",
	[3]byte{0, 34, 177}:    "Elbit Systems",
	[3]byte{0, 34, 178}:    "4RF Communications Ltd",
	[3]byte{0, 34, 179}:    "Sei S.p.A.",
	[3]byte{0, 34, 180}:    "ARRIS Group, Inc.",
	[3]byte{0, 34, 181}:    "NOVITA",
	[3]byte{0, 34, 182}:    "Superflow Technologies Group",
	[3]byte{0, 34, 183}:    "GSS Grundig SAT-Systems GmbH",
	[3]byte{0, 34, 184}:    "Norcott",
	[3]byte{0, 34, 185}:    "Analogix Seminconductor, Inc",
	[3]byte{0, 34, 186}:    "HUTH Elektronik Systeme GmbH",
	[3]byte{0, 34, 187}:    "beyerdynamic GmbH & Co. KG",
	[3]byte{0, 34, 188}:    "JDSU France SAS",
	[3]byte{0, 34, 189}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 34, 190}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 34, 191}:    "SieAmp Group of Companies",
	[3]byte{0, 34, 192}:    "Shenzhen Forcelink Electronic Co, Ltd",
	[3]byte{0, 34, 193}:    "Active Storage Inc.",
	[3]byte{0, 34, 194}:    "Proview Eletrônica do Brasil LTDA",
	[3]byte{0, 34, 195}:    "Zeeport Technology Inc.",
	[3]byte{0, 34, 196}:    "epro GmbH",
	[3]byte{0, 34, 197}:    "INFORSON Co,Ltd.",
	[3]byte{0, 34, 198}:    "Sutus Inc",
	[3]byte{0, 34, 199}:    "SEGGER Microcontroller GmbH & Co. KG",
	[3]byte{0, 34, 200}:    "Applied Instruments B.V.",
	[3]byte{0, 34, 201}:    "Lenord, Bauer & Co GmbH",
	[3]byte{0, 34, 202}:    "Anviz Biometric Tech. Co., Ltd.",
	[3]byte{0, 34, 203}:    "IONODES Inc.",
	[3]byte{0, 34, 204}:    "SciLog, Inc.",
	[3]byte{0, 34, 205}:    "Ared Technology Co., Ltd.",
	[3]byte{0, 34, 206}:    "Cisco, Service Provider Video Technology Group",
	[3]byte{0, 34, 207}:    "PLANEX Communications INC",
	[3]byte{0, 34, 208}:    "Polar Electro Oy",
	[3]byte{0, 34, 209}:    "Albrecht Jung GmbH & Co. KG",
	[3]byte{0, 34, 210}:    "All Earth Comércio de Eletrônicos LTDA.",
	[3]byte{0, 34, 211}:    "Hub-Tech",
	[3]byte{0, 34, 212}:    "ComWorth Co., Ltd.",
	[3]byte{0, 34, 213}:    "Eaton Corp. Electrical Group Data Center Solutions - Pulizzi",
	[3]byte{0, 34, 214}:    "Cypak AB",
	[3]byte{0, 34, 215}:    "Nintendo Co., Ltd.",
	[3]byte{0, 34, 216}:    "Shenzhen GST Security and Safety Technology Limited",
	[3]byte{0, 34, 217}:    "Fortex Industrial Ltd.",
	[3]byte{0, 34, 218}:    "ANATEK, LLC",
	[3]byte{0, 34, 219}:    "Translogic Corporation",
	[3]byte{0, 34, 220}:    "Vigil Health Solutions Inc.",
	[3]byte{0, 34, 221}:    "Protecta Electronics Ltd",
	[3]byte{0, 34, 222}:    "OPPO Digital, Inc.",
	[3]byte{0, 34, 223}:    "TAMUZ Monitors",
	[3]byte{0, 34, 224}:    "Atlantic Software Technologies S.r.L.",
	[3]byte{0, 34, 225}:    "ZORT Labs, LLC.",
	[3]byte{0, 34, 226}:    "WABTEC Transit Division",
	[3]byte{0, 34, 227}:    "Amerigon",
	[3]byte{0, 34, 228}:    "APASS TECHNOLOGY CO., LTD.",
	[3]byte{0, 34, 229}:    "Fisher-Rosemount Systems Inc.",
	[3]byte{0, 34, 230}:    "Intelligent Data",
	[3]byte{0, 34, 231}:    "WPS Parking Systems",
	[3]byte{0, 34, 232}:    "Applition Co., Ltd.",
	[3]byte{0, 34, 233}:    "ProVision Communications",
	[3]byte{0, 34, 234}:    "Rustelcom Inc.",
	[3]byte{0, 34, 235}:    "Data Respons A/S",
	[3]byte{0, 34, 236}:    "IDEALBT TECHNOLOGY CORPORATION",
	[3]byte{0, 34, 237}:    "TSI Power Corporation",
	[3]byte{0, 34, 238}:    "Algo Communication Products Ltd",
	[3]byte{0, 34, 239}:    "iWDL Technologies",
	[3]byte{0, 34, 240}:    "3 Greens Aviation Limited",
	[3]byte{0, 34, 241}:    "PRIVATE",
	[3]byte{0, 34, 242}:    "SunPower Corp",
	[3]byte{0, 34, 243}:    "SHARP Corporation",
	[3]byte{0, 34, 244}:    "AMPAK Technology, Inc.",
	[3]byte{0, 34, 245}:    "Advanced Realtime Tracking GmbH",
	[3]byte{0, 34, 246}:    "Syracuse Research Corporation",
	[3]byte{0, 34, 247}:    "Conceptronic",
	[3]byte{0, 34, 248}:    "PIMA Electronic Systems Ltd.",
	[3]byte{0, 34, 249}:    "Pollin Electronic GmbH",
	[3]byte{0, 34, 250}:    "Intel Corporate",
	[3]byte{0, 34, 251}:    "Intel Corporate",
	[3]byte{0, 34, 252}:    "Nokia Danmark A/S",
	[3]byte{0, 34, 253}:    "Nokia Danmark A/S",
	[3]byte{0, 34, 254}:    "Microprocessor Designs Inc",
	[3]byte{0, 34, 255}:    "iWDL Technologies",
	[3]byte{0, 35, 0}:      "Cayee Computer Ltd.",
	[3]byte{0, 35, 1}:      "Witron Technology Limited",
	[3]byte{0, 35, 2}:      "Cobalt Digital, Inc.",
	[3]byte{0, 35, 3}:      "LITE-ON IT Corporation",
	[3]byte{0, 35, 4}:      "CISCO SYSTEMS, INC.",
	[3]byte{0, 35, 5}:      "CISCO SYSTEMS, INC.",
	[3]byte{0, 35, 6}:      "ALPS Electric Co., Ltd",
	[3]byte{0, 35, 7}:      "FUTURE INNOVATION TECH CO.,LTD",
	[3]byte{0, 35, 8}:      "Arcadyan Technology Corporation",
	[3]byte{0, 35, 9}:      "Janam Technologies LLC",
	[3]byte{0, 35, 10}:     "ARBURG GmbH & Co KG",
	[3]byte{0, 35, 11}:     "ARRIS Group, Inc.",
	[3]byte{0, 35, 12}:     "CLOVER ELECTRONICS CO.,LTD.",
	[3]byte{0, 35, 13}:     "Nortel Networks",
	[3]byte{0, 35, 14}:     "Gorba AG",
	[3]byte{0, 35, 15}:     "Hirsch Electronics Corporation",
	[3]byte{0, 35, 16}:     "LNC Technology Co., Ltd.",
	[3]byte{0, 35, 17}:     "Gloscom Co., Ltd.",
	[3]byte{0, 35, 18}:     "Apple",
	[3]byte{0, 35, 19}:     "Qool Technologies Ltd.",
	[3]byte{0, 35, 20}:     "Intel Corporate",
	[3]byte{0, 35, 21}:     "Intel Corporate",
	[3]byte{0, 35, 22}:     "KISAN ELECTRONICS CO",
	[3]byte{0, 35, 23}:     "Lasercraft Inc",
	[3]byte{0, 35, 24}:     "Toshiba",
	[3]byte{0, 35, 25}:     "Sielox LLC",
	[3]byte{0, 35, 26}:     "ITF Co., Ltd.",
	[3]byte{0, 35, 27}:     "Danaher Motion - Kollmorgen",
	[3]byte{0, 35, 28}:     "Fourier Systems Ltd.",
	[3]byte{0, 35, 29}:     "Deltacom Electronics Ltd",
	[3]byte{0, 35, 30}:     "Cezzer Multimedia Technologies",
	[3]byte{0, 35, 31}:     "Guangda Electronic & Telecommunication Technology Development Co., Ltd.",
	[3]byte{0, 35, 32}:     "Nicira Networks",
	[3]byte{0, 35, 33}:     "Avitech International Corp",
	[3]byte{0, 35, 34}:     "KISS Teknical Solutions, Inc.",
	[3]byte{0, 35, 35}:     "Zylin AS",
	[3]byte{0, 35, 36}:     "G-PRO COMPUTER",
	[3]byte{0, 35, 37}:     "IOLAN Holding",
	[3]byte{0, 35, 38}:     "Fujitsu Limited",
	[3]byte{0, 35, 39}:     "Shouyo Electronics CO., LTD",
	[3]byte{0, 35, 40}:     "ALCON TELECOMMUNICATIONS CO., LTD.",
	[3]byte{0, 35, 41}:     "DDRdrive LLC",
	[3]byte{0, 35, 42}:     "eonas IT-Beratung und -Entwicklung GmbH",
	[3]byte{0, 35, 43}:     "IRD A/S",
	[3]byte{0, 35, 44}:     "Senticare",
	[3]byte{0, 35, 45}:     "SandForce",
	[3]byte{0, 35, 46}:     "Kedah Electronics Engineering, LLC",
	[3]byte{0, 35, 47}:     "Advanced Card Systems Ltd.",
	[3]byte{0, 35, 48}:     "DIZIPIA, INC.",
	[3]byte{0, 35, 49}:     "Nintendo Co., Ltd.",
	[3]byte{0, 35, 50}:     "Apple",
	[3]byte{0, 35, 51}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 35, 52}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 35, 53}:     "Linkflex Co.,Ltd",
	[3]byte{0, 35, 54}:     "METEL s.r.o.",
	[3]byte{0, 35, 55}:     "Global Star Solutions ULC",
	[3]byte{0, 35, 56}:     "OJ-Electronics A/S",
	[3]byte{0, 35, 57}:     "Samsung Electronics",
	[3]byte{0, 35, 58}:     "Samsung Electronics Co.,Ltd",
	[3]byte{0, 35, 59}:     "C-Matic Systems Ltd",
	[3]byte{0, 35, 60}:     "Alflex",
	[3]byte{0, 35, 61}:     "Novero holding B.V.",
	[3]byte{0, 35, 62}:     "Alcatel-Lucent-IPD",
	[3]byte{0, 35, 63}:     "Purechoice Inc",
	[3]byte{0, 35, 64}:     "MiX Telematics",
	[3]byte{0, 35, 65}:     "Siemens AB, Infrastructure & Cities, Building Technologies Division, IC BT SSP SP BA PR",
	[3]byte{0, 35, 66}:     "Coffee Equipment Company",
	[3]byte{0, 35, 67}:     "TEM AG",
	[3]byte{0, 35, 68}:     "Objective Interface Systems, Inc.",
	[3]byte{0, 35, 69}:     "Sony Ericsson Mobile Communications",
	[3]byte{0, 35, 70}:     "Vestac",
	[3]byte{0, 35, 71}:     "ProCurve Networking by HP",
	[3]byte{0, 35, 72}:     "SAGEM COMMUNICATION",
	[3]byte{0, 35, 73}:     "Helmholtz Centre Berlin for Material and Energy",
	[3]byte{0, 35, 74}:     "PRIVATE",
	[3]byte{0, 35, 75}:     "Inyuan Technology Inc.",
	[3]byte{0, 35, 76}:     "KTC AB",
	[3]byte{0, 35, 77}:     "Hon Hai Precision Ind. Co., Ltd.",
	[3]byte{0, 35, 78}:     "Hon Hai Precision Ind. Co., Ltd.",
	[3]byte{0, 35, 79}:     "Luminous Power Technologies Pvt. Ltd.",
	[3]byte{0, 35, 80}:     "LynTec",
	[3]byte{0, 35, 81}:     "2Wire",
	[3]byte{0, 35, 82}:     "DATASENSOR S.p.A.",
	[3]byte{0, 35, 83}:     "F E T Elettronica snc",
	[3]byte{0, 35, 84}:     "ASUSTek COMPUTER INC.",
	[3]byte{0, 35, 85}:     "Kinco Automation(Shanghai) Ltd.",
	[3]byte{0, 35, 86}:     "Packet Forensics LLC",
	[3]byte{0, 35, 87}:     "Pitronot Technologies and Engineering P.T.E. Ltd.",
	[3]byte{0, 35, 88}:     "SYSTEL SA",
	[3]byte{0, 35, 89}:     "Benchmark Electronics ( Thailand ) Public Company Limited",
	[3]byte{0, 35, 90}:     "COMPAL INFORMATION (KUNSHAN) CO., Ltd.",
	[3]byte{0, 35, 91}:     "Gulfstream",
	[3]byte{0, 35, 92}:     "Aprius, Inc.",
	[3]byte{0, 35, 93}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 35, 94}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 35, 95}:     "Silicon Micro Sensors GmbH",
	[3]byte{0, 35, 96}:     "Lookit Technology Co., Ltd",
	[3]byte{0, 35, 97}:     "Unigen Corporation",
	[3]byte{0, 35, 98}:     "Goldline Controls",
	[3]byte{0, 35, 99}:     "Zhuhai RaySharp Technology Co., Ltd.",
	[3]byte{0, 35, 100}:    "Power Instruments Pte Ltd",
	[3]byte{0, 35, 101}:    "ELKA-Elektronik GmbH",
	[3]byte{0, 35, 102}:    "Beijing Siasun Electronic System Co.,Ltd.",
	[3]byte{0, 35, 103}:    "UniControls a.s.",
	[3]byte{0, 35, 104}:    "Motorola",
	[3]byte{0, 35, 105}:    "Cisco-Linksys, LLC",
	[3]byte{0, 35, 106}:    "SmartRG Inc",
	[3]byte{0, 35, 107}:    "Xembedded, Inc.",
	[3]byte{0, 35, 108}:    "Apple",
	[3]byte{0, 35, 109}:    "ResMed Ltd",
	[3]byte{0, 35, 110}:    "Burster GmbH & Co KG",
	[3]byte{0, 35, 111}:    "DAQ System",
	[3]byte{0, 35, 112}:    "Snell",
	[3]byte{0, 35, 113}:    "SOAM Systel",
	[3]byte{0, 35, 114}:    "MORE STAR INDUSTRIAL GROUP LIMITED",
	[3]byte{0, 35, 115}:    "GridIron Systems, Inc.",
	[3]byte{0, 35, 116}:    "ARRIS Group, Inc.",
	[3]byte{0, 35, 117}:    "ARRIS Group, Inc.",
	[3]byte{0, 35, 118}:    "HTC Corporation",
	[3]byte{0, 35, 119}:    "Isotek Electronics Ltd",
	[3]byte{0, 35, 120}:    "GN Netcom A/S",
	[3]byte{0, 35, 121}:    "Union Business Machines Co. Ltd.",
	[3]byte{0, 35, 122}:    "RIM",
	[3]byte{0, 35, 123}:    "WHDI LLC",
	[3]byte{0, 35, 124}:    "NEOTION",
	[3]byte{0, 35, 125}:    "Hewlett-Packard Company",
	[3]byte{0, 35, 126}:    "ELSTER GMBH",
	[3]byte{0, 35, 127}:    "PLANTRONICS, INC.",
	[3]byte{0, 35, 128}:    "Nanoteq",
	[3]byte{0, 35, 129}:    "Lengda Technology(Xiamen) Co.,Ltd.",
	[3]byte{0, 35, 130}:    "Lih Rong Electronic Enterprise Co., Ltd.",
	[3]byte{0, 35, 131}:    "InMage Systems Inc",
	[3]byte{0, 35, 132}:    "GGH Engineering s.r.l.",
	[3]byte{0, 35, 133}:    "ANTIPODE",
	[3]byte{0, 35, 134}:    "Tour & Andersson AB",
	[3]byte{0, 35, 135}:    "ThinkFlood, Inc.",
	[3]byte{0, 35, 136}:    "V.T. Telematica S.p.a.",
	[3]byte{0, 35, 137}:    "HANGZHOU H3C Technologies Co., Ltd.",
	[3]byte{0, 35, 138}:    "Ciena Corporation",
	[3]byte{0, 35, 139}:    "Quanta Computer Inc.",
	[3]byte{0, 35, 140}:    "PRIVATE",
	[3]byte{0, 35, 141}:    "Techno Design Co., Ltd.",
	[3]byte{0, 35, 142}:    "Pirelli Tyre S.p.A.",
	[3]byte{0, 35, 143}:    "NIDEC COPAL CORPORATION",
	[3]byte{0, 35, 144}:    "Algolware Corporation",
	[3]byte{0, 35, 145}:    "Maxian",
	[3]byte{0, 35, 146}:    "Proteus Industries Inc.",
	[3]byte{0, 35, 147}:    "AJINEXTEK",
	[3]byte{0, 35, 148}:    "Samjeon",
	[3]byte{0, 35, 149}:    "ARRIS Group, Inc.",
	[3]byte{0, 35, 150}:    "ANDES TECHNOLOGY CORPORATION",
	[3]byte{0, 35, 151}:    "Westell Technologies Inc.",
	[3]byte{0, 35, 152}:    "Sky Control",
	[3]byte{0, 35, 153}:    "VD Division, Samsung Electronics Co.",
	[3]byte{0, 35, 154}:    "EasyData Hardware GmbH",
	[3]byte{0, 35, 155}:    "Elster Solutions, LLC",
	[3]byte{0, 35, 156}:    "Juniper Networks",
	[3]byte{0, 35, 157}:    "Mapower Electronics Co., Ltd",
	[3]byte{0, 35, 158}:    "Jiangsu Lemote Technology Corporation Limited",
	[3]byte{0, 35, 159}:    "Institut für Prüftechnik",
	[3]byte{0, 35, 160}:    "Hana CNS Co., LTD.",
	[3]byte{0, 35, 161}:    "Trend Electronics Ltd",
	[3]byte{0, 35, 162}:    "ARRIS Group, Inc.",
	[3]byte{0, 35, 163}:    "ARRIS Group, Inc.",
	[3]byte{0, 35, 164}:    "New Concepts Development Corp.",
	[3]byte{0, 35, 165}:    "SageTV, LLC",
	[3]byte{0, 35, 166}:    "E-Mon",
	[3]byte{0, 35, 167}:    "Redpine Signals, Inc.",
	[3]byte{0, 35, 168}:    "Marshall Electronics",
	[3]byte{0, 35, 169}:    "Beijing Detianquan Electromechanical Equipment Co., Ltd",
	[3]byte{0, 35, 170}:    "HFR, Inc.",
	[3]byte{0, 35, 171}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 35, 172}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 35, 173}:    "Xmark Corporation",
	[3]byte{0, 35, 174}:    "Dell Inc.",
	[3]byte{0, 35, 175}:    "ARRIS Group, Inc.",
	[3]byte{0, 35, 176}:    "COMXION Technology Inc.",
	[3]byte{0, 35, 177}:    "Longcheer Technology (Singapore) Pte Ltd",
	[3]byte{0, 35, 178}:    "Intelligent Mechatronic Systems Inc",
	[3]byte{0, 35, 179}:    "Lyyn AB",
	[3]byte{0, 35, 180}:    "Nokia Danmark A/S",
	[3]byte{0, 35, 181}:    "ORTANA LTD",
	[3]byte{0, 35, 182}:    "SECURITE COMMUNICATIONS / HONEYWELL",
	[3]byte{0, 35, 183}:    "Q-Light Co., Ltd.",
	[3]byte{0, 35, 184}:    "Sichuan Jiuzhou Electronic Technology Co.,Ltd",
	[3]byte{0, 35, 185}:    "EADS Deutschland GmbH",
	[3]byte{0, 35, 186}:    "Chroma",
	[3]byte{0, 35, 187}:    "Schmitt Industries",
	[3]byte{0, 35, 188}:    "EQ-SYS GmbH",
	[3]byte{0, 35, 189}:    "Digital Ally, Inc.",
	[3]byte{0, 35, 190}:    "Cisco SPVTG",
	[3]byte{0, 35, 191}:    "Mainpine, Inc.",
	[3]byte{0, 35, 192}:    "Broadway Networks",
	[3]byte{0, 35, 193}:    "Securitas Direct AB",
	[3]byte{0, 35, 194}:    "SAMSUNG Electronics. Co. LTD",
	[3]byte{0, 35, 195}:    "LogMeIn, Inc.",
	[3]byte{0, 35, 196}:    "Lux Lumen",
	[3]byte{0, 35, 197}:    "Radiation Safety and Control Services Inc",
	[3]byte{0, 35, 198}:    "SMC Corporation",
	[3]byte{0, 35, 199}:    "AVSystem",
	[3]byte{0, 35, 200}:    "TEAM-R",
	[3]byte{0, 35, 201}:    "Sichuan Tianyi Information Science & Technology Stock CO.,LTD",
	[3]byte{0, 35, 202}:    "Behind The Set, LLC",
	[3]byte{0, 35, 203}:    "Shenzhen Full-join Technology Co.,Ltd",
	[3]byte{0, 35, 204}:    "Nintendo Co., Ltd.",
	[3]byte{0, 35, 205}:    "TP-LINK TECHNOLOGIES CO., LTD.",
	[3]byte{0, 35, 206}:    "KITA DENSHI CORPORATION",
	[3]byte{0, 35, 207}:    "CUMMINS-ALLISON CORP.",
	[3]byte{0, 35, 208}:    "Uniloc USA Inc.",
	[3]byte{0, 35, 209}:    "TRG",
	[3]byte{0, 35, 210}:    "Inhand Electronics, Inc.",
	[3]byte{0, 35, 211}:    "AirLink WiFi Networking Corp.",
	[3]byte{0, 35, 212}:    "Texas Instruments",
	[3]byte{0, 35, 213}:    "WAREMA electronic GmbH",
	[3]byte{0, 35, 214}:    "Samsung Electronics Co.,LTD",
	[3]byte{0, 35, 215}:    "Samsung Electronics",
	[3]byte{0, 35, 216}:    "Ball-It Oy",
	[3]byte{0, 35, 217}:    "Banner Engineering",
	[3]byte{0, 35, 218}:    "Industrial Computer Source (Deutschland)GmbH",
	[3]byte{0, 35, 219}:    "saxnet gmbh",
	[3]byte{0, 35, 220}:    "Benein, Inc",
	[3]byte{0, 35, 221}:    "ELGIN S.A.",
	[3]byte{0, 35, 222}:    "Ansync Inc.",
	[3]byte{0, 35, 223}:    "Apple",
	[3]byte{0, 35, 224}:    "INO Therapeutics LLC",
	[3]byte{0, 35, 225}:    "Cavena Image Products AB",
	[3]byte{0, 35, 226}:    "SEA Signalisation",
	[3]byte{0, 35, 227}:    "Microtronic AG",
	[3]byte{0, 35, 228}:    "IPnect co. ltd.",
	[3]byte{0, 35, 229}:    "IPaXiom Networks",
	[3]byte{0, 35, 230}:    "Pirkus, Inc.",
	[3]byte{0, 35, 231}:    "Hinke A/S",
	[3]byte{0, 35, 232}:    "Demco Corp.",
	[3]byte{0, 35, 233}:    "F5 Networks, Inc.",
	[3]byte{0, 35, 234}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 35, 235}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 35, 236}:    "Algorithmix GmbH",
	[3]byte{0, 35, 237}:    "ARRIS Group, Inc.",
	[3]byte{0, 35, 238}:    "ARRIS Group, Inc.",
	[3]byte{0, 35, 239}:    "Zuend Systemtechnik AG",
	[3]byte{0, 35, 240}:    "Shanghai Jinghan Weighing Apparatus Co. Ltd.",
	[3]byte{0, 35, 241}:    "Sony Ericsson Mobile Communications",
	[3]byte{0, 35, 242}:    "TVLogic",
	[3]byte{0, 35, 243}:    "Glocom, Inc.",
	[3]byte{0, 35, 244}:    "Masternaut",
	[3]byte{0, 35, 245}:    "WILO SE",
	[3]byte{0, 35, 246}:    "Softwell Technology Co., Ltd.",
	[3]byte{0, 35, 247}:    "PRIVATE",
	[3]byte{0, 35, 248}:    "ZyXEL Communications Corporation",
	[3]byte{0, 35, 249}:    "Double-Take Software, INC.",
	[3]byte{0, 35, 250}:    "RG Nets, Inc.",
	[3]byte{0, 35, 251}:    "IP Datatel, LLC.",
	[3]byte{0, 35, 252}:    "Ultra Stereo Labs, Inc",
	[3]byte{0, 35, 253}:    "AFT Atlas Fahrzeugtechnik GmbH",
	[3]byte{0, 35, 254}:    "Biodevices, SA",
	[3]byte{0, 35, 255}:    "Beijing HTTC Technology Ltd.",
	[3]byte{0, 36, 0}:      "Nortel Networks",
	[3]byte{0, 36, 1}:      "D-Link Corporation",
	[3]byte{0, 36, 2}:      "Op-Tection GmbH",
	[3]byte{0, 36, 3}:      "Nokia Danmark A/S",
	[3]byte{0, 36, 4}:      "Nokia Danmark A/S",
	[3]byte{0, 36, 5}:      "Dilog Nordic AB",
	[3]byte{0, 36, 6}:      "Pointmobile",
	[3]byte{0, 36, 7}:      "TELEM SAS",
	[3]byte{0, 36, 8}:      "Pacific Biosciences",
	[3]byte{0, 36, 9}:      "The Toro Company",
	[3]byte{0, 36, 10}:     "US Beverage Net",
	[3]byte{0, 36, 11}:     "Virtual Computer Inc.",
	[3]byte{0, 36, 12}:     "DELEC GmbH",
	[3]byte{0, 36, 13}:     "OnePath Networks LTD.",
	[3]byte{0, 36, 14}:     "Inventec Besta Co., Ltd.",
	[3]byte{0, 36, 15}:     "Ishii Tool & Engineering Corporation",
	[3]byte{0, 36, 16}:     "NUETEQ Technology,Inc.",
	[3]byte{0, 36, 17}:     "PharmaSmart LLC",
	[3]byte{0, 36, 18}:     "Benign Technologies Co, Ltd.",
	[3]byte{0, 36, 19}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 36, 20}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 36, 21}:     "Magnetic Autocontrol GmbH",
	[3]byte{0, 36, 22}:     "Any Use",
	[3]byte{0, 36, 23}:     "Thomson Telecom Belgium",
	[3]byte{0, 36, 24}:     "Nextwave Semiconductor",
	[3]byte{0, 36, 25}:     "PRIVATE",
	[3]byte{0, 36, 26}:     "Red Beetle Inc.",
	[3]byte{0, 36, 27}:     "iWOW Communications Pte Ltd",
	[3]byte{0, 36, 28}:     "FuGang Electronic (DG) Co.,Ltd",
	[3]byte{0, 36, 29}:     "GIGA-BYTE TECHNOLOGY CO.,LTD.",
	[3]byte{0, 36, 30}:     "Nintendo Co., Ltd.",
	[3]byte{0, 36, 31}:     "DCT-Delta GmbH",
	[3]byte{0, 36, 32}:     "NetUP Inc.",
	[3]byte{0, 36, 33}:     "MICRO-STAR INT'L CO., LTD.",
	[3]byte{0, 36, 34}:     "Knapp Logistik Automation GmbH",
	[3]byte{0, 36, 35}:     "AzureWave Technologies (Shanghai) Inc.",
	[3]byte{0, 36, 36}:     "Axis Network Technology",
	[3]byte{0, 36, 37}:     "Shenzhenshi chuangzhicheng Technology Co.,Ltd",
	[3]byte{0, 36, 38}:     "NOHMI BOSAI LTD.",
	[3]byte{0, 36, 39}:     "SSI COMPUTER CORP",
	[3]byte{0, 36, 40}:     "EnergyICT",
	[3]byte{0, 36, 41}:     "MK MASTER INC.",
	[3]byte{0, 36, 42}:     "Hittite Microwave Corporation",
	[3]byte{0, 36, 43}:     "Hon Hai Precision Ind.Co.,Ltd.",
	[3]byte{0, 36, 44}:     "Hon Hai Precision Ind. Co., Ltd.",
	[3]byte{0, 36, 46}:     "Datastrip Inc.",
	[3]byte{0, 36, 47}:     "Micron",
	[3]byte{0, 36, 48}:     "Ruby Tech Corp.",
	[3]byte{0, 36, 49}:     "Uni-v co.,ltd",
	[3]byte{0, 36, 50}:     "Neostar Technology Co.,LTD",
	[3]byte{0, 36, 51}:     "Alps Electric Co., Ltd",
	[3]byte{0, 36, 52}:     "Lectrosonics, Inc.",
	[3]byte{0, 36, 53}:     "WIDE CORPORATION",
	[3]byte{0, 36, 54}:     "Apple",
	[3]byte{0, 36, 55}:     "Motorola - BSG",
	[3]byte{0, 36, 56}:     "Brocade Communications Systems, Inc",
	[3]byte{0, 36, 57}:     "Digital Barriers Advanced Technologies",
	[3]byte{0, 36, 58}:     "Ludl Electronic Products",
	[3]byte{0, 36, 59}:     "CSSI (S) Pte Ltd",
	[3]byte{0, 36, 60}:     "S.A.A.A.",
	[3]byte{0, 36, 61}:     "Emerson Appliance Motors and Controls",
	[3]byte{0, 36, 63}:     "Storwize, Inc.",
	[3]byte{0, 36, 64}:     "Halo Monitoring, Inc.",
	[3]byte{0, 36, 65}:     "Wanzl Metallwarenfabrik GmbH",
	[3]byte{0, 36, 66}:     "Axona Limited",
	[3]byte{0, 36, 67}:     "Nortel Networks",
	[3]byte{0, 36, 68}:     "Nintendo Co., Ltd.",
	[3]byte{0, 36, 69}:     "CommScope Canada Inc.",
	[3]byte{0, 36, 70}:     "MMB Research Inc.",
	[3]byte{0, 36, 71}:     "Kaztek Systems",
	[3]byte{0, 36, 72}:     "SpiderCloud Wireless, Inc",
	[3]byte{0, 36, 73}:     "Shen Zhen Lite Star Electronics Technology Co., Ltd",
	[3]byte{0, 36, 74}:     "Voyant International",
	[3]byte{0, 36, 75}:     "PERCEPTRON INC",
	[3]byte{0, 36, 76}:     "Solartron Metrology Ltd",
	[3]byte{0, 36, 77}:     "Hokkaido Electronics Corporation",
	[3]byte{0, 36, 78}:     "RadChips, Inc.",
	[3]byte{0, 36, 79}:     "Asantron Technologies Ltd.",
	[3]byte{0, 36, 80}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 36, 81}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 36, 82}:     "Silicon Software GmbH",
	[3]byte{0, 36, 83}:     "Initra d.o.o.",
	[3]byte{0, 36, 84}:     "Samsung Electronics CO., LTD",
	[3]byte{0, 36, 85}:     "MuLogic BV",
	[3]byte{0, 36, 86}:     "2Wire",
	[3]byte{0, 36, 88}:     "PA Bastion CC",
	[3]byte{0, 36, 89}:     "ABB STOTZ-KONTAKT GmbH",
	[3]byte{0, 36, 90}:     "Nanjing Panda Electronics Company Limited",
	[3]byte{0, 36, 91}:     "RAIDON TECHNOLOGY, INC.",
	[3]byte{0, 36, 92}:     "Design-Com Technologies Pty. Ltd.",
	[3]byte{0, 36, 93}:     "Terberg besturingstechniek B.V.",
	[3]byte{0, 36, 94}:     "Hivision Co.,ltd",
	[3]byte{0, 36, 95}:     "Vine Telecom CO.,Ltd.",
	[3]byte{0, 36, 96}:     "Giaval Science Development Co. Ltd.",
	[3]byte{0, 36, 97}:     "Shin Wang Tech.",
	[3]byte{0, 36, 98}:     "Rayzone Corporation",
	[3]byte{0, 36, 99}:     "Phybridge Inc",
	[3]byte{0, 36, 100}:    "Bridge Technologies Co AS",
	[3]byte{0, 36, 101}:    "Elentec",
	[3]byte{0, 36, 102}:    "Unitron nv",
	[3]byte{0, 36, 103}:    "AOC International (Europe) GmbH",
	[3]byte{0, 36, 104}:    "Sumavision Technologies Co.,Ltd",
	[3]byte{0, 36, 105}:    "Smart Doorphones",
	[3]byte{0, 36, 106}:    "Solid Year Co., Ltd.",
	[3]byte{0, 36, 107}:    "Covia, Inc.",
	[3]byte{0, 36, 108}:    "ARUBA NETWORKS, INC.",
	[3]byte{0, 36, 109}:    "Weinzierl Engineering GmbH",
	[3]byte{0, 36, 110}:    "Phihong USA Corp.",
	[3]byte{0, 36, 111}:    "Onda Communication spa",
	[3]byte{0, 36, 112}:    "AUROTECH ultrasound AS.",
	[3]byte{0, 36, 113}:    "Fusion MultiSystems dba Fusion-io",
	[3]byte{0, 36, 114}:    "ReDriven Power Inc.",
	[3]byte{0, 36, 115}:    "3Com Europe Ltd",
	[3]byte{0, 36, 116}:    "Autronica Fire And Securirty",
	[3]byte{0, 36, 117}:    "Compass System(Embedded Dept.)",
	[3]byte{0, 36, 118}:    "TAP.tv",
	[3]byte{0, 36, 119}:    "Tibbo Technology",
	[3]byte{0, 36, 120}:    "Mag Tech Electronics Co Limited",
	[3]byte{0, 36, 121}:    "Optec Displays, Inc.",
	[3]byte{0, 36, 122}:    "FU YI CHENG Technology Co., Ltd.",
	[3]byte{0, 36, 123}:    "Actiontec Electronics, Inc",
	[3]byte{0, 36, 124}:    "Nokia Danmark A/S",
	[3]byte{0, 36, 125}:    "Nokia Danmark A/S",
	[3]byte{0, 36, 126}:    "Universal Global Scientific Industrial Co., Ltd",
	[3]byte{0, 36, 127}:    "Nortel Networks",
	[3]byte{0, 36, 128}:    "Meteocontrol GmbH",
	[3]byte{0, 36, 129}:    "Hewlett-Packard Company",
	[3]byte{0, 36, 130}:    "Ruckus Wireless",
	[3]byte{0, 36, 131}:    "LG Electronics",
	[3]byte{0, 36, 132}:    "Bang and Olufsen Medicom a/s",
	[3]byte{0, 36, 133}:    "ConteXtream Ltd",
	[3]byte{0, 36, 134}:    "DesignArt Networks",
	[3]byte{0, 36, 135}:    "Blackboard Inc.",
	[3]byte{0, 36, 136}:    "Centre For Development Of Telematics",
	[3]byte{0, 36, 137}:    "Vodafone Omnitel N.V.",
	[3]byte{0, 36, 138}:    "Kaga Electronics Co., Ltd.",
	[3]byte{0, 36, 139}:    "HYBUS CO., LTD.",
	[3]byte{0, 36, 140}:    "ASUSTek COMPUTER INC.",
	[3]byte{0, 36, 141}:    "Sony Computer Entertainment Inc.",
	[3]byte{0, 36, 142}:    "Infoware ZRt.",
	[3]byte{0, 36, 143}:    "DO-MONIX",
	[3]byte{0, 36, 144}:    "Samsung Electronics Co.,LTD",
	[3]byte{0, 36, 145}:    "Samsung Electronics",
	[3]byte{0, 36, 146}:    "Motorola, Broadband Solutions Group",
	[3]byte{0, 36, 147}:    "ARRIS Group, Inc.",
	[3]byte{0, 36, 148}:    "Shenzhen Baoxin Tech CO., Ltd.",
	[3]byte{0, 36, 149}:    "ARRIS Group, Inc.",
	[3]byte{0, 36, 150}:    "Ginzinger electronic systems",
	[3]byte{0, 36, 151}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 36, 152}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 36, 153}:    "Aquila Technologies",
	[3]byte{0, 36, 154}:    "Beijing Zhongchuang Telecommunication Test Co., Ltd.",
	[3]byte{0, 36, 155}:    "Action Star Enterprise Co., Ltd.",
	[3]byte{0, 36, 156}:    "Bimeng Comunication System Co. Ltd",
	[3]byte{0, 36, 157}:    "NES Technology Inc.",
	[3]byte{0, 36, 158}:    "ADC-Elektronik GmbH",
	[3]byte{0, 36, 159}:    "RIM Testing Services",
	[3]byte{0, 36, 160}:    "ARRIS Group, Inc.",
	[3]byte{0, 36, 161}:    "ARRIS Group, Inc.",
	[3]byte{0, 36, 162}:    "Hong Kong Middleware Technology Limited",
	[3]byte{0, 36, 163}:    "Sonim Technologies Inc",
	[3]byte{0, 36, 164}:    "Siklu Communication",
	[3]byte{0, 36, 165}:    "Buffalo Inc.",
	[3]byte{0, 36, 166}:    "TELESTAR DIGITAL GmbH",
	[3]byte{0, 36, 167}:    "Advanced Video Communications Inc.",
	[3]byte{0, 36, 168}:    "ProCurve Networking by HP",
	[3]byte{0, 36, 169}:    "Ag Leader Technology",
	[3]byte{0, 36, 170}:    "Dycor Technologies Ltd.",
	[3]byte{0, 36, 171}:    "A7 Engineering, Inc.",
	[3]byte{0, 36, 172}:    "Hangzhou DPtech Technologies Co., Ltd.",
	[3]byte{0, 36, 173}:    "Adolf Thies Gmbh & Co. KG",
	[3]byte{0, 36, 174}:    "Morpho",
	[3]byte{0, 36, 175}:    "EchoStar Technologies",
	[3]byte{0, 36, 176}:    "ESAB AB",
	[3]byte{0, 36, 177}:    "Coulomb Technologies",
	[3]byte{0, 36, 178}:    "Netgear",
	[3]byte{0, 36, 179}:    "Graf-Syteco GmbH & Co. KG",
	[3]byte{0, 36, 180}:    "ESCATRONIC GmbH",
	[3]byte{0, 36, 181}:    "Nortel Networks",
	[3]byte{0, 36, 182}:    "Seagate Technology",
	[3]byte{0, 36, 183}:    "GridPoint, Inc.",
	[3]byte{0, 36, 184}:    "free alliance sdn bhd",
	[3]byte{0, 36, 185}:    "Wuhan Higheasy Electronic Technology Development Co.Ltd",
	[3]byte{0, 36, 186}:    "Texas Instruments",
	[3]byte{0, 36, 187}:    "CENTRAL Corporation",
	[3]byte{0, 36, 188}:    "HuRob Co.,Ltd",
	[3]byte{0, 36, 189}:    "Hainzl Industriesysteme GmbH",
	[3]byte{0, 36, 190}:    "Sony Corporation",
	[3]byte{0, 36, 191}:    "CIAT",
	[3]byte{0, 36, 192}:    "NTI COMODO INC",
	[3]byte{0, 36, 193}:    "ARRIS Group, Inc.",
	[3]byte{0, 36, 194}:    "Asumo Co.,Ltd.",
	[3]byte{0, 36, 195}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 36, 196}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 36, 197}:    "Meridian Audio Limited",
	[3]byte{0, 36, 198}:    "Hager Electro SAS",
	[3]byte{0, 36, 199}:    "Mobilarm Ltd",
	[3]byte{0, 36, 200}:    "Broadband Solutions Group",
	[3]byte{0, 36, 201}:    "Broadband Solutions Group",
	[3]byte{0, 36, 202}:    "Tobii Technology AB",
	[3]byte{0, 36, 203}:    "Autonet Mobile",
	[3]byte{0, 36, 204}:    "Fascinations Toys and Gifts, Inc.",
	[3]byte{0, 36, 205}:    "Willow Garage, Inc.",
	[3]byte{0, 36, 206}:    "Exeltech Inc",
	[3]byte{0, 36, 207}:    "Inscape Data Corporation",
	[3]byte{0, 36, 208}:    "Shenzhen SOGOOD Industry CO.,LTD.",
	[3]byte{0, 36, 209}:    "Thomson Inc.",
	[3]byte{0, 36, 210}:    "Askey Computer",
	[3]byte{0, 36, 211}:    "QUALICA Inc.",
	[3]byte{0, 36, 212}:    "FREEBOX SA",
	[3]byte{0, 36, 213}:    "Winward Industrial Limited",
	[3]byte{0, 36, 214}:    "Intel Corporate",
	[3]byte{0, 36, 215}:    "Intel Corporate",
	[3]byte{0, 36, 216}:    "IlSung Precision",
	[3]byte{0, 36, 217}:    "BICOM, Inc.",
	[3]byte{0, 36, 218}:    "Innovar Systems Limited",
	[3]byte{0, 36, 219}:    "Alcohol Monitoring Systems",
	[3]byte{0, 36, 220}:    "Juniper Networks",
	[3]byte{0, 36, 221}:    "Centrak, Inc.",
	[3]byte{0, 36, 222}:    "GLOBAL Technology Inc.",
	[3]byte{0, 36, 223}:    "Digitalbox Europe GmbH",
	[3]byte{0, 36, 224}:    "DS Tech, LLC",
	[3]byte{0, 36, 225}:    "Convey Computer Corp.",
	[3]byte{0, 36, 226}:    "HASEGAWA ELECTRIC CO.,LTD.",
	[3]byte{0, 36, 227}:    "CAO Group",
	[3]byte{0, 36, 228}:    "Withings",
	[3]byte{0, 36, 229}:    "Seer Technology, Inc",
	[3]byte{0, 36, 230}:    "In Motion Technology Inc.",
	[3]byte{0, 36, 231}:    "Plaster Networks",
	[3]byte{0, 36, 232}:    "Dell Inc.",
	[3]byte{0, 36, 233}:    "Samsung Electronics Co., Ltd., Storage System Division",
	[3]byte{0, 36, 234}:    "iris-GmbH infrared & intelligent sensors",
	[3]byte{0, 36, 235}:    "ClearPath Networks, Inc.",
	[3]byte{0, 36, 236}:    "United Information Technology Co.,Ltd.",
	[3]byte{0, 36, 237}:    "YT Elec. Co,.Ltd.",
	[3]byte{0, 36, 238}:    "Wynmax Inc.",
	[3]byte{0, 36, 239}:    "Sony Ericsson Mobile Communications",
	[3]byte{0, 36, 240}:    "Seanodes",
	[3]byte{0, 36, 241}:    "Shenzhen Fanhai Sanjiang Electronics Co., Ltd.",
	[3]byte{0, 36, 242}:    "Uniphone Telecommunication Co., Ltd.",
	[3]byte{0, 36, 243}:    "Nintendo Co., Ltd.",
	[3]byte{0, 36, 244}:    "Kaminario Technologies Ltd.",
	[3]byte{0, 36, 245}:    "NDS Surgical Imaging",
	[3]byte{0, 36, 246}:    "MIYOSHI ELECTRONICS CORPORATION",
	[3]byte{0, 36, 247}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 36, 248}:    "Technical Solutions Company Ltd.",
	[3]byte{0, 36, 249}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 36, 250}:    "Hilger u. Kern GMBH",
	[3]byte{0, 36, 251}:    "PRIVATE",
	[3]byte{0, 36, 252}:    "QuoPin Co., Ltd.",
	[3]byte{0, 36, 253}:    "Accedian Networks Inc",
	[3]byte{0, 36, 254}:    "AVM GmbH",
	[3]byte{0, 36, 255}:    "QLogic Corporation",
	[3]byte{0, 37, 0}:      "Apple",
	[3]byte{0, 37, 1}:      "JSC \"Supertel\"",
	[3]byte{0, 37, 2}:      "NaturalPoint",
	[3]byte{0, 37, 3}:      "IBM Corp",
	[3]byte{0, 37, 4}:      "Valiant Communications Limited",
	[3]byte{0, 37, 5}:      "eks Engel GmbH & Co. KG",
	[3]byte{0, 37, 6}:      "A.I. ANTITACCHEGGIO ITALIA SRL",
	[3]byte{0, 37, 7}:      "ASTAK Inc.",
	[3]byte{0, 37, 8}:      "Maquet Cardiopulmonary AG",
	[3]byte{0, 37, 9}:      "SHARETRONIC Group LTD",
	[3]byte{0, 37, 10}:     "Security Expert Co. Ltd",
	[3]byte{0, 37, 11}:     "CENTROFACTOR  INC",
	[3]byte{0, 37, 12}:     "Enertrac",
	[3]byte{0, 37, 13}:     "GZT Telkom-Telmor sp. z o.o.",
	[3]byte{0, 37, 14}:     "gt german telematics gmbh",
	[3]byte{0, 37, 15}:     "On-Ramp Wireless, Inc.",
	[3]byte{0, 37, 16}:     "Pico-Tesla Magnetic Therapies",
	[3]byte{0, 37, 17}:     "ELITEGROUP COMPUTER SYSTEM CO., LTD.",
	[3]byte{0, 37, 18}:     "ZTE Corporation",
	[3]byte{0, 37, 19}:     "CXP DIGITAL BV",
	[3]byte{0, 37, 20}:     "PC Worth Int'l Co., Ltd.",
	[3]byte{0, 37, 21}:     "SFR",
	[3]byte{0, 37, 22}:     "Integrated Design Tools, Inc.",
	[3]byte{0, 37, 23}:     "Venntis, LLC",
	[3]byte{0, 37, 24}:     "Power PLUS Communications AG",
	[3]byte{0, 37, 25}:     "Viaas Inc",
	[3]byte{0, 37, 26}:     "Psiber Data Systems Inc.",
	[3]byte{0, 37, 27}:     "Philips CareServant",
	[3]byte{0, 37, 28}:     "EDT",
	[3]byte{0, 37, 29}:     "DSA Encore, LLC",
	[3]byte{0, 37, 30}:     "ROTEL TECHNOLOGIES",
	[3]byte{0, 37, 31}:     "ZYNUS VISION INC.",
	[3]byte{0, 37, 32}:     "SMA Railway Technology GmbH",
	[3]byte{0, 37, 33}:     "Logitek Electronic Systems, Inc.",
	[3]byte{0, 37, 34}:     "ASRock Incorporation",
	[3]byte{0, 37, 35}:     "OCP Inc.",
	[3]byte{0, 37, 36}:     "Lightcomm Technology Co., Ltd",
	[3]byte{0, 37, 37}:     "CTERA Networks Ltd.",
	[3]byte{0, 37, 38}:     "Genuine Technologies Co., Ltd.",
	[3]byte{0, 37, 39}:     "Bitrode Corp.",
	[3]byte{0, 37, 40}:     "Daido Signal Co., Ltd.",
	[3]byte{0, 37, 41}:     "COMELIT GROUP S.P.A",
	[3]byte{0, 37, 42}:     "Chengdu GeeYa Technology Co.,LTD",
	[3]byte{0, 37, 43}:     "Stirling Energy Systems",
	[3]byte{0, 37, 44}:     "Entourage Systems, Inc.",
	[3]byte{0, 37, 45}:     "Kiryung Electronics",
	[3]byte{0, 37, 46}:     "Cisco SPVTG",
	[3]byte{0, 37, 47}:     "Energy, Inc.",
	[3]byte{0, 37, 48}:     "Aetas Systems Inc.",
	[3]byte{0, 37, 49}:     "Cloud Engines, Inc.",
	[3]byte{0, 37, 50}:     "Digital Recorders",
	[3]byte{0, 37, 51}:     "WITTENSTEIN AG",
	[3]byte{0, 37, 53}:     "Minimax GmbH & Co KG",
	[3]byte{0, 37, 54}:     "Oki Electric Industry Co., Ltd.",
	[3]byte{0, 37, 55}:     "Runcom Technologies Ltd.",
	[3]byte{0, 37, 56}:     "Samsung Electronics Co., Ltd., Memory Division",
	[3]byte{0, 37, 57}:     "IfTA GmbH",
	[3]byte{0, 37, 58}:     "CEVA, Ltd.",
	[3]byte{0, 37, 59}:     "din Dietmar Nocker Facilitymanagement GmbH",
	[3]byte{0, 37, 60}:     "2Wire",
	[3]byte{0, 37, 61}:     "DRS Consolidated Controls",
	[3]byte{0, 37, 62}:     "Sensus Metering Systems",
	[3]byte{0, 37, 64}:     "Quasar Technologies, Inc.",
	[3]byte{0, 37, 65}:     "Maquet Critical Care AB",
	[3]byte{0, 37, 66}:     "Pittasoft",
	[3]byte{0, 37, 67}:     "MONEYTECH",
	[3]byte{0, 37, 68}:     "LoJack Corporation",
	[3]byte{0, 37, 69}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 37, 70}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 37, 71}:     "Nokia Danmark A/S",
	[3]byte{0, 37, 72}:     "Nokia Danmark A/S",
	[3]byte{0, 37, 73}:     "Jeorich Tech. Co.,Ltd.",
	[3]byte{0, 37, 74}:     "RingCube Technologies, Inc.",
	[3]byte{0, 37, 75}:     "Apple",
	[3]byte{0, 37, 76}:     "Videon Central, Inc.",
	[3]byte{0, 37, 77}:     "Singapore Technologies Electronics Limited",
	[3]byte{0, 37, 78}:     "Vertex Wireless Co., Ltd.",
	[3]byte{0, 37, 79}:     "ELETTROLAB Srl",
	[3]byte{0, 37, 80}:     "Riverbed Technology",
	[3]byte{0, 37, 81}:     "SE-Elektronic GmbH",
	[3]byte{0, 37, 82}:     "VXI CORPORATION",
	[3]byte{0, 37, 83}:     "Pirelli Tyre S.p.A.",
	[3]byte{0, 37, 84}:     "Pixel8 Networks",
	[3]byte{0, 37, 85}:     "Visonic Technologies 1993 Ltd",
	[3]byte{0, 37, 86}:     "Hon Hai Precision Ind. Co., Ltd.",
	[3]byte{0, 37, 87}:     "Research In Motion",
	[3]byte{0, 37, 88}:     "MPEDIA",
	[3]byte{0, 37, 89}:     "Syphan Technologies Ltd",
	[3]byte{0, 37, 90}:     "Tantalus Systems Corp.",
	[3]byte{0, 37, 91}:     "CoachComm, LLC",
	[3]byte{0, 37, 92}:     "NEC Corporation",
	[3]byte{0, 37, 93}:     "Morningstar Corporation",
	[3]byte{0, 37, 94}:     "Shanghai Dare Technologies Co.,Ltd.",
	[3]byte{0, 37, 95}:     "SenTec AG",
	[3]byte{0, 37, 96}:     "Ibridge Networks & Communications Ltd.",
	[3]byte{0, 37, 97}:     "ProCurve Networking by HP",
	[3]byte{0, 37, 98}:     "interbro Co. Ltd.",
	[3]byte{0, 37, 99}:     "Luxtera Inc",
	[3]byte{0, 37, 100}:    "Dell Inc.",
	[3]byte{0, 37, 101}:    "Vizimax Inc.",
	[3]byte{0, 37, 102}:    "Samsung Electronics Co.,Ltd",
	[3]byte{0, 37, 103}:    "Samsung Electronics",
	[3]byte{0, 37, 104}:    "Shenzhen Huawei Communication Technologies Co., Ltd",
	[3]byte{0, 37, 105}:    "SAGEM COMMUNICATION",
	[3]byte{0, 37, 106}:    "inIT - Institut Industrial IT",
	[3]byte{0, 37, 107}:    "ATENIX E.E. s.r.l.",
	[3]byte{0, 37, 108}:    "\"Azimut\" Production Association JSC",
	[3]byte{0, 37, 109}:    "Broadband Forum",
	[3]byte{0, 37, 110}:    "Van Breda B.V.",
	[3]byte{0, 37, 111}:    "Dantherm Power",
	[3]byte{0, 37, 112}:    "Eastern Communications Company Limited",
	[3]byte{0, 37, 113}:    "Zhejiang Tianle Digital Electric Co.,Ltd",
	[3]byte{0, 37, 114}:    "Nemo-Q International AB",
	[3]byte{0, 37, 115}:    "ST Electronics (Info-Security) Pte Ltd",
	[3]byte{0, 37, 116}:    "KUNIMI MEDIA DEVICE Co., Ltd.",
	[3]byte{0, 37, 117}:    "FiberPlex Technologies, LLC",
	[3]byte{0, 37, 118}:    "NELI TECHNOLOGIES",
	[3]byte{0, 37, 119}:    "D-BOX Technologies",
	[3]byte{0, 37, 120}:    "JSC \"Concern \"Sozvezdie\"",
	[3]byte{0, 37, 121}:    "J & F Labs",
	[3]byte{0, 37, 122}:    "CAMCO Produktions- und Vertriebs-GmbH für  Beschallungs- und Beleuchtungsanlagen",
	[3]byte{0, 37, 123}:    "STJ  ELECTRONICS  PVT  LTD",
	[3]byte{0, 37, 124}:    "Huachentel Technology Development Co., Ltd",
	[3]byte{0, 37, 125}:    "PointRed Telecom Private Ltd.",
	[3]byte{0, 37, 126}:    "NEW POS Technology Limited",
	[3]byte{0, 37, 127}:    "CallTechSolution Co.,Ltd",
	[3]byte{0, 37, 128}:    "Equipson S.A.",
	[3]byte{0, 37, 129}:    "x-star networks Inc.",
	[3]byte{0, 37, 130}:    "Maksat Technologies (P) Ltd",
	[3]byte{0, 37, 131}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 37, 132}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 37, 133}:    "KOKUYO S&T Co., Ltd.",
	[3]byte{0, 37, 134}:    "TP-LINK Technologies Co., Ltd.",
	[3]byte{0, 37, 135}:    "Vitality, Inc.",
	[3]byte{0, 37, 136}:    "Genie Industries, Inc.",
	[3]byte{0, 37, 137}:    "Hills Industries Limited",
	[3]byte{0, 37, 138}:    "Pole/Zero Corporation",
	[3]byte{0, 37, 139}:    "Mellanox Technologies Ltd",
	[3]byte{0, 37, 140}:    "ESUS ELEKTRONIK SAN. VE DIS. TIC. LTD. STI.",
	[3]byte{0, 37, 141}:    "Haier",
	[3]byte{0, 37, 142}:    "The Weather Channel",
	[3]byte{0, 37, 143}:    "Trident Microsystems, Inc.",
	[3]byte{0, 37, 144}:    "Super Micro Computer, Inc.",
	[3]byte{0, 37, 145}:    "NEXTEK, Inc.",
	[3]byte{0, 37, 146}:    "Guangzhou Shirui Electronic Co., Ltd",
	[3]byte{0, 37, 147}:    "DatNet Informatikai Kft.",
	[3]byte{0, 37, 148}:    "Eurodesign BG LTD",
	[3]byte{0, 37, 149}:    "Northwest Signal Supply, Inc",
	[3]byte{0, 37, 150}:    "GIGAVISION srl",
	[3]byte{0, 37, 151}:    "Kalki Communication Technologies",
	[3]byte{0, 37, 152}:    "Zhong Shan City Litai Electronic Industrial Co. Ltd",
	[3]byte{0, 37, 153}:    "Hedon e.d. B.V.",
	[3]byte{0, 37, 154}:    "CEStronics GmbH",
	[3]byte{0, 37, 155}:    "Beijing PKUNITY Microsystems Technology Co., Ltd",
	[3]byte{0, 37, 156}:    "Cisco-Linksys, LLC",
	[3]byte{0, 37, 157}:    "PRIVATE",
	[3]byte{0, 37, 158}:    "Huawei Technologies Co., Ltd.",
	[3]byte{0, 37, 159}:    "TechnoDigital Technologies GmbH",
	[3]byte{0, 37, 160}:    "Nintendo Co., Ltd.",
	[3]byte{0, 37, 161}:    "Enalasys",
	[3]byte{0, 37, 162}:    "Alta Definicion LINCEO S.L.",
	[3]byte{0, 37, 163}:    "Trimax Wireless, Inc.",
	[3]byte{0, 37, 164}:    "EuroDesign embedded technologies GmbH",
	[3]byte{0, 37, 165}:    "Walnut Media Network",
	[3]byte{0, 37, 166}:    "Central Network Solution Co., Ltd.",
	[3]byte{0, 37, 167}:    "Comverge, Inc.",
	[3]byte{0, 37, 168}:    "Kontron (BeiJing) Technology Co.,Ltd",
	[3]byte{0, 37, 169}:    "Shanghai Embedway Information Technologies Co.,Ltd",
	[3]byte{0, 37, 170}:    "Beijing Soul Technology Co.,Ltd.",
	[3]byte{0, 37, 171}:    "AIO LCD PC BU / TPV",
	[3]byte{0, 37, 172}:    "I-Tech corporation",
	[3]byte{0, 37, 173}:    "Manufacturing Resources International",
	[3]byte{0, 37, 174}:    "Microsoft Corporation",
	[3]byte{0, 37, 175}:    "COMFILE Technology",
	[3]byte{0, 37, 176}:    "Schmartz Inc",
	[3]byte{0, 37, 177}:    "Maya-Creation Corporation",
	[3]byte{0, 37, 178}:    "MBDA Deutschland GmbH",
	[3]byte{0, 37, 179}:    "Hewlett-Packard Company",
	[3]byte{0, 37, 180}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 37, 181}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 37, 182}:    "Telecom FM",
	[3]byte{0, 37, 183}:    "Costar  electronics, inc.,",
	[3]byte{0, 37, 184}:    "Agile Communications, Inc.",
	[3]byte{0, 37, 185}:    "Cypress Solutions Inc",
	[3]byte{0, 37, 186}:    "Alcatel-Lucent IPD",
	[3]byte{0, 37, 187}:    "INNERINT Co., Ltd.",
	[3]byte{0, 37, 188}:    "Apple",
	[3]byte{0, 37, 189}:    "Italdata Ingegneria dell'Idea S.p.A.",
	[3]byte{0, 37, 190}:    "Tektrap Systems Inc.",
	[3]byte{0, 37, 191}:    "Wireless Cables Inc.",
	[3]byte{0, 37, 192}:    "ZillionTV Corporation",
	[3]byte{0, 37, 193}:    "Nawoo Korea Corp.",
	[3]byte{0, 37, 194}:    "RingBell Co.,Ltd.",
	[3]byte{0, 37, 195}:    "Nortel Networks",
	[3]byte{0, 37, 196}:    "Ruckus Wireless",
	[3]byte{0, 37, 197}:    "Star Link Communication Pvt. Ltd.",
	[3]byte{0, 37, 198}:    "kasercorp, ltd",
	[3]byte{0, 37, 199}:    "altek Corporation",
	[3]byte{0, 37, 200}:    "S-Access GmbH",
	[3]byte{0, 37, 201}:    "SHENZHEN HUAPU DIGITAL CO., LTD",
	[3]byte{0, 37, 202}:    "LS Research, LLC",
	[3]byte{0, 37, 203}:    "Reiner SCT",
	[3]byte{0, 37, 204}:    "Mobile Communications Korea Incorporated",
	[3]byte{0, 37, 205}:    "Skylane Optics",
	[3]byte{0, 37, 206}:    "InnerSpace",
	[3]byte{0, 37, 207}:    "Nokia Danmark A/S",
	[3]byte{0, 37, 208}:    "Nokia Danmark A/S",
	[3]byte{0, 37, 209}:    "Eastern Asia Technology Limited",
	[3]byte{0, 37, 210}:    "InpegVision Co., Ltd",
	[3]byte{0, 37, 211}:    "AzureWave Technologies, Inc",
	[3]byte{0, 37, 212}:    "Fortress Technologies",
	[3]byte{0, 37, 213}:    "Robonica (Pty) Ltd",
	[3]byte{0, 37, 214}:    "The Kroger Co.",
	[3]byte{0, 37, 215}:    "CEDO",
	[3]byte{0, 37, 216}:    "KOREA MAINTENANCE",
	[3]byte{0, 37, 217}:    "DataFab Systems Inc.",
	[3]byte{0, 37, 218}:    "Secura Key",
	[3]byte{0, 37, 219}:    "ATI Electronics(Shenzhen) Co., LTD",
	[3]byte{0, 37, 220}:    "Sumitomo Electric Networks, Inc",
	[3]byte{0, 37, 221}:    "SUNNYTEK INFORMATION CO., LTD.",
	[3]byte{0, 37, 222}:    "Probits Co., LTD.",
	[3]byte{0, 37, 223}:    "PRIVATE",
	[3]byte{0, 37, 224}:    "CeedTec Sdn Bhd",
	[3]byte{0, 37, 225}:    "SHANGHAI SEEYOO ELECTRONIC & TECHNOLOGY CO., LTD",
	[3]byte{0, 37, 226}:    "Everspring Industry Co., Ltd.",
	[3]byte{0, 37, 227}:    "Hanshinit Inc.",
	[3]byte{0, 37, 228}:    "OMNI-WiFi, LLC",
	[3]byte{0, 37, 229}:    "LG Electronics Inc",
	[3]byte{0, 37, 230}:    "Belgian Monitoring Systems bvba",
	[3]byte{0, 37, 231}:    "Sony Ericsson Mobile Communications",
	[3]byte{0, 37, 232}:    "Idaho Technology",
	[3]byte{0, 37, 233}:    "i-mate Development, Inc.",
	[3]byte{0, 37, 234}:    "Iphion BV",
	[3]byte{0, 37, 235}:    "Reutech Radar Systems (PTY) Ltd",
	[3]byte{0, 37, 236}:    "Humanware",
	[3]byte{0, 37, 237}:    "NuVo Technologies LLC",
	[3]byte{0, 37, 238}:    "Avtex Ltd",
	[3]byte{0, 37, 239}:    "I-TEC Co., Ltd.",
	[3]byte{0, 37, 240}:    "Suga Electronics Limited",
	[3]byte{0, 37, 241}:    "ARRIS Group, Inc.",
	[3]byte{0, 37, 242}:    "ARRIS Group, Inc.",
	[3]byte{0, 37, 243}:    "Nordwestdeutsche Zählerrevision",
	[3]byte{0, 37, 244}:    "KoCo Connector AG",
	[3]byte{0, 37, 245}:    "DVS Korea, Co., Ltd",
	[3]byte{0, 37, 246}:    "netTALK.com, Inc.",
	[3]byte{0, 37, 247}:    "Ansaldo STS USA",
	[3]byte{0, 37, 249}:    "GMK electronic design GmbH",
	[3]byte{0, 37, 250}:    "J&M Analytik AG",
	[3]byte{0, 37, 251}:    "Tunstall Healthcare A/S",
	[3]byte{0, 37, 252}:    "ENDA ENDUSTRIYEL ELEKTRONIK LTD. STI.",
	[3]byte{0, 37, 253}:    "OBR Centrum Techniki Morskiej S.A.",
	[3]byte{0, 37, 254}:    "Pilot Electronics Corporation",
	[3]byte{0, 37, 255}:    "CreNova Multimedia Co., Ltd",
	[3]byte{0, 38, 0}:      "TEAC Australia Pty Ltd.",
	[3]byte{0, 38, 1}:      "Cutera Inc",
	[3]byte{0, 38, 2}:      "SMART Temps LLC",
	[3]byte{0, 38, 3}:      "Shenzhen Wistar Technology Co., Ltd",
	[3]byte{0, 38, 4}:      "Audio Processing Technology Ltd",
	[3]byte{0, 38, 5}:      "CC Systems AB",
	[3]byte{0, 38, 6}:      "RAUMFELD GmbH",
	[3]byte{0, 38, 7}:      "Enabling Technology Pty Ltd",
	[3]byte{0, 38, 8}:      "Apple",
	[3]byte{0, 38, 9}:      "Phyllis Co., Ltd.",
	[3]byte{0, 38, 10}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 38, 11}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 38, 12}:     "Dataram",
	[3]byte{0, 38, 13}:     "Mercury Systems, Inc.",
	[3]byte{0, 38, 14}:     "Ablaze Systems, LLC",
	[3]byte{0, 38, 15}:     "Linn Products Ltd",
	[3]byte{0, 38, 16}:     "Apacewave Technologies",
	[3]byte{0, 38, 17}:     "Licera AB",
	[3]byte{0, 38, 18}:     "Space Exploration Technologies",
	[3]byte{0, 38, 19}:     "Engel Axil S.L.",
	[3]byte{0, 38, 20}:     "KTNF",
	[3]byte{0, 38, 21}:     "Teracom Limited",
	[3]byte{0, 38, 22}:     "Rosemount Inc.",
	[3]byte{0, 38, 23}:     "OEM Worldwide",
	[3]byte{0, 38, 24}:     "ASUSTek COMPUTER INC.",
	[3]byte{0, 38, 25}:     "FRC",
	[3]byte{0, 38, 26}:     "Femtocomm System Technology Corp.",
	[3]byte{0, 38, 27}:     "LAUREL BANK MACHINES CO., LTD.",
	[3]byte{0, 38, 28}:     "NEOVIA INC.",
	[3]byte{0, 38, 29}:     "COP SECURITY SYSTEM CORP.",
	[3]byte{0, 38, 30}:     "QINGBANG ELEC(SZ) CO., LTD",
	[3]byte{0, 38, 31}:     "SAE Magnetics (H.K.) Ltd.",
	[3]byte{0, 38, 32}:     "ISGUS GmbH",
	[3]byte{0, 38, 33}:     "InteliCloud Technology Inc.",
	[3]byte{0, 38, 34}:     "COMPAL INFORMATION (KUNSHAN) CO., LTD.",
	[3]byte{0, 38, 35}:     "JRD Communication Inc",
	[3]byte{0, 38, 36}:     "Thomson Inc.",
	[3]byte{0, 38, 37}:     "MediaSputnik",
	[3]byte{0, 38, 38}:     "Geophysical Survey Systems, Inc.",
	[3]byte{0, 38, 39}:     "Truesell",
	[3]byte{0, 38, 40}:     "companytec automação e controle ltda.",
	[3]byte{0, 38, 41}:     "Juphoon System Software Inc.",
	[3]byte{0, 38, 42}:     "Proxense, LLC",
	[3]byte{0, 38, 43}:     "Wongs Electronics Co. Ltd.",
	[3]byte{0, 38, 44}:     "IKT Advanced Technologies s.r.o.",
	[3]byte{0, 38, 45}:     "Wistron Corporation",
	[3]byte{0, 38, 46}:     "Chengdu Jiuzhou Electronic Technology Inc",
	[3]byte{0, 38, 47}:     "HAMAMATSU TOA ELECTRONICS",
	[3]byte{0, 38, 48}:     "ACOREL S.A.S",
	[3]byte{0, 38, 49}:     "COMMTACT LTD",
	[3]byte{0, 38, 50}:     "Instrumentation Technologies d.d.",
	[3]byte{0, 38, 51}:     "MIR - Medical International Research",
	[3]byte{0, 38, 52}:     "Infineta Systems, Inc",
	[3]byte{0, 38, 53}:     "Bluetechnix GmbH",
	[3]byte{0, 38, 54}:     "ARRIS Group, Inc.",
	[3]byte{0, 38, 55}:     "Samsung Electro-Mechanics",
	[3]byte{0, 38, 56}:     "Xia Men Joyatech Co., Ltd.",
	[3]byte{0, 38, 57}:     "T.M. Electronics, Inc.",
	[3]byte{0, 38, 58}:     "Digitec Systems",
	[3]byte{0, 38, 59}:     "Onbnetech",
	[3]byte{0, 38, 60}:     "Bachmann Technology GmbH & Co. KG",
	[3]byte{0, 38, 61}:     "MIA Corporation",
	[3]byte{0, 38, 62}:     "Trapeze Networks",
	[3]byte{0, 38, 63}:     "LIOS Technology GmbH",
	[3]byte{0, 38, 64}:     "Baustem Broadband Technologies, Ltd.",
	[3]byte{0, 38, 65}:     "ARRIS Group, Inc.",
	[3]byte{0, 38, 66}:     "ARRIS Group, Inc.",
	[3]byte{0, 38, 67}:     "Alps Electric Co., Ltd",
	[3]byte{0, 38, 68}:     "Thomson Telecom Belgium",
	[3]byte{0, 38, 69}:     "Circontrol S.A.",
	[3]byte{0, 38, 70}:     "SHENYANG TONGFANG MULTIMEDIA TECHNOLOGY COMPANY LIMITED",
	[3]byte{0, 38, 71}:     "WFE TECHNOLOGY CORP.",
	[3]byte{0, 38, 72}:     "Emitech Corp.",
	[3]byte{0, 38, 74}:     "Apple",
	[3]byte{0, 38, 76}:     "Shanghai DigiVision Technology Co., Ltd.",
	[3]byte{0, 38, 77}:     "Arcadyan Technology Corporation",
	[3]byte{0, 38, 78}:     "Rail & Road Protec GmbH",
	[3]byte{0, 38, 79}:     "Krüger &Gothe GmbH",
	[3]byte{0, 38, 80}:     "2Wire",
	[3]byte{0, 38, 81}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 38, 82}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 38, 83}:     "DaySequerra Corporation",
	[3]byte{0, 38, 84}:     "3Com Corporation",
	[3]byte{0, 38, 85}:     "Hewlett-Packard Company",
	[3]byte{0, 38, 86}:     "Sansonic Electronics USA",
	[3]byte{0, 38, 87}:     "OOO NPP EKRA",
	[3]byte{0, 38, 88}:     "T-Platforms (Cyprus) Limited",
	[3]byte{0, 38, 89}:     "Nintendo Co., Ltd.",
	[3]byte{0, 38, 90}:     "D-Link Corporation",
	[3]byte{0, 38, 91}:     "Hitron Technologies. Inc",
	[3]byte{0, 38, 92}:     "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{0, 38, 93}:     "Samsung Electronics",
	[3]byte{0, 38, 94}:     "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{0, 38, 95}:     "Samsung Electronics Co.,Ltd",
	[3]byte{0, 38, 96}:     "Logiways",
	[3]byte{0, 38, 97}:     "Irumtek Co., Ltd.",
	[3]byte{0, 38, 98}:     "Actiontec Electronics, Inc",
	[3]byte{0, 38, 99}:     "Shenzhen Huitaiwei Tech. Ltd, co.",
	[3]byte{0, 38, 100}:    "Core System Japan",
	[3]byte{0, 38, 101}:    "ProtectedLogic Corporation",
	[3]byte{0, 38, 102}:    "EFM Networks",
	[3]byte{0, 38, 103}:    "CARECOM CO.,LTD.",
	[3]byte{0, 38, 104}:    "Nokia Danmark A/S",
	[3]byte{0, 38, 105}:    "Nokia Danmark A/S",
	[3]byte{0, 38, 106}:    "ESSENSIUM NV",
	[3]byte{0, 38, 107}:    "SHINE UNION ENTERPRISE LIMITED",
	[3]byte{0, 38, 108}:    "Inventec",
	[3]byte{0, 38, 109}:    "MobileAccess Networks",
	[3]byte{0, 38, 110}:    "Nissho-denki Co.,LTD.",
	[3]byte{0, 38, 111}:    "Coordiwise Technology Corp.",
	[3]byte{0, 38, 112}:    "Cinch Connectors",
	[3]byte{0, 38, 113}:    "AUTOVISION Co., Ltd",
	[3]byte{0, 38, 114}:    "AAMP of America",
	[3]byte{0, 38, 115}:    "RICOH COMPANY,LTD.",
	[3]byte{0, 38, 116}:    "Electronic Solutions, Inc.",
	[3]byte{0, 38, 117}:    "Aztech Electronics Pte Ltd",
	[3]byte{0, 38, 118}:    "COMMidt AS",
	[3]byte{0, 38, 119}:    "DEIF A/S",
	[3]byte{0, 38, 120}:    "Logic Instrument SA",
	[3]byte{0, 38, 121}:    "Euphonic Technologies, Inc.",
	[3]byte{0, 38, 122}:    "wuhan hongxin telecommunication technologies co.,ltd",
	[3]byte{0, 38, 123}:    "GSI Helmholtzzentrum für Schwerionenforschung GmbH",
	[3]byte{0, 38, 124}:    "Metz-Werke GmbH & Co KG",
	[3]byte{0, 38, 125}:    "A-Max Technology Macao Commercial Offshore Company Limited",
	[3]byte{0, 38, 126}:    "Parrot SA",
	[3]byte{0, 38, 127}:    "Zenterio AB",
	[3]byte{0, 38, 128}:    "Lockie Innovation Pty Ltd",
	[3]byte{0, 38, 129}:    "Interspiro AB",
	[3]byte{0, 38, 130}:    "Gemtek Technology Co., Ltd.",
	[3]byte{0, 38, 131}:    "Ajoho Enterprise Co., Ltd.",
	[3]byte{0, 38, 132}:    "KISAN SYSTEM",
	[3]byte{0, 38, 133}:    "Digital Innovation",
	[3]byte{0, 38, 134}:    "Quantenna Communcations, Inc.",
	[3]byte{0, 38, 135}:    "Corega K.K",
	[3]byte{0, 38, 136}:    "Juniper Networks",
	[3]byte{0, 38, 137}:    "General Dynamics Robotic Systems",
	[3]byte{0, 38, 138}:    "Terrier SC Ltd",
	[3]byte{0, 38, 139}:    "Guangzhou Escene Computer Technology Limited",
	[3]byte{0, 38, 140}:    "StarLeaf Ltd.",
	[3]byte{0, 38, 141}:    "CellTel S.p.A.",
	[3]byte{0, 38, 142}:    "Alta Solutions, Inc.",
	[3]byte{0, 38, 143}:    "MTA SpA",
	[3]byte{0, 38, 144}:    "I DO IT",
	[3]byte{0, 38, 145}:    "SAGEM COMMUNICATION",
	[3]byte{0, 38, 146}:    "Mitsubishi Electric Co.",
	[3]byte{0, 38, 147}:    "QVidium Technologies, Inc.",
	[3]byte{0, 38, 148}:    "Senscient Ltd",
	[3]byte{0, 38, 149}:    "ZT Group Int'l Inc",
	[3]byte{0, 38, 150}:    "NOOLIX Co., Ltd",
	[3]byte{0, 38, 151}:    "Cheetah Technologies, L.P.",
	[3]byte{0, 38, 152}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 38, 153}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 38, 154}:    "Carina System Co., Ltd.",
	[3]byte{0, 38, 155}:    "SOKRAT Ltd.",
	[3]byte{0, 38, 156}:    "ITUS JAPAN CO. LTD",
	[3]byte{0, 38, 157}:    "M2Mnet Co., Ltd.",
	[3]byte{0, 38, 158}:    "Quanta Computer Inc",
	[3]byte{0, 38, 159}:    "PRIVATE",
	[3]byte{0, 38, 160}:    "moblic",
	[3]byte{0, 38, 161}:    "Megger",
	[3]byte{0, 38, 162}:    "Instrumentation Technology Systems",
	[3]byte{0, 38, 163}:    "FQ Ingenieria Electronica S.A.",
	[3]byte{0, 38, 164}:    "Novus Produtos Eletronicos Ltda",
	[3]byte{0, 38, 165}:    "MICROROBOT.CO.,LTD",
	[3]byte{0, 38, 166}:    "TRIXELL",
	[3]byte{0, 38, 167}:    "CONNECT SRL",
	[3]byte{0, 38, 168}:    "DAEHAP HYPER-TECH",
	[3]byte{0, 38, 169}:    "Strong Technologies Pty Ltd",
	[3]byte{0, 38, 170}:    "Kenmec Mechanical Engineering Co., Ltd.",
	[3]byte{0, 38, 171}:    "SEIKO EPSON CORPORATION",
	[3]byte{0, 38, 172}:    "Shanghai LUSTER Teraband photonic Co., Ltd.",
	[3]byte{0, 38, 173}:    "Arada Systems, Inc.",
	[3]byte{0, 38, 174}:    "Wireless Measurement Ltd",
	[3]byte{0, 38, 175}:    "Duelco A/S",
	[3]byte{0, 38, 176}:    "Apple",
	[3]byte{0, 38, 177}:    "Navis Auto Motive Systems, Inc.",
	[3]byte{0, 38, 178}:    "Setrix GmbH",
	[3]byte{0, 38, 179}:    "Thales Communications Inc",
	[3]byte{0, 38, 180}:    "Ford Motor Company",
	[3]byte{0, 38, 181}:    "ICOMM Tele Ltd",
	[3]byte{0, 38, 182}:    "Askey Computer",
	[3]byte{0, 38, 183}:    "Kingston Technology Company, Inc.",
	[3]byte{0, 38, 184}:    "Actiontec Electronics, Inc",
	[3]byte{0, 38, 185}:    "Dell Inc",
	[3]byte{0, 38, 186}:    "ARRIS Group, Inc.",
	[3]byte{0, 38, 187}:    "Apple",
	[3]byte{0, 38, 188}:    "General Jack Technology Ltd.",
	[3]byte{0, 38, 189}:    "JTEC Card & Communication Co., Ltd.",
	[3]byte{0, 38, 190}:    "Schoonderbeek Elektronica Systemen B.V.",
	[3]byte{0, 38, 191}:    "ShenZhen Temobi Science&Tech Development Co.,Ltd",
	[3]byte{0, 38, 192}:    "EnergyHub",
	[3]byte{0, 38, 193}:    "ARTRAY CO., LTD.",
	[3]byte{0, 38, 194}:    "SCDI Co. LTD",
	[3]byte{0, 38, 195}:    "Insightek Corp.",
	[3]byte{0, 38, 196}:    "Cadmos microsystems S.r.l.",
	[3]byte{0, 38, 197}:    "Guangdong Gosun Telecommunications Co.,Ltd",
	[3]byte{0, 38, 198}:    "Intel Corporate",
	[3]byte{0, 38, 199}:    "Intel Corporate",
	[3]byte{0, 38, 200}:    "System Sensor",
	[3]byte{0, 38, 201}:    "Proventix Systems, Inc.",
	[3]byte{0, 38, 202}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 38, 203}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 38, 204}:    "Nokia Danmark A/S",
	[3]byte{0, 38, 205}:    "PurpleComm, Inc.",
	[3]byte{0, 38, 206}:    "Kozumi USA Corp.",
	[3]byte{0, 38, 207}:    "DEKA R&D",
	[3]byte{0, 38, 208}:    "Semihalf",
	[3]byte{0, 38, 209}:    "S Squared Innovations Inc.",
	[3]byte{0, 38, 210}:    "Pcube Systems, Inc.",
	[3]byte{0, 38, 211}:    "Zeno Information System",
	[3]byte{0, 38, 212}:    "IRCA SpA",
	[3]byte{0, 38, 213}:    "Ory Solucoes em Comercio de Informatica Ltda.",
	[3]byte{0, 38, 214}:    "Ningbo Andy Optoelectronic Co., Ltd.",
	[3]byte{0, 38, 215}:    "KM Electornic Technology Co., Ltd.",
	[3]byte{0, 38, 216}:    "Magic Point Inc.",
	[3]byte{0, 38, 217}:    "Pace plc",
	[3]byte{0, 38, 218}:    "Universal Media Corporation /Slovakia/ s.r.o.",
	[3]byte{0, 38, 219}:    "Ionics EMS Inc.",
	[3]byte{0, 38, 220}:    "Optical Systems Design",
	[3]byte{0, 38, 221}:    "Fival Science & Technology Co.,Ltd.",
	[3]byte{0, 38, 222}:    "FDI MATELEC",
	[3]byte{0, 38, 223}:    "TaiDoc Technology Corp.",
	[3]byte{0, 38, 224}:    "ASITEQ",
	[3]byte{0, 38, 225}:    "Stanford University, OpenFlow Group",
	[3]byte{0, 38, 226}:    "LG Electronics",
	[3]byte{0, 38, 227}:    "DTI",
	[3]byte{0, 38, 228}:    "CANAL OVERSEAS",
	[3]byte{0, 38, 229}:    "AEG Power Solutions",
	[3]byte{0, 38, 230}:    "Visionhitech Co., Ltd.",
	[3]byte{0, 38, 231}:    "Shanghai ONLAN Communication Tech. Co., Ltd.",
	[3]byte{0, 38, 232}:    "Murata Manufacturing Co., Ltd.",
	[3]byte{0, 38, 233}:    "SP Corp",
	[3]byte{0, 38, 234}:    "Cheerchip Electronic Technology (ShangHai) Co., Ltd.",
	[3]byte{0, 38, 235}:    "Advanced Spectrum Technology Co., Ltd.",
	[3]byte{0, 38, 236}:    "Legrand Home Systems, Inc",
	[3]byte{0, 38, 237}:    "zte corporation",
	[3]byte{0, 38, 238}:    "TKM GmbH",
	[3]byte{0, 38, 239}:    "Technology Advancement Group, Inc.",
	[3]byte{0, 38, 240}:    "cTrixs International GmbH.",
	[3]byte{0, 38, 241}:    "ProCurve Networking by HP",
	[3]byte{0, 38, 242}:    "Netgear",
	[3]byte{0, 38, 243}:    "SMC Networks",
	[3]byte{0, 38, 244}:    "Nesslab",
	[3]byte{0, 38, 245}:    "XRPLUS Inc.",
	[3]byte{0, 38, 246}:    "Military Communication Institute",
	[3]byte{0, 38, 247}:    "Infosys Technologies Ltd.",
	[3]byte{0, 38, 248}:    "Golden Highway Industry Development Co., Ltd.",
	[3]byte{0, 38, 249}:    "S.E.M. srl",
	[3]byte{0, 38, 250}:    "BandRich Inc.",
	[3]byte{0, 38, 251}:    "AirDio Wireless, Inc.",
	[3]byte{0, 38, 252}:    "AcSiP Technology Corp.",
	[3]byte{0, 38, 253}:    "Interactive Intelligence",
	[3]byte{0, 38, 254}:    "MKD Technology Inc.",
	[3]byte{0, 38, 255}:    "Research In Motion",
	[3]byte{0, 39, 0}:      "Shenzhen Siglent Technology Co., Ltd.",
	[3]byte{0, 39, 1}:      "INCOstartec GmbH",
	[3]byte{0, 39, 2}:      "SolarEdge Technologies",
	[3]byte{0, 39, 3}:      "Testech Electronics Pte Ltd",
	[3]byte{0, 39, 4}:      "Accelerated Concepts, Inc",
	[3]byte{0, 39, 5}:      "Sectronic",
	[3]byte{0, 39, 6}:      "YOISYS",
	[3]byte{0, 39, 7}:      "Lift Complex DS, JSC",
	[3]byte{0, 39, 8}:      "Nordiag ASA",
	[3]byte{0, 39, 9}:      "Nintendo Co., Ltd.",
	[3]byte{0, 39, 10}:     "IEE S.A.",
	[3]byte{0, 39, 11}:     "Adura Technologies",
	[3]byte{0, 39, 12}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 39, 13}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 39, 14}:     "Intel Corporate",
	[3]byte{0, 39, 15}:     "Envisionnovation Inc",
	[3]byte{0, 39, 16}:     "Intel Corporate",
	[3]byte{0, 39, 17}:     "LanPro Inc",
	[3]byte{0, 39, 18}:     "MaxVision LLC",
	[3]byte{0, 39, 19}:     "Universal Global Scientific Industrial Co., Ltd.",
	[3]byte{0, 39, 20}:     "Grainmustards, Co,ltd.",
	[3]byte{0, 39, 21}:     "Rebound Telecom. Co., Ltd",
	[3]byte{0, 39, 22}:     "Adachi-Syokai Co., Ltd.",
	[3]byte{0, 39, 23}:     "CE Digital(Zhenjiang)Co.,Ltd",
	[3]byte{0, 39, 24}:     "Suzhou NEW SEAUNION Video Technology Co.,Ltd",
	[3]byte{0, 39, 25}:     "TP-LINK TECHNOLOGIES CO., LTD.",
	[3]byte{0, 39, 26}:     "Geenovo Technology Ltd.",
	[3]byte{0, 39, 27}:     "Alec Sicherheitssysteme GmbH",
	[3]byte{0, 39, 28}:     "MERCURY CORPORATION",
	[3]byte{0, 39, 29}:     "Comba Telecom Systems (China) Ltd.",
	[3]byte{0, 39, 30}:     "Xagyl Communications",
	[3]byte{0, 39, 31}:     "MIPRO Electronics Co., Ltd",
	[3]byte{0, 39, 32}:     "NEW-SOL COM",
	[3]byte{0, 39, 33}:     "Shenzhen Baoan Fenda Industrial Co., Ltd",
	[3]byte{0, 39, 34}:     "Ubiquiti Networks",
	[3]byte{0, 39, 248}:    "Brocade Communications Systems, Inc.",
	[3]byte{0, 42, 106}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 42, 175}:    "LARsys-Automation GmbH",
	[3]byte{0, 45, 118}:    "TITECH GmbH",
	[3]byte{0, 48, 0}:      "ALLWELL TECHNOLOGY CORP.",
	[3]byte{0, 48, 1}:      "SMP",
	[3]byte{0, 48, 2}:      "Expand Networks",
	[3]byte{0, 48, 3}:      "Phasys Ltd.",
	[3]byte{0, 48, 4}:      "LEADTEK RESEARCH INC.",
	[3]byte{0, 48, 5}:      "Fujitsu Siemens Computers",
	[3]byte{0, 48, 6}:      "SUPERPOWER COMPUTER",
	[3]byte{0, 48, 7}:      "OPTI, INC.",
	[3]byte{0, 48, 8}:      "AVIO DIGITAL, INC.",
	[3]byte{0, 48, 9}:      "Tachion Networks, Inc.",
	[3]byte{0, 48, 10}:     "AZTECH Electronics Pte Ltd",
	[3]byte{0, 48, 11}:     "mPHASE Technologies, Inc.",
	[3]byte{0, 48, 12}:     "CONGRUENCY, LTD.",
	[3]byte{0, 48, 13}:     "MMC Technology, Inc.",
	[3]byte{0, 48, 14}:     "Klotz Digital AG",
	[3]byte{0, 48, 15}:     "IMT - Information Management T",
	[3]byte{0, 48, 16}:     "VISIONETICS INTERNATIONAL",
	[3]byte{0, 48, 17}:     "HMS Industrial Networks",
	[3]byte{0, 48, 18}:     "DIGITAL ENGINEERING LTD.",
	[3]byte{0, 48, 19}:     "NEC Corporation",
	[3]byte{0, 48, 20}:     "DIVIO, INC.",
	[3]byte{0, 48, 21}:     "CP CLARE CORP.",
	[3]byte{0, 48, 22}:     "ISHIDA CO., LTD.",
	[3]byte{0, 48, 23}:     "BlueArc UK Ltd",
	[3]byte{0, 48, 24}:     "Jetway Information Co., Ltd.",
	[3]byte{0, 48, 25}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 48, 26}:     "SMARTBRIDGES PTE. LTD.",
	[3]byte{0, 48, 27}:     "SHUTTLE, INC.",
	[3]byte{0, 48, 28}:     "ALTVATER AIRDATA SYSTEMS",
	[3]byte{0, 48, 29}:     "SKYSTREAM, INC.",
	[3]byte{0, 48, 30}:     "3COM Europe Ltd.",
	[3]byte{0, 48, 31}:     "OPTICAL NETWORKS, INC.",
	[3]byte{0, 48, 32}:     "TSI, Inc..",
	[3]byte{0, 48, 33}:     "HSING TECH. ENTERPRISE CO.,LTD",
	[3]byte{0, 48, 34}:     "Fong Kai Industrial Co., Ltd.",
	[3]byte{0, 48, 35}:     "COGENT COMPUTER SYSTEMS, INC.",
	[3]byte{0, 48, 36}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 48, 37}:     "CHECKOUT COMPUTER SYSTEMS, LTD",
	[3]byte{0, 48, 38}:     "HeiTel Digital Video GmbH",
	[3]byte{0, 48, 39}:     "KERBANGO, INC.",
	[3]byte{0, 48, 40}:     "FASE Saldatura srl",
	[3]byte{0, 48, 41}:     "OPICOM",
	[3]byte{0, 48, 42}:     "SOUTHERN INFORMATION",
	[3]byte{0, 48, 43}:     "INALP NETWORKS, INC.",
	[3]byte{0, 48, 44}:     "SYLANTRO SYSTEMS CORPORATION",
	[3]byte{0, 48, 45}:     "QUANTUM BRIDGE COMMUNICATIONS",
	[3]byte{0, 48, 46}:     "Hoft & Wessel AG",
	[3]byte{0, 48, 47}:     "GE Aviation System",
	[3]byte{0, 48, 48}:     "HARMONIX CORPORATION",
	[3]byte{0, 48, 49}:     "LIGHTWAVE COMMUNICATIONS, INC.",
	[3]byte{0, 48, 50}:     "MagicRam, Inc.",
	[3]byte{0, 48, 51}:     "ORIENT TELECOM CO., LTD.",
	[3]byte{0, 48, 52}:     "SET ENGINEERING",
	[3]byte{0, 48, 53}:     "Corning Incorporated",
	[3]byte{0, 48, 54}:     "RMP ELEKTRONIKSYSTEME GMBH",
	[3]byte{0, 48, 55}:     "Packard Bell Nec Services",
	[3]byte{0, 48, 56}:     "XCP, INC.",
	[3]byte{0, 48, 57}:     "SOFTBOOK PRESS",
	[3]byte{0, 48, 58}:     "MAATEL",
	[3]byte{0, 48, 59}:     "PowerCom Technology",
	[3]byte{0, 48, 60}:     "ONNTO CORP.",
	[3]byte{0, 48, 61}:     "IVA CORPORATION",
	[3]byte{0, 48, 62}:     "Radcom Ltd.",
	[3]byte{0, 48, 63}:     "TurboComm Tech Inc.",
	[3]byte{0, 48, 64}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 48, 65}:     "SAEJIN T & M CO., LTD.",
	[3]byte{0, 48, 66}:     "DeTeWe-Deutsche Telephonwerke",
	[3]byte{0, 48, 67}:     "IDREAM TECHNOLOGIES, PTE. LTD.",
	[3]byte{0, 48, 68}:     "CradlePoint, Inc",
	[3]byte{0, 48, 69}:     "Village Networks, Inc. (VNI)",
	[3]byte{0, 48, 70}:     "Controlled Electronic Manageme",
	[3]byte{0, 48, 71}:     "NISSEI ELECTRIC CO., LTD.",
	[3]byte{0, 48, 72}:     "Supermicro Computer, Inc.",
	[3]byte{0, 48, 73}:     "BRYANT TECHNOLOGY, LTD.",
	[3]byte{0, 48, 74}:     "Fraunhofer IPMS",
	[3]byte{0, 48, 75}:     "ORBACOM SYSTEMS, INC.",
	[3]byte{0, 48, 76}:     "APPIAN COMMUNICATIONS, INC.",
	[3]byte{0, 48, 77}:     "ESI",
	[3]byte{0, 48, 78}:     "BUSTEC PRODUCTION LTD.",
	[3]byte{0, 48, 79}:     "PLANET Technology Corporation",
	[3]byte{0, 48, 80}:     "Versa Technology",
	[3]byte{0, 48, 81}:     "ORBIT AVIONIC & COMMUNICATION",
	[3]byte{0, 48, 82}:     "ELASTIC NETWORKS",
	[3]byte{0, 48, 83}:     "Basler AG",
	[3]byte{0, 48, 84}:     "CASTLENET TECHNOLOGY, INC.",
	[3]byte{0, 48, 85}:     "Renesas Technology America, Inc.",
	[3]byte{0, 48, 86}:     "Beck IPC GmbH",
	[3]byte{0, 48, 87}:     "QTelNet, Inc.",
	[3]byte{0, 48, 88}:     "API MOTION",
	[3]byte{0, 48, 89}:     "KONTRON COMPACT COMPUTERS AG",
	[3]byte{0, 48, 90}:     "TELGEN CORPORATION",
	[3]byte{0, 48, 91}:     "Toko Inc.",
	[3]byte{0, 48, 92}:     "SMAR Laboratories Corp.",
	[3]byte{0, 48, 93}:     "DIGITRA SYSTEMS, INC.",
	[3]byte{0, 48, 94}:     "Abelko Innovation",
	[3]byte{0, 48, 95}:     "Hasselblad",
	[3]byte{0, 48, 96}:     "Powerfile, Inc.",
	[3]byte{0, 48, 97}:     "MobyTEL",
	[3]byte{0, 48, 98}:     "IP Video Networks Inc",
	[3]byte{0, 48, 99}:     "SANTERA SYSTEMS, INC.",
	[3]byte{0, 48, 100}:    "ADLINK TECHNOLOGY, INC.",
	[3]byte{0, 48, 101}:    "Apple",
	[3]byte{0, 48, 102}:    "RFM",
	[3]byte{0, 48, 103}:    "BIOSTAR MICROTECH INT'L CORP.",
	[3]byte{0, 48, 104}:    "CYBERNETICS TECH. CO., LTD.",
	[3]byte{0, 48, 105}:    "IMPACCT TECHNOLOGY CORP.",
	[3]byte{0, 48, 106}:    "PENTA MEDIA CO., LTD.",
	[3]byte{0, 48, 107}:    "CMOS SYSTEMS, INC.",
	[3]byte{0, 48, 108}:    "Hitex Holding GmbH",
	[3]byte{0, 48, 109}:    "LUCENT TECHNOLOGIES",
	[3]byte{0, 48, 110}:    "HEWLETT PACKARD",
	[3]byte{0, 48, 111}:    "SEYEON TECH. CO., LTD.",
	[3]byte{0, 48, 112}:    "1Net Corporation",
	[3]byte{0, 48, 113}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 48, 114}:    "Intellibyte Inc.",
	[3]byte{0, 48, 115}:    "International Microsystems, In",
	[3]byte{0, 48, 116}:    "EQUIINET LTD.",
	[3]byte{0, 48, 117}:    "ADTECH",
	[3]byte{0, 48, 118}:    "Akamba Corporation",
	[3]byte{0, 48, 119}:    "ONPREM NETWORKS",
	[3]byte{0, 48, 120}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 48, 121}:    "CQOS, INC.",
	[3]byte{0, 48, 122}:    "Advanced Technology & Systems",
	[3]byte{0, 48, 123}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 48, 124}:    "ADID SA",
	[3]byte{0, 48, 125}:    "GRE AMERICA, INC.",
	[3]byte{0, 48, 126}:    "Redflex Communication Systems",
	[3]byte{0, 48, 127}:    "IRLAN LTD.",
	[3]byte{0, 48, 128}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 48, 129}:    "ALTOS C&C",
	[3]byte{0, 48, 130}:    "TAIHAN ELECTRIC WIRE CO., LTD.",
	[3]byte{0, 48, 131}:    "Ivron Systems",
	[3]byte{0, 48, 132}:    "ALLIED TELESYN INTERNAIONAL",
	[3]byte{0, 48, 133}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 48, 134}:    "Transistor Devices, Inc.",
	[3]byte{0, 48, 135}:    "VEGA GRIESHABER KG",
	[3]byte{0, 48, 136}:    "Ericsson",
	[3]byte{0, 48, 137}:    "Spectrapoint Wireless, LLC",
	[3]byte{0, 48, 138}:    "NICOTRA SISTEMI S.P.A",
	[3]byte{0, 48, 139}:    "Brix Networks",
	[3]byte{0, 48, 140}:    "Quantum Corporation",
	[3]byte{0, 48, 141}:    "Pinnacle Systems, Inc.",
	[3]byte{0, 48, 142}:    "CROSS MATCH TECHNOLOGIES, INC.",
	[3]byte{0, 48, 143}:    "MICRILOR, Inc.",
	[3]byte{0, 48, 144}:    "CYRA TECHNOLOGIES, INC.",
	[3]byte{0, 48, 145}:    "TAIWAN FIRST LINE ELEC. CORP.",
	[3]byte{0, 48, 146}:    "ModuNORM GmbH",
	[3]byte{0, 48, 147}:    "Sonnet Technologies, Inc",
	[3]byte{0, 48, 148}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 48, 149}:    "Procomp Informatics, Ltd.",
	[3]byte{0, 48, 150}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 48, 151}:    "AB Regin",
	[3]byte{0, 48, 152}:    "Global Converging Technologies",
	[3]byte{0, 48, 153}:    "BOENIG UND KALLENBACH OHG",
	[3]byte{0, 48, 154}:    "ASTRO TERRA CORP.",
	[3]byte{0, 48, 155}:    "Smartware",
	[3]byte{0, 48, 156}:    "Timing Applications, Inc.",
	[3]byte{0, 48, 157}:    "Nimble Microsystems, Inc.",
	[3]byte{0, 48, 158}:    "WORKBIT CORPORATION.",
	[3]byte{0, 48, 159}:    "AMBER NETWORKS",
	[3]byte{0, 48, 160}:    "TYCO SUBMARINE SYSTEMS, LTD.",
	[3]byte{0, 48, 161}:    "WEBGATE Inc.",
	[3]byte{0, 48, 162}:    "Lightner Engineering",
	[3]byte{0, 48, 163}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 48, 164}:    "Woodwind Communications System",
	[3]byte{0, 48, 165}:    "ACTIVE POWER",
	[3]byte{0, 48, 166}:    "VIANET TECHNOLOGIES, LTD.",
	[3]byte{0, 48, 167}:    "SCHWEITZER ENGINEERING",
	[3]byte{0, 48, 168}:    "OL'E COMMUNICATIONS, INC.",
	[3]byte{0, 48, 169}:    "Netiverse, Inc.",
	[3]byte{0, 48, 170}:    "AXUS MICROSYSTEMS, INC.",
	[3]byte{0, 48, 171}:    "DELTA NETWORKS, INC.",
	[3]byte{0, 48, 172}:    "Systeme Lauer GmbH & Co., Ltd.",
	[3]byte{0, 48, 173}:    "SHANGHAI COMMUNICATION",
	[3]byte{0, 48, 174}:    "Times N System, Inc.",
	[3]byte{0, 48, 175}:    "Honeywell GmbH",
	[3]byte{0, 48, 176}:    "Convergenet Technologies",
	[3]byte{0, 48, 177}:    "TrunkNet",
	[3]byte{0, 48, 178}:    "L-3 Sonoma EO",
	[3]byte{0, 48, 179}:    "San Valley Systems, Inc.",
	[3]byte{0, 48, 180}:    "INTERSIL CORP.",
	[3]byte{0, 48, 181}:    "Tadiran Microwave Networks",
	[3]byte{0, 48, 182}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 48, 183}:    "Teletrol Systems, Inc.",
	[3]byte{0, 48, 184}:    "RiverDelta Networks",
	[3]byte{0, 48, 185}:    "ECTEL",
	[3]byte{0, 48, 186}:    "AC&T SYSTEM CO., LTD.",
	[3]byte{0, 48, 187}:    "CacheFlow, Inc.",
	[3]byte{0, 48, 188}:    "Optronic AG",
	[3]byte{0, 48, 189}:    "BELKIN COMPONENTS",
	[3]byte{0, 48, 190}:    "City-Net Technology, Inc.",
	[3]byte{0, 48, 191}:    "MULTIDATA GMBH",
	[3]byte{0, 48, 192}:    "Lara Technology, Inc.",
	[3]byte{0, 48, 193}:    "HEWLETT-PACKARD",
	[3]byte{0, 48, 194}:    "COMONE",
	[3]byte{0, 48, 195}:    "FLUECKIGER ELEKTRONIK AG",
	[3]byte{0, 48, 196}:    "Canon Imaging Systems Inc.",
	[3]byte{0, 48, 197}:    "CADENCE DESIGN SYSTEMS",
	[3]byte{0, 48, 198}:    "CONTROL SOLUTIONS, INC.",
	[3]byte{0, 48, 199}:    "Macromate Corp.",
	[3]byte{0, 48, 200}:    "GAD LINE, LTD.",
	[3]byte{0, 48, 201}:    "LuxN, N",
	[3]byte{0, 48, 202}:    "Discovery Com",
	[3]byte{0, 48, 203}:    "OMNI FLOW COMPUTERS, INC.",
	[3]byte{0, 48, 204}:    "Tenor Networks, Inc.",
	[3]byte{0, 48, 205}:    "CONEXANT SYSTEMS, INC.",
	[3]byte{0, 48, 206}:    "Zaffire",
	[3]byte{0, 48, 207}:    "TWO TECHNOLOGIES, INC.",
	[3]byte{0, 48, 208}:    "Tellabs",
	[3]byte{0, 48, 209}:    "INOVA CORPORATION",
	[3]byte{0, 48, 210}:    "WIN TECHNOLOGIES, CO., LTD.",
	[3]byte{0, 48, 211}:    "Agilent Technologies",
	[3]byte{0, 48, 212}:    "AAE Systems, Inc.",
	[3]byte{0, 48, 213}:    "DResearch GmbH",
	[3]byte{0, 48, 214}:    "MSC VERTRIEBS GMBH",
	[3]byte{0, 48, 215}:    "Innovative Systems, L.L.C.",
	[3]byte{0, 48, 216}:    "SITEK",
	[3]byte{0, 48, 217}:    "DATACORE SOFTWARE CORP.",
	[3]byte{0, 48, 218}:    "COMTREND CO.",
	[3]byte{0, 48, 219}:    "Mindready Solutions, Inc.",
	[3]byte{0, 48, 220}:    "RIGHTECH CORPORATION",
	[3]byte{0, 48, 221}:    "INDIGITA CORPORATION",
	[3]byte{0, 48, 222}:    "WAGO Kontakttechnik GmbH",
	[3]byte{0, 48, 223}:    "KB/TEL TELECOMUNICACIONES",
	[3]byte{0, 48, 224}:    "OXFORD SEMICONDUCTOR LTD.",
	[3]byte{0, 48, 225}:    "Network Equipment Technologies, Inc.",
	[3]byte{0, 48, 226}:    "GARNET SYSTEMS CO., LTD.",
	[3]byte{0, 48, 227}:    "SEDONA NETWORKS CORP.",
	[3]byte{0, 48, 228}:    "CHIYODA SYSTEM RIKEN",
	[3]byte{0, 48, 229}:    "Amper Datos S.A.",
	[3]byte{0, 48, 230}:    "Draeger Medical Systems, Inc.",
	[3]byte{0, 48, 231}:    "CNF MOBILE SOLUTIONS, INC.",
	[3]byte{0, 48, 232}:    "ENSIM CORP.",
	[3]byte{0, 48, 233}:    "GMA COMMUNICATION MANUFACT'G",
	[3]byte{0, 48, 234}:    "TeraForce Technology Corporation",
	[3]byte{0, 48, 235}:    "TURBONET COMMUNICATIONS, INC.",
	[3]byte{0, 48, 236}:    "BORGARDT",
	[3]byte{0, 48, 237}:    "Expert Magnetics Corp.",
	[3]byte{0, 48, 238}:    "DSG Technology, Inc.",
	[3]byte{0, 48, 239}:    "NEON TECHNOLOGY, INC.",
	[3]byte{0, 48, 240}:    "Uniform Industrial Corp.",
	[3]byte{0, 48, 241}:    "Accton Technology Corp.",
	[3]byte{0, 48, 242}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 48, 243}:    "At Work Computers",
	[3]byte{0, 48, 244}:    "STARDOT TECHNOLOGIES",
	[3]byte{0, 48, 245}:    "Wild Lab. Ltd.",
	[3]byte{0, 48, 246}:    "SECURELOGIX CORPORATION",
	[3]byte{0, 48, 247}:    "RAMIX INC.",
	[3]byte{0, 48, 248}:    "Dynapro Systems, Inc.",
	[3]byte{0, 48, 249}:    "Sollae Systems Co., Ltd.",
	[3]byte{0, 48, 250}:    "TELICA, INC.",
	[3]byte{0, 48, 251}:    "AZS Technology AG",
	[3]byte{0, 48, 252}:    "Terawave Communications, Inc.",
	[3]byte{0, 48, 253}:    "INTEGRATED SYSTEMS DESIGN",
	[3]byte{0, 48, 254}:    "DSA GmbH",
	[3]byte{0, 48, 255}:    "DATAFAB SYSTEMS, INC.",
	[3]byte{0, 51, 108}:    "SynapSense Corporation",
	[3]byte{0, 52, 241}:    "Radicom Research, Inc.",
	[3]byte{0, 53, 50}:     "Electro-Metrics Corporation",
	[3]byte{0, 53, 96}:     "Rosen Aviation",
	[3]byte{0, 54, 248}:    "Conti Temic microelectronic GmbH",
	[3]byte{0, 54, 254}:    "SuperVision",
	[3]byte{0, 55, 109}:    "Murata Manufacturing Co., Ltd.",
	[3]byte{0, 58, 152}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 58, 153}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 58, 154}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 58, 155}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 58, 156}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 58, 157}:    "NEC Platforms, Ltd.",
	[3]byte{0, 58, 175}:    "BlueBit Ltd.",
	[3]byte{0, 60, 197}:    "WONWOO Engineering Co., Ltd",
	[3]byte{0, 61, 65}:     "Hatteland Computer AS",
	[3]byte{0, 62, 225}:    "Apple",
	[3]byte{0, 64, 0}:      "PCI COMPONENTES DA AMZONIA LTD",
	[3]byte{0, 64, 1}:      "Zero One Technology Co. Ltd.",
	[3]byte{0, 64, 2}:      "PERLE SYSTEMS LIMITED",
	[3]byte{0, 64, 3}:      "Emerson Process Management Power & Water Solutions, Inc.",
	[3]byte{0, 64, 4}:      "ICM CO. LTD.",
	[3]byte{0, 64, 5}:      "ANI COMMUNICATIONS INC.",
	[3]byte{0, 64, 6}:      "SAMPO TECHNOLOGY CORPORATION",
	[3]byte{0, 64, 7}:      "TELMAT INFORMATIQUE",
	[3]byte{0, 64, 8}:      "A PLUS INFO CORPORATION",
	[3]byte{0, 64, 9}:      "TACHIBANA TECTRON CO., LTD.",
	[3]byte{0, 64, 10}:     "PIVOTAL TECHNOLOGIES, INC.",
	[3]byte{0, 64, 11}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 64, 12}:     "GENERAL MICRO SYSTEMS, INC.",
	[3]byte{0, 64, 13}:     "LANNET DATA COMMUNICATIONS,LTD",
	[3]byte{0, 64, 14}:     "MEMOTEC, INC.",
	[3]byte{0, 64, 15}:     "DATACOM TECHNOLOGIES",
	[3]byte{0, 64, 16}:     "SONIC SYSTEMS, INC.",
	[3]byte{0, 64, 17}:     "ANDOVER CONTROLS CORPORATION",
	[3]byte{0, 64, 18}:     "WINDATA, INC.",
	[3]byte{0, 64, 19}:     "NTT DATA COMM. SYSTEMS CORP.",
	[3]byte{0, 64, 20}:     "COMSOFT GMBH",
	[3]byte{0, 64, 21}:     "ASCOM INFRASYS AG",
	[3]byte{0, 64, 22}:     "ADC - Global Connectivity Solutions Division",
	[3]byte{0, 64, 23}:     "Silex Technology America",
	[3]byte{0, 64, 24}:     "ADOBE SYSTEMS, INC.",
	[3]byte{0, 64, 25}:     "AEON SYSTEMS, INC.",
	[3]byte{0, 64, 26}:     "FUJI ELECTRIC CO., LTD.",
	[3]byte{0, 64, 27}:     "PRINTER SYSTEMS CORP.",
	[3]byte{0, 64, 28}:     "AST RESEARCH, INC.",
	[3]byte{0, 64, 29}:     "INVISIBLE SOFTWARE, INC.",
	[3]byte{0, 64, 30}:     "ICC",
	[3]byte{0, 64, 31}:     "COLORGRAPH LTD",
	[3]byte{0, 64, 32}:     "TE Connectivity Ltd.",
	[3]byte{0, 64, 33}:     "RASTER GRAPHICS",
	[3]byte{0, 64, 34}:     "KLEVER COMPUTERS, INC.",
	[3]byte{0, 64, 35}:     "LOGIC CORPORATION",
	[3]byte{0, 64, 36}:     "COMPAC INC.",
	[3]byte{0, 64, 37}:     "MOLECULAR DYNAMICS",
	[3]byte{0, 64, 38}:     "Buffalo Inc.",
	[3]byte{0, 64, 39}:     "SMC MASSACHUSETTS, INC.",
	[3]byte{0, 64, 40}:     "NETCOMM LIMITED",
	[3]byte{0, 64, 41}:     "COMPEX",
	[3]byte{0, 64, 42}:     "CANOGA-PERKINS",
	[3]byte{0, 64, 43}:     "TRIGEM COMPUTER, INC.",
	[3]byte{0, 64, 44}:     "ISIS DISTRIBUTED SYSTEMS, INC.",
	[3]byte{0, 64, 45}:     "HARRIS ADACOM CORPORATION",
	[3]byte{0, 64, 46}:     "PRECISION SOFTWARE, INC.",
	[3]byte{0, 64, 47}:     "XLNT DESIGNS INC.",
	[3]byte{0, 64, 48}:     "GK COMPUTER",
	[3]byte{0, 64, 49}:     "KOKUSAI ELECTRIC CO., LTD",
	[3]byte{0, 64, 50}:     "DIGITAL COMMUNICATIONS",
	[3]byte{0, 64, 51}:     "ADDTRON TECHNOLOGY CO., LTD.",
	[3]byte{0, 64, 52}:     "BUSTEK CORPORATION",
	[3]byte{0, 64, 53}:     "OPCOM",
	[3]byte{0, 64, 54}:     "TRIBE COMPUTER WORKS, INC.",
	[3]byte{0, 64, 55}:     "SEA-ILAN, INC.",
	[3]byte{0, 64, 56}:     "TALENT ELECTRIC INCORPORATED",
	[3]byte{0, 64, 57}:     "OPTEC DAIICHI DENKO CO., LTD.",
	[3]byte{0, 64, 58}:     "IMPACT TECHNOLOGIES",
	[3]byte{0, 64, 59}:     "SYNERJET INTERNATIONAL CORP.",
	[3]byte{0, 64, 60}:     "FORKS, INC.",
	[3]byte{0, 64, 61}:     "Teradata Corporation",
	[3]byte{0, 64, 62}:     "RASTER OPS CORPORATION",
	[3]byte{0, 64, 63}:     "SSANGYONG COMPUTER SYSTEMS",
	[3]byte{0, 64, 64}:     "RING ACCESS, INC.",
	[3]byte{0, 64, 65}:     "FUJIKURA LTD.",
	[3]byte{0, 64, 66}:     "N.A.T. GMBH",
	[3]byte{0, 64, 67}:     "Nokia Siemens Networks GmbH & Co. KG.",
	[3]byte{0, 64, 68}:     "QNIX COMPUTER CO., LTD.",
	[3]byte{0, 64, 69}:     "TWINHEAD CORPORATION",
	[3]byte{0, 64, 70}:     "UDC RESEARCH LIMITED",
	[3]byte{0, 64, 71}:     "WIND RIVER SYSTEMS",
	[3]byte{0, 64, 72}:     "SMD INFORMATICA S.A.",
	[3]byte{0, 64, 73}:     "Roche Diagnostics International Ltd.",
	[3]byte{0, 64, 74}:     "WEST AUSTRALIAN DEPARTMENT",
	[3]byte{0, 64, 75}:     "MAPLE COMPUTER SYSTEMS",
	[3]byte{0, 64, 76}:     "HYPERTEC PTY LTD.",
	[3]byte{0, 64, 77}:     "TELECOMMUNICATIONS TECHNIQUES",
	[3]byte{0, 64, 78}:     "FLUENT, INC.",
	[3]byte{0, 64, 79}:     "SPACE & NAVAL WARFARE SYSTEMS",
	[3]byte{0, 64, 80}:     "IRONICS, INCORPORATED",
	[3]byte{0, 64, 81}:     "GRACILIS, INC.",
	[3]byte{0, 64, 82}:     "STAR TECHNOLOGIES, INC.",
	[3]byte{0, 64, 83}:     "AMPRO COMPUTERS",
	[3]byte{0, 64, 84}:     "CONNECTION MACHINES SERVICES",
	[3]byte{0, 64, 85}:     "METRONIX GMBH",
	[3]byte{0, 64, 86}:     "MCM JAPAN LTD.",
	[3]byte{0, 64, 87}:     "LOCKHEED - SANDERS",
	[3]byte{0, 64, 88}:     "KRONOS, INC.",
	[3]byte{0, 64, 89}:     "YOSHIDA KOGYO K. K.",
	[3]byte{0, 64, 90}:     "GOLDSTAR INFORMATION & COMM.",
	[3]byte{0, 64, 91}:     "FUNASSET LIMITED",
	[3]byte{0, 64, 92}:     "FUTURE SYSTEMS, INC.",
	[3]byte{0, 64, 93}:     "STAR-TEK, INC.",
	[3]byte{0, 64, 94}:     "NORTH HILLS ISRAEL",
	[3]byte{0, 64, 95}:     "AFE COMPUTERS LTD.",
	[3]byte{0, 64, 96}:     "COMENDEC LTD",
	[3]byte{0, 64, 97}:     "DATATECH ENTERPRISES CO., LTD.",
	[3]byte{0, 64, 98}:     "E-SYSTEMS, INC./GARLAND DIV.",
	[3]byte{0, 64, 99}:     "VIA TECHNOLOGIES, INC.",
	[3]byte{0, 64, 100}:    "KLA INSTRUMENTS CORPORATION",
	[3]byte{0, 64, 101}:    "GTE SPACENET",
	[3]byte{0, 64, 102}:    "Hitachi Metals, Ltd.",
	[3]byte{0, 64, 103}:    "OMNIBYTE CORPORATION",
	[3]byte{0, 64, 104}:    "EXTENDED SYSTEMS",
	[3]byte{0, 64, 105}:    "LEMCOM SYSTEMS, INC.",
	[3]byte{0, 64, 106}:    "KENTEK INFORMATION SYSTEMS,INC",
	[3]byte{0, 64, 107}:    "SYSGEN",
	[3]byte{0, 64, 108}:    "COPERNIQUE",
	[3]byte{0, 64, 109}:    "LANCO, INC.",
	[3]byte{0, 64, 110}:    "COROLLARY, INC.",
	[3]byte{0, 64, 111}:    "SYNC RESEARCH INC.",
	[3]byte{0, 64, 112}:    "INTERWARE CO., LTD.",
	[3]byte{0, 64, 113}:    "ATM COMPUTER GMBH",
	[3]byte{0, 64, 114}:    "Applied Innovation Inc.",
	[3]byte{0, 64, 115}:    "BASS ASSOCIATES",
	[3]byte{0, 64, 116}:    "CABLE AND WIRELESS",
	[3]byte{0, 64, 117}:    "Tattile SRL",
	[3]byte{0, 64, 118}:    "Sun Conversion Technologies",
	[3]byte{0, 64, 119}:    "MAXTON TECHNOLOGY CORPORATION",
	[3]byte{0, 64, 120}:    "WEARNES AUTOMATION PTE LTD",
	[3]byte{0, 64, 121}:    "JUKO MANUFACTURE COMPANY, LTD.",
	[3]byte{0, 64, 122}:    "SOCIETE D'EXPLOITATION DU CNIT",
	[3]byte{0, 64, 123}:    "SCIENTIFIC ATLANTA",
	[3]byte{0, 64, 124}:    "QUME CORPORATION",
	[3]byte{0, 64, 125}:    "EXTENSION TECHNOLOGY CORP.",
	[3]byte{0, 64, 126}:    "EVERGREEN SYSTEMS, INC.",
	[3]byte{0, 64, 127}:    "FLIR Systems",
	[3]byte{0, 64, 128}:    "ATHENIX CORPORATION",
	[3]byte{0, 64, 129}:    "MANNESMANN SCANGRAPHIC GMBH",
	[3]byte{0, 64, 130}:    "LABORATORY EQUIPMENT CORP.",
	[3]byte{0, 64, 131}:    "TDA INDUSTRIA DE PRODUTOS",
	[3]byte{0, 64, 132}:    "HONEYWELL ACS",
	[3]byte{0, 64, 133}:    "SAAB INSTRUMENTS AB",
	[3]byte{0, 64, 134}:    "MICHELS & KLEBERHOFF COMPUTER",
	[3]byte{0, 64, 135}:    "UBITREX CORPORATION",
	[3]byte{0, 64, 136}:    "MOBIUS TECHNOLOGIES, INC.",
	[3]byte{0, 64, 137}:    "MEIDENSHA CORPORATION",
	[3]byte{0, 64, 138}:    "TPS TELEPROCESSING SYS. GMBH",
	[3]byte{0, 64, 139}:    "RAYLAN CORPORATION",
	[3]byte{0, 64, 140}:    "AXIS COMMUNICATIONS AB",
	[3]byte{0, 64, 141}:    "THE GOODYEAR TIRE & RUBBER CO.",
	[3]byte{0, 64, 142}:    "Tattile SRL",
	[3]byte{0, 64, 143}:    "WM-DATA MINFO AB",
	[3]byte{0, 64, 144}:    "ANSEL COMMUNICATIONS",
	[3]byte{0, 64, 145}:    "PROCOMP INDUSTRIA ELETRONICA",
	[3]byte{0, 64, 146}:    "ASP COMPUTER PRODUCTS, INC.",
	[3]byte{0, 64, 147}:    "PAXDATA NETWORKS LTD.",
	[3]byte{0, 64, 148}:    "SHOGRAPHICS, INC.",
	[3]byte{0, 64, 149}:    "R.P.T. INTERGROUPS INT'L LTD.",
	[3]byte{0, 64, 150}:    "Cisco Systems",
	[3]byte{0, 64, 151}:    "DATEX DIVISION OF",
	[3]byte{0, 64, 152}:    "DRESSLER GMBH & CO.",
	[3]byte{0, 64, 153}:    "NEWGEN SYSTEMS CORP.",
	[3]byte{0, 64, 154}:    "NETWORK EXPRESS, INC.",
	[3]byte{0, 64, 155}:    "HAL COMPUTER SYSTEMS INC.",
	[3]byte{0, 64, 156}:    "TRANSWARE",
	[3]byte{0, 64, 157}:    "DIGIBOARD, INC.",
	[3]byte{0, 64, 158}:    "CONCURRENT TECHNOLOGIES  LTD.",
	[3]byte{0, 64, 159}:    "Telco Systems, Inc.",
	[3]byte{0, 64, 160}:    "GOLDSTAR CO., LTD.",
	[3]byte{0, 64, 161}:    "ERGO COMPUTING",
	[3]byte{0, 64, 162}:    "KINGSTAR TECHNOLOGY INC.",
	[3]byte{0, 64, 163}:    "MICROUNITY SYSTEMS ENGINEERING",
	[3]byte{0, 64, 164}:    "ROSE ELECTRONICS",
	[3]byte{0, 64, 165}:    "CLINICOMP INTL.",
	[3]byte{0, 64, 166}:    "Cray, Inc.",
	[3]byte{0, 64, 167}:    "ITAUTEC PHILCO S.A.",
	[3]byte{0, 64, 168}:    "IMF INTERNATIONAL LTD.",
	[3]byte{0, 64, 169}:    "DATACOM INC.",
	[3]byte{0, 64, 170}:    "Metso Automation",
	[3]byte{0, 64, 171}:    "ROLAND DG CORPORATION",
	[3]byte{0, 64, 172}:    "SUPER WORKSTATION, INC.",
	[3]byte{0, 64, 173}:    "SMA REGELSYSTEME GMBH",
	[3]byte{0, 64, 174}:    "DELTA CONTROLS, INC.",
	[3]byte{0, 64, 175}:    "DIGITAL PRODUCTS, INC.",
	[3]byte{0, 64, 176}:    "BYTEX CORPORATION, ENGINEERING",
	[3]byte{0, 64, 177}:    "CODONICS INC.",
	[3]byte{0, 64, 178}:    "SYSTEMFORSCHUNG",
	[3]byte{0, 64, 179}:    "ParTech Inc.",
	[3]byte{0, 64, 180}:    "NEXTCOM K.K.",
	[3]byte{0, 64, 181}:    "VIDEO TECHNOLOGY COMPUTERS LTD",
	[3]byte{0, 64, 182}:    "COMPUTERM  CORPORATION",
	[3]byte{0, 64, 183}:    "STEALTH COMPUTER SYSTEMS",
	[3]byte{0, 64, 184}:    "IDEA ASSOCIATES",
	[3]byte{0, 64, 185}:    "MACQ ELECTRONIQUE SA",
	[3]byte{0, 64, 186}:    "ALLIANT COMPUTER SYSTEMS CORP.",
	[3]byte{0, 64, 187}:    "GOLDSTAR CABLE CO., LTD.",
	[3]byte{0, 64, 188}:    "ALGORITHMICS LTD.",
	[3]byte{0, 64, 189}:    "STARLIGHT NETWORKS, INC.",
	[3]byte{0, 64, 190}:    "BOEING DEFENSE & SPACE",
	[3]byte{0, 64, 191}:    "CHANNEL SYSTEMS INTERN'L INC.",
	[3]byte{0, 64, 192}:    "VISTA CONTROLS CORPORATION",
	[3]byte{0, 64, 193}:    "BIZERBA-WERKE WILHEIM KRAUT",
	[3]byte{0, 64, 194}:    "APPLIED COMPUTING DEVICES",
	[3]byte{0, 64, 195}:    "FISCHER AND PORTER CO.",
	[3]byte{0, 64, 196}:    "KINKEI SYSTEM CORPORATION",
	[3]byte{0, 64, 197}:    "MICOM COMMUNICATIONS INC.",
	[3]byte{0, 64, 198}:    "FIBERNET RESEARCH, INC.",
	[3]byte{0, 64, 199}:    "RUBY TECH CORPORATION",
	[3]byte{0, 64, 200}:    "MILAN TECHNOLOGY CORPORATION",
	[3]byte{0, 64, 201}:    "NCUBE",
	[3]byte{0, 64, 202}:    "FIRST INTERNAT'L COMPUTER, INC",
	[3]byte{0, 64, 203}:    "LANWAN TECHNOLOGIES",
	[3]byte{0, 64, 204}:    "SILCOM MANUF'G TECHNOLOGY INC.",
	[3]byte{0, 64, 205}:    "TERA MICROSYSTEMS, INC.",
	[3]byte{0, 64, 206}:    "NET-SOURCE, INC.",
	[3]byte{0, 64, 207}:    "STRAWBERRY TREE, INC.",
	[3]byte{0, 64, 208}:    "MITAC INTERNATIONAL CORP.",
	[3]byte{0, 64, 209}:    "FUKUDA DENSHI CO., LTD.",
	[3]byte{0, 64, 210}:    "PAGINE CORPORATION",
	[3]byte{0, 64, 211}:    "KIMPSION INTERNATIONAL CORP.",
	[3]byte{0, 64, 212}:    "GAGE TALKER CORP.",
	[3]byte{0, 64, 213}:    "Sartorius Mechatronics T&H GmbH",
	[3]byte{0, 64, 214}:    "LOCAMATION B.V.",
	[3]byte{0, 64, 215}:    "STUDIO GEN INC.",
	[3]byte{0, 64, 216}:    "OCEAN OFFICE AUTOMATION LTD.",
	[3]byte{0, 64, 217}:    "AMERICAN MEGATRENDS INC.",
	[3]byte{0, 64, 218}:    "TELSPEC LTD",
	[3]byte{0, 64, 219}:    "ADVANCED TECHNICAL SOLUTIONS",
	[3]byte{0, 64, 220}:    "TRITEC ELECTRONIC GMBH",
	[3]byte{0, 64, 221}:    "HONG TECHNOLOGIES",
	[3]byte{0, 64, 222}:    "Elsag Datamat spa",
	[3]byte{0, 64, 223}:    "DIGALOG SYSTEMS, INC.",
	[3]byte{0, 64, 224}:    "ATOMWIDE LTD.",
	[3]byte{0, 64, 225}:    "MARNER INTERNATIONAL, INC.",
	[3]byte{0, 64, 226}:    "MESA RIDGE TECHNOLOGIES, INC.",
	[3]byte{0, 64, 227}:    "QUIN SYSTEMS LTD",
	[3]byte{0, 64, 228}:    "E-M TECHNOLOGY, INC.",
	[3]byte{0, 64, 229}:    "SYBUS CORPORATION",
	[3]byte{0, 64, 230}:    "C.A.E.N.",
	[3]byte{0, 64, 231}:    "ARNOS INSTRUMENTS & COMPUTER",
	[3]byte{0, 64, 232}:    "CHARLES RIVER DATA SYSTEMS,INC",
	[3]byte{0, 64, 233}:    "ACCORD SYSTEMS, INC.",
	[3]byte{0, 64, 234}:    "PLAIN TREE SYSTEMS INC",
	[3]byte{0, 64, 235}:    "MARTIN MARIETTA CORPORATION",
	[3]byte{0, 64, 236}:    "MIKASA SYSTEM ENGINEERING",
	[3]byte{0, 64, 237}:    "NETWORK CONTROLS INT'NATL INC.",
	[3]byte{0, 64, 238}:    "OPTIMEM",
	[3]byte{0, 64, 239}:    "HYPERCOM, INC.",
	[3]byte{0, 64, 240}:    "MicroBrain,Inc.",
	[3]byte{0, 64, 241}:    "CHUO ELECTRONICS CO., LTD.",
	[3]byte{0, 64, 242}:    "JANICH & KLASS COMPUTERTECHNIK",
	[3]byte{0, 64, 243}:    "NETCOR",
	[3]byte{0, 64, 244}:    "CAMEO COMMUNICATIONS, INC.",
	[3]byte{0, 64, 245}:    "OEM ENGINES",
	[3]byte{0, 64, 246}:    "KATRON COMPUTERS INC.",
	[3]byte{0, 64, 247}:    "Polaroid Corporation",
	[3]byte{0, 64, 248}:    "SYSTEMHAUS DISCOM",
	[3]byte{0, 64, 249}:    "COMBINET",
	[3]byte{0, 64, 250}:    "MICROBOARDS, INC.",
	[3]byte{0, 64, 251}:    "CASCADE COMMUNICATIONS CORP.",
	[3]byte{0, 64, 252}:    "IBR COMPUTER TECHNIK GMBH",
	[3]byte{0, 64, 253}:    "LXE",
	[3]byte{0, 64, 254}:    "SYMPLEX COMMUNICATIONS",
	[3]byte{0, 64, 255}:    "TELEBIT CORPORATION",
	[3]byte{0, 65, 180}:    "Wuxi Zhongxing Optoelectronics Technology Co.,Ltd.",
	[3]byte{0, 66, 82}:     "RLX Technologies",
	[3]byte{0, 67, 255}:    "KETRON S.R.L.",
	[3]byte{0, 69, 1}:      "Versus Technology, Inc.",
	[3]byte{0, 70, 75}:     "HUAWEI TECHNOLOGIES CO.,LTD",
	[3]byte{0, 77, 50}:     "Andon Health Co.,Ltd.",
	[3]byte{0, 80, 0}:      "NEXO COMMUNICATIONS, INC.",
	[3]byte{0, 80, 1}:      "YAMASHITA SYSTEMS CORP.",
	[3]byte{0, 80, 2}:      "OMNISEC AG",
	[3]byte{0, 80, 3}:      "Xrite Inc",
	[3]byte{0, 80, 4}:      "3COM CORPORATION",
	[3]byte{0, 80, 6}:      "TAC AB",
	[3]byte{0, 80, 7}:      "SIEMENS TELECOMMUNICATION SYSTEMS LIMITED",
	[3]byte{0, 80, 8}:      "TIVA MICROCOMPUTER CORP. (TMC)",
	[3]byte{0, 80, 9}:      "PHILIPS BROADBAND NETWORKS",
	[3]byte{0, 80, 10}:     "IRIS TECHNOLOGIES, INC.",
	[3]byte{0, 80, 11}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 80, 12}:     "e-Tek Labs, Inc.",
	[3]byte{0, 80, 13}:     "SATORI ELECTORIC CO., LTD.",
	[3]byte{0, 80, 14}:     "CHROMATIS NETWORKS, INC.",
	[3]byte{0, 80, 15}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 80, 16}:     "NovaNET Learning, Inc.",
	[3]byte{0, 80, 18}:     "CBL - GMBH",
	[3]byte{0, 80, 19}:     "Chaparral Network Storage",
	[3]byte{0, 80, 20}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 80, 21}:     "BRIGHT STAR ENGINEERING",
	[3]byte{0, 80, 22}:     "SST/WOODHEAD INDUSTRIES",
	[3]byte{0, 80, 23}:     "RSR S.R.L.",
	[3]byte{0, 80, 24}:     "AMIT, Inc.",
	[3]byte{0, 80, 25}:     "SPRING TIDE NETWORKS, INC.",
	[3]byte{0, 80, 26}:     "IQinVision",
	[3]byte{0, 80, 27}:     "ABL CANADA, INC.",
	[3]byte{0, 80, 28}:     "JATOM SYSTEMS, INC.",
	[3]byte{0, 80, 30}:     "Miranda Technologies, Inc.",
	[3]byte{0, 80, 31}:     "MRG SYSTEMS, LTD.",
	[3]byte{0, 80, 32}:     "MEDIASTAR CO., LTD.",
	[3]byte{0, 80, 33}:     "EIS INTERNATIONAL, INC.",
	[3]byte{0, 80, 34}:     "ZONET TECHNOLOGY, INC.",
	[3]byte{0, 80, 35}:     "PG DESIGN ELECTRONICS, INC.",
	[3]byte{0, 80, 36}:     "NAVIC SYSTEMS, INC.",
	[3]byte{0, 80, 38}:     "COSYSTEMS, INC.",
	[3]byte{0, 80, 39}:     "GENICOM CORPORATION",
	[3]byte{0, 80, 40}:     "AVAL COMMUNICATIONS",
	[3]byte{0, 80, 41}:     "1394 PRINTER WORKING GROUP",
	[3]byte{0, 80, 42}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 80, 43}:     "GENRAD LTD.",
	[3]byte{0, 80, 44}:     "SOYO COMPUTER, INC.",
	[3]byte{0, 80, 45}:     "ACCEL, INC.",
	[3]byte{0, 80, 46}:     "CAMBEX CORPORATION",
	[3]byte{0, 80, 47}:     "TollBridge Technologies, Inc.",
	[3]byte{0, 80, 48}:     "FUTURE PLUS SYSTEMS",
	[3]byte{0, 80, 49}:     "AEROFLEX LABORATORIES, INC.",
	[3]byte{0, 80, 50}:     "PICAZO COMMUNICATIONS, INC.",
	[3]byte{0, 80, 51}:     "MAYAN NETWORKS",
	[3]byte{0, 80, 54}:     "NETCAM, LTD.",
	[3]byte{0, 80, 55}:     "KOGA ELECTRONICS CO.",
	[3]byte{0, 80, 56}:     "DAIN TELECOM CO., LTD.",
	[3]byte{0, 80, 57}:     "MARINER NETWORKS",
	[3]byte{0, 80, 58}:     "DATONG ELECTRONICS LTD.",
	[3]byte{0, 80, 59}:     "MEDIAFIRE CORPORATION",
	[3]byte{0, 80, 60}:     "TSINGHUA NOVEL ELECTRONICS",
	[3]byte{0, 80, 62}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 80, 63}:     "ANCHOR GAMES",
	[3]byte{0, 80, 64}:     "Panasonic Electric Works Co., Ltd.",
	[3]byte{0, 80, 65}:     "Coretronic Corporation",
	[3]byte{0, 80, 66}:     "SCI MANUFACTURING SINGAPORE PTE, LTD.",
	[3]byte{0, 80, 67}:     "MARVELL SEMICONDUCTOR, INC.",
	[3]byte{0, 80, 68}:     "ASACA CORPORATION",
	[3]byte{0, 80, 69}:     "RIOWORKS SOLUTIONS, INC.",
	[3]byte{0, 80, 70}:     "MENICX INTERNATIONAL CO., LTD.",
	[3]byte{0, 80, 71}:     "PRIVATE",
	[3]byte{0, 80, 72}:     "INFOLIBRIA",
	[3]byte{0, 80, 73}:     "Arbor Networks Inc",
	[3]byte{0, 80, 74}:     "ELTECO A.S.",
	[3]byte{0, 80, 75}:     "BARCONET N.V.",
	[3]byte{0, 80, 76}:     "Galil Motion Control",
	[3]byte{0, 80, 77}:     "Tokyo Electron Device Limited",
	[3]byte{0, 80, 78}:     "SIERRA MONITOR CORP.",
	[3]byte{0, 80, 79}:     "OLENCOM ELECTRONICS",
	[3]byte{0, 80, 80}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 80, 81}:     "IWATSU ELECTRIC CO., LTD.",
	[3]byte{0, 80, 82}:     "TIARA NETWORKS, INC.",
	[3]byte{0, 80, 83}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 80, 84}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 80, 85}:     "DOMS A/S",
	[3]byte{0, 80, 86}:     "VMware, Inc.",
	[3]byte{0, 80, 87}:     "BROADBAND ACCESS SYSTEMS",
	[3]byte{0, 80, 88}:     "VegaStream Group Limted",
	[3]byte{0, 80, 89}:     "iBAHN",
	[3]byte{0, 80, 90}:     "NETWORK ALCHEMY, INC.",
	[3]byte{0, 80, 91}:     "KAWASAKI LSI U.S.A., INC.",
	[3]byte{0, 80, 92}:     "TUNDO CORPORATION",
	[3]byte{0, 80, 94}:     "DIGITEK MICROLOGIC S.A.",
	[3]byte{0, 80, 95}:     "BRAND INNOVATORS",
	[3]byte{0, 80, 96}:     "TANDBERG TELECOM AS",
	[3]byte{0, 80, 98}:     "KOUWELL ELECTRONICS CORP.  **",
	[3]byte{0, 80, 99}:     "OY COMSEL SYSTEM AB",
	[3]byte{0, 80, 100}:    "CAE ELECTRONICS",
	[3]byte{0, 80, 101}:    "TDK-Lambda Corporation",
	[3]byte{0, 80, 102}:    "AtecoM GmbH advanced telecomunication modules",
	[3]byte{0, 80, 103}:    "AEROCOMM, INC.",
	[3]byte{0, 80, 104}:    "ELECTRONIC INDUSTRIES ASSOCIATION",
	[3]byte{0, 80, 105}:    "PixStream Incorporated",
	[3]byte{0, 80, 106}:    "EDEVA, INC.",
	[3]byte{0, 80, 107}:    "SPX-ATEG",
	[3]byte{0, 80, 108}:    "Beijer Electronics Products AB",
	[3]byte{0, 80, 109}:    "VIDEOJET SYSTEMS",
	[3]byte{0, 80, 110}:    "CORDER ENGINEERING CORPORATION",
	[3]byte{0, 80, 111}:    "G-CONNECT",
	[3]byte{0, 80, 112}:    "CHAINTECH COMPUTER CO., LTD.",
	[3]byte{0, 80, 113}:    "AIWA CO., LTD.",
	[3]byte{0, 80, 114}:    "CORVIS CORPORATION",
	[3]byte{0, 80, 115}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 80, 116}:    "ADVANCED HI-TECH CORP.",
	[3]byte{0, 80, 117}:    "KESTREL SOLUTIONS",
	[3]byte{0, 80, 118}:    "IBM Corp",
	[3]byte{0, 80, 119}:    "PROLIFIC TECHNOLOGY, INC.",
	[3]byte{0, 80, 120}:    "MEGATON HOUSE, LTD.",
	[3]byte{0, 80, 121}:    "PRIVATE",
	[3]byte{0, 80, 122}:    "XPEED, INC.",
	[3]byte{0, 80, 123}:    "MERLOT COMMUNICATIONS",
	[3]byte{0, 80, 124}:    "VIDEOCON AG",
	[3]byte{0, 80, 125}:    "IFP",
	[3]byte{0, 80, 126}:    "NEWER TECHNOLOGY",
	[3]byte{0, 80, 127}:    "DrayTek Corp.",
	[3]byte{0, 80, 128}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 80, 129}:    "MURATA MACHINERY, LTD.",
	[3]byte{0, 80, 130}:    "FORESSON CORPORATION",
	[3]byte{0, 80, 131}:    "GILBARCO, INC.",
	[3]byte{0, 80, 132}:    "ATL PRODUCTS",
	[3]byte{0, 80, 134}:    "TELKOM SA, LTD.",
	[3]byte{0, 80, 135}:    "TERASAKI ELECTRIC CO., LTD.",
	[3]byte{0, 80, 136}:    "AMANO CORPORATION",
	[3]byte{0, 80, 137}:    "SAFETY MANAGEMENT SYSTEMS",
	[3]byte{0, 80, 139}:    "Hewlett-Packard Company",
	[3]byte{0, 80, 140}:    "RSI SYSTEMS",
	[3]byte{0, 80, 141}:    "ABIT COMPUTER CORPORATION",
	[3]byte{0, 80, 142}:    "OPTIMATION, INC.",
	[3]byte{0, 80, 143}:    "ASITA TECHNOLOGIES INT'L LTD.",
	[3]byte{0, 80, 144}:    "DCTRI",
	[3]byte{0, 80, 145}:    "NETACCESS, INC.",
	[3]byte{0, 80, 146}:    "RIGAKU INDUSTRIAL CORPORATION",
	[3]byte{0, 80, 147}:    "BOEING",
	[3]byte{0, 80, 148}:    "PACE plc",
	[3]byte{0, 80, 149}:    "PERACOM NETWORKS",
	[3]byte{0, 80, 150}:    "SALIX TECHNOLOGIES, INC.",
	[3]byte{0, 80, 151}:    "MMC-EMBEDDED COMPUTERTECHNIK GmbH",
	[3]byte{0, 80, 152}:    "GLOBALOOP, LTD.",
	[3]byte{0, 80, 153}:    "3COM EUROPE, LTD.",
	[3]byte{0, 80, 154}:    "TAG ELECTRONIC SYSTEMS",
	[3]byte{0, 80, 155}:    "SWITCHCORE AB",
	[3]byte{0, 80, 156}:    "BETA RESEARCH",
	[3]byte{0, 80, 157}:    "THE INDUSTREE B.V.",
	[3]byte{0, 80, 158}:    "Les Technologies SoftAcoustik Inc.",
	[3]byte{0, 80, 159}:    "HORIZON COMPUTER",
	[3]byte{0, 80, 160}:    "DELTA COMPUTER SYSTEMS, INC.",
	[3]byte{0, 80, 161}:    "CARLO GAVAZZI, INC.",
	[3]byte{0, 80, 162}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 80, 163}:    "TransMedia Communications, Inc.",
	[3]byte{0, 80, 164}:    "IO TECH, INC.",
	[3]byte{0, 80, 165}:    "CAPITOL BUSINESS SYSTEMS, LTD.",
	[3]byte{0, 80, 166}:    "OPTRONICS",
	[3]byte{0, 80, 167}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 80, 168}:    "OpenCon Systems, Inc.",
	[3]byte{0, 80, 169}:    "MOLDAT WIRELESS TECHNOLGIES",
	[3]byte{0, 80, 170}:    "KONICA MINOLTA HOLDINGS, INC.",
	[3]byte{0, 80, 171}:    "NALTEC, Inc.",
	[3]byte{0, 80, 172}:    "MAPLE COMPUTER CORPORATION",
	[3]byte{0, 80, 173}:    "CommUnique Wireless Corp.",
	[3]byte{0, 80, 174}:    "FDK Co., Ltd",
	[3]byte{0, 80, 175}:    "INTERGON, INC.",
	[3]byte{0, 80, 176}:    "TECHNOLOGY ATLANTA CORPORATION",
	[3]byte{0, 80, 177}:    "GIDDINGS & LEWIS",
	[3]byte{0, 80, 178}:    "BRODEL GmbH",
	[3]byte{0, 80, 179}:    "VOICEBOARD CORPORATION",
	[3]byte{0, 80, 180}:    "SATCHWELL CONTROL SYSTEMS, LTD",
	[3]byte{0, 80, 181}:    "FICHET-BAUCHE",
	[3]byte{0, 80, 182}:    "GOOD WAY IND. CO., LTD.",
	[3]byte{0, 80, 183}:    "BOSER TECHNOLOGY CO., LTD.",
	[3]byte{0, 80, 184}:    "INOVA COMPUTERS GMBH & CO. KG",
	[3]byte{0, 80, 185}:    "XITRON TECHNOLOGIES, INC.",
	[3]byte{0, 80, 186}:    "D-LINK",
	[3]byte{0, 80, 187}:    "CMS TECHNOLOGIES",
	[3]byte{0, 80, 188}:    "HAMMER STORAGE SOLUTIONS",
	[3]byte{0, 80, 189}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 80, 190}:    "FAST MULTIMEDIA AG",
	[3]byte{0, 80, 191}:    "Metalligence Technology Corp.",
	[3]byte{0, 80, 192}:    "GATAN, INC.",
	[3]byte{0, 80, 193}:    "GEMFLEX NETWORKS, LTD.",
	[3]byte{0, 80, 194}:    "IEEE REGISTRATION AUTHORITY  - Please see IAB public listing for more information.",
	[3]byte{0, 80, 196}:    "IMD",
	[3]byte{0, 80, 197}:    "ADS Technologies, Inc",
	[3]byte{0, 80, 198}:    "LOOP TELECOMMUNICATION INTERNATIONAL, INC.",
	[3]byte{0, 80, 200}:    "Addonics Technologies, Inc.",
	[3]byte{0, 80, 201}:    "MASPRO DENKOH CORP.",
	[3]byte{0, 80, 202}:    "NET TO NET TECHNOLOGIES",
	[3]byte{0, 80, 203}:    "JETTER",
	[3]byte{0, 80, 204}:    "XYRATEX",
	[3]byte{0, 80, 205}:    "DIGIANSWER A/S",
	[3]byte{0, 80, 206}:    "LG INTERNATIONAL CORP.",
	[3]byte{0, 80, 207}:    "VANLINK COMMUNICATION TECHNOLOGY RESEARCH INSTITUTE",
	[3]byte{0, 80, 208}:    "MINERVA SYSTEMS",
	[3]byte{0, 80, 209}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 80, 210}:    "CMC Electronics Inc",
	[3]byte{0, 80, 211}:    "DIGITAL AUDIO PROCESSING PTY. LTD.",
	[3]byte{0, 80, 212}:    "JOOHONG INFORMATION &",
	[3]byte{0, 80, 213}:    "AD SYSTEMS CORP.",
	[3]byte{0, 80, 214}:    "ATLAS COPCO TOOLS AB",
	[3]byte{0, 80, 215}:    "TELSTRAT",
	[3]byte{0, 80, 216}:    "UNICORN COMPUTER CORP.",
	[3]byte{0, 80, 217}:    "ENGETRON-ENGENHARIA ELETRONICA IND. e COM. LTDA",
	[3]byte{0, 80, 218}:    "3COM CORPORATION",
	[3]byte{0, 80, 219}:    "CONTEMPORARY CONTROL",
	[3]byte{0, 80, 220}:    "TAS TELEFONBAU A. SCHWABE GMBH & CO. KG",
	[3]byte{0, 80, 221}:    "SERRA SOLDADURA, S.A.",
	[3]byte{0, 80, 222}:    "SIGNUM SYSTEMS CORP.",
	[3]byte{0, 80, 223}:    "AirFiber, Inc.",
	[3]byte{0, 80, 225}:    "NS TECH ELECTRONICS SDN BHD",
	[3]byte{0, 80, 226}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 80, 227}:    "ARRIS Group, Inc.",
	[3]byte{0, 80, 228}:    "Apple",
	[3]byte{0, 80, 230}:    "HAKUSAN CORPORATION",
	[3]byte{0, 80, 231}:    "PARADISE INNOVATIONS (ASIA)",
	[3]byte{0, 80, 232}:    "NOMADIX INC.",
	[3]byte{0, 80, 234}:    "XEL COMMUNICATIONS, INC.",
	[3]byte{0, 80, 235}:    "ALPHA-TOP CORPORATION",
	[3]byte{0, 80, 236}:    "OLICOM A/S",
	[3]byte{0, 80, 237}:    "ANDA NETWORKS",
	[3]byte{0, 80, 238}:    "TEK DIGITEL CORPORATION",
	[3]byte{0, 80, 239}:    "SPE Systemhaus GmbH",
	[3]byte{0, 80, 240}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 80, 241}:    "Intel Corporation",
	[3]byte{0, 80, 242}:    "MICROSOFT CORP.",
	[3]byte{0, 80, 243}:    "GLOBAL NET INFORMATION CO., Ltd.",
	[3]byte{0, 80, 244}:    "SIGMATEK GMBH & CO. KG",
	[3]byte{0, 80, 246}:    "PAN-INTERNATIONAL INDUSTRIAL CORP.",
	[3]byte{0, 80, 247}:    "VENTURE MANUFACTURING (SINGAPORE) LTD.",
	[3]byte{0, 80, 248}:    "ENTREGA TECHNOLOGIES, INC.",
	[3]byte{0, 80, 249}:    "Sensormatic Electronics LLC",
	[3]byte{0, 80, 250}:    "OXTEL, LTD.",
	[3]byte{0, 80, 251}:    "VSK ELECTRONICS",
	[3]byte{0, 80, 252}:    "EDIMAX TECHNOLOGY CO., LTD.",
	[3]byte{0, 80, 253}:    "VISIONCOMM CO., LTD.",
	[3]byte{0, 80, 254}:    "PCTVnet ASA",
	[3]byte{0, 80, 255}:    "HAKKO ELECTRONICS CO., LTD.",
	[3]byte{0, 82, 24}:     "Wuxi Keboda Electron Co.Ltd",
	[3]byte{0, 84, 175}:    "Continental Automotive Systems Inc.",
	[3]byte{0, 89, 7}:      "LenovoEMC Products USA, LLC",
	[3]byte{0, 90, 57}:     "SHENZHEN FAST TECHNOLOGIES CO., LTD.",
	[3]byte{0, 92, 177}:    "Gospell DIGITAL TECHNOLOGY CO., LTD",
	[3]byte{0, 93, 3}:      "Xilinx, Inc",
	[3]byte{0, 96, 0}:      "XYCOM INC.",
	[3]byte{0, 96, 1}:      "InnoSys, Inc.",
	[3]byte{0, 96, 2}:      "SCREEN SUBTITLING SYSTEMS, LTD",
	[3]byte{0, 96, 3}:      "TERAOKA WEIGH SYSTEM PTE, LTD.",
	[3]byte{0, 96, 4}:      "COMPUTADORES MODULARES SA",
	[3]byte{0, 96, 5}:      "FEEDBACK DATA LTD.",
	[3]byte{0, 96, 6}:      "SOTEC CO., LTD",
	[3]byte{0, 96, 7}:      "ACRES GAMING, INC.",
	[3]byte{0, 96, 8}:      "3COM CORPORATION",
	[3]byte{0, 96, 9}:      "CISCO SYSTEMS, INC.",
	[3]byte{0, 96, 10}:     "SORD COMPUTER CORPORATION",
	[3]byte{0, 96, 11}:     "LOGWARE GmbH",
	[3]byte{0, 96, 12}:     "Eurotech Inc.",
	[3]byte{0, 96, 13}:     "Digital Logic GmbH",
	[3]byte{0, 96, 14}:     "WAVENET INTERNATIONAL, INC.",
	[3]byte{0, 96, 15}:     "WESTELL, INC.",
	[3]byte{0, 96, 16}:     "NETWORK MACHINES, INC.",
	[3]byte{0, 96, 17}:     "CRYSTAL SEMICONDUCTOR CORP.",
	[3]byte{0, 96, 18}:     "POWER COMPUTING CORPORATION",
	[3]byte{0, 96, 19}:     "NETSTAL MASCHINEN AG",
	[3]byte{0, 96, 20}:     "EDEC CO., LTD.",
	[3]byte{0, 96, 21}:     "NET2NET CORPORATION",
	[3]byte{0, 96, 22}:     "CLARIION",
	[3]byte{0, 96, 23}:     "TOKIMEC INC.",
	[3]byte{0, 96, 24}:     "STELLAR ONE CORPORATION",
	[3]byte{0, 96, 25}:     "Roche Diagnostics",
	[3]byte{0, 96, 26}:     "KEITHLEY INSTRUMENTS",
	[3]byte{0, 96, 27}:     "MESA ELECTRONICS",
	[3]byte{0, 96, 28}:     "TELXON CORPORATION",
	[3]byte{0, 96, 29}:     "LUCENT TECHNOLOGIES",
	[3]byte{0, 96, 30}:     "SOFTLAB, INC.",
	[3]byte{0, 96, 31}:     "STALLION TECHNOLOGIES",
	[3]byte{0, 96, 32}:     "PIVOTAL NETWORKING, INC.",
	[3]byte{0, 96, 33}:     "DSC CORPORATION",
	[3]byte{0, 96, 34}:     "VICOM SYSTEMS, INC.",
	[3]byte{0, 96, 35}:     "PERICOM SEMICONDUCTOR CORP.",
	[3]byte{0, 96, 36}:     "GRADIENT TECHNOLOGIES, INC.",
	[3]byte{0, 96, 37}:     "ACTIVE IMAGING PLC",
	[3]byte{0, 96, 38}:     "VIKING Modular Solutions",
	[3]byte{0, 96, 39}:     "Superior Modular Products",
	[3]byte{0, 96, 40}:     "MACROVISION CORPORATION",
	[3]byte{0, 96, 41}:     "CARY PERIPHERALS INC.",
	[3]byte{0, 96, 42}:     "SYMICRON COMPUTER COMMUNICATIONS, LTD.",
	[3]byte{0, 96, 43}:     "PEAK AUDIO",
	[3]byte{0, 96, 44}:     "LINX Data Terminals, Inc.",
	[3]byte{0, 96, 45}:     "ALERTON TECHNOLOGIES, INC.",
	[3]byte{0, 96, 46}:     "CYCLADES CORPORATION",
	[3]byte{0, 96, 47}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 96, 48}:     "VILLAGE TRONIC ENTWICKLUNG",
	[3]byte{0, 96, 49}:     "HRK SYSTEMS",
	[3]byte{0, 96, 50}:     "I-CUBE, INC.",
	[3]byte{0, 96, 51}:     "ACUITY IMAGING, INC.",
	[3]byte{0, 96, 52}:     "ROBERT BOSCH GmbH",
	[3]byte{0, 96, 53}:     "DALLAS SEMICONDUCTOR, INC.",
	[3]byte{0, 96, 54}:     "AIT Austrian Institute of Technology GmbH",
	[3]byte{0, 96, 55}:     "NXP Semiconductors",
	[3]byte{0, 96, 56}:     "Nortel Networks",
	[3]byte{0, 96, 57}:     "SanCom Technology, Inc.",
	[3]byte{0, 96, 58}:     "QUICK CONTROLS LTD.",
	[3]byte{0, 96, 59}:     "AMTEC spa",
	[3]byte{0, 96, 60}:     "HAGIWARA SYS-COM CO., LTD.",
	[3]byte{0, 96, 61}:     "3CX",
	[3]byte{0, 96, 62}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 96, 63}:     "PATAPSCO DESIGNS",
	[3]byte{0, 96, 64}:     "NETRO CORP.",
	[3]byte{0, 96, 65}:     "Yokogawa Electric Corporation",
	[3]byte{0, 96, 66}:     "TKS (USA), INC.",
	[3]byte{0, 96, 67}:     "iDirect, INC.",
	[3]byte{0, 96, 68}:     "LITTON/POLY-SCIENTIFIC",
	[3]byte{0, 96, 69}:     "PATHLIGHT TECHNOLOGIES",
	[3]byte{0, 96, 70}:     "VMETRO, INC.",
	[3]byte{0, 96, 71}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 96, 72}:     "EMC CORPORATION",
	[3]byte{0, 96, 73}:     "VINA TECHNOLOGIES",
	[3]byte{0, 96, 74}:     "SAIC IDEAS GROUP",
	[3]byte{0, 96, 75}:     "Safe-com GmbH & Co. KG",
	[3]byte{0, 96, 76}:     "SAGEM COMMUNICATION",
	[3]byte{0, 96, 77}:     "MMC NETWORKS, INC.",
	[3]byte{0, 96, 78}:     "CYCLE COMPUTER CORPORATION, INC.",
	[3]byte{0, 96, 79}:     "Tattile SRL",
	[3]byte{0, 96, 80}:     "INTERNIX INC.",
	[3]byte{0, 96, 81}:     "QUALITY SEMICONDUCTOR",
	[3]byte{0, 96, 82}:     "PERIPHERALS ENTERPRISE CO., Ltd.",
	[3]byte{0, 96, 83}:     "TOYODA MACHINE WORKS, LTD.",
	[3]byte{0, 96, 84}:     "CONTROLWARE GMBH",
	[3]byte{0, 96, 85}:     "CORNELL UNIVERSITY",
	[3]byte{0, 96, 86}:     "NETWORK TOOLS, INC.",
	[3]byte{0, 96, 87}:     "MURATA MANUFACTURING CO., LTD.",
	[3]byte{0, 96, 88}:     "COPPER MOUNTAIN COMMUNICATIONS, INC.",
	[3]byte{0, 96, 89}:     "TECHNICAL COMMUNICATIONS CORP.",
	[3]byte{0, 96, 90}:     "CELCORE, INC.",
	[3]byte{0, 96, 91}:     "IntraServer Technology, Inc.",
	[3]byte{0, 96, 92}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 96, 93}:     "SCANIVALVE CORP.",
	[3]byte{0, 96, 94}:     "LIBERTY TECHNOLOGY NETWORKING",
	[3]byte{0, 96, 95}:     "NIPPON UNISOFT CORPORATION",
	[3]byte{0, 96, 96}:     "Data Innovations North America",
	[3]byte{0, 96, 97}:     "WHISTLE COMMUNICATIONS CORP.",
	[3]byte{0, 96, 98}:     "TELESYNC, INC.",
	[3]byte{0, 96, 99}:     "PSION DACOM PLC.",
	[3]byte{0, 96, 100}:    "NETCOMM LIMITED",
	[3]byte{0, 96, 101}:    "BERNECKER & RAINER INDUSTRIE-ELEKTRONIC GmbH",
	[3]byte{0, 96, 102}:    "LACROIX Trafic",
	[3]byte{0, 96, 103}:    "ACER NETXUS INC.",
	[3]byte{0, 96, 104}:    "Dialogic Corporation",
	[3]byte{0, 96, 105}:    "Brocade Communications Systems, Inc.",
	[3]byte{0, 96, 106}:    "MITSUBISHI WIRELESS COMMUNICATIONS. INC.",
	[3]byte{0, 96, 107}:    "Synclayer Inc.",
	[3]byte{0, 96, 108}:    "ARESCOM",
	[3]byte{0, 96, 109}:    "DIGITAL EQUIPMENT CORP.",
	[3]byte{0, 96, 110}:    "DAVICOM SEMICONDUCTOR, INC.",
	[3]byte{0, 96, 111}:    "CLARION CORPORATION OF AMERICA",
	[3]byte{0, 96, 112}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 96, 113}:    "MIDAS LAB, INC.",
	[3]byte{0, 96, 114}:    "VXL INSTRUMENTS, LIMITED",
	[3]byte{0, 96, 115}:    "REDCREEK COMMUNICATIONS, INC.",
	[3]byte{0, 96, 116}:    "QSC AUDIO PRODUCTS",
	[3]byte{0, 96, 117}:    "PENTEK, INC.",
	[3]byte{0, 96, 118}:    "SCHLUMBERGER TECHNOLOGIES RETAIL PETROLEUM SYSTEMS",
	[3]byte{0, 96, 119}:    "PRISA NETWORKS",
	[3]byte{0, 96, 120}:    "POWER MEASUREMENT LTD.",
	[3]byte{0, 96, 121}:    "Mainstream Data, Inc.",
	[3]byte{0, 96, 122}:    "DVS GmbH",
	[3]byte{0, 96, 123}:    "FORE SYSTEMS, INC.",
	[3]byte{0, 96, 124}:    "WaveAccess, Ltd.",
	[3]byte{0, 96, 125}:    "SENTIENT NETWORKS INC.",
	[3]byte{0, 96, 126}:    "GIGALABS, INC.",
	[3]byte{0, 96, 127}:    "AURORA TECHNOLOGIES, INC.",
	[3]byte{0, 96, 128}:    "MICROTRONIX DATACOM LTD.",
	[3]byte{0, 96, 129}:    "TV/COM INTERNATIONAL",
	[3]byte{0, 96, 130}:    "NOVALINK TECHNOLOGIES, INC.",
	[3]byte{0, 96, 131}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 96, 132}:    "DIGITAL VIDEO",
	[3]byte{0, 96, 133}:    "Storage Concepts",
	[3]byte{0, 96, 134}:    "LOGIC REPLACEMENT TECH. LTD.",
	[3]byte{0, 96, 135}:    "KANSAI ELECTRIC CO., LTD.",
	[3]byte{0, 96, 136}:    "WHITE MOUNTAIN DSP, INC.",
	[3]byte{0, 96, 137}:    "XATA",
	[3]byte{0, 96, 138}:    "CITADEL COMPUTER",
	[3]byte{0, 96, 139}:    "ConferTech International",
	[3]byte{0, 96, 140}:    "3COM CORPORATION",
	[3]byte{0, 96, 141}:    "UNIPULSE CORP.",
	[3]byte{0, 96, 142}:    "HE ELECTRONICS, TECHNOLOGIE & SYSTEMTECHNIK GmbH",
	[3]byte{0, 96, 143}:    "TEKRAM TECHNOLOGY CO., LTD.",
	[3]byte{0, 96, 144}:    "Artiza Networks Inc",
	[3]byte{0, 96, 145}:    "FIRST PACIFIC NETWORKS, INC.",
	[3]byte{0, 96, 146}:    "MICRO/SYS, INC.",
	[3]byte{0, 96, 147}:    "VARIAN",
	[3]byte{0, 96, 148}:    "IBM Corp",
	[3]byte{0, 96, 149}:    "ACCU-TIME SYSTEMS, INC.",
	[3]byte{0, 96, 150}:    "T.S. MICROTECH INC.",
	[3]byte{0, 96, 151}:    "3COM CORPORATION",
	[3]byte{0, 96, 152}:    "HT COMMUNICATIONS",
	[3]byte{0, 96, 153}:    "SBE, Inc.",
	[3]byte{0, 96, 154}:    "NJK TECHNO CO.",
	[3]byte{0, 96, 155}:    "ASTRO-MED, INC.",
	[3]byte{0, 96, 156}:    "Perkin-Elmer Incorporated",
	[3]byte{0, 96, 157}:    "PMI FOOD EQUIPMENT GROUP",
	[3]byte{0, 96, 158}:    "ASC X3 - INFORMATION TECHNOLOGY STANDARDS SECRETARIATS",
	[3]byte{0, 96, 159}:    "PHAST CORPORATION",
	[3]byte{0, 96, 160}:    "SWITCHED NETWORK TECHNOLOGIES, INC.",
	[3]byte{0, 96, 161}:    "VPNet, Inc.",
	[3]byte{0, 96, 162}:    "NIHON UNISYS LIMITED CO.",
	[3]byte{0, 96, 163}:    "CONTINUUM TECHNOLOGY CORP.",
	[3]byte{0, 96, 164}:    "GEW Technologies (PTY)Ltd",
	[3]byte{0, 96, 165}:    "PERFORMANCE TELECOM CORP.",
	[3]byte{0, 96, 166}:    "PARTICLE MEASURING SYSTEMS",
	[3]byte{0, 96, 167}:    "MICROSENS GmbH & CO. KG",
	[3]byte{0, 96, 168}:    "TIDOMAT AB",
	[3]byte{0, 96, 169}:    "GESYTEC MbH",
	[3]byte{0, 96, 170}:    "INTELLIGENT DEVICES INC. (IDI)",
	[3]byte{0, 96, 171}:    "LARSCOM INCORPORATED",
	[3]byte{0, 96, 172}:    "RESILIENCE CORPORATION",
	[3]byte{0, 96, 173}:    "MegaChips Corporation",
	[3]byte{0, 96, 174}:    "TRIO INFORMATION SYSTEMS AB",
	[3]byte{0, 96, 175}:    "PACIFIC MICRO DATA, INC.",
	[3]byte{0, 96, 176}:    "HEWLETT-PACKARD CO.",
	[3]byte{0, 96, 177}:    "INPUT/OUTPUT, INC.",
	[3]byte{0, 96, 178}:    "PROCESS CONTROL CORP.",
	[3]byte{0, 96, 179}:    "Z-COM, INC.",
	[3]byte{0, 96, 180}:    "GLENAYRE R&D INC.",
	[3]byte{0, 96, 181}:    "KEBA GmbH",
	[3]byte{0, 96, 182}:    "LAND COMPUTER CO., LTD.",
	[3]byte{0, 96, 183}:    "CHANNELMATIC, INC.",
	[3]byte{0, 96, 184}:    "CORELIS Inc.",
	[3]byte{0, 96, 185}:    "NEC Platforms, Ltd",
	[3]byte{0, 96, 186}:    "SAHARA NETWORKS, INC.",
	[3]byte{0, 96, 187}:    "CABLETRON - NETLINK, INC.",
	[3]byte{0, 96, 188}:    "KeunYoung Electronics & Communication Co., Ltd.",
	[3]byte{0, 96, 189}:    "HUBBELL-PULSECOM",
	[3]byte{0, 96, 190}:    "WEBTRONICS",
	[3]byte{0, 96, 191}:    "MACRAIGOR SYSTEMS, INC.",
	[3]byte{0, 96, 192}:    "Nera Networks AS",
	[3]byte{0, 96, 193}:    "WaveSpan Corporation",
	[3]byte{0, 96, 194}:    "MPL AG",
	[3]byte{0, 96, 195}:    "NETVISION CORPORATION",
	[3]byte{0, 96, 196}:    "SOLITON SYSTEMS K.K.",
	[3]byte{0, 96, 197}:    "ANCOT CORP.",
	[3]byte{0, 96, 198}:    "DCS AG",
	[3]byte{0, 96, 199}:    "AMATI COMMUNICATIONS CORP.",
	[3]byte{0, 96, 200}:    "KUKA WELDING SYSTEMS & ROBOTS",
	[3]byte{0, 96, 201}:    "ControlNet, Inc.",
	[3]byte{0, 96, 202}:    "HARMONIC SYSTEMS INCORPORATED",
	[3]byte{0, 96, 203}:    "HITACHI ZOSEN CORPORATION",
	[3]byte{0, 96, 204}:    "EMTRAK, INCORPORATED",
	[3]byte{0, 96, 205}:    "VideoServer, Inc.",
	[3]byte{0, 96, 206}:    "ACCLAIM COMMUNICATIONS",
	[3]byte{0, 96, 207}:    "ALTEON NETWORKS, INC.",
	[3]byte{0, 96, 208}:    "SNMP RESEARCH INCORPORATED",
	[3]byte{0, 96, 209}:    "CASCADE COMMUNICATIONS",
	[3]byte{0, 96, 210}:    "LUCENT TECHNOLOGIES TAIWAN TELECOMMUNICATIONS CO., LTD.",
	[3]byte{0, 96, 211}:    "AT&T",
	[3]byte{0, 96, 212}:    "ELDAT COMMUNICATION LTD.",
	[3]byte{0, 96, 213}:    "MIYACHI TECHNOS CORP.",
	[3]byte{0, 96, 214}:    "NovAtel Wireless Technologies Ltd.",
	[3]byte{0, 96, 215}:    "ECOLE POLYTECHNIQUE FEDERALE DE LAUSANNE (EPFL)",
	[3]byte{0, 96, 216}:    "ELMIC SYSTEMS, INC.",
	[3]byte{0, 96, 217}:    "TRANSYS NETWORKS INC.",
	[3]byte{0, 96, 218}:    "JBM ELECTRONICS CO.",
	[3]byte{0, 96, 219}:    "NTP ELEKTRONIK A/S",
	[3]byte{0, 96, 220}:    "Toyo Network Systems  & System Integration Co. LTD",
	[3]byte{0, 96, 221}:    "MYRICOM, INC.",
	[3]byte{0, 96, 222}:    "Kayser-Threde GmbH",
	[3]byte{0, 96, 223}:    "Brocade Communications Systems, Inc.",
	[3]byte{0, 96, 224}:    "AXIOM TECHNOLOGY CO., LTD.",
	[3]byte{0, 96, 225}:    "ORCKIT COMMUNICATIONS LTD.",
	[3]byte{0, 96, 226}:    "QUEST ENGINEERING & DEVELOPMENT",
	[3]byte{0, 96, 227}:    "ARBIN INSTRUMENTS",
	[3]byte{0, 96, 228}:    "COMPUSERVE, INC.",
	[3]byte{0, 96, 229}:    "FUJI AUTOMATION CO., LTD.",
	[3]byte{0, 96, 230}:    "SHOMITI SYSTEMS INCORPORATED",
	[3]byte{0, 96, 231}:    "RANDATA",
	[3]byte{0, 96, 232}:    "HITACHI COMPUTER PRODUCTS (AMERICA), INC.",
	[3]byte{0, 96, 233}:    "ATOP TECHNOLOGIES, INC.",
	[3]byte{0, 96, 234}:    "StreamLogic",
	[3]byte{0, 96, 235}:    "FOURTHTRACK SYSTEMS",
	[3]byte{0, 96, 236}:    "HERMARY OPTO ELECTRONICS INC.",
	[3]byte{0, 96, 237}:    "RICARDO TEST AUTOMATION LTD.",
	[3]byte{0, 96, 238}:    "APOLLO",
	[3]byte{0, 96, 239}:    "FLYTECH TECHNOLOGY CO., LTD.",
	[3]byte{0, 96, 240}:    "JOHNSON & JOHNSON MEDICAL, INC",
	[3]byte{0, 96, 241}:    "EXP COMPUTER, INC.",
	[3]byte{0, 96, 242}:    "LASERGRAPHICS, INC.",
	[3]byte{0, 96, 243}:    "Performance Analysis Broadband, Spirent plc",
	[3]byte{0, 96, 244}:    "ADVANCED COMPUTER SOLUTIONS, Inc.",
	[3]byte{0, 96, 245}:    "ICON WEST, INC.",
	[3]byte{0, 96, 246}:    "NEXTEST COMMUNICATIONS PRODUCTS, INC.",
	[3]byte{0, 96, 247}:    "DATAFUSION SYSTEMS",
	[3]byte{0, 96, 248}:    "Loran International Technologies Inc.",
	[3]byte{0, 96, 249}:    "DIAMOND LANE COMMUNICATIONS",
	[3]byte{0, 96, 250}:    "EDUCATIONAL TECHNOLOGY RESOURCES, INC.",
	[3]byte{0, 96, 251}:    "PACKETEER, INC.",
	[3]byte{0, 96, 252}:    "CONSERVATION THROUGH INNOVATION LTD.",
	[3]byte{0, 96, 253}:    "NetICs, Inc.",
	[3]byte{0, 96, 254}:    "LYNX SYSTEM DEVELOPERS, INC.",
	[3]byte{0, 96, 255}:    "QuVis, Inc.",
	[3]byte{0, 97, 113}:    "Apple",
	[3]byte{0, 100, 64}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 100, 166}:   "Maquet CardioVascular",
	[3]byte{0, 102, 75}:    "Huawei Technologies Co., Ltd",
	[3]byte{0, 107, 142}:   "Shanghai Feixun Communication Co.,Ltd.",
	[3]byte{0, 107, 158}:   "VIZIO Inc",
	[3]byte{0, 107, 160}:   "SHENZHEN UNIVERSAL INTELLISYS PTE LTD",
	[3]byte{0, 109, 251}:   "Vutrix (UK) Ltd",
	[3]byte{0, 112, 176}:   "M/A-COM INC. COMPANIES",
	[3]byte{0, 112, 179}:   "DATA RECALL LTD.",
	[3]byte{0, 113, 204}:   "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{0, 115, 141}:   "Tinno Mobile Technology Corp",
	[3]byte{0, 115, 224}:   "Samsung Electronics Co.,Ltd",
	[3]byte{0, 117, 50}:    "INID BV",
	[3]byte{0, 117, 225}:   "Ampt, LLC",
	[3]byte{0, 120, 158}:   "SAGEMCOM",
	[3]byte{0, 125, 250}:   "Volkswagen Group of America",
	[3]byte{0, 127, 40}:    "Actiontec Electronics, Inc",
	[3]byte{0, 128, 0}:     "MULTITECH SYSTEMS, INC.",
	[3]byte{0, 128, 1}:     "PERIPHONICS CORPORATION",
	[3]byte{0, 128, 2}:     "SATELCOM (UK) LTD",
	[3]byte{0, 128, 3}:     "HYTEC ELECTRONICS LTD.",
	[3]byte{0, 128, 4}:     "ANTLOW COMMUNICATIONS, LTD.",
	[3]byte{0, 128, 5}:     "CACTUS COMPUTER INC.",
	[3]byte{0, 128, 6}:     "COMPUADD CORPORATION",
	[3]byte{0, 128, 7}:     "DLOG NC-SYSTEME",
	[3]byte{0, 128, 8}:     "DYNATECH COMPUTER SYSTEMS",
	[3]byte{0, 128, 9}:     "JUPITER SYSTEMS, INC.",
	[3]byte{0, 128, 10}:    "JAPAN COMPUTER CORP.",
	[3]byte{0, 128, 11}:    "CSK CORPORATION",
	[3]byte{0, 128, 12}:    "VIDECOM LIMITED",
	[3]byte{0, 128, 13}:    "VOSSWINKEL F.U.",
	[3]byte{0, 128, 14}:    "ATLANTIX CORPORATION",
	[3]byte{0, 128, 15}:    "STANDARD MICROSYSTEMS",
	[3]byte{0, 128, 16}:    "COMMODORE INTERNATIONAL",
	[3]byte{0, 128, 17}:    "DIGITAL SYSTEMS INT'L. INC.",
	[3]byte{0, 128, 18}:    "INTEGRATED MEASUREMENT SYSTEMS",
	[3]byte{0, 128, 19}:    "THOMAS-CONRAD CORPORATION",
	[3]byte{0, 128, 20}:    "ESPRIT SYSTEMS",
	[3]byte{0, 128, 21}:    "SEIKO SYSTEMS, INC.",
	[3]byte{0, 128, 22}:    "WANDEL AND GOLTERMANN",
	[3]byte{0, 128, 23}:    "PFU LIMITED",
	[3]byte{0, 128, 24}:    "KOBE STEEL, LTD.",
	[3]byte{0, 128, 25}:    "DAYNA COMMUNICATIONS, INC.",
	[3]byte{0, 128, 26}:    "BELL ATLANTIC",
	[3]byte{0, 128, 27}:    "KODIAK TECHNOLOGY",
	[3]byte{0, 128, 28}:    "NEWPORT SYSTEMS SOLUTIONS",
	[3]byte{0, 128, 29}:    "INTEGRATED INFERENCE MACHINES",
	[3]byte{0, 128, 30}:    "XINETRON, INC.",
	[3]byte{0, 128, 31}:    "KRUPP ATLAS ELECTRONIK GMBH",
	[3]byte{0, 128, 32}:    "NETWORK PRODUCTS",
	[3]byte{0, 128, 33}:    "Alcatel Canada Inc.",
	[3]byte{0, 128, 34}:    "SCAN-OPTICS",
	[3]byte{0, 128, 35}:    "INTEGRATED BUSINESS NETWORKS",
	[3]byte{0, 128, 36}:    "KALPANA, INC.",
	[3]byte{0, 128, 37}:    "STOLLMANN GMBH",
	[3]byte{0, 128, 38}:    "NETWORK PRODUCTS CORPORATION",
	[3]byte{0, 128, 39}:    "ADAPTIVE SYSTEMS, INC.",
	[3]byte{0, 128, 40}:    "TRADPOST (HK) LTD",
	[3]byte{0, 128, 41}:    "EAGLE TECHNOLOGY, INC.",
	[3]byte{0, 128, 42}:    "TEST SYSTEMS & SIMULATIONS INC",
	[3]byte{0, 128, 43}:    "INTEGRATED MARKETING CO",
	[3]byte{0, 128, 44}:    "THE SAGE GROUP PLC",
	[3]byte{0, 128, 45}:    "XYLOGICS INC",
	[3]byte{0, 128, 46}:    "CASTLE ROCK COMPUTING",
	[3]byte{0, 128, 47}:    "NATIONAL INSTRUMENTS CORP.",
	[3]byte{0, 128, 48}:    "NEXUS ELECTRONICS",
	[3]byte{0, 128, 49}:    "BASYS, CORP.",
	[3]byte{0, 128, 50}:    "ACCESS CO., LTD.",
	[3]byte{0, 128, 51}:    "EMS Aviation, Inc.",
	[3]byte{0, 128, 52}:    "SMT GOUPIL",
	[3]byte{0, 128, 53}:    "TECHNOLOGY WORKS, INC.",
	[3]byte{0, 128, 54}:    "REFLEX MANUFACTURING SYSTEMS",
	[3]byte{0, 128, 55}:    "Ericsson Group",
	[3]byte{0, 128, 56}:    "DATA RESEARCH & APPLICATIONS",
	[3]byte{0, 128, 57}:    "ALCATEL STC AUSTRALIA",
	[3]byte{0, 128, 58}:    "VARITYPER, INC.",
	[3]byte{0, 128, 59}:    "APT COMMUNICATIONS, INC.",
	[3]byte{0, 128, 60}:    "TVS ELECTRONICS LTD",
	[3]byte{0, 128, 61}:    "SURIGIKEN CO.,  LTD.",
	[3]byte{0, 128, 62}:    "SYNERNETICS",
	[3]byte{0, 128, 63}:    "TATUNG COMPANY",
	[3]byte{0, 128, 64}:    "JOHN FLUKE MANUFACTURING CO.",
	[3]byte{0, 128, 65}:    "VEB KOMBINAT ROBOTRON",
	[3]byte{0, 128, 66}:    "Artesyn Embedded Technologies",
	[3]byte{0, 128, 67}:    "NETWORLD, INC.",
	[3]byte{0, 128, 68}:    "SYSTECH COMPUTER CORP.",
	[3]byte{0, 128, 69}:    "MATSUSHITA ELECTRIC IND. CO",
	[3]byte{0, 128, 70}:    "Tattile SRL",
	[3]byte{0, 128, 71}:    "IN-NET CORP.",
	[3]byte{0, 128, 72}:    "COMPEX INCORPORATED",
	[3]byte{0, 128, 73}:    "NISSIN ELECTRIC CO., LTD.",
	[3]byte{0, 128, 74}:    "PRO-LOG",
	[3]byte{0, 128, 75}:    "EAGLE TECHNOLOGIES PTY.LTD.",
	[3]byte{0, 128, 76}:    "CONTEC CO., LTD.",
	[3]byte{0, 128, 77}:    "CYCLONE MICROSYSTEMS, INC.",
	[3]byte{0, 128, 78}:    "APEX COMPUTER COMPANY",
	[3]byte{0, 128, 79}:    "DAIKIN INDUSTRIES, LTD.",
	[3]byte{0, 128, 80}:    "ZIATECH CORPORATION",
	[3]byte{0, 128, 81}:    "FIBERMUX",
	[3]byte{0, 128, 82}:    "TECHNICALLY ELITE CONCEPTS",
	[3]byte{0, 128, 83}:    "INTELLICOM, INC.",
	[3]byte{0, 128, 84}:    "FRONTIER TECHNOLOGIES CORP.",
	[3]byte{0, 128, 85}:    "FERMILAB",
	[3]byte{0, 128, 86}:    "SPHINX ELEKTRONIK GMBH",
	[3]byte{0, 128, 87}:    "ADSOFT, LTD.",
	[3]byte{0, 128, 88}:    "PRINTER SYSTEMS CORPORATION",
	[3]byte{0, 128, 89}:    "STANLEY ELECTRIC CO., LTD",
	[3]byte{0, 128, 90}:    "TULIP COMPUTERS INTERNAT'L B.V",
	[3]byte{0, 128, 91}:    "CONDOR SYSTEMS, INC.",
	[3]byte{0, 128, 92}:    "AGILIS CORPORATION",
	[3]byte{0, 128, 93}:    "CANSTAR",
	[3]byte{0, 128, 94}:    "LSI LOGIC CORPORATION",
	[3]byte{0, 128, 95}:    "Hewlett-Packard Company",
	[3]byte{0, 128, 96}:    "NETWORK INTERFACE CORPORATION",
	[3]byte{0, 128, 97}:    "LITTON SYSTEMS, INC.",
	[3]byte{0, 128, 98}:    "INTERFACE  CO.",
	[3]byte{0, 128, 99}:    "Hirschmann Automation and Control GmbH",
	[3]byte{0, 128, 100}:   "WYSE TECHNOLOGY LLC",
	[3]byte{0, 128, 101}:   "CYBERGRAPHIC SYSTEMS PTY LTD.",
	[3]byte{0, 128, 102}:   "ARCOM CONTROL SYSTEMS, LTD.",
	[3]byte{0, 128, 103}:   "SQUARE D COMPANY",
	[3]byte{0, 128, 104}:   "YAMATECH SCIENTIFIC LTD.",
	[3]byte{0, 128, 105}:   "COMPUTONE SYSTEMS",
	[3]byte{0, 128, 106}:   "ERI (EMPAC RESEARCH INC.)",
	[3]byte{0, 128, 107}:   "SCHMID TELECOMMUNICATION",
	[3]byte{0, 128, 108}:   "CEGELEC PROJECTS LTD",
	[3]byte{0, 128, 109}:   "CENTURY SYSTEMS CORP.",
	[3]byte{0, 128, 110}:   "NIPPON STEEL CORPORATION",
	[3]byte{0, 128, 111}:   "ONELAN LTD.",
	[3]byte{0, 128, 112}:   "COMPUTADORAS MICRON",
	[3]byte{0, 128, 113}:   "SAI TECHNOLOGY",
	[3]byte{0, 128, 114}:   "MICROPLEX SYSTEMS LTD.",
	[3]byte{0, 128, 115}:   "DWB ASSOCIATES",
	[3]byte{0, 128, 116}:   "FISHER CONTROLS",
	[3]byte{0, 128, 117}:   "PARSYTEC GMBH",
	[3]byte{0, 128, 118}:   "MCNC",
	[3]byte{0, 128, 119}:   "BROTHER INDUSTRIES, LTD.",
	[3]byte{0, 128, 120}:   "PRACTICAL PERIPHERALS, INC.",
	[3]byte{0, 128, 121}:   "MICROBUS DESIGNS LTD.",
	[3]byte{0, 128, 122}:   "AITECH SYSTEMS LTD.",
	[3]byte{0, 128, 123}:   "ARTEL COMMUNICATIONS CORP.",
	[3]byte{0, 128, 124}:   "FIBERCOM, INC.",
	[3]byte{0, 128, 125}:   "EQUINOX SYSTEMS INC.",
	[3]byte{0, 128, 126}:   "SOUTHERN PACIFIC LTD.",
	[3]byte{0, 128, 127}:   "DY-4 INCORPORATED",
	[3]byte{0, 128, 128}:   "DATAMEDIA CORPORATION",
	[3]byte{0, 128, 129}:   "KENDALL SQUARE RESEARCH CORP.",
	[3]byte{0, 128, 130}:   "PEP MODULAR COMPUTERS GMBH",
	[3]byte{0, 128, 131}:   "AMDAHL",
	[3]byte{0, 128, 132}:   "THE CLOUD INC.",
	[3]byte{0, 128, 133}:   "H-THREE SYSTEMS CORPORATION",
	[3]byte{0, 128, 134}:   "COMPUTER GENERATION INC.",
	[3]byte{0, 128, 135}:   "OKI ELECTRIC INDUSTRY CO., LTD",
	[3]byte{0, 128, 136}:   "VICTOR COMPANY OF JAPAN, LTD.",
	[3]byte{0, 128, 137}:   "TECNETICS (PTY) LTD.",
	[3]byte{0, 128, 138}:   "SUMMIT MICROSYSTEMS CORP.",
	[3]byte{0, 128, 139}:   "DACOLL LIMITED",
	[3]byte{0, 128, 140}:   "NetScout Systems, Inc.",
	[3]byte{0, 128, 141}:   "WESTCOAST TECHNOLOGY B.V.",
	[3]byte{0, 128, 142}:   "RADSTONE TECHNOLOGY",
	[3]byte{0, 128, 143}:   "C. ITOH ELECTRONICS, INC.",
	[3]byte{0, 128, 144}:   "MICROTEK INTERNATIONAL, INC.",
	[3]byte{0, 128, 145}:   "TOKYO ELECTRIC CO.,LTD",
	[3]byte{0, 128, 146}:   "Silex Technology, Inc.",
	[3]byte{0, 128, 147}:   "XYRON CORPORATION",
	[3]byte{0, 128, 148}:   "ALFA LAVAL AUTOMATION AB",
	[3]byte{0, 128, 149}:   "BASIC MERTON HANDELSGES.M.B.H.",
	[3]byte{0, 128, 150}:   "HUMAN DESIGNED SYSTEMS, INC.",
	[3]byte{0, 128, 151}:   "CENTRALP AUTOMATISMES",
	[3]byte{0, 128, 152}:   "TDK CORPORATION",
	[3]byte{0, 128, 153}:   "Eaton Industries GmbH",
	[3]byte{0, 128, 154}:   "NOVUS NETWORKS LTD",
	[3]byte{0, 128, 155}:   "JUSTSYSTEM CORPORATION",
	[3]byte{0, 128, 156}:   "LUXCOM, INC.",
	[3]byte{0, 128, 157}:   "Commscraft Ltd.",
	[3]byte{0, 128, 158}:   "DATUS GMBH",
	[3]byte{0, 128, 159}:   "ALCATEL BUSINESS SYSTEMS",
	[3]byte{0, 128, 160}:   "EDISA HEWLETT PACKARD S/A",
	[3]byte{0, 128, 161}:   "MICROTEST, INC.",
	[3]byte{0, 128, 162}:   "CREATIVE ELECTRONIC SYSTEMS",
	[3]byte{0, 128, 163}:   "Lantronix",
	[3]byte{0, 128, 164}:   "LIBERTY ELECTRONICS",
	[3]byte{0, 128, 165}:   "SPEED INTERNATIONAL",
	[3]byte{0, 128, 166}:   "REPUBLIC TECHNOLOGY, INC.",
	[3]byte{0, 128, 167}:   "Honeywell International Inc",
	[3]byte{0, 128, 168}:   "VITACOM CORPORATION",
	[3]byte{0, 128, 169}:   "CLEARPOINT RESEARCH",
	[3]byte{0, 128, 170}:   "MAXPEED",
	[3]byte{0, 128, 171}:   "DUKANE NETWORK INTEGRATION",
	[3]byte{0, 128, 172}:   "IMLOGIX, DIVISION OF GENESYS",
	[3]byte{0, 128, 173}:   "CNET TECHNOLOGY, INC.",
	[3]byte{0, 128, 174}:   "HUGHES NETWORK SYSTEMS",
	[3]byte{0, 128, 175}:   "ALLUMER CO., LTD.",
	[3]byte{0, 128, 176}:   "ADVANCED INFORMATION",
	[3]byte{0, 128, 177}:   "SOFTCOM A/S",
	[3]byte{0, 128, 178}:   "NETWORK EQUIPMENT TECHNOLOGIES",
	[3]byte{0, 128, 179}:   "AVAL DATA CORPORATION",
	[3]byte{0, 128, 180}:   "SOPHIA SYSTEMS",
	[3]byte{0, 128, 181}:   "UNITED NETWORKS INC.",
	[3]byte{0, 128, 182}:   "THEMIS COMPUTER",
	[3]byte{0, 128, 183}:   "STELLAR COMPUTER",
	[3]byte{0, 128, 184}:   "B.U.G. MORISEIKI, INCORPORATED",
	[3]byte{0, 128, 185}:   "ARCHE TECHNOLIGIES INC.",
	[3]byte{0, 128, 186}:   "SPECIALIX (ASIA) PTE, LTD",
	[3]byte{0, 128, 187}:   "HUGHES LAN SYSTEMS",
	[3]byte{0, 128, 188}:   "HITACHI ENGINEERING CO., LTD",
	[3]byte{0, 128, 189}:   "THE FURUKAWA ELECTRIC CO., LTD",
	[3]byte{0, 128, 190}:   "ARIES RESEARCH",
	[3]byte{0, 128, 191}:   "TAKAOKA ELECTRIC MFG. CO. LTD.",
	[3]byte{0, 128, 192}:   "PENRIL DATACOMM",
	[3]byte{0, 128, 193}:   "LANEX CORPORATION",
	[3]byte{0, 128, 194}:   "IEEE 802.1 COMMITTEE",
	[3]byte{0, 128, 195}:   "BICC INFORMATION SYSTEMS & SVC",
	[3]byte{0, 128, 196}:   "DOCUMENT TECHNOLOGIES, INC.",
	[3]byte{0, 128, 197}:   "NOVELLCO DE MEXICO",
	[3]byte{0, 128, 198}:   "NATIONAL DATACOMM CORPORATION",
	[3]byte{0, 128, 199}:   "XIRCOM",
	[3]byte{0, 128, 200}:   "D-LINK SYSTEMS, INC.",
	[3]byte{0, 128, 201}:   "ALBERTA MICROELECTRONIC CENTRE",
	[3]byte{0, 128, 202}:   "NETCOM RESEARCH INCORPORATED",
	[3]byte{0, 128, 203}:   "FALCO DATA PRODUCTS",
	[3]byte{0, 128, 204}:   "MICROWAVE BYPASS SYSTEMS",
	[3]byte{0, 128, 205}:   "MICRONICS COMPUTER, INC.",
	[3]byte{0, 128, 206}:   "BROADCAST TELEVISION SYSTEMS",
	[3]byte{0, 128, 207}:   "EMBEDDED PERFORMANCE INC.",
	[3]byte{0, 128, 208}:   "COMPUTER PERIPHERALS, INC.",
	[3]byte{0, 128, 209}:   "KIMTRON CORPORATION",
	[3]byte{0, 128, 210}:   "SHINNIHONDENKO CO., LTD.",
	[3]byte{0, 128, 211}:   "SHIVA CORP.",
	[3]byte{0, 128, 212}:   "CHASE RESEARCH LTD.",
	[3]byte{0, 128, 213}:   "CADRE TECHNOLOGIES",
	[3]byte{0, 128, 214}:   "NUVOTECH, INC.",
	[3]byte{0, 128, 215}:   "Fantum Engineering",
	[3]byte{0, 128, 216}:   "NETWORK PERIPHERALS INC.",
	[3]byte{0, 128, 217}:   "EMK Elektronik GmbH & Co. KG",
	[3]byte{0, 128, 218}:   "Bruel & Kjaer Sound & Vibration Measurement A/S",
	[3]byte{0, 128, 219}:   "GRAPHON CORPORATION",
	[3]byte{0, 128, 220}:   "PICKER INTERNATIONAL",
	[3]byte{0, 128, 221}:   "GMX INC/GIMIX",
	[3]byte{0, 128, 222}:   "GIPSI S.A.",
	[3]byte{0, 128, 223}:   "ADC CODENOLL TECHNOLOGY CORP.",
	[3]byte{0, 128, 224}:   "XTP SYSTEMS, INC.",
	[3]byte{0, 128, 225}:   "STMICROELECTRONICS",
	[3]byte{0, 128, 226}:   "T.D.I. CO., LTD.",
	[3]byte{0, 128, 227}:   "CORAL NETWORK CORPORATION",
	[3]byte{0, 128, 228}:   "NORTHWEST DIGITAL SYSTEMS, INC",
	[3]byte{0, 128, 229}:   "NetApp, Inc",
	[3]byte{0, 128, 230}:   "PEER NETWORKS, INC.",
	[3]byte{0, 128, 231}:   "LYNWOOD SCIENTIFIC DEV. LTD.",
	[3]byte{0, 128, 232}:   "CUMULUS CORPORATIION",
	[3]byte{0, 128, 233}:   "Madge Ltd.",
	[3]byte{0, 128, 234}:   "ADVA Optical Networking Ltd.",
	[3]byte{0, 128, 235}:   "COMPCONTROL B.V.",
	[3]byte{0, 128, 236}:   "SUPERCOMPUTING SOLUTIONS, INC.",
	[3]byte{0, 128, 237}:   "IQ TECHNOLOGIES, INC.",
	[3]byte{0, 128, 238}:   "THOMSON CSF",
	[3]byte{0, 128, 239}:   "RATIONAL",
	[3]byte{0, 128, 240}:   "Panasonic Communications Co., Ltd.",
	[3]byte{0, 128, 241}:   "OPUS SYSTEMS",
	[3]byte{0, 128, 242}:   "RAYCOM SYSTEMS INC",
	[3]byte{0, 128, 243}:   "SUN ELECTRONICS CORP.",
	[3]byte{0, 128, 244}:   "TELEMECANIQUE ELECTRIQUE",
	[3]byte{0, 128, 245}:   "Quantel Ltd",
	[3]byte{0, 128, 246}:   "SYNERGY MICROSYSTEMS",
	[3]byte{0, 128, 247}:   "ZENITH ELECTRONICS",
	[3]byte{0, 128, 248}:   "MIZAR, INC.",
	[3]byte{0, 128, 249}:   "HEURIKON CORPORATION",
	[3]byte{0, 128, 250}:   "RWT GMBH",
	[3]byte{0, 128, 251}:   "BVM LIMITED",
	[3]byte{0, 128, 252}:   "AVATAR CORPORATION",
	[3]byte{0, 128, 253}:   "EXSCEED CORPRATION",
	[3]byte{0, 128, 254}:   "AZURE TECHNOLOGIES, INC.",
	[3]byte{0, 128, 255}:   "SOC. DE TELEINFORMATIQUE RTC",
	[3]byte{0, 134, 160}:   "PRIVATE",
	[3]byte{0, 136, 101}:   "Apple",
	[3]byte{0, 139, 67}:    "RFTECH",
	[3]byte{0, 140, 16}:    "Black Box Corp.",
	[3]byte{0, 140, 84}:    "ADB Broadband Italia",
	[3]byte{0, 140, 250}:   "Inventec Corporation",
	[3]byte{0, 141, 78}:    "CJSC NII STT",
	[3]byte{0, 141, 218}:   "Link One Co., Ltd.",
	[3]byte{0, 142, 242}:   "NETGEAR INC.,",
	[3]byte{0, 144, 0}:     "DIAMOND MULTIMEDIA",
	[3]byte{0, 144, 1}:     "NISHIMU ELECTRONICS INDUSTRIES CO., LTD.",
	[3]byte{0, 144, 2}:     "ALLGON AB",
	[3]byte{0, 144, 3}:     "APLIO",
	[3]byte{0, 144, 4}:     "3COM EUROPE LTD.",
	[3]byte{0, 144, 5}:     "PROTECH SYSTEMS CO., LTD.",
	[3]byte{0, 144, 6}:     "HAMAMATSU PHOTONICS K.K.",
	[3]byte{0, 144, 7}:     "DOMEX TECHNOLOGY CORP.",
	[3]byte{0, 144, 8}:     "HanA Systems Inc.",
	[3]byte{0, 144, 9}:     "I Controls, Inc.",
	[3]byte{0, 144, 10}:    "PROTON ELECTRONIC INDUSTRIAL CO., LTD.",
	[3]byte{0, 144, 11}:    "LANNER ELECTRONICS, INC.",
	[3]byte{0, 144, 12}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 144, 13}:    "Overland Storage Inc.",
	[3]byte{0, 144, 14}:    "HANDLINK TECHNOLOGIES, INC.",
	[3]byte{0, 144, 15}:    "KAWASAKI HEAVY INDUSTRIES, LTD",
	[3]byte{0, 144, 16}:    "SIMULATION LABORATORIES, INC.",
	[3]byte{0, 144, 17}:    "WAVTrace, Inc.",
	[3]byte{0, 144, 18}:    "GLOBESPAN SEMICONDUCTOR, INC.",
	[3]byte{0, 144, 19}:    "SAMSAN CORP.",
	[3]byte{0, 144, 20}:    "ROTORK INSTRUMENTS, LTD.",
	[3]byte{0, 144, 21}:    "CENTIGRAM COMMUNICATIONS CORP.",
	[3]byte{0, 144, 22}:    "ZAC",
	[3]byte{0, 144, 23}:    "Zypcom, Inc",
	[3]byte{0, 144, 24}:    "ITO ELECTRIC INDUSTRY CO, LTD.",
	[3]byte{0, 144, 25}:    "HERMES ELECTRONICS CO., LTD.",
	[3]byte{0, 144, 26}:    "UNISPHERE SOLUTIONS",
	[3]byte{0, 144, 27}:    "DIGITAL CONTROLS",
	[3]byte{0, 144, 28}:    "mps Software Gmbh",
	[3]byte{0, 144, 29}:    "PEC (NZ) LTD.",
	[3]byte{0, 144, 30}:    "Selesta Ingegneria S.p.A.",
	[3]byte{0, 144, 31}:    "ADTEC PRODUCTIONS, INC.",
	[3]byte{0, 144, 32}:    "PHILIPS ANALYTICAL X-RAY B.V.",
	[3]byte{0, 144, 33}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 144, 34}:    "IVEX",
	[3]byte{0, 144, 35}:    "ZILOG INC.",
	[3]byte{0, 144, 36}:    "PIPELINKS, INC.",
	[3]byte{0, 144, 37}:    "BAE Systems Australia (Electronic Systems) Pty Ltd",
	[3]byte{0, 144, 38}:    "ADVANCED SWITCHING COMMUNICATIONS, INC.",
	[3]byte{0, 144, 39}:    "INTEL CORPORATION",
	[3]byte{0, 144, 40}:    "NIPPON SIGNAL CO., LTD.",
	[3]byte{0, 144, 41}:    "CRYPTO AG",
	[3]byte{0, 144, 42}:    "COMMUNICATION DEVICES, INC.",
	[3]byte{0, 144, 43}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 144, 44}:    "DATA & CONTROL EQUIPMENT LTD.",
	[3]byte{0, 144, 45}:    "DATA ELECTRONICS (AUST.) PTY, LTD.",
	[3]byte{0, 144, 46}:    "NAMCO LIMITED",
	[3]byte{0, 144, 47}:    "NETCORE SYSTEMS, INC.",
	[3]byte{0, 144, 48}:    "HONEYWELL-DATING",
	[3]byte{0, 144, 49}:    "MYSTICOM, LTD.",
	[3]byte{0, 144, 50}:    "PELCOMBE GROUP LTD.",
	[3]byte{0, 144, 51}:    "INNOVAPHONE AG",
	[3]byte{0, 144, 52}:    "IMAGIC, INC.",
	[3]byte{0, 144, 53}:    "ALPHA TELECOM, INC.",
	[3]byte{0, 144, 54}:    "ens, inc.",
	[3]byte{0, 144, 55}:    "ACUCOMM, INC.",
	[3]byte{0, 144, 56}:    "FOUNTAIN TECHNOLOGIES, INC.",
	[3]byte{0, 144, 57}:    "SHASTA NETWORKS",
	[3]byte{0, 144, 58}:    "NIHON MEDIA TOOL INC.",
	[3]byte{0, 144, 59}:    "TriEMS Research Lab, Inc.",
	[3]byte{0, 144, 60}:    "ATLANTIC NETWORK SYSTEMS",
	[3]byte{0, 144, 61}:    "BIOPAC SYSTEMS, INC.",
	[3]byte{0, 144, 62}:    "N.V. PHILIPS INDUSTRIAL ACTIVITIES",
	[3]byte{0, 144, 63}:    "AZTEC RADIOMEDIA",
	[3]byte{0, 144, 64}:    "Siemens Network Convergence LLC",
	[3]byte{0, 144, 65}:    "APPLIED DIGITAL ACCESS",
	[3]byte{0, 144, 66}:    "ECCS, Inc.",
	[3]byte{0, 144, 67}:    "Tattile SRL",
	[3]byte{0, 144, 68}:    "ASSURED DIGITAL, INC.",
	[3]byte{0, 144, 69}:    "Marconi Communications",
	[3]byte{0, 144, 70}:    "DEXDYNE, LTD.",
	[3]byte{0, 144, 71}:    "GIGA FAST E. LTD.",
	[3]byte{0, 144, 72}:    "ZEAL CORPORATION",
	[3]byte{0, 144, 73}:    "ENTRIDIA CORPORATION",
	[3]byte{0, 144, 74}:    "CONCUR SYSTEM TECHNOLOGIES",
	[3]byte{0, 144, 75}:    "GemTek Technology Co., Ltd.",
	[3]byte{0, 144, 76}:    "EPIGRAM, INC.",
	[3]byte{0, 144, 77}:    "SPEC S.A.",
	[3]byte{0, 144, 78}:    "DELEM BV",
	[3]byte{0, 144, 79}:    "ABB POWER T&D COMPANY, INC.",
	[3]byte{0, 144, 80}:    "TELESTE OY",
	[3]byte{0, 144, 81}:    "ULTIMATE TECHNOLOGY CORP.",
	[3]byte{0, 144, 82}:    "SELCOM ELETTRONICA S.R.L.",
	[3]byte{0, 144, 83}:    "DAEWOO ELECTRONICS CO., LTD.",
	[3]byte{0, 144, 84}:    "INNOVATIVE SEMICONDUCTORS, INC",
	[3]byte{0, 144, 85}:    "PARKER HANNIFIN CORPORATION COMPUMOTOR DIVISION",
	[3]byte{0, 144, 86}:    "TELESTREAM, INC.",
	[3]byte{0, 144, 87}:    "AANetcom, Inc.",
	[3]byte{0, 144, 88}:    "Ultra Electronics Ltd., Command and Control Systems",
	[3]byte{0, 144, 89}:    "TELECOM DEVICE K.K.",
	[3]byte{0, 144, 90}:    "DEARBORN GROUP, INC.",
	[3]byte{0, 144, 91}:    "RAYMOND AND LAE ENGINEERING",
	[3]byte{0, 144, 92}:    "EDMI",
	[3]byte{0, 144, 93}:    "NETCOM SICHERHEITSTECHNIK GmbH",
	[3]byte{0, 144, 94}:    "RAULAND-BORG CORPORATION",
	[3]byte{0, 144, 95}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 144, 96}:    "SYSTEM CREATE CORP.",
	[3]byte{0, 144, 97}:    "PACIFIC RESEARCH & ENGINEERING CORPORATION",
	[3]byte{0, 144, 98}:    "ICP VORTEX COMPUTERSYSTEME GmbH",
	[3]byte{0, 144, 99}:    "COHERENT COMMUNICATIONS SYSTEMS CORPORATION",
	[3]byte{0, 144, 100}:   "Thomson Inc.",
	[3]byte{0, 144, 101}:   "FINISAR CORPORATION",
	[3]byte{0, 144, 102}:   "Troika Networks, Inc.",
	[3]byte{0, 144, 103}:   "WalkAbout Computers, Inc.",
	[3]byte{0, 144, 104}:   "DVT CORP.",
	[3]byte{0, 144, 105}:   "JUNIPER NETWORKS, INC.",
	[3]byte{0, 144, 106}:   "TURNSTONE SYSTEMS, INC.",
	[3]byte{0, 144, 107}:   "APPLIED RESOURCES, INC.",
	[3]byte{0, 144, 108}:   "Sartorius Hamburg GmbH",
	[3]byte{0, 144, 109}:   "CISCO SYSTEMS, INC.",
	[3]byte{0, 144, 110}:   "PRAXON, INC.",
	[3]byte{0, 144, 111}:   "CISCO SYSTEMS, INC.",
	[3]byte{0, 144, 112}:   "NEO NETWORKS, INC.",
	[3]byte{0, 144, 113}:   "Applied Innovation Inc.",
	[3]byte{0, 144, 114}:   "SIMRAD AS",
	[3]byte{0, 144, 115}:   "GAIO TECHNOLOGY",
	[3]byte{0, 144, 116}:   "ARGON NETWORKS, INC.",
	[3]byte{0, 144, 117}:   "NEC DO BRASIL S.A.",
	[3]byte{0, 144, 118}:   "FMT AIRCRAFT GATE SUPPORT SYSTEMS AB",
	[3]byte{0, 144, 119}:   "ADVANCED FIBRE COMMUNICATIONS",
	[3]byte{0, 144, 120}:   "MER TELEMANAGEMENT SOLUTIONS, LTD.",
	[3]byte{0, 144, 121}:   "ClearOne, Inc.",
	[3]byte{0, 144, 122}:   "Spectralink, Inc",
	[3]byte{0, 144, 123}:   "E-TECH, INC.",
	[3]byte{0, 144, 124}:   "DIGITALCAST, INC.",
	[3]byte{0, 144, 125}:   "Lake Communications",
	[3]byte{0, 144, 126}:   "VETRONIX CORP.",
	[3]byte{0, 144, 127}:   "WatchGuard Technologies, Inc.",
	[3]byte{0, 144, 128}:   "NOT LIMITED, INC.",
	[3]byte{0, 144, 129}:   "ALOHA NETWORKS, INC.",
	[3]byte{0, 144, 130}:   "FORCE INSTITUTE",
	[3]byte{0, 144, 131}:   "TURBO COMMUNICATION, INC.",
	[3]byte{0, 144, 132}:   "ATECH SYSTEM",
	[3]byte{0, 144, 133}:   "GOLDEN ENTERPRISES, INC.",
	[3]byte{0, 144, 134}:   "CISCO SYSTEMS, INC.",
	[3]byte{0, 144, 135}:   "ITIS",
	[3]byte{0, 144, 136}:   "BAXALL SECURITY LTD.",
	[3]byte{0, 144, 137}:   "SOFTCOM MICROSYSTEMS, INC.",
	[3]byte{0, 144, 138}:   "BAYLY COMMUNICATIONS, INC.",
	[3]byte{0, 144, 139}:   "Tattile SRL",
	[3]byte{0, 144, 140}:   "ETREND ELECTRONICS, INC.",
	[3]byte{0, 144, 141}:   "VICKERS ELECTRONICS SYSTEMS",
	[3]byte{0, 144, 142}:   "Nortel Networks Broadband Access",
	[3]byte{0, 144, 143}:   "AUDIO CODES LTD.",
	[3]byte{0, 144, 144}:   "I-BUS",
	[3]byte{0, 144, 145}:   "DigitalScape, Inc.",
	[3]byte{0, 144, 146}:   "CISCO SYSTEMS, INC.",
	[3]byte{0, 144, 147}:   "NANAO CORPORATION",
	[3]byte{0, 144, 148}:   "OSPREY TECHNOLOGIES, INC.",
	[3]byte{0, 144, 149}:   "UNIVERSAL AVIONICS",
	[3]byte{0, 144, 150}:   "ASKEY COMPUTER CORP.",
	[3]byte{0, 144, 151}:   "Sycamore Networks",
	[3]byte{0, 144, 152}:   "SBC DESIGNS, INC.",
	[3]byte{0, 144, 153}:   "ALLIED TELESIS, K.K.",
	[3]byte{0, 144, 154}:   "ONE WORLD SYSTEMS, INC.",
	[3]byte{0, 144, 155}:   "MARKEM-IMAJE",
	[3]byte{0, 144, 156}:   "ARRIS Group, Inc.",
	[3]byte{0, 144, 157}:   "NovaTech Process Solutions, LLC",
	[3]byte{0, 144, 158}:   "Critical IO, LLC",
	[3]byte{0, 144, 159}:   "DIGI-DATA CORPORATION",
	[3]byte{0, 144, 160}:   "8X8 INC.",
	[3]byte{0, 144, 161}:   "Flying Pig Systems/High End Systems Inc.",
	[3]byte{0, 144, 162}:   "CYBERTAN TECHNOLOGY, INC.",
	[3]byte{0, 144, 163}:   "Corecess Inc.",
	[3]byte{0, 144, 164}:   "ALTIGA NETWORKS",
	[3]byte{0, 144, 165}:   "SPECTRA LOGIC",
	[3]byte{0, 144, 166}:   "CISCO SYSTEMS, INC.",
	[3]byte{0, 144, 167}:   "CLIENTEC CORPORATION",
	[3]byte{0, 144, 168}:   "NineTiles Networks, Ltd.",
	[3]byte{0, 144, 169}:   "WESTERN DIGITAL",
	[3]byte{0, 144, 170}:   "INDIGO ACTIVE VISION SYSTEMS LIMITED",
	[3]byte{0, 144, 171}:   "CISCO SYSTEMS, INC.",
	[3]byte{0, 144, 172}:   "OPTIVISION, INC.",
	[3]byte{0, 144, 173}:   "ASPECT ELECTRONICS, INC.",
	[3]byte{0, 144, 174}:   "ITALTEL S.p.A.",
	[3]byte{0, 144, 175}:   "J. MORITA MFG. CORP.",
	[3]byte{0, 144, 176}:   "VADEM",
	[3]byte{0, 144, 177}:   "CISCO SYSTEMS, INC.",
	[3]byte{0, 144, 178}:   "AVICI SYSTEMS INC.",
	[3]byte{0, 144, 179}:   "AGRANAT SYSTEMS",
	[3]byte{0, 144, 180}:   "WILLOWBROOK TECHNOLOGIES",
	[3]byte{0, 144, 181}:   "NIKON CORPORATION",
	[3]byte{0, 144, 182}:   "FIBEX SYSTEMS",
	[3]byte{0, 144, 183}:   "DIGITAL LIGHTWAVE, INC.",
	[3]byte{0, 144, 184}:   "ROHDE & SCHWARZ GMBH & CO. KG",
	[3]byte{0, 144, 185}:   "BERAN INSTRUMENTS LTD.",
	[3]byte{0, 144, 186}:   "VALID NETWORKS, INC.",
	[3]byte{0, 144, 187}:   "TAINET COMMUNICATION SYSTEM Corp.",
	[3]byte{0, 144, 188}:   "TELEMANN CO., LTD.",
	[3]byte{0, 144, 189}:   "OMNIA COMMUNICATIONS, INC.",
	[3]byte{0, 144, 190}:   "IBC/INTEGRATED BUSINESS COMPUTERS",
	[3]byte{0, 144, 191}:   "CISCO SYSTEMS, INC.",
	[3]byte{0, 144, 192}:   "K.J. LAW ENGINEERS, INC.",
	[3]byte{0, 144, 193}:   "Peco II, Inc.",
	[3]byte{0, 144, 194}:   "JK microsystems, Inc.",
	[3]byte{0, 144, 195}:   "TOPIC SEMICONDUCTOR CORP.",
	[3]byte{0, 144, 196}:   "JAVELIN SYSTEMS, INC.",
	[3]byte{0, 144, 197}:   "INTERNET MAGIC, INC.",
	[3]byte{0, 144, 198}:   "OPTIM SYSTEMS, INC.",
	[3]byte{0, 144, 199}:   "ICOM INC.",
	[3]byte{0, 144, 200}:   "WAVERIDER COMMUNICATIONS (CANADA) INC.",
	[3]byte{0, 144, 201}:   "DPAC Technologies",
	[3]byte{0, 144, 202}:   "ACCORD VIDEO TELECOMMUNICATIONS, LTD.",
	[3]byte{0, 144, 203}:   "Wireless OnLine, Inc.",
	[3]byte{0, 144, 204}:   "Planex Communications",
	[3]byte{0, 144, 205}:   "ENT-EMPRESA NACIONAL DE TELECOMMUNICACOES, S.A.",
	[3]byte{0, 144, 206}:   "TETRA GmbH",
	[3]byte{0, 144, 207}:   "NORTEL",
	[3]byte{0, 144, 208}:   "Thomson Telecom Belgium",
	[3]byte{0, 144, 209}:   "LEICHU ENTERPRISE CO., LTD.",
	[3]byte{0, 144, 210}:   "ARTEL VIDEO SYSTEMS",
	[3]byte{0, 144, 211}:   "GIESECKE & DEVRIENT GmbH",
	[3]byte{0, 144, 212}:   "BindView Development Corp.",
	[3]byte{0, 144, 213}:   "EUPHONIX, INC.",
	[3]byte{0, 144, 214}:   "CRYSTAL GROUP",
	[3]byte{0, 144, 215}:   "NetBoost Corp.",
	[3]byte{0, 144, 216}:   "WHITECROSS SYSTEMS",
	[3]byte{0, 144, 217}:   "CISCO SYSTEMS, INC.",
	[3]byte{0, 144, 218}:   "DYNARC, INC.",
	[3]byte{0, 144, 219}:   "NEXT LEVEL COMMUNICATIONS",
	[3]byte{0, 144, 220}:   "TECO INFORMATION SYSTEMS",
	[3]byte{0, 144, 221}:   "MIHARU COMMUNICATIONS Inc",
	[3]byte{0, 144, 222}:   "CARDKEY SYSTEMS, INC.",
	[3]byte{0, 144, 223}:   "MITSUBISHI CHEMICAL AMERICA, INC.",
	[3]byte{0, 144, 224}:   "SYSTRAN CORP.",
	[3]byte{0, 144, 225}:   "TELENA S.P.A.",
	[3]byte{0, 144, 226}:   "DISTRIBUTED PROCESSING TECHNOLOGY",
	[3]byte{0, 144, 227}:   "AVEX ELECTRONICS INC.",
	[3]byte{0, 144, 228}:   "NEC AMERICA, INC.",
	[3]byte{0, 144, 229}:   "TEKNEMA, INC.",
	[3]byte{0, 144, 230}:   "ALi Corporation",
	[3]byte{0, 144, 231}:   "HORSCH ELEKTRONIK AG",
	[3]byte{0, 144, 232}:   "MOXA TECHNOLOGIES CORP., LTD.",
	[3]byte{0, 144, 233}:   "JANZ COMPUTER AG",
	[3]byte{0, 144, 234}:   "ALPHA TECHNOLOGIES, INC.",
	[3]byte{0, 144, 235}:   "SENTRY TELECOM SYSTEMS",
	[3]byte{0, 144, 236}:   "PYRESCOM",
	[3]byte{0, 144, 237}:   "CENTRAL SYSTEM RESEARCH CO., LTD.",
	[3]byte{0, 144, 238}:   "PERSONAL COMMUNICATIONS TECHNOLOGIES",
	[3]byte{0, 144, 239}:   "INTEGRIX, INC.",
	[3]byte{0, 144, 240}:   "Harmonic Video Systems Ltd.",
	[3]byte{0, 144, 241}:   "DOT HILL SYSTEMS CORPORATION",
	[3]byte{0, 144, 242}:   "CISCO SYSTEMS, INC.",
	[3]byte{0, 144, 243}:   "ASPECT COMMUNICATIONS",
	[3]byte{0, 144, 244}:   "LIGHTNING INSTRUMENTATION",
	[3]byte{0, 144, 245}:   "CLEVO CO.",
	[3]byte{0, 144, 246}:   "ESCALATE NETWORKS, INC.",
	[3]byte{0, 144, 247}:   "NBASE COMMUNICATIONS LTD.",
	[3]byte{0, 144, 248}:   "MEDIATRIX TELECOM",
	[3]byte{0, 144, 249}:   "LEITCH",
	[3]byte{0, 144, 250}:   "Emulex Corporation",
	[3]byte{0, 144, 251}:   "PORTWELL, INC.",
	[3]byte{0, 144, 252}:   "NETWORK COMPUTING DEVICES",
	[3]byte{0, 144, 253}:   "CopperCom, Inc.",
	[3]byte{0, 144, 254}:   "ELECOM CO., LTD.  (LANEED DIV.)",
	[3]byte{0, 144, 255}:   "TELLUS TECHNOLOGY INC.",
	[3]byte{0, 145, 214}:   "Crystal Group, Inc.",
	[3]byte{0, 145, 250}:   "Synapse Product Development",
	[3]byte{0, 146, 250}:   "SHENZHEN WISKY TECHNOLOGY CO.,LTD",
	[3]byte{0, 147, 99}:    "Uni-Link Technology Co., Ltd.",
	[3]byte{0, 149, 105}:   "LSD Science and Technology Co.,Ltd.",
	[3]byte{0, 151, 255}:   "Heimann Sensor GmbH",
	[3]byte{0, 156, 2}:     "Hewlett-Packard Company",
	[3]byte{0, 157, 142}:   "CARDIAC RECORDERS, INC.",
	[3]byte{0, 158, 200}:   "Beijing Xiaomi Electronic Products Co., Ltd.",
	[3]byte{0, 160, 0}:     "CENTILLION NETWORKS, INC.",
	[3]byte{0, 160, 1}:     "DRS Signal Solutions",
	[3]byte{0, 160, 2}:     "LEEDS & NORTHRUP AUSTRALIA PTY LTD",
	[3]byte{0, 160, 3}:     "Siemens Switzerland Ltd., I B T HVP",
	[3]byte{0, 160, 4}:     "NETPOWER, INC.",
	[3]byte{0, 160, 5}:     "DANIEL INSTRUMENTS, LTD.",
	[3]byte{0, 160, 6}:     "IMAGE DATA PROCESSING SYSTEM GROUP",
	[3]byte{0, 160, 7}:     "APEXX TECHNOLOGY, INC.",
	[3]byte{0, 160, 8}:     "NETCORP",
	[3]byte{0, 160, 9}:     "WHITETREE NETWORK",
	[3]byte{0, 160, 10}:    "Airspan",
	[3]byte{0, 160, 11}:    "COMPUTEX CO., LTD.",
	[3]byte{0, 160, 12}:    "KINGMAX TECHNOLOGY, INC.",
	[3]byte{0, 160, 13}:    "THE PANDA PROJECT",
	[3]byte{0, 160, 14}:    "VISUAL NETWORKS, INC.",
	[3]byte{0, 160, 15}:    "Broadband Technologies",
	[3]byte{0, 160, 16}:    "SYSLOGIC DATENTECHNIK AG",
	[3]byte{0, 160, 17}:    "MUTOH INDUSTRIES LTD.",
	[3]byte{0, 160, 18}:    "Telco Systems, Inc.",
	[3]byte{0, 160, 19}:    "TELTREND LTD.",
	[3]byte{0, 160, 20}:    "CSIR",
	[3]byte{0, 160, 21}:    "WYLE",
	[3]byte{0, 160, 22}:    "MICROPOLIS CORP.",
	[3]byte{0, 160, 23}:    "J B M CORPORATION",
	[3]byte{0, 160, 24}:    "CREATIVE CONTROLLERS, INC.",
	[3]byte{0, 160, 25}:    "NEBULA CONSULTANTS, INC.",
	[3]byte{0, 160, 26}:    "BINAR ELEKTRONIK AB",
	[3]byte{0, 160, 27}:    "PREMISYS COMMUNICATIONS, INC.",
	[3]byte{0, 160, 28}:    "NASCENT NETWORKS CORPORATION",
	[3]byte{0, 160, 29}:    "SIXNET",
	[3]byte{0, 160, 30}:    "EST CORPORATION",
	[3]byte{0, 160, 31}:    "TRICORD SYSTEMS, INC.",
	[3]byte{0, 160, 32}:    "CITICORP/TTI",
	[3]byte{0, 160, 33}:    "General Dynamics",
	[3]byte{0, 160, 34}:    "CENTRE FOR DEVELOPMENT OF ADVANCED COMPUTING",
	[3]byte{0, 160, 35}:    "APPLIED CREATIVE TECHNOLOGY, INC.",
	[3]byte{0, 160, 36}:    "3COM CORPORATION",
	[3]byte{0, 160, 37}:    "REDCOM LABS INC.",
	[3]byte{0, 160, 38}:    "TELDAT, S.A.",
	[3]byte{0, 160, 39}:    "FIREPOWER SYSTEMS, INC.",
	[3]byte{0, 160, 40}:    "CONNER PERIPHERALS",
	[3]byte{0, 160, 41}:    "COULTER CORPORATION",
	[3]byte{0, 160, 42}:    "TRANCELL SYSTEMS",
	[3]byte{0, 160, 43}:    "TRANSITIONS RESEARCH CORP.",
	[3]byte{0, 160, 44}:    "interWAVE Communications",
	[3]byte{0, 160, 45}:    "1394 Trade Association",
	[3]byte{0, 160, 46}:    "BRAND COMMUNICATIONS, LTD.",
	[3]byte{0, 160, 47}:    "PIRELLI CAVI",
	[3]byte{0, 160, 48}:    "CAPTOR NV/SA",
	[3]byte{0, 160, 49}:    "HAZELTINE CORPORATION, MS 1-17",
	[3]byte{0, 160, 50}:    "GES SINGAPORE PTE. LTD.",
	[3]byte{0, 160, 51}:    "imc MeBsysteme GmbH",
	[3]byte{0, 160, 52}:    "AXEL",
	[3]byte{0, 160, 53}:    "CYLINK CORPORATION",
	[3]byte{0, 160, 54}:    "APPLIED NETWORK TECHNOLOGY",
	[3]byte{0, 160, 55}:    "Mindray DS USA, Inc.",
	[3]byte{0, 160, 56}:    "EMAIL ELECTRONICS",
	[3]byte{0, 160, 57}:    "ROSS TECHNOLOGY, INC.",
	[3]byte{0, 160, 58}:    "KUBOTEK CORPORATION",
	[3]byte{0, 160, 59}:    "TOSHIN ELECTRIC CO., LTD.",
	[3]byte{0, 160, 60}:    "EG&G NUCLEAR INSTRUMENTS",
	[3]byte{0, 160, 61}:    "OPTO-22",
	[3]byte{0, 160, 62}:    "ATM FORUM",
	[3]byte{0, 160, 63}:    "COMPUTER SOCIETY MICROPROCESSOR & MICROPROCESSOR STANDARDS C",
	[3]byte{0, 160, 64}:    "Apple",
	[3]byte{0, 160, 65}:    "INFICON",
	[3]byte{0, 160, 66}:    "SPUR PRODUCTS CORP.",
	[3]byte{0, 160, 67}:    "AMERICAN TECHNOLOGY LABS, INC.",
	[3]byte{0, 160, 68}:    "NTT IT CO., LTD.",
	[3]byte{0, 160, 69}:    "PHOENIX CONTACT GMBH & CO.",
	[3]byte{0, 160, 70}:    "SCITEX CORP. LTD.",
	[3]byte{0, 160, 71}:    "INTEGRATED FITNESS CORP.",
	[3]byte{0, 160, 72}:    "QUESTECH, LTD.",
	[3]byte{0, 160, 73}:    "DIGITECH INDUSTRIES, INC.",
	[3]byte{0, 160, 74}:    "NISSHIN ELECTRIC CO., LTD.",
	[3]byte{0, 160, 75}:    "TFL LAN INC.",
	[3]byte{0, 160, 76}:    "INNOVATIVE SYSTEMS & TECHNOLOGIES, INC.",
	[3]byte{0, 160, 77}:    "EDA INSTRUMENTS, INC.",
	[3]byte{0, 160, 78}:    "VOELKER TECHNOLOGIES, INC.",
	[3]byte{0, 160, 79}:    "AMERITEC CORP.",
	[3]byte{0, 160, 80}:    "CYPRESS SEMICONDUCTOR",
	[3]byte{0, 160, 81}:    "ANGIA COMMUNICATIONS. INC.",
	[3]byte{0, 160, 82}:    "STANILITE ELECTRONICS PTY. LTD",
	[3]byte{0, 160, 83}:    "COMPACT DEVICES, INC.",
	[3]byte{0, 160, 84}:    "PRIVATE",
	[3]byte{0, 160, 85}:    "Data Device Corporation",
	[3]byte{0, 160, 86}:    "MICROPROSS",
	[3]byte{0, 160, 87}:    "LANCOM Systems GmbH",
	[3]byte{0, 160, 88}:    "GLORY, LTD.",
	[3]byte{0, 160, 89}:    "HAMILTON HALLMARK",
	[3]byte{0, 160, 90}:    "KOFAX IMAGE PRODUCTS",
	[3]byte{0, 160, 91}:    "MARQUIP, INC.",
	[3]byte{0, 160, 92}:    "INVENTORY CONVERSION, INC./",
	[3]byte{0, 160, 93}:    "CS COMPUTER SYSTEME GmbH",
	[3]byte{0, 160, 94}:    "MYRIAD LOGIC INC.",
	[3]byte{0, 160, 95}:    "BTG Electronics Design BV",
	[3]byte{0, 160, 96}:    "ACER PERIPHERALS, INC.",
	[3]byte{0, 160, 97}:    "PURITAN BENNETT",
	[3]byte{0, 160, 98}:    "AES PRODATA",
	[3]byte{0, 160, 99}:    "JRL SYSTEMS, INC.",
	[3]byte{0, 160, 100}:   "KVB/ANALECT",
	[3]byte{0, 160, 101}:   "Symantec Corporation",
	[3]byte{0, 160, 102}:   "ISA CO., LTD.",
	[3]byte{0, 160, 103}:   "NETWORK SERVICES GROUP",
	[3]byte{0, 160, 104}:   "BHP LIMITED",
	[3]byte{0, 160, 105}:   "Symmetricom, Inc.",
	[3]byte{0, 160, 106}:   "Verilink Corporation",
	[3]byte{0, 160, 107}:   "DMS DORSCH MIKROSYSTEM GMBH",
	[3]byte{0, 160, 108}:   "SHINDENGEN ELECTRIC MFG. CO., LTD.",
	[3]byte{0, 160, 109}:   "MANNESMANN TALLY CORPORATION",
	[3]byte{0, 160, 110}:   "AUSTRON, INC.",
	[3]byte{0, 160, 111}:   "THE APPCON GROUP, INC.",
	[3]byte{0, 160, 112}:   "COASTCOM",
	[3]byte{0, 160, 113}:   "VIDEO LOTTERY TECHNOLOGIES,INC",
	[3]byte{0, 160, 114}:   "OVATION SYSTEMS LTD.",
	[3]byte{0, 160, 115}:   "COM21, INC.",
	[3]byte{0, 160, 116}:   "PERCEPTION TECHNOLOGY",
	[3]byte{0, 160, 117}:   "MICRON TECHNOLOGY, INC.",
	[3]byte{0, 160, 118}:   "CARDWARE LAB, INC.",
	[3]byte{0, 160, 119}:   "FUJITSU NEXION, INC.",
	[3]byte{0, 160, 120}:   "Marconi Communications",
	[3]byte{0, 160, 121}:   "ALPS ELECTRIC (USA), INC.",
	[3]byte{0, 160, 122}:   "ADVANCED PERIPHERALS TECHNOLOGIES, INC.",
	[3]byte{0, 160, 123}:   "DAWN COMPUTER INCORPORATION",
	[3]byte{0, 160, 124}:   "TONYANG NYLON CO., LTD.",
	[3]byte{0, 160, 125}:   "SEEQ TECHNOLOGY, INC.",
	[3]byte{0, 160, 126}:   "AVID TECHNOLOGY, INC.",
	[3]byte{0, 160, 127}:   "GSM-SYNTEL, LTD.",
	[3]byte{0, 160, 128}:   "Tattile SRL",
	[3]byte{0, 160, 129}:   "ALCATEL DATA NETWORKS",
	[3]byte{0, 160, 130}:   "NKT ELEKTRONIK A/S",
	[3]byte{0, 160, 131}:   "ASIMMPHONY TURKEY",
	[3]byte{0, 160, 132}:   "Dataplex Pty Ltd",
	[3]byte{0, 160, 133}:   "PRIVATE",
	[3]byte{0, 160, 134}:   "AMBER WAVE SYSTEMS, INC.",
	[3]byte{0, 160, 135}:   "Microsemi Corporation",
	[3]byte{0, 160, 136}:   "ESSENTIAL COMMUNICATIONS",
	[3]byte{0, 160, 137}:   "XPOINT TECHNOLOGIES, INC.",
	[3]byte{0, 160, 138}:   "BROOKTROUT TECHNOLOGY, INC.",
	[3]byte{0, 160, 139}:   "ASTON ELECTRONIC DESIGNS LTD.",
	[3]byte{0, 160, 140}:   "MultiMedia LANs, Inc.",
	[3]byte{0, 160, 141}:   "JACOMO CORPORATION",
	[3]byte{0, 160, 142}:   "Check Point Software Technologies",
	[3]byte{0, 160, 143}:   "DESKNET SYSTEMS, INC.",
	[3]byte{0, 160, 144}:   "TimeStep Corporation",
	[3]byte{0, 160, 145}:   "APPLICOM INTERNATIONAL",
	[3]byte{0, 160, 146}:   "H. BOLLMANN MANUFACTURERS, LTD",
	[3]byte{0, 160, 147}:   "B/E AEROSPACE, Inc.",
	[3]byte{0, 160, 148}:   "COMSAT CORPORATION",
	[3]byte{0, 160, 149}:   "ACACIA NETWORKS, INC.",
	[3]byte{0, 160, 150}:   "MITSUMI ELECTRIC CO., LTD.",
	[3]byte{0, 160, 151}:   "JC INFORMATION SYSTEMS",
	[3]byte{0, 160, 152}:   "NetApp",
	[3]byte{0, 160, 153}:   "K-NET LTD.",
	[3]byte{0, 160, 154}:   "NIHON KOHDEN AMERICA",
	[3]byte{0, 160, 155}:   "QPSX COMMUNICATIONS, LTD.",
	[3]byte{0, 160, 156}:   "Xyplex, Inc.",
	[3]byte{0, 160, 157}:   "JOHNATHON FREEMAN TECHNOLOGIES",
	[3]byte{0, 160, 158}:   "ICTV",
	[3]byte{0, 160, 159}:   "COMMVISION CORP.",
	[3]byte{0, 160, 160}:   "COMPACT DATA, LTD.",
	[3]byte{0, 160, 161}:   "EPIC DATA INC.",
	[3]byte{0, 160, 162}:   "DIGICOM S.P.A.",
	[3]byte{0, 160, 163}:   "RELIABLE POWER METERS",
	[3]byte{0, 160, 164}:   "MICROS SYSTEMS, INC.",
	[3]byte{0, 160, 165}:   "TEKNOR MICROSYSTEME, INC.",
	[3]byte{0, 160, 166}:   "M.I. SYSTEMS, K.K.",
	[3]byte{0, 160, 167}:   "VORAX CORPORATION",
	[3]byte{0, 160, 168}:   "RENEX CORPORATION",
	[3]byte{0, 160, 169}:   "NAVTEL COMMUNICATIONS INC.",
	[3]byte{0, 160, 170}:   "SPACELABS MEDICAL",
	[3]byte{0, 160, 171}:   "NETCS INFORMATIONSTECHNIK GMBH",
	[3]byte{0, 160, 172}:   "GILAT SATELLITE NETWORKS, LTD.",
	[3]byte{0, 160, 173}:   "MARCONI SPA",
	[3]byte{0, 160, 174}:   "NUCOM SYSTEMS, INC.",
	[3]byte{0, 160, 175}:   "WMS INDUSTRIES",
	[3]byte{0, 160, 176}:   "I-O DATA DEVICE, INC.",
	[3]byte{0, 160, 177}:   "FIRST VIRTUAL CORPORATION",
	[3]byte{0, 160, 178}:   "SHIMA SEIKI",
	[3]byte{0, 160, 179}:   "ZYKRONIX",
	[3]byte{0, 160, 180}:   "TEXAS MICROSYSTEMS, INC.",
	[3]byte{0, 160, 181}:   "3H TECHNOLOGY",
	[3]byte{0, 160, 182}:   "SANRITZ AUTOMATION CO., LTD.",
	[3]byte{0, 160, 183}:   "CORDANT, INC.",
	[3]byte{0, 160, 184}:   "SYMBIOS LOGIC INC.",
	[3]byte{0, 160, 185}:   "EAGLE TECHNOLOGY, INC.",
	[3]byte{0, 160, 186}:   "PATTON ELECTRONICS CO.",
	[3]byte{0, 160, 187}:   "HILAN GMBH",
	[3]byte{0, 160, 188}:   "VIASAT, INCORPORATED",
	[3]byte{0, 160, 189}:   "I-TECH CORP.",
	[3]byte{0, 160, 190}:   "INTEGRATED CIRCUIT SYSTEMS, INC. COMMUNICATIONS GROUP",
	[3]byte{0, 160, 191}:   "WIRELESS DATA GROUP MOTOROLA",
	[3]byte{0, 160, 192}:   "DIGITAL LINK CORP.",
	[3]byte{0, 160, 193}:   "ORTIVUS MEDICAL AB",
	[3]byte{0, 160, 194}:   "R.A. SYSTEMS CO., LTD.",
	[3]byte{0, 160, 195}:   "UNICOMPUTER GMBH",
	[3]byte{0, 160, 196}:   "CRISTIE ELECTRONICS LTD.",
	[3]byte{0, 160, 197}:   "ZYXEL COMMUNICATION",
	[3]byte{0, 160, 198}:   "QUALCOMM INCORPORATED",
	[3]byte{0, 160, 199}:   "TADIRAN TELECOMMUNICATIONS",
	[3]byte{0, 160, 200}:   "ADTRAN INC.",
	[3]byte{0, 160, 201}:   "INTEL CORPORATION - HF1-06",
	[3]byte{0, 160, 202}:   "FUJITSU DENSO LTD.",
	[3]byte{0, 160, 203}:   "ARK TELECOMMUNICATIONS, INC.",
	[3]byte{0, 160, 204}:   "LITE-ON COMMUNICATIONS, INC.",
	[3]byte{0, 160, 205}:   "DR. JOHANNES HEIDENHAIN GmbH",
	[3]byte{0, 160, 206}:   "Ecessa",
	[3]byte{0, 160, 207}:   "SOTAS, INC.",
	[3]byte{0, 160, 208}:   "TEN X TECHNOLOGY, INC.",
	[3]byte{0, 160, 209}:   "INVENTEC CORPORATION",
	[3]byte{0, 160, 210}:   "ALLIED TELESIS INTERNATIONAL CORPORATION",
	[3]byte{0, 160, 211}:   "INSTEM COMPUTER SYSTEMS, LTD.",
	[3]byte{0, 160, 212}:   "RADIOLAN,  INC.",
	[3]byte{0, 160, 213}:   "SIERRA WIRELESS INC.",
	[3]byte{0, 160, 214}:   "SBE, INC.",
	[3]byte{0, 160, 215}:   "KASTEN CHASE APPLIED RESEARCH",
	[3]byte{0, 160, 216}:   "SPECTRA - TEK",
	[3]byte{0, 160, 217}:   "CONVEX COMPUTER CORPORATION",
	[3]byte{0, 160, 218}:   "INTEGRATED SYSTEMS Technology, Inc.",
	[3]byte{0, 160, 219}:   "FISHER & PAYKEL PRODUCTION",
	[3]byte{0, 160, 220}:   "O.N. ELECTRONIC CO., LTD.",
	[3]byte{0, 160, 221}:   "AZONIX CORPORATION",
	[3]byte{0, 160, 222}:   "YAMAHA CORPORATION",
	[3]byte{0, 160, 223}:   "STS TECHNOLOGIES, INC.",
	[3]byte{0, 160, 224}:   "TENNYSON TECHNOLOGIES PTY LTD",
	[3]byte{0, 160, 225}:   "WESTPORT RESEARCH ASSOCIATES, INC.",
	[3]byte{0, 160, 226}:   "Keisokugiken Corporation",
	[3]byte{0, 160, 227}:   "XKL SYSTEMS CORP.",
	[3]byte{0, 160, 228}:   "OPTIQUEST",
	[3]byte{0, 160, 229}:   "NHC COMMUNICATIONS",
	[3]byte{0, 160, 230}:   "DIALOGIC CORPORATION",
	[3]byte{0, 160, 231}:   "CENTRAL DATA CORPORATION",
	[3]byte{0, 160, 232}:   "REUTERS HOLDINGS PLC",
	[3]byte{0, 160, 233}:   "ELECTRONIC RETAILING SYSTEMS INTERNATIONAL",
	[3]byte{0, 160, 234}:   "ETHERCOM CORP.",
	[3]byte{0, 160, 235}:   "Encore Networks, Inc.",
	[3]byte{0, 160, 236}:   "TRANSMITTON LTD.",
	[3]byte{0, 160, 237}:   "Brooks Automation, Inc.",
	[3]byte{0, 160, 238}:   "NASHOBA NETWORKS",
	[3]byte{0, 160, 239}:   "LUCIDATA LTD.",
	[3]byte{0, 160, 240}:   "TORONTO MICROELECTRONICS INC.",
	[3]byte{0, 160, 241}:   "MTI",
	[3]byte{0, 160, 242}:   "INFOTEK COMMUNICATIONS, INC.",
	[3]byte{0, 160, 243}:   "STAUBLI",
	[3]byte{0, 160, 244}:   "GE",
	[3]byte{0, 160, 245}:   "RADGUARD LTD.",
	[3]byte{0, 160, 246}:   "AutoGas Systems Inc.",
	[3]byte{0, 160, 247}:   "V.I COMPUTER CORP.",
	[3]byte{0, 160, 248}:   "SYMBOL TECHNOLOGIES, INC.",
	[3]byte{0, 160, 249}:   "BINTEC COMMUNICATIONS GMBH",
	[3]byte{0, 160, 250}:   "Marconi Communication GmbH",
	[3]byte{0, 160, 251}:   "TORAY ENGINEERING CO., LTD.",
	[3]byte{0, 160, 252}:   "IMAGE SCIENCES, INC.",
	[3]byte{0, 160, 253}:   "SCITEX DIGITAL PRINTING, INC.",
	[3]byte{0, 160, 254}:   "BOSTON TECHNOLOGY, INC.",
	[3]byte{0, 160, 255}:   "TELLABS OPERATIONS, INC.",
	[3]byte{0, 161, 222}:   "ShenZhen ShiHua Technology CO.,LTD",
	[3]byte{0, 162, 218}:   "INAT GmbH",
	[3]byte{0, 162, 245}:   "Guangzhou Yuanyun Network Technology Co.,Ltd",
	[3]byte{0, 162, 255}:   "abatec group AG",
	[3]byte{0, 170, 0}:     "INTEL CORPORATION",
	[3]byte{0, 170, 1}:     "INTEL CORPORATION",
	[3]byte{0, 170, 2}:     "INTEL CORPORATION",
	[3]byte{0, 170, 60}:    "OLIVETTI TELECOM SPA (OLTECO)",
	[3]byte{0, 170, 112}:   "LG Electronics",
	[3]byte{0, 172, 224}:   "ARRIS Group, Inc.",
	[3]byte{0, 174, 250}:   "Murata Manufacturing Co., Ltd.",
	[3]byte{0, 176, 9}:     "Grass Valley Group",
	[3]byte{0, 176, 23}:    "InfoGear Technology Corp.",
	[3]byte{0, 176, 25}:    "UTC CCS",
	[3]byte{0, 176, 28}:    "Westport Technologies",
	[3]byte{0, 176, 30}:    "Rantic Labs, Inc.",
	[3]byte{0, 176, 42}:    "ORSYS GmbH",
	[3]byte{0, 176, 45}:    "ViaGate Technologies, Inc.",
	[3]byte{0, 176, 51}:    "OAO \"Izhevskiy radiozavod\"",
	[3]byte{0, 176, 59}:    "HiQ Networks",
	[3]byte{0, 176, 72}:    "Marconi Communications Inc.",
	[3]byte{0, 176, 74}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 176, 82}:    "Atheros Communications",
	[3]byte{0, 176, 100}:   "CISCO SYSTEMS, INC.",
	[3]byte{0, 176, 105}:   "Honewell Oy",
	[3]byte{0, 176, 109}:   "Jones Futurex Inc.",
	[3]byte{0, 176, 128}:   "Mannesmann Ipulsys B.V.",
	[3]byte{0, 176, 134}:   "LocSoft Limited",
	[3]byte{0, 176, 142}:   "CISCO SYSTEMS, INC.",
	[3]byte{0, 176, 145}:   "Transmeta Corp.",
	[3]byte{0, 176, 148}:   "Alaris, Inc.",
	[3]byte{0, 176, 154}:   "Morrow Technologies Corp.",
	[3]byte{0, 176, 157}:   "Point Grey Research Inc.",
	[3]byte{0, 176, 172}:   "SIAE-Microelettronica S.p.A.",
	[3]byte{0, 176, 174}:   "Symmetricom",
	[3]byte{0, 176, 179}:   "Xstreamis PLC",
	[3]byte{0, 176, 194}:   "CISCO SYSTEMS, INC.",
	[3]byte{0, 176, 199}:   "Tellabs Operations, Inc.",
	[3]byte{0, 176, 206}:   "TECHNOLOGY RESCUE",
	[3]byte{0, 176, 208}:   "Dell Computer Corp.",
	[3]byte{0, 176, 219}:   "Nextcell, Inc.",
	[3]byte{0, 176, 223}:   "Starboard Storage Systems",
	[3]byte{0, 176, 231}:   "British Federal Ltd.",
	[3]byte{0, 176, 236}:   "EACEM",
	[3]byte{0, 176, 238}:   "Ajile Systems, Inc.",
	[3]byte{0, 176, 240}:   "CALY NETWORKS",
	[3]byte{0, 176, 245}:   "NetWorth Technologies, Inc.",
	[3]byte{0, 179, 56}:    "Kontron Design Manufacturing Services (M) Sdn. Bhd",
	[3]byte{0, 179, 66}:    "MacroSAN Technologies Co., Ltd.",
	[3]byte{0, 181, 109}:   "David Electronics Co., LTD.",
	[3]byte{0, 181, 214}:   "Omnibit Inc.",
	[3]byte{0, 183, 141}:   "Nanjing Shining Electric Automation Co., Ltd",
	[3]byte{0, 185, 246}:   "Shenzhen Super Rich Electronics Co.,Ltd",
	[3]byte{0, 186, 192}:   "Biometric Access Company",
	[3]byte{0, 187, 1}:     "OCTOTHORPE CORP.",
	[3]byte{0, 187, 58}:    "PRIVATE",
	[3]byte{0, 187, 142}:   "HME Co., Ltd.",
	[3]byte{0, 187, 240}:   "UNGERMANN-BASS INC.",
	[3]byte{0, 189, 39}:    "Exar Corp.",
	[3]byte{0, 189, 58}:    "Nokia Corporation",
	[3]byte{0, 191, 21}:    "Genetec Inc.",
	[3]byte{0, 192, 0}:     "LANOPTICS, LTD.",
	[3]byte{0, 192, 1}:     "DIATEK PATIENT MANAGMENT",
	[3]byte{0, 192, 2}:     "SERCOMM CORPORATION",
	[3]byte{0, 192, 3}:     "GLOBALNET COMMUNICATIONS",
	[3]byte{0, 192, 4}:     "JAPAN BUSINESS COMPUTER CO.LTD",
	[3]byte{0, 192, 5}:     "LIVINGSTON ENTERPRISES, INC.",
	[3]byte{0, 192, 6}:     "NIPPON AVIONICS CO., LTD.",
	[3]byte{0, 192, 7}:     "PINNACLE DATA SYSTEMS, INC.",
	[3]byte{0, 192, 8}:     "SECO SRL",
	[3]byte{0, 192, 9}:     "KT TECHNOLOGY (S) PTE LTD",
	[3]byte{0, 192, 10}:    "MICRO CRAFT",
	[3]byte{0, 192, 11}:    "NORCONTROL A.S.",
	[3]byte{0, 192, 12}:    "RELIA TECHNOLGIES",
	[3]byte{0, 192, 13}:    "ADVANCED LOGIC RESEARCH, INC.",
	[3]byte{0, 192, 14}:    "PSITECH, INC.",
	[3]byte{0, 192, 15}:    "QUANTUM SOFTWARE SYSTEMS LTD.",
	[3]byte{0, 192, 16}:    "HIRAKAWA HEWTECH CORP.",
	[3]byte{0, 192, 17}:    "INTERACTIVE COMPUTING DEVICES",
	[3]byte{0, 192, 18}:    "NETSPAN CORPORATION",
	[3]byte{0, 192, 19}:    "NETRIX",
	[3]byte{0, 192, 20}:    "TELEMATICS CALABASAS INT'L,INC",
	[3]byte{0, 192, 21}:    "NEW MEDIA CORPORATION",
	[3]byte{0, 192, 22}:    "ELECTRONIC THEATRE CONTROLS",
	[3]byte{0, 192, 23}:    "Fluke Corporation",
	[3]byte{0, 192, 24}:    "LANART CORPORATION",
	[3]byte{0, 192, 25}:    "LEAP TECHNOLOGY, INC.",
	[3]byte{0, 192, 26}:    "COROMETRICS MEDICAL SYSTEMS",
	[3]byte{0, 192, 27}:    "SOCKET COMMUNICATIONS, INC.",
	[3]byte{0, 192, 28}:    "INTERLINK COMMUNICATIONS LTD.",
	[3]byte{0, 192, 29}:    "GRAND JUNCTION NETWORKS, INC.",
	[3]byte{0, 192, 30}:    "LA FRANCAISE DES JEUX",
	[3]byte{0, 192, 31}:    "S.E.R.C.E.L.",
	[3]byte{0, 192, 32}:    "ARCO ELECTRONIC, CONTROL LTD.",
	[3]byte{0, 192, 33}:    "NETEXPRESS",
	[3]byte{0, 192, 34}:    "LASERMASTER TECHNOLOGIES, INC.",
	[3]byte{0, 192, 35}:    "TUTANKHAMON ELECTRONICS",
	[3]byte{0, 192, 36}:    "EDEN SISTEMAS DE COMPUTACAO SA",
	[3]byte{0, 192, 37}:    "DATAPRODUCTS CORPORATION",
	[3]byte{0, 192, 38}:    "LANS TECHNOLOGY CO., LTD.",
	[3]byte{0, 192, 39}:    "CIPHER SYSTEMS, INC.",
	[3]byte{0, 192, 40}:    "JASCO CORPORATION",
	[3]byte{0, 192, 41}:    "Nexans Deutschland GmbH - ANS",
	[3]byte{0, 192, 42}:    "OHKURA ELECTRIC CO., LTD.",
	[3]byte{0, 192, 43}:    "GERLOFF GESELLSCHAFT FUR",
	[3]byte{0, 192, 44}:    "CENTRUM COMMUNICATIONS, INC.",
	[3]byte{0, 192, 45}:    "FUJI PHOTO FILM CO., LTD.",
	[3]byte{0, 192, 46}:    "NETWIZ",
	[3]byte{0, 192, 47}:    "OKUMA CORPORATION",
	[3]byte{0, 192, 48}:    "INTEGRATED ENGINEERING B. V.",
	[3]byte{0, 192, 49}:    "DESIGN RESEARCH SYSTEMS, INC.",
	[3]byte{0, 192, 50}:    "I-CUBED LIMITED",
	[3]byte{0, 192, 51}:    "TELEBIT COMMUNICATIONS APS",
	[3]byte{0, 192, 52}:    "TRANSACTION NETWORK",
	[3]byte{0, 192, 53}:    "QUINTAR COMPANY",
	[3]byte{0, 192, 54}:    "RAYTECH ELECTRONIC CORP.",
	[3]byte{0, 192, 55}:    "DYNATEM",
	[3]byte{0, 192, 56}:    "RASTER IMAGE PROCESSING SYSTEM",
	[3]byte{0, 192, 57}:    "Teridian Semiconductor Corporation",
	[3]byte{0, 192, 58}:    "MEN-MIKRO ELEKTRONIK GMBH",
	[3]byte{0, 192, 59}:    "MULTIACCESS COMPUTING CORP.",
	[3]byte{0, 192, 60}:    "TOWER TECH S.R.L.",
	[3]byte{0, 192, 61}:    "WIESEMANN & THEIS GMBH",
	[3]byte{0, 192, 62}:    "FA. GEBR. HELLER GMBH",
	[3]byte{0, 192, 63}:    "STORES AUTOMATED SYSTEMS, INC.",
	[3]byte{0, 192, 64}:    "ECCI",
	[3]byte{0, 192, 65}:    "DIGITAL TRANSMISSION SYSTEMS",
	[3]byte{0, 192, 66}:    "DATALUX CORP.",
	[3]byte{0, 192, 67}:    "STRATACOM",
	[3]byte{0, 192, 68}:    "EMCOM CORPORATION",
	[3]byte{0, 192, 69}:    "ISOLATION SYSTEMS, LTD.",
	[3]byte{0, 192, 70}:    "Blue Chip Technology Ltd",
	[3]byte{0, 192, 71}:    "UNIMICRO SYSTEMS, INC.",
	[3]byte{0, 192, 72}:    "BAY TECHNICAL ASSOCIATES",
	[3]byte{0, 192, 73}:    "U.S. ROBOTICS, INC.",
	[3]byte{0, 192, 74}:    "GROUP 2000 AG",
	[3]byte{0, 192, 75}:    "CREATIVE MICROSYSTEMS",
	[3]byte{0, 192, 76}:    "DEPARTMENT OF FOREIGN AFFAIRS",
	[3]byte{0, 192, 77}:    "MITEC, INC.",
	[3]byte{0, 192, 78}:    "COMTROL CORPORATION",
	[3]byte{0, 192, 79}:    "DELL COMPUTER CORPORATION",
	[3]byte{0, 192, 80}:    "TOYO DENKI SEIZO K.K.",
	[3]byte{0, 192, 81}:    "ADVANCED INTEGRATION RESEARCH",
	[3]byte{0, 192, 82}:    "BURR-BROWN",
	[3]byte{0, 192, 83}:    "Aspect Software Inc.",
	[3]byte{0, 192, 84}:    "NETWORK PERIPHERALS, LTD.",
	[3]byte{0, 192, 85}:    "MODULAR COMPUTING TECHNOLOGIES",
	[3]byte{0, 192, 86}:    "SOMELEC",
	[3]byte{0, 192, 87}:    "MYCO ELECTRONICS",
	[3]byte{0, 192, 88}:    "DATAEXPERT CORP.",
	[3]byte{0, 192, 89}:    "DENSO CORPORATION",
	[3]byte{0, 192, 90}:    "SEMAPHORE COMMUNICATIONS CORP.",
	[3]byte{0, 192, 91}:    "NETWORKS NORTHWEST, INC.",
	[3]byte{0, 192, 92}:    "ELONEX PLC",
	[3]byte{0, 192, 93}:    "L&N TECHNOLOGIES",
	[3]byte{0, 192, 94}:    "VARI-LITE, INC.",
	[3]byte{0, 192, 95}:    "FINE-PAL COMPANY LIMITED",
	[3]byte{0, 192, 96}:    "ID SCANDINAVIA AS",
	[3]byte{0, 192, 97}:    "SOLECTEK CORPORATION",
	[3]byte{0, 192, 98}:    "IMPULSE TECHNOLOGY",
	[3]byte{0, 192, 99}:    "MORNING STAR TECHNOLOGIES, INC",
	[3]byte{0, 192, 100}:   "GENERAL DATACOMM IND. INC.",
	[3]byte{0, 192, 101}:   "SCOPE COMMUNICATIONS, INC.",
	[3]byte{0, 192, 102}:   "DOCUPOINT, INC.",
	[3]byte{0, 192, 103}:   "UNITED BARCODE INDUSTRIES",
	[3]byte{0, 192, 104}:   "HME Clear-Com LTD.",
	[3]byte{0, 192, 105}:   "Axxcelera Broadband Wireless",
	[3]byte{0, 192, 106}:   "ZAHNER-ELEKTRIK GMBH & CO. KG",
	[3]byte{0, 192, 107}:   "OSI PLUS CORPORATION",
	[3]byte{0, 192, 108}:   "SVEC COMPUTER CORP.",
	[3]byte{0, 192, 109}:   "BOCA RESEARCH, INC.",
	[3]byte{0, 192, 110}:   "HAFT TECHNOLOGY, INC.",
	[3]byte{0, 192, 111}:   "KOMATSU LTD.",
	[3]byte{0, 192, 112}:   "SECTRA SECURE-TRANSMISSION AB",
	[3]byte{0, 192, 113}:   "AREANEX COMMUNICATIONS, INC.",
	[3]byte{0, 192, 114}:   "KNX LTD.",
	[3]byte{0, 192, 115}:   "XEDIA CORPORATION",
	[3]byte{0, 192, 116}:   "TOYODA AUTOMATIC LOOM",
	[3]byte{0, 192, 117}:   "XANTE CORPORATION",
	[3]byte{0, 192, 118}:   "I-DATA INTERNATIONAL A-S",
	[3]byte{0, 192, 119}:   "DAEWOO TELECOM LTD.",
	[3]byte{0, 192, 120}:   "COMPUTER SYSTEMS ENGINEERING",
	[3]byte{0, 192, 121}:   "FONSYS CO.,LTD.",
	[3]byte{0, 192, 122}:   "PRIVA B.V.",
	[3]byte{0, 192, 123}:   "ASCEND COMMUNICATIONS, INC.",
	[3]byte{0, 192, 124}:   "HIGHTECH INFORMATION",
	[3]byte{0, 192, 125}:   "RISC DEVELOPMENTS LTD.",
	[3]byte{0, 192, 126}:   "KUBOTA CORPORATION ELECTRONIC",
	[3]byte{0, 192, 127}:   "NUPON COMPUTING CORP.",
	[3]byte{0, 192, 128}:   "NETSTAR, INC.",
	[3]byte{0, 192, 129}:   "METRODATA LTD.",
	[3]byte{0, 192, 130}:   "MOORE PRODUCTS CO.",
	[3]byte{0, 192, 131}:   "TRACE MOUNTAIN PRODUCTS, INC.",
	[3]byte{0, 192, 132}:   "DATA LINK CORP. LTD.",
	[3]byte{0, 192, 133}:   "ELECTRONICS FOR IMAGING, INC.",
	[3]byte{0, 192, 134}:   "THE LYNK CORPORATION",
	[3]byte{0, 192, 135}:   "UUNET TECHNOLOGIES, INC.",
	[3]byte{0, 192, 136}:   "EKF ELEKTRONIK GMBH",
	[3]byte{0, 192, 137}:   "TELINDUS DISTRIBUTION",
	[3]byte{0, 192, 138}:   "Lauterbach GmbH",
	[3]byte{0, 192, 139}:   "RISQ MODULAR SYSTEMS, INC.",
	[3]byte{0, 192, 140}:   "PERFORMANCE TECHNOLOGIES, INC.",
	[3]byte{0, 192, 141}:   "TRONIX PRODUCT DEVELOPMENT",
	[3]byte{0, 192, 142}:   "NETWORK INFORMATION TECHNOLOGY",
	[3]byte{0, 192, 143}:   "Panasonic Electric Works Co., Ltd.",
	[3]byte{0, 192, 144}:   "PRAIM S.R.L.",
	[3]byte{0, 192, 145}:   "JABIL CIRCUIT, INC.",
	[3]byte{0, 192, 146}:   "MENNEN MEDICAL INC.",
	[3]byte{0, 192, 147}:   "ALTA RESEARCH CORP.",
	[3]byte{0, 192, 148}:   "VMX INC.",
	[3]byte{0, 192, 149}:   "ZNYX",
	[3]byte{0, 192, 150}:   "TAMURA CORPORATION",
	[3]byte{0, 192, 151}:   "ARCHIPEL SA",
	[3]byte{0, 192, 152}:   "CHUNTEX ELECTRONIC CO., LTD.",
	[3]byte{0, 192, 153}:   "YOSHIKI INDUSTRIAL CO.,LTD.",
	[3]byte{0, 192, 154}:   "PHOTONICS CORPORATION",
	[3]byte{0, 192, 155}:   "RELIANCE COMM/TEC, R-TEC",
	[3]byte{0, 192, 156}:   "HIOKI E.E. CORPORATION",
	[3]byte{0, 192, 157}:   "DISTRIBUTED SYSTEMS INT'L, INC",
	[3]byte{0, 192, 158}:   "CACHE COMPUTERS, INC.",
	[3]byte{0, 192, 159}:   "QUANTA COMPUTER, INC.",
	[3]byte{0, 192, 160}:   "ADVANCE MICRO RESEARCH, INC.",
	[3]byte{0, 192, 161}:   "TOKYO DENSHI SEKEI CO.",
	[3]byte{0, 192, 162}:   "INTERMEDIUM A/S",
	[3]byte{0, 192, 163}:   "DUAL ENTERPRISES CORPORATION",
	[3]byte{0, 192, 164}:   "UNIGRAF OY",
	[3]byte{0, 192, 165}:   "DICKENS DATA SYSTEMS",
	[3]byte{0, 192, 166}:   "EXICOM AUSTRALIA PTY. LTD",
	[3]byte{0, 192, 167}:   "SEEL LTD.",
	[3]byte{0, 192, 168}:   "GVC CORPORATION",
	[3]byte{0, 192, 169}:   "BARRON MCCANN LTD.",
	[3]byte{0, 192, 170}:   "SILICON VALLEY COMPUTER",
	[3]byte{0, 192, 171}:   "Telco Systems, Inc.",
	[3]byte{0, 192, 172}:   "GAMBIT COMPUTER COMMUNICATIONS",
	[3]byte{0, 192, 173}:   "MARBEN COMMUNICATION SYSTEMS",
	[3]byte{0, 192, 174}:   "TOWERCOM CO. INC. DBA PC HOUSE",
	[3]byte{0, 192, 175}:   "TEKLOGIX INC.",
	[3]byte{0, 192, 176}:   "GCC TECHNOLOGIES,INC.",
	[3]byte{0, 192, 177}:   "GENIUS NET CO.",
	[3]byte{0, 192, 178}:   "NORAND CORPORATION",
	[3]byte{0, 192, 179}:   "COMSTAT DATACOMM CORPORATION",
	[3]byte{0, 192, 180}:   "MYSON TECHNOLOGY, INC.",
	[3]byte{0, 192, 181}:   "CORPORATE NETWORK SYSTEMS,INC.",
	[3]byte{0, 192, 182}:   "Overland Storage, Inc.",
	[3]byte{0, 192, 183}:   "AMERICAN POWER CONVERSION CORP",
	[3]byte{0, 192, 184}:   "FRASER'S HILL LTD.",
	[3]byte{0, 192, 185}:   "FUNK SOFTWARE, INC.",
	[3]byte{0, 192, 186}:   "NETVANTAGE",
	[3]byte{0, 192, 187}:   "FORVAL CREATIVE, INC.",
	[3]byte{0, 192, 188}:   "TELECOM AUSTRALIA/CSSC",
	[3]byte{0, 192, 189}:   "INEX TECHNOLOGIES, INC.",
	[3]byte{0, 192, 190}:   "ALCATEL - SEL",
	[3]byte{0, 192, 191}:   "TECHNOLOGY CONCEPTS, LTD.",
	[3]byte{0, 192, 192}:   "SHORE MICROSYSTEMS, INC.",
	[3]byte{0, 192, 193}:   "QUAD/GRAPHICS, INC.",
	[3]byte{0, 192, 194}:   "INFINITE NETWORKS LTD.",
	[3]byte{0, 192, 195}:   "ACUSON COMPUTED SONOGRAPHY",
	[3]byte{0, 192, 196}:   "COMPUTER OPERATIONAL",
	[3]byte{0, 192, 197}:   "SID INFORMATICA",
	[3]byte{0, 192, 198}:   "PERSONAL MEDIA CORP.",
	[3]byte{0, 192, 199}:   "SPARKTRUM MICROSYSTEMS, INC.",
	[3]byte{0, 192, 200}:   "MICRO BYTE PTY. LTD.",
	[3]byte{0, 192, 201}:   "ELSAG BAILEY PROCESS",
	[3]byte{0, 192, 202}:   "ALFA, INC.",
	[3]byte{0, 192, 203}:   "CONTROL TECHNOLOGY CORPORATION",
	[3]byte{0, 192, 204}:   "TELESCIENCES CO SYSTEMS, INC.",
	[3]byte{0, 192, 205}:   "COMELTA, S.A.",
	[3]byte{0, 192, 206}:   "CEI SYSTEMS & ENGINEERING PTE",
	[3]byte{0, 192, 207}:   "IMATRAN VOIMA OY",
	[3]byte{0, 192, 208}:   "RATOC SYSTEM INC.",
	[3]byte{0, 192, 209}:   "COMTREE TECHNOLOGY CORPORATION",
	[3]byte{0, 192, 210}:   "SYNTELLECT, INC.",
	[3]byte{0, 192, 211}:   "OLYMPUS IMAGE SYSTEMS, INC.",
	[3]byte{0, 192, 212}:   "AXON NETWORKS, INC.",
	[3]byte{0, 192, 213}:   "Werbeagentur Jürgen Siebert",
	[3]byte{0, 192, 214}:   "J1 SYSTEMS, INC.",
	[3]byte{0, 192, 215}:   "TAIWAN TRADING CENTER DBA",
	[3]byte{0, 192, 216}:   "UNIVERSAL DATA SYSTEMS",
	[3]byte{0, 192, 217}:   "QUINTE NETWORK CONFIDENTIALITY",
	[3]byte{0, 192, 218}:   "NICE SYSTEMS LTD.",
	[3]byte{0, 192, 219}:   "IPC CORPORATION (PTE) LTD.",
	[3]byte{0, 192, 220}:   "EOS TECHNOLOGIES, INC.",
	[3]byte{0, 192, 221}:   "QLogic Corporation",
	[3]byte{0, 192, 222}:   "ZCOMM, INC.",
	[3]byte{0, 192, 223}:   "KYE Systems Corp.",
	[3]byte{0, 192, 224}:   "DSC COMMUNICATION CORP.",
	[3]byte{0, 192, 225}:   "SONIC SOLUTIONS",
	[3]byte{0, 192, 226}:   "CALCOMP, INC.",
	[3]byte{0, 192, 227}:   "OSITECH COMMUNICATIONS, INC.",
	[3]byte{0, 192, 228}:   "SIEMENS BUILDING",
	[3]byte{0, 192, 229}:   "GESPAC, S.A.",
	[3]byte{0, 192, 230}:   "Verilink Corporation",
	[3]byte{0, 192, 231}:   "FIBERDATA AB",
	[3]byte{0, 192, 232}:   "PLEXCOM, INC.",
	[3]byte{0, 192, 233}:   "OAK SOLUTIONS, LTD.",
	[3]byte{0, 192, 234}:   "ARRAY TECHNOLOGY LTD.",
	[3]byte{0, 192, 235}:   "SEH COMPUTERTECHNIK GMBH",
	[3]byte{0, 192, 236}:   "DAUPHIN TECHNOLOGY",
	[3]byte{0, 192, 237}:   "US ARMY ELECTRONIC",
	[3]byte{0, 192, 238}:   "KYOCERA CORPORATION",
	[3]byte{0, 192, 239}:   "ABIT CORPORATION",
	[3]byte{0, 192, 240}:   "KINGSTON TECHNOLOGY CORP.",
	[3]byte{0, 192, 241}:   "SHINKO ELECTRIC CO., LTD.",
	[3]byte{0, 192, 242}:   "TRANSITION NETWORKS",
	[3]byte{0, 192, 243}:   "NETWORK COMMUNICATIONS CORP.",
	[3]byte{0, 192, 244}:   "INTERLINK SYSTEM CO., LTD.",
	[3]byte{0, 192, 245}:   "METACOMP, INC.",
	[3]byte{0, 192, 246}:   "CELAN TECHNOLOGY INC.",
	[3]byte{0, 192, 247}:   "ENGAGE COMMUNICATION, INC.",
	[3]byte{0, 192, 248}:   "ABOUT COMPUTING INC.",
	[3]byte{0, 192, 249}:   "Artesyn Embedded Technologies",
	[3]byte{0, 192, 250}:   "CANARY COMMUNICATIONS, INC.",
	[3]byte{0, 192, 251}:   "ADVANCED TECHNOLOGY LABS",
	[3]byte{0, 192, 252}:   "ELASTIC REALITY, INC.",
	[3]byte{0, 192, 253}:   "PROSUM",
	[3]byte{0, 192, 254}:   "APTEC COMPUTER SYSTEMS, INC.",
	[3]byte{0, 192, 255}:   "DOT HILL SYSTEMS CORPORATION",
	[3]byte{0, 193, 79}:    "DDL Co,.ltd.",
	[3]byte{0, 194, 198}:   "Intel Corporate",
	[3]byte{0, 197, 219}:   "Datatech Sistemas Digitales Avanzados SL",
	[3]byte{0, 198, 16}:    "Apple",
	[3]byte{0, 203, 189}:   "Cambridge Broadband Networks Ltd.",
	[3]byte{0, 205, 144}:   "MAS Elektronik AG",
	[3]byte{0, 207, 28}:    "COMMUNICATION MACHINERY CORP.",
	[3]byte{0, 208, 0}:     "FERRAN SCIENTIFIC, INC.",
	[3]byte{0, 208, 1}:     "VST TECHNOLOGIES, INC.",
	[3]byte{0, 208, 2}:     "DITECH CORPORATION",
	[3]byte{0, 208, 3}:     "COMDA ENTERPRISES CORP.",
	[3]byte{0, 208, 4}:     "PENTACOM LTD.",
	[3]byte{0, 208, 5}:     "ZHS ZEITMANAGEMENTSYSTEME",
	[3]byte{0, 208, 6}:     "CISCO SYSTEMS, INC.",
	[3]byte{0, 208, 7}:     "MIC ASSOCIATES, INC.",
	[3]byte{0, 208, 8}:     "MACTELL CORPORATION",
	[3]byte{0, 208, 9}:     "HSING TECH. ENTERPRISE CO. LTD",
	[3]byte{0, 208, 10}:    "LANACCESS TELECOM S.A.",
	[3]byte{0, 208, 11}:    "RHK TECHNOLOGY, INC.",
	[3]byte{0, 208, 12}:    "SNIJDER MICRO SYSTEMS",
	[3]byte{0, 208, 13}:    "MICROMERITICS INSTRUMENT",
	[3]byte{0, 208, 14}:    "PLURIS, INC.",
	[3]byte{0, 208, 15}:    "SPEECH DESIGN GMBH",
	[3]byte{0, 208, 16}:    "CONVERGENT NETWORKS, INC.",
	[3]byte{0, 208, 17}:    "PRISM VIDEO, INC.",
	[3]byte{0, 208, 18}:    "GATEWORKS CORP.",
	[3]byte{0, 208, 19}:    "PRIMEX AEROSPACE COMPANY",
	[3]byte{0, 208, 20}:    "ROOT, INC.",
	[3]byte{0, 208, 21}:    "UNIVEX MICROTECHNOLOGY CORP.",
	[3]byte{0, 208, 22}:    "SCM MICROSYSTEMS, INC.",
	[3]byte{0, 208, 23}:    "SYNTECH INFORMATION CO., LTD.",
	[3]byte{0, 208, 24}:    "QWES. COM, INC.",
	[3]byte{0, 208, 25}:    "DAINIPPON SCREEN CORPORATE",
	[3]byte{0, 208, 26}:    "URMET  TLC S.P.A.",
	[3]byte{0, 208, 27}:    "MIMAKI ENGINEERING CO., LTD.",
	[3]byte{0, 208, 28}:    "SBS TECHNOLOGIES,",
	[3]byte{0, 208, 29}:    "FURUNO ELECTRIC CO., LTD.",
	[3]byte{0, 208, 30}:    "PINGTEL CORP.",
	[3]byte{0, 208, 31}:    "Senetas Security",
	[3]byte{0, 208, 32}:    "AIM SYSTEM, INC.",
	[3]byte{0, 208, 33}:    "REGENT ELECTRONICS CORP.",
	[3]byte{0, 208, 34}:    "INCREDIBLE TECHNOLOGIES, INC.",
	[3]byte{0, 208, 35}:    "INFORTREND TECHNOLOGY, INC.",
	[3]byte{0, 208, 36}:    "Cognex Corporation",
	[3]byte{0, 208, 37}:    "XROSSTECH, INC.",
	[3]byte{0, 208, 38}:    "HIRSCHMANN AUSTRIA GMBH",
	[3]byte{0, 208, 39}:    "APPLIED AUTOMATION, INC.",
	[3]byte{0, 208, 40}:    "Harmonic, Inc",
	[3]byte{0, 208, 41}:    "WAKEFERN FOOD CORPORATION",
	[3]byte{0, 208, 42}:    "Voxent Systems Ltd.",
	[3]byte{0, 208, 43}:    "JETCELL, INC.",
	[3]byte{0, 208, 44}:    "CAMPBELL SCIENTIFIC, INC.",
	[3]byte{0, 208, 45}:    "ADEMCO",
	[3]byte{0, 208, 46}:    "COMMUNICATION AUTOMATION CORP.",
	[3]byte{0, 208, 47}:    "VLSI TECHNOLOGY INC.",
	[3]byte{0, 208, 48}:    "Safetran Systems Corp",
	[3]byte{0, 208, 49}:    "INDUSTRIAL LOGIC CORPORATION",
	[3]byte{0, 208, 50}:    "YANO ELECTRIC CO., LTD.",
	[3]byte{0, 208, 51}:    "DALIAN DAXIAN NETWORK",
	[3]byte{0, 208, 52}:    "ORMEC SYSTEMS CORP.",
	[3]byte{0, 208, 53}:    "BEHAVIOR TECH. COMPUTER CORP.",
	[3]byte{0, 208, 54}:    "TECHNOLOGY ATLANTA CORP.",
	[3]byte{0, 208, 55}:    "Pace France",
	[3]byte{0, 208, 56}:    "FIVEMERE, LTD.",
	[3]byte{0, 208, 57}:    "UTILICOM, INC.",
	[3]byte{0, 208, 58}:    "ZONEWORX, INC.",
	[3]byte{0, 208, 59}:    "VISION PRODUCTS PTY. LTD.",
	[3]byte{0, 208, 60}:    "Vieo, Inc.",
	[3]byte{0, 208, 61}:    "GALILEO TECHNOLOGY, LTD.",
	[3]byte{0, 208, 62}:    "ROCKETCHIPS, INC.",
	[3]byte{0, 208, 63}:    "AMERICAN COMMUNICATION",
	[3]byte{0, 208, 64}:    "SYSMATE CO., LTD.",
	[3]byte{0, 208, 65}:    "AMIGO TECHNOLOGY CO., LTD.",
	[3]byte{0, 208, 66}:    "MAHLO GMBH & CO. UG",
	[3]byte{0, 208, 67}:    "ZONAL RETAIL DATA SYSTEMS",
	[3]byte{0, 208, 68}:    "ALIDIAN NETWORKS, INC.",
	[3]byte{0, 208, 69}:    "KVASER AB",
	[3]byte{0, 208, 70}:    "DOLBY LABORATORIES, INC.",
	[3]byte{0, 208, 71}:    "XN TECHNOLOGIES",
	[3]byte{0, 208, 72}:    "ECTON, INC.",
	[3]byte{0, 208, 73}:    "IMPRESSTEK CO., LTD.",
	[3]byte{0, 208, 74}:    "PRESENCE TECHNOLOGY GMBH",
	[3]byte{0, 208, 75}:    "LA CIE GROUP S.A.",
	[3]byte{0, 208, 76}:    "EUROTEL TELECOM LTD.",
	[3]byte{0, 208, 77}:    "DIV OF RESEARCH & STATISTICS",
	[3]byte{0, 208, 78}:    "LOGIBAG",
	[3]byte{0, 208, 79}:    "BITRONICS, INC.",
	[3]byte{0, 208, 80}:    "ISKRATEL",
	[3]byte{0, 208, 81}:    "O2 MICRO, INC.",
	[3]byte{0, 208, 82}:    "ASCEND COMMUNICATIONS, INC.",
	[3]byte{0, 208, 83}:    "CONNECTED SYSTEMS",
	[3]byte{0, 208, 84}:    "SAS INSTITUTE INC.",
	[3]byte{0, 208, 85}:    "KATHREIN-WERKE KG",
	[3]byte{0, 208, 86}:    "SOMAT CORPORATION",
	[3]byte{0, 208, 87}:    "ULTRAK, INC.",
	[3]byte{0, 208, 88}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 208, 89}:    "AMBIT MICROSYSTEMS CORP.",
	[3]byte{0, 208, 90}:    "SYMBIONICS, LTD.",
	[3]byte{0, 208, 91}:    "ACROLOOP MOTION CONTROL",
	[3]byte{0, 208, 92}:    "TECHNOTREND SYSTEMTECHNIK GMBH",
	[3]byte{0, 208, 93}:    "INTELLIWORXX, INC.",
	[3]byte{0, 208, 94}:    "STRATABEAM TECHNOLOGY, INC.",
	[3]byte{0, 208, 95}:    "VALCOM, INC.",
	[3]byte{0, 208, 96}:    "Panasonic Europe Ltd.",
	[3]byte{0, 208, 97}:    "TREMON ENTERPRISES CO., LTD.",
	[3]byte{0, 208, 98}:    "DIGIGRAM",
	[3]byte{0, 208, 99}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 208, 100}:   "MULTITEL",
	[3]byte{0, 208, 101}:   "TOKO ELECTRIC",
	[3]byte{0, 208, 102}:   "WINTRISS ENGINEERING CORP.",
	[3]byte{0, 208, 103}:   "CAMPIO COMMUNICATIONS",
	[3]byte{0, 208, 104}:   "IWILL CORPORATION",
	[3]byte{0, 208, 105}:   "TECHNOLOGIC SYSTEMS",
	[3]byte{0, 208, 106}:   "LINKUP SYSTEMS CORPORATION",
	[3]byte{0, 208, 107}:   "SR TELECOM INC.",
	[3]byte{0, 208, 108}:   "SHAREWAVE, INC.",
	[3]byte{0, 208, 109}:   "ACRISON, INC.",
	[3]byte{0, 208, 110}:   "TRENDVIEW RECORDERS LTD.",
	[3]byte{0, 208, 111}:   "KMC CONTROLS",
	[3]byte{0, 208, 112}:   "LONG WELL ELECTRONICS CORP.",
	[3]byte{0, 208, 113}:   "ECHELON CORP.",
	[3]byte{0, 208, 114}:   "BROADLOGIC",
	[3]byte{0, 208, 115}:   "ACN ADVANCED COMMUNICATIONS",
	[3]byte{0, 208, 116}:   "TAQUA SYSTEMS, INC.",
	[3]byte{0, 208, 117}:   "ALARIS MEDICAL SYSTEMS, INC.",
	[3]byte{0, 208, 118}:   "Bank of America",
	[3]byte{0, 208, 119}:   "LUCENT TECHNOLOGIES",
	[3]byte{0, 208, 120}:   "Eltex of Sweden AB",
	[3]byte{0, 208, 121}:   "CISCO SYSTEMS, INC.",
	[3]byte{0, 208, 122}:   "AMAQUEST COMPUTER CORP.",
	[3]byte{0, 208, 123}:   "COMCAM INTERNATIONAL INC",
	[3]byte{0, 208, 124}:   "KOYO ELECTRONICS INC. CO.,LTD.",
	[3]byte{0, 208, 125}:   "COSINE COMMUNICATIONS",
	[3]byte{0, 208, 126}:   "KEYCORP LTD.",
	[3]byte{0, 208, 127}:   "STRATEGY & TECHNOLOGY, LIMITED",
	[3]byte{0, 208, 128}:   "EXABYTE CORPORATION",
	[3]byte{0, 208, 129}:   "RTD Embedded Technologies, Inc.",
	[3]byte{0, 208, 130}:   "IOWAVE INC.",
	[3]byte{0, 208, 131}:   "INVERTEX, INC.",
	[3]byte{0, 208, 132}:   "NEXCOMM SYSTEMS, INC.",
	[3]byte{0, 208, 133}:   "OTIS ELEVATOR COMPANY",
	[3]byte{0, 208, 134}:   "FOVEON, INC.",
	[3]byte{0, 208, 135}:   "MICROFIRST INC.",
	[3]byte{0, 208, 136}:   "ARRIS Group, Inc.",
	[3]byte{0, 208, 137}:   "DYNACOLOR, INC.",
	[3]byte{0, 208, 138}:   "PHOTRON USA",
	[3]byte{0, 208, 139}:   "ADVA Optical Networking Ltd.",
	[3]byte{0, 208, 140}:   "GENOA TECHNOLOGY, INC.",
	[3]byte{0, 208, 141}:   "PHOENIX GROUP, INC.",
	[3]byte{0, 208, 142}:   "NVISION INC.",
	[3]byte{0, 208, 143}:   "ARDENT TECHNOLOGIES, INC.",
	[3]byte{0, 208, 144}:   "CISCO SYSTEMS, INC.",
	[3]byte{0, 208, 145}:   "SMARTSAN SYSTEMS, INC.",
	[3]byte{0, 208, 146}:   "GLENAYRE WESTERN MULTIPLEX",
	[3]byte{0, 208, 147}:   "TQ - COMPONENTS GMBH",
	[3]byte{0, 208, 148}:   "TIMELINE VISTA, INC.",
	[3]byte{0, 208, 149}:   "Alcatel-Lucent, Enterprise Business Group",
	[3]byte{0, 208, 150}:   "3COM EUROPE LTD.",
	[3]byte{0, 208, 151}:   "CISCO SYSTEMS, INC.",
	[3]byte{0, 208, 152}:   "Photon Dynamics Canada Inc.",
	[3]byte{0, 208, 153}:   "Elcard Wireless Systems Oy",
	[3]byte{0, 208, 154}:   "FILANET CORPORATION",
	[3]byte{0, 208, 155}:   "SPECTEL LTD.",
	[3]byte{0, 208, 156}:   "KAPADIA COMMUNICATIONS",
	[3]byte{0, 208, 157}:   "VERIS INDUSTRIES",
	[3]byte{0, 208, 158}:   "2WIRE, INC.",
	[3]byte{0, 208, 159}:   "NOVTEK TEST SYSTEMS",
	[3]byte{0, 208, 160}:   "MIPS DENMARK",
	[3]byte{0, 208, 161}:   "OSKAR VIERLING GMBH + CO. KG",
	[3]byte{0, 208, 162}:   "INTEGRATED DEVICE",
	[3]byte{0, 208, 163}:   "VOCAL DATA, INC.",
	[3]byte{0, 208, 164}:   "ALANTRO COMMUNICATIONS",
	[3]byte{0, 208, 165}:   "AMERICAN ARIUM",
	[3]byte{0, 208, 166}:   "LANBIRD TECHNOLOGY CO., LTD.",
	[3]byte{0, 208, 167}:   "TOKYO SOKKI KENKYUJO CO., LTD.",
	[3]byte{0, 208, 168}:   "NETWORK ENGINES, INC.",
	[3]byte{0, 208, 169}:   "SHINANO KENSHI CO., LTD.",
	[3]byte{0, 208, 170}:   "CHASE COMMUNICATIONS",
	[3]byte{0, 208, 171}:   "DELTAKABEL TELECOM CV",
	[3]byte{0, 208, 172}:   "GRAYSON WIRELESS",
	[3]byte{0, 208, 173}:   "TL INDUSTRIES",
	[3]byte{0, 208, 174}:   "ORESIS COMMUNICATIONS, INC.",
	[3]byte{0, 208, 175}:   "CUTLER-HAMMER, INC.",
	[3]byte{0, 208, 176}:   "BITSWITCH LTD.",
	[3]byte{0, 208, 177}:   "OMEGA ELECTRONICS SA",
	[3]byte{0, 208, 178}:   "XIOTECH CORPORATION",
	[3]byte{0, 208, 179}:   "DRS Technologies Canada Ltd",
	[3]byte{0, 208, 180}:   "KATSUJIMA CO., LTD.",
	[3]byte{0, 208, 181}:   "IPricot formerly DotCom",
	[3]byte{0, 208, 182}:   "CRESCENT NETWORKS, INC.",
	[3]byte{0, 208, 183}:   "INTEL CORPORATION",
	[3]byte{0, 208, 184}:   "Iomega Corporation",
	[3]byte{0, 208, 185}:   "MICROTEK INTERNATIONAL, INC.",
	[3]byte{0, 208, 186}:   "CISCO SYSTEMS, INC.",
	[3]byte{0, 208, 187}:   "CISCO SYSTEMS, INC.",
	[3]byte{0, 208, 188}:   "CISCO SYSTEMS, INC.",
	[3]byte{0, 208, 189}:   "Silicon Image GmbH",
	[3]byte{0, 208, 190}:   "EMUTEC INC.",
	[3]byte{0, 208, 191}:   "PIVOTAL TECHNOLOGIES",
	[3]byte{0, 208, 192}:   "CISCO SYSTEMS, INC.",
	[3]byte{0, 208, 193}:   "HARMONIC DATA SYSTEMS, LTD.",
	[3]byte{0, 208, 194}:   "BALTHAZAR TECHNOLOGY AB",
	[3]byte{0, 208, 195}:   "VIVID TECHNOLOGY PTE, LTD.",
	[3]byte{0, 208, 196}:   "TERATECH CORPORATION",
	[3]byte{0, 208, 197}:   "COMPUTATIONAL SYSTEMS, INC.",
	[3]byte{0, 208, 198}:   "THOMAS & BETTS CORP.",
	[3]byte{0, 208, 199}:   "PATHWAY, INC.",
	[3]byte{0, 208, 200}:   "Prevas A/S",
	[3]byte{0, 208, 201}:   "ADVANTECH CO., LTD.",
	[3]byte{0, 208, 202}:   "Intrinsyc Software International Inc.",
	[3]byte{0, 208, 203}:   "DASAN CO., LTD.",
	[3]byte{0, 208, 204}:   "TECHNOLOGIES LYRE INC.",
	[3]byte{0, 208, 205}:   "ATAN TECHNOLOGY INC.",
	[3]byte{0, 208, 206}:   "ASYST ELECTRONIC",
	[3]byte{0, 208, 207}:   "MORETON BAY",
	[3]byte{0, 208, 208}:   "ZHONGXING TELECOM LTD.",
	[3]byte{0, 208, 209}:   "Sycamore Networks",
	[3]byte{0, 208, 210}:   "EPILOG CORPORATION",
	[3]byte{0, 208, 211}:   "CISCO SYSTEMS, INC.",
	[3]byte{0, 208, 212}:   "V-BITS, INC.",
	[3]byte{0, 208, 213}:   "GRUNDIG AG",
	[3]byte{0, 208, 214}:   "AETHRA TELECOMUNICAZIONI",
	[3]byte{0, 208, 215}:   "B2C2, INC.",
	[3]byte{0, 208, 216}:   "3Com Corporation",
	[3]byte{0, 208, 217}:   "DEDICATED MICROCOMPUTERS",
	[3]byte{0, 208, 218}:   "TAICOM DATA SYSTEMS CO., LTD.",
	[3]byte{0, 208, 219}:   "MCQUAY INTERNATIONAL",
	[3]byte{0, 208, 220}:   "MODULAR MINING SYSTEMS, INC.",
	[3]byte{0, 208, 221}:   "SUNRISE TELECOM, INC.",
	[3]byte{0, 208, 222}:   "PHILIPS MULTIMEDIA NETWORK",
	[3]byte{0, 208, 223}:   "KUZUMI ELECTRONICS, INC.",
	[3]byte{0, 208, 224}:   "DOOIN ELECTRONICS CO.",
	[3]byte{0, 208, 225}:   "AVIONITEK ISRAEL INC.",
	[3]byte{0, 208, 226}:   "MRT MICRO, INC.",
	[3]byte{0, 208, 227}:   "ELE-CHEM ENGINEERING CO., LTD.",
	[3]byte{0, 208, 228}:   "CISCO SYSTEMS, INC.",
	[3]byte{0, 208, 229}:   "SOLIDUM SYSTEMS CORP.",
	[3]byte{0, 208, 230}:   "IBOND INC.",
	[3]byte{0, 208, 231}:   "VCON TELECOMMUNICATION LTD.",
	[3]byte{0, 208, 232}:   "MAC SYSTEM CO., LTD.",
	[3]byte{0, 208, 233}:   "Advantage Century Telecommunication Corp.",
	[3]byte{0, 208, 234}:   "NEXTONE COMMUNICATIONS, INC.",
	[3]byte{0, 208, 235}:   "LIGHTERA NETWORKS, INC.",
	[3]byte{0, 208, 236}:   "NAKAYO TELECOMMUNICATIONS, INC",
	[3]byte{0, 208, 237}:   "XIOX",
	[3]byte{0, 208, 238}:   "DICTAPHONE CORPORATION",
	[3]byte{0, 208, 239}:   "IGT",
	[3]byte{0, 208, 240}:   "CONVISION TECHNOLOGY GMBH",
	[3]byte{0, 208, 241}:   "SEGA ENTERPRISES, LTD.",
	[3]byte{0, 208, 242}:   "MONTEREY NETWORKS",
	[3]byte{0, 208, 243}:   "SOLARI DI UDINE SPA",
	[3]byte{0, 208, 244}:   "CARINTHIAN TECH INSTITUTE",
	[3]byte{0, 208, 245}:   "ORANGE MICRO, INC.",
	[3]byte{0, 208, 246}:   "Alcatel Canada",
	[3]byte{0, 208, 247}:   "NEXT NETS CORPORATION",
	[3]byte{0, 208, 248}:   "FUJIAN STAR TERMINAL",
	[3]byte{0, 208, 249}:   "ACUTE COMMUNICATIONS CORP.",
	[3]byte{0, 208, 250}:   "Thales e-Security Ltd.",
	[3]byte{0, 208, 251}:   "TEK MICROSYSTEMS, INCORPORATED",
	[3]byte{0, 208, 252}:   "GRANITE MICROSYSTEMS",
	[3]byte{0, 208, 253}:   "OPTIMA TELE.COM, INC.",
	[3]byte{0, 208, 254}:   "ASTRAL POINT",
	[3]byte{0, 208, 255}:   "CISCO SYSTEMS, INC.",
	[3]byte{0, 209, 28}:    "ACETEL",
	[3]byte{0, 211, 141}:   "Hotel Technology Next Generation",
	[3]byte{0, 214, 50}:    "GE Energy",
	[3]byte{0, 217, 209}:   "Sony Computer Entertainment Inc.",
	[3]byte{0, 219, 30}:    "Albedo Telecom SL",
	[3]byte{0, 219, 69}:    "THAMWAY CO.,LTD.",
	[3]byte{0, 219, 223}:   "Intel Corporate",
	[3]byte{0, 221, 0}:     "UNGERMANN-BASS INC.",
	[3]byte{0, 221, 1}:     "UNGERMANN-BASS INC.",
	[3]byte{0, 221, 2}:     "UNGERMANN-BASS INC.",
	[3]byte{0, 221, 3}:     "UNGERMANN-BASS INC.",
	[3]byte{0, 221, 4}:     "UNGERMANN-BASS INC.",
	[3]byte{0, 221, 5}:     "UNGERMANN-BASS INC.",
	[3]byte{0, 221, 6}:     "UNGERMANN-BASS INC.",
	[3]byte{0, 221, 7}:     "UNGERMANN-BASS INC.",
	[3]byte{0, 221, 8}:     "UNGERMANN-BASS INC.",
	[3]byte{0, 221, 9}:     "UNGERMANN-BASS INC.",
	[3]byte{0, 221, 10}:    "UNGERMANN-BASS INC.",
	[3]byte{0, 221, 11}:    "UNGERMANN-BASS INC.",
	[3]byte{0, 221, 12}:    "UNGERMANN-BASS INC.",
	[3]byte{0, 221, 13}:    "UNGERMANN-BASS INC.",
	[3]byte{0, 221, 14}:    "UNGERMANN-BASS INC.",
	[3]byte{0, 221, 15}:    "UNGERMANN-BASS INC.",
	[3]byte{0, 222, 251}:   "CISCO SYSTEMS, INC.",
	[3]byte{0, 224, 0}:     "Fujitsu Limited",
	[3]byte{0, 224, 1}:     "STRAND LIGHTING LIMITED",
	[3]byte{0, 224, 2}:     "CROSSROADS SYSTEMS, INC.",
	[3]byte{0, 224, 3}:     "NOKIA WIRELESS BUSINESS COMMUN",
	[3]byte{0, 224, 4}:     "PMC-SIERRA, INC.",
	[3]byte{0, 224, 5}:     "TECHNICAL CORP.",
	[3]byte{0, 224, 6}:     "SILICON INTEGRATED SYS. CORP.",
	[3]byte{0, 224, 7}:     "Avaya ECS Ltd",
	[3]byte{0, 224, 8}:     "AMAZING CONTROLS! INC.",
	[3]byte{0, 224, 9}:     "MARATHON TECHNOLOGIES CORP.",
	[3]byte{0, 224, 10}:    "DIBA, INC.",
	[3]byte{0, 224, 11}:    "ROOFTOP COMMUNICATIONS CORP.",
	[3]byte{0, 224, 12}:    "MOTOROLA",
	[3]byte{0, 224, 13}:    "RADIANT SYSTEMS",
	[3]byte{0, 224, 14}:    "AVALON IMAGING SYSTEMS, INC.",
	[3]byte{0, 224, 15}:    "SHANGHAI BAUD DATA",
	[3]byte{0, 224, 16}:    "HESS SB-AUTOMATENBAU GmbH",
	[3]byte{0, 224, 17}:    "Uniden Corporation",
	[3]byte{0, 224, 18}:    "PLUTO TECHNOLOGIES INTERNATIONAL INC.",
	[3]byte{0, 224, 19}:    "EASTERN ELECTRONIC CO., LTD.",
	[3]byte{0, 224, 20}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 224, 21}:    "HEIWA CORPORATION",
	[3]byte{0, 224, 22}:    "RAPID CITY COMMUNICATIONS",
	[3]byte{0, 224, 23}:    "EXXACT GmbH",
	[3]byte{0, 224, 24}:    "ASUSTEK COMPUTER INC.",
	[3]byte{0, 224, 25}:    "ING. GIORDANO ELETTRONICA",
	[3]byte{0, 224, 26}:    "COMTEC SYSTEMS. CO., LTD.",
	[3]byte{0, 224, 27}:    "SPHERE COMMUNICATIONS, INC.",
	[3]byte{0, 224, 28}:    "Cradlepoint, Inc",
	[3]byte{0, 224, 29}:    "WebTV NETWORKS, INC.",
	[3]byte{0, 224, 30}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 224, 31}:    "AVIDIA Systems, Inc.",
	[3]byte{0, 224, 32}:    "TECNOMEN OY",
	[3]byte{0, 224, 33}:    "FREEGATE CORP.",
	[3]byte{0, 224, 34}:    "Analog Devices Inc.",
	[3]byte{0, 224, 35}:    "TELRAD",
	[3]byte{0, 224, 36}:    "GADZOOX NETWORKS",
	[3]byte{0, 224, 37}:    "dit Co., Ltd.",
	[3]byte{0, 224, 38}:    "Redlake MASD LLC",
	[3]byte{0, 224, 39}:    "DUX, INC.",
	[3]byte{0, 224, 40}:    "APTIX CORPORATION",
	[3]byte{0, 224, 41}:    "STANDARD MICROSYSTEMS CORP.",
	[3]byte{0, 224, 42}:    "TANDBERG TELEVISION AS",
	[3]byte{0, 224, 43}:    "EXTREME NETWORKS",
	[3]byte{0, 224, 44}:    "AST COMPUTER",
	[3]byte{0, 224, 45}:    "InnoMediaLogic, Inc.",
	[3]byte{0, 224, 46}:    "SPC ELECTRONICS CORPORATION",
	[3]byte{0, 224, 47}:    "MCNS HOLDINGS, L.P.",
	[3]byte{0, 224, 48}:    "MELITA INTERNATIONAL CORP.",
	[3]byte{0, 224, 49}:    "HAGIWARA ELECTRIC CO., LTD.",
	[3]byte{0, 224, 50}:    "MISYS FINANCIAL SYSTEMS, LTD.",
	[3]byte{0, 224, 51}:    "E.E.P.D. GmbH",
	[3]byte{0, 224, 52}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 224, 53}:    "Artesyn Embedded Technologies",
	[3]byte{0, 224, 54}:    "PIONEER CORPORATION",
	[3]byte{0, 224, 55}:    "CENTURY CORPORATION",
	[3]byte{0, 224, 56}:    "PROXIMA CORPORATION",
	[3]byte{0, 224, 57}:    "PARADYNE CORP.",
	[3]byte{0, 224, 58}:    "CABLETRON SYSTEMS, INC.",
	[3]byte{0, 224, 59}:    "PROMINET CORPORATION",
	[3]byte{0, 224, 60}:    "AdvanSys",
	[3]byte{0, 224, 61}:    "FOCON ELECTRONIC SYSTEMS A/S",
	[3]byte{0, 224, 62}:    "ALFATECH, INC.",
	[3]byte{0, 224, 63}:    "JATON CORPORATION",
	[3]byte{0, 224, 64}:    "DeskStation Technology, Inc.",
	[3]byte{0, 224, 65}:    "CSPI",
	[3]byte{0, 224, 66}:    "Pacom Systems Ltd.",
	[3]byte{0, 224, 67}:    "VitalCom",
	[3]byte{0, 224, 68}:    "LSICS CORPORATION",
	[3]byte{0, 224, 69}:    "TOUCHWAVE, INC.",
	[3]byte{0, 224, 70}:    "BENTLY NEVADA CORP.",
	[3]byte{0, 224, 71}:    "InFocus Corporation",
	[3]byte{0, 224, 72}:    "SDL COMMUNICATIONS, INC.",
	[3]byte{0, 224, 73}:    "MICROWI ELECTRONIC GmbH",
	[3]byte{0, 224, 74}:    "ENHANCED MESSAGING SYSTEMS, INC",
	[3]byte{0, 224, 75}:    "JUMP INDUSTRIELLE COMPUTERTECHNIK GmbH",
	[3]byte{0, 224, 76}:    "REALTEK SEMICONDUCTOR CORP.",
	[3]byte{0, 224, 77}:    "INTERNET INITIATIVE JAPAN, INC",
	[3]byte{0, 224, 78}:    "SANYO DENKI CO., LTD.",
	[3]byte{0, 224, 79}:    "CISCO SYSTEMS, INC.",
	[3]byte{0, 224, 80}:    "EXECUTONE INFORMATION SYSTEMS, INC.",
	[3]byte{0, 224, 81}:    "TALX CORPORATION",
	[3]byte{0, 224, 82}:    "Brocade Communications Systems, Inc",
	[3]byte{0, 224, 83}:    "CELLPORT LABS, INC.",
	[3]byte{0, 224, 84}:    "KODAI HITEC CO., LTD.",
	[3]byte{0, 224, 85}:    "INGENIERIA ELECTRONICA COMERCIAL INELCOM S.A.",
	[3]byte{0, 224, 86}:    "HOLONTECH CORPORATION",
	[3]byte{0, 224, 87}:    "HAN MICROTELECOM. CO., LTD.",
	[3]byte{0, 224, 88}:    "PHASE ONE DENMARK A/S",
	[3]byte{0, 224, 89}:    "CONTROLLED ENVIRONMENTS, LTD.",
	[3]byte{0, 224, 90}:    "GALEA NETWORK SECURITY",
	[3]byte{0, 224, 91}:    "WEST END SYSTEMS CORP.",
	[3]byte{0, 224, 92}:    "MATSUSHITA KOTOBUKI ELECTRONICS INDUSTRIES, LTD.",
	[3]byte{0, 224, 93}:    "UNITEC CO., LTD.",
	[3]byte{0, 224, 94}:    "JAPAN AVIATION ELECTRONICS INDUSTRY, LTD.",
	[3]byte{0, 224, 95}:    "e-Net, Inc.",
	[3]byte{0, 224, 96}:    "SHERWOOD",
	[3]byte{0, 224, 97}:    "EdgePoint Networks, Inc.",
	[3]byte{0, 224, 98}:    "HOST ENGINEERING",
	[3]byte{0, 224, 99}:    "CABLETRON - YAGO SYSTEMS, INC.",
	[3]byte{0, 224, 100}:   "SAMSUNG ELECTRONICS",
	[3]byte{0, 224, 101}:   "OPTICAL ACCESS INTERNATIONAL",
	[3]byte{0, 224, 102}:   "ProMax Systems, Inc.",
	[3]byte{0, 224, 103}:   "eac AUTOMATION-CONSULTING GmbH",
	[3]byte{0, 224, 104}:   "MERRIMAC SYSTEMS INC.",
	[3]byte{0, 224, 105}:   "JAYCOR",
	[3]byte{0, 224, 106}:   "KAPSCH AG",
	[3]byte{0, 224, 107}:   "W&G SPECIAL PRODUCTS",
	[3]byte{0, 224, 108}:   "Ultra Electronics Limited (AEP Networks)",
	[3]byte{0, 224, 109}:   "COMPUWARE CORPORATION",
	[3]byte{0, 224, 110}:   "FAR SYSTEMS S.p.A.",
	[3]byte{0, 224, 111}:   "ARRIS Group, Inc.",
	[3]byte{0, 224, 112}:   "DH TECHNOLOGY",
	[3]byte{0, 224, 113}:   "EPIS MICROCOMPUTER",
	[3]byte{0, 224, 114}:   "LYNK",
	[3]byte{0, 224, 115}:   "NATIONAL AMUSEMENT NETWORK, INC.",
	[3]byte{0, 224, 116}:   "TIERNAN COMMUNICATIONS, INC.",
	[3]byte{0, 224, 117}:   "Verilink Corporation",
	[3]byte{0, 224, 118}:   "DEVELOPMENT CONCEPTS, INC.",
	[3]byte{0, 224, 119}:   "WEBGEAR, INC.",
	[3]byte{0, 224, 120}:   "BERKELEY NETWORKS",
	[3]byte{0, 224, 121}:   "A.T.N.R.",
	[3]byte{0, 224, 122}:   "MIKRODIDAKT AB",
	[3]byte{0, 224, 123}:   "BAY NETWORKS",
	[3]byte{0, 224, 124}:   "METTLER-TOLEDO, INC.",
	[3]byte{0, 224, 125}:   "NETRONIX, INC.",
	[3]byte{0, 224, 126}:   "WALT DISNEY IMAGINEERING",
	[3]byte{0, 224, 127}:   "LOGISTISTEM s.r.l.",
	[3]byte{0, 224, 128}:   "CONTROL RESOURCES CORPORATION",
	[3]byte{0, 224, 129}:   "TYAN COMPUTER CORP.",
	[3]byte{0, 224, 130}:   "ANERMA",
	[3]byte{0, 224, 131}:   "JATO TECHNOLOGIES, INC.",
	[3]byte{0, 224, 132}:   "COMPULITE R&D",
	[3]byte{0, 224, 133}:   "GLOBAL MAINTECH, INC.",
	[3]byte{0, 224, 134}:   "Emerson Network Power, Avocent Division",
	[3]byte{0, 224, 135}:   "LeCroy - Networking Productions Division",
	[3]byte{0, 224, 136}:   "LTX-Credence CORPORATION",
	[3]byte{0, 224, 137}:   "ION Networks, Inc.",
	[3]byte{0, 224, 138}:   "GEC AVERY, LTD.",
	[3]byte{0, 224, 139}:   "QLogic Corp.",
	[3]byte{0, 224, 140}:   "NEOPARADIGM LABS, INC.",
	[3]byte{0, 224, 141}:   "PRESSURE SYSTEMS, INC.",
	[3]byte{0, 224, 142}:   "UTSTARCOM",
	[3]byte{0, 224, 143}:   "CISCO SYSTEMS, INC.",
	[3]byte{0, 224, 144}:   "BECKMAN LAB. AUTOMATION DIV.",
	[3]byte{0, 224, 145}:   "LG ELECTRONICS, INC.",
	[3]byte{0, 224, 146}:   "ADMTEK INCORPORATED",
	[3]byte{0, 224, 147}:   "ACKFIN NETWORKS",
	[3]byte{0, 224, 148}:   "OSAI SRL",
	[3]byte{0, 224, 149}:   "ADVANCED-VISION TECHNOLGIES CORP.",
	[3]byte{0, 224, 150}:   "SHIMADZU CORPORATION",
	[3]byte{0, 224, 151}:   "CARRIER ACCESS CORPORATION",
	[3]byte{0, 224, 152}:   "AboCom Systems, Inc.",
	[3]byte{0, 224, 153}:   "SAMSON AG",
	[3]byte{0, 224, 154}:   "Positron Inc.",
	[3]byte{0, 224, 155}:   "ENGAGE NETWORKS, INC.",
	[3]byte{0, 224, 156}:   "MII",
	[3]byte{0, 224, 157}:   "SARNOFF CORPORATION",
	[3]byte{0, 224, 158}:   "QUANTUM CORPORATION",
	[3]byte{0, 224, 159}:   "PIXEL VISION",
	[3]byte{0, 224, 160}:   "WILTRON CO.",
	[3]byte{0, 224, 161}:   "HIMA PAUL HILDEBRANDT GmbH Co. KG",
	[3]byte{0, 224, 162}:   "MICROSLATE INC.",
	[3]byte{0, 224, 163}:   "CISCO SYSTEMS, INC.",
	[3]byte{0, 224, 164}:   "ESAOTE S.p.A.",
	[3]byte{0, 224, 165}:   "ComCore Semiconductor, Inc.",
	[3]byte{0, 224, 166}:   "TELOGY NETWORKS, INC.",
	[3]byte{0, 224, 167}:   "IPC INFORMATION SYSTEMS, INC.",
	[3]byte{0, 224, 168}:   "SAT GmbH & Co.",
	[3]byte{0, 224, 169}:   "FUNAI ELECTRIC CO., LTD.",
	[3]byte{0, 224, 170}:   "ELECTROSONIC LTD.",
	[3]byte{0, 224, 171}:   "DIMAT S.A.",
	[3]byte{0, 224, 172}:   "MIDSCO, INC.",
	[3]byte{0, 224, 173}:   "EES TECHNOLOGY, LTD.",
	[3]byte{0, 224, 174}:   "XAQTI CORPORATION",
	[3]byte{0, 224, 175}:   "GENERAL DYNAMICS INFORMATION SYSTEMS",
	[3]byte{0, 224, 176}:   "CISCO SYSTEMS, INC.",
	[3]byte{0, 224, 177}:   "Alcatel-Lucent, Enterprise Business Group",
	[3]byte{0, 224, 178}:   "TELMAX COMMUNICATIONS CORP.",
	[3]byte{0, 224, 179}:   "EtherWAN Systems, Inc.",
	[3]byte{0, 224, 180}:   "TECHNO SCOPE CO., LTD.",
	[3]byte{0, 224, 181}:   "ARDENT COMMUNICATIONS CORP.",
	[3]byte{0, 224, 182}:   "Entrada Networks",
	[3]byte{0, 224, 183}:   "PI GROUP, LTD.",
	[3]byte{0, 224, 184}:   "GATEWAY 2000",
	[3]byte{0, 224, 185}:   "BYAS SYSTEMS",
	[3]byte{0, 224, 186}:   "BERGHOF AUTOMATIONSTECHNIK GmbH",
	[3]byte{0, 224, 187}:   "NBX CORPORATION",
	[3]byte{0, 224, 188}:   "SYMON COMMUNICATIONS, INC.",
	[3]byte{0, 224, 189}:   "INTERFACE SYSTEMS, INC.",
	[3]byte{0, 224, 190}:   "GENROCO INTERNATIONAL, INC.",
	[3]byte{0, 224, 191}:   "TORRENT NETWORKING TECHNOLOGIES CORP.",
	[3]byte{0, 224, 192}:   "SEIWA ELECTRIC MFG. CO., LTD.",
	[3]byte{0, 224, 193}:   "MEMOREX TELEX JAPAN, LTD.",
	[3]byte{0, 224, 194}:   "NECSY S.p.A.",
	[3]byte{0, 224, 195}:   "SAKAI SYSTEM DEVELOPMENT CORP.",
	[3]byte{0, 224, 196}:   "HORNER ELECTRIC, INC.",
	[3]byte{0, 224, 197}:   "BCOM ELECTRONICS INC.",
	[3]byte{0, 224, 198}:   "LINK2IT, L.L.C.",
	[3]byte{0, 224, 199}:   "EUROTECH SRL",
	[3]byte{0, 224, 200}:   "VIRTUAL ACCESS, LTD.",
	[3]byte{0, 224, 201}:   "AutomatedLogic Corporation",
	[3]byte{0, 224, 202}:   "BEST DATA PRODUCTS",
	[3]byte{0, 224, 203}:   "RESON, INC.",
	[3]byte{0, 224, 204}:   "HERO SYSTEMS, LTD.",
	[3]byte{0, 224, 205}:   "SAAB SENSIS CORPORATION",
	[3]byte{0, 224, 206}:   "ARN",
	[3]byte{0, 224, 207}:   "INTEGRATED DEVICE TECHNOLOGY, INC.",
	[3]byte{0, 224, 208}:   "NETSPEED, INC.",
	[3]byte{0, 224, 209}:   "TELSIS LIMITED",
	[3]byte{0, 224, 210}:   "VERSANET COMMUNICATIONS, INC.",
	[3]byte{0, 224, 211}:   "DATENTECHNIK GmbH",
	[3]byte{0, 224, 212}:   "EXCELLENT COMPUTER",
	[3]byte{0, 224, 213}:   "Emulex Corporation",
	[3]byte{0, 224, 214}:   "COMPUTER & COMMUNICATION RESEARCH LAB.",
	[3]byte{0, 224, 215}:   "SUNSHINE ELECTRONICS, INC.",
	[3]byte{0, 224, 216}:   "LANBit Computer, Inc.",
	[3]byte{0, 224, 217}:   "TAZMO CO., LTD.",
	[3]byte{0, 224, 218}:   "Alcatel North America ESD",
	[3]byte{0, 224, 219}:   "ViaVideo Communications, Inc.",
	[3]byte{0, 224, 220}:   "NEXWARE CORP.",
	[3]byte{0, 224, 221}:   "ZENITH ELECTRONICS CORPORATION",
	[3]byte{0, 224, 222}:   "DATAX NV",
	[3]byte{0, 224, 223}:   "KEYMILE GmbH",
	[3]byte{0, 224, 224}:   "SI ELECTRONICS, LTD.",
	[3]byte{0, 224, 225}:   "G2 NETWORKS, INC.",
	[3]byte{0, 224, 226}:   "INNOVA CORP.",
	[3]byte{0, 224, 227}:   "SK-ELEKTRONIK GmbH",
	[3]byte{0, 224, 228}:   "FANUC ROBOTICS NORTH AMERICA, Inc.",
	[3]byte{0, 224, 229}:   "CINCO NETWORKS, INC.",
	[3]byte{0, 224, 230}:   "INCAA DATACOM B.V.",
	[3]byte{0, 224, 231}:   "RAYTHEON E-SYSTEMS, INC.",
	[3]byte{0, 224, 232}:   "GRETACODER Data Systems AG",
	[3]byte{0, 224, 233}:   "DATA LABS, INC.",
	[3]byte{0, 224, 234}:   "INNOVAT COMMUNICATIONS, INC.",
	[3]byte{0, 224, 235}:   "DIGICOM SYSTEMS, INCORPORATED",
	[3]byte{0, 224, 236}:   "CELESTICA INC.",
	[3]byte{0, 224, 237}:   "SILICOM, LTD.",
	[3]byte{0, 224, 238}:   "MAREL HF",
	[3]byte{0, 224, 239}:   "DIONEX",
	[3]byte{0, 224, 240}:   "ABLER TECHNOLOGY, INC.",
	[3]byte{0, 224, 241}:   "THAT CORPORATION",
	[3]byte{0, 224, 242}:   "ARLOTTO COMNET, INC.",
	[3]byte{0, 224, 243}:   "WebSprint Communications, Inc.",
	[3]byte{0, 224, 244}:   "INSIDE Technology A/S",
	[3]byte{0, 224, 245}:   "TELES AG",
	[3]byte{0, 224, 246}:   "DECISION EUROPE",
	[3]byte{0, 224, 247}:   "CISCO SYSTEMS, INC.",
	[3]byte{0, 224, 248}:   "DICNA CONTROL AB",
	[3]byte{0, 224, 249}:   "CISCO SYSTEMS, INC.",
	[3]byte{0, 224, 250}:   "TRL TECHNOLOGY, LTD.",
	[3]byte{0, 224, 251}:   "LEIGHTRONIX, INC.",
	[3]byte{0, 224, 252}:   "HUAWEI TECHNOLOGIES CO., LTD.",
	[3]byte{0, 224, 253}:   "A-TREND TECHNOLOGY CO., LTD.",
	[3]byte{0, 224, 254}:   "CISCO SYSTEMS, INC.",
	[3]byte{0, 224, 255}:   "SECURITY DYNAMICS TECHNOLOGIES, Inc.",
	[3]byte{0, 225, 109}:   "Cisco",
	[3]byte{0, 225, 117}:   "AK-Systems Ltd",
	[3]byte{0, 227, 178}:   "Samsung Electronics Co.,Ltd",
	[3]byte{0, 230, 102}:   "ARIMA Communications Corp.",
	[3]byte{0, 230, 211}:   "NIXDORF COMPUTER CORP.",
	[3]byte{0, 230, 232}:   "Netzin Technology Corporation,.Ltd.",
	[3]byte{0, 232, 171}:   "Meggitt Training Systems, Inc.",
	[3]byte{0, 235, 45}:    "Sony Mobile Communications AB",
	[3]byte{0, 238, 189}:   "HTC Corporation",
	[3]byte{0, 240, 81}:    "KWB Gmbh",
	[3]byte{0, 243, 219}:   "WOO Sports",
	[3]byte{0, 244, 3}:     "Orbis Systems Oy",
	[3]byte{0, 244, 111}:   "Samsung Elec Co.,Ltd",
	[3]byte{0, 244, 185}:   "Apple",
	[3]byte{0, 247, 111}:   "Apple",
	[3]byte{0, 248, 96}:    "PT. Panggung Electric Citrabuana",
	[3]byte{0, 250, 59}:    "CLOOS ELECTRONIC GMBH",
	[3]byte{0, 252, 88}:    "WebSilicon Ltd.",
	[3]byte{0, 252, 112}:   "Intrepid Control Systems, Inc.",
	[3]byte{0, 253, 76}:    "NEVATEC",
	[3]byte{2, 7, 1}:       "RACAL-DATACOM",
	[3]byte{2, 28, 124}:    "PERQ SYSTEMS CORPORATION",
	[3]byte{2, 96, 134}:    "LOGIC REPLACEMENT TECH. LTD.",
	[3]byte{2, 96, 140}:    "3COM CORPORATION",
	[3]byte{2, 112, 1}:     "RACAL-DATACOM",
	[3]byte{2, 112, 176}:   "M/A-COM INC. COMPANIES",
	[3]byte{2, 112, 179}:   "DATA RECALL LTD",
	[3]byte{2, 157, 142}:   "CARDIAC RECORDERS INC.",
	[3]byte{2, 170, 60}:    "OLIVETTI TELECOMM SPA (OLTECO)",
	[3]byte{2, 187, 1}:     "OCTOTHORPE CORP.",
	[3]byte{2, 192, 140}:   "3COM CORPORATION",
	[3]byte{2, 207, 28}:    "COMMUNICATION MACHINERY CORP.",
	[3]byte{2, 230, 211}:   "NIXDORF COMPUTER CORPORATION",
	[3]byte{4, 10, 131}:    "Alcatel-Lucent",
	[3]byte{4, 10, 224}:    "XMIT AG COMPUTER NETWORKS",
	[3]byte{4, 12, 206}:    "Apple",
	[3]byte{4, 14, 194}:    "ViewSonic Mobile China Limited",
	[3]byte{4, 21, 82}:     "Apple",
	[3]byte{4, 24, 15}:     "Samsung Electronics Co.,Ltd",
	[3]byte{4, 24, 182}:    "PRIVATE",
	[3]byte{4, 24, 214}:    "Ubiquiti Networks",
	[3]byte{4, 26, 4}:      "WaveIP",
	[3]byte{4, 27, 148}:    "Host Mobility AB",
	[3]byte{4, 27, 186}:    "Samsung Electronics Co.,Ltd",
	[3]byte{4, 29, 16}:     "Dream Ware Inc.",
	[3]byte{4, 30, 100}:    "Apple",
	[3]byte{4, 32, 154}:    "Panasonic AVC Networks Company",
	[3]byte{4, 34, 52}:     "Wireless Standard Extensions",
	[3]byte{4, 38, 5}:      "GFR Gesellschaft für Regelungstechnik und Energieeinsparung mbH",
	[3]byte{4, 38, 101}:    "Apple",
	[3]byte{4, 43, 187}:    "PicoCELA, Inc.",
	[3]byte{4, 47, 86}:     "ATOCS (Shenzhen) LTD",
	[3]byte{4, 50, 244}:    "Partron",
	[3]byte{4, 54, 4}:      "Gyeyoung I&T",
	[3]byte{4, 61, 152}:    "ChongQing QingJia Electronics CO.,LTD",
	[3]byte{4, 68, 161}:    "TELECON GALICIA,S.A.",
	[3]byte{4, 70, 101}:    "Murata Manufacturing Co., Ltd.",
	[3]byte{4, 72, 154}:    "Apple",
	[3]byte{4, 74, 80}:     "Ramaxel Technology (Shenzhen) limited company",
	[3]byte{4, 75, 255}:    "GuangZhou Hedy Digital Technology Co., Ltd",
	[3]byte{4, 76, 239}:    "Fujian Sanao Technology Co.,Ltd",
	[3]byte{4, 78, 6}:      "Ericsson AB",
	[3]byte{4, 79, 139}:    "Adapteva, Inc.",
	[3]byte{4, 79, 170}:    "Ruckus Wireless",
	[3]byte{4, 84, 83}:     "Apple",
	[3]byte{4, 85, 202}:    "BriView (Xiamen) Corp.",
	[3]byte{4, 87, 47}:     "Sertel Electronics UK Ltd",
	[3]byte{4, 88, 111}:    "Sichuan Whayer information industry Co.,LTD",
	[3]byte{4, 90, 149}:    "Nokia Corporation",
	[3]byte{4, 92, 6}:      "Zmodo Technology Corporation",
	[3]byte{4, 92, 142}:    "gosund GROUP CO.,LTD",
	[3]byte{4, 93, 86}:     "camtron industrial inc.",
	[3]byte{4, 95, 167}:    "Shenzhen Yichen Technology Development Co.,LTD",
	[3]byte{4, 98, 215}:    "ALSTOM HYDRO FRANCE",
	[3]byte{4, 99, 224}:    "Nome Oy",
	[3]byte{4, 103, 133}:   "scemtec Hard- und Software fuer Mess- und Steuerungstechnik GmbH",
	[3]byte{4, 109, 66}:    "Bryston Ltd.",
	[3]byte{4, 110, 73}:    "TaiYear Electronic Technology (Suzhou) Co., Ltd",
	[3]byte{4, 112, 188}:   "Globalstar Inc.",
	[3]byte{4, 116, 161}:   "Aligera Equipamentos Digitais Ltda",
	[3]byte{4, 117, 245}:   "CSST",
	[3]byte{4, 118, 110}:   "ALPS Co,. Ltd.",
	[3]byte{4, 125, 123}:   "Quanta Computer Inc.",
	[3]byte{4, 129, 174}:   "Clack Corporation",
	[3]byte{4, 132, 138}:   "7INOVA TECHNOLOGY LIMITED",
	[3]byte{4, 136, 140}:   "Eifelwerk Butler Systeme GmbH",
	[3]byte{4, 136, 226}:   "Beats Electronics LLC",
	[3]byte{4, 138, 21}:    "Avaya, Inc",
	[3]byte{4, 139, 66}:    "Skspruce Technology Limited",
	[3]byte{4, 140, 3}:     "ThinPAD Technology (Shenzhen)CO.,LTD",
	[3]byte{4, 141, 56}:    "Netcore Technology Inc.",
	[3]byte{4, 148, 161}:   "CATCH THE WIND INC",
	[3]byte{4, 152, 243}:   "ALPS Electric Co,. Ltd.",
	[3]byte{4, 153, 230}:   "Shenzhen Yoostar Technology Co., Ltd",
	[3]byte{4, 155, 156}:   "Eadingcore  Intelligent Technology Co., Ltd.",
	[3]byte{4, 156, 98}:    "BMT Medical Technology s.r.o.",
	[3]byte{4, 159, 6}:     "Smobile Co., Ltd.",
	[3]byte{4, 159, 129}:   "Netscout Systems, Inc.",
	[3]byte{4, 161, 81}:    "NETGEAR INC.,",
	[3]byte{4, 163, 243}:   "Emicon",
	[3]byte{4, 168, 42}:    "Nokia Corporation",
	[3]byte{4, 179, 182}:   "Seamap (UK) Ltd",
	[3]byte{4, 180, 102}:   "BSP Co., Ltd.",
	[3]byte{4, 189, 112}:   "HUAWEI TECHNOLOGIES CO.,LTD",
	[3]byte{4, 191, 168}:   "ISB Corporation",
	[3]byte{4, 192, 91}:    "Tigo Energy",
	[3]byte{4, 192, 111}:   "Shenzhen Huawei Communication Technologies Co., Ltd",
	[3]byte{4, 192, 156}:   "Tellabs Inc.",
	[3]byte{4, 193, 185}:   "Fiberhome Telecommunication Tech.Co.,Ltd.",
	[3]byte{4, 197, 164}:   "CISCO SYSTEMS, INC.",
	[3]byte{4, 200, 128}:   "Samtec Inc",
	[3]byte{4, 201, 145}:   "Phistek INC.",
	[3]byte{4, 203, 29}:    "Traka plc",
	[3]byte{4, 206, 20}:    "Wilocity LTD.",
	[3]byte{4, 207, 37}:    "MANYCOLORS, INC.",
	[3]byte{4, 212, 55}:    "ZNV",
	[3]byte{4, 215, 131}:   "Y&H E&C Co.,LTD.",
	[3]byte{4, 218, 210}:   "Cisco",
	[3]byte{4, 219, 86}:    "Apple, Inc.",
	[3]byte{4, 219, 138}:   "Suntech International Ltd.",
	[3]byte{4, 221, 76}:    "Velocytech",
	[3]byte{4, 222, 219}:   "Rockport Networks Inc",
	[3]byte{4, 223, 105}:   "Car Connectivity Consortium",
	[3]byte{4, 224, 196}:   "TRIUMPH-ADLER AG",
	[3]byte{4, 225, 200}:   "IMS Soluções em Energia Ltda.",
	[3]byte{4, 226, 248}:   "AEP Ticketing solutions srl",
	[3]byte{4, 228, 81}:    "Texas Instruments",
	[3]byte{4, 229, 54}:    "Apple",
	[3]byte{4, 229, 72}:    "Cohda Wireless Pty Ltd",
	[3]byte{4, 230, 98}:    "Acroname Inc.",
	[3]byte{4, 230, 118}:   "AMPAK Technology Inc.",
	[3]byte{4, 233, 229}:   "PJRC.COM, LLC",
	[3]byte{4, 238, 145}:   "x-fabric GmbH",
	[3]byte{4, 240, 33}:    "Compex Systems Pte Ltd",
	[3]byte{4, 241, 62}:    "Apple",
	[3]byte{4, 241, 125}:   "Tarana Wireless",
	[3]byte{4, 244, 188}:   "Xena Networks",
	[3]byte{4, 247, 228}:   "Apple",
	[3]byte{4, 248, 194}:   "Flaircomm Microelectronics, Inc.",
	[3]byte{4, 249, 56}:    "HUAWEI TECHNOLOGIES CO.,LTD",
	[3]byte{4, 254, 49}:    "Samsung Electronics Co.,Ltd",
	[3]byte{4, 254, 127}:   "CISCO SYSTEMS, INC.",
	[3]byte{4, 255, 81}:    "NOVAMEDIA INNOVISION SP. Z O.O.",
	[3]byte{8, 0, 1}:       "COMPUTERVISION CORPORATION",
	[3]byte{8, 0, 2}:       "BRIDGE COMMUNICATIONS INC.",
	[3]byte{8, 0, 3}:       "ADVANCED COMPUTER COMM.",
	[3]byte{8, 0, 4}:       "CROMEMCO INCORPORATED",
	[3]byte{8, 0, 5}:       "SYMBOLICS INC.",
	[3]byte{8, 0, 6}:       "SIEMENS AG",
	[3]byte{8, 0, 7}:       "Apple",
	[3]byte{8, 0, 8}:       "BOLT BERANEK AND NEWMAN INC.",
	[3]byte{8, 0, 9}:       "HEWLETT PACKARD",
	[3]byte{8, 0, 10}:      "NESTAR SYSTEMS INCORPORATED",
	[3]byte{8, 0, 11}:      "UNISYS CORPORATION",
	[3]byte{8, 0, 12}:      "MIKLYN DEVELOPMENT CO.",
	[3]byte{8, 0, 13}:      "INTERNATIONAL COMPUTERS LTD.",
	[3]byte{8, 0, 14}:      "NCR CORPORATION",
	[3]byte{8, 0, 15}:      "MITEL CORPORATION",
	[3]byte{8, 0, 17}:      "TEKTRONIX INC.",
	[3]byte{8, 0, 18}:      "BELL ATLANTIC INTEGRATED SYST.",
	[3]byte{8, 0, 19}:      "EXXON",
	[3]byte{8, 0, 20}:      "EXCELAN",
	[3]byte{8, 0, 21}:      "STC BUSINESS SYSTEMS",
	[3]byte{8, 0, 22}:      "BARRISTER INFO SYS CORP",
	[3]byte{8, 0, 23}:      "NATIONAL SEMICONDUCTOR",
	[3]byte{8, 0, 24}:      "PIRELLI FOCOM NETWORKS",
	[3]byte{8, 0, 25}:      "GENERAL ELECTRIC CORPORATION",
	[3]byte{8, 0, 26}:      "TIARA/ 10NET",
	[3]byte{8, 0, 27}:      "EMC Corporation",
	[3]byte{8, 0, 28}:      "KDD-KOKUSAI DEBNSIN DENWA CO.",
	[3]byte{8, 0, 29}:      "ABLE COMMUNICATIONS INC.",
	[3]byte{8, 0, 30}:      "APOLLO COMPUTER INC.",
	[3]byte{8, 0, 31}:      "SHARP CORPORATION",
	[3]byte{8, 0, 32}:      "Oracle Corporation",
	[3]byte{8, 0, 33}:      "3M COMPANY",
	[3]byte{8, 0, 34}:      "NBI INC.",
	[3]byte{8, 0, 35}:      "Panasonic Communications Co., Ltd.",
	[3]byte{8, 0, 36}:      "10NET COMMUNICATIONS/DCA",
	[3]byte{8, 0, 37}:      "CONTROL DATA",
	[3]byte{8, 0, 38}:      "NORSK DATA A.S.",
	[3]byte{8, 0, 39}:      "CADMUS COMPUTER SYSTEMS",
	[3]byte{8, 0, 40}:      "Texas Instruments",
	[3]byte{8, 0, 41}:      "MEGATEK CORPORATION",
	[3]byte{8, 0, 42}:      "MOSAIC TECHNOLOGIES INC.",
	[3]byte{8, 0, 43}:      "DIGITAL EQUIPMENT CORPORATION",
	[3]byte{8, 0, 44}:      "BRITTON LEE INC.",
	[3]byte{8, 0, 45}:      "LAN-TEC INC.",
	[3]byte{8, 0, 46}:      "METAPHOR COMPUTER SYSTEMS",
	[3]byte{8, 0, 47}:      "PRIME COMPUTER INC.",
	[3]byte{8, 0, 48}:      "NETWORK RESEARCH CORPORATION",
	[3]byte{8, 0, 48}:      "CERN",
	[3]byte{8, 0, 48}:      "ROYAL MELBOURNE INST OF TECH",
	[3]byte{8, 0, 49}:      "LITTLE MACHINES INC.",
	[3]byte{8, 0, 50}:      "TIGAN INCORPORATED",
	[3]byte{8, 0, 51}:      "BAUSCH & LOMB",
	[3]byte{8, 0, 52}:      "FILENET CORPORATION",
	[3]byte{8, 0, 53}:      "MICROFIVE CORPORATION",
	[3]byte{8, 0, 54}:      "INTERGRAPH CORPORATION",
	[3]byte{8, 0, 55}:      "FUJI-XEROX CO. LTD.",
	[3]byte{8, 0, 56}:      "BULL S.A.S.",
	[3]byte{8, 0, 57}:      "SPIDER SYSTEMS LIMITED",
	[3]byte{8, 0, 58}:      "ORCATECH INC.",
	[3]byte{8, 0, 59}:      "TORUS SYSTEMS LIMITED",
	[3]byte{8, 0, 60}:      "SCHLUMBERGER WELL SERVICES",
	[3]byte{8, 0, 61}:      "CADNETIX CORPORATIONS",
	[3]byte{8, 0, 62}:      "CODEX CORPORATION",
	[3]byte{8, 0, 63}:      "FRED KOSCHARA ENTERPRISES",
	[3]byte{8, 0, 64}:      "FERRANTI COMPUTER SYS. LIMITED",
	[3]byte{8, 0, 65}:      "RACAL-MILGO INFORMATION SYS..",
	[3]byte{8, 0, 66}:      "JAPAN MACNICS CORP.",
	[3]byte{8, 0, 67}:      "PIXEL COMPUTER INC.",
	[3]byte{8, 0, 68}:      "DAVID SYSTEMS INC.",
	[3]byte{8, 0, 69}:      "CONCURRENT COMPUTER CORP.",
	[3]byte{8, 0, 70}:      "Sony Corporation",
	[3]byte{8, 0, 71}:      "SEQUENT COMPUTER SYSTEMS INC.",
	[3]byte{8, 0, 72}:      "EUROTHERM GAUGING SYSTEMS",
	[3]byte{8, 0, 73}:      "UNIVATION",
	[3]byte{8, 0, 74}:      "BANYAN SYSTEMS INC.",
	[3]byte{8, 0, 75}:      "PLANNING RESEARCH CORP.",
	[3]byte{8, 0, 76}:      "HYDRA COMPUTER SYSTEMS INC.",
	[3]byte{8, 0, 77}:      "CORVUS SYSTEMS INC.",
	[3]byte{8, 0, 78}:      "3COM EUROPE LTD.",
	[3]byte{8, 0, 79}:      "CYGNET SYSTEMS",
	[3]byte{8, 0, 80}:      "DAISY SYSTEMS CORP.",
	[3]byte{8, 0, 81}:      "EXPERDATA",
	[3]byte{8, 0, 82}:      "INSYSTEC",
	[3]byte{8, 0, 83}:      "MIDDLE EAST TECH. UNIVERSITY",
	[3]byte{8, 0, 85}:      "STANFORD TELECOMM. INC.",
	[3]byte{8, 0, 86}:      "STANFORD LINEAR ACCEL. CENTER",
	[3]byte{8, 0, 87}:      "EVANS & SUTHERLAND",
	[3]byte{8, 0, 88}:      "SYSTEMS CONCEPTS",
	[3]byte{8, 0, 89}:      "A/S MYCRON",
	[3]byte{8, 0, 90}:      "IBM Corp",
	[3]byte{8, 0, 91}:      "VTA TECHNOLOGIES INC.",
	[3]byte{8, 0, 92}:      "FOUR PHASE SYSTEMS",
	[3]byte{8, 0, 93}:      "GOULD INC.",
	[3]byte{8, 0, 94}:      "COUNTERPOINT COMPUTER INC.",
	[3]byte{8, 0, 95}:      "SABER TECHNOLOGY CORP.",
	[3]byte{8, 0, 96}:      "INDUSTRIAL NETWORKING INC.",
	[3]byte{8, 0, 97}:      "JAROGATE LTD.",
	[3]byte{8, 0, 98}:      "GENERAL DYNAMICS",
	[3]byte{8, 0, 99}:      "PLESSEY",
	[3]byte{8, 0, 100}:     "Sitasys AG",
	[3]byte{8, 0, 101}:     "GENRAD INC.",
	[3]byte{8, 0, 102}:     "AGFA CORPORATION",
	[3]byte{8, 0, 103}:     "COMDESIGN",
	[3]byte{8, 0, 104}:     "RIDGE COMPUTERS",
	[3]byte{8, 0, 105}:     "SILICON GRAPHICS INC.",
	[3]byte{8, 0, 106}:     "ATT BELL LABORATORIES",
	[3]byte{8, 0, 107}:     "ACCEL TECHNOLOGIES INC.",
	[3]byte{8, 0, 108}:     "SUNTEK TECHNOLOGY INT'L",
	[3]byte{8, 0, 109}:     "WHITECHAPEL COMPUTER WORKS",
	[3]byte{8, 0, 110}:     "MASSCOMP",
	[3]byte{8, 0, 111}:     "PHILIPS APELDOORN B.V.",
	[3]byte{8, 0, 112}:     "MITSUBISHI ELECTRIC CORP.",
	[3]byte{8, 0, 113}:     "MATRA (DSIE)",
	[3]byte{8, 0, 114}:     "XEROX CORP UNIV GRANT PROGRAM",
	[3]byte{8, 0, 115}:     "TECMAR INC.",
	[3]byte{8, 0, 116}:     "CASIO COMPUTER CO. LTD.",
	[3]byte{8, 0, 117}:     "DANSK DATA ELECTRONIK",
	[3]byte{8, 0, 118}:     "PC LAN TECHNOLOGIES",
	[3]byte{8, 0, 119}:     "TSL COMMUNICATIONS LTD.",
	[3]byte{8, 0, 120}:     "ACCELL CORPORATION",
	[3]byte{8, 0, 121}:     "THE DROID WORKS",
	[3]byte{8, 0, 122}:     "INDATA",
	[3]byte{8, 0, 123}:     "SANYO ELECTRIC CO. LTD.",
	[3]byte{8, 0, 124}:     "VITALINK COMMUNICATIONS CORP.",
	[3]byte{8, 0, 126}:     "AMALGAMATED WIRELESS(AUS) LTD",
	[3]byte{8, 0, 127}:     "CARNEGIE-MELLON UNIVERSITY",
	[3]byte{8, 0, 128}:     "AES DATA INC.",
	[3]byte{8, 0, 129}:     "ASTECH INC.",
	[3]byte{8, 0, 130}:     "VERITAS SOFTWARE",
	[3]byte{8, 0, 131}:     "Seiko Instruments Inc.",
	[3]byte{8, 0, 132}:     "TOMEN ELECTRONICS CORP.",
	[3]byte{8, 0, 133}:     "ELXSI",
	[3]byte{8, 0, 134}:     "KONICA MINOLTA HOLDINGS, INC.",
	[3]byte{8, 0, 135}:     "XYPLEX",
	[3]byte{8, 0, 136}:     "Brocade Communications Systems, Inc.",
	[3]byte{8, 0, 137}:     "KINETICS",
	[3]byte{8, 0, 138}:     "PerfTech, Inc.",
	[3]byte{8, 0, 139}:     "PYRAMID TECHNOLOGY CORP.",
	[3]byte{8, 0, 140}:     "NETWORK RESEARCH CORPORATION",
	[3]byte{8, 0, 141}:     "XYVISION INC.",
	[3]byte{8, 0, 142}:     "TANDEM COMPUTERS",
	[3]byte{8, 0, 143}:     "CHIPCOM CORPORATION",
	[3]byte{8, 0, 144}:     "SONOMA SYSTEMS",
	[3]byte{8, 3, 113}:     "KRG CORPORATE",
	[3]byte{8, 5, 205}:     "DongGuang EnMai Electronic Product Co.Ltd.",
	[3]byte{8, 8, 194}:     "Samsung Electronics",
	[3]byte{8, 8, 234}:     "AMSC",
	[3]byte{8, 9, 182}:     "Masimo Corp",
	[3]byte{8, 12, 11}:     "SysMik GmbH Dresden",
	[3]byte{8, 12, 201}:    "Mission Technology Group, dba Magma",
	[3]byte{8, 13, 132}:    "GECO, Inc.",
	[3]byte{8, 14, 168}:    "Velex s.r.l.",
	[3]byte{8, 15, 250}:    "KSP INC.",
	[3]byte{8, 17, 94}:     "Bitel Co., Ltd.",
	[3]byte{8, 17, 150}:    "Intel Corporate",
	[3]byte{8, 20, 67}:     "UNIBRAIN S.A.",
	[3]byte{8, 22, 81}:     "Shenzhen Sea Star Technology Co.,Ltd",
	[3]byte{8, 23, 53}:     "CISCO SYSTEMS, INC.",
	[3]byte{8, 23, 244}:    "IBM Corp",
	[3]byte{8, 24, 26}:     "zte corporation",
	[3]byte{8, 24, 76}:     "A. S. Thomas, Inc.",
	[3]byte{8, 25, 166}:    "HUAWEI TECHNOLOGIES CO.,LTD",
	[3]byte{8, 29, 251}:    "Shanghai Mexon Communication Technology Co.,Ltd",
	[3]byte{8, 31, 63}:     "WondaLink Inc.",
	[3]byte{8, 31, 243}:    "CISCO SYSTEMS, INC.",
	[3]byte{8, 37, 34}:     "ADVANSEE",
	[3]byte{8, 39, 25}:     "APS systems/electronic AG",
	[3]byte{8, 42, 208}:    "SRD Innovations Inc.",
	[3]byte{8, 46, 95}:     "Hewlett Packard",
	[3]byte{8, 53, 113}:    "CASwell INC.",
	[3]byte{8, 55, 61}:     "Samsung Electronics Co.,Ltd",
	[3]byte{8, 55, 156}:    "Topaz Co. LTD.",
	[3]byte{8, 56, 165}:    "Funkwerk plettac electronic GmbH",
	[3]byte{8, 58, 184}:    "Shinoda Plasma Co., Ltd.",
	[3]byte{8, 61, 136}:    "Samsung Electronics Co.,Ltd",
	[3]byte{8, 62, 12}:     "ARRIS Group, Inc.",
	[3]byte{8, 62, 142}:    "Hon Hai Precision Ind.Co.Ltd",
	[3]byte{8, 63, 62}:     "WSH GmbH",
	[3]byte{8, 63, 118}:    "Intellian Technologies, Inc.",
	[3]byte{8, 64, 39}:     "Gridstore Inc.",
	[3]byte{8, 70, 86}:     "VODALYS Ingénierie",
	[3]byte{8, 72, 44}:     "Raycore Taiwan Co., LTD.",
	[3]byte{8, 78, 28}:     "H2A Systems, LLC",
	[3]byte{8, 78, 191}:    "Broad Net Mux Corporation",
	[3]byte{8, 81, 46}:     "Orion Diagnostica Oy",
	[3]byte{8, 82, 64}:     "EbV Elektronikbau- und Vertriebs GmbH",
	[3]byte{8, 87, 0}:      "TP-LINK TECHNOLOGIES CO.,LTD.",
	[3]byte{8, 90, 224}:    "Recovision Technology Co., Ltd.",
	[3]byte{8, 91, 14}:     "Fortinet, Inc.",
	[3]byte{8, 93, 221}:    "Mercury Corporation",
	[3]byte{8, 96, 110}:    "ASUSTek COMPUTER INC.",
	[3]byte{8, 99, 97}:     "Huawei Technologies Co., Ltd",
	[3]byte{8, 104, 208}:   "Japan System Design",
	[3]byte{8, 104, 234}:   "EITO ELECTRONICS CO., LTD.",
	[3]byte{8, 109, 242}:   "Shenzhen MIMOWAVE Technology Co.,Ltd",
	[3]byte{8, 112, 69}:    "Apple",
	[3]byte{8, 116, 246}:   "Winterhalter Gastronom GmbH",
	[3]byte{8, 117, 114}:   "Obelux Oy",
	[3]byte{8, 118, 24}:    "ViE Technologies Sdn. Bhd.",
	[3]byte{8, 118, 149}:   "Auto Industrial Co., Ltd.",
	[3]byte{8, 118, 255}:   "Thomson Telecom Belgium",
	[3]byte{8, 121, 153}:   "AIM GmbH",
	[3]byte{8, 122, 76}:    "Huawei Technologies Co., Ltd",
	[3]byte{8, 123, 170}:   "SVYAZKOMPLEKTSERVICE, LLC",
	[3]byte{8, 124, 190}:   "Quintic Corp.",
	[3]byte{8, 125, 33}:    "Altasec technology corporation",
	[3]byte{8, 128, 57}:    "Cisco SPVTG",
	[3]byte{8, 129, 188}:   "HongKong Ipro Technology Co., Limited",
	[3]byte{8, 129, 244}:   "Juniper Networks",
	[3]byte{8, 134, 59}:    "Belkin International, Inc.",
	[3]byte{8, 141, 200}:   "Ryowa Electronics Co.,Ltd",
	[3]byte{8, 142, 79}:    "SF Software Solutions",
	[3]byte{8, 143, 44}:    "Hills Sound Vision & Lighting",
	[3]byte{8, 150, 215}:   "AVM GmbH",
	[3]byte{8, 151, 88}:    "Shenzhen Strong Rising Electronics Co.,Ltd DongGuan Subsidiary",
	[3]byte{8, 158, 1}:     "QUANTA COMPUTER INC.",
	[3]byte{8, 159, 151}:   "LEROY AUTOMATION",
	[3]byte{8, 161, 43}:    "ShenZhen EZL Technology Co., Ltd",
	[3]byte{8, 165, 200}:   "Sunnovo International Limited",
	[3]byte{8, 169, 90}:    "Azurewave",
	[3]byte{8, 172, 165}:   "Benu Video, Inc.",
	[3]byte{8, 175, 120}:   "Totus Solutions, Inc.",
	[3]byte{8, 178, 163}:   "Cynny Italia S.r.L.",
	[3]byte{8, 180, 207}:   "Abicom International",
	[3]byte{8, 183, 56}:    "Lite-On Technogy Corp.",
	[3]byte{8, 183, 236}:   "Wireless Seismic",
	[3]byte{8, 187, 204}:   "AK-NORD EDV VERTRIEBSGES. mbH",
	[3]byte{8, 189, 67}:    "NETGEAR INC.,",
	[3]byte{8, 190, 9}:     "Astrol Electronic AG",
	[3]byte{8, 202, 69}:    "Toyou Feiji Electronics Co., Ltd.",
	[3]byte{8, 204, 104}:   "Cisco",
	[3]byte{8, 205, 155}:   "samtec automotive electronics & software GmbH",
	[3]byte{8, 208, 159}:   "CISCO SYSTEMS, INC.",
	[3]byte{8, 210, 154}:   "Proformatique",
	[3]byte{8, 212, 12}:    "Intel Corporate",
	[3]byte{8, 212, 43}:    "Samsung Electronics",
	[3]byte{8, 213, 192}:   "Seers Technology Co., Ltd",
	[3]byte{8, 216, 51}:    "Shenzhen RF Technology Co,.Ltd",
	[3]byte{8, 223, 31}:    "Bose Corporation",
	[3]byte{8, 229, 218}:   "NANJING FUJITSU COMPUTER PRODUCTS CO.,LTD.",
	[3]byte{8, 230, 114}:   "JEBSEE ELECTRONICS CO.,LTD.",
	[3]byte{8, 232, 79}:    "HUAWEI TECHNOLOGIES CO.,LTD",
	[3]byte{8, 234, 68}:    "Aerohive Networks, Inc.",
	[3]byte{8, 235, 41}:    "Jiangsu Huitong Group Co.,Ltd.",
	[3]byte{8, 235, 116}:   "Humax",
	[3]byte{8, 235, 237}:   "World Elite Technology Co.,LTD",
	[3]byte{8, 237, 185}:   "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{8, 238, 139}:   "Samsung Elec Co.,Ltd",
	[3]byte{8, 239, 59}:    "MCS Logic Inc.",
	[3]byte{8, 239, 171}:   "SAYME WIRELESS SENSOR NETWORK",
	[3]byte{8, 241, 183}:   "Towerstream Corpration",
	[3]byte{8, 242, 244}:   "Net One Partners Co.,Ltd.",
	[3]byte{8, 246, 248}:   "GET Engineering",
	[3]byte{8, 247, 40}:    "GLOBO Multimedia Sp. z o.o. Sp.k.",
	[3]byte{8, 250, 224}:   "Fohhn Audio AG",
	[3]byte{8, 252, 82}:    "OpenXS BV",
	[3]byte{8, 252, 136}:   "Samsung Electronics Co.,Ltd",
	[3]byte{8, 253, 14}:    "Samsung Electronics Co.,Ltd",
	[3]byte{12, 4, 0}:      "Jantar d.o.o.",
	[3]byte{12, 5, 53}:     "Juniper Systems",
	[3]byte{12, 17, 5}:     "Ringslink (Xiamen) Network Communication Technologies Co., Ltd",
	[3]byte{12, 18, 98}:    "zte corporation",
	[3]byte{12, 19, 11}:    "Uniqoteq Ltd.",
	[3]byte{12, 20, 32}:    "Samsung Electronics Co.,Ltd",
	[3]byte{12, 21, 197}:   "SDTEC Co., Ltd.",
	[3]byte{12, 23, 241}:   "TELECSYS",
	[3]byte{12, 25, 31}:    "Inform Electronik",
	[3]byte{12, 29, 175}:   "Beijing Xiaomi communications co.,ltd",
	[3]byte{12, 29, 194}:   "SeAH Networks",
	[3]byte{12, 32, 38}:    "noax Technologies AG",
	[3]byte{12, 39, 36}:    "Cisco",
	[3]byte{12, 39, 85}:    "Valuable Techologies Limited",
	[3]byte{12, 42, 105}:   "electric imp, incorporated",
	[3]byte{12, 42, 231}:   "Beijing General Research Institute of Mining and Metallurgy",
	[3]byte{12, 45, 137}:   "QiiQ Communications Inc.",
	[3]byte{12, 48, 33}:    "Apple",
	[3]byte{12, 55, 220}:   "Huawei Technologies Co., Ltd",
	[3]byte{12, 56, 62}:    "Fanvil Technology Co., Ltd.",
	[3]byte{12, 57, 86}:    "Observator instruments",
	[3]byte{12, 60, 101}:   "Dome Imaging Inc",
	[3]byte{12, 62, 159}:   "Apple, Inc",
	[3]byte{12, 70, 157}:   "MS Sedco",
	[3]byte{12, 71, 61}:    "Hitron Technologies. Inc",
	[3]byte{12, 76, 57}:    "Mitrastar Technology",
	[3]byte{12, 77, 233}:   "Apple",
	[3]byte{12, 79, 90}:    "ASA-RT s.r.l.",
	[3]byte{12, 81, 247}:   "CHAUVIN ARNOUX",
	[3]byte{12, 84, 165}:   "PEGATRON CORPORATION",
	[3]byte{12, 85, 33}:    "Axiros GmbH",
	[3]byte{12, 86, 92}:    "HyBroad Vision (Hong Kong) Technology Co Ltd",
	[3]byte{12, 87, 235}:   "Mueller Systems",
	[3]byte{12, 90, 25}:    "Axtion Sdn Bhd",
	[3]byte{12, 92, 216}:   "DOLI Elektronik GmbH",
	[3]byte{12, 96, 118}:   "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{12, 99, 252}:   "Nanjing Signway Technology Co., Ltd",
	[3]byte{12, 104, 3}:    "Cisco",
	[3]byte{12, 110, 79}:   "PrimeVOLT Co., Ltd.",
	[3]byte{12, 113, 93}:   "Samsung Electronics Co.,Ltd",
	[3]byte{12, 114, 44}:   "TP-LINK TECHNOLOGIES CO.,LTD.",
	[3]byte{12, 116, 194}:  "Apple",
	[3]byte{12, 117, 35}:   "BEIJING GEHUA CATV NETWORK CO.,LTD",
	[3]byte{12, 119, 26}:   "Apple",
	[3]byte{12, 125, 124}:  "Kexiang Information Technology Co, Ltd.",
	[3]byte{12, 129, 18}:   "PRIVATE",
	[3]byte{12, 130, 48}:   "SHENZHEN MAGNUS TECHNOLOGIES CO.,LTD",
	[3]byte{12, 130, 104}:  "TP-LINK TECHNOLOGIES CO.,LTD.",
	[3]byte{12, 130, 106}:  "Wuhan Huagong Genuine Optics Technology Co., Ltd",
	[3]byte{12, 132, 17}:   "A.O. Smith Water Products",
	[3]byte{12, 132, 132}:  "Zenovia Electronics Inc.",
	[3]byte{12, 132, 220}:  "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{12, 133, 37}:   "CISCO SYSTEMS, INC.",
	[3]byte{12, 137, 16}:   "Samsung Electronics Co.,LTD",
	[3]byte{12, 139, 253}:  "Intel Corporate",
	[3]byte{12, 140, 143}:  "Kamo Technology Limited",
	[3]byte{12, 140, 220}:  "Suunto Oy",
	[3]byte{12, 141, 152}:  "TOP EIGHT IND CORP",
	[3]byte{12, 146, 78}:   "Rice Lake Weighing Systems",
	[3]byte{12, 147, 1}:    "PT. Prasimax Inovasi Teknologi",
	[3]byte{12, 147, 251}:  "BNS Solutions",
	[3]byte{12, 150, 191}:  "Huawei Technologies Co., Ltd",
	[3]byte{12, 155, 19}:   "Shanghai Magic Mobile Telecommunication Co.Ltd.",
	[3]byte{12, 157, 86}:   "Consort Controls Ltd",
	[3]byte{12, 158, 145}:  "Sankosha Corporation",
	[3]byte{12, 161, 56}:   "Blinq Wireless Inc.",
	[3]byte{12, 162, 244}:  "Chameleon Technology (UK) Limited",
	[3]byte{12, 164, 2}:    "Alcatel Lucent IPD",
	[3]byte{12, 164, 42}:   "OB Telecom Electronic Technology Co., Ltd",
	[3]byte{12, 166, 148}:  "Sunitec Enterprise Co.,Ltd",
	[3]byte{12, 172, 5}:    "Unitend Technologies Inc.",
	[3]byte{12, 175, 90}:   "GENUS POWER INFRASTRUCTURES LIMITED",
	[3]byte{12, 179, 25}:   "Samsung Elec Co.,Ltd",
	[3]byte{12, 180, 239}:  "Digience Co.,Ltd.",
	[3]byte{12, 189, 81}:   "TCT Mobile Limited",
	[3]byte{12, 191, 21}:   "Genetec",
	[3]byte{12, 192, 192}:  "MAGNETI MARELLI SISTEMAS ELECTRONICOS MEXICO",
	[3]byte{12, 195, 167}:  "Meritec",
	[3]byte{12, 196, 122}:  "Super Micro Computer, Inc.",
	[3]byte{12, 196, 126}:  "EUCAST Co., Ltd.",
	[3]byte{12, 198, 85}:   "Wuxi YSTen Technology Co.,Ltd.",
	[3]byte{12, 198, 106}:  "Nokia Corporation",
	[3]byte{12, 198, 172}:  "DAGS",
	[3]byte{12, 200, 31}:   "Summer Infant, Inc.",
	[3]byte{12, 201, 198}:  "Samwin Hong Kong Limited",
	[3]byte{12, 203, 141}:  "ASCO Numatics GmbH",
	[3]byte{12, 205, 211}:  "EASTRIVER TECHNOLOGY CO., LTD.",
	[3]byte{12, 205, 251}:  "EDIC Systems Inc.",
	[3]byte{12, 207, 209}:  "SPRINGWAVE Co., Ltd",
	[3]byte{12, 210, 146}:  "Intel Corporate",
	[3]byte{12, 210, 181}:  "Binatone Telecommunication Pvt. Ltd",
	[3]byte{12, 213, 2}:    "Westell",
	[3]byte{12, 214, 150}:  "Amimon Ltd",
	[3]byte{12, 215, 194}:  "Axium Technologies, Inc.",
	[3]byte{12, 217, 150}:  "CISCO SYSTEMS, INC.",
	[3]byte{12, 217, 193}:  "Visteon Corporation",
	[3]byte{12, 218, 65}:   "Hangzhou H3C Technologies Co., Limited",
	[3]byte{12, 220, 204}:  "Inala Technologies",
	[3]byte{12, 221, 239}:  "Nokia Corporation",
	[3]byte{12, 223, 164}:  "Samsung Electronics Co.,Ltd",
	[3]byte{12, 224, 228}:  "Plantronics, Inc",
	[3]byte{12, 229, 211}:  "DH electronics GmbH",
	[3]byte{12, 231, 9}:    "Fox Crypto B.V.",
	[3]byte{12, 232, 47}:   "Bonfiglioli Vectron GmbH",
	[3]byte{12, 233, 54}:   "ELIMOS srl",
	[3]byte{12, 238, 230}:  "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{12, 239, 124}:  "AnaCom Inc",
	[3]byte{12, 240, 25}:   "Malgn Technology Co., Ltd.",
	[3]byte{12, 240, 180}:  "Globalsat International Technology Ltd",
	[3]byte{12, 243, 97}:   "Java Information",
	[3]byte{12, 243, 238}:  "EM Microelectronic",
	[3]byte{12, 244, 5}:    "Beijing Signalway Technologies Co.,Ltd",
	[3]byte{12, 248, 147}:  "ARRIS Group, Inc.",
	[3]byte{12, 252, 131}:  "Airoha Technology Corp.,",
	[3]byte{16, 0, 0}:      "PRIVATE",
	[3]byte{16, 0, 90}:     "IBM Corp",
	[3]byte{16, 0, 232}:    "NATIONAL SEMICONDUCTOR",
	[3]byte{16, 0, 253}:    "LaonPeople",
	[3]byte{16, 1, 202}:    "Ashley Butterworth",
	[3]byte{16, 5, 202}:    "Cisco",
	[3]byte{16, 7, 35}:     "IEEE REGISTRATION AUTHORITY  - Please see MAM public listing for more information.",
	[3]byte{16, 8, 177}:    "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{16, 9, 12}:     "Janome Sewing Machine Co., Ltd.",
	[3]byte{16, 11, 169}:   "Intel Corporate",
	[3]byte{16, 12, 36}:    "pomdevices, LLC",
	[3]byte{16, 13, 47}:    "Online Security Pty. Ltd.",
	[3]byte{16, 13, 50}:    "Embedian, Inc.",
	[3]byte{16, 13, 127}:   "NETGEAR INC.,",
	[3]byte{16, 14, 43}:    "NEC CASIO Mobile Communications",
	[3]byte{16, 14, 126}:   "Juniper networks",
	[3]byte{16, 15, 24}:    "Fu Gang Electronic(KunShan)CO.,LTD",
	[3]byte{16, 16, 182}:   "McCain Inc",
	[3]byte{16, 18, 18}:    "Vivo International Corporation Pty Ltd",
	[3]byte{16, 18, 24}:    "Korins Inc.",
	[3]byte{16, 18, 72}:    "ITG, Inc.",
	[3]byte{16, 19, 238}:   "Justec International Technology INC.",
	[3]byte{16, 24, 158}:   "Elmo Motion Control",
	[3]byte{16, 27, 84}:    "HUAWEI TECHNOLOGIES CO.,LTD",
	[3]byte{16, 28, 12}:    "Apple",
	[3]byte{16, 29, 81}:    "ON-Q LLC dba ON-Q Mesh Networks",
	[3]byte{16, 29, 192}:   "Samsung Electronics Co.,Ltd",
	[3]byte{16, 31, 116}:   "Hewlett-Packard Company",
	[3]byte{16, 34, 121}:   "ZeroDesktop, Inc.",
	[3]byte{16, 39, 190}:   "TVIP",
	[3]byte{16, 40, 49}:    "Morion Inc.",
	[3]byte{16, 45, 150}:   "Looxcie Inc.",
	[3]byte{16, 46, 175}:   "Texas Instruments",
	[3]byte{16, 47, 107}:   "Microsoft Corporation",
	[3]byte{16, 48, 71}:    "Samsung Electronics Co.,Ltd",
	[3]byte{16, 51, 120}:   "FLECTRON Co., LTD",
	[3]byte{16, 55, 17}:    "Simlink AS",
	[3]byte{16, 59, 89}:    "Samsung Electronics Co.,Ltd",
	[3]byte{16, 61, 234}:   "HFC Technology (Beijing) Ltd. Co.",
	[3]byte{16, 64, 243}:   "Apple",
	[3]byte{16, 67, 105}:   "Soundmax Electronic Limited",
	[3]byte{16, 68, 90}:    "Shaanxi Hitech Electronic Co., LTD",
	[3]byte{16, 69, 190}:   "Norphonic AS",
	[3]byte{16, 69, 248}:   "LNT-Automation GmbH",
	[3]byte{16, 71, 128}:   "HUAWEI TECHNOLOGIES CO.,LTD",
	[3]byte{16, 72, 177}:   "Beijing Duokan Technology Limited",
	[3]byte{16, 75, 70}:    "Mitsubishi Electric Corporation",
	[3]byte{16, 77, 119}:   "Innovative Computer Engineering",
	[3]byte{16, 78, 7}:     "Shanghai Genvision Industries Co.,Ltd",
	[3]byte{16, 81, 114}:   "HUAWEI TECHNOLOGIES CO.,LTD",
	[3]byte{16, 86, 202}:   "Peplink International Ltd.",
	[3]byte{16, 92, 59}:    "Perma-Pipe, Inc.",
	[3]byte{16, 92, 191}:   "DuroByte Inc",
	[3]byte{16, 95, 6}:     "Actiontec Electronics, Inc",
	[3]byte{16, 95, 73}:    "Cisco SPVTG",
	[3]byte{16, 96, 75}:    "Hewlett Packard",
	[3]byte{16, 98, 201}:   "Adatis GmbH & Co. KG",
	[3]byte{16, 100, 226}:  "ADFweb.com s.r.l.",
	[3]byte{16, 101, 163}:  "Core Brands LLC",
	[3]byte{16, 101, 207}:  "IQSIM",
	[3]byte{16, 102, 130}:  "NEC Platforms, Ltd.",
	[3]byte{16, 104, 63}:   "LG Electronics",
	[3]byte{16, 111, 63}:   "Buffalo Inc.",
	[3]byte{16, 111, 239}:  "Ad-Sol Nissin Corp",
	[3]byte{16, 113, 249}:  "Cloud Telecomputers, LLC",
	[3]byte{16, 118, 138}:  "EoCell",
	[3]byte{16, 119, 177}:  "Samsung Electronics Co.,LTD",
	[3]byte{16, 120, 206}:  "Hanvit SI, Inc.",
	[3]byte{16, 120, 210}:  "ELITEGROUP COMPUTER SYSTEM CO., LTD.",
	[3]byte{16, 122, 134}:  "U&U ENGINEERING INC.",
	[3]byte{16, 123, 239}:  "ZyXEL Communications Corp",
	[3]byte{16, 131, 210}:  "Microseven Systems, LLC",
	[3]byte{16, 136, 15}:   "Daruma Telecomunicações e Informática S.A.",
	[3]byte{16, 136, 206}:  "Fiberhome Telecommunication Tech.Co.,Ltd.",
	[3]byte{16, 138, 27}:   "RAONIX Inc.",
	[3]byte{16, 140, 207}:  "CISCO SYSTEMS, INC.",
	[3]byte{16, 146, 102}:  "Samsung Electronics Co.,Ltd",
	[3]byte{16, 147, 233}:  "Apple",
	[3]byte{16, 154, 185}:  "Tosibox Oy",
	[3]byte{16, 154, 221}:  "Apple",
	[3]byte{16, 159, 169}:  "Actiontec Electronics, Inc",
	[3]byte{16, 161, 59}:   "FUJIKURA RUBBER LTD.",
	[3]byte{16, 165, 208}:  "Murata Manufacturing Co.,Ltd.",
	[3]byte{16, 167, 67}:   "SK Mtek Limited",
	[3]byte{16, 169, 50}:   "Beijing Cyber Cloud Technology Co. ,Ltd.",
	[3]byte{16, 174, 96}:   "PRIVATE",
	[3]byte{16, 178, 107}:  "base Co.,Ltd.",
	[3]byte{16, 183, 19}:   "PRIVATE",
	[3]byte{16, 183, 246}:  "Plastoform Industries Ltd.",
	[3]byte{16, 185, 254}:  "Lika srl",
	[3]byte{16, 186, 165}:  "GANA I&C CO., LTD",
	[3]byte{16, 189, 24}:   "CISCO SYSTEMS, INC.",
	[3]byte{16, 191, 72}:   "ASUSTEK COMPUTER INC.",
	[3]byte{16, 194, 186}:  "UTT Co., Ltd.",
	[3]byte{16, 195, 123}:  "ASUSTek COMPUTER INC.",
	[3]byte{16, 197, 134}:  "BIO SOUND LAB CO., LTD.",
	[3]byte{16, 198, 31}:   "Huawei Technologies Co., Ltd",
	[3]byte{16, 198, 126}:  "SHENZHEN JUCHIN TECHNOLOGY CO., LTD",
	[3]byte{16, 198, 252}:  "Garmin International",
	[3]byte{16, 199, 63}:   "Midas Klark Teknik Ltd",
	[3]byte{16, 202, 129}:  "PRECIA",
	[3]byte{16, 204, 219}:  "AXIMUM PRODUITS ELECTRONIQUES",
	[3]byte{16, 209, 220}:  "INSTAR Deutschland GmbH",
	[3]byte{16, 213, 66}:   "Samsung Electronics Co.,Ltd",
	[3]byte{16, 221, 177}:  "Apple",
	[3]byte{16, 221, 244}:  "Maxway Electronics CO.,LTD",
	[3]byte{16, 222, 228}:  "automationNEXT GmbH",
	[3]byte{16, 226, 213}:  "Qi Hardware Inc.",
	[3]byte{16, 227, 199}:  "Seohwa Telecom",
	[3]byte{16, 228, 175}:  "APR, LLC",
	[3]byte{16, 230, 174}:  "Source Technologies, LLC",
	[3]byte{16, 232, 238}:  "PhaseSpace",
	[3]byte{16, 234, 89}:   "Cisco SPVTG",
	[3]byte{16, 238, 217}:  "Canoga Perkins Corporation",
	[3]byte{16, 243, 17}:   "Cisco",
	[3]byte{16, 243, 219}:  "Gridco Systems, Inc.",
	[3]byte{16, 244, 154}:  "T3 Innovation",
	[3]byte{16, 246, 129}:  "vivo Mobile Communication Co., Ltd.",
	[3]byte{16, 249, 111}:  "LG Electronics",
	[3]byte{16, 249, 238}:  "Nokia Corporation",
	[3]byte{16, 250, 206}:  "Reacheng Communication Technology Co.,Ltd",
	[3]byte{16, 251, 240}:  "KangSheng LTD.",
	[3]byte{16, 252, 84}:   "Shany Electronic Co., Ltd.",
	[3]byte{16, 254, 237}:  "TP-LINK TECHNOLOGIES CO., LTD.",
	[3]byte{17, 0, 170}:    "PRIVATE",
	[3]byte{20, 7, 8}:      "PRIVATE",
	[3]byte{20, 7, 224}:    "Abrantix AG",
	[3]byte{20, 12, 118}:   "FREEBOX SAS",
	[3]byte{20, 13, 79}:    "Flextronics International",
	[3]byte{20, 16, 159}:   "Apple",
	[3]byte{20, 19, 48}:    "Anakreon UK LLP",
	[3]byte{20, 20, 75}:    "FUJIAN STAR-NET COMMUNICATION CO.,LTD",
	[3]byte{20, 26, 81}:    "Treetech Sistemas Digitais",
	[3]byte{20, 27, 189}:   "Volex Inc.",
	[3]byte{20, 27, 240}:   "Intellimedia Systems Ltd",
	[3]byte{20, 31, 186}:   "IEEE REGISTRATION AUTHORITY  - Please see MAM public listing for more information.",
	[3]byte{20, 35, 215}:   "EUTRONIX CO., LTD.",
	[3]byte{20, 43, 210}:   "Armtel Ltd.",
	[3]byte{20, 43, 214}:   "Guangdong Appscomm Co.,Ltd",
	[3]byte{20, 45, 39}:    "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{20, 45, 139}:   "Incipio Technologies, Inc",
	[3]byte{20, 45, 245}:   "Amphitech",
	[3]byte{20, 48, 122}:   "Avermetrics",
	[3]byte{20, 48, 198}:   "Motorola Mobility LLC",
	[3]byte{20, 53, 139}:   "Mediabridge Products, LLC.",
	[3]byte{20, 53, 179}:   "Future Designs, Inc.",
	[3]byte{20, 54, 5}:     "Nokia Corporation",
	[3]byte{20, 54, 198}:   "Lenovo Mobile Communication Technology Ltd.",
	[3]byte{20, 55, 59}:    "PROCOM Systems",
	[3]byte{20, 58, 234}:   "Dynapower Company LLC",
	[3]byte{20, 61, 242}:   "Beijing Shidai Hongyuan Network Communication Co.,Ltd",
	[3]byte{20, 62, 96}:    "Alcatel-Lucent",
	[3]byte{20, 65, 226}:   "Monaco Enterprises, Inc.",
	[3]byte{20, 67, 25}:    "Creative&Link Technology Limited",
	[3]byte{20, 70, 228}:   "AVISTEL",
	[3]byte{20, 72, 139}:   "Shenzhen Doov Technology Co.,Ltd",
	[3]byte{20, 73, 120}:   "Digital Control Incorporated",
	[3]byte{20, 73, 224}:   "Samsung Electro Mechanics co.,LTD.",
	[3]byte{20, 76, 26}:    "Max Communication GmbH",
	[3]byte{20, 84, 18}:    "Entis Co., Ltd.",
	[3]byte{20, 86, 69}:    "Savitech Corp.",
	[3]byte{20, 88, 208}:   "Hewlett Packard",
	[3]byte{20, 90, 5}:     "Apple",
	[3]byte{20, 91, 209}:   "ARRIS Group, Inc.",
	[3]byte{20, 96, 128}:   "zte corporation",
	[3]byte{20, 99, 8}:     "JABIL CIRCUIT (SHANGHAI) LTD.",
	[3]byte{20, 106, 11}:   "Cypress Electronics Limited",
	[3]byte{20, 110, 10}:   "PRIVATE",
	[3]byte{20, 115, 115}:  "TUBITAK UEKAE",
	[3]byte{20, 116, 17}:   "RIM",
	[3]byte{20, 117, 144}:  "TP-LINK TECHNOLOGIES CO.,LTD.",
	[3]byte{20, 125, 179}:  "JOA TELECOM.CO.,LTD",
	[3]byte{20, 125, 197}:  "Murata Manufacturing Co., Ltd.",
	[3]byte{20, 130, 91}:   "Hefei Radio Communication Technology Co., Ltd",
	[3]byte{20, 134, 146}:  "TP-LINK TECHNOLOGIES CO.,LTD.",
	[3]byte{20, 137, 253}:  "Samsung Electronics",
	[3]byte{20, 138, 112}:  "ADS GmbH",
	[3]byte{20, 143, 198}:  "Apple",
	[3]byte{20, 144, 144}:  "KongTop industrial(shen zhen)CO.,LTD",
	[3]byte{20, 148, 72}:   "BLU CASTLE S.A.",
	[3]byte{20, 153, 226}:  "Apple, Inc",
	[3]byte{20, 159, 232}:  "Lenovo Mobile Communication Technology Ltd.",
	[3]byte{20, 163, 100}:  "Samsung Electronics Co.,Ltd",
	[3]byte{20, 166, 44}:   "S.M. Dezac S.A.",
	[3]byte{20, 168, 107}:  "ShenZhen Telacom Science&Technology Co., Ltd",
	[3]byte{20, 169, 227}:  "MST CORPORATION",
	[3]byte{20, 171, 240}:  "ARRIS Group, Inc.",
	[3]byte{20, 177, 38}:   "Industrial Software Co",
	[3]byte{20, 177, 200}:  "InfiniWing, Inc.",
	[3]byte{20, 180, 132}:  "Samsung Electronics Co.,Ltd",
	[3]byte{20, 183, 61}:   "ARCHEAN Technologies",
	[3]byte{20, 185, 104}:  "Huawei Technologies Co., Ltd",
	[3]byte{20, 192, 137}:  "DUNE HD LTD",
	[3]byte{20, 193, 38}:   "Nokia Corporation",
	[3]byte{20, 194, 29}:   "Sabtech Industries",
	[3]byte{20, 204, 32}:   "TP-LINK TECHNOLOGIES CO.,LTD",
	[3]byte{20, 207, 141}:  "OHSUNG ELECTRONICS CO., LTD.",
	[3]byte{20, 207, 146}:  "TP-LINK TECHNOLOGIES CO., LTD.",
	[3]byte{20, 207, 226}:  "ARRIS Group, Inc.",
	[3]byte{20, 212, 254}:  "Pace plc",
	[3]byte{20, 214, 77}:   "D-Link International",
	[3]byte{20, 215, 110}:  "CONCH ELECTRONIC Co.,Ltd",
	[3]byte{20, 218, 233}:  "ASUSTek COMPUTER INC.",
	[3]byte{20, 219, 133}:  "S NET MEDIA",
	[3]byte{20, 228, 236}:  "mLogic LLC",
	[3]byte{20, 230, 228}:  "TP-LINK TECHNOLOGIES CO., LTD.",
	[3]byte{20, 235, 51}:   "BSMediasoft Co., Ltd.",
	[3]byte{20, 237, 165}:  "Wächter GmbH Sicherheitssysteme",
	[3]byte{20, 237, 228}:  "Kaiam Corporation",
	[3]byte{20, 238, 157}:  "AirNav Systems LLC",
	[3]byte{20, 240, 197}:  "Xtremio Ltd.",
	[3]byte{20, 242, 142}:  "ShenYang ZhongKe-Allwin Technology Co.LTD",
	[3]byte{20, 244, 42}:   "Samsung Electronics",
	[3]byte{20, 246, 90}:   "Xiaomi inc.",
	[3]byte{20, 248, 147}:  "Wuhan FiberHome Digital Technology Co.,Ltd.",
	[3]byte{20, 254, 175}:  "SAGITTAR LIMITED",
	[3]byte{20, 254, 181}:  "Dell Inc",
	[3]byte{24, 0, 45}:     "Sony Mobile Communications AB",
	[3]byte{24, 0, 219}:    "Fitbit Inc.",
	[3]byte{24, 1, 227}:    "Elektrobit Wireless Communications Ltd",
	[3]byte{24, 3, 115}:    "Dell Inc",
	[3]byte{24, 3, 250}:    "IBT Interfaces",
	[3]byte{24, 6, 117}:    "DILAX Intelcom GmbH",
	[3]byte{24, 11, 82}:    "Nanotron Technologies GmbH",
	[3]byte{24, 12, 20}:    "iSonea Limited",
	[3]byte{24, 12, 119}:   "Westinghouse Electric Company, LLC",
	[3]byte{24, 12, 172}:   "CANON INC.",
	[3]byte{24, 16, 78}:    "CEDINT-UPM",
	[3]byte{24, 20, 32}:    "TEB SAS",
	[3]byte{24, 20, 86}:    "Nokia Corporation",
	[3]byte{24, 23, 20}:    "DAEWOOIS",
	[3]byte{24, 23, 37}:    "Cameo Communications, Inc.",
	[3]byte{24, 25, 63}:    "Tamtron Oy",
	[3]byte{24, 27, 235}:   "Actiontec Electronics, Inc",
	[3]byte{24, 30, 120}:   "SAGEMCOM",
	[3]byte{24, 30, 176}:   "Samsung Electronics Co.,Ltd",
	[3]byte{24, 32, 18}:    "Aztech Associates Inc.",
	[3]byte{24, 32, 50}:    "Apple",
	[3]byte{24, 32, 166}:   "Sage Co., Ltd.",
	[3]byte{24, 34, 126}:   "Samsung Electronics Co.,Ltd",
	[3]byte{24, 38, 102}:   "Samsung Electronics Co.,Ltd",
	[3]byte{24, 40, 97}:    "AirTies Wireless Networks",
	[3]byte{24, 42, 123}:   "Nintendo Co., Ltd.",
	[3]byte{24, 43, 5}:     "8D Technologies",
	[3]byte{24, 44, 145}:   "Concept Development, Inc.",
	[3]byte{24, 48, 9}:     "Woojin Industrial Systems Co., Ltd.",
	[3]byte{24, 50, 162}:   "LAON TECHNOLOGY CO., LTD.",
	[3]byte{24, 51, 157}:   "CISCO SYSTEMS, INC.",
	[3]byte{24, 52, 81}:    "Apple",
	[3]byte{24, 54, 252}:   "Elecsys International Corporation",
	[3]byte{24, 56, 37}:    "Wuhan Lingjiu High-tech Co.,Ltd.",
	[3]byte{24, 57, 25}:    "Unicoi Systems",
	[3]byte{24, 59, 210}:   "BYD Precision Manufacture Company Ltd.",
	[3]byte{24, 61, 162}:   "Intel Corporate",
	[3]byte{24, 63, 71}:    "Samsung Electronics Co.,Ltd",
	[3]byte{24, 66, 29}:    "PRIVATE",
	[3]byte{24, 66, 47}:    "Alcatel Lucent",
	[3]byte{24, 68, 98}:    "Riava Networks, Inc.",
	[3]byte{24, 70, 23}:    "Samsung Electronics",
	[3]byte{24, 72, 216}:   "Fastback Networks",
	[3]byte{24, 74, 111}:   "Alcatel-Lucent Shanghai Bell Co., Ltd",
	[3]byte{24, 78, 148}:   "MESSOA TECHNOLOGIES INC.",
	[3]byte{24, 82, 83}:    "Pixord Corporation",
	[3]byte{24, 83, 224}:   "Hanyang Digitech Co.Ltd",
	[3]byte{24, 85, 15}:    "Cisco SPVTG",
	[3]byte{24, 89, 51}:    "Cisco SPVTG",
	[3]byte{24, 90, 232}:   "Zenotech.Co.,Ltd",
	[3]byte{24, 98, 44}:    "SAGEMCOM SAS",
	[3]byte{24, 100, 114}:  "Aruba Networks",
	[3]byte{24, 101, 113}:  "Top Victory Electronics (Taiwan) Co., Ltd.",
	[3]byte{24, 102, 227}:  "Veros Systems, Inc.",
	[3]byte{24, 103, 63}:   "Hanover Displays Limited",
	[3]byte{24, 103, 81}:   "KOMEG Industrielle Messtechnik GmbH",
	[3]byte{24, 103, 176}:  "Samsung Electronics Co.,LTD",
	[3]byte{24, 109, 153}:  "Adanis Inc.",
	[3]byte{24, 113, 23}:   "eta plus electronic gmbh",
	[3]byte{24, 121, 162}:  "GMJ ELECTRIC LIMITED",
	[3]byte{24, 122, 147}:  "AMICCOM Electronics Corporation",
	[3]byte{24, 124, 129}:  "Valeo Vision Systems",
	[3]byte{24, 126, 213}:  "shenzhen kaism technology Co. Ltd",
	[3]byte{24, 128, 206}:  "Barberry Solutions Ltd",
	[3]byte{24, 128, 245}:  "Alcatel-Lucent Shanghai Bell Co., Ltd",
	[3]byte{24, 130, 25}:   "Alibaba Cloud Computing Ltd.",
	[3]byte{24, 131, 49}:   "Samsung Electronics Co.,Ltd",
	[3]byte{24, 131, 191}:  "Arcadyan Technology Corporation",
	[3]byte{24, 132, 16}:   "CoreTrust Inc.",
	[3]byte{24, 134, 58}:   "DIGITAL ART SYSTEM",
	[3]byte{24, 134, 172}:  "Nokia Danmark A/S",
	[3]byte{24, 135, 150}:  "HTC Corporation",
	[3]byte{24, 136, 87}:   "Beijing Jinhong Xi-Dian Information Technology Corp.",
	[3]byte{24, 137, 223}:  "CerebrEX Inc.",
	[3]byte{24, 142, 213}:  "TP Vision Belgium N.V. - innovation site Brugge",
	[3]byte{24, 146, 44}:   "Virtual Instruments",
	[3]byte{24, 151, 255}:  "TechFaith Wireless Technology Limited",
	[3]byte{24, 154, 103}:  "CSE-Servelec Limited",
	[3]byte{24, 156, 93}:   "Cisco",
	[3]byte{24, 158, 252}:  "Apple",
	[3]byte{24, 169, 5}:    "Hewlett-Packard Company",
	[3]byte{24, 169, 88}:   "PROVISION THAI CO., LTD.",
	[3]byte{24, 169, 155}:  "Dell Inc",
	[3]byte{24, 170, 69}:   "Fon Technology",
	[3]byte{24, 171, 245}:  "Ultra Electronics - Electrics",
	[3]byte{24, 173, 77}:   "Polostar Technology Corporation",
	[3]byte{24, 174, 187}:  "Siemens Convergence Creators GmbH&Co.KG",
	[3]byte{24, 175, 97}:   "Apple, Inc",
	[3]byte{24, 175, 143}:  "Apple",
	[3]byte{24, 175, 159}:  "DIGITRONIC Automationsanlagen GmbH",
	[3]byte{24, 178, 9}:    "Torrey Pines Logic, Inc",
	[3]byte{24, 179, 186}:  "Netlogic AB",
	[3]byte{24, 180, 48}:   "Nest Labs Inc.",
	[3]byte{24, 181, 145}:  "I-Storm",
	[3]byte{24, 183, 158}:  "Invoxia",
	[3]byte{24, 192, 134}:  "Broadcom Corporation",
	[3]byte{24, 196, 81}:   "Tucson Embedded Systems",
	[3]byte{24, 200, 231}:  "Shenzhen Hualistone Technology Co.,Ltd",
	[3]byte{24, 204, 35}:   "Philio Technology Corporation",
	[3]byte{24, 207, 94}:   "Liteon Technology Corporation",
	[3]byte{24, 208, 113}:  "DASAN CO., LTD.",
	[3]byte{24, 213, 182}:  "SMG Holdings LLC",
	[3]byte{24, 214, 106}:  "Inmarsat",
	[3]byte{24, 214, 207}:  "Kurth Electronic GmbH",
	[3]byte{24, 217, 73}:   "Qvis Labs, LLC",
	[3]byte{24, 220, 86}:   "Yulong Computer Telecommunication Scientific(shenzhen)Co.,Lt",
	[3]byte{24, 226, 136}:  "STT Condigi",
	[3]byte{24, 226, 194}:  "Samsung Electronics",
	[3]byte{24, 231, 40}:   "Cisco",
	[3]byte{24, 231, 244}:  "Apple",
	[3]byte{24, 232, 15}:   "Viking Electronics Inc.",
	[3]byte{24, 232, 221}:  "MODULETEK",
	[3]byte{24, 239, 99}:   "CISCO SYSTEMS, INC.",
	[3]byte{24, 244, 106}:  "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{24, 246, 80}:   "Multimedia Pacific Limited",
	[3]byte{24, 248, 122}:  "i3 International Inc.",
	[3]byte{24, 250, 111}:  "ISC applied systems corp",
	[3]byte{24, 251, 123}:  "Dell Inc",
	[3]byte{24, 252, 159}:  "Changhe Electronics Co., Ltd.",
	[3]byte{24, 254, 52}:   "Espressif Inc.",
	[3]byte{24, 255, 46}:   "Shenzhen Rui Ying Da Technology Co., Ltd",
	[3]byte{28, 6, 86}:     "IDY Corporation",
	[3]byte{28, 8, 193}:    "Lg Innotek",
	[3]byte{28, 11, 82}:    "EPICOM S.A",
	[3]byte{28, 15, 207}:   "Sypro Optics GmbH",
	[3]byte{28, 17, 225}:   "Wartsila Finland Oy",
	[3]byte{28, 18, 157}:   "IEEE PES PSRC/SUB",
	[3]byte{28, 20, 72}:    "ARRIS Group, Inc.",
	[3]byte{28, 23, 211}:   "CISCO SYSTEMS, INC.",
	[3]byte{28, 24, 74}:    "ShenZhen RicherLink Technologies Co.,LTD",
	[3]byte{28, 25, 222}:   "eyevis GmbH",
	[3]byte{28, 26, 192}:   "Apple",
	[3]byte{28, 27, 104}:   "ARRIS Group, Inc.",
	[3]byte{28, 28, 253}:   "Dalian Hi-Think Computer Technology, Corp",
	[3]byte{28, 29, 103}:   "Shenzhen Huawei Communication Technologies Co., Ltd",
	[3]byte{28, 29, 134}:   "Cisco",
	[3]byte{28, 51, 77}:    "ITS Telecom",
	[3]byte{28, 52, 119}:   "Innovation Wireless",
	[3]byte{28, 53, 241}:   "NEW Lift Neue Elektronische Wege Steuerungsbau GmbH",
	[3]byte{28, 55, 191}:   "Cloudium Systems Ltd.",
	[3]byte{28, 58, 79}:    "AccuSpec Electronics, LLC",
	[3]byte{28, 61, 231}:   "Sigma Koki Co.,Ltd.",
	[3]byte{28, 62, 132}:   "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{28, 65, 88}:    "Gemalto M2M GmbH",
	[3]byte{28, 67, 236}:   "JAPAN CIRCUIT CO.,LTD",
	[3]byte{28, 69, 147}:   "Texas Instruments",
	[3]byte{28, 72, 64}:    "IMS Messsysteme GmbH",
	[3]byte{28, 72, 249}:   "GN Netcom A/S",
	[3]byte{28, 74, 247}:   "AMON INC",
	[3]byte{28, 75, 185}:   "SMG ENTERPRISE, LLC",
	[3]byte{28, 75, 214}:   "AzureWave",
	[3]byte{28, 81, 181}:   "Techaya LTD",
	[3]byte{28, 82, 22}:    "DONGGUAN HELE ELECTRONICS CO., LTD",
	[3]byte{28, 82, 214}:   "FLAT DISPLAY TECHNOLOGY CORPORATION",
	[3]byte{28, 90, 62}:    "Samsung Eletronics Co., Ltd (Visual Display Divison)",
	[3]byte{28, 90, 107}:   "Philips Electronics Nederland BV",
	[3]byte{28, 92, 85}:    "PRIMA Cinema, Inc",
	[3]byte{28, 92, 96}:    "Shenzhen Belzon Technology Co.,LTD.",
	[3]byte{28, 95, 255}:   "Beijing Ereneben Information Technology Co.,Ltd Shenzhen Branch",
	[3]byte{28, 98, 184}:   "Samsung Electronics Co.,Ltd",
	[3]byte{28, 99, 183}:   "OpenProducts 237 AB",
	[3]byte{28, 101, 157}:  "Liteon Technology Corporation",
	[3]byte{28, 102, 109}:  "Hon Hai Precision Ind.Co.Ltd",
	[3]byte{28, 102, 170}:  "Samsung Electronics",
	[3]byte{28, 105, 165}:  "Research In Motion",
	[3]byte{28, 106, 122}:  "Cisco",
	[3]byte{28, 107, 202}:  "Mitsunami Co., Ltd.",
	[3]byte{28, 111, 101}:  "GIGA-BYTE TECHNOLOGY CO.,LTD.",
	[3]byte{28, 117, 8}:    "COMPAL INFORMATION (KUNSHAN) CO., LTD.",
	[3]byte{28, 118, 202}:  "Terasic Technologies Inc.",
	[3]byte{28, 120, 57}:   "Shenzhen Tencent Computer System Co., Ltd.",
	[3]byte{28, 123, 33}:   "Sony Mobile Communications AB",
	[3]byte{28, 124, 17}:   "EID",
	[3]byte{28, 124, 69}:   "Vitek Industrial Video Products, Inc.",
	[3]byte{28, 124, 199}:  "Coriant GmbH",
	[3]byte{28, 126, 81}:   "3bumen.com",
	[3]byte{28, 126, 229}:  "D-Link International",
	[3]byte{28, 131, 176}:  "Linked IP GmbH",
	[3]byte{28, 132, 100}:  "FORMOSA WIRELESS COMMUNICATION CORP.",
	[3]byte{28, 134, 173}:  "MCT CO., LTD.",
	[3]byte{28, 142, 142}:  "DB Communication & Systems Co., ltd.",
	[3]byte{28, 143, 138}:  "Phase Motion Control SpA",
	[3]byte{28, 145, 121}:  "Integrated System Technologies Ltd",
	[3]byte{28, 148, 146}:  "RUAG Schweiz AG",
	[3]byte{28, 149, 93}:   "I-LAX ELECTRONICS INC.",
	[3]byte{28, 149, 159}:  "Veethree Electronics And Marine LLC",
	[3]byte{28, 150, 90}:   "Weifang goertek Electronics CO.,LTD",
	[3]byte{28, 151, 61}:   "PRICOM Design",
	[3]byte{28, 153, 76}:   "Murata Manufactuaring Co.,Ltd.",
	[3]byte{28, 156, 38}:   "Zoovel Technologies",
	[3]byte{28, 158, 203}:  "Beijing Nari Smartchip Microelectronics Company Limited",
	[3]byte{28, 162, 177}:  "ruwido austria gmbh",
	[3]byte{28, 167, 112}:  "SHENZHEN CHUANGWEI-RGB ELECTRONICS CO.,LT",
	[3]byte{28, 170, 7}:    "CISCO SYSTEMS, INC.",
	[3]byte{28, 171, 1}:    "Innovolt",
	[3]byte{28, 171, 167}:  "Apple",
	[3]byte{28, 175, 5}:    "Samsung Electronics Co.,Ltd",
	[3]byte{28, 175, 247}:  "D-LINK INTERNATIONAL PTE LIMITED",
	[3]byte{28, 176, 148}:  "HTC Corporation",
	[3]byte{28, 177, 127}:  "NEC Platforms, Ltd.",
	[3]byte{28, 178, 67}:   "TDC A/S",
	[3]byte{28, 186, 140}:  "Texas Instruments",
	[3]byte{28, 187, 168}:  "OJSC \"Ufimskiy Zavod \"Promsvyaz\"",
	[3]byte{28, 189, 14}:   "Amplified Engineering Pty Ltd",
	[3]byte{28, 189, 185}:  "D-LINK INTERNATIONAL PTE LIMITED",
	[3]byte{28, 193, 26}:   "Wavetronix",
	[3]byte{28, 193, 222}:  "Hewlett-Packard Company",
	[3]byte{28, 195, 22}:   "MileSight Technology Co., Ltd.",
	[3]byte{28, 198, 60}:   "Arcadyan Technology Corporation",
	[3]byte{28, 212, 12}:   "Kriwan Industrie-Elektronik GmbH",
	[3]byte{28, 222, 167}:  "Cisco",
	[3]byte{28, 223, 15}:   "CISCO SYSTEMS, INC.",
	[3]byte{28, 225, 101}:  "Marshal Corporation",
	[3]byte{28, 225, 146}:  "Qisda Corporation",
	[3]byte{28, 226, 204}:  "Texas Instruments",
	[3]byte{28, 230, 43}:   "Apple",
	[3]byte{28, 230, 199}:  "Cisco",
	[3]byte{28, 238, 232}:  "Ilshin Elecom",
	[3]byte{28, 240, 97}:   "SCAPS GmbH",
	[3]byte{28, 244, 202}:  "PRIVATE",
	[3]byte{28, 245, 231}:  "Turtle Industry Co., Ltd.",
	[3]byte{28, 250, 104}:  "TP-LINK TECHNOLOGIES CO.,LTD.",
	[3]byte{28, 252, 187}:  "Realfiction ApS",
	[3]byte{28, 254, 167}:  "IDentytech Solutins Ltd.",
	[3]byte{32, 1, 79}:     "Linea Research Ltd",
	[3]byte{32, 2, 175}:    "Murata Manufactuaring Co.,Ltd.",
	[3]byte{32, 5, 5}:      "RADMAX COMMUNICATION PRIVATE LIMITED",
	[3]byte{32, 5, 232}:    "OOO InProMedia",
	[3]byte{32, 8, 237}:    "Huawei Technologies Co., Ltd",
	[3]byte{32, 10, 94}:    "Xiangshan Giant Eagle Technology Developing co.,LTD",
	[3]byte{32, 11, 199}:   "HUAWEI TECHNOLOGIES CO.,LTD",
	[3]byte{32, 12, 200}:   "NETGEAR INC.,",
	[3]byte{32, 14, 149}:   "IEC – TC9 WG43",
	[3]byte{32, 16, 122}:   "Gemtek Technology Co., Ltd.",
	[3]byte{32, 18, 87}:    "Most Lucky Trading Ltd",
	[3]byte{32, 18, 213}:   "Scientech Materials Corporation",
	[3]byte{32, 19, 224}:   "Samsung Electronics Co.,Ltd",
	[3]byte{32, 22, 216}:   "Liteon Technology Corporation",
	[3]byte{32, 24, 14}:    "Shenzhen Sunchip Technology Co., Ltd",
	[3]byte{32, 26, 6}:     "COMPAL INFORMATION (KUNSHAN) CO., LTD.",
	[3]byte{32, 29, 3}:     "Elatec GmbH",
	[3]byte{32, 33, 165}:   "LG Electronics Inc",
	[3]byte{32, 37, 100}:   "PEGATRON CORPORATION",
	[3]byte{32, 37, 152}:   "Teleview",
	[3]byte{32, 43, 193}:   "Shenzhen Huawei Communication Technologies Co., Ltd",
	[3]byte{32, 44, 183}:   "Kong Yue Electronics & Information Industry (Xinhui) Ltd.",
	[3]byte{32, 55, 6}:     "CISCO SYSTEMS, INC.",
	[3]byte{32, 55, 188}:   "Kuipers Electronic Engineering BV",
	[3]byte{32, 58, 7}:     "Cisco",
	[3]byte{32, 64, 5}:     "feno GmbH",
	[3]byte{32, 65, 90}:    "Smarteh d.o.o.",
	[3]byte{32, 68, 58}:    "Schneider Electric Asia Pacific Ltd",
	[3]byte{32, 70, 161}:   "VECOW Co., Ltd",
	[3]byte{32, 70, 249}:   "Advanced Network Devices (dba:AND)",
	[3]byte{32, 74, 170}:   "Hanscan Spain S.A.",
	[3]byte{32, 76, 109}:   "Hugo Brennenstuhl Gmbh & Co. KG.",
	[3]byte{32, 78, 107}:   "Axxana(israel) ltd",
	[3]byte{32, 78, 127}:   "NETGEAR",
	[3]byte{32, 83, 202}:   "Risk Technology Ltd",
	[3]byte{32, 84, 118}:   "Sony Mobile Communications AB",
	[3]byte{32, 87, 33}:    "Salix Technology CO., Ltd.",
	[3]byte{32, 89, 160}:   "Paragon Technologies Inc.",
	[3]byte{32, 90, 0}:     "Coval",
	[3]byte{32, 91, 42}:    "PRIVATE",
	[3]byte{32, 91, 94}:    "Shenzhen Wonhe Technology Co., Ltd",
	[3]byte{32, 92, 250}:   "Yangzhou ChangLian Network Technology Co,ltd.",
	[3]byte{32, 100, 50}:   "SAMSUNG ELECTRO MECHANICS CO.,LTD.",
	[3]byte{32, 103, 177}:  "Pluto inc.",
	[3]byte{32, 104, 157}:  "Liteon Technology Corporation",
	[3]byte{32, 106, 138}:  "Wistron InfoComm Manufacturing(Kunshan)Co.,Ltd.",
	[3]byte{32, 106, 255}:  "Atlas Elektronik UK Limited",
	[3]byte{32, 110, 156}:  "Samsung Electronics Co.,Ltd",
	[3]byte{32, 111, 236}:  "Braemac CA LLC",
	[3]byte{32, 115, 85}:   "ARRIS Group, Inc.",
	[3]byte{32, 116, 207}:  "Shenzhen Voxtech Co.,Ltd",
	[3]byte{32, 118, 0}:    "Actiontec Electronics, Inc",
	[3]byte{32, 118, 147}:  "Lenovo (Beijing) Limited.",
	[3]byte{32, 124, 143}:  "Quanta Microsystems,Inc.",
	[3]byte{32, 125, 116}:  "Apple",
	[3]byte{32, 133, 140}:  "Assa",
	[3]byte{32, 135, 172}:  "AES motomation",
	[3]byte{32, 137, 132}:  "COMPAL INFORMATION (KUNSHAN) CO., LTD",
	[3]byte{32, 137, 134}:  "zte corporation",
	[3]byte{32, 145, 138}:  "PROFALUX",
	[3]byte{32, 145, 217}:  "I'M SPA",
	[3]byte{32, 147, 77}:   "Fujian Star-net Communication Co., Ltd",
	[3]byte{32, 154, 233}:  "Volacomm Co., Ltd",
	[3]byte{32, 155, 165}:  "JIAXING GLEAD Electronics Co.,Ltd",
	[3]byte{32, 162, 231}:  "Lee-Dickens Ltd",
	[3]byte{32, 167, 135}:  "Bointec Taiwan Corporation Limited",
	[3]byte{32, 169, 155}:  "Microsoft Corporation",
	[3]byte{32, 170, 37}:   "IP-NET LLC",
	[3]byte{32, 170, 75}:   "Cisco-Linksys, LLC",
	[3]byte{32, 176, 247}:  "Enclustra GmbH",
	[3]byte{32, 179, 153}:  "Enterasys",
	[3]byte{32, 181, 198}:  "Mimosa Networks",
	[3]byte{32, 183, 192}:  "Omicron electronics GmbH",
	[3]byte{32, 187, 192}:  "Cisco",
	[3]byte{32, 187, 198}:  "Jabil Circuit Hungary Ltd.",
	[3]byte{32, 191, 219}:  "DVL",
	[3]byte{32, 193, 175}:  "i Wit Digital Co., Limited",
	[3]byte{32, 195, 143}:  "Texas Instruments Inc",
	[3]byte{32, 198, 13}:   "Shanghai annijie Information technology Co.,LTD",
	[3]byte{32, 198, 235}:  "Panasonic Corporation AVC Networks Company",
	[3]byte{32, 200, 179}:  "SHENZHEN BUL-TECH CO.,LTD.",
	[3]byte{32, 201, 208}:  "Apple",
	[3]byte{32, 205, 57}:   "Texas Instruments, Inc",
	[3]byte{32, 206, 196}:  "Peraso Technologies",
	[3]byte{32, 207, 48}:   "ASUSTek COMPUTER INC.",
	[3]byte{32, 210, 31}:   "Wincal Technology Corp.",
	[3]byte{32, 211, 144}:  "Samsung Electronics Co.,Ltd",
	[3]byte{32, 213, 171}:  "Korea Infocom Co.,Ltd.",
	[3]byte{32, 213, 191}:  "Samsung Eletronics Co., Ltd",
	[3]byte{32, 214, 7}:    "Nokia Corporation",
	[3]byte{32, 217, 6}:    "Iota, Inc.",
	[3]byte{32, 220, 147}:  "Cheetah Hi-Tech, Inc.",
	[3]byte{32, 220, 230}:  "TP-LINK TECHNOLOGIES CO., LTD.",
	[3]byte{32, 223, 63}:   "Nanjing SAC Power Grid Automation Co., Ltd.",
	[3]byte{32, 229, 42}:   "NETGEAR INC.,",
	[3]byte{32, 229, 100}:  "ARRIS Group, Inc.",
	[3]byte{32, 231, 145}:  "Siemens Healthcare Diagnostics, Inc",
	[3]byte{32, 234, 199}:  "SHENZHEN RIOPINE ELECTRONICS CO., LTD",
	[3]byte{32, 237, 116}:  "Ability enterprise co.,Ltd.",
	[3]byte{32, 238, 198}:  "Elefirst Science & Tech Co ., ltd",
	[3]byte{32, 240, 2}:    "MTData Developments Pty. Ltd.",
	[3]byte{32, 243, 163}:  "Huawei Technologies Co., Ltd",
	[3]byte{32, 248, 94}:   "Delta Electronics",
	[3]byte{32, 250, 187}:  "Cambridge Executive Limited",
	[3]byte{32, 253, 241}:  "3COM EUROPE LTD",
	[3]byte{32, 254, 205}:  "System In Frontier Inc.",
	[3]byte{32, 254, 219}:  "M2M Solution S.A.S.",
	[3]byte{36, 1, 199}:    "Cisco",
	[3]byte{36, 5, 15}:     "MTN Electronic Co. Ltd",
	[3]byte{36, 9, 23}:     "Devlin Electronics Limited",
	[3]byte{36, 10, 17}:    "TCT Mobile Limited",
	[3]byte{36, 10, 100}:   "AzureWaveTechnologies,Inc",
	[3]byte{36, 11, 42}:    "Viettel Group",
	[3]byte{36, 11, 177}:   "KOSTAL Industrie Elektrik GmbH",
	[3]byte{36, 16, 100}:   "Shenzhen Ecsino Tecnical Co. Ltd",
	[3]byte{36, 17, 37}:    "Hutek Co., Ltd.",
	[3]byte{36, 17, 72}:    "Entropix, LLC",
	[3]byte{36, 17, 208}:   "Chongqing Ehs Science and Technology Development Co.,Ltd.",
	[3]byte{36, 26, 140}:   "Squarehead Technology AS",
	[3]byte{36, 27, 19}:    "Shanghai Nutshell Electronic Co., Ltd.",
	[3]byte{36, 31, 44}:    "Calsys, Inc.",
	[3]byte{36, 33, 171}:   "Sony Ericsson Mobile Communications",
	[3]byte{36, 38, 66}:    "SHARP Corporation.",
	[3]byte{36, 47, 250}:   "Toshiba Global Commerce Solutions",
	[3]byte{36, 51, 108}:   "PRIVATE",
	[3]byte{36, 55, 76}:    "Cisco SPVTG",
	[3]byte{36, 55, 239}:   "EMC Electronic Media Communication SA",
	[3]byte{36, 60, 32}:    "Dynamode Group",
	[3]byte{36, 66, 188}:   "Alinco,incorporated",
	[3]byte{36, 69, 151}:   "GEMUE Gebr. Mueller Apparatebau",
	[3]byte{36, 71, 14}:    "PentronicAB",
	[3]byte{36, 73, 123}:   "Innovative Converged Devices Inc",
	[3]byte{36, 79, 29}:    "iRule LLC",
	[3]byte{36, 95, 223}:   "KYOCERA Corporation",
	[3]byte{36, 98, 120}:   "sysmocom - systems for mobile communications GmbH",
	[3]byte{36, 100, 239}:  "CYG SUNRI CO.,LTD.",
	[3]byte{36, 101, 17}:   "AVM GmbH",
	[3]byte{36, 105, 74}:   "Jasmine Systems Inc.",
	[3]byte{36, 105, 165}:  "Huawei Technologies Co., Ltd",
	[3]byte{36, 106, 171}:  "IT-IS International",
	[3]byte{36, 118, 125}:  "Cisco SPVTG",
	[3]byte{36, 119, 3}:    "Intel Corporate",
	[3]byte{36, 128, 0}:    "Westcontrol AS",
	[3]byte{36, 129, 170}:  "KSH International Co., Ltd.",
	[3]byte{36, 130, 138}:  "Prowave Technologies Ltd.",
	[3]byte{36, 134, 244}:  "Ctek, Inc.",
	[3]byte{36, 135, 7}:    "SEnergy Corporation",
	[3]byte{36, 147, 202}:  "Voxtronic Technology Computer-Systeme GmbH",
	[3]byte{36, 148, 66}:   "OPEN ROAD SOLUTIONS , INC.",
	[3]byte{36, 149, 4}:    "SFR",
	[3]byte{36, 151, 237}:  "Techvision Intelligent Technology Limited",
	[3]byte{36, 162, 225}:  "Apple, Inc",
	[3]byte{36, 164, 44}:   "KOUKAAM a.s.",
	[3]byte{36, 164, 60}:   "Ubiquiti Networks, INC",
	[3]byte{36, 164, 149}:  "Thales Canada Inc.",
	[3]byte{36, 168, 125}:  "Panasonic Automotive Systems Asia Pacific(Thailand)Co.,Ltd.",
	[3]byte{36, 169, 55}:   "PURE Storage",
	[3]byte{36, 171, 129}:  "Apple",
	[3]byte{36, 175, 74}:   "Alcatel-Lucent-IPD",
	[3]byte{36, 175, 84}:   "NEXGEN Mediatech Inc.",
	[3]byte{36, 182, 87}:   "CISCO SYSTEMS, INC.",
	[3]byte{36, 182, 184}:  "FRIEM SPA",
	[3]byte{36, 182, 253}:  "Dell Inc",
	[3]byte{36, 184, 140}:  "Crenus Co.,Ltd.",
	[3]byte{36, 184, 210}:  "Opzoon Technology Co.,Ltd.",
	[3]byte{36, 186, 48}:   "Technical Consumer Products, Inc.",
	[3]byte{36, 187, 193}:  "Absolute Analysis",
	[3]byte{36, 188, 130}:  "Dali Wireless, Inc.",
	[3]byte{36, 190, 5}:    "Hewlett Packard",
	[3]byte{36, 191, 116}:  "PRIVATE",
	[3]byte{36, 192, 179}:  "RSF",
	[3]byte{36, 198, 150}:  "Samsung Electronics Co.,Ltd",
	[3]byte{36, 200, 72}:   "mywerk system GmbH",
	[3]byte{36, 200, 110}:  "Chaney Instrument Co.",
	[3]byte{36, 201, 161}:  "Ruckus Wireless",
	[3]byte{36, 201, 222}:  "Genoray",
	[3]byte{36, 203, 231}:  "MYK, Inc.",
	[3]byte{36, 207, 33}:   "Shenzhen State Micro Technology Co., Ltd",
	[3]byte{36, 209, 63}:   "MEXUS CO.,LTD",
	[3]byte{36, 210, 204}:  "SmartDrive Systems Inc.",
	[3]byte{36, 217, 33}:   "Avaya, Inc",
	[3]byte{36, 218, 182}:  "Sistemas de Gestión Energética S.A. de C.V",
	[3]byte{36, 219, 172}:  "Shenzhen Huawei Communication Technologies Co., Ltd",
	[3]byte{36, 219, 173}:  "ShopperTrak RCT Corporation",
	[3]byte{36, 219, 237}:  "Samsung Electronics Co.,Ltd",
	[3]byte{36, 222, 198}:  "Aruba Networks",
	[3]byte{36, 226, 113}:  "Qingdao Hisense Communications Co.,Ltd",
	[3]byte{36, 227, 20}:   "Apple",
	[3]byte{36, 230, 186}:  "JSC Zavod im. Kozitsky",
	[3]byte{36, 233, 179}:  "Cisco",
	[3]byte{36, 234, 64}:   "Systeme Helmholz GmbH",
	[3]byte{36, 235, 101}:  "SAET I.S. S.r.l.",
	[3]byte{36, 236, 153}:  "Askey Computer Corp",
	[3]byte{36, 236, 214}:  "CSG Science & Technology Co.,Ltd.Hefei",
	[3]byte{36, 238, 58}:   "Chengdu Yingji Electronic Hi-tech Co Ltd",
	[3]byte{36, 240, 255}:  "GHT Co., Ltd.",
	[3]byte{36, 242, 221}:  "Radiant Zemax LLC",
	[3]byte{36, 245, 170}:  "Samsung Electronics Co.,LTD",
	[3]byte{36, 253, 82}:   "Liteon Technology Corporation",
	[3]byte{40, 4, 224}:    "FERMAX ELECTRONICA S.A.U.",
	[3]byte{40, 6, 30}:     "NINGBO GLOBAL USEFUL ELECTRIC CO.,LTD",
	[3]byte{40, 6, 141}:    "ITL, LLC",
	[3]byte{40, 11, 92}:    "Apple",
	[3]byte{40, 12, 184}:   "Mikrosay Yazilim ve Elektronik A.S.",
	[3]byte{40, 13, 252}:   "Sony Computer Entertainment Inc.",
	[3]byte{40, 16, 123}:   "D-Link International",
	[3]byte{40, 20, 113}:   "Lantis co., LTD.",
	[3]byte{40, 22, 46}:    "2Wire",
	[3]byte{40, 23, 206}:   "Omnisense Ltd",
	[3]byte{40, 24, 120}:   "Microsoft Corporation",
	[3]byte{40, 24, 253}:   "Aditya Infotech Ltd.",
	[3]byte{40, 34, 70}:    "Beijing Sinoix Communication Co., LTD",
	[3]byte{40, 38, 166}:   "PBR electronics GmbH",
	[3]byte{40, 40, 93}:    "ZyXEL Communications Corporation",
	[3]byte{40, 41, 204}:   "Corsa Technology Incorporated",
	[3]byte{40, 41, 217}:   "GlobalBeiMing technology (Beijing)Co. Ltd",
	[3]byte{40, 44, 178}:   "TP-LINK TECHNOLOGIES CO.,LTD.",
	[3]byte{40, 49, 82}:    "HUAWEI TECHNOLOGIES CO.,LTD",
	[3]byte{40, 50, 197}:   "Humax.co.,ltd",
	[3]byte{40, 52, 16}:    "Enigma Diagnostics Limited",
	[3]byte{40, 52, 162}:   "Cisco",
	[3]byte{40, 55, 55}:    "Apple",
	[3]byte{40, 56, 207}:   "Gen2wave",
	[3]byte{40, 57, 231}:   "Preceno Technology Pte.Ltd.",
	[3]byte{40, 59, 150}:   "Cool Control LTD",
	[3]byte{40, 60, 228}:   "Huawei Technologies Co., Ltd",
	[3]byte{40, 64, 26}:    "C8 MediSensors, Inc.",
	[3]byte{40, 65, 33}:    "OptiSense Network, LLC",
	[3]byte{40, 68, 48}:    "GenesisTechnical Systems (UK) Ltd",
	[3]byte{40, 71, 170}:   "Nokia Corporation",
	[3]byte{40, 72, 70}:    "GridCentric Inc.",
	[3]byte{40, 76, 83}:    "Intune Networks",
	[3]byte{40, 77, 146}:   "Luminator",
	[3]byte{40, 78, 215}:   "OutSmart Power Systems, Inc.",
	[3]byte{40, 79, 206}:   "Liaoning Wontel Science and Technology Development Co.,Ltd.",
	[3]byte{40, 81, 50}:    "Shenzhen Prayfly Technology Co.,Ltd",
	[3]byte{40, 87, 103}:   "Echostar Technologies Corp",
	[3]byte{40, 95, 219}:   "Shenzhen Huawei Communication Technologies Co., Ltd",
	[3]byte{40, 96, 70}:    "Lantech Communications Global, Inc.",
	[3]byte{40, 96, 148}:   "CAPELEC",
	[3]byte{40, 99, 54}:    "Siemens AG - Industrial Automation - EWA",
	[3]byte{40, 101, 107}:  "Keystone Microtech Corporation",
	[3]byte{40, 106, 184}:  "Apple",
	[3]byte{40, 106, 186}:  "Apple",
	[3]byte{40, 109, 151}:  "SAMJIN Co., Ltd.",
	[3]byte{40, 110, 212}:  "HUAWEI TECHNOLOGIES CO.,LTD",
	[3]byte{40, 113, 132}:  "Spire Payments",
	[3]byte{40, 114, 197}:  "Smartmatic Corp",
	[3]byte{40, 114, 240}:  "ATHENA",
	[3]byte{40, 121, 148}:  "Realplay Digital Technology(Shenzhen) Co.,Ltd",
	[3]byte{40, 128, 35}:   "Hewlett Packard",
	[3]byte{40, 133, 45}:   "Touch Networks",
	[3]byte{40, 137, 21}:   "CashGuard Sverige AB",
	[3]byte{40, 138, 28}:   "Juniper networks",
	[3]byte{40, 145, 208}:  "Stage Tec Entwicklungsgesellschaft für professionelle Audiotechnik mbH",
	[3]byte{40, 146, 74}:   "Hewlett Packard",
	[3]byte{40, 147, 254}:  "CISCO SYSTEMS, INC.",
	[3]byte{40, 148, 15}:   "CISCO SYSTEMS, INC.",
	[3]byte{40, 148, 175}:  "Samhwa Telecom",
	[3]byte{40, 152, 123}:  "Samsung Electronics Co.,Ltd",
	[3]byte{40, 154, 75}:   "SteelSeries ApS",
	[3]byte{40, 154, 250}:  "TCT Mobile Limited",
	[3]byte{40, 158, 223}:  "Danfoss Turbocor Compressors, Inc",
	[3]byte{40, 161, 134}:  "enblink",
	[3]byte{40, 161, 146}:  "GERP Solution",
	[3]byte{40, 161, 235}:  "ETEK TECHNOLOGY (SHENZHEN) CO.,LTD",
	[3]byte{40, 162, 65}:   "exlar corp",
	[3]byte{40, 165, 116}:  "Miller Electric Mfg. Co.",
	[3]byte{40, 165, 238}:  "Shenzhen SDGI CATV Co., Ltd",
	[3]byte{40, 175, 10}:   "Sirius XM Radio Inc",
	[3]byte{40, 176, 204}:  "Xenya d.o.o.",
	[3]byte{40, 178, 189}:  "Intel Corporate",
	[3]byte{40, 179, 171}:  "Genmark Automation",
	[3]byte{40, 186, 24}:   "NextNav, LLC",
	[3]byte{40, 186, 181}:  "Samsung Electronics Co.,Ltd",
	[3]byte{40, 187, 89}:   "RNET Technologies, Inc.",
	[3]byte{40, 190, 155}:  "Technicolor USA Inc.",
	[3]byte{40, 192, 218}:  "Juniper Networks",
	[3]byte{40, 198, 113}:  "Yota Devices OY",
	[3]byte{40, 198, 142}:  "NETGEAR INC.,",
	[3]byte{40, 199, 24}:   "Altierre",
	[3]byte{40, 199, 206}:  "Cisco",
	[3]byte{40, 200, 37}:   "DellKing Industrial Co., Ltd",
	[3]byte{40, 201, 20}:   "Taimag Corporation",
	[3]byte{40, 203, 235}:  "One",
	[3]byte{40, 204, 1}:    "Samsung Electronics Co.,Ltd",
	[3]byte{40, 204, 255}:  "Corporacion Empresarial Altra SL",
	[3]byte{40, 205, 28}:   "Espotel Oy",
	[3]byte{40, 205, 76}:   "Individual Computers GmbH",
	[3]byte{40, 205, 156}:  "Shenzhen Dynamax Software Development Co.,Ltd.",
	[3]byte{40, 207, 218}:  "Apple",
	[3]byte{40, 207, 233}:  "Apple",
	[3]byte{40, 209, 175}:  "Nokia Corporation",
	[3]byte{40, 210, 68}:   "LCFC(HeFei) Electronics Technology Co., Ltd.",
	[3]byte{40, 213, 118}:  "Premier Wireless, Inc.",
	[3]byte{40, 217, 62}:   "Telecor Inc.",
	[3]byte{40, 217, 138}:  "Hangzhou Konke Technology Co.,Ltd.",
	[3]byte{40, 217, 151}:  "Yuduan Mobile Co., Ltd.",
	[3]byte{40, 219, 129}:  "Shanghai Guao Electronic Technology Co., Ltd",
	[3]byte{40, 222, 246}:  "bioMerieux Inc.",
	[3]byte{40, 224, 44}:   "Apple",
	[3]byte{40, 225, 76}:   "Apple, Inc.",
	[3]byte{40, 226, 151}:  "Shanghai InfoTM Microelectronics Co.,Ltd.",
	[3]byte{40, 227, 31}:   "Xiaomi inc.",
	[3]byte{40, 227, 71}:   "Liteon Technology Corporation",
	[3]byte{40, 230, 8}:    "Tokheim",
	[3]byte{40, 230, 233}:  "SIS Sat Internet Services GmbH",
	[3]byte{40, 231, 148}:  "Microtime Computer Inc.",
	[3]byte{40, 231, 207}:  "Apple",
	[3]byte{40, 237, 88}:   "JAG Jakob AG",
	[3]byte{40, 238, 44}:   "Frontline Test Equipment",
	[3]byte{40, 239, 1}:    "PRIVATE",
	[3]byte{40, 243, 88}:   "2C - Trifonov & Co",
	[3]byte{40, 245, 50}:   "ADD-Engineering BV",
	[3]byte{40, 246, 6}:    "Syes srl",
	[3]byte{40, 251, 211}:  "Ragentek Technology Group",
	[3]byte{40, 252, 81}:   "The Electric Controller and Manufacturing Co., LLC",
	[3]byte{40, 252, 246}:  "Shenzhen Xin KingBrand enterprises Co.,Ltd",
	[3]byte{44, 0, 44}:     "UNOWHY",
	[3]byte{44, 0, 51}:     "EControls, LLC",
	[3]byte{44, 0, 247}:    "XOS",
	[3]byte{44, 1, 11}:     "NASCENT Technology, LLC - RemKon",
	[3]byte{44, 6, 35}:     "Win Leader Inc.",
	[3]byte{44, 7, 60}:     "DEVLINE LIMITED",
	[3]byte{44, 16, 193}:   "Nintendo Co., Ltd.",
	[3]byte{44, 24, 174}:   "Trend Electronics Co., Ltd.",
	[3]byte{44, 25, 132}:   "IDN Telecom, Inc.",
	[3]byte{44, 26, 49}:    "Electronics Company Limited",
	[3]byte{44, 30, 234}:   "AERODEV",
	[3]byte{44, 33, 114}:   "Juniper Networks",
	[3]byte{44, 36, 95}:    "Babolat VS",
	[3]byte{44, 38, 197}:   "zte corporation",
	[3]byte{44, 39, 215}:   "Hewlett-Packard Company",
	[3]byte{44, 40, 45}:    "BBK COMMUNICATIAO TECHNOLOGY CO.,LTD.",
	[3]byte{44, 41, 151}:   "Microsoft Corporation",
	[3]byte{44, 45, 72}:    "bct electronic GesmbH",
	[3]byte{44, 48, 104}:   "Pantech Co.,Ltd",
	[3]byte{44, 51, 122}:   "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{44, 52, 39}:    "ERCO & GENER",
	[3]byte{44, 53, 87}:    "ELLIY Power CO..Ltd",
	[3]byte{44, 54, 160}:   "Capisco Limited",
	[3]byte{44, 54, 248}:   "CISCO SYSTEMS, INC.",
	[3]byte{44, 55, 49}:    "ShenZhen Yifang Digital Technology Co.,LTD",
	[3]byte{44, 55, 150}:   "CYBO CO.,LTD.",
	[3]byte{44, 57, 150}:   "SAGEMCOM",
	[3]byte{44, 57, 193}:   "Ciena Corporation",
	[3]byte{44, 58, 40}:    "Fagor Electrónica",
	[3]byte{44, 59, 253}:   "Netstor Technology Co., Ltd.",
	[3]byte{44, 62, 207}:   "Cisco",
	[3]byte{44, 63, 56}:    "CISCO SYSTEMS, INC.",
	[3]byte{44, 63, 62}:    "Alge-Timing GmbH",
	[3]byte{44, 65, 56}:    "Hewlett-Packard Company",
	[3]byte{44, 68, 1}:     "Samsung Electronics Co.,Ltd",
	[3]byte{44, 68, 27}:    "Spectrum Medical Limited",
	[3]byte{44, 68, 253}:   "Hewlett Packard",
	[3]byte{44, 80, 137}:   "Shenzhen Kaixuan Visual Technology Co.,Limited",
	[3]byte{44, 83, 74}:    "Shenzhen Winyao Electronic Limited",
	[3]byte{44, 84, 45}:    "CISCO SYSTEMS, INC.",
	[3]byte{44, 84, 207}:   "LG Electronics",
	[3]byte{44, 85, 60}:    "Gainspeed, Inc.",
	[3]byte{44, 89, 229}:   "Hewlett Packard",
	[3]byte{44, 90, 5}:     "Nokia Corporation",
	[3]byte{44, 90, 163}:   "PROMATE ELECTRONIC CO.LTD",
	[3]byte{44, 91, 225}:   "Centripetal Networks, Inc",
	[3]byte{44, 93, 147}:   "Ruckus Wireless",
	[3]byte{44, 95, 243}:   "Pertronic Industries",
	[3]byte{44, 96, 12}:    "QUANTA COMPUTER INC.",
	[3]byte{44, 98, 90}:    "Finest Security Systems Co., Ltd",
	[3]byte{44, 98, 137}:   "Regenersis (Glenrothes) Ltd",
	[3]byte{44, 103, 251}:  "ShenZhen Zhengjili Electronics Co., LTD",
	[3]byte{44, 105, 186}:  "RF Controls, LLC",
	[3]byte{44, 107, 245}:  "Juniper networks",
	[3]byte{44, 113, 85}:   "HiveMotion",
	[3]byte{44, 114, 195}:  "Soundmatters",
	[3]byte{44, 117, 15}:   "Shanghai Dongzhou-Lawton Communication Technology Co. Ltd.",
	[3]byte{44, 118, 138}:  "Hewlett-Packard Company",
	[3]byte{44, 123, 90}:   "Milper Ltd",
	[3]byte{44, 123, 132}:  "OOO Petr Telegin",
	[3]byte{44, 126, 207}:  "Onzo Ltd",
	[3]byte{44, 128, 101}:  "HARTING Inc. of North America",
	[3]byte{44, 129, 88}:   "Hon Hai Precision Ind. Co.,Ltd",
	[3]byte{44, 138, 114}:  "HTC Corporation",
	[3]byte{44, 139, 242}:  "Hitachi Metals America Ltd",
	[3]byte{44, 145, 39}:   "Eintechno Corporation",
	[3]byte{44, 146, 44}:   "Kishu Giken Kogyou Company Ltd,.",
	[3]byte{44, 148, 100}:  "Cincoze Co., Ltd.",
	[3]byte{44, 149, 127}:  "zte corporation",
	[3]byte{44, 151, 23}:   "I.C.Y. B.V.",
	[3]byte{44, 154, 164}:  "NGI SpA",
	[3]byte{44, 158, 95}:   "ARRIS Group, Inc.",
	[3]byte{44, 158, 252}:  "CANON INC.",
	[3]byte{44, 161, 87}:   "acromate, Inc.",
	[3]byte{44, 163, 14}:   "POWER DRAGON DEVELOPMENT LIMITED",
	[3]byte{44, 167, 128}:  "True Technologies Inc.",
	[3]byte{44, 168, 53}:   "RIM",
	[3]byte{44, 171, 37}:   "Shenzhen Gongjin Electronics Co.,Ltd",
	[3]byte{44, 171, 164}:  "Cisco SPVTG",
	[3]byte{44, 176, 93}:   "NETGEAR",
	[3]byte{44, 176, 223}:  "Soliton Technologies Pvt Ltd",
	[3]byte{44, 180, 58}:   "Apple",
	[3]byte{44, 182, 147}:  "Radware",
	[3]byte{44, 182, 157}:  "RED Digital Cinema",
	[3]byte{44, 190, 8}:    "Apple",
	[3]byte{44, 190, 151}:  "Ingenieurbuero Bickele und Buehler GmbH",
	[3]byte{44, 194, 96}:   "Ravello Systems",
	[3]byte{44, 204, 21}:   "Nokia Corporation",
	[3]byte{44, 205, 39}:   "Precor Inc",
	[3]byte{44, 205, 67}:   "Summit Technology Group",
	[3]byte{44, 205, 105}:  "Aqavi.com",
	[3]byte{44, 208, 90}:   "Liteon Technology Corporation",
	[3]byte{44, 209, 218}:  "Sanjole, Inc.",
	[3]byte{44, 210, 231}:  "Nokia Corporation",
	[3]byte{44, 212, 68}:   "Fujitsu Limited",
	[3]byte{44, 221, 12}:   "Discovergy GmbH",
	[3]byte{44, 226, 168}:  "DeviceDesign",
	[3]byte{44, 228, 18}:   "SAGEMCOM SAS",
	[3]byte{44, 230, 204}:  "Ruckus Wireless",
	[3]byte{44, 232, 113}:  "Alert Metalguard ApS",
	[3]byte{44, 237, 235}:  "Alpheus Digital Company Limited",
	[3]byte{44, 238, 38}:   "Petroleum Geo-Services",
	[3]byte{44, 240, 238}:  "Apple",
	[3]byte{44, 242, 3}:    "EMKO ELEKTRONIK SAN VE TIC AS",
	[3]byte{44, 244, 197}:  "Avaya, Inc",
	[3]byte{44, 247, 241}:  "Seeed Technology Inc.",
	[3]byte{44, 250, 162}:  "Alcatel-Lucent",
	[3]byte{48, 5, 92}:     "Brother industries, LTD.",
	[3]byte{48, 11, 156}:   "Delta Mobile Systems, Inc.",
	[3]byte{48, 13, 42}:    "Zhejiang Wellcom Technology Co.,Ltd.",
	[3]byte{48, 14, 213}:   "Hon Hai Precision Ind.Co.Ltd",
	[3]byte{48, 16, 179}:   "Liteon Technology Corporation",
	[3]byte{48, 16, 228}:   "Apple, Inc.",
	[3]byte{48, 20, 45}:    "Piciorgros GmbH",
	[3]byte{48, 20, 74}:    "Wistron Neweb Corp.",
	[3]byte{48, 21, 24}:    "Ubiquitous Communication Co. ltd.",
	[3]byte{48, 22, 141}:   "ProLon",
	[3]byte{48, 23, 200}:   "Sony Ericsson Mobile Communications AB",
	[3]byte{48, 24, 207}:   "DEOS control systems GmbH",
	[3]byte{48, 25, 102}:   "Samsung Electronics Co.,Ltd",
	[3]byte{48, 26, 40}:    "Mako Networks Ltd",
	[3]byte{48, 33, 91}:    "Shenzhen Ostar Display Electronic Co.,Ltd",
	[3]byte{48, 45, 232}:   "JDA, LLC (JDA Systems)",
	[3]byte{48, 50, 148}:   "W-IE-NE-R Plein & Baus GmbH",
	[3]byte{48, 50, 212}:   "Hanilstm Co., Ltd.",
	[3]byte{48, 51, 53}:    "Boosty",
	[3]byte{48, 55, 166}:   "CISCO SYSTEMS, INC.",
	[3]byte{48, 56, 85}:    "Nokia Corporation",
	[3]byte{48, 57, 38}:    "Sony Ericsson Mobile Communications AB",
	[3]byte{48, 57, 85}:    "Shenzhen Jinhengjia Electronic Co., Ltd.",
	[3]byte{48, 57, 242}:   "ADB Broadband Italia",
	[3]byte{48, 58, 100}:   "Intel Corporate",
	[3]byte{48, 61, 8}:     "GLINTT TES S.A.",
	[3]byte{48, 62, 173}:   "Sonavox Canada Inc",
	[3]byte{48, 65, 116}:   "ALTEC LANSING LLC",
	[3]byte{48, 66, 37}:    "BURG-WÄCHTER KG",
	[3]byte{48, 68, 73}:    "PLATH GmbH",
	[3]byte{48, 70, 154}:   "NETGEAR",
	[3]byte{48, 73, 59}:    "Nanjing Z-Com Wireless Co.,Ltd",
	[3]byte{48, 76, 126}:   "Panasonic Electric Works Automation Controls Techno Co.,Ltd.",
	[3]byte{48, 78, 195}:   "Tianjin Techua Technology Co., Ltd.",
	[3]byte{48, 81, 248}:   "BYK-Gardner GmbH",
	[3]byte{48, 82, 90}:    "NST Co., LTD",
	[3]byte{48, 85, 237}:   "Trex Network LLC",
	[3]byte{48, 87, 172}:   "IRLAB LTD.",
	[3]byte{48, 89, 91}:    "streamnow AG",
	[3]byte{48, 89, 183}:   "Microsoft",
	[3]byte{48, 93, 56}:    "Beissbarth",
	[3]byte{48, 96, 35}:    "ARRIS Group, Inc.",
	[3]byte{48, 97, 18}:    "PAV GmbH",
	[3]byte{48, 97, 24}:    "Paradom Inc.",
	[3]byte{48, 101, 236}:  "Wistron (ChongQing)",
	[3]byte{48, 104, 140}:  "Reach Technology Inc.",
	[3]byte{48, 105, 75}:   "RIM",
	[3]byte{48, 108, 190}:  "Skymotion Technology (HK) Limited",
	[3]byte{48, 110, 92}:   "Validus Technologies",
	[3]byte{48, 113, 178}:  "Hangzhou Prevail Optoelectronic Equipment Co.,LTD.",
	[3]byte{48, 115, 80}:   "Inpeco SA",
	[3]byte{48, 117, 18}:   "Sony Mobile Communications AB",
	[3]byte{48, 118, 111}:  "LG Electronics",
	[3]byte{48, 119, 203}:  "Maike Industry(Shenzhen)CO.,LTD",
	[3]byte{48, 120, 107}:  "TIANJIN Golden Pentagon Electronics Co., Ltd.",
	[3]byte{48, 120, 194}:  "Innowireless, Co. Ltd.",
	[3]byte{48, 124, 48}:   "RIM",
	[3]byte{48, 126, 203}:  "SFR",
	[3]byte{48, 133, 169}:  "Asustek Computer Inc",
	[3]byte{48, 135, 48}:   "Shenzhen Huawei Communication Technologies Co., Ltd",
	[3]byte{48, 137, 153}:  "Guangdong East Power Co.,",
	[3]byte{48, 140, 251}:  "Dropcam",
	[3]byte{48, 144, 171}:  "Apple",
	[3]byte{48, 145, 143}:  "Technicolor",
	[3]byte{48, 146, 246}:  "SHANGHAI SUNMON COMMUNICATION TECHNOGY CO.,LTD",
	[3]byte{48, 155, 173}:  "BBK Electronics Corp., Ltd.,",
	[3]byte{48, 168, 219}:  "Sony Mobile Communications AB",
	[3]byte{48, 170, 189}:  "Shanghai Reallytek Information Technology Co.,Ltd",
	[3]byte{48, 174, 123}:  "Deqing Dusun Electron CO., LTD",
	[3]byte{48, 174, 246}:  "Radio Mobile Access",
	[3]byte{48, 178, 22}:   "Hytec Geraetebau GmbH",
	[3]byte{48, 179, 162}:  "Shenzhen Heguang Measurement & Control Technology Co.,Ltd",
	[3]byte{48, 181, 194}:  "TP-LINK TECHNOLOGIES CO.,LTD.",
	[3]byte{48, 181, 241}:  "Aitexin Technology Co., Ltd",
	[3]byte{48, 199, 80}:   "MIC Technology Group",
	[3]byte{48, 199, 174}:  "Samsung Electronics Co.,Ltd",
	[3]byte{48, 200, 42}:   "Wi-Next s.r.l.",
	[3]byte{48, 205, 167}:  "Samsung Electronics ITS, Printer division",
	[3]byte{48, 209, 126}:  "HUAWEI TECHNOLOGIES CO.,LTD",
	[3]byte{48, 211, 87}:   "Logosol, Inc.",
	[3]byte{48, 212, 106}:  "Autosales Incorporated",
	[3]byte{48, 213, 135}:  "Samsung Electronics Co.,Ltd",
	[3]byte{48, 214, 201}:  "Samsung Electronics Co.,Ltd",
	[3]byte{48, 222, 134}:  "Cedac Software S.r.l.",
	[3]byte{48, 228, 142}:  "Vodafone UK",
	[3]byte{48, 228, 219}:  "CISCO SYSTEMS, INC.",
	[3]byte{48, 235, 37}:   "INTEK DIGITAL",
	[3]byte{48, 239, 209}:  "Alstom Strongwish (Shenzhen) Co., Ltd.",
	[3]byte{48, 243, 29}:   "zte corporation",
	[3]byte{48, 243, 58}:   "+plugg srl",
	[3]byte{48, 244, 47}:   "ESP",
	[3]byte{48, 247, 13}:   "Cisco Systems",
	[3]byte{48, 247, 197}:  "Apple",
	[3]byte{48, 247, 215}:  "Thread Technology Co., Ltd",
	[3]byte{48, 249, 237}:  "Sony Corporation",
	[3]byte{48, 250, 183}:  "Tunai Creative",
	[3]byte{48, 253, 17}:   "MACROTECH (USA) INC.",
	[3]byte{52, 0, 163}:    "HUAWEI TECHNOLOGIES CO.,LTD",
	[3]byte{52, 2, 134}:    "Intel Corporate",
	[3]byte{52, 2, 155}:    "CloudBerry Technologies Private Limited",
	[3]byte{52, 7, 251}:    "Ericsson AB",
	[3]byte{52, 8, 4}:      "D-Link Corporation",
	[3]byte{52, 10, 255}:   "Qingdao Hisense Communications Co.,Ltd",
	[3]byte{52, 19, 168}:   "Mediplan Limited",
	[3]byte{52, 19, 232}:   "Intel Corporate",
	[3]byte{52, 21, 158}:   "Apple",
	[3]byte{52, 23, 235}:   "Dell Inc",
	[3]byte{52, 26, 76}:    "SHENZHEN WEIBU ELECTRONICS CO.,LTD.",
	[3]byte{52, 27, 34}:    "Grandbeing Technology Co., Ltd",
	[3]byte{52, 33, 9}:     "Jensen Scandinavia AS",
	[3]byte{52, 35, 135}:   "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{52, 35, 186}:   "Samsung Electro Mechanics co.,LTD.",
	[3]byte{52, 37, 93}:    "Shenzhen Loadcom Technology Co.,Ltd",
	[3]byte{52, 40, 240}:   "ATN International Limited",
	[3]byte{52, 41, 234}:   "MCD ELECTRONICS SP. Z O.O.",
	[3]byte{52, 47, 110}:   "Anywire corporation",
	[3]byte{52, 49, 17}:    "Samsung Electronics Co.,Ltd",
	[3]byte{52, 49, 196}:   "AVM GmbH",
	[3]byte{52, 56, 175}:   "Inlab Software GmbH",
	[3]byte{52, 64, 181}:   "IBM",
	[3]byte{52, 70, 111}:   "HiTEM Engineering",
	[3]byte{52, 75, 61}:    "Fiberhome Telecommunication Tech.Co.,Ltd.",
	[3]byte{52, 75, 80}:    "ZTE Corporation",
	[3]byte{52, 77, 234}:   "zte corporation",
	[3]byte{52, 77, 247}:   "LG Electronics",
	[3]byte{52, 79, 63}:    "IO-Power Technology Co., Ltd.",
	[3]byte{52, 79, 92}:    "R&amp;M AG",
	[3]byte{52, 79, 105}:   "EKINOPS SAS",
	[3]byte{52, 81, 170}:   "JID GLOBAL",
	[3]byte{52, 81, 201}:   "Apple",
	[3]byte{52, 91, 17}:    "EVI HEAT AB",
	[3]byte{52, 92, 64}:    "Cargt Holdings LLC",
	[3]byte{52, 93, 16}:    "Wytek",
	[3]byte{52, 97, 120}:   "The Boeing Company",
	[3]byte{52, 98, 136}:   "Cisco",
	[3]byte{52, 100, 169}:  "Hewlett Packard",
	[3]byte{52, 104, 74}:   "Teraworks Co., Ltd.",
	[3]byte{52, 107, 211}:  "Huawei Technologies Co., Ltd",
	[3]byte{52, 110, 138}:  "Ecosense",
	[3]byte{52, 111, 144}:  "Cisco",
	[3]byte{52, 111, 146}:  "White Rodgers Division",
	[3]byte{52, 117, 199}:  "Avaya, Inc",
	[3]byte{52, 118, 197}:  "I-O DATA DEVICE, INC.",
	[3]byte{52, 120, 119}:  "O-NET Communications(Shenzhen) Limited",
	[3]byte{52, 126, 57}:   "Nokia Danmark A/S",
	[3]byte{52, 129, 55}:   "UNICARD SA",
	[3]byte{52, 129, 196}:  "AVM GmbH",
	[3]byte{52, 130, 222}:  "Kayo Technology, Inc.",
	[3]byte{52, 131, 2}:    "iFORCOM Co., Ltd",
	[3]byte{52, 132, 70}:   "Ericsson AB",
	[3]byte{52, 134, 42}:   "Heinz Lackmann GmbH & Co KG",
	[3]byte{52, 136, 93}:   "Logitech Far East",
	[3]byte{52, 138, 174}:  "SAGEMCOM SAS",
	[3]byte{52, 149, 219}:  "Logitec Corporation",
	[3]byte{52, 151, 251}:  "ADVANCED RF TECHNOLOGIES INC",
	[3]byte{52, 153, 111}:  "VPI Engineering",
	[3]byte{52, 153, 215}:  "Universal Flow Monitors, Inc.",
	[3]byte{52, 154, 13}:   "ZBD Displays Ltd",
	[3]byte{52, 157, 144}:  "Heinzmann GmbH & CO. KG",
	[3]byte{52, 161, 131}:  "AWare, Inc",
	[3]byte{52, 163, 191}:  "Terewave. Inc.",
	[3]byte{52, 165, 93}:   "TECHNOSOFT INTERNATIONAL SRL",
	[3]byte{52, 165, 225}:  "Sensorist ApS",
	[3]byte{52, 166, 140}:  "Shine Profit Development Limited",
	[3]byte{52, 167, 9}:    "Trevil srl",
	[3]byte{52, 167, 186}:  "Fischer International Systems Corporation",
	[3]byte{52, 168, 67}:   "KYOCERA Display Corporation",
	[3]byte{52, 168, 78}:   "Cisco",
	[3]byte{52, 170, 139}:  "Samsung Electronics Co.,Ltd",
	[3]byte{52, 170, 153}:  "Alcatel-Lucent",
	[3]byte{52, 170, 238}:  "Mikrovisatos Servisas UAB",
	[3]byte{52, 173, 228}:  "Shanghai Chint Power Systems Co., Ltd.",
	[3]byte{52, 175, 44}:   "Nintendo Co., Ltd.",
	[3]byte{52, 177, 247}:  "Texas Instruments",
	[3]byte{52, 181, 113}:  "PLDS",
	[3]byte{52, 183, 253}:  "Guangzhou Younghead Electronic Technology Co.,Ltd",
	[3]byte{52, 186, 81}:   "Se-Kure Controls, Inc.",
	[3]byte{52, 186, 154}:  "Asiatelco Technologies Co.",
	[3]byte{52, 187, 31}:   "Research In Motion",
	[3]byte{52, 187, 38}:   "Motorola Mobility LLC",
	[3]byte{52, 188, 166}:  "Beijing Ding Qing Technology, Ltd.",
	[3]byte{52, 189, 200}:  "Cisco Systems",
	[3]byte{52, 189, 249}:  "Shanghai WDK Industrial Co.,Ltd.",
	[3]byte{52, 189, 250}:  "Cisco SPVTG",
	[3]byte{52, 190, 0}:    "Samsung Electronics Co.,Ltd",
	[3]byte{52, 191, 144}:  "Fiberhome Telecommunication Tech.Co.,Ltd.",
	[3]byte{52, 192, 89}:   "Apple",
	[3]byte{52, 195, 172}:  "Samsung Electronics",
	[3]byte{52, 197, 208}:  "Hagleitner Hygiene International GmbH",
	[3]byte{52, 198, 154}:  "Enecsys Ltd",
	[3]byte{52, 199, 49}:   "ALPS Co,. Ltd.",
	[3]byte{52, 200, 3}:    "Nokia Corporation",
	[3]byte{52, 201, 157}:  "EIDOLON COMMUNICATIONS TECHNOLOGY CO. LTD.",
	[3]byte{52, 205, 109}:  "CommSky Technologies",
	[3]byte{52, 205, 190}:  "Huawei Technologies Co., Ltd",
	[3]byte{52, 206, 148}:  "Parsec (Pty) Ltd",
	[3]byte{52, 208, 155}:  "MobilMAX Technology Inc.",
	[3]byte{52, 210, 196}:  "RENA GmbH Print Systeme",
	[3]byte{52, 215, 180}:  "Tributary Systems, Inc.",
	[3]byte{52, 219, 253}:  "Cisco",
	[3]byte{52, 222, 26}:   "Intel Corporate",
	[3]byte{52, 222, 52}:   "zte corporation",
	[3]byte{52, 223, 42}:   "Fujikon Industrial Co.,Limited",
	[3]byte{52, 224, 207}:  "zte corporation",
	[3]byte{52, 224, 215}:  "DONGGUAN QISHENG ELECTRONICS INDUSTRIAL CO., LTD",
	[3]byte{52, 226, 253}:  "Apple",
	[3]byte{52, 228, 42}:   "Automatic Bar Controls Inc.",
	[3]byte{52, 230, 173}:  "Intel Corporate",
	[3]byte{52, 230, 215}:  "Dell Inc.",
	[3]byte{52, 239, 68}:   "2Wire",
	[3]byte{52, 239, 139}:  "NTT Communications Corporation",
	[3]byte{52, 240, 202}:  "Shenzhen Linghangyuan Digital Technology Co.,Ltd.",
	[3]byte{52, 243, 155}:  "WizLAN Ltd.",
	[3]byte{52, 246, 45}:   "SHARP Corporation",
	[3]byte{52, 246, 210}:  "Panasonic Taiwan Co.,Ltd.",
	[3]byte{52, 249, 104}:  "ATEK Products, LLC",
	[3]byte{52, 250, 64}:   "Guangzhou Robustel Technologies Co., Limited",
	[3]byte{52, 252, 111}:  "ALCEA",
	[3]byte{56, 1, 151}:    "Toshiba Samsung Storage Technolgoy Korea Corporation",
	[3]byte{56, 6, 180}:    "A.D.C. GmbH",
	[3]byte{56, 8, 253}:    "Silca Spa",
	[3]byte{56, 10, 10}:    "Sky-City Communication and Electronics Limited Company",
	[3]byte{56, 10, 148}:   "Samsung Electronics Co.,Ltd",
	[3]byte{56, 11, 64}:    "Samsung Electronics Co.,Ltd",
	[3]byte{56, 13, 212}:   "Primax Electronics LTD.",
	[3]byte{56, 14, 123}:   "V.P.S. Thai Co., Ltd",
	[3]byte{56, 15, 74}:    "Apple",
	[3]byte{56, 15, 228}:   "Dedicated Network Partners Oy",
	[3]byte{56, 22, 209}:   "Samsung Electronics Co.,Ltd",
	[3]byte{56, 23, 102}:   "PROMZAKAZ LTD.",
	[3]byte{56, 25, 47}:    "Nokia Corporation",
	[3]byte{56, 28, 26}:    "Cisco",
	[3]byte{56, 28, 74}:    "SIMCom Wireless Solutions Co.,Ltd.",
	[3]byte{56, 34, 157}:   "Pirelli Tyre S.p.A.",
	[3]byte{56, 34, 214}:   "H3C Technologies Co., Limited",
	[3]byte{56, 38, 43}:    "UTran Technology",
	[3]byte{56, 38, 205}:   "ANDTEK",
	[3]byte{56, 40, 234}:   "Fujian Netcom Technology Co., LTD",
	[3]byte{56, 44, 74}:    "ASUSTek COMPUTER INC.",
	[3]byte{56, 45, 209}:   "Samsung Electronics Co.,Ltd",
	[3]byte{56, 49, 172}:   "WEG",
	[3]byte{56, 59, 200}:   "2wire",
	[3]byte{56, 63, 16}:    "DBL Technology Ltd.",
	[3]byte{56, 66, 51}:    "Wildeboer Bauteile GmbH",
	[3]byte{56, 66, 166}:   "Ingenieurbuero Stahlkopf",
	[3]byte{56, 67, 105}:   "Patrol Products Consortium LLC",
	[3]byte{56, 69, 140}:   "MyCloud Technology corporation",
	[3]byte{56, 70, 8}:     "ZTE Corporation",
	[3]byte{56, 72, 76}:    "Apple",
	[3]byte{56, 75, 118}:   "AIRTAME ApS",
	[3]byte{56, 79, 240}:   "Azurewave Technologies, Inc.",
	[3]byte{56, 82, 26}:    "Alcatel-Lucent 7705",
	[3]byte{56, 88, 12}:    "Panaccess Systems GmbH",
	[3]byte{56, 89, 248}:   "MindMade sp. z o.o.",
	[3]byte{56, 89, 249}:   "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{56, 90, 168}:   "Beijing Zhongdun Security Technology Development Co.",
	[3]byte{56, 95, 195}:   "Yu Jeong System, Co.Ltd",
	[3]byte{56, 96, 119}:   "PEGATRON CORPORATION",
	[3]byte{56, 99, 187}:   "Hewlett Packard",
	[3]byte{56, 99, 246}:   "3NOD MULTIMEDIA(SHENZHEN)CO.,LTD",
	[3]byte{56, 102, 69}:   "OOSIC Technology CO.,Ltd",
	[3]byte{56, 103, 147}:  "Asia Optical Co., Inc.",
	[3]byte{56, 107, 187}:  "ARRIS Group, Inc.",
	[3]byte{56, 108, 155}:  "Ivy Biomedical",
	[3]byte{56, 110, 33}:   "Wasion Group Ltd.",
	[3]byte{56, 114, 192}:  "COMTREND",
	[3]byte{56, 123, 71}:   "AKELA, Inc.",
	[3]byte{56, 131, 69}:   "TP-LINK TECHNOLOGIES CO., LTD.",
	[3]byte{56, 137, 220}:  "Opticon Sensors Europe B.V.",
	[3]byte{56, 138, 183}:  "ITC Networks",
	[3]byte{56, 142, 231}:  "Fanhattan LLC",
	[3]byte{56, 145, 251}:  "Xenox Holding BV",
	[3]byte{56, 148, 150}:  "Samsung Elec Co.,Ltd",
	[3]byte{56, 149, 146}:  "Beijing Tendyron Corporation",
	[3]byte{56, 159, 131}:  "OTN Systems N.V.",
	[3]byte{56, 165, 60}:   "Veenstra Instruments",
	[3]byte{56, 165, 182}:  "SHENZHEN MEGMEET ELECTRICAL CO.,LTD",
	[3]byte{56, 168, 81}:   "Moog, Ing",
	[3]byte{56, 168, 107}:  "Orga BV",
	[3]byte{56, 169, 95}:   "Actifio Inc",
	[3]byte{56, 170, 60}:   "SAMSUNG ELECTRO-MECHANICS",
	[3]byte{56, 177, 45}:   "Sonotronic Nagel GmbH",
	[3]byte{56, 177, 219}:  "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{56, 181, 189}:  "E.G.O. Elektro-Ger",
	[3]byte{56, 183, 77}:   "Fijowave Limited",
	[3]byte{56, 187, 35}:   "OzVision America LLC",
	[3]byte{56, 187, 60}:   "Avaya, Inc",
	[3]byte{56, 188, 26}:   "Meizu technology co.,ltd",
	[3]byte{56, 191, 47}:   "Espec Corp.",
	[3]byte{56, 191, 51}:   "NEC CASIO Mobile Communications",
	[3]byte{56, 192, 150}:  "ALPS ELECTRIC CO.,LTD.",
	[3]byte{56, 199, 186}:  "CS Services Co.,Ltd.",
	[3]byte{56, 200, 92}:   "Cisco SPVTG",
	[3]byte{56, 201, 169}:  "SMART High Reliability Solutions, Inc.",
	[3]byte{56, 202, 151}:  "Contour Design LLC",
	[3]byte{56, 209, 53}:   "EasyIO Corporation Sdn. Bhd.",
	[3]byte{56, 219, 187}:  "Sunbow Telecom Co., Ltd.",
	[3]byte{56, 222, 96}:   "Mohlenhoff GmbH",
	[3]byte{56, 224, 142}:  "Mitsubishi Electric Corporation",
	[3]byte{56, 229, 149}:  "Shenzhen Gongjin Electronics Co.,Ltd",
	[3]byte{56, 231, 216}:  "HTC Corporation",
	[3]byte{56, 232, 223}:  "b gmbh medien + datenbanken",
	[3]byte{56, 233, 140}:  "Reco S.p.A.",
	[3]byte{56, 234, 167}:  "Hewlett Packard",
	[3]byte{56, 236, 17}:   "Novatek Microelectronics Corp.",
	[3]byte{56, 236, 228}:  "Samsung Electronics",
	[3]byte{56, 238, 157}:  "Anedo Ltd.",
	[3]byte{56, 240, 152}:  "Vapor Stone Rail Systems",
	[3]byte{56, 243, 63}:   "TATSUNO CORPORATION",
	[3]byte{56, 245, 151}:  "home2net GmbH",
	[3]byte{56, 247, 8}:    "National Resource Management, Inc.",
	[3]byte{56, 248, 137}:  "Huawei Technologies Co., Ltd",
	[3]byte{56, 248, 183}:  "V2COM PARTICIPACOES S.A.",
	[3]byte{56, 254, 197}:  "Ellips B.V.",
	[3]byte{60, 2, 177}:    "Creation Technologies LP",
	[3]byte{60, 4, 191}:    "PRAVIS SYSTEMS Co.Ltd.,",
	[3]byte{60, 5, 171}:    "Product Creation Studio",
	[3]byte{60, 7, 84}:     "Apple",
	[3]byte{60, 7, 113}:    "Sony Corporation",
	[3]byte{60, 8, 30}:     "Beijing Yupont Electric Power Technology Co.,Ltd",
	[3]byte{60, 8, 246}:    "Cisco",
	[3]byte{60, 9, 109}:    "Powerhouse Dynamics",
	[3]byte{60, 12, 72}:    "Servergy, Inc.",
	[3]byte{60, 14, 35}:    "Cisco",
	[3]byte{60, 15, 193}:   "KBC Networks",
	[3]byte{60, 16, 64}:    "daesung network",
	[3]byte{60, 16, 111}:   "ALBAHITH TECHNOLOGIES",
	[3]byte{60, 21, 194}:   "Apple",
	[3]byte{60, 21, 234}:   "TESCOM CO., LTD.",
	[3]byte{60, 24, 159}:   "Nokia Corporation",
	[3]byte{60, 24, 160}:   "Luxshare Precision Industry Co.,Ltd.",
	[3]byte{60, 25, 21}:    "GFI Chrono Time",
	[3]byte{60, 25, 125}:   "Ericsson AB",
	[3]byte{60, 26, 87}:    "Cardiopulmonary Corp",
	[3]byte{60, 26, 121}:   "Huayuan Technology CO.,LTD",
	[3]byte{60, 28, 190}:   "JADAK LLC",
	[3]byte{60, 30, 19}:    "HANGZHOU SUNRISE TECHNOLOGY CO., LTD",
	[3]byte{60, 37, 215}:   "Nokia Corporation",
	[3]byte{60, 38, 213}:   "Sotera Wireless",
	[3]byte{60, 39, 99}:    "SLE quality engineering GmbH & Co. KG",
	[3]byte{60, 45, 183}:   "Texas Instruments",
	[3]byte{60, 47, 58}:    "SFORZATO Corp.",
	[3]byte{60, 48, 12}:    "Dewar Electronics Pty Ltd",
	[3]byte{60, 54, 61}:    "Nokia Corporation",
	[3]byte{60, 54, 228}:   "Arris Group, Inc.",
	[3]byte{60, 56, 136}:   "ConnectQuest, llc",
	[3]byte{60, 57, 195}:   "JW Electronics Co., Ltd.",
	[3]byte{60, 57, 231}:   "IEEE REGISTRATION AUTHORITY  - Please see MAM public listing for more information.",
	[3]byte{60, 58, 115}:   "Avaya, Inc",
	[3]byte{60, 64, 79}:    "Guangdong Pisen Electronics Co. Ltd.",
	[3]byte{60, 67, 142}:   "ARRIS Group, Inc.",
	[3]byte{60, 70, 216}:   "TP-LINK TECHNOLOGIES CO.,LTD.",
	[3]byte{60, 73, 55}:    "ASSMANN Electronic GmbH",
	[3]byte{60, 74, 146}:   "Hewlett-Packard Company",
	[3]byte{60, 76, 105}:   "Infinity System S.L.",
	[3]byte{60, 78, 71}:    "Etronic A/S",
	[3]byte{60, 87, 189}:   "Kessler Crane Inc.",
	[3]byte{60, 87, 213}:   "FiveCo",
	[3]byte{60, 90, 55}:    "Samsung Electronics",
	[3]byte{60, 90, 180}:   "Google",
	[3]byte{60, 95, 1}:     "Synerchip Co., Ltd.",
	[3]byte{60, 97, 4}:     "Juniper Networks",
	[3]byte{60, 98, 0}:     "Samsung electronics CO., LTD",
	[3]byte{60, 98, 120}:   "SHENZHEN JETNET TECHNOLOGY CO.,LTD.",
	[3]byte{60, 103, 44}:   "Sciovid Inc.",
	[3]byte{60, 106, 125}:  "Niigata Power Systems Co., Ltd.",
	[3]byte{60, 110, 99}:   "Mitron OY",
	[3]byte{60, 111, 69}:   "Fiberpro Inc.",
	[3]byte{60, 111, 247}:  "EnTek Systems, Inc.",
	[3]byte{60, 112, 89}:   "MakerBot Industries",
	[3]byte{60, 116, 55}:   "RIM",
	[3]byte{60, 117, 74}:   "ARRIS Group, Inc.",
	[3]byte{60, 119, 230}:  "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{60, 125, 177}:  "Texas Instruments",
	[3]byte{60, 129, 216}:  "SAGEMCOM SAS",
	[3]byte{60, 131, 181}:  "Advance Vision Electronics Co. Ltd.",
	[3]byte{60, 134, 168}:  "Sangshin elecom .co,, LTD",
	[3]byte{60, 137, 166}:  "KAPELSE",
	[3]byte{60, 138, 176}:  "Juniper Networks",
	[3]byte{60, 138, 229}:  "Tensun Information Technology(Hangzhou) Co.,LTD",
	[3]byte{60, 139, 254}:  "Samsung Electronics",
	[3]byte{60, 145, 87}:   "Hangzhou Yulong Conmunication Co.,Ltd",
	[3]byte{60, 145, 116}:  "ALONG COMMUNICATION TECHNOLOGY",
	[3]byte{60, 148, 213}:  "Juniper Networks",
	[3]byte{60, 151, 14}:   "Wistron InfoComm(Kunshan)Co.,Ltd.",
	[3]byte{60, 151, 126}:  "IPS Technology Limited",
	[3]byte{60, 152, 191}:  "Quest Controls, Inc.",
	[3]byte{60, 153, 247}:  "Lansentechnology AB",
	[3]byte{60, 159, 129}:  "Shenzhen CATIC Bit Communications Technology Co.,Ltd",
	[3]byte{60, 161, 13}:   "Samsung Electronics Co.,Ltd",
	[3]byte{60, 163, 21}:   "Bless Information & Communications Co., Ltd",
	[3]byte{60, 167, 43}:   "MRV Communications (Networks) LTD",
	[3]byte{60, 169, 244}:  "Intel Corporate",
	[3]byte{60, 170, 63}:   "iKey, Ltd.",
	[3]byte{60, 171, 142}:  "Apple",
	[3]byte{60, 174, 105}:  "ESA Elektroschaltanlagen Grimma GmbH",
	[3]byte{60, 177, 91}:   "Avaya, Inc",
	[3]byte{60, 177, 127}:  "Wattwatchers Pty Ld",
	[3]byte{60, 184, 122}:  "PRIVATE",
	[3]byte{60, 185, 166}:  "Belden Deutschland GmbH",
	[3]byte{60, 189, 216}:  "LG ELECTRONICS INC",
	[3]byte{60, 192, 198}:  "d&b audiotechnik GmbH",
	[3]byte{60, 193, 44}:   "AES Corporation",
	[3]byte{60, 193, 246}:  "Melange Systems Pvt. Ltd.",
	[3]byte{60, 194, 67}:   "Nokia Corporation",
	[3]byte{60, 201, 158}:  "Huiyang Technology Co., Ltd",
	[3]byte{60, 202, 135}:  "Iders Incorporated",
	[3]byte{60, 205, 90}:   "Technische Alternative GmbH",
	[3]byte{60, 205, 147}:  "LG ELECTRONICS INC",
	[3]byte{60, 206, 115}:  "CISCO SYSTEMS, INC.",
	[3]byte{60, 208, 248}:  "Apple",
	[3]byte{60, 209, 110}:  "Telepower Communication Co., Ltd",
	[3]byte{60, 212, 214}:  "WirelessWERX, Inc",
	[3]byte{60, 215, 218}:  "SK Mtek microelectronics(shenzhen)limited",
	[3]byte{60, 217, 43}:   "Hewlett-Packard Company",
	[3]byte{60, 217, 206}:  "Eclipse WiFi",
	[3]byte{60, 223, 30}:   "CISCO SYSTEMS, INC.",
	[3]byte{60, 223, 189}:  "Huawei Technologies Co., Ltd",
	[3]byte{60, 224, 114}:  "Apple",
	[3]byte{60, 229, 166}:  "Hangzhou H3C Technologies Co., Ltd.",
	[3]byte{60, 229, 180}:  "KIDASEN INDUSTRIA E COMERCIO DE ANTENAS LTDA",
	[3]byte{60, 230, 36}:   "LG Display",
	[3]byte{60, 234, 79}:   "2Wire",
	[3]byte{60, 234, 251}:  "NSE AG",
	[3]byte{60, 243, 146}:  "Virtualtek. Co. Ltd",
	[3]byte{60, 245, 44}:   "DSPECIALISTS GmbH",
	[3]byte{60, 247, 42}:   "Nokia Corporation",
	[3]byte{60, 247, 72}:   "Shenzhen Linsn Technology Development Co.,Ltd",
	[3]byte{60, 248, 8}:    "HUAWEI TECHNOLOGIES CO.,LTD",
	[3]byte{60, 251, 150}:  "Emcraft Systems LLC",
	[3]byte{64, 1, 7}:      "Arista Corp",
	[3]byte{64, 1, 198}:    "3COM EUROPE LTD",
	[3]byte{64, 4, 12}:     "A&T",
	[3]byte{64, 7, 192}:    "Railtec Systems GmbH",
	[3]byte{64, 14, 103}:   "Tremol Ltd.",
	[3]byte{64, 14, 133}:   "Samsung Electro Mechanics co.,LTD.",
	[3]byte{64, 18, 228}:   "Compass-EOS",
	[3]byte{64, 19, 217}:   "Global ES",
	[3]byte{64, 21, 151}:   "Protect America, Inc.",
	[3]byte{64, 22, 126}:   "ASUSTek COMPUTER INC.",
	[3]byte{64, 22, 159}:   "TP-LINK TECHNOLOGIES CO., LTD.",
	[3]byte{64, 22, 250}:   "EKM Metering",
	[3]byte{64, 24, 177}:   "Aerohive Networks Inc.",
	[3]byte{64, 24, 215}:   "Wyle Telemetry and Data Systems",
	[3]byte{64, 29, 89}:    "Biometric Associates, LP",
	[3]byte{64, 34, 237}:   "Digital Projection Ltd",
	[3]byte{64, 37, 194}:   "Intel Corporate",
	[3]byte{64, 39, 11}:    "Mobileeco Co., Ltd",
	[3]byte{64, 43, 161}:   "Sony Ericsson Mobile Communications AB",
	[3]byte{64, 44, 244}:   "Universal Global Scientific Industrial Co., Ltd.",
	[3]byte{64, 48, 4}:     "Apple",
	[3]byte{64, 48, 103}:   "Conlog (Pty) Ltd",
	[3]byte{64, 51, 108}:   "Godrej & Boyce Mfg. co. ltd",
	[3]byte{64, 55, 173}:   "Macro Image Technology, Inc.",
	[3]byte{64, 60, 252}:   "Apple",
	[3]byte{64, 64, 34}:    "ZIV",
	[3]byte{64, 64, 107}:   "Icomera",
	[3]byte{64, 69, 218}:   "Spreadtrum Communications (Shanghai) Co., Ltd.",
	[3]byte{64, 74, 3}:     "ZyXEL Communications Corporation",
	[3]byte{64, 74, 24}:    "Addrek Smart Solutions",
	[3]byte{64, 77, 142}:   "Shenzhen Huawei Communication Technologies Co., Ltd",
	[3]byte{64, 78, 235}:   "Higher Way Electronic Co., Ltd.",
	[3]byte{64, 80, 224}:   "Milton Security Group LLC",
	[3]byte{64, 81, 108}:   "Grandex International Corporation",
	[3]byte{64, 82, 13}:    "Pico Technology",
	[3]byte{64, 85, 57}:    "CISCO SYSTEMS, INC.",
	[3]byte{64, 86, 12}:    "In Home Displays Ltd",
	[3]byte{64, 90, 155}:   "ANOVO",
	[3]byte{64, 95, 190}:   "RIM",
	[3]byte{64, 95, 194}:   "Texas Instruments",
	[3]byte{64, 96, 90}:    "Hawkeye Tech Co. Ltd",
	[3]byte{64, 97, 134}:   "MICRO-STAR INT'L CO.,LTD",
	[3]byte{64, 97, 142}:   "Stella-Green Co",
	[3]byte{64, 102, 122}:  "mediola - connected living AG",
	[3]byte{64, 104, 38}:   "Thales UK Limited",
	[3]byte{64, 106, 171}:  "RIM",
	[3]byte{64, 108, 143}:  "Apple",
	[3]byte{64, 111, 42}:   "Research In Motion",
	[3]byte{64, 112, 9}:    "ARRIS Group, Inc.",
	[3]byte{64, 112, 74}:   "Power Idea Technology Limited",
	[3]byte{64, 112, 116}:  "Life Technology (China) Co., Ltd",
	[3]byte{64, 116, 150}:  "aFUN TECHNOLOGY INC.",
	[3]byte{64, 120, 106}:  "Motorola Mobility LLC",
	[3]byte{64, 120, 117}:  "IMBEL - Industria de Material Belico do Brasil",
	[3]byte{64, 122, 128}:  "Nokia Corporation",
	[3]byte{64, 123, 27}:   "Mettle Networks Inc.",
	[3]byte{64, 130, 86}:   "Continental Automotive GmbH",
	[3]byte{64, 131, 222}:  "Motorola",
	[3]byte{64, 132, 147}:  "Clavister AB",
	[3]byte{64, 136, 224}:  "Beijing Ereneben Information Technology Limited Shenzhen Branch",
	[3]byte{64, 138, 154}:  "TITENG CO., Ltd.",
	[3]byte{64, 139, 7}:    "Actiontec Electronics, Inc",
	[3]byte{64, 139, 246}:  "Shenzhen TCL New Technology Co; Ltd.",
	[3]byte{64, 149, 88}:   "Aisino Corporation",
	[3]byte{64, 151, 209}:  "BK Electronics cc",
	[3]byte{64, 152, 76}:   "Casacom Solutions AG",
	[3]byte{64, 152, 78}:   "Texas Instruments",
	[3]byte{64, 152, 123}:  "Aisino Corporation",
	[3]byte{64, 155, 13}:   "Shenzhen Yourf Kwan Industrial Co., Ltd",
	[3]byte{64, 159, 199}:  "BAEKCHUN I&C Co., Ltd.",
	[3]byte{64, 166, 164}:  "PassivSystems Ltd",
	[3]byte{64, 166, 217}:  "Apple",
	[3]byte{64, 168, 240}:  "Hewlett Packard",
	[3]byte{64, 172, 141}:  "Data Management, Inc.",
	[3]byte{64, 176, 250}:  "LG Electronics",
	[3]byte{64, 178, 200}:  "Nortel Networks",
	[3]byte{64, 179, 149}:  "Apple",
	[3]byte{64, 179, 205}:  "Chiyoda Electronics Co.,Ltd.",
	[3]byte{64, 179, 252}:  "Logital Co. Limited",
	[3]byte{64, 180, 240}:  "Juniper Networks",
	[3]byte{64, 182, 177}:  "SUNGSAM CO,.Ltd",
	[3]byte{64, 183, 243}:  "ARRIS Group, Inc.",
	[3]byte{64, 186, 97}:   "Arima Communications Corp.",
	[3]byte{64, 188, 115}:  "Cronoplast  S.L.",
	[3]byte{64, 188, 139}:  "itelio GmbH",
	[3]byte{64, 189, 158}:  "Physio-Control, Inc",
	[3]byte{64, 191, 23}:   "Digistar Telecom. SA",
	[3]byte{64, 194, 69}:   "Shenzhen Hexicom Technology Co., Ltd.",
	[3]byte{64, 196, 214}:  "ChongQing Camyu Technology Development Co.,Ltd.",
	[3]byte{64, 198, 42}:   "Shanghai Jing Ren Electronic Technology Co., Ltd.",
	[3]byte{64, 199, 201}:  "Naviit Inc.",
	[3]byte{64, 203, 168}:  "Huawei Technologies Co., Ltd",
	[3]byte{64, 205, 58}:   "Z3 Technology",
	[3]byte{64, 211, 45}:   "Apple",
	[3]byte{64, 212, 14}:   "Biodata Ltd",
	[3]byte{64, 213, 89}:   "MICRO S.E.R.I.",
	[3]byte{64, 216, 85}:   "IEEE REGISTRATION AUTHORITY",
	[3]byte{64, 226, 48}:   "AzureWave Technologies, Inc.",
	[3]byte{64, 231, 48}:   "DEY Storage Systems, Inc.",
	[3]byte{64, 231, 147}:  "Shenzhen Siviton Technology Co.,Ltd",
	[3]byte{64, 234, 206}:  "FOUNDER BROADBAND NETWORK SERVICE CO.,LTD",
	[3]byte{64, 236, 248}:  "Siemens AG",
	[3]byte{64, 239, 76}:   "Fihonest communication co.,Ltd",
	[3]byte{64, 240, 47}:   "Liteon Technology Corporation",
	[3]byte{64, 241, 76}:   "ISE Europe SPRL",
	[3]byte{64, 242, 1}:    "SAGEMCOM",
	[3]byte{64, 242, 233}:  "IBM",
	[3]byte{64, 243, 8}:    "Murata Manufactuaring Co.,Ltd.",
	[3]byte{64, 244, 7}:    "Nintendo Co., Ltd.",
	[3]byte{64, 244, 236}:  "CISCO SYSTEMS, INC.",
	[3]byte{64, 245, 46}:   "Leica Microsystems (Schweiz) AG",
	[3]byte{64, 252, 137}:  "ARRIS Group, Inc.",
	[3]byte{68, 3, 167}:    "Cisco",
	[3]byte{68, 12, 253}:   "NetMan Co., Ltd.",
	[3]byte{68, 17, 194}:   "Telegartner Karl Gartner GmbH",
	[3]byte{68, 19, 25}:    "WKK TECHNOLOGY LTD.",
	[3]byte{68, 24, 79}:    "Fitview",
	[3]byte{68, 25, 182}:   "Hangzhou Hikvision Digital Technology Co.,Ltd.",
	[3]byte{68, 30, 145}:   "ARVIDA Intelligent Electronics Technology  Co.,Ltd.",
	[3]byte{68, 30, 161}:   "Hewlett-Packard Company",
	[3]byte{68, 35, 170}:   "Farmage Co., Ltd.",
	[3]byte{68, 37, 187}:   "Bamboo Entertainment Corporation",
	[3]byte{68, 41, 56}:    "NietZsche enterprise Co.Ltd.",
	[3]byte{68, 42, 96}:    "Apple",
	[3]byte{68, 42, 255}:   "E3 Technology, Inc.",
	[3]byte{68, 43, 3}:     "CISCO SYSTEMS, INC.",
	[3]byte{68, 49, 146}:   "Hewlett Packard",
	[3]byte{68, 50, 42}:    "Avaya, Inc",
	[3]byte{68, 50, 200}:   "Technicolor USA Inc.",
	[3]byte{68, 51, 76}:    "Shenzhen Bilian electronic CO.,LTD",
	[3]byte{68, 52, 143}:   "MXT INDUSTRIAL LTDA",
	[3]byte{68, 55, 25}:    "2 Save Energy Ltd",
	[3]byte{68, 55, 111}:   "Young Electric Sign Co",
	[3]byte{68, 55, 230}:   "Hon Hai Precision Ind.Co.Ltd",
	[3]byte{68, 56, 57}:    "Cumulus Networks, inc",
	[3]byte{68, 57, 196}:   "Universal Global Scientific Industrial Co.,Ltd",
	[3]byte{68, 60, 156}:   "Pintsch Tiefenbach GmbH",
	[3]byte{68, 61, 33}:    "Nuvolt",
	[3]byte{68, 62, 178}:   "DEOTRON Co., LTD.",
	[3]byte{68, 72, 145}:   "HDMI Licensing, LLC",
	[3]byte{68, 74, 101}:   "Silverflare Ltd.",
	[3]byte{68, 76, 12}:    "Apple",
	[3]byte{68, 78, 26}:    "Samsung Electronics Co.,Ltd",
	[3]byte{68, 79, 94}:    "Pan Studios Co.,Ltd.",
	[3]byte{68, 81, 219}:   "Raytheon BBN Technologies",
	[3]byte{68, 84, 192}:   "Thompson Aerospace",
	[3]byte{68, 86, 141}:   "PNC Technologies  Co., Ltd.",
	[3]byte{68, 86, 183}:   "Spawn Labs, Inc",
	[3]byte{68, 88, 41}:    "Cisco SPVTG",
	[3]byte{68, 89, 159}:   "Criticare Systems, Inc",
	[3]byte{68, 94, 243}:   "Tonalite Holding B.V.",
	[3]byte{68, 95, 122}:   "Shihlin Electric & Engineering Corp.",
	[3]byte{68, 97, 50}:    "ecobee inc",
	[3]byte{68, 97, 156}:   "FONsystem co. ltd.",
	[3]byte{68, 102, 110}:  "IP-LINE",
	[3]byte{68, 103, 85}:   "Orbit Irrigation",
	[3]byte{68, 104, 171}:  "JUIN COMPANY, LIMITED",
	[3]byte{68, 108, 36}:   "Reallin Electronic Co.,Ltd",
	[3]byte{68, 109, 87}:   "Liteon Technology Corporation",
	[3]byte{68, 109, 108}:  "Samsung Elec Co.,Ltd",
	[3]byte{68, 112, 11}:   "IFFU",
	[3]byte{68, 112, 152}:  "MING HONG TECHNOLOGY (SHEN ZHEN) LIMITED",
	[3]byte{68, 116, 108}:  "Sony Mobile Communications AB",
	[3]byte{68, 123, 196}:  "DualShine Technology(SZ)Co.,Ltd",
	[3]byte{68, 124, 127}:  "Innolight Technology Corporation",
	[3]byte{68, 125, 165}:  "VTION INFORMATION TECHNOLOGY (FUJIAN) CO.,LTD",
	[3]byte{68, 126, 118}:  "Trek Technology (S) Pte Ltd",
	[3]byte{68, 126, 149}:  "Alpha and Omega, Inc",
	[3]byte{68, 131, 18}:   "Star-Net",
	[3]byte{68, 133, 0}:    "Intel Corporate",
	[3]byte{68, 134, 193}:  "Siemens Low Voltage & Products",
	[3]byte{68, 135, 252}:  "ELITEGROUP COMPUTER SYSTEM CO., LTD.",
	[3]byte{68, 136, 203}:  "Camco Technologies NV",
	[3]byte{68, 138, 91}:   "Micro-Star INT'L CO., LTD.",
	[3]byte{68, 140, 82}:   "KTIS CO., Ltd",
	[3]byte{68, 142, 18}:   "DT Research, Inc.",
	[3]byte{68, 142, 129}:  "VIG",
	[3]byte{68, 145, 219}:  "Shanghai Huaqin Telecom Technology Co.,Ltd",
	[3]byte{68, 148, 252}:  "NETGEAR INC.,",
	[3]byte{68, 149, 250}:  "Qingdao Santong Digital Technology Co.Ltd",
	[3]byte{68, 155, 120}:  "The Now Factory",
	[3]byte{68, 156, 181}:  "Alcomp, Inc",
	[3]byte{68, 164, 45}:   "TCT Mobile Limited",
	[3]byte{68, 166, 137}:  "PROMAX ELECTRONICA SA",
	[3]byte{68, 166, 229}:  "THINKING TECHNOLOGY CO.,LTD",
	[3]byte{68, 167, 207}:  "Murata Manufacturing Co., Ltd.",
	[3]byte{68, 168, 194}:  "SEWOO TECH CO., LTD",
	[3]byte{68, 170, 39}:   "udworks Co., Ltd.",
	[3]byte{68, 170, 232}:  "Nanotec Electronic GmbH & Co. KG",
	[3]byte{68, 173, 217}:  "Cisco",
	[3]byte{68, 179, 130}:  "Kuang-chi Institute of Advanced Technology",
	[3]byte{68, 193, 92}:   "Texas Instruments",
	[3]byte{68, 194, 51}:   "Guangzhou Comet Technology Development Co.Ltd",
	[3]byte{68, 195, 6}:    "SIFROM Inc.",
	[3]byte{68, 195, 155}:  "OOO RUBEZH NPO",
	[3]byte{68, 196, 169}:  "Opticom Communication, LLC",
	[3]byte{68, 197, 111}:  "NGN Easy Satfinder (Tianjin) Electronic Co., Ltd",
	[3]byte{68, 201, 162}:  "Greenwald Industries",
	[3]byte{68, 206, 125}:  "SFR",
	[3]byte{68, 209, 94}:   "Shanghai Kingto Information Technology Ltd",
	[3]byte{68, 210, 202}:  "Anvia TV Oy",
	[3]byte{68, 211, 202}:  "CISCO SYSTEMS, INC.",
	[3]byte{68, 212, 224}:  "Sony Mobile Communications AB",
	[3]byte{68, 214, 61}:   "Talari Networks",
	[3]byte{68, 216, 50}:   "Azurewave Technologies, Inc.",
	[3]byte{68, 216, 132}:  "Apple",
	[3]byte{68, 220, 145}:  "PLANEX COMMUNICATIONS INC.",
	[3]byte{68, 220, 203}:  "SEMINDIA SYSTEMS PVT LTD",
	[3]byte{68, 224, 142}:  "Cisco SPVTG",
	[3]byte{68, 225, 55}:   "ARRIS Group, Inc.",
	[3]byte{68, 228, 154}:  "OMNITRONICS PTY LTD",
	[3]byte{68, 228, 217}:  "CISCO SYSTEMS, INC.",
	[3]byte{68, 232, 165}:  "Myreka Technologies Sdn. Bhd.",
	[3]byte{68, 237, 87}:   "Longicorn, inc.",
	[3]byte{68, 238, 48}:   "Budelmann Elektronik GmbH",
	[3]byte{68, 244, 89}:   "Samsung Electronics",
	[3]byte{68, 248, 73}:   "Union Pacific Railroad",
	[3]byte{68, 251, 66}:   "Apple",
	[3]byte{72, 2, 42}:     "B-Link Electronic Limited",
	[3]byte{72, 3, 98}:     "DESAY ELECTRONICS(HUIZHOU)CO.,LTD",
	[3]byte{72, 12, 73}:    "NAKAYO TELECOMMUNICATIONS,INC",
	[3]byte{72, 18, 73}:    "Luxcom Technologies Inc.",
	[3]byte{72, 19, 243}:   "BBK Electronics Corp., Ltd.",
	[3]byte{72, 23, 76}:    "MicroPower technologies",
	[3]byte{72, 24, 66}:    "Shanghai Winaas Co. Equipment Co. Ltd.",
	[3]byte{72, 26, 132}:   "Pointer Telocation Ltd",
	[3]byte{72, 27, 210}:   "Intron Scientific co., ltd.",
	[3]byte{72, 38, 232}:   "Tek-Air Systems, Inc.",
	[3]byte{72, 40, 47}:    "ZTE Corporation",
	[3]byte{72, 44, 234}:   "Motorola Inc Business Light Radios",
	[3]byte{72, 51, 221}:   "ZENNIO AVANCE Y TECNOLOGIA, S.L.",
	[3]byte{72, 52, 61}:    "IEP GmbH",
	[3]byte{72, 61, 50}:    "Syscor Controls &amp; Automation",
	[3]byte{72, 68, 135}:   "Cisco SPVTG",
	[3]byte{72, 68, 247}:   "Samsung Electronics Co., LTD",
	[3]byte{72, 70, 241}:   "Uros Oy",
	[3]byte{72, 70, 251}:   "HUAWEI TECHNOLOGIES CO.,LTD",
	[3]byte{72, 81, 183}:   "Intel Corporate",
	[3]byte{72, 82, 97}:    "SOREEL",
	[3]byte{72, 87, 221}:   "Facebook",
	[3]byte{72, 89, 41}:    "LG Electronics",
	[3]byte{72, 90, 63}:    "WISOL",
	[3]byte{72, 90, 182}:   "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{72, 91, 57}:    "ASUSTek COMPUTER INC.",
	[3]byte{72, 93, 96}:    "Azurewave Technologies, Inc.",
	[3]byte{72, 96, 188}:   "Apple",
	[3]byte{72, 97, 163}:   "Concern \"Axion\" JSC",
	[3]byte{72, 98, 118}:   "HUAWEI TECHNOLOGIES CO.,LTD",
	[3]byte{72, 107, 44}:   "BBK Electronics Corp., Ltd.,",
	[3]byte{72, 107, 145}:  "Fleetwood Group Inc.",
	[3]byte{72, 110, 115}:  "Pica8, Inc.",
	[3]byte{72, 111, 210}:  "StorSimple Inc",
	[3]byte{72, 113, 25}:   "SGB GROUP LTD.",
	[3]byte{72, 116, 110}:  "Apple",
	[3]byte{72, 118, 4}:    "PRIVATE",
	[3]byte{72, 130, 68}:   "Life Fitness / Div. of Brunswick",
	[3]byte{72, 142, 66}:   "DIGALOG GmbH",
	[3]byte{72, 145, 83}:   "Weinmann Geräte für Medizin GmbH + Co. KG",
	[3]byte{72, 145, 246}:  "Shenzhen Reach software technology CO.,LTD",
	[3]byte{72, 155, 226}:  "SCI Innovations Ltd",
	[3]byte{72, 157, 24}:   "Flashbay Limited",
	[3]byte{72, 157, 36}:   "Research In Motion",
	[3]byte{72, 162, 45}:   "Shenzhen Huaxuchang Telecom Technology Co.,Ltd",
	[3]byte{72, 162, 183}:  "Kodofon JSC",
	[3]byte{72, 166, 210}:  "GJsun Optical Science and Tech Co.,Ltd.",
	[3]byte{72, 170, 93}:   "Store Electronic Systems",
	[3]byte{72, 178, 83}:   "Marketaxess Corporation",
	[3]byte{72, 181, 167}:  "Glory Horse Industries Ltd.",
	[3]byte{72, 184, 222}:  "HOMEWINS TECHNOLOGY CO.,LTD.",
	[3]byte{72, 185, 119}:  "PulseOn Oy",
	[3]byte{72, 185, 194}:  "Teletics Inc.",
	[3]byte{72, 190, 45}:   "Symanitron",
	[3]byte{72, 193, 172}:  "PLANTRONICS, INC.",
	[3]byte{72, 200, 98}:   "Simo Wireless,Inc.",
	[3]byte{72, 200, 182}:  "SysTec GmbH",
	[3]byte{72, 203, 110}:  "Cello Electronics (UK) Ltd",
	[3]byte{72, 208, 207}:  "Universal Electronics, Inc.",
	[3]byte{72, 209, 142}:  "Metis Communication Co.,Ltd",
	[3]byte{72, 210, 36}:   "Liteon Technology Corporation",
	[3]byte{72, 213, 76}:   "Jeda Networks",
	[3]byte{72, 215, 5}:    "Apple",
	[3]byte{72, 215, 255}:  "BLANKOM Antennentechnik GmbH",
	[3]byte{72, 216, 85}:   "Telvent",
	[3]byte{72, 216, 254}:  "ClarIDy Solutions, Inc.",
	[3]byte{72, 220, 251}:  "Nokia Corporation",
	[3]byte{72, 223, 28}:   "Wuhan NEC Fibre Optic Communications industry Co. Ltd",
	[3]byte{72, 225, 175}:  "Vity",
	[3]byte{72, 234, 99}:   "Zhejiang Uniview Technologies Co., Ltd.",
	[3]byte{72, 235, 48}:   "ETERNA TECHNOLOGY, INC.",
	[3]byte{72, 237, 128}:  "daesung eltec",
	[3]byte{72, 238, 7}:    "Silver Palm Technologies LLC",
	[3]byte{72, 238, 134}:  "UTStarcom (China) Co.,Ltd",
	[3]byte{72, 242, 48}:   "Ubizcore Co.,LTD",
	[3]byte{72, 243, 23}:   "PRIVATE",
	[3]byte{72, 244, 125}:  "TechVision Holding  Internation Limited",
	[3]byte{72, 247, 241}:  "Alcatel-Lucent",
	[3]byte{72, 248, 179}:  "Cisco-Linksys, LLC",
	[3]byte{72, 248, 225}:  "Alcatel Lucent WT",
	[3]byte{72, 249, 37}:   "Maestronic",
	[3]byte{72, 252, 184}:  "Woodstream Corporation",
	[3]byte{72, 254, 234}:  "HOMA B.V.",
	[3]byte{76, 0, 130}:    "Cisco",
	[3]byte{76, 2, 46}:     "CMR KOREA CO., LTD",
	[3]byte{76, 2, 137}:    "LEX COMPUTECH CO., LTD",
	[3]byte{76, 6, 138}:    "Basler Electric Company",
	[3]byte{76, 7, 201}:    "COMPUTER OFFICE Co.,Ltd.",
	[3]byte{76, 9, 180}:    "zte corporation",
	[3]byte{76, 11, 58}:    "TCT Mobile Limited",
	[3]byte{76, 11, 190}:   "Microsoft",
	[3]byte{76, 13, 238}:   "JABIL CIRCUIT (SHANGHAI) LTD.",
	[3]byte{76, 15, 110}:   "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{76, 15, 199}:   "Earda Electronics Co.,Ltd",
	[3]byte{76, 17, 191}:   "ZHEJIANG DAHUA TECHNOLOGY CO.,LTD.",
	[3]byte{76, 20, 128}:   "NOREGON SYSTEMS, INC",
	[3]byte{76, 20, 163}:   "TCL Technoly Electronics (Huizhou) Co., Ltd.",
	[3]byte{76, 22, 241}:   "zte corporation",
	[3]byte{76, 23, 235}:   "SAGEMCOM",
	[3]byte{76, 26, 58}:    "PRIMA Research And Production Enterprise Ltd.",
	[3]byte{76, 26, 149}:   "Novakon Co., Ltd.",
	[3]byte{76, 31, 204}:   "HUAWEI TECHNOLOGIES CO.,LTD",
	[3]byte{76, 33, 208}:   "Sony Mobile Communications AB",
	[3]byte{76, 34, 88}:    "cozybit, Inc.",
	[3]byte{76, 37, 120}:   "Nokia Corporation",
	[3]byte{76, 38, 231}:   "Welgate Co., Ltd.",
	[3]byte{76, 44, 128}:   "Beijing Skyway Technologies Co.,Ltd",
	[3]byte{76, 44, 131}:   "Zhejiang KaNong Network Technology Co.,Ltd.",
	[3]byte{76, 47, 157}:   "ICM Controls",
	[3]byte{76, 48, 137}:   "Thales Transportation Systems GmbH",
	[3]byte{76, 50, 45}:    "TELEDATA NETWORKS",
	[3]byte{76, 50, 217}:   "M Rutty Holdings Pty. Ltd.",
	[3]byte{76, 57, 9}:     "HPL Electric & Power Private Limited",
	[3]byte{76, 57, 16}:    "Newtek Electronics co., Ltd.",
	[3]byte{76, 59, 116}:   "VOGTEC(H.K.) Co., Ltd",
	[3]byte{76, 60, 22}:    "Samsung Electronics Co.,Ltd",
	[3]byte{76, 72, 218}:   "Beijing Autelan Technology Co.,Ltd",
	[3]byte{76, 75, 104}:   "Mobile Device, Inc.",
	[3]byte{76, 78, 53}:    "Cisco",
	[3]byte{76, 84, 39}:    "Linepro Sp. z o.o.",
	[3]byte{76, 84, 153}:   "Shenzhen Huawei Communication Technologies Co., Ltd",
	[3]byte{76, 85, 133}:   "Hamilton Systems",
	[3]byte{76, 85, 184}:   "Turkcell Teknoloji",
	[3]byte{76, 85, 204}:   "ACKme Networks Pty Ltd",
	[3]byte{76, 93, 205}:   "Oy Finnish Electric Vehicle Technologies Ltd",
	[3]byte{76, 94, 12}:    "Routerboard.com",
	[3]byte{76, 95, 210}:   "Alcatel-Lucent",
	[3]byte{76, 96, 213}:   "airPointe of New Hampshire",
	[3]byte{76, 96, 222}:   "NETGEAR",
	[3]byte{76, 98, 85}:    "SANMINA-SCI SYSTEM DE MEXICO S.A. DE C.V.",
	[3]byte{76, 99, 235}:   "Application Solutions (Electronics and Vision) Ltd",
	[3]byte{76, 100, 217}:  "Guangdong Leawin Group Co., Ltd",
	[3]byte{76, 110, 110}:  "Comnect Technology CO.,LTD",
	[3]byte{76, 114, 185}:  "Pegatron Corporation",
	[3]byte{76, 115, 103}:  "Genius Bytes Software Solutions GmbH",
	[3]byte{76, 115, 165}:  "KOVE",
	[3]byte{76, 116, 3}:    "Mundo Reader (bq)",
	[3]byte{76, 119, 79}:   "Embedded Wireless Labs",
	[3]byte{76, 120, 151}:  "Arrowhead Alarm Products Ltd",
	[3]byte{76, 121, 186}:  "Intel Corporate",
	[3]byte{76, 127, 98}:   "Nokia Corporation",
	[3]byte{76, 128, 79}:   "Armstrong Monitoring Corp",
	[3]byte{76, 128, 147}:  "Intel Corporate",
	[3]byte{76, 130, 207}:  "Echostar Technologies",
	[3]byte{76, 131, 222}:  "Cisco SPVTG",
	[3]byte{76, 139, 48}:   "Actiontec Electronics, Inc",
	[3]byte{76, 139, 85}:   "Grupo Digicon",
	[3]byte{76, 139, 239}:  "Huawei Technologies Co., Ltd",
	[3]byte{76, 141, 121}:  "Apple",
	[3]byte{76, 143, 165}:  "Jastec",
	[3]byte{76, 150, 20}:   "Juniper Networks",
	[3]byte{76, 152, 239}:  "Zeo",
	[3]byte{76, 158, 128}:  "KYOKKO ELECTRIC Co., Ltd.",
	[3]byte{76, 158, 228}:  "Hanyang Navicom Co.,Ltd.",
	[3]byte{76, 158, 255}:  "ZyXEL Communications Corp",
	[3]byte{76, 165, 109}:  "Samsung Electronics Co.,Ltd",
	[3]byte{76, 167, 75}:   "Alcatel Lucent",
	[3]byte{76, 170, 22}:   "AzureWave Technologies (Shanghai) Inc.",
	[3]byte{76, 171, 51}:   "KST technology",
	[3]byte{76, 172, 10}:   "ZTE Corporation",
	[3]byte{76, 177, 108}:  "HUAWEI TECHNOLOGIES CO.,LTD",
	[3]byte{76, 177, 153}:  "Apple",
	[3]byte{76, 180, 234}:  "HRD (S) PTE., LTD.",
	[3]byte{76, 184, 28}:   "SAM Electronics GmbH",
	[3]byte{76, 185, 200}:  "CONET CO., LTD.",
	[3]byte{76, 186, 163}:  "Bison Electronics Inc.",
	[3]byte{76, 187, 88}:   "Chicony Electronics Co., Ltd.",
	[3]byte{76, 188, 66}:   "Shenzhen Hangsheng Electronics Co.,Ltd.",
	[3]byte{76, 188, 165}:  "Samsung Electronics Co.,Ltd",
	[3]byte{76, 196, 82}:   "Shang Hai Tyd. Electon Technology Ltd.",
	[3]byte{76, 198, 2}:    "Radios, Inc.",
	[3]byte{76, 201, 79}:   "Alcatel-Lucent",
	[3]byte{76, 202, 83}:   "Skyera, Inc.",
	[3]byte{76, 203, 245}:  "zte corporation",
	[3]byte{76, 204, 52}:   "Motorola Solutions Inc.",
	[3]byte{76, 214, 55}:   "Qsono Electronics Co., Ltd",
	[3]byte{76, 215, 182}:  "Helmer Scientific",
	[3]byte{76, 217, 196}:  "Magneti Marelli Automotive Electronics (Guangzhou) Co. Ltd",
	[3]byte{76, 223, 61}:   "TEAM ENGINEERS ADVANCE TECHNOLOGIES INDIA PVT LTD",
	[3]byte{76, 225, 187}:  "Zhuhai HiFocus Technology Co., Ltd.",
	[3]byte{76, 226, 241}:  "sclak srl",
	[3]byte{76, 230, 118}:  "Buffalo Inc.",
	[3]byte{76, 233, 51}:   "RailComm, LLC",
	[3]byte{76, 235, 66}:   "Intel Corporate",
	[3]byte{76, 237, 222}:  "Askey Computer Corp",
	[3]byte{76, 240, 46}:   "Vifa Denmark A/S",
	[3]byte{76, 242, 191}:  "Cambridge Industries(Group) Co.,Ltd.",
	[3]byte{76, 244, 91}:   "Blue Clover Devices",
	[3]byte{76, 245, 160}:  "Scalable Network Technologies Inc",
	[3]byte{76, 247, 55}:   "SamJi Electronics Co., Ltd",
	[3]byte{80, 0, 140}:    "Hong Kong Telecommunications (HKT) Limited",
	[3]byte{80, 1, 187}:    "Samsung Electronics",
	[3]byte{80, 5, 61}:     "CyWee Group Ltd",
	[3]byte{80, 6, 4}:      "Cisco",
	[3]byte{80, 11, 50}:    "Foxda Technology Industrial(ShenZhen)Co.,LTD",
	[3]byte{80, 14, 109}:   "TrafficCast International",
	[3]byte{80, 17, 235}:   "SilverNet Ltd",
	[3]byte{80, 20, 181}:   "Richfit Information Technology Co., Ltd",
	[3]byte{80, 23, 255}:   "Cisco",
	[3]byte{80, 26, 197}:   "Microsoft",
	[3]byte{80, 28, 191}:   "Cisco",
	[3]byte{80, 32, 107}:   "Emerson Climate Technologies Transportation Solutions",
	[3]byte{80, 34, 103}:   "PixeLINK",
	[3]byte{80, 37, 43}:    "Nethra Imaging Incorporated",
	[3]byte{80, 38, 144}:   "Fujitsu Limited",
	[3]byte{80, 39, 199}:   "TECHNART Co.,Ltd",
	[3]byte{80, 41, 77}:    "NANJING IOT SENSOR TECHNOLOGY CO,LTD",
	[3]byte{80, 42, 126}:   "Smart electronic GmbH",
	[3]byte{80, 42, 139}:   "Telekom Research and Development Sdn Bhd",
	[3]byte{80, 45, 29}:    "Nokia Corporation",
	[3]byte{80, 45, 162}:   "Intel Corporate",
	[3]byte{80, 45, 244}:   "Phytec Messtechnik GmbH",
	[3]byte{80, 46, 92}:    "HTC Corporation",
	[3]byte{80, 46, 206}:   "Asahi Electronics Co.,Ltd",
	[3]byte{80, 50, 117}:   "Samsung Electronics Co.,Ltd",
	[3]byte{80, 57, 85}:    "Cisco SPVTG",
	[3]byte{80, 60, 196}:   "Lenovo Mobile Communication Technology Ltd.",
	[3]byte{80, 61, 229}:   "CISCO SYSTEMS, INC.",
	[3]byte{80, 63, 86}:    "Syncmold Enterprise Corp",
	[3]byte{80, 70, 93}:    "ASUSTek COMPUTER INC.",
	[3]byte{80, 72, 235}:   "BEIJING HAIHEJINSHENG NETWORK TECHNOLOGY CO. LTD.",
	[3]byte{80, 74, 94}:    "Masimo Corporation",
	[3]byte{80, 74, 110}:   "NETGEAR INC.,",
	[3]byte{80, 79, 148}:   "Loxone Electronics GmbH",
	[3]byte{80, 80, 101}:   "TAKT Corporation",
	[3]byte{80, 86, 99}:    "Texas Instruments",
	[3]byte{80, 86, 168}:   "Jolla Ltd",
	[3]byte{80, 86, 191}:   "Samsung Electronics Co.,LTD",
	[3]byte{80, 87, 168}:   "CISCO SYSTEMS, INC.",
	[3]byte{80, 88, 0}:     "WyTec International, Inc.",
	[3]byte{80, 90, 198}:   "GUANGDONG SUPER TELECOM CO.,LTD.",
	[3]byte{80, 96, 40}:    "Xirrus Inc.",
	[3]byte{80, 97, 132}:   "Avaya, Inc",
	[3]byte{80, 97, 214}:   "Indu-Sol GmbH",
	[3]byte{80, 99, 19}:    "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{80, 100, 65}:   "Greenlee",
	[3]byte{80, 103, 135}:  "iTellus",
	[3]byte{80, 103, 174}:  "Cisco",
	[3]byte{80, 103, 240}:  "ZyXEL Communications Corporation",
	[3]byte{80, 111, 154}:  "Wi-Fi Alliance",
	[3]byte{80, 112, 229}:  "He Shan World Fair Electronics Technology Limited",
	[3]byte{80, 114, 77}:   "BEG Brueck Electronic GmbH",
	[3]byte{80, 118, 145}:  "Tekpea, Inc.",
	[3]byte{80, 118, 166}:  "Ecil Informatica Ind. Com. Ltda",
	[3]byte{80, 121, 91}:   "Interexport Telecomunicaciones S.A.",
	[3]byte{80, 125, 2}:    "BIODIT",
	[3]byte{80, 126, 93}:   "Arcadyan Technology Corporation",
	[3]byte{80, 133, 105}:  "Samsung Electronics Co.,LTD",
	[3]byte{80, 135, 137}:  "Cisco",
	[3]byte{80, 135, 184}:  "Nuvyyo Inc",
	[3]byte{80, 138, 66}:   "Uptmate Technology Co., LTD",
	[3]byte{80, 138, 203}:  "SHENZHEN MAXMADE TECHNOLOGY CO., LTD.",
	[3]byte{80, 140, 119}:  "DIRMEIER Schanktechnik GmbH &Co KG",
	[3]byte{80, 141, 111}:  "CHAHOO Limited",
	[3]byte{80, 147, 79}:   "Gradual Tecnologia Ltda.",
	[3]byte{80, 151, 114}:  "Westinghouse Digital",
	[3]byte{80, 152, 113}:  "Inventum Technologies Private Limited",
	[3]byte{80, 159, 39}:   "Huawei Technologies Co., Ltd",
	[3]byte{80, 160, 84}:   "Actineon",
	[3]byte{80, 160, 191}:  "Alba Fiber Systems Inc.",
	[3]byte{80, 164, 200}:  "Samsung Electronics Co.,Ltd",
	[3]byte{80, 166, 227}:  "David Clark Company",
	[3]byte{80, 167, 21}:   "Aboundi, Inc.",
	[3]byte{80, 167, 51}:   "Ruckus Wireless",
	[3]byte{80, 171, 191}:  "Hoseo Telecom",
	[3]byte{80, 173, 213}:  "Dynalec Corporation",
	[3]byte{80, 175, 115}:  "Shenzhen Bitland Information Technology Co., Ltd.",
	[3]byte{80, 182, 149}:  "Micropoint Biotechnologies,Inc.",
	[3]byte{80, 183, 195}:  "Samsung Electronics CO., LTD",
	[3]byte{80, 184, 136}:  "wi2be Tecnologia S/A",
	[3]byte{80, 184, 162}:  "ImTech Technologies LLC,",
	[3]byte{80, 189, 95}:   "TP-LINK TECHNOLOGIES CO.,LTD.",
	[3]byte{80, 192, 6}:    "Carmanah Signs",
	[3]byte{80, 194, 113}:  "SECURETECH INC",
	[3]byte{80, 197, 141}:  "Juniper Networks",
	[3]byte{80, 199, 191}:  "TP-LINK TECHNOLOGIES CO.,LTD.",
	[3]byte{80, 201, 113}:  "GN Netcom A/S",
	[3]byte{80, 201, 160}:  "SKIPPER Electronics AS",
	[3]byte{80, 204, 248}:  "Samsung Electro Mechanics",
	[3]byte{80, 205, 50}:   "NanJing Chaoran Science & Technology Co.,Ltd.",
	[3]byte{80, 206, 117}:  "Measy Electronics Ltd",
	[3]byte{80, 210, 116}:  "Steffes Corporation",
	[3]byte{80, 214, 215}:  "Takahata Precision",
	[3]byte{80, 224, 199}:  "TurControlSystme AG",
	[3]byte{80, 225, 74}:   "PRIVATE",
	[3]byte{80, 229, 73}:   "GIGA-BYTE TECHNOLOGY CO.,LTD.",
	[3]byte{80, 234, 214}:  "Apple",
	[3]byte{80, 235, 26}:   "Brocade Communications Systems, Inc.",
	[3]byte{80, 237, 120}:  "Changzhou Yongse Infotech Co.,Ltd",
	[3]byte{80, 237, 148}:  "Egatel SL",
	[3]byte{80, 240, 3}:    "Open Stack, Inc.",
	[3]byte{80, 244, 60}:   "Leeo Inc",
	[3]byte{80, 245, 32}:   "Samsung Electronics Co.,Ltd",
	[3]byte{80, 246, 26}:   "Kunshan JADE Technologies co., Ltd.",
	[3]byte{80, 250, 171}:  "L-tek d.o.o.",
	[3]byte{80, 252, 48}:   "Treehouse Labs",
	[3]byte{80, 252, 159}:  "Samsung Electronics Co.,Ltd",
	[3]byte{80, 254, 242}:  "Sify Technologies Ltd",
	[3]byte{84, 3, 245}:    "EBN Technology Corp.",
	[3]byte{84, 4, 150}:    "Gigawave LTD",
	[3]byte{84, 4, 166}:    "ASUSTek COMPUTER INC.",
	[3]byte{84, 5, 54}:     "Vivago Oy",
	[3]byte{84, 5, 95}:     "Alcatel Lucent",
	[3]byte{84, 9, 141}:    "deister electronic GmbH",
	[3]byte{84, 17, 47}:    "Sulzer Pump Solutions Finland Oy",
	[3]byte{84, 17, 95}:    "Atamo Pty Ltd",
	[3]byte{84, 27, 93}:    "Techno-Innov",
	[3]byte{84, 29, 251}:   "Freestyle Energy Ltd",
	[3]byte{84, 31, 213}:   "Advantage Electronics",
	[3]byte{84, 32, 24}:    "Tely Labs",
	[3]byte{84, 33, 96}:    "Resolution Products",
	[3]byte{84, 34, 248}:   "zte corporation",
	[3]byte{84, 38, 150}:   "Apple",
	[3]byte{84, 39, 30}:    "AzureWave Technonloies, Inc.",
	[3]byte{84, 42, 156}:   "LSY Defense, LLC.",
	[3]byte{84, 42, 162}:   "Alpha Networks Inc.",
	[3]byte{84, 44, 234}:   "PROTECTRON",
	[3]byte{84, 47, 137}:   "Euclid Laboratories, Inc.",
	[3]byte{84, 49, 49}:    "Raster Vision Ltd",
	[3]byte{84, 53, 48}:    "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{84, 53, 223}:   "Symeo GmbH",
	[3]byte{84, 57, 104}:   "Edgewater Networks Inc",
	[3]byte{84, 57, 223}:   "HUAWEI TECHNOLOGIES CO.,LTD",
	[3]byte{84, 61, 55}:    "Ruckus Wireless",
	[3]byte{84, 66, 73}:    "Sony Corporation",
	[3]byte{84, 68, 8}:     "Nokia Corporation",
	[3]byte{84, 70, 107}:   "Shenzhen CZTIC Electronic Technology Co., Ltd",
	[3]byte{84, 74, 0}:     "Cisco",
	[3]byte{84, 74, 5}:     "wenglor sensoric gmbh",
	[3]byte{84, 74, 22}:    "Texas Instruments",
	[3]byte{84, 81, 70}:    "AMG Systems Ltd.",
	[3]byte{84, 83, 237}:   "Sony Corporation",
	[3]byte{84, 84, 20}:    "Digital RF Corea, Inc",
	[3]byte{84, 94, 189}:   "NL Technologies",
	[3]byte{84, 95, 169}:   "Teracom Limited",
	[3]byte{84, 97, 234}:   "Zaplox AB",
	[3]byte{84, 114, 79}:   "Apple",
	[3]byte{84, 115, 152}:  "Toyo Electronics Corporation",
	[3]byte{84, 116, 230}:  "Webtech Wireless",
	[3]byte{84, 117, 208}:  "CISCO SYSTEMS, INC.",
	[3]byte{84, 120, 26}:   "Cisco",
	[3]byte{84, 121, 117}:  "Nokia Corporation",
	[3]byte{84, 127, 84}:   "INGENICO",
	[3]byte{84, 127, 168}:  "TELCO systems, s.r.o.",
	[3]byte{84, 127, 238}:  "CISCO SYSTEMS, INC.",
	[3]byte{84, 129, 173}:  "Eagle Research Corporation",
	[3]byte{84, 132, 123}:  "Digital Devices GmbH",
	[3]byte{84, 136, 14}:   "Samsung Electro Mechanics co., LTD.",
	[3]byte{84, 137, 34}:   "Zelfy Inc",
	[3]byte{84, 137, 152}:  "HUAWEI TECHNOLOGIES CO.,LTD",
	[3]byte{84, 146, 190}:  "Samsung Electronics Co.,Ltd",
	[3]byte{84, 147, 89}:   "SHENZHEN TWOWING TECHNOLOGIES CO.,LTD.",
	[3]byte{84, 148, 120}:  "Silvershore Technology Partners",
	[3]byte{84, 154, 22}:   "Uzushio Electric Co.,Ltd.",
	[3]byte{84, 155, 18}:   "Samsung Electronics",
	[3]byte{84, 157, 133}:  "EnerAccess inc",
	[3]byte{84, 159, 53}:   "Dell Inc.",
	[3]byte{84, 160, 79}:   "t-mac Technologies Ltd",
	[3]byte{84, 160, 80}:   "ASUSTek COMPUTER INC.",
	[3]byte{84, 163, 27}:   "Shenzhen Linkworld Technology Co,.LTD",
	[3]byte{84, 165, 27}:   "Shenzhen Huawei Communication Technologies Co., Ltd",
	[3]byte{84, 165, 75}:   "NSC Communications Siberia Ltd",
	[3]byte{84, 166, 25}:   "Alcatel-Lucent Shanghai Bell Co., Ltd",
	[3]byte{84, 169, 212}:  "Minibar Systems",
	[3]byte{84, 174, 39}:   "Apple",
	[3]byte{84, 182, 32}:   "SUHDOL E&C Co.Ltd.",
	[3]byte{84, 183, 83}:   "Hunan Fenghui Yinjia Science And Technology Co.,Ltd",
	[3]byte{84, 190, 247}:  "PEGATRON CORPORATION",
	[3]byte{84, 200, 15}:   "TP-LINK TECHNOLOGIES CO.,LTD.",
	[3]byte{84, 205, 167}:  "Fujian Shenzhou Electronic Co.,Ltd",
	[3]byte{84, 205, 238}:  "ShenZhen Apexis Electronic Co.,Ltd",
	[3]byte{84, 208, 237}:  "AXIM Communications",
	[3]byte{84, 209, 99}:   "MAX-TECH,INC",
	[3]byte{84, 209, 176}:  "Universal Laser Systems, Inc",
	[3]byte{84, 212, 111}:  "Cisco SPVTG",
	[3]byte{84, 223, 0}:    "Ulterius Technologies, LLC",
	[3]byte{84, 223, 99}:   "Intrakey technologies GmbH",
	[3]byte{84, 224, 50}:   "Juniper Networks",
	[3]byte{84, 226, 224}:  "Pace plc",
	[3]byte{84, 227, 176}:  "JVL Industri Elektronik",
	[3]byte{84, 228, 58}:   "Apple, Inc.",
	[3]byte{84, 228, 189}:  "FN-LINK TECHNOLOGY LIMITED",
	[3]byte{84, 230, 63}:   "ShenZhen LingKeWeiEr Technology Co., Ltd.",
	[3]byte{84, 230, 252}:  "TP-LINK TECHNOLOGIES CO., LTD.",
	[3]byte{84, 234, 168}:  "Apple, Inc.",
	[3]byte{84, 238, 117}:  "Wistron InfoComm(Kunshan)Co.,Ltd.",
	[3]byte{84, 239, 146}:  "Shenzhen Elink Technology Co., LTD",
	[3]byte{84, 245, 182}:  "ORIENTAL PACIFIC INTERNATIONAL LIMITED",
	[3]byte{84, 246, 102}:  "Berthold Technologies GmbH and Co.KG",
	[3]byte{84, 248, 118}:  "ABB AG",
	[3]byte{84, 250, 62}:   "Samsung Electronics Co.,LTD",
	[3]byte{84, 251, 88}:   "WISEWARE, Lda",
	[3]byte{84, 253, 191}:  "Scheidt & Bachmann GmbH",
	[3]byte{84, 255, 207}:  "Mopria Alliance",
	[3]byte{88, 5, 40}:     "LABRIS NETWORKS",
	[3]byte{88, 5, 86}:     "Elettronica GF S.r.L.",
	[3]byte{88, 8, 250}:    "Fiber Optic & telecommunication INC.",
	[3]byte{88, 9, 67}:     "PRIVATE",
	[3]byte{88, 9, 229}:    "Kivic Inc.",
	[3]byte{88, 10, 32}:    "Cisco",
	[3]byte{88, 16, 140}:   "Intelbras",
	[3]byte{88, 18, 67}:    "AcSiP Technology Corp.",
	[3]byte{88, 22, 38}:    "Avaya, Inc",
	[3]byte{88, 23, 12}:    "Sony Ericsson Mobile Communications AB",
	[3]byte{88, 28, 189}:   "Affinegy",
	[3]byte{88, 29, 145}:   "Advanced Mobile Telecom co.,ltd.",
	[3]byte{88, 31, 103}:   "Open-m technology limited",
	[3]byte{88, 31, 170}:   "Apple",
	[3]byte{88, 31, 239}:   "Tuttnaer LTD",
	[3]byte{88, 33, 54}:    "KMB systems, s.r.o.",
	[3]byte{88, 35, 140}:   "Technicolor CH USA",
	[3]byte{88, 46, 254}:   "Lighting Science Group",
	[3]byte{88, 47, 66}:    "Universal Electric Corporation",
	[3]byte{88, 52, 59}:    "Glovast Technology Ltd.",
	[3]byte{88, 53, 217}:   "CISCO SYSTEMS, INC.",
	[3]byte{88, 60, 198}:   "Omneality Ltd.",
	[3]byte{88, 66, 228}:   "Sigma International General Medical Apparatus, LLC.",
	[3]byte{88, 70, 143}:   "Koncar Electronics and Informatics",
	[3]byte{88, 70, 225}:   "Baxter Healthcare",
	[3]byte{88, 72, 192}:   "COFLEC",
	[3]byte{88, 73, 59}:    "Palo Alto Networks",
	[3]byte{88, 73, 186}:   "Chitai Electronic Corp.",
	[3]byte{88, 76, 25}:    "Chongqing Guohong Technology Development Company Limited",
	[3]byte{88, 76, 238}:   "Digital One Technologies, Limited",
	[3]byte{88, 80, 118}:   "Linear Equipamentos Eletronicos SA",
	[3]byte{88, 80, 171}:   "TLS Corporation",
	[3]byte{88, 80, 230}:   "Best Buy Corporation",
	[3]byte{88, 85, 202}:   "Apple",
	[3]byte{88, 86, 232}:   "ARRIS Group, Inc.",
	[3]byte{88, 87, 13}:    "Danfoss Solar Inverters",
	[3]byte{88, 99, 154}:   "TPL SYSTEMES",
	[3]byte{88, 101, 230}:  "INFOMARK CO., LTD.",
	[3]byte{88, 102, 186}:  "Hangzhou H3C Technologies Co., Limited",
	[3]byte{88, 103, 26}:   "BARNES&NOBLE.COM",
	[3]byte{88, 103, 127}:  "Clare Controls Inc.",
	[3]byte{88, 105, 108}:  "Fujian Ruijie Networks co, ltd",
	[3]byte{88, 105, 249}:  "Fusion Transactive Ltd.",
	[3]byte{88, 106, 177}:  "Hangzhou H3C Technologies Co., Limited",
	[3]byte{88, 109, 143}:  "Cisco-Linksys, LLC",
	[3]byte{88, 110, 214}:  "PRIVATE",
	[3]byte{88, 117, 33}:   "CJSC RTSoft",
	[3]byte{88, 118, 117}:  "Beijing ECHO Technologies Co.,Ltd",
	[3]byte{88, 118, 197}:  "DIGI I'S LTD",
	[3]byte{88, 122, 77}:   "Stonesoft Corporation",
	[3]byte{88, 123, 233}:  "AirPro Technology India Pvt. Ltd",
	[3]byte{88, 126, 97}:   "Hisense Electric Co., Ltd",
	[3]byte{88, 127, 183}:  "SONAR INDUSTRIAL CO., LTD.",
	[3]byte{88, 127, 200}:  "S2M",
	[3]byte{88, 132, 228}:  "IP500 Alliance e.V.",
	[3]byte{88, 135, 76}:   "LITE-ON CLEAN ENERGY TECHNOLOGY CORP.",
	[3]byte{88, 135, 226}:  "Shenzhen Coship Electronics Co., Ltd.",
	[3]byte{88, 141, 9}:    "CISCO SYSTEMS, INC.",
	[3]byte{88, 145, 207}:  "Intel Corporate",
	[3]byte{88, 146, 13}:   "Kinetic Avionics Limited",
	[3]byte{88, 147, 150}:  "Ruckus Wireless",
	[3]byte{88, 148, 107}:  "Intel Corporate",
	[3]byte{88, 148, 207}:  "Vertex Standard LMR, Inc.",
	[3]byte{88, 151, 30}:   "Cisco",
	[3]byte{88, 152, 53}:   "Technicolor",
	[3]byte{88, 152, 111}:  "Revolution Display",
	[3]byte{88, 156, 252}:  "FreeBSD Foundation",
	[3]byte{88, 162, 181}:  "LG Electronics",
	[3]byte{88, 167, 111}:  "iD corporation",
	[3]byte{88, 176, 53}:   "Apple",
	[3]byte{88, 176, 212}:  "ZuniData Systems Inc.",
	[3]byte{88, 185, 97}:   "SOLEM Electronique",
	[3]byte{88, 185, 225}:  "Crystalfontz America, Inc.",
	[3]byte{88, 188, 39}:   "CISCO SYSTEMS, INC.",
	[3]byte{88, 189, 163}:  "Nintendo Co., Ltd.",
	[3]byte{88, 189, 249}:  "Sigrand",
	[3]byte{88, 191, 234}:  "CISCO SYSTEMS, INC.",
	[3]byte{88, 194, 50}:   "NEC Corporation",
	[3]byte{88, 195, 139}:  "Samsung Electronics",
	[3]byte{88, 207, 75}:   "Lufkin Industries",
	[3]byte{88, 208, 113}:  "BW Broadcast",
	[3]byte{88, 208, 143}:  "IEEE 1904.1 Working Group",
	[3]byte{88, 214, 211}:  "Dairy Cheq Inc",
	[3]byte{88, 219, 141}:  "Fast Co., Ltd.",
	[3]byte{88, 224, 44}:   "Micro Technic A/S",
	[3]byte{88, 227, 38}:   "Compass Technologies Inc.",
	[3]byte{88, 228, 118}:  "CENTRON COMMUNICATIONS TECHNOLOGIES FUJIAN CO.,LTD",
	[3]byte{88, 230, 54}:   "EVRsafe Technologies",
	[3]byte{88, 231, 71}:   "Deltanet AG",
	[3]byte{88, 232, 8}:    "AUTONICS CORPORATION",
	[3]byte{88, 235, 20}:   "Proteus Digital Health",
	[3]byte{88, 236, 225}:  "Newport Corporation",
	[3]byte{88, 238, 206}:  "Icon Time Systems",
	[3]byte{88, 243, 135}:  "HCCP",
	[3]byte{88, 243, 156}:  "Cisco",
	[3]byte{88, 246, 123}:  "Xia Men UnionCore Technology LTD.",
	[3]byte{88, 246, 191}:  "Kyoto University",
	[3]byte{88, 249, 142}:  "SECUDOS GmbH",
	[3]byte{88, 252, 219}:  "IEEE REGISTRATION AUTHORITY  - Please see MAM public listing for more information.",
	[3]byte{88, 253, 32}:   "Bravida Sakerhet AB",
	[3]byte{92, 2, 106}:    "Applied Vision Corporation",
	[3]byte{92, 7, 111}:    "Thought Creator",
	[3]byte{92, 10, 91}:    "SAMSUNG ELECTRO-MECHANICS CO., LTD.",
	[3]byte{92, 12, 187}:   "CELIZION Inc.",
	[3]byte{92, 14, 139}:   "Motorola",
	[3]byte{92, 17, 147}:   "Seal One AG",
	[3]byte{92, 20, 55}:    "Thyssenkrupp Aufzugswerke GmbH",
	[3]byte{92, 21, 21}:    "ADVAN",
	[3]byte{92, 21, 225}:   "AIDC TECHNOLOGY (S) PTE LTD",
	[3]byte{92, 22, 199}:   "Big Switch Networks",
	[3]byte{92, 23, 55}:    "I-View Now, LLC.",
	[3]byte{92, 23, 211}:   "LGE",
	[3]byte{92, 24, 181}:   "Talon Communications",
	[3]byte{92, 32, 208}:   "Asoni Communication Co., Ltd.",
	[3]byte{92, 34, 196}:   "DAE EUN ELETRONICS CO., LTD",
	[3]byte{92, 36, 121}:   "Baltech AG",
	[3]byte{92, 37, 76}:    "Avire Global Pte Ltd",
	[3]byte{92, 38, 10}:    "Dell Inc.",
	[3]byte{92, 42, 239}:   "Open Access Pty Ltd",
	[3]byte{92, 43, 245}:   "Vivint",
	[3]byte{92, 46, 89}:    "Samsung Electronics Co.,Ltd",
	[3]byte{92, 46, 210}:   "ABC(XiSheng) Electronics Co.,Ltd",
	[3]byte{92, 49, 62}:    "Texas Instruments",
	[3]byte{92, 51, 39}:    "Spazio Italia srl",
	[3]byte{92, 51, 92}:    "Swissphone Telecom AG",
	[3]byte{92, 51, 142}:   "Alpha Networkc Inc.",
	[3]byte{92, 53, 59}:    "Compal Broadband Networks Inc.",
	[3]byte{92, 53, 218}:   "There Corporation Oy",
	[3]byte{92, 54, 184}:   "TCL King Electrical Appliances (Huizhou) Ltd.",
	[3]byte{92, 56, 224}:   "Shanghai Super Electronics Technology Co.,LTD",
	[3]byte{92, 60, 39}:    "Samsung Electronics Co.,Ltd",
	[3]byte{92, 64, 88}:    "Jefferson Audio Video Systems, Inc.",
	[3]byte{92, 67, 210}:   "HAZEMEYER",
	[3]byte{92, 74, 38}:    "Enguity Technology Corp",
	[3]byte{92, 76, 169}:   "Shenzhen Huawei Communication Technologies Co., Ltd",
	[3]byte{92, 80, 21}:    "CISCO SYSTEMS, INC.",
	[3]byte{92, 81, 79}:    "Intel Corporate",
	[3]byte{92, 86, 237}:   "3pleplay Electronics Private Limited",
	[3]byte{92, 87, 26}:    "ARRIS Group, Inc.",
	[3]byte{92, 87, 200}:   "Nokia Corporation",
	[3]byte{92, 89, 72}:    "Apple",
	[3]byte{92, 91, 194}:   "YIK Corporation",
	[3]byte{92, 94, 171}:   "Juniper Networks",
	[3]byte{92, 99, 191}:   "TP-LINK TECHNOLOGIES CO., LTD.",
	[3]byte{92, 105, 132}:  "NUVICO",
	[3]byte{92, 106, 125}:  "KENTKART EGE ELEKTRONIK SAN. VE TIC. LTD. STI.",
	[3]byte{92, 107, 50}:   "Texas Instruments",
	[3]byte{92, 109, 32}:   "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{92, 111, 79}:   "S.A. SISTEL",
	[3]byte{92, 119, 87}:   "Haivision Network Video",
	[3]byte{92, 125, 94}:   "Huawei Technologies Co., Ltd",
	[3]byte{92, 132, 134}:  "Brightsource Industries Israel LTD",
	[3]byte{92, 134, 74}:   "Secret Labs LLC",
	[3]byte{92, 135, 120}:  "Cybertelbridge co.,ltd",
	[3]byte{92, 137, 212}:  "Beijing Banner Electric Co.,Ltd",
	[3]byte{92, 141, 78}:   "Apple",
	[3]byte{92, 143, 224}:  "ARRIS Group, Inc.",
	[3]byte{92, 147, 162}:  "Liteon Technology Corporation",
	[3]byte{92, 149, 174}:  "Apple",
	[3]byte{92, 150, 106}:  "RTNET",
	[3]byte{92, 150, 157}:  "Apple",
	[3]byte{92, 151, 243}:  "Apple",
	[3]byte{92, 154, 216}:  "Fujitsu Limited",
	[3]byte{92, 163, 157}:  "SAMSUNG ELECTRO-MECHANICS CO., LTD.",
	[3]byte{92, 163, 235}:  "Lokel s.r.o.",
	[3]byte{92, 164, 138}:  "Cisco",
	[3]byte{92, 170, 253}:  "Sonos, Inc.",
	[3]byte{92, 172, 76}:   "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{92, 181, 36}:   "Sony Ericsson Mobile Communications AB",
	[3]byte{92, 182, 204}:  "NovaComm Technologies Inc.",
	[3]byte{92, 184, 203}:  "Allis Communications",
	[3]byte{92, 189, 158}:  "HONGKONG MIRACLE EAGLE TECHNOLOGY(GROUP) LIMITED",
	[3]byte{92, 194, 19}:   "Fr. Sauter AG",
	[3]byte{92, 197, 212}:  "Intel Corporate",
	[3]byte{92, 198, 208}:  "Skyworth Digital technology(shenzhen)co.ltd.",
	[3]byte{92, 201, 211}:  "PALLADIUM ENERGY ELETRONICA DA AMAZONIA LTDA",
	[3]byte{92, 202, 50}:   "Theben AG",
	[3]byte{92, 206, 173}:  "CDYNE Corporation",
	[3]byte{92, 209, 53}:   "Xtreme Power Systems",
	[3]byte{92, 210, 228}:  "Intel Corporate",
	[3]byte{92, 212, 27}:   "UCZOON Technology Co., LTD",
	[3]byte{92, 212, 171}:  "Zektor",
	[3]byte{92, 214, 31}:   "Qardio, Inc",
	[3]byte{92, 217, 152}:  "D-Link Corporation",
	[3]byte{92, 218, 212}:  "Murata Manufacturing Co., Ltd.",
	[3]byte{92, 221, 112}:  "Hangzhou H3C Technologies Co., Limited",
	[3]byte{92, 224, 197}:  "Intel Corporate",
	[3]byte{92, 224, 202}:  "FeiTian United (Beijing) System Technology Co., Ltd.",
	[3]byte{92, 224, 246}:  "NIC.br- Nucleo de Informacao e Coordenacao do Ponto BR",
	[3]byte{92, 226, 35}:   "Delphin Technology AG",
	[3]byte{92, 226, 134}:  "Nortel Networks",
	[3]byte{92, 226, 244}:  "AcSiP Technology Corp.",
	[3]byte{92, 231, 191}:  "New Singularity International Technical Development Co.,Ltd",
	[3]byte{92, 232, 235}:  "Samsung Electronics",
	[3]byte{92, 235, 78}:   "R. STAHL HMI Systems GmbH",
	[3]byte{92, 238, 121}:  "Global Digitech Co LTD",
	[3]byte{92, 242, 7}:    "Speco Technologies",
	[3]byte{92, 243, 112}:  "CC&C Technologies, Inc",
	[3]byte{92, 243, 252}:  "IBM Corp",
	[3]byte{92, 244, 171}:  "ZyXEL Communications Corp",
	[3]byte{92, 245, 13}:   "Institute of microelectronic applications",
	[3]byte{92, 246, 220}:  "Samsung Electronics Co.,LTD",
	[3]byte{92, 248, 161}:  "Murata Manufactuaring Co.,Ltd.",
	[3]byte{92, 249, 56}:   "Apple, Inc",
	[3]byte{92, 249, 106}:  "Huawei Technologies Co., Ltd",
	[3]byte{92, 249, 221}:  "Dell Inc",
	[3]byte{92, 249, 240}:  "Atomos Engineering P/L",
	[3]byte{92, 255, 53}:   "Wistron Corporation",
	[3]byte{92, 255, 255}:  "Shenzhen Kezhonglong Optoelectronic Technology Co., Ltd",
	[3]byte{96, 2, 146}:    "PEGATRON CORPORATION",
	[3]byte{96, 2, 180}:    "Wistron NeWeb Corp.",
	[3]byte{96, 3, 8}:      "Apple",
	[3]byte{96, 3, 71}:     "Billion Electric Co. Ltd.",
	[3]byte{96, 4, 23}:     "POSBANK CO.,LTD",
	[3]byte{96, 15, 119}:   "SilverPlus, Inc",
	[3]byte{96, 17, 153}:   "Siama Systems Inc",
	[3]byte{96, 18, 131}:   "Soluciones Tecnologicas para la Salud y el Bienestar SA",
	[3]byte{96, 21, 199}:   "IdaTech",
	[3]byte{96, 25, 12}:    "RRAMAC",
	[3]byte{96, 25, 41}:    "VOLTRONIC POWER TECHNOLOGY(SHENZHEN) CORP.",
	[3]byte{96, 29, 15}:    "Midnite Solar",
	[3]byte{96, 30, 2}:     "EltexAlatau",
	[3]byte{96, 33, 3}:     "STCUBE.INC",
	[3]byte{96, 33, 192}:   "Murata Manufactuaring Co.,Ltd.",
	[3]byte{96, 36, 193}:   "Jiangsu Zhongxun Electronic Technology Co., Ltd",
	[3]byte{96, 42, 84}:    "CardioTek B.V.",
	[3]byte{96, 42, 208}:   "Cisco SPVTG",
	[3]byte{96, 50, 240}:   "Mplus technology",
	[3]byte{96, 51, 75}:    "Apple",
	[3]byte{96, 53, 83}:    "Buwon Technology",
	[3]byte{96, 54, 150}:   "The Sapling Company",
	[3]byte{96, 54, 221}:   "Intel Corporate",
	[3]byte{96, 56, 14}:    "Alps Electric Co.,",
	[3]byte{96, 57, 31}:    "ABB Ltd",
	[3]byte{96, 63, 197}:   "COX CO., LTD",
	[3]byte{96, 68, 245}:   "Easy Digital Ltd.",
	[3]byte{96, 69, 94}:    "Liptel s.r.o.",
	[3]byte{96, 69, 189}:   "Microsoft",
	[3]byte{96, 70, 22}:    "XIAMEN VANN INTELLIGENT CO., LTD",
	[3]byte{96, 71, 212}:   "FORICS Electronic Technology Co., Ltd.",
	[3]byte{96, 72, 38}:    "Newbridge Technologies Int. Ltd.",
	[3]byte{96, 74, 28}:    "SUYIN Corporation",
	[3]byte{96, 80, 193}:   "Kinetek Sports",
	[3]byte{96, 81, 44}:    "TCT mobile limited",
	[3]byte{96, 82, 208}:   "FACTS Engineering",
	[3]byte{96, 84, 100}:   "Eyedro Green Solutions Inc.",
	[3]byte{96, 87, 24}:    "Intel Corporate",
	[3]byte{96, 96, 31}:    "SZ DJI TECHNOLOGY CO.,LTD",
	[3]byte{96, 99, 253}:   "Transcend Communication Beijing Co.,Ltd.",
	[3]byte{96, 100, 161}:  "RADiflow Ltd.",
	[3]byte{96, 103, 32}:   "Intel Corporate",
	[3]byte{96, 105, 68}:   "Apple, Inc",
	[3]byte{96, 105, 155}:  "isepos GmbH",
	[3]byte{96, 107, 189}:  "Samsung Electronics Co., LTD",
	[3]byte{96, 108, 102}:  "Intel Corporate",
	[3]byte{96, 115, 92}:   "Cisco",
	[3]byte{96, 116, 141}:  "Atmaca Elektronik",
	[3]byte{96, 118, 136}:  "Velodyne",
	[3]byte{96, 119, 226}:  "Samsung Electronics Co.,Ltd",
	[3]byte{96, 129, 43}:   "Custom Control Concepts",
	[3]byte{96, 129, 249}:  "Helium Systems, Inc",
	[3]byte{96, 131, 178}:  "GkWare e.K.",
	[3]byte{96, 132, 59}:   "Soladigm, Inc.",
	[3]byte{96, 134, 69}:   "Avery Weigh-Tronix, LLC",
	[3]byte{96, 137, 60}:   "Thermo Fisher Scientific P.O.A.",
	[3]byte{96, 137, 177}:  "Key Digital Systems",
	[3]byte{96, 137, 183}:  "KAEL MÜHENDİSLİK ELEKTRONİK TİCARET SANAYİ LİMİTED ŞİRKETİ",
	[3]byte{96, 140, 43}:   "Hanson Technology",
	[3]byte{96, 141, 23}:   "Sentrus Government Systems Division, Inc",
	[3]byte{96, 143, 92}:   "Samsung Electronics Co.,Ltd",
	[3]byte{96, 144, 132}:  "DSSD Inc",
	[3]byte{96, 146, 23}:   "Apple",
	[3]byte{96, 150, 32}:   "PRIVATE",
	[3]byte{96, 153, 209}:  "Vuzix / Lenovo",
	[3]byte{96, 154, 164}:  "GVI SECURITY INC.",
	[3]byte{96, 158, 100}:  "Vivonic GmbH",
	[3]byte{96, 159, 157}:  "CloudSwitch",
	[3]byte{96, 161, 10}:   "Samsung Electronics Co.,Ltd",
	[3]byte{96, 164, 76}:   "ASUSTek COMPUTER INC.",
	[3]byte{96, 168, 254}:  "Nokia Solutions and Networks",
	[3]byte{96, 169, 176}:  "Merchandising Technologies, Inc",
	[3]byte{96, 177, 133}:  "ATH system",
	[3]byte{96, 179, 196}:  "Elber Srl",
	[3]byte{96, 182, 6}:    "Phorus",
	[3]byte{96, 182, 23}:   "Fiberhome Telecommunication Tech.Co.,Ltd.",
	[3]byte{96, 185, 51}:   "Deutron Electronics Corp.",
	[3]byte{96, 185, 130}:  "RO.VE.R. Laboratories S.p.A.",
	[3]byte{96, 187, 12}:   "Beijing HuaqinWorld Technology Co,Ltd",
	[3]byte{96, 188, 76}:   "EWM Hightec Welding GmbH",
	[3]byte{96, 189, 145}:  "Move Innovation",
	[3]byte{96, 190, 181}:  "Motorola Mobility LLC",
	[3]byte{96, 193, 203}:  "Fujian Great Power PLC Equipment Co.,Ltd",
	[3]byte{96, 195, 151}:  "2Wire Inc",
	[3]byte{96, 197, 71}:   "Apple",
	[3]byte{96, 197, 168}:  "Beijing LT Honway Technology Co.,Ltd",
	[3]byte{96, 199, 152}:  "Verifone, Inc.",
	[3]byte{96, 201, 128}:  "Trymus",
	[3]byte{96, 203, 251}:  "AirScape Inc.",
	[3]byte{96, 205, 169}:  "Abloomy",
	[3]byte{96, 205, 197}:  "Taiwan Carol Electronics., Ltd",
	[3]byte{96, 208, 169}:  "Samsung Electronics Co.,Ltd",
	[3]byte{96, 209, 170}:  "Vishal Telecommunications Pvt Ltd",
	[3]byte{96, 210, 185}:  "REALAND BIO CO., LTD.",
	[3]byte{96, 211, 10}:   "Quatius Limited",
	[3]byte{96, 216, 25}:   "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{96, 217, 199}:  "Apple",
	[3]byte{96, 218, 35}:   "Estech Co.,Ltd",
	[3]byte{96, 219, 42}:   "HNS",
	[3]byte{96, 222, 68}:   "HUAWEI TECHNOLOGIES CO.,LTD",
	[3]byte{96, 224, 14}:   "SHINSEI ELECTRONICS CO LTD",
	[3]byte{96, 227, 39}:   "TP-LINK TECHNOLOGIES CO.,LTD.",
	[3]byte{96, 231, 1}:    "Huawei Technologies Co., Ltd",
	[3]byte{96, 233, 86}:   "Ayla Networks, Inc",
	[3]byte{96, 235, 105}:  "Quanta computer Inc.",
	[3]byte{96, 241, 61}:   "JABLOCOM s.r.o.",
	[3]byte{96, 242, 129}:  "TRANWO TECHNOLOGY CO., LTD.",
	[3]byte{96, 242, 239}:  "VisionVera International Co., Ltd.",
	[3]byte{96, 243, 218}:  "Logic Way GmbH",
	[3]byte{96, 244, 148}:  "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{96, 245, 156}:  "CRU-Dataport",
	[3]byte{96, 246, 115}:  "TERUMO CORPORATION",
	[3]byte{96, 250, 205}:  "Apple",
	[3]byte{96, 251, 66}:   "Apple",
	[3]byte{96, 254, 30}:   "China Palms Telecom.Ltd",
	[3]byte{96, 254, 32}:   "2 Wire",
	[3]byte{96, 254, 197}:  "Apple",
	[3]byte{96, 254, 249}:  "Thomas & Betts",
	[3]byte{96, 255, 221}:  "C.E. ELECTRONICS, INC",
	[3]byte{100, 0, 45}:    "Powerlinq Co., LTD",
	[3]byte{100, 0, 241}:   "CISCO SYSTEMS, INC.",
	[3]byte{100, 5, 190}:   "NEW LIGHT LED",
	[3]byte{100, 9, 76}:    "Beijing Superbee Wireless Technology Co.,Ltd",
	[3]byte{100, 9, 128}:   "XIAOMI Electronics,CO.,LTD",
	[3]byte{100, 11, 74}:   "Digital Telecom Technology Limited",
	[3]byte{100, 14, 54}:   "TAZTAG",
	[3]byte{100, 14, 148}:  "Pluribus Networks, Inc.",
	[3]byte{100, 15, 40}:   "2wire",
	[3]byte{100, 16, 132}:  "HEXIUM Technical Development Co., Ltd.",
	[3]byte{100, 18, 37}:   "Cisco",
	[3]byte{100, 22, 141}:  "CISCO SYSTEMS, INC.",
	[3]byte{100, 22, 240}:  "Shehzhen Huawei Communication Technologies Co., Ltd.",
	[3]byte{100, 26, 34}:   "Heliospectra/Woodhill Investments",
	[3]byte{100, 28, 103}:  "DIGIBRAS INDUSTRIA DO BRASILS/A",
	[3]byte{100, 30, 129}:  "Dowslake Microsystems",
	[3]byte{100, 32, 12}:   "Apple",
	[3]byte{100, 33, 132}:  "Nippon Denki Kagaku Co.,LTD",
	[3]byte{100, 34, 22}:   "Shandong Taixin Electronic co.,Ltd",
	[3]byte{100, 36, 0}:    "Xorcom Ltd.",
	[3]byte{100, 39, 55}:   "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{100, 45, 183}:  "SEUNGIL ELECTRONICS",
	[3]byte{100, 49, 80}:   "Hewlett-Packard Company",
	[3]byte{100, 49, 126}:  "Dexin Corporation",
	[3]byte{100, 52, 9}:    "BITwave Pte Ltd",
	[3]byte{100, 62, 140}:  "HUAWEI TECHNOLOGIES CO.,LTD",
	[3]byte{100, 63, 95}:   "Exablaze",
	[3]byte{100, 66, 20}:   "Swisscom Energy Solutions AG",
	[3]byte{100, 67, 70}:   "GuangDong Quick Network Computer CO.,LTD",
	[3]byte{100, 75, 195}:  "Shanghai WOASiS Telecommunications Ltd., Co.",
	[3]byte{100, 75, 240}:  "CalDigit, Inc",
	[3]byte{100, 77, 112}:  "dSPACE GmbH",
	[3]byte{100, 79, 116}:  "LENUS Co., Ltd.",
	[3]byte{100, 79, 176}:  "Hyunjin.com",
	[3]byte{100, 81, 6}:    "Hewlett Packard",
	[3]byte{100, 81, 126}:  "LONG BEN (DONGGUAN) ELECTRONIC TECHNOLOGY CO.,LTD.",
	[3]byte{100, 82, 153}:  "The Chamberlain Group, Inc",
	[3]byte{100, 83, 93}:   "Frauscher Sensortechnik",
	[3]byte{100, 84, 34}:   "Equinox Payments",
	[3]byte{100, 85, 99}:   "Intelight Inc.",
	[3]byte{100, 85, 127}:  "NSFOCUS Information Technology Co., Ltd.",
	[3]byte{100, 85, 177}:  "ARRIS Group, Inc.",
	[3]byte{100, 86, 1}:    "TP-LINK TECHNOLOGIES CO.,LTD",
	[3]byte{100, 90, 4}:    "Chicony Electronics Co., Ltd.",
	[3]byte{100, 93, 215}:  "Shenzhen Lifesense Medical Electronics Co., Ltd.",
	[3]byte{100, 94, 190}:  "Yahoo! JAPAN",
	[3]byte{100, 95, 255}:  "Nicolet Neuro",
	[3]byte{100, 98, 35}:   "Cellient Co., Ltd.",
	[3]byte{100, 100, 155}: "juniper networks",
	[3]byte{100, 101, 192}: "Nuvon, Inc",
	[3]byte{100, 102, 179}: "TP-LINK TECHNOLOGIES CO., LTD.",
	[3]byte{100, 103, 7}:   "Beijing Omnific Technology, Ltd.",
	[3]byte{100, 104, 12}:  "COMTREND",
	[3]byte{100, 105, 188}: "Hytera Communications Co .,ltd",
	[3]byte{100, 108, 178}: "Samsung Electronics Co.,Ltd",
	[3]byte{100, 110, 108}: "Radio Datacom LLC",
	[3]byte{100, 110, 234}: "Iskratel d.o.o.",
	[3]byte{100, 112, 2}:   "TP-LINK TECHNOLOGIES CO., LTD.",
	[3]byte{100, 114, 216}: "GooWi Technology Co.,Limited",
	[3]byte{100, 115, 226}: "Arbiter Systems, Inc.",
	[3]byte{100, 118, 87}:  "Innovative Security Designs",
	[3]byte{100, 118, 186}: "Apple",
	[3]byte{100, 119, 145}: "Samsung Electronics Co.,Ltd",
	[3]byte{100, 123, 212}: "Texas Instruments",
	[3]byte{100, 124, 52}:  "Ubee Interactive Corp.",
	[3]byte{100, 125, 129}: "YOKOTA INDUSTRIAL CO,.LTD",
	[3]byte{100, 127, 218}: "TEKTELIC Communications Inc.",
	[3]byte{100, 128, 139}: "VG Controls, Inc.",
	[3]byte{100, 128, 153}: "Intel Corporate",
	[3]byte{100, 129, 37}:  "Alphatron Marine BV",
	[3]byte{100, 135, 136}: "Juniper Networks",
	[3]byte{100, 135, 215}: "Pirelli Tyre S.p.A.",
	[3]byte{100, 136, 255}: "Sichuan Changhong Electric Ltd.",
	[3]byte{100, 137, 154}: "LG Electronics",
	[3]byte{100, 141, 158}: "IVT Electronic Co.,Ltd",
	[3]byte{100, 153, 93}:  "LGE",
	[3]byte{100, 153, 104}: "Elentec",
	[3]byte{100, 153, 160}: "AG Elektronik AB",
	[3]byte{100, 155, 36}:  "V Technology Co., Ltd.",
	[3]byte{100, 156, 129}: "Qualcomm iSkoot, Inc.",
	[3]byte{100, 156, 142}: "Texas Instruments",
	[3]byte{100, 158, 243}: "CISCO SYSTEMS, INC.",
	[3]byte{100, 159, 247}: "Kone OYj",
	[3]byte{100, 160, 231}: "CISCO SYSTEMS, INC.",
	[3]byte{100, 162, 50}:  "OOO Samlight",
	[3]byte{100, 163, 65}:  "Wonderlan (Beijing) Technology Co., Ltd.",
	[3]byte{100, 163, 203}: "Apple",
	[3]byte{100, 167, 105}: "HTC Corporation",
	[3]byte{100, 167, 221}: "Avaya, Inc",
	[3]byte{100, 168, 55}:  "Juni Korea Co., Ltd",
	[3]byte{100, 174, 12}:  "CISCO SYSTEMS, INC.",
	[3]byte{100, 174, 136}: "Polytec GmbH",
	[3]byte{100, 178, 29}:  "Chengdu Phycom Tech Co., Ltd.",
	[3]byte{100, 179, 16}:  "Samsung Electronics Co.,Ltd",
	[3]byte{100, 179, 112}: "PowerComm Solutons LLC",
	[3]byte{100, 180, 115}: "Xiaomi inc.",
	[3]byte{100, 182, 74}:  "ViVOtech, Inc.",
	[3]byte{100, 184, 83}:  "Samsung Elec Co.,Ltd",
	[3]byte{100, 185, 232}: "Apple",
	[3]byte{100, 186, 189}: "SDJ Technologies, Inc.",
	[3]byte{100, 188, 17}:  "CombiQ AB",
	[3]byte{100, 197, 170}: "South African Broadcasting Corporation",
	[3]byte{100, 198, 103}: "Barnes&Noble",
	[3]byte{100, 198, 175}: "AXERRA Networks Ltd",
	[3]byte{100, 201, 68}:  "LARK Technologies, Inc",
	[3]byte{100, 208, 45}:  "Next Generation Integration (NGI)",
	[3]byte{100, 209, 163}: "Sitecom Europe BV",
	[3]byte{100, 210, 65}:  "Keith & Koep GmbH",
	[3]byte{100, 212, 189}: "ALPS ELECTRIC CO.,LTD.",
	[3]byte{100, 212, 218}: "Intel Corporate",
	[3]byte{100, 216, 20}:  "CISCO SYSTEMS, INC.",
	[3]byte{100, 217, 18}:  "Solidica, Inc.",
	[3]byte{100, 217, 84}:  "TAICANG AND W ELECTRONICS CO LTD",
	[3]byte{100, 217, 137}: "CISCO SYSTEMS, INC.",
	[3]byte{100, 219, 24}:  "OpenPattern",
	[3]byte{100, 220, 1}:   "Static Systems Group PLC",
	[3]byte{100, 222, 28}:  "Kingnetic Pte Ltd",
	[3]byte{100, 225, 97}:  "DEP Corp.",
	[3]byte{100, 229, 153}: "EFM Networks",
	[3]byte{100, 230, 37}:  "Woxu Wireless Co., Ltd",
	[3]byte{100, 230, 130}: "Apple",
	[3]byte{100, 232, 79}:  "Serialway Communication Technology Co. Ltd",
	[3]byte{100, 232, 146}: "Morio Denki Co., Ltd.",
	[3]byte{100, 232, 230}: "global moisture management system",
	[3]byte{100, 233, 80}:  "Cisco",
	[3]byte{100, 234, 197}: "SiboTech Automation Co., Ltd.",
	[3]byte{100, 235, 140}: "Seiko Epson Corporation",
	[3]byte{100, 237, 87}:  "ARRIS Group, Inc.",
	[3]byte{100, 237, 98}:  "WOORI SYSTEMS Co., Ltd",
	[3]byte{100, 242, 66}:  "Gerdes Aktiengesellschaft",
	[3]byte{100, 245, 14}:  "Kinion Technology Company Limited",
	[3]byte{100, 249, 112}: "Kenade Electronics Technology Co.,LTD.",
	[3]byte{100, 249, 135}: "Avvasi Inc.",
	[3]byte{100, 252, 140}: "Zonar Systems",
	[3]byte{104, 5, 113}:   "Samsung Electronics Co.,Ltd",
	[3]byte{104, 5, 202}:   "Intel Corporate",
	[3]byte{104, 9, 39}:    "Apple",
	[3]byte{104, 10, 215}:  "Yancheng Kecheng Optoelectronic Technology Co., Ltd",
	[3]byte{104, 18, 45}:   "Special Instrument Development Co., Ltd.",
	[3]byte{104, 21, 144}:  "SAGEMCOM SAS",
	[3]byte{104, 21, 211}:  "Zaklady Elektroniki i Mechaniki Precyzyjnej R&G S.A.",
	[3]byte{104, 22, 5}:    "Systems And Electronic Development FZCO",
	[3]byte{104, 23, 41}:   "Intel Corporate",
	[3]byte{104, 25, 63}:   "Digital Airways",
	[3]byte{104, 26, 178}:  "zte corporation",
	[3]byte{104, 28, 162}:  "Rosewill Inc.",
	[3]byte{104, 29, 100}:  "Sunwave Communications Co., Ltd",
	[3]byte{104, 30, 139}:  "InfoSight Corporation",
	[3]byte{104, 31, 216}:  "Advanced Telemetry",
	[3]byte{104, 35, 75}:   "Nihon Dengyo Kousaku",
	[3]byte{104, 40, 186}:  "Dejai",
	[3]byte{104, 45, 220}:  "Wuhan Changjiang Electro-Communication Equipment CO.,LTD",
	[3]byte{104, 54, 181}:  "DriveScale, Inc.",
	[3]byte{104, 59, 30}:   "Countwise LTD",
	[3]byte{104, 62, 236}:  "ERECA",
	[3]byte{104, 67, 82}:   "Bhuu Limited",
	[3]byte{104, 72, 152}:  "Samsung Electronics Co.,Ltd",
	[3]byte{104, 75, 136}:  "Galtronics Telemetry Inc.",
	[3]byte{104, 76, 168}:  "Shenzhen Herotel Tech. Co., Ltd.",
	[3]byte{104, 81, 183}:  "PowerCloud Systems, Inc.",
	[3]byte{104, 84, 237}:  "Alcatel-Lucent - Nuage",
	[3]byte{104, 84, 245}:  "enLighted Inc",
	[3]byte{104, 89, 127}:  "Alcatel Lucent",
	[3]byte{104, 91, 53}:   "Apple",
	[3]byte{104, 91, 54}:   "POWERTECH INDUSTRIAL CO., LTD.",
	[3]byte{104, 93, 67}:   "Intel Corporate",
	[3]byte{104, 94, 107}:  "PowerRay Co., Ltd.",
	[3]byte{104, 99, 89}:   "Advanced Digital Broadcast SA",
	[3]byte{104, 105, 46}:  "Zycoo Co.,Ltd",
	[3]byte{104, 105, 242}: "ComAp s.r.o.",
	[3]byte{104, 110, 35}:  "Wi3 Inc.",
	[3]byte{104, 110, 72}:  "Prophet Electronic Technology Corp.,Ltd",
	[3]byte{104, 114, 81}:  "Ubiquiti Networks",
	[3]byte{104, 114, 220}: "CETORY.TV Company Limited",
	[3]byte{104, 118, 79}:  "Sony Mobile Communications AB",
	[3]byte{104, 120, 72}:  "Westunitis Co., Ltd.",
	[3]byte{104, 120, 76}:  "Nortel Networks",
	[3]byte{104, 121, 36}:  "ELS-GmbH & Co. KG",
	[3]byte{104, 121, 237}: "SHARP Corporation",
	[3]byte{104, 124, 200}: "Measurement Systems S. de R.L.",
	[3]byte{104, 124, 213}: "Y Soft Corporation, a.s.",
	[3]byte{104, 127, 116}: "Cisco-Linksys, LLC",
	[3]byte{104, 131, 26}:  "Pandora Mobility Corporation",
	[3]byte{104, 132, 112}: "eSSys Co.,Ltd",
	[3]byte{104, 133, 64}:  "IGI Mobile, Inc.",
	[3]byte{104, 133, 106}: "OuterLink Corporation",
	[3]byte{104, 134, 167}: "Cisco",
	[3]byte{104, 134, 231}: "Orbotix, Inc.",
	[3]byte{104, 135, 107}: "INQ Mobile Limited",
	[3]byte{104, 138, 181}: "EDP Servicos",
	[3]byte{104, 146, 52}:  "Ruckus Wireless",
	[3]byte{104, 148, 35}:  "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{104, 150, 123}: "Apple",
	[3]byte{104, 151, 75}:  "Shenzhen Costar Electronics Co. Ltd.",
	[3]byte{104, 151, 232}: "Society of Motion Picture &amp; Television Engineers",
	[3]byte{104, 153, 205}: "Cisco",
	[3]byte{104, 156, 94}:  "AcSiP Technology Corp.",
	[3]byte{104, 156, 112}: "Apple",
	[3]byte{104, 160, 246}: "Huawei Technologies Co., Ltd",
	[3]byte{104, 161, 183}: "Honghao Mingchuan Technology (Beijing) CO.,Ltd.",
	[3]byte{104, 163, 196}: "Liteon Technology Corporation",
	[3]byte{104, 164, 14}:  "BSH Bosch and Siemens Home Appliances GmbH",
	[3]byte{104, 168, 109}: "Apple",
	[3]byte{104, 170, 210}: "DATECS LTD.,",
	[3]byte{104, 171, 138}: "RF IDeas",
	[3]byte{104, 174, 32}:  "Apple",
	[3]byte{104, 175, 19}:  "Futura Mobility",
	[3]byte{104, 176, 148}: "INESA ELECTRON CO.,LTD",
	[3]byte{104, 180, 58}:  "WaterFurnace International, Inc.",
	[3]byte{104, 181, 153}: "Hewlett-Packard Company",
	[3]byte{104, 182, 252}: "Hitron Technologies. Inc",
	[3]byte{104, 184, 217}: "Act KDE, Inc.",
	[3]byte{104, 188, 12}:  "CISCO SYSTEMS, INC.",
	[3]byte{104, 189, 171}: "CISCO SYSTEMS, INC.",
	[3]byte{104, 201, 11}:  "Texas Instruments",
	[3]byte{104, 202, 0}:   "Octopus Systems Limited",
	[3]byte{104, 204, 156}: "Mine Site Technologies",
	[3]byte{104, 205, 15}:  "U Tek Company Limited",
	[3]byte{104, 206, 78}:  "L-3 Communications Infrared Products",
	[3]byte{104, 209, 253}: "Shenzhen Trimax Technology Co.,Ltd",
	[3]byte{104, 210, 71}:  "Portalis LC",
	[3]byte{104, 217, 37}:  "ProSys Development Services",
	[3]byte{104, 217, 60}:  "Apple",
	[3]byte{104, 219, 103}: "Nantong Coship Electronics Co., Ltd",
	[3]byte{104, 219, 150}: "OPWILL Technologies CO .,LTD",
	[3]byte{104, 220, 232}: "PacketStorm Communications",
	[3]byte{104, 223, 221}: "Xiaomi inc.",
	[3]byte{104, 225, 102}: "PRIVATE",
	[3]byte{104, 228, 31}:  "Unglaube Identech GmbH",
	[3]byte{104, 235, 174}: "Samsung Electronics Co.,Ltd",
	[3]byte{104, 235, 197}: "Angstrem Telecom",
	[3]byte{104, 236, 98}:  "YODO Technology Corp. Ltd.",
	[3]byte{104, 237, 67}:  "Research In Motion",
	[3]byte{104, 238, 150}: "Cisco SPVTG",
	[3]byte{104, 239, 189}: "CISCO SYSTEMS, INC.",
	[3]byte{104, 240, 109}: "ALONG INDUSTRIAL CO., LIMITED",
	[3]byte{104, 241, 37}:  "Data Controls Inc.",
	[3]byte{104, 247, 40}:  "LCFC(HeFei) Electronics Technology co., ltd",
	[3]byte{104, 248, 149}: "Redflow Limited",
	[3]byte{104, 251, 149}: "Generalplus Technology Inc.",
	[3]byte{104, 252, 179}: "Next Level Security Systems, Inc.",
	[3]byte{108, 2, 115}:   "Shenzhen Jin Yun Video Equipment Co., Ltd.",
	[3]byte{108, 4, 96}:    "RBH Access Technologies Inc.",
	[3]byte{108, 9, 214}:   "Digiquest Electronics LTD",
	[3]byte{108, 11, 132}:  "Universal Global Scientific Industrial Co.,Ltd.",
	[3]byte{108, 14, 13}:   "Sony Ericsson Mobile Communications AB",
	[3]byte{108, 15, 106}:  "JDC Tech Co., Ltd.",
	[3]byte{108, 20, 247}:  "Erhardt+Leimer GmbH",
	[3]byte{108, 21, 249}:  "Nautronix Limited",
	[3]byte{108, 24, 17}:   "Decatur Electronics",
	[3]byte{108, 25, 143}:  "D-Link International",
	[3]byte{108, 32, 86}:   "Cisco",
	[3]byte{108, 34, 171}:  "Ainsworth Game Technology",
	[3]byte{108, 35, 185}:  "Sony Ericsson Mobile Communications AB",
	[3]byte{108, 37, 185}:  "BBK Electronics Corp., Ltd.,",
	[3]byte{108, 41, 149}:  "Intel Corporate",
	[3]byte{108, 44, 6}:    "OOO NPP Systemotechnika-NN",
	[3]byte{108, 46, 51}:   "Accelink Technologies Co.,Ltd.",
	[3]byte{108, 46, 133}:  "SAGEMCOM",
	[3]byte{108, 47, 44}:   "Samsung Electronics Co.,Ltd",
	[3]byte{108, 50, 222}:  "Indieon Technologies Pvt. Ltd.",
	[3]byte{108, 51, 169}:  "Magicjack LP",
	[3]byte{108, 57, 29}:   "Beijing ZhongHuaHun Network Information center",
	[3]byte{108, 58, 132}:  "Shenzhen Aero-Startech. Co.Ltd",
	[3]byte{108, 59, 229}:  "Hewlett Packard",
	[3]byte{108, 60, 83}:   "SoundHawk Corp",
	[3]byte{108, 62, 109}:  "Apple",
	[3]byte{108, 62, 156}:  "KE Knestel Elektronik GmbH",
	[3]byte{108, 64, 8}:    "Apple",
	[3]byte{108, 64, 198}:  "Nimbus Data Systems, Inc.",
	[3]byte{108, 65, 106}:  "Cisco",
	[3]byte{108, 75, 127}:  "Vossloh-Schwabe Deutschland GmbH",
	[3]byte{108, 80, 77}:   "CISCO SYSTEMS, INC.",
	[3]byte{108, 87, 121}:  "Aclima, Inc.",
	[3]byte{108, 90, 52}:   "Shenzhen Haitianxiong Electronic Co., Ltd.",
	[3]byte{108, 90, 181}:  "TCL Technoly Electronics (Huizhou) Co., Ltd.",
	[3]byte{108, 92, 222}:  "SunReports, Inc.",
	[3]byte{108, 93, 99}:   "ShenZhen Rapoo Technology Co., Ltd.",
	[3]byte{108, 94, 122}:  "Ubiquitous Internet Telecom Co., Ltd",
	[3]byte{108, 95, 28}:   "Lenovo Mobile Communication Technology Ltd.",
	[3]byte{108, 97, 38}:   "Rinicom Holdings",
	[3]byte{108, 98, 109}:  "Micro-Star INT'L CO., LTD",
	[3]byte{108, 100, 26}:  "Penguin Computing",
	[3]byte{108, 110, 254}: "Core Logic Inc.",
	[3]byte{108, 111, 24}:  "Stereotaxis, Inc.",
	[3]byte{108, 112, 57}:  "Novar GmbH",
	[3]byte{108, 112, 159}: "Apple",
	[3]byte{108, 113, 217}: "AzureWave Technologies, Inc",
	[3]byte{108, 118, 96}:  "KYOCERA Corporation",
	[3]byte{108, 129, 254}: "Mitsuba Corporation",
	[3]byte{108, 131, 54}:  "Samsung Electronics Co.,Ltd",
	[3]byte{108, 131, 102}: "Nanjing SAC Power Grid Automation Co., Ltd.",
	[3]byte{108, 134, 134}: "Technonia",
	[3]byte{108, 136, 20}:  "Intel Corporate",
	[3]byte{108, 139, 47}:  "zte corporation",
	[3]byte{108, 140, 219}: "Otus Technologies Ltd",
	[3]byte{108, 141, 101}: "Wireless Glue Networks, Inc.",
	[3]byte{108, 144, 177}: "SanLogic Inc",
	[3]byte{108, 146, 191}: "Inspur Electronic Information Industry Co.,Ltd.",
	[3]byte{108, 148, 248}: "Apple",
	[3]byte{108, 152, 235}: "Ocedo GmbH",
	[3]byte{108, 153, 137}: "Cisco",
	[3]byte{108, 154, 201}: "Valentine Research, Inc.",
	[3]byte{108, 155, 2}:   "Nokia Corporation",
	[3]byte{108, 156, 233}: "Nimble Storage",
	[3]byte{108, 156, 237}: "CISCO SYSTEMS, INC.",
	[3]byte{108, 166, 130}: "EDAM information & communications",
	[3]byte{108, 167, 128}: "Nokia Corporation",
	[3]byte{108, 169, 6}:   "Telefield Ltd",
	[3]byte{108, 169, 111}: "TransPacket AS",
	[3]byte{108, 170, 179}: "Ruckus Wireless",
	[3]byte{108, 171, 77}:  "Digital Payment Technologies",
	[3]byte{108, 172, 96}:  "Venetex Corp",
	[3]byte{108, 173, 63}:  "Hubbell Building Automation, Inc.",
	[3]byte{108, 173, 239}: "KZ Broadband Technologies, Ltd.",
	[3]byte{108, 173, 248}: "Azurewave Technologies, Inc.",
	[3]byte{108, 174, 139}: "IBM Corporation",
	[3]byte{108, 176, 206}: "NETGEAR",
	[3]byte{108, 179, 17}:  "Shenzhen Lianrui Electronics Co.,Ltd",
	[3]byte{108, 179, 80}:  "Anhui comhigher tech co.,ltd",
	[3]byte{108, 183, 244}: "Samsung Electronics Co.,Ltd",
	[3]byte{108, 190, 233}: "Alcatel-Lucent-IPD",
	[3]byte{108, 191, 181}: "Noon Technology Co., Ltd",
	[3]byte{108, 193, 210}: "ARRIS Group, Inc.",
	[3]byte{108, 194, 23}:  "Hewlett Packard",
	[3]byte{108, 194, 107}: "Apple",
	[3]byte{108, 208, 50}:  "LG Electronics",
	[3]byte{108, 209, 70}:  "Smartek d.o.o.",
	[3]byte{108, 209, 176}: "WING SING ELECTRONICS HONG KONG LIMITED",
	[3]byte{108, 214, 138}: "LG Electronics Inc",
	[3]byte{108, 220, 106}: "Promethean Limited",
	[3]byte{108, 224, 176}: "SOUND4",
	[3]byte{108, 228, 206}: "Villiger Security Solutions AG",
	[3]byte{108, 232, 115}: "TP-LINK TECHNOLOGIES CO., LTD.",
	[3]byte{108, 233, 7}:   "Nokia Corporation",
	[3]byte{108, 233, 131}: "Gastron Co., LTD.",
	[3]byte{108, 236, 161}: "SHENZHEN CLOU ELECTRONICS CO. LTD.",
	[3]byte{108, 236, 235}: "Texas Instruments",
	[3]byte{108, 240, 73}:  "GIGA-BYTE TECHNOLOGY CO.,LTD.",
	[3]byte{108, 243, 115}: "Samsung Electronics Co.,Ltd",
	[3]byte{108, 243, 127}: "Aruba Networks",
	[3]byte{108, 249, 124}: "Nanoptix Inc.",
	[3]byte{108, 250, 88}:  "Avaya, Inc",
	[3]byte{108, 250, 137}: "Cisco",
	[3]byte{108, 250, 167}: "AMPAK Technology Inc.",
	[3]byte{108, 253, 185}: "Proware Technologies Co Ltd.",
	[3]byte{108, 255, 190}: "MPB Communications Inc.",
	[3]byte{112, 2, 88}:    "01DB-METRAVIB",
	[3]byte{112, 5, 20}:    "LG Electronics",
	[3]byte{112, 11, 192}:  "Dewav Technology Company",
	[3]byte{112, 15, 199}:  "SHENZHEN IKINLOOP TECHNOLOGY CO.,LTD.",
	[3]byte{112, 15, 236}:  "Poindus Systems Corp.",
	[3]byte{112, 16, 92}:   "Cisco",
	[3]byte{112, 17, 36}:   "Apple",
	[3]byte{112, 20, 4}:    "Limited Liability Company",
	[3]byte{112, 24, 139}:  "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{112, 26, 4}:    "Liteon Tech Corp.",
	[3]byte{112, 26, 237}:  "ADVAS CO., LTD.",
	[3]byte{112, 29, 127}:  "Comtech Technology Co., Ltd.",
	[3]byte{112, 35, 147}:  "fos4X GmbH",
	[3]byte{112, 37, 38}:   "Alcatel-Lucent",
	[3]byte{112, 37, 89}:   "CyberTAN Technology, Inc.",
	[3]byte{112, 43, 29}:   "E-Domus International Limited",
	[3]byte{112, 44, 31}:   "Wisol",
	[3]byte{112, 45, 209}:  "Newings Communication CO., LTD.",
	[3]byte{112, 47, 75}:   "PolyVision Inc.",
	[3]byte{112, 47, 151}:  "Aava Mobile Oy",
	[3]byte{112, 48, 24}:   "Avaya, Inc",
	[3]byte{112, 48, 93}:   "Ubiquoss Inc",
	[3]byte{112, 48, 94}:   "Nanjing Zhongke Menglian Information Technology Co.,LTD",
	[3]byte{112, 49, 135}:  "ACX GmbH",
	[3]byte{112, 50, 213}:  "Athena Wireless Communications Inc",
	[3]byte{112, 56, 17}:   "Invensys Rail",
	[3]byte{112, 56, 180}:  "Low Tech Solutions",
	[3]byte{112, 56, 238}:  "Avaya, Inc",
	[3]byte{112, 58, 216}:  "Shenzhen Afoundry Electronic Co., Ltd",
	[3]byte{112, 60, 57}:   "SEAWING Kft",
	[3]byte{112, 62, 172}:  "Apple",
	[3]byte{112, 65, 183}:  "Edwards Lifesciences LLC",
	[3]byte{112, 70, 66}:   "CHYNG HONG ELECTRONIC CO., LTD.",
	[3]byte{112, 74, 174}:  "Xstream Flow (Pty) Ltd",
	[3]byte{112, 74, 228}:  "Rinstrum Pty Ltd",
	[3]byte{112, 76, 237}:  "TMRG, Inc.",
	[3]byte{112, 78, 1}:    "KWANGWON TECH CO., LTD.",
	[3]byte{112, 82, 197}:  "Avaya, Inc.",
	[3]byte{112, 83, 63}:   "Alfa Instrumentos Eletronicos Ltda.",
	[3]byte{112, 84, 210}:  "PEGATRON CORPORATION",
	[3]byte{112, 84, 245}:  "HUAWEI TECHNOLOGIES CO.,LTD",
	[3]byte{112, 86, 129}:  "Apple",
	[3]byte{112, 88, 18}:   "Panasonic AVC Networks Company",
	[3]byte{112, 89, 87}:   "Medallion Instrumentation Systems",
	[3]byte{112, 89, 134}:  "OOO TTV",
	[3]byte{112, 90, 182}:  "COMPAL INFORMATION (KUNSHAN) CO., LTD.",
	[3]byte{112, 91, 46}:   "M2Communication Inc.",
	[3]byte{112, 92, 173}:  "Konami Gaming Inc",
	[3]byte{112, 94, 170}:  "Action Target, Inc.",
	[3]byte{112, 96, 222}:  "LaVision GmbH",
	[3]byte{112, 97, 115}:  "Calantec GmbH",
	[3]byte{112, 98, 184}:  "D-Link International",
	[3]byte{112, 100, 23}:  "ORBIS TECNOLOGIA ELECTRICA S.A.",
	[3]byte{112, 101, 130}: "Suzhou Hanming Technologies Co., Ltd.",
	[3]byte{112, 111, 129}: "PRIVATE",
	[3]byte{112, 112, 76}:  "Purple Communications, Inc",
	[3]byte{112, 113, 179}: "Brain Corporation",
	[3]byte{112, 113, 188}: "PEGATRON CORPORATION",
	[3]byte{112, 114, 13}:  "Lenovo Mobile Communication Technology Ltd.",
	[3]byte{112, 114, 60}:  "Huawei Technologies Co., Ltd",
	[3]byte{112, 114, 207}: "EdgeCore Networks",
	[3]byte{112, 115, 203}: "Apple",
	[3]byte{112, 118, 48}:  "Pace plc.",
	[3]byte{112, 118, 221}: "Oxyguard International A/S",
	[3]byte{112, 118, 240}: "LevelOne Communications (India) Private Limited",
	[3]byte{112, 118, 255}: "KERLINK",
	[3]byte{112, 123, 232}: "HUAWEI TECHNOLOGIES CO.,LTD",
	[3]byte{112, 124, 24}:  "ADATA Technology Co., Ltd",
	[3]byte{112, 126, 67}:  "ARRIS Group, Inc.",
	[3]byte{112, 126, 222}: "NASTEC LTD.",
	[3]byte{112, 129, 5}:   "CISCO SYSTEMS, INC.",
	[3]byte{112, 130, 14}:  "as electronics GmbH",
	[3]byte{112, 130, 142}: "OleumTech Corporation",
	[3]byte{112, 133, 198}: "Pace plc.",
	[3]byte{112, 139, 120}: "citygrow technology co., ltd",
	[3]byte{112, 141, 9}:   "Nokia Corporation",
	[3]byte{112, 147, 131}: "Intelligent Optical Network High Tech CO.,LTD.",
	[3]byte{112, 147, 248}: "Space Monkey, Inc.",
	[3]byte{112, 151, 86}:  "Happyelectronics Co.,Ltd",
	[3]byte{112, 154, 11}:  "Italian Institute of Technology",
	[3]byte{112, 155, 165}: "Shenzhen Y&D Electronics Co.,LTD.",
	[3]byte{112, 155, 252}: "Bryton Inc.",
	[3]byte{112, 158, 41}:  "Sony Computer Entertainment Inc.",
	[3]byte{112, 158, 134}: "X6D Limited",
	[3]byte{112, 161, 145}: "Trendsetter Medical, LLC",
	[3]byte{112, 164, 28}:  "Advanced Wireless Dynamics S.L.",
	[3]byte{112, 166, 106}: "Prox Dynamics AS",
	[3]byte{112, 168, 227}: "HUAWEI TECHNOLOGIES CO.,LTD",
	[3]byte{112, 170, 178}: "Research In Motion",
	[3]byte{112, 175, 37}:  "Nishiyama Industry Co.,LTD.",
	[3]byte{112, 176, 53}:  "Shenzhen Zowee Technology Co., Ltd",
	[3]byte{112, 176, 140}: "Shenou Communication Equipment Co.,Ltd",
	[3]byte{112, 177, 78}:  "Pace plc",
	[3]byte{112, 178, 101}: "Hiltron s.r.l.",
	[3]byte{112, 179, 213}: "IEEE REGISTRATION AUTHORITY  - Please see OUI36 public listing for more information.",
	[3]byte{112, 181, 153}: "Embedded Technologies s.r.o.",
	[3]byte{112, 185, 33}:  "FiberHome Telecommunication Technologies CO.,LTD",
	[3]byte{112, 186, 239}: "Hangzhou H3C Technologies Co., Limited",
	[3]byte{112, 198, 172}: "Bosch Automotive Aftermarket",
	[3]byte{112, 202, 155}: "CISCO SYSTEMS, INC.",
	[3]byte{112, 205, 96}:  "Apple",
	[3]byte{112, 212, 242}: "RIM",
	[3]byte{112, 213, 126}: "Scalar Corporation",
	[3]byte{112, 213, 231}: "Wellcore Corporation",
	[3]byte{112, 214, 182}: "Metrum Technologies",
	[3]byte{112, 216, 128}: "Upos System sp. z o.o.",
	[3]byte{112, 221, 161}: "Tellabs",
	[3]byte{112, 222, 226}: "Apple",
	[3]byte{112, 224, 39}:  "HONGYU COMMUNICATION TECHNOLOGY LIMITED",
	[3]byte{112, 225, 57}:  "3view Ltd",
	[3]byte{112, 226, 76}:  "SAE IT-systems GmbH & Co. KG",
	[3]byte{112, 226, 132}: "Wistron InfoComm(Zhongshan) Corporation",
	[3]byte{112, 232, 67}:  "Beijing C&W Optical Communication Technology Co.,Ltd.",
	[3]byte{112, 238, 80}:  "Netatmo",
	[3]byte{112, 241, 118}: "Data Modul AG",
	[3]byte{112, 241, 150}: "Actiontec Electronics, Inc",
	[3]byte{112, 241, 161}: "Liteon Technology Corporation",
	[3]byte{112, 241, 229}: "Xetawave LLC",
	[3]byte{112, 243, 149}: "Universal Global Scientific Industrial Co., Ltd.",
	[3]byte{112, 249, 39}:  "Samsung Electronics",
	[3]byte{112, 249, 109}: "Hangzhou H3C Technologies Co., Limited",
	[3]byte{112, 252, 140}: "OneAccess SA",
	[3]byte{112, 255, 92}:  "Cheerzing Communication(Xiamen)Technology Co.,Ltd",
	[3]byte{112, 255, 118}: "Texas Instruments",
	[3]byte{116, 10, 188}:  "JSJS Designs (Europe) Limited",
	[3]byte{116, 14, 219}:  "Optowiz Co., Ltd",
	[3]byte{116, 20, 137}:  "SRT Wireless",
	[3]byte{116, 21, 226}:  "Tri-Sen Systems Corporation",
	[3]byte{116, 25, 248}:  "IEEE REGISTRATION AUTHORITY  - Please see MAM public listing for more information.",
	[3]byte{116, 30, 147}:  "Fiberhome Telecommunication Tech.Co.,Ltd.",
	[3]byte{116, 37, 138}:  "Hangzhou H3C Technologies Co., Limited",
	[3]byte{116, 38, 172}:  "Cisco",
	[3]byte{116, 39, 60}:   "ChangYang Technology (Nanjing) Co., LTD",
	[3]byte{116, 39, 234}:  "Elitegroup Computer Systems Co., Ltd.",
	[3]byte{116, 41, 175}:  "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{116, 43, 15}:   "Infinidat Ltd.",
	[3]byte{116, 43, 98}:   "Fujitsu Limited",
	[3]byte{116, 45, 10}:   "Norfolk Elektronik AG",
	[3]byte{116, 47, 104}:  "Azurewave Technologies, Inc.",
	[3]byte{116, 49, 112}:  "Arcadyan Technology Corporation",
	[3]byte{116, 50, 86}:   "NT-ware Systemprg GmbH",
	[3]byte{116, 55, 47}:   "Tongfang Shenzhen Cloudcomputing Technology Co.,Ltd",
	[3]byte{116, 56, 137}:  "ANNAX Anzeigesysteme GmbH",
	[3]byte{116, 62, 203}:  "Gentrice tech",
	[3]byte{116, 68, 1}:    "NETGEAR",
	[3]byte{116, 69, 138}:  "Samsung Electronics Co.,Ltd",
	[3]byte{116, 70, 160}:  "Hewlett Packard",
	[3]byte{116, 75, 233}:  "EXPLORER HYPERTECH CO.,LTD",
	[3]byte{116, 77, 121}:  "Arrive Systems Inc.",
	[3]byte{116, 83, 39}:   "COMMSEN CO., LIMITED",
	[3]byte{116, 84, 125}:  "Cisco SPVTG",
	[3]byte{116, 86, 18}:   "ARRIS Group, Inc.",
	[3]byte{116, 87, 152}:  "TRUMPF Laser GmbH + Co. KG",
	[3]byte{116, 92, 159}:  "TCT mobile ltd.",
	[3]byte{116, 94, 28}:   "PIONEER CORPORATION",
	[3]byte{116, 95, 0}:    "Samsung Semiconductor Inc.",
	[3]byte{116, 95, 174}:  "TSL PPL",
	[3]byte{116, 99, 223}:  "VTS GmbH",
	[3]byte{116, 101, 209}: "Atlinks",
	[3]byte{116, 102, 48}:  "T:mi Ytti",
	[3]byte{116, 106, 137}: "Rezolt Corporation",
	[3]byte{116, 106, 143}: "VS Vision Systems GmbH",
	[3]byte{116, 107, 130}: "MOVEK",
	[3]byte{116, 111, 61}:  "Contec GmbH",
	[3]byte{116, 114, 242}: "Chipsip Technology Co., Ltd.",
	[3]byte{116, 117, 72}:  "Amazon Technologies Inc.",
	[3]byte{116, 120, 24}:  "ServiceAssure",
	[3]byte{116, 123, 122}: "ETH Inc.",
	[3]byte{116, 125, 182}: "Aliwei Communications, Inc",
	[3]byte{116, 126, 26}:  "Red Embedded Design Limited",
	[3]byte{116, 126, 45}:  "Beijing Thomson CITIC Digital Technology Co. LTD.",
	[3]byte{116, 134, 122}: "Dell Inc",
	[3]byte{116, 136, 42}:  "HUAWEI TECHNOLOGIES CO.,LTD",
	[3]byte{116, 136, 139}: "ADB Broadband Italia",
	[3]byte{116, 142, 8}:   "Bestek Corp.",
	[3]byte{116, 142, 248}: "Brocade Communications Systems, Inc.",
	[3]byte{116, 143, 27}:  "MasterImage 3D",
	[3]byte{116, 143, 77}:  "MEN Mikro Elektronik GmbH",
	[3]byte{116, 144, 80}:  "Renesas Electronics Corporation",
	[3]byte{116, 145, 26}:  "Ruckus Wireless",
	[3]byte{116, 147, 164}: "Zebra Technologies Corp.",
	[3]byte{116, 148, 61}:  "AgJunction",
	[3]byte{116, 153, 117}: "IBM Corporation",
	[3]byte{116, 156, 82}:  "Huizhou Desay SV Automotive Co., Ltd.",
	[3]byte{116, 157, 220}: "2Wire",
	[3]byte{116, 164, 167}: "QRS Music Technologies, Inc.",
	[3]byte{116, 164, 181}: "Powerleader Science and Technology Co. Ltd.",
	[3]byte{116, 167, 34}:  "LG Electronics",
	[3]byte{116, 173, 183}: "China Mobile Group Device Co.,Ltd.",
	[3]byte{116, 174, 118}: "iNovo Broadband, Inc.",
	[3]byte{116, 176, 12}:  "Network Video Technologies, Inc",
	[3]byte{116, 185, 235}: "Fujian JinQianMao Electronic Technology Co.,Ltd",
	[3]byte{116, 186, 219}: "Longconn Electornics(shenzhen)Co.,Ltd",
	[3]byte{116, 190, 8}:   "ATEK Products, LLC",
	[3]byte{116, 191, 161}: "HYUNTECK",
	[3]byte{116, 198, 33}:  "Zhejiang Hite Renewable Energy Co.,LTD",
	[3]byte{116, 201, 154}: "Ericsson AB",
	[3]byte{116, 202, 37}:  "Calxeda, Inc.",
	[3]byte{116, 205, 12}:  "Smith Myers Communications Ltd.",
	[3]byte{116, 206, 86}:  "Packet Force Technology Limited Company",
	[3]byte{116, 208, 43}:  "ASUSTek COMPUTER INC.",
	[3]byte{116, 208, 220}: "ERICSSON AB",
	[3]byte{116, 212, 53}:  "GIGA-BYTE TECHNOLOGY CO.,LTD.",
	[3]byte{116, 214, 117}: "WYMA Tecnologia",
	[3]byte{116, 216, 80}:  "Evrisko Systems",
	[3]byte{116, 218, 56}:  "Edimax Technology Co. Ltd.",
	[3]byte{116, 219, 209}: "Ebay Inc",
	[3]byte{116, 222, 43}:  "Liteon Technology Corporation",
	[3]byte{116, 224, 110}: "Ergophone GmbH",
	[3]byte{116, 225, 74}:  "IEEE REGISTRATION AUTHORITY  - Please see MAM public listing for more information.",
	[3]byte{116, 225, 182}: "Apple",
	[3]byte{116, 226, 245}: "Apple",
	[3]byte{116, 228, 36}:  "APISTE CORPORATION",
	[3]byte{116, 229, 11}:  "Intel Corporate",
	[3]byte{116, 229, 55}:  "RADSPIN",
	[3]byte{116, 229, 67}:  "Liteon Technology Corporation",
	[3]byte{116, 230, 226}: "Dell Inc.",
	[3]byte{116, 231, 198}: "ARRIS Group, Inc.",
	[3]byte{116, 234, 58}:  "TP-LINK Technologies Co.,Ltd.",
	[3]byte{116, 236, 241}: "Acumen",
	[3]byte{116, 240, 109}: "AzureWave Technologies, Inc.",
	[3]byte{116, 240, 125}: "BnCOM Co.,Ltd",
	[3]byte{116, 241, 2}:   "Beijing HCHCOM Technology Co., Ltd",
	[3]byte{116, 244, 19}:  "Maxwell Forest",
	[3]byte{116, 246, 18}:  "ARRIS Group, Inc.",
	[3]byte{116, 247, 38}:  "Neuron Robotics",
	[3]byte{116, 248, 93}:  "Berkeley Nucleonics Corp",
	[3]byte{116, 253, 160}: "Compupal (Group) Corporation",
	[3]byte{116, 254, 72}:  "ADVANTECH CO., LTD.",
	[3]byte{116, 255, 125}: "Wren Sound Systems, LLC",
	[3]byte{120, 2, 143}:   "Adaptive Spectrum and Signal Alignment (ASSIA), Inc.",
	[3]byte{120, 7, 56}:    "Z.U.K. Elzab S.A.",
	[3]byte{120, 17, 133}:  "NBS Payment Solutions Inc.",
	[3]byte{120, 18, 184}:  "ORANTEK LIMITED",
	[3]byte{120, 24, 129}:  "AzureWave Technologies, Inc.",
	[3]byte{120, 25, 46}:   "NASCENT Technology",
	[3]byte{120, 25, 247}:  "Juniper Networks",
	[3]byte{120, 28, 90}:   "SHARP Corporation",
	[3]byte{120, 29, 186}:  "HUAWEI TECHNOLOGIES CO.,LTD",
	[3]byte{120, 29, 253}:  "Jabil Inc",
	[3]byte{120, 31, 219}:  "Samsung Electronics Co.,Ltd",
	[3]byte{120, 34, 61}:   "Affirmed Networks",
	[3]byte{120, 36, 175}:  "ASUSTek COMPUTER INC.",
	[3]byte{120, 37, 68}:   "Omnima Limited",
	[3]byte{120, 37, 173}:  "SAMSUNG ELECTRONICS CO., LTD.",
	[3]byte{120, 43, 203}:  "Dell Inc",
	[3]byte{120, 46, 239}:  "Nokia Corporation",
	[3]byte{120, 48, 59}:   "Stephen Technologies Co.,Limited",
	[3]byte{120, 48, 225}:  "UltraClenz, LLC",
	[3]byte{120, 49, 43}:   "zte corporation",
	[3]byte{120, 49, 193}:  "Apple",
	[3]byte{120, 50, 79}:   "Millennium Group, Inc.",
	[3]byte{120, 58, 132}:  "Apple",
	[3]byte{120, 60, 227}:  "Kai-EE",
	[3]byte{120, 61, 91}:   "TELNET Redes Inteligentes S.A.",
	[3]byte{120, 62, 83}:   "BSkyB Ltd",
	[3]byte{120, 63, 21}:   "EasySYNC Ltd.",
	[3]byte{120, 68, 5}:    "FUJITU(HONG KONG) ELECTRONIC Co.,LTD.",
	[3]byte{120, 68, 118}:  "Zioncom technology co.,ltd",
	[3]byte{120, 69, 97}:   "CyberTAN Technology Inc.",
	[3]byte{120, 69, 196}:  "Dell Inc",
	[3]byte{120, 70, 196}:  "DAEHAP HYPER-TECH",
	[3]byte{120, 71, 29}:   "Samsung Electronics Co.,Ltd",
	[3]byte{120, 72, 89}:   "Hewlett Packard",
	[3]byte{120, 73, 29}:   "The Will-Burt Company",
	[3]byte{120, 75, 8}:    "f.robotics acquisitions ltd",
	[3]byte{120, 75, 135}:  "Murata Manufacturing Co.,Ltd.",
	[3]byte{120, 81, 12}:   "LiveU Ltd.",
	[3]byte{120, 82, 26}:   "Samsung Electronics Co.,Ltd",
	[3]byte{120, 82, 98}:   "Shenzhen Hojy Software Co., Ltd.",
	[3]byte{120, 84, 46}:   "D-Link International",
	[3]byte{120, 85, 23}:   "SankyuElectronics",
	[3]byte{120, 87, 18}:   "Mobile Integration Workgroup",
	[3]byte{120, 89, 62}:   "RAFI GmbH & Co.KG",
	[3]byte{120, 89, 94}:   "Samsung Electronics Co.,Ltd",
	[3]byte{120, 89, 104}:  "Hon Hai Precision Ind.Co.,Ltd.",
	[3]byte{120, 92, 114}:  "Hioso Technology Co., Ltd.",
	[3]byte{120, 97, 124}:  "MITSUMI ELECTRIC CO.,LTD",
	[3]byte{120, 102, 174}: "ZTEC Instruments, Inc.",
	[3]byte{120, 106, 137}: "Huawei Technologies Co., Ltd",
	[3]byte{120, 108, 28}:  "Apple",
	[3]byte{120, 127, 98}:  "GiK mbH",
	[3]byte{120, 129, 143}: "Server Racks Australia Pty Ltd",
	[3]byte{120, 132, 60}:  "Sony Corporation",
	[3]byte{120, 132, 238}: "INDRA ESPACIO S.A.",
	[3]byte{120, 137, 115}: "CMC",
	[3]byte{120, 140, 84}:  "Eltek Technologies LTD",
	[3]byte{120, 141, 247}: "Hitron Technologies. Inc",
	[3]byte{120, 146, 62}:  "Nokia Corporation",
	[3]byte{120, 146, 156}: "Intel Corporate",
	[3]byte{120, 150, 132}: "ARRIS Group, Inc.",
	[3]byte{120, 152, 253}: "Q9 Networks Inc.",
	[3]byte{120, 153, 92}:  "Nationz Technologies Inc",
	[3]byte{120, 153, 102}: "Musilab Electronics (DongGuan)Co.,Ltd.",
	[3]byte{120, 153, 143}: "MEDILINE ITALIA SRL",
	[3]byte{120, 156, 231}: "Shenzhen Aikede Technology Co., Ltd",
	[3]byte{120, 158, 208}: "Samsung Electronics",
	[3]byte{120, 159, 76}:  "HOERBIGER Elektronik GmbH",
	[3]byte{120, 159, 135}: "Siemens AG I IA PP PRM",
	[3]byte{120, 160, 81}:  "iiNet Labs Pty Ltd",
	[3]byte{120, 161, 6}:   "TP-LINK TECHNOLOGIES CO.,LTD.",
	[3]byte{120, 161, 131}: "Advidia",
	[3]byte{120, 162, 160}: "Nintendo Co., Ltd.",
	[3]byte{120, 163, 228}: "Apple",
	[3]byte{120, 165, 4}:   "Texas Instruments",
	[3]byte{120, 165, 221}: "Shenzhen Smarteye Digital Electronics Co., Ltd",
	[3]byte{120, 166, 131}: "Precidata",
	[3]byte{120, 166, 189}: "DAEYEON Control&Instrument Co,.Ltd",
	[3]byte{120, 167, 20}:  "Amphenol",
	[3]byte{120, 168, 115}: "Samsung Electronics Co.,Ltd",
	[3]byte{120, 171, 96}:  "ABB Australia",
	[3]byte{120, 171, 187}: "Samsung Electronics Co.,LTD",
	[3]byte{120, 172, 192}: "Hewlett-Packard Company",
	[3]byte{120, 174, 12}:  "Far South Networks",
	[3]byte{120, 179, 185}: "ShangHai sunup lighting CO.,LTD",
	[3]byte{120, 179, 206}: "Elo touch solutions",
	[3]byte{120, 181, 210}: "Ever Treasure Industrial Limited",
	[3]byte{120, 182, 193}: "AOBO Telecom Co.,Ltd",
	[3]byte{120, 184, 26}:  "INTER SALES A/S",
	[3]byte{120, 186, 208}: "Shinybow Technology Co. Ltd.",
	[3]byte{120, 190, 182}: "Enhanced Vision",
	[3]byte{120, 190, 189}: "STULZ GmbH",
	[3]byte{120, 196, 14}:  "H&D Wireless",
	[3]byte{120, 196, 171}: "Shenzhen Runsil Technology Co.,Ltd",
	[3]byte{120, 197, 229}: "Texas Instruments",
	[3]byte{120, 198, 187}: "Innovasic, Inc.",
	[3]byte{120, 202, 4}:   "Nokia Corporation",
	[3]byte{120, 202, 57}:  "Apple",
	[3]byte{120, 202, 94}:  "ELNO",
	[3]byte{120, 203, 51}:  "DHC Software Co.,Ltd",
	[3]byte{120, 205, 142}: "SMC Networks Inc",
	[3]byte{120, 208, 4}:   "Neousys Technology Inc.",
	[3]byte{120, 209, 41}:  "Vicos",
	[3]byte{120, 211, 79}:  "Pace-O-Matic, Inc.",
	[3]byte{120, 211, 141}: "HONGKONG YUNLINK TECHNOLOGY LIMITED",
	[3]byte{120, 213, 181}: "NAVIELEKTRO KY",
	[3]byte{120, 214, 111}: "Aristocrat Technologies Australia Pty. Ltd.",
	[3]byte{120, 214, 240}: "Samsung Electro Mechanics",
	[3]byte{120, 215, 82}:  "HUAWEI TECHNOLOGIES CO.,LTD",
	[3]byte{120, 217, 159}: "NuCom HK Ltd.",
	[3]byte{120, 218, 110}: "Cisco",
	[3]byte{120, 218, 179}: "GBO Technology",
	[3]byte{120, 221, 8}:   "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{120, 221, 214}: "c-scape",
	[3]byte{120, 222, 228}: "Texas Instruments",
	[3]byte{120, 227, 181}: "Hewlett-Packard Company",
	[3]byte{120, 228, 0}:   "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{120, 231, 209}: "Hewlett-Packard Company",
	[3]byte{120, 232, 182}: "zte corporation",
	[3]byte{120, 235, 20}:  "SHENZHEN FAST TECHNOLOGIES CO.,LTD",
	[3]byte{120, 236, 34}:  "Shanghai Qihui Telecom Technology Co., LTD",
	[3]byte{120, 236, 116}: "Kyland-USA",
	[3]byte{120, 239, 76}:  "Unetconvergence Co., Ltd.",
	[3]byte{120, 245, 229}: "BEGA Gantenbrink-Leuchten KG",
	[3]byte{120, 245, 253}: "Huawei Technologies Co., Ltd",
	[3]byte{120, 247, 190}: "Samsung Electronics Co.,Ltd",
	[3]byte{120, 247, 208}: "Silverbrook Research",
	[3]byte{120, 253, 148}: "Apple",
	[3]byte{120, 254, 61}:  "Juniper Networks",
	[3]byte{120, 254, 65}:  "Socus networks",
	[3]byte{120, 254, 226}: "Shanghai Diveo Technology Co., Ltd",
	[3]byte{120, 255, 87}:  "Intel Corporate",
	[3]byte{124, 1, 135}:   "Curtis Instruments, Inc.",
	[3]byte{124, 2, 188}:   "Hansung Electronics Co. LTD",
	[3]byte{124, 3, 76}:    "SAGEMCOM",
	[3]byte{124, 3, 216}:   "SAGEMCOM SAS",
	[3]byte{124, 5, 7}:     "PEGATRON CORPORATION",
	[3]byte{124, 5, 30}:    "RAFAEL LTD.",
	[3]byte{124, 6, 35}:    "Ultra Electronics, CIS",
	[3]byte{124, 8, 217}:   "Shanghai B-Star Technology Co",
	[3]byte{124, 9, 43}:    "Bekey A/S",
	[3]byte{124, 10, 80}:   "J-MEX Inc.",
	[3]byte{124, 14, 206}:  "Cisco",
	[3]byte{124, 17, 190}:  "Apple",
	[3]byte{124, 20, 118}:  "Damall Technologies SAS",
	[3]byte{124, 22, 13}:   "Saia-Burgess Controls AG",
	[3]byte{124, 26, 3}:    "8Locations Co., Ltd.",
	[3]byte{124, 26, 252}:  "Dalian Co-Edifice Video Technology Co., Ltd",
	[3]byte{124, 30, 82}:   "Microsoft",
	[3]byte{124, 30, 179}:  "2N TELEKOMUNIKACE a.s.",
	[3]byte{124, 32, 72}:   "KoamTac",
	[3]byte{124, 32, 100}:  "Alcatel Lucent IPD",
	[3]byte{124, 37, 135}:  "chaowifi.com",
	[3]byte{124, 44, 243}:  "Secure Electrans Ltd",
	[3]byte{124, 46, 13}:   "Blackmagic Design",
	[3]byte{124, 47, 128}:  "Gigaset Communications GmbH",
	[3]byte{124, 51, 110}:  "MEG Electronics Inc.",
	[3]byte{124, 56, 108}:  "Real Time Logic",
	[3]byte{124, 57, 32}:   "SSOMA SECURITY",
	[3]byte{124, 59, 213}:  "Imago Group",
	[3]byte{124, 62, 157}:  "PATECH",
	[3]byte{124, 67, 143}:  "E-Band Communications Corp.",
	[3]byte{124, 68, 76}:   "Entertainment Solutions, S.L.",
	[3]byte{124, 73, 185}:  "Plexus Manufacturing Sdn Bhd",
	[3]byte{124, 74, 130}:  "Portsmith LLC",
	[3]byte{124, 74, 168}:  "MindTree Wireless PVT Ltd",
	[3]byte{124, 75, 120}:  "Red Sun Synthesis Pte Ltd",
	[3]byte{124, 76, 88}:   "Scale Computing, Inc.",
	[3]byte{124, 76, 165}:  "BSkyB Ltd",
	[3]byte{124, 79, 181}:  "Arcadyan Technology Corporation",
	[3]byte{124, 85, 231}:  "YSI, Inc.",
	[3]byte{124, 96, 151}:  "HUAWEI TECHNOLOGIES CO.,LTD",
	[3]byte{124, 97, 147}:  "HTC Corporation",
	[3]byte{124, 102, 157}: "Texas Instruments",
	[3]byte{124, 105, 246}: "Cisco",
	[3]byte{124, 106, 179}: "IBC TECHNOLOGIES INC.",
	[3]byte{124, 106, 195}: "GatesAir, Inc",
	[3]byte{124, 106, 219}: "SafeTone Technology Co.,Ltd",
	[3]byte{124, 107, 51}:  "Tenyu Tech Co. Ltd.",
	[3]byte{124, 107, 82}:  "Tigaro Wireless",
	[3]byte{124, 108, 57}:  "PIXSYS SRL",
	[3]byte{124, 108, 143}: "AMS NEVE LTD",
	[3]byte{124, 109, 98}:  "Apple",
	[3]byte{124, 109, 248}: "Apple",
	[3]byte{124, 111, 6}:   "Caterpillar Trimble Control Technologies",
	[3]byte{124, 111, 248}: "ShenZhen ACTO Digital Video Technology Co.,Ltd.",
	[3]byte{124, 112, 188}: "IEEE REGISTRATION AUTHORITY  - Please see MAM public listing for more information.",
	[3]byte{124, 114, 228}: "Unikey Technologies",
	[3]byte{124, 118, 115}: "ENMAS GmbH",
	[3]byte{124, 122, 145}: "Intel Corporate",
	[3]byte{124, 123, 228}: "Z'SEDAI KENKYUSHO CORPORATION",
	[3]byte{124, 125, 65}:  "Jinmuyu Electronics Co., Ltd.",
	[3]byte{124, 130, 45}:  "Nortec",
	[3]byte{124, 131, 6}:   "Glen Dimplex Nordic as",
	[3]byte{124, 141, 145}: "Shanghai Hongzhuo Information Technology co.,LTD",
	[3]byte{124, 142, 228}: "Texas Instruments",
	[3]byte{124, 148, 178}: "Philips Healthcare PCCI",
	[3]byte{124, 149, 243}: "Cisco",
	[3]byte{124, 151, 99}:  "Openmatics s.r.o.",
	[3]byte{124, 154, 155}: "VSE valencia smart energy",
	[3]byte{124, 161, 93}:  "GN ReSound A/S",
	[3]byte{124, 162, 155}: "D.SignT GmbH & Co. KG",
	[3]byte{124, 166, 29}:  "MHL, LLC",
	[3]byte{124, 172, 178}: "Bosch Software Innovations GmbH",
	[3]byte{124, 173, 116}: "Cisco",
	[3]byte{124, 176, 62}:  "OSRAM GmbH",
	[3]byte{124, 177, 119}: "Satelco AG",
	[3]byte{124, 178, 27}:  "Cisco SPVTG",
	[3]byte{124, 178, 50}:  "TCL King High Frequency EI,Co.,LTD",
	[3]byte{124, 181, 66}:  "ACES Technology",
	[3]byte{124, 183, 51}:  "ASKEY COMPUTER CORP",
	[3]byte{124, 183, 123}: "Paradigm Electronics Inc",
	[3]byte{124, 187, 111}: "Cosco Electronics Co., Ltd.",
	[3]byte{124, 189, 6}:   "AE REFUsol",
	[3]byte{124, 191, 136}: "Mobilicom LTD",
	[3]byte{124, 191, 177}: "ARRIS Group, Inc.",
	[3]byte{124, 195, 161}: "Apple",
	[3]byte{124, 196, 239}: "Devialet",
	[3]byte{124, 197, 55}:  "Apple",
	[3]byte{124, 200, 171}: "Acro Associates, Inc.",
	[3]byte{124, 200, 208}: "TIANJIN YAAN TECHNOLOGY CO., LTD.",
	[3]byte{124, 200, 215}: "Damalisk",
	[3]byte{124, 203, 13}:  "Antaira Technologies, LLC",
	[3]byte{124, 204, 184}: "Intel Corporate",
	[3]byte{124, 205, 17}:  "MS-Magnet",
	[3]byte{124, 205, 60}:  "Guangzhou Juzing Technology Co., Ltd",
	[3]byte{124, 207, 207}: "Shanghai SEARI Intelligent System Co., Ltd",
	[3]byte{124, 209, 195}: "Apple",
	[3]byte{124, 211, 10}:  "INVENTEC Corporation",
	[3]byte{124, 215, 98}:  "Freestyle Technology Pty Ltd",
	[3]byte{124, 216, 68}:  "Enmotus Inc",
	[3]byte{124, 217, 254}: "New Cosmos Electric Co., Ltd.",
	[3]byte{124, 218, 132}: "Dongnian Networks Inc.",
	[3]byte{124, 221, 17}:  "Chongqing MAS SCI&TECH.Co.,Ltd",
	[3]byte{124, 221, 32}:  "IOXOS Technologies S.A.",
	[3]byte{124, 221, 144}: "Shenzhen Ogemray Technology Co., Ltd.",
	[3]byte{124, 224, 68}:  "NEON Inc",
	[3]byte{124, 225, 255}: "Computer Performance, Inc. DBA Digital Loggers, Inc.",
	[3]byte{124, 228, 170}: "PRIVATE",
	[3]byte{124, 229, 36}:  "Quirky, Inc.",
	[3]byte{124, 229, 107}: "ESEN Optoelectronics Technology Co.,Ltd.",
	[3]byte{124, 233, 211}: "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{124, 235, 234}: "ASCT",
	[3]byte{124, 237, 141}: "MICROSOFT",
	[3]byte{124, 239, 24}:  "Creative Product Design Pty. Ltd.",
	[3]byte{124, 239, 138}: "Inhon International Ltd.",
	[3]byte{124, 240, 95}:  "Apple",
	[3]byte{124, 240, 152}: "Bee Beans Technologies, Inc.",
	[3]byte{124, 240, 186}: "Linkwell Telesystems Pvt Ltd",
	[3]byte{124, 244, 41}:  "NUUO Inc.",
	[3]byte{124, 250, 223}: "Apple",
	[3]byte{124, 254, 40}:  "Salutron Inc.",
	[3]byte{124, 254, 78}:  "Shenzhen Safe vision Technology Co.,LTD",
	[3]byte{124, 255, 98}:  "Huizhou Super Electron Technology Co.,Ltd.",
	[3]byte{128, 0, 11}:    "Intel Corporate",
	[3]byte{128, 0, 16}:    "ATT BELL LABORATORIES",
	[3]byte{128, 0, 110}:   "Apple",
	[3]byte{128, 5, 223}:   "Montage Technology Group Limited",
	[3]byte{128, 7, 162}:   "Esson Technology Inc.",
	[3]byte{128, 9, 2}:     "Keysight Technologies, Inc.",
	[3]byte{128, 10, 6}:    "COMTEC co.,ltd",
	[3]byte{128, 14, 36}:   "ForgetBox",
	[3]byte{128, 20, 64}:   "Sunlit System Technology Corp",
	[3]byte{128, 20, 168}:  "Guangzhou V-SOLUTION Electronic Technology Co., Ltd.",
	[3]byte{128, 22, 183}:  "Brunel University",
	[3]byte{128, 23, 125}:  "Nortel Networks",
	[3]byte{128, 24, 167}:  "Samsung Eletronics Co., Ltd",
	[3]byte{128, 25, 52}:   "Intel Corporate",
	[3]byte{128, 25, 103}:  "Shanghai Reallytek Information Technology  Co.,Ltd",
	[3]byte{128, 29, 170}:  "Avaya Inc",
	[3]byte{128, 31, 2}:    "Edimax Technology Co. Ltd.",
	[3]byte{128, 32, 175}:  "Trade FIDES, a.s.",
	[3]byte{128, 34, 117}:  "Beijing Beny Wave Technology Co Ltd",
	[3]byte{128, 42, 250}:  "Germaneers GmbH",
	[3]byte{128, 45, 225}:  "Solarbridge Technologies",
	[3]byte{128, 46, 20}:   "azeti Networks AG",
	[3]byte{128, 47, 222}:  "Zurich Instruments AG",
	[3]byte{128, 52, 87}:   "OT Systems Limited",
	[3]byte{128, 55, 115}:  "Netgear Inc",
	[3]byte{128, 56, 253}:  "LeapFrog Enterprises, Inc.",
	[3]byte{128, 57, 229}:  "PATLITE CORPORATION",
	[3]byte{128, 59, 154}:  "ghe-ces electronic ag",
	[3]byte{128, 63, 93}:   "Winstars Technology Ltd",
	[3]byte{128, 63, 214}:  "bytes at work AG",
	[3]byte{128, 65, 78}:   "BBK Electronics Corp., Ltd.,",
	[3]byte{128, 66, 124}:  "Adolf Tedsen GmbH & Co. KG",
	[3]byte{128, 71, 49}:   "Packet Design, Inc.",
	[3]byte{128, 72, 165}:  "SICHUAN TIANYI COMHEART TELECOM CO.,LTD",
	[3]byte{128, 73, 113}:  "Apple",
	[3]byte{128, 75, 32}:   "Ventilation Control",
	[3]byte{128, 79, 88}:   "ThinkEco, Inc.",
	[3]byte{128, 80, 27}:   "Nokia Corporation",
	[3]byte{128, 86, 242}:  "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{128, 87, 25}:   "Samsung Electronics Co.,Ltd",
	[3]byte{128, 88, 197}:  "NovaTec Kommunikationstechnik GmbH",
	[3]byte{128, 89, 253}:  "Noviga",
	[3]byte{128, 96, 7}:    "RIM",
	[3]byte{128, 97, 143}:  "Shenzhen sangfei consumer communications co.,ltd",
	[3]byte{128, 100, 89}:  "Nimbus Inc.",
	[3]byte{128, 101, 233}: "BenQ Corporation",
	[3]byte{128, 102, 41}:  "Prescope Technologies CO.,LTD.",
	[3]byte{128, 108, 27}:  "Motorola Mobility LLC",
	[3]byte{128, 108, 139}: "KAESER KOMPRESSOREN AG",
	[3]byte{128, 108, 188}: "NET New Electronic Technology GmbH",
	[3]byte{128, 113, 31}:  "Juniper Networks",
	[3]byte{128, 113, 122}: "Huawei Technologies Co., Ltd",
	[3]byte{128, 118, 147}: "Newag SA",
	[3]byte{128, 121, 174}: "ShanDong Tecsunrise  Co.,Ltd",
	[3]byte{128, 122, 127}: "ABB Genway Xiamen Electrical Equipment CO., LTD",
	[3]byte{128, 123, 30}:  "Corsair Components",
	[3]byte{128, 125, 27}:  "Neosystem Co. Ltd.",
	[3]byte{128, 125, 227}: "Chongqing Sichuan Instrument Microcircuit Co.LTD.",
	[3]byte{128, 129, 165}: "TONGQING COMMUNICATION EQUIPMENT (SHENZHEN) Co.,Ltd",
	[3]byte{128, 130, 135}: "ATCOM Technology Co.Ltd.",
	[3]byte{128, 134, 152}: "Netronics Technologies Inc.",
	[3]byte{128, 134, 242}: "Intel Corporate",
	[3]byte{128, 139, 92}:  "Shenzhen Runhuicheng Technology Co., Ltd",
	[3]byte{128, 145, 42}:  "Lih Rong electronic Enterprise Co., Ltd.",
	[3]byte{128, 145, 192}: "AgileMesh, Inc.",
	[3]byte{128, 146, 159}: "Apple",
	[3]byte{128, 147, 147}: "Xapt GmbH",
	[3]byte{128, 148, 108}: "TOKYO RADAR CORPORATION",
	[3]byte{128, 150, 177}: "ARRIS Group, Inc.",
	[3]byte{128, 150, 202}: "Hon Hai Precision Ind Co.,Ltd",
	[3]byte{128, 151, 27}:  "Altenergy Power System,Inc.",
	[3]byte{128, 155, 32}:  "Intel Corporate",
	[3]byte{128, 161, 215}: "Shanghai DareGlobal Technologies Co.,Ltd",
	[3]byte{128, 170, 164}: "USAG",
	[3]byte{128, 173, 103}: "Kasda Digital Technology Co.,Ltd",
	[3]byte{128, 178, 25}:  "ELEKTRON TECHNOLOGY UK LIMITED",
	[3]byte{128, 178, 137}: "Forworld Electronics Ltd.",
	[3]byte{128, 179, 42}:  "Alstom Grid",
	[3]byte{128, 182, 134}: "Huawei Technologies Co., Ltd",
	[3]byte{128, 185, 92}:  "ELFTECH Co., Ltd.",
	[3]byte{128, 186, 172}: "TeleAdapt Ltd",
	[3]byte{128, 186, 230}: "Neets",
	[3]byte{128, 187, 235}: "Satmap Systems Ltd",
	[3]byte{128, 190, 5}:   "Apple",
	[3]byte{128, 193, 110}: "Hewlett Packard",
	[3]byte{128, 198, 63}:  "Remec Broadband Wireless , LLC",
	[3]byte{128, 198, 171}: "Technicolor USA Inc.",
	[3]byte{128, 198, 202}: "Endian s.r.l.",
	[3]byte{128, 200, 98}:  "Openpeak, Inc",
	[3]byte{128, 206, 177}: "Theissen Training Systems GmbH",
	[3]byte{128, 207, 65}:  "Lenovo Mobile Communication Technology Ltd.",
	[3]byte{128, 208, 25}:  "Embed, Inc",
	[3]byte{128, 209, 139}: "Hangzhou I'converge Technology Co.,Ltd",
	[3]byte{128, 210, 29}:  "AzureWave Technologies, Inc",
	[3]byte{128, 212, 51}:  "LzLabs GmbH",
	[3]byte{128, 215, 51}:  "QSR Automations, Inc.",
	[3]byte{128, 219, 49}:  "Power Quotient International Co., Ltd.",
	[3]byte{128, 230, 80}:  "Apple",
	[3]byte{128, 234, 150}: "Apple",
	[3]byte{128, 234, 202}: "Dialog Semiconductor Hellas SA",
	[3]byte{128, 238, 115}: "Shuttle Inc.",
	[3]byte{128, 242, 94}:  "Kyynel",
	[3]byte{128, 245, 147}: "IRCO Sistemas de Telecomunicación S.A.",
	[3]byte{128, 246, 46}:  "Hangzhou H3C Technologies Co., Limited",
	[3]byte{128, 248, 235}: "RayTight",
	[3]byte{128, 250, 91}:  "CLEVO CO.",
	[3]byte{128, 251, 6}:   "HUAWEI TECHNOLOGIES CO.,LTD",
	[3]byte{128, 255, 168}: "UNIDIS",
	[3]byte{132, 0, 210}:   "Sony Ericsson Mobile Communications AB",
	[3]byte{132, 1, 167}:   "Greyware Automation Products, Inc",
	[3]byte{132, 11, 45}:   "SAMSUNG ELECTRO-MECHANICS CO., LTD",
	[3]byte{132, 15, 69}:   "Shanghai GMT Digital Technologies Co., Ltd",
	[3]byte{132, 23, 21}:   "GP Electronics (HK) Ltd.",
	[3]byte{132, 23, 102}:  "Weifang GoerTek Electronics Co., Ltd",
	[3]byte{132, 24, 38}:   "Osram GmbH",
	[3]byte{132, 24, 58}:   "Ruckus Wireless",
	[3]byte{132, 24, 136}:  "Juniper Networks",
	[3]byte{132, 27, 56}:   "Shenzhen Excelsecu Data Technology Co.,Ltd",
	[3]byte{132, 27, 94}:   "NETGEAR",
	[3]byte{132, 30, 38}:   "KERNEL-I Co.,LTD",
	[3]byte{132, 33, 65}:   "Shenzhen Ginwave Technologies Ltd.",
	[3]byte{132, 36, 141}:  "Motorola Solutions Inc",
	[3]byte{132, 37, 63}:   "Silex Technology, Inc",
	[3]byte{132, 37, 164}:  "Tariox Limited",
	[3]byte{132, 37, 219}:  "Samsung Electronics Co.,Ltd",
	[3]byte{132, 38, 21}:   "ADB Broadband Italia",
	[3]byte{132, 38, 43}:   "Alcatel-Lucent",
	[3]byte{132, 38, 144}:  "BEIJING THOUGHT SCIENCE CO.,LTD.",
	[3]byte{132, 39, 206}:  "Corporation of the Presiding Bishop of The Church of Jesus Christ of Latter-day Saints",
	[3]byte{132, 41, 20}:   "EMPORIA TELECOM Produktions- und VertriebsgesmbH & Co KG",
	[3]byte{132, 41, 153}:  "Apple",
	[3]byte{132, 43, 43}:   "Dell Inc.",
	[3]byte{132, 43, 80}:   "Huria Co.,Ltd.",
	[3]byte{132, 43, 188}:  "Modelleisenbahn GmbH",
	[3]byte{132, 47, 117}:  "Innokas Group",
	[3]byte{132, 48, 229}:  "SkyHawke Technologies, LLC",
	[3]byte{132, 50, 234}:  "ANHUI WANZTEN P&T CO., LTD",
	[3]byte{132, 52, 151}:  "Hewlett Packard",
	[3]byte{132, 54, 17}:   "hyungseul publishing networks",
	[3]byte{132, 56, 53}:   "Apple",
	[3]byte{132, 56, 56}:   "Samsung Electro Mechanics co., LTD.",
	[3]byte{132, 58, 75}:   "Intel Corporate",
	[3]byte{132, 63, 78}:   "Tri-Tech Manufacturing, Inc.",
	[3]byte{132, 68, 100}:  "ServerU Inc",
	[3]byte{132, 72, 35}:   "WOXTER TECHNOLOGY Co. Ltd",
	[3]byte{132, 73, 21}:   "vArmour Networks, Inc.",
	[3]byte{132, 75, 245}:  "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{132, 79, 3}:    "Ablelink Electronics Ltd",
	[3]byte{132, 81, 129}:  "Samsung Electronics Co.,Ltd",
	[3]byte{132, 85, 165}:  "Samsung Elec Co.,Ltd",
	[3]byte{132, 86, 156}:  "Coho Data, Inc.,",
	[3]byte{132, 87, 135}:  "DVR C&C Co., Ltd.",
	[3]byte{132, 92, 147}:  "Chabrier Services",
	[3]byte{132, 93, 215}:  "Shenzhen Netcom Electronics Co.,Ltd",
	[3]byte{132, 98, 35}:   "Shenzhen Coship Electronics Co., Ltd.",
	[3]byte{132, 98, 166}:  "EuroCB (Phils), Inc.",
	[3]byte{132, 99, 214}:  "Microsoft Corporation",
	[3]byte{132, 106, 237}: "Wireless Tsukamoto.,co.LTD",
	[3]byte{132, 110, 177}: "Park Assist LLC",
	[3]byte{132, 114, 7}:   "I&C Technology",
	[3]byte{132, 116, 42}:  "zte corporation",
	[3]byte{132, 118, 22}:  "Addat S.r.o.",
	[3]byte{132, 120, 139}: "Apple",
	[3]byte{132, 120, 172}: "Cisco",
	[3]byte{132, 122, 136}: "HTC Corporation",
	[3]byte{132, 126, 64}:  "Texas Instruments",
	[3]byte{132, 130, 244}: "Beijing Huasun Unicreate Technology Co., Ltd",
	[3]byte{132, 131, 54}:  "Newrun",
	[3]byte{132, 131, 113}: "Avaya, Inc",
	[3]byte{132, 132, 51}:  "Paradox Engineering SA",
	[3]byte{132, 133, 6}:   "Apple",
	[3]byte{132, 133, 10}:  "Hella Sonnen- und Wetterschutztechnik GmbH",
	[3]byte{132, 134, 243}: "Greenvity Communications",
	[3]byte{132, 141, 132}: "Rajant Corporation",
	[3]byte{132, 141, 199}: "Cisco SPVTG",
	[3]byte{132, 142, 12}:  "Apple",
	[3]byte{132, 142, 150}: "Embertec Pty Ltd",
	[3]byte{132, 142, 223}: "Sony Mobile Communications AB",
	[3]byte{132, 143, 105}: "Dell Inc.",
	[3]byte{132, 144, 0}:   "Arnold & Richter Cine Technik",
	[3]byte{132, 147, 12}:  "InCoax Networks Europe AB",
	[3]byte{132, 148, 140}: "Hitron Technologies. Inc",
	[3]byte{132, 150, 129}: "Cathay Communication Co.,Ltd",
	[3]byte{132, 150, 216}: "Pace plc",
	[3]byte{132, 151, 184}: "Memjet Inc.",
	[3]byte{132, 156, 166}: "Arcadyan Technology Corporation",
	[3]byte{132, 157, 197}: "Centera Photonics Inc.",
	[3]byte{132, 164, 102}: "Samsung Electronics Co.,Ltd",
	[3]byte{132, 166, 200}: "Intel Corporate",
	[3]byte{132, 167, 131}: "Alcatel Lucent",
	[3]byte{132, 168, 228}: "Shenzhen Huawei Communication Technologies Co., Ltd",
	[3]byte{132, 169, 145}: "Cyber Trans Japan Co.,Ltd.",
	[3]byte{132, 172, 164}: "Beijing Novel Super Digital TV Technology Co., Ltd",
	[3]byte{132, 175, 31}:  "Beat System Service Co,. Ltd.",
	[3]byte{132, 177, 83}:  "Apple",
	[3]byte{132, 181, 156}: "Juniper networks",
	[3]byte{132, 194, 228}: "Jiangsu Qinheng Co., Ltd.",
	[3]byte{132, 199, 39}:  "Gnodal Ltd",
	[3]byte{132, 199, 169}: "C3PO S.A.",
	[3]byte{132, 200, 177}: "Incognito Software Inc.",
	[3]byte{132, 201, 178}: "D-Link International",
	[3]byte{132, 211, 42}:  "IEEE 1905.1",
	[3]byte{132, 217, 200}: "Unipattern Co.,",
	[3]byte{132, 219, 47}:  "Sierra Wireless Inc",
	[3]byte{132, 221, 32}:  "Texas Instruments",
	[3]byte{132, 221, 183}: "Cilag GmbH International",
	[3]byte{132, 222, 61}:  "Crystal Vision Ltd",
	[3]byte{132, 223, 12}:  "NET2GRID BV",
	[3]byte{132, 224, 88}:  "Pace plc",
	[3]byte{132, 228, 217}: "Shenzhen NEED technology Ltd.",
	[3]byte{132, 230, 41}:  "Bluwan SA",
	[3]byte{132, 231, 20}:  "Liang Herng Enterprise,Co.Ltd.",
	[3]byte{132, 234, 153}: "Vieworks",
	[3]byte{132, 235, 24}:  "Texas Instruments",
	[3]byte{132, 237, 51}:  "BBMC Co.,Ltd",
	[3]byte{132, 244, 147}: "OMS spol. s.r.o.",
	[3]byte{132, 246, 76}:  "Cross Point BV",
	[3]byte{132, 252, 254}: "Apple",
	[3]byte{132, 254, 158}: "RTC Industries, Inc.",
	[3]byte{136, 3, 85}:    "Arcadyan Technology Corp.",
	[3]byte{136, 9, 5}:     "MTMCommunications",
	[3]byte{136, 15, 16}:   "Huami Information Technology Co.,Ltd.",
	[3]byte{136, 15, 182}:  "Jabil Circuits India Pvt Ltd,-EHTP unit",
	[3]byte{136, 16, 54}:   "Panodic(ShenZhen) Electronics Limted",
	[3]byte{136, 18, 78}:   "Qualcomm Atheros",
	[3]byte{136, 20, 43}:   "Protonic Holland",
	[3]byte{136, 21, 68}:   "Meraki, Inc.",
	[3]byte{136, 24, 174}:  "Tamron Co., Ltd",
	[3]byte{136, 29, 252}:  "Cisco",
	[3]byte{136, 31, 161}:  "Apple",
	[3]byte{136, 32, 18}:   "LMI Technologies",
	[3]byte{136, 33, 227}:  "Nebusens, S.L.",
	[3]byte{136, 35, 100}:  "Watchnet DVR Inc",
	[3]byte{136, 35, 254}:  "TTTech Computertechnik AG",
	[3]byte{136, 37, 44}:   "Arcadyan Technology Corporation",
	[3]byte{136, 41, 80}:   "Dalian Netmoon Tech Develop Co.,Ltd",
	[3]byte{136, 46, 90}:   "storONE",
	[3]byte{136, 48, 138}:  "Murata Manufactuaring Co.,Ltd.",
	[3]byte{136, 50, 155}:  "Samsung Electro Mechanics co.,LTD.",
	[3]byte{136, 51, 20}:   "Texas Instruments",
	[3]byte{136, 53, 76}:   "Transics",
	[3]byte{136, 54, 18}:   "SRC Computers, LLC",
	[3]byte{136, 65, 193}:  "ORBISAT DA AMAZONIA IND E AEROL SA",
	[3]byte{136, 65, 252}:  "AirTies Wireless Netowrks",
	[3]byte{136, 67, 225}:  "CISCO SYSTEMS, INC.",
	[3]byte{136, 68, 246}:  "Nokia Corporation",
	[3]byte{136, 70, 42}:   "Telechips Inc.",
	[3]byte{136, 75, 57}:   "Siemens AG, Healthcare Sector",
	[3]byte{136, 81, 251}:  "Hewlett Packard",
	[3]byte{136, 83, 46}:   "Intel Corporate",
	[3]byte{136, 83, 149}:  "Apple",
	[3]byte{136, 83, 212}:  "Huawei Technologies Co., Ltd",
	[3]byte{136, 87, 109}:  "XTA Electronics Ltd",
	[3]byte{136, 90, 146}:  "Cisco",
	[3]byte{136, 91, 221}:  "Aerohive Networks Inc.",
	[3]byte{136, 92, 71}:   "Alcatel Lucent",
	[3]byte{136, 97, 90}:   "Siano Mobile Silicon Ltd.",
	[3]byte{136, 99, 223}:  "Apple",
	[3]byte{136, 104, 92}:  "Shenzhen ChuangDao & Perpetual Eternal Technology Co.,Ltd",
	[3]byte{136, 107, 118}: "CHINA HOPEFUL GROUP HOPEFUL ELECTRIC CO.,LTD",
	[3]byte{136, 112, 140}: "Lenovo Mobile Communication Technology Ltd.",
	[3]byte{136, 112, 239}: "SC Professional Trading Co., Ltd.",
	[3]byte{136, 115, 152}: "K2E Tekpoint",
	[3]byte{136, 117, 86}:  "Cisco",
	[3]byte{136, 120, 156}: "Game Technologies SA",
	[3]byte{136, 134, 3}:   "HUAWEI TECHNOLOGIES CO.,LTD",
	[3]byte{136, 134, 160}: "Simton Technologies, Ltd.",
	[3]byte{136, 135, 23}:  "CANON INC.",
	[3]byte{136, 135, 221}: "DarbeeVision Inc.",
	[3]byte{136, 137, 20}:  "All Components Incorporated",
	[3]byte{136, 137, 100}: "GSI Electronics Inc.",
	[3]byte{136, 139, 93}:  "Storage Appliance Corporation",
	[3]byte{136, 140, 25}:  "Brady Corp Asia Pacific Ltd",
	[3]byte{136, 145, 102}: "Viewcooper Corp.",
	[3]byte{136, 145, 221}: "Racktivity",
	[3]byte{136, 148, 113}: "Brocade Communications Systems, Inc.",
	[3]byte{136, 148, 249}: "Gemicom Technology, Inc.",
	[3]byte{136, 149, 185}: "Unified Packet Systems Crop",
	[3]byte{136, 150, 118}: "TTC MARCONI s.r.o.",
	[3]byte{136, 151, 223}: "Entrypass Corporation Sdn. Bhd.",
	[3]byte{136, 152, 33}:  "TERAON",
	[3]byte{136, 155, 57}:  "Samsung Electronics Co.,Ltd",
	[3]byte{136, 156, 166}: "BTB Korea INC",
	[3]byte{136, 159, 250}: "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{136, 163, 204}: "Amatis Controls",
	[3]byte{136, 165, 189}: "QPCOM INC.",
	[3]byte{136, 167, 60}:  "Ragentek Technology Group",
	[3]byte{136, 172, 193}: "Generiton Co., Ltd.",
	[3]byte{136, 174, 29}:  "COMPAL INFORMATION(KUNSHAN)CO.,LTD",
	[3]byte{136, 177, 104}: "Delta Control GmbH",
	[3]byte{136, 177, 225}: "AirTight Networks, Inc.",
	[3]byte{136, 182, 39}:  "Gembird Europe BV",
	[3]byte{136, 186, 127}: "Qfiednet Co., Ltd.",
	[3]byte{136, 191, 213}: "Simple Audio Ltd",
	[3]byte{136, 195, 110}: "Beijing Ereneben lnformation Technology Limited",
	[3]byte{136, 198, 38}:  "Logitech - Ultimate Ears",
	[3]byte{136, 198, 99}:  "Apple",
	[3]byte{136, 201, 208}: "LG Electronics",
	[3]byte{136, 203, 135}: "Apple",
	[3]byte{136, 215, 188}: "DEP Company",
	[3]byte{136, 217, 98}:  "Canopus Systems US LLC",
	[3]byte{136, 220, 150}: "SENAO Networks, Inc.",
	[3]byte{136, 221, 121}: "Voltaire",
	[3]byte{136, 224, 160}: "Shenzhen VisionSTOR Technologies Co., Ltd",
	[3]byte{136, 224, 243}: "Juniper Networks",
	[3]byte{136, 227, 171}: "Huawei Technologies Co., Ltd",
	[3]byte{136, 231, 18}:  "Whirlpool Corporation",
	[3]byte{136, 231, 166}: "iKnowledge Integration Corp.",
	[3]byte{136, 232, 248}: "YONG TAI ELECTRONIC (DONGGUAN) LTD.",
	[3]byte{136, 233, 23}:  "Tamaggo",
	[3]byte{136, 237, 28}:  "Cudo Communication Co., Ltd.",
	[3]byte{136, 240, 49}:  "Cisco",
	[3]byte{136, 240, 119}: "CISCO SYSTEMS, INC.",
	[3]byte{136, 244, 136}: "cellon communications technology(shenzhen)Co.,Ltd.",
	[3]byte{136, 244, 144}: "Jetmobile Pte Ltd",
	[3]byte{136, 247, 199}: "Technicolor USA Inc.",
	[3]byte{136, 253, 21}:  "LINEEYE CO., LTD",
	[3]byte{136, 254, 214}: "ShangHai WangYong Software Co., Ltd.",
	[3]byte{140, 0, 109}:   "Apple",
	[3]byte{140, 4, 255}:   "Technicolor USA Inc.",
	[3]byte{140, 5, 81}:    "Koubachi AG",
	[3]byte{140, 7, 140}:   "FLOW DATA INC",
	[3]byte{140, 8, 139}:   "Remote Solution",
	[3]byte{140, 9, 244}:   "ARRIS Group, Inc.",
	[3]byte{140, 12, 144}:  "Ruckus Wireless",
	[3]byte{140, 12, 163}:  "Amper",
	[3]byte{140, 14, 227}:  "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD.",
	[3]byte{140, 17, 203}:  "ABUS Security-Center GmbH & Co. KG",
	[3]byte{140, 24, 217}:  "Shenzhen RF Technology Co., Ltd",
	[3]byte{140, 31, 148}:  "RF Surgical System Inc.",
	[3]byte{140, 33, 10}:   "TP-LINK TECHNOLOGIES CO., LTD.",
	[3]byte{140, 39, 29}:   "QuantHouse",
	[3]byte{140, 39, 138}:  "Vocollect Inc",
	[3]byte{140, 41, 55}:   "Apple",
	[3]byte{140, 45, 170}:  "Apple",
	[3]byte{140, 47, 57}:   "IBA Dosimetry GmbH",
	[3]byte{140, 51, 48}:   "EmFirst Co., Ltd.",
	[3]byte{140, 51, 87}:   "HiteVision Digital Media Technology Co.,Ltd.",
	[3]byte{140, 58, 227}:  "LG Electronics",
	[3]byte{140, 60, 7}:    "Skiva Technologies, Inc.",
	[3]byte{140, 60, 74}:   "NAKAYO TELECOMMUNICATIONS,INC.",
	[3]byte{140, 65, 242}:  "RDA Technologies Ltd.",
	[3]byte{140, 68, 53}:   "Shanghai BroadMobi Communication Technology Co., Ltd.",
	[3]byte{140, 74, 238}:  "GIGA TMS INC",
	[3]byte{140, 75, 89}:   "3D Imaging & Simulations Corp",
	[3]byte{140, 76, 220}:  "PLANEX COMMUNICATIONS INC.",
	[3]byte{140, 77, 185}:  "Unmonday Ltd",
	[3]byte{140, 77, 234}:  "Cerio Corporation",
	[3]byte{140, 81, 5}:    "Shenzhen ireadygo Information Technology CO.,LTD.",
	[3]byte{140, 83, 247}:  "A&D ENGINEERING CO., LTD.",
	[3]byte{140, 84, 29}:   "LGE",
	[3]byte{140, 86, 157}:  "Imaging Solutions Group",
	[3]byte{140, 86, 197}:  "Nintendo Co., Ltd.",
	[3]byte{140, 87, 253}:  "LVX Western",
	[3]byte{140, 88, 119}:  "Apple",
	[3]byte{140, 89, 139}:  "C Technologies AB",
	[3]byte{140, 90, 240}:  "Exeltech Solar Products",
	[3]byte{140, 92, 161}:  "d-broad,INC",
	[3]byte{140, 93, 96}:   "UCI Corporation Co.,Ltd.",
	[3]byte{140, 95, 223}:  "Beijing Railway Signal Factory",
	[3]byte{140, 96, 79}:   "CISCO SYSTEMS, INC.",
	[3]byte{140, 100, 11}:  "Beyond Devices d.o.o.",
	[3]byte{140, 100, 34}:  "Sony Ericsson Mobile Communications AB",
	[3]byte{140, 104, 120}: "Nortek-AS",
	[3]byte{140, 106, 228}: "Viogem Limited",
	[3]byte{140, 112, 90}:  "Intel Corporate",
	[3]byte{140, 113, 248}: "Samsung Electronics Co.,Ltd",
	[3]byte{140, 115, 110}: "Fujitsu Limited",
	[3]byte{140, 118, 193}: "Goden Tech Limited",
	[3]byte{140, 119, 18}:  "Samsung Electronics Co.,Ltd",
	[3]byte{140, 119, 22}:  "LONGCHEER TELECOMMUNICATION LIMITED",
	[3]byte{140, 123, 157}: "Apple",
	[3]byte{140, 124, 146}: "Apple",
	[3]byte{140, 124, 181}: "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{140, 124, 255}: "Brocade Communications Systems, Inc.",
	[3]byte{140, 126, 179}: "Lytro, Inc.",
	[3]byte{140, 127, 59}:  "ARRIS Group, Inc.",
	[3]byte{140, 130, 168}: "Insigma Technology Co.,Ltd",
	[3]byte{140, 132, 1}:   "PRIVATE",
	[3]byte{140, 137, 165}: "Micro-Star INT'L CO., LTD",
	[3]byte{140, 138, 110}: "ESTUN AUTOMATION TECHNOLOY CO., LTD",
	[3]byte{140, 142, 118}: "taskit GmbH",
	[3]byte{140, 144, 211}: "Alcatel Lucent",
	[3]byte{140, 145, 9}:   "Toyoshima Electric Technoeogy(Suzhou) Co.,Ltd.",
	[3]byte{140, 146, 54}:  "Aus.Linx Technology Co., Ltd.",
	[3]byte{140, 148, 207}: "Encell Technology, Inc.",
	[3]byte{140, 160, 72}:  "Beijing NeTopChip Technology Co.,LTD",
	[3]byte{140, 169, 130}: "Intel Corporate",
	[3]byte{140, 174, 76}:  "Plugable Technologies",
	[3]byte{140, 174, 137}: "Y-cam Solutions Ltd",
	[3]byte{140, 176, 148}: "Airtech I&C Co., Ltd",
	[3]byte{140, 182, 79}:  "CISCO SYSTEMS, INC.",
	[3]byte{140, 183, 247}: "Shenzhen UniStrong Science & Technology Co., Ltd",
	[3]byte{140, 184, 44}:  "IPitomy Communications",
	[3]byte{140, 184, 100}: "AcSiP Technology Corp.",
	[3]byte{140, 190, 190}: "Xiaomi Technology Co.,Ltd",
	[3]byte{140, 191, 157}: "Shanghai Xinyou Information Technology Ltd. Co.",
	[3]byte{140, 193, 33}:  "Panasonic Corporation AVC Networks Company",
	[3]byte{140, 197, 225}: "ShenZhen Konka Telecommunication Technology Co.,Ltd",
	[3]byte{140, 199, 170}: "Radinet Communications Inc.",
	[3]byte{140, 199, 208}: "zhejiang ebang communication co.,ltd",
	[3]byte{140, 200, 205}: "Samsung Electronics Co., LTD",
	[3]byte{140, 205, 162}: "ACTP, Inc.",
	[3]byte{140, 205, 232}: "Nintendo Co., Ltd.",
	[3]byte{140, 207, 92}:  "BEFEGA GmbH",
	[3]byte{140, 209, 123}: "CG Mobile",
	[3]byte{140, 211, 162}: "VisSim AS",
	[3]byte{140, 214, 40}:  "Ikor Metering",
	[3]byte{140, 219, 37}:  "ESG Solutions",
	[3]byte{140, 220, 212}: "Hewlett Packard",
	[3]byte{140, 221, 141}: "Wifly-City System Inc.",
	[3]byte{140, 222, 82}:  "ISSC Technologies Corp.",
	[3]byte{140, 222, 153}: "Comlab Inc.",
	[3]byte{140, 223, 157}: "NEC Corporation",
	[3]byte{140, 224, 129}: "zte corporation",
	[3]byte{140, 231, 72}:  "PRIVATE",
	[3]byte{140, 231, 140}: "DK Networks",
	[3]byte{140, 231, 179}: "Sonardyne International Ltd",
	[3]byte{140, 238, 198}: "Precepscion Pty. Ltd.",
	[3]byte{140, 248, 19}:  "ORANGE POLSKA",
	[3]byte{140, 249, 69}:  "Power Automation pte Ltd",
	[3]byte{140, 249, 201}: "MESADA Technology Co.,Ltd.",
	[3]byte{140, 250, 186}: "Apple",
	[3]byte{140, 253, 240}: "QUALCOMM Incorporated",
	[3]byte{144, 0, 78}:    "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{144, 1, 59}:    "SAGEMCOM",
	[3]byte{144, 2, 138}:   "Shenzhen Shidean Legrand Electronic Products Co.,Ltd",
	[3]byte{144, 2, 169}:   "ZHEJIANG DAHUA TECHNOLOGY CO.,LTD",
	[3]byte{144, 3, 183}:   "PARROT",
	[3]byte{144, 9, 23}:    "Far-sighted mobile",
	[3]byte{144, 10, 58}:   "PSG Plastic Service GmbH",
	[3]byte{144, 12, 180}:  "Alinket Electronic Technology Co., Ltd",
	[3]byte{144, 13, 102}:  "Digimore Electronics Co., Ltd",
	[3]byte{144, 13, 203}:  "ARRIS Group, Inc.",
	[3]byte{144, 23, 155}:  "Nanomegas",
	[3]byte{144, 23, 172}:  "HUAWEI TECHNOLOGIES CO.,LTD",
	[3]byte{144, 24, 94}:   "Apex Tool Group GmbH & Co OHG",
	[3]byte{144, 24, 124}:  "Samsung Electro Mechanics co., LTD.",
	[3]byte{144, 24, 174}:  "Shanghai Meridian Technologies, Co. Ltd.",
	[3]byte{144, 25, 0}:    "SCS SA",
	[3]byte{144, 26, 202}:  "ARRIS Group, Inc.",
	[3]byte{144, 27, 14}:   "Fujitsu Technology Solutions GmbH",
	[3]byte{144, 29, 39}:   "zte corporation",
	[3]byte{144, 30, 221}:  "GREAT COMPUTER CORPORATION",
	[3]byte{144, 32, 58}:   "BYD Precision Manufacture Co.,Ltd",
	[3]byte{144, 32, 131}:  "General Engine Management Systems Ltd.",
	[3]byte{144, 33, 85}:   "HTC Corporation",
	[3]byte{144, 33, 129}:  "Shanghai Huaqin Telecom Technology Co.,Ltd",
	[3]byte{144, 39, 228}:  "Apple",
	[3]byte{144, 43, 52}:   "GIGA-BYTE TECHNOLOGY CO.,LTD.",
	[3]byte{144, 44, 199}:  "C-MAX Asia Limited",
	[3]byte{144, 46, 135}:  "LabJack",
	[3]byte{144, 49, 205}:  "Onyx Healthcare Inc.",
	[3]byte{144, 52, 43}:   "Gatekeeper Systems, Inc.",
	[3]byte{144, 52, 252}:  "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{144, 53, 110}:  "Vodafone Omnitel N.V.",
	[3]byte{144, 56, 223}:  "Changzhou Tiannengbo System Co. Ltd.",
	[3]byte{144, 58, 160}:  "Alcatel-Lucent",
	[3]byte{144, 60, 174}:  "Yunnan KSEC Digital Technology Co.,Ltd.",
	[3]byte{144, 61, 90}:   "Shenzhen Wision Technology Holding Limited",
	[3]byte{144, 61, 107}:  "Zicon Technology Corp.",
	[3]byte{144, 62, 171}:  "ARRIS Group, Inc.",
	[3]byte{144, 70, 183}:  "Vadaro Pte Ltd",
	[3]byte{144, 71, 22}:   "RORZE CORPORATION",
	[3]byte{144, 72, 154}:  "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{144, 73, 250}:  "Intel Corporation",
	[3]byte{144, 76, 229}:  "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{144, 78, 43}:   "Huawei Technologies Co., Ltd",
	[3]byte{144, 80, 123}:  "Advanced PANMOBIL Systems GmbH & Co. KG",
	[3]byte{144, 81, 63}:   "Elettronica Santerno",
	[3]byte{144, 84, 70}:   "TES ELECTRONIC SOLUTIONS",
	[3]byte{144, 85, 174}:  "Ericsson, EAB/RWI/K",
	[3]byte{144, 86, 130}:  "Lenbrook Industries Limited",
	[3]byte{144, 86, 146}:  "Autotalks Ltd.",
	[3]byte{144, 89, 175}:  "Texas Instruments",
	[3]byte{144, 95, 46}:   "TCT Mobile Limited",
	[3]byte{144, 95, 141}:  "modas GmbH",
	[3]byte{144, 97, 12}:   "Fida International (S) Pte Ltd",
	[3]byte{144, 103, 23}:  "Alphion India Private Limited",
	[3]byte{144, 103, 181}: "Alcatel-Lucent",
	[3]byte{144, 103, 243}: "Alcatel Lucent",
	[3]byte{144, 104, 195}: "Motorola Mobility LLC",
	[3]byte{144, 109, 200}: "DLG Automação Industrial Ltda",
	[3]byte{144, 110, 187}: "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{144, 112, 37}:  "Garea Microsys Co.,Ltd.",
	[3]byte{144, 114, 64}:  "Apple",
	[3]byte{144, 121, 144}: "Benchmark Electronics Romania SRL",
	[3]byte{144, 122, 10}:  "Gebr. Bode GmbH & Co KG",
	[3]byte{144, 122, 40}:  "Beijing Morncloud Information And Technology Co. Ltd.",
	[3]byte{144, 122, 241}: "SNUPI Technologies",
	[3]byte{144, 126, 186}: "UTEK TECHNOLOGY (SHENZHEN) CO.,LTD",
	[3]byte{144, 127, 97}:  "Chicony Electronics Co., Ltd.",
	[3]byte{144, 130, 96}:  "IEEE 1904.1 Working Group",
	[3]byte{144, 131, 122}: "General Electric Water & Process Technologies",
	[3]byte{144, 132, 13}:  "Apple",
	[3]byte{144, 136, 162}: "IONICS TECHNOLOGY ME LTDA",
	[3]byte{144, 140, 9}:   "Total Phase",
	[3]byte{144, 140, 68}:  "H.K ZONGMU TECHNOLOGY CO., LTD.",
	[3]byte{144, 140, 99}:  "GZ Weedong Networks Technology Co. , Ltd",
	[3]byte{144, 141, 29}:  "GH Technologies",
	[3]byte{144, 143, 207}: "UNO System Co., Ltd",
	[3]byte{144, 144, 60}:  "TRISON TECHNOLOGY CORPORATION",
	[3]byte{144, 144, 96}:  "RSI VIDEO TECHNOLOGIES",
	[3]byte{144, 146, 180}: "Diehl BGT Defence GmbH & Co. KG",
	[3]byte{144, 148, 228}: "D-Link International",
	[3]byte{144, 152, 100}: "Impex-Sat GmbH&amp;Co KG",
	[3]byte{144, 153, 22}:  "ELVEES NeoTek OJSC",
	[3]byte{144, 157, 224}: "Newland Design + Assoc. Inc.",
	[3]byte{144, 159, 51}:  "EFM Networks",
	[3]byte{144, 159, 67}:  "Accutron Instruments Inc.",
	[3]byte{144, 162, 218}: "GHEO SA",
	[3]byte{144, 164, 222}: "Wistron Neweb Corp.",
	[3]byte{144, 167, 131}: "JSW PACIFIC CORPORATION",
	[3]byte{144, 167, 193}: "Pakedge Device and Software Inc.",
	[3]byte{144, 172, 63}:  "BrightSign LLC",
	[3]byte{144, 174, 27}:  "TP-LINK TECHNOLOGIES CO.,LTD.",
	[3]byte{144, 177, 28}:  "Dell Inc.",
	[3]byte{144, 177, 52}:  "ARRIS Group, Inc.",
	[3]byte{144, 178, 31}:  "Apple",
	[3]byte{144, 182, 134}: "Murata Manufacturing Co., Ltd.",
	[3]byte{144, 184, 208}: "Joyent, Inc.",
	[3]byte{144, 185, 49}:  "Apple, Inc",
	[3]byte{144, 185, 125}: "Johnson Outdoors Marine Electronics d/b/a Minnkota",
	[3]byte{144, 193, 21}:  "Sony Ericsson Mobile Communications AB",
	[3]byte{144, 199, 146}: "ARRIS Group, Inc.",
	[3]byte{144, 204, 36}:  "Synaptics, Inc",
	[3]byte{144, 207, 21}:  "Nokia Corporation",
	[3]byte{144, 207, 111}: "Dlogixs Co Ltd",
	[3]byte{144, 207, 125}: "Qingdao Hisense Electric Co.,Ltd.",
	[3]byte{144, 209, 27}:  "Palomar Medical Technologies",
	[3]byte{144, 215, 79}:  "Bookeen",
	[3]byte{144, 215, 235}: "Texas Instruments",
	[3]byte{144, 216, 82}:  "Comtec Co., Ltd.",
	[3]byte{144, 217, 44}:  "HUG-WITSCHI AG",
	[3]byte{144, 218, 78}:  "AVANU",
	[3]byte{144, 218, 106}: "FOCUS H&S Co., Ltd.",
	[3]byte{144, 219, 70}:  "E-LEAD ELECTRONIC CO., LTD",
	[3]byte{144, 223, 183}: "s.m.s smart microwave sensors GmbH",
	[3]byte{144, 224, 240}: "IEEE 1722a Working Group",
	[3]byte{144, 226, 186}: "Intel Corporate",
	[3]byte{144, 230, 186}: "ASUSTek COMPUTER INC.",
	[3]byte{144, 234, 96}:  "SPI Lasers Ltd",
	[3]byte{144, 239, 104}: "ZyXEL Communications Corporation",
	[3]byte{144, 241, 170}: "Samsung Electronics Co.,LTD",
	[3]byte{144, 241, 176}: "Hangzhou Anheng Info&Tech CO.,LTD",
	[3]byte{144, 242, 120}: "Radius Gateway",
	[3]byte{144, 243, 183}: "Kirisun Communications Co., Ltd.",
	[3]byte{144, 244, 193}: "Rand McNally",
	[3]byte{144, 246, 82}:  "TP-LINK TECHNOLOGIES CO., LTD.",
	[3]byte{144, 247, 47}:  "Phillips Machine & Welding Co., Inc.",
	[3]byte{144, 251, 91}:  "Avaya, Inc",
	[3]byte{144, 251, 166}: "Hon Hai Precision Ind.Co.Ltd",
	[3]byte{144, 253, 97}:  "Apple",
	[3]byte{144, 255, 121}: "Metro Ethernet Forum",
	[3]byte{148, 0, 112}:   "Nokia Corporation",
	[3]byte{148, 1, 73}:    "AutoHotBox",
	[3]byte{148, 1, 194}:   "Samsung Electronics Co.,Ltd",
	[3]byte{148, 5, 182}:   "Liling FullRiver Electronics & Technology Ltd",
	[3]byte{148, 11, 45}:   "NetView Technologies(Shenzhen) Co., Ltd",
	[3]byte{148, 11, 213}:  "Himax Technologies, Inc",
	[3]byte{148, 12, 109}:  "TP-LINK Technologies Co.,Ltd.",
	[3]byte{148, 16, 62}:   "Belkin International Inc.",
	[3]byte{148, 17, 218}:  "ITF Fröschl GmbH",
	[3]byte{148, 22, 115}:  "Point Core SARL",
	[3]byte{148, 29, 28}:   "TLab West Systems AB",
	[3]byte{148, 32, 83}:   "Nokia Corporation",
	[3]byte{148, 33, 151}:  "Stalmart Technology Limited",
	[3]byte{148, 35, 110}:  "Shenzhen Junlan Electronic Ltd",
	[3]byte{148, 46, 23}:   "Schneider Electric Canada Inc",
	[3]byte{148, 46, 99}:   "Finsécur",
	[3]byte{148, 49, 155}:  "Alphatronics BV",
	[3]byte{148, 51, 221}:  "Taco Electronic Solutions, Inc.",
	[3]byte{148, 53, 10}:   "Samsung Electronics Co.,Ltd",
	[3]byte{148, 54, 224}:  "Sichuan Bihong Broadcast &amp; Television New Technologies Co.,Ltd",
	[3]byte{148, 57, 229}:  "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{148, 58, 240}:  "Nokia Corporation",
	[3]byte{148, 59, 177}:  "KAONMEDIA",
	[3]byte{148, 64, 162}:  "Anywave Communication Technologies, Inc.",
	[3]byte{148, 68, 68}:   "LG Innotek",
	[3]byte{148, 68, 82}:   "Belkin International Inc.",
	[3]byte{148, 70, 150}:  "BaudTec Corporation",
	[3]byte{148, 74, 9}:    "BitWise Controls",
	[3]byte{148, 80, 71}:   "Rechnerbetriebsgruppe",
	[3]byte{148, 81, 3}:    "Samsung Electronics",
	[3]byte{148, 81, 191}:  "Hyundai ESG",
	[3]byte{148, 84, 147}:  "Rigado, LLC",
	[3]byte{148, 89, 45}:   "EKE Building Technology Systems Ltd",
	[3]byte{148, 91, 126}:  "TRILOBIT LTDA.",
	[3]byte{148, 97, 36}:   "Pason Systems",
	[3]byte{148, 98, 105}:  "Arris Group, Inc.",
	[3]byte{148, 99, 209}:  "Samsung Electronics Co.,Ltd",
	[3]byte{148, 112, 210}: "WINFIRM TECHNOLOGY",
	[3]byte{148, 113, 172}: "TCT Mobile Limited",
	[3]byte{148, 117, 110}: "QinetiQ North America",
	[3]byte{148, 124, 62}:  "Polewall Norge AS",
	[3]byte{148, 129, 164}: "Azuray Technologies",
	[3]byte{148, 133, 122}: "Evantage Industries Corp",
	[3]byte{148, 134, 212}: "Surveillance Pro Corporation",
	[3]byte{148, 135, 124}: "ARRIS Group, Inc.",
	[3]byte{148, 136, 84}:  "Texas Instruments",
	[3]byte{148, 139, 3}:   "EAGET Innovation and Technology Co., Ltd.",
	[3]byte{148, 141, 80}:  "Beamex Oy Ab",
	[3]byte{148, 142, 137}: "INDUSTRIAS UNIDAS SA DE CV",
	[3]byte{148, 143, 238}: "Hughes Telematics, Inc.",
	[3]byte{148, 148, 38}:  "Apple",
	[3]byte{148, 152, 162}: "Shanghai LISTEN TECH.LTD",
	[3]byte{148, 155, 253}: "Trans New Technology, Inc.",
	[3]byte{148, 156, 85}:  "Alta Data Technologies",
	[3]byte{148, 159, 63}:  "Optek Digital Technology company limited",
	[3]byte{148, 159, 180}: "ChengDu JiaFaAnTai Technology Co.,Ltd",
	[3]byte{148, 167, 188}: "BodyMedia, Inc.",
	[3]byte{148, 170, 184}: "Joview(Beijing) Technology Co. Ltd.",
	[3]byte{148, 172, 202}: "trivum technologies GmbH",
	[3]byte{148, 174, 97}:  "Alcatel Lucent",
	[3]byte{148, 174, 227}: "Belden Hirschmann Industries (Suzhou) Ltd.",
	[3]byte{148, 180, 15}:  "Aruba Networks",
	[3]byte{148, 184, 197}: "RuggedCom Inc.",
	[3]byte{148, 185, 180}: "Aptos Technology",
	[3]byte{148, 186, 49}:  "Visiontec da Amazônia Ltda.",
	[3]byte{148, 186, 86}:  "Shenzhen Coship Electronics Co., Ltd.",
	[3]byte{148, 191, 30}:  "eflow Inc. / Smart Device Planning and Development Division",
	[3]byte{148, 191, 149}: "Shenzhen Coship Electronics Co., Ltd",
	[3]byte{148, 192, 20}:  "Sorter Sp. j. Konrad Grzeszczyk MichaA, Ziomek",
	[3]byte{148, 192, 56}:  "Tallac Networks",
	[3]byte{148, 193, 80}:  "2Wire Inc",
	[3]byte{148, 195, 228}: "SCA Schucker Gmbh & Co KG",
	[3]byte{148, 196, 233}: "PowerLayer Microsystems HongKong Limited",
	[3]byte{148, 198, 235}: "NOVA electronics, Inc.",
	[3]byte{148, 199, 175}: "Raylios Technology",
	[3]byte{148, 201, 98}:  "Teseq AG",
	[3]byte{148, 202, 15}:  "Honeywell Analytics",
	[3]byte{148, 204, 185}: "ARRIS Group, Inc.",
	[3]byte{148, 205, 172}: "Creowave Oy",
	[3]byte{148, 206, 44}:  "Sony Mobile Communications AB",
	[3]byte{148, 206, 49}:  "CTS Limited",
	[3]byte{148, 208, 25}:  "Cydle Corp.",
	[3]byte{148, 214, 14}:  "shenzhen yunmao information technologies co., ltd",
	[3]byte{148, 215, 35}:  "Shanghai DareGlobal Technologies Co., Ltd",
	[3]byte{148, 215, 113}: "Samsung Electronics Co.,Ltd",
	[3]byte{148, 217, 60}:  "ENELPS",
	[3]byte{148, 219, 73}:  "SITCORP",
	[3]byte{148, 219, 201}: "Azurewave",
	[3]byte{148, 221, 63}:  "A+V Link Technologies, Corp.",
	[3]byte{148, 222, 14}:  "SmartOptics AS",
	[3]byte{148, 222, 128}: "GIGA-BYTE TECHNOLOGY CO.,LTD.",
	[3]byte{148, 223, 78}:  "Wistron InfoComm(Kunshan)Co.,Ltd.",
	[3]byte{148, 223, 88}:  "IJ Electron CO.,Ltd.",
	[3]byte{148, 224, 208}: "HealthStream Taiwan Inc.",
	[3]byte{148, 226, 38}:  "D. ORtiz Consulting, LLC",
	[3]byte{148, 231, 17}:  "Xirka Dama Persada PT",
	[3]byte{148, 232, 72}:  "FYLDE MICRO LTD",
	[3]byte{148, 233, 140}: "Alcatel-Lucent",
	[3]byte{148, 235, 44}:  "Google Inc.",
	[3]byte{148, 235, 205}: "Research In Motion Limited",
	[3]byte{148, 246, 146}: "Geminico co.,Ltd.",
	[3]byte{148, 247, 32}:  "Tianjin Deviser Electronics Instrument Co., Ltd",
	[3]byte{148, 250, 232}: "Shenzhen Eycom Technology Co., Ltd",
	[3]byte{148, 251, 178}: "Shenzhen Gongjin Electronics Co.,Ltd",
	[3]byte{148, 253, 29}:  "WhereWhen Corp",
	[3]byte{148, 253, 46}:  "Shanghai Uniscope Technologies Co.,Ltd",
	[3]byte{148, 254, 244}: "SAGEMCOM",
	[3]byte{152, 2, 132}:   "Theobroma Systems GmbH",
	[3]byte{152, 3, 160}:   "ABB n.v. Power Quality Products",
	[3]byte{152, 3, 216}:   "Apple",
	[3]byte{152, 12, 130}:  "Samsung Electro Mechanics",
	[3]byte{152, 13, 46}:   "HTC Corporation",
	[3]byte{152, 14, 228}:  "PRIVATE",
	[3]byte{152, 16, 148}:  "Shenzhen Vsun communication technology Co.,ltd",
	[3]byte{152, 22, 236}:  "IC Intracom",
	[3]byte{152, 32, 142}:  "Definium Technologies",
	[3]byte{152, 38, 42}:   "Applied Research Associates, Inc",
	[3]byte{152, 41, 29}:   "Jaguar de Mexico, SA de CV",
	[3]byte{152, 41, 63}:   "Fujian Start Computer Equipment Co.,Ltd",
	[3]byte{152, 44, 190}:  "2Wire",
	[3]byte{152, 45, 86}:   "Resolution Audio",
	[3]byte{152, 47, 60}:   "Sichuan Changhong Electric Ltd.",
	[3]byte{152, 48, 0}:    "Beijing KEMACOM Technologies Co., Ltd.",
	[3]byte{152, 48, 113}:  "DAIKYUNG VASCOM",
	[3]byte{152, 52, 157}:  "Krauss Maffei Technologies GmbH",
	[3]byte{152, 53, 113}:  "Sub10 Systems Ltd",
	[3]byte{152, 53, 184}:  "Assembled Products Corporation",
	[3]byte{152, 55, 19}:   "PT.Navicom Indonesia",
	[3]byte{152, 59, 22}:   "AMPAK Technology Inc",
	[3]byte{152, 63, 159}:  "China SSJ (Suzhou) Network Technology Inc.",
	[3]byte{152, 66, 70}:   "SOL INDUSTRY PTE., LTD",
	[3]byte{152, 67, 218}:  "INTERTECH",
	[3]byte{152, 71, 60}:   "SHANGHAI SUNMON COMMUNICATION TECHNOGY CO.,LTD",
	[3]byte{152, 74, 71}:   "CHG Hospital Beds",
	[3]byte{152, 75, 74}:   "ARRIS Group, Inc.",
	[3]byte{152, 75, 225}:  "Hewlett-Packard Company",
	[3]byte{152, 76, 4}:    "Zhangzhou Keneng Electrical Equipment Co Ltd",
	[3]byte{152, 76, 211}:  "Mantis Deposition",
	[3]byte{152, 78, 151}:  "Starlight Marketing (H. K.) Ltd.",
	[3]byte{152, 79, 238}:  "Intel Corporate",
	[3]byte{152, 82, 177}:  "Samsung Electronics",
	[3]byte{152, 87, 211}:  "HON HAI-CCPBG  PRECISION IND.CO.,LTD.",
	[3]byte{152, 88, 138}:  "SYSGRATION Ltd.",
	[3]byte{152, 89, 69}:   "Texas Instruments",
	[3]byte{152, 92, 147}:  "SBG Systems SAS",
	[3]byte{152, 93, 70}:   "PeopleNet Communication",
	[3]byte{152, 94, 27}:   "ConversDigital Co., Ltd.",
	[3]byte{152, 96, 34}:   "EMW Co., Ltd.",
	[3]byte{152, 102, 234}: "Industrial Control Communications, Inc.",
	[3]byte{152, 107, 61}:  "ARRIS Group, Inc.",
	[3]byte{152, 108, 245}: "zte corporation",
	[3]byte{152, 109, 200}: "TOSHIBA MITSUBISHI-ELECTRIC INDUSTRIAL SYSTEMS CORPORATION",
	[3]byte{152, 115, 196}: "Sage Electronic Engineering LLC",
	[3]byte{152, 118, 182}: "Adafruit",
	[3]byte{152, 119, 112}: "Pep Digital Technology (Guangzhou) Co., Ltd",
	[3]byte{152, 126, 70}:  "Emizon Networks Limited",
	[3]byte{152, 130, 23}:  "Disruptive Ltd",
	[3]byte{152, 134, 177}: "Flyaudio corporation (China)",
	[3]byte{152, 137, 237}: "Anadem Information Inc.",
	[3]byte{152, 139, 93}:  "SAGEM COMMUNICATION",
	[3]byte{152, 139, 173}: "Corintech Ltd.",
	[3]byte{152, 142, 52}:  "ZHEJIANG BOXSAM ELECTRONIC CO.,LTD",
	[3]byte{152, 142, 74}:  "NOXUS(BEIJING) TECHNOLOGY CO.,LTD",
	[3]byte{152, 142, 221}: "TE Connectivity Limerick",
	[3]byte{152, 144, 128}: "Linkpower Network System Inc Ltd.",
	[3]byte{152, 144, 150}: "Dell Inc",
	[3]byte{152, 147, 204}: "LG Electronics Inc.",
	[3]byte{152, 148, 73}:  "Skyworth Wireless Technology Ltd.",
	[3]byte{152, 167, 176}: "MCST ZAO",
	[3]byte{152, 170, 215}: "BLUE WAVE NETWORKING CO LTD",
	[3]byte{152, 176, 57}:  "Alcatel-Lucent",
	[3]byte{152, 184, 227}: "Apple",
	[3]byte{152, 188, 87}:  "SVA TECHNOLOGIES CO.LTD",
	[3]byte{152, 188, 153}: "Edeltech Co.,Ltd.",
	[3]byte{152, 190, 148}: "IBM",
	[3]byte{152, 192, 235}: "Global Regency Ltd",
	[3]byte{152, 200, 69}:  "PacketAccess",
	[3]byte{152, 205, 180}: "Virident Systems, Inc.",
	[3]byte{152, 211, 49}:  "Shenzhen Bolutek Technology Co.,Ltd.",
	[3]byte{152, 214, 134}: "Chyi Lee industry Co., ltd.",
	[3]byte{152, 214, 187}: "Apple",
	[3]byte{152, 214, 247}: "LG Electronics",
	[3]byte{152, 216, 140}: "Nortel Networks",
	[3]byte{152, 218, 146}: "Vuzix Corporation",
	[3]byte{152, 220, 217}: "UNITEC Co., Ltd.",
	[3]byte{152, 225, 101}: "Accutome",
	[3]byte{152, 231, 154}: "Foxconn(NanJing) Communication Co.,Ltd.",
	[3]byte{152, 236, 101}: "Cosesy ApS",
	[3]byte{152, 240, 171}: "Apple",
	[3]byte{152, 241, 112}: "Murata Manufacturing Co., Ltd.",
	[3]byte{152, 245, 55}:  "zte corporation",
	[3]byte{152, 248, 193}: "IDT Technology Limited",
	[3]byte{152, 248, 219}: "Marini Impianti Industriali s.r.l.",
	[3]byte{152, 250, 227}: "Xiaomi inc.",
	[3]byte{152, 251, 18}:  "Grand Electronics (HK) Ltd",
	[3]byte{152, 252, 17}:  "Cisco-Linksys, LLC",
	[3]byte{152, 254, 3}:   "Ericsson - North America",
	[3]byte{152, 254, 148}: "Apple",
	[3]byte{152, 255, 106}: "OTEC(Shanghai)Technology Co.,Ltd.",
	[3]byte{152, 255, 208}: "Lenovo Mobile Communication Technology Ltd.",
	[3]byte{156, 1, 17}:    "Shenzhen Newabel Electronic Co., Ltd.",
	[3]byte{156, 2, 152}:   "Samsung Electronics Co.,Ltd",
	[3]byte{156, 3, 158}:   "Beijing Winchannel Software Technology Co., Ltd",
	[3]byte{156, 4, 115}:   "Tecmobile (International) Ltd.",
	[3]byte{156, 4, 235}:   "Apple",
	[3]byte{156, 6, 110}:   "Hytera Communications Corporation Limited",
	[3]byte{156, 13, 172}:  "Tymphany HK Limited",
	[3]byte{156, 20, 101}:  "Edata Elektronik San. ve Tic. A.Ş.",
	[3]byte{156, 24, 116}:  "Nokia Danmark A/S",
	[3]byte{156, 28, 18}:   "Aruba Networks",
	[3]byte{156, 31, 221}:  "Accupix Inc.",
	[3]byte{156, 32, 123}:  "Apple",
	[3]byte{156, 33, 106}:  "TP-LINK TECHNOLOGIES CO.,LTD.",
	[3]byte{156, 34, 14}:   "TASCAN Service GmbH",
	[3]byte{156, 40, 64}:   "Discovery Technology,LTD..",
	[3]byte{156, 40, 191}:  "Continental Automotive Czech Republic s.r.o.",
	[3]byte{156, 40, 239}:  "HUAWEI TECHNOLOGIES CO.,LTD",
	[3]byte{156, 42, 112}:  "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{156, 49, 120}:  "Foshan Huadian Intelligent Communications Teachnologies Co.,Ltd",
	[3]byte{156, 49, 182}:  "Kulite Semiconductor Products Inc",
	[3]byte{156, 53, 131}:  "Nipro Diagnostics, Inc",
	[3]byte{156, 58, 175}:  "Samsung Electronics Co.,Ltd",
	[3]byte{156, 62, 170}:  "EnvyLogic Co.,Ltd.",
	[3]byte{156, 65, 124}:  "Hame  Technology Co.,  Limited",
	[3]byte{156, 68, 61}:   "CHENGDU XUGUANG TECHNOLOGY CO, LTD",
	[3]byte{156, 68, 166}:  "SwiftTest, Inc.",
	[3]byte{156, 69, 99}:   "DIMEP Sistemas",
	[3]byte{156, 74, 123}:  "Nokia Corporation",
	[3]byte{156, 76, 174}:  "Mesa Labs",
	[3]byte{156, 78, 32}:   "CISCO SYSTEMS, INC.",
	[3]byte{156, 78, 54}:   "Intel Corporate",
	[3]byte{156, 78, 142}:  "ALT Systems Ltd",
	[3]byte{156, 78, 191}:  "BoxCast",
	[3]byte{156, 83, 205}:  "ENGICAM s.r.l.",
	[3]byte{156, 84, 28}:   "Shenzhen My-power Technology Co.,Ltd",
	[3]byte{156, 84, 202}:  "Zhengzhou VCOM Science and Technology Co.,Ltd",
	[3]byte{156, 85, 180}:  "I.S.E. S.r.l.",
	[3]byte{156, 87, 17}:   "Feitian Xunda(Beijing) Aeronautical Information Technology Co., Ltd.",
	[3]byte{156, 91, 150}:  "NMR Corporation",
	[3]byte{156, 92, 141}:  "FIREMAX INDÚSTRIA E COMÉRCIO DE PRODUTOS ELETRÔNICOS  LTDA",
	[3]byte{156, 93, 18}:   "Aerohive Networks Inc",
	[3]byte{156, 93, 149}:  "VTC Electronics Corp.",
	[3]byte{156, 94, 115}:  "Calibre UK Ltd",
	[3]byte{156, 97, 29}:   "Omni-ID USA, Inc.",
	[3]byte{156, 100, 94}:  "Harman Consumer Group",
	[3]byte{156, 101, 176}: "Samsung Electronics Co.,Ltd",
	[3]byte{156, 101, 249}: "AcSiP Technology Corp.",
	[3]byte{156, 102, 80}:  "Glodio Technolies Co.,Ltd Tianjin Branch",
	[3]byte{156, 106, 190}: "QEES ApS.",
	[3]byte{156, 117, 20}:  "Wildix srl",
	[3]byte{156, 119, 170}: "NADASNV",
	[3]byte{156, 121, 172}: "Suntec Software(Shanghai) Co., Ltd.",
	[3]byte{156, 123, 210}: "NEOLAB Convergence",
	[3]byte{156, 128, 125}: "SYSCABLE Korea Inc.",
	[3]byte{156, 128, 223}: "Arcadyan Technology Corporation",
	[3]byte{156, 134, 218}: "Phoenix Geophysics Ltd.",
	[3]byte{156, 136, 136}: "Simac Techniek NV",
	[3]byte{156, 139, 241}: "The Warehouse Limited",
	[3]byte{156, 141, 26}:  "INTEG process group inc",
	[3]byte{156, 142, 153}: "Hewlett-Packard Company",
	[3]byte{156, 142, 220}: "Teracom Limited",
	[3]byte{156, 147, 78}:  "Xerox Corporation",
	[3]byte{156, 147, 228}: "PRIVATE",
	[3]byte{156, 149, 248}: "SmartDoor Systems, LLC",
	[3]byte{156, 151, 38}:  "Technicolor",
	[3]byte{156, 152, 17}:  "Guangzhou Sunrise Electronics Development Co., Ltd",
	[3]byte{156, 156, 29}:  "Starkey Labs Inc.",
	[3]byte{156, 161, 10}:  "SCLE SFE",
	[3]byte{156, 161, 52}:  "Nike, Inc.",
	[3]byte{156, 163, 186}: "SAKURA Internet Inc.",
	[3]byte{156, 165, 119}: "Osorno Enterprises Inc.",
	[3]byte{156, 169, 228}: "zte corporation",
	[3]byte{156, 173, 151}: "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{156, 173, 239}: "Obihai Technology, Inc.",
	[3]byte{156, 175, 202}: "CISCO SYSTEMS, INC.",
	[3]byte{156, 176, 8}:   "Ubiquitous Computing Technology Corporation",
	[3]byte{156, 178, 6}:   "PROCENTEC",
	[3]byte{156, 182, 84}:  "Hewlett Packard",
	[3]byte{156, 183, 13}:  "Liteon Technology Corporation",
	[3]byte{156, 183, 147}: "Creatcomm Technology Inc.",
	[3]byte{156, 187, 152}: "Shen Zhen RND Electronic Co.,LTD",
	[3]byte{156, 189, 157}: "SkyDisk, Inc.",
	[3]byte{156, 192, 119}: "PrintCounts, LLC",
	[3]byte{156, 192, 210}: "Conductix-Wampfler AG",
	[3]byte{156, 193, 114}: "Huawei Technologies Co., Ltd",
	[3]byte{156, 199, 166}: "AVM GmbH",
	[3]byte{156, 199, 209}: "SHARP Corporation",
	[3]byte{156, 202, 217}: "Nokia Corporation",
	[3]byte{156, 205, 130}: "CHENG UEI PRECISION INDUSTRY CO.,LTD",
	[3]byte{156, 210, 30}:  "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{156, 210, 75}:  "zte corporation",
	[3]byte{156, 211, 109}: "NETGEAR INC.,",
	[3]byte{156, 214, 67}:  "D-Link International",
	[3]byte{156, 217, 23}:  "Motorola Mobility LLC",
	[3]byte{156, 223, 3}:   "Harman/Becker Automotive Systems GmbH",
	[3]byte{156, 225, 14}:  "NCTech Ltd",
	[3]byte{156, 225, 214}: "Junger Audio-Studiotechnik GmbH",
	[3]byte{156, 230, 53}:  "Nintendo Co., Ltd.",
	[3]byte{156, 230, 231}: "Samsung Electronics Co.,Ltd",
	[3]byte{156, 231, 189}: "Winduskorea co., Ltd",
	[3]byte{156, 235, 232}: "BizLink (Kunshan) Co.,Ltd",
	[3]byte{156, 246, 26}:  "UTC Fire and Security",
	[3]byte{156, 246, 125}: "Ricardo Prague, s.r.o.",
	[3]byte{156, 248, 219}: "shenzhen eyunmei technology co,.ltd",
	[3]byte{156, 249, 56}:  "AREVA NP GmbH",
	[3]byte{156, 251, 241}: "MESOMATIC GmbH & Co.KG",
	[3]byte{156, 255, 190}: "OTSL Inc.",
	[3]byte{160, 2, 220}:   "Amazon Technologies Inc.",
	[3]byte{160, 3, 99}:    "Robert Bosch Healthcare GmbH",
	[3]byte{160, 6, 39}:    "NEXPA System",
	[3]byte{160, 7, 152}:   "Samsung Electronics",
	[3]byte{160, 7, 182}:   "Advanced Technical Support, Inc.",
	[3]byte{160, 10, 191}:  "Wieson Technologies Co., Ltd.",
	[3]byte{160, 11, 186}:  "SAMSUNG ELECTRO-MECHANICS",
	[3]byte{160, 12, 161}:  "SKTB SKiT",
	[3]byte{160, 18, 144}:  "Avaya, Inc",
	[3]byte{160, 18, 219}:  "TABUCHI ELECTRIC CO.,LTD",
	[3]byte{160, 19, 59}:   "Copyright © HiTi Digital, Inc.",
	[3]byte{160, 20, 61}:   "PARROT SA",
	[3]byte{160, 22, 92}:   "Triteka LTD",
	[3]byte{160, 24, 89}:   "Shenzhen Yidashi Electronics Co Ltd",
	[3]byte{160, 25, 23}:   "Bertel S.p.a.",
	[3]byte{160, 28, 5}:    "NIMAX TELECOM CO.,LTD.",
	[3]byte{160, 29, 72}:   "Hewlett Packard",
	[3]byte{160, 33, 149}:  "Samsung Electronics Digital Imaging",
	[3]byte{160, 33, 183}:  "NETGEAR",
	[3]byte{160, 35, 27}:   "TeleComp R&D Corp.",
	[3]byte{160, 43, 184}:  "Hewlett Packard",
	[3]byte{160, 46, 243}:  "United Integrated Services Co., Led.",
	[3]byte{160, 54, 159}:  "Intel Corporate",
	[3]byte{160, 54, 240}:  "Comprehensive Power",
	[3]byte{160, 54, 250}:  "Ettus Research LLC",
	[3]byte{160, 58, 117}:  "PSS Belgium N.V.",
	[3]byte{160, 59, 27}:   "Inspire Tech",
	[3]byte{160, 64, 37}:   "Actioncable, Inc.",
	[3]byte{160, 64, 65}:   "SAMWONFA Co.,Ltd.",
	[3]byte{160, 65, 167}:  "NL Ministry of Defense",
	[3]byte{160, 66, 63}:   "Tyan Computer Corp",
	[3]byte{160, 72, 28}:   "Hewlett Packard",
	[3]byte{160, 76, 193}:  "Helixtech Corp.",
	[3]byte{160, 78, 4}:    "Nokia Corporation",
	[3]byte{160, 81, 198}:  "Avaya, Inc",
	[3]byte{160, 85, 222}:  "Pace plc",
	[3]byte{160, 86, 178}:  "Harman/Becker Automotive Systems GmbH",
	[3]byte{160, 89, 58}:   "V.D.S. Video Display Systems srl",
	[3]byte{160, 90, 164}:  "Grand Products Nevada, Inc.",
	[3]byte{160, 91, 33}:   "ENVINET GmbH",
	[3]byte{160, 93, 193}:  "TMCT Co., LTD.",
	[3]byte{160, 93, 231}:  "DIRECTV, Inc.",
	[3]byte{160, 94, 107}:  "MELPER Co., Ltd.",
	[3]byte{160, 101, 24}:  "VNPT TECHNOLOGY",
	[3]byte{160, 103, 190}: "Sicon s.r.l.",
	[3]byte{160, 105, 134}: "Wellav Technologies Ltd",
	[3]byte{160, 106, 0}:   "Verilink Corporation",
	[3]byte{160, 108, 236}: "RIM",
	[3]byte{160, 109, 9}:   "Intelcan Technosystems Inc.",
	[3]byte{160, 110, 80}:  "Nanotek Elektronik Sistemler Ltd. Sti.",
	[3]byte{160, 113, 169}: "Nokia Corporation",
	[3]byte{160, 115, 50}:  "Cashmaster International Limited",
	[3]byte{160, 115, 252}: "Rancore Technologies Private Limited",
	[3]byte{160, 117, 145}: "Samsung Electronics Co.,Ltd",
	[3]byte{160, 119, 113}: "Vialis BV",
	[3]byte{160, 120, 186}: "Pantech Co., Ltd.",
	[3]byte{160, 130, 31}:  "Samsung Electronics Co.,Ltd",
	[3]byte{160, 130, 199}: "P.T.I Co.,LTD",
	[3]byte{160, 134, 29}:  "Chengdu Fuhuaxin Technology co.,Ltd",
	[3]byte{160, 134, 236}: "SAEHAN HITEC Co., Ltd",
	[3]byte{160, 136, 105}: "Intel Corporate",
	[3]byte{160, 136, 180}: "Intel Corporate",
	[3]byte{160, 137, 228}: "Skyworth Digital Technology(Shenzhen) Co.,Ltd",
	[3]byte{160, 138, 135}: "HuiZhou KaiYue Electronic Co.,Ltd",
	[3]byte{160, 140, 21}:  "Gerhard D. Wempe KG",
	[3]byte{160, 140, 155}: "Xtreme Technologies Corp",
	[3]byte{160, 144, 222}: "VEEDIMS,LLC",
	[3]byte{160, 147, 71}:  "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD.",
	[3]byte{160, 152, 5}:   "OpenVox Communication Co Ltd",
	[3]byte{160, 152, 237}: "Shandong Intelligent Optical Communication Development Co., Ltd.",
	[3]byte{160, 154, 90}:  "Time Domain",
	[3]byte{160, 155, 189}: "Total Aviation Solutions Pty Ltd",
	[3]byte{160, 161, 48}:  "DLI Taiwan Branch office",
	[3]byte{160, 162, 60}:  "GPMS",
	[3]byte{160, 163, 226}: "Actiontec Electronics, Inc",
	[3]byte{160, 167, 99}:  "Polytron Vertrieb GmbH",
	[3]byte{160, 168, 205}: "Intel Corporate",
	[3]byte{160, 170, 253}: "EraThink Technologies Corp.",
	[3]byte{160, 177, 0}:   "ShenZhen Cando Electronics Co.,Ltd",
	[3]byte{160, 179, 204}: "Hewlett Packard",
	[3]byte{160, 180, 165}: "Samsung Elec Co.,Ltd",
	[3]byte{160, 181, 218}: "HongKong THTF Co., Ltd",
	[3]byte{160, 182, 98}:  "Acutvista Innovation Co., Ltd.",
	[3]byte{160, 185, 237}: "Skytap",
	[3]byte{160, 186, 184}: "Pixon Imaging",
	[3]byte{160, 191, 80}:  "S.C. ADD-PRODUCTION S.R.L.",
	[3]byte{160, 191, 165}: "CORESYS",
	[3]byte{160, 195, 222}: "Triton Electronic Systems Ltd.",
	[3]byte{160, 198, 236}: "ShenZhen ANYK Technology Co.,LTD",
	[3]byte{160, 206, 200}: "CE LINK LIMITED",
	[3]byte{160, 207, 91}:  "CISCO SYSTEMS, INC.",
	[3]byte{160, 209, 42}:  "AXPRO Technology Inc.",
	[3]byte{160, 211, 193}: "Hewlett Packard",
	[3]byte{160, 218, 146}: "Nanjing Glarun Atten Technology Co. Ltd.",
	[3]byte{160, 220, 4}:   "Becker-Antriebe GmbH",
	[3]byte{160, 221, 151}: "PolarLink Technologies, Ltd",
	[3]byte{160, 221, 229}: "SHARP Corporation",
	[3]byte{160, 222, 5}:   "JSC \"Irbis-T\"",
	[3]byte{160, 226, 1}:   "AVTrace Ltd.(China)",
	[3]byte{160, 226, 90}:  "Amicus SK, s.r.o.",
	[3]byte{160, 226, 149}: "DAT System Co.,Ltd",
	[3]byte{160, 228, 83}:  "Sony Mobile Communications AB",
	[3]byte{160, 229, 52}:  "Stratec Biomedical AG",
	[3]byte{160, 229, 233}: "enimai Inc",
	[3]byte{160, 230, 248}: "Texas Instruments Inc",
	[3]byte{160, 233, 219}: "Ningbo FreeWings Technologies Co.,Ltd",
	[3]byte{160, 235, 118}: "AirCUVE Inc.",
	[3]byte{160, 236, 128}: "zte corporation",
	[3]byte{160, 237, 205}: "Apple",
	[3]byte{160, 239, 132}: "Seine Image Int'l Co., Ltd",
	[3]byte{160, 242, 23}:  "GE Medical System(China) Co., Ltd.",
	[3]byte{160, 243, 193}: "TP-LINK TECHNOLOGIES CO., LTD.",
	[3]byte{160, 243, 228}: "Alcatel Lucent IPD",
	[3]byte{160, 244, 25}:  "Nokia Corporation",
	[3]byte{160, 244, 80}:  "HTC Corporation",
	[3]byte{160, 244, 89}:  "FN-LINK TECHNOLOGY LIMITED",
	[3]byte{160, 252, 110}: "Telegrafia a.s.",
	[3]byte{160, 254, 145}: "AVAT Automation GmbH",
	[3]byte{164, 1, 48}:    "ABIsystems Co., LTD",
	[3]byte{164, 5, 158}:   "STA Infinity LLP",
	[3]byte{164, 9, 203}:   "Alfred Kaercher GmbH &amp; Co KG",
	[3]byte{164, 11, 237}:  "Carry Technology Co.,Ltd",
	[3]byte{164, 12, 195}:  "CISCO SYSTEMS, INC.",
	[3]byte{164, 18, 66}:   "NEC Platforms, Ltd.",
	[3]byte{164, 19, 78}:   "Luxul",
	[3]byte{164, 21, 102}:  "Wei Fang Goertek Electronics Co.,Ltd",
	[3]byte{164, 23, 49}:   "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{164, 24, 117}:  "CISCO SYSTEMS, INC.",
	[3]byte{164, 27, 192}:  "Fastec Imaging Corporation",
	[3]byte{164, 31, 114}:  "Dell Inc.",
	[3]byte{164, 33, 138}:  "Nortel Networks",
	[3]byte{164, 35, 5}:    "Open Networking Laboratory",
	[3]byte{164, 36, 179}:  "FlatFrog Laboratories AB",
	[3]byte{164, 37, 27}:   "Avaya, Inc",
	[3]byte{164, 41, 64}:   "Shenzhen YOUHUA Technology Co., Ltd",
	[3]byte{164, 41, 183}:  "bluesky",
	[3]byte{164, 44, 8}:    "Masterwork Automodules",
	[3]byte{164, 51, 209}:  "Fibrlink Communications Co.,Ltd.",
	[3]byte{164, 56, 252}:  "Plastic Logic",
	[3]byte{164, 58, 105}:  "Vers Inc",
	[3]byte{164, 59, 250}:  "IEEE REGISTRATION AUTHORITY  - Please see MAM public listing for more information.",
	[3]byte{164, 61, 120}:  "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD",
	[3]byte{164, 70, 107}:  "EOC Technology",
	[3]byte{164, 70, 250}:  "AmTRAN Video Corporation",
	[3]byte{164, 74, 211}:  "ST Electronics(Shanghai) Co.,Ltd",
	[3]byte{164, 75, 21}:   "Sun Cupid Technology (HK) LTD",
	[3]byte{164, 76, 17}:   "CISCO SYSTEMS, INC.",
	[3]byte{164, 78, 45}:   "Adaptive Wireless Solutions, LLC",
	[3]byte{164, 78, 49}:   "Intel Corporate",
	[3]byte{164, 80, 85}:   "busware.de",
	[3]byte{164, 82, 111}:  "ADB Broadband Italia",
	[3]byte{164, 86, 27}:   "MCOT Corporation",
	[3]byte{164, 86, 48}:   "CISCO SYSTEMS, INC.",
	[3]byte{164, 90, 28}:   "smart-electronic GmbH",
	[3]byte{164, 92, 39}:   "Nintendo Co., Ltd.",
	[3]byte{164, 93, 54}:   "Hewlett Packard",
	[3]byte{164, 93, 161}:  "ADB Broadband Italia",
	[3]byte{164, 96, 50}:   "MRV Communications (Networks) LTD",
	[3]byte{164, 103, 6}:   "Apple",
	[3]byte{164, 108, 193}: "LTi REEnergy GmbH",
	[3]byte{164, 110, 121}: "DFT System Co.Ltd",
	[3]byte{164, 112, 214}: "Motorola Mobility LLC",
	[3]byte{164, 119, 51}:  "Google",
	[3]byte{164, 119, 96}:  "Nokia Corporation",
	[3]byte{164, 121, 228}: "KLINFO Corp",
	[3]byte{164, 122, 164}: "ARRIS Group, Inc.",
	[3]byte{164, 122, 207}: "VIBICOM COMMUNICATIONS INC.",
	[3]byte{164, 124, 20}:  "ChargeStorm AB",
	[3]byte{164, 124, 31}:  "Cobham plc",
	[3]byte{164, 126, 57}:  "zte corporation",
	[3]byte{164, 129, 238}: "Nokia Corporation",
	[3]byte{164, 133, 107}: "Q Electronics Ltd",
	[3]byte{164, 137, 91}:  "ARK INFOSOLUTIONS PVT LTD",
	[3]byte{164, 144, 5}:   "CHINA GREATWALL COMPUTER SHENZHEN CO.,LTD",
	[3]byte{164, 147, 76}:  "CISCO SYSTEMS, INC.",
	[3]byte{164, 151, 187}: "Hitachi Industrial Equipment Systems Co.,Ltd",
	[3]byte{164, 153, 71}:  "Huawei Technologies Co., Ltd",
	[3]byte{164, 153, 129}: "FuJian Elite Power Tech CO.,LTD.",
	[3]byte{164, 154, 88}:  "Samsung Electronics Co.,Ltd",
	[3]byte{164, 155, 19}:  "Burroughs Payment Systems, Inc.",
	[3]byte{164, 157, 73}:  "Ketra, Inc.",
	[3]byte{164, 158, 219}: "AutoCrib, Inc.",
	[3]byte{164, 159, 133}: "Lyve Minds, Inc",
	[3]byte{164, 159, 137}: "Shanghai Rui Rui Communication Technology Co.Ltd.",
	[3]byte{164, 161, 194}: "Ericsson AB (EAB)",
	[3]byte{164, 162, 74}:  "Cisco SPVTG",
	[3]byte{164, 164, 211}: "Bluebank Communication Technology Co.Ltd",
	[3]byte{164, 168, 15}:  "Shenzhen Coship Electronics Co., Ltd.",
	[3]byte{164, 173, 0}:   "Ragsdale Technology",
	[3]byte{164, 173, 184}: "Vitec Group, Camera Dynamics Ltd",
	[3]byte{164, 174, 154}: "Maestro Wireless Solutions ltd.",
	[3]byte{164, 177, 33}:  "Arantia 2010 S.L.",
	[3]byte{164, 177, 151}: "Apple",
	[3]byte{164, 177, 233}: "Technicolor",
	[3]byte{164, 177, 238}: "H. ZANDER GmbH & Co. KG",
	[3]byte{164, 178, 167}: "Adaxys Solutions AG",
	[3]byte{164, 179, 106}: "JSC SDO Chromatec",
	[3]byte{164, 184, 24}:  "PENTA Gesellschaft für elektronische Industriedatenverarbeitung mbH",
	[3]byte{164, 185, 128}: "Parking BOXX Inc.",
	[3]byte{164, 186, 219}: "Dell Inc.",
	[3]byte{164, 187, 175}: "Lime Instruments",
	[3]byte{164, 190, 97}:  "EutroVision System, Inc.",
	[3]byte{164, 192, 199}: "ShenZhen Hitom Communication Technology Co..LTD",
	[3]byte{164, 192, 225}: "Nintendo Co., Ltd.",
	[3]byte{164, 194, 171}: "Hangzhou LEAD-IT Information & Technology Co.,Ltd",
	[3]byte{164, 195, 97}:  "Apple",
	[3]byte{164, 199, 222}: "Cambridge Industries(Group) Co.,Ltd.",
	[3]byte{164, 208, 148}: "Erwin Peters Systemtechnik GmbH",
	[3]byte{164, 209, 143}: "Shenzhen Skyee Optical Fiber Communication Technology Ltd.",
	[3]byte{164, 209, 209}: "ECOtality North America",
	[3]byte{164, 209, 210}: "Apple",
	[3]byte{164, 211, 181}: "GLITEL Stropkov, s.r.o.",
	[3]byte{164, 216, 86}:  "Gimbal, Inc",
	[3]byte{164, 218, 63}:  "Bionics Corp.",
	[3]byte{164, 219, 46}:  "Kingspan Environmental Ltd",
	[3]byte{164, 219, 48}:  "Liteon Technology Corporation",
	[3]byte{164, 222, 80}:  "Total Walther GmbH",
	[3]byte{164, 224, 230}: "FILIZOLA S.A. PESAGEM E AUTOMACAO",
	[3]byte{164, 227, 46}:  "Silicon & Software Systems Ltd.",
	[3]byte{164, 227, 145}: "DENY FONTAINE",
	[3]byte{164, 228, 184}: "BlackBerry Limited",
	[3]byte{164, 231, 49}:  "Nokia Corporation",
	[3]byte{164, 231, 228}: "Connex GmbH",
	[3]byte{164, 233, 145}: "SISTEMAS AUDIOVISUALES ITELSIS S.L.",
	[3]byte{164, 233, 163}: "Honest Technology Co., Ltd",
	[3]byte{164, 235, 211}: "Samsung Electronics Co.,Ltd",
	[3]byte{164, 237, 78}:  "ARRIS Group, Inc.",
	[3]byte{164, 238, 87}:  "SEIKO EPSON CORPORATION",
	[3]byte{164, 239, 82}:  "Telewave Co., Ltd.",
	[3]byte{164, 243, 193}: "Open Source Robotics Foundation, Inc.",
	[3]byte{164, 245, 34}:  "CHOFU SEISAKUSHO CO.,LTD",
	[3]byte{164, 247, 208}: "LAN Accessories Co., Ltd.",
	[3]byte{164, 251, 141}: "Hangzhou Dunchong Technology Co.Ltd",
	[3]byte{164, 252, 206}: "Security Expert Ltd.",
	[3]byte{168, 1, 128}:   "IMAGO Technologies GmbH",
	[3]byte{168, 6, 0}:     "Samsung Electronics Co.,Ltd",
	[3]byte{168, 12, 13}:   "Cisco",
	[3]byte{168, 19, 116}:  "Panasonic Corporation AVC Networks Company",
	[3]byte{168, 21, 77}:   "TP-LINK TECHNOLOGIES CO.,LTD.",
	[3]byte{168, 22, 178}:  "LG Electronics",
	[3]byte{168, 23, 88}:   "Elektronik System i Umeå AB",
	[3]byte{168, 27, 24}:   "XTS CORP",
	[3]byte{168, 27, 93}:   "Foxtel Management Pty Ltd",
	[3]byte{168, 29, 22}:   "AzureWave Technologies, Inc",
	[3]byte{168, 31, 175}:  "KRYPTON POLSKA",
	[3]byte{168, 32, 102}:  "Apple",
	[3]byte{168, 36, 235}:  "ZAO NPO Introtest",
	[3]byte{168, 38, 217}:  "HTC Corporation",
	[3]byte{168, 41, 76}:   "Precision Optical Transceivers, Inc.",
	[3]byte{168, 43, 214}:  "Shina System Co., Ltd",
	[3]byte{168, 48, 173}:  "Wei Fang Goertek Electronics Co.,Ltd",
	[3]byte{168, 50, 154}:  "Digicom Futuristic Technologies Ltd.",
	[3]byte{168, 57, 68}:   "Actiontec Electronics, Inc",
	[3]byte{168, 64, 65}:   "Dragino Technology Co., Limited",
	[3]byte{168, 68, 129}:  "Nokia Corporation",
	[3]byte{168, 69, 233}:  "Firich Enterprises CO., LTD.",
	[3]byte{168, 73, 165}:  "Lisantech Co., Ltd.",
	[3]byte{168, 84, 178}:  "Wistron Neweb Corp.",
	[3]byte{168, 85, 106}:  "Pocketnet Technology Inc.",
	[3]byte{168, 87, 78}:   "TP-LINK TECHNOLOGIES CO.,LTD.",
	[3]byte{168, 91, 176}:  "Shenzhen Dehoo Technology Co.,Ltd",
	[3]byte{168, 91, 243}:  "Audivo GmbH",
	[3]byte{168, 97, 170}:  "Cloudview Limited",
	[3]byte{168, 98, 162}:  "JIWUMEDIA CO., LTD.",
	[3]byte{168, 99, 223}:  "DISPLAIRE CORPORATION",
	[3]byte{168, 99, 242}:  "Texas Instruments",
	[3]byte{168, 100, 5}:   "nimbus 9, Inc",
	[3]byte{168, 101, 178}: "DONGGUAN YISHANG ELECTRONIC TECHNOLOGY CO., LIMITED",
	[3]byte{168, 106, 111}: "RIM",
	[3]byte{168, 112, 165}: "UniComm Inc.",
	[3]byte{168, 117, 214}: "FreeTek International Co., Ltd.",
	[3]byte{168, 117, 226}: "Aventura Technologies, Inc.",
	[3]byte{168, 119, 111}: "Zonoff",
	[3]byte{168, 123, 57}:  "Nokia Corporation",
	[3]byte{168, 124, 1}:   "Samsung Elec Co.,Ltd",
	[3]byte{168, 126, 51}:  "Nokia Danmark A/S",
	[3]byte{168, 129, 241}: "BMEYE B.V.",
	[3]byte{168, 134, 221}: "Apple, Inc.",
	[3]byte{168, 135, 146}: "Broadband Antenna Tracking Systems",
	[3]byte{168, 135, 237}: "ARC Wireless LLC",
	[3]byte{168, 136, 8}:   "Apple",
	[3]byte{168, 140, 238}: "MicroMade Galka i Drozdz sp.j.",
	[3]byte{168, 141, 123}: "SunDroid Global limited.",
	[3]byte{168, 142, 36}:  "Apple",
	[3]byte{168, 146, 44}:  "LG Electronics",
	[3]byte{168, 147, 230}: "JIANGXI JINGGANGSHAN CKING COMMUNICATION TECHNOLOGY CO.,LTD",
	[3]byte{168, 149, 176}: "Aker Subsea Ltd",
	[3]byte{168, 150, 138}: "Apple",
	[3]byte{168, 151, 220}: "IBM",
	[3]byte{168, 152, 198}: "Shinbo Co., Ltd.",
	[3]byte{168, 153, 92}:  "aizo ag",
	[3]byte{168, 155, 16}:  "inMotion Ltd.",
	[3]byte{168, 157, 210}: "Shanghai DareGlobal Technologies Co., Ltd",
	[3]byte{168, 166, 104}: "zte corporation",
	[3]byte{168, 173, 61}:  "Alcatel-Lucent Shanghai Bell Co., Ltd",
	[3]byte{168, 176, 174}: "LEONI",
	[3]byte{168, 177, 212}: "CISCO SYSTEMS, INC.",
	[3]byte{168, 185, 179}: "ESSYS",
	[3]byte{168, 187, 207}: "Apple",
	[3]byte{168, 189, 26}:  "Honey Bee (Hong Kong) Limited",
	[3]byte{168, 189, 58}:  "UNIONMAN TECHNOLOGY CO.,LTD",
	[3]byte{168, 194, 34}:  "TM-Research Inc.",
	[3]byte{168, 203, 149}: "EAST BEST CO., LTD.",
	[3]byte{168, 204, 197}: "Saab AB (publ)",
	[3]byte{168, 206, 144}: "CVC",
	[3]byte{168, 208, 227}: "Systech Electronics Ltd.",
	[3]byte{168, 208, 229}: "Juniper Networks",
	[3]byte{168, 210, 54}:  "Lightware Visual Engineering",
	[3]byte{168, 211, 200}: "Wachendorff Elektronik  GmbH & Co. KG",
	[3]byte{168, 216, 138}: "Wyconn",
	[3]byte{168, 224, 24}:  "Nokia Corporation",
	[3]byte{168, 227, 238}: "Sony Computer Entertainment Inc.",
	[3]byte{168, 229, 57}:  "Moimstone Co.,Ltd",
	[3]byte{168, 239, 38}:  "Tritonwave",
	[3]byte{168, 242, 116}: "Samsung Electronics",
	[3]byte{168, 244, 112}: "Fujian Newland Communication Science Technologies Co.,Ltd.",
	[3]byte{168, 247, 224}: "PLANET Technology Corporation",
	[3]byte{168, 249, 75}:  "Eltex Enterprise Ltd.",
	[3]byte{168, 250, 216}: "Apple",
	[3]byte{168, 251, 112}: "WiseSec L.t.d",
	[3]byte{168, 252, 183}: "Consolidated Resource Imaging",
	[3]byte{170, 0, 0}:     "DIGITAL EQUIPMENT CORPORATION",
	[3]byte{170, 0, 1}:     "DIGITAL EQUIPMENT CORPORATION",
	[3]byte{170, 0, 2}:     "DIGITAL EQUIPMENT CORPORATION",
	[3]byte{170, 0, 3}:     "DIGITAL EQUIPMENT CORPORATION",
	[3]byte{170, 0, 4}:     "DIGITAL EQUIPMENT CORPORATION",
	[3]byte{172, 1, 66}:    "Uriel Technologies SIA",
	[3]byte{172, 2, 202}:   "HI Solutions, Inc.",
	[3]byte{172, 2, 207}:   "RW Tecnologia Industria e Comercio Ltda",
	[3]byte{172, 2, 239}:   "Comsis",
	[3]byte{172, 6, 19}:    "Senselogix Ltd",
	[3]byte{172, 10, 97}:   "Labor S.r.L.",
	[3]byte{172, 13, 254}:  "Ekon GmbH - myGEKKO",
	[3]byte{172, 17, 211}:  "Suzhou HOTEK  Video Technology Co. Ltd",
	[3]byte{172, 20, 97}:   "ATAW  Co., Ltd.",
	[3]byte{172, 20, 210}:  "wi-daq, inc.",
	[3]byte{172, 22, 45}:   "Hewlett Packard",
	[3]byte{172, 23, 2}:    "Fibar Group sp. z o.o.",
	[3]byte{172, 24, 38}:   "SEIKO EPSON CORPORATION",
	[3]byte{172, 25, 159}:  "SUNGROW POWER SUPPLY CO.,LTD.",
	[3]byte{172, 32, 170}:  "DMATEK Co., Ltd.",
	[3]byte{172, 34, 11}:   "ASUSTek COMPUTER INC.",
	[3]byte{172, 45, 163}:  "TXTR GmbH",
	[3]byte{172, 47, 168}:  "Humannix Co.,Ltd.",
	[3]byte{172, 49, 157}:  "Shenzhen TG-NET Botone Technology Co.,Ltd.",
	[3]byte{172, 52, 203}:  "Shanhai GBCOM Communication Technology Co. Ltd",
	[3]byte{172, 54, 19}:   "Samsung Electronics Co.,Ltd",
	[3]byte{172, 56, 112}:  "Lenovo Mobile Communication Technology Ltd.",
	[3]byte{172, 58, 122}:  "Roku",
	[3]byte{172, 60, 11}:   "Apple",
	[3]byte{172, 60, 180}:  "Nilan A/S",
	[3]byte{172, 61, 5}:    "Instorescreen Aisa",
	[3]byte{172, 61, 117}:  "HANGZHOU ZHIWAY TECHNOLOGIES CO.,LTD.",
	[3]byte{172, 63, 164}:  "TAIYO YUDEN CO.,LTD",
	[3]byte{172, 64, 234}:  "C&T Solution Inc.",
	[3]byte{172, 65, 34}:   "Eclipse Electronic Systems Inc.",
	[3]byte{172, 68, 242}:  "Revolabs Inc",
	[3]byte{172, 71, 35}:   "Genelec",
	[3]byte{172, 74, 254}:  "Hisense Broadband Multimedia Technology Co.,Ltd.",
	[3]byte{172, 75, 200}:  "Juniper Networks",
	[3]byte{172, 78, 145}:  "HUAWEI TECHNOLOGIES CO.,LTD",
	[3]byte{172, 79, 252}:  "SVS-VISTEK GmbH",
	[3]byte{172, 80, 54}:   "Pi-Coral Inc",
	[3]byte{172, 81, 53}:   "MPI TECH",
	[3]byte{172, 81, 238}:  "Cambridge Communication Systems Ltd",
	[3]byte{172, 84, 236}:  "IEEE P1823 Standards Working Group",
	[3]byte{172, 88, 59}:   "Human Assembler, Inc.",
	[3]byte{172, 93, 16}:   "Pace Americas",
	[3]byte{172, 94, 140}:  "Utillink",
	[3]byte{172, 97, 35}:   "Drivven, Inc.",
	[3]byte{172, 103, 6}:   "Ruckus Wireless",
	[3]byte{172, 107, 172}: "Jenny Science AG",
	[3]byte{172, 110, 26}:  "Shenzhen Gongjin Electronics Co.,Ltd",
	[3]byte{172, 111, 79}:  "Enspert Inc",
	[3]byte{172, 111, 187}: "TATUNG Technology Inc.",
	[3]byte{172, 111, 217}: "Valueplus Inc.",
	[3]byte{172, 114, 54}:  "Lexking Technology Co., Ltd.",
	[3]byte{172, 114, 137}: "Intel Corporate",
	[3]byte{172, 122, 66}:  "iConnectivity",
	[3]byte{172, 123, 161}: "Intel Corporate",
	[3]byte{172, 127, 62}:  "Apple",
	[3]byte{172, 128, 214}: "Hexatronic AB",
	[3]byte{172, 129, 18}:  "Gemtek Technology Co., Ltd.",
	[3]byte{172, 129, 243}: "Nokia Corporation",
	[3]byte{172, 131, 23}:  "Shenzhen Furtunetel Communication Co., Ltd",
	[3]byte{172, 131, 240}: "ImmediaTV Corporation",
	[3]byte{172, 133, 61}:  "HUAWEI TECHNOLOGIES CO.,LTD",
	[3]byte{172, 134, 116}: "Open Mesh, Inc.",
	[3]byte{172, 134, 126}: "Create New Technology (HK) Limited Company",
	[3]byte{172, 135, 163}: "Apple",
	[3]byte{172, 138, 205}: "ROGER D.Wensker, G.Wensker sp.j.",
	[3]byte{172, 141, 20}:  "Smartrove Inc",
	[3]byte{172, 147, 47}:  "Nokia Corporation",
	[3]byte{172, 148, 3}:   "Envision Peripherals Inc",
	[3]byte{172, 154, 150}: "Lantiq Deutschland GmbH",
	[3]byte{172, 155, 132}: "Smak Tecnologia e Automacao",
	[3]byte{172, 156, 228}: "Alcatel-Lucent Shanghai Bell Co., Ltd",
	[3]byte{172, 160, 22}:  "CISCO SYSTEMS, INC.",
	[3]byte{172, 162, 19}:  "Shenzhen Bilian electronic CO.,LTD",
	[3]byte{172, 162, 44}:  "Baycity Technologies Ltd",
	[3]byte{172, 163, 30}:  "Aruba Networks",
	[3]byte{172, 164, 48}:  "Peerless AV",
	[3]byte{172, 169, 25}:  "TrekStor GmbH",
	[3]byte{172, 169, 160}: "Audioengine, Ltd.",
	[3]byte{172, 171, 141}: "Lyngso Marine A/S",
	[3]byte{172, 179, 19}:  "ARRIS Group, Inc.",
	[3]byte{172, 183, 79}:  "METEL s.r.o.",
	[3]byte{172, 184, 89}:  "Uniband Electronic Corp,",
	[3]byte{172, 189, 11}:  "IMAC CO.,LTD",
	[3]byte{172, 190, 117}: "Ufine Technologies Co.,Ltd.",
	[3]byte{172, 190, 182}: "Visualedge Technology Co., Ltd.",
	[3]byte{172, 194, 236}: "CLT INT'L IND. CORP.",
	[3]byte{172, 197, 149}: "Graphite Systems",
	[3]byte{172, 198, 152}: "Kohzu Precision Co., Ltd.",
	[3]byte{172, 201, 53}:  "Ness Corporation",
	[3]byte{172, 202, 84}:  "Telldus Technologies AB",
	[3]byte{172, 202, 142}: "ODA Technologies",
	[3]byte{172, 202, 186}: "Midokura Co., Ltd.",
	[3]byte{172, 203, 9}:   "Hefcom Metering (Pty) Ltd",
	[3]byte{172, 204, 142}: "Axis Communications AB",
	[3]byte{172, 206, 143}: "HWA YAO TECHNOLOGIES CO., LTD",
	[3]byte{172, 207, 35}:  "Hi-flying electronics technology Co.,Ltd",
	[3]byte{172, 207, 92}:  "Apple",
	[3]byte{172, 209, 128}: "Crexendo Business Solutions, Inc.",
	[3]byte{172, 211, 100}: "ABB SPA, ABB SACE DIV.",
	[3]byte{172, 214, 87}:  "Shaanxi Guolian Digital TV Technology Co., Ltd.",
	[3]byte{172, 217, 214}: "tci GmbH",
	[3]byte{172, 219, 218}: "Shenzhen Geniatech Inc, Ltd",
	[3]byte{172, 222, 72}:  "PRIVATE",
	[3]byte{172, 224, 105}: "ISAAC Instruments",
	[3]byte{172, 226, 21}:  "Huawei Technologies Co., Ltd",
	[3]byte{172, 227, 72}:  "MadgeTech, Inc",
	[3]byte{172, 228, 46}:  "SK hynix",
	[3]byte{172, 230, 75}:  "Shenzhen Baojia Battery Technology Co., Ltd.",
	[3]byte{172, 232, 123}: "Huawei Technologies Co., Ltd",
	[3]byte{172, 232, 126}: "Bytemark Computer Consulting Ltd",
	[3]byte{172, 233, 127}: "IoT Tech Limited",
	[3]byte{172, 233, 170}: "Hay Systems Ltd",
	[3]byte{172, 234, 106}: "GENIX INFOCOMM CO., LTD.",
	[3]byte{172, 238, 59}:  "6harmonics Inc",
	[3]byte{172, 240, 178}: "Becker Electronics Taiwan Ltd.",
	[3]byte{172, 241, 223}: "D-Link International",
	[3]byte{172, 242, 197}: "Cisco",
	[3]byte{172, 247, 243}: "XIAOMI CORPORATION",
	[3]byte{172, 249, 126}: "ELESYS INC.",
	[3]byte{172, 253, 206}: "Intel Corporate",
	[3]byte{172, 253, 236}: "Apple, Inc",
	[3]byte{176, 0, 180}:   "Cisco",
	[3]byte{176, 5, 148}:   "Liteon Technology Corporation",
	[3]byte{176, 9, 211}:   "Avizia",
	[3]byte{176, 16, 65}:   "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{176, 18, 3}:    "Dynamics Hong Kong Limited",
	[3]byte{176, 18, 102}:  "Futaba-Kikaku",
	[3]byte{176, 20, 8}:    "LIGHTSPEED INTERNATIONAL CO.",
	[3]byte{176, 23, 67}:   "EDISON GLOBAL CIRCUITS LLC",
	[3]byte{176, 27, 124}:  "Ontrol A.S.",
	[3]byte{176, 28, 145}:  "Elim Co",
	[3]byte{176, 31, 129}:  "IEEE REGISTRATION AUTHORITY  - Please see MAM public listing for more information.",
	[3]byte{176, 36, 243}:  "Progeny Systems",
	[3]byte{176, 37, 170}:  "PRIVATE",
	[3]byte{176, 52, 149}:  "Apple",
	[3]byte{176, 53, 141}:  "Nokia Corporation",
	[3]byte{176, 56, 41}:   "Siliconware Precision Industries Co., Ltd.",
	[3]byte{176, 56, 80}:   "Nanjing CAS-ZDC IOT SYSTEM CO.,LTD",
	[3]byte{176, 67, 93}:   "NuLEDs, Inc.",
	[3]byte{176, 69, 21}:   "mira fitness,LLC.",
	[3]byte{176, 69, 25}:   "TCT mobile ltd",
	[3]byte{176, 69, 69}:   "YACOUB Automation GmbH",
	[3]byte{176, 70, 252}:  "MitraStar Technology Corp.",
	[3]byte{176, 72, 122}:  "TP-LINK TECHNOLOGIES CO., LTD.",
	[3]byte{176, 76, 5}:    "Fresenius Medical Care Deutschland GmbH",
	[3]byte{176, 80, 188}:  "SHENZHEN BASICOM ELECTRONIC CO.,LTD.",
	[3]byte{176, 81, 142}:  "Holl technology CO.Ltd.",
	[3]byte{176, 87, 6}:    "Vallox Oy",
	[3]byte{176, 88, 196}:  "Broadcast Microwave Services, Inc",
	[3]byte{176, 91, 31}:   "THERMO FISHER SCIENTIFIC S.P.A.",
	[3]byte{176, 91, 103}:  "Huawei Technologies Co., Ltd",
	[3]byte{176, 92, 229}:  "Nokia Corporation",
	[3]byte{176, 97, 199}:  "Ericsson-LG Enterprise",
	[3]byte{176, 101, 99}:  "Shanghai Railway Communication Factory",
	[3]byte{176, 101, 189}: "Apple",
	[3]byte{176, 104, 182}: "Hangzhou OYE Technology Co. Ltd",
	[3]byte{176, 105, 113}: "DEI Sales, Inc.",
	[3]byte{176, 108, 191}: "3ality Digital Systems GmbH",
	[3]byte{176, 117, 12}:  "QA Cafe",
	[3]byte{176, 117, 77}:  "Alcatel-Lucent",
	[3]byte{176, 117, 213}: "ZTE Corporation",
	[3]byte{176, 119, 172}: "ARRIS Group, Inc.",
	[3]byte{176, 121, 8}:   "Cummings Engineering",
	[3]byte{176, 121, 60}:  "Revolv Inc",
	[3]byte{176, 121, 148}: "Motorola Mobility LLC",
	[3]byte{176, 125, 98}:  "Dipl.-Ing. H. Horstmann GmbH",
	[3]byte{176, 128, 140}: "Laser Light Engines",
	[3]byte{176, 129, 216}: "I-sys Corp",
	[3]byte{176, 131, 254}: "Dell Inc",
	[3]byte{176, 134, 158}: "Chloride S.r.L",
	[3]byte{176, 136, 7}:   "Strata Worldwide",
	[3]byte{176, 137, 145}: "LGE",
	[3]byte{176, 142, 26}:  "URadio Systems Co., Ltd",
	[3]byte{176, 144, 116}: "Fulan Electronics Limited",
	[3]byte{176, 145, 52}:  "Taleo",
	[3]byte{176, 145, 55}:  "ISis ImageStream Internet Solutions, Inc",
	[3]byte{176, 151, 58}:  "E-Fuel Corporation",
	[3]byte{176, 152, 159}: "LG CNS",
	[3]byte{176, 153, 40}:  "Fujitsu Limited",
	[3]byte{176, 154, 226}: "STEMMER IMAGING GmbH",
	[3]byte{176, 155, 212}: "GNH Software India Private Limited",
	[3]byte{176, 159, 186}: "Apple",
	[3]byte{176, 161, 10}:  "Pivotal Systems Corporation",
	[3]byte{176, 163, 126}: "Qingdao Haier Electronics Co.,Ltd",
	[3]byte{176, 167, 42}:  "Ensemble Designs, Inc.",
	[3]byte{176, 167, 55}:  "Roku, Inc.",
	[3]byte{176, 168, 110}: "Juniper Networks",
	[3]byte{176, 170, 54}:  "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD.",
	[3]byte{176, 172, 250}: "Fujitsu Limited",
	[3]byte{176, 173, 170}: "Avaya, Inc",
	[3]byte{176, 178, 220}: "Zyxel Communications Corporation",
	[3]byte{176, 179, 43}:  "Slican Sp. z o.o.",
	[3]byte{176, 180, 72}:  "Texas Instruments",
	[3]byte{176, 184, 213}: "Nanjing Nengrui Auto Equipment CO.,Ltd",
	[3]byte{176, 189, 109}: "Echostreams Innovative Solutions",
	[3]byte{176, 189, 161}: "ZAKLAD ELEKTRONICZNY SIMS",
	[3]byte{176, 191, 153}: "WIZITDONGDO",
	[3]byte{176, 196, 231}: "Samsung Electronics",
	[3]byte{176, 197, 84}:  "D-Link International",
	[3]byte{176, 198, 154}: "Juniper Networks",
	[3]byte{176, 199, 69}:  "Buffalo Inc.",
	[3]byte{176, 200, 63}:  "Jiangsu Cynray IOT Co., Ltd.",
	[3]byte{176, 200, 173}: "People Power Company",
	[3]byte{176, 201, 91}:  "Beijing Symtech CO.,LTD",
	[3]byte{176, 206, 24}:  "Zhejiang shenghui lighting co.,Ltd",
	[3]byte{176, 207, 77}:  "MI-Zone Technology Ireland",
	[3]byte{176, 208, 156}: "Samsung Electronics Co.,Ltd",
	[3]byte{176, 210, 245}: "Vello Systems, Inc.",
	[3]byte{176, 213, 157}: "Shenzhen Zowee Technology Co., Ltd",
	[3]byte{176, 215, 197}: "STP KFT",
	[3]byte{176, 218, 0}:   "CERA ELECTRONIQUE",
	[3]byte{176, 223, 58}:  "Samsung Electronics Co.,Ltd",
	[3]byte{176, 227, 157}: "CAT SYSTEM CO.,LTD.",
	[3]byte{176, 229, 14}:  "NRG SYSTEMS INC",
	[3]byte{176, 231, 84}:  "2Wire",
	[3]byte{176, 232, 146}: "SEIKO EPSON CORPORATION",
	[3]byte{176, 233, 126}: "Advanced Micro Peripherals",
	[3]byte{176, 236, 113}: "Samsung Electronics Co.,Ltd",
	[3]byte{176, 236, 143}: "GMX SAS",
	[3]byte{176, 238, 69}:  "AzureWave Technologies, Inc.",
	[3]byte{176, 241, 188}: "Dhemax Ingenieros Ltda",
	[3]byte{176, 250, 235}: "Cisco",
	[3]byte{176, 254, 189}: "PRIVATE",
	[3]byte{180, 0, 156}:   "CableWorld Ltd.",
	[3]byte{180, 1, 66}:    "GCI Science & Technology Co.,LTD",
	[3]byte{180, 4, 24}:    "Smartchip Integrated Inc.",
	[3]byte{180, 7, 249}:   "SAMSUNG ELECTRO-MECHANICS",
	[3]byte{180, 8, 50}:    "TC Communications",
	[3]byte{180, 10, 198}:  "DEXON Systems Ltd.",
	[3]byte{180, 11, 68}:   "Smartisan Technology Co., Ltd.",
	[3]byte{180, 11, 122}:  "Brusa Elektronik AG",
	[3]byte{180, 12, 37}:   "Palo Alto Networks",
	[3]byte{180, 14, 150}:  "HERAN",
	[3]byte{180, 14, 220}:  "LG-Ericsson Co.,Ltd.",
	[3]byte{180, 20, 137}:  "CISCO SYSTEMS, INC.",
	[3]byte{180, 21, 19}:   "HUAWEI TECHNOLOGIES CO.,LTD",
	[3]byte{180, 23, 128}:  "DTI Group Ltd",
	[3]byte{180, 24, 209}:  "Apple",
	[3]byte{180, 29, 239}:  "Internet Laboratories, Inc.",
	[3]byte{180, 33, 29}:   "Beijing GuangXin Technology Co., Ltd",
	[3]byte{180, 33, 138}:  "Dog Hunter LLC",
	[3]byte{180, 36, 231}:  "Codetek Technology Co.,Ltd",
	[3]byte{180, 40, 241}:  "E-Prime Co., Ltd.",
	[3]byte{180, 42, 57}:   "ORBIT MERRET, spol. s r. o.",
	[3]byte{180, 44, 146}:  "Zhejiang Weirong Electronic Co., Ltd",
	[3]byte{180, 44, 190}:  "Direct Payment Solutions Limited",
	[3]byte{180, 49, 184}:  "Aviwest",
	[3]byte{180, 52, 108}:  "MATSUNICHI DIGITAL TECHNOLOGY (HONG KONG) LIMITED",
	[3]byte{180, 53, 100}:  "Fujian Tian Cheng Electron Science & Technical Development Co.,Ltd.",
	[3]byte{180, 53, 247}:  "Zhejiang Pearmain Electronics Co.ltd.",
	[3]byte{180, 55, 65}:   "Consert, Inc.",
	[3]byte{180, 57, 52}:   "Pen Generations, Inc.",
	[3]byte{180, 57, 214}:  "ProCurve Networking by HP",
	[3]byte{180, 58, 40}:   "Samsung Electronics Co.,Ltd",
	[3]byte{180, 61, 178}:  "Degreane Horizon",
	[3]byte{180, 62, 59}:   "Viableware, Inc",
	[3]byte{180, 65, 122}:  "ShenZhen Gongjin Electronics Co.,Ltd",
	[3]byte{180, 67, 13}:   "Broadlink Pty Ltd",
	[3]byte{180, 71, 94}:   "Avaya, Inc",
	[3]byte{180, 76, 194}:  "NR ELECTRIC CO., LTD",
	[3]byte{180, 81, 249}:  "NB Software",
	[3]byte{180, 82, 83}:   "Seagate Technology",
	[3]byte{180, 82, 125}:  "Sony Mobile Communications AB",
	[3]byte{180, 82, 126}:  "Sony Mobile Communications AB",
	[3]byte{180, 85, 112}:  "Borea",
	[3]byte{180, 88, 97}:   "CRemote, LLC",
	[3]byte{180, 92, 164}:  "Thing-talk Wireless Communication Technologies Corporation Limited",
	[3]byte{180, 97, 255}:  "Lumigon A/S",
	[3]byte{180, 98, 56}:   "Exablox",
	[3]byte{180, 98, 147}:  "Samsung Electronics Co.,Ltd",
	[3]byte{180, 98, 173}:  "raytest GmbH",
	[3]byte{180, 102, 152}: "Zealabs srl",
	[3]byte{180, 103, 233}: "Qingdao GoerTek Technology Co., Ltd.",
	[3]byte{180, 116, 159}: "askey computer corp",
	[3]byte{180, 117, 14}:  "Belkin International Inc.",
	[3]byte{180, 121, 167}: "Samsung Electro Mechanics co., LTD.",
	[3]byte{180, 124, 41}:  "Shenzhen Guzidi Technology Co.,Ltd",
	[3]byte{180, 127, 94}:  "Foresight Manufacture (S) Pte Ltd",
	[3]byte{180, 130, 85}:  "Research Products Corporation",
	[3]byte{180, 130, 123}: "AKG Acoustics GmbH",
	[3]byte{180, 130, 197}: "Relay2, Inc.",
	[3]byte{180, 130, 254}: "Askey Computer Corp",
	[3]byte{180, 133, 71}:  "Amptown System Company GmbH",
	[3]byte{180, 137, 16}:  "Coster T.E. S.P.A.",
	[3]byte{180, 148, 78}:  "WeTelecom Co., Ltd.",
	[3]byte{180, 152, 66}:  "zte corporation",
	[3]byte{180, 153, 76}:  "Texas Instruments",
	[3]byte{180, 153, 186}: "Hewlett-Packard Company",
	[3]byte{180, 157, 180}: "Axion Technologies Inc.",
	[3]byte{180, 158, 172}: "Imagik Int'l Corp",
	[3]byte{180, 158, 230}: "SHENZHEN TECHNOLOGY CO LTD",
	[3]byte{180, 164, 181}: "Zen Eye Co.,Ltd",
	[3]byte{180, 164, 227}: "CISCO SYSTEMS, INC.",
	[3]byte{180, 165, 169}: "MODI GmbH",
	[3]byte{180, 168, 40}:  "Shenzhen Concox Information Technology Co., Ltd",
	[3]byte{180, 168, 43}:  "Histar Digital Electronics Co., Ltd.",
	[3]byte{180, 169, 90}:  "Avaya, Inc",
	[3]byte{180, 170, 77}:  "Ensequence, Inc.",
	[3]byte{180, 171, 44}:  "MtM Technology Corporation",
	[3]byte{180, 174, 111}: "Circle Reliance, Inc.",
	[3]byte{180, 176, 23}:  "Avaya, Inc",
	[3]byte{180, 179, 98}:  "ZTE Corporation",
	[3]byte{180, 181, 47}:  "Hewlett Packard",
	[3]byte{180, 181, 66}:  "Hubbell Power Systems, Inc.",
	[3]byte{180, 181, 175}: "Minsung Electronics",
	[3]byte{180, 182, 118}: "Intel Corporate",
	[3]byte{180, 184, 89}:  "Texa Spa",
	[3]byte{180, 184, 141}: "Thuh Company",
	[3]byte{180, 196, 78}:  "VXL eTech Pvt Ltd",
	[3]byte{180, 199, 153}: "Motorola Solutions Inc.",
	[3]byte{180, 200, 16}:  "UMPI Elettronica",
	[3]byte{180, 204, 233}: "PROSYST",
	[3]byte{180, 206, 246}: "HTC Corporation",
	[3]byte{180, 207, 219}: "Shenzhen Jiuzhou Electric Co.,LTD",
	[3]byte{180, 216, 169}: "BetterBots",
	[3]byte{180, 216, 222}: "iota Computing, Inc.",
	[3]byte{180, 221, 21}:  "ControlThings Oy Ab",
	[3]byte{180, 223, 59}:  "Chromlech",
	[3]byte{180, 223, 250}: "Litemax Electronics Inc.",
	[3]byte{180, 224, 205}: "Fusion-io, Inc",
	[3]byte{180, 225, 235}: "PRIVATE",
	[3]byte{180, 233, 176}: "Cisco",
	[3]byte{180, 237, 25}:  "Pie Digital, Inc.",
	[3]byte{180, 237, 84}:  "Wohler Technologies",
	[3]byte{180, 238, 180}: "ASKEY COMPUTER CORP",
	[3]byte{180, 238, 212}: "Texas Instruments",
	[3]byte{180, 240, 171}: "Apple",
	[3]byte{180, 242, 232}: "Pace plc",
	[3]byte{180, 243, 35}:  "PETATEL INC.",
	[3]byte{180, 252, 117}: "SEMA Electronics(HK) CO.,LTD",
	[3]byte{180, 254, 140}: "Centro Sicurezza Italia SpA",
	[3]byte{184, 3, 5}:     "Intel Corporate",
	[3]byte{184, 4, 21}:    "Bayan Audio",
	[3]byte{184, 8, 207}:   "Intel Corporate",
	[3]byte{184, 11, 157}:  "ROPEX Industrie-Elektronik GmbH",
	[3]byte{184, 20, 19}:   "Keen High Holding(HK) Ltd.",
	[3]byte{184, 22, 25}:   "ARRIS Group, Inc.",
	[3]byte{184, 23, 194}:  "Apple",
	[3]byte{184, 24, 111}:  "ORIENTAL MOTOR CO., LTD.",
	[3]byte{184, 25, 153}:  "Nesys",
	[3]byte{184, 32, 231}:  "Guangzhou Horizontal Information & Network Integration Co. Ltd",
	[3]byte{184, 36, 16}:   "Magneti Marelli Slovakia s.r.o.",
	[3]byte{184, 36, 26}:   "SWEDA INFORMATICA LTDA",
	[3]byte{184, 38, 108}:  "ANOV France",
	[3]byte{184, 38, 212}:  "Furukawa Industrial S.A. Produtos Elétricos",
	[3]byte{184, 39, 235}:  "Raspberry Pi Foundation",
	[3]byte{184, 40, 139}:  "Parker Hannifin",
	[3]byte{184, 41, 247}:  "Blaster Tech",
	[3]byte{184, 42, 114}:  "Dell Inc",
	[3]byte{184, 42, 220}:  "EFR Europäische Funk-Rundsteuerung GmbH",
	[3]byte{184, 44, 160}:  "Honeywell HomMed",
	[3]byte{184, 48, 168}:  "Road-Track Telematics Development",
	[3]byte{184, 54, 216}:  "Videoswitch",
	[3]byte{184, 56, 97}:   "Cisco",
	[3]byte{184, 56, 202}:  "Kyokko Tsushin System CO.,LTD",
	[3]byte{184, 58, 123}:  "Worldplay (Canada) Inc.",
	[3]byte{184, 61, 78}:   "Shenzhen Cultraview Digital Technology Co.,Ltd Shanghai Branch",
	[3]byte{184, 62, 89}:   "Roku, Inc",
	[3]byte{184, 65, 95}:   "ASP AG",
	[3]byte{184, 67, 228}:  "Vlatacom",
	[3]byte{184, 71, 198}:  "SanJet Technology Corp.",
	[3]byte{184, 79, 213}:  "Microsoft Corporation",
	[3]byte{184, 85, 16}:   "Zioncom Electronics (Shenzhen) Ltd.",
	[3]byte{184, 88, 16}:   "NUMERA, INC.",
	[3]byte{184, 90, 247}:  "Ouya, Inc",
	[3]byte{184, 90, 254}:  "Handaer Communication Technology (Beijing) Co., Ltd",
	[3]byte{184, 94, 123}:  "Samsung Electronics Co.,Ltd",
	[3]byte{184, 96, 145}:  "Onnet Technologies and Innovations LLC",
	[3]byte{184, 97, 111}:  "Accton Wireless Broadband(AWB), Corp.",
	[3]byte{184, 98, 31}:   "CISCO SYSTEMS, INC.",
	[3]byte{184, 99, 188}:  "ROBOTIS, Co, Ltd",
	[3]byte{184, 100, 145}: "CK Telecom Ltd",
	[3]byte{184, 101, 59}:  "Bolymin, Inc.",
	[3]byte{184, 107, 35}:  "Toshiba",
	[3]byte{184, 108, 232}: "Samsung Electronics Co.,Ltd",
	[3]byte{184, 112, 244}: "COMPAL INFORMATION (KUNSHAN) CO., LTD.",
	[3]byte{184, 116, 36}:  "Viessmann Elektronik GmbH",
	[3]byte{184, 116, 71}:  "Convergence Technologies",
	[3]byte{184, 117, 192}: "PayPal, Inc.",
	[3]byte{184, 118, 63}:  "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{184, 119, 195}: "Decagon Devices, Inc.",
	[3]byte{184, 120, 46}:  "Apple",
	[3]byte{184, 121, 126}: "Secure Meters (UK) Limited",
	[3]byte{184, 122, 201}: "Siemens Ltd.",
	[3]byte{184, 124, 242}: "Aerohive Networks Inc.",
	[3]byte{184, 135, 30}:  "Good Mind Industries Co., Ltd.",
	[3]byte{184, 135, 168}: "Step Ahead Innovations Inc.",
	[3]byte{184, 136, 227}: "COMPAL INFORMATION (KUNSHAN) CO., LTD",
	[3]byte{184, 137, 202}: "ILJIN ELECTRIC Co., Ltd.",
	[3]byte{184, 138, 96}:  "Intel Corporate",
	[3]byte{184, 141, 18}:  "Apple",
	[3]byte{184, 142, 58}:  "Infinite Technologies JLT",
	[3]byte{184, 143, 20}:  "Analytica GmbH",
	[3]byte{184, 146, 29}:  "BG T&A",
	[3]byte{184, 148, 210}: "Retail Innovation HTT AB",
	[3]byte{184, 150, 116}: "AllDSP GmbH & Co. KG",
	[3]byte{184, 151, 90}:  "BIOSTAR Microtech Int'l Corp.",
	[3]byte{184, 152, 176}: "Atlona Inc.",
	[3]byte{184, 152, 247}: "Gionee Communication Equipment Co,Ltd.ShenZhen",
	[3]byte{184, 153, 25}:  "7signal Solutions, Inc",
	[3]byte{184, 154, 237}: "OceanServer Technology, Inc",
	[3]byte{184, 155, 201}: "SMC Networks Inc",
	[3]byte{184, 155, 228}: "ABB Power Systems Power Generation",
	[3]byte{184, 163, 134}: "D-Link International",
	[3]byte{184, 163, 224}: "BenRui Technology Co.,Ltd",
	[3]byte{184, 168, 175}: "Logic S.p.A.",
	[3]byte{184, 172, 111}: "Dell Inc",
	[3]byte{184, 173, 62}:  "BLUECOM",
	[3]byte{184, 174, 110}: "Nintendo Co., Ltd.",
	[3]byte{184, 174, 237}: "Elitegroup Computer Systems Co., Ltd.",
	[3]byte{184, 175, 103}: "Hewlett-Packard Company",
	[3]byte{184, 177, 199}: "BT&COM CO.,LTD",
	[3]byte{184, 180, 46}:  "Gionee Communication Equipment Co,Ltd.ShenZhen",
	[3]byte{184, 183, 215}: "2GIG Technologies",
	[3]byte{184, 185, 78}:  "Shenzhen iBaby Labs, Inc.",
	[3]byte{184, 186, 104}: "Xi'an Jizhong Digital Communication Co.,Ltd",
	[3]byte{184, 186, 114}: "Cynove",
	[3]byte{184, 187, 109}: "ENERES Co.,Ltd.",
	[3]byte{184, 189, 121}: "TrendPoint Systems",
	[3]byte{184, 190, 191}: "CISCO SYSTEMS, INC.",
	[3]byte{184, 191, 131}: "Intel Corporate",
	[3]byte{184, 193, 162}: "Dragon Path Technologies Co., Limited",
	[3]byte{184, 196, 111}: "PRIMMCON INDUSTRIES INC",
	[3]byte{184, 198, 142}: "Samsung Electronics Co.,Ltd",
	[3]byte{184, 199, 22}:  "Fiberhome Telecommunication Technologies Co.,LTD",
	[3]byte{184, 199, 93}:  "Apple",
	[3]byte{184, 200, 85}:  "Shanghai GBCOM Communication Technology Co.,Ltd.",
	[3]byte{184, 202, 58}:  "Dell Inc",
	[3]byte{184, 205, 147}: "Penetek, Inc",
	[3]byte{184, 205, 167}: "Maxeler Technologies Ltd.",
	[3]byte{184, 208, 111}: "GUANGZHOU HKUST FOK YING TUNG RESEARCH INSTITUTE",
	[3]byte{184, 212, 157}: "M Seven System Ltd.",
	[3]byte{184, 216, 18}:  "IEEE REGISTRATION AUTHORITY  - Please see MAM public listing for more information.",
	[3]byte{184, 217, 206}: "Samsung Electronics",
	[3]byte{184, 218, 241}: "Strahlenschutz- Entwicklungs- und Ausruestungsgesellschaft mbH",
	[3]byte{184, 218, 247}: "Advanced Photonics, Inc.",
	[3]byte{184, 220, 135}: "IAI Corporation",
	[3]byte{184, 223, 107}: "SpotCam Co., Ltd.",
	[3]byte{184, 229, 137}: "Payter BV",
	[3]byte{184, 230, 37}:  "2Wire",
	[3]byte{184, 231, 121}: "9Solutions Oy",
	[3]byte{184, 232, 86}:  "Apple",
	[3]byte{184, 233, 55}:  "Sonos, Inc.",
	[3]byte{184, 238, 101}: "Liteon Technology Corporation",
	[3]byte{184, 238, 121}: "YWire Technologies, Inc.",
	[3]byte{184, 243, 23}:  "iSun Smasher Communications Private Limited",
	[3]byte{184, 244, 208}: "Herrmann Ultraschalltechnik GmbH & Co. Kg",
	[3]byte{184, 245, 231}: "WayTools, LLC",
	[3]byte{184, 246, 177}: "Apple",
	[3]byte{184, 247, 50}:  "Aryaka Networks Inc",
	[3]byte{184, 248, 40}:  "Changshu Gaoshida Optoelectronic Technology Co. Ltd.",
	[3]byte{184, 249, 52}:  "Sony Ericsson Mobile Communications AB",
	[3]byte{184, 253, 50}:  "Zhejiang ROICX Microelectronics",
	[3]byte{184, 255, 97}:  "Apple",
	[3]byte{184, 255, 111}: "Shanghai Typrotech Technology Co.Ltd",
	[3]byte{184, 255, 254}: "Texas Instruments",
	[3]byte{188, 2, 0}:     "Stewart Audio",
	[3]byte{188, 5, 67}:    "AVM GmbH",
	[3]byte{188, 13, 165}:  "Texas Instruments",
	[3]byte{188, 15, 43}:   "FORTUNE TECHGROUP CO.,LTD",
	[3]byte{188, 18, 94}:   "Beijing  WisVideo  INC.",
	[3]byte{188, 20, 1}:    "Hitron Technologies. Inc",
	[3]byte{188, 20, 239}:  "ITON Technology Limited",
	[3]byte{188, 21, 166}:  "Taiwan Jantek Electronics,Ltd.",
	[3]byte{188, 22, 101}:  "Cisco",
	[3]byte{188, 22, 245}:  "Cisco",
	[3]byte{188, 26, 103}:  "YF Technology Co., Ltd",
	[3]byte{188, 32, 164}:  "Samsung Electronics",
	[3]byte{188, 32, 186}:  "Inspur (Shandong) Electronic Information Co., Ltd",
	[3]byte{188, 37, 240}:  "3D Display Technologies Co., Ltd.",
	[3]byte{188, 38, 29}:   "HONG KONG TECON TECHNOLOGY",
	[3]byte{188, 40, 70}:   "NextBIT Computing Pvt. Ltd.",
	[3]byte{188, 40, 214}:  "Rowley Associates Limited",
	[3]byte{188, 43, 107}:  "Beijing Haier IC Design Co.,Ltd",
	[3]byte{188, 43, 215}:  "Revogi Innovation Co., Ltd.",
	[3]byte{188, 44, 85}:   "Bear Flag Design, Inc.",
	[3]byte{188, 45, 152}:  "ThinGlobal LLC",
	[3]byte{188, 48, 91}:   "Dell Inc.",
	[3]byte{188, 48, 125}:  "Wistron Neweb Corp.",
	[3]byte{188, 52, 0}:    "IEEE REGISTRATION AUTHORITY  - Please see MAM public listing for more information.",
	[3]byte{188, 53, 229}:  "Hydro Systems Company",
	[3]byte{188, 56, 210}:  "Pandachip Limited",
	[3]byte{188, 57, 166}:  "CSUN System Technology Co.,LTD",
	[3]byte{188, 59, 175}:  "Apple",
	[3]byte{188, 62, 19}:   "Accordance Systems Inc.",
	[3]byte{188, 65, 0}:    "Codaco Electronic s.r.o.",
	[3]byte{188, 67, 119}:  "Hang Zhou Huite Technology Co.,ltd.",
	[3]byte{188, 68, 134}:  "Samsung Electronics Co.,Ltd",
	[3]byte{188, 71, 96}:   "Samsung Electronics Co.,Ltd",
	[3]byte{188, 75, 121}:  "SensingTek",
	[3]byte{188, 77, 251}:  "Hitron Technologies. Inc",
	[3]byte{188, 78, 60}:   "CORE STAFF CO., LTD.",
	[3]byte{188, 78, 93}:   "ZhongMiao Technology Co., Ltd.",
	[3]byte{188, 81, 254}:  "Swann Communications Pty Ltd",
	[3]byte{188, 82, 180}:  "Alcatel-Lucent",
	[3]byte{188, 82, 183}:  "Apple",
	[3]byte{188, 95, 244}:  "ASRock Incorporation",
	[3]byte{188, 98, 159}:  "Telenet Systems P. Ltd.",
	[3]byte{188, 102, 65}:  "IEEE REGISTRATION AUTHORITY  - Please see MAM public listing for more information.",
	[3]byte{188, 103, 28}:  "Cisco",
	[3]byte{188, 103, 120}: "Apple",
	[3]byte{188, 103, 132}: "Environics Oy",
	[3]byte{188, 106, 22}:  "tdvine",
	[3]byte{188, 106, 41}:  "Texas Instruments",
	[3]byte{188, 107, 77}:  "Alcatel-Lucent",
	[3]byte{188, 110, 118}: "Green Energy Options Ltd",
	[3]byte{188, 113, 193}: "XTrillion, Inc.",
	[3]byte{188, 114, 177}: "Samsung Electronics Co.,Ltd",
	[3]byte{188, 116, 215}: "HangZhou JuRu Technology CO.,LTD",
	[3]byte{188, 118, 78}:  "Rackspace US, Inc.",
	[3]byte{188, 118, 112}: "Shenzhen Huawei Communication Technologies Co., Ltd",
	[3]byte{188, 119, 55}:  "Intel Corporate",
	[3]byte{188, 119, 159}: "SBM Co., Ltd.",
	[3]byte{188, 121, 173}: "Samsung Electronics Co.,Ltd",
	[3]byte{188, 125, 209}: "Radio Data Comms",
	[3]byte{188, 129, 31}:  "Ingate Systems",
	[3]byte{188, 129, 153}: "BASIC Co.,Ltd.",
	[3]byte{188, 131, 167}: "SHENZHEN CHUANGWEI-RGB ELECTRONICS CO.,LT",
	[3]byte{188, 133, 31}:  "Samsung Electronics",
	[3]byte{188, 133, 86}:  "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{188, 136, 147}: "VILLBAU Ltd.",
	[3]byte{188, 139, 85}:  "NPP ELIKS America Inc. DBA T&M Atlantic",
	[3]byte{188, 140, 205}: "Samsung Electro Mechanics co.,LTD.",
	[3]byte{188, 141, 14}:  "Alcatel-Lucent",
	[3]byte{188, 146, 107}: "Apple",
	[3]byte{188, 150, 128}: "Shenzhen Gongjin Electronics Co.,Ltd",
	[3]byte{188, 152, 137}: "Fiberhome Telecommunication Tech.Co.,Ltd.",
	[3]byte{188, 153, 188}: "FonSee Technology Inc.",
	[3]byte{188, 156, 197}: "Beijing Huafei Technology Co., Ltd.",
	[3]byte{188, 157, 165}: "DASCOM Europe GmbH",
	[3]byte{188, 164, 225}: "Nabto",
	[3]byte{188, 169, 214}: "Cyber-Rain, Inc.",
	[3]byte{188, 174, 197}: "ASUSTek COMPUTER INC.",
	[3]byte{188, 177, 129}: "SHARP CORPORATION",
	[3]byte{188, 177, 243}: "Samsung Electronics",
	[3]byte{188, 184, 82}:  "Cybera, Inc.",
	[3]byte{188, 186, 225}: "AREC Inc.",
	[3]byte{188, 187, 201}: "Kellendonk Elektronik GmbH",
	[3]byte{188, 188, 70}:  "SKS Welding Systems GmbH",
	[3]byte{188, 193, 104}: "DinBox Sverige AB",
	[3]byte{188, 194, 58}:  "Thomson Video Networks",
	[3]byte{188, 195, 66}:  "Panasonic System Networks Co., Ltd.",
	[3]byte{188, 198, 26}:  "SPECTRA EMBEDDED SYSTEMS",
	[3]byte{188, 198, 219}: "Nokia Corporation",
	[3]byte{188, 200, 16}:  "Cisco SPVTG",
	[3]byte{188, 202, 181}: "ARRIS Group, Inc.",
	[3]byte{188, 205, 69}:  "VOISMART",
	[3]byte{188, 207, 204}: "HTC Corporation",
	[3]byte{188, 209, 119}: "TP-LINK TECHNOLOGIES CO.,LTD.",
	[3]byte{188, 209, 211}: "Tinno Mobile Technology Corp",
	[3]byte{188, 213, 182}: "d2d technologies",
	[3]byte{188, 217, 64}:  "ASR Co,.Ltd.",
	[3]byte{188, 224, 157}: "Eoslink",
	[3]byte{188, 229, 159}: "WATERWORLD Technology Co.,LTD",
	[3]byte{188, 234, 43}:  "CityCom GmbH",
	[3]byte{188, 234, 250}: "Hewlett Packard",
	[3]byte{188, 238, 123}: "ASUSTek COMPUTER INC.",
	[3]byte{188, 242, 175}: "devolo AG",
	[3]byte{188, 245, 172}: "LG Electronics",
	[3]byte{188, 246, 28}:  "Geomodeling Wuxi Technology Co. Ltd.",
	[3]byte{188, 246, 133}: "D-Link International",
	[3]byte{188, 254, 140}: "Altronic, LLC",
	[3]byte{188, 255, 172}: "TOPCON CORPORATION",
	[3]byte{192, 13, 126}:  "Additech, Inc.",
	[3]byte{192, 17, 166}:  "Fort-Telecom ltd.",
	[3]byte{192, 18, 66}:   "Alpha Security Products",
	[3]byte{192, 20, 61}:   "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{192, 24, 133}:  "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{192, 30, 155}:  "Pixavi AS",
	[3]byte{192, 34, 80}:   "PRIVATE",
	[3]byte{192, 37, 6}:    "AVM GmbH",
	[3]byte{192, 37, 92}:   "Cisco",
	[3]byte{192, 39, 185}:  "Beijing National Railway Research & Design Institute  of Signal & Communication Co., Ltd.",
	[3]byte{192, 41, 115}:  "Audyssey Laboratories Inc.",
	[3]byte{192, 41, 243}:  "XySystem",
	[3]byte{192, 43, 252}:  "iNES. applied informatics GmbH",
	[3]byte{192, 44, 122}:  "Shen Zhen Horn audio Co., Ltd.",
	[3]byte{192, 52, 180}:  "Gigastone Corporation",
	[3]byte{192, 53, 128}:  "A&R TECH",
	[3]byte{192, 53, 189}:  "Velocytech Aps",
	[3]byte{192, 53, 197}:  "Prosoft Systems LTD",
	[3]byte{192, 56, 150}:  "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{192, 56, 249}:  "Nokia Danmark A/S",
	[3]byte{192, 59, 143}:  "Minicom Digital Signage",
	[3]byte{192, 61, 70}:   "Shanghai Mochui Network Technology Co., Ltd",
	[3]byte{192, 62, 15}:   "BSkyB Ltd",
	[3]byte{192, 63, 14}:   "NETGEAR",
	[3]byte{192, 63, 42}:   "Biscotti, Inc.",
	[3]byte{192, 63, 213}:  "Elitegroup Computer Systems Co., LTD",
	[3]byte{192, 65, 246}:  "LG Electronics Inc",
	[3]byte{192, 67, 1}:    "Epec Oy",
	[3]byte{192, 68, 227}:  "Shenzhen Sinkna Electronics Co., LTD",
	[3]byte{192, 73, 61}:   "MAITRISE TECHNOLOGIQUE",
	[3]byte{192, 74, 0}:    "TP-LINK TECHNOLOGIES CO.,LTD.",
	[3]byte{192, 77, 247}:  "SERELEC",
	[3]byte{192, 86, 227}:  "Hangzhou Hikvision Digital Technology Co.,Ltd.",
	[3]byte{192, 87, 188}:  "Avaya, Inc",
	[3]byte{192, 88, 167}:  "Pico Systems Co., Ltd.",
	[3]byte{192, 94, 111}:  "V. Stonkaus firma \"Kodinis Raktas\"",
	[3]byte{192, 94, 121}:  "SHENZHEN HUAXUN ARK TECHNOLOGIES CO.,LTD",
	[3]byte{192, 97, 24}:   "TP-LINK TECHNOLOGIES CO.,LTD.",
	[3]byte{192, 98, 107}:  "CISCO SYSTEMS, INC.",
	[3]byte{192, 99, 148}:  "Apple",
	[3]byte{192, 100, 198}: "Nokia Corporation",
	[3]byte{192, 101, 153}: "Samsung Electronics Co.,Ltd",
	[3]byte{192, 103, 175}: "Cisco",
	[3]byte{192, 108, 15}:  "Dobbs Stanford",
	[3]byte{192, 108, 109}: "MagneMotion, Inc.",
	[3]byte{192, 123, 188}: "Cisco",
	[3]byte{192, 126, 64}:  "SHENZHEN XDK COMMUNICATION EQUIPMENT CO.,LTD",
	[3]byte{192, 129, 112}: "Effigis GeoSolutions",
	[3]byte{192, 131, 10}:  "2Wire",
	[3]byte{192, 132, 122}: "Apple",
	[3]byte{192, 136, 91}:  "SnD Tech Co., Ltd.",
	[3]byte{192, 138, 222}: "Ruckus Wireless",
	[3]byte{192, 139, 111}: "S I Sistemas Inteligentes Eletrônicos Ltda",
	[3]byte{192, 140, 96}:  "Cisco",
	[3]byte{192, 145, 50}:  "Patriot Memory",
	[3]byte{192, 145, 52}:  "ProCurve Networking by HP",
	[3]byte{192, 152, 121}: "Acer Inc.",
	[3]byte{192, 152, 229}: "University of Michigan",
	[3]byte{192, 156, 146}: "COBY",
	[3]byte{192, 157, 38}:  "Topicon HK Lmd.",
	[3]byte{192, 159, 66}:  "Apple",
	[3]byte{192, 160, 187}: "D-Link International",
	[3]byte{192, 160, 199}: "FAIRFIELD INDUSTRIES",
	[3]byte{192, 160, 222}: "Multi Touch Oy",
	[3]byte{192, 160, 226}: "Eden Innovations",
	[3]byte{192, 162, 109}: "Abbott Point of Care",
	[3]byte{192, 163, 100}: "3D Systems Massachusetts",
	[3]byte{192, 163, 158}: "EarthCam, Inc.",
	[3]byte{192, 170, 104}: "OSASI Technos Inc.",
	[3]byte{192, 172, 84}:  "SAGEMCOM",
	[3]byte{192, 179, 57}:  "Comigo Ltd.",
	[3]byte{192, 179, 87}:  "Yoshiki Electronics Industry Ltd.",
	[3]byte{192, 184, 177}: "BitBox Ltd",
	[3]byte{192, 186, 230}: "Application Solutions (Electronics and Vision) Ltd",
	[3]byte{192, 189, 66}:  "ZPA Smart Energy a.s.",
	[3]byte{192, 193, 192}: "Cisco-Linksys, LLC",
	[3]byte{192, 195, 182}: "Automatic Systems",
	[3]byte{192, 197, 32}:  "Ruckus Wireless",
	[3]byte{192, 197, 105}: "SHANGHAI LYNUC CNC TECHNOLOGY CO.,LTD",
	[3]byte{192, 198, 135}: "Cisco SPVTG",
	[3]byte{192, 201, 70}:  "MITSUYA LABORATORIES INC.",
	[3]byte{192, 203, 56}:  "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{192, 207, 163}: "Creative Electronics & Software, Inc.",
	[3]byte{192, 208, 68}:  "SAGEMCOM",
	[3]byte{192, 217, 98}:  "Askey Computer Corp.",
	[3]byte{192, 218, 116}: "Hangzhou Sunyard Technology Co., Ltd.",
	[3]byte{192, 223, 119}: "Conrad Electronic SE",
	[3]byte{192, 228, 34}:  "Texas Instruments",
	[3]byte{192, 229, 78}:  "DENX Computer Systems GmbH",
	[3]byte{192, 234, 228}: "Sonicwall",
	[3]byte{192, 238, 251}: "OnePlus Tech (Shenzhen) Ltd",
	[3]byte{192, 241, 196}: "Pacidal Corporation Ltd.",
	[3]byte{192, 242, 251}: "Apple",
	[3]byte{192, 247, 157}: "Powercode",
	[3]byte{192, 248, 218}: "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{192, 249, 145}: "GME Standard Communications P/L",
	[3]byte{196, 0, 6}:     "Lipi Data Systems Ltd.",
	[3]byte{196, 1, 66}:    "MaxMedia Technology Limited",
	[3]byte{196, 1, 124}:   "Ruckus Wireless",
	[3]byte{196, 1, 177}:   "SeekTech INC",
	[3]byte{196, 1, 206}:   "PRESITION (2000) CO., LTD.",
	[3]byte{196, 4, 21}:    "NETGEAR INC.,",
	[3]byte{196, 5, 40}:    "Huawei Technologies Co., Ltd",
	[3]byte{196, 8, 74}:    "Alcatel-Lucent",
	[3]byte{196, 8, 128}:   "Shenzhen UTEPO Tech Co., Ltd.",
	[3]byte{196, 9, 56}:    "Fujian Star-net Communication Co., Ltd",
	[3]byte{196, 10, 203}:  "CISCO SYSTEMS, INC.",
	[3]byte{196, 14, 69}:   "ACK Networks,Inc.",
	[3]byte{196, 15, 9}:    "Hermes electronic GmbH",
	[3]byte{196, 16, 138}:  "Ruckus Wireless",
	[3]byte{196, 20, 60}:   "Cisco",
	[3]byte{196, 22, 250}:  "Prysm Inc",
	[3]byte{196, 23, 254}:  "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{196, 25, 139}:  "Dominion Voting Systems Corporation",
	[3]byte{196, 25, 236}:  "Qualisys AB",
	[3]byte{196, 30, 206}:  "HMI Sources Ltd.",
	[3]byte{196, 33, 200}:  "KYOCERA Corporation",
	[3]byte{196, 35, 122}:  "WhizNets Inc.",
	[3]byte{196, 36, 46}:   "Galvanic Applied Sciences Inc",
	[3]byte{196, 38, 40}:   "Airo Wireless",
	[3]byte{196, 39, 149}:  "Technicolor USA Inc.",
	[3]byte{196, 41, 29}:   "KLEMSAN ELEKTRIK ELEKTRONIK SAN.VE TIC.AS.",
	[3]byte{196, 44, 3}:    "Apple",
	[3]byte{196, 52, 107}:  "Hewlett Packard",
	[3]byte{196, 54, 218}:  "Rusteletech Ltd.",
	[3]byte{196, 56, 211}:  "TAGATEC CO.,LTD",
	[3]byte{196, 57, 58}:   "SMC Networks Inc",
	[3]byte{196, 58, 159}:  "Siconix Inc.",
	[3]byte{196, 60, 60}:   "CYBELEC SA",
	[3]byte{196, 61, 199}:  "NETGEAR",
	[3]byte{196, 66, 2}:    "Samsung Electronics Co.,Ltd",
	[3]byte{196, 67, 143}:  "LG Electronics",
	[3]byte{196, 69, 103}:  "SAMBON PRECISON and ELECTRONICS",
	[3]byte{196, 69, 236}:  "Shanghai Yali Electron Co.,LTD",
	[3]byte{196, 70, 25}:   "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{196, 72, 56}:   "Satcom Direct, Inc.",
	[3]byte{196, 74, 208}:  "FIREFLIES SYSTEMS",
	[3]byte{196, 75, 68}:   "Omniprint Inc.",
	[3]byte{196, 75, 209}:  "Wallys Communications  Teachnologies Co.,Ltd.",
	[3]byte{196, 78, 31}:   "BlueN",
	[3]byte{196, 78, 172}:  "Shenzhen Shiningworth Technology Co., Ltd.",
	[3]byte{196, 80, 6}:    "Samsung Electronics Co.,Ltd",
	[3]byte{196, 84, 68}:   "QUANTA COMPUTER INC.",
	[3]byte{196, 85, 166}:  "Cadac Holdings Ltd",
	[3]byte{196, 85, 194}:  "Bach-Simpson",
	[3]byte{196, 86, 0}:    "Galleon Embedded Computing",
	[3]byte{196, 86, 254}:  "Lava International Ltd.",
	[3]byte{196, 87, 110}:  "Samsung Electronics Co.,LTD",
	[3]byte{196, 88, 194}:  "Shenzhen TATFOOK Technology Co., Ltd.",
	[3]byte{196, 89, 118}:  "Fugoo Coorporation",
	[3]byte{196, 93, 216}:  "HDMI Forum",
	[3]byte{196, 96, 68}:   "Everex Electronics Limited",
	[3]byte{196, 98, 107}:  "ZPT Vigantice",
	[3]byte{196, 98, 234}:  "Samsung Electronics Co.,Ltd",
	[3]byte{196, 99, 84}:   "U-Raku, Inc.",
	[3]byte{196, 100, 19}:  "CISCO SYSTEMS, INC.",
	[3]byte{196, 103, 181}: "Libratone A/S",
	[3]byte{196, 106, 183}: "Xiaomi Technology,Inc.",
	[3]byte{196, 107, 180}: "myIDkey",
	[3]byte{196, 109, 241}: "DataGravity",
	[3]byte{196, 110, 31}:  "TP-LINK TECHNOLOGIES CO.,LTD",
	[3]byte{196, 113, 48}:  "Fon Technology S.L.",
	[3]byte{196, 113, 254}: "CISCO SYSTEMS, INC.",
	[3]byte{196, 115, 30}:  "Samsung Eletronics Co., Ltd",
	[3]byte{196, 123, 47}:  "Beijing JoinHope Image Technology Ltd.",
	[3]byte{196, 123, 163}: "NAVIS Inc.",
	[3]byte{196, 125, 79}:  "CISCO SYSTEMS, INC.",
	[3]byte{196, 125, 204}: "Motorola Solutions Inc.",
	[3]byte{196, 125, 254}: "A.N. Solutions GmbH",
	[3]byte{196, 127, 81}:  "Inventek Systems",
	[3]byte{196, 130, 63}:  "Fujian Newland Auto-ID Tech. Co,.Ltd.",
	[3]byte{196, 130, 78}:  "Changzhou Uchip Electronics Co., LTD.",
	[3]byte{196, 133, 8}:   "Intel Corporate",
	[3]byte{196, 136, 229}: "Samsung Electronics Co.,Ltd",
	[3]byte{196, 145, 58}:  "Shenzhen Sanland Electronic Co., ltd.",
	[3]byte{196, 147, 0}:   "8Devices",
	[3]byte{196, 147, 19}:  "100fio networks technology llc",
	[3]byte{196, 147, 128}: "Speedytel technology",
	[3]byte{196, 149, 162}: "SHENZHEN WEIJIU INDUSTRY AND TRADE DEVELOPMENT CO., LTD",
	[3]byte{196, 152, 5}:   "Minieum Networks, Inc",
	[3]byte{196, 168, 29}:  "D-Link International",
	[3]byte{196, 170, 161}: "SUMMIT DEVELOPMENT, spol.s r.o.",
	[3]byte{196, 173, 33}:  "MEDIAEDGE Corporation",
	[3]byte{196, 181, 18}:  "General Electric Digital Energy",
	[3]byte{196, 186, 153}: "I+ME Actia Informatik und Mikro-Elektronik GmbH",
	[3]byte{196, 189, 106}: "SKF GmbH",
	[3]byte{196, 190, 132}: "Texas Instruments.",
	[3]byte{196, 192, 174}: "MIDORI ELECTRONIC CO., LTD.",
	[3]byte{196, 193, 159}: "National Oilwell Varco Instrumentation, Monitoring, and Optimization (NOV IMO)",
	[3]byte{196, 199, 85}:  "Beijing HuaqinWorld Technology Co.,Ltd",
	[3]byte{196, 201, 25}:  "Energy Imports Ltd",
	[3]byte{196, 201, 236}: "D&D GROUP sp. z o.o.",
	[3]byte{196, 202, 217}: "Hangzhou H3C Technologies Co., Limited",
	[3]byte{196, 205, 69}:  "Beijing Boomsense Technology CO.,LTD.",
	[3]byte{196, 212, 137}: "JiangSu Joyque Information Industry Co.,Ltd",
	[3]byte{196, 214, 85}:  "Tercel technology co.,ltd",
	[3]byte{196, 217, 135}: "Intel Corporate",
	[3]byte{196, 218, 38}:  "NOBLEX SA",
	[3]byte{196, 224, 50}:  "IEEE 1904.1 Working Group",
	[3]byte{196, 225, 124}: "U2S co.",
	[3]byte{196, 231, 190}: "SCSpro Co.,Ltd",
	[3]byte{196, 233, 47}:  "AB Sciex",
	[3]byte{196, 233, 132}: "TP-LINK TECHNOLOGIES CO.,LTD.",
	[3]byte{196, 235, 227}: "RRCN SAS",
	[3]byte{196, 237, 186}: "Texas Instruments",
	[3]byte{196, 238, 174}: "VSS Monitoring",
	[3]byte{196, 238, 245}: "Oclaro, Inc.",
	[3]byte{196, 244, 100}: "Spica international",
	[3]byte{196, 245, 124}: "Brocade Communications Systems, Inc.",
	[3]byte{196, 252, 228}: "DishTV NZ Ltd",
	[3]byte{200, 2, 16}:    "LG Innotek",
	[3]byte{200, 2, 88}:    "ITW GSE ApS",
	[3]byte{200, 2, 166}:   "Beijing Newmine Technology",
	[3]byte{200, 7, 24}:    "TDSi",
	[3]byte{200, 10, 169}:  "Quanta Computer Inc.",
	[3]byte{200, 14, 119}:  "Le Shi Zhi Xin Electronic Technology (Tianjin)  Co.,Ltd",
	[3]byte{200, 14, 149}:  "OmniLync Inc.",
	[3]byte{200, 20, 121}:  "Samsung Electronics Co.,Ltd",
	[3]byte{200, 22, 189}:  "HISENSE ELECTRIC CO.,LTD.",
	[3]byte{200, 25, 247}:  "Samsung Electronics Co.,Ltd",
	[3]byte{200, 26, 254}:  "DLOGIC GmbH",
	[3]byte{200, 27, 107}:  "Innova Security",
	[3]byte{200, 30, 142}:  "ADV Security (S) Pte Ltd",
	[3]byte{200, 31, 102}:  "Dell Inc",
	[3]byte{200, 32, 142}:  "Storagedata",
	[3]byte{200, 41, 42}:   "Barun Electronics",
	[3]byte{200, 42, 20}:   "Apple",
	[3]byte{200, 46, 148}:  "Halfa Enterprise Co., Ltd.",
	[3]byte{200, 49, 104}:  "eZEX corporation",
	[3]byte{200, 50, 50}:   "Hunting Innova",
	[3]byte{200, 51, 75}:   "Apple",
	[3]byte{200, 53, 184}:  "Ericsson, EAB/RWI/K",
	[3]byte{200, 58, 53}:   "Tenda Technology Co., Ltd.",
	[3]byte{200, 59, 69}:   "JRI-Maxant",
	[3]byte{200, 61, 151}:  "Nokia Corporation",
	[3]byte{200, 62, 153}:  "Texas Instruments",
	[3]byte{200, 62, 167}:  "KUNBUS GmbH",
	[3]byte{200, 69, 41}:   "IMK Networks Co.,Ltd",
	[3]byte{200, 69, 68}:   "Shanghai Enlogic Electric Technology Co., Ltd.",
	[3]byte{200, 72, 245}:  "MEDISON Xray Co., Ltd",
	[3]byte{200, 76, 117}:  "CISCO SYSTEMS, INC.",
	[3]byte{200, 86, 69}:   "Intermas France",
	[3]byte{200, 86, 99}:   "Sunflex Europe GmbH",
	[3]byte{200, 96, 0}:    "ASUSTek COMPUTER INC.",
	[3]byte{200, 100, 199}: "zte corporation",
	[3]byte{200, 108, 30}:  "Display Systems Ltd",
	[3]byte{200, 108, 135}: "Zyxel Communications Corp",
	[3]byte{200, 108, 182}: "Optcom Co., Ltd.",
	[3]byte{200, 111, 29}:  "Apple",
	[3]byte{200, 114, 72}:  "Aplicom Oy",
	[3]byte{200, 123, 91}:  "zte corporation",
	[3]byte{200, 124, 188}: "Valink Co., Ltd.",
	[3]byte{200, 125, 119}: "Shenzhen Kingtech Communication Equipment Co.,Ltd",
	[3]byte{200, 126, 117}: "Samsung Electronics Co.,Ltd",
	[3]byte{200, 132, 57}:  "Sunrise Technologies",
	[3]byte{200, 132, 71}:  "Beautiful Enterprise Co., Ltd",
	[3]byte{200, 133, 80}:  "Apple",
	[3]byte{200, 135, 59}:  "Net Optics",
	[3]byte{200, 138, 131}: "Dongguan HuaHong Electronics Co.,Ltd",
	[3]byte{200, 139, 71}:  "Nolangroup S.P.A con Socio Unico",
	[3]byte{200, 144, 62}:  "Pakton Technologies",
	[3]byte{200, 145, 249}: "SAGEMCOM",
	[3]byte{200, 147, 70}:  "MXCHIP Company Limited",
	[3]byte{200, 147, 131}: "Embedded Automation, Inc.",
	[3]byte{200, 148, 210}: "Jiangsu Datang  Electronic Products Co., Ltd",
	[3]byte{200, 151, 159}: "Nokia Corporation",
	[3]byte{200, 156, 29}:  "CISCO SYSTEMS, INC.",
	[3]byte{200, 156, 220}: "ELITEGROUP COMPUTER SYSTEM CO., LTD.",
	[3]byte{200, 159, 29}:  "SHENZHEN COMMUNICATION TECHNOLOGIES CO.,LTD",
	[3]byte{200, 159, 66}:  "VDII Innovation AB",
	[3]byte{200, 160, 48}:  "Texas Instruments",
	[3]byte{200, 161, 182}: "Shenzhen Longway Technologies Co., Ltd",
	[3]byte{200, 161, 186}: "Neul Ltd",
	[3]byte{200, 166, 32}:  "Nebula, Inc",
	[3]byte{200, 167, 10}:  "Verizon Business",
	[3]byte{200, 167, 41}:  "SYStronics Co., Ltd.",
	[3]byte{200, 170, 33}:  "ARRIS Group, Inc.",
	[3]byte{200, 170, 204}: "PRIVATE",
	[3]byte{200, 174, 156}: "Shanghai TYD Elecronic Technology Co. Ltd",
	[3]byte{200, 175, 64}:  "marco Systemanalyse und Entwicklung GmbH",
	[3]byte{200, 179, 115}: "Cisco-Linksys, LLC",
	[3]byte{200, 181, 183}: "Apple",
	[3]byte{200, 186, 148}: "Samsung Electro Mechanics co., LTD.",
	[3]byte{200, 187, 211}: "Embrane",
	[3]byte{200, 188, 200}: "Apple",
	[3]byte{200, 190, 25}:  "D-Link International",
	[3]byte{200, 193, 38}:  "ZPM Industria e Comercio Ltda",
	[3]byte{200, 193, 60}:  "RuggedTek Hangzhou Co., Ltd",
	[3]byte{200, 199, 145}: "Zero1.tv GmbH",
	[3]byte{200, 203, 184}: "Hewlett Packard",
	[3]byte{200, 205, 114}: "SAGEMCOM",
	[3]byte{200, 208, 25}:  "Shanghai Tigercel Communication Technology Co.,Ltd",
	[3]byte{200, 209, 11}:  "Nokia Corporation",
	[3]byte{200, 209, 94}:  "Huawei Technologies Co., Ltd",
	[3]byte{200, 209, 209}: "AGAiT Technology Corporation",
	[3]byte{200, 210, 193}: "Jetlun (Shenzhen) Corporation",
	[3]byte{200, 211, 163}: "D-Link International",
	[3]byte{200, 212, 41}:  "Muehlbauer AG",
	[3]byte{200, 213, 144}: "FLIGHT DATA SYSTEMS",
	[3]byte{200, 213, 254}: "Shenzhen Zowee Technology Co., Ltd",
	[3]byte{200, 215, 25}:  "Cisco Consumer Products, LLC",
	[3]byte{200, 221, 201}: "Lenovo Mobile Communication Technology Ltd.",
	[3]byte{200, 222, 81}:  "Integra Networks, Inc.",
	[3]byte{200, 223, 124}: "Nokia Corporation",
	[3]byte{200, 224, 235}: "Apple",
	[3]byte{200, 225, 167}: "Vertu Corporation Limited",
	[3]byte{200, 228, 47}:  "Technical Research Design and Development",
	[3]byte{200, 231, 216}: "SHENZHEN MERCURY COMMUNICATION TECHNOLOGIES CO.,LTD.",
	[3]byte{200, 238, 8}:   "TANGTOP TECHNOLOGY CO.,LTD",
	[3]byte{200, 238, 117}: "Pishion International Co. Ltd",
	[3]byte{200, 238, 166}: "Shenzhen SHX Technology Co., Ltd",
	[3]byte{200, 239, 46}:  "Beijing Gefei Tech. Co., Ltd",
	[3]byte{200, 243, 107}: "Yamato Scale Co.,Ltd.",
	[3]byte{200, 243, 134}: "Shenzhen Xiaoniao Technology Co.,Ltd",
	[3]byte{200, 244, 6}:   "Avaya, Inc",
	[3]byte{200, 246, 80}:  "Apple",
	[3]byte{200, 246, 141}: "S.E.TECHNOLOGIES LIMITED",
	[3]byte{200, 247, 4}:   "Building Block Video",
	[3]byte{200, 247, 51}:  "Intel Corporate",
	[3]byte{200, 249, 129}: "Seneca s.r.l.",
	[3]byte{200, 249, 249}: "CISCO SYSTEMS, INC.",
	[3]byte{200, 251, 38}:  "Cisco SPVTG",
	[3]byte{200, 254, 48}:  "Bejing DAYO Mobile Communication Technology Ltd.",
	[3]byte{200, 255, 119}: "Dyson Limited",
	[3]byte{204, 0, 128}:   "BETTINI SRL",
	[3]byte{204, 3, 250}:   "Technicolor CH USA",
	[3]byte{204, 4, 124}:   "G-WAY Microwave",
	[3]byte{204, 4, 180}:   "Select Comfort",
	[3]byte{204, 5, 27}:    "Samsung Electronics Co.,Ltd",
	[3]byte{204, 7, 171}:   "Samsung Electronics Co.,Ltd",
	[3]byte{204, 7, 228}:   "Lenovo Mobile Communication Technology Ltd.",
	[3]byte{204, 8, 224}:   "Apple",
	[3]byte{204, 9, 200}:   "IMAQLIQ LTD",
	[3]byte{204, 12, 218}:  "Miljovakt AS",
	[3]byte{204, 13, 236}:  "Cisco SPVTG",
	[3]byte{204, 16, 163}:  "Beijing Nan Bao Technology Co., Ltd.",
	[3]byte{204, 20, 166}:  "Yichun MyEnergy Domain, Inc",
	[3]byte{204, 24, 123}:  "Manzanita Systems, Inc.",
	[3]byte{204, 26, 250}:  "zte corporation",
	[3]byte{204, 30, 255}:  "Metrological Group BV",
	[3]byte{204, 34, 24}:   "InnoDigital Co., Ltd.",
	[3]byte{204, 38, 45}:   "Verifi, LLC",
	[3]byte{204, 42, 128}:  "Micro-Biz intelligence solutions Co.,Ltd",
	[3]byte{204, 45, 140}:  "LG ELECTRONICS INC",
	[3]byte{204, 48, 128}:  "VAIO Corporation",
	[3]byte{204, 51, 187}:  "SAGEMCOM SAS",
	[3]byte{204, 52, 41}:   "TP-LINK TECHNOLOGIES CO.,LTD.",
	[3]byte{204, 52, 215}:  "GEWISS S.P.A.",
	[3]byte{204, 53, 64}:   "Technicolor USA Inc.",
	[3]byte{204, 57, 140}:  "Shiningtek",
	[3]byte{204, 58, 97}:   "SAMSUNG ELECTRO MECHANICS CO., LTD.",
	[3]byte{204, 60, 63}:   "SA.S.S. Datentechnik AG",
	[3]byte{204, 61, 130}:  "Intel Corporate",
	[3]byte{204, 62, 95}:   "Hewlett Packard",
	[3]byte{204, 63, 29}:   "Intesis Software SL",
	[3]byte{204, 67, 227}:  "Trump s.a.",
	[3]byte{204, 71, 3}:    "Intercon Systems Co., Ltd.",
	[3]byte{204, 74, 225}:  "Fourtec -Fourier Technologies",
	[3]byte{204, 75, 251}:  "Hellberg Safety AB",
	[3]byte{204, 78, 36}:   "Brocade Communications Systems, Inc.",
	[3]byte{204, 80, 28}:   "KVH Industries, Inc.",
	[3]byte{204, 80, 118}:  "Ocom Communications, Inc.",
	[3]byte{204, 82, 175}:  "Universal Global Scientific Industrial Co., Ltd.",
	[3]byte{204, 83, 181}:  "HUAWEI TECHNOLOGIES CO.,LTD",
	[3]byte{204, 84, 89}:   "OnTime Networks AS",
	[3]byte{204, 85, 173}:  "RIM",
	[3]byte{204, 89, 62}:   "TOUMAZ LTD",
	[3]byte{204, 92, 117}:  "Weightech Com. Imp. Exp. Equip. Pesagem Ltda",
	[3]byte{204, 93, 78}:   "ZyXEL Communications Corporation",
	[3]byte{204, 93, 87}:   "Information  System Research Institute,Inc.",
	[3]byte{204, 96, 187}:  "Empower RF Systems",
	[3]byte{204, 101, 173}: "ARRIS Group, Inc.",
	[3]byte{204, 105, 176}: "Global Traffic Technologies, LLC",
	[3]byte{204, 107, 152}: "Minetec Wireless Technologies",
	[3]byte{204, 107, 241}: "Sound Masking Inc.",
	[3]byte{204, 109, 160}: "Roku, Inc.",
	[3]byte{204, 109, 239}: "TJK Tietolaite Oy",
	[3]byte{204, 114, 15}:  "Viscount Systems Inc.",
	[3]byte{204, 116, 152}: "Filmetrics Inc.",
	[3]byte{204, 118, 105}: "SEETECH",
	[3]byte{204, 120, 95}:  "Apple",
	[3]byte{204, 122, 48}:  "CMAX Wireless Co., Ltd.",
	[3]byte{204, 123, 53}:  "zte corporation",
	[3]byte{204, 125, 55}:  "ARRIS Group, Inc.",
	[3]byte{204, 126, 231}: "Panasonic AVC Networks Company",
	[3]byte{204, 133, 108}: "SHENZHEN MDK DIGITAL TECHNOLOGY CO.,LTD",
	[3]byte{204, 137, 253}: "Nokia Corporation",
	[3]byte{204, 140, 227}: "Texas Instruments",
	[3]byte{204, 144, 147}: "Hansong Tehnologies",
	[3]byte{204, 145, 43}:  "TE Connectivity Touch Solutions",
	[3]byte{204, 148, 74}:  "Pfeiffer Vacuum GmbH",
	[3]byte{204, 149, 215}: "VIZIO, Inc",
	[3]byte{204, 150, 160}: "Shenzhen Huawei Communication Technologies Co., Ltd",
	[3]byte{204, 158, 0}:   "Nintendo Co., Ltd.",
	[3]byte{204, 159, 53}:  "Transbit Sp. z o.o.",
	[3]byte{204, 160, 229}: "DZG Metering GmbH",
	[3]byte{204, 162, 35}:  "Huawei Technologies Co., Ltd",
	[3]byte{204, 163, 116}: "Guangdong Guanglian Electronic Technology Co.Ltd",
	[3]byte{204, 164, 98}:  "ARRIS Group, Inc.",
	[3]byte{204, 166, 20}:  "AIFA TECHNOLOGY CORP.",
	[3]byte{204, 175, 120}: "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{204, 178, 85}:  "D-Link International",
	[3]byte{204, 179, 248}: "FUJITSU ISOTEC LIMITED",
	[3]byte{204, 181, 90}:  "Fraunhofer ITWM",
	[3]byte{204, 182, 145}: "NECMagnusCommunications",
	[3]byte{204, 184, 136}: "AnB Securite s.a.",
	[3]byte{204, 184, 241}: "EAGLE KINGDOM TECHNOLOGIES LIMITED",
	[3]byte{204, 189, 53}:  "Steinel GmbH",
	[3]byte{204, 189, 211}: "Ultimaker B.V.",
	[3]byte{204, 190, 113}: "OptiLogix BV",
	[3]byte{204, 193, 4}:   "Applied Technical Systems",
	[3]byte{204, 195, 234}: "Motorola Mobility LLC",
	[3]byte{204, 197, 10}:  "SHENZHEN DAJIAHAO TECHNOLOGY CO.,LTD",
	[3]byte{204, 198, 43}:  "Tri-Systems Corporation",
	[3]byte{204, 200, 215}: "CIAS Elettronica srl",
	[3]byte{204, 204, 78}:  "Sun Fountainhead USA. Corp",
	[3]byte{204, 204, 129}: "HUAWEI TECHNOLOGIES CO.,LTD",
	[3]byte{204, 205, 100}: "SM-Electronic GmbH",
	[3]byte{204, 206, 64}:  "Janteq Corp",
	[3]byte{204, 210, 155}: "Shenzhen Bopengfa Elec&Technology CO.,Ltd",
	[3]byte{204, 213, 57}:  "Cisco",
	[3]byte{204, 216, 17}:  "Aiconn Technology Corporation",
	[3]byte{204, 216, 193}: "Cisco",
	[3]byte{204, 217, 233}: "SCR Engineers Ltd.",
	[3]byte{204, 225, 127}: "juniper networks",
	[3]byte{204, 225, 213}: "Buffalo Inc.",
	[3]byte{204, 231, 152}: "My Social Stuff",
	[3]byte{204, 231, 223}: "American Magnetics, Inc.",
	[3]byte{204, 232, 172}: "SOYEA Technology Co.,Ltd.",
	[3]byte{204, 234, 28}:  "DCONWORKS  Co., Ltd",
	[3]byte{204, 238, 217}: "Deto Mechatronic GmbH",
	[3]byte{204, 239, 72}:  "CISCO SYSTEMS, INC.",
	[3]byte{204, 243, 165}: "Chi Mei Communication Systems, Inc",
	[3]byte{204, 244, 7}:   "EUKREA ELECTROMATIQUE SARL",
	[3]byte{204, 245, 56}:  "3isysnetworks",
	[3]byte{204, 246, 122}: "Ayecka Communication Systems LTD",
	[3]byte{204, 248, 65}:  "Lumewave",
	[3]byte{204, 248, 240}: "Xi'an HISU Multimedia Technology Co.,Ltd.",
	[3]byte{204, 249, 84}:  "Avaya, Inc",
	[3]byte{204, 249, 232}: "Samsung Electronics Co.,Ltd",
	[3]byte{204, 250, 0}:   "LG Electronics",
	[3]byte{204, 251, 101}: "Nintendo Co., Ltd.",
	[3]byte{204, 252, 109}: "RIZ TRANSMITTERS",
	[3]byte{204, 252, 177}: "Wireless Technology, Inc.",
	[3]byte{204, 254, 60}:  "Samsung Electronics",
	[3]byte{208, 7, 144}:   "Texas Instruments",
	[3]byte{208, 10, 171}:  "Yokogawa Digital Computer Corporation",
	[3]byte{208, 14, 164}:  "Porsche Cars North America",
	[3]byte{208, 18, 66}:   "BIOS Corporation",
	[3]byte{208, 19, 30}:   "Sunrex Technology Corp",
	[3]byte{208, 21, 74}:   "zte corporation",
	[3]byte{208, 23, 106}:  "Samsung Electronics Co.,Ltd",
	[3]byte{208, 26, 167}:  "UniPrint",
	[3]byte{208, 28, 187}:  "Beijing Ctimes Digital Technology Co., Ltd.",
	[3]byte{208, 34, 18}:   "IEEE REGISTRATION AUTHORITY  - Please see MAM public listing for more information.",
	[3]byte{208, 34, 190}:  "Samsung Electro Mechanics co.,LTD.",
	[3]byte{208, 35, 219}:  "Apple",
	[3]byte{208, 39, 136}:  "Hon Hai Precision Ind.Co.Ltd",
	[3]byte{208, 44, 69}:   "littleBits Electronics, Inc.",
	[3]byte{208, 45, 179}:  "Huawei Technologies Co., Ltd",
	[3]byte{208, 49, 16}:   "Ingenic Semiconductor Co.,Ltd",
	[3]byte{208, 55, 97}:   "Texas Instruments",
	[3]byte{208, 57, 114}:  "Texas Instruments",
	[3]byte{208, 57, 179}:  "ARRIS Group, Inc.",
	[3]byte{208, 70, 220}:  "Southwest Research Institute",
	[3]byte{208, 76, 193}:  "SINTRONES Technology Corp.",
	[3]byte{208, 79, 126}:  "Apple",
	[3]byte{208, 80, 153}:  "ASRock Incorporation",
	[3]byte{208, 81, 98}:   "Sony Mobile Communications AB",
	[3]byte{208, 82, 168}:  "Physical Graph Corporation",
	[3]byte{208, 84, 45}:   "Cambridge Industries(Group) Co.,Ltd.",
	[3]byte{208, 87, 76}:   "CISCO SYSTEMS, INC.",
	[3]byte{208, 87, 133}:  "Pantech Co., Ltd.",
	[3]byte{208, 87, 161}:  "Werma Signaltechnik GmbH & Co. KG",
	[3]byte{208, 88, 117}:  "Active Control Technology Inc.",
	[3]byte{208, 89, 195}:  "CeraMicro Technology Corporation",
	[3]byte{208, 89, 228}:  "Samsung Electronics Co.,Ltd",
	[3]byte{208, 90, 15}:   "I-BT DIGITAL CO.,LTD",
	[3]byte{208, 90, 241}:  "Shenzhen Pulier Tech CO.,Ltd",
	[3]byte{208, 91, 168}:  "zte corporation",
	[3]byte{208, 95, 184}:  "Texas Instruments",
	[3]byte{208, 95, 206}:  "Hitachi Data Systems",
	[3]byte{208, 98, 160}:  "China Essence Technology (Zhumadian) Co., Ltd.",
	[3]byte{208, 99, 77}:   "Meiko Maschinenbau GmbH &amp; Co. KG",
	[3]byte{208, 99, 180}:  "SolidRun Ltd.",
	[3]byte{208, 102, 123}: "Samsung Electronics Co., LTD",
	[3]byte{208, 103, 229}: "Dell Inc",
	[3]byte{208, 105, 158}: "LUMINEX Lighting Control Equipment",
	[3]byte{208, 105, 208}: "Verto Medical Solutions, LLC",
	[3]byte{208, 114, 220}: "Cisco",
	[3]byte{208, 115, 127}: "Mini-Circuits",
	[3]byte{208, 115, 142}: "DONG OH PRECISION CO., LTD.",
	[3]byte{208, 115, 213}: "LIFI LABS MANAGEMENT PTY LTD",
	[3]byte{208, 117, 190}: "Reno A&E",
	[3]byte{208, 118, 80}:  "IEEE REGISTRATION AUTHORITY  - Please see MAM public listing for more information.",
	[3]byte{208, 122, 181}: "Huawei Technologies Co., Ltd",
	[3]byte{208, 125, 229}: "Forward Pay Systems, Inc.",
	[3]byte{208, 126, 40}:  "Hewlett Packard",
	[3]byte{208, 126, 53}:  "Intel Corporate",
	[3]byte{208, 132, 176}: "Sagemcom",
	[3]byte{208, 137, 153}: "APCON, Inc.",
	[3]byte{208, 138, 85}:  "Skullcandy",
	[3]byte{208, 139, 126}: "Passif Semiconductor",
	[3]byte{208, 140, 181}: "Texas Instruments",
	[3]byte{208, 140, 255}: "UPWIS AB",
	[3]byte{208, 147, 248}: "Stonestreet One LLC",
	[3]byte{208, 149, 199}: "Pantech Co., Ltd.",
	[3]byte{208, 155, 5}:   "Emtronix",
	[3]byte{208, 156, 48}:  "Foster Electric Company, Limited",
	[3]byte{208, 157, 10}:  "LINKCOM",
	[3]byte{208, 160, 214}: "Chengdu TD Tech Ltd.",
	[3]byte{208, 163, 17}:  "Neuberger Gebäudeautomation GmbH",
	[3]byte{208, 174, 236}: "Alpha Networks Inc.",
	[3]byte{208, 175, 182}: "Linktop Technology Co., LTD",
	[3]byte{208, 179, 63}:  "SHENZHEN TINNO MOBILE TECHNOLOGY CO.,LTD.",
	[3]byte{208, 180, 152}: "Robert Bosch LLC Automotive Electronics",
	[3]byte{208, 181, 35}:  "Bestcare Cloucal Corp.",
	[3]byte{208, 181, 61}:  "SEPRO ROBOTIQUE",
	[3]byte{208, 187, 128}: "SHL Telemedicine International Ltd.",
	[3]byte{208, 189, 1}:   "DS International",
	[3]byte{208, 190, 44}:  "CNSLink Co., Ltd.",
	[3]byte{208, 193, 177}: "Samsung Electronics Co.,Ltd",
	[3]byte{208, 194, 130}: "CISCO SYSTEMS, INC.",
	[3]byte{208, 196, 47}:  "Tamagawa Seiki Co.,Ltd.",
	[3]byte{208, 199, 137}: "Cisco",
	[3]byte{208, 199, 192}: "TP-LINK TECHNOLOGIES CO.,LTD.",
	[3]byte{208, 205, 225}: "Scientech Electronics",
	[3]byte{208, 207, 94}:  "Energy Micro AS",
	[3]byte{208, 208, 253}: "CISCO SYSTEMS, INC.",
	[3]byte{208, 210, 18}:  "K2NET Co.,Ltd.",
	[3]byte{208, 210, 134}: "Beckman Coulter K.K.",
	[3]byte{208, 211, 252}: "Mios, Ltd.",
	[3]byte{208, 212, 18}:  "ADB Broadband Italia",
	[3]byte{208, 212, 113}: "MVTECH co., Ltd",
	[3]byte{208, 214, 204}: "Wintop",
	[3]byte{208, 219, 50}:  "Nokia Corporation",
	[3]byte{208, 223, 154}: "Liteon Technology Corporation",
	[3]byte{208, 223, 178}: "Genie Networks Limited",
	[3]byte{208, 223, 199}: "Samsung Electronics Co.,Ltd",
	[3]byte{208, 225, 64}:  "Apple, Inc",
	[3]byte{208, 227, 71}:  "Yoga",
	[3]byte{208, 228, 11}:  "Wearable Inc.",
	[3]byte{208, 229, 77}:  "Pace plc",
	[3]byte{208, 231, 130}: "Azurewave Technologies, Inc.",
	[3]byte{208, 235, 3}:   "Zhehua technology limited",
	[3]byte{208, 235, 158}: "Seowoo Inc.",
	[3]byte{208, 240, 219}: "Ericsson",
	[3]byte{208, 242, 127}: "SteadyServ Technoligies, LLC",
	[3]byte{208, 247, 59}:  "Helmut Mauell GmbH",
	[3]byte{208, 250, 29}:  "Qihoo  360  Technology Co.,Ltd",
	[3]byte{208, 255, 80}:  "Texas Instruments, Inc",
	[3]byte{212, 0, 13}:    "Phoenix Broadband Technologies, LLC.",
	[3]byte{212, 0, 87}:    "MC Technologies GmbH",
	[3]byte{212, 1, 41}:    "Broadcom Corporation",
	[3]byte{212, 1, 109}:   "TP-LINK TECHNOLOGIES CO.,LTD.",
	[3]byte{212, 2, 74}:    "Delphian Systems LLC",
	[3]byte{212, 11, 185}:  "Solid Semecs bv.",
	[3]byte{212, 15, 178}:  "Applied Micro Electronics AME bv",
	[3]byte{212, 16, 144}:  "iNFORM Systems AG",
	[3]byte{212, 16, 207}:  "Huanshun Network Science and Technology Co., Ltd.",
	[3]byte{212, 17, 214}:  "ShotSpotter, Inc.",
	[3]byte{212, 18, 150}:  "Anobit Technologies Ltd.",
	[3]byte{212, 18, 187}:  "Quadrant Components Inc. Ltd",
	[3]byte{212, 19, 111}:  "Asia Pacific Brands",
	[3]byte{212, 28, 28}:   "RCF S.P.A.",
	[3]byte{212, 30, 53}:   "TOHO Electronics INC.",
	[3]byte{212, 31, 12}:   "TVI Vision Oy",
	[3]byte{212, 32, 109}:  "HTC Corporation",
	[3]byte{212, 33, 34}:   "Sercomm Corporation",
	[3]byte{212, 34, 63}:   "Lenovo Mobile Communication Technology Ltd.",
	[3]byte{212, 34, 78}:   "Alcatel Lucent",
	[3]byte{212, 39, 81}:   "Infopia Co., Ltd",
	[3]byte{212, 40, 178}:  "ioBridge, Inc.",
	[3]byte{212, 41, 234}:  "Zimory GmbH",
	[3]byte{212, 44, 61}:   "Sky Light Digital Limited",
	[3]byte{212, 47, 35}:   "Akenori PTE Ltd",
	[3]byte{212, 49, 157}:  "Sinwatec",
	[3]byte{212, 50, 102}:  "Fike Corporation",
	[3]byte{212, 55, 215}:  "zte corporation",
	[3]byte{212, 58, 101}:  "IGRS Engineering Lab Ltd.",
	[3]byte{212, 58, 233}:  "DONGGUAN ipt INDUSTRIAL CO., LTD",
	[3]byte{212, 61, 103}:  "Carma Industries Inc.",
	[3]byte{212, 61, 126}:  "Micro-Star Int'l Co, Ltd",
	[3]byte{212, 67, 168}:  "Changzhou Haojie Electric Co., Ltd.",
	[3]byte{212, 75, 94}:   "TAIYO YUDEN CO., LTD.",
	[3]byte{212, 76, 36}:   "Vuppalamritha Magnetic Components LTD",
	[3]byte{212, 76, 156}:  "Shenzhen YOOBAO Technology Co.Ltd",
	[3]byte{212, 76, 167}:  "Informtekhnika & Communication, LLC",
	[3]byte{212, 79, 128}:  "Kemper Digital GmbH",
	[3]byte{212, 80, 122}:  "CEIVA Logic, Inc",
	[3]byte{212, 82, 81}:   "IBT Ingenieurbureau Broennimann Thun",
	[3]byte{212, 82, 151}:  "nSTREAMS Technologies, Inc.",
	[3]byte{212, 83, 175}:  "VIGO System S.A.",
	[3]byte{212, 90, 178}:  "Galleon Systems",
	[3]byte{212, 92, 112}:  "Wi-Fi Alliance",
	[3]byte{212, 93, 66}:   "Nokia Corporation",
	[3]byte{212, 97, 50}:   "Pro Concept Manufacturer Co.,Ltd.",
	[3]byte{212, 100, 247}: "CHENGDU USEE DIGITAL TECHNOLOGY CO., LTD",
	[3]byte{212, 102, 168}: "Riedo Networks GmbH",
	[3]byte{212, 103, 97}:  "SAHAB TECHNOLOGY",
	[3]byte{212, 103, 231}: "Fiberhome Telecommunication Tech.Co.,Ltd.",
	[3]byte{212, 104, 103}: "Neoventus Design Group",
	[3]byte{212, 106, 145}: "Snap AV",
	[3]byte{212, 106, 168}: "HUAWEI TECHNOLOGIES CO.,LTD",
	[3]byte{212, 108, 191}: "Goodrich ISR",
	[3]byte{212, 108, 218}: "CSM GmbH",
	[3]byte{212, 110, 92}:  "Huawei Technologies Co., Ltd",
	[3]byte{212, 111, 66}:  "WAXESS USA Inc",
	[3]byte{212, 121, 195}: "Cameronet GmbH & Co. KG",
	[3]byte{212, 123, 53}:  "NEO Monitors AS",
	[3]byte{212, 123, 117}: "HARTING Electronics GmbH",
	[3]byte{212, 129, 202}: "iDevices, LLC",
	[3]byte{212, 130, 62}:  "Argosy Technologies, Ltd.",
	[3]byte{212, 133, 100}: "Hewlett-Packard Company",
	[3]byte{212, 135, 216}: "Samsung Electronics",
	[3]byte{212, 136, 144}: "Samsung Electronics Co.,Ltd",
	[3]byte{212, 140, 181}: "CISCO SYSTEMS, INC.",
	[3]byte{212, 141, 217}: "Meld Technology, Inc",
	[3]byte{212, 143, 51}:  "Microsoft Corporation",
	[3]byte{212, 143, 170}: "Sogecam Industrial, S.A.",
	[3]byte{212, 145, 175}: "Electroacustica General Iberica, S.A.",
	[3]byte{212, 147, 152}: "Nokia Corporation",
	[3]byte{212, 147, 160}: "Fidelix Oy",
	[3]byte{212, 148, 90}:  "COSMO CO., LTD",
	[3]byte{212, 148, 161}: "Texas Instruments",
	[3]byte{212, 149, 36}:  "Clover Network, Inc.",
	[3]byte{212, 150, 223}: "SUNGJIN C&T CO.,LTD",
	[3]byte{212, 151, 11}:  "XIAOMI CORPORATION",
	[3]byte{212, 154, 32}:  "Apple",
	[3]byte{212, 156, 40}:  "JayBird Gear LLC",
	[3]byte{212, 156, 142}: "University of FUKUI",
	[3]byte{212, 158, 109}: "Wuhan Zhongyuan Huadian Science & Technology Co.,",
	[3]byte{212, 160, 42}:  "CISCO SYSTEMS, INC.",
	[3]byte{212, 164, 37}:  "SMAX Technology Co., Ltd.",
	[3]byte{212, 164, 153}: "InView Technology Corporation",
	[3]byte{212, 169, 40}:  "GreenWave Reality Inc",
	[3]byte{212, 170, 255}: "MICRO WORLD",
	[3]byte{212, 172, 78}:  "BODi rS, LLC",
	[3]byte{212, 173, 45}:  "Fiberhome Telecommunication Tech.Co.,Ltd.",
	[3]byte{212, 174, 82}:  "Dell Inc",
	[3]byte{212, 177, 16}:  "HUAWEI TECHNOLOGIES CO.,LTD",
	[3]byte{212, 180, 62}:  "Messcomp Datentechnik GmbH",
	[3]byte{212, 190, 217}: "Dell Inc",
	[3]byte{212, 191, 45}:  "SE Controls Asia Pacific Ltd",
	[3]byte{212, 191, 127}: "UPVEL",
	[3]byte{212, 193, 252}: "Nokia Corporation",
	[3]byte{212, 199, 102}: "Acentic GmbH",
	[3]byte{212, 201, 239}: "Hewlett Packard",
	[3]byte{212, 202, 109}: "Routerboard.com",
	[3]byte{212, 202, 110}: "u-blox AG",
	[3]byte{212, 203, 175}: "Nokia Corporation",
	[3]byte{212, 206, 184}: "Enatel LTD",
	[3]byte{212, 207, 249}: "Shenzhen Sen5 Technology Co., Ltd.",
	[3]byte{212, 209, 132}: "ADB Broadband Italia",
	[3]byte{212, 210, 73}:  "Power Ethernet",
	[3]byte{212, 213, 13}:  "Southwest Microwave, Inc",
	[3]byte{212, 215, 72}:  "CISCO SYSTEMS, INC.",
	[3]byte{212, 216, 152}: "Korea CNO Tech Co., Ltd",
	[3]byte{212, 217, 25}:  "GoPro",
	[3]byte{212, 223, 87}:  "Alpinion Medical Systems",
	[3]byte{212, 224, 142}: "ValueHD Corporation",
	[3]byte{212, 227, 44}:  "S. Siedle & Sohne",
	[3]byte{212, 227, 63}:  "Alcatel-Lucent",
	[3]byte{212, 232, 178}: "Samsung Electronics",
	[3]byte{212, 234, 14}:  "Avaya, Inc",
	[3]byte{212, 236, 12}:  "Harley-Davidson Motor Company",
	[3]byte{212, 236, 134}: "LinkedHope Intelligent Technologies Co., Ltd",
	[3]byte{212, 238, 7}:   "HIWIFI Co., Ltd.",
	[3]byte{212, 240, 39}:  "Navetas Energy Management",
	[3]byte{212, 240, 180}: "Napco Security Technologies",
	[3]byte{212, 241, 67}:  "IPROAD.,Inc",
	[3]byte{212, 244, 111}: "Apple",
	[3]byte{212, 245, 19}:  "Texas Instruments",
	[3]byte{212, 246, 63}:  "IEA S.R.L.",
	[3]byte{216, 0, 77}:    "Apple",
	[3]byte{216, 5, 46}:    "Skyviia Corporation",
	[3]byte{216, 6, 209}:   "Honeywell Fire System (Shanghai) Co,. Ltd.",
	[3]byte{216, 8, 245}:   "Arcadia Networks Co. Ltd.",
	[3]byte{216, 9, 195}:   "Cercacor Labs",
	[3]byte{216, 12, 207}:  "C.G.V. S.A.S.",
	[3]byte{216, 13, 227}:  "FXI TECHNOLOGIES AS",
	[3]byte{216, 21, 13}:   "TP-LINK TECHNOLOGIES CO.,LTD.",
	[3]byte{216, 22, 10}:   "Nippon Electro-Sensory Devices",
	[3]byte{216, 24, 43}:   "Conti Temic Microelectronic GmbH",
	[3]byte{216, 25, 206}:  "Telesquare",
	[3]byte{216, 27, 254}:  "TWINLINX CORPORATION",
	[3]byte{216, 28, 20}:   "Compacta International, Ltd.",
	[3]byte{216, 30, 222}:  "B&W Group Ltd",
	[3]byte{216, 36, 189}:  "CISCO SYSTEMS, INC.",
	[3]byte{216, 37, 34}:   "Pace plc",
	[3]byte{216, 38, 185}:  "Guangdong Coagent Electronics S &T Co., Ltd.",
	[3]byte{216, 39, 12}:   "MaxTronic International Co., Ltd.",
	[3]byte{216, 40, 201}:  "General Electric Consumer and Industrial",
	[3]byte{216, 41, 22}:   "Ascent Communication Technology",
	[3]byte{216, 41, 134}:  "Best Wish Technology LTD",
	[3]byte{216, 42, 21}:   "Leitner SpA",
	[3]byte{216, 42, 126}:  "Nokia Corporation",
	[3]byte{216, 45, 155}:  "Shenzhen G.Credit Communication Technology Co., Ltd",
	[3]byte{216, 45, 225}:  "Tricascade Inc.",
	[3]byte{216, 48, 98}:   "Apple",
	[3]byte{216, 49, 207}:  "Samsung Electronics Co.,Ltd",
	[3]byte{216, 51, 127}:  "Office FA.com Co.,Ltd.",
	[3]byte{216, 60, 105}:  "Tinno Mobile Technology Corp",
	[3]byte{216, 66, 172}:  "Shanghai Feixun Communication Co.,Ltd.",
	[3]byte{216, 70, 6}:    "Silicon Valley Global Marketing",
	[3]byte{216, 73, 11}:   "HUAWEI TECHNOLOGIES CO.,LTD",
	[3]byte{216, 73, 47}:   "CANON INC.",
	[3]byte{216, 74, 135}:  "OI ELECTRIC CO.,LTD",
	[3]byte{216, 75, 42}:   "Cognitas Technologies, Inc.",
	[3]byte{216, 80, 230}:  "ASUSTek COMPUTER INC.",
	[3]byte{216, 84, 58}:   "Texas Instruments",
	[3]byte{216, 87, 239}:  "Samsung Electronics",
	[3]byte{216, 88, 215}:  "CZ.NIC, z.s.p.o.",
	[3]byte{216, 93, 76}:   "TP-LINK Technologies Co.,Ltd.",
	[3]byte{216, 93, 132}:  "CAx soft GmbH",
	[3]byte{216, 93, 251}:  "PRIVATE",
	[3]byte{216, 97, 148}:  "Objetivos y Sevicios de Valor Añadido",
	[3]byte{216, 98, 219}:  "Eno Inc.",
	[3]byte{216, 101, 149}: "Toy's Myth Inc.",
	[3]byte{216, 102, 198}: "Shenzhen Daystar Technology Co.,ltd",
	[3]byte{216, 102, 238}: "BOXIN COMMUNICATION CO.,LTD.",
	[3]byte{216, 103, 217}: "CISCO SYSTEMS, INC.",
	[3]byte{216, 105, 96}:  "Steinsvik",
	[3]byte{216, 107, 247}: "Nintendo Co., Ltd.",
	[3]byte{216, 108, 233}: "SAGEMCOM SAS",
	[3]byte{216, 113, 87}:  "Lenovo Mobile Communication Technology Ltd.",
	[3]byte{216, 117, 51}:  "Nokia Corporation",
	[3]byte{216, 118, 10}:  "Escort, Inc.",
	[3]byte{216, 120, 229}: "KUHN SA",
	[3]byte{216, 121, 136}: "Hon Hai Precision Ind. Co., Ltd.",
	[3]byte{216, 124, 221}: "SANIX INCORPORATED",
	[3]byte{216, 126, 177}: "x.o.ware, inc.",
	[3]byte{216, 128, 57}:  "Microchip Technology Inc.",
	[3]byte{216, 129, 206}: "AHN INC.",
	[3]byte{216, 132, 102}: "Extreme Networks",
	[3]byte{216, 138, 59}:  "UNIT-EM",
	[3]byte{216, 144, 232}: "Samsung Electronics Co.,Ltd",
	[3]byte{216, 149, 47}:  "Texas Instruments",
	[3]byte{216, 150, 133}: "GoPro",
	[3]byte{216, 150, 149}: "Apple",
	[3]byte{216, 150, 224}: "Alibaba Cloud Computing Ltd.",
	[3]byte{216, 151, 59}:  "Artesyn Embedded Technologies",
	[3]byte{216, 151, 96}:  "C2 Development, Inc.",
	[3]byte{216, 151, 124}: "Grey Innovation",
	[3]byte{216, 151, 186}: "PEGATRON CORPORATION",
	[3]byte{216, 157, 103}: "Hewlett Packard",
	[3]byte{216, 157, 185}: "eMegatech International Corp.",
	[3]byte{216, 158, 63}:  "Apple",
	[3]byte{216, 162, 94}:  "Apple",
	[3]byte{216, 174, 144}: "Itibia Technologies",
	[3]byte{216, 175, 59}:  "Hangzhou Bigbright Integrated communications system Co.,Ltd",
	[3]byte{216, 175, 241}: "Panasonic Appliances Company",
	[3]byte{216, 176, 46}:  "Guangzhou Zonerich Business Machine Co., Ltd",
	[3]byte{216, 176, 76}:  "Jinan USR IOT Technology Co., Ltd.",
	[3]byte{216, 177, 42}:  "Panasonic Mobile Communications Co., Ltd.",
	[3]byte{216, 179, 119}: "HTC Corporation",
	[3]byte{216, 182, 183}: "Comtrend Corporation",
	[3]byte{216, 182, 193}: "NetworkAccountant, Inc.",
	[3]byte{216, 182, 214}: "Blu Tether Limited",
	[3]byte{216, 184, 246}: "Nantworks",
	[3]byte{216, 185, 14}:  "Triple Domain Vision Co.,Ltd.",
	[3]byte{216, 187, 44}:  "Apple",
	[3]byte{216, 191, 76}:  "Victory Concept Electronics Limited",
	[3]byte{216, 192, 104}: "Netgenetech.co.,ltd.",
	[3]byte{216, 195, 251}: "DETRACOM",
	[3]byte{216, 198, 145}: "Hichan Technology Corp.",
	[3]byte{216, 199, 200}: "Aruba Networks",
	[3]byte{216, 201, 157}: "EA DISPLAY LIMITED",
	[3]byte{216, 203, 138}: "Micro-Star INTL CO., LTD.",
	[3]byte{216, 207, 156}: "Apple",
	[3]byte{216, 209, 203}: "Apple",
	[3]byte{216, 210, 124}: "JEMA ENERGY, SA",
	[3]byte{216, 211, 133}: "Hewlett-Packard Company",
	[3]byte{216, 212, 60}:  "Sony Corporation",
	[3]byte{216, 213, 185}: "Rainforest Automation, Inc.",
	[3]byte{216, 214, 126}: "GSK CNC EQUIPMENT CO.,LTD",
	[3]byte{216, 218, 82}:  "APATOR S.A.",
	[3]byte{216, 220, 233}: "Kunshan Erlab ductless filtration system Co.,Ltd",
	[3]byte{216, 221, 95}:  "BALMUDA Inc.",
	[3]byte{216, 221, 253}: "Texas Instruments",
	[3]byte{216, 222, 206}: "ISUNG CO.,LTD",
	[3]byte{216, 223, 13}:  "beroNet GmbH",
	[3]byte{216, 227, 174}: "CIRTEC MEDICAL SYSTEMS",
	[3]byte{216, 229, 109}: "TCT Mobile Limited",
	[3]byte{216, 231, 43}:  "NetScout Systems, Inc.",
	[3]byte{216, 231, 67}:  "Wush, Inc",
	[3]byte{216, 233, 82}:  "KEOPSYS",
	[3]byte{216, 235, 151}: "TRENDnet, Inc.",
	[3]byte{216, 238, 120}: "Moog Protokraft",
	[3]byte{216, 240, 242}: "Zeebo Inc",
	[3]byte{216, 247, 16}:  "Libre Wireless Technologies Inc.",
	[3]byte{216, 251, 17}:  "AXACORE",
	[3]byte{216, 252, 147}: "Intel Corporate",
	[3]byte{216, 254, 143}: "IDFone Co., Ltd.",
	[3]byte{216, 254, 227}: "D-Link International",
	[3]byte{220, 2, 101}:   "Meditech Kft",
	[3]byte{220, 2, 142}:   "zte corporation",
	[3]byte{220, 5, 47}:    "National Products Inc.",
	[3]byte{220, 5, 117}:   "SIEMENS ENERGY AUTOMATION",
	[3]byte{220, 5, 237}:   "Nabtesco  Corporation",
	[3]byte{220, 7, 193}:   "HangZhou QiYang Technology Co.,Ltd.",
	[3]byte{220, 11, 26}:   "ADB Broadband Italia",
	[3]byte{220, 14, 161}:  "COMPAL INFORMATION (KUNSHAN) CO., LTD",
	[3]byte{220, 22, 162}:  "Medtronic Diabetes",
	[3]byte{220, 23, 90}:   "Hitachi High-Technologies Corporation",
	[3]byte{220, 23, 146}:  "Captivate Network",
	[3]byte{220, 29, 159}:  "U & B tech",
	[3]byte{220, 29, 212}:  "Microstep-MIS spol. s r.o.",
	[3]byte{220, 30, 163}:  "Accensus LLC",
	[3]byte{220, 32, 8}:    "ASD Electronics Ltd",
	[3]byte{220, 42, 20}:   "Shanghai Longjing Technology Co.",
	[3]byte{220, 43, 97}:   "Apple",
	[3]byte{220, 43, 102}:  "InfoBLOCK S.A. de C.V.",
	[3]byte{220, 43, 202}:  "Zera GmbH",
	[3]byte{220, 44, 38}:   "Iton Technology Limited",
	[3]byte{220, 46, 106}:  "HCT. Co., Ltd.",
	[3]byte{220, 47, 3}:    "Step forward Group Co., Ltd.",
	[3]byte{220, 48, 156}:  "Heyrex Limited",
	[3]byte{220, 51, 80}:   "TechSAT GmbH",
	[3]byte{220, 55, 210}:  "Hunan HKT Electronic Technology Co., Ltd",
	[3]byte{220, 56, 225}:  "Juniper networks",
	[3]byte{220, 57, 121}:  "Skyport Systems",
	[3]byte{220, 58, 94}:   "Roku, Inc",
	[3]byte{220, 60, 46}:   "Manufacturing System Insights, Inc.",
	[3]byte{220, 60, 132}:  "Ticom Geomatics, Inc.",
	[3]byte{220, 62, 81}:   "Solberg & Andersen AS",
	[3]byte{220, 62, 248}:  "Nokia Corporation",
	[3]byte{220, 69, 23}:   "ARRIS Group, Inc.",
	[3]byte{220, 73, 201}:  "CASCO SIGNAL LTD",
	[3]byte{220, 78, 222}:  "SHINYEI TECHNOLOGY CO., LTD.",
	[3]byte{220, 83, 124}:  "Compal Broadband Networks, Inc.",
	[3]byte{220, 87, 38}:   "Power-One",
	[3]byte{220, 94, 54}:   "Paterson Technology",
	[3]byte{220, 100, 124}: "C.R.S. iiMotion GmbH",
	[3]byte{220, 102, 58}:  "Apacer Technology Inc.",
	[3]byte{220, 111, 0}:   "Livescribe, Inc.",
	[3]byte{220, 111, 8}:   "Bay Storage Technology",
	[3]byte{220, 112, 20}:  "PRIVATE",
	[3]byte{220, 113, 68}:  "Samsung Electro Mechanics",
	[3]byte{220, 123, 148}: "CISCO SYSTEMS, INC.",
	[3]byte{220, 130, 91}:  "JANUS, spol. s r.o.",
	[3]byte{220, 133, 222}: "Azurewave Technologies., inc.",
	[3]byte{220, 134, 216}: "Apple, Inc",
	[3]byte{220, 155, 30}:  "Intercom, Inc.",
	[3]byte{220, 155, 156}: "Apple",
	[3]byte{220, 156, 82}:  "Sapphire Technology Limited.",
	[3]byte{220, 159, 164}: "Nokia Corporation",
	[3]byte{220, 159, 219}: "Ubiquiti Networks, Inc.",
	[3]byte{220, 165, 244}: "Cisco",
	[3]byte{220, 166, 189}: "Beijing Lanbo Technology Co., Ltd.",
	[3]byte{220, 167, 217}: "Compressor Controls Corp",
	[3]byte{220, 168, 207}: "New Spin Golf, LLC.",
	[3]byte{220, 169, 113}: "Intel Corporate",
	[3]byte{220, 169, 137}: "MACANDC",
	[3]byte{220, 173, 158}: "GreenPriz",
	[3]byte{220, 174, 4}:   "CELOXICA Ltd",
	[3]byte{220, 176, 88}:  "Burkert Werke GmbH",
	[3]byte{220, 180, 196}: "Microsoft XCG",
	[3]byte{220, 191, 144}: "HUIZHOU QIAOXING TELECOMMUNICATION INDUSTRY CO.,LTD.",
	[3]byte{220, 192, 219}: "Shenzhen Kaiboer Technology Co., Ltd.",
	[3]byte{220, 193, 1}:   "SOLiD Technologies, Inc.",
	[3]byte{220, 196, 34}:  "Systembase Limited",
	[3]byte{220, 198, 34}:  "BUHEUNG SYSTEM",
	[3]byte{220, 199, 147}: "Nokia Corporation",
	[3]byte{220, 203, 168}: "Explora Technologies Inc",
	[3]byte{220, 206, 65}:  "FE GLOBAL HONG KONG LIMITED",
	[3]byte{220, 206, 188}: "Shenzhen JSR Technology Co.,Ltd.",
	[3]byte{220, 207, 148}: "Beijing Rongcheng Hutong Technology Co., Ltd.",
	[3]byte{220, 208, 247}: "Bentek Systems Ltd.",
	[3]byte{220, 210, 252}: "HUAWEI TECHNOLOGIES CO.,LTD",
	[3]byte{220, 211, 33}:  "HUMAX co.,tld",
	[3]byte{220, 213, 42}:  "Sunny Heart Limited",
	[3]byte{220, 216, 127}: "Shenzhen JoinCyber Telecom Equipment Ltd",
	[3]byte{220, 218, 79}:  "GETCK TECHNOLOGY,  INC",
	[3]byte{220, 222, 202}: "Akyllor",
	[3]byte{220, 226, 172}: "Lumens Digital Optics Inc.",
	[3]byte{220, 229, 120}: "Experimental Factory of Scientific Engineering and Special Design Department",
	[3]byte{220, 231, 28}:  "AUG Elektronik GmbH",
	[3]byte{220, 236, 6}:   "Heimi Network Technology Co., Ltd.",
	[3]byte{220, 240, 93}:  "Letta Teknoloji",
	[3]byte{220, 241, 16}:  "Nokia Corporation",
	[3]byte{220, 247, 85}:  "SITRONIK",
	[3]byte{220, 248, 88}:  "Lorent Networks, Inc.",
	[3]byte{220, 250, 213}: "STRONG Ges.m.b.H.",
	[3]byte{220, 251, 2}:   "Buffalo Inc.",
	[3]byte{224, 5, 197}:   "TP-LINK Technologies Co.,Ltd.",
	[3]byte{224, 6, 230}:   "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{224, 11, 40}:   "Inovonics",
	[3]byte{224, 12, 127}:  "Nintendo Co., Ltd.",
	[3]byte{224, 13, 185}:  "PRIVATE",
	[3]byte{224, 16, 127}:  "Ruckus Wireless",
	[3]byte{224, 20, 62}:   "Modoosis Inc.",
	[3]byte{224, 24, 119}:  "Fujitsu Limited",
	[3]byte{224, 28, 65}:   "Aerohive Networks Inc.",
	[3]byte{224, 28, 238}:  "Bravo Tech, Inc.",
	[3]byte{224, 29, 56}:   "Beijing HuaqinWorld Technology Co.,Ltd",
	[3]byte{224, 29, 59}:   "Cambridge Industries(Group) Co.,Ltd",
	[3]byte{224, 30, 7}:    "Anite Telecoms  US. Inc",
	[3]byte{224, 31, 10}:   "Xslent Energy Technologies. LLC",
	[3]byte{224, 36, 127}:  "HUAWEI TECHNOLOGIES CO.,LTD",
	[3]byte{224, 37, 56}:   "Titan Pet Products",
	[3]byte{224, 38, 48}:   "Intrigue Technologies, Inc.",
	[3]byte{224, 38, 54}:   "Nortel Networks",
	[3]byte{224, 39, 26}:   "TTC Next-generation Home Network System WG",
	[3]byte{224, 42, 130}:  "Universal Global Scientific Industrial Co., Ltd.",
	[3]byte{224, 47, 109}:  "Cisco",
	[3]byte{224, 48, 5}:    "Alcatel-Lucent Shanghai Bell Co., Ltd",
	[3]byte{224, 49, 208}:  "SZ Telstar CO., LTD",
	[3]byte{224, 54, 227}:  "Stage One International Co., Ltd.",
	[3]byte{224, 57, 215}:  "Plexxi, Inc.",
	[3]byte{224, 60, 91}:   "SHENZHEN JIAXINJIE ELECTRON CO.,LTD",
	[3]byte{224, 62, 68}:   "Broadcom Corporation",
	[3]byte{224, 62, 74}:   "Cavanagh Group International",
	[3]byte{224, 62, 125}:  "data-complex GmbH",
	[3]byte{224, 63, 73}:   "ASUSTek COMPUTER INC.",
	[3]byte{224, 70, 154}:  "NETGEAR",
	[3]byte{224, 85, 151}:  "Emergent Vision Technologies Inc.",
	[3]byte{224, 86, 244}:  "AxesNetwork Solutions inc.",
	[3]byte{224, 88, 158}:  "Laerdal Medical",
	[3]byte{224, 91, 112}:  "Innovid, Co., Ltd.",
	[3]byte{224, 93, 166}:  "Detlef Fink Elektronik & Softwareentwicklung",
	[3]byte{224, 95, 185}:  "CISCO SYSTEMS, INC.",
	[3]byte{224, 97, 178}:  "HANGZHOU ZENOINTEL TECHNOLOGY CO., LTD",
	[3]byte{224, 98, 144}:  "Jinan Jovision Science & Technology Co., Ltd.",
	[3]byte{224, 99, 229}:  "Sony Mobile Communications AB",
	[3]byte{224, 100, 187}: "DigiView S.r.l.",
	[3]byte{224, 102, 120}: "Apple",
	[3]byte{224, 103, 179}: "C-Data Technology Co., Ltd",
	[3]byte{224, 105, 149}: "PEGATRON CORPORATION",
	[3]byte{224, 117, 10}:  "ALPS ERECTORIC CO.,LTD.",
	[3]byte{224, 117, 125}: "Motorola Mobility LLC",
	[3]byte{224, 124, 98}:  "Whistle Labs, Inc.",
	[3]byte{224, 127, 83}:  "TECHBOARD SRL",
	[3]byte{224, 127, 136}: "EVIDENCE Network SIA",
	[3]byte{224, 129, 119}: "GreenBytes, Inc.",
	[3]byte{224, 135, 177}: "Nata-Info Ltd.",
	[3]byte{224, 136, 93}:  "Technicolor CH USA Inc",
	[3]byte{224, 138, 126}: "Exponent",
	[3]byte{224, 143, 236}: "REPOTEC CO., LTD.",
	[3]byte{224, 145, 83}:  "XAVi Technologies Corp.",
	[3]byte{224, 145, 245}: "NETGEAR",
	[3]byte{224, 148, 103}: "Intel Corporate",
	[3]byte{224, 149, 121}: "ORTHOsoft inc, d/b/a Zimmer CAS",
	[3]byte{224, 151, 150}: "HUAWEI TECHNOLOGIES CO.,LTD",
	[3]byte{224, 151, 242}: "Atomax Inc.",
	[3]byte{224, 157, 49}:  "Intel Corporate",
	[3]byte{224, 157, 184}: "PLANEX COMMUNICATIONS INC.",
	[3]byte{224, 161, 152}: "NOJA Power Switchgear Pty Ltd",
	[3]byte{224, 161, 215}: "SFR",
	[3]byte{224, 163, 15}:  "Pevco",
	[3]byte{224, 166, 112}: "Nokia Corporation",
	[3]byte{224, 170, 176}: "GENERAL VISION ELECTRONICS CO. LTD.",
	[3]byte{224, 171, 254}: "Orb Networks, Inc.",
	[3]byte{224, 172, 241}: "Cisco",
	[3]byte{224, 174, 94}:  "ALPS Co,. Ltd.",
	[3]byte{224, 174, 178}: "Bender GmbH &amp; Co.KG",
	[3]byte{224, 174, 237}: "LOENK",
	[3]byte{224, 175, 75}:  "Pluribus Networks, Inc.",
	[3]byte{224, 178, 241}: "FN-LINK TECHNOLOGY LIMITED",
	[3]byte{224, 181, 45}:  "Apple",
	[3]byte{224, 183, 177}: "Pace plc",
	[3]byte{224, 185, 165}: "Azurewave",
	[3]byte{224, 185, 186}: "Apple",
	[3]byte{224, 188, 67}:  "C2 Microsystems, Inc.",
	[3]byte{224, 194, 134}: "Aisai Communication Technology Co., Ltd.",
	[3]byte{224, 194, 183}: "Masimo Corporation",
	[3]byte{224, 195, 243}: "ZTE Corporation",
	[3]byte{224, 198, 179}: "MilDef AB",
	[3]byte{224, 199, 157}: "Texas Instruments",
	[3]byte{224, 200, 106}: "SHENZHEN TW-SCIE Co., Ltd",
	[3]byte{224, 201, 34}:  "Jireh Energy Tech., Ltd.",
	[3]byte{224, 201, 122}: "Apple",
	[3]byte{224, 202, 77}:  "Shenzhen Unistar Communication Co.,LTD",
	[3]byte{224, 202, 148}: "Askey Computer",
	[3]byte{224, 203, 29}:  "PRIVATE",
	[3]byte{224, 203, 78}:  "ASUSTek COMPUTER INC.",
	[3]byte{224, 203, 238}: "Samsung Electronics Co.,Ltd",
	[3]byte{224, 206, 195}: "ASKEY COMPUTER CORP",
	[3]byte{224, 207, 45}:  "Gemintek Corporation",
	[3]byte{224, 209, 10}:  "Katoudenkikougyousyo co ltd",
	[3]byte{224, 209, 230}: "Aliph dba Jawbone",
	[3]byte{224, 211, 26}:  "EQUES Technology Co., Limited",
	[3]byte{224, 215, 186}: "Texas Instruments",
	[3]byte{224, 217, 162}: "Hippih aps",
	[3]byte{224, 218, 220}: "JVC KENWOOD Corporation",
	[3]byte{224, 219, 85}:  "Dell Inc",
	[3]byte{224, 219, 136}: "Open Standard Digital-IF Interface for SATCOM Systems",
	[3]byte{224, 220, 160}: "Siemens Electrical Apparatus Ltd., Suzhou Chengdu Branch",
	[3]byte{224, 230, 49}:  "SNB TECHNOLOGIES LIMITED",
	[3]byte{224, 231, 81}:  "Nintendo Co., Ltd.",
	[3]byte{224, 232, 232}: "Olive Telecommunication Pvt. Ltd",
	[3]byte{224, 237, 26}:  "vastriver Technology Co., Ltd",
	[3]byte{224, 237, 199}: "Shenzhen Friendcom Technology Development Co., Ltd",
	[3]byte{224, 238, 27}:  "Panasonic Automotive Systems Company of America",
	[3]byte{224, 239, 37}:  "Lintes Technology Co., Ltd.",
	[3]byte{224, 242, 17}:  "Digitalwatt",
	[3]byte{224, 243, 121}: "Vaddio",
	[3]byte{224, 245, 198}: "Apple",
	[3]byte{224, 245, 202}: "CHENG UEI PRECISION INDUSTRY CO.,LTD.",
	[3]byte{224, 248, 71}:  "Apple",
	[3]byte{224, 249, 190}: "Cloudena Corp.",
	[3]byte{224, 250, 236}: "Platan sp. z o.o. sp. k.",
	[3]byte{228, 4, 57}:    "TomTom Software Ltd",
	[3]byte{228, 17, 91}:   "Hewlett Packard",
	[3]byte{228, 18, 24}:   "ShenZhen Rapoo Technology Co., Ltd.",
	[3]byte{228, 18, 29}:   "Samsung Electronics Co.,Ltd",
	[3]byte{228, 18, 137}:  "topsystem Systemhaus GmbH",
	[3]byte{228, 28, 75}:   "V2 TECHNOLOGY, INC.",
	[3]byte{228, 29, 45}:   "Mellanox Technologies, Inc.",
	[3]byte{228, 31, 19}:   "IBM Corp",
	[3]byte{228, 35, 84}:   "SHENZHEN FUZHI SOFTWARE TECHNOLOGY CO.,LTD",
	[3]byte{228, 37, 231}:  "Apple",
	[3]byte{228, 37, 233}:  "Color-Chip",
	[3]byte{228, 39, 113}:  "Smartlabs",
	[3]byte{228, 42, 211}:  "Magneti Marelli S.p.A. Powertrain",
	[3]byte{228, 44, 86}:   "Lilee Systems, Ltd.",
	[3]byte{228, 45, 2}:    "TCT Mobile Limited",
	[3]byte{228, 47, 38}:   "Fiberhome Telecommunication Tech.Co.,Ltd.",
	[3]byte{228, 47, 246}:  "Unicore communication Inc.",
	[3]byte{228, 50, 203}:  "Samsung Electronics Co.,Ltd",
	[3]byte{228, 53, 147}:  "Hangzhou GoTo technology Co.Ltd",
	[3]byte{228, 53, 251}:  "Sabre Technology (Hull) Ltd",
	[3]byte{228, 55, 215}:  "HENRI DEPAEPE S.A.S.",
	[3]byte{228, 56, 242}:  "Advantage Controls",
	[3]byte{228, 63, 162}:  "Wuxi DSP Technologies Inc.",
	[3]byte{228, 64, 226}:  "Samsung Electronics Co.,Ltd",
	[3]byte{228, 65, 230}:  "Ottec Technology GmbH",
	[3]byte{228, 70, 189}:  "C&C TECHNIC TAIWAN CO., LTD.",
	[3]byte{228, 72, 199}:  "Cisco SPVTG",
	[3]byte{228, 76, 108}:  "Shenzhen Guo Wei Electronic Co,. Ltd.",
	[3]byte{228, 78, 24}:   "Gardasoft VisionLimited",
	[3]byte{228, 79, 41}:   "MA Lighting Technology GmbH",
	[3]byte{228, 79, 95}:   "EDS Elektronik Destek San.Tic.Ltd.Sti",
	[3]byte{228, 85, 234}:  "Dedicated Computing",
	[3]byte{228, 86, 20}:   "Suttle Apparatus",
	[3]byte{228, 87, 168}:  "Stuart Manufacturing, Inc.",
	[3]byte{228, 93, 82}:   "Avaya, Inc",
	[3]byte{228, 100, 73}:  "ARRIS Group, Inc.",
	[3]byte{228, 103, 186}: "Danish Interpretation Systems A/S",
	[3]byte{228, 104, 163}: "HUAWEI TECHNOLOGIES CO.,LTD",
	[3]byte{228, 108, 33}:  "messMa GmbH",
	[3]byte{228, 113, 133}: "Securifi Ltd",
	[3]byte{228, 117, 30}:  "Getinge Sterilization AB",
	[3]byte{228, 119, 35}:  "zte corporation",
	[3]byte{228, 119, 107}: "AARTESYS AG",
	[3]byte{228, 119, 212}: "Minrray Industry Co.,Ltd",
	[3]byte{228, 124, 249}: "Samsung Electronics Co., LTD",
	[3]byte{228, 125, 90}:  "Beijing Hanbang Technology Corp.",
	[3]byte{228, 127, 178}: "Fujitsu Limited",
	[3]byte{228, 129, 132}: "Alcatel-Lucent",
	[3]byte{228, 129, 179}: "Shenzhen ACT Industrial Co.,Ltd.",
	[3]byte{228, 131, 153}: "ARRIS Group, Inc.",
	[3]byte{228, 138, 213}: "RF WINDOW CO., LTD.",
	[3]byte{228, 139, 127}: "Apple",
	[3]byte{228, 140, 15}:  "Discovery Insure",
	[3]byte{228, 144, 105}: "Rockwell Automation",
	[3]byte{228, 146, 231}: "Gridlink Tech. Co.,Ltd.",
	[3]byte{228, 146, 251}: "Samsung Electronics Co.,Ltd",
	[3]byte{228, 149, 110}: "IEEE REGISTRATION AUTHORITY  - Please see MAM public listing for more information.",
	[3]byte{228, 150, 174}: "ALTOGRAPHICS Inc.",
	[3]byte{228, 151, 240}: "Shanghai VLC Technologies Ltd. Co.",
	[3]byte{228, 152, 214}: "Apple, Inc",
	[3]byte{228, 165, 239}: "TRON LINK ELECTRONICS CO., LTD.",
	[3]byte{228, 167, 253}: "Cellco Partnership",
	[3]byte{228, 171, 70}:  "UAB Selteka",
	[3]byte{228, 173, 125}: "SCL Elements",
	[3]byte{228, 175, 161}: "HES-SO",
	[3]byte{228, 176, 33}:  "Samsung Electronics Co.,Ltd",
	[3]byte{228, 186, 217}: "360 Fly Inc.",
	[3]byte{228, 193, 70}:  "Objetivos y Servicios de Valor A",
	[3]byte{228, 198, 43}:  "Airware",
	[3]byte{228, 198, 61}:  "Apple, Inc.",
	[3]byte{228, 198, 230}: "Mophie, LLC",
	[3]byte{228, 199, 34}:  "Cisco",
	[3]byte{228, 200, 6}:   "Ceiec Electric Technology Inc.",
	[3]byte{228, 206, 143}: "Apple",
	[3]byte{228, 211, 50}:  "TP-LINK TECHNOLOGIES CO.,LTD.",
	[3]byte{228, 211, 241}: "Cisco",
	[3]byte{228, 213, 61}:  "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{228, 215, 29}:  "Oraya Therapeutics",
	[3]byte{228, 221, 121}: "En-Vision America, Inc.",
	[3]byte{228, 224, 197}: "Samsung Electronics Co., LTD",
	[3]byte{228, 228, 9}:   "LEIFHEIT AG",
	[3]byte{228, 236, 16}:  "Nokia Corporation",
	[3]byte{228, 238, 253}: "MR&D Manufacturing",
	[3]byte{228, 243, 101}: "Time-O-Matic, Inc.",
	[3]byte{228, 243, 227}: "Shanghai iComhome Co.,Ltd.",
	[3]byte{228, 244, 198}: "NETGEAR",
	[3]byte{228, 247, 161}: "Datafox GmbH",
	[3]byte{228, 248, 239}: "Samsung Elec Co.,Ltd",
	[3]byte{228, 250, 29}:  "PAD Peripheral Advanced Design Inc.",
	[3]byte{228, 255, 221}: "ELECTRON INDIA",
	[3]byte{232, 3, 154}:   "Samsung Electronics CO., LTD",
	[3]byte{232, 4, 11}:    "Apple",
	[3]byte{232, 4, 16}:    "PRIVATE",
	[3]byte{232, 4, 98}:    "CISCO SYSTEMS, INC.",
	[3]byte{232, 4, 243}:   "Throughtek Co., Ltd.",
	[3]byte{232, 5, 109}:   "Nortel Networks",
	[3]byte{232, 6, 136}:   "Apple",
	[3]byte{232, 8, 139}:   "Huawei Technologies Co., Ltd",
	[3]byte{232, 11, 19}:   "Akib Systems Taiwan, INC",
	[3]byte{232, 12, 56}:   "DAEYOUNG INFORMATION SYSTEM CO., LTD",
	[3]byte{232, 12, 117}:  "Syncbak, Inc.",
	[3]byte{232, 16, 46}:   "Really Simple Software, Inc",
	[3]byte{232, 17, 50}:   "Samsung Electronics CO., LTD",
	[3]byte{232, 19, 36}:   "GuangZhou Bonsoninfo System CO.,LTD",
	[3]byte{232, 21, 14}:   "Nokia Corporation",
	[3]byte{232, 23, 252}:  "NIFTY Corporation",
	[3]byte{232, 24, 99}:   "IEEE REGISTRATION AUTHORITY  - Please see MAM public listing for more information.",
	[3]byte{232, 40, 119}:  "TMY Co., Ltd.",
	[3]byte{232, 40, 213}:  "Cots Technology",
	[3]byte{232, 42, 234}:  "Intel Corporate",
	[3]byte{232, 46, 36}:   "Out of the Fog Research LLC",
	[3]byte{232, 51, 129}:  "ARRIS Group, Inc.",
	[3]byte{232, 57, 53}:   "Hewlett Packard",
	[3]byte{232, 57, 223}:  "Askey Computer",
	[3]byte{232, 58, 151}:  "OCZ Technology Group",
	[3]byte{232, 62, 182}:  "RIM",
	[3]byte{232, 62, 251}:  "GEODESIC LTD.",
	[3]byte{232, 62, 252}:  "ARRIS Group, Inc.",
	[3]byte{232, 64, 64}:   "CISCO SYSTEMS, INC.",
	[3]byte{232, 64, 242}:  "PEGATRON CORPORATION",
	[3]byte{232, 67, 182}:  "QNAP Systems, Inc.",
	[3]byte{232, 72, 31}:   "Advanced Automotive Antennas",
	[3]byte{232, 78, 6}:    "EDUP INTERNATIONAL (HK) CO., LTD",
	[3]byte{232, 78, 132}:  "Samsung Electronics Co.,Ltd",
	[3]byte{232, 78, 206}:  "Nintendo Co., Ltd.",
	[3]byte{232, 81, 110}:  "TSMART Inc.",
	[3]byte{232, 81, 157}:  "Yeonhab Precision Co.,LTD",
	[3]byte{232, 84, 132}:  "NEO INFORMATION SYSTEMS CO., LTD.",
	[3]byte{232, 86, 214}:  "NCTech Ltd",
	[3]byte{232, 90, 167}:  "LLC Emzior",
	[3]byte{232, 91, 91}:   "LG ELECTRONICS INC",
	[3]byte{232, 91, 240}:  "Imaging Diagnostics",
	[3]byte{232, 93, 107}:  "Luminate Wireless",
	[3]byte{232, 94, 83}:   "Infratec Datentechnik GmbH",
	[3]byte{232, 97, 31}:   "Dawning Information Industry Co.,Ltd",
	[3]byte{232, 97, 126}:  "Liteon Technology Corporation",
	[3]byte{232, 97, 131}:  "Black Diamond Advanced Technology, LLC",
	[3]byte{232, 108, 218}: "Supercomputers and Neurocomputers Research Center",
	[3]byte{232, 109, 82}:  "ARRIS Group, Inc.",
	[3]byte{232, 109, 84}:  "Digit Mobile Inc",
	[3]byte{232, 109, 110}: "Control & Display Systems Ltd t/a CDSRail",
	[3]byte{232, 113, 141}: "Elsys Equipamentos Eletronicos Ltda",
	[3]byte{232, 117, 127}: "FIRS Technologies(Shenzhen) Co., Ltd",
	[3]byte{232, 120, 161}: "BEOVIEW INTERCOM DOO",
	[3]byte{232, 122, 243}: "S5 Tech S.r.l.",
	[3]byte{232, 128, 46}:  "Apple",
	[3]byte{232, 128, 216}: "GNTEK Electronics Co.,Ltd.",
	[3]byte{232, 135, 163}: "Loxley Public Company Limited",
	[3]byte{232, 137, 44}:  "ARRIS Group, Inc.",
	[3]byte{232, 141, 40}:  "Apple",
	[3]byte{232, 141, 245}: "ZNYX Networks, Inc.",
	[3]byte{232, 142, 96}:  "NSD Corporation",
	[3]byte{232, 146, 24}:  "Arcontia International AB",
	[3]byte{232, 146, 164}: "LG Electronics",
	[3]byte{232, 148, 76}:  "Cogent Healthcare Systems Ltd",
	[3]byte{232, 148, 246}: "TP-LINK TECHNOLOGIES CO.,LTD.",
	[3]byte{232, 150, 6}:   "testo Instruments (Shenzhen) Co., Ltd.",
	[3]byte{232, 153, 90}:  "PiiGAB, Processinformation i Goteborg AB",
	[3]byte{232, 153, 196}: "HTC Corporation",
	[3]byte{232, 154, 143}: "Quanta Computer Inc.",
	[3]byte{232, 154, 255}: "Fujian Landi Commercial Equipment Co.,Ltd",
	[3]byte{232, 157, 135}: "Toshiba",
	[3]byte{232, 163, 100}: "Signal Path International / Peachtree Audio",
	[3]byte{232, 164, 193}: "Deep Sea Electronics PLC",
	[3]byte{232, 171, 250}: "Shenzhen Reecam Tech.Ltd.",
	[3]byte{232, 177, 252}: "Intel Corporate",
	[3]byte{232, 180, 174}: "Shenzhen C&D Electronics Co.,Ltd",
	[3]byte{232, 183, 72}:  "CISCO SYSTEMS, INC.",
	[3]byte{232, 186, 112}: "CISCO SYSTEMS, INC.",
	[3]byte{232, 187, 61}:  "Sino Prime-Tech Limited",
	[3]byte{232, 187, 168}: "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.,LTD.",
	[3]byte{232, 190, 129}: "SAGEMCOM",
	[3]byte{232, 194, 41}:  "H-Displays (MSC) Bhd",
	[3]byte{232, 195, 32}:  "Austco Communication Systems Pty Ltd",
	[3]byte{232, 203, 161}: "Nokia Corporation",
	[3]byte{232, 204, 24}:  "D-Link International",
	[3]byte{232, 204, 50}:  "Micronet  LTD",
	[3]byte{232, 205, 45}:  "Huawei Technologies Co., Ltd",
	[3]byte{232, 206, 6}:   "SkyHawke Technologies, LLC.",
	[3]byte{232, 208, 250}: "MKS Instruments Deutschland GmbH",
	[3]byte{232, 212, 131}: "ULTIMATE Europe Transportation Equipment GmbH",
	[3]byte{232, 212, 224}: "Beijing BenyWave Technology Co., Ltd.",
	[3]byte{232, 218, 150}: "Zhuhai Tianrui Electrical Power Tech. Co., Ltd.",
	[3]byte{232, 218, 170}: "VideoHome Technology Corp.",
	[3]byte{232, 222, 39}:  "TP-LINK TECHNOLOGIES CO.,LTD.",
	[3]byte{232, 223, 242}: "PRF Co., Ltd.",
	[3]byte{232, 224, 143}: "GRAVOTECH MARKING SAS",
	[3]byte{232, 224, 183}: "Toshiba",
	[3]byte{232, 225, 226}: "Energotest",
	[3]byte{232, 229, 214}: "Samsung Electronics Co.,Ltd",
	[3]byte{232, 231, 50}:  "Alcatel-Lucent",
	[3]byte{232, 231, 112}: "Warp9 Tech Design, Inc.",
	[3]byte{232, 231, 118}: "Shenzhen Kootion Technology Co., Ltd",
	[3]byte{232, 232, 117}: "iS5 Communications Inc.",
	[3]byte{232, 234, 106}: "StarTech.com",
	[3]byte{232, 234, 218}: "Denkovi Assembly Electroncs LTD",
	[3]byte{232, 237, 5}:   "ARRIS Group, Inc.",
	[3]byte{232, 237, 243}: "Cisco",
	[3]byte{232, 239, 137}: "OPMEX Tech.",
	[3]byte{232, 241, 176}: "SAGEMCOM SAS",
	[3]byte{232, 242, 38}:  "MILLSON CUSTOM SOLUTIONS INC.",
	[3]byte{232, 249, 40}:  "RFTECH SRL",
	[3]byte{232, 252, 96}:  "ELCOM Innovations Private Limited",
	[3]byte{232, 252, 175}: "NETGEAR INC.,",
	[3]byte{236, 14, 196}:  "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{236, 14, 214}:  "ITECH INSTRUMENTS SAS",
	[3]byte{236, 17, 32}:   "FloDesign Wind Turbine Corporation",
	[3]byte{236, 19, 178}:  "Netonix",
	[3]byte{236, 20, 246}:  "BioControl AS",
	[3]byte{236, 23, 47}:   "TP-LINK TECHNOLOGIES CO., LTD.",
	[3]byte{236, 23, 102}:  "Research Centre Module",
	[3]byte{236, 26, 89}:   "Belkin International Inc.",
	[3]byte{236, 29, 127}:  "zte corporation",
	[3]byte{236, 33, 159}:  "VidaBox LLC",
	[3]byte{236, 34, 87}:   "JiangSu NanJing University Electronic Information Technology Co.,Ltd",
	[3]byte{236, 34, 128}:  "D-Link International",
	[3]byte{236, 35, 61}:   "Huawei Technologies Co., Ltd",
	[3]byte{236, 35, 104}:  "IntelliVoice Co.,Ltd.",
	[3]byte{236, 36, 184}:  "Texas Instruments",
	[3]byte{236, 42, 240}:  "Ypsomed AG",
	[3]byte{236, 44, 73}:   "University of Tokyo",
	[3]byte{236, 46, 78}:   "HITACHI-LG DATA STORAGE INC",
	[3]byte{236, 48, 145}:  "CISCO SYSTEMS, INC.",
	[3]byte{236, 53, 134}:  "Apple",
	[3]byte{236, 59, 240}:  "NovelSat",
	[3]byte{236, 60, 90}:   "SHEN ZHEN HENG SHENG HUI DIGITAL TECHNOLOGY CO.,LTD",
	[3]byte{236, 62, 9}:    "PERFORMANCE DESIGNED PRODUCTS, LLC",
	[3]byte{236, 63, 5}:    "Institute 706, The Second Academy China Aerospace Science & Industry Corp",
	[3]byte{236, 66, 240}:  "ADL Embedded Solutions, Inc.",
	[3]byte{236, 67, 230}:  "AWCER Ltd.",
	[3]byte{236, 67, 246}:  "ZyXEL Communications Corporation",
	[3]byte{236, 68, 118}:  "CISCO SYSTEMS, INC.",
	[3]byte{236, 70, 68}:   "TTK SAS",
	[3]byte{236, 70, 112}:  "Meinberg Funkuhren GmbH & Co. KG",
	[3]byte{236, 71, 60}:   "Redwire, LLC",
	[3]byte{236, 73, 147}:  "Qihan Technology Co., Ltd",
	[3]byte{236, 76, 77}:   "ZAO NPK RoTeK",
	[3]byte{236, 84, 46}:   "Shanghai XiMei Electronic Technology Co. Ltd",
	[3]byte{236, 85, 249}:  "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{236, 89, 231}:  "Microsoft Corporation",
	[3]byte{236, 92, 105}:  "MITSUBISHI HEAVY INDUSTRIES MECHATRONICS SYSTEMS,LTD.",
	[3]byte{236, 98, 100}:  "Global411 Internet Services, LLC",
	[3]byte{236, 99, 229}:  "ePBoard Design LLC",
	[3]byte{236, 102, 209}: "B&W Group LTD",
	[3]byte{236, 108, 159}: "Chengdu Volans Technology CO.,LTD",
	[3]byte{236, 113, 219}: "Shenzhen Baichuan Digital Technology Co., Ltd.",
	[3]byte{236, 124, 116}: "Justone Technologies Co., Ltd.",
	[3]byte{236, 125, 157}: "MEI",
	[3]byte{236, 128, 9}:   "NovaSparks",
	[3]byte{236, 131, 108}: "RM Tech Co., Ltd.",
	[3]byte{236, 133, 47}:  "Apple",
	[3]byte{236, 136, 143}: "TP-LINK TECHNOLOGIES CO., LTD.",
	[3]byte{236, 137, 245}: "Lenovo Mobile Communication Technology Ltd.",
	[3]byte{236, 138, 76}:  "zte corporation",
	[3]byte{236, 142, 173}: "DLX",
	[3]byte{236, 146, 51}:  "Eddyfi NDT Inc",
	[3]byte{236, 147, 39}:  "MEMMERT GmbH + Co. KG",
	[3]byte{236, 150, 129}: "2276427 Ontario Inc",
	[3]byte{236, 152, 108}: "Lufft Mess- und Regeltechnik GmbH",
	[3]byte{236, 152, 193}: "Beijing Risbo Network Technology Co.,Ltd",
	[3]byte{236, 154, 116}: "Hewlett Packard",
	[3]byte{236, 155, 91}:  "Nokia Corporation",
	[3]byte{236, 158, 205}: "Artesyn Embedded Technologies",
	[3]byte{236, 162, 155}: "Kemppi Oy",
	[3]byte{236, 168, 107}: "ELITEGROUP COMPUTER SYSTEMS CO., LTD.",
	[3]byte{236, 177, 6}:   "Acuro Networks, Inc",
	[3]byte{236, 181, 65}:  "SHINANO E and E Co.Ltd.",
	[3]byte{236, 185, 7}:   "CloudGenix Inc",
	[3]byte{236, 187, 174}: "Digivoice Tecnologia em Eletronica Ltda",
	[3]byte{236, 189, 9}:   "FUSION Electronics Ltd",
	[3]byte{236, 195, 138}: "Accuenergy (CANADA) Inc",
	[3]byte{236, 200, 130}: "CISCO SYSTEMS, INC.",
	[3]byte{236, 203, 48}:  "Huawei Technologies Co., Ltd",
	[3]byte{236, 205, 109}: "Allied Telesis, Inc.",
	[3]byte{236, 208, 14}:  "MiraeRecognition Co., Ltd.",
	[3]byte{236, 208, 64}:  "GEA Farm Technologies GmbH",
	[3]byte{236, 209, 154}: "Zhuhai Liming Industries Co., Ltd",
	[3]byte{236, 217, 37}:  "RAMI",
	[3]byte{236, 217, 80}:  "IRT SA",
	[3]byte{236, 217, 209}: "Shenzhen TG-NET Botone Technology Co.,Ltd.",
	[3]byte{236, 222, 61}:  "Lamprey Networks, Inc.",
	[3]byte{236, 224, 155}: "Samsung electronics CO., LTD",
	[3]byte{236, 225, 169}: "Cisco",
	[3]byte{236, 229, 18}:  "tado GmbH",
	[3]byte{236, 229, 85}:  "Hirschmann Automation",
	[3]byte{236, 231, 68}:  "Omntec mfg. inc",
	[3]byte{236, 233, 11}:  "SISTEMA SOLUCOES ELETRONICAS LTDA - EASYTECH",
	[3]byte{236, 233, 21}:  "STI Ltd",
	[3]byte{236, 233, 248}: "Guang Zhou TRI-SUN Electronics Technology  Co., Ltd",
	[3]byte{236, 234, 3}:   "DARFON LIGHTING CORP",
	[3]byte{236, 240, 14}:  "Abocom",
	[3]byte{236, 242, 54}:  "NEOMONTANA ELECTRONICS",
	[3]byte{236, 243, 91}:  "Nokia Corporation",
	[3]byte{236, 244, 187}: "Dell Inc",
	[3]byte{236, 247, 43}:  "HD DIGITAL TECH CO., LTD.",
	[3]byte{236, 250, 170}: "The IMS Company",
	[3]byte{236, 252, 85}:  "A. Eberle GmbH & Co. KG",
	[3]byte{236, 254, 126}: "BlueRadios, Inc.",
	[3]byte{240, 0, 127}:   "Janz - Contadores de Energia, SA",
	[3]byte{240, 2, 43}:    "Chrontel",
	[3]byte{240, 2, 72}:    "SmarteBuilding",
	[3]byte{240, 7, 134}:   "Shandong Bittel Electronics Co., Ltd",
	[3]byte{240, 8, 241}:   "Samsung Electronics Co.,Ltd",
	[3]byte{240, 19, 195}:  "SHENZHEN FENDA TECHNOLOGY CO., LTD",
	[3]byte{240, 21, 160}:  "KyungDong One Co., Ltd.",
	[3]byte{240, 28, 19}:   "LG Electronics",
	[3]byte{240, 28, 45}:   "Juniper Networks",
	[3]byte{240, 31, 175}:  "Dell Inc",
	[3]byte{240, 33, 157}:  "Cal-Comp Electronics & Communications Company Ltd.",
	[3]byte{240, 35, 41}:   "SHOWA DENKI CO.,LTD.",
	[3]byte{240, 36, 5}:    "OPUS High Technology Corporation",
	[3]byte{240, 36, 8}:    "Talaris (Sweden) AB",
	[3]byte{240, 37, 114}:  "CISCO SYSTEMS, INC.",
	[3]byte{240, 37, 183}:  "Samsung Electro Mechanics co., LTD.",
	[3]byte{240, 38, 76}:   "Dr. Sigrist AG",
	[3]byte{240, 39, 101}:  "Murata Manufactuaring Co.,Ltd.",
	[3]byte{240, 41, 41}:   "Cisco",
	[3]byte{240, 42, 97}:   "Waldo Networks, Inc.",
	[3]byte{240, 47, 216}:  "Bi2-Vision",
	[3]byte{240, 50, 26}:   "Mita-Teknik A/S",
	[3]byte{240, 55, 161}:  "Huike Electronics (SHENZHEN) CO., LTD.",
	[3]byte{240, 58, 75}:   "Bloombase, Inc.",
	[3]byte{240, 58, 85}:   "Omega Elektronik AS",
	[3]byte{240, 61, 41}:   "Actility",
	[3]byte{240, 63, 248}:  "R L Drake",
	[3]byte{240, 67, 53}:   "DVN(Shanghai)Ltd.",
	[3]byte{240, 74, 43}:   "PYRAMID Computer GmbH",
	[3]byte{240, 75, 106}:  "Scientific Production Association Siberian Arsenal, Ltd.",
	[3]byte{240, 75, 242}:  "JTECH Communications, Inc.",
	[3]byte{240, 77, 162}:  "Dell Inc.",
	[3]byte{240, 79, 124}:  "PRIVATE",
	[3]byte{240, 88, 73}:   "CareView Communications",
	[3]byte{240, 90, 9}:    "Samsung Electronics Co.,Ltd",
	[3]byte{240, 93, 137}:  "Dycon Limited",
	[3]byte{240, 93, 200}:  "Duracell Powermat",
	[3]byte{240, 95, 90}:   "Getriebebau NORD GmbH and Co. KG",
	[3]byte{240, 97, 48}:   "Advantage Pharmacy Services, LLC",
	[3]byte{240, 98, 13}:   "Shenzhen Egreat Tech Corp.,Ltd",
	[3]byte{240, 98, 129}:  "ProCurve Networking by HP",
	[3]byte{240, 101, 221}: "Primax Electronics Ltd.",
	[3]byte{240, 104, 83}:  "Integrated Corporation",
	[3]byte{240, 107, 202}: "Samsung Electronics Co.,Ltd",
	[3]byte{240, 114, 140}: "Samsung Electronics Co.,Ltd",
	[3]byte{240, 115, 174}: "PEAK-System Technik",
	[3]byte{240, 118, 28}:  "COMPAL INFORMATION (KUNSHAN) CO., LTD.",
	[3]byte{240, 119, 101}: "Sourcefire, Inc",
	[3]byte{240, 119, 208}: "Xcellen",
	[3]byte{240, 123, 203}: "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{240, 125, 104}: "D-Link Corporation",
	[3]byte{240, 127, 6}:   "Cisco",
	[3]byte{240, 127, 12}:  "Leopold Kostal GmbH &Co. KG",
	[3]byte{240, 129, 175}: "IRZ AUTOMATION TECHNOLOGIES LTD",
	[3]byte{240, 130, 97}:  "SAGEMCOM",
	[3]byte{240, 132, 47}:  "ADB Broadband Italia",
	[3]byte{240, 132, 201}: "zte corporation",
	[3]byte{240, 138, 40}:  "JIANGSU HENGSION ELECTRONIC S and T CO.,LTD",
	[3]byte{240, 139, 254}: "COSTEL.,CO.LTD",
	[3]byte{240, 140, 251}: "Fiberhome Telecommunication Tech.Co.,Ltd.",
	[3]byte{240, 142, 219}: "VeloCloud Networks",
	[3]byte{240, 146, 28}:  "Hewlett Packard",
	[3]byte{240, 147, 58}:  "NxtConect",
	[3]byte{240, 147, 197}: "Garland Technology",
	[3]byte{240, 156, 187}: "RaonThink Inc.",
	[3]byte{240, 156, 233}: "Aerohive Networks Inc",
	[3]byte{240, 158, 99}:  "Cisco",
	[3]byte{240, 162, 37}:  "PRIVATE",
	[3]byte{240, 167, 100}: "GST Co., Ltd.",
	[3]byte{240, 172, 164}: "HBC-radiomatic",
	[3]byte{240, 173, 78}:  "Globalscale Technologies, Inc.",
	[3]byte{240, 174, 81}:  "Xi3 Corp",
	[3]byte{240, 180, 121}: "Apple",
	[3]byte{240, 182, 235}: "Poslab Technology Co., Ltd.",
	[3]byte{240, 188, 200}: "MaxID (Pty) Ltd",
	[3]byte{240, 189, 241}: "Sipod Inc.",
	[3]byte{240, 191, 151}: "Sony Corporation",
	[3]byte{240, 193, 241}: "Apple, Inc.",
	[3]byte{240, 194, 76}:  "Zhejiang FeiYue Digital Technology Co., Ltd",
	[3]byte{240, 194, 124}: "Mianyang Netop Telecom Equipment Co.,Ltd.",
	[3]byte{240, 200, 140}: "LeddarTech Inc.",
	[3]byte{240, 203, 161}: "Apple",
	[3]byte{240, 209, 79}:  "LINEAR LLC",
	[3]byte{240, 209, 169}: "Apple",
	[3]byte{240, 211, 167}: "CobaltRay Co., Ltd",
	[3]byte{240, 211, 231}: "Sensometrix SA",
	[3]byte{240, 215, 103}: "Axema Passagekontroll AB",
	[3]byte{240, 218, 124}: "RLH INDUSTRIES,INC.",
	[3]byte{240, 219, 48}:  "Yottabyte",
	[3]byte{240, 219, 248}: "Apple",
	[3]byte{240, 220, 226}: "Apple",
	[3]byte{240, 222, 113}: "Shanghai EDO Technologies Co.,Ltd.",
	[3]byte{240, 222, 185}: "ShangHai Y&Y Electronics Co., Ltd",
	[3]byte{240, 222, 241}: "Wistron InfoComm (Kunshan)Co",
	[3]byte{240, 229, 195}: "Drägerwerk AG & Co. KG aA",
	[3]byte{240, 231, 126}: "Samsung Electronics Co.,Ltd",
	[3]byte{240, 235, 208}: "Shanghai Feixun Communication Co.,Ltd.",
	[3]byte{240, 236, 57}:  "Essec",
	[3]byte{240, 237, 30}:  "Bilkon Bilgisayar Kontrollu Cih. Im.Ltd.",
	[3]byte{240, 238, 187}: "VIPAR GmbH",
	[3]byte{240, 240, 2}:   "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{240, 242, 96}:  "Mobitec AB",
	[3]byte{240, 243, 54}:  "TP-LINK TECHNOLOGIES CO.,LTD",
	[3]byte{240, 245, 174}: "Adaptrum Inc.",
	[3]byte{240, 246, 28}:  "Apple",
	[3]byte{240, 246, 68}:  "Whitesky Science & Technology Co.,Ltd.",
	[3]byte{240, 246, 105}: "Motion Analysis Corporation",
	[3]byte{240, 247, 85}:  "CISCO SYSTEMS, INC.",
	[3]byte{240, 247, 179}: "Phorm",
	[3]byte{240, 248, 66}:  "KEEBOX, Inc.",
	[3]byte{240, 249, 247}: "IES GmbH & Co. KG",
	[3]byte{240, 253, 160}: "Acurix Networks LP",
	[3]byte{240, 254, 107}: "Shanghai High-Flying Electronics Technology Co., Ltd",
	[3]byte{244, 3, 33}:    "BeNeXt B.V.",
	[3]byte{244, 4, 76}:    "ValenceTech Limited",
	[3]byte{244, 6, 105}:   "Intel Corporate",
	[3]byte{244, 6, 141}:   "devolo AG",
	[3]byte{244, 6, 165}:   "Hangzhou Bianfeng Networking Technology Co., Ltd.",
	[3]byte{244, 9, 216}:   "Samsung Electro Mechanics co., LTD.",
	[3]byte{244, 11, 147}:  "Research In Motion",
	[3]byte{244, 14, 17}:   "IEEE REGISTRATION AUTHORITY  - Please see MAM public listing for more information.",
	[3]byte{244, 15, 27}:   "Cisco",
	[3]byte{244, 15, 155}:  "WAVELINK",
	[3]byte{244, 21, 253}:  "Shanghai Pateo Electronic Equipment Manufacturing Co., Ltd.",
	[3]byte{244, 27, 161}:  "Apple",
	[3]byte{244, 30, 38}:   "Simon-Kaloi Engineering",
	[3]byte{244, 31, 11}:   "YAMABISHI Corporation",
	[3]byte{244, 31, 194}:  "Cisco",
	[3]byte{244, 32, 18}:   "Cuciniale GmbH",
	[3]byte{244, 40, 51}:   "MMPC Inc.",
	[3]byte{244, 40, 83}:   "Zioncom Electronics (Shenzhen) Ltd.",
	[3]byte{244, 40, 150}:  "SPECTO PAINEIS ELETRONICOS LTDA",
	[3]byte{244, 54, 225}:  "Abilis Systems SARL",
	[3]byte{244, 55, 183}:  "Apple",
	[3]byte{244, 56, 20}:   "Shanghai Howell Electronic Co.,Ltd",
	[3]byte{244, 61, 128}:  "FAG Industrial Services GmbH",
	[3]byte{244, 62, 97}:   "Shenzhen Gongjin Electronics Co., Ltd",
	[3]byte{244, 62, 157}:  "Benu Networks, Inc.",
	[3]byte{244, 66, 39}:   "S & S Research Inc.",
	[3]byte{244, 68, 80}:   "BND Co., Ltd.",
	[3]byte{244, 69, 237}:  "Portable Innovation Technology Ltd.",
	[3]byte{244, 71, 42}:   "Nanjing Rousing Sci. and Tech. Industrial Co., Ltd",
	[3]byte{244, 72, 72}:   "Amscreen Group Ltd",
	[3]byte{244, 78, 5}:    "Cisco",
	[3]byte{244, 78, 253}:  "Actions Semiconductor Co.,Ltd.(Cayman Islands)",
	[3]byte{244, 80, 235}:  "Telechips Inc",
	[3]byte{244, 82, 20}:   "Mellanox Technologies, Inc.",
	[3]byte{244, 84, 51}:   "Rockwell Automation",
	[3]byte{244, 85, 149}:  "HENGBAO Corporation LTD.",
	[3]byte{244, 85, 156}:  "Huawei Technologies Co., Ltd",
	[3]byte{244, 85, 224}:  "Niceway CNC Technology Co.,Ltd.Hunan Province",
	[3]byte{244, 88, 66}:   "Boxx TV Ltd",
	[3]byte{244, 95, 105}:  "Matsufu Electronics distribution Company",
	[3]byte{244, 95, 212}:  "Cisco SPVTG",
	[3]byte{244, 95, 247}:  "DQ Technology Inc.",
	[3]byte{244, 96, 13}:   "Panoptic Technology, Inc",
	[3]byte{244, 99, 73}:   "Diffon Corporation",
	[3]byte{244, 106, 188}: "Adonit Corp. Ltd.",
	[3]byte{244, 109, 4}:   "ASUSTek COMPUTER INC.",
	[3]byte{244, 109, 226}: "zte corporation",
	[3]byte{244, 115, 202}: "Conversion Sound Inc.",
	[3]byte{244, 118, 38}:  "Viltechmeda UAB",
	[3]byte{244, 122, 78}:  "Woojeon&Handan",
	[3]byte{244, 122, 204}: "SolidFire, Inc.",
	[3]byte{244, 123, 94}:  "Samsung Eletronics Co., Ltd",
	[3]byte{244, 127, 53}:  "CISCO SYSTEMS, INC.",
	[3]byte{244, 129, 57}:  "CANON INC.",
	[3]byte{244, 135, 113}: "Infoblox",
	[3]byte{244, 142, 9}:   "Nokia Corporation",
	[3]byte{244, 144, 202}: "Tensorcom",
	[3]byte{244, 144, 234}: "Deciso B.V.",
	[3]byte{244, 148, 97}:  "NexGen Storage",
	[3]byte{244, 148, 102}: "CountMax,  ltd",
	[3]byte{244, 153, 172}: "WEBER Schraubautomaten GmbH",
	[3]byte{244, 159, 84}:  "Samsung Electronics",
	[3]byte{244, 159, 243}: "Huawei Technologies Co., Ltd",
	[3]byte{244, 162, 148}: "EAGLE WORLD DEVELOPMENT CO., LIMITED",
	[3]byte{244, 165, 42}:  "Hawa Technologies Inc",
	[3]byte{244, 172, 193}: "CISCO SYSTEMS, INC.",
	[3]byte{244, 177, 100}: "Lightning Telecommunications Technology Co. Ltd",
	[3]byte{244, 179, 129}: "WindowMaster A/S",
	[3]byte{244, 181, 47}:  "Juniper networks",
	[3]byte{244, 181, 73}:  "Yeastar Technology Co., Ltd.",
	[3]byte{244, 182, 229}: "TerraSem Co.,Ltd",
	[3]byte{244, 183, 42}:  "TIME INTERCONNECT LTD",
	[3]byte{244, 183, 226}: "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{244, 184, 94}:  "Texas INstruments",
	[3]byte{244, 189, 124}: "Chengdu jinshi communication Co., LTD",
	[3]byte{244, 196, 71}:  "Coagent International Enterprise Limited",
	[3]byte{244, 198, 215}: "blackned GmbH",
	[3]byte{244, 199, 20}:  "Shenzhen Huawei Communication Technologies Co., Ltd",
	[3]byte{244, 199, 149}: "WEY Elektronik AG",
	[3]byte{244, 202, 229}: "FREEBOX SA",
	[3]byte{244, 205, 144}: "Vispiron Rotec GmbH",
	[3]byte{244, 206, 70}:  "Hewlett-Packard Company",
	[3]byte{244, 207, 226}: "Cisco",
	[3]byte{244, 208, 50}:  "Yunnan Ideal Information&Technology.,Ltd",
	[3]byte{244, 210, 97}:  "SEMOCON Co., Ltd",
	[3]byte{244, 217, 251}: "Samsung Electronics CO., LTD",
	[3]byte{244, 220, 77}:  "Beijing CCD Digital Technology Co., Ltd",
	[3]byte{244, 220, 218}: "Zhuhai Jiahe Communication Technology Co., limited",
	[3]byte{244, 220, 249}: "Huawei Technologies Co., Ltd",
	[3]byte{244, 221, 158}: "GoPro",
	[3]byte{244, 225, 66}:  "Delta Elektronika BV",
	[3]byte{244, 230, 215}: "Solar Power Technologies, Inc.",
	[3]byte{244, 234, 103}: "CISCO SYSTEMS, INC.",
	[3]byte{244, 236, 56}:  "TP-LINK TECHNOLOGIES CO., LTD.",
	[3]byte{244, 238, 20}:  "SHENZHEN MERCURY COMMUNICATION TECHNOLOGIES CO.,LTD.",
	[3]byte{244, 241, 90}:  "Apple",
	[3]byte{244, 241, 225}: "Motorola Mobility LLC",
	[3]byte{244, 242, 109}: "TP-LINK TECHNOLOGIES CO.,LTD.",
	[3]byte{244, 245, 165}: "Nokia corporation",
	[3]byte{244, 245, 232}: "Google",
	[3]byte{244, 246, 70}:  "Dediprog Technology Co. Ltd.",
	[3]byte{244, 249, 81}:  "Apple",
	[3]byte{244, 252, 50}:  "Texas Instruments",
	[3]byte{244, 253, 43}:  "ZOYI Company",
	[3]byte{248, 1, 19}:    "Huawei Technologies Co., Ltd",
	[3]byte{248, 3, 50}:    "Khomp",
	[3]byte{248, 5, 28}:    "DRS Imaging and Targeting Solutions",
	[3]byte{248, 11, 190}:  "ARRIS Group, Inc.",
	[3]byte{248, 11, 208}:  "Datang Telecom communication terminal (Tianjin) Co., Ltd.",
	[3]byte{248, 12, 243}:  "LG Electronics",
	[3]byte{248, 13, 67}:   "Hon Hai Precision Ind. Co., Ltd.",
	[3]byte{248, 13, 234}:  "ZyCast Technology Inc.",
	[3]byte{248, 15, 65}:   "Wistron InfoComm(ZhongShan) Corporation",
	[3]byte{248, 15, 132}:  "Natural Security SAS",
	[3]byte{248, 16, 55}:   "Atopia Systems, LP",
	[3]byte{248, 21, 71}:   "Avaya, Inc",
	[3]byte{248, 22, 84}:   "Intel Corporate",
	[3]byte{248, 26, 103}:  "TP-LINK TECHNOLOGIES CO., LTD.",
	[3]byte{248, 28, 229}:  "Telefonbau Behnke GmbH",
	[3]byte{248, 29, 147}:  "Longdhua(Beijing) Controls Technology Co.,Ltd",
	[3]byte{248, 30, 223}:  "Apple",
	[3]byte{248, 34, 133}:  "Cypress Technology CO., LTD.",
	[3]byte{248, 36, 65}:   "Yeelink",
	[3]byte{248, 39, 147}:  "Apple, Inc",
	[3]byte{248, 43, 200}:  "Jiangsu Switter Co., Ltd",
	[3]byte{248, 46, 219}:  "RTW GmbH & Co. KG",
	[3]byte{248, 47, 91}:   "eGauge Systems LLC",
	[3]byte{248, 47, 168}:  "Hon Hai Precision Ind. Co.,Ltd.",
	[3]byte{248, 48, 148}:  "Alcatel-Lucent Telecom Limited",
	[3]byte{248, 49, 62}:   "endeavour GmbH",
	[3]byte{248, 51, 118}:  "Good Mind Innovation Co., Ltd.",
	[3]byte{248, 53, 83}:   "Magenta Research Ltd.",
	[3]byte{248, 53, 221}:  "Gemtek Technology Co., Ltd.",
	[3]byte{248, 61, 78}:   "Softlink Automation System Co., Ltd",
	[3]byte{248, 61, 255}:  "Huawei Technologies Co., Ltd",
	[3]byte{248, 66, 251}:  "Yasuda Joho Co.,ltd.",
	[3]byte{248, 67, 96}:   "INGENICO",
	[3]byte{248, 69, 173}:  "Konka Group Co., Ltd.",
	[3]byte{248, 70, 45}:   "SYNTEC Incorporation",
	[3]byte{248, 71, 45}:   "X2gen Digital Corp. Ltd",
	[3]byte{248, 72, 151}:  "Hitachi, Ltd.",
	[3]byte{248, 74, 115}:  "EUMTECH CO., LTD",
	[3]byte{248, 74, 127}:  "Innometriks Inc",
	[3]byte{248, 74, 191}:  "HUAWEI TECHNOLOGIES CO.,LTD",
	[3]byte{248, 79, 87}:   "Cisco",
	[3]byte{248, 80, 99}:   "Verathon",
	[3]byte{248, 81, 109}:  "Denwa Technology Corp.",
	[3]byte{248, 82, 223}:  "VNL Europe AB",
	[3]byte{248, 84, 175}:  "ECI Telecom Ltd.",
	[3]byte{248, 87, 46}:   "Core Brands, LLC",
	[3]byte{248, 91, 201}:  "M-Cube Spa",
	[3]byte{248, 92, 69}:   "IC Nexus Co. Ltd.",
	[3]byte{248, 95, 42}:   "Nokia Corporation",
	[3]byte{248, 98, 170}:  "xn systems",
	[3]byte{248, 102, 1}:   "Suzhou Chi-tek information technology Co., Ltd",
	[3]byte{248, 102, 209}: "Hon Hai Precision Ind. Co., Ltd.",
	[3]byte{248, 102, 242}: "CISCO SYSTEMS, INC.",
	[3]byte{248, 105, 113}: "Seibu Electric Co.,",
	[3]byte{248, 110, 207}: "Arcx Inc",
	[3]byte{248, 113, 254}: "The Goldman Sachs Group, Inc.",
	[3]byte{248, 114, 234}: "Cisco",
	[3]byte{248, 115, 148}: "NETGEAR INC.,",
	[3]byte{248, 118, 155}: "Neopis Co., Ltd.",
	[3]byte{248, 123, 98}:  "FASTWEL INTERNATIONAL CO., LTD. Taiwan Branch",
	[3]byte{248, 123, 122}: "ARRIS Group, Inc.",
	[3]byte{248, 123, 140}: "Amped Wireless",
	[3]byte{248, 129, 26}:  "OVERKIZ",
	[3]byte{248, 132, 121}: "Yaojin Technology(Shenzhen)Co.,Ltd",
	[3]byte{248, 132, 242}: "Samsung Electronics Co.,Ltd",
	[3]byte{248, 140, 28}:  "KAISHUN ELECTRONIC TECHNOLOGY CO., LTD. BEIJING",
	[3]byte{248, 141, 239}: "Tenebraex",
	[3]byte{248, 142, 133}: "COMTREND CORPORATION",
	[3]byte{248, 143, 202}: "Google Fiber, Inc",
	[3]byte{248, 145, 42}:  "GLP German Light Products GmbH",
	[3]byte{248, 147, 243}: "VOLANS",
	[3]byte{248, 149, 80}:  "Proton Products Chengdu Ltd",
	[3]byte{248, 151, 207}: "DAESHIN-INFORMATION TECHNOLOGY CO., LTD.",
	[3]byte{248, 153, 85}:  "Fortress Technology Inc",
	[3]byte{248, 157, 13}:  "Control Technology Inc.",
	[3]byte{248, 159, 184}: "YAZAKI Energy System Corporation",
	[3]byte{248, 160, 61}:  "Dinstar Technologies Co., Ltd.",
	[3]byte{248, 162, 180}: "RHEWA-WAAGENFABRIK August Freudewald GmbH &amp;Co. KG",
	[3]byte{248, 164, 95}:  "Beijing Xiaomi communications co.,ltd",
	[3]byte{248, 169, 99}:  "COMPAL INFORMATION (KUNSHAN) CO., LTD.",
	[3]byte{248, 169, 208}: "LG Electronics",
	[3]byte{248, 169, 222}: "PUISSANCE PLUS",
	[3]byte{248, 170, 138}: "Axview Technology (Shenzhen) Co.,Ltd",
	[3]byte{248, 172, 109}: "Deltenna Ltd",
	[3]byte{248, 177, 86}:  "Dell Inc",
	[3]byte{248, 178, 243}: "GUANGZHOU BOSMA TECHNOLOGY CO.,LTD",
	[3]byte{248, 181, 153}: "Guangzhou CHNAVS Digital Technology Co.,Ltd",
	[3]byte{248, 188, 18}:  "Dell Inc",
	[3]byte{248, 188, 65}:  "Rosslare Enterprises Limited",
	[3]byte{248, 192, 1}:   "Juniper Networks",
	[3]byte{248, 192, 145}: "Highgates Technology",
	[3]byte{248, 194, 136}: "Cisco",
	[3]byte{248, 198, 120}: "Carefusion",
	[3]byte{248, 208, 172}: "Sony Computer Entertainment Inc.",
	[3]byte{248, 208, 189}: "Samsung Electronics Co.,Ltd",
	[3]byte{248, 209, 17}:  "TP-LINK TECHNOLOGIES CO., LTD.",
	[3]byte{248, 211, 169}: "AXAN Networks",
	[3]byte{248, 212, 98}:  "Pumatronix Equipamentos Eletronicos Ltda.",
	[3]byte{248, 215, 86}:  "Simm Tronic Limited",
	[3]byte{248, 215, 191}: "REV Ritter GmbH",
	[3]byte{248, 218, 223}: "EcoTech, Inc.",
	[3]byte{248, 218, 226}: "Beta LaserMike",
	[3]byte{248, 218, 244}: "Taishan Online Technology Co., Ltd.",
	[3]byte{248, 219, 76}:  "PNY Technologies, INC.",
	[3]byte{248, 219, 127}: "HTC Corporation",
	[3]byte{248, 219, 136}: "Dell Inc",
	[3]byte{248, 220, 122}: "Variscite LTD",
	[3]byte{248, 223, 168}: "ZTE Corporation",
	[3]byte{248, 224, 121}: "Motorola Mobility LLC",
	[3]byte{248, 228, 251}: "Actiontec Electronics, Inc",
	[3]byte{248, 231, 181}: "µTech Tecnologia LTDA",
	[3]byte{248, 232, 17}:  "HUAWEI TECHNOLOGIES CO.,LTD",
	[3]byte{248, 233, 3}:   "D-Link International",
	[3]byte{248, 233, 104}: "Egker Kft.",
	[3]byte{248, 234, 10}:  "Dipl.-Math. Michael Rauch",
	[3]byte{248, 237, 165}: "ARRIS Group, Inc.",
	[3]byte{248, 240, 5}:   "Newport Media Inc.",
	[3]byte{248, 240, 20}:  "RackWare Inc.",
	[3]byte{248, 240, 130}: "Orion Networks International, Inc",
	[3]byte{248, 241, 182}: "Motorola Mobility LLC",
	[3]byte{248, 242, 90}:  "G-Lab GmbH",
	[3]byte{248, 247, 211}: "International Communications Corporation",
	[3]byte{248, 247, 255}: "SYN-TECH SYSTEMS INC",
	[3]byte{248, 251, 47}:  "Santur Corporation",
	[3]byte{248, 254, 92}:  "Reciprocal Labs Corp",
	[3]byte{248, 254, 168}: "Technico Japan Corporation",
	[3]byte{248, 255, 95}:  "Shenzhen Communication Technology Co.,Ltd",
	[3]byte{252, 0, 18}:    "Toshiba Samsung Storage Technolgoy Korea Corporation",
	[3]byte{252, 1, 158}:   "VIEVU",
	[3]byte{252, 1, 205}:   "FUNDACION TEKNIKER",
	[3]byte{252, 6, 71}:    "Cortland Research, LLC",
	[3]byte{252, 7, 160}:   "LRE Medical GmbH",
	[3]byte{252, 8, 119}:   "Prentke Romich Company",
	[3]byte{252, 9, 216}:   "ACTEON Group",
	[3]byte{252, 9, 246}:   "GUANGDONG TONZE ELECTRIC CO.,LTD",
	[3]byte{252, 10, 129}:  "Motorola Solutions Inc.",
	[3]byte{252, 15, 230}:  "Sony Computer Entertainment Inc.",
	[3]byte{252, 16, 189}:  "Control Sistematizado S.A.",
	[3]byte{252, 17, 134}:  "Logic3 plc",
	[3]byte{252, 19, 73}:   "Global Apps Corp.",
	[3]byte{252, 21, 180}:  "Hewlett Packard",
	[3]byte{252, 22, 7}:    "Taian Technology(Wuxi) Co.,Ltd.",
	[3]byte{252, 23, 148}:  "InterCreative Co., Ltd",
	[3]byte{252, 25, 16}:   "Samsung Electronics Co.,Ltd",
	[3]byte{252, 25, 208}:  "Cloud Vision Networks Technology Co.,Ltd.",
	[3]byte{252, 27, 255}:  "V-ZUG AG",
	[3]byte{252, 29, 89}:   "I Smart Cities HK Ltd",
	[3]byte{252, 29, 132}:  "Autobase",
	[3]byte{252, 30, 22}:   "IPEVO corp",
	[3]byte{252, 31, 25}:   "SAMSUNG ELECTRO-MECHANICS CO., LTD.",
	[3]byte{252, 31, 192}:  "EURECAM",
	[3]byte{252, 34, 156}:  "Han Kyung I Net Co.,Ltd.",
	[3]byte{252, 35, 37}:   "EosTek (Shenzhen) Co., Ltd.",
	[3]byte{252, 37, 63}:   "Apple",
	[3]byte{252, 39, 162}:  "TRANS ELECTRIC CO., LTD.",
	[3]byte{252, 42, 84}:   "Connected Data, Inc.",
	[3]byte{252, 46, 45}:   "Lorom Industrial Co.LTD.",
	[3]byte{252, 47, 64}:   "Calxeda, Inc.",
	[3]byte{252, 53, 152}:  "Favite Inc.",
	[3]byte{252, 53, 230}:  "Visteon corp",
	[3]byte{252, 63, 171}:  "Henan Lanxin Technology Co., Ltd",
	[3]byte{252, 68, 99}:   "Universal Audio, Inc",
	[3]byte{252, 68, 153}:  "Swarco LEA d.o.o.",
	[3]byte{252, 69, 95}:   "JIANGXI SHANSHUI OPTOELECTRONIC TECHNOLOGY CO.,LTD",
	[3]byte{252, 72, 239}:  "HUAWEI TECHNOLOGIES CO.,LTD",
	[3]byte{252, 74, 233}:  "Castlenet Technology Inc.",
	[3]byte{252, 75, 28}:   "INTERSENSOR S.R.L.",
	[3]byte{252, 75, 188}:  "Sunplus Technology Co., Ltd.",
	[3]byte{252, 77, 212}:  "Universal Global Scientific Industrial Co., Ltd.",
	[3]byte{252, 80, 144}:  "SIMEX Sp. z o.o.",
	[3]byte{252, 82, 206}:  "Control iD",
	[3]byte{252, 88, 250}:  "Shen Zhen Shi Xin Zhong Xin Technology Co.,Ltd.",
	[3]byte{252, 91, 36}:   "Weibel Scientific A/S",
	[3]byte{252, 91, 38}:   "MikroBits",
	[3]byte{252, 91, 57}:   "Cisco",
	[3]byte{252, 96, 24}:   "Zhejiang Kangtai Electric Co., Ltd.",
	[3]byte{252, 97, 152}:  "NEC Personal Products, Ltd",
	[3]byte{252, 98, 110}:  "Beijing MDC Telecom",
	[3]byte{252, 98, 185}:  "ALPS ERECTRIC CO.,LTD",
	[3]byte{252, 104, 62}:  "Directed Perception, Inc",
	[3]byte{252, 108, 49}:  "LXinstruments GmbH",
	[3]byte{252, 109, 192}: "BME CORPORATION",
	[3]byte{252, 117, 22}:  "D-Link International",
	[3]byte{252, 117, 230}: "Handreamnet",
	[3]byte{252, 121, 11}:  "Hitachi High Technologies America, Inc.",
	[3]byte{252, 124, 231}: "FCI USA LLC",
	[3]byte{252, 131, 41}:  "Trei technics",
	[3]byte{252, 131, 153}: "Avaya, Inc",
	[3]byte{252, 139, 151}: "Shenzhen Gongjin Electronics Co.,Ltd",
	[3]byte{252, 142, 126}: "Pace plc",
	[3]byte{252, 143, 196}: "Intelligent Technology Inc.",
	[3]byte{252, 146, 59}:  "Nokia Corporation",
	[3]byte{252, 148, 108}: "UBIVELOX",
	[3]byte{252, 148, 227}: "Technicolor USA Inc.",
	[3]byte{252, 153, 71}:  "Cisco",
	[3]byte{252, 159, 174}: "Fidus Systems Inc",
	[3]byte{252, 159, 225}: "CONWIN.Tech. Ltd",
	[3]byte{252, 161, 62}:  "Samsung Electronics",
	[3]byte{252, 168, 65}:  "Avaya, Inc",
	[3]byte{252, 169, 176}: "MIARTECH (SHANGHAI),INC.",
	[3]byte{252, 170, 20}:  "GIGA-BYTE TECHNOLOGY CO.,LTD.",
	[3]byte{252, 173, 15}:  "QTS NETWORKS",
	[3]byte{252, 175, 106}: "Conemtech AB",
	[3]byte{252, 176, 196}: "Shanghai DareGlobal Technologies Co., Ltd",
	[3]byte{252, 187, 161}: "Shenzhen Minicreate Technology Co.,Ltd",
	[3]byte{252, 194, 61}:  "Atmel Corporation",
	[3]byte{252, 194, 222}: "Murata Manufacturing Co., Ltd.",
	[3]byte{252, 199, 52}:  "Samsung Electronics Co.,Ltd",
	[3]byte{252, 200, 151}: "ZTE Corporation",
	[3]byte{252, 204, 228}: "Ascon Ltd.",
	[3]byte{252, 207, 98}:  "IBM Corp",
	[3]byte{252, 212, 242}: "The Coca Cola Company",
	[3]byte{252, 212, 246}: "Messana Air.Ray Conditioning s.r.l.",
	[3]byte{252, 213, 217}: "Shenzhen SDMC Technology Co., Ltd.",
	[3]byte{252, 214, 189}: "Robert Bosch GmbH",
	[3]byte{252, 216, 23}:  "Beijing Hesun Technologies Co.Ltd.",
	[3]byte{252, 219, 150}: "ENERVALLEY CO., LTD",
	[3]byte{252, 219, 179}: "Murata Manufacturing Co., Ltd.",
	[3]byte{252, 221, 85}:  "Shenzhen WeWins wireless Co.,Ltd",
	[3]byte{252, 225, 134}: "A3M Co., LTD",
	[3]byte{252, 225, 146}: "Sichuan Jinwangtong Electronic Science&Technology Co,.Ltd",
	[3]byte{252, 225, 217}: "Stable Imaging Solutions LLC",
	[3]byte{252, 226, 63}:  "CLAY PAKY SPA",
	[3]byte{252, 229, 87}:  "Nokia Corporation",
	[3]byte{252, 232, 146}: "Hangzhou Lancable Technology Co.,Ltd",
	[3]byte{252, 237, 185}: "Arrayent",
	[3]byte{252, 241, 82}:  "Sony Corporation",
	[3]byte{252, 241, 205}: "OPTEX-FA CO.,LTD.",
	[3]byte{252, 245, 40}:  "ZyXEL Communications Corporation",
	[3]byte{252, 246, 71}:  "Fiberhome Telecommunication Tech.Co.,Ltd.",
	[3]byte{252, 248, 174}: "Intel Corporate",
	[3]byte{252, 248, 183}: "TRONTEQ Electronic",
	[3]byte{252, 250, 247}: "Shanghai Baud Data Communication Co.,Ltd.",
	[3]byte{252, 251, 251}: "CISCO SYSTEMS, INC.",
	[3]byte{252, 254, 119}: "Hitachi Reftechno, Inc.",
	[3]byte{252, 255, 170}: "IEEE REGISTRATION AUTHORITY  - Please see MAL public listing for more information.",
}
