// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/devtools/clouddebugger/v2/debugger.proto
// DO NOT EDIT!

package google_devtools_clouddebugger_v2 // import "google.golang.org/genproto/googleapis/devtools/clouddebugger/v2"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/serviceconfig"
import google_protobuf3 "github.com/golang/protobuf/ptypes/empty"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Request to set a breakpoint
type SetBreakpointRequest struct {
	// ID of the debuggee where the breakpoint is to be set.
	DebuggeeId string `protobuf:"bytes,1,opt,name=debuggee_id,json=debuggeeId" json:"debuggee_id,omitempty"`
	// Breakpoint specification to set.
	// The field 'location' of the breakpoint must be set.
	Breakpoint *Breakpoint `protobuf:"bytes,2,opt,name=breakpoint" json:"breakpoint,omitempty"`
	// The client version making the call.
	// Following: `domain/type/version` (e.g., `google.com/intellij/v1`).
	ClientVersion string `protobuf:"bytes,4,opt,name=client_version,json=clientVersion" json:"client_version,omitempty"`
}

func (m *SetBreakpointRequest) Reset()                    { *m = SetBreakpointRequest{} }
func (m *SetBreakpointRequest) String() string            { return proto.CompactTextString(m) }
func (*SetBreakpointRequest) ProtoMessage()               {}
func (*SetBreakpointRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{0} }

func (m *SetBreakpointRequest) GetBreakpoint() *Breakpoint {
	if m != nil {
		return m.Breakpoint
	}
	return nil
}

// Response for setting a breakpoint.
type SetBreakpointResponse struct {
	// Breakpoint resource.
	// The field `id` is guaranteed to be set (in addition to the echoed fileds).
	Breakpoint *Breakpoint `protobuf:"bytes,1,opt,name=breakpoint" json:"breakpoint,omitempty"`
}

func (m *SetBreakpointResponse) Reset()                    { *m = SetBreakpointResponse{} }
func (m *SetBreakpointResponse) String() string            { return proto.CompactTextString(m) }
func (*SetBreakpointResponse) ProtoMessage()               {}
func (*SetBreakpointResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{1} }

func (m *SetBreakpointResponse) GetBreakpoint() *Breakpoint {
	if m != nil {
		return m.Breakpoint
	}
	return nil
}

// Request to get breakpoint information.
type GetBreakpointRequest struct {
	// ID of the debuggee whose breakpoint to get.
	DebuggeeId string `protobuf:"bytes,1,opt,name=debuggee_id,json=debuggeeId" json:"debuggee_id,omitempty"`
	// ID of the breakpoint to get.
	BreakpointId string `protobuf:"bytes,2,opt,name=breakpoint_id,json=breakpointId" json:"breakpoint_id,omitempty"`
	// The client version making the call.
	// Following: `domain/type/version` (e.g., `google.com/intellij/v1`).
	ClientVersion string `protobuf:"bytes,4,opt,name=client_version,json=clientVersion" json:"client_version,omitempty"`
}

func (m *GetBreakpointRequest) Reset()                    { *m = GetBreakpointRequest{} }
func (m *GetBreakpointRequest) String() string            { return proto.CompactTextString(m) }
func (*GetBreakpointRequest) ProtoMessage()               {}
func (*GetBreakpointRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{2} }

// Response for getting breakpoint information.
type GetBreakpointResponse struct {
	// Complete breakpoint state.
	// The fields `id` and `location` are guaranteed to be set.
	Breakpoint *Breakpoint `protobuf:"bytes,1,opt,name=breakpoint" json:"breakpoint,omitempty"`
}

func (m *GetBreakpointResponse) Reset()                    { *m = GetBreakpointResponse{} }
func (m *GetBreakpointResponse) String() string            { return proto.CompactTextString(m) }
func (*GetBreakpointResponse) ProtoMessage()               {}
func (*GetBreakpointResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{3} }

func (m *GetBreakpointResponse) GetBreakpoint() *Breakpoint {
	if m != nil {
		return m.Breakpoint
	}
	return nil
}

// Request to delete a breakpoint.
type DeleteBreakpointRequest struct {
	// ID of the debuggee whose breakpoint to delete.
	DebuggeeId string `protobuf:"bytes,1,opt,name=debuggee_id,json=debuggeeId" json:"debuggee_id,omitempty"`
	// ID of the breakpoint to delete.
	BreakpointId string `protobuf:"bytes,2,opt,name=breakpoint_id,json=breakpointId" json:"breakpoint_id,omitempty"`
	// The client version making the call.
	// Following: `domain/type/version` (e.g., `google.com/intellij/v1`).
	ClientVersion string `protobuf:"bytes,3,opt,name=client_version,json=clientVersion" json:"client_version,omitempty"`
}

func (m *DeleteBreakpointRequest) Reset()                    { *m = DeleteBreakpointRequest{} }
func (m *DeleteBreakpointRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteBreakpointRequest) ProtoMessage()               {}
func (*DeleteBreakpointRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{4} }

// Request to list breakpoints.
type ListBreakpointsRequest struct {
	// ID of the debuggee whose breakpoints to list.
	DebuggeeId string `protobuf:"bytes,1,opt,name=debuggee_id,json=debuggeeId" json:"debuggee_id,omitempty"`
	// When set to `true`, the response includes the list of breakpoints set by
	// any user. Otherwise, it includes only breakpoints set by the caller.
	IncludeAllUsers bool `protobuf:"varint,2,opt,name=include_all_users,json=includeAllUsers" json:"include_all_users,omitempty"`
	// When set to `true`, the response includes active and inactive
	// breakpoints. Otherwise, it includes only active breakpoints.
	IncludeInactive bool `protobuf:"varint,3,opt,name=include_inactive,json=includeInactive" json:"include_inactive,omitempty"`
	// When set, the response includes only breakpoints with the specified action.
	Action *ListBreakpointsRequest_BreakpointActionValue `protobuf:"bytes,4,opt,name=action" json:"action,omitempty"`
	// This field is deprecated. The following fields are always stripped out of
	// the result: `stack_frames`, `evaluated_expressions` and `variable_table`.
	StripResults bool `protobuf:"varint,5,opt,name=strip_results,json=stripResults" json:"strip_results,omitempty"`
	// A wait token that, if specified, blocks the call until the breakpoints
	// list has changed, or a server selected timeout has expired.  The value
	// should be set from the last response. The error code
	// `google.rpc.Code.ABORTED` (RPC) is returned on wait timeout, which
	// should be called again with the same `wait_token`.
	WaitToken string `protobuf:"bytes,6,opt,name=wait_token,json=waitToken" json:"wait_token,omitempty"`
	// The client version making the call.
	// Following: `domain/type/version` (e.g., `google.com/intellij/v1`).
	ClientVersion string `protobuf:"bytes,8,opt,name=client_version,json=clientVersion" json:"client_version,omitempty"`
}

func (m *ListBreakpointsRequest) Reset()                    { *m = ListBreakpointsRequest{} }
func (m *ListBreakpointsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListBreakpointsRequest) ProtoMessage()               {}
func (*ListBreakpointsRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{5} }

func (m *ListBreakpointsRequest) GetAction() *ListBreakpointsRequest_BreakpointActionValue {
	if m != nil {
		return m.Action
	}
	return nil
}

// Wrapper message for `Breakpoint.Action`. Defines a filter on the action
// field of breakpoints.
type ListBreakpointsRequest_BreakpointActionValue struct {
	// Only breakpoints with the specified action will pass the filter.
	Value Breakpoint_Action `protobuf:"varint,1,opt,name=value,enum=google.devtools.clouddebugger.v2.Breakpoint_Action" json:"value,omitempty"`
}

func (m *ListBreakpointsRequest_BreakpointActionValue) Reset() {
	*m = ListBreakpointsRequest_BreakpointActionValue{}
}
func (m *ListBreakpointsRequest_BreakpointActionValue) String() string {
	return proto.CompactTextString(m)
}
func (*ListBreakpointsRequest_BreakpointActionValue) ProtoMessage() {}
func (*ListBreakpointsRequest_BreakpointActionValue) Descriptor() ([]byte, []int) {
	return fileDescriptor2, []int{5, 0}
}

// Response for listing breakpoints.
type ListBreakpointsResponse struct {
	// List of breakpoints matching the request.
	// The fields `id` and `location` are guaranteed to be set on each breakpoint.
	// The fields: `stack_frames`, `evaluated_expressions` and `variable_table`
	// are cleared on each breakpoint regardless of it's status.
	Breakpoints []*Breakpoint `protobuf:"bytes,1,rep,name=breakpoints" json:"breakpoints,omitempty"`
	// A wait token that can be used in the next call to `list` (REST) or
	// `ListBreakpoints` (RPC) to block until the list of breakpoints has changes.
	NextWaitToken string `protobuf:"bytes,2,opt,name=next_wait_token,json=nextWaitToken" json:"next_wait_token,omitempty"`
}

func (m *ListBreakpointsResponse) Reset()                    { *m = ListBreakpointsResponse{} }
func (m *ListBreakpointsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListBreakpointsResponse) ProtoMessage()               {}
func (*ListBreakpointsResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{6} }

func (m *ListBreakpointsResponse) GetBreakpoints() []*Breakpoint {
	if m != nil {
		return m.Breakpoints
	}
	return nil
}

// Request to list debuggees.
type ListDebuggeesRequest struct {
	// Project number of a Google Cloud project whose debuggees to list.
	Project string `protobuf:"bytes,2,opt,name=project" json:"project,omitempty"`
	// When set to `true`, the result includes all debuggees. Otherwise, the
	// result includes only debuggees that are active.
	IncludeInactive bool `protobuf:"varint,3,opt,name=include_inactive,json=includeInactive" json:"include_inactive,omitempty"`
	// The client version making the call.
	// Following: `domain/type/version` (e.g., `google.com/intellij/v1`).
	ClientVersion string `protobuf:"bytes,4,opt,name=client_version,json=clientVersion" json:"client_version,omitempty"`
}

func (m *ListDebuggeesRequest) Reset()                    { *m = ListDebuggeesRequest{} }
func (m *ListDebuggeesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListDebuggeesRequest) ProtoMessage()               {}
func (*ListDebuggeesRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{7} }

// Response for listing debuggees.
type ListDebuggeesResponse struct {
	// List of debuggees accessible to the calling user.
	// Note that the `description` field is the only human readable field
	// that should be displayed to the user.
	// The fields `debuggee.id` and  `description` fields are guaranteed to be
	// set on each debuggee.
	Debuggees []*Debuggee `protobuf:"bytes,1,rep,name=debuggees" json:"debuggees,omitempty"`
}

func (m *ListDebuggeesResponse) Reset()                    { *m = ListDebuggeesResponse{} }
func (m *ListDebuggeesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListDebuggeesResponse) ProtoMessage()               {}
func (*ListDebuggeesResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{8} }

func (m *ListDebuggeesResponse) GetDebuggees() []*Debuggee {
	if m != nil {
		return m.Debuggees
	}
	return nil
}

func init() {
	proto.RegisterType((*SetBreakpointRequest)(nil), "google.devtools.clouddebugger.v2.SetBreakpointRequest")
	proto.RegisterType((*SetBreakpointResponse)(nil), "google.devtools.clouddebugger.v2.SetBreakpointResponse")
	proto.RegisterType((*GetBreakpointRequest)(nil), "google.devtools.clouddebugger.v2.GetBreakpointRequest")
	proto.RegisterType((*GetBreakpointResponse)(nil), "google.devtools.clouddebugger.v2.GetBreakpointResponse")
	proto.RegisterType((*DeleteBreakpointRequest)(nil), "google.devtools.clouddebugger.v2.DeleteBreakpointRequest")
	proto.RegisterType((*ListBreakpointsRequest)(nil), "google.devtools.clouddebugger.v2.ListBreakpointsRequest")
	proto.RegisterType((*ListBreakpointsRequest_BreakpointActionValue)(nil), "google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue")
	proto.RegisterType((*ListBreakpointsResponse)(nil), "google.devtools.clouddebugger.v2.ListBreakpointsResponse")
	proto.RegisterType((*ListDebuggeesRequest)(nil), "google.devtools.clouddebugger.v2.ListDebuggeesRequest")
	proto.RegisterType((*ListDebuggeesResponse)(nil), "google.devtools.clouddebugger.v2.ListDebuggeesResponse")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for Debugger2 service

type Debugger2Client interface {
	// Sets the breakpoint to the debuggee.
	SetBreakpoint(ctx context.Context, in *SetBreakpointRequest, opts ...grpc.CallOption) (*SetBreakpointResponse, error)
	// Gets breakpoint information.
	GetBreakpoint(ctx context.Context, in *GetBreakpointRequest, opts ...grpc.CallOption) (*GetBreakpointResponse, error)
	// Deletes the breakpoint from the debuggee.
	DeleteBreakpoint(ctx context.Context, in *DeleteBreakpointRequest, opts ...grpc.CallOption) (*google_protobuf3.Empty, error)
	// Lists all breakpoints for the debuggee.
	ListBreakpoints(ctx context.Context, in *ListBreakpointsRequest, opts ...grpc.CallOption) (*ListBreakpointsResponse, error)
	// Lists all the debuggees that the user can set breakpoints to.
	ListDebuggees(ctx context.Context, in *ListDebuggeesRequest, opts ...grpc.CallOption) (*ListDebuggeesResponse, error)
}

type debugger2Client struct {
	cc *grpc.ClientConn
}

func NewDebugger2Client(cc *grpc.ClientConn) Debugger2Client {
	return &debugger2Client{cc}
}

func (c *debugger2Client) SetBreakpoint(ctx context.Context, in *SetBreakpointRequest, opts ...grpc.CallOption) (*SetBreakpointResponse, error) {
	out := new(SetBreakpointResponse)
	err := grpc.Invoke(ctx, "/google.devtools.clouddebugger.v2.Debugger2/SetBreakpoint", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *debugger2Client) GetBreakpoint(ctx context.Context, in *GetBreakpointRequest, opts ...grpc.CallOption) (*GetBreakpointResponse, error) {
	out := new(GetBreakpointResponse)
	err := grpc.Invoke(ctx, "/google.devtools.clouddebugger.v2.Debugger2/GetBreakpoint", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *debugger2Client) DeleteBreakpoint(ctx context.Context, in *DeleteBreakpointRequest, opts ...grpc.CallOption) (*google_protobuf3.Empty, error) {
	out := new(google_protobuf3.Empty)
	err := grpc.Invoke(ctx, "/google.devtools.clouddebugger.v2.Debugger2/DeleteBreakpoint", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *debugger2Client) ListBreakpoints(ctx context.Context, in *ListBreakpointsRequest, opts ...grpc.CallOption) (*ListBreakpointsResponse, error) {
	out := new(ListBreakpointsResponse)
	err := grpc.Invoke(ctx, "/google.devtools.clouddebugger.v2.Debugger2/ListBreakpoints", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *debugger2Client) ListDebuggees(ctx context.Context, in *ListDebuggeesRequest, opts ...grpc.CallOption) (*ListDebuggeesResponse, error) {
	out := new(ListDebuggeesResponse)
	err := grpc.Invoke(ctx, "/google.devtools.clouddebugger.v2.Debugger2/ListDebuggees", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Debugger2 service

type Debugger2Server interface {
	// Sets the breakpoint to the debuggee.
	SetBreakpoint(context.Context, *SetBreakpointRequest) (*SetBreakpointResponse, error)
	// Gets breakpoint information.
	GetBreakpoint(context.Context, *GetBreakpointRequest) (*GetBreakpointResponse, error)
	// Deletes the breakpoint from the debuggee.
	DeleteBreakpoint(context.Context, *DeleteBreakpointRequest) (*google_protobuf3.Empty, error)
	// Lists all breakpoints for the debuggee.
	ListBreakpoints(context.Context, *ListBreakpointsRequest) (*ListBreakpointsResponse, error)
	// Lists all the debuggees that the user can set breakpoints to.
	ListDebuggees(context.Context, *ListDebuggeesRequest) (*ListDebuggeesResponse, error)
}

func RegisterDebugger2Server(s *grpc.Server, srv Debugger2Server) {
	s.RegisterService(&_Debugger2_serviceDesc, srv)
}

func _Debugger2_SetBreakpoint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetBreakpointRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(Debugger2Server).SetBreakpoint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.clouddebugger.v2.Debugger2/SetBreakpoint",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(Debugger2Server).SetBreakpoint(ctx, req.(*SetBreakpointRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Debugger2_GetBreakpoint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBreakpointRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(Debugger2Server).GetBreakpoint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.clouddebugger.v2.Debugger2/GetBreakpoint",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(Debugger2Server).GetBreakpoint(ctx, req.(*GetBreakpointRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Debugger2_DeleteBreakpoint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteBreakpointRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(Debugger2Server).DeleteBreakpoint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.clouddebugger.v2.Debugger2/DeleteBreakpoint",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(Debugger2Server).DeleteBreakpoint(ctx, req.(*DeleteBreakpointRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Debugger2_ListBreakpoints_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBreakpointsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(Debugger2Server).ListBreakpoints(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.clouddebugger.v2.Debugger2/ListBreakpoints",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(Debugger2Server).ListBreakpoints(ctx, req.(*ListBreakpointsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Debugger2_ListDebuggees_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDebuggeesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(Debugger2Server).ListDebuggees(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.clouddebugger.v2.Debugger2/ListDebuggees",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(Debugger2Server).ListDebuggees(ctx, req.(*ListDebuggeesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Debugger2_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.devtools.clouddebugger.v2.Debugger2",
	HandlerType: (*Debugger2Server)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "SetBreakpoint",
			Handler:    _Debugger2_SetBreakpoint_Handler,
		},
		{
			MethodName: "GetBreakpoint",
			Handler:    _Debugger2_GetBreakpoint_Handler,
		},
		{
			MethodName: "DeleteBreakpoint",
			Handler:    _Debugger2_DeleteBreakpoint_Handler,
		},
		{
			MethodName: "ListBreakpoints",
			Handler:    _Debugger2_ListBreakpoints_Handler,
		},
		{
			MethodName: "ListDebuggees",
			Handler:    _Debugger2_ListDebuggees_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google.golang.org/genproto/googleapis/devtools/clouddebugger/v2/debugger.proto",
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/devtools/clouddebugger/v2/debugger.proto", fileDescriptor2)
}

var fileDescriptor2 = []byte{
	// 789 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xbc, 0x55, 0xdd, 0x6a, 0xdb, 0x48,
	0x14, 0x66, 0x9c, 0xcd, 0x8f, 0x8f, 0xe3, 0x24, 0x3b, 0xe4, 0x47, 0x18, 0x76, 0xd7, 0x68, 0xff,
	0xb2, 0x61, 0xd1, 0x2c, 0xca, 0xb2, 0x49, 0xf6, 0xaa, 0x31, 0x29, 0x8e, 0x4b, 0x08, 0x41, 0x6d,
	0xd3, 0x4b, 0x23, 0xcb, 0x13, 0x75, 0x1a, 0x45, 0xa3, 0x6a, 0x46, 0x6e, 0x43, 0xc8, 0x4d, 0x0a,
	0xbd, 0x2f, 0x7d, 0x81, 0x3e, 0x40, 0xa1, 0x4f, 0x50, 0xe8, 0x75, 0x7b, 0xd9, 0x57, 0xe8, 0x83,
	0x14, 0xfd, 0xc5, 0xb2, 0x2b, 0x6a, 0xcb, 0x81, 0xdc, 0x18, 0xf9, 0xcc, 0x9c, 0x6f, 0xbe, 0xef,
	0x9b, 0x73, 0xce, 0xc0, 0xa1, 0xcd, 0xb9, 0xed, 0x50, 0xcd, 0xe6, 0x8e, 0xe9, 0xda, 0x1a, 0xf7,
	0x6d, 0x62, 0x53, 0xd7, 0xf3, 0xb9, 0xe4, 0x24, 0x5e, 0x32, 0x3d, 0x26, 0x48, 0x97, 0xf6, 0x24,
	0xe7, 0x8e, 0x20, 0x96, 0xc3, 0x83, 0x6e, 0x97, 0x76, 0x02, 0xdb, 0xa6, 0x3e, 0xe9, 0xe9, 0x24,
	0xfd, 0xd6, 0xa2, 0x1c, 0x5c, 0x4f, 0xf0, 0xd2, 0x04, 0x6d, 0x20, 0x41, 0xeb, 0xe9, 0xb5, 0xd6,
	0x78, 0x27, 0x9a, 0x1e, 0x23, 0x82, 0xfa, 0x3d, 0x66, 0x51, 0x8b, 0xbb, 0x27, 0xcc, 0x26, 0xa6,
	0xeb, 0x72, 0x69, 0x4a, 0xc6, 0x5d, 0x11, 0x1f, 0x56, 0xbb, 0x77, 0x63, 0xf2, 0xa6, 0x34, 0x13,
	0xac, 0x4d, 0x9b, 0xc9, 0xc7, 0x41, 0x47, 0xb3, 0xf8, 0x19, 0x89, 0xf1, 0x48, 0xb4, 0xd0, 0x09,
	0x4e, 0x88, 0x27, 0xcf, 0x3d, 0x2a, 0x08, 0x3d, 0xf3, 0xe4, 0x79, 0xfc, 0x1b, 0x27, 0xa9, 0x6f,
	0x11, 0x2c, 0xdf, 0xa7, 0xb2, 0xe1, 0x53, 0xf3, 0xd4, 0xe3, 0xcc, 0x95, 0x06, 0x7d, 0x1a, 0x50,
	0x21, 0xf1, 0x2f, 0x50, 0x49, 0xce, 0xa1, 0x6d, 0xd6, 0x55, 0x50, 0x1d, 0xad, 0x97, 0x0d, 0x48,
	0x43, 0xad, 0x2e, 0x3e, 0x00, 0xe8, 0x5c, 0x67, 0x29, 0xa5, 0x3a, 0x5a, 0xaf, 0xe8, 0x7f, 0x6b,
	0xa3, 0xcc, 0xd3, 0x32, 0x27, 0x65, 0xf2, 0xf1, 0xef, 0xb0, 0x60, 0x39, 0x8c, 0xba, 0xb2, 0xdd,
	0xa3, 0xbe, 0x60, 0xdc, 0x55, 0x7e, 0x88, 0x4e, 0xac, 0xc6, 0xd1, 0xe3, 0x38, 0xa8, 0x52, 0x58,
	0x19, 0x62, 0x2b, 0x3c, 0xee, 0x0a, 0x3a, 0xc4, 0x06, 0xdd, 0x8c, 0x8d, 0xfa, 0x02, 0xc1, 0x72,
	0x73, 0x22, 0x57, 0x7e, 0x85, 0x6a, 0x1f, 0x27, 0xdc, 0x52, 0x8a, 0xb6, 0xcc, 0xf7, 0x83, 0xad,
	0x6e, 0x01, 0xb1, 0xcd, 0x5b, 0x10, 0xfb, 0x12, 0xc1, 0xda, 0x1e, 0x75, 0xa8, 0xa4, 0xb7, 0xa7,
	0x77, 0x2a, 0x4f, 0xef, 0xa7, 0x29, 0x58, 0x3d, 0x60, 0x22, 0xa3, 0x58, 0x8c, 0xcd, 0x63, 0x03,
	0x7e, 0x64, 0xae, 0xe5, 0x04, 0x5d, 0xda, 0x36, 0x1d, 0xa7, 0x1d, 0x08, 0xea, 0x8b, 0x88, 0xcb,
	0x9c, 0xb1, 0x98, 0x2c, 0xec, 0x3a, 0xce, 0xc3, 0x30, 0x8c, 0xff, 0x82, 0xa5, 0x74, 0x2f, 0x73,
	0x4d, 0x4b, 0xb2, 0x1e, 0x8d, 0x08, 0xf5, 0xb7, 0xb6, 0x92, 0x30, 0x3e, 0x81, 0x99, 0xf0, 0x2b,
	0xb9, 0xa1, 0x8a, 0x7e, 0x38, 0xda, 0xe5, 0x7c, 0x05, 0x19, 0xf3, 0x77, 0x23, 0xc0, 0x63, 0xd3,
	0x09, 0xa8, 0x91, 0xa0, 0xe3, 0x3f, 0xa1, 0x2a, 0xa4, 0xcf, 0xbc, 0xb6, 0x4f, 0x45, 0xe0, 0x48,
	0xa1, 0x4c, 0x87, 0x7c, 0x1a, 0x25, 0x05, 0x19, 0xf3, 0xd1, 0x82, 0x11, 0xc7, 0xf1, 0x4f, 0x00,
	0xcf, 0x4c, 0x26, 0xdb, 0x92, 0x9f, 0x52, 0x57, 0x99, 0x89, 0x7c, 0x28, 0x87, 0x91, 0x07, 0x61,
	0x20, 0xc7, 0xe9, 0xb9, 0x1c, 0xa7, 0x6b, 0x1d, 0x58, 0xc9, 0xe5, 0x83, 0x5b, 0x30, 0xdd, 0x0b,
	0x3f, 0x22, 0x87, 0x17, 0xf4, 0xcd, 0x22, 0x45, 0xa5, 0xc5, 0x40, 0x46, 0x8c, 0xa0, 0xbe, 0x42,
	0xb0, 0xf6, 0x8d, 0x17, 0x49, 0x01, 0x1f, 0x42, 0xa5, 0x5f, 0x20, 0x42, 0x41, 0xf5, 0xa9, 0xc2,
	0x15, 0x9c, 0x05, 0xc0, 0x7f, 0xc0, 0xa2, 0x4b, 0x9f, 0xcb, 0x76, 0xc6, 0x9a, 0xb8, 0x0e, 0xab,
	0x61, 0xf8, 0x51, 0x6a, 0x8f, 0x7a, 0x85, 0x60, 0x39, 0xe4, 0xb4, 0x97, 0x14, 0xce, 0x75, 0x7d,
	0x29, 0x30, 0xeb, 0xf9, 0xfc, 0x09, 0xb5, 0x64, 0x92, 0x98, 0xfe, 0x2d, 0x52, 0x2c, 0x63, 0xb6,
	0xb5, 0x09, 0x2b, 0x43, 0x1c, 0x12, 0x57, 0xf6, 0xa1, 0x9c, 0x56, 0x74, 0xea, 0xc9, 0xc6, 0x68,
	0x4f, 0x52, 0x1c, 0xa3, 0x9f, 0xac, 0xbf, 0x9f, 0x85, 0x72, 0x12, 0xf7, 0x75, 0xfc, 0x11, 0x41,
	0x75, 0x60, 0x6a, 0xe2, 0xff, 0x46, 0xc3, 0xe6, 0x3d, 0x0a, 0xb5, 0xad, 0xc2, 0x79, 0xb1, 0x34,
	0x75, 0xff, 0xea, 0xf3, 0x97, 0xd7, 0xa5, 0x86, 0xfa, 0x6f, 0xf6, 0xc1, 0x25, 0xd7, 0x84, 0xc9,
	0x45, 0xa6, 0xbb, 0x2f, 0x49, 0xe6, 0x6a, 0x89, 0xa0, 0xf2, 0xff, 0xec, 0x43, 0x11, 0x8a, 0x69,
	0x16, 0x15, 0xd3, 0x9c, 0x50, 0x4c, 0xf3, 0x7b, 0x62, 0xf0, 0x9d, 0xc2, 0x62, 0x2e, 0x06, 0x66,
	0xe5, 0x25, 0x7e, 0x87, 0x60, 0x69, 0x78, 0xf4, 0xe2, 0x9d, 0x71, 0xee, 0x3c, 0x77, 0x5c, 0xd7,
	0x56, 0xd3, 0xd4, 0xf4, 0xe1, 0xd7, 0xee, 0x86, 0x6f, 0x7d, 0xca, 0x78, 0xe3, 0xe6, 0x8c, 0x3f,
	0x20, 0x58, 0x1c, 0xea, 0x6a, 0xbc, 0x3d, 0xe9, 0x50, 0xac, 0xed, 0x4c, 0x90, 0x99, 0x5c, 0xc2,
	0x76, 0x24, 0x49, 0xc7, 0xff, 0x14, 0x95, 0x84, 0xdf, 0x20, 0xa8, 0x0e, 0x34, 0xe0, 0x38, 0x15,
	0x94, 0x37, 0x35, 0xc6, 0xa9, 0xa0, 0xdc, 0x4e, 0x57, 0x7f, 0x8e, 0xc8, 0x2b, 0x78, 0x35, 0x9f,
	0x7c, 0x63, 0x0b, 0x7e, 0xb3, 0xf8, 0xd9, 0x48, 0xf4, 0x46, 0x35, 0x6d, 0xf2, 0xa3, 0xf0, 0xbe,
	0x8f, 0x50, 0x67, 0x26, 0xba, 0xf8, 0xcd, 0xaf, 0x01, 0x00, 0x00, 0xff, 0xff, 0x18, 0xd5, 0x6a,
	0x43, 0x15, 0x0b, 0x00, 0x00,
}
