// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/cloud/ml/v1beta1/prediction_service.proto
// DO NOT EDIT!

package google_cloud_ml_v1beta1 // import "google.golang.org/genproto/googleapis/cloud/ml/v1beta1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/serviceconfig"
import google_api2 "google.golang.org/genproto/googleapis/api/httpbody"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Request for predictions to be issued against a trained model.
//
// The body of the request is a single JSON object with a single top-level
// field:
//
// <dl>
//   <dt>instances</dt>
//   <dd>A JSON array containing values representing the instances to use for
//       prediction.</dd>
// </dl>
//
// The structure of each element of the instances list is determined by your
// model's input definition. Instances can include named inputs or can contain
// only unlabeled values.
//
// Most data does not include named inputs. Some instances will be simple
// JSON values (boolean, number, or string). However, instances are often lists
// of simple values, or complex nested lists. Here are some examples of request
// bodies:
//
// CSV data with each row encoded as a string value:
// <pre>
// {"instances": ["1.0,true,\\"x\\"", "-2.0,false,\\"y\\""]}
// </pre>
// Plain text:
// <pre>
// {"instances": ["the quick brown fox", "la bruja le dio"]}
// </pre>
// Sentences encoded as lists of words (vectors of strings):
// <pre>
// {"instances": [["the","quick","brown"], ["la","bruja","le"]]}
// </pre>
// Floating point scalar values:
// <pre>
// {"instances": [0.0, 1.1, 2.2]}
// </pre>
// Vectors of integers:
// <pre>
// {"instances": [[0, 1, 2], [3, 4, 5],...]}
// </pre>
// Tensors (in this case, two-dimensional tensors):
// <pre>
// {"instances": [[[0, 1, 2], [3, 4, 5]], ...]}
// </pre>
// Images represented as a three-dimensional list. In this encoding scheme the
// first two dimensions represent the rows and columns of the image, and the
// third contains the R, G, and B values for each pixel.
// <pre>
// {"instances": [[[[138, 30, 66], [130, 20, 56], ...]]]]}
// </pre>
// Data must be encoded as UTF-8. If your data uses another character encoding,
// you must base64 encode the data and mark it as binary. To mark a JSON string
// as binary, replace it with an object with a single attribute named `b`:
// <pre>{"b": "..."} </pre>
// For example:
//
// Two Serialized tf.Examples (fake data, for illustrative purposes only):
// <pre>
// {"instances": [{"b64": "X5ad6u"}, {"b64": "IA9j4nx"}]}
// </pre>
// Two JPEG image byte strings (fake data, for illustrative purposes only):
// <pre>
// {"instances": [{"b64": "ASa8asdf"}, {"b64": "JLK7ljk3"}]}
// </pre>
// If your data includes named references, format each instance as a JSON object
// with the named references as the keys:
//
// JSON input data to be preprocessed:
// <pre>
// {"instances": [{"a": 1.0,  "b": true,  "c": "x"},
//                {"a": -2.0, "b": false, "c": "y"}]}
// </pre>
// Some models have an underlying TensorFlow graph that accepts multiple input
// tensors. In this case, you should use the names of JSON name/value pairs to
// identify the input tensors, as shown in the following exmaples:
//
// For a graph with input tensor aliases "tag" (string) and "image"
// (base64-encoded string):
// <pre>
// {"instances": [{"tag": "beach", "image": {"b64": "ASa8asdf"}},
//                {"tag": "car", "image": {"b64": "JLK7ljk3"}}]}
// </pre>
// For a graph with input tensor aliases "tag" (string) and "image"
// (3-dimensional array of 8-bit ints):
// <pre>
// {"instances": [{"tag": "beach", "image": [[[263, 1, 10], [262, 2, 11], ...]]},
//                {"tag": "car", "image": [[[10, 11, 24], [23, 10, 15], ...]]}]}
// </pre>
// If the call is successful, the response body will contain one prediction
// entry per instance in the request body. If prediction fails for any
// instance, the response body will contain no predictions and will contian
// a single error entry instead.
type PredictRequest struct {
	// Required. The resource name of a model or a version.
	//
	// Authorization: requires `Viewer` role on the parent project.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	//
	// Required. The prediction request body.
	HttpBody *google_api2.HttpBody `protobuf:"bytes,2,opt,name=http_body,json=httpBody" json:"http_body,omitempty"`
}

func (m *PredictRequest) Reset()                    { *m = PredictRequest{} }
func (m *PredictRequest) String() string            { return proto.CompactTextString(m) }
func (*PredictRequest) ProtoMessage()               {}
func (*PredictRequest) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{0} }

func (m *PredictRequest) GetHttpBody() *google_api2.HttpBody {
	if m != nil {
		return m.HttpBody
	}
	return nil
}

func init() {
	proto.RegisterType((*PredictRequest)(nil), "google.cloud.ml.v1beta1.PredictRequest")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for OnlinePredictionService service

type OnlinePredictionServiceClient interface {
	// Performs prediction on the data in the request.
	//
	// Responses are very similar to requests. There are two top-level fields,
	// each of which are JSON lists:
	//
	// <dl>
	//   <dt>predictions</dt>
	//   <dd>The list of predictions, one per instance in the request.</dd>
	//   <dt>error</dt>
	//   <dd>An error message returned instead of a prediction list if any
	//       instance produced an error.</dd>
	// </dl>
	//
	// If the call is successful, the response body will contain one prediction
	// entry per instance in the request body. If prediction fails for any
	// instance, the response body will contain no predictions and will contian
	// a single error entry instead.
	//
	// Even though there is one prediction per instance, the format of a
	// prediction is not directly related to the format of an instance.
	// Predictions take whatever format is specified in the outputs collection
	// defined in the model. The collection of predictions is returned in a JSON
	// list. Each member of the list can be a simple value, a list, or a JSON
	// object of any complexity. If your model has more than one output tensor,
	// each prediction will be a JSON object containing a name/value pair for each
	// output. The names identify the output aliases in the graph.
	//
	// The following examples show some possible responses:
	//
	// A simple set of predictions for three input instances, where each
	// prediction is an integer value:
	// <pre>
	// {"predictions": [5, 4, 3]}
	// </pre>
	// A more complex set of predictions, each containing two named values that
	// correspond to output tensors, named **label** and **scores** respectively.
	// The value of **label** is the predicted category ("car" or "beach") and
	// **scores** contains a list of probabilities for that instance across the
	// possible categories.
	// <pre>
	// {"predictions": [{"label": "beach", "scores": [0.1, 0.9]},
	//                  {"label": "car", "scores": [0.75, 0.25]}]}
	// </pre>
	// A response when there is an error processing an input instance:
	// <pre>
	// {"error": "Divide by zero"}
	// </pre>
	Predict(ctx context.Context, in *PredictRequest, opts ...grpc.CallOption) (*google_api2.HttpBody, error)
}

type onlinePredictionServiceClient struct {
	cc *grpc.ClientConn
}

func NewOnlinePredictionServiceClient(cc *grpc.ClientConn) OnlinePredictionServiceClient {
	return &onlinePredictionServiceClient{cc}
}

func (c *onlinePredictionServiceClient) Predict(ctx context.Context, in *PredictRequest, opts ...grpc.CallOption) (*google_api2.HttpBody, error) {
	out := new(google_api2.HttpBody)
	err := grpc.Invoke(ctx, "/google.cloud.ml.v1beta1.OnlinePredictionService/Predict", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for OnlinePredictionService service

type OnlinePredictionServiceServer interface {
	// Performs prediction on the data in the request.
	//
	// Responses are very similar to requests. There are two top-level fields,
	// each of which are JSON lists:
	//
	// <dl>
	//   <dt>predictions</dt>
	//   <dd>The list of predictions, one per instance in the request.</dd>
	//   <dt>error</dt>
	//   <dd>An error message returned instead of a prediction list if any
	//       instance produced an error.</dd>
	// </dl>
	//
	// If the call is successful, the response body will contain one prediction
	// entry per instance in the request body. If prediction fails for any
	// instance, the response body will contain no predictions and will contian
	// a single error entry instead.
	//
	// Even though there is one prediction per instance, the format of a
	// prediction is not directly related to the format of an instance.
	// Predictions take whatever format is specified in the outputs collection
	// defined in the model. The collection of predictions is returned in a JSON
	// list. Each member of the list can be a simple value, a list, or a JSON
	// object of any complexity. If your model has more than one output tensor,
	// each prediction will be a JSON object containing a name/value pair for each
	// output. The names identify the output aliases in the graph.
	//
	// The following examples show some possible responses:
	//
	// A simple set of predictions for three input instances, where each
	// prediction is an integer value:
	// <pre>
	// {"predictions": [5, 4, 3]}
	// </pre>
	// A more complex set of predictions, each containing two named values that
	// correspond to output tensors, named **label** and **scores** respectively.
	// The value of **label** is the predicted category ("car" or "beach") and
	// **scores** contains a list of probabilities for that instance across the
	// possible categories.
	// <pre>
	// {"predictions": [{"label": "beach", "scores": [0.1, 0.9]},
	//                  {"label": "car", "scores": [0.75, 0.25]}]}
	// </pre>
	// A response when there is an error processing an input instance:
	// <pre>
	// {"error": "Divide by zero"}
	// </pre>
	Predict(context.Context, *PredictRequest) (*google_api2.HttpBody, error)
}

func RegisterOnlinePredictionServiceServer(s *grpc.Server, srv OnlinePredictionServiceServer) {
	s.RegisterService(&_OnlinePredictionService_serviceDesc, srv)
}

func _OnlinePredictionService_Predict_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PredictRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OnlinePredictionServiceServer).Predict(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.ml.v1beta1.OnlinePredictionService/Predict",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OnlinePredictionServiceServer).Predict(ctx, req.(*PredictRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _OnlinePredictionService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.ml.v1beta1.OnlinePredictionService",
	HandlerType: (*OnlinePredictionServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Predict",
			Handler:    _OnlinePredictionService_Predict_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google.golang.org/genproto/googleapis/cloud/ml/v1beta1/prediction_service.proto",
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/cloud/ml/v1beta1/prediction_service.proto", fileDescriptor3)
}

var fileDescriptor3 = []byte{
	// 314 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x8c, 0x91, 0xc1, 0x4a, 0x03, 0x31,
	0x14, 0x45, 0x49, 0x11, 0xb5, 0x11, 0x5c, 0x04, 0xb1, 0xa5, 0x1b, 0x4b, 0x5d, 0x58, 0xba, 0x48,
	0x68, 0xdd, 0x55, 0x5c, 0xd8, 0x95, 0xae, 0x3a, 0xd4, 0x85, 0xcb, 0x92, 0x66, 0x62, 0x1a, 0xc9,
	0xe4, 0xc5, 0x99, 0xb4, 0x58, 0xc4, 0x8d, 0xbf, 0xd0, 0x4f, 0xf3, 0x17, 0xfc, 0x10, 0xc9, 0x4c,
	0x18, 0x90, 0x2a, 0x74, 0xf7, 0x48, 0xb8, 0xf7, 0xdc, 0x77, 0x1f, 0x9e, 0x2a, 0x00, 0x65, 0x24,
	0x55, 0x60, 0xb8, 0x55, 0x14, 0x72, 0xc5, 0x94, 0xb4, 0x2e, 0x07, 0x0f, 0xac, 0xfa, 0xe2, 0x4e,
	0x17, 0x4c, 0x18, 0x58, 0xa5, 0x2c, 0x33, 0x6c, 0x3d, 0x5c, 0x48, 0xcf, 0x87, 0xcc, 0xe5, 0x32,
	0xd5, 0xc2, 0x6b, 0xb0, 0xf3, 0x42, 0xe6, 0x6b, 0x2d, 0x24, 0x2d, 0x45, 0xa4, 0x15, 0x0d, 0x4b,
	0x05, 0xcd, 0x0c, 0x8d, 0x8a, 0xce, 0xc3, 0x7e, 0x24, 0xee, 0x34, 0x8b, 0x8e, 0x02, 0xec, 0xb3,
	0x56, 0x8c, 0x5b, 0x0b, 0x9e, 0x07, 0x54, 0x51, 0x31, 0x3a, 0x77, 0xfb, 0x5b, 0x2d, 0xbd, 0x77,
	0x0b, 0x48, 0x37, 0xf5, 0x50, 0x59, 0xf4, 0x9e, 0xf0, 0x69, 0x52, 0xad, 0x30, 0x93, 0xaf, 0x2b,
	0x59, 0x78, 0x42, 0xf0, 0x81, 0xe5, 0x99, 0x6c, 0xa3, 0x2e, 0xea, 0x37, 0x67, 0xe5, 0x4c, 0x86,
	0xb8, 0x19, 0x74, 0xf3, 0x20, 0x6c, 0x37, 0xba, 0xa8, 0x7f, 0x32, 0x3a, 0xa3, 0x11, 0xce, 0x9d,
	0xa6, 0xf7, 0xde, 0xbb, 0x09, 0xa4, 0x9b, 0xd9, 0xf1, 0x32, 0x4e, 0xa3, 0x2d, 0xc2, 0xad, 0xa9,
	0x35, 0xda, 0xca, 0xa4, 0xae, 0xe8, 0xb1, 0xda, 0x87, 0xbc, 0xe1, 0xa3, 0xf8, 0x48, 0xae, 0xe8,
	0x3f, 0x3d, 0xd1, 0xdf, 0xb1, 0x3a, 0x7f, 0xf2, 0x7a, 0xf4, 0xf3, 0xeb, 0x7b, 0xdb, 0xe8, 0xf7,
	0x2e, 0xeb, 0x83, 0xbc, 0x87, 0xc0, 0xb7, 0x2e, 0x87, 0x17, 0x29, 0x7c, 0xc1, 0x06, 0x83, 0x8f,
	0x71, 0xbc, 0xd1, 0x18, 0x0d, 0x26, 0x37, 0xf8, 0x42, 0x40, 0xb6, 0xc3, 0x0c, 0x9e, 0xd1, 0x60,
	0x72, 0xbe, 0x93, 0x37, 0x09, 0x4d, 0x25, 0x68, 0x71, 0x58, 0x56, 0x76, 0xfd, 0x13, 0x00, 0x00,
	0xff, 0xff, 0x22, 0x54, 0x5b, 0xa1, 0x2c, 0x02, 0x00, 0x00,
}
