package vmwareapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/vmware/mgmt/2019-08-09-preview/vmware"
)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result vmware.OperationListPage, err error)
	ListComplete(ctx context.Context) (result vmware.OperationListIterator, err error)
}

var _ OperationsClientAPI = (*vmware.OperationsClient)(nil)

// LocationsClientAPI contains the set of methods on the LocationsClient type.
type LocationsClientAPI interface {
	CheckQuotaAvailability(ctx context.Context, location string) (result vmware.Quota, err error)
	CheckTrialAvailability(ctx context.Context, location string) (result vmware.Trial, err error)
}

var _ LocationsClientAPI = (*vmware.LocationsClient)(nil)

// PrivateCloudsClientAPI contains the set of methods on the PrivateCloudsClient type.
type PrivateCloudsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, privateCloudName string, privateCloud vmware.PrivateCloud) (result vmware.PrivateCloudsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, privateCloudName string) (result vmware.PrivateCloudsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, privateCloudName string) (result vmware.PrivateCloud, err error)
	List(ctx context.Context, resourceGroupName string) (result vmware.PrivateCloudListPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string) (result vmware.PrivateCloudListIterator, err error)
	ListAdminCredentials(ctx context.Context, resourceGroupName string, privateCloudName string) (result vmware.AdminCredentials, err error)
	ListInSubscription(ctx context.Context) (result vmware.PrivateCloudListPage, err error)
	ListInSubscriptionComplete(ctx context.Context) (result vmware.PrivateCloudListIterator, err error)
	Update(ctx context.Context, resourceGroupName string, privateCloudName string, privateCloud vmware.PrivateCloud) (result vmware.PrivateCloudsUpdateFuture, err error)
}

var _ PrivateCloudsClientAPI = (*vmware.PrivateCloudsClient)(nil)

// ClustersClientAPI contains the set of methods on the ClustersClient type.
type ClustersClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, privateCloudName string, clusterName string, cluster vmware.Cluster) (result vmware.ClustersCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, privateCloudName string, clusterName string) (result vmware.ClustersDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, privateCloudName string, clusterName string) (result vmware.Cluster, err error)
	List(ctx context.Context, resourceGroupName string, privateCloudName string) (result vmware.ClusterListPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, privateCloudName string) (result vmware.ClusterListIterator, err error)
	Update(ctx context.Context, resourceGroupName string, privateCloudName string, clusterName string, cluster vmware.Cluster) (result vmware.ClustersUpdateFuture, err error)
}

var _ ClustersClientAPI = (*vmware.ClustersClient)(nil)
