// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sesv2

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateConfigurationSet = "CreateConfigurationSet"

// CreateConfigurationSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateConfigurationSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateConfigurationSet for more information on using the CreateConfigurationSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateConfigurationSetRequest method.
//    req, resp := client.CreateConfigurationSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateConfigurationSet
func (c *SESV2) CreateConfigurationSetRequest(input *CreateConfigurationSetInput) (req *request.Request, output *CreateConfigurationSetOutput) {
	op := &request.Operation{
		Name:       opCreateConfigurationSet,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/email/configuration-sets",
	}

	if input == nil {
		input = &CreateConfigurationSetInput{}
	}

	output = &CreateConfigurationSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateConfigurationSet API operation for Amazon Simple Email Service.
//
// Create a configuration set. Configuration sets are groups of rules that you
// can apply to the emails that you send. You apply a configuration set to an
// email by specifying the name of the configuration set when you call the Amazon
// SES API v2. When you apply a configuration set to an email, all of the rules
// in that configuration set are applied to the email.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation CreateConfigurationSet for usage and error information.
//
// Returned Error Types:
//   * AlreadyExistsException
//   The resource specified in your request already exists.
//
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * LimitExceededException
//   There are too many instances of the specified resource type.
//
//   * BadRequestException
//   The input you provided is invalid.
//
//   * ConcurrentModificationException
//   The resource is being modified by another operation or thread.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateConfigurationSet
func (c *SESV2) CreateConfigurationSet(input *CreateConfigurationSetInput) (*CreateConfigurationSetOutput, error) {
	req, out := c.CreateConfigurationSetRequest(input)
	return out, req.Send()
}

// CreateConfigurationSetWithContext is the same as CreateConfigurationSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateConfigurationSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) CreateConfigurationSetWithContext(ctx aws.Context, input *CreateConfigurationSetInput, opts ...request.Option) (*CreateConfigurationSetOutput, error) {
	req, out := c.CreateConfigurationSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateConfigurationSetEventDestination = "CreateConfigurationSetEventDestination"

// CreateConfigurationSetEventDestinationRequest generates a "aws/request.Request" representing the
// client's request for the CreateConfigurationSetEventDestination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateConfigurationSetEventDestination for more information on using the CreateConfigurationSetEventDestination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateConfigurationSetEventDestinationRequest method.
//    req, resp := client.CreateConfigurationSetEventDestinationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateConfigurationSetEventDestination
func (c *SESV2) CreateConfigurationSetEventDestinationRequest(input *CreateConfigurationSetEventDestinationInput) (req *request.Request, output *CreateConfigurationSetEventDestinationOutput) {
	op := &request.Operation{
		Name:       opCreateConfigurationSetEventDestination,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/email/configuration-sets/{ConfigurationSetName}/event-destinations",
	}

	if input == nil {
		input = &CreateConfigurationSetEventDestinationInput{}
	}

	output = &CreateConfigurationSetEventDestinationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateConfigurationSetEventDestination API operation for Amazon Simple Email Service.
//
// Create an event destination. Events include message sends, deliveries, opens,
// clicks, bounces, and complaints. Event destinations are places that you can
// send information about these events to. For example, you can send event data
// to Amazon SNS to receive notifications when you receive bounces or complaints,
// or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for
// long-term storage.
//
// A single configuration set can include more than one event destination.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation CreateConfigurationSetEventDestination for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * AlreadyExistsException
//   The resource specified in your request already exists.
//
//   * LimitExceededException
//   There are too many instances of the specified resource type.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateConfigurationSetEventDestination
func (c *SESV2) CreateConfigurationSetEventDestination(input *CreateConfigurationSetEventDestinationInput) (*CreateConfigurationSetEventDestinationOutput, error) {
	req, out := c.CreateConfigurationSetEventDestinationRequest(input)
	return out, req.Send()
}

// CreateConfigurationSetEventDestinationWithContext is the same as CreateConfigurationSetEventDestination with the addition of
// the ability to pass a context and additional request options.
//
// See CreateConfigurationSetEventDestination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) CreateConfigurationSetEventDestinationWithContext(ctx aws.Context, input *CreateConfigurationSetEventDestinationInput, opts ...request.Option) (*CreateConfigurationSetEventDestinationOutput, error) {
	req, out := c.CreateConfigurationSetEventDestinationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCustomVerificationEmailTemplate = "CreateCustomVerificationEmailTemplate"

// CreateCustomVerificationEmailTemplateRequest generates a "aws/request.Request" representing the
// client's request for the CreateCustomVerificationEmailTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCustomVerificationEmailTemplate for more information on using the CreateCustomVerificationEmailTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateCustomVerificationEmailTemplateRequest method.
//    req, resp := client.CreateCustomVerificationEmailTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateCustomVerificationEmailTemplate
func (c *SESV2) CreateCustomVerificationEmailTemplateRequest(input *CreateCustomVerificationEmailTemplateInput) (req *request.Request, output *CreateCustomVerificationEmailTemplateOutput) {
	op := &request.Operation{
		Name:       opCreateCustomVerificationEmailTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/email/custom-verification-email-templates",
	}

	if input == nil {
		input = &CreateCustomVerificationEmailTemplateInput{}
	}

	output = &CreateCustomVerificationEmailTemplateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateCustomVerificationEmailTemplate API operation for Amazon Simple Email Service.
//
// Creates a new custom verification email template.
//
// For more information about custom verification email templates, see Using
// Custom Verification Email Templates (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html)
// in the Amazon SES Developer Guide.
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation CreateCustomVerificationEmailTemplate for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input you provided is invalid.
//
//   * AlreadyExistsException
//   The resource specified in your request already exists.
//
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * LimitExceededException
//   There are too many instances of the specified resource type.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateCustomVerificationEmailTemplate
func (c *SESV2) CreateCustomVerificationEmailTemplate(input *CreateCustomVerificationEmailTemplateInput) (*CreateCustomVerificationEmailTemplateOutput, error) {
	req, out := c.CreateCustomVerificationEmailTemplateRequest(input)
	return out, req.Send()
}

// CreateCustomVerificationEmailTemplateWithContext is the same as CreateCustomVerificationEmailTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCustomVerificationEmailTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) CreateCustomVerificationEmailTemplateWithContext(ctx aws.Context, input *CreateCustomVerificationEmailTemplateInput, opts ...request.Option) (*CreateCustomVerificationEmailTemplateOutput, error) {
	req, out := c.CreateCustomVerificationEmailTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDedicatedIpPool = "CreateDedicatedIpPool"

// CreateDedicatedIpPoolRequest generates a "aws/request.Request" representing the
// client's request for the CreateDedicatedIpPool operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDedicatedIpPool for more information on using the CreateDedicatedIpPool
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDedicatedIpPoolRequest method.
//    req, resp := client.CreateDedicatedIpPoolRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateDedicatedIpPool
func (c *SESV2) CreateDedicatedIpPoolRequest(input *CreateDedicatedIpPoolInput) (req *request.Request, output *CreateDedicatedIpPoolOutput) {
	op := &request.Operation{
		Name:       opCreateDedicatedIpPool,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/email/dedicated-ip-pools",
	}

	if input == nil {
		input = &CreateDedicatedIpPoolInput{}
	}

	output = &CreateDedicatedIpPoolOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateDedicatedIpPool API operation for Amazon Simple Email Service.
//
// Create a new pool of dedicated IP addresses. A pool can include one or more
// dedicated IP addresses that are associated with your AWS account. You can
// associate a pool with a configuration set. When you send an email that uses
// that configuration set, the message is sent from one of the addresses in
// the associated pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation CreateDedicatedIpPool for usage and error information.
//
// Returned Error Types:
//   * AlreadyExistsException
//   The resource specified in your request already exists.
//
//   * LimitExceededException
//   There are too many instances of the specified resource type.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
//   * ConcurrentModificationException
//   The resource is being modified by another operation or thread.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateDedicatedIpPool
func (c *SESV2) CreateDedicatedIpPool(input *CreateDedicatedIpPoolInput) (*CreateDedicatedIpPoolOutput, error) {
	req, out := c.CreateDedicatedIpPoolRequest(input)
	return out, req.Send()
}

// CreateDedicatedIpPoolWithContext is the same as CreateDedicatedIpPool with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDedicatedIpPool for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) CreateDedicatedIpPoolWithContext(ctx aws.Context, input *CreateDedicatedIpPoolInput, opts ...request.Option) (*CreateDedicatedIpPoolOutput, error) {
	req, out := c.CreateDedicatedIpPoolRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDeliverabilityTestReport = "CreateDeliverabilityTestReport"

// CreateDeliverabilityTestReportRequest generates a "aws/request.Request" representing the
// client's request for the CreateDeliverabilityTestReport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDeliverabilityTestReport for more information on using the CreateDeliverabilityTestReport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDeliverabilityTestReportRequest method.
//    req, resp := client.CreateDeliverabilityTestReportRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateDeliverabilityTestReport
func (c *SESV2) CreateDeliverabilityTestReportRequest(input *CreateDeliverabilityTestReportInput) (req *request.Request, output *CreateDeliverabilityTestReportOutput) {
	op := &request.Operation{
		Name:       opCreateDeliverabilityTestReport,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/email/deliverability-dashboard/test",
	}

	if input == nil {
		input = &CreateDeliverabilityTestReportInput{}
	}

	output = &CreateDeliverabilityTestReportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDeliverabilityTestReport API operation for Amazon Simple Email Service.
//
// Create a new predictive inbox placement test. Predictive inbox placement
// tests can help you predict how your messages will be handled by various email
// providers around the world. When you perform a predictive inbox placement
// test, you provide a sample message that contains the content that you plan
// to send to your customers. Amazon SES then sends that message to special
// email addresses spread across several major email providers. After about
// 24 hours, the test is complete, and you can use the GetDeliverabilityTestReport
// operation to view the results of the test.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation CreateDeliverabilityTestReport for usage and error information.
//
// Returned Error Types:
//   * AccountSuspendedException
//   The message can't be sent because the account's ability to send email has
//   been permanently restricted.
//
//   * SendingPausedException
//   The message can't be sent because the account's ability to send email is
//   currently paused.
//
//   * MessageRejected
//   The message can't be sent because it contains invalid content.
//
//   * MailFromDomainNotVerifiedException
//   The message can't be sent because the sending domain isn't verified.
//
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * LimitExceededException
//   There are too many instances of the specified resource type.
//
//   * BadRequestException
//   The input you provided is invalid.
//
//   * ConcurrentModificationException
//   The resource is being modified by another operation or thread.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateDeliverabilityTestReport
func (c *SESV2) CreateDeliverabilityTestReport(input *CreateDeliverabilityTestReportInput) (*CreateDeliverabilityTestReportOutput, error) {
	req, out := c.CreateDeliverabilityTestReportRequest(input)
	return out, req.Send()
}

// CreateDeliverabilityTestReportWithContext is the same as CreateDeliverabilityTestReport with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDeliverabilityTestReport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) CreateDeliverabilityTestReportWithContext(ctx aws.Context, input *CreateDeliverabilityTestReportInput, opts ...request.Option) (*CreateDeliverabilityTestReportOutput, error) {
	req, out := c.CreateDeliverabilityTestReportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEmailIdentity = "CreateEmailIdentity"

// CreateEmailIdentityRequest generates a "aws/request.Request" representing the
// client's request for the CreateEmailIdentity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEmailIdentity for more information on using the CreateEmailIdentity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateEmailIdentityRequest method.
//    req, resp := client.CreateEmailIdentityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateEmailIdentity
func (c *SESV2) CreateEmailIdentityRequest(input *CreateEmailIdentityInput) (req *request.Request, output *CreateEmailIdentityOutput) {
	op := &request.Operation{
		Name:       opCreateEmailIdentity,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/email/identities",
	}

	if input == nil {
		input = &CreateEmailIdentityInput{}
	}

	output = &CreateEmailIdentityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEmailIdentity API operation for Amazon Simple Email Service.
//
// Starts the process of verifying an email identity. An identity is an email
// address or domain that you use when you send email. Before you can use an
// identity to send email, you first have to verify it. By verifying an identity,
// you demonstrate that you're the owner of the identity, and that you've given
// Amazon SES API v2 permission to send email from the identity.
//
// When you verify an email address, Amazon SES sends an email to the address.
// Your email address is verified as soon as you follow the link in the verification
// email.
//
// When you verify a domain without specifying the DkimSigningAttributes object,
// this operation provides a set of DKIM tokens. You can convert these tokens
// into CNAME records, which you then add to the DNS configuration for your
// domain. Your domain is verified when Amazon SES detects these records in
// the DNS configuration for your domain. This verification method is known
// as Easy DKIM (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html).
//
// Alternatively, you can perform the verification process by providing your
// own public-private key pair. This verification method is known as Bring Your
// Own DKIM (BYODKIM). To use BYODKIM, your call to the CreateEmailIdentity
// operation has to include the DkimSigningAttributes object. When you specify
// this object, you provide a selector (a component of the DNS record name that
// identifies the public key that you want to use for DKIM authentication) and
// a private key.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation CreateEmailIdentity for usage and error information.
//
// Returned Error Types:
//   * AlreadyExistsException
//   The resource specified in your request already exists.
//
//   * LimitExceededException
//   There are too many instances of the specified resource type.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
//   * ConcurrentModificationException
//   The resource is being modified by another operation or thread.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateEmailIdentity
func (c *SESV2) CreateEmailIdentity(input *CreateEmailIdentityInput) (*CreateEmailIdentityOutput, error) {
	req, out := c.CreateEmailIdentityRequest(input)
	return out, req.Send()
}

// CreateEmailIdentityWithContext is the same as CreateEmailIdentity with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEmailIdentity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) CreateEmailIdentityWithContext(ctx aws.Context, input *CreateEmailIdentityInput, opts ...request.Option) (*CreateEmailIdentityOutput, error) {
	req, out := c.CreateEmailIdentityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEmailIdentityPolicy = "CreateEmailIdentityPolicy"

// CreateEmailIdentityPolicyRequest generates a "aws/request.Request" representing the
// client's request for the CreateEmailIdentityPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEmailIdentityPolicy for more information on using the CreateEmailIdentityPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateEmailIdentityPolicyRequest method.
//    req, resp := client.CreateEmailIdentityPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateEmailIdentityPolicy
func (c *SESV2) CreateEmailIdentityPolicyRequest(input *CreateEmailIdentityPolicyInput) (req *request.Request, output *CreateEmailIdentityPolicyOutput) {
	op := &request.Operation{
		Name:       opCreateEmailIdentityPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/email/identities/{EmailIdentity}/policies/{PolicyName}",
	}

	if input == nil {
		input = &CreateEmailIdentityPolicyInput{}
	}

	output = &CreateEmailIdentityPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateEmailIdentityPolicy API operation for Amazon Simple Email Service.
//
// Creates the specified sending authorization policy for the given identity
// (an email address or a domain).
//
// This API is for the identity owner only. If you have not verified the identity,
// this API will return an error.
//
// Sending authorization is a feature that enables an identity owner to authorize
// other senders to use its identities. For information about using sending
// authorization, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation CreateEmailIdentityPolicy for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * AlreadyExistsException
//   The resource specified in your request already exists.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * LimitExceededException
//   There are too many instances of the specified resource type.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateEmailIdentityPolicy
func (c *SESV2) CreateEmailIdentityPolicy(input *CreateEmailIdentityPolicyInput) (*CreateEmailIdentityPolicyOutput, error) {
	req, out := c.CreateEmailIdentityPolicyRequest(input)
	return out, req.Send()
}

// CreateEmailIdentityPolicyWithContext is the same as CreateEmailIdentityPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEmailIdentityPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) CreateEmailIdentityPolicyWithContext(ctx aws.Context, input *CreateEmailIdentityPolicyInput, opts ...request.Option) (*CreateEmailIdentityPolicyOutput, error) {
	req, out := c.CreateEmailIdentityPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEmailTemplate = "CreateEmailTemplate"

// CreateEmailTemplateRequest generates a "aws/request.Request" representing the
// client's request for the CreateEmailTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEmailTemplate for more information on using the CreateEmailTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateEmailTemplateRequest method.
//    req, resp := client.CreateEmailTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateEmailTemplate
func (c *SESV2) CreateEmailTemplateRequest(input *CreateEmailTemplateInput) (req *request.Request, output *CreateEmailTemplateOutput) {
	op := &request.Operation{
		Name:       opCreateEmailTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/email/templates",
	}

	if input == nil {
		input = &CreateEmailTemplateInput{}
	}

	output = &CreateEmailTemplateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateEmailTemplate API operation for Amazon Simple Email Service.
//
// Creates an email template. Email templates enable you to send personalized
// email to one or more destinations in a single API operation. For more information,
// see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html).
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation CreateEmailTemplate for usage and error information.
//
// Returned Error Types:
//   * AlreadyExistsException
//   The resource specified in your request already exists.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
//   * LimitExceededException
//   There are too many instances of the specified resource type.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateEmailTemplate
func (c *SESV2) CreateEmailTemplate(input *CreateEmailTemplateInput) (*CreateEmailTemplateOutput, error) {
	req, out := c.CreateEmailTemplateRequest(input)
	return out, req.Send()
}

// CreateEmailTemplateWithContext is the same as CreateEmailTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEmailTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) CreateEmailTemplateWithContext(ctx aws.Context, input *CreateEmailTemplateInput, opts ...request.Option) (*CreateEmailTemplateOutput, error) {
	req, out := c.CreateEmailTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateImportJob = "CreateImportJob"

// CreateImportJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateImportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateImportJob for more information on using the CreateImportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateImportJobRequest method.
//    req, resp := client.CreateImportJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateImportJob
func (c *SESV2) CreateImportJobRequest(input *CreateImportJobInput) (req *request.Request, output *CreateImportJobOutput) {
	op := &request.Operation{
		Name:       opCreateImportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/email/import-jobs",
	}

	if input == nil {
		input = &CreateImportJobInput{}
	}

	output = &CreateImportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateImportJob API operation for Amazon Simple Email Service.
//
// Creates an import job for a data destination.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation CreateImportJob for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input you provided is invalid.
//
//   * LimitExceededException
//   There are too many instances of the specified resource type.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateImportJob
func (c *SESV2) CreateImportJob(input *CreateImportJobInput) (*CreateImportJobOutput, error) {
	req, out := c.CreateImportJobRequest(input)
	return out, req.Send()
}

// CreateImportJobWithContext is the same as CreateImportJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateImportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) CreateImportJobWithContext(ctx aws.Context, input *CreateImportJobInput, opts ...request.Option) (*CreateImportJobOutput, error) {
	req, out := c.CreateImportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConfigurationSet = "DeleteConfigurationSet"

// DeleteConfigurationSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConfigurationSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConfigurationSet for more information on using the DeleteConfigurationSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteConfigurationSetRequest method.
//    req, resp := client.DeleteConfigurationSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteConfigurationSet
func (c *SESV2) DeleteConfigurationSetRequest(input *DeleteConfigurationSetInput) (req *request.Request, output *DeleteConfigurationSetOutput) {
	op := &request.Operation{
		Name:       opDeleteConfigurationSet,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2/email/configuration-sets/{ConfigurationSetName}",
	}

	if input == nil {
		input = &DeleteConfigurationSetInput{}
	}

	output = &DeleteConfigurationSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteConfigurationSet API operation for Amazon Simple Email Service.
//
// Delete an existing configuration set.
//
// Configuration sets are groups of rules that you can apply to the emails you
// send. You apply a configuration set to an email by including a reference
// to the configuration set in the headers of the email. When you apply a configuration
// set to an email, all of the rules in that configuration set are applied to
// the email.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation DeleteConfigurationSet for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
//   * ConcurrentModificationException
//   The resource is being modified by another operation or thread.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteConfigurationSet
func (c *SESV2) DeleteConfigurationSet(input *DeleteConfigurationSetInput) (*DeleteConfigurationSetOutput, error) {
	req, out := c.DeleteConfigurationSetRequest(input)
	return out, req.Send()
}

// DeleteConfigurationSetWithContext is the same as DeleteConfigurationSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConfigurationSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) DeleteConfigurationSetWithContext(ctx aws.Context, input *DeleteConfigurationSetInput, opts ...request.Option) (*DeleteConfigurationSetOutput, error) {
	req, out := c.DeleteConfigurationSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConfigurationSetEventDestination = "DeleteConfigurationSetEventDestination"

// DeleteConfigurationSetEventDestinationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConfigurationSetEventDestination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConfigurationSetEventDestination for more information on using the DeleteConfigurationSetEventDestination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteConfigurationSetEventDestinationRequest method.
//    req, resp := client.DeleteConfigurationSetEventDestinationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteConfigurationSetEventDestination
func (c *SESV2) DeleteConfigurationSetEventDestinationRequest(input *DeleteConfigurationSetEventDestinationInput) (req *request.Request, output *DeleteConfigurationSetEventDestinationOutput) {
	op := &request.Operation{
		Name:       opDeleteConfigurationSetEventDestination,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2/email/configuration-sets/{ConfigurationSetName}/event-destinations/{EventDestinationName}",
	}

	if input == nil {
		input = &DeleteConfigurationSetEventDestinationInput{}
	}

	output = &DeleteConfigurationSetEventDestinationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteConfigurationSetEventDestination API operation for Amazon Simple Email Service.
//
// Delete an event destination.
//
// Events include message sends, deliveries, opens, clicks, bounces, and complaints.
// Event destinations are places that you can send information about these events
// to. For example, you can send event data to Amazon SNS to receive notifications
// when you receive bounces or complaints, or you can use Amazon Kinesis Data
// Firehose to stream data to Amazon S3 for long-term storage.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation DeleteConfigurationSetEventDestination for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteConfigurationSetEventDestination
func (c *SESV2) DeleteConfigurationSetEventDestination(input *DeleteConfigurationSetEventDestinationInput) (*DeleteConfigurationSetEventDestinationOutput, error) {
	req, out := c.DeleteConfigurationSetEventDestinationRequest(input)
	return out, req.Send()
}

// DeleteConfigurationSetEventDestinationWithContext is the same as DeleteConfigurationSetEventDestination with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConfigurationSetEventDestination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) DeleteConfigurationSetEventDestinationWithContext(ctx aws.Context, input *DeleteConfigurationSetEventDestinationInput, opts ...request.Option) (*DeleteConfigurationSetEventDestinationOutput, error) {
	req, out := c.DeleteConfigurationSetEventDestinationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCustomVerificationEmailTemplate = "DeleteCustomVerificationEmailTemplate"

// DeleteCustomVerificationEmailTemplateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCustomVerificationEmailTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCustomVerificationEmailTemplate for more information on using the DeleteCustomVerificationEmailTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteCustomVerificationEmailTemplateRequest method.
//    req, resp := client.DeleteCustomVerificationEmailTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteCustomVerificationEmailTemplate
func (c *SESV2) DeleteCustomVerificationEmailTemplateRequest(input *DeleteCustomVerificationEmailTemplateInput) (req *request.Request, output *DeleteCustomVerificationEmailTemplateOutput) {
	op := &request.Operation{
		Name:       opDeleteCustomVerificationEmailTemplate,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2/email/custom-verification-email-templates/{TemplateName}",
	}

	if input == nil {
		input = &DeleteCustomVerificationEmailTemplateInput{}
	}

	output = &DeleteCustomVerificationEmailTemplateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCustomVerificationEmailTemplate API operation for Amazon Simple Email Service.
//
// Deletes an existing custom verification email template.
//
// For more information about custom verification email templates, see Using
// Custom Verification Email Templates (https://docs.aws.amazon.com/es/latest/DeveloperGuide/send-email-verify-address-custom.html)
// in the Amazon SES Developer Guide.
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation DeleteCustomVerificationEmailTemplate for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteCustomVerificationEmailTemplate
func (c *SESV2) DeleteCustomVerificationEmailTemplate(input *DeleteCustomVerificationEmailTemplateInput) (*DeleteCustomVerificationEmailTemplateOutput, error) {
	req, out := c.DeleteCustomVerificationEmailTemplateRequest(input)
	return out, req.Send()
}

// DeleteCustomVerificationEmailTemplateWithContext is the same as DeleteCustomVerificationEmailTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCustomVerificationEmailTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) DeleteCustomVerificationEmailTemplateWithContext(ctx aws.Context, input *DeleteCustomVerificationEmailTemplateInput, opts ...request.Option) (*DeleteCustomVerificationEmailTemplateOutput, error) {
	req, out := c.DeleteCustomVerificationEmailTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDedicatedIpPool = "DeleteDedicatedIpPool"

// DeleteDedicatedIpPoolRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDedicatedIpPool operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDedicatedIpPool for more information on using the DeleteDedicatedIpPool
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDedicatedIpPoolRequest method.
//    req, resp := client.DeleteDedicatedIpPoolRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteDedicatedIpPool
func (c *SESV2) DeleteDedicatedIpPoolRequest(input *DeleteDedicatedIpPoolInput) (req *request.Request, output *DeleteDedicatedIpPoolOutput) {
	op := &request.Operation{
		Name:       opDeleteDedicatedIpPool,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2/email/dedicated-ip-pools/{PoolName}",
	}

	if input == nil {
		input = &DeleteDedicatedIpPoolInput{}
	}

	output = &DeleteDedicatedIpPoolOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDedicatedIpPool API operation for Amazon Simple Email Service.
//
// Delete a dedicated IP pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation DeleteDedicatedIpPool for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
//   * ConcurrentModificationException
//   The resource is being modified by another operation or thread.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteDedicatedIpPool
func (c *SESV2) DeleteDedicatedIpPool(input *DeleteDedicatedIpPoolInput) (*DeleteDedicatedIpPoolOutput, error) {
	req, out := c.DeleteDedicatedIpPoolRequest(input)
	return out, req.Send()
}

// DeleteDedicatedIpPoolWithContext is the same as DeleteDedicatedIpPool with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDedicatedIpPool for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) DeleteDedicatedIpPoolWithContext(ctx aws.Context, input *DeleteDedicatedIpPoolInput, opts ...request.Option) (*DeleteDedicatedIpPoolOutput, error) {
	req, out := c.DeleteDedicatedIpPoolRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEmailIdentity = "DeleteEmailIdentity"

// DeleteEmailIdentityRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEmailIdentity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEmailIdentity for more information on using the DeleteEmailIdentity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteEmailIdentityRequest method.
//    req, resp := client.DeleteEmailIdentityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteEmailIdentity
func (c *SESV2) DeleteEmailIdentityRequest(input *DeleteEmailIdentityInput) (req *request.Request, output *DeleteEmailIdentityOutput) {
	op := &request.Operation{
		Name:       opDeleteEmailIdentity,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2/email/identities/{EmailIdentity}",
	}

	if input == nil {
		input = &DeleteEmailIdentityInput{}
	}

	output = &DeleteEmailIdentityOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteEmailIdentity API operation for Amazon Simple Email Service.
//
// Deletes an email identity. An identity can be either an email address or
// a domain name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation DeleteEmailIdentity for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
//   * ConcurrentModificationException
//   The resource is being modified by another operation or thread.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteEmailIdentity
func (c *SESV2) DeleteEmailIdentity(input *DeleteEmailIdentityInput) (*DeleteEmailIdentityOutput, error) {
	req, out := c.DeleteEmailIdentityRequest(input)
	return out, req.Send()
}

// DeleteEmailIdentityWithContext is the same as DeleteEmailIdentity with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEmailIdentity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) DeleteEmailIdentityWithContext(ctx aws.Context, input *DeleteEmailIdentityInput, opts ...request.Option) (*DeleteEmailIdentityOutput, error) {
	req, out := c.DeleteEmailIdentityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEmailIdentityPolicy = "DeleteEmailIdentityPolicy"

// DeleteEmailIdentityPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEmailIdentityPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEmailIdentityPolicy for more information on using the DeleteEmailIdentityPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteEmailIdentityPolicyRequest method.
//    req, resp := client.DeleteEmailIdentityPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteEmailIdentityPolicy
func (c *SESV2) DeleteEmailIdentityPolicyRequest(input *DeleteEmailIdentityPolicyInput) (req *request.Request, output *DeleteEmailIdentityPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteEmailIdentityPolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2/email/identities/{EmailIdentity}/policies/{PolicyName}",
	}

	if input == nil {
		input = &DeleteEmailIdentityPolicyInput{}
	}

	output = &DeleteEmailIdentityPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteEmailIdentityPolicy API operation for Amazon Simple Email Service.
//
// Deletes the specified sending authorization policy for the given identity
// (an email address or a domain). This API returns successfully even if a policy
// with the specified name does not exist.
//
// This API is for the identity owner only. If you have not verified the identity,
// this API will return an error.
//
// Sending authorization is a feature that enables an identity owner to authorize
// other senders to use its identities. For information about using sending
// authorization, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation DeleteEmailIdentityPolicy for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteEmailIdentityPolicy
func (c *SESV2) DeleteEmailIdentityPolicy(input *DeleteEmailIdentityPolicyInput) (*DeleteEmailIdentityPolicyOutput, error) {
	req, out := c.DeleteEmailIdentityPolicyRequest(input)
	return out, req.Send()
}

// DeleteEmailIdentityPolicyWithContext is the same as DeleteEmailIdentityPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEmailIdentityPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) DeleteEmailIdentityPolicyWithContext(ctx aws.Context, input *DeleteEmailIdentityPolicyInput, opts ...request.Option) (*DeleteEmailIdentityPolicyOutput, error) {
	req, out := c.DeleteEmailIdentityPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEmailTemplate = "DeleteEmailTemplate"

// DeleteEmailTemplateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEmailTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEmailTemplate for more information on using the DeleteEmailTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteEmailTemplateRequest method.
//    req, resp := client.DeleteEmailTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteEmailTemplate
func (c *SESV2) DeleteEmailTemplateRequest(input *DeleteEmailTemplateInput) (req *request.Request, output *DeleteEmailTemplateOutput) {
	op := &request.Operation{
		Name:       opDeleteEmailTemplate,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2/email/templates/{TemplateName}",
	}

	if input == nil {
		input = &DeleteEmailTemplateInput{}
	}

	output = &DeleteEmailTemplateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteEmailTemplate API operation for Amazon Simple Email Service.
//
// Deletes an email template.
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation DeleteEmailTemplate for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteEmailTemplate
func (c *SESV2) DeleteEmailTemplate(input *DeleteEmailTemplateInput) (*DeleteEmailTemplateOutput, error) {
	req, out := c.DeleteEmailTemplateRequest(input)
	return out, req.Send()
}

// DeleteEmailTemplateWithContext is the same as DeleteEmailTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEmailTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) DeleteEmailTemplateWithContext(ctx aws.Context, input *DeleteEmailTemplateInput, opts ...request.Option) (*DeleteEmailTemplateOutput, error) {
	req, out := c.DeleteEmailTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSuppressedDestination = "DeleteSuppressedDestination"

// DeleteSuppressedDestinationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSuppressedDestination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSuppressedDestination for more information on using the DeleteSuppressedDestination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSuppressedDestinationRequest method.
//    req, resp := client.DeleteSuppressedDestinationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteSuppressedDestination
func (c *SESV2) DeleteSuppressedDestinationRequest(input *DeleteSuppressedDestinationInput) (req *request.Request, output *DeleteSuppressedDestinationOutput) {
	op := &request.Operation{
		Name:       opDeleteSuppressedDestination,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2/email/suppression/addresses/{EmailAddress}",
	}

	if input == nil {
		input = &DeleteSuppressedDestinationInput{}
	}

	output = &DeleteSuppressedDestinationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSuppressedDestination API operation for Amazon Simple Email Service.
//
// Removes an email address from the suppression list for your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation DeleteSuppressedDestination for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * BadRequestException
//   The input you provided is invalid.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteSuppressedDestination
func (c *SESV2) DeleteSuppressedDestination(input *DeleteSuppressedDestinationInput) (*DeleteSuppressedDestinationOutput, error) {
	req, out := c.DeleteSuppressedDestinationRequest(input)
	return out, req.Send()
}

// DeleteSuppressedDestinationWithContext is the same as DeleteSuppressedDestination with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSuppressedDestination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) DeleteSuppressedDestinationWithContext(ctx aws.Context, input *DeleteSuppressedDestinationInput, opts ...request.Option) (*DeleteSuppressedDestinationOutput, error) {
	req, out := c.DeleteSuppressedDestinationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAccount = "GetAccount"

// GetAccountRequest generates a "aws/request.Request" representing the
// client's request for the GetAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAccount for more information on using the GetAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAccountRequest method.
//    req, resp := client.GetAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetAccount
func (c *SESV2) GetAccountRequest(input *GetAccountInput) (req *request.Request, output *GetAccountOutput) {
	op := &request.Operation{
		Name:       opGetAccount,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/email/account",
	}

	if input == nil {
		input = &GetAccountInput{}
	}

	output = &GetAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAccount API operation for Amazon Simple Email Service.
//
// Obtain information about the email-sending status and capabilities of your
// Amazon SES account in the current AWS Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation GetAccount for usage and error information.
//
// Returned Error Types:
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetAccount
func (c *SESV2) GetAccount(input *GetAccountInput) (*GetAccountOutput, error) {
	req, out := c.GetAccountRequest(input)
	return out, req.Send()
}

// GetAccountWithContext is the same as GetAccount with the addition of
// the ability to pass a context and additional request options.
//
// See GetAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) GetAccountWithContext(ctx aws.Context, input *GetAccountInput, opts ...request.Option) (*GetAccountOutput, error) {
	req, out := c.GetAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBlacklistReports = "GetBlacklistReports"

// GetBlacklistReportsRequest generates a "aws/request.Request" representing the
// client's request for the GetBlacklistReports operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBlacklistReports for more information on using the GetBlacklistReports
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBlacklistReportsRequest method.
//    req, resp := client.GetBlacklistReportsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetBlacklistReports
func (c *SESV2) GetBlacklistReportsRequest(input *GetBlacklistReportsInput) (req *request.Request, output *GetBlacklistReportsOutput) {
	op := &request.Operation{
		Name:       opGetBlacklistReports,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/email/deliverability-dashboard/blacklist-report",
	}

	if input == nil {
		input = &GetBlacklistReportsInput{}
	}

	output = &GetBlacklistReportsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBlacklistReports API operation for Amazon Simple Email Service.
//
// Retrieve a list of the blacklists that your dedicated IP addresses appear
// on.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation GetBlacklistReports for usage and error information.
//
// Returned Error Types:
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetBlacklistReports
func (c *SESV2) GetBlacklistReports(input *GetBlacklistReportsInput) (*GetBlacklistReportsOutput, error) {
	req, out := c.GetBlacklistReportsRequest(input)
	return out, req.Send()
}

// GetBlacklistReportsWithContext is the same as GetBlacklistReports with the addition of
// the ability to pass a context and additional request options.
//
// See GetBlacklistReports for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) GetBlacklistReportsWithContext(ctx aws.Context, input *GetBlacklistReportsInput, opts ...request.Option) (*GetBlacklistReportsOutput, error) {
	req, out := c.GetBlacklistReportsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetConfigurationSet = "GetConfigurationSet"

// GetConfigurationSetRequest generates a "aws/request.Request" representing the
// client's request for the GetConfigurationSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetConfigurationSet for more information on using the GetConfigurationSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetConfigurationSetRequest method.
//    req, resp := client.GetConfigurationSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetConfigurationSet
func (c *SESV2) GetConfigurationSetRequest(input *GetConfigurationSetInput) (req *request.Request, output *GetConfigurationSetOutput) {
	op := &request.Operation{
		Name:       opGetConfigurationSet,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/email/configuration-sets/{ConfigurationSetName}",
	}

	if input == nil {
		input = &GetConfigurationSetInput{}
	}

	output = &GetConfigurationSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetConfigurationSet API operation for Amazon Simple Email Service.
//
// Get information about an existing configuration set, including the dedicated
// IP pool that it's associated with, whether or not it's enabled for sending
// email, and more.
//
// Configuration sets are groups of rules that you can apply to the emails you
// send. You apply a configuration set to an email by including a reference
// to the configuration set in the headers of the email. When you apply a configuration
// set to an email, all of the rules in that configuration set are applied to
// the email.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation GetConfigurationSet for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetConfigurationSet
func (c *SESV2) GetConfigurationSet(input *GetConfigurationSetInput) (*GetConfigurationSetOutput, error) {
	req, out := c.GetConfigurationSetRequest(input)
	return out, req.Send()
}

// GetConfigurationSetWithContext is the same as GetConfigurationSet with the addition of
// the ability to pass a context and additional request options.
//
// See GetConfigurationSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) GetConfigurationSetWithContext(ctx aws.Context, input *GetConfigurationSetInput, opts ...request.Option) (*GetConfigurationSetOutput, error) {
	req, out := c.GetConfigurationSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetConfigurationSetEventDestinations = "GetConfigurationSetEventDestinations"

// GetConfigurationSetEventDestinationsRequest generates a "aws/request.Request" representing the
// client's request for the GetConfigurationSetEventDestinations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetConfigurationSetEventDestinations for more information on using the GetConfigurationSetEventDestinations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetConfigurationSetEventDestinationsRequest method.
//    req, resp := client.GetConfigurationSetEventDestinationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetConfigurationSetEventDestinations
func (c *SESV2) GetConfigurationSetEventDestinationsRequest(input *GetConfigurationSetEventDestinationsInput) (req *request.Request, output *GetConfigurationSetEventDestinationsOutput) {
	op := &request.Operation{
		Name:       opGetConfigurationSetEventDestinations,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/email/configuration-sets/{ConfigurationSetName}/event-destinations",
	}

	if input == nil {
		input = &GetConfigurationSetEventDestinationsInput{}
	}

	output = &GetConfigurationSetEventDestinationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetConfigurationSetEventDestinations API operation for Amazon Simple Email Service.
//
// Retrieve a list of event destinations that are associated with a configuration
// set.
//
// Events include message sends, deliveries, opens, clicks, bounces, and complaints.
// Event destinations are places that you can send information about these events
// to. For example, you can send event data to Amazon SNS to receive notifications
// when you receive bounces or complaints, or you can use Amazon Kinesis Data
// Firehose to stream data to Amazon S3 for long-term storage.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation GetConfigurationSetEventDestinations for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetConfigurationSetEventDestinations
func (c *SESV2) GetConfigurationSetEventDestinations(input *GetConfigurationSetEventDestinationsInput) (*GetConfigurationSetEventDestinationsOutput, error) {
	req, out := c.GetConfigurationSetEventDestinationsRequest(input)
	return out, req.Send()
}

// GetConfigurationSetEventDestinationsWithContext is the same as GetConfigurationSetEventDestinations with the addition of
// the ability to pass a context and additional request options.
//
// See GetConfigurationSetEventDestinations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) GetConfigurationSetEventDestinationsWithContext(ctx aws.Context, input *GetConfigurationSetEventDestinationsInput, opts ...request.Option) (*GetConfigurationSetEventDestinationsOutput, error) {
	req, out := c.GetConfigurationSetEventDestinationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCustomVerificationEmailTemplate = "GetCustomVerificationEmailTemplate"

// GetCustomVerificationEmailTemplateRequest generates a "aws/request.Request" representing the
// client's request for the GetCustomVerificationEmailTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCustomVerificationEmailTemplate for more information on using the GetCustomVerificationEmailTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCustomVerificationEmailTemplateRequest method.
//    req, resp := client.GetCustomVerificationEmailTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetCustomVerificationEmailTemplate
func (c *SESV2) GetCustomVerificationEmailTemplateRequest(input *GetCustomVerificationEmailTemplateInput) (req *request.Request, output *GetCustomVerificationEmailTemplateOutput) {
	op := &request.Operation{
		Name:       opGetCustomVerificationEmailTemplate,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/email/custom-verification-email-templates/{TemplateName}",
	}

	if input == nil {
		input = &GetCustomVerificationEmailTemplateInput{}
	}

	output = &GetCustomVerificationEmailTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCustomVerificationEmailTemplate API operation for Amazon Simple Email Service.
//
// Returns the custom email verification template for the template name you
// specify.
//
// For more information about custom verification email templates, see Using
// Custom Verification Email Templates (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html)
// in the Amazon SES Developer Guide.
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation GetCustomVerificationEmailTemplate for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetCustomVerificationEmailTemplate
func (c *SESV2) GetCustomVerificationEmailTemplate(input *GetCustomVerificationEmailTemplateInput) (*GetCustomVerificationEmailTemplateOutput, error) {
	req, out := c.GetCustomVerificationEmailTemplateRequest(input)
	return out, req.Send()
}

// GetCustomVerificationEmailTemplateWithContext is the same as GetCustomVerificationEmailTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See GetCustomVerificationEmailTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) GetCustomVerificationEmailTemplateWithContext(ctx aws.Context, input *GetCustomVerificationEmailTemplateInput, opts ...request.Option) (*GetCustomVerificationEmailTemplateOutput, error) {
	req, out := c.GetCustomVerificationEmailTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDedicatedIp = "GetDedicatedIp"

// GetDedicatedIpRequest generates a "aws/request.Request" representing the
// client's request for the GetDedicatedIp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDedicatedIp for more information on using the GetDedicatedIp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDedicatedIpRequest method.
//    req, resp := client.GetDedicatedIpRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDedicatedIp
func (c *SESV2) GetDedicatedIpRequest(input *GetDedicatedIpInput) (req *request.Request, output *GetDedicatedIpOutput) {
	op := &request.Operation{
		Name:       opGetDedicatedIp,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/email/dedicated-ips/{IP}",
	}

	if input == nil {
		input = &GetDedicatedIpInput{}
	}

	output = &GetDedicatedIpOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDedicatedIp API operation for Amazon Simple Email Service.
//
// Get information about a dedicated IP address, including the name of the dedicated
// IP pool that it's associated with, as well information about the automatic
// warm-up process for the address.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation GetDedicatedIp for usage and error information.
//
// Returned Error Types:
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDedicatedIp
func (c *SESV2) GetDedicatedIp(input *GetDedicatedIpInput) (*GetDedicatedIpOutput, error) {
	req, out := c.GetDedicatedIpRequest(input)
	return out, req.Send()
}

// GetDedicatedIpWithContext is the same as GetDedicatedIp with the addition of
// the ability to pass a context and additional request options.
//
// See GetDedicatedIp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) GetDedicatedIpWithContext(ctx aws.Context, input *GetDedicatedIpInput, opts ...request.Option) (*GetDedicatedIpOutput, error) {
	req, out := c.GetDedicatedIpRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDedicatedIps = "GetDedicatedIps"

// GetDedicatedIpsRequest generates a "aws/request.Request" representing the
// client's request for the GetDedicatedIps operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDedicatedIps for more information on using the GetDedicatedIps
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDedicatedIpsRequest method.
//    req, resp := client.GetDedicatedIpsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDedicatedIps
func (c *SESV2) GetDedicatedIpsRequest(input *GetDedicatedIpsInput) (req *request.Request, output *GetDedicatedIpsOutput) {
	op := &request.Operation{
		Name:       opGetDedicatedIps,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/email/dedicated-ips",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "PageSize",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetDedicatedIpsInput{}
	}

	output = &GetDedicatedIpsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDedicatedIps API operation for Amazon Simple Email Service.
//
// List the dedicated IP addresses that are associated with your AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation GetDedicatedIps for usage and error information.
//
// Returned Error Types:
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDedicatedIps
func (c *SESV2) GetDedicatedIps(input *GetDedicatedIpsInput) (*GetDedicatedIpsOutput, error) {
	req, out := c.GetDedicatedIpsRequest(input)
	return out, req.Send()
}

// GetDedicatedIpsWithContext is the same as GetDedicatedIps with the addition of
// the ability to pass a context and additional request options.
//
// See GetDedicatedIps for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) GetDedicatedIpsWithContext(ctx aws.Context, input *GetDedicatedIpsInput, opts ...request.Option) (*GetDedicatedIpsOutput, error) {
	req, out := c.GetDedicatedIpsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetDedicatedIpsPages iterates over the pages of a GetDedicatedIps operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetDedicatedIps method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetDedicatedIps operation.
//    pageNum := 0
//    err := client.GetDedicatedIpsPages(params,
//        func(page *sesv2.GetDedicatedIpsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SESV2) GetDedicatedIpsPages(input *GetDedicatedIpsInput, fn func(*GetDedicatedIpsOutput, bool) bool) error {
	return c.GetDedicatedIpsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetDedicatedIpsPagesWithContext same as GetDedicatedIpsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) GetDedicatedIpsPagesWithContext(ctx aws.Context, input *GetDedicatedIpsInput, fn func(*GetDedicatedIpsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetDedicatedIpsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetDedicatedIpsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetDedicatedIpsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetDeliverabilityDashboardOptions = "GetDeliverabilityDashboardOptions"

// GetDeliverabilityDashboardOptionsRequest generates a "aws/request.Request" representing the
// client's request for the GetDeliverabilityDashboardOptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDeliverabilityDashboardOptions for more information on using the GetDeliverabilityDashboardOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDeliverabilityDashboardOptionsRequest method.
//    req, resp := client.GetDeliverabilityDashboardOptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDeliverabilityDashboardOptions
func (c *SESV2) GetDeliverabilityDashboardOptionsRequest(input *GetDeliverabilityDashboardOptionsInput) (req *request.Request, output *GetDeliverabilityDashboardOptionsOutput) {
	op := &request.Operation{
		Name:       opGetDeliverabilityDashboardOptions,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/email/deliverability-dashboard",
	}

	if input == nil {
		input = &GetDeliverabilityDashboardOptionsInput{}
	}

	output = &GetDeliverabilityDashboardOptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDeliverabilityDashboardOptions API operation for Amazon Simple Email Service.
//
// Retrieve information about the status of the Deliverability dashboard for
// your account. When the Deliverability dashboard is enabled, you gain access
// to reputation, deliverability, and other metrics for the domains that you
// use to send email. You also gain the ability to perform predictive inbox
// placement tests.
//
// When you use the Deliverability dashboard, you pay a monthly subscription
// charge, in addition to any other fees that you accrue by using Amazon SES
// and other AWS services. For more information about the features and cost
// of a Deliverability dashboard subscription, see Amazon SES Pricing (http://aws.amazon.com/ses/pricing/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation GetDeliverabilityDashboardOptions for usage and error information.
//
// Returned Error Types:
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * LimitExceededException
//   There are too many instances of the specified resource type.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDeliverabilityDashboardOptions
func (c *SESV2) GetDeliverabilityDashboardOptions(input *GetDeliverabilityDashboardOptionsInput) (*GetDeliverabilityDashboardOptionsOutput, error) {
	req, out := c.GetDeliverabilityDashboardOptionsRequest(input)
	return out, req.Send()
}

// GetDeliverabilityDashboardOptionsWithContext is the same as GetDeliverabilityDashboardOptions with the addition of
// the ability to pass a context and additional request options.
//
// See GetDeliverabilityDashboardOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) GetDeliverabilityDashboardOptionsWithContext(ctx aws.Context, input *GetDeliverabilityDashboardOptionsInput, opts ...request.Option) (*GetDeliverabilityDashboardOptionsOutput, error) {
	req, out := c.GetDeliverabilityDashboardOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDeliverabilityTestReport = "GetDeliverabilityTestReport"

// GetDeliverabilityTestReportRequest generates a "aws/request.Request" representing the
// client's request for the GetDeliverabilityTestReport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDeliverabilityTestReport for more information on using the GetDeliverabilityTestReport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDeliverabilityTestReportRequest method.
//    req, resp := client.GetDeliverabilityTestReportRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDeliverabilityTestReport
func (c *SESV2) GetDeliverabilityTestReportRequest(input *GetDeliverabilityTestReportInput) (req *request.Request, output *GetDeliverabilityTestReportOutput) {
	op := &request.Operation{
		Name:       opGetDeliverabilityTestReport,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/email/deliverability-dashboard/test-reports/{ReportId}",
	}

	if input == nil {
		input = &GetDeliverabilityTestReportInput{}
	}

	output = &GetDeliverabilityTestReportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDeliverabilityTestReport API operation for Amazon Simple Email Service.
//
// Retrieve the results of a predictive inbox placement test.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation GetDeliverabilityTestReport for usage and error information.
//
// Returned Error Types:
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDeliverabilityTestReport
func (c *SESV2) GetDeliverabilityTestReport(input *GetDeliverabilityTestReportInput) (*GetDeliverabilityTestReportOutput, error) {
	req, out := c.GetDeliverabilityTestReportRequest(input)
	return out, req.Send()
}

// GetDeliverabilityTestReportWithContext is the same as GetDeliverabilityTestReport with the addition of
// the ability to pass a context and additional request options.
//
// See GetDeliverabilityTestReport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) GetDeliverabilityTestReportWithContext(ctx aws.Context, input *GetDeliverabilityTestReportInput, opts ...request.Option) (*GetDeliverabilityTestReportOutput, error) {
	req, out := c.GetDeliverabilityTestReportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDomainDeliverabilityCampaign = "GetDomainDeliverabilityCampaign"

// GetDomainDeliverabilityCampaignRequest generates a "aws/request.Request" representing the
// client's request for the GetDomainDeliverabilityCampaign operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDomainDeliverabilityCampaign for more information on using the GetDomainDeliverabilityCampaign
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDomainDeliverabilityCampaignRequest method.
//    req, resp := client.GetDomainDeliverabilityCampaignRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDomainDeliverabilityCampaign
func (c *SESV2) GetDomainDeliverabilityCampaignRequest(input *GetDomainDeliverabilityCampaignInput) (req *request.Request, output *GetDomainDeliverabilityCampaignOutput) {
	op := &request.Operation{
		Name:       opGetDomainDeliverabilityCampaign,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/email/deliverability-dashboard/campaigns/{CampaignId}",
	}

	if input == nil {
		input = &GetDomainDeliverabilityCampaignInput{}
	}

	output = &GetDomainDeliverabilityCampaignOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDomainDeliverabilityCampaign API operation for Amazon Simple Email Service.
//
// Retrieve all the deliverability data for a specific campaign. This data is
// available for a campaign only if the campaign sent email by using a domain
// that the Deliverability dashboard is enabled for.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation GetDomainDeliverabilityCampaign for usage and error information.
//
// Returned Error Types:
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDomainDeliverabilityCampaign
func (c *SESV2) GetDomainDeliverabilityCampaign(input *GetDomainDeliverabilityCampaignInput) (*GetDomainDeliverabilityCampaignOutput, error) {
	req, out := c.GetDomainDeliverabilityCampaignRequest(input)
	return out, req.Send()
}

// GetDomainDeliverabilityCampaignWithContext is the same as GetDomainDeliverabilityCampaign with the addition of
// the ability to pass a context and additional request options.
//
// See GetDomainDeliverabilityCampaign for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) GetDomainDeliverabilityCampaignWithContext(ctx aws.Context, input *GetDomainDeliverabilityCampaignInput, opts ...request.Option) (*GetDomainDeliverabilityCampaignOutput, error) {
	req, out := c.GetDomainDeliverabilityCampaignRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDomainStatisticsReport = "GetDomainStatisticsReport"

// GetDomainStatisticsReportRequest generates a "aws/request.Request" representing the
// client's request for the GetDomainStatisticsReport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDomainStatisticsReport for more information on using the GetDomainStatisticsReport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDomainStatisticsReportRequest method.
//    req, resp := client.GetDomainStatisticsReportRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDomainStatisticsReport
func (c *SESV2) GetDomainStatisticsReportRequest(input *GetDomainStatisticsReportInput) (req *request.Request, output *GetDomainStatisticsReportOutput) {
	op := &request.Operation{
		Name:       opGetDomainStatisticsReport,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/email/deliverability-dashboard/statistics-report/{Domain}",
	}

	if input == nil {
		input = &GetDomainStatisticsReportInput{}
	}

	output = &GetDomainStatisticsReportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDomainStatisticsReport API operation for Amazon Simple Email Service.
//
// Retrieve inbox placement and engagement rates for the domains that you use
// to send email.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation GetDomainStatisticsReport for usage and error information.
//
// Returned Error Types:
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDomainStatisticsReport
func (c *SESV2) GetDomainStatisticsReport(input *GetDomainStatisticsReportInput) (*GetDomainStatisticsReportOutput, error) {
	req, out := c.GetDomainStatisticsReportRequest(input)
	return out, req.Send()
}

// GetDomainStatisticsReportWithContext is the same as GetDomainStatisticsReport with the addition of
// the ability to pass a context and additional request options.
//
// See GetDomainStatisticsReport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) GetDomainStatisticsReportWithContext(ctx aws.Context, input *GetDomainStatisticsReportInput, opts ...request.Option) (*GetDomainStatisticsReportOutput, error) {
	req, out := c.GetDomainStatisticsReportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEmailIdentity = "GetEmailIdentity"

// GetEmailIdentityRequest generates a "aws/request.Request" representing the
// client's request for the GetEmailIdentity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEmailIdentity for more information on using the GetEmailIdentity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetEmailIdentityRequest method.
//    req, resp := client.GetEmailIdentityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetEmailIdentity
func (c *SESV2) GetEmailIdentityRequest(input *GetEmailIdentityInput) (req *request.Request, output *GetEmailIdentityOutput) {
	op := &request.Operation{
		Name:       opGetEmailIdentity,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/email/identities/{EmailIdentity}",
	}

	if input == nil {
		input = &GetEmailIdentityInput{}
	}

	output = &GetEmailIdentityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEmailIdentity API operation for Amazon Simple Email Service.
//
// Provides information about a specific identity, including the identity's
// verification status, sending authorization policies, its DKIM authentication
// status, and its custom Mail-From settings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation GetEmailIdentity for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetEmailIdentity
func (c *SESV2) GetEmailIdentity(input *GetEmailIdentityInput) (*GetEmailIdentityOutput, error) {
	req, out := c.GetEmailIdentityRequest(input)
	return out, req.Send()
}

// GetEmailIdentityWithContext is the same as GetEmailIdentity with the addition of
// the ability to pass a context and additional request options.
//
// See GetEmailIdentity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) GetEmailIdentityWithContext(ctx aws.Context, input *GetEmailIdentityInput, opts ...request.Option) (*GetEmailIdentityOutput, error) {
	req, out := c.GetEmailIdentityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEmailIdentityPolicies = "GetEmailIdentityPolicies"

// GetEmailIdentityPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the GetEmailIdentityPolicies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEmailIdentityPolicies for more information on using the GetEmailIdentityPolicies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetEmailIdentityPoliciesRequest method.
//    req, resp := client.GetEmailIdentityPoliciesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetEmailIdentityPolicies
func (c *SESV2) GetEmailIdentityPoliciesRequest(input *GetEmailIdentityPoliciesInput) (req *request.Request, output *GetEmailIdentityPoliciesOutput) {
	op := &request.Operation{
		Name:       opGetEmailIdentityPolicies,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/email/identities/{EmailIdentity}/policies",
	}

	if input == nil {
		input = &GetEmailIdentityPoliciesInput{}
	}

	output = &GetEmailIdentityPoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEmailIdentityPolicies API operation for Amazon Simple Email Service.
//
// Returns the requested sending authorization policies for the given identity
// (an email address or a domain). The policies are returned as a map of policy
// names to policy contents. You can retrieve a maximum of 20 policies at a
// time.
//
// This API is for the identity owner only. If you have not verified the identity,
// this API will return an error.
//
// Sending authorization is a feature that enables an identity owner to authorize
// other senders to use its identities. For information about using sending
// authorization, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation GetEmailIdentityPolicies for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetEmailIdentityPolicies
func (c *SESV2) GetEmailIdentityPolicies(input *GetEmailIdentityPoliciesInput) (*GetEmailIdentityPoliciesOutput, error) {
	req, out := c.GetEmailIdentityPoliciesRequest(input)
	return out, req.Send()
}

// GetEmailIdentityPoliciesWithContext is the same as GetEmailIdentityPolicies with the addition of
// the ability to pass a context and additional request options.
//
// See GetEmailIdentityPolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) GetEmailIdentityPoliciesWithContext(ctx aws.Context, input *GetEmailIdentityPoliciesInput, opts ...request.Option) (*GetEmailIdentityPoliciesOutput, error) {
	req, out := c.GetEmailIdentityPoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEmailTemplate = "GetEmailTemplate"

// GetEmailTemplateRequest generates a "aws/request.Request" representing the
// client's request for the GetEmailTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEmailTemplate for more information on using the GetEmailTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetEmailTemplateRequest method.
//    req, resp := client.GetEmailTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetEmailTemplate
func (c *SESV2) GetEmailTemplateRequest(input *GetEmailTemplateInput) (req *request.Request, output *GetEmailTemplateOutput) {
	op := &request.Operation{
		Name:       opGetEmailTemplate,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/email/templates/{TemplateName}",
	}

	if input == nil {
		input = &GetEmailTemplateInput{}
	}

	output = &GetEmailTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEmailTemplate API operation for Amazon Simple Email Service.
//
// Displays the template object (which includes the subject line, HTML part
// and text part) for the template you specify.
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation GetEmailTemplate for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetEmailTemplate
func (c *SESV2) GetEmailTemplate(input *GetEmailTemplateInput) (*GetEmailTemplateOutput, error) {
	req, out := c.GetEmailTemplateRequest(input)
	return out, req.Send()
}

// GetEmailTemplateWithContext is the same as GetEmailTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See GetEmailTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) GetEmailTemplateWithContext(ctx aws.Context, input *GetEmailTemplateInput, opts ...request.Option) (*GetEmailTemplateOutput, error) {
	req, out := c.GetEmailTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetImportJob = "GetImportJob"

// GetImportJobRequest generates a "aws/request.Request" representing the
// client's request for the GetImportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetImportJob for more information on using the GetImportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetImportJobRequest method.
//    req, resp := client.GetImportJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetImportJob
func (c *SESV2) GetImportJobRequest(input *GetImportJobInput) (req *request.Request, output *GetImportJobOutput) {
	op := &request.Operation{
		Name:       opGetImportJob,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/email/import-jobs/{JobId}",
	}

	if input == nil {
		input = &GetImportJobInput{}
	}

	output = &GetImportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetImportJob API operation for Amazon Simple Email Service.
//
// Provides information about an import job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation GetImportJob for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input you provided is invalid.
//
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetImportJob
func (c *SESV2) GetImportJob(input *GetImportJobInput) (*GetImportJobOutput, error) {
	req, out := c.GetImportJobRequest(input)
	return out, req.Send()
}

// GetImportJobWithContext is the same as GetImportJob with the addition of
// the ability to pass a context and additional request options.
//
// See GetImportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) GetImportJobWithContext(ctx aws.Context, input *GetImportJobInput, opts ...request.Option) (*GetImportJobOutput, error) {
	req, out := c.GetImportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSuppressedDestination = "GetSuppressedDestination"

// GetSuppressedDestinationRequest generates a "aws/request.Request" representing the
// client's request for the GetSuppressedDestination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSuppressedDestination for more information on using the GetSuppressedDestination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSuppressedDestinationRequest method.
//    req, resp := client.GetSuppressedDestinationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetSuppressedDestination
func (c *SESV2) GetSuppressedDestinationRequest(input *GetSuppressedDestinationInput) (req *request.Request, output *GetSuppressedDestinationOutput) {
	op := &request.Operation{
		Name:       opGetSuppressedDestination,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/email/suppression/addresses/{EmailAddress}",
	}

	if input == nil {
		input = &GetSuppressedDestinationInput{}
	}

	output = &GetSuppressedDestinationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSuppressedDestination API operation for Amazon Simple Email Service.
//
// Retrieves information about a specific email address that's on the suppression
// list for your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation GetSuppressedDestination for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input you provided is invalid.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetSuppressedDestination
func (c *SESV2) GetSuppressedDestination(input *GetSuppressedDestinationInput) (*GetSuppressedDestinationOutput, error) {
	req, out := c.GetSuppressedDestinationRequest(input)
	return out, req.Send()
}

// GetSuppressedDestinationWithContext is the same as GetSuppressedDestination with the addition of
// the ability to pass a context and additional request options.
//
// See GetSuppressedDestination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) GetSuppressedDestinationWithContext(ctx aws.Context, input *GetSuppressedDestinationInput, opts ...request.Option) (*GetSuppressedDestinationOutput, error) {
	req, out := c.GetSuppressedDestinationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListConfigurationSets = "ListConfigurationSets"

// ListConfigurationSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListConfigurationSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListConfigurationSets for more information on using the ListConfigurationSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListConfigurationSetsRequest method.
//    req, resp := client.ListConfigurationSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListConfigurationSets
func (c *SESV2) ListConfigurationSetsRequest(input *ListConfigurationSetsInput) (req *request.Request, output *ListConfigurationSetsOutput) {
	op := &request.Operation{
		Name:       opListConfigurationSets,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/email/configuration-sets",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "PageSize",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListConfigurationSetsInput{}
	}

	output = &ListConfigurationSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListConfigurationSets API operation for Amazon Simple Email Service.
//
// List all of the configuration sets associated with your account in the current
// region.
//
// Configuration sets are groups of rules that you can apply to the emails you
// send. You apply a configuration set to an email by including a reference
// to the configuration set in the headers of the email. When you apply a configuration
// set to an email, all of the rules in that configuration set are applied to
// the email.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation ListConfigurationSets for usage and error information.
//
// Returned Error Types:
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListConfigurationSets
func (c *SESV2) ListConfigurationSets(input *ListConfigurationSetsInput) (*ListConfigurationSetsOutput, error) {
	req, out := c.ListConfigurationSetsRequest(input)
	return out, req.Send()
}

// ListConfigurationSetsWithContext is the same as ListConfigurationSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListConfigurationSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) ListConfigurationSetsWithContext(ctx aws.Context, input *ListConfigurationSetsInput, opts ...request.Option) (*ListConfigurationSetsOutput, error) {
	req, out := c.ListConfigurationSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListConfigurationSetsPages iterates over the pages of a ListConfigurationSets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListConfigurationSets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListConfigurationSets operation.
//    pageNum := 0
//    err := client.ListConfigurationSetsPages(params,
//        func(page *sesv2.ListConfigurationSetsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SESV2) ListConfigurationSetsPages(input *ListConfigurationSetsInput, fn func(*ListConfigurationSetsOutput, bool) bool) error {
	return c.ListConfigurationSetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListConfigurationSetsPagesWithContext same as ListConfigurationSetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) ListConfigurationSetsPagesWithContext(ctx aws.Context, input *ListConfigurationSetsInput, fn func(*ListConfigurationSetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListConfigurationSetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListConfigurationSetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListConfigurationSetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCustomVerificationEmailTemplates = "ListCustomVerificationEmailTemplates"

// ListCustomVerificationEmailTemplatesRequest generates a "aws/request.Request" representing the
// client's request for the ListCustomVerificationEmailTemplates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCustomVerificationEmailTemplates for more information on using the ListCustomVerificationEmailTemplates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListCustomVerificationEmailTemplatesRequest method.
//    req, resp := client.ListCustomVerificationEmailTemplatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListCustomVerificationEmailTemplates
func (c *SESV2) ListCustomVerificationEmailTemplatesRequest(input *ListCustomVerificationEmailTemplatesInput) (req *request.Request, output *ListCustomVerificationEmailTemplatesOutput) {
	op := &request.Operation{
		Name:       opListCustomVerificationEmailTemplates,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/email/custom-verification-email-templates",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "PageSize",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCustomVerificationEmailTemplatesInput{}
	}

	output = &ListCustomVerificationEmailTemplatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCustomVerificationEmailTemplates API operation for Amazon Simple Email Service.
//
// Lists the existing custom verification email templates for your account in
// the current AWS Region.
//
// For more information about custom verification email templates, see Using
// Custom Verification Email Templates (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html)
// in the Amazon SES Developer Guide.
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation ListCustomVerificationEmailTemplates for usage and error information.
//
// Returned Error Types:
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListCustomVerificationEmailTemplates
func (c *SESV2) ListCustomVerificationEmailTemplates(input *ListCustomVerificationEmailTemplatesInput) (*ListCustomVerificationEmailTemplatesOutput, error) {
	req, out := c.ListCustomVerificationEmailTemplatesRequest(input)
	return out, req.Send()
}

// ListCustomVerificationEmailTemplatesWithContext is the same as ListCustomVerificationEmailTemplates with the addition of
// the ability to pass a context and additional request options.
//
// See ListCustomVerificationEmailTemplates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) ListCustomVerificationEmailTemplatesWithContext(ctx aws.Context, input *ListCustomVerificationEmailTemplatesInput, opts ...request.Option) (*ListCustomVerificationEmailTemplatesOutput, error) {
	req, out := c.ListCustomVerificationEmailTemplatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCustomVerificationEmailTemplatesPages iterates over the pages of a ListCustomVerificationEmailTemplates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCustomVerificationEmailTemplates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListCustomVerificationEmailTemplates operation.
//    pageNum := 0
//    err := client.ListCustomVerificationEmailTemplatesPages(params,
//        func(page *sesv2.ListCustomVerificationEmailTemplatesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SESV2) ListCustomVerificationEmailTemplatesPages(input *ListCustomVerificationEmailTemplatesInput, fn func(*ListCustomVerificationEmailTemplatesOutput, bool) bool) error {
	return c.ListCustomVerificationEmailTemplatesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCustomVerificationEmailTemplatesPagesWithContext same as ListCustomVerificationEmailTemplatesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) ListCustomVerificationEmailTemplatesPagesWithContext(ctx aws.Context, input *ListCustomVerificationEmailTemplatesInput, fn func(*ListCustomVerificationEmailTemplatesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCustomVerificationEmailTemplatesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCustomVerificationEmailTemplatesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCustomVerificationEmailTemplatesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDedicatedIpPools = "ListDedicatedIpPools"

// ListDedicatedIpPoolsRequest generates a "aws/request.Request" representing the
// client's request for the ListDedicatedIpPools operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDedicatedIpPools for more information on using the ListDedicatedIpPools
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDedicatedIpPoolsRequest method.
//    req, resp := client.ListDedicatedIpPoolsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListDedicatedIpPools
func (c *SESV2) ListDedicatedIpPoolsRequest(input *ListDedicatedIpPoolsInput) (req *request.Request, output *ListDedicatedIpPoolsOutput) {
	op := &request.Operation{
		Name:       opListDedicatedIpPools,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/email/dedicated-ip-pools",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "PageSize",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDedicatedIpPoolsInput{}
	}

	output = &ListDedicatedIpPoolsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDedicatedIpPools API operation for Amazon Simple Email Service.
//
// List all of the dedicated IP pools that exist in your AWS account in the
// current Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation ListDedicatedIpPools for usage and error information.
//
// Returned Error Types:
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListDedicatedIpPools
func (c *SESV2) ListDedicatedIpPools(input *ListDedicatedIpPoolsInput) (*ListDedicatedIpPoolsOutput, error) {
	req, out := c.ListDedicatedIpPoolsRequest(input)
	return out, req.Send()
}

// ListDedicatedIpPoolsWithContext is the same as ListDedicatedIpPools with the addition of
// the ability to pass a context and additional request options.
//
// See ListDedicatedIpPools for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) ListDedicatedIpPoolsWithContext(ctx aws.Context, input *ListDedicatedIpPoolsInput, opts ...request.Option) (*ListDedicatedIpPoolsOutput, error) {
	req, out := c.ListDedicatedIpPoolsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDedicatedIpPoolsPages iterates over the pages of a ListDedicatedIpPools operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDedicatedIpPools method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDedicatedIpPools operation.
//    pageNum := 0
//    err := client.ListDedicatedIpPoolsPages(params,
//        func(page *sesv2.ListDedicatedIpPoolsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SESV2) ListDedicatedIpPoolsPages(input *ListDedicatedIpPoolsInput, fn func(*ListDedicatedIpPoolsOutput, bool) bool) error {
	return c.ListDedicatedIpPoolsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDedicatedIpPoolsPagesWithContext same as ListDedicatedIpPoolsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) ListDedicatedIpPoolsPagesWithContext(ctx aws.Context, input *ListDedicatedIpPoolsInput, fn func(*ListDedicatedIpPoolsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDedicatedIpPoolsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDedicatedIpPoolsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDedicatedIpPoolsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDeliverabilityTestReports = "ListDeliverabilityTestReports"

// ListDeliverabilityTestReportsRequest generates a "aws/request.Request" representing the
// client's request for the ListDeliverabilityTestReports operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDeliverabilityTestReports for more information on using the ListDeliverabilityTestReports
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDeliverabilityTestReportsRequest method.
//    req, resp := client.ListDeliverabilityTestReportsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListDeliverabilityTestReports
func (c *SESV2) ListDeliverabilityTestReportsRequest(input *ListDeliverabilityTestReportsInput) (req *request.Request, output *ListDeliverabilityTestReportsOutput) {
	op := &request.Operation{
		Name:       opListDeliverabilityTestReports,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/email/deliverability-dashboard/test-reports",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "PageSize",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDeliverabilityTestReportsInput{}
	}

	output = &ListDeliverabilityTestReportsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDeliverabilityTestReports API operation for Amazon Simple Email Service.
//
// Show a list of the predictive inbox placement tests that you've performed,
// regardless of their statuses. For predictive inbox placement tests that are
// complete, you can use the GetDeliverabilityTestReport operation to view the
// results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation ListDeliverabilityTestReports for usage and error information.
//
// Returned Error Types:
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListDeliverabilityTestReports
func (c *SESV2) ListDeliverabilityTestReports(input *ListDeliverabilityTestReportsInput) (*ListDeliverabilityTestReportsOutput, error) {
	req, out := c.ListDeliverabilityTestReportsRequest(input)
	return out, req.Send()
}

// ListDeliverabilityTestReportsWithContext is the same as ListDeliverabilityTestReports with the addition of
// the ability to pass a context and additional request options.
//
// See ListDeliverabilityTestReports for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) ListDeliverabilityTestReportsWithContext(ctx aws.Context, input *ListDeliverabilityTestReportsInput, opts ...request.Option) (*ListDeliverabilityTestReportsOutput, error) {
	req, out := c.ListDeliverabilityTestReportsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDeliverabilityTestReportsPages iterates over the pages of a ListDeliverabilityTestReports operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDeliverabilityTestReports method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDeliverabilityTestReports operation.
//    pageNum := 0
//    err := client.ListDeliverabilityTestReportsPages(params,
//        func(page *sesv2.ListDeliverabilityTestReportsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SESV2) ListDeliverabilityTestReportsPages(input *ListDeliverabilityTestReportsInput, fn func(*ListDeliverabilityTestReportsOutput, bool) bool) error {
	return c.ListDeliverabilityTestReportsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDeliverabilityTestReportsPagesWithContext same as ListDeliverabilityTestReportsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) ListDeliverabilityTestReportsPagesWithContext(ctx aws.Context, input *ListDeliverabilityTestReportsInput, fn func(*ListDeliverabilityTestReportsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDeliverabilityTestReportsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDeliverabilityTestReportsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDeliverabilityTestReportsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDomainDeliverabilityCampaigns = "ListDomainDeliverabilityCampaigns"

// ListDomainDeliverabilityCampaignsRequest generates a "aws/request.Request" representing the
// client's request for the ListDomainDeliverabilityCampaigns operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDomainDeliverabilityCampaigns for more information on using the ListDomainDeliverabilityCampaigns
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDomainDeliverabilityCampaignsRequest method.
//    req, resp := client.ListDomainDeliverabilityCampaignsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListDomainDeliverabilityCampaigns
func (c *SESV2) ListDomainDeliverabilityCampaignsRequest(input *ListDomainDeliverabilityCampaignsInput) (req *request.Request, output *ListDomainDeliverabilityCampaignsOutput) {
	op := &request.Operation{
		Name:       opListDomainDeliverabilityCampaigns,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/email/deliverability-dashboard/domains/{SubscribedDomain}/campaigns",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "PageSize",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDomainDeliverabilityCampaignsInput{}
	}

	output = &ListDomainDeliverabilityCampaignsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDomainDeliverabilityCampaigns API operation for Amazon Simple Email Service.
//
// Retrieve deliverability data for all the campaigns that used a specific domain
// to send email during a specified time range. This data is available for a
// domain only if you enabled the Deliverability dashboard for the domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation ListDomainDeliverabilityCampaigns for usage and error information.
//
// Returned Error Types:
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListDomainDeliverabilityCampaigns
func (c *SESV2) ListDomainDeliverabilityCampaigns(input *ListDomainDeliverabilityCampaignsInput) (*ListDomainDeliverabilityCampaignsOutput, error) {
	req, out := c.ListDomainDeliverabilityCampaignsRequest(input)
	return out, req.Send()
}

// ListDomainDeliverabilityCampaignsWithContext is the same as ListDomainDeliverabilityCampaigns with the addition of
// the ability to pass a context and additional request options.
//
// See ListDomainDeliverabilityCampaigns for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) ListDomainDeliverabilityCampaignsWithContext(ctx aws.Context, input *ListDomainDeliverabilityCampaignsInput, opts ...request.Option) (*ListDomainDeliverabilityCampaignsOutput, error) {
	req, out := c.ListDomainDeliverabilityCampaignsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDomainDeliverabilityCampaignsPages iterates over the pages of a ListDomainDeliverabilityCampaigns operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDomainDeliverabilityCampaigns method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDomainDeliverabilityCampaigns operation.
//    pageNum := 0
//    err := client.ListDomainDeliverabilityCampaignsPages(params,
//        func(page *sesv2.ListDomainDeliverabilityCampaignsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SESV2) ListDomainDeliverabilityCampaignsPages(input *ListDomainDeliverabilityCampaignsInput, fn func(*ListDomainDeliverabilityCampaignsOutput, bool) bool) error {
	return c.ListDomainDeliverabilityCampaignsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDomainDeliverabilityCampaignsPagesWithContext same as ListDomainDeliverabilityCampaignsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) ListDomainDeliverabilityCampaignsPagesWithContext(ctx aws.Context, input *ListDomainDeliverabilityCampaignsInput, fn func(*ListDomainDeliverabilityCampaignsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDomainDeliverabilityCampaignsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDomainDeliverabilityCampaignsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDomainDeliverabilityCampaignsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEmailIdentities = "ListEmailIdentities"

// ListEmailIdentitiesRequest generates a "aws/request.Request" representing the
// client's request for the ListEmailIdentities operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEmailIdentities for more information on using the ListEmailIdentities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListEmailIdentitiesRequest method.
//    req, resp := client.ListEmailIdentitiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListEmailIdentities
func (c *SESV2) ListEmailIdentitiesRequest(input *ListEmailIdentitiesInput) (req *request.Request, output *ListEmailIdentitiesOutput) {
	op := &request.Operation{
		Name:       opListEmailIdentities,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/email/identities",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "PageSize",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEmailIdentitiesInput{}
	}

	output = &ListEmailIdentitiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEmailIdentities API operation for Amazon Simple Email Service.
//
// Returns a list of all of the email identities that are associated with your
// AWS account. An identity can be either an email address or a domain. This
// operation returns identities that are verified as well as those that aren't.
// This operation returns identities that are associated with Amazon SES and
// Amazon Pinpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation ListEmailIdentities for usage and error information.
//
// Returned Error Types:
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListEmailIdentities
func (c *SESV2) ListEmailIdentities(input *ListEmailIdentitiesInput) (*ListEmailIdentitiesOutput, error) {
	req, out := c.ListEmailIdentitiesRequest(input)
	return out, req.Send()
}

// ListEmailIdentitiesWithContext is the same as ListEmailIdentities with the addition of
// the ability to pass a context and additional request options.
//
// See ListEmailIdentities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) ListEmailIdentitiesWithContext(ctx aws.Context, input *ListEmailIdentitiesInput, opts ...request.Option) (*ListEmailIdentitiesOutput, error) {
	req, out := c.ListEmailIdentitiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEmailIdentitiesPages iterates over the pages of a ListEmailIdentities operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEmailIdentities method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListEmailIdentities operation.
//    pageNum := 0
//    err := client.ListEmailIdentitiesPages(params,
//        func(page *sesv2.ListEmailIdentitiesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SESV2) ListEmailIdentitiesPages(input *ListEmailIdentitiesInput, fn func(*ListEmailIdentitiesOutput, bool) bool) error {
	return c.ListEmailIdentitiesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEmailIdentitiesPagesWithContext same as ListEmailIdentitiesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) ListEmailIdentitiesPagesWithContext(ctx aws.Context, input *ListEmailIdentitiesInput, fn func(*ListEmailIdentitiesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEmailIdentitiesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEmailIdentitiesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEmailIdentitiesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEmailTemplates = "ListEmailTemplates"

// ListEmailTemplatesRequest generates a "aws/request.Request" representing the
// client's request for the ListEmailTemplates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEmailTemplates for more information on using the ListEmailTemplates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListEmailTemplatesRequest method.
//    req, resp := client.ListEmailTemplatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListEmailTemplates
func (c *SESV2) ListEmailTemplatesRequest(input *ListEmailTemplatesInput) (req *request.Request, output *ListEmailTemplatesOutput) {
	op := &request.Operation{
		Name:       opListEmailTemplates,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/email/templates",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "PageSize",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEmailTemplatesInput{}
	}

	output = &ListEmailTemplatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEmailTemplates API operation for Amazon Simple Email Service.
//
// Lists the email templates present in your Amazon SES account in the current
// AWS Region.
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation ListEmailTemplates for usage and error information.
//
// Returned Error Types:
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListEmailTemplates
func (c *SESV2) ListEmailTemplates(input *ListEmailTemplatesInput) (*ListEmailTemplatesOutput, error) {
	req, out := c.ListEmailTemplatesRequest(input)
	return out, req.Send()
}

// ListEmailTemplatesWithContext is the same as ListEmailTemplates with the addition of
// the ability to pass a context and additional request options.
//
// See ListEmailTemplates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) ListEmailTemplatesWithContext(ctx aws.Context, input *ListEmailTemplatesInput, opts ...request.Option) (*ListEmailTemplatesOutput, error) {
	req, out := c.ListEmailTemplatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEmailTemplatesPages iterates over the pages of a ListEmailTemplates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEmailTemplates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListEmailTemplates operation.
//    pageNum := 0
//    err := client.ListEmailTemplatesPages(params,
//        func(page *sesv2.ListEmailTemplatesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SESV2) ListEmailTemplatesPages(input *ListEmailTemplatesInput, fn func(*ListEmailTemplatesOutput, bool) bool) error {
	return c.ListEmailTemplatesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEmailTemplatesPagesWithContext same as ListEmailTemplatesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) ListEmailTemplatesPagesWithContext(ctx aws.Context, input *ListEmailTemplatesInput, fn func(*ListEmailTemplatesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEmailTemplatesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEmailTemplatesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEmailTemplatesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListImportJobs = "ListImportJobs"

// ListImportJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListImportJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListImportJobs for more information on using the ListImportJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListImportJobsRequest method.
//    req, resp := client.ListImportJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListImportJobs
func (c *SESV2) ListImportJobsRequest(input *ListImportJobsInput) (req *request.Request, output *ListImportJobsOutput) {
	op := &request.Operation{
		Name:       opListImportJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/email/import-jobs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "PageSize",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListImportJobsInput{}
	}

	output = &ListImportJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListImportJobs API operation for Amazon Simple Email Service.
//
// Lists all of the import jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation ListImportJobs for usage and error information.
//
// Returned Error Types:
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListImportJobs
func (c *SESV2) ListImportJobs(input *ListImportJobsInput) (*ListImportJobsOutput, error) {
	req, out := c.ListImportJobsRequest(input)
	return out, req.Send()
}

// ListImportJobsWithContext is the same as ListImportJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListImportJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) ListImportJobsWithContext(ctx aws.Context, input *ListImportJobsInput, opts ...request.Option) (*ListImportJobsOutput, error) {
	req, out := c.ListImportJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListImportJobsPages iterates over the pages of a ListImportJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListImportJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListImportJobs operation.
//    pageNum := 0
//    err := client.ListImportJobsPages(params,
//        func(page *sesv2.ListImportJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SESV2) ListImportJobsPages(input *ListImportJobsInput, fn func(*ListImportJobsOutput, bool) bool) error {
	return c.ListImportJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListImportJobsPagesWithContext same as ListImportJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) ListImportJobsPagesWithContext(ctx aws.Context, input *ListImportJobsInput, fn func(*ListImportJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListImportJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListImportJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListImportJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSuppressedDestinations = "ListSuppressedDestinations"

// ListSuppressedDestinationsRequest generates a "aws/request.Request" representing the
// client's request for the ListSuppressedDestinations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSuppressedDestinations for more information on using the ListSuppressedDestinations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSuppressedDestinationsRequest method.
//    req, resp := client.ListSuppressedDestinationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListSuppressedDestinations
func (c *SESV2) ListSuppressedDestinationsRequest(input *ListSuppressedDestinationsInput) (req *request.Request, output *ListSuppressedDestinationsOutput) {
	op := &request.Operation{
		Name:       opListSuppressedDestinations,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/email/suppression/addresses",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "PageSize",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSuppressedDestinationsInput{}
	}

	output = &ListSuppressedDestinationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSuppressedDestinations API operation for Amazon Simple Email Service.
//
// Retrieves a list of email addresses that are on the suppression list for
// your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation ListSuppressedDestinations for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input you provided is invalid.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * InvalidNextTokenException
//   The specified request includes an invalid or expired token.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListSuppressedDestinations
func (c *SESV2) ListSuppressedDestinations(input *ListSuppressedDestinationsInput) (*ListSuppressedDestinationsOutput, error) {
	req, out := c.ListSuppressedDestinationsRequest(input)
	return out, req.Send()
}

// ListSuppressedDestinationsWithContext is the same as ListSuppressedDestinations with the addition of
// the ability to pass a context and additional request options.
//
// See ListSuppressedDestinations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) ListSuppressedDestinationsWithContext(ctx aws.Context, input *ListSuppressedDestinationsInput, opts ...request.Option) (*ListSuppressedDestinationsOutput, error) {
	req, out := c.ListSuppressedDestinationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSuppressedDestinationsPages iterates over the pages of a ListSuppressedDestinations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSuppressedDestinations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListSuppressedDestinations operation.
//    pageNum := 0
//    err := client.ListSuppressedDestinationsPages(params,
//        func(page *sesv2.ListSuppressedDestinationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SESV2) ListSuppressedDestinationsPages(input *ListSuppressedDestinationsInput, fn func(*ListSuppressedDestinationsOutput, bool) bool) error {
	return c.ListSuppressedDestinationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSuppressedDestinationsPagesWithContext same as ListSuppressedDestinationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) ListSuppressedDestinationsPagesWithContext(ctx aws.Context, input *ListSuppressedDestinationsInput, fn func(*ListSuppressedDestinationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSuppressedDestinationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSuppressedDestinationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSuppressedDestinationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListTagsForResource
func (c *SESV2) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/email/tags",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Simple Email Service.
//
// Retrieve a list of the tags (keys and values) that are associated with a
// specified resource. A tag is a label that you optionally define and associate
// with a resource. Each tag consists of a required tag key and an optional
// associated tag value. A tag key is a general label that acts as a category
// for more specific tag values. A tag value acts as a descriptor within a tag
// key.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input you provided is invalid.
//
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListTagsForResource
func (c *SESV2) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutAccountDedicatedIpWarmupAttributes = "PutAccountDedicatedIpWarmupAttributes"

// PutAccountDedicatedIpWarmupAttributesRequest generates a "aws/request.Request" representing the
// client's request for the PutAccountDedicatedIpWarmupAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutAccountDedicatedIpWarmupAttributes for more information on using the PutAccountDedicatedIpWarmupAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutAccountDedicatedIpWarmupAttributesRequest method.
//    req, resp := client.PutAccountDedicatedIpWarmupAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutAccountDedicatedIpWarmupAttributes
func (c *SESV2) PutAccountDedicatedIpWarmupAttributesRequest(input *PutAccountDedicatedIpWarmupAttributesInput) (req *request.Request, output *PutAccountDedicatedIpWarmupAttributesOutput) {
	op := &request.Operation{
		Name:       opPutAccountDedicatedIpWarmupAttributes,
		HTTPMethod: "PUT",
		HTTPPath:   "/v2/email/account/dedicated-ips/warmup",
	}

	if input == nil {
		input = &PutAccountDedicatedIpWarmupAttributesInput{}
	}

	output = &PutAccountDedicatedIpWarmupAttributesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutAccountDedicatedIpWarmupAttributes API operation for Amazon Simple Email Service.
//
// Enable or disable the automatic warm-up feature for dedicated IP addresses.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation PutAccountDedicatedIpWarmupAttributes for usage and error information.
//
// Returned Error Types:
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutAccountDedicatedIpWarmupAttributes
func (c *SESV2) PutAccountDedicatedIpWarmupAttributes(input *PutAccountDedicatedIpWarmupAttributesInput) (*PutAccountDedicatedIpWarmupAttributesOutput, error) {
	req, out := c.PutAccountDedicatedIpWarmupAttributesRequest(input)
	return out, req.Send()
}

// PutAccountDedicatedIpWarmupAttributesWithContext is the same as PutAccountDedicatedIpWarmupAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See PutAccountDedicatedIpWarmupAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) PutAccountDedicatedIpWarmupAttributesWithContext(ctx aws.Context, input *PutAccountDedicatedIpWarmupAttributesInput, opts ...request.Option) (*PutAccountDedicatedIpWarmupAttributesOutput, error) {
	req, out := c.PutAccountDedicatedIpWarmupAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutAccountDetails = "PutAccountDetails"

// PutAccountDetailsRequest generates a "aws/request.Request" representing the
// client's request for the PutAccountDetails operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutAccountDetails for more information on using the PutAccountDetails
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutAccountDetailsRequest method.
//    req, resp := client.PutAccountDetailsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutAccountDetails
func (c *SESV2) PutAccountDetailsRequest(input *PutAccountDetailsInput) (req *request.Request, output *PutAccountDetailsOutput) {
	op := &request.Operation{
		Name:       opPutAccountDetails,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/email/account/details",
	}

	if input == nil {
		input = &PutAccountDetailsInput{}
	}

	output = &PutAccountDetailsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutAccountDetails API operation for Amazon Simple Email Service.
//
// Update your Amazon SES account details.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation PutAccountDetails for usage and error information.
//
// Returned Error Types:
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
//   * ConflictException
//   If there is already an ongoing account details update under review.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutAccountDetails
func (c *SESV2) PutAccountDetails(input *PutAccountDetailsInput) (*PutAccountDetailsOutput, error) {
	req, out := c.PutAccountDetailsRequest(input)
	return out, req.Send()
}

// PutAccountDetailsWithContext is the same as PutAccountDetails with the addition of
// the ability to pass a context and additional request options.
//
// See PutAccountDetails for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) PutAccountDetailsWithContext(ctx aws.Context, input *PutAccountDetailsInput, opts ...request.Option) (*PutAccountDetailsOutput, error) {
	req, out := c.PutAccountDetailsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutAccountSendingAttributes = "PutAccountSendingAttributes"

// PutAccountSendingAttributesRequest generates a "aws/request.Request" representing the
// client's request for the PutAccountSendingAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutAccountSendingAttributes for more information on using the PutAccountSendingAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutAccountSendingAttributesRequest method.
//    req, resp := client.PutAccountSendingAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutAccountSendingAttributes
func (c *SESV2) PutAccountSendingAttributesRequest(input *PutAccountSendingAttributesInput) (req *request.Request, output *PutAccountSendingAttributesOutput) {
	op := &request.Operation{
		Name:       opPutAccountSendingAttributes,
		HTTPMethod: "PUT",
		HTTPPath:   "/v2/email/account/sending",
	}

	if input == nil {
		input = &PutAccountSendingAttributesInput{}
	}

	output = &PutAccountSendingAttributesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutAccountSendingAttributes API operation for Amazon Simple Email Service.
//
// Enable or disable the ability of your account to send email.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation PutAccountSendingAttributes for usage and error information.
//
// Returned Error Types:
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutAccountSendingAttributes
func (c *SESV2) PutAccountSendingAttributes(input *PutAccountSendingAttributesInput) (*PutAccountSendingAttributesOutput, error) {
	req, out := c.PutAccountSendingAttributesRequest(input)
	return out, req.Send()
}

// PutAccountSendingAttributesWithContext is the same as PutAccountSendingAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See PutAccountSendingAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) PutAccountSendingAttributesWithContext(ctx aws.Context, input *PutAccountSendingAttributesInput, opts ...request.Option) (*PutAccountSendingAttributesOutput, error) {
	req, out := c.PutAccountSendingAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutAccountSuppressionAttributes = "PutAccountSuppressionAttributes"

// PutAccountSuppressionAttributesRequest generates a "aws/request.Request" representing the
// client's request for the PutAccountSuppressionAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutAccountSuppressionAttributes for more information on using the PutAccountSuppressionAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutAccountSuppressionAttributesRequest method.
//    req, resp := client.PutAccountSuppressionAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutAccountSuppressionAttributes
func (c *SESV2) PutAccountSuppressionAttributesRequest(input *PutAccountSuppressionAttributesInput) (req *request.Request, output *PutAccountSuppressionAttributesOutput) {
	op := &request.Operation{
		Name:       opPutAccountSuppressionAttributes,
		HTTPMethod: "PUT",
		HTTPPath:   "/v2/email/account/suppression",
	}

	if input == nil {
		input = &PutAccountSuppressionAttributesInput{}
	}

	output = &PutAccountSuppressionAttributesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutAccountSuppressionAttributes API operation for Amazon Simple Email Service.
//
// Change the settings for the account-level suppression list.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation PutAccountSuppressionAttributes for usage and error information.
//
// Returned Error Types:
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutAccountSuppressionAttributes
func (c *SESV2) PutAccountSuppressionAttributes(input *PutAccountSuppressionAttributesInput) (*PutAccountSuppressionAttributesOutput, error) {
	req, out := c.PutAccountSuppressionAttributesRequest(input)
	return out, req.Send()
}

// PutAccountSuppressionAttributesWithContext is the same as PutAccountSuppressionAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See PutAccountSuppressionAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) PutAccountSuppressionAttributesWithContext(ctx aws.Context, input *PutAccountSuppressionAttributesInput, opts ...request.Option) (*PutAccountSuppressionAttributesOutput, error) {
	req, out := c.PutAccountSuppressionAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutConfigurationSetDeliveryOptions = "PutConfigurationSetDeliveryOptions"

// PutConfigurationSetDeliveryOptionsRequest generates a "aws/request.Request" representing the
// client's request for the PutConfigurationSetDeliveryOptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutConfigurationSetDeliveryOptions for more information on using the PutConfigurationSetDeliveryOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutConfigurationSetDeliveryOptionsRequest method.
//    req, resp := client.PutConfigurationSetDeliveryOptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutConfigurationSetDeliveryOptions
func (c *SESV2) PutConfigurationSetDeliveryOptionsRequest(input *PutConfigurationSetDeliveryOptionsInput) (req *request.Request, output *PutConfigurationSetDeliveryOptionsOutput) {
	op := &request.Operation{
		Name:       opPutConfigurationSetDeliveryOptions,
		HTTPMethod: "PUT",
		HTTPPath:   "/v2/email/configuration-sets/{ConfigurationSetName}/delivery-options",
	}

	if input == nil {
		input = &PutConfigurationSetDeliveryOptionsInput{}
	}

	output = &PutConfigurationSetDeliveryOptionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutConfigurationSetDeliveryOptions API operation for Amazon Simple Email Service.
//
// Associate a configuration set with a dedicated IP pool. You can use dedicated
// IP pools to create groups of dedicated IP addresses for sending specific
// types of email.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation PutConfigurationSetDeliveryOptions for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutConfigurationSetDeliveryOptions
func (c *SESV2) PutConfigurationSetDeliveryOptions(input *PutConfigurationSetDeliveryOptionsInput) (*PutConfigurationSetDeliveryOptionsOutput, error) {
	req, out := c.PutConfigurationSetDeliveryOptionsRequest(input)
	return out, req.Send()
}

// PutConfigurationSetDeliveryOptionsWithContext is the same as PutConfigurationSetDeliveryOptions with the addition of
// the ability to pass a context and additional request options.
//
// See PutConfigurationSetDeliveryOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) PutConfigurationSetDeliveryOptionsWithContext(ctx aws.Context, input *PutConfigurationSetDeliveryOptionsInput, opts ...request.Option) (*PutConfigurationSetDeliveryOptionsOutput, error) {
	req, out := c.PutConfigurationSetDeliveryOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutConfigurationSetReputationOptions = "PutConfigurationSetReputationOptions"

// PutConfigurationSetReputationOptionsRequest generates a "aws/request.Request" representing the
// client's request for the PutConfigurationSetReputationOptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutConfigurationSetReputationOptions for more information on using the PutConfigurationSetReputationOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutConfigurationSetReputationOptionsRequest method.
//    req, resp := client.PutConfigurationSetReputationOptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutConfigurationSetReputationOptions
func (c *SESV2) PutConfigurationSetReputationOptionsRequest(input *PutConfigurationSetReputationOptionsInput) (req *request.Request, output *PutConfigurationSetReputationOptionsOutput) {
	op := &request.Operation{
		Name:       opPutConfigurationSetReputationOptions,
		HTTPMethod: "PUT",
		HTTPPath:   "/v2/email/configuration-sets/{ConfigurationSetName}/reputation-options",
	}

	if input == nil {
		input = &PutConfigurationSetReputationOptionsInput{}
	}

	output = &PutConfigurationSetReputationOptionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutConfigurationSetReputationOptions API operation for Amazon Simple Email Service.
//
// Enable or disable collection of reputation metrics for emails that you send
// using a particular configuration set in a specific AWS Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation PutConfigurationSetReputationOptions for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutConfigurationSetReputationOptions
func (c *SESV2) PutConfigurationSetReputationOptions(input *PutConfigurationSetReputationOptionsInput) (*PutConfigurationSetReputationOptionsOutput, error) {
	req, out := c.PutConfigurationSetReputationOptionsRequest(input)
	return out, req.Send()
}

// PutConfigurationSetReputationOptionsWithContext is the same as PutConfigurationSetReputationOptions with the addition of
// the ability to pass a context and additional request options.
//
// See PutConfigurationSetReputationOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) PutConfigurationSetReputationOptionsWithContext(ctx aws.Context, input *PutConfigurationSetReputationOptionsInput, opts ...request.Option) (*PutConfigurationSetReputationOptionsOutput, error) {
	req, out := c.PutConfigurationSetReputationOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutConfigurationSetSendingOptions = "PutConfigurationSetSendingOptions"

// PutConfigurationSetSendingOptionsRequest generates a "aws/request.Request" representing the
// client's request for the PutConfigurationSetSendingOptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutConfigurationSetSendingOptions for more information on using the PutConfigurationSetSendingOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutConfigurationSetSendingOptionsRequest method.
//    req, resp := client.PutConfigurationSetSendingOptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutConfigurationSetSendingOptions
func (c *SESV2) PutConfigurationSetSendingOptionsRequest(input *PutConfigurationSetSendingOptionsInput) (req *request.Request, output *PutConfigurationSetSendingOptionsOutput) {
	op := &request.Operation{
		Name:       opPutConfigurationSetSendingOptions,
		HTTPMethod: "PUT",
		HTTPPath:   "/v2/email/configuration-sets/{ConfigurationSetName}/sending",
	}

	if input == nil {
		input = &PutConfigurationSetSendingOptionsInput{}
	}

	output = &PutConfigurationSetSendingOptionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutConfigurationSetSendingOptions API operation for Amazon Simple Email Service.
//
// Enable or disable email sending for messages that use a particular configuration
// set in a specific AWS Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation PutConfigurationSetSendingOptions for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutConfigurationSetSendingOptions
func (c *SESV2) PutConfigurationSetSendingOptions(input *PutConfigurationSetSendingOptionsInput) (*PutConfigurationSetSendingOptionsOutput, error) {
	req, out := c.PutConfigurationSetSendingOptionsRequest(input)
	return out, req.Send()
}

// PutConfigurationSetSendingOptionsWithContext is the same as PutConfigurationSetSendingOptions with the addition of
// the ability to pass a context and additional request options.
//
// See PutConfigurationSetSendingOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) PutConfigurationSetSendingOptionsWithContext(ctx aws.Context, input *PutConfigurationSetSendingOptionsInput, opts ...request.Option) (*PutConfigurationSetSendingOptionsOutput, error) {
	req, out := c.PutConfigurationSetSendingOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutConfigurationSetSuppressionOptions = "PutConfigurationSetSuppressionOptions"

// PutConfigurationSetSuppressionOptionsRequest generates a "aws/request.Request" representing the
// client's request for the PutConfigurationSetSuppressionOptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutConfigurationSetSuppressionOptions for more information on using the PutConfigurationSetSuppressionOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutConfigurationSetSuppressionOptionsRequest method.
//    req, resp := client.PutConfigurationSetSuppressionOptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutConfigurationSetSuppressionOptions
func (c *SESV2) PutConfigurationSetSuppressionOptionsRequest(input *PutConfigurationSetSuppressionOptionsInput) (req *request.Request, output *PutConfigurationSetSuppressionOptionsOutput) {
	op := &request.Operation{
		Name:       opPutConfigurationSetSuppressionOptions,
		HTTPMethod: "PUT",
		HTTPPath:   "/v2/email/configuration-sets/{ConfigurationSetName}/suppression-options",
	}

	if input == nil {
		input = &PutConfigurationSetSuppressionOptionsInput{}
	}

	output = &PutConfigurationSetSuppressionOptionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutConfigurationSetSuppressionOptions API operation for Amazon Simple Email Service.
//
// Specify the account suppression list preferences for a configuration set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation PutConfigurationSetSuppressionOptions for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutConfigurationSetSuppressionOptions
func (c *SESV2) PutConfigurationSetSuppressionOptions(input *PutConfigurationSetSuppressionOptionsInput) (*PutConfigurationSetSuppressionOptionsOutput, error) {
	req, out := c.PutConfigurationSetSuppressionOptionsRequest(input)
	return out, req.Send()
}

// PutConfigurationSetSuppressionOptionsWithContext is the same as PutConfigurationSetSuppressionOptions with the addition of
// the ability to pass a context and additional request options.
//
// See PutConfigurationSetSuppressionOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) PutConfigurationSetSuppressionOptionsWithContext(ctx aws.Context, input *PutConfigurationSetSuppressionOptionsInput, opts ...request.Option) (*PutConfigurationSetSuppressionOptionsOutput, error) {
	req, out := c.PutConfigurationSetSuppressionOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutConfigurationSetTrackingOptions = "PutConfigurationSetTrackingOptions"

// PutConfigurationSetTrackingOptionsRequest generates a "aws/request.Request" representing the
// client's request for the PutConfigurationSetTrackingOptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutConfigurationSetTrackingOptions for more information on using the PutConfigurationSetTrackingOptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutConfigurationSetTrackingOptionsRequest method.
//    req, resp := client.PutConfigurationSetTrackingOptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutConfigurationSetTrackingOptions
func (c *SESV2) PutConfigurationSetTrackingOptionsRequest(input *PutConfigurationSetTrackingOptionsInput) (req *request.Request, output *PutConfigurationSetTrackingOptionsOutput) {
	op := &request.Operation{
		Name:       opPutConfigurationSetTrackingOptions,
		HTTPMethod: "PUT",
		HTTPPath:   "/v2/email/configuration-sets/{ConfigurationSetName}/tracking-options",
	}

	if input == nil {
		input = &PutConfigurationSetTrackingOptionsInput{}
	}

	output = &PutConfigurationSetTrackingOptionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutConfigurationSetTrackingOptions API operation for Amazon Simple Email Service.
//
// Specify a custom domain to use for open and click tracking elements in email
// that you send.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation PutConfigurationSetTrackingOptions for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutConfigurationSetTrackingOptions
func (c *SESV2) PutConfigurationSetTrackingOptions(input *PutConfigurationSetTrackingOptionsInput) (*PutConfigurationSetTrackingOptionsOutput, error) {
	req, out := c.PutConfigurationSetTrackingOptionsRequest(input)
	return out, req.Send()
}

// PutConfigurationSetTrackingOptionsWithContext is the same as PutConfigurationSetTrackingOptions with the addition of
// the ability to pass a context and additional request options.
//
// See PutConfigurationSetTrackingOptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) PutConfigurationSetTrackingOptionsWithContext(ctx aws.Context, input *PutConfigurationSetTrackingOptionsInput, opts ...request.Option) (*PutConfigurationSetTrackingOptionsOutput, error) {
	req, out := c.PutConfigurationSetTrackingOptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutDedicatedIpInPool = "PutDedicatedIpInPool"

// PutDedicatedIpInPoolRequest generates a "aws/request.Request" representing the
// client's request for the PutDedicatedIpInPool operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutDedicatedIpInPool for more information on using the PutDedicatedIpInPool
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutDedicatedIpInPoolRequest method.
//    req, resp := client.PutDedicatedIpInPoolRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutDedicatedIpInPool
func (c *SESV2) PutDedicatedIpInPoolRequest(input *PutDedicatedIpInPoolInput) (req *request.Request, output *PutDedicatedIpInPoolOutput) {
	op := &request.Operation{
		Name:       opPutDedicatedIpInPool,
		HTTPMethod: "PUT",
		HTTPPath:   "/v2/email/dedicated-ips/{IP}/pool",
	}

	if input == nil {
		input = &PutDedicatedIpInPoolInput{}
	}

	output = &PutDedicatedIpInPoolOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutDedicatedIpInPool API operation for Amazon Simple Email Service.
//
// Move a dedicated IP address to an existing dedicated IP pool.
//
// The dedicated IP address that you specify must already exist, and must be
// associated with your AWS account.
//
// The dedicated IP pool you specify must already exist. You can create a new
// pool by using the CreateDedicatedIpPool operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation PutDedicatedIpInPool for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutDedicatedIpInPool
func (c *SESV2) PutDedicatedIpInPool(input *PutDedicatedIpInPoolInput) (*PutDedicatedIpInPoolOutput, error) {
	req, out := c.PutDedicatedIpInPoolRequest(input)
	return out, req.Send()
}

// PutDedicatedIpInPoolWithContext is the same as PutDedicatedIpInPool with the addition of
// the ability to pass a context and additional request options.
//
// See PutDedicatedIpInPool for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) PutDedicatedIpInPoolWithContext(ctx aws.Context, input *PutDedicatedIpInPoolInput, opts ...request.Option) (*PutDedicatedIpInPoolOutput, error) {
	req, out := c.PutDedicatedIpInPoolRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutDedicatedIpWarmupAttributes = "PutDedicatedIpWarmupAttributes"

// PutDedicatedIpWarmupAttributesRequest generates a "aws/request.Request" representing the
// client's request for the PutDedicatedIpWarmupAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutDedicatedIpWarmupAttributes for more information on using the PutDedicatedIpWarmupAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutDedicatedIpWarmupAttributesRequest method.
//    req, resp := client.PutDedicatedIpWarmupAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutDedicatedIpWarmupAttributes
func (c *SESV2) PutDedicatedIpWarmupAttributesRequest(input *PutDedicatedIpWarmupAttributesInput) (req *request.Request, output *PutDedicatedIpWarmupAttributesOutput) {
	op := &request.Operation{
		Name:       opPutDedicatedIpWarmupAttributes,
		HTTPMethod: "PUT",
		HTTPPath:   "/v2/email/dedicated-ips/{IP}/warmup",
	}

	if input == nil {
		input = &PutDedicatedIpWarmupAttributesInput{}
	}

	output = &PutDedicatedIpWarmupAttributesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutDedicatedIpWarmupAttributes API operation for Amazon Simple Email Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation PutDedicatedIpWarmupAttributes for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutDedicatedIpWarmupAttributes
func (c *SESV2) PutDedicatedIpWarmupAttributes(input *PutDedicatedIpWarmupAttributesInput) (*PutDedicatedIpWarmupAttributesOutput, error) {
	req, out := c.PutDedicatedIpWarmupAttributesRequest(input)
	return out, req.Send()
}

// PutDedicatedIpWarmupAttributesWithContext is the same as PutDedicatedIpWarmupAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See PutDedicatedIpWarmupAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) PutDedicatedIpWarmupAttributesWithContext(ctx aws.Context, input *PutDedicatedIpWarmupAttributesInput, opts ...request.Option) (*PutDedicatedIpWarmupAttributesOutput, error) {
	req, out := c.PutDedicatedIpWarmupAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutDeliverabilityDashboardOption = "PutDeliverabilityDashboardOption"

// PutDeliverabilityDashboardOptionRequest generates a "aws/request.Request" representing the
// client's request for the PutDeliverabilityDashboardOption operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutDeliverabilityDashboardOption for more information on using the PutDeliverabilityDashboardOption
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutDeliverabilityDashboardOptionRequest method.
//    req, resp := client.PutDeliverabilityDashboardOptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutDeliverabilityDashboardOption
func (c *SESV2) PutDeliverabilityDashboardOptionRequest(input *PutDeliverabilityDashboardOptionInput) (req *request.Request, output *PutDeliverabilityDashboardOptionOutput) {
	op := &request.Operation{
		Name:       opPutDeliverabilityDashboardOption,
		HTTPMethod: "PUT",
		HTTPPath:   "/v2/email/deliverability-dashboard",
	}

	if input == nil {
		input = &PutDeliverabilityDashboardOptionInput{}
	}

	output = &PutDeliverabilityDashboardOptionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutDeliverabilityDashboardOption API operation for Amazon Simple Email Service.
//
// Enable or disable the Deliverability dashboard. When you enable the Deliverability
// dashboard, you gain access to reputation, deliverability, and other metrics
// for the domains that you use to send email. You also gain the ability to
// perform predictive inbox placement tests.
//
// When you use the Deliverability dashboard, you pay a monthly subscription
// charge, in addition to any other fees that you accrue by using Amazon SES
// and other AWS services. For more information about the features and cost
// of a Deliverability dashboard subscription, see Amazon SES Pricing (http://aws.amazon.com/ses/pricing/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation PutDeliverabilityDashboardOption for usage and error information.
//
// Returned Error Types:
//   * AlreadyExistsException
//   The resource specified in your request already exists.
//
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * LimitExceededException
//   There are too many instances of the specified resource type.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutDeliverabilityDashboardOption
func (c *SESV2) PutDeliverabilityDashboardOption(input *PutDeliverabilityDashboardOptionInput) (*PutDeliverabilityDashboardOptionOutput, error) {
	req, out := c.PutDeliverabilityDashboardOptionRequest(input)
	return out, req.Send()
}

// PutDeliverabilityDashboardOptionWithContext is the same as PutDeliverabilityDashboardOption with the addition of
// the ability to pass a context and additional request options.
//
// See PutDeliverabilityDashboardOption for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) PutDeliverabilityDashboardOptionWithContext(ctx aws.Context, input *PutDeliverabilityDashboardOptionInput, opts ...request.Option) (*PutDeliverabilityDashboardOptionOutput, error) {
	req, out := c.PutDeliverabilityDashboardOptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutEmailIdentityDkimAttributes = "PutEmailIdentityDkimAttributes"

// PutEmailIdentityDkimAttributesRequest generates a "aws/request.Request" representing the
// client's request for the PutEmailIdentityDkimAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutEmailIdentityDkimAttributes for more information on using the PutEmailIdentityDkimAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutEmailIdentityDkimAttributesRequest method.
//    req, resp := client.PutEmailIdentityDkimAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutEmailIdentityDkimAttributes
func (c *SESV2) PutEmailIdentityDkimAttributesRequest(input *PutEmailIdentityDkimAttributesInput) (req *request.Request, output *PutEmailIdentityDkimAttributesOutput) {
	op := &request.Operation{
		Name:       opPutEmailIdentityDkimAttributes,
		HTTPMethod: "PUT",
		HTTPPath:   "/v2/email/identities/{EmailIdentity}/dkim",
	}

	if input == nil {
		input = &PutEmailIdentityDkimAttributesInput{}
	}

	output = &PutEmailIdentityDkimAttributesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutEmailIdentityDkimAttributes API operation for Amazon Simple Email Service.
//
// Used to enable or disable DKIM authentication for an email identity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation PutEmailIdentityDkimAttributes for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutEmailIdentityDkimAttributes
func (c *SESV2) PutEmailIdentityDkimAttributes(input *PutEmailIdentityDkimAttributesInput) (*PutEmailIdentityDkimAttributesOutput, error) {
	req, out := c.PutEmailIdentityDkimAttributesRequest(input)
	return out, req.Send()
}

// PutEmailIdentityDkimAttributesWithContext is the same as PutEmailIdentityDkimAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See PutEmailIdentityDkimAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) PutEmailIdentityDkimAttributesWithContext(ctx aws.Context, input *PutEmailIdentityDkimAttributesInput, opts ...request.Option) (*PutEmailIdentityDkimAttributesOutput, error) {
	req, out := c.PutEmailIdentityDkimAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutEmailIdentityDkimSigningAttributes = "PutEmailIdentityDkimSigningAttributes"

// PutEmailIdentityDkimSigningAttributesRequest generates a "aws/request.Request" representing the
// client's request for the PutEmailIdentityDkimSigningAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutEmailIdentityDkimSigningAttributes for more information on using the PutEmailIdentityDkimSigningAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutEmailIdentityDkimSigningAttributesRequest method.
//    req, resp := client.PutEmailIdentityDkimSigningAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutEmailIdentityDkimSigningAttributes
func (c *SESV2) PutEmailIdentityDkimSigningAttributesRequest(input *PutEmailIdentityDkimSigningAttributesInput) (req *request.Request, output *PutEmailIdentityDkimSigningAttributesOutput) {
	op := &request.Operation{
		Name:       opPutEmailIdentityDkimSigningAttributes,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/email/identities/{EmailIdentity}/dkim/signing",
	}

	if input == nil {
		input = &PutEmailIdentityDkimSigningAttributesInput{}
	}

	output = &PutEmailIdentityDkimSigningAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutEmailIdentityDkimSigningAttributes API operation for Amazon Simple Email Service.
//
// Used to configure or change the DKIM authentication settings for an email
// domain identity. You can use this operation to do any of the following:
//
//    * Update the signing attributes for an identity that uses Bring Your Own
//    DKIM (BYODKIM).
//
//    * Change from using no DKIM authentication to using Easy DKIM.
//
//    * Change from using no DKIM authentication to using BYODKIM.
//
//    * Change from using Easy DKIM to using BYODKIM.
//
//    * Change from using BYODKIM to using Easy DKIM.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation PutEmailIdentityDkimSigningAttributes for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutEmailIdentityDkimSigningAttributes
func (c *SESV2) PutEmailIdentityDkimSigningAttributes(input *PutEmailIdentityDkimSigningAttributesInput) (*PutEmailIdentityDkimSigningAttributesOutput, error) {
	req, out := c.PutEmailIdentityDkimSigningAttributesRequest(input)
	return out, req.Send()
}

// PutEmailIdentityDkimSigningAttributesWithContext is the same as PutEmailIdentityDkimSigningAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See PutEmailIdentityDkimSigningAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) PutEmailIdentityDkimSigningAttributesWithContext(ctx aws.Context, input *PutEmailIdentityDkimSigningAttributesInput, opts ...request.Option) (*PutEmailIdentityDkimSigningAttributesOutput, error) {
	req, out := c.PutEmailIdentityDkimSigningAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutEmailIdentityFeedbackAttributes = "PutEmailIdentityFeedbackAttributes"

// PutEmailIdentityFeedbackAttributesRequest generates a "aws/request.Request" representing the
// client's request for the PutEmailIdentityFeedbackAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutEmailIdentityFeedbackAttributes for more information on using the PutEmailIdentityFeedbackAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutEmailIdentityFeedbackAttributesRequest method.
//    req, resp := client.PutEmailIdentityFeedbackAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutEmailIdentityFeedbackAttributes
func (c *SESV2) PutEmailIdentityFeedbackAttributesRequest(input *PutEmailIdentityFeedbackAttributesInput) (req *request.Request, output *PutEmailIdentityFeedbackAttributesOutput) {
	op := &request.Operation{
		Name:       opPutEmailIdentityFeedbackAttributes,
		HTTPMethod: "PUT",
		HTTPPath:   "/v2/email/identities/{EmailIdentity}/feedback",
	}

	if input == nil {
		input = &PutEmailIdentityFeedbackAttributesInput{}
	}

	output = &PutEmailIdentityFeedbackAttributesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutEmailIdentityFeedbackAttributes API operation for Amazon Simple Email Service.
//
// Used to enable or disable feedback forwarding for an identity. This setting
// determines what happens when an identity is used to send an email that results
// in a bounce or complaint event.
//
// If the value is true, you receive email notifications when bounce or complaint
// events occur. These notifications are sent to the address that you specified
// in the Return-Path header of the original email.
//
// You're required to have a method of tracking bounces and complaints. If you
// haven't set up another mechanism for receiving bounce or complaint notifications
// (for example, by setting up an event destination), you receive an email notification
// when these events occur (even if this setting is disabled).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation PutEmailIdentityFeedbackAttributes for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutEmailIdentityFeedbackAttributes
func (c *SESV2) PutEmailIdentityFeedbackAttributes(input *PutEmailIdentityFeedbackAttributesInput) (*PutEmailIdentityFeedbackAttributesOutput, error) {
	req, out := c.PutEmailIdentityFeedbackAttributesRequest(input)
	return out, req.Send()
}

// PutEmailIdentityFeedbackAttributesWithContext is the same as PutEmailIdentityFeedbackAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See PutEmailIdentityFeedbackAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) PutEmailIdentityFeedbackAttributesWithContext(ctx aws.Context, input *PutEmailIdentityFeedbackAttributesInput, opts ...request.Option) (*PutEmailIdentityFeedbackAttributesOutput, error) {
	req, out := c.PutEmailIdentityFeedbackAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutEmailIdentityMailFromAttributes = "PutEmailIdentityMailFromAttributes"

// PutEmailIdentityMailFromAttributesRequest generates a "aws/request.Request" representing the
// client's request for the PutEmailIdentityMailFromAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutEmailIdentityMailFromAttributes for more information on using the PutEmailIdentityMailFromAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutEmailIdentityMailFromAttributesRequest method.
//    req, resp := client.PutEmailIdentityMailFromAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutEmailIdentityMailFromAttributes
func (c *SESV2) PutEmailIdentityMailFromAttributesRequest(input *PutEmailIdentityMailFromAttributesInput) (req *request.Request, output *PutEmailIdentityMailFromAttributesOutput) {
	op := &request.Operation{
		Name:       opPutEmailIdentityMailFromAttributes,
		HTTPMethod: "PUT",
		HTTPPath:   "/v2/email/identities/{EmailIdentity}/mail-from",
	}

	if input == nil {
		input = &PutEmailIdentityMailFromAttributesInput{}
	}

	output = &PutEmailIdentityMailFromAttributesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutEmailIdentityMailFromAttributes API operation for Amazon Simple Email Service.
//
// Used to enable or disable the custom Mail-From domain configuration for an
// email identity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation PutEmailIdentityMailFromAttributes for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutEmailIdentityMailFromAttributes
func (c *SESV2) PutEmailIdentityMailFromAttributes(input *PutEmailIdentityMailFromAttributesInput) (*PutEmailIdentityMailFromAttributesOutput, error) {
	req, out := c.PutEmailIdentityMailFromAttributesRequest(input)
	return out, req.Send()
}

// PutEmailIdentityMailFromAttributesWithContext is the same as PutEmailIdentityMailFromAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See PutEmailIdentityMailFromAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) PutEmailIdentityMailFromAttributesWithContext(ctx aws.Context, input *PutEmailIdentityMailFromAttributesInput, opts ...request.Option) (*PutEmailIdentityMailFromAttributesOutput, error) {
	req, out := c.PutEmailIdentityMailFromAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutSuppressedDestination = "PutSuppressedDestination"

// PutSuppressedDestinationRequest generates a "aws/request.Request" representing the
// client's request for the PutSuppressedDestination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutSuppressedDestination for more information on using the PutSuppressedDestination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutSuppressedDestinationRequest method.
//    req, resp := client.PutSuppressedDestinationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutSuppressedDestination
func (c *SESV2) PutSuppressedDestinationRequest(input *PutSuppressedDestinationInput) (req *request.Request, output *PutSuppressedDestinationOutput) {
	op := &request.Operation{
		Name:       opPutSuppressedDestination,
		HTTPMethod: "PUT",
		HTTPPath:   "/v2/email/suppression/addresses",
	}

	if input == nil {
		input = &PutSuppressedDestinationInput{}
	}

	output = &PutSuppressedDestinationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutSuppressedDestination API operation for Amazon Simple Email Service.
//
// Adds an email address to the suppression list for your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation PutSuppressedDestination for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input you provided is invalid.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutSuppressedDestination
func (c *SESV2) PutSuppressedDestination(input *PutSuppressedDestinationInput) (*PutSuppressedDestinationOutput, error) {
	req, out := c.PutSuppressedDestinationRequest(input)
	return out, req.Send()
}

// PutSuppressedDestinationWithContext is the same as PutSuppressedDestination with the addition of
// the ability to pass a context and additional request options.
//
// See PutSuppressedDestination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) PutSuppressedDestinationWithContext(ctx aws.Context, input *PutSuppressedDestinationInput, opts ...request.Option) (*PutSuppressedDestinationOutput, error) {
	req, out := c.PutSuppressedDestinationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSendBulkEmail = "SendBulkEmail"

// SendBulkEmailRequest generates a "aws/request.Request" representing the
// client's request for the SendBulkEmail operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendBulkEmail for more information on using the SendBulkEmail
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SendBulkEmailRequest method.
//    req, resp := client.SendBulkEmailRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/SendBulkEmail
func (c *SESV2) SendBulkEmailRequest(input *SendBulkEmailInput) (req *request.Request, output *SendBulkEmailOutput) {
	op := &request.Operation{
		Name:       opSendBulkEmail,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/email/outbound-bulk-emails",
	}

	if input == nil {
		input = &SendBulkEmailInput{}
	}

	output = &SendBulkEmailOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SendBulkEmail API operation for Amazon Simple Email Service.
//
// Composes an email message to multiple destinations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation SendBulkEmail for usage and error information.
//
// Returned Error Types:
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * LimitExceededException
//   There are too many instances of the specified resource type.
//
//   * AccountSuspendedException
//   The message can't be sent because the account's ability to send email has
//   been permanently restricted.
//
//   * SendingPausedException
//   The message can't be sent because the account's ability to send email is
//   currently paused.
//
//   * MessageRejected
//   The message can't be sent because it contains invalid content.
//
//   * MailFromDomainNotVerifiedException
//   The message can't be sent because the sending domain isn't verified.
//
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/SendBulkEmail
func (c *SESV2) SendBulkEmail(input *SendBulkEmailInput) (*SendBulkEmailOutput, error) {
	req, out := c.SendBulkEmailRequest(input)
	return out, req.Send()
}

// SendBulkEmailWithContext is the same as SendBulkEmail with the addition of
// the ability to pass a context and additional request options.
//
// See SendBulkEmail for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) SendBulkEmailWithContext(ctx aws.Context, input *SendBulkEmailInput, opts ...request.Option) (*SendBulkEmailOutput, error) {
	req, out := c.SendBulkEmailRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSendCustomVerificationEmail = "SendCustomVerificationEmail"

// SendCustomVerificationEmailRequest generates a "aws/request.Request" representing the
// client's request for the SendCustomVerificationEmail operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendCustomVerificationEmail for more information on using the SendCustomVerificationEmail
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SendCustomVerificationEmailRequest method.
//    req, resp := client.SendCustomVerificationEmailRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/SendCustomVerificationEmail
func (c *SESV2) SendCustomVerificationEmailRequest(input *SendCustomVerificationEmailInput) (req *request.Request, output *SendCustomVerificationEmailOutput) {
	op := &request.Operation{
		Name:       opSendCustomVerificationEmail,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/email/outbound-custom-verification-emails",
	}

	if input == nil {
		input = &SendCustomVerificationEmailInput{}
	}

	output = &SendCustomVerificationEmailOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SendCustomVerificationEmail API operation for Amazon Simple Email Service.
//
// Adds an email address to the list of identities for your Amazon SES account
// in the current AWS Region and attempts to verify it. As a result of executing
// this operation, a customized verification email is sent to the specified
// address.
//
// To use this operation, you must first create a custom verification email
// template. For more information about creating and using custom verification
// email templates, see Using Custom Verification Email Templates (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html)
// in the Amazon SES Developer Guide.
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation SendCustomVerificationEmail for usage and error information.
//
// Returned Error Types:
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * LimitExceededException
//   There are too many instances of the specified resource type.
//
//   * MessageRejected
//   The message can't be sent because it contains invalid content.
//
//   * SendingPausedException
//   The message can't be sent because the account's ability to send email is
//   currently paused.
//
//   * MailFromDomainNotVerifiedException
//   The message can't be sent because the sending domain isn't verified.
//
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/SendCustomVerificationEmail
func (c *SESV2) SendCustomVerificationEmail(input *SendCustomVerificationEmailInput) (*SendCustomVerificationEmailOutput, error) {
	req, out := c.SendCustomVerificationEmailRequest(input)
	return out, req.Send()
}

// SendCustomVerificationEmailWithContext is the same as SendCustomVerificationEmail with the addition of
// the ability to pass a context and additional request options.
//
// See SendCustomVerificationEmail for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) SendCustomVerificationEmailWithContext(ctx aws.Context, input *SendCustomVerificationEmailInput, opts ...request.Option) (*SendCustomVerificationEmailOutput, error) {
	req, out := c.SendCustomVerificationEmailRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSendEmail = "SendEmail"

// SendEmailRequest generates a "aws/request.Request" representing the
// client's request for the SendEmail operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendEmail for more information on using the SendEmail
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SendEmailRequest method.
//    req, resp := client.SendEmailRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/SendEmail
func (c *SESV2) SendEmailRequest(input *SendEmailInput) (req *request.Request, output *SendEmailOutput) {
	op := &request.Operation{
		Name:       opSendEmail,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/email/outbound-emails",
	}

	if input == nil {
		input = &SendEmailInput{}
	}

	output = &SendEmailOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SendEmail API operation for Amazon Simple Email Service.
//
// Sends an email message. You can use the Amazon SES API v2 to send two types
// of messages:
//
//    * Simple – A standard email message. When you create this type of message,
//    you specify the sender, the recipient, and the message body, and Amazon
//    SES assembles the message for you.
//
//    * Raw – A raw, MIME-formatted email message. When you send this type
//    of email, you have to specify all of the message headers, as well as the
//    message body. You can use this message type to send messages that contain
//    attachments. The message that you specify has to be a valid MIME message.
//
//    * Templated – A message that contains personalization tags. When you
//    send this type of email, Amazon SES API v2 automatically replaces the
//    tags with values that you specify.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation SendEmail for usage and error information.
//
// Returned Error Types:
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * LimitExceededException
//   There are too many instances of the specified resource type.
//
//   * AccountSuspendedException
//   The message can't be sent because the account's ability to send email has
//   been permanently restricted.
//
//   * SendingPausedException
//   The message can't be sent because the account's ability to send email is
//   currently paused.
//
//   * MessageRejected
//   The message can't be sent because it contains invalid content.
//
//   * MailFromDomainNotVerifiedException
//   The message can't be sent because the sending domain isn't verified.
//
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/SendEmail
func (c *SESV2) SendEmail(input *SendEmailInput) (*SendEmailOutput, error) {
	req, out := c.SendEmailRequest(input)
	return out, req.Send()
}

// SendEmailWithContext is the same as SendEmail with the addition of
// the ability to pass a context and additional request options.
//
// See SendEmail for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) SendEmailWithContext(ctx aws.Context, input *SendEmailInput, opts ...request.Option) (*SendEmailOutput, error) {
	req, out := c.SendEmailRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/TagResource
func (c *SESV2) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/email/tags",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Simple Email Service.
//
// Add one or more tags (keys and values) to a specified resource. A tag is
// a label that you optionally define and associate with a resource. Tags can
// help you categorize and manage resources in different ways, such as by purpose,
// owner, environment, or other criteria. A resource can have as many as 50
// tags.
//
// Each tag consists of a required tag key and an associated tag value, both
// of which you define. A tag key is a general label that acts as a category
// for more specific tag values. A tag value acts as a descriptor within a tag
// key.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input you provided is invalid.
//
//   * ConcurrentModificationException
//   The resource is being modified by another operation or thread.
//
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/TagResource
func (c *SESV2) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTestRenderEmailTemplate = "TestRenderEmailTemplate"

// TestRenderEmailTemplateRequest generates a "aws/request.Request" representing the
// client's request for the TestRenderEmailTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TestRenderEmailTemplate for more information on using the TestRenderEmailTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TestRenderEmailTemplateRequest method.
//    req, resp := client.TestRenderEmailTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/TestRenderEmailTemplate
func (c *SESV2) TestRenderEmailTemplateRequest(input *TestRenderEmailTemplateInput) (req *request.Request, output *TestRenderEmailTemplateOutput) {
	op := &request.Operation{
		Name:       opTestRenderEmailTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/email/templates/{TemplateName}/render",
	}

	if input == nil {
		input = &TestRenderEmailTemplateInput{}
	}

	output = &TestRenderEmailTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TestRenderEmailTemplate API operation for Amazon Simple Email Service.
//
// Creates a preview of the MIME content of an email when provided with a template
// and a set of replacement data.
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation TestRenderEmailTemplate for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/TestRenderEmailTemplate
func (c *SESV2) TestRenderEmailTemplate(input *TestRenderEmailTemplateInput) (*TestRenderEmailTemplateOutput, error) {
	req, out := c.TestRenderEmailTemplateRequest(input)
	return out, req.Send()
}

// TestRenderEmailTemplateWithContext is the same as TestRenderEmailTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See TestRenderEmailTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) TestRenderEmailTemplateWithContext(ctx aws.Context, input *TestRenderEmailTemplateInput, opts ...request.Option) (*TestRenderEmailTemplateOutput, error) {
	req, out := c.TestRenderEmailTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UntagResource
func (c *SESV2) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2/email/tags",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Simple Email Service.
//
// Remove one or more tags (keys and values) from a specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input you provided is invalid.
//
//   * ConcurrentModificationException
//   The resource is being modified by another operation or thread.
//
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UntagResource
func (c *SESV2) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateConfigurationSetEventDestination = "UpdateConfigurationSetEventDestination"

// UpdateConfigurationSetEventDestinationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateConfigurationSetEventDestination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateConfigurationSetEventDestination for more information on using the UpdateConfigurationSetEventDestination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateConfigurationSetEventDestinationRequest method.
//    req, resp := client.UpdateConfigurationSetEventDestinationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UpdateConfigurationSetEventDestination
func (c *SESV2) UpdateConfigurationSetEventDestinationRequest(input *UpdateConfigurationSetEventDestinationInput) (req *request.Request, output *UpdateConfigurationSetEventDestinationOutput) {
	op := &request.Operation{
		Name:       opUpdateConfigurationSetEventDestination,
		HTTPMethod: "PUT",
		HTTPPath:   "/v2/email/configuration-sets/{ConfigurationSetName}/event-destinations/{EventDestinationName}",
	}

	if input == nil {
		input = &UpdateConfigurationSetEventDestinationInput{}
	}

	output = &UpdateConfigurationSetEventDestinationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateConfigurationSetEventDestination API operation for Amazon Simple Email Service.
//
// Update the configuration of an event destination for a configuration set.
//
// Events include message sends, deliveries, opens, clicks, bounces, and complaints.
// Event destinations are places that you can send information about these events
// to. For example, you can send event data to Amazon SNS to receive notifications
// when you receive bounces or complaints, or you can use Amazon Kinesis Data
// Firehose to stream data to Amazon S3 for long-term storage.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation UpdateConfigurationSetEventDestination for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UpdateConfigurationSetEventDestination
func (c *SESV2) UpdateConfigurationSetEventDestination(input *UpdateConfigurationSetEventDestinationInput) (*UpdateConfigurationSetEventDestinationOutput, error) {
	req, out := c.UpdateConfigurationSetEventDestinationRequest(input)
	return out, req.Send()
}

// UpdateConfigurationSetEventDestinationWithContext is the same as UpdateConfigurationSetEventDestination with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateConfigurationSetEventDestination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) UpdateConfigurationSetEventDestinationWithContext(ctx aws.Context, input *UpdateConfigurationSetEventDestinationInput, opts ...request.Option) (*UpdateConfigurationSetEventDestinationOutput, error) {
	req, out := c.UpdateConfigurationSetEventDestinationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCustomVerificationEmailTemplate = "UpdateCustomVerificationEmailTemplate"

// UpdateCustomVerificationEmailTemplateRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCustomVerificationEmailTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCustomVerificationEmailTemplate for more information on using the UpdateCustomVerificationEmailTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateCustomVerificationEmailTemplateRequest method.
//    req, resp := client.UpdateCustomVerificationEmailTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UpdateCustomVerificationEmailTemplate
func (c *SESV2) UpdateCustomVerificationEmailTemplateRequest(input *UpdateCustomVerificationEmailTemplateInput) (req *request.Request, output *UpdateCustomVerificationEmailTemplateOutput) {
	op := &request.Operation{
		Name:       opUpdateCustomVerificationEmailTemplate,
		HTTPMethod: "PUT",
		HTTPPath:   "/v2/email/custom-verification-email-templates/{TemplateName}",
	}

	if input == nil {
		input = &UpdateCustomVerificationEmailTemplateInput{}
	}

	output = &UpdateCustomVerificationEmailTemplateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateCustomVerificationEmailTemplate API operation for Amazon Simple Email Service.
//
// Updates an existing custom verification email template.
//
// For more information about custom verification email templates, see Using
// Custom Verification Email Templates (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html)
// in the Amazon SES Developer Guide.
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation UpdateCustomVerificationEmailTemplate for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * BadRequestException
//   The input you provided is invalid.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UpdateCustomVerificationEmailTemplate
func (c *SESV2) UpdateCustomVerificationEmailTemplate(input *UpdateCustomVerificationEmailTemplateInput) (*UpdateCustomVerificationEmailTemplateOutput, error) {
	req, out := c.UpdateCustomVerificationEmailTemplateRequest(input)
	return out, req.Send()
}

// UpdateCustomVerificationEmailTemplateWithContext is the same as UpdateCustomVerificationEmailTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCustomVerificationEmailTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) UpdateCustomVerificationEmailTemplateWithContext(ctx aws.Context, input *UpdateCustomVerificationEmailTemplateInput, opts ...request.Option) (*UpdateCustomVerificationEmailTemplateOutput, error) {
	req, out := c.UpdateCustomVerificationEmailTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEmailIdentityPolicy = "UpdateEmailIdentityPolicy"

// UpdateEmailIdentityPolicyRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEmailIdentityPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEmailIdentityPolicy for more information on using the UpdateEmailIdentityPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateEmailIdentityPolicyRequest method.
//    req, resp := client.UpdateEmailIdentityPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UpdateEmailIdentityPolicy
func (c *SESV2) UpdateEmailIdentityPolicyRequest(input *UpdateEmailIdentityPolicyInput) (req *request.Request, output *UpdateEmailIdentityPolicyOutput) {
	op := &request.Operation{
		Name:       opUpdateEmailIdentityPolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/v2/email/identities/{EmailIdentity}/policies/{PolicyName}",
	}

	if input == nil {
		input = &UpdateEmailIdentityPolicyInput{}
	}

	output = &UpdateEmailIdentityPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateEmailIdentityPolicy API operation for Amazon Simple Email Service.
//
// Updates the specified sending authorization policy for the given identity
// (an email address or a domain). This API returns successfully even if a policy
// with the specified name does not exist.
//
// This API is for the identity owner only. If you have not verified the identity,
// this API will return an error.
//
// Sending authorization is a feature that enables an identity owner to authorize
// other senders to use its identities. For information about using sending
// authorization, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation UpdateEmailIdentityPolicy for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UpdateEmailIdentityPolicy
func (c *SESV2) UpdateEmailIdentityPolicy(input *UpdateEmailIdentityPolicyInput) (*UpdateEmailIdentityPolicyOutput, error) {
	req, out := c.UpdateEmailIdentityPolicyRequest(input)
	return out, req.Send()
}

// UpdateEmailIdentityPolicyWithContext is the same as UpdateEmailIdentityPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEmailIdentityPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) UpdateEmailIdentityPolicyWithContext(ctx aws.Context, input *UpdateEmailIdentityPolicyInput, opts ...request.Option) (*UpdateEmailIdentityPolicyOutput, error) {
	req, out := c.UpdateEmailIdentityPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEmailTemplate = "UpdateEmailTemplate"

// UpdateEmailTemplateRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEmailTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEmailTemplate for more information on using the UpdateEmailTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateEmailTemplateRequest method.
//    req, resp := client.UpdateEmailTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UpdateEmailTemplate
func (c *SESV2) UpdateEmailTemplateRequest(input *UpdateEmailTemplateInput) (req *request.Request, output *UpdateEmailTemplateOutput) {
	op := &request.Operation{
		Name:       opUpdateEmailTemplate,
		HTTPMethod: "PUT",
		HTTPPath:   "/v2/email/templates/{TemplateName}",
	}

	if input == nil {
		input = &UpdateEmailTemplateInput{}
	}

	output = &UpdateEmailTemplateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateEmailTemplate API operation for Amazon Simple Email Service.
//
// Updates an email template. Email templates enable you to send personalized
// email to one or more destinations in a single API operation. For more information,
// see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html).
//
// You can execute this operation no more than once per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation UpdateEmailTemplate for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   The resource you attempted to access doesn't exist.
//
//   * TooManyRequestsException
//   Too many requests have been made to the operation.
//
//   * BadRequestException
//   The input you provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UpdateEmailTemplate
func (c *SESV2) UpdateEmailTemplate(input *UpdateEmailTemplateInput) (*UpdateEmailTemplateOutput, error) {
	req, out := c.UpdateEmailTemplateRequest(input)
	return out, req.Send()
}

// UpdateEmailTemplateWithContext is the same as UpdateEmailTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEmailTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SESV2) UpdateEmailTemplateWithContext(ctx aws.Context, input *UpdateEmailTemplateInput, opts ...request.Option) (*UpdateEmailTemplateOutput, error) {
	req, out := c.UpdateEmailTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// An object that contains information about your account details.
type AccountDetails struct {
	_ struct{} `type:"structure"`

	// Additional email addresses where updates are sent about your account review
	// process.
	AdditionalContactEmailAddresses []*string `min:"1" type:"list" sensitive:"true"`

	// The language you would prefer for the case. The contact language can be one
	// of ENGLISH or JAPANESE.
	ContactLanguage *string `type:"string" enum:"ContactLanguage"`

	// The type of email your account is sending. The mail type can be one of the
	// following:
	//
	//    * MARKETING – Most of your sending traffic is to keep your customers
	//    informed of your latest offering.
	//
	//    * TRANSACTIONAL – Most of your sending traffic is to communicate during
	//    a transaction with a customer.
	MailType *string `type:"string" enum:"MailType"`

	// Information about the review of the latest details you submitted.
	ReviewDetails *ReviewDetails `type:"structure"`

	// A description of the types of email that you plan to send.
	UseCaseDescription *string `min:"1" type:"string" sensitive:"true"`

	// The URL of your website. This information helps us better understand the
	// type of content that you plan to send.
	WebsiteURL *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation
func (s AccountDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountDetails) GoString() string {
	return s.String()
}

// SetAdditionalContactEmailAddresses sets the AdditionalContactEmailAddresses field's value.
func (s *AccountDetails) SetAdditionalContactEmailAddresses(v []*string) *AccountDetails {
	s.AdditionalContactEmailAddresses = v
	return s
}

// SetContactLanguage sets the ContactLanguage field's value.
func (s *AccountDetails) SetContactLanguage(v string) *AccountDetails {
	s.ContactLanguage = &v
	return s
}

// SetMailType sets the MailType field's value.
func (s *AccountDetails) SetMailType(v string) *AccountDetails {
	s.MailType = &v
	return s
}

// SetReviewDetails sets the ReviewDetails field's value.
func (s *AccountDetails) SetReviewDetails(v *ReviewDetails) *AccountDetails {
	s.ReviewDetails = v
	return s
}

// SetUseCaseDescription sets the UseCaseDescription field's value.
func (s *AccountDetails) SetUseCaseDescription(v string) *AccountDetails {
	s.UseCaseDescription = &v
	return s
}

// SetWebsiteURL sets the WebsiteURL field's value.
func (s *AccountDetails) SetWebsiteURL(v string) *AccountDetails {
	s.WebsiteURL = &v
	return s
}

// The message can't be sent because the account's ability to send email has
// been permanently restricted.
type AccountSuspendedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s AccountSuspendedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountSuspendedException) GoString() string {
	return s.String()
}

func newErrorAccountSuspendedException(v protocol.ResponseMetadata) error {
	return &AccountSuspendedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccountSuspendedException) Code() string {
	return "AccountSuspendedException"
}

// Message returns the exception's message.
func (s *AccountSuspendedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccountSuspendedException) OrigErr() error {
	return nil
}

func (s *AccountSuspendedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccountSuspendedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccountSuspendedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The resource specified in your request already exists.
type AlreadyExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s AlreadyExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AlreadyExistsException) GoString() string {
	return s.String()
}

func newErrorAlreadyExistsException(v protocol.ResponseMetadata) error {
	return &AlreadyExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AlreadyExistsException) Code() string {
	return "AlreadyExistsException"
}

// Message returns the exception's message.
func (s *AlreadyExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AlreadyExistsException) OrigErr() error {
	return nil
}

func (s *AlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AlreadyExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AlreadyExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The input you provided is invalid.
type BadRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s *BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequestException) OrigErr() error {
	return nil
}

func (s *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object that contains information about a blacklisting event that impacts
// one of the dedicated IP addresses that is associated with your account.
type BlacklistEntry struct {
	_ struct{} `type:"structure"`

	// Additional information about the blacklisting event, as provided by the blacklist
	// maintainer.
	Description *string `type:"string"`

	// The time when the blacklisting event occurred, shown in Unix time format.
	ListingTime *time.Time `type:"timestamp"`

	// The name of the blacklist that the IP address appears on.
	RblName *string `type:"string"`
}

// String returns the string representation
func (s BlacklistEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BlacklistEntry) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *BlacklistEntry) SetDescription(v string) *BlacklistEntry {
	s.Description = &v
	return s
}

// SetListingTime sets the ListingTime field's value.
func (s *BlacklistEntry) SetListingTime(v time.Time) *BlacklistEntry {
	s.ListingTime = &v
	return s
}

// SetRblName sets the RblName field's value.
func (s *BlacklistEntry) SetRblName(v string) *BlacklistEntry {
	s.RblName = &v
	return s
}

// Represents the body of the email message.
type Body struct {
	_ struct{} `type:"structure"`

	// An object that represents the version of the message that is displayed in
	// email clients that support HTML. HTML messages can include formatted text,
	// hyperlinks, images, and more.
	Html *Content `type:"structure"`

	// An object that represents the version of the message that is displayed in
	// email clients that don't support HTML, or clients where the recipient has
	// disabled HTML rendering.
	Text *Content `type:"structure"`
}

// String returns the string representation
func (s Body) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Body) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Body) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Body"}
	if s.Html != nil {
		if err := s.Html.Validate(); err != nil {
			invalidParams.AddNested("Html", err.(request.ErrInvalidParams))
		}
	}
	if s.Text != nil {
		if err := s.Text.Validate(); err != nil {
			invalidParams.AddNested("Text", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHtml sets the Html field's value.
func (s *Body) SetHtml(v *Content) *Body {
	s.Html = v
	return s
}

// SetText sets the Text field's value.
func (s *Body) SetText(v *Content) *Body {
	s.Text = v
	return s
}

// An object that contains the body of the message. You can specify a template
// message.
type BulkEmailContent struct {
	_ struct{} `type:"structure"`

	// The template to use for the bulk email message.
	Template *Template `type:"structure"`
}

// String returns the string representation
func (s BulkEmailContent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BulkEmailContent) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BulkEmailContent) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BulkEmailContent"}
	if s.Template != nil {
		if err := s.Template.Validate(); err != nil {
			invalidParams.AddNested("Template", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTemplate sets the Template field's value.
func (s *BulkEmailContent) SetTemplate(v *Template) *BulkEmailContent {
	s.Template = v
	return s
}

type BulkEmailEntry struct {
	_ struct{} `type:"structure"`

	// Represents the destination of the message, consisting of To:, CC:, and BCC:
	// fields.
	//
	// Amazon SES does not support the SMTPUTF8 extension, as described in RFC6531
	// (https://tools.ietf.org/html/rfc6531). For this reason, the local part of
	// a destination email address (the part of the email address that precedes
	// the @ sign) may only contain 7-bit ASCII characters (https://en.wikipedia.org/wiki/Email_address#Local-part).
	// If the domain part of an address (the part after the @ sign) contains non-ASCII
	// characters, they must be encoded using Punycode, as described in RFC3492
	// (https://tools.ietf.org/html/rfc3492.html).
	//
	// Destination is a required field
	Destination *Destination `type:"structure" required:"true"`

	// The ReplacementEmailContent associated with a BulkEmailEntry.
	ReplacementEmailContent *ReplacementEmailContent `type:"structure"`

	// A list of tags, in the form of name/value pairs, to apply to an email that
	// you send using the SendBulkTemplatedEmail operation. Tags correspond to characteristics
	// of the email that you define, so that you can publish email sending events.
	ReplacementTags []*MessageTag `type:"list"`
}

// String returns the string representation
func (s BulkEmailEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BulkEmailEntry) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BulkEmailEntry) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BulkEmailEntry"}
	if s.Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("Destination"))
	}
	if s.ReplacementTags != nil {
		for i, v := range s.ReplacementTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ReplacementTags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestination sets the Destination field's value.
func (s *BulkEmailEntry) SetDestination(v *Destination) *BulkEmailEntry {
	s.Destination = v
	return s
}

// SetReplacementEmailContent sets the ReplacementEmailContent field's value.
func (s *BulkEmailEntry) SetReplacementEmailContent(v *ReplacementEmailContent) *BulkEmailEntry {
	s.ReplacementEmailContent = v
	return s
}

// SetReplacementTags sets the ReplacementTags field's value.
func (s *BulkEmailEntry) SetReplacementTags(v []*MessageTag) *BulkEmailEntry {
	s.ReplacementTags = v
	return s
}

// The result of the SendBulkEmail operation of each specified BulkEmailEntry.
type BulkEmailEntryResult struct {
	_ struct{} `type:"structure"`

	// A description of an error that prevented a message being sent using the SendBulkTemplatedEmail
	// operation.
	Error *string `type:"string"`

	// The unique message identifier returned from the SendBulkTemplatedEmail operation.
	MessageId *string `type:"string"`

	// The status of a message sent using the SendBulkTemplatedEmail operation.
	//
	// Possible values for this parameter include:
	//
	//    * SUCCESS: Amazon SES accepted the message, and will attempt to deliver
	//    it to the recipients.
	//
	//    * MESSAGE_REJECTED: The message was rejected because it contained a virus.
	//
	//    * MAIL_FROM_DOMAIN_NOT_VERIFIED: The sender's email address or domain
	//    was not verified.
	//
	//    * CONFIGURATION_SET_DOES_NOT_EXIST: The configuration set you specified
	//    does not exist.
	//
	//    * TEMPLATE_DOES_NOT_EXIST: The template you specified does not exist.
	//
	//    * ACCOUNT_SUSPENDED: Your account has been shut down because of issues
	//    related to your email sending practices.
	//
	//    * ACCOUNT_THROTTLED: The number of emails you can send has been reduced
	//    because your account has exceeded its allocated sending limit.
	//
	//    * ACCOUNT_DAILY_QUOTA_EXCEEDED: You have reached or exceeded the maximum
	//    number of emails you can send from your account in a 24-hour period.
	//
	//    * INVALID_SENDING_POOL_NAME: The configuration set you specified refers
	//    to an IP pool that does not exist.
	//
	//    * ACCOUNT_SENDING_PAUSED: Email sending for the Amazon SES account was
	//    disabled using the UpdateAccountSendingEnabled (https://docs.aws.amazon.com/ses/latest/APIReference/API_UpdateAccountSendingEnabled.html)
	//    operation.
	//
	//    * CONFIGURATION_SET_SENDING_PAUSED: Email sending for this configuration
	//    set was disabled using the UpdateConfigurationSetSendingEnabled (https://docs.aws.amazon.com/ses/latest/APIReference/API_UpdateConfigurationSetSendingEnabled.html)
	//    operation.
	//
	//    * INVALID_PARAMETER_VALUE: One or more of the parameters you specified
	//    when calling this operation was invalid. See the error message for additional
	//    information.
	//
	//    * TRANSIENT_FAILURE: Amazon SES was unable to process your request because
	//    of a temporary issue.
	//
	//    * FAILED: Amazon SES was unable to process your request. See the error
	//    message for additional information.
	Status *string `type:"string" enum:"BulkEmailStatus"`
}

// String returns the string representation
func (s BulkEmailEntryResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BulkEmailEntryResult) GoString() string {
	return s.String()
}

// SetError sets the Error field's value.
func (s *BulkEmailEntryResult) SetError(v string) *BulkEmailEntryResult {
	s.Error = &v
	return s
}

// SetMessageId sets the MessageId field's value.
func (s *BulkEmailEntryResult) SetMessageId(v string) *BulkEmailEntryResult {
	s.MessageId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *BulkEmailEntryResult) SetStatus(v string) *BulkEmailEntryResult {
	s.Status = &v
	return s
}

// An object that defines an Amazon CloudWatch destination for email events.
// You can use Amazon CloudWatch to monitor and gain insights on your email
// sending metrics.
type CloudWatchDestination struct {
	_ struct{} `type:"structure"`

	// An array of objects that define the dimensions to use when you send email
	// events to Amazon CloudWatch.
	//
	// DimensionConfigurations is a required field
	DimensionConfigurations []*CloudWatchDimensionConfiguration `type:"list" required:"true"`
}

// String returns the string representation
func (s CloudWatchDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloudWatchDestination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudWatchDestination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloudWatchDestination"}
	if s.DimensionConfigurations == nil {
		invalidParams.Add(request.NewErrParamRequired("DimensionConfigurations"))
	}
	if s.DimensionConfigurations != nil {
		for i, v := range s.DimensionConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DimensionConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDimensionConfigurations sets the DimensionConfigurations field's value.
func (s *CloudWatchDestination) SetDimensionConfigurations(v []*CloudWatchDimensionConfiguration) *CloudWatchDestination {
	s.DimensionConfigurations = v
	return s
}

// An object that defines the dimension configuration to use when you send email
// events to Amazon CloudWatch.
type CloudWatchDimensionConfiguration struct {
	_ struct{} `type:"structure"`

	// The default value of the dimension that is published to Amazon CloudWatch
	// if you don't provide the value of the dimension when you send an email. This
	// value has to meet the following criteria:
	//
	//    * It can only contain ASCII letters (a–z, A–Z), numbers (0–9), underscores
	//    (_), or dashes (-).
	//
	//    * It can contain no more than 256 characters.
	//
	// DefaultDimensionValue is a required field
	DefaultDimensionValue *string `type:"string" required:"true"`

	// The name of an Amazon CloudWatch dimension associated with an email sending
	// metric. The name has to meet the following criteria:
	//
	//    * It can only contain ASCII letters (a–z, A–Z), numbers (0–9), underscores
	//    (_), or dashes (-).
	//
	//    * It can contain no more than 256 characters.
	//
	// DimensionName is a required field
	DimensionName *string `type:"string" required:"true"`

	// The location where the Amazon SES API v2 finds the value of a dimension to
	// publish to Amazon CloudWatch. If you want to use the message tags that you
	// specify using an X-SES-MESSAGE-TAGS header or a parameter to the SendEmail
	// or SendRawEmail API, choose messageTag. If you want to use your own email
	// headers, choose emailHeader. If you want to use link tags, choose linkTags.
	//
	// DimensionValueSource is a required field
	DimensionValueSource *string `type:"string" required:"true" enum:"DimensionValueSource"`
}

// String returns the string representation
func (s CloudWatchDimensionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloudWatchDimensionConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudWatchDimensionConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloudWatchDimensionConfiguration"}
	if s.DefaultDimensionValue == nil {
		invalidParams.Add(request.NewErrParamRequired("DefaultDimensionValue"))
	}
	if s.DimensionName == nil {
		invalidParams.Add(request.NewErrParamRequired("DimensionName"))
	}
	if s.DimensionValueSource == nil {
		invalidParams.Add(request.NewErrParamRequired("DimensionValueSource"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefaultDimensionValue sets the DefaultDimensionValue field's value.
func (s *CloudWatchDimensionConfiguration) SetDefaultDimensionValue(v string) *CloudWatchDimensionConfiguration {
	s.DefaultDimensionValue = &v
	return s
}

// SetDimensionName sets the DimensionName field's value.
func (s *CloudWatchDimensionConfiguration) SetDimensionName(v string) *CloudWatchDimensionConfiguration {
	s.DimensionName = &v
	return s
}

// SetDimensionValueSource sets the DimensionValueSource field's value.
func (s *CloudWatchDimensionConfiguration) SetDimensionValueSource(v string) *CloudWatchDimensionConfiguration {
	s.DimensionValueSource = &v
	return s
}

// The resource is being modified by another operation or thread.
type ConcurrentModificationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ConcurrentModificationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConcurrentModificationException) GoString() string {
	return s.String()
}

func newErrorConcurrentModificationException(v protocol.ResponseMetadata) error {
	return &ConcurrentModificationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConcurrentModificationException) Code() string {
	return "ConcurrentModificationException"
}

// Message returns the exception's message.
func (s *ConcurrentModificationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConcurrentModificationException) OrigErr() error {
	return nil
}

func (s *ConcurrentModificationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConcurrentModificationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConcurrentModificationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// If there is already an ongoing account details update under review.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object that represents the content of the email, and optionally a character
// set specification.
type Content struct {
	_ struct{} `type:"structure"`

	// The character set for the content. Because of the constraints of the SMTP
	// protocol, Amazon SES uses 7-bit ASCII by default. If the text includes characters
	// outside of the ASCII range, you have to specify a character set. For example,
	// you could specify UTF-8, ISO-8859-1, or Shift_JIS.
	Charset *string `type:"string"`

	// The content of the message itself.
	//
	// Data is a required field
	Data *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Content) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Content) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Content) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Content"}
	if s.Data == nil {
		invalidParams.Add(request.NewErrParamRequired("Data"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCharset sets the Charset field's value.
func (s *Content) SetCharset(v string) *Content {
	s.Charset = &v
	return s
}

// SetData sets the Data field's value.
func (s *Content) SetData(v string) *Content {
	s.Data = &v
	return s
}

// A request to add an event destination to a configuration set.
type CreateConfigurationSetEventDestinationInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set that you want to add an event destination
	// to.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `location:"uri" locationName:"ConfigurationSetName" type:"string" required:"true"`

	// An object that defines the event destination.
	//
	// EventDestination is a required field
	EventDestination *EventDestinationDefinition `type:"structure" required:"true"`

	// A name that identifies the event destination within the configuration set.
	//
	// EventDestinationName is a required field
	EventDestinationName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateConfigurationSetEventDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateConfigurationSetEventDestinationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConfigurationSetEventDestinationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateConfigurationSetEventDestinationInput"}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}
	if s.ConfigurationSetName != nil && len(*s.ConfigurationSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationSetName", 1))
	}
	if s.EventDestination == nil {
		invalidParams.Add(request.NewErrParamRequired("EventDestination"))
	}
	if s.EventDestinationName == nil {
		invalidParams.Add(request.NewErrParamRequired("EventDestinationName"))
	}
	if s.EventDestination != nil {
		if err := s.EventDestination.Validate(); err != nil {
			invalidParams.AddNested("EventDestination", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *CreateConfigurationSetEventDestinationInput) SetConfigurationSetName(v string) *CreateConfigurationSetEventDestinationInput {
	s.ConfigurationSetName = &v
	return s
}

// SetEventDestination sets the EventDestination field's value.
func (s *CreateConfigurationSetEventDestinationInput) SetEventDestination(v *EventDestinationDefinition) *CreateConfigurationSetEventDestinationInput {
	s.EventDestination = v
	return s
}

// SetEventDestinationName sets the EventDestinationName field's value.
func (s *CreateConfigurationSetEventDestinationInput) SetEventDestinationName(v string) *CreateConfigurationSetEventDestinationInput {
	s.EventDestinationName = &v
	return s
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type CreateConfigurationSetEventDestinationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateConfigurationSetEventDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateConfigurationSetEventDestinationOutput) GoString() string {
	return s.String()
}

// A request to create a configuration set.
type CreateConfigurationSetInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `type:"string" required:"true"`

	// An object that defines the dedicated IP pool that is used to send emails
	// that you send using the configuration set.
	DeliveryOptions *DeliveryOptions `type:"structure"`

	// An object that defines whether or not Amazon SES collects reputation metrics
	// for the emails that you send that use the configuration set.
	ReputationOptions *ReputationOptions `type:"structure"`

	// An object that defines whether or not Amazon SES can send email that you
	// send using the configuration set.
	SendingOptions *SendingOptions `type:"structure"`

	// An object that contains information about the suppression list preferences
	// for your account.
	SuppressionOptions *SuppressionOptions `type:"structure"`

	// An array of objects that define the tags (keys and values) that you want
	// to associate with the configuration set.
	Tags []*Tag `type:"list"`

	// An object that defines the open and click tracking options for emails that
	// you send using the configuration set.
	TrackingOptions *TrackingOptions `type:"structure"`
}

// String returns the string representation
func (s CreateConfigurationSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateConfigurationSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConfigurationSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateConfigurationSetInput"}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TrackingOptions != nil {
		if err := s.TrackingOptions.Validate(); err != nil {
			invalidParams.AddNested("TrackingOptions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *CreateConfigurationSetInput) SetConfigurationSetName(v string) *CreateConfigurationSetInput {
	s.ConfigurationSetName = &v
	return s
}

// SetDeliveryOptions sets the DeliveryOptions field's value.
func (s *CreateConfigurationSetInput) SetDeliveryOptions(v *DeliveryOptions) *CreateConfigurationSetInput {
	s.DeliveryOptions = v
	return s
}

// SetReputationOptions sets the ReputationOptions field's value.
func (s *CreateConfigurationSetInput) SetReputationOptions(v *ReputationOptions) *CreateConfigurationSetInput {
	s.ReputationOptions = v
	return s
}

// SetSendingOptions sets the SendingOptions field's value.
func (s *CreateConfigurationSetInput) SetSendingOptions(v *SendingOptions) *CreateConfigurationSetInput {
	s.SendingOptions = v
	return s
}

// SetSuppressionOptions sets the SuppressionOptions field's value.
func (s *CreateConfigurationSetInput) SetSuppressionOptions(v *SuppressionOptions) *CreateConfigurationSetInput {
	s.SuppressionOptions = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateConfigurationSetInput) SetTags(v []*Tag) *CreateConfigurationSetInput {
	s.Tags = v
	return s
}

// SetTrackingOptions sets the TrackingOptions field's value.
func (s *CreateConfigurationSetInput) SetTrackingOptions(v *TrackingOptions) *CreateConfigurationSetInput {
	s.TrackingOptions = v
	return s
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type CreateConfigurationSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateConfigurationSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateConfigurationSetOutput) GoString() string {
	return s.String()
}

// Represents a request to create a custom verification email template.
type CreateCustomVerificationEmailTemplateInput struct {
	_ struct{} `type:"structure"`

	// The URL that the recipient of the verification email is sent to if his or
	// her address is not successfully verified.
	//
	// FailureRedirectionURL is a required field
	FailureRedirectionURL *string `type:"string" required:"true"`

	// The email address that the custom verification email is sent from.
	//
	// FromEmailAddress is a required field
	FromEmailAddress *string `type:"string" required:"true"`

	// The URL that the recipient of the verification email is sent to if his or
	// her address is successfully verified.
	//
	// SuccessRedirectionURL is a required field
	SuccessRedirectionURL *string `type:"string" required:"true"`

	// The content of the custom verification email. The total size of the email
	// must be less than 10 MB. The message body may contain HTML, with some limitations.
	// For more information, see Custom Verification Email Frequently Asked Questions
	// (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html#custom-verification-emails-faq)
	// in the Amazon SES Developer Guide.
	//
	// TemplateContent is a required field
	TemplateContent *string `type:"string" required:"true"`

	// The name of the custom verification email template.
	//
	// TemplateName is a required field
	TemplateName *string `min:"1" type:"string" required:"true"`

	// The subject line of the custom verification email.
	//
	// TemplateSubject is a required field
	TemplateSubject *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateCustomVerificationEmailTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCustomVerificationEmailTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCustomVerificationEmailTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCustomVerificationEmailTemplateInput"}
	if s.FailureRedirectionURL == nil {
		invalidParams.Add(request.NewErrParamRequired("FailureRedirectionURL"))
	}
	if s.FromEmailAddress == nil {
		invalidParams.Add(request.NewErrParamRequired("FromEmailAddress"))
	}
	if s.SuccessRedirectionURL == nil {
		invalidParams.Add(request.NewErrParamRequired("SuccessRedirectionURL"))
	}
	if s.TemplateContent == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateContent"))
	}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}
	if s.TemplateSubject == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateSubject"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFailureRedirectionURL sets the FailureRedirectionURL field's value.
func (s *CreateCustomVerificationEmailTemplateInput) SetFailureRedirectionURL(v string) *CreateCustomVerificationEmailTemplateInput {
	s.FailureRedirectionURL = &v
	return s
}

// SetFromEmailAddress sets the FromEmailAddress field's value.
func (s *CreateCustomVerificationEmailTemplateInput) SetFromEmailAddress(v string) *CreateCustomVerificationEmailTemplateInput {
	s.FromEmailAddress = &v
	return s
}

// SetSuccessRedirectionURL sets the SuccessRedirectionURL field's value.
func (s *CreateCustomVerificationEmailTemplateInput) SetSuccessRedirectionURL(v string) *CreateCustomVerificationEmailTemplateInput {
	s.SuccessRedirectionURL = &v
	return s
}

// SetTemplateContent sets the TemplateContent field's value.
func (s *CreateCustomVerificationEmailTemplateInput) SetTemplateContent(v string) *CreateCustomVerificationEmailTemplateInput {
	s.TemplateContent = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *CreateCustomVerificationEmailTemplateInput) SetTemplateName(v string) *CreateCustomVerificationEmailTemplateInput {
	s.TemplateName = &v
	return s
}

// SetTemplateSubject sets the TemplateSubject field's value.
func (s *CreateCustomVerificationEmailTemplateInput) SetTemplateSubject(v string) *CreateCustomVerificationEmailTemplateInput {
	s.TemplateSubject = &v
	return s
}

// If the action is successful, the service sends back an HTTP 200 response
// with an empty HTTP body.
type CreateCustomVerificationEmailTemplateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateCustomVerificationEmailTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCustomVerificationEmailTemplateOutput) GoString() string {
	return s.String()
}

// A request to create a new dedicated IP pool.
type CreateDedicatedIpPoolInput struct {
	_ struct{} `type:"structure"`

	// The name of the dedicated IP pool.
	//
	// PoolName is a required field
	PoolName *string `type:"string" required:"true"`

	// An object that defines the tags (keys and values) that you want to associate
	// with the pool.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreateDedicatedIpPoolInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDedicatedIpPoolInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDedicatedIpPoolInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDedicatedIpPoolInput"}
	if s.PoolName == nil {
		invalidParams.Add(request.NewErrParamRequired("PoolName"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPoolName sets the PoolName field's value.
func (s *CreateDedicatedIpPoolInput) SetPoolName(v string) *CreateDedicatedIpPoolInput {
	s.PoolName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDedicatedIpPoolInput) SetTags(v []*Tag) *CreateDedicatedIpPoolInput {
	s.Tags = v
	return s
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type CreateDedicatedIpPoolOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateDedicatedIpPoolOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDedicatedIpPoolOutput) GoString() string {
	return s.String()
}

// A request to perform a predictive inbox placement test. Predictive inbox
// placement tests can help you predict how your messages will be handled by
// various email providers around the world. When you perform a predictive inbox
// placement test, you provide a sample message that contains the content that
// you plan to send to your customers. We send that message to special email
// addresses spread across several major email providers around the world. The
// test takes about 24 hours to complete. When the test is complete, you can
// use the GetDeliverabilityTestReport operation to view the results of the
// test.
type CreateDeliverabilityTestReportInput struct {
	_ struct{} `type:"structure"`

	// The HTML body of the message that you sent when you performed the predictive
	// inbox placement test.
	//
	// Content is a required field
	Content *EmailContent `type:"structure" required:"true"`

	// The email address that the predictive inbox placement test email was sent
	// from.
	//
	// FromEmailAddress is a required field
	FromEmailAddress *string `type:"string" required:"true"`

	// A unique name that helps you to identify the predictive inbox placement test
	// when you retrieve the results.
	ReportName *string `type:"string"`

	// An array of objects that define the tags (keys and values) that you want
	// to associate with the predictive inbox placement test.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreateDeliverabilityTestReportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDeliverabilityTestReportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDeliverabilityTestReportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDeliverabilityTestReportInput"}
	if s.Content == nil {
		invalidParams.Add(request.NewErrParamRequired("Content"))
	}
	if s.FromEmailAddress == nil {
		invalidParams.Add(request.NewErrParamRequired("FromEmailAddress"))
	}
	if s.Content != nil {
		if err := s.Content.Validate(); err != nil {
			invalidParams.AddNested("Content", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContent sets the Content field's value.
func (s *CreateDeliverabilityTestReportInput) SetContent(v *EmailContent) *CreateDeliverabilityTestReportInput {
	s.Content = v
	return s
}

// SetFromEmailAddress sets the FromEmailAddress field's value.
func (s *CreateDeliverabilityTestReportInput) SetFromEmailAddress(v string) *CreateDeliverabilityTestReportInput {
	s.FromEmailAddress = &v
	return s
}

// SetReportName sets the ReportName field's value.
func (s *CreateDeliverabilityTestReportInput) SetReportName(v string) *CreateDeliverabilityTestReportInput {
	s.ReportName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDeliverabilityTestReportInput) SetTags(v []*Tag) *CreateDeliverabilityTestReportInput {
	s.Tags = v
	return s
}

// Information about the predictive inbox placement test that you created.
type CreateDeliverabilityTestReportOutput struct {
	_ struct{} `type:"structure"`

	// The status of the predictive inbox placement test. If the status is IN_PROGRESS,
	// then the predictive inbox placement test is currently running. Predictive
	// inbox placement tests are usually complete within 24 hours of creating the
	// test. If the status is COMPLETE, then the test is finished, and you can use
	// the GetDeliverabilityTestReport to view the results of the test.
	//
	// DeliverabilityTestStatus is a required field
	DeliverabilityTestStatus *string `type:"string" required:"true" enum:"DeliverabilityTestStatus"`

	// A unique string that identifies the predictive inbox placement test.
	//
	// ReportId is a required field
	ReportId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateDeliverabilityTestReportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDeliverabilityTestReportOutput) GoString() string {
	return s.String()
}

// SetDeliverabilityTestStatus sets the DeliverabilityTestStatus field's value.
func (s *CreateDeliverabilityTestReportOutput) SetDeliverabilityTestStatus(v string) *CreateDeliverabilityTestReportOutput {
	s.DeliverabilityTestStatus = &v
	return s
}

// SetReportId sets the ReportId field's value.
func (s *CreateDeliverabilityTestReportOutput) SetReportId(v string) *CreateDeliverabilityTestReportOutput {
	s.ReportId = &v
	return s
}

// A request to begin the verification process for an email identity (an email
// address or domain).
type CreateEmailIdentityInput struct {
	_ struct{} `type:"structure"`

	// If your request includes this object, Amazon SES configures the identity
	// to use Bring Your Own DKIM (BYODKIM) for DKIM authentication purposes, as
	// opposed to the default method, Easy DKIM (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html).
	//
	// You can only specify this object if the email identity is a domain, as opposed
	// to an address.
	DkimSigningAttributes *DkimSigningAttributes `type:"structure"`

	// The email address or domain that you want to verify.
	//
	// EmailIdentity is a required field
	EmailIdentity *string `min:"1" type:"string" required:"true"`

	// An array of objects that define the tags (keys and values) that you want
	// to associate with the email identity.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreateEmailIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEmailIdentityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEmailIdentityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEmailIdentityInput"}
	if s.EmailIdentity == nil {
		invalidParams.Add(request.NewErrParamRequired("EmailIdentity"))
	}
	if s.EmailIdentity != nil && len(*s.EmailIdentity) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EmailIdentity", 1))
	}
	if s.DkimSigningAttributes != nil {
		if err := s.DkimSigningAttributes.Validate(); err != nil {
			invalidParams.AddNested("DkimSigningAttributes", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDkimSigningAttributes sets the DkimSigningAttributes field's value.
func (s *CreateEmailIdentityInput) SetDkimSigningAttributes(v *DkimSigningAttributes) *CreateEmailIdentityInput {
	s.DkimSigningAttributes = v
	return s
}

// SetEmailIdentity sets the EmailIdentity field's value.
func (s *CreateEmailIdentityInput) SetEmailIdentity(v string) *CreateEmailIdentityInput {
	s.EmailIdentity = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateEmailIdentityInput) SetTags(v []*Tag) *CreateEmailIdentityInput {
	s.Tags = v
	return s
}

// If the email identity is a domain, this object contains information about
// the DKIM verification status for the domain.
//
// If the email identity is an email address, this object is empty.
type CreateEmailIdentityOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains information about the DKIM attributes for the identity.
	DkimAttributes *DkimAttributes `type:"structure"`

	// The email identity type.
	IdentityType *string `type:"string" enum:"IdentityType"`

	// Specifies whether or not the identity is verified. You can only send email
	// from verified email addresses or domains. For more information about verifying
	// identities, see the Amazon Pinpoint User Guide (https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-email-manage-verify.html).
	VerifiedForSendingStatus *bool `type:"boolean"`
}

// String returns the string representation
func (s CreateEmailIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEmailIdentityOutput) GoString() string {
	return s.String()
}

// SetDkimAttributes sets the DkimAttributes field's value.
func (s *CreateEmailIdentityOutput) SetDkimAttributes(v *DkimAttributes) *CreateEmailIdentityOutput {
	s.DkimAttributes = v
	return s
}

// SetIdentityType sets the IdentityType field's value.
func (s *CreateEmailIdentityOutput) SetIdentityType(v string) *CreateEmailIdentityOutput {
	s.IdentityType = &v
	return s
}

// SetVerifiedForSendingStatus sets the VerifiedForSendingStatus field's value.
func (s *CreateEmailIdentityOutput) SetVerifiedForSendingStatus(v bool) *CreateEmailIdentityOutput {
	s.VerifiedForSendingStatus = &v
	return s
}

// Represents a request to create a sending authorization policy for an identity.
// Sending authorization is an Amazon SES feature that enables you to authorize
// other senders to use your identities. For information, see the Amazon SES
// Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-identity-owner-tasks-management.html).
type CreateEmailIdentityPolicyInput struct {
	_ struct{} `type:"structure"`

	// The email identity for which you want to create a policy.
	//
	// EmailIdentity is a required field
	EmailIdentity *string `location:"uri" locationName:"EmailIdentity" min:"1" type:"string" required:"true"`

	// The text of the policy in JSON format. The policy cannot exceed 4 KB.
	//
	// For information about the syntax of sending authorization policies, see the
	// Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-policies.html).
	//
	// Policy is a required field
	Policy *string `min:"1" type:"string" required:"true"`

	// The name of the policy.
	//
	// The policy name cannot exceed 64 characters and can only include alphanumeric
	// characters, dashes, and underscores.
	//
	// PolicyName is a required field
	PolicyName *string `location:"uri" locationName:"PolicyName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateEmailIdentityPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEmailIdentityPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEmailIdentityPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEmailIdentityPolicyInput"}
	if s.EmailIdentity == nil {
		invalidParams.Add(request.NewErrParamRequired("EmailIdentity"))
	}
	if s.EmailIdentity != nil && len(*s.EmailIdentity) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EmailIdentity", 1))
	}
	if s.Policy == nil {
		invalidParams.Add(request.NewErrParamRequired("Policy"))
	}
	if s.Policy != nil && len(*s.Policy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Policy", 1))
	}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEmailIdentity sets the EmailIdentity field's value.
func (s *CreateEmailIdentityPolicyInput) SetEmailIdentity(v string) *CreateEmailIdentityPolicyInput {
	s.EmailIdentity = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *CreateEmailIdentityPolicyInput) SetPolicy(v string) *CreateEmailIdentityPolicyInput {
	s.Policy = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *CreateEmailIdentityPolicyInput) SetPolicyName(v string) *CreateEmailIdentityPolicyInput {
	s.PolicyName = &v
	return s
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type CreateEmailIdentityPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateEmailIdentityPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEmailIdentityPolicyOutput) GoString() string {
	return s.String()
}

// Represents a request to create an email template. For more information, see
// the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html).
type CreateEmailTemplateInput struct {
	_ struct{} `type:"structure"`

	// The content of the email template, composed of a subject line, an HTML part,
	// and a text-only part.
	//
	// TemplateContent is a required field
	TemplateContent *EmailTemplateContent `type:"structure" required:"true"`

	// The name of the template you want to create.
	//
	// TemplateName is a required field
	TemplateName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateEmailTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEmailTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEmailTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEmailTemplateInput"}
	if s.TemplateContent == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateContent"))
	}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTemplateContent sets the TemplateContent field's value.
func (s *CreateEmailTemplateInput) SetTemplateContent(v *EmailTemplateContent) *CreateEmailTemplateInput {
	s.TemplateContent = v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *CreateEmailTemplateInput) SetTemplateName(v string) *CreateEmailTemplateInput {
	s.TemplateName = &v
	return s
}

// If the action is successful, the service sends back an HTTP 200 response
// with an empty HTTP body.
type CreateEmailTemplateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateEmailTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEmailTemplateOutput) GoString() string {
	return s.String()
}

// Represents a request to create an import job from a data source for a data
// destination.
type CreateImportJobInput struct {
	_ struct{} `type:"structure"`

	// The data source for the import job.
	//
	// ImportDataSource is a required field
	ImportDataSource *ImportDataSource `type:"structure" required:"true"`

	// The destination for the import job.
	//
	// ImportDestination is a required field
	ImportDestination *ImportDestination `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateImportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateImportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateImportJobInput"}
	if s.ImportDataSource == nil {
		invalidParams.Add(request.NewErrParamRequired("ImportDataSource"))
	}
	if s.ImportDestination == nil {
		invalidParams.Add(request.NewErrParamRequired("ImportDestination"))
	}
	if s.ImportDataSource != nil {
		if err := s.ImportDataSource.Validate(); err != nil {
			invalidParams.AddNested("ImportDataSource", err.(request.ErrInvalidParams))
		}
	}
	if s.ImportDestination != nil {
		if err := s.ImportDestination.Validate(); err != nil {
			invalidParams.AddNested("ImportDestination", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetImportDataSource sets the ImportDataSource field's value.
func (s *CreateImportJobInput) SetImportDataSource(v *ImportDataSource) *CreateImportJobInput {
	s.ImportDataSource = v
	return s
}

// SetImportDestination sets the ImportDestination field's value.
func (s *CreateImportJobInput) SetImportDestination(v *ImportDestination) *CreateImportJobInput {
	s.ImportDestination = v
	return s
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type CreateImportJobOutput struct {
	_ struct{} `type:"structure"`

	// A string that represents the import job ID.
	JobId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateImportJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *CreateImportJobOutput) SetJobId(v string) *CreateImportJobOutput {
	s.JobId = &v
	return s
}

// Contains information about a custom verification email template.
type CustomVerificationEmailTemplateMetadata struct {
	_ struct{} `type:"structure"`

	// The URL that the recipient of the verification email is sent to if his or
	// her address is not successfully verified.
	FailureRedirectionURL *string `type:"string"`

	// The email address that the custom verification email is sent from.
	FromEmailAddress *string `type:"string"`

	// The URL that the recipient of the verification email is sent to if his or
	// her address is successfully verified.
	SuccessRedirectionURL *string `type:"string"`

	// The name of the custom verification email template.
	TemplateName *string `min:"1" type:"string"`

	// The subject line of the custom verification email.
	TemplateSubject *string `type:"string"`
}

// String returns the string representation
func (s CustomVerificationEmailTemplateMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomVerificationEmailTemplateMetadata) GoString() string {
	return s.String()
}

// SetFailureRedirectionURL sets the FailureRedirectionURL field's value.
func (s *CustomVerificationEmailTemplateMetadata) SetFailureRedirectionURL(v string) *CustomVerificationEmailTemplateMetadata {
	s.FailureRedirectionURL = &v
	return s
}

// SetFromEmailAddress sets the FromEmailAddress field's value.
func (s *CustomVerificationEmailTemplateMetadata) SetFromEmailAddress(v string) *CustomVerificationEmailTemplateMetadata {
	s.FromEmailAddress = &v
	return s
}

// SetSuccessRedirectionURL sets the SuccessRedirectionURL field's value.
func (s *CustomVerificationEmailTemplateMetadata) SetSuccessRedirectionURL(v string) *CustomVerificationEmailTemplateMetadata {
	s.SuccessRedirectionURL = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *CustomVerificationEmailTemplateMetadata) SetTemplateName(v string) *CustomVerificationEmailTemplateMetadata {
	s.TemplateName = &v
	return s
}

// SetTemplateSubject sets the TemplateSubject field's value.
func (s *CustomVerificationEmailTemplateMetadata) SetTemplateSubject(v string) *CustomVerificationEmailTemplateMetadata {
	s.TemplateSubject = &v
	return s
}

// An object that contains information about the volume of email sent on each
// day of the analysis period.
type DailyVolume struct {
	_ struct{} `type:"structure"`

	// An object that contains inbox placement metrics for a specified day in the
	// analysis period, broken out by the recipient's email provider.
	DomainIspPlacements []*DomainIspPlacement `type:"list"`

	// The date that the DailyVolume metrics apply to, in Unix time.
	StartDate *time.Time `type:"timestamp"`

	// An object that contains inbox placement metrics for a specific day in the
	// analysis period.
	VolumeStatistics *VolumeStatistics `type:"structure"`
}

// String returns the string representation
func (s DailyVolume) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DailyVolume) GoString() string {
	return s.String()
}

// SetDomainIspPlacements sets the DomainIspPlacements field's value.
func (s *DailyVolume) SetDomainIspPlacements(v []*DomainIspPlacement) *DailyVolume {
	s.DomainIspPlacements = v
	return s
}

// SetStartDate sets the StartDate field's value.
func (s *DailyVolume) SetStartDate(v time.Time) *DailyVolume {
	s.StartDate = &v
	return s
}

// SetVolumeStatistics sets the VolumeStatistics field's value.
func (s *DailyVolume) SetVolumeStatistics(v *VolumeStatistics) *DailyVolume {
	s.VolumeStatistics = v
	return s
}

// Contains information about a dedicated IP address that is associated with
// your Amazon SES account.
//
// To learn more about requesting dedicated IP addresses, see Requesting and
// Relinquishing Dedicated IP Addresses (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/dedicated-ip-case.html)
// in the Amazon SES Developer Guide.
type DedicatedIp struct {
	_ struct{} `type:"structure"`

	// An IPv4 address.
	//
	// Ip is a required field
	Ip *string `type:"string" required:"true"`

	// The name of the dedicated IP pool that the IP address is associated with.
	PoolName *string `type:"string"`

	// Indicates how complete the dedicated IP warm-up process is. When this value
	// equals 1, the address has completed the warm-up process and is ready for
	// use.
	//
	// WarmupPercentage is a required field
	WarmupPercentage *int64 `type:"integer" required:"true"`

	// The warm-up status of a dedicated IP address. The status can have one of
	// the following values:
	//
	//    * IN_PROGRESS – The IP address isn't ready to use because the dedicated
	//    IP warm-up process is ongoing.
	//
	//    * DONE – The dedicated IP warm-up process is complete, and the IP address
	//    is ready to use.
	//
	// WarmupStatus is a required field
	WarmupStatus *string `type:"string" required:"true" enum:"WarmupStatus"`
}

// String returns the string representation
func (s DedicatedIp) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DedicatedIp) GoString() string {
	return s.String()
}

// SetIp sets the Ip field's value.
func (s *DedicatedIp) SetIp(v string) *DedicatedIp {
	s.Ip = &v
	return s
}

// SetPoolName sets the PoolName field's value.
func (s *DedicatedIp) SetPoolName(v string) *DedicatedIp {
	s.PoolName = &v
	return s
}

// SetWarmupPercentage sets the WarmupPercentage field's value.
func (s *DedicatedIp) SetWarmupPercentage(v int64) *DedicatedIp {
	s.WarmupPercentage = &v
	return s
}

// SetWarmupStatus sets the WarmupStatus field's value.
func (s *DedicatedIp) SetWarmupStatus(v string) *DedicatedIp {
	s.WarmupStatus = &v
	return s
}

// A request to delete an event destination from a configuration set.
type DeleteConfigurationSetEventDestinationInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set that contains the event destination that
	// you want to delete.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `location:"uri" locationName:"ConfigurationSetName" type:"string" required:"true"`

	// The name of the event destination that you want to delete.
	//
	// EventDestinationName is a required field
	EventDestinationName *string `location:"uri" locationName:"EventDestinationName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteConfigurationSetEventDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteConfigurationSetEventDestinationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConfigurationSetEventDestinationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConfigurationSetEventDestinationInput"}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}
	if s.ConfigurationSetName != nil && len(*s.ConfigurationSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationSetName", 1))
	}
	if s.EventDestinationName == nil {
		invalidParams.Add(request.NewErrParamRequired("EventDestinationName"))
	}
	if s.EventDestinationName != nil && len(*s.EventDestinationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventDestinationName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *DeleteConfigurationSetEventDestinationInput) SetConfigurationSetName(v string) *DeleteConfigurationSetEventDestinationInput {
	s.ConfigurationSetName = &v
	return s
}

// SetEventDestinationName sets the EventDestinationName field's value.
func (s *DeleteConfigurationSetEventDestinationInput) SetEventDestinationName(v string) *DeleteConfigurationSetEventDestinationInput {
	s.EventDestinationName = &v
	return s
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type DeleteConfigurationSetEventDestinationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteConfigurationSetEventDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteConfigurationSetEventDestinationOutput) GoString() string {
	return s.String()
}

// A request to delete a configuration set.
type DeleteConfigurationSetInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set that you want to delete.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `location:"uri" locationName:"ConfigurationSetName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteConfigurationSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteConfigurationSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConfigurationSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConfigurationSetInput"}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}
	if s.ConfigurationSetName != nil && len(*s.ConfigurationSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationSetName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *DeleteConfigurationSetInput) SetConfigurationSetName(v string) *DeleteConfigurationSetInput {
	s.ConfigurationSetName = &v
	return s
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type DeleteConfigurationSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteConfigurationSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteConfigurationSetOutput) GoString() string {
	return s.String()
}

// Represents a request to delete an existing custom verification email template.
type DeleteCustomVerificationEmailTemplateInput struct {
	_ struct{} `type:"structure"`

	// The name of the custom verification email template that you want to delete.
	//
	// TemplateName is a required field
	TemplateName *string `location:"uri" locationName:"TemplateName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteCustomVerificationEmailTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCustomVerificationEmailTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCustomVerificationEmailTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCustomVerificationEmailTemplateInput"}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTemplateName sets the TemplateName field's value.
func (s *DeleteCustomVerificationEmailTemplateInput) SetTemplateName(v string) *DeleteCustomVerificationEmailTemplateInput {
	s.TemplateName = &v
	return s
}

// If the action is successful, the service sends back an HTTP 200 response
// with an empty HTTP body.
type DeleteCustomVerificationEmailTemplateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteCustomVerificationEmailTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCustomVerificationEmailTemplateOutput) GoString() string {
	return s.String()
}

// A request to delete a dedicated IP pool.
type DeleteDedicatedIpPoolInput struct {
	_ struct{} `type:"structure"`

	// The name of the dedicated IP pool that you want to delete.
	//
	// PoolName is a required field
	PoolName *string `location:"uri" locationName:"PoolName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDedicatedIpPoolInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDedicatedIpPoolInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDedicatedIpPoolInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDedicatedIpPoolInput"}
	if s.PoolName == nil {
		invalidParams.Add(request.NewErrParamRequired("PoolName"))
	}
	if s.PoolName != nil && len(*s.PoolName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PoolName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPoolName sets the PoolName field's value.
func (s *DeleteDedicatedIpPoolInput) SetPoolName(v string) *DeleteDedicatedIpPoolInput {
	s.PoolName = &v
	return s
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type DeleteDedicatedIpPoolOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDedicatedIpPoolOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDedicatedIpPoolOutput) GoString() string {
	return s.String()
}

// A request to delete an existing email identity. When you delete an identity,
// you lose the ability to send email from that identity. You can restore your
// ability to send email by completing the verification process for the identity
// again.
type DeleteEmailIdentityInput struct {
	_ struct{} `type:"structure"`

	// The identity (that is, the email address or domain) that you want to delete.
	//
	// EmailIdentity is a required field
	EmailIdentity *string `location:"uri" locationName:"EmailIdentity" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEmailIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEmailIdentityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEmailIdentityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEmailIdentityInput"}
	if s.EmailIdentity == nil {
		invalidParams.Add(request.NewErrParamRequired("EmailIdentity"))
	}
	if s.EmailIdentity != nil && len(*s.EmailIdentity) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EmailIdentity", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEmailIdentity sets the EmailIdentity field's value.
func (s *DeleteEmailIdentityInput) SetEmailIdentity(v string) *DeleteEmailIdentityInput {
	s.EmailIdentity = &v
	return s
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type DeleteEmailIdentityOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteEmailIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEmailIdentityOutput) GoString() string {
	return s.String()
}

// Represents a request to delete a sending authorization policy for an identity.
// Sending authorization is an Amazon SES feature that enables you to authorize
// other senders to use your identities. For information, see the Amazon SES
// Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-identity-owner-tasks-management.html).
type DeleteEmailIdentityPolicyInput struct {
	_ struct{} `type:"structure"`

	// The email identity for which you want to delete a policy.
	//
	// EmailIdentity is a required field
	EmailIdentity *string `location:"uri" locationName:"EmailIdentity" min:"1" type:"string" required:"true"`

	// The name of the policy.
	//
	// The policy name cannot exceed 64 characters and can only include alphanumeric
	// characters, dashes, and underscores.
	//
	// PolicyName is a required field
	PolicyName *string `location:"uri" locationName:"PolicyName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEmailIdentityPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEmailIdentityPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEmailIdentityPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEmailIdentityPolicyInput"}
	if s.EmailIdentity == nil {
		invalidParams.Add(request.NewErrParamRequired("EmailIdentity"))
	}
	if s.EmailIdentity != nil && len(*s.EmailIdentity) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EmailIdentity", 1))
	}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEmailIdentity sets the EmailIdentity field's value.
func (s *DeleteEmailIdentityPolicyInput) SetEmailIdentity(v string) *DeleteEmailIdentityPolicyInput {
	s.EmailIdentity = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *DeleteEmailIdentityPolicyInput) SetPolicyName(v string) *DeleteEmailIdentityPolicyInput {
	s.PolicyName = &v
	return s
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type DeleteEmailIdentityPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteEmailIdentityPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEmailIdentityPolicyOutput) GoString() string {
	return s.String()
}

// Represents a request to delete an email template. For more information, see
// the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html).
type DeleteEmailTemplateInput struct {
	_ struct{} `type:"structure"`

	// The name of the template to be deleted.
	//
	// TemplateName is a required field
	TemplateName *string `location:"uri" locationName:"TemplateName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEmailTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEmailTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEmailTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEmailTemplateInput"}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTemplateName sets the TemplateName field's value.
func (s *DeleteEmailTemplateInput) SetTemplateName(v string) *DeleteEmailTemplateInput {
	s.TemplateName = &v
	return s
}

// If the action is successful, the service sends back an HTTP 200 response
// with an empty HTTP body.
type DeleteEmailTemplateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteEmailTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEmailTemplateOutput) GoString() string {
	return s.String()
}

// A request to remove an email address from the suppression list for your account.
type DeleteSuppressedDestinationInput struct {
	_ struct{} `type:"structure"`

	// The suppressed email destination to remove from the account suppression list.
	//
	// EmailAddress is a required field
	EmailAddress *string `location:"uri" locationName:"EmailAddress" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSuppressedDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSuppressedDestinationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSuppressedDestinationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSuppressedDestinationInput"}
	if s.EmailAddress == nil {
		invalidParams.Add(request.NewErrParamRequired("EmailAddress"))
	}
	if s.EmailAddress != nil && len(*s.EmailAddress) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EmailAddress", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEmailAddress sets the EmailAddress field's value.
func (s *DeleteSuppressedDestinationInput) SetEmailAddress(v string) *DeleteSuppressedDestinationInput {
	s.EmailAddress = &v
	return s
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type DeleteSuppressedDestinationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSuppressedDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSuppressedDestinationOutput) GoString() string {
	return s.String()
}

// An object that contains metadata related to a predictive inbox placement
// test.
type DeliverabilityTestReport struct {
	_ struct{} `type:"structure"`

	// The date and time when the predictive inbox placement test was created, in
	// Unix time format.
	CreateDate *time.Time `type:"timestamp"`

	// The status of the predictive inbox placement test. If the status is IN_PROGRESS,
	// then the predictive inbox placement test is currently running. Predictive
	// inbox placement tests are usually complete within 24 hours of creating the
	// test. If the status is COMPLETE, then the test is finished, and you can use
	// the GetDeliverabilityTestReport to view the results of the test.
	DeliverabilityTestStatus *string `type:"string" enum:"DeliverabilityTestStatus"`

	// The sender address that you specified for the predictive inbox placement
	// test.
	FromEmailAddress *string `type:"string"`

	// A unique string that identifies the predictive inbox placement test.
	ReportId *string `type:"string"`

	// A name that helps you identify a predictive inbox placement test report.
	ReportName *string `type:"string"`

	// The subject line for an email that you submitted in a predictive inbox placement
	// test.
	Subject *string `type:"string"`
}

// String returns the string representation
func (s DeliverabilityTestReport) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeliverabilityTestReport) GoString() string {
	return s.String()
}

// SetCreateDate sets the CreateDate field's value.
func (s *DeliverabilityTestReport) SetCreateDate(v time.Time) *DeliverabilityTestReport {
	s.CreateDate = &v
	return s
}

// SetDeliverabilityTestStatus sets the DeliverabilityTestStatus field's value.
func (s *DeliverabilityTestReport) SetDeliverabilityTestStatus(v string) *DeliverabilityTestReport {
	s.DeliverabilityTestStatus = &v
	return s
}

// SetFromEmailAddress sets the FromEmailAddress field's value.
func (s *DeliverabilityTestReport) SetFromEmailAddress(v string) *DeliverabilityTestReport {
	s.FromEmailAddress = &v
	return s
}

// SetReportId sets the ReportId field's value.
func (s *DeliverabilityTestReport) SetReportId(v string) *DeliverabilityTestReport {
	s.ReportId = &v
	return s
}

// SetReportName sets the ReportName field's value.
func (s *DeliverabilityTestReport) SetReportName(v string) *DeliverabilityTestReport {
	s.ReportName = &v
	return s
}

// SetSubject sets the Subject field's value.
func (s *DeliverabilityTestReport) SetSubject(v string) *DeliverabilityTestReport {
	s.Subject = &v
	return s
}

// Used to associate a configuration set with a dedicated IP pool.
type DeliveryOptions struct {
	_ struct{} `type:"structure"`

	// The name of the dedicated IP pool that you want to associate with the configuration
	// set.
	SendingPoolName *string `type:"string"`

	// Specifies whether messages that use the configuration set are required to
	// use Transport Layer Security (TLS). If the value is Require, messages are
	// only delivered if a TLS connection can be established. If the value is Optional,
	// messages can be delivered in plain text if a TLS connection can't be established.
	TlsPolicy *string `type:"string" enum:"TlsPolicy"`
}

// String returns the string representation
func (s DeliveryOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeliveryOptions) GoString() string {
	return s.String()
}

// SetSendingPoolName sets the SendingPoolName field's value.
func (s *DeliveryOptions) SetSendingPoolName(v string) *DeliveryOptions {
	s.SendingPoolName = &v
	return s
}

// SetTlsPolicy sets the TlsPolicy field's value.
func (s *DeliveryOptions) SetTlsPolicy(v string) *DeliveryOptions {
	s.TlsPolicy = &v
	return s
}

// An object that describes the recipients for an email.
type Destination struct {
	_ struct{} `type:"structure"`

	// An array that contains the email addresses of the "BCC" (blind carbon copy)
	// recipients for the email.
	BccAddresses []*string `type:"list"`

	// An array that contains the email addresses of the "CC" (carbon copy) recipients
	// for the email.
	CcAddresses []*string `type:"list"`

	// An array that contains the email addresses of the "To" recipients for the
	// email.
	ToAddresses []*string `type:"list"`
}

// String returns the string representation
func (s Destination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Destination) GoString() string {
	return s.String()
}

// SetBccAddresses sets the BccAddresses field's value.
func (s *Destination) SetBccAddresses(v []*string) *Destination {
	s.BccAddresses = v
	return s
}

// SetCcAddresses sets the CcAddresses field's value.
func (s *Destination) SetCcAddresses(v []*string) *Destination {
	s.CcAddresses = v
	return s
}

// SetToAddresses sets the ToAddresses field's value.
func (s *Destination) SetToAddresses(v []*string) *Destination {
	s.ToAddresses = v
	return s
}

// An object that contains information about the DKIM authentication status
// for an email identity.
//
// Amazon SES determines the authentication status by searching for specific
// records in the DNS configuration for the domain. If you used Easy DKIM (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html)
// to set up DKIM authentication, Amazon SES tries to find three unique CNAME
// records in the DNS configuration for your domain. If you provided a public
// key to perform DKIM authentication, Amazon SES tries to find a TXT record
// that uses the selector that you specified. The value of the TXT record must
// be a public key that's paired with the private key that you specified in
// the process of creating the identity
type DkimAttributes struct {
	_ struct{} `type:"structure"`

	// A string that indicates how DKIM was configured for the identity. There are
	// two possible values:
	//
	//    * AWS_SES – Indicates that DKIM was configured for the identity by using
	//    Easy DKIM (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html).
	//
	//    * EXTERNAL – Indicates that DKIM was configured for the identity by
	//    using Bring Your Own DKIM (BYODKIM).
	SigningAttributesOrigin *string `type:"string" enum:"DkimSigningAttributesOrigin"`

	// If the value is true, then the messages that you send from the identity are
	// signed using DKIM. If the value is false, then the messages that you send
	// from the identity aren't DKIM-signed.
	SigningEnabled *bool `type:"boolean"`

	// Describes whether or not Amazon SES has successfully located the DKIM records
	// in the DNS records for the domain. The status can be one of the following:
	//
	//    * PENDING – The verification process was initiated, but Amazon SES hasn't
	//    yet detected the DKIM records in the DNS configuration for the domain.
	//
	//    * SUCCESS – The verification process completed successfully.
	//
	//    * FAILED – The verification process failed. This typically occurs when
	//    Amazon SES fails to find the DKIM records in the DNS configuration of
	//    the domain.
	//
	//    * TEMPORARY_FAILURE – A temporary issue is preventing Amazon SES from
	//    determining the DKIM authentication status of the domain.
	//
	//    * NOT_STARTED – The DKIM verification process hasn't been initiated
	//    for the domain.
	Status *string `type:"string" enum:"DkimStatus"`

	// If you used Easy DKIM (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html)
	// to configure DKIM authentication for the domain, then this object contains
	// a set of unique strings that you use to create a set of CNAME records that
	// you add to the DNS configuration for your domain. When Amazon SES detects
	// these records in the DNS configuration for your domain, the DKIM authentication
	// process is complete.
	//
	// If you configured DKIM authentication for the domain by providing your own
	// public-private key pair, then this object contains the selector for the public
	// key.
	//
	// Regardless of the DKIM authentication method you use, Amazon SES searches
	// for the appropriate records in the DNS configuration of the domain for up
	// to 72 hours.
	Tokens []*string `type:"list"`
}

// String returns the string representation
func (s DkimAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DkimAttributes) GoString() string {
	return s.String()
}

// SetSigningAttributesOrigin sets the SigningAttributesOrigin field's value.
func (s *DkimAttributes) SetSigningAttributesOrigin(v string) *DkimAttributes {
	s.SigningAttributesOrigin = &v
	return s
}

// SetSigningEnabled sets the SigningEnabled field's value.
func (s *DkimAttributes) SetSigningEnabled(v bool) *DkimAttributes {
	s.SigningEnabled = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DkimAttributes) SetStatus(v string) *DkimAttributes {
	s.Status = &v
	return s
}

// SetTokens sets the Tokens field's value.
func (s *DkimAttributes) SetTokens(v []*string) *DkimAttributes {
	s.Tokens = v
	return s
}

// An object that contains information about the tokens used for setting up
// Bring Your Own DKIM (BYODKIM).
type DkimSigningAttributes struct {
	_ struct{} `type:"structure"`

	// A private key that's used to generate a DKIM signature.
	//
	// The private key must use 1024-bit RSA encryption, and must be encoded using
	// base64 encoding.
	//
	// DomainSigningPrivateKey is a required field
	DomainSigningPrivateKey *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// A string that's used to identify a public key in the DNS configuration for
	// a domain.
	//
	// DomainSigningSelector is a required field
	DomainSigningSelector *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DkimSigningAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DkimSigningAttributes) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DkimSigningAttributes) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DkimSigningAttributes"}
	if s.DomainSigningPrivateKey == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainSigningPrivateKey"))
	}
	if s.DomainSigningPrivateKey != nil && len(*s.DomainSigningPrivateKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainSigningPrivateKey", 1))
	}
	if s.DomainSigningSelector == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainSigningSelector"))
	}
	if s.DomainSigningSelector != nil && len(*s.DomainSigningSelector) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainSigningSelector", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainSigningPrivateKey sets the DomainSigningPrivateKey field's value.
func (s *DkimSigningAttributes) SetDomainSigningPrivateKey(v string) *DkimSigningAttributes {
	s.DomainSigningPrivateKey = &v
	return s
}

// SetDomainSigningSelector sets the DomainSigningSelector field's value.
func (s *DkimSigningAttributes) SetDomainSigningSelector(v string) *DkimSigningAttributes {
	s.DomainSigningSelector = &v
	return s
}

// An object that contains the deliverability data for a specific campaign.
// This data is available for a campaign only if the campaign sent email by
// using a domain that the Deliverability dashboard is enabled for (PutDeliverabilityDashboardOption
// operation).
type DomainDeliverabilityCampaign struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the campaign. The Deliverability dashboard automatically
	// generates and assigns this identifier to a campaign.
	CampaignId *string `type:"string"`

	// The percentage of email messages that were deleted by recipients, without
	// being opened first. Due to technical limitations, this value only includes
	// recipients who opened the message by using an email client that supports
	// images.
	DeleteRate *float64 `type:"double"`

	// The major email providers who handled the email message.
	Esps []*string `type:"list"`

	// The first time, in Unix time format, when the email message was delivered
	// to any recipient's inbox. This value can help you determine how long it took
	// for a campaign to deliver an email message.
	FirstSeenDateTime *time.Time `type:"timestamp"`

	// The verified email address that the email message was sent from.
	FromAddress *string `min:"1" type:"string"`

	// The URL of an image that contains a snapshot of the email message that was
	// sent.
	ImageUrl *string `type:"string"`

	// The number of email messages that were delivered to recipients’ inboxes.
	InboxCount *int64 `type:"long"`

	// The last time, in Unix time format, when the email message was delivered
	// to any recipient's inbox. This value can help you determine how long it took
	// for a campaign to deliver an email message.
	LastSeenDateTime *time.Time `type:"timestamp"`

	// The projected number of recipients that the email message was sent to.
	ProjectedVolume *int64 `type:"long"`

	// The percentage of email messages that were opened and then deleted by recipients.
	// Due to technical limitations, this value only includes recipients who opened
	// the message by using an email client that supports images.
	ReadDeleteRate *float64 `type:"double"`

	// The percentage of email messages that were opened by recipients. Due to technical
	// limitations, this value only includes recipients who opened the message by
	// using an email client that supports images.
	ReadRate *float64 `type:"double"`

	// The IP addresses that were used to send the email message.
	SendingIps []*string `type:"list"`

	// The number of email messages that were delivered to recipients' spam or junk
	// mail folders.
	SpamCount *int64 `type:"long"`

	// The subject line, or title, of the email message.
	Subject *string `type:"string"`
}

// String returns the string representation
func (s DomainDeliverabilityCampaign) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DomainDeliverabilityCampaign) GoString() string {
	return s.String()
}

// SetCampaignId sets the CampaignId field's value.
func (s *DomainDeliverabilityCampaign) SetCampaignId(v string) *DomainDeliverabilityCampaign {
	s.CampaignId = &v
	return s
}

// SetDeleteRate sets the DeleteRate field's value.
func (s *DomainDeliverabilityCampaign) SetDeleteRate(v float64) *DomainDeliverabilityCampaign {
	s.DeleteRate = &v
	return s
}

// SetEsps sets the Esps field's value.
func (s *DomainDeliverabilityCampaign) SetEsps(v []*string) *DomainDeliverabilityCampaign {
	s.Esps = v
	return s
}

// SetFirstSeenDateTime sets the FirstSeenDateTime field's value.
func (s *DomainDeliverabilityCampaign) SetFirstSeenDateTime(v time.Time) *DomainDeliverabilityCampaign {
	s.FirstSeenDateTime = &v
	return s
}

// SetFromAddress sets the FromAddress field's value.
func (s *DomainDeliverabilityCampaign) SetFromAddress(v string) *DomainDeliverabilityCampaign {
	s.FromAddress = &v
	return s
}

// SetImageUrl sets the ImageUrl field's value.
func (s *DomainDeliverabilityCampaign) SetImageUrl(v string) *DomainDeliverabilityCampaign {
	s.ImageUrl = &v
	return s
}

// SetInboxCount sets the InboxCount field's value.
func (s *DomainDeliverabilityCampaign) SetInboxCount(v int64) *DomainDeliverabilityCampaign {
	s.InboxCount = &v
	return s
}

// SetLastSeenDateTime sets the LastSeenDateTime field's value.
func (s *DomainDeliverabilityCampaign) SetLastSeenDateTime(v time.Time) *DomainDeliverabilityCampaign {
	s.LastSeenDateTime = &v
	return s
}

// SetProjectedVolume sets the ProjectedVolume field's value.
func (s *DomainDeliverabilityCampaign) SetProjectedVolume(v int64) *DomainDeliverabilityCampaign {
	s.ProjectedVolume = &v
	return s
}

// SetReadDeleteRate sets the ReadDeleteRate field's value.
func (s *DomainDeliverabilityCampaign) SetReadDeleteRate(v float64) *DomainDeliverabilityCampaign {
	s.ReadDeleteRate = &v
	return s
}

// SetReadRate sets the ReadRate field's value.
func (s *DomainDeliverabilityCampaign) SetReadRate(v float64) *DomainDeliverabilityCampaign {
	s.ReadRate = &v
	return s
}

// SetSendingIps sets the SendingIps field's value.
func (s *DomainDeliverabilityCampaign) SetSendingIps(v []*string) *DomainDeliverabilityCampaign {
	s.SendingIps = v
	return s
}

// SetSpamCount sets the SpamCount field's value.
func (s *DomainDeliverabilityCampaign) SetSpamCount(v int64) *DomainDeliverabilityCampaign {
	s.SpamCount = &v
	return s
}

// SetSubject sets the Subject field's value.
func (s *DomainDeliverabilityCampaign) SetSubject(v string) *DomainDeliverabilityCampaign {
	s.Subject = &v
	return s
}

// An object that contains information about the Deliverability dashboard subscription
// for a verified domain that you use to send email and currently has an active
// Deliverability dashboard subscription. If a Deliverability dashboard subscription
// is active for a domain, you gain access to reputation, inbox placement, and
// other metrics for the domain.
type DomainDeliverabilityTrackingOption struct {
	_ struct{} `type:"structure"`

	// A verified domain that’s associated with your AWS account and currently
	// has an active Deliverability dashboard subscription.
	Domain *string `type:"string"`

	// An object that contains information about the inbox placement data settings
	// for the domain.
	InboxPlacementTrackingOption *InboxPlacementTrackingOption `type:"structure"`

	// The date, in Unix time format, when you enabled the Deliverability dashboard
	// for the domain.
	SubscriptionStartDate *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s DomainDeliverabilityTrackingOption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DomainDeliverabilityTrackingOption) GoString() string {
	return s.String()
}

// SetDomain sets the Domain field's value.
func (s *DomainDeliverabilityTrackingOption) SetDomain(v string) *DomainDeliverabilityTrackingOption {
	s.Domain = &v
	return s
}

// SetInboxPlacementTrackingOption sets the InboxPlacementTrackingOption field's value.
func (s *DomainDeliverabilityTrackingOption) SetInboxPlacementTrackingOption(v *InboxPlacementTrackingOption) *DomainDeliverabilityTrackingOption {
	s.InboxPlacementTrackingOption = v
	return s
}

// SetSubscriptionStartDate sets the SubscriptionStartDate field's value.
func (s *DomainDeliverabilityTrackingOption) SetSubscriptionStartDate(v time.Time) *DomainDeliverabilityTrackingOption {
	s.SubscriptionStartDate = &v
	return s
}

// An object that contains inbox placement data for email sent from one of your
// email domains to a specific email provider.
type DomainIspPlacement struct {
	_ struct{} `type:"structure"`

	// The percentage of messages that were sent from the selected domain to the
	// specified email provider that arrived in recipients' inboxes.
	InboxPercentage *float64 `type:"double"`

	// The total number of messages that were sent from the selected domain to the
	// specified email provider that arrived in recipients' inboxes.
	InboxRawCount *int64 `type:"long"`

	// The name of the email provider that the inbox placement data applies to.
	IspName *string `type:"string"`

	// The percentage of messages that were sent from the selected domain to the
	// specified email provider that arrived in recipients' spam or junk mail folders.
	SpamPercentage *float64 `type:"double"`

	// The total number of messages that were sent from the selected domain to the
	// specified email provider that arrived in recipients' spam or junk mail folders.
	SpamRawCount *int64 `type:"long"`
}

// String returns the string representation
func (s DomainIspPlacement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DomainIspPlacement) GoString() string {
	return s.String()
}

// SetInboxPercentage sets the InboxPercentage field's value.
func (s *DomainIspPlacement) SetInboxPercentage(v float64) *DomainIspPlacement {
	s.InboxPercentage = &v
	return s
}

// SetInboxRawCount sets the InboxRawCount field's value.
func (s *DomainIspPlacement) SetInboxRawCount(v int64) *DomainIspPlacement {
	s.InboxRawCount = &v
	return s
}

// SetIspName sets the IspName field's value.
func (s *DomainIspPlacement) SetIspName(v string) *DomainIspPlacement {
	s.IspName = &v
	return s
}

// SetSpamPercentage sets the SpamPercentage field's value.
func (s *DomainIspPlacement) SetSpamPercentage(v float64) *DomainIspPlacement {
	s.SpamPercentage = &v
	return s
}

// SetSpamRawCount sets the SpamRawCount field's value.
func (s *DomainIspPlacement) SetSpamRawCount(v int64) *DomainIspPlacement {
	s.SpamRawCount = &v
	return s
}

// An object that defines the entire content of the email, including the message
// headers and the body content. You can create a simple email message, in which
// you specify the subject and the text and HTML versions of the message body.
// You can also create raw messages, in which you specify a complete MIME-formatted
// message. Raw messages can include attachments and custom headers.
type EmailContent struct {
	_ struct{} `type:"structure"`

	// The raw email message. The message has to meet the following criteria:
	//
	//    * The message has to contain a header and a body, separated by one blank
	//    line.
	//
	//    * All of the required header fields must be present in the message.
	//
	//    * Each part of a multipart MIME message must be formatted properly.
	//
	//    * If you include attachments, they must be in a file format that the Amazon
	//    SES API v2 supports.
	//
	//    * The entire message must be Base64 encoded.
	//
	//    * If any of the MIME parts in your message contain content that is outside
	//    of the 7-bit ASCII character range, you should encode that content to
	//    ensure that recipients' email clients render the message properly.
	//
	//    * The length of any single line of text in the message can't exceed 1,000
	//    characters. This restriction is defined in RFC 5321 (https://tools.ietf.org/html/rfc5321).
	Raw *RawMessage `type:"structure"`

	// The simple email message. The message consists of a subject and a message
	// body.
	Simple *Message `type:"structure"`

	// The template to use for the email message.
	Template *Template `type:"structure"`
}

// String returns the string representation
func (s EmailContent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EmailContent) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EmailContent) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EmailContent"}
	if s.Raw != nil {
		if err := s.Raw.Validate(); err != nil {
			invalidParams.AddNested("Raw", err.(request.ErrInvalidParams))
		}
	}
	if s.Simple != nil {
		if err := s.Simple.Validate(); err != nil {
			invalidParams.AddNested("Simple", err.(request.ErrInvalidParams))
		}
	}
	if s.Template != nil {
		if err := s.Template.Validate(); err != nil {
			invalidParams.AddNested("Template", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRaw sets the Raw field's value.
func (s *EmailContent) SetRaw(v *RawMessage) *EmailContent {
	s.Raw = v
	return s
}

// SetSimple sets the Simple field's value.
func (s *EmailContent) SetSimple(v *Message) *EmailContent {
	s.Simple = v
	return s
}

// SetTemplate sets the Template field's value.
func (s *EmailContent) SetTemplate(v *Template) *EmailContent {
	s.Template = v
	return s
}

// The content of the email, composed of a subject line, an HTML part, and a
// text-only part.
type EmailTemplateContent struct {
	_ struct{} `type:"structure"`

	// The HTML body of the email.
	Html *string `type:"string"`

	// The subject line of the email.
	Subject *string `type:"string"`

	// The email body that will be visible to recipients whose email clients do
	// not display HTML.
	Text *string `type:"string"`
}

// String returns the string representation
func (s EmailTemplateContent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EmailTemplateContent) GoString() string {
	return s.String()
}

// SetHtml sets the Html field's value.
func (s *EmailTemplateContent) SetHtml(v string) *EmailTemplateContent {
	s.Html = &v
	return s
}

// SetSubject sets the Subject field's value.
func (s *EmailTemplateContent) SetSubject(v string) *EmailTemplateContent {
	s.Subject = &v
	return s
}

// SetText sets the Text field's value.
func (s *EmailTemplateContent) SetText(v string) *EmailTemplateContent {
	s.Text = &v
	return s
}

// Contains information about an email template.
type EmailTemplateMetadata struct {
	_ struct{} `type:"structure"`

	// The time and date the template was created.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// The name of the template.
	TemplateName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s EmailTemplateMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EmailTemplateMetadata) GoString() string {
	return s.String()
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *EmailTemplateMetadata) SetCreatedTimestamp(v time.Time) *EmailTemplateMetadata {
	s.CreatedTimestamp = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *EmailTemplateMetadata) SetTemplateName(v string) *EmailTemplateMetadata {
	s.TemplateName = &v
	return s
}

// In the Amazon SES API v2, events include message sends, deliveries, opens,
// clicks, bounces, complaints and delivery delays. Event destinations are places
// that you can send information about these events to. For example, you can
// send event data to Amazon SNS to receive notifications when you receive bounces
// or complaints, or you can use Amazon Kinesis Data Firehose to stream data
// to Amazon S3 for long-term storage.
type EventDestination struct {
	_ struct{} `type:"structure"`

	// An object that defines an Amazon CloudWatch destination for email events.
	// You can use Amazon CloudWatch to monitor and gain insights on your email
	// sending metrics.
	CloudWatchDestination *CloudWatchDestination `type:"structure"`

	// If true, the event destination is enabled. When the event destination is
	// enabled, the specified event types are sent to the destinations in this EventDestinationDefinition.
	//
	// If false, the event destination is disabled. When the event destination is
	// disabled, events aren't sent to the specified destinations.
	Enabled *bool `type:"boolean"`

	// An object that defines an Amazon Kinesis Data Firehose destination for email
	// events. You can use Amazon Kinesis Data Firehose to stream data to other
	// services, such as Amazon S3 and Amazon Redshift.
	KinesisFirehoseDestination *KinesisFirehoseDestination `type:"structure"`

	// The types of events that Amazon SES sends to the specified event destinations.
	//
	// MatchingEventTypes is a required field
	MatchingEventTypes []*string `type:"list" required:"true"`

	// A name that identifies the event destination.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// An object that defines an Amazon Pinpoint project destination for email events.
	// You can send email event data to a Amazon Pinpoint project to view metrics
	// using the Transactional Messaging dashboards that are built in to Amazon
	// Pinpoint. For more information, see Transactional Messaging Charts (https://docs.aws.amazon.com/pinpoint/latest/userguide/analytics-transactional-messages.html)
	// in the Amazon Pinpoint User Guide.
	PinpointDestination *PinpointDestination `type:"structure"`

	// An object that defines an Amazon SNS destination for email events. You can
	// use Amazon SNS to send notification when certain email events occur.
	SnsDestination *SnsDestination `type:"structure"`
}

// String returns the string representation
func (s EventDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventDestination) GoString() string {
	return s.String()
}

// SetCloudWatchDestination sets the CloudWatchDestination field's value.
func (s *EventDestination) SetCloudWatchDestination(v *CloudWatchDestination) *EventDestination {
	s.CloudWatchDestination = v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *EventDestination) SetEnabled(v bool) *EventDestination {
	s.Enabled = &v
	return s
}

// SetKinesisFirehoseDestination sets the KinesisFirehoseDestination field's value.
func (s *EventDestination) SetKinesisFirehoseDestination(v *KinesisFirehoseDestination) *EventDestination {
	s.KinesisFirehoseDestination = v
	return s
}

// SetMatchingEventTypes sets the MatchingEventTypes field's value.
func (s *EventDestination) SetMatchingEventTypes(v []*string) *EventDestination {
	s.MatchingEventTypes = v
	return s
}

// SetName sets the Name field's value.
func (s *EventDestination) SetName(v string) *EventDestination {
	s.Name = &v
	return s
}

// SetPinpointDestination sets the PinpointDestination field's value.
func (s *EventDestination) SetPinpointDestination(v *PinpointDestination) *EventDestination {
	s.PinpointDestination = v
	return s
}

// SetSnsDestination sets the SnsDestination field's value.
func (s *EventDestination) SetSnsDestination(v *SnsDestination) *EventDestination {
	s.SnsDestination = v
	return s
}

// An object that defines the event destination. Specifically, it defines which
// services receive events from emails sent using the configuration set that
// the event destination is associated with. Also defines the types of events
// that are sent to the event destination.
type EventDestinationDefinition struct {
	_ struct{} `type:"structure"`

	// An object that defines an Amazon CloudWatch destination for email events.
	// You can use Amazon CloudWatch to monitor and gain insights on your email
	// sending metrics.
	CloudWatchDestination *CloudWatchDestination `type:"structure"`

	// If true, the event destination is enabled. When the event destination is
	// enabled, the specified event types are sent to the destinations in this EventDestinationDefinition.
	//
	// If false, the event destination is disabled. When the event destination is
	// disabled, events aren't sent to the specified destinations.
	Enabled *bool `type:"boolean"`

	// An object that defines an Amazon Kinesis Data Firehose destination for email
	// events. You can use Amazon Kinesis Data Firehose to stream data to other
	// services, such as Amazon S3 and Amazon Redshift.
	KinesisFirehoseDestination *KinesisFirehoseDestination `type:"structure"`

	// An array that specifies which events the Amazon SES API v2 should send to
	// the destinations in this EventDestinationDefinition.
	MatchingEventTypes []*string `type:"list"`

	// An object that defines an Amazon Pinpoint project destination for email events.
	// You can send email event data to a Amazon Pinpoint project to view metrics
	// using the Transactional Messaging dashboards that are built in to Amazon
	// Pinpoint. For more information, see Transactional Messaging Charts (https://docs.aws.amazon.com/pinpoint/latest/userguide/analytics-transactional-messages.html)
	// in the Amazon Pinpoint User Guide.
	PinpointDestination *PinpointDestination `type:"structure"`

	// An object that defines an Amazon SNS destination for email events. You can
	// use Amazon SNS to send notification when certain email events occur.
	SnsDestination *SnsDestination `type:"structure"`
}

// String returns the string representation
func (s EventDestinationDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventDestinationDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EventDestinationDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EventDestinationDefinition"}
	if s.CloudWatchDestination != nil {
		if err := s.CloudWatchDestination.Validate(); err != nil {
			invalidParams.AddNested("CloudWatchDestination", err.(request.ErrInvalidParams))
		}
	}
	if s.KinesisFirehoseDestination != nil {
		if err := s.KinesisFirehoseDestination.Validate(); err != nil {
			invalidParams.AddNested("KinesisFirehoseDestination", err.(request.ErrInvalidParams))
		}
	}
	if s.SnsDestination != nil {
		if err := s.SnsDestination.Validate(); err != nil {
			invalidParams.AddNested("SnsDestination", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudWatchDestination sets the CloudWatchDestination field's value.
func (s *EventDestinationDefinition) SetCloudWatchDestination(v *CloudWatchDestination) *EventDestinationDefinition {
	s.CloudWatchDestination = v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *EventDestinationDefinition) SetEnabled(v bool) *EventDestinationDefinition {
	s.Enabled = &v
	return s
}

// SetKinesisFirehoseDestination sets the KinesisFirehoseDestination field's value.
func (s *EventDestinationDefinition) SetKinesisFirehoseDestination(v *KinesisFirehoseDestination) *EventDestinationDefinition {
	s.KinesisFirehoseDestination = v
	return s
}

// SetMatchingEventTypes sets the MatchingEventTypes field's value.
func (s *EventDestinationDefinition) SetMatchingEventTypes(v []*string) *EventDestinationDefinition {
	s.MatchingEventTypes = v
	return s
}

// SetPinpointDestination sets the PinpointDestination field's value.
func (s *EventDestinationDefinition) SetPinpointDestination(v *PinpointDestination) *EventDestinationDefinition {
	s.PinpointDestination = v
	return s
}

// SetSnsDestination sets the SnsDestination field's value.
func (s *EventDestinationDefinition) SetSnsDestination(v *SnsDestination) *EventDestinationDefinition {
	s.SnsDestination = v
	return s
}

// An object that contains the failure details about an import job.
type FailureInfo struct {
	_ struct{} `type:"structure"`

	// A message about why the import job failed.
	ErrorMessage *string `type:"string"`

	// An Amazon S3 presigned URL that contains all the failed records and related
	// information.
	FailedRecordsS3Url *string `type:"string"`
}

// String returns the string representation
func (s FailureInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FailureInfo) GoString() string {
	return s.String()
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *FailureInfo) SetErrorMessage(v string) *FailureInfo {
	s.ErrorMessage = &v
	return s
}

// SetFailedRecordsS3Url sets the FailedRecordsS3Url field's value.
func (s *FailureInfo) SetFailedRecordsS3Url(v string) *FailureInfo {
	s.FailedRecordsS3Url = &v
	return s
}

// A request to obtain information about the email-sending capabilities of your
// Amazon SES account.
type GetAccountInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccountInput) GoString() string {
	return s.String()
}

// A list of details about the email-sending capabilities of your Amazon SES
// account in the current AWS Region.
type GetAccountOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether or not the automatic warm-up feature is enabled for dedicated
	// IP addresses that are associated with your account.
	DedicatedIpAutoWarmupEnabled *bool `type:"boolean"`

	// An object that defines your account details.
	Details *AccountDetails `type:"structure"`

	// The reputation status of your Amazon SES account. The status can be one of
	// the following:
	//
	//    * HEALTHY – There are no reputation-related issues that currently impact
	//    your account.
	//
	//    * PROBATION – We've identified potential issues with your Amazon SES
	//    account. We're placing your account under review while you work on correcting
	//    these issues.
	//
	//    * SHUTDOWN – Your account's ability to send email is currently paused
	//    because of an issue with the email sent from your account. When you correct
	//    the issue, you can contact us and request that your account's ability
	//    to send email is resumed.
	EnforcementStatus *string `type:"string"`

	// Indicates whether or not your account has production access in the current
	// AWS Region.
	//
	// If the value is false, then your account is in the sandbox. When your account
	// is in the sandbox, you can only send email to verified identities. Additionally,
	// the maximum number of emails you can send in a 24-hour period (your sending
	// quota) is 200, and the maximum number of emails you can send per second (your
	// maximum sending rate) is 1.
	//
	// If the value is true, then your account has production access. When your
	// account has production access, you can send email to any address. The sending
	// quota and maximum sending rate for your account vary based on your specific
	// use case.
	ProductionAccessEnabled *bool `type:"boolean"`

	// An object that contains information about the per-day and per-second sending
	// limits for your Amazon SES account in the current AWS Region.
	SendQuota *SendQuota `type:"structure"`

	// Indicates whether or not email sending is enabled for your Amazon SES account
	// in the current AWS Region.
	SendingEnabled *bool `type:"boolean"`

	// An object that contains information about the email address suppression preferences
	// for your account in the current AWS Region.
	SuppressionAttributes *SuppressionAttributes `type:"structure"`
}

// String returns the string representation
func (s GetAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccountOutput) GoString() string {
	return s.String()
}

// SetDedicatedIpAutoWarmupEnabled sets the DedicatedIpAutoWarmupEnabled field's value.
func (s *GetAccountOutput) SetDedicatedIpAutoWarmupEnabled(v bool) *GetAccountOutput {
	s.DedicatedIpAutoWarmupEnabled = &v
	return s
}

// SetDetails sets the Details field's value.
func (s *GetAccountOutput) SetDetails(v *AccountDetails) *GetAccountOutput {
	s.Details = v
	return s
}

// SetEnforcementStatus sets the EnforcementStatus field's value.
func (s *GetAccountOutput) SetEnforcementStatus(v string) *GetAccountOutput {
	s.EnforcementStatus = &v
	return s
}

// SetProductionAccessEnabled sets the ProductionAccessEnabled field's value.
func (s *GetAccountOutput) SetProductionAccessEnabled(v bool) *GetAccountOutput {
	s.ProductionAccessEnabled = &v
	return s
}

// SetSendQuota sets the SendQuota field's value.
func (s *GetAccountOutput) SetSendQuota(v *SendQuota) *GetAccountOutput {
	s.SendQuota = v
	return s
}

// SetSendingEnabled sets the SendingEnabled field's value.
func (s *GetAccountOutput) SetSendingEnabled(v bool) *GetAccountOutput {
	s.SendingEnabled = &v
	return s
}

// SetSuppressionAttributes sets the SuppressionAttributes field's value.
func (s *GetAccountOutput) SetSuppressionAttributes(v *SuppressionAttributes) *GetAccountOutput {
	s.SuppressionAttributes = v
	return s
}

// A request to retrieve a list of the blacklists that your dedicated IP addresses
// appear on.
type GetBlacklistReportsInput struct {
	_ struct{} `type:"structure"`

	// A list of IP addresses that you want to retrieve blacklist information about.
	// You can only specify the dedicated IP addresses that you use to send email
	// using Amazon SES or Amazon Pinpoint.
	//
	// BlacklistItemNames is a required field
	BlacklistItemNames []*string `location:"querystring" locationName:"BlacklistItemNames" type:"list" required:"true"`
}

// String returns the string representation
func (s GetBlacklistReportsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBlacklistReportsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBlacklistReportsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBlacklistReportsInput"}
	if s.BlacklistItemNames == nil {
		invalidParams.Add(request.NewErrParamRequired("BlacklistItemNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBlacklistItemNames sets the BlacklistItemNames field's value.
func (s *GetBlacklistReportsInput) SetBlacklistItemNames(v []*string) *GetBlacklistReportsInput {
	s.BlacklistItemNames = v
	return s
}

// An object that contains information about blacklist events.
type GetBlacklistReportsOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains information about a blacklist that one of your dedicated
	// IP addresses appears on.
	//
	// BlacklistReport is a required field
	BlacklistReport map[string][]*BlacklistEntry `type:"map" required:"true"`
}

// String returns the string representation
func (s GetBlacklistReportsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBlacklistReportsOutput) GoString() string {
	return s.String()
}

// SetBlacklistReport sets the BlacklistReport field's value.
func (s *GetBlacklistReportsOutput) SetBlacklistReport(v map[string][]*BlacklistEntry) *GetBlacklistReportsOutput {
	s.BlacklistReport = v
	return s
}

// A request to obtain information about the event destinations for a configuration
// set.
type GetConfigurationSetEventDestinationsInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set that contains the event destination.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `location:"uri" locationName:"ConfigurationSetName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetConfigurationSetEventDestinationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetConfigurationSetEventDestinationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetConfigurationSetEventDestinationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetConfigurationSetEventDestinationsInput"}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}
	if s.ConfigurationSetName != nil && len(*s.ConfigurationSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationSetName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *GetConfigurationSetEventDestinationsInput) SetConfigurationSetName(v string) *GetConfigurationSetEventDestinationsInput {
	s.ConfigurationSetName = &v
	return s
}

// Information about an event destination for a configuration set.
type GetConfigurationSetEventDestinationsOutput struct {
	_ struct{} `type:"structure"`

	// An array that includes all of the events destinations that have been configured
	// for the configuration set.
	EventDestinations []*EventDestination `type:"list"`
}

// String returns the string representation
func (s GetConfigurationSetEventDestinationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetConfigurationSetEventDestinationsOutput) GoString() string {
	return s.String()
}

// SetEventDestinations sets the EventDestinations field's value.
func (s *GetConfigurationSetEventDestinationsOutput) SetEventDestinations(v []*EventDestination) *GetConfigurationSetEventDestinationsOutput {
	s.EventDestinations = v
	return s
}

// A request to obtain information about a configuration set.
type GetConfigurationSetInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set that you want to obtain more information
	// about.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `location:"uri" locationName:"ConfigurationSetName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetConfigurationSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetConfigurationSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetConfigurationSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetConfigurationSetInput"}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}
	if s.ConfigurationSetName != nil && len(*s.ConfigurationSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationSetName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *GetConfigurationSetInput) SetConfigurationSetName(v string) *GetConfigurationSetInput {
	s.ConfigurationSetName = &v
	return s
}

// Information about a configuration set.
type GetConfigurationSetOutput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set.
	ConfigurationSetName *string `type:"string"`

	// An object that defines the dedicated IP pool that is used to send emails
	// that you send using the configuration set.
	DeliveryOptions *DeliveryOptions `type:"structure"`

	// An object that defines whether or not Amazon SES collects reputation metrics
	// for the emails that you send that use the configuration set.
	ReputationOptions *ReputationOptions `type:"structure"`

	// An object that defines whether or not Amazon SES can send email that you
	// send using the configuration set.
	SendingOptions *SendingOptions `type:"structure"`

	// An object that contains information about the suppression list preferences
	// for your account.
	SuppressionOptions *SuppressionOptions `type:"structure"`

	// An array of objects that define the tags (keys and values) that are associated
	// with the configuration set.
	Tags []*Tag `type:"list"`

	// An object that defines the open and click tracking options for emails that
	// you send using the configuration set.
	TrackingOptions *TrackingOptions `type:"structure"`
}

// String returns the string representation
func (s GetConfigurationSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetConfigurationSetOutput) GoString() string {
	return s.String()
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *GetConfigurationSetOutput) SetConfigurationSetName(v string) *GetConfigurationSetOutput {
	s.ConfigurationSetName = &v
	return s
}

// SetDeliveryOptions sets the DeliveryOptions field's value.
func (s *GetConfigurationSetOutput) SetDeliveryOptions(v *DeliveryOptions) *GetConfigurationSetOutput {
	s.DeliveryOptions = v
	return s
}

// SetReputationOptions sets the ReputationOptions field's value.
func (s *GetConfigurationSetOutput) SetReputationOptions(v *ReputationOptions) *GetConfigurationSetOutput {
	s.ReputationOptions = v
	return s
}

// SetSendingOptions sets the SendingOptions field's value.
func (s *GetConfigurationSetOutput) SetSendingOptions(v *SendingOptions) *GetConfigurationSetOutput {
	s.SendingOptions = v
	return s
}

// SetSuppressionOptions sets the SuppressionOptions field's value.
func (s *GetConfigurationSetOutput) SetSuppressionOptions(v *SuppressionOptions) *GetConfigurationSetOutput {
	s.SuppressionOptions = v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetConfigurationSetOutput) SetTags(v []*Tag) *GetConfigurationSetOutput {
	s.Tags = v
	return s
}

// SetTrackingOptions sets the TrackingOptions field's value.
func (s *GetConfigurationSetOutput) SetTrackingOptions(v *TrackingOptions) *GetConfigurationSetOutput {
	s.TrackingOptions = v
	return s
}

// Represents a request to retrieve an existing custom verification email template.
type GetCustomVerificationEmailTemplateInput struct {
	_ struct{} `type:"structure"`

	// The name of the custom verification email template that you want to retrieve.
	//
	// TemplateName is a required field
	TemplateName *string `location:"uri" locationName:"TemplateName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetCustomVerificationEmailTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCustomVerificationEmailTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCustomVerificationEmailTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCustomVerificationEmailTemplateInput"}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTemplateName sets the TemplateName field's value.
func (s *GetCustomVerificationEmailTemplateInput) SetTemplateName(v string) *GetCustomVerificationEmailTemplateInput {
	s.TemplateName = &v
	return s
}

// The following elements are returned by the service.
type GetCustomVerificationEmailTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The URL that the recipient of the verification email is sent to if his or
	// her address is not successfully verified.
	FailureRedirectionURL *string `type:"string"`

	// The email address that the custom verification email is sent from.
	FromEmailAddress *string `type:"string"`

	// The URL that the recipient of the verification email is sent to if his or
	// her address is successfully verified.
	SuccessRedirectionURL *string `type:"string"`

	// The content of the custom verification email.
	TemplateContent *string `type:"string"`

	// The name of the custom verification email template.
	TemplateName *string `min:"1" type:"string"`

	// The subject line of the custom verification email.
	TemplateSubject *string `type:"string"`
}

// String returns the string representation
func (s GetCustomVerificationEmailTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCustomVerificationEmailTemplateOutput) GoString() string {
	return s.String()
}

// SetFailureRedirectionURL sets the FailureRedirectionURL field's value.
func (s *GetCustomVerificationEmailTemplateOutput) SetFailureRedirectionURL(v string) *GetCustomVerificationEmailTemplateOutput {
	s.FailureRedirectionURL = &v
	return s
}

// SetFromEmailAddress sets the FromEmailAddress field's value.
func (s *GetCustomVerificationEmailTemplateOutput) SetFromEmailAddress(v string) *GetCustomVerificationEmailTemplateOutput {
	s.FromEmailAddress = &v
	return s
}

// SetSuccessRedirectionURL sets the SuccessRedirectionURL field's value.
func (s *GetCustomVerificationEmailTemplateOutput) SetSuccessRedirectionURL(v string) *GetCustomVerificationEmailTemplateOutput {
	s.SuccessRedirectionURL = &v
	return s
}

// SetTemplateContent sets the TemplateContent field's value.
func (s *GetCustomVerificationEmailTemplateOutput) SetTemplateContent(v string) *GetCustomVerificationEmailTemplateOutput {
	s.TemplateContent = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *GetCustomVerificationEmailTemplateOutput) SetTemplateName(v string) *GetCustomVerificationEmailTemplateOutput {
	s.TemplateName = &v
	return s
}

// SetTemplateSubject sets the TemplateSubject field's value.
func (s *GetCustomVerificationEmailTemplateOutput) SetTemplateSubject(v string) *GetCustomVerificationEmailTemplateOutput {
	s.TemplateSubject = &v
	return s
}

// A request to obtain more information about a dedicated IP address.
type GetDedicatedIpInput struct {
	_ struct{} `type:"structure"`

	// The IP address that you want to obtain more information about. The value
	// you specify has to be a dedicated IP address that's assocaited with your
	// AWS account.
	//
	// Ip is a required field
	Ip *string `location:"uri" locationName:"IP" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDedicatedIpInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDedicatedIpInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDedicatedIpInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDedicatedIpInput"}
	if s.Ip == nil {
		invalidParams.Add(request.NewErrParamRequired("Ip"))
	}
	if s.Ip != nil && len(*s.Ip) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Ip", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIp sets the Ip field's value.
func (s *GetDedicatedIpInput) SetIp(v string) *GetDedicatedIpInput {
	s.Ip = &v
	return s
}

// Information about a dedicated IP address.
type GetDedicatedIpOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains information about a dedicated IP address.
	DedicatedIp *DedicatedIp `type:"structure"`
}

// String returns the string representation
func (s GetDedicatedIpOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDedicatedIpOutput) GoString() string {
	return s.String()
}

// SetDedicatedIp sets the DedicatedIp field's value.
func (s *GetDedicatedIpOutput) SetDedicatedIp(v *DedicatedIp) *GetDedicatedIpOutput {
	s.DedicatedIp = v
	return s
}

// A request to obtain more information about dedicated IP pools.
type GetDedicatedIpsInput struct {
	_ struct{} `type:"structure"`

	// A token returned from a previous call to GetDedicatedIps to indicate the
	// position of the dedicated IP pool in the list of IP pools.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// The number of results to show in a single call to GetDedicatedIpsRequest.
	// If the number of results is larger than the number you specified in this
	// parameter, then the response includes a NextToken element, which you can
	// use to obtain additional results.
	PageSize *int64 `location:"querystring" locationName:"PageSize" type:"integer"`

	// The name of the IP pool that the dedicated IP address is associated with.
	PoolName *string `location:"querystring" locationName:"PoolName" type:"string"`
}

// String returns the string representation
func (s GetDedicatedIpsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDedicatedIpsInput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetDedicatedIpsInput) SetNextToken(v string) *GetDedicatedIpsInput {
	s.NextToken = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetDedicatedIpsInput) SetPageSize(v int64) *GetDedicatedIpsInput {
	s.PageSize = &v
	return s
}

// SetPoolName sets the PoolName field's value.
func (s *GetDedicatedIpsInput) SetPoolName(v string) *GetDedicatedIpsInput {
	s.PoolName = &v
	return s
}

// Information about the dedicated IP addresses that are associated with your
// AWS account.
type GetDedicatedIpsOutput struct {
	_ struct{} `type:"structure"`

	// A list of dedicated IP addresses that are associated with your AWS account.
	DedicatedIps []*DedicatedIp `type:"list"`

	// A token that indicates that there are additional dedicated IP addresses to
	// list. To view additional addresses, issue another request to GetDedicatedIps,
	// passing this token in the NextToken parameter.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetDedicatedIpsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDedicatedIpsOutput) GoString() string {
	return s.String()
}

// SetDedicatedIps sets the DedicatedIps field's value.
func (s *GetDedicatedIpsOutput) SetDedicatedIps(v []*DedicatedIp) *GetDedicatedIpsOutput {
	s.DedicatedIps = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetDedicatedIpsOutput) SetNextToken(v string) *GetDedicatedIpsOutput {
	s.NextToken = &v
	return s
}

// Retrieve information about the status of the Deliverability dashboard for
// your AWS account. When the Deliverability dashboard is enabled, you gain
// access to reputation, deliverability, and other metrics for your domains.
// You also gain the ability to perform predictive inbox placement tests.
//
// When you use the Deliverability dashboard, you pay a monthly subscription
// charge, in addition to any other fees that you accrue by using Amazon SES
// and other AWS services. For more information about the features and cost
// of a Deliverability dashboard subscription, see Amazon Pinpoint Pricing (http://aws.amazon.com/pinpoint/pricing/).
type GetDeliverabilityDashboardOptionsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetDeliverabilityDashboardOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeliverabilityDashboardOptionsInput) GoString() string {
	return s.String()
}

// An object that shows the status of the Deliverability dashboard.
type GetDeliverabilityDashboardOptionsOutput struct {
	_ struct{} `type:"structure"`

	// The current status of your Deliverability dashboard subscription. If this
	// value is PENDING_EXPIRATION, your subscription is scheduled to expire at
	// the end of the current calendar month.
	AccountStatus *string `type:"string" enum:"DeliverabilityDashboardAccountStatus"`

	// An array of objects, one for each verified domain that you use to send email
	// and currently has an active Deliverability dashboard subscription that isn’t
	// scheduled to expire at the end of the current calendar month.
	ActiveSubscribedDomains []*DomainDeliverabilityTrackingOption `type:"list"`

	// Specifies whether the Deliverability dashboard is enabled. If this value
	// is true, the dashboard is enabled.
	//
	// DashboardEnabled is a required field
	DashboardEnabled *bool `type:"boolean" required:"true"`

	// An array of objects, one for each verified domain that you use to send email
	// and currently has an active Deliverability dashboard subscription that's
	// scheduled to expire at the end of the current calendar month.
	PendingExpirationSubscribedDomains []*DomainDeliverabilityTrackingOption `type:"list"`

	// The date, in Unix time format, when your current subscription to the Deliverability
	// dashboard is scheduled to expire, if your subscription is scheduled to expire
	// at the end of the current calendar month. This value is null if you have
	// an active subscription that isn’t due to expire at the end of the month.
	SubscriptionExpiryDate *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s GetDeliverabilityDashboardOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeliverabilityDashboardOptionsOutput) GoString() string {
	return s.String()
}

// SetAccountStatus sets the AccountStatus field's value.
func (s *GetDeliverabilityDashboardOptionsOutput) SetAccountStatus(v string) *GetDeliverabilityDashboardOptionsOutput {
	s.AccountStatus = &v
	return s
}

// SetActiveSubscribedDomains sets the ActiveSubscribedDomains field's value.
func (s *GetDeliverabilityDashboardOptionsOutput) SetActiveSubscribedDomains(v []*DomainDeliverabilityTrackingOption) *GetDeliverabilityDashboardOptionsOutput {
	s.ActiveSubscribedDomains = v
	return s
}

// SetDashboardEnabled sets the DashboardEnabled field's value.
func (s *GetDeliverabilityDashboardOptionsOutput) SetDashboardEnabled(v bool) *GetDeliverabilityDashboardOptionsOutput {
	s.DashboardEnabled = &v
	return s
}

// SetPendingExpirationSubscribedDomains sets the PendingExpirationSubscribedDomains field's value.
func (s *GetDeliverabilityDashboardOptionsOutput) SetPendingExpirationSubscribedDomains(v []*DomainDeliverabilityTrackingOption) *GetDeliverabilityDashboardOptionsOutput {
	s.PendingExpirationSubscribedDomains = v
	return s
}

// SetSubscriptionExpiryDate sets the SubscriptionExpiryDate field's value.
func (s *GetDeliverabilityDashboardOptionsOutput) SetSubscriptionExpiryDate(v time.Time) *GetDeliverabilityDashboardOptionsOutput {
	s.SubscriptionExpiryDate = &v
	return s
}

// A request to retrieve the results of a predictive inbox placement test.
type GetDeliverabilityTestReportInput struct {
	_ struct{} `type:"structure"`

	// A unique string that identifies the predictive inbox placement test.
	//
	// ReportId is a required field
	ReportId *string `location:"uri" locationName:"ReportId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDeliverabilityTestReportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeliverabilityTestReportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDeliverabilityTestReportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDeliverabilityTestReportInput"}
	if s.ReportId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReportId"))
	}
	if s.ReportId != nil && len(*s.ReportId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ReportId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReportId sets the ReportId field's value.
func (s *GetDeliverabilityTestReportInput) SetReportId(v string) *GetDeliverabilityTestReportInput {
	s.ReportId = &v
	return s
}

// The results of the predictive inbox placement test.
type GetDeliverabilityTestReportOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains the results of the predictive inbox placement test.
	//
	// DeliverabilityTestReport is a required field
	DeliverabilityTestReport *DeliverabilityTestReport `type:"structure" required:"true"`

	// An object that describes how the test email was handled by several email
	// providers, including Gmail, Hotmail, Yahoo, AOL, and others.
	//
	// IspPlacements is a required field
	IspPlacements []*IspPlacement `type:"list" required:"true"`

	// An object that contains the message that you sent when you performed this
	// predictive inbox placement test.
	Message *string `type:"string"`

	// An object that specifies how many test messages that were sent during the
	// predictive inbox placement test were delivered to recipients' inboxes, how
	// many were sent to recipients' spam folders, and how many weren't delivered.
	//
	// OverallPlacement is a required field
	OverallPlacement *PlacementStatistics `type:"structure" required:"true"`

	// An array of objects that define the tags (keys and values) that are associated
	// with the predictive inbox placement test.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s GetDeliverabilityTestReportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeliverabilityTestReportOutput) GoString() string {
	return s.String()
}

// SetDeliverabilityTestReport sets the DeliverabilityTestReport field's value.
func (s *GetDeliverabilityTestReportOutput) SetDeliverabilityTestReport(v *DeliverabilityTestReport) *GetDeliverabilityTestReportOutput {
	s.DeliverabilityTestReport = v
	return s
}

// SetIspPlacements sets the IspPlacements field's value.
func (s *GetDeliverabilityTestReportOutput) SetIspPlacements(v []*IspPlacement) *GetDeliverabilityTestReportOutput {
	s.IspPlacements = v
	return s
}

// SetMessage sets the Message field's value.
func (s *GetDeliverabilityTestReportOutput) SetMessage(v string) *GetDeliverabilityTestReportOutput {
	s.Message = &v
	return s
}

// SetOverallPlacement sets the OverallPlacement field's value.
func (s *GetDeliverabilityTestReportOutput) SetOverallPlacement(v *PlacementStatistics) *GetDeliverabilityTestReportOutput {
	s.OverallPlacement = v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetDeliverabilityTestReportOutput) SetTags(v []*Tag) *GetDeliverabilityTestReportOutput {
	s.Tags = v
	return s
}

// Retrieve all the deliverability data for a specific campaign. This data is
// available for a campaign only if the campaign sent email by using a domain
// that the Deliverability dashboard is enabled for (PutDeliverabilityDashboardOption
// operation).
type GetDomainDeliverabilityCampaignInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the campaign. The Deliverability dashboard automatically
	// generates and assigns this identifier to a campaign.
	//
	// CampaignId is a required field
	CampaignId *string `location:"uri" locationName:"CampaignId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDomainDeliverabilityCampaignInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDomainDeliverabilityCampaignInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDomainDeliverabilityCampaignInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDomainDeliverabilityCampaignInput"}
	if s.CampaignId == nil {
		invalidParams.Add(request.NewErrParamRequired("CampaignId"))
	}
	if s.CampaignId != nil && len(*s.CampaignId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CampaignId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCampaignId sets the CampaignId field's value.
func (s *GetDomainDeliverabilityCampaignInput) SetCampaignId(v string) *GetDomainDeliverabilityCampaignInput {
	s.CampaignId = &v
	return s
}

// An object that contains all the deliverability data for a specific campaign.
// This data is available for a campaign only if the campaign sent email by
// using a domain that the Deliverability dashboard is enabled for.
type GetDomainDeliverabilityCampaignOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains the deliverability data for the campaign.
	//
	// DomainDeliverabilityCampaign is a required field
	DomainDeliverabilityCampaign *DomainDeliverabilityCampaign `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetDomainDeliverabilityCampaignOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDomainDeliverabilityCampaignOutput) GoString() string {
	return s.String()
}

// SetDomainDeliverabilityCampaign sets the DomainDeliverabilityCampaign field's value.
func (s *GetDomainDeliverabilityCampaignOutput) SetDomainDeliverabilityCampaign(v *DomainDeliverabilityCampaign) *GetDomainDeliverabilityCampaignOutput {
	s.DomainDeliverabilityCampaign = v
	return s
}

// A request to obtain deliverability metrics for a domain.
type GetDomainStatisticsReportInput struct {
	_ struct{} `type:"structure"`

	// The domain that you want to obtain deliverability metrics for.
	//
	// Domain is a required field
	Domain *string `location:"uri" locationName:"Domain" min:"1" type:"string" required:"true"`

	// The last day (in Unix time) that you want to obtain domain deliverability
	// metrics for. The EndDate that you specify has to be less than or equal to
	// 30 days after the StartDate.
	//
	// EndDate is a required field
	EndDate *time.Time `location:"querystring" locationName:"EndDate" type:"timestamp" required:"true"`

	// The first day (in Unix time) that you want to obtain domain deliverability
	// metrics for.
	//
	// StartDate is a required field
	StartDate *time.Time `location:"querystring" locationName:"StartDate" type:"timestamp" required:"true"`
}

// String returns the string representation
func (s GetDomainStatisticsReportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDomainStatisticsReportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDomainStatisticsReportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDomainStatisticsReportInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 1))
	}
	if s.EndDate == nil {
		invalidParams.Add(request.NewErrParamRequired("EndDate"))
	}
	if s.StartDate == nil {
		invalidParams.Add(request.NewErrParamRequired("StartDate"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *GetDomainStatisticsReportInput) SetDomain(v string) *GetDomainStatisticsReportInput {
	s.Domain = &v
	return s
}

// SetEndDate sets the EndDate field's value.
func (s *GetDomainStatisticsReportInput) SetEndDate(v time.Time) *GetDomainStatisticsReportInput {
	s.EndDate = &v
	return s
}

// SetStartDate sets the StartDate field's value.
func (s *GetDomainStatisticsReportInput) SetStartDate(v time.Time) *GetDomainStatisticsReportInput {
	s.StartDate = &v
	return s
}

// An object that includes statistics that are related to the domain that you
// specified.
type GetDomainStatisticsReportOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains deliverability metrics for the domain that you specified.
	// This object contains data for each day, starting on the StartDate and ending
	// on the EndDate.
	//
	// DailyVolumes is a required field
	DailyVolumes []*DailyVolume `type:"list" required:"true"`

	// An object that contains deliverability metrics for the domain that you specified.
	// The data in this object is a summary of all of the data that was collected
	// from the StartDate to the EndDate.
	//
	// OverallVolume is a required field
	OverallVolume *OverallVolume `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetDomainStatisticsReportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDomainStatisticsReportOutput) GoString() string {
	return s.String()
}

// SetDailyVolumes sets the DailyVolumes field's value.
func (s *GetDomainStatisticsReportOutput) SetDailyVolumes(v []*DailyVolume) *GetDomainStatisticsReportOutput {
	s.DailyVolumes = v
	return s
}

// SetOverallVolume sets the OverallVolume field's value.
func (s *GetDomainStatisticsReportOutput) SetOverallVolume(v *OverallVolume) *GetDomainStatisticsReportOutput {
	s.OverallVolume = v
	return s
}

// A request to return details about an email identity.
type GetEmailIdentityInput struct {
	_ struct{} `type:"structure"`

	// The email identity that you want to retrieve details for.
	//
	// EmailIdentity is a required field
	EmailIdentity *string `location:"uri" locationName:"EmailIdentity" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetEmailIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEmailIdentityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEmailIdentityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEmailIdentityInput"}
	if s.EmailIdentity == nil {
		invalidParams.Add(request.NewErrParamRequired("EmailIdentity"))
	}
	if s.EmailIdentity != nil && len(*s.EmailIdentity) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EmailIdentity", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEmailIdentity sets the EmailIdentity field's value.
func (s *GetEmailIdentityInput) SetEmailIdentity(v string) *GetEmailIdentityInput {
	s.EmailIdentity = &v
	return s
}

// Details about an email identity.
type GetEmailIdentityOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains information about the DKIM attributes for the identity.
	DkimAttributes *DkimAttributes `type:"structure"`

	// The feedback forwarding configuration for the identity.
	//
	// If the value is true, you receive email notifications when bounce or complaint
	// events occur. These notifications are sent to the address that you specified
	// in the Return-Path header of the original email.
	//
	// You're required to have a method of tracking bounces and complaints. If you
	// haven't set up another mechanism for receiving bounce or complaint notifications
	// (for example, by setting up an event destination), you receive an email notification
	// when these events occur (even if this setting is disabled).
	FeedbackForwardingStatus *bool `type:"boolean"`

	// The email identity type.
	IdentityType *string `type:"string" enum:"IdentityType"`

	// An object that contains information about the Mail-From attributes for the
	// email identity.
	MailFromAttributes *MailFromAttributes `type:"structure"`

	// A map of policy names to policies.
	Policies map[string]*string `type:"map"`

	// An array of objects that define the tags (keys and values) that are associated
	// with the email identity.
	Tags []*Tag `type:"list"`

	// Specifies whether or not the identity is verified. You can only send email
	// from verified email addresses or domains. For more information about verifying
	// identities, see the Amazon Pinpoint User Guide (https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-email-manage-verify.html).
	VerifiedForSendingStatus *bool `type:"boolean"`
}

// String returns the string representation
func (s GetEmailIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEmailIdentityOutput) GoString() string {
	return s.String()
}

// SetDkimAttributes sets the DkimAttributes field's value.
func (s *GetEmailIdentityOutput) SetDkimAttributes(v *DkimAttributes) *GetEmailIdentityOutput {
	s.DkimAttributes = v
	return s
}

// SetFeedbackForwardingStatus sets the FeedbackForwardingStatus field's value.
func (s *GetEmailIdentityOutput) SetFeedbackForwardingStatus(v bool) *GetEmailIdentityOutput {
	s.FeedbackForwardingStatus = &v
	return s
}

// SetIdentityType sets the IdentityType field's value.
func (s *GetEmailIdentityOutput) SetIdentityType(v string) *GetEmailIdentityOutput {
	s.IdentityType = &v
	return s
}

// SetMailFromAttributes sets the MailFromAttributes field's value.
func (s *GetEmailIdentityOutput) SetMailFromAttributes(v *MailFromAttributes) *GetEmailIdentityOutput {
	s.MailFromAttributes = v
	return s
}

// SetPolicies sets the Policies field's value.
func (s *GetEmailIdentityOutput) SetPolicies(v map[string]*string) *GetEmailIdentityOutput {
	s.Policies = v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetEmailIdentityOutput) SetTags(v []*Tag) *GetEmailIdentityOutput {
	s.Tags = v
	return s
}

// SetVerifiedForSendingStatus sets the VerifiedForSendingStatus field's value.
func (s *GetEmailIdentityOutput) SetVerifiedForSendingStatus(v bool) *GetEmailIdentityOutput {
	s.VerifiedForSendingStatus = &v
	return s
}

// A request to return the policies of an email identity.
type GetEmailIdentityPoliciesInput struct {
	_ struct{} `type:"structure"`

	// The email identity that you want to retrieve policies for.
	//
	// EmailIdentity is a required field
	EmailIdentity *string `location:"uri" locationName:"EmailIdentity" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetEmailIdentityPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEmailIdentityPoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEmailIdentityPoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEmailIdentityPoliciesInput"}
	if s.EmailIdentity == nil {
		invalidParams.Add(request.NewErrParamRequired("EmailIdentity"))
	}
	if s.EmailIdentity != nil && len(*s.EmailIdentity) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EmailIdentity", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEmailIdentity sets the EmailIdentity field's value.
func (s *GetEmailIdentityPoliciesInput) SetEmailIdentity(v string) *GetEmailIdentityPoliciesInput {
	s.EmailIdentity = &v
	return s
}

// Identity policies associated with email identity.
type GetEmailIdentityPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// A map of policy names to policies.
	Policies map[string]*string `type:"map"`
}

// String returns the string representation
func (s GetEmailIdentityPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEmailIdentityPoliciesOutput) GoString() string {
	return s.String()
}

// SetPolicies sets the Policies field's value.
func (s *GetEmailIdentityPoliciesOutput) SetPolicies(v map[string]*string) *GetEmailIdentityPoliciesOutput {
	s.Policies = v
	return s
}

// Represents a request to display the template object (which includes the subject
// line, HTML part and text part) for the template you specify.
type GetEmailTemplateInput struct {
	_ struct{} `type:"structure"`

	// The name of the template you want to retrieve.
	//
	// TemplateName is a required field
	TemplateName *string `location:"uri" locationName:"TemplateName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetEmailTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEmailTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEmailTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEmailTemplateInput"}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTemplateName sets the TemplateName field's value.
func (s *GetEmailTemplateInput) SetTemplateName(v string) *GetEmailTemplateInput {
	s.TemplateName = &v
	return s
}

// The following element is returned by the service.
type GetEmailTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The content of the email template, composed of a subject line, an HTML part,
	// and a text-only part.
	//
	// TemplateContent is a required field
	TemplateContent *EmailTemplateContent `type:"structure" required:"true"`

	// The name of the template you want to retrieve.
	//
	// TemplateName is a required field
	TemplateName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetEmailTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEmailTemplateOutput) GoString() string {
	return s.String()
}

// SetTemplateContent sets the TemplateContent field's value.
func (s *GetEmailTemplateOutput) SetTemplateContent(v *EmailTemplateContent) *GetEmailTemplateOutput {
	s.TemplateContent = v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *GetEmailTemplateOutput) SetTemplateName(v string) *GetEmailTemplateOutput {
	s.TemplateName = &v
	return s
}

// Represents a request for information about an import job using the import
// job ID.
type GetImportJobInput struct {
	_ struct{} `type:"structure"`

	// The ID of the import job.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"JobId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetImportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetImportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetImportJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *GetImportJobInput) SetJobId(v string) *GetImportJobInput {
	s.JobId = &v
	return s
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type GetImportJobOutput struct {
	_ struct{} `type:"structure"`

	// The time stamp of when the import job was completed.
	CompletedTimestamp *time.Time `type:"timestamp"`

	// The time stamp of when the import job was created.
	CreatedTimestamp *time.Time `type:"timestamp"`

	// The number of records that failed processing because of invalid input or
	// other reasons.
	FailedRecordsCount *int64 `type:"integer"`

	// The failure details about an import job.
	FailureInfo *FailureInfo `type:"structure"`

	// The data source of the import job.
	ImportDataSource *ImportDataSource `type:"structure"`

	// The destination of the import job.
	ImportDestination *ImportDestination `type:"structure"`

	// A string that represents the import job ID.
	JobId *string `min:"1" type:"string"`

	// The status of the import job.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// The current number of records processed.
	ProcessedRecordsCount *int64 `type:"integer"`
}

// String returns the string representation
func (s GetImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetImportJobOutput) GoString() string {
	return s.String()
}

// SetCompletedTimestamp sets the CompletedTimestamp field's value.
func (s *GetImportJobOutput) SetCompletedTimestamp(v time.Time) *GetImportJobOutput {
	s.CompletedTimestamp = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *GetImportJobOutput) SetCreatedTimestamp(v time.Time) *GetImportJobOutput {
	s.CreatedTimestamp = &v
	return s
}

// SetFailedRecordsCount sets the FailedRecordsCount field's value.
func (s *GetImportJobOutput) SetFailedRecordsCount(v int64) *GetImportJobOutput {
	s.FailedRecordsCount = &v
	return s
}

// SetFailureInfo sets the FailureInfo field's value.
func (s *GetImportJobOutput) SetFailureInfo(v *FailureInfo) *GetImportJobOutput {
	s.FailureInfo = v
	return s
}

// SetImportDataSource sets the ImportDataSource field's value.
func (s *GetImportJobOutput) SetImportDataSource(v *ImportDataSource) *GetImportJobOutput {
	s.ImportDataSource = v
	return s
}

// SetImportDestination sets the ImportDestination field's value.
func (s *GetImportJobOutput) SetImportDestination(v *ImportDestination) *GetImportJobOutput {
	s.ImportDestination = v
	return s
}

// SetJobId sets the JobId field's value.
func (s *GetImportJobOutput) SetJobId(v string) *GetImportJobOutput {
	s.JobId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *GetImportJobOutput) SetJobStatus(v string) *GetImportJobOutput {
	s.JobStatus = &v
	return s
}

// SetProcessedRecordsCount sets the ProcessedRecordsCount field's value.
func (s *GetImportJobOutput) SetProcessedRecordsCount(v int64) *GetImportJobOutput {
	s.ProcessedRecordsCount = &v
	return s
}

// A request to retrieve information about an email address that's on the suppression
// list for your account.
type GetSuppressedDestinationInput struct {
	_ struct{} `type:"structure"`

	// The email address that's on the account suppression list.
	//
	// EmailAddress is a required field
	EmailAddress *string `location:"uri" locationName:"EmailAddress" type:"string" required:"true"`
}

// String returns the string representation
func (s GetSuppressedDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSuppressedDestinationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSuppressedDestinationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSuppressedDestinationInput"}
	if s.EmailAddress == nil {
		invalidParams.Add(request.NewErrParamRequired("EmailAddress"))
	}
	if s.EmailAddress != nil && len(*s.EmailAddress) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EmailAddress", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEmailAddress sets the EmailAddress field's value.
func (s *GetSuppressedDestinationInput) SetEmailAddress(v string) *GetSuppressedDestinationInput {
	s.EmailAddress = &v
	return s
}

// Information about the suppressed email address.
type GetSuppressedDestinationOutput struct {
	_ struct{} `type:"structure"`

	// An object containing information about the suppressed email address.
	//
	// SuppressedDestination is a required field
	SuppressedDestination *SuppressedDestination `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetSuppressedDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSuppressedDestinationOutput) GoString() string {
	return s.String()
}

// SetSuppressedDestination sets the SuppressedDestination field's value.
func (s *GetSuppressedDestinationOutput) SetSuppressedDestination(v *SuppressedDestination) *GetSuppressedDestinationOutput {
	s.SuppressedDestination = v
	return s
}

// Information about an email identity.
type IdentityInfo struct {
	_ struct{} `type:"structure"`

	// The address or domain of the identity.
	IdentityName *string `min:"1" type:"string"`

	// The email identity type. The identity type can be one of the following:
	//
	//    * EMAIL_ADDRESS – The identity is an email address.
	//
	//    * DOMAIN – The identity is a domain.
	//
	//    * MANAGED_DOMAIN – The identity is a domain that is managed by AWS.
	IdentityType *string `type:"string" enum:"IdentityType"`

	// Indicates whether or not you can send email from the identity.
	//
	// An identity is an email address or domain that you send email from. Before
	// you can send email from an identity, you have to demostrate that you own
	// the identity, and that you authorize Amazon SES to send email from that identity.
	SendingEnabled *bool `type:"boolean"`
}

// String returns the string representation
func (s IdentityInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IdentityInfo) GoString() string {
	return s.String()
}

// SetIdentityName sets the IdentityName field's value.
func (s *IdentityInfo) SetIdentityName(v string) *IdentityInfo {
	s.IdentityName = &v
	return s
}

// SetIdentityType sets the IdentityType field's value.
func (s *IdentityInfo) SetIdentityType(v string) *IdentityInfo {
	s.IdentityType = &v
	return s
}

// SetSendingEnabled sets the SendingEnabled field's value.
func (s *IdentityInfo) SetSendingEnabled(v bool) *IdentityInfo {
	s.SendingEnabled = &v
	return s
}

// An object that contains details about the data source of the import job.
type ImportDataSource struct {
	_ struct{} `type:"structure"`

	// The data format of the import job's data source.
	//
	// DataFormat is a required field
	DataFormat *string `type:"string" required:"true" enum:"DataFormat"`

	// An Amazon S3 URL in the format s3://<bucket_name>/<object>.
	//
	// S3Url is a required field
	S3Url *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ImportDataSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportDataSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportDataSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportDataSource"}
	if s.DataFormat == nil {
		invalidParams.Add(request.NewErrParamRequired("DataFormat"))
	}
	if s.S3Url == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Url"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataFormat sets the DataFormat field's value.
func (s *ImportDataSource) SetDataFormat(v string) *ImportDataSource {
	s.DataFormat = &v
	return s
}

// SetS3Url sets the S3Url field's value.
func (s *ImportDataSource) SetS3Url(v string) *ImportDataSource {
	s.S3Url = &v
	return s
}

// An object that contains details about the resource destination the import
// job is going to target.
type ImportDestination struct {
	_ struct{} `type:"structure"`

	// An object that contains the action of the import job towards suppression
	// list.
	//
	// SuppressionListDestination is a required field
	SuppressionListDestination *SuppressionListDestination `type:"structure" required:"true"`
}

// String returns the string representation
func (s ImportDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportDestination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportDestination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportDestination"}
	if s.SuppressionListDestination == nil {
		invalidParams.Add(request.NewErrParamRequired("SuppressionListDestination"))
	}
	if s.SuppressionListDestination != nil {
		if err := s.SuppressionListDestination.Validate(); err != nil {
			invalidParams.AddNested("SuppressionListDestination", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSuppressionListDestination sets the SuppressionListDestination field's value.
func (s *ImportDestination) SetSuppressionListDestination(v *SuppressionListDestination) *ImportDestination {
	s.SuppressionListDestination = v
	return s
}

// A summary of the import job.
type ImportJobSummary struct {
	_ struct{} `type:"structure"`

	CreatedTimestamp *time.Time `type:"timestamp"`

	// An object that contains details about the resource destination the import
	// job is going to target.
	ImportDestination *ImportDestination `type:"structure"`

	// A string that represents the import job ID.
	JobId *string `min:"1" type:"string"`

	// The status of the import job.
	JobStatus *string `type:"string" enum:"JobStatus"`
}

// String returns the string representation
func (s ImportJobSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportJobSummary) GoString() string {
	return s.String()
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *ImportJobSummary) SetCreatedTimestamp(v time.Time) *ImportJobSummary {
	s.CreatedTimestamp = &v
	return s
}

// SetImportDestination sets the ImportDestination field's value.
func (s *ImportJobSummary) SetImportDestination(v *ImportDestination) *ImportJobSummary {
	s.ImportDestination = v
	return s
}

// SetJobId sets the JobId field's value.
func (s *ImportJobSummary) SetJobId(v string) *ImportJobSummary {
	s.JobId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *ImportJobSummary) SetJobStatus(v string) *ImportJobSummary {
	s.JobStatus = &v
	return s
}

// An object that contains information about the inbox placement data settings
// for a verified domain that’s associated with your AWS account. This data
// is available only if you enabled the Deliverability dashboard for the domain.
type InboxPlacementTrackingOption struct {
	_ struct{} `type:"structure"`

	// Specifies whether inbox placement data is being tracked for the domain.
	Global *bool `type:"boolean"`

	// An array of strings, one for each major email provider that the inbox placement
	// data applies to.
	TrackedIsps []*string `type:"list"`
}

// String returns the string representation
func (s InboxPlacementTrackingOption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InboxPlacementTrackingOption) GoString() string {
	return s.String()
}

// SetGlobal sets the Global field's value.
func (s *InboxPlacementTrackingOption) SetGlobal(v bool) *InboxPlacementTrackingOption {
	s.Global = &v
	return s
}

// SetTrackedIsps sets the TrackedIsps field's value.
func (s *InboxPlacementTrackingOption) SetTrackedIsps(v []*string) *InboxPlacementTrackingOption {
	s.TrackedIsps = v
	return s
}

// The specified request includes an invalid or expired token.
type InvalidNextTokenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidNextTokenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidNextTokenException) GoString() string {
	return s.String()
}

func newErrorInvalidNextTokenException(v protocol.ResponseMetadata) error {
	return &InvalidNextTokenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidNextTokenException) Code() string {
	return "InvalidNextTokenException"
}

// Message returns the exception's message.
func (s *InvalidNextTokenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidNextTokenException) OrigErr() error {
	return nil
}

func (s *InvalidNextTokenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidNextTokenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidNextTokenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object that describes how email sent during the predictive inbox placement
// test was handled by a certain email provider.
type IspPlacement struct {
	_ struct{} `type:"structure"`

	// The name of the email provider that the inbox placement data applies to.
	IspName *string `type:"string"`

	// An object that contains inbox placement metrics for a specific email provider.
	PlacementStatistics *PlacementStatistics `type:"structure"`
}

// String returns the string representation
func (s IspPlacement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IspPlacement) GoString() string {
	return s.String()
}

// SetIspName sets the IspName field's value.
func (s *IspPlacement) SetIspName(v string) *IspPlacement {
	s.IspName = &v
	return s
}

// SetPlacementStatistics sets the PlacementStatistics field's value.
func (s *IspPlacement) SetPlacementStatistics(v *PlacementStatistics) *IspPlacement {
	s.PlacementStatistics = v
	return s
}

// An object that defines an Amazon Kinesis Data Firehose destination for email
// events. You can use Amazon Kinesis Data Firehose to stream data to other
// services, such as Amazon S3 and Amazon Redshift.
type KinesisFirehoseDestination struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon Kinesis Data Firehose stream
	// that the Amazon SES API v2 sends email events to.
	//
	// DeliveryStreamArn is a required field
	DeliveryStreamArn *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role that the Amazon SES API v2
	// uses to send email events to the Amazon Kinesis Data Firehose stream.
	//
	// IamRoleArn is a required field
	IamRoleArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s KinesisFirehoseDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KinesisFirehoseDestination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KinesisFirehoseDestination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KinesisFirehoseDestination"}
	if s.DeliveryStreamArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DeliveryStreamArn"))
	}
	if s.IamRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("IamRoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeliveryStreamArn sets the DeliveryStreamArn field's value.
func (s *KinesisFirehoseDestination) SetDeliveryStreamArn(v string) *KinesisFirehoseDestination {
	s.DeliveryStreamArn = &v
	return s
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *KinesisFirehoseDestination) SetIamRoleArn(v string) *KinesisFirehoseDestination {
	s.IamRoleArn = &v
	return s
}

// There are too many instances of the specified resource type.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A request to obtain a list of configuration sets for your Amazon SES account
// in the current AWS Region.
type ListConfigurationSetsInput struct {
	_ struct{} `type:"structure"`

	// A token returned from a previous call to ListConfigurationSets to indicate
	// the position in the list of configuration sets.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// The number of results to show in a single call to ListConfigurationSets.
	// If the number of results is larger than the number you specified in this
	// parameter, then the response includes a NextToken element, which you can
	// use to obtain additional results.
	PageSize *int64 `location:"querystring" locationName:"PageSize" type:"integer"`
}

// String returns the string representation
func (s ListConfigurationSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListConfigurationSetsInput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListConfigurationSetsInput) SetNextToken(v string) *ListConfigurationSetsInput {
	s.NextToken = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListConfigurationSetsInput) SetPageSize(v int64) *ListConfigurationSetsInput {
	s.PageSize = &v
	return s
}

// A list of configuration sets in your Amazon SES account in the current AWS
// Region.
type ListConfigurationSetsOutput struct {
	_ struct{} `type:"structure"`

	// An array that contains all of the configuration sets in your Amazon SES account
	// in the current AWS Region.
	ConfigurationSets []*string `type:"list"`

	// A token that indicates that there are additional configuration sets to list.
	// To view additional configuration sets, issue another request to ListConfigurationSets,
	// and pass this token in the NextToken parameter.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListConfigurationSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListConfigurationSetsOutput) GoString() string {
	return s.String()
}

// SetConfigurationSets sets the ConfigurationSets field's value.
func (s *ListConfigurationSetsOutput) SetConfigurationSets(v []*string) *ListConfigurationSetsOutput {
	s.ConfigurationSets = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConfigurationSetsOutput) SetNextToken(v string) *ListConfigurationSetsOutput {
	s.NextToken = &v
	return s
}

// Represents a request to list the existing custom verification email templates
// for your account.
type ListCustomVerificationEmailTemplatesInput struct {
	_ struct{} `type:"structure"`

	// A token returned from a previous call to ListCustomVerificationEmailTemplates
	// to indicate the position in the list of custom verification email templates.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// The number of results to show in a single call to ListCustomVerificationEmailTemplates.
	// If the number of results is larger than the number you specified in this
	// parameter, then the response includes a NextToken element, which you can
	// use to obtain additional results.
	//
	// The value you specify has to be at least 1, and can be no more than 50.
	PageSize *int64 `location:"querystring" locationName:"PageSize" type:"integer"`
}

// String returns the string representation
func (s ListCustomVerificationEmailTemplatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCustomVerificationEmailTemplatesInput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListCustomVerificationEmailTemplatesInput) SetNextToken(v string) *ListCustomVerificationEmailTemplatesInput {
	s.NextToken = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListCustomVerificationEmailTemplatesInput) SetPageSize(v int64) *ListCustomVerificationEmailTemplatesInput {
	s.PageSize = &v
	return s
}

// The following elements are returned by the service.
type ListCustomVerificationEmailTemplatesOutput struct {
	_ struct{} `type:"structure"`

	// A list of the custom verification email templates that exist in your account.
	CustomVerificationEmailTemplates []*CustomVerificationEmailTemplateMetadata `type:"list"`

	// A token indicating that there are additional custom verification email templates
	// available to be listed. Pass this token to a subsequent call to ListCustomVerificationEmailTemplates
	// to retrieve the next 50 custom verification email templates.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListCustomVerificationEmailTemplatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCustomVerificationEmailTemplatesOutput) GoString() string {
	return s.String()
}

// SetCustomVerificationEmailTemplates sets the CustomVerificationEmailTemplates field's value.
func (s *ListCustomVerificationEmailTemplatesOutput) SetCustomVerificationEmailTemplates(v []*CustomVerificationEmailTemplateMetadata) *ListCustomVerificationEmailTemplatesOutput {
	s.CustomVerificationEmailTemplates = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCustomVerificationEmailTemplatesOutput) SetNextToken(v string) *ListCustomVerificationEmailTemplatesOutput {
	s.NextToken = &v
	return s
}

// A request to obtain a list of dedicated IP pools.
type ListDedicatedIpPoolsInput struct {
	_ struct{} `type:"structure"`

	// A token returned from a previous call to ListDedicatedIpPools to indicate
	// the position in the list of dedicated IP pools.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// The number of results to show in a single call to ListDedicatedIpPools. If
	// the number of results is larger than the number you specified in this parameter,
	// then the response includes a NextToken element, which you can use to obtain
	// additional results.
	PageSize *int64 `location:"querystring" locationName:"PageSize" type:"integer"`
}

// String returns the string representation
func (s ListDedicatedIpPoolsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDedicatedIpPoolsInput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListDedicatedIpPoolsInput) SetNextToken(v string) *ListDedicatedIpPoolsInput {
	s.NextToken = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListDedicatedIpPoolsInput) SetPageSize(v int64) *ListDedicatedIpPoolsInput {
	s.PageSize = &v
	return s
}

// A list of dedicated IP pools.
type ListDedicatedIpPoolsOutput struct {
	_ struct{} `type:"structure"`

	// A list of all of the dedicated IP pools that are associated with your AWS
	// account in the current Region.
	DedicatedIpPools []*string `type:"list"`

	// A token that indicates that there are additional IP pools to list. To view
	// additional IP pools, issue another request to ListDedicatedIpPools, passing
	// this token in the NextToken parameter.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListDedicatedIpPoolsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDedicatedIpPoolsOutput) GoString() string {
	return s.String()
}

// SetDedicatedIpPools sets the DedicatedIpPools field's value.
func (s *ListDedicatedIpPoolsOutput) SetDedicatedIpPools(v []*string) *ListDedicatedIpPoolsOutput {
	s.DedicatedIpPools = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDedicatedIpPoolsOutput) SetNextToken(v string) *ListDedicatedIpPoolsOutput {
	s.NextToken = &v
	return s
}

// A request to list all of the predictive inbox placement tests that you've
// performed.
type ListDeliverabilityTestReportsInput struct {
	_ struct{} `type:"structure"`

	// A token returned from a previous call to ListDeliverabilityTestReports to
	// indicate the position in the list of predictive inbox placement tests.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// The number of results to show in a single call to ListDeliverabilityTestReports.
	// If the number of results is larger than the number you specified in this
	// parameter, then the response includes a NextToken element, which you can
	// use to obtain additional results.
	//
	// The value you specify has to be at least 0, and can be no more than 1000.
	PageSize *int64 `location:"querystring" locationName:"PageSize" type:"integer"`
}

// String returns the string representation
func (s ListDeliverabilityTestReportsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeliverabilityTestReportsInput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListDeliverabilityTestReportsInput) SetNextToken(v string) *ListDeliverabilityTestReportsInput {
	s.NextToken = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListDeliverabilityTestReportsInput) SetPageSize(v int64) *ListDeliverabilityTestReportsInput {
	s.PageSize = &v
	return s
}

// A list of the predictive inbox placement test reports that are available
// for your account, regardless of whether or not those tests are complete.
type ListDeliverabilityTestReportsOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains a lists of predictive inbox placement tests that
	// you've performed.
	//
	// DeliverabilityTestReports is a required field
	DeliverabilityTestReports []*DeliverabilityTestReport `type:"list" required:"true"`

	// A token that indicates that there are additional predictive inbox placement
	// tests to list. To view additional predictive inbox placement tests, issue
	// another request to ListDeliverabilityTestReports, and pass this token in
	// the NextToken parameter.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListDeliverabilityTestReportsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeliverabilityTestReportsOutput) GoString() string {
	return s.String()
}

// SetDeliverabilityTestReports sets the DeliverabilityTestReports field's value.
func (s *ListDeliverabilityTestReportsOutput) SetDeliverabilityTestReports(v []*DeliverabilityTestReport) *ListDeliverabilityTestReportsOutput {
	s.DeliverabilityTestReports = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDeliverabilityTestReportsOutput) SetNextToken(v string) *ListDeliverabilityTestReportsOutput {
	s.NextToken = &v
	return s
}

// Retrieve deliverability data for all the campaigns that used a specific domain
// to send email during a specified time range. This data is available for a
// domain only if you enabled the Deliverability dashboard.
type ListDomainDeliverabilityCampaignsInput struct {
	_ struct{} `type:"structure"`

	// The last day, in Unix time format, that you want to obtain deliverability
	// data for. This value has to be less than or equal to 30 days after the value
	// of the StartDate parameter.
	//
	// EndDate is a required field
	EndDate *time.Time `location:"querystring" locationName:"EndDate" type:"timestamp" required:"true"`

	// A token that’s returned from a previous call to the ListDomainDeliverabilityCampaigns
	// operation. This token indicates the position of a campaign in the list of
	// campaigns.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// The maximum number of results to include in response to a single call to
	// the ListDomainDeliverabilityCampaigns operation. If the number of results
	// is larger than the number that you specify in this parameter, the response
	// includes a NextToken element, which you can use to obtain additional results.
	PageSize *int64 `location:"querystring" locationName:"PageSize" type:"integer"`

	// The first day, in Unix time format, that you want to obtain deliverability
	// data for.
	//
	// StartDate is a required field
	StartDate *time.Time `location:"querystring" locationName:"StartDate" type:"timestamp" required:"true"`

	// The domain to obtain deliverability data for.
	//
	// SubscribedDomain is a required field
	SubscribedDomain *string `location:"uri" locationName:"SubscribedDomain" type:"string" required:"true"`
}

// String returns the string representation
func (s ListDomainDeliverabilityCampaignsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDomainDeliverabilityCampaignsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDomainDeliverabilityCampaignsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDomainDeliverabilityCampaignsInput"}
	if s.EndDate == nil {
		invalidParams.Add(request.NewErrParamRequired("EndDate"))
	}
	if s.StartDate == nil {
		invalidParams.Add(request.NewErrParamRequired("StartDate"))
	}
	if s.SubscribedDomain == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscribedDomain"))
	}
	if s.SubscribedDomain != nil && len(*s.SubscribedDomain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubscribedDomain", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndDate sets the EndDate field's value.
func (s *ListDomainDeliverabilityCampaignsInput) SetEndDate(v time.Time) *ListDomainDeliverabilityCampaignsInput {
	s.EndDate = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDomainDeliverabilityCampaignsInput) SetNextToken(v string) *ListDomainDeliverabilityCampaignsInput {
	s.NextToken = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListDomainDeliverabilityCampaignsInput) SetPageSize(v int64) *ListDomainDeliverabilityCampaignsInput {
	s.PageSize = &v
	return s
}

// SetStartDate sets the StartDate field's value.
func (s *ListDomainDeliverabilityCampaignsInput) SetStartDate(v time.Time) *ListDomainDeliverabilityCampaignsInput {
	s.StartDate = &v
	return s
}

// SetSubscribedDomain sets the SubscribedDomain field's value.
func (s *ListDomainDeliverabilityCampaignsInput) SetSubscribedDomain(v string) *ListDomainDeliverabilityCampaignsInput {
	s.SubscribedDomain = &v
	return s
}

// An array of objects that provide deliverability data for all the campaigns
// that used a specific domain to send email during a specified time range.
// This data is available for a domain only if you enabled the Deliverability
// dashboard for the domain.
type ListDomainDeliverabilityCampaignsOutput struct {
	_ struct{} `type:"structure"`

	// An array of responses, one for each campaign that used the domain to send
	// email during the specified time range.
	//
	// DomainDeliverabilityCampaigns is a required field
	DomainDeliverabilityCampaigns []*DomainDeliverabilityCampaign `type:"list" required:"true"`

	// A token that’s returned from a previous call to the ListDomainDeliverabilityCampaigns
	// operation. This token indicates the position of the campaign in the list
	// of campaigns.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListDomainDeliverabilityCampaignsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDomainDeliverabilityCampaignsOutput) GoString() string {
	return s.String()
}

// SetDomainDeliverabilityCampaigns sets the DomainDeliverabilityCampaigns field's value.
func (s *ListDomainDeliverabilityCampaignsOutput) SetDomainDeliverabilityCampaigns(v []*DomainDeliverabilityCampaign) *ListDomainDeliverabilityCampaignsOutput {
	s.DomainDeliverabilityCampaigns = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDomainDeliverabilityCampaignsOutput) SetNextToken(v string) *ListDomainDeliverabilityCampaignsOutput {
	s.NextToken = &v
	return s
}

// A request to list all of the email identities associated with your AWS account.
// This list includes identities that you've already verified, identities that
// are unverified, and identities that were verified in the past, but are no
// longer verified.
type ListEmailIdentitiesInput struct {
	_ struct{} `type:"structure"`

	// A token returned from a previous call to ListEmailIdentities to indicate
	// the position in the list of identities.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// The number of results to show in a single call to ListEmailIdentities. If
	// the number of results is larger than the number you specified in this parameter,
	// then the response includes a NextToken element, which you can use to obtain
	// additional results.
	//
	// The value you specify has to be at least 0, and can be no more than 1000.
	PageSize *int64 `location:"querystring" locationName:"PageSize" type:"integer"`
}

// String returns the string representation
func (s ListEmailIdentitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEmailIdentitiesInput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListEmailIdentitiesInput) SetNextToken(v string) *ListEmailIdentitiesInput {
	s.NextToken = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListEmailIdentitiesInput) SetPageSize(v int64) *ListEmailIdentitiesInput {
	s.PageSize = &v
	return s
}

// A list of all of the identities that you've attempted to verify, regardless
// of whether or not those identities were successfully verified.
type ListEmailIdentitiesOutput struct {
	_ struct{} `type:"structure"`

	// An array that includes all of the email identities associated with your AWS
	// account.
	EmailIdentities []*IdentityInfo `type:"list"`

	// A token that indicates that there are additional configuration sets to list.
	// To view additional configuration sets, issue another request to ListEmailIdentities,
	// and pass this token in the NextToken parameter.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListEmailIdentitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEmailIdentitiesOutput) GoString() string {
	return s.String()
}

// SetEmailIdentities sets the EmailIdentities field's value.
func (s *ListEmailIdentitiesOutput) SetEmailIdentities(v []*IdentityInfo) *ListEmailIdentitiesOutput {
	s.EmailIdentities = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEmailIdentitiesOutput) SetNextToken(v string) *ListEmailIdentitiesOutput {
	s.NextToken = &v
	return s
}

// Represents a request to list the email templates present in your Amazon SES
// account in the current AWS Region. For more information, see the Amazon SES
// Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html).
type ListEmailTemplatesInput struct {
	_ struct{} `type:"structure"`

	// A token returned from a previous call to ListEmailTemplates to indicate the
	// position in the list of email templates.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// The number of results to show in a single call to ListEmailTemplates. If
	// the number of results is larger than the number you specified in this parameter,
	// then the response includes a NextToken element, which you can use to obtain
	// additional results.
	//
	// The value you specify has to be at least 1, and can be no more than 10.
	PageSize *int64 `location:"querystring" locationName:"PageSize" type:"integer"`
}

// String returns the string representation
func (s ListEmailTemplatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEmailTemplatesInput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListEmailTemplatesInput) SetNextToken(v string) *ListEmailTemplatesInput {
	s.NextToken = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListEmailTemplatesInput) SetPageSize(v int64) *ListEmailTemplatesInput {
	s.PageSize = &v
	return s
}

// The following elements are returned by the service.
type ListEmailTemplatesOutput struct {
	_ struct{} `type:"structure"`

	// A token indicating that there are additional email templates available to
	// be listed. Pass this token to a subsequent ListEmailTemplates call to retrieve
	// the next 10 email templates.
	NextToken *string `type:"string"`

	// An array the contains the name and creation time stamp for each template
	// in your Amazon SES account.
	TemplatesMetadata []*EmailTemplateMetadata `type:"list"`
}

// String returns the string representation
func (s ListEmailTemplatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEmailTemplatesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListEmailTemplatesOutput) SetNextToken(v string) *ListEmailTemplatesOutput {
	s.NextToken = &v
	return s
}

// SetTemplatesMetadata sets the TemplatesMetadata field's value.
func (s *ListEmailTemplatesOutput) SetTemplatesMetadata(v []*EmailTemplateMetadata) *ListEmailTemplatesOutput {
	s.TemplatesMetadata = v
	return s
}

// Represents a request to list all of the import jobs for a data destination
// within the specified maximum number of import jobs.
type ListImportJobsInput struct {
	_ struct{} `type:"structure"`

	// The destination of the import job, which can be used to list import jobs
	// that have a certain ImportDestinationType.
	ImportDestinationType *string `type:"string" enum:"ImportDestinationType"`

	// A string token indicating that there might be additional import jobs available
	// to be listed. Copy this token to a subsequent call to ListImportJobs with
	// the same parameters to retrieve the next page of import jobs.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// Maximum number of import jobs to return at once. Use this parameter to paginate
	// results. If additional import jobs exist beyond the specified limit, the
	// NextToken element is sent in the response. Use the NextToken value in subsequent
	// requests to retrieve additional addresses.
	PageSize *int64 `location:"querystring" locationName:"PageSize" type:"integer"`
}

// String returns the string representation
func (s ListImportJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListImportJobsInput) GoString() string {
	return s.String()
}

// SetImportDestinationType sets the ImportDestinationType field's value.
func (s *ListImportJobsInput) SetImportDestinationType(v string) *ListImportJobsInput {
	s.ImportDestinationType = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListImportJobsInput) SetNextToken(v string) *ListImportJobsInput {
	s.NextToken = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListImportJobsInput) SetPageSize(v int64) *ListImportJobsInput {
	s.PageSize = &v
	return s
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type ListImportJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list of the import job summaries.
	ImportJobs []*ImportJobSummary `type:"list"`

	// A string token indicating that there might be additional import jobs available
	// to be listed. Copy this token to a subsequent call to ListImportJobs with
	// the same parameters to retrieve the next page of import jobs.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListImportJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListImportJobsOutput) GoString() string {
	return s.String()
}

// SetImportJobs sets the ImportJobs field's value.
func (s *ListImportJobsOutput) SetImportJobs(v []*ImportJobSummary) *ListImportJobsOutput {
	s.ImportJobs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListImportJobsOutput) SetNextToken(v string) *ListImportJobsOutput {
	s.NextToken = &v
	return s
}

// A request to obtain a list of email destinations that are on the suppression
// list for your account.
type ListSuppressedDestinationsInput struct {
	_ struct{} `type:"structure"`

	// Used to filter the list of suppressed email destinations so that it only
	// includes addresses that were added to the list before a specific date. The
	// date that you specify should be in Unix time format.
	EndDate *time.Time `location:"querystring" locationName:"EndDate" type:"timestamp"`

	// A token returned from a previous call to ListSuppressedDestinations to indicate
	// the position in the list of suppressed email addresses.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// The number of results to show in a single call to ListSuppressedDestinations.
	// If the number of results is larger than the number you specified in this
	// parameter, then the response includes a NextToken element, which you can
	// use to obtain additional results.
	PageSize *int64 `location:"querystring" locationName:"PageSize" type:"integer"`

	// The factors that caused the email address to be added to .
	Reasons []*string `location:"querystring" locationName:"Reason" type:"list"`

	// Used to filter the list of suppressed email destinations so that it only
	// includes addresses that were added to the list after a specific date. The
	// date that you specify should be in Unix time format.
	StartDate *time.Time `location:"querystring" locationName:"StartDate" type:"timestamp"`
}

// String returns the string representation
func (s ListSuppressedDestinationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSuppressedDestinationsInput) GoString() string {
	return s.String()
}

// SetEndDate sets the EndDate field's value.
func (s *ListSuppressedDestinationsInput) SetEndDate(v time.Time) *ListSuppressedDestinationsInput {
	s.EndDate = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSuppressedDestinationsInput) SetNextToken(v string) *ListSuppressedDestinationsInput {
	s.NextToken = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListSuppressedDestinationsInput) SetPageSize(v int64) *ListSuppressedDestinationsInput {
	s.PageSize = &v
	return s
}

// SetReasons sets the Reasons field's value.
func (s *ListSuppressedDestinationsInput) SetReasons(v []*string) *ListSuppressedDestinationsInput {
	s.Reasons = v
	return s
}

// SetStartDate sets the StartDate field's value.
func (s *ListSuppressedDestinationsInput) SetStartDate(v time.Time) *ListSuppressedDestinationsInput {
	s.StartDate = &v
	return s
}

// A list of suppressed email addresses.
type ListSuppressedDestinationsOutput struct {
	_ struct{} `type:"structure"`

	// A token that indicates that there are additional email addresses on the suppression
	// list for your account. To view additional suppressed addresses, issue another
	// request to ListSuppressedDestinations, and pass this token in the NextToken
	// parameter.
	NextToken *string `type:"string"`

	// A list of summaries, each containing a summary for a suppressed email destination.
	SuppressedDestinationSummaries []*SuppressedDestinationSummary `type:"list"`
}

// String returns the string representation
func (s ListSuppressedDestinationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSuppressedDestinationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSuppressedDestinationsOutput) SetNextToken(v string) *ListSuppressedDestinationsOutput {
	s.NextToken = &v
	return s
}

// SetSuppressedDestinationSummaries sets the SuppressedDestinationSummaries field's value.
func (s *ListSuppressedDestinationsOutput) SetSuppressedDestinationSummaries(v []*SuppressedDestinationSummary) *ListSuppressedDestinationsOutput {
	s.SuppressedDestinationSummaries = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource that you want to retrieve
	// tag information for.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"querystring" locationName:"ResourceArn" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// An array that lists all the tags that are associated with the resource. Each
	// tag consists of a required tag key (Key) and an associated tag value (Value)
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// A list of attributes that are associated with a MAIL FROM domain.
type MailFromAttributes struct {
	_ struct{} `type:"structure"`

	// The action that you want to take if the required MX record can't be found
	// when you send an email. When you set this value to UseDefaultValue, the mail
	// is sent using amazonses.com as the MAIL FROM domain. When you set this value
	// to RejectMessage, the Amazon SES API v2 returns a MailFromDomainNotVerified
	// error, and doesn't attempt to deliver the email.
	//
	// These behaviors are taken when the custom MAIL FROM domain configuration
	// is in the Pending, Failed, and TemporaryFailure states.
	//
	// BehaviorOnMxFailure is a required field
	BehaviorOnMxFailure *string `type:"string" required:"true" enum:"BehaviorOnMxFailure"`

	// The name of a domain that an email identity uses as a custom MAIL FROM domain.
	//
	// MailFromDomain is a required field
	MailFromDomain *string `type:"string" required:"true"`

	// The status of the MAIL FROM domain. This status can have the following values:
	//
	//    * PENDING – Amazon SES hasn't started searching for the MX record yet.
	//
	//    * SUCCESS – Amazon SES detected the required MX record for the MAIL
	//    FROM domain.
	//
	//    * FAILED – Amazon SES can't find the required MX record, or the record
	//    no longer exists.
	//
	//    * TEMPORARY_FAILURE – A temporary issue occurred, which prevented Amazon
	//    SES from determining the status of the MAIL FROM domain.
	//
	// MailFromDomainStatus is a required field
	MailFromDomainStatus *string `type:"string" required:"true" enum:"MailFromDomainStatus"`
}

// String returns the string representation
func (s MailFromAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MailFromAttributes) GoString() string {
	return s.String()
}

// SetBehaviorOnMxFailure sets the BehaviorOnMxFailure field's value.
func (s *MailFromAttributes) SetBehaviorOnMxFailure(v string) *MailFromAttributes {
	s.BehaviorOnMxFailure = &v
	return s
}

// SetMailFromDomain sets the MailFromDomain field's value.
func (s *MailFromAttributes) SetMailFromDomain(v string) *MailFromAttributes {
	s.MailFromDomain = &v
	return s
}

// SetMailFromDomainStatus sets the MailFromDomainStatus field's value.
func (s *MailFromAttributes) SetMailFromDomainStatus(v string) *MailFromAttributes {
	s.MailFromDomainStatus = &v
	return s
}

// The message can't be sent because the sending domain isn't verified.
type MailFromDomainNotVerifiedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s MailFromDomainNotVerifiedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MailFromDomainNotVerifiedException) GoString() string {
	return s.String()
}

func newErrorMailFromDomainNotVerifiedException(v protocol.ResponseMetadata) error {
	return &MailFromDomainNotVerifiedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MailFromDomainNotVerifiedException) Code() string {
	return "MailFromDomainNotVerifiedException"
}

// Message returns the exception's message.
func (s *MailFromDomainNotVerifiedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MailFromDomainNotVerifiedException) OrigErr() error {
	return nil
}

func (s *MailFromDomainNotVerifiedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MailFromDomainNotVerifiedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MailFromDomainNotVerifiedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents the email message that you're sending. The Message object consists
// of a subject line and a message body.
type Message struct {
	_ struct{} `type:"structure"`

	// The body of the message. You can specify an HTML version of the message,
	// a text-only version of the message, or both.
	//
	// Body is a required field
	Body *Body `type:"structure" required:"true"`

	// The subject line of the email. The subject line can only contain 7-bit ASCII
	// characters. However, you can specify non-ASCII characters in the subject
	// line by using encoded-word syntax, as described in RFC 2047 (https://tools.ietf.org/html/rfc2047).
	//
	// Subject is a required field
	Subject *Content `type:"structure" required:"true"`
}

// String returns the string representation
func (s Message) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Message) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Message) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Message"}
	if s.Body == nil {
		invalidParams.Add(request.NewErrParamRequired("Body"))
	}
	if s.Subject == nil {
		invalidParams.Add(request.NewErrParamRequired("Subject"))
	}
	if s.Body != nil {
		if err := s.Body.Validate(); err != nil {
			invalidParams.AddNested("Body", err.(request.ErrInvalidParams))
		}
	}
	if s.Subject != nil {
		if err := s.Subject.Validate(); err != nil {
			invalidParams.AddNested("Subject", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBody sets the Body field's value.
func (s *Message) SetBody(v *Body) *Message {
	s.Body = v
	return s
}

// SetSubject sets the Subject field's value.
func (s *Message) SetSubject(v *Content) *Message {
	s.Subject = v
	return s
}

// The message can't be sent because it contains invalid content.
type MessageRejected struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s MessageRejected) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MessageRejected) GoString() string {
	return s.String()
}

func newErrorMessageRejected(v protocol.ResponseMetadata) error {
	return &MessageRejected{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MessageRejected) Code() string {
	return "MessageRejected"
}

// Message returns the exception's message.
func (s *MessageRejected) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MessageRejected) OrigErr() error {
	return nil
}

func (s *MessageRejected) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MessageRejected) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MessageRejected) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains the name and value of a tag that you apply to an email. You can
// use message tags when you publish email sending events.
type MessageTag struct {
	_ struct{} `type:"structure"`

	// The name of the message tag. The message tag name has to meet the following
	// criteria:
	//
	//    * It can only contain ASCII letters (a–z, A–Z), numbers (0–9), underscores
	//    (_), or dashes (-).
	//
	//    * It can contain no more than 256 characters.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The value of the message tag. The message tag value has to meet the following
	// criteria:
	//
	//    * It can only contain ASCII letters (a–z, A–Z), numbers (0–9), underscores
	//    (_), or dashes (-).
	//
	//    * It can contain no more than 256 characters.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s MessageTag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MessageTag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MessageTag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MessageTag"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *MessageTag) SetName(v string) *MessageTag {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *MessageTag) SetValue(v string) *MessageTag {
	s.Value = &v
	return s
}

// The resource you attempted to access doesn't exist.
type NotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s NotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotFoundException) GoString() string {
	return s.String()
}

func newErrorNotFoundException(v protocol.ResponseMetadata) error {
	return &NotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotFoundException) Code() string {
	return "NotFoundException"
}

// Message returns the exception's message.
func (s *NotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotFoundException) OrigErr() error {
	return nil
}

func (s *NotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object that contains information about email that was sent from the selected
// domain.
type OverallVolume struct {
	_ struct{} `type:"structure"`

	// An object that contains inbox and junk mail placement metrics for individual
	// email providers.
	DomainIspPlacements []*DomainIspPlacement `type:"list"`

	// The percentage of emails that were sent from the domain that were read by
	// their recipients.
	ReadRatePercent *float64 `type:"double"`

	// An object that contains information about the numbers of messages that arrived
	// in recipients' inboxes and junk mail folders.
	VolumeStatistics *VolumeStatistics `type:"structure"`
}

// String returns the string representation
func (s OverallVolume) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OverallVolume) GoString() string {
	return s.String()
}

// SetDomainIspPlacements sets the DomainIspPlacements field's value.
func (s *OverallVolume) SetDomainIspPlacements(v []*DomainIspPlacement) *OverallVolume {
	s.DomainIspPlacements = v
	return s
}

// SetReadRatePercent sets the ReadRatePercent field's value.
func (s *OverallVolume) SetReadRatePercent(v float64) *OverallVolume {
	s.ReadRatePercent = &v
	return s
}

// SetVolumeStatistics sets the VolumeStatistics field's value.
func (s *OverallVolume) SetVolumeStatistics(v *VolumeStatistics) *OverallVolume {
	s.VolumeStatistics = v
	return s
}

// An object that defines an Amazon Pinpoint project destination for email events.
// You can send email event data to a Amazon Pinpoint project to view metrics
// using the Transactional Messaging dashboards that are built in to Amazon
// Pinpoint. For more information, see Transactional Messaging Charts (https://docs.aws.amazon.com/pinpoint/latest/userguide/analytics-transactional-messages.html)
// in the Amazon Pinpoint User Guide.
type PinpointDestination struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon Pinpoint project that you want
	// to send email events to.
	ApplicationArn *string `type:"string"`
}

// String returns the string representation
func (s PinpointDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PinpointDestination) GoString() string {
	return s.String()
}

// SetApplicationArn sets the ApplicationArn field's value.
func (s *PinpointDestination) SetApplicationArn(v string) *PinpointDestination {
	s.ApplicationArn = &v
	return s
}

// An object that contains inbox placement data for an email provider.
type PlacementStatistics struct {
	_ struct{} `type:"structure"`

	// The percentage of emails that were authenticated by using DomainKeys Identified
	// Mail (DKIM) during the predictive inbox placement test.
	DkimPercentage *float64 `type:"double"`

	// The percentage of emails that arrived in recipients' inboxes during the predictive
	// inbox placement test.
	InboxPercentage *float64 `type:"double"`

	// The percentage of emails that didn't arrive in recipients' inboxes at all
	// during the predictive inbox placement test.
	MissingPercentage *float64 `type:"double"`

	// The percentage of emails that arrived in recipients' spam or junk mail folders
	// during the predictive inbox placement test.
	SpamPercentage *float64 `type:"double"`

	// The percentage of emails that were authenticated by using Sender Policy Framework
	// (SPF) during the predictive inbox placement test.
	SpfPercentage *float64 `type:"double"`
}

// String returns the string representation
func (s PlacementStatistics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PlacementStatistics) GoString() string {
	return s.String()
}

// SetDkimPercentage sets the DkimPercentage field's value.
func (s *PlacementStatistics) SetDkimPercentage(v float64) *PlacementStatistics {
	s.DkimPercentage = &v
	return s
}

// SetInboxPercentage sets the InboxPercentage field's value.
func (s *PlacementStatistics) SetInboxPercentage(v float64) *PlacementStatistics {
	s.InboxPercentage = &v
	return s
}

// SetMissingPercentage sets the MissingPercentage field's value.
func (s *PlacementStatistics) SetMissingPercentage(v float64) *PlacementStatistics {
	s.MissingPercentage = &v
	return s
}

// SetSpamPercentage sets the SpamPercentage field's value.
func (s *PlacementStatistics) SetSpamPercentage(v float64) *PlacementStatistics {
	s.SpamPercentage = &v
	return s
}

// SetSpfPercentage sets the SpfPercentage field's value.
func (s *PlacementStatistics) SetSpfPercentage(v float64) *PlacementStatistics {
	s.SpfPercentage = &v
	return s
}

// A request to enable or disable the automatic IP address warm-up feature.
type PutAccountDedicatedIpWarmupAttributesInput struct {
	_ struct{} `type:"structure"`

	// Enables or disables the automatic warm-up feature for dedicated IP addresses
	// that are associated with your Amazon SES account in the current AWS Region.
	// Set to true to enable the automatic warm-up feature, or set to false to disable
	// it.
	AutoWarmupEnabled *bool `type:"boolean"`
}

// String returns the string representation
func (s PutAccountDedicatedIpWarmupAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutAccountDedicatedIpWarmupAttributesInput) GoString() string {
	return s.String()
}

// SetAutoWarmupEnabled sets the AutoWarmupEnabled field's value.
func (s *PutAccountDedicatedIpWarmupAttributesInput) SetAutoWarmupEnabled(v bool) *PutAccountDedicatedIpWarmupAttributesInput {
	s.AutoWarmupEnabled = &v
	return s
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type PutAccountDedicatedIpWarmupAttributesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutAccountDedicatedIpWarmupAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutAccountDedicatedIpWarmupAttributesOutput) GoString() string {
	return s.String()
}

// A request to submit new account details.
type PutAccountDetailsInput struct {
	_ struct{} `type:"structure"`

	// Additional email addresses that you would like to be notified regarding Amazon
	// SES matters.
	AdditionalContactEmailAddresses []*string `min:"1" type:"list" sensitive:"true"`

	// The language you would prefer to be contacted with.
	ContactLanguage *string `type:"string" enum:"ContactLanguage"`

	// The type of email your account will send.
	//
	// MailType is a required field
	MailType *string `type:"string" required:"true" enum:"MailType"`

	// Indicates whether or not your account should have production access in the
	// current AWS Region.
	//
	// If the value is false, then your account is in the sandbox. When your account
	// is in the sandbox, you can only send email to verified identities. Additionally,
	// the maximum number of emails you can send in a 24-hour period (your sending
	// quota) is 200, and the maximum number of emails you can send per second (your
	// maximum sending rate) is 1.
	//
	// If the value is true, then your account has production access. When your
	// account has production access, you can send email to any address. The sending
	// quota and maximum sending rate for your account vary based on your specific
	// use case.
	ProductionAccessEnabled *bool `type:"boolean"`

	// A description of the types of email that you plan to send.
	//
	// UseCaseDescription is a required field
	UseCaseDescription *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The URL of your website. This information helps us better understand the
	// type of content that you plan to send.
	//
	// WebsiteURL is a required field
	WebsiteURL *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s PutAccountDetailsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutAccountDetailsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutAccountDetailsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutAccountDetailsInput"}
	if s.AdditionalContactEmailAddresses != nil && len(s.AdditionalContactEmailAddresses) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AdditionalContactEmailAddresses", 1))
	}
	if s.MailType == nil {
		invalidParams.Add(request.NewErrParamRequired("MailType"))
	}
	if s.UseCaseDescription == nil {
		invalidParams.Add(request.NewErrParamRequired("UseCaseDescription"))
	}
	if s.UseCaseDescription != nil && len(*s.UseCaseDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UseCaseDescription", 1))
	}
	if s.WebsiteURL == nil {
		invalidParams.Add(request.NewErrParamRequired("WebsiteURL"))
	}
	if s.WebsiteURL != nil && len(*s.WebsiteURL) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WebsiteURL", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdditionalContactEmailAddresses sets the AdditionalContactEmailAddresses field's value.
func (s *PutAccountDetailsInput) SetAdditionalContactEmailAddresses(v []*string) *PutAccountDetailsInput {
	s.AdditionalContactEmailAddresses = v
	return s
}

// SetContactLanguage sets the ContactLanguage field's value.
func (s *PutAccountDetailsInput) SetContactLanguage(v string) *PutAccountDetailsInput {
	s.ContactLanguage = &v
	return s
}

// SetMailType sets the MailType field's value.
func (s *PutAccountDetailsInput) SetMailType(v string) *PutAccountDetailsInput {
	s.MailType = &v
	return s
}

// SetProductionAccessEnabled sets the ProductionAccessEnabled field's value.
func (s *PutAccountDetailsInput) SetProductionAccessEnabled(v bool) *PutAccountDetailsInput {
	s.ProductionAccessEnabled = &v
	return s
}

// SetUseCaseDescription sets the UseCaseDescription field's value.
func (s *PutAccountDetailsInput) SetUseCaseDescription(v string) *PutAccountDetailsInput {
	s.UseCaseDescription = &v
	return s
}

// SetWebsiteURL sets the WebsiteURL field's value.
func (s *PutAccountDetailsInput) SetWebsiteURL(v string) *PutAccountDetailsInput {
	s.WebsiteURL = &v
	return s
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type PutAccountDetailsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutAccountDetailsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutAccountDetailsOutput) GoString() string {
	return s.String()
}

// A request to change the ability of your account to send email.
type PutAccountSendingAttributesInput struct {
	_ struct{} `type:"structure"`

	// Enables or disables your account's ability to send email. Set to true to
	// enable email sending, or set to false to disable email sending.
	//
	// If AWS paused your account's ability to send email, you can't use this operation
	// to resume your account's ability to send email.
	SendingEnabled *bool `type:"boolean"`
}

// String returns the string representation
func (s PutAccountSendingAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutAccountSendingAttributesInput) GoString() string {
	return s.String()
}

// SetSendingEnabled sets the SendingEnabled field's value.
func (s *PutAccountSendingAttributesInput) SetSendingEnabled(v bool) *PutAccountSendingAttributesInput {
	s.SendingEnabled = &v
	return s
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type PutAccountSendingAttributesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutAccountSendingAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutAccountSendingAttributesOutput) GoString() string {
	return s.String()
}

// A request to change your account's suppression preferences.
type PutAccountSuppressionAttributesInput struct {
	_ struct{} `type:"structure"`

	// A list that contains the reasons that email addresses will be automatically
	// added to the suppression list for your account. This list can contain any
	// or all of the following:
	//
	//    * COMPLAINT – Amazon SES adds an email address to the suppression list
	//    for your account when a message sent to that address results in a complaint.
	//
	//    * BOUNCE – Amazon SES adds an email address to the suppression list
	//    for your account when a message sent to that address results in a hard
	//    bounce.
	SuppressedReasons []*string `type:"list"`
}

// String returns the string representation
func (s PutAccountSuppressionAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutAccountSuppressionAttributesInput) GoString() string {
	return s.String()
}

// SetSuppressedReasons sets the SuppressedReasons field's value.
func (s *PutAccountSuppressionAttributesInput) SetSuppressedReasons(v []*string) *PutAccountSuppressionAttributesInput {
	s.SuppressedReasons = v
	return s
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type PutAccountSuppressionAttributesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutAccountSuppressionAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutAccountSuppressionAttributesOutput) GoString() string {
	return s.String()
}

// A request to associate a configuration set with a dedicated IP pool.
type PutConfigurationSetDeliveryOptionsInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set that you want to associate with a dedicated
	// IP pool.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `location:"uri" locationName:"ConfigurationSetName" type:"string" required:"true"`

	// The name of the dedicated IP pool that you want to associate with the configuration
	// set.
	SendingPoolName *string `type:"string"`

	// Specifies whether messages that use the configuration set are required to
	// use Transport Layer Security (TLS). If the value is Require, messages are
	// only delivered if a TLS connection can be established. If the value is Optional,
	// messages can be delivered in plain text if a TLS connection can't be established.
	TlsPolicy *string `type:"string" enum:"TlsPolicy"`
}

// String returns the string representation
func (s PutConfigurationSetDeliveryOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutConfigurationSetDeliveryOptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutConfigurationSetDeliveryOptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutConfigurationSetDeliveryOptionsInput"}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}
	if s.ConfigurationSetName != nil && len(*s.ConfigurationSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationSetName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *PutConfigurationSetDeliveryOptionsInput) SetConfigurationSetName(v string) *PutConfigurationSetDeliveryOptionsInput {
	s.ConfigurationSetName = &v
	return s
}

// SetSendingPoolName sets the SendingPoolName field's value.
func (s *PutConfigurationSetDeliveryOptionsInput) SetSendingPoolName(v string) *PutConfigurationSetDeliveryOptionsInput {
	s.SendingPoolName = &v
	return s
}

// SetTlsPolicy sets the TlsPolicy field's value.
func (s *PutConfigurationSetDeliveryOptionsInput) SetTlsPolicy(v string) *PutConfigurationSetDeliveryOptionsInput {
	s.TlsPolicy = &v
	return s
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type PutConfigurationSetDeliveryOptionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutConfigurationSetDeliveryOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutConfigurationSetDeliveryOptionsOutput) GoString() string {
	return s.String()
}

// A request to enable or disable tracking of reputation metrics for a configuration
// set.
type PutConfigurationSetReputationOptionsInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set that you want to enable or disable reputation
	// metric tracking for.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `location:"uri" locationName:"ConfigurationSetName" type:"string" required:"true"`

	// If true, tracking of reputation metrics is enabled for the configuration
	// set. If false, tracking of reputation metrics is disabled for the configuration
	// set.
	ReputationMetricsEnabled *bool `type:"boolean"`
}

// String returns the string representation
func (s PutConfigurationSetReputationOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutConfigurationSetReputationOptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutConfigurationSetReputationOptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutConfigurationSetReputationOptionsInput"}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}
	if s.ConfigurationSetName != nil && len(*s.ConfigurationSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationSetName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *PutConfigurationSetReputationOptionsInput) SetConfigurationSetName(v string) *PutConfigurationSetReputationOptionsInput {
	s.ConfigurationSetName = &v
	return s
}

// SetReputationMetricsEnabled sets the ReputationMetricsEnabled field's value.
func (s *PutConfigurationSetReputationOptionsInput) SetReputationMetricsEnabled(v bool) *PutConfigurationSetReputationOptionsInput {
	s.ReputationMetricsEnabled = &v
	return s
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type PutConfigurationSetReputationOptionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutConfigurationSetReputationOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutConfigurationSetReputationOptionsOutput) GoString() string {
	return s.String()
}

// A request to enable or disable the ability of Amazon SES to send emails that
// use a specific configuration set.
type PutConfigurationSetSendingOptionsInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set that you want to enable or disable email
	// sending for.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `location:"uri" locationName:"ConfigurationSetName" type:"string" required:"true"`

	// If true, email sending is enabled for the configuration set. If false, email
	// sending is disabled for the configuration set.
	SendingEnabled *bool `type:"boolean"`
}

// String returns the string representation
func (s PutConfigurationSetSendingOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutConfigurationSetSendingOptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutConfigurationSetSendingOptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutConfigurationSetSendingOptionsInput"}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}
	if s.ConfigurationSetName != nil && len(*s.ConfigurationSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationSetName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *PutConfigurationSetSendingOptionsInput) SetConfigurationSetName(v string) *PutConfigurationSetSendingOptionsInput {
	s.ConfigurationSetName = &v
	return s
}

// SetSendingEnabled sets the SendingEnabled field's value.
func (s *PutConfigurationSetSendingOptionsInput) SetSendingEnabled(v bool) *PutConfigurationSetSendingOptionsInput {
	s.SendingEnabled = &v
	return s
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type PutConfigurationSetSendingOptionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutConfigurationSetSendingOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutConfigurationSetSendingOptionsOutput) GoString() string {
	return s.String()
}

// A request to change the account suppression list preferences for a specific
// configuration set.
type PutConfigurationSetSuppressionOptionsInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set that you want to change the suppression
	// list preferences for.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `location:"uri" locationName:"ConfigurationSetName" type:"string" required:"true"`

	// A list that contains the reasons that email addresses are automatically added
	// to the suppression list for your account. This list can contain any or all
	// of the following:
	//
	//    * COMPLAINT – Amazon SES adds an email address to the suppression list
	//    for your account when a message sent to that address results in a complaint.
	//
	//    * BOUNCE – Amazon SES adds an email address to the suppression list
	//    for your account when a message sent to that address results in a hard
	//    bounce.
	SuppressedReasons []*string `type:"list"`
}

// String returns the string representation
func (s PutConfigurationSetSuppressionOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutConfigurationSetSuppressionOptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutConfigurationSetSuppressionOptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutConfigurationSetSuppressionOptionsInput"}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}
	if s.ConfigurationSetName != nil && len(*s.ConfigurationSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationSetName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *PutConfigurationSetSuppressionOptionsInput) SetConfigurationSetName(v string) *PutConfigurationSetSuppressionOptionsInput {
	s.ConfigurationSetName = &v
	return s
}

// SetSuppressedReasons sets the SuppressedReasons field's value.
func (s *PutConfigurationSetSuppressionOptionsInput) SetSuppressedReasons(v []*string) *PutConfigurationSetSuppressionOptionsInput {
	s.SuppressedReasons = v
	return s
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type PutConfigurationSetSuppressionOptionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutConfigurationSetSuppressionOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutConfigurationSetSuppressionOptionsOutput) GoString() string {
	return s.String()
}

// A request to add a custom domain for tracking open and click events to a
// configuration set.
type PutConfigurationSetTrackingOptionsInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set that you want to add a custom tracking
	// domain to.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `location:"uri" locationName:"ConfigurationSetName" type:"string" required:"true"`

	// The domain that you want to use to track open and click events.
	CustomRedirectDomain *string `type:"string"`
}

// String returns the string representation
func (s PutConfigurationSetTrackingOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutConfigurationSetTrackingOptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutConfigurationSetTrackingOptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutConfigurationSetTrackingOptionsInput"}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}
	if s.ConfigurationSetName != nil && len(*s.ConfigurationSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationSetName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *PutConfigurationSetTrackingOptionsInput) SetConfigurationSetName(v string) *PutConfigurationSetTrackingOptionsInput {
	s.ConfigurationSetName = &v
	return s
}

// SetCustomRedirectDomain sets the CustomRedirectDomain field's value.
func (s *PutConfigurationSetTrackingOptionsInput) SetCustomRedirectDomain(v string) *PutConfigurationSetTrackingOptionsInput {
	s.CustomRedirectDomain = &v
	return s
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type PutConfigurationSetTrackingOptionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutConfigurationSetTrackingOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutConfigurationSetTrackingOptionsOutput) GoString() string {
	return s.String()
}

// A request to move a dedicated IP address to a dedicated IP pool.
type PutDedicatedIpInPoolInput struct {
	_ struct{} `type:"structure"`

	// The name of the IP pool that you want to add the dedicated IP address to.
	// You have to specify an IP pool that already exists.
	//
	// DestinationPoolName is a required field
	DestinationPoolName *string `type:"string" required:"true"`

	// The IP address that you want to move to the dedicated IP pool. The value
	// you specify has to be a dedicated IP address that's associated with your
	// AWS account.
	//
	// Ip is a required field
	Ip *string `location:"uri" locationName:"IP" type:"string" required:"true"`
}

// String returns the string representation
func (s PutDedicatedIpInPoolInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutDedicatedIpInPoolInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutDedicatedIpInPoolInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutDedicatedIpInPoolInput"}
	if s.DestinationPoolName == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationPoolName"))
	}
	if s.Ip == nil {
		invalidParams.Add(request.NewErrParamRequired("Ip"))
	}
	if s.Ip != nil && len(*s.Ip) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Ip", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinationPoolName sets the DestinationPoolName field's value.
func (s *PutDedicatedIpInPoolInput) SetDestinationPoolName(v string) *PutDedicatedIpInPoolInput {
	s.DestinationPoolName = &v
	return s
}

// SetIp sets the Ip field's value.
func (s *PutDedicatedIpInPoolInput) SetIp(v string) *PutDedicatedIpInPoolInput {
	s.Ip = &v
	return s
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type PutDedicatedIpInPoolOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutDedicatedIpInPoolOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutDedicatedIpInPoolOutput) GoString() string {
	return s.String()
}

// A request to change the warm-up attributes for a dedicated IP address. This
// operation is useful when you want to resume the warm-up process for an existing
// IP address.
type PutDedicatedIpWarmupAttributesInput struct {
	_ struct{} `type:"structure"`

	// The dedicated IP address that you want to update the warm-up attributes for.
	//
	// Ip is a required field
	Ip *string `location:"uri" locationName:"IP" type:"string" required:"true"`

	// The warm-up percentage that you want to associate with the dedicated IP address.
	//
	// WarmupPercentage is a required field
	WarmupPercentage *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s PutDedicatedIpWarmupAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutDedicatedIpWarmupAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutDedicatedIpWarmupAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutDedicatedIpWarmupAttributesInput"}
	if s.Ip == nil {
		invalidParams.Add(request.NewErrParamRequired("Ip"))
	}
	if s.Ip != nil && len(*s.Ip) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Ip", 1))
	}
	if s.WarmupPercentage == nil {
		invalidParams.Add(request.NewErrParamRequired("WarmupPercentage"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIp sets the Ip field's value.
func (s *PutDedicatedIpWarmupAttributesInput) SetIp(v string) *PutDedicatedIpWarmupAttributesInput {
	s.Ip = &v
	return s
}

// SetWarmupPercentage sets the WarmupPercentage field's value.
func (s *PutDedicatedIpWarmupAttributesInput) SetWarmupPercentage(v int64) *PutDedicatedIpWarmupAttributesInput {
	s.WarmupPercentage = &v
	return s
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type PutDedicatedIpWarmupAttributesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutDedicatedIpWarmupAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutDedicatedIpWarmupAttributesOutput) GoString() string {
	return s.String()
}

// Enable or disable the Deliverability dashboard. When you enable the Deliverability
// dashboard, you gain access to reputation, deliverability, and other metrics
// for the domains that you use to send email using Amazon SES API v2. You also
// gain the ability to perform predictive inbox placement tests.
//
// When you use the Deliverability dashboard, you pay a monthly subscription
// charge, in addition to any other fees that you accrue by using Amazon SES
// and other AWS services. For more information about the features and cost
// of a Deliverability dashboard subscription, see Amazon Pinpoint Pricing (http://aws.amazon.com/pinpoint/pricing/).
type PutDeliverabilityDashboardOptionInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether to enable the Deliverability dashboard. To enable the dashboard,
	// set this value to true.
	//
	// DashboardEnabled is a required field
	DashboardEnabled *bool `type:"boolean" required:"true"`

	// An array of objects, one for each verified domain that you use to send email
	// and enabled the Deliverability dashboard for.
	SubscribedDomains []*DomainDeliverabilityTrackingOption `type:"list"`
}

// String returns the string representation
func (s PutDeliverabilityDashboardOptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutDeliverabilityDashboardOptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutDeliverabilityDashboardOptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutDeliverabilityDashboardOptionInput"}
	if s.DashboardEnabled == nil {
		invalidParams.Add(request.NewErrParamRequired("DashboardEnabled"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDashboardEnabled sets the DashboardEnabled field's value.
func (s *PutDeliverabilityDashboardOptionInput) SetDashboardEnabled(v bool) *PutDeliverabilityDashboardOptionInput {
	s.DashboardEnabled = &v
	return s
}

// SetSubscribedDomains sets the SubscribedDomains field's value.
func (s *PutDeliverabilityDashboardOptionInput) SetSubscribedDomains(v []*DomainDeliverabilityTrackingOption) *PutDeliverabilityDashboardOptionInput {
	s.SubscribedDomains = v
	return s
}

// A response that indicates whether the Deliverability dashboard is enabled.
type PutDeliverabilityDashboardOptionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutDeliverabilityDashboardOptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutDeliverabilityDashboardOptionOutput) GoString() string {
	return s.String()
}

// A request to enable or disable DKIM signing of email that you send from an
// email identity.
type PutEmailIdentityDkimAttributesInput struct {
	_ struct{} `type:"structure"`

	// The email identity that you want to change the DKIM settings for.
	//
	// EmailIdentity is a required field
	EmailIdentity *string `location:"uri" locationName:"EmailIdentity" min:"1" type:"string" required:"true"`

	// Sets the DKIM signing configuration for the identity.
	//
	// When you set this value true, then the messages that are sent from the identity
	// are signed using DKIM. If you set this value to false, your messages are
	// sent without DKIM signing.
	SigningEnabled *bool `type:"boolean"`
}

// String returns the string representation
func (s PutEmailIdentityDkimAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutEmailIdentityDkimAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutEmailIdentityDkimAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutEmailIdentityDkimAttributesInput"}
	if s.EmailIdentity == nil {
		invalidParams.Add(request.NewErrParamRequired("EmailIdentity"))
	}
	if s.EmailIdentity != nil && len(*s.EmailIdentity) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EmailIdentity", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEmailIdentity sets the EmailIdentity field's value.
func (s *PutEmailIdentityDkimAttributesInput) SetEmailIdentity(v string) *PutEmailIdentityDkimAttributesInput {
	s.EmailIdentity = &v
	return s
}

// SetSigningEnabled sets the SigningEnabled field's value.
func (s *PutEmailIdentityDkimAttributesInput) SetSigningEnabled(v bool) *PutEmailIdentityDkimAttributesInput {
	s.SigningEnabled = &v
	return s
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type PutEmailIdentityDkimAttributesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutEmailIdentityDkimAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutEmailIdentityDkimAttributesOutput) GoString() string {
	return s.String()
}

// A request to change the DKIM attributes for an email identity.
type PutEmailIdentityDkimSigningAttributesInput struct {
	_ struct{} `type:"structure"`

	// The email identity that you want to configure DKIM for.
	//
	// EmailIdentity is a required field
	EmailIdentity *string `location:"uri" locationName:"EmailIdentity" min:"1" type:"string" required:"true"`

	// An object that contains information about the private key and selector that
	// you want to use to configure DKIM for the identity. This object is only required
	// if you want to configure Bring Your Own DKIM (BYODKIM) for the identity.
	SigningAttributes *DkimSigningAttributes `type:"structure"`

	// The method that you want to use to configure DKIM for the identity. There
	// are two possible values:
	//
	//    * AWS_SES – Configure DKIM for the identity by using Easy DKIM (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html).
	//
	//    * EXTERNAL – Configure DKIM for the identity by using Bring Your Own
	//    DKIM (BYODKIM).
	//
	// SigningAttributesOrigin is a required field
	SigningAttributesOrigin *string `type:"string" required:"true" enum:"DkimSigningAttributesOrigin"`
}

// String returns the string representation
func (s PutEmailIdentityDkimSigningAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutEmailIdentityDkimSigningAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutEmailIdentityDkimSigningAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutEmailIdentityDkimSigningAttributesInput"}
	if s.EmailIdentity == nil {
		invalidParams.Add(request.NewErrParamRequired("EmailIdentity"))
	}
	if s.EmailIdentity != nil && len(*s.EmailIdentity) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EmailIdentity", 1))
	}
	if s.SigningAttributesOrigin == nil {
		invalidParams.Add(request.NewErrParamRequired("SigningAttributesOrigin"))
	}
	if s.SigningAttributes != nil {
		if err := s.SigningAttributes.Validate(); err != nil {
			invalidParams.AddNested("SigningAttributes", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEmailIdentity sets the EmailIdentity field's value.
func (s *PutEmailIdentityDkimSigningAttributesInput) SetEmailIdentity(v string) *PutEmailIdentityDkimSigningAttributesInput {
	s.EmailIdentity = &v
	return s
}

// SetSigningAttributes sets the SigningAttributes field's value.
func (s *PutEmailIdentityDkimSigningAttributesInput) SetSigningAttributes(v *DkimSigningAttributes) *PutEmailIdentityDkimSigningAttributesInput {
	s.SigningAttributes = v
	return s
}

// SetSigningAttributesOrigin sets the SigningAttributesOrigin field's value.
func (s *PutEmailIdentityDkimSigningAttributesInput) SetSigningAttributesOrigin(v string) *PutEmailIdentityDkimSigningAttributesInput {
	s.SigningAttributesOrigin = &v
	return s
}

// If the action is successful, the service sends back an HTTP 200 response.
//
// The following data is returned in JSON format by the service.
type PutEmailIdentityDkimSigningAttributesOutput struct {
	_ struct{} `type:"structure"`

	// The DKIM authentication status of the identity. Amazon SES determines the
	// authentication status by searching for specific records in the DNS configuration
	// for your domain. If you used Easy DKIM (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html)
	// to set up DKIM authentication, Amazon SES tries to find three unique CNAME
	// records in the DNS configuration for your domain.
	//
	// If you provided a public key to perform DKIM authentication, Amazon SES tries
	// to find a TXT record that uses the selector that you specified. The value
	// of the TXT record must be a public key that's paired with the private key
	// that you specified in the process of creating the identity.
	//
	// The status can be one of the following:
	//
	//    * PENDING – The verification process was initiated, but Amazon SES hasn't
	//    yet detected the DKIM records in the DNS configuration for the domain.
	//
	//    * SUCCESS – The verification process completed successfully.
	//
	//    * FAILED – The verification process failed. This typically occurs when
	//    Amazon SES fails to find the DKIM records in the DNS configuration of
	//    the domain.
	//
	//    * TEMPORARY_FAILURE – A temporary issue is preventing Amazon SES from
	//    determining the DKIM authentication status of the domain.
	//
	//    * NOT_STARTED – The DKIM verification process hasn't been initiated
	//    for the domain.
	DkimStatus *string `type:"string" enum:"DkimStatus"`

	// If you used Easy DKIM (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html)
	// to configure DKIM authentication for the domain, then this object contains
	// a set of unique strings that you use to create a set of CNAME records that
	// you add to the DNS configuration for your domain. When Amazon SES detects
	// these records in the DNS configuration for your domain, the DKIM authentication
	// process is complete.
	//
	// If you configured DKIM authentication for the domain by providing your own
	// public-private key pair, then this object contains the selector that's associated
	// with your public key.
	//
	// Regardless of the DKIM authentication method you use, Amazon SES searches
	// for the appropriate records in the DNS configuration of the domain for up
	// to 72 hours.
	DkimTokens []*string `type:"list"`
}

// String returns the string representation
func (s PutEmailIdentityDkimSigningAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutEmailIdentityDkimSigningAttributesOutput) GoString() string {
	return s.String()
}

// SetDkimStatus sets the DkimStatus field's value.
func (s *PutEmailIdentityDkimSigningAttributesOutput) SetDkimStatus(v string) *PutEmailIdentityDkimSigningAttributesOutput {
	s.DkimStatus = &v
	return s
}

// SetDkimTokens sets the DkimTokens field's value.
func (s *PutEmailIdentityDkimSigningAttributesOutput) SetDkimTokens(v []*string) *PutEmailIdentityDkimSigningAttributesOutput {
	s.DkimTokens = v
	return s
}

// A request to set the attributes that control how bounce and complaint events
// are processed.
type PutEmailIdentityFeedbackAttributesInput struct {
	_ struct{} `type:"structure"`

	// Sets the feedback forwarding configuration for the identity.
	//
	// If the value is true, you receive email notifications when bounce or complaint
	// events occur. These notifications are sent to the address that you specified
	// in the Return-Path header of the original email.
	//
	// You're required to have a method of tracking bounces and complaints. If you
	// haven't set up another mechanism for receiving bounce or complaint notifications
	// (for example, by setting up an event destination), you receive an email notification
	// when these events occur (even if this setting is disabled).
	EmailForwardingEnabled *bool `type:"boolean"`

	// The email identity that you want to configure bounce and complaint feedback
	// forwarding for.
	//
	// EmailIdentity is a required field
	EmailIdentity *string `location:"uri" locationName:"EmailIdentity" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutEmailIdentityFeedbackAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutEmailIdentityFeedbackAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutEmailIdentityFeedbackAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutEmailIdentityFeedbackAttributesInput"}
	if s.EmailIdentity == nil {
		invalidParams.Add(request.NewErrParamRequired("EmailIdentity"))
	}
	if s.EmailIdentity != nil && len(*s.EmailIdentity) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EmailIdentity", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEmailForwardingEnabled sets the EmailForwardingEnabled field's value.
func (s *PutEmailIdentityFeedbackAttributesInput) SetEmailForwardingEnabled(v bool) *PutEmailIdentityFeedbackAttributesInput {
	s.EmailForwardingEnabled = &v
	return s
}

// SetEmailIdentity sets the EmailIdentity field's value.
func (s *PutEmailIdentityFeedbackAttributesInput) SetEmailIdentity(v string) *PutEmailIdentityFeedbackAttributesInput {
	s.EmailIdentity = &v
	return s
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type PutEmailIdentityFeedbackAttributesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutEmailIdentityFeedbackAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutEmailIdentityFeedbackAttributesOutput) GoString() string {
	return s.String()
}

// A request to configure the custom MAIL FROM domain for a verified identity.
type PutEmailIdentityMailFromAttributesInput struct {
	_ struct{} `type:"structure"`

	// The action that you want to take if the required MX record isn't found when
	// you send an email. When you set this value to UseDefaultValue, the mail is
	// sent using amazonses.com as the MAIL FROM domain. When you set this value
	// to RejectMessage, the Amazon SES API v2 returns a MailFromDomainNotVerified
	// error, and doesn't attempt to deliver the email.
	//
	// These behaviors are taken when the custom MAIL FROM domain configuration
	// is in the Pending, Failed, and TemporaryFailure states.
	BehaviorOnMxFailure *string `type:"string" enum:"BehaviorOnMxFailure"`

	// The verified email identity that you want to set up the custom MAIL FROM
	// domain for.
	//
	// EmailIdentity is a required field
	EmailIdentity *string `location:"uri" locationName:"EmailIdentity" min:"1" type:"string" required:"true"`

	// The custom MAIL FROM domain that you want the verified identity to use. The
	// MAIL FROM domain must meet the following criteria:
	//
	//    * It has to be a subdomain of the verified identity.
	//
	//    * It can't be used to receive email.
	//
	//    * It can't be used in a "From" address if the MAIL FROM domain is a destination
	//    for feedback forwarding emails.
	MailFromDomain *string `type:"string"`
}

// String returns the string representation
func (s PutEmailIdentityMailFromAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutEmailIdentityMailFromAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutEmailIdentityMailFromAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutEmailIdentityMailFromAttributesInput"}
	if s.EmailIdentity == nil {
		invalidParams.Add(request.NewErrParamRequired("EmailIdentity"))
	}
	if s.EmailIdentity != nil && len(*s.EmailIdentity) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EmailIdentity", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBehaviorOnMxFailure sets the BehaviorOnMxFailure field's value.
func (s *PutEmailIdentityMailFromAttributesInput) SetBehaviorOnMxFailure(v string) *PutEmailIdentityMailFromAttributesInput {
	s.BehaviorOnMxFailure = &v
	return s
}

// SetEmailIdentity sets the EmailIdentity field's value.
func (s *PutEmailIdentityMailFromAttributesInput) SetEmailIdentity(v string) *PutEmailIdentityMailFromAttributesInput {
	s.EmailIdentity = &v
	return s
}

// SetMailFromDomain sets the MailFromDomain field's value.
func (s *PutEmailIdentityMailFromAttributesInput) SetMailFromDomain(v string) *PutEmailIdentityMailFromAttributesInput {
	s.MailFromDomain = &v
	return s
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type PutEmailIdentityMailFromAttributesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutEmailIdentityMailFromAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutEmailIdentityMailFromAttributesOutput) GoString() string {
	return s.String()
}

// A request to add an email destination to the suppression list for your account.
type PutSuppressedDestinationInput struct {
	_ struct{} `type:"structure"`

	// The email address that should be added to the suppression list for your account.
	//
	// EmailAddress is a required field
	EmailAddress *string `type:"string" required:"true"`

	// The factors that should cause the email address to be added to the suppression
	// list for your account.
	//
	// Reason is a required field
	Reason *string `type:"string" required:"true" enum:"SuppressionListReason"`
}

// String returns the string representation
func (s PutSuppressedDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutSuppressedDestinationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutSuppressedDestinationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutSuppressedDestinationInput"}
	if s.EmailAddress == nil {
		invalidParams.Add(request.NewErrParamRequired("EmailAddress"))
	}
	if s.Reason == nil {
		invalidParams.Add(request.NewErrParamRequired("Reason"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEmailAddress sets the EmailAddress field's value.
func (s *PutSuppressedDestinationInput) SetEmailAddress(v string) *PutSuppressedDestinationInput {
	s.EmailAddress = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *PutSuppressedDestinationInput) SetReason(v string) *PutSuppressedDestinationInput {
	s.Reason = &v
	return s
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type PutSuppressedDestinationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutSuppressedDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutSuppressedDestinationOutput) GoString() string {
	return s.String()
}

// Represents the raw content of an email message.
type RawMessage struct {
	_ struct{} `type:"structure"`

	// The raw email message. The message has to meet the following criteria:
	//
	//    * The message has to contain a header and a body, separated by one blank
	//    line.
	//
	//    * All of the required header fields must be present in the message.
	//
	//    * Each part of a multipart MIME message must be formatted properly.
	//
	//    * Attachments must be in a file format that the Amazon SES supports.
	//
	//    * The entire message must be Base64 encoded.
	//
	//    * If any of the MIME parts in your message contain content that is outside
	//    of the 7-bit ASCII character range, you should encode that content to
	//    ensure that recipients' email clients render the message properly.
	//
	//    * The length of any single line of text in the message can't exceed 1,000
	//    characters. This restriction is defined in RFC 5321 (https://tools.ietf.org/html/rfc5321).
	//
	// Data is automatically base64 encoded/decoded by the SDK.
	//
	// Data is a required field
	Data []byte `type:"blob" required:"true"`
}

// String returns the string representation
func (s RawMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RawMessage) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RawMessage) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RawMessage"}
	if s.Data == nil {
		invalidParams.Add(request.NewErrParamRequired("Data"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetData sets the Data field's value.
func (s *RawMessage) SetData(v []byte) *RawMessage {
	s.Data = v
	return s
}

// The ReplaceEmailContent object to be used for a specific BulkEmailEntry.
// The ReplacementTemplate can be specified within this object.
type ReplacementEmailContent struct {
	_ struct{} `type:"structure"`

	// The ReplacementTemplate associated with ReplacementEmailContent.
	ReplacementTemplate *ReplacementTemplate `type:"structure"`
}

// String returns the string representation
func (s ReplacementEmailContent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplacementEmailContent) GoString() string {
	return s.String()
}

// SetReplacementTemplate sets the ReplacementTemplate field's value.
func (s *ReplacementEmailContent) SetReplacementTemplate(v *ReplacementTemplate) *ReplacementEmailContent {
	s.ReplacementTemplate = v
	return s
}

// An object which contains ReplacementTemplateData to be used for a specific
// BulkEmailEntry.
type ReplacementTemplate struct {
	_ struct{} `type:"structure"`

	// A list of replacement values to apply to the template. This parameter is
	// a JSON object, typically consisting of key-value pairs in which the keys
	// correspond to replacement tags in the email template.
	ReplacementTemplateData *string `type:"string"`
}

// String returns the string representation
func (s ReplacementTemplate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplacementTemplate) GoString() string {
	return s.String()
}

// SetReplacementTemplateData sets the ReplacementTemplateData field's value.
func (s *ReplacementTemplate) SetReplacementTemplateData(v string) *ReplacementTemplate {
	s.ReplacementTemplateData = &v
	return s
}

// Enable or disable collection of reputation metrics for emails that you send
// using this configuration set in the current AWS Region.
type ReputationOptions struct {
	_ struct{} `type:"structure"`

	// The date and time (in Unix time) when the reputation metrics were last given
	// a fresh start. When your account is given a fresh start, your reputation
	// metrics are calculated starting from the date of the fresh start.
	LastFreshStart *time.Time `type:"timestamp"`

	// If true, tracking of reputation metrics is enabled for the configuration
	// set. If false, tracking of reputation metrics is disabled for the configuration
	// set.
	ReputationMetricsEnabled *bool `type:"boolean"`
}

// String returns the string representation
func (s ReputationOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReputationOptions) GoString() string {
	return s.String()
}

// SetLastFreshStart sets the LastFreshStart field's value.
func (s *ReputationOptions) SetLastFreshStart(v time.Time) *ReputationOptions {
	s.LastFreshStart = &v
	return s
}

// SetReputationMetricsEnabled sets the ReputationMetricsEnabled field's value.
func (s *ReputationOptions) SetReputationMetricsEnabled(v bool) *ReputationOptions {
	s.ReputationMetricsEnabled = &v
	return s
}

// An object that contains information about your account details review.
type ReviewDetails struct {
	_ struct{} `type:"structure"`

	// The associated support center case ID (if any).
	CaseId *string `type:"string"`

	// The status of the latest review of your account. The status can be one of
	// the following:
	//
	//    * PENDING – We have received your appeal and are in the process of reviewing
	//    it.
	//
	//    * GRANTED – Your appeal has been reviewed and your production access
	//    has been granted.
	//
	//    * DENIED – Your appeal has been reviewed and your production access
	//    has been denied.
	//
	//    * FAILED – An internal error occurred and we didn't receive your appeal.
	//    You can submit your appeal again.
	Status *string `type:"string" enum:"ReviewStatus"`
}

// String returns the string representation
func (s ReviewDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReviewDetails) GoString() string {
	return s.String()
}

// SetCaseId sets the CaseId field's value.
func (s *ReviewDetails) SetCaseId(v string) *ReviewDetails {
	s.CaseId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ReviewDetails) SetStatus(v string) *ReviewDetails {
	s.Status = &v
	return s
}

// Represents a request to send email messages to multiple destinations using
// Amazon SES. For more information, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html).
type SendBulkEmailInput struct {
	_ struct{} `type:"structure"`

	// The list of bulk email entry objects.
	//
	// BulkEmailEntries is a required field
	BulkEmailEntries []*BulkEmailEntry `type:"list" required:"true"`

	// The name of the configuration set that you want to use when sending the email.
	ConfigurationSetName *string `type:"string"`

	// An object that contains the body of the message. You can specify a template
	// message.
	//
	// DefaultContent is a required field
	DefaultContent *BulkEmailContent `type:"structure" required:"true"`

	// A list of tags, in the form of name/value pairs, to apply to an email that
	// you send using the SendEmail operation. Tags correspond to characteristics
	// of the email that you define, so that you can publish email sending events.
	DefaultEmailTags []*MessageTag `type:"list"`

	// The address that you want bounce and complaint notifications to be sent to.
	FeedbackForwardingEmailAddress *string `type:"string"`

	// This parameter is used only for sending authorization. It is the ARN of the
	// identity that is associated with the sending authorization policy that permits
	// you to use the email address specified in the FeedbackForwardingEmailAddress
	// parameter.
	//
	// For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com)
	// attaches a policy to it that authorizes you to use feedback@example.com,
	// then you would specify the FeedbackForwardingEmailAddressIdentityArn to be
	// arn:aws:ses:us-east-1:123456789012:identity/example.com, and the FeedbackForwardingEmailAddress
	// to be feedback@example.com.
	//
	// For more information about sending authorization, see the Amazon SES Developer
	// Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
	FeedbackForwardingEmailAddressIdentityArn *string `type:"string"`

	// The email address that you want to use as the "From" address for the email.
	// The address that you specify has to be verified.
	FromEmailAddress *string `type:"string"`

	// This parameter is used only for sending authorization. It is the ARN of the
	// identity that is associated with the sending authorization policy that permits
	// you to use the email address specified in the FromEmailAddress parameter.
	//
	// For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com)
	// attaches a policy to it that authorizes you to use sender@example.com, then
	// you would specify the FromEmailAddressIdentityArn to be arn:aws:ses:us-east-1:123456789012:identity/example.com,
	// and the FromEmailAddress to be sender@example.com.
	//
	// For more information about sending authorization, see the Amazon SES Developer
	// Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
	FromEmailAddressIdentityArn *string `type:"string"`

	// The "Reply-to" email addresses for the message. When the recipient replies
	// to the message, each Reply-to address receives the reply.
	ReplyToAddresses []*string `type:"list"`
}

// String returns the string representation
func (s SendBulkEmailInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendBulkEmailInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendBulkEmailInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendBulkEmailInput"}
	if s.BulkEmailEntries == nil {
		invalidParams.Add(request.NewErrParamRequired("BulkEmailEntries"))
	}
	if s.DefaultContent == nil {
		invalidParams.Add(request.NewErrParamRequired("DefaultContent"))
	}
	if s.BulkEmailEntries != nil {
		for i, v := range s.BulkEmailEntries {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "BulkEmailEntries", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.DefaultContent != nil {
		if err := s.DefaultContent.Validate(); err != nil {
			invalidParams.AddNested("DefaultContent", err.(request.ErrInvalidParams))
		}
	}
	if s.DefaultEmailTags != nil {
		for i, v := range s.DefaultEmailTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DefaultEmailTags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBulkEmailEntries sets the BulkEmailEntries field's value.
func (s *SendBulkEmailInput) SetBulkEmailEntries(v []*BulkEmailEntry) *SendBulkEmailInput {
	s.BulkEmailEntries = v
	return s
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *SendBulkEmailInput) SetConfigurationSetName(v string) *SendBulkEmailInput {
	s.ConfigurationSetName = &v
	return s
}

// SetDefaultContent sets the DefaultContent field's value.
func (s *SendBulkEmailInput) SetDefaultContent(v *BulkEmailContent) *SendBulkEmailInput {
	s.DefaultContent = v
	return s
}

// SetDefaultEmailTags sets the DefaultEmailTags field's value.
func (s *SendBulkEmailInput) SetDefaultEmailTags(v []*MessageTag) *SendBulkEmailInput {
	s.DefaultEmailTags = v
	return s
}

// SetFeedbackForwardingEmailAddress sets the FeedbackForwardingEmailAddress field's value.
func (s *SendBulkEmailInput) SetFeedbackForwardingEmailAddress(v string) *SendBulkEmailInput {
	s.FeedbackForwardingEmailAddress = &v
	return s
}

// SetFeedbackForwardingEmailAddressIdentityArn sets the FeedbackForwardingEmailAddressIdentityArn field's value.
func (s *SendBulkEmailInput) SetFeedbackForwardingEmailAddressIdentityArn(v string) *SendBulkEmailInput {
	s.FeedbackForwardingEmailAddressIdentityArn = &v
	return s
}

// SetFromEmailAddress sets the FromEmailAddress field's value.
func (s *SendBulkEmailInput) SetFromEmailAddress(v string) *SendBulkEmailInput {
	s.FromEmailAddress = &v
	return s
}

// SetFromEmailAddressIdentityArn sets the FromEmailAddressIdentityArn field's value.
func (s *SendBulkEmailInput) SetFromEmailAddressIdentityArn(v string) *SendBulkEmailInput {
	s.FromEmailAddressIdentityArn = &v
	return s
}

// SetReplyToAddresses sets the ReplyToAddresses field's value.
func (s *SendBulkEmailInput) SetReplyToAddresses(v []*string) *SendBulkEmailInput {
	s.ReplyToAddresses = v
	return s
}

// The following data is returned in JSON format by the service.
type SendBulkEmailOutput struct {
	_ struct{} `type:"structure"`

	// A list of BulkMailEntry objects.
	//
	// BulkEmailEntryResults is a required field
	BulkEmailEntryResults []*BulkEmailEntryResult `type:"list" required:"true"`
}

// String returns the string representation
func (s SendBulkEmailOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendBulkEmailOutput) GoString() string {
	return s.String()
}

// SetBulkEmailEntryResults sets the BulkEmailEntryResults field's value.
func (s *SendBulkEmailOutput) SetBulkEmailEntryResults(v []*BulkEmailEntryResult) *SendBulkEmailOutput {
	s.BulkEmailEntryResults = v
	return s
}

// Represents a request to send a custom verification email to a specified recipient.
type SendCustomVerificationEmailInput struct {
	_ struct{} `type:"structure"`

	// Name of a configuration set to use when sending the verification email.
	ConfigurationSetName *string `type:"string"`

	// The email address to verify.
	//
	// EmailAddress is a required field
	EmailAddress *string `type:"string" required:"true"`

	// The name of the custom verification email template to use when sending the
	// verification email.
	//
	// TemplateName is a required field
	TemplateName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SendCustomVerificationEmailInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendCustomVerificationEmailInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendCustomVerificationEmailInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendCustomVerificationEmailInput"}
	if s.EmailAddress == nil {
		invalidParams.Add(request.NewErrParamRequired("EmailAddress"))
	}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *SendCustomVerificationEmailInput) SetConfigurationSetName(v string) *SendCustomVerificationEmailInput {
	s.ConfigurationSetName = &v
	return s
}

// SetEmailAddress sets the EmailAddress field's value.
func (s *SendCustomVerificationEmailInput) SetEmailAddress(v string) *SendCustomVerificationEmailInput {
	s.EmailAddress = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *SendCustomVerificationEmailInput) SetTemplateName(v string) *SendCustomVerificationEmailInput {
	s.TemplateName = &v
	return s
}

// The following element is returned by the service.
type SendCustomVerificationEmailOutput struct {
	_ struct{} `type:"structure"`

	// The unique message identifier returned from the SendCustomVerificationEmail
	// operation.
	MessageId *string `type:"string"`
}

// String returns the string representation
func (s SendCustomVerificationEmailOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendCustomVerificationEmailOutput) GoString() string {
	return s.String()
}

// SetMessageId sets the MessageId field's value.
func (s *SendCustomVerificationEmailOutput) SetMessageId(v string) *SendCustomVerificationEmailOutput {
	s.MessageId = &v
	return s
}

// Represents a request to send a single formatted email using Amazon SES. For
// more information, see the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-formatted.html).
type SendEmailInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set that you want to use when sending the email.
	ConfigurationSetName *string `type:"string"`

	// An object that contains the body of the message. You can send either a Simple
	// message Raw message or a template Message.
	//
	// Content is a required field
	Content *EmailContent `type:"structure" required:"true"`

	// An object that contains the recipients of the email message.
	Destination *Destination `type:"structure"`

	// A list of tags, in the form of name/value pairs, to apply to an email that
	// you send using the SendEmail operation. Tags correspond to characteristics
	// of the email that you define, so that you can publish email sending events.
	EmailTags []*MessageTag `type:"list"`

	// The address that you want bounce and complaint notifications to be sent to.
	FeedbackForwardingEmailAddress *string `type:"string"`

	// This parameter is used only for sending authorization. It is the ARN of the
	// identity that is associated with the sending authorization policy that permits
	// you to use the email address specified in the FeedbackForwardingEmailAddress
	// parameter.
	//
	// For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com)
	// attaches a policy to it that authorizes you to use feedback@example.com,
	// then you would specify the FeedbackForwardingEmailAddressIdentityArn to be
	// arn:aws:ses:us-east-1:123456789012:identity/example.com, and the FeedbackForwardingEmailAddress
	// to be feedback@example.com.
	//
	// For more information about sending authorization, see the Amazon SES Developer
	// Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
	FeedbackForwardingEmailAddressIdentityArn *string `type:"string"`

	// The email address that you want to use as the "From" address for the email.
	// The address that you specify has to be verified.
	FromEmailAddress *string `type:"string"`

	// This parameter is used only for sending authorization. It is the ARN of the
	// identity that is associated with the sending authorization policy that permits
	// you to use the email address specified in the FromEmailAddress parameter.
	//
	// For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com)
	// attaches a policy to it that authorizes you to use sender@example.com, then
	// you would specify the FromEmailAddressIdentityArn to be arn:aws:ses:us-east-1:123456789012:identity/example.com,
	// and the FromEmailAddress to be sender@example.com.
	//
	// For more information about sending authorization, see the Amazon SES Developer
	// Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
	//
	// For Raw emails, the FromEmailAddressIdentityArn value overrides the X-SES-SOURCE-ARN
	// and X-SES-FROM-ARN headers specified in raw email message content.
	FromEmailAddressIdentityArn *string `type:"string"`

	// The "Reply-to" email addresses for the message. When the recipient replies
	// to the message, each Reply-to address receives the reply.
	ReplyToAddresses []*string `type:"list"`
}

// String returns the string representation
func (s SendEmailInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendEmailInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendEmailInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendEmailInput"}
	if s.Content == nil {
		invalidParams.Add(request.NewErrParamRequired("Content"))
	}
	if s.Content != nil {
		if err := s.Content.Validate(); err != nil {
			invalidParams.AddNested("Content", err.(request.ErrInvalidParams))
		}
	}
	if s.EmailTags != nil {
		for i, v := range s.EmailTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "EmailTags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *SendEmailInput) SetConfigurationSetName(v string) *SendEmailInput {
	s.ConfigurationSetName = &v
	return s
}

// SetContent sets the Content field's value.
func (s *SendEmailInput) SetContent(v *EmailContent) *SendEmailInput {
	s.Content = v
	return s
}

// SetDestination sets the Destination field's value.
func (s *SendEmailInput) SetDestination(v *Destination) *SendEmailInput {
	s.Destination = v
	return s
}

// SetEmailTags sets the EmailTags field's value.
func (s *SendEmailInput) SetEmailTags(v []*MessageTag) *SendEmailInput {
	s.EmailTags = v
	return s
}

// SetFeedbackForwardingEmailAddress sets the FeedbackForwardingEmailAddress field's value.
func (s *SendEmailInput) SetFeedbackForwardingEmailAddress(v string) *SendEmailInput {
	s.FeedbackForwardingEmailAddress = &v
	return s
}

// SetFeedbackForwardingEmailAddressIdentityArn sets the FeedbackForwardingEmailAddressIdentityArn field's value.
func (s *SendEmailInput) SetFeedbackForwardingEmailAddressIdentityArn(v string) *SendEmailInput {
	s.FeedbackForwardingEmailAddressIdentityArn = &v
	return s
}

// SetFromEmailAddress sets the FromEmailAddress field's value.
func (s *SendEmailInput) SetFromEmailAddress(v string) *SendEmailInput {
	s.FromEmailAddress = &v
	return s
}

// SetFromEmailAddressIdentityArn sets the FromEmailAddressIdentityArn field's value.
func (s *SendEmailInput) SetFromEmailAddressIdentityArn(v string) *SendEmailInput {
	s.FromEmailAddressIdentityArn = &v
	return s
}

// SetReplyToAddresses sets the ReplyToAddresses field's value.
func (s *SendEmailInput) SetReplyToAddresses(v []*string) *SendEmailInput {
	s.ReplyToAddresses = v
	return s
}

// A unique message ID that you receive when an email is accepted for sending.
type SendEmailOutput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the message that is generated when the message is
	// accepted.
	//
	// It's possible for Amazon SES to accept a message without sending it. This
	// can happen when the message that you're trying to send has an attachment
	// contains a virus, or when you send a templated email that contains invalid
	// personalization content, for example.
	MessageId *string `type:"string"`
}

// String returns the string representation
func (s SendEmailOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendEmailOutput) GoString() string {
	return s.String()
}

// SetMessageId sets the MessageId field's value.
func (s *SendEmailOutput) SetMessageId(v string) *SendEmailOutput {
	s.MessageId = &v
	return s
}

// An object that contains information about the per-day and per-second sending
// limits for your Amazon SES account in the current AWS Region.
type SendQuota struct {
	_ struct{} `type:"structure"`

	// The maximum number of emails that you can send in the current AWS Region
	// over a 24-hour period. This value is also called your sending quota.
	Max24HourSend *float64 `type:"double"`

	// The maximum number of emails that you can send per second in the current
	// AWS Region. This value is also called your maximum sending rate or your maximum
	// TPS (transactions per second) rate.
	MaxSendRate *float64 `type:"double"`

	// The number of emails sent from your Amazon SES account in the current AWS
	// Region over the past 24 hours.
	SentLast24Hours *float64 `type:"double"`
}

// String returns the string representation
func (s SendQuota) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendQuota) GoString() string {
	return s.String()
}

// SetMax24HourSend sets the Max24HourSend field's value.
func (s *SendQuota) SetMax24HourSend(v float64) *SendQuota {
	s.Max24HourSend = &v
	return s
}

// SetMaxSendRate sets the MaxSendRate field's value.
func (s *SendQuota) SetMaxSendRate(v float64) *SendQuota {
	s.MaxSendRate = &v
	return s
}

// SetSentLast24Hours sets the SentLast24Hours field's value.
func (s *SendQuota) SetSentLast24Hours(v float64) *SendQuota {
	s.SentLast24Hours = &v
	return s
}

// Used to enable or disable email sending for messages that use this configuration
// set in the current AWS Region.
type SendingOptions struct {
	_ struct{} `type:"structure"`

	// If true, email sending is enabled for the configuration set. If false, email
	// sending is disabled for the configuration set.
	SendingEnabled *bool `type:"boolean"`
}

// String returns the string representation
func (s SendingOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendingOptions) GoString() string {
	return s.String()
}

// SetSendingEnabled sets the SendingEnabled field's value.
func (s *SendingOptions) SetSendingEnabled(v bool) *SendingOptions {
	s.SendingEnabled = &v
	return s
}

// The message can't be sent because the account's ability to send email is
// currently paused.
type SendingPausedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s SendingPausedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendingPausedException) GoString() string {
	return s.String()
}

func newErrorSendingPausedException(v protocol.ResponseMetadata) error {
	return &SendingPausedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *SendingPausedException) Code() string {
	return "SendingPausedException"
}

// Message returns the exception's message.
func (s *SendingPausedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *SendingPausedException) OrigErr() error {
	return nil
}

func (s *SendingPausedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *SendingPausedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *SendingPausedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object that defines an Amazon SNS destination for email events. You can
// use Amazon SNS to send notification when certain email events occur.
type SnsDestination struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic that you want to publish
	// email events to. For more information about Amazon SNS topics, see the Amazon
	// SNS Developer Guide (https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html).
	//
	// TopicArn is a required field
	TopicArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SnsDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SnsDestination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SnsDestination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SnsDestination"}
	if s.TopicArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TopicArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTopicArn sets the TopicArn field's value.
func (s *SnsDestination) SetTopicArn(v string) *SnsDestination {
	s.TopicArn = &v
	return s
}

// An object that contains information about an email address that is on the
// suppression list for your account.
type SuppressedDestination struct {
	_ struct{} `type:"structure"`

	// An optional value that can contain additional information about the reasons
	// that the address was added to the suppression list for your account.
	Attributes *SuppressedDestinationAttributes `type:"structure"`

	// The email address that is on the suppression list for your account.
	//
	// EmailAddress is a required field
	EmailAddress *string `type:"string" required:"true"`

	// The date and time when the suppressed destination was last updated, shown
	// in Unix time format.
	//
	// LastUpdateTime is a required field
	LastUpdateTime *time.Time `type:"timestamp" required:"true"`

	// The reason that the address was added to the suppression list for your account.
	//
	// Reason is a required field
	Reason *string `type:"string" required:"true" enum:"SuppressionListReason"`
}

// String returns the string representation
func (s SuppressedDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SuppressedDestination) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *SuppressedDestination) SetAttributes(v *SuppressedDestinationAttributes) *SuppressedDestination {
	s.Attributes = v
	return s
}

// SetEmailAddress sets the EmailAddress field's value.
func (s *SuppressedDestination) SetEmailAddress(v string) *SuppressedDestination {
	s.EmailAddress = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *SuppressedDestination) SetLastUpdateTime(v time.Time) *SuppressedDestination {
	s.LastUpdateTime = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *SuppressedDestination) SetReason(v string) *SuppressedDestination {
	s.Reason = &v
	return s
}

// An object that contains additional attributes that are related an email address
// that is on the suppression list for your account.
type SuppressedDestinationAttributes struct {
	_ struct{} `type:"structure"`

	// A unique identifier that's generated when an email address is added to the
	// suppression list for your account.
	FeedbackId *string `type:"string"`

	// The unique identifier of the email message that caused the email address
	// to be added to the suppression list for your account.
	MessageId *string `type:"string"`
}

// String returns the string representation
func (s SuppressedDestinationAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SuppressedDestinationAttributes) GoString() string {
	return s.String()
}

// SetFeedbackId sets the FeedbackId field's value.
func (s *SuppressedDestinationAttributes) SetFeedbackId(v string) *SuppressedDestinationAttributes {
	s.FeedbackId = &v
	return s
}

// SetMessageId sets the MessageId field's value.
func (s *SuppressedDestinationAttributes) SetMessageId(v string) *SuppressedDestinationAttributes {
	s.MessageId = &v
	return s
}

// A summary that describes the suppressed email address.
type SuppressedDestinationSummary struct {
	_ struct{} `type:"structure"`

	// The email address that's on the suppression list for your account.
	//
	// EmailAddress is a required field
	EmailAddress *string `type:"string" required:"true"`

	// The date and time when the suppressed destination was last updated, shown
	// in Unix time format.
	//
	// LastUpdateTime is a required field
	LastUpdateTime *time.Time `type:"timestamp" required:"true"`

	// The reason that the address was added to the suppression list for your account.
	//
	// Reason is a required field
	Reason *string `type:"string" required:"true" enum:"SuppressionListReason"`
}

// String returns the string representation
func (s SuppressedDestinationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SuppressedDestinationSummary) GoString() string {
	return s.String()
}

// SetEmailAddress sets the EmailAddress field's value.
func (s *SuppressedDestinationSummary) SetEmailAddress(v string) *SuppressedDestinationSummary {
	s.EmailAddress = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *SuppressedDestinationSummary) SetLastUpdateTime(v time.Time) *SuppressedDestinationSummary {
	s.LastUpdateTime = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *SuppressedDestinationSummary) SetReason(v string) *SuppressedDestinationSummary {
	s.Reason = &v
	return s
}

// An object that contains information about the email address suppression preferences
// for your account in the current AWS Region.
type SuppressionAttributes struct {
	_ struct{} `type:"structure"`

	// A list that contains the reasons that email addresses will be automatically
	// added to the suppression list for your account. This list can contain any
	// or all of the following:
	//
	//    * COMPLAINT – Amazon SES adds an email address to the suppression list
	//    for your account when a message sent to that address results in a complaint.
	//
	//    * BOUNCE – Amazon SES adds an email address to the suppression list
	//    for your account when a message sent to that address results in a hard
	//    bounce.
	SuppressedReasons []*string `type:"list"`
}

// String returns the string representation
func (s SuppressionAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SuppressionAttributes) GoString() string {
	return s.String()
}

// SetSuppressedReasons sets the SuppressedReasons field's value.
func (s *SuppressionAttributes) SetSuppressedReasons(v []*string) *SuppressionAttributes {
	s.SuppressedReasons = v
	return s
}

// An object that contains details about the action of suppression list.
type SuppressionListDestination struct {
	_ struct{} `type:"structure"`

	// The type of action that you want to perform on the address. Acceptable values:
	//
	//    * PUT: add the addresses to the suppression list. If the record already
	//    exists, it will override it with the new value.
	//
	//    * DELETE: remove the addresses from the suppression list.
	//
	// SuppressionListImportAction is a required field
	SuppressionListImportAction *string `type:"string" required:"true" enum:"SuppressionListImportAction"`
}

// String returns the string representation
func (s SuppressionListDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SuppressionListDestination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SuppressionListDestination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SuppressionListDestination"}
	if s.SuppressionListImportAction == nil {
		invalidParams.Add(request.NewErrParamRequired("SuppressionListImportAction"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSuppressionListImportAction sets the SuppressionListImportAction field's value.
func (s *SuppressionListDestination) SetSuppressionListImportAction(v string) *SuppressionListDestination {
	s.SuppressionListImportAction = &v
	return s
}

// An object that contains information about the suppression list preferences
// for your account.
type SuppressionOptions struct {
	_ struct{} `type:"structure"`

	// A list that contains the reasons that email addresses are automatically added
	// to the suppression list for your account. This list can contain any or all
	// of the following:
	//
	//    * COMPLAINT – Amazon SES adds an email address to the suppression list
	//    for your account when a message sent to that address results in a complaint.
	//
	//    * BOUNCE – Amazon SES adds an email address to the suppression list
	//    for your account when a message sent to that address results in a hard
	//    bounce.
	SuppressedReasons []*string `type:"list"`
}

// String returns the string representation
func (s SuppressionOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SuppressionOptions) GoString() string {
	return s.String()
}

// SetSuppressedReasons sets the SuppressedReasons field's value.
func (s *SuppressionOptions) SetSuppressedReasons(v []*string) *SuppressionOptions {
	s.SuppressedReasons = v
	return s
}

// An object that defines the tags that are associated with a resource. A tag
// is a label that you optionally define and associate with a resource. Tags
// can help you categorize and manage resources in different ways, such as by
// purpose, owner, environment, or other criteria. A resource can have as many
// as 50 tags.
//
// Each tag consists of a required tag key and an associated tag value, both
// of which you define. A tag key is a general label that acts as a category
// for a more specific tag value. A tag value acts as a descriptor within a
// tag key. A tag key can contain as many as 128 characters. A tag value can
// contain as many as 256 characters. The characters can be Unicode letters,
// digits, white space, or one of the following symbols: _ . : / = + -. The
// following additional restrictions apply to tags:
//
//    * Tag keys and values are case sensitive.
//
//    * For each associated resource, each tag key must be unique and it can
//    have only one value.
//
//    * The aws: prefix is reserved for use by AWS; you can’t use it in any
//    tag keys or values that you define. In addition, you can't edit or remove
//    tag keys or values that use this prefix. Tags that use this prefix don’t
//    count against the limit of 50 tags per resource.
//
//    * You can associate tags with public or shared resources, but the tags
//    are available only for your AWS account, not any other accounts that share
//    the resource. In addition, the tags are available only for resources that
//    are located in the specified AWS Region for your AWS account.
type Tag struct {
	_ struct{} `type:"structure"`

	// One part of a key-value pair that defines a tag. The maximum length of a
	// tag key is 128 characters. The minimum length is 1 character.
	//
	// Key is a required field
	Key *string `type:"string" required:"true"`

	// The optional part of a key-value pair that defines a tag. The maximum length
	// of a tag value is 256 characters. The minimum length is 0 characters. If
	// you don't want a resource to have a specific tag value, don't specify a value
	// for this parameter. If you don't specify a value, Amazon SES sets the value
	// to an empty string.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource that you want to add one or
	// more tags to.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`

	// A list of the tags that you want to add to the resource. A tag consists of
	// a required tag key (Key) and an associated tag value (Value). The maximum
	// length of a tag key is 128 characters. The maximum length of a tag value
	// is 256 characters.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// An object that defines the email template to use for an email message, and
// the values to use for any message variables in that template. An email template
// is a type of message template that contains content that you want to define,
// save, and reuse in email messages that you send.
type Template struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the template.
	TemplateArn *string `type:"string"`

	// An object that defines the values to use for message variables in the template.
	// This object is a set of key-value pairs. Each key defines a message variable
	// in the template. The corresponding value defines the value to use for that
	// variable.
	TemplateData *string `type:"string"`

	// The name of the template. You will refer to this name when you send email
	// using the SendTemplatedEmail or SendBulkTemplatedEmail operations.
	TemplateName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Template) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Template) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Template) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Template"}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTemplateArn sets the TemplateArn field's value.
func (s *Template) SetTemplateArn(v string) *Template {
	s.TemplateArn = &v
	return s
}

// SetTemplateData sets the TemplateData field's value.
func (s *Template) SetTemplateData(v string) *Template {
	s.TemplateData = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *Template) SetTemplateName(v string) *Template {
	s.TemplateName = &v
	return s
}

// >Represents a request to create a preview of the MIME content of an email
// when provided with a template and a set of replacement data.
type TestRenderEmailTemplateInput struct {
	_ struct{} `type:"structure"`

	// A list of replacement values to apply to the template. This parameter is
	// a JSON object, typically consisting of key-value pairs in which the keys
	// correspond to replacement tags in the email template.
	//
	// TemplateData is a required field
	TemplateData *string `type:"string" required:"true"`

	// The name of the template that you want to render.
	//
	// TemplateName is a required field
	TemplateName *string `location:"uri" locationName:"TemplateName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s TestRenderEmailTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TestRenderEmailTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TestRenderEmailTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TestRenderEmailTemplateInput"}
	if s.TemplateData == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateData"))
	}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTemplateData sets the TemplateData field's value.
func (s *TestRenderEmailTemplateInput) SetTemplateData(v string) *TestRenderEmailTemplateInput {
	s.TemplateData = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *TestRenderEmailTemplateInput) SetTemplateName(v string) *TestRenderEmailTemplateInput {
	s.TemplateName = &v
	return s
}

// The following element is returned by the service.
type TestRenderEmailTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The complete MIME message rendered by applying the data in the TemplateData
	// parameter to the template specified in the TemplateName parameter.
	//
	// RenderedTemplate is a required field
	RenderedTemplate *string `type:"string" required:"true"`
}

// String returns the string representation
func (s TestRenderEmailTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TestRenderEmailTemplateOutput) GoString() string {
	return s.String()
}

// SetRenderedTemplate sets the RenderedTemplate field's value.
func (s *TestRenderEmailTemplateOutput) SetRenderedTemplate(v string) *TestRenderEmailTemplateOutput {
	s.RenderedTemplate = &v
	return s
}

// Too many requests have been made to the operation.
type TooManyRequestsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s TooManyRequestsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TooManyRequestsException) GoString() string {
	return s.String()
}

func newErrorTooManyRequestsException(v protocol.ResponseMetadata) error {
	return &TooManyRequestsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyRequestsException) Code() string {
	return "TooManyRequestsException"
}

// Message returns the exception's message.
func (s *TooManyRequestsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyRequestsException) OrigErr() error {
	return nil
}

func (s *TooManyRequestsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyRequestsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyRequestsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object that defines the tracking options for a configuration set. When
// you use the Amazon SES API v2 to send an email, it contains an invisible
// image that's used to track when recipients open your email. If your email
// contains links, those links are changed slightly in order to track when recipients
// click them.
//
// These images and links include references to a domain operated by AWS. You
// can optionally configure the Amazon SES to use a domain that you operate
// for these images and links.
type TrackingOptions struct {
	_ struct{} `type:"structure"`

	// The domain that you want to use for tracking open and click events.
	//
	// CustomRedirectDomain is a required field
	CustomRedirectDomain *string `type:"string" required:"true"`
}

// String returns the string representation
func (s TrackingOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TrackingOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TrackingOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TrackingOptions"}
	if s.CustomRedirectDomain == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomRedirectDomain"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomRedirectDomain sets the CustomRedirectDomain field's value.
func (s *TrackingOptions) SetCustomRedirectDomain(v string) *TrackingOptions {
	s.CustomRedirectDomain = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource that you want to remove one
	// or more tags from.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"querystring" locationName:"ResourceArn" type:"string" required:"true"`

	// The tags (tag keys) that you want to remove from the resource. When you specify
	// a tag key, the action removes both that key and its associated tag value.
	//
	// To remove more than one tag from the resource, append the TagKeys parameter
	// and argument for each additional tag to remove, separated by an ampersand.
	// For example: /v2/email/tags?ResourceArn=ResourceArn&TagKeys=Key1&TagKeys=Key2
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"TagKeys" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// A request to change the settings for an event destination for a configuration
// set.
type UpdateConfigurationSetEventDestinationInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set that contains the event destination that
	// you want to modify.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `location:"uri" locationName:"ConfigurationSetName" type:"string" required:"true"`

	// An object that defines the event destination.
	//
	// EventDestination is a required field
	EventDestination *EventDestinationDefinition `type:"structure" required:"true"`

	// The name of the event destination that you want to modify.
	//
	// EventDestinationName is a required field
	EventDestinationName *string `location:"uri" locationName:"EventDestinationName" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateConfigurationSetEventDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateConfigurationSetEventDestinationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateConfigurationSetEventDestinationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateConfigurationSetEventDestinationInput"}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}
	if s.ConfigurationSetName != nil && len(*s.ConfigurationSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationSetName", 1))
	}
	if s.EventDestination == nil {
		invalidParams.Add(request.NewErrParamRequired("EventDestination"))
	}
	if s.EventDestinationName == nil {
		invalidParams.Add(request.NewErrParamRequired("EventDestinationName"))
	}
	if s.EventDestinationName != nil && len(*s.EventDestinationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventDestinationName", 1))
	}
	if s.EventDestination != nil {
		if err := s.EventDestination.Validate(); err != nil {
			invalidParams.AddNested("EventDestination", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *UpdateConfigurationSetEventDestinationInput) SetConfigurationSetName(v string) *UpdateConfigurationSetEventDestinationInput {
	s.ConfigurationSetName = &v
	return s
}

// SetEventDestination sets the EventDestination field's value.
func (s *UpdateConfigurationSetEventDestinationInput) SetEventDestination(v *EventDestinationDefinition) *UpdateConfigurationSetEventDestinationInput {
	s.EventDestination = v
	return s
}

// SetEventDestinationName sets the EventDestinationName field's value.
func (s *UpdateConfigurationSetEventDestinationInput) SetEventDestinationName(v string) *UpdateConfigurationSetEventDestinationInput {
	s.EventDestinationName = &v
	return s
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type UpdateConfigurationSetEventDestinationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateConfigurationSetEventDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateConfigurationSetEventDestinationOutput) GoString() string {
	return s.String()
}

// Represents a request to update an existing custom verification email template.
type UpdateCustomVerificationEmailTemplateInput struct {
	_ struct{} `type:"structure"`

	// The URL that the recipient of the verification email is sent to if his or
	// her address is not successfully verified.
	//
	// FailureRedirectionURL is a required field
	FailureRedirectionURL *string `type:"string" required:"true"`

	// The email address that the custom verification email is sent from.
	//
	// FromEmailAddress is a required field
	FromEmailAddress *string `type:"string" required:"true"`

	// The URL that the recipient of the verification email is sent to if his or
	// her address is successfully verified.
	//
	// SuccessRedirectionURL is a required field
	SuccessRedirectionURL *string `type:"string" required:"true"`

	// The content of the custom verification email. The total size of the email
	// must be less than 10 MB. The message body may contain HTML, with some limitations.
	// For more information, see Custom Verification Email Frequently Asked Questions
	// (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html#custom-verification-emails-faq)
	// in the Amazon SES Developer Guide.
	//
	// TemplateContent is a required field
	TemplateContent *string `type:"string" required:"true"`

	// The name of the custom verification email template that you want to update.
	//
	// TemplateName is a required field
	TemplateName *string `location:"uri" locationName:"TemplateName" min:"1" type:"string" required:"true"`

	// The subject line of the custom verification email.
	//
	// TemplateSubject is a required field
	TemplateSubject *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateCustomVerificationEmailTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateCustomVerificationEmailTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCustomVerificationEmailTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCustomVerificationEmailTemplateInput"}
	if s.FailureRedirectionURL == nil {
		invalidParams.Add(request.NewErrParamRequired("FailureRedirectionURL"))
	}
	if s.FromEmailAddress == nil {
		invalidParams.Add(request.NewErrParamRequired("FromEmailAddress"))
	}
	if s.SuccessRedirectionURL == nil {
		invalidParams.Add(request.NewErrParamRequired("SuccessRedirectionURL"))
	}
	if s.TemplateContent == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateContent"))
	}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}
	if s.TemplateSubject == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateSubject"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFailureRedirectionURL sets the FailureRedirectionURL field's value.
func (s *UpdateCustomVerificationEmailTemplateInput) SetFailureRedirectionURL(v string) *UpdateCustomVerificationEmailTemplateInput {
	s.FailureRedirectionURL = &v
	return s
}

// SetFromEmailAddress sets the FromEmailAddress field's value.
func (s *UpdateCustomVerificationEmailTemplateInput) SetFromEmailAddress(v string) *UpdateCustomVerificationEmailTemplateInput {
	s.FromEmailAddress = &v
	return s
}

// SetSuccessRedirectionURL sets the SuccessRedirectionURL field's value.
func (s *UpdateCustomVerificationEmailTemplateInput) SetSuccessRedirectionURL(v string) *UpdateCustomVerificationEmailTemplateInput {
	s.SuccessRedirectionURL = &v
	return s
}

// SetTemplateContent sets the TemplateContent field's value.
func (s *UpdateCustomVerificationEmailTemplateInput) SetTemplateContent(v string) *UpdateCustomVerificationEmailTemplateInput {
	s.TemplateContent = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *UpdateCustomVerificationEmailTemplateInput) SetTemplateName(v string) *UpdateCustomVerificationEmailTemplateInput {
	s.TemplateName = &v
	return s
}

// SetTemplateSubject sets the TemplateSubject field's value.
func (s *UpdateCustomVerificationEmailTemplateInput) SetTemplateSubject(v string) *UpdateCustomVerificationEmailTemplateInput {
	s.TemplateSubject = &v
	return s
}

// If the action is successful, the service sends back an HTTP 200 response
// with an empty HTTP body.
type UpdateCustomVerificationEmailTemplateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateCustomVerificationEmailTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateCustomVerificationEmailTemplateOutput) GoString() string {
	return s.String()
}

// Represents a request to update a sending authorization policy for an identity.
// Sending authorization is an Amazon SES feature that enables you to authorize
// other senders to use your identities. For information, see the Amazon SES
// Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-identity-owner-tasks-management.html).
type UpdateEmailIdentityPolicyInput struct {
	_ struct{} `type:"structure"`

	// The email identity for which you want to update policy.
	//
	// EmailIdentity is a required field
	EmailIdentity *string `location:"uri" locationName:"EmailIdentity" min:"1" type:"string" required:"true"`

	// The text of the policy in JSON format. The policy cannot exceed 4 KB.
	//
	// For information about the syntax of sending authorization policies, see the
	// Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-policies.html).
	//
	// Policy is a required field
	Policy *string `min:"1" type:"string" required:"true"`

	// The name of the policy.
	//
	// The policy name cannot exceed 64 characters and can only include alphanumeric
	// characters, dashes, and underscores.
	//
	// PolicyName is a required field
	PolicyName *string `location:"uri" locationName:"PolicyName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateEmailIdentityPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateEmailIdentityPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEmailIdentityPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateEmailIdentityPolicyInput"}
	if s.EmailIdentity == nil {
		invalidParams.Add(request.NewErrParamRequired("EmailIdentity"))
	}
	if s.EmailIdentity != nil && len(*s.EmailIdentity) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EmailIdentity", 1))
	}
	if s.Policy == nil {
		invalidParams.Add(request.NewErrParamRequired("Policy"))
	}
	if s.Policy != nil && len(*s.Policy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Policy", 1))
	}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEmailIdentity sets the EmailIdentity field's value.
func (s *UpdateEmailIdentityPolicyInput) SetEmailIdentity(v string) *UpdateEmailIdentityPolicyInput {
	s.EmailIdentity = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *UpdateEmailIdentityPolicyInput) SetPolicy(v string) *UpdateEmailIdentityPolicyInput {
	s.Policy = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *UpdateEmailIdentityPolicyInput) SetPolicyName(v string) *UpdateEmailIdentityPolicyInput {
	s.PolicyName = &v
	return s
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
type UpdateEmailIdentityPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateEmailIdentityPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateEmailIdentityPolicyOutput) GoString() string {
	return s.String()
}

// Represents a request to update an email template. For more information, see
// the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html).
type UpdateEmailTemplateInput struct {
	_ struct{} `type:"structure"`

	// The content of the email template, composed of a subject line, an HTML part,
	// and a text-only part.
	//
	// TemplateContent is a required field
	TemplateContent *EmailTemplateContent `type:"structure" required:"true"`

	// The name of the template you want to update.
	//
	// TemplateName is a required field
	TemplateName *string `location:"uri" locationName:"TemplateName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateEmailTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateEmailTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEmailTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateEmailTemplateInput"}
	if s.TemplateContent == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateContent"))
	}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTemplateContent sets the TemplateContent field's value.
func (s *UpdateEmailTemplateInput) SetTemplateContent(v *EmailTemplateContent) *UpdateEmailTemplateInput {
	s.TemplateContent = v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *UpdateEmailTemplateInput) SetTemplateName(v string) *UpdateEmailTemplateInput {
	s.TemplateName = &v
	return s
}

// If the action is successful, the service sends back an HTTP 200 response
// with an empty HTTP body.
type UpdateEmailTemplateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateEmailTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateEmailTemplateOutput) GoString() string {
	return s.String()
}

// An object that contains information about the amount of email that was delivered
// to recipients.
type VolumeStatistics struct {
	_ struct{} `type:"structure"`

	// The total number of emails that arrived in recipients' inboxes.
	InboxRawCount *int64 `type:"long"`

	// An estimate of the percentage of emails sent from the current domain that
	// will arrive in recipients' inboxes.
	ProjectedInbox *int64 `type:"long"`

	// An estimate of the percentage of emails sent from the current domain that
	// will arrive in recipients' spam or junk mail folders.
	ProjectedSpam *int64 `type:"long"`

	// The total number of emails that arrived in recipients' spam or junk mail
	// folders.
	SpamRawCount *int64 `type:"long"`
}

// String returns the string representation
func (s VolumeStatistics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VolumeStatistics) GoString() string {
	return s.String()
}

// SetInboxRawCount sets the InboxRawCount field's value.
func (s *VolumeStatistics) SetInboxRawCount(v int64) *VolumeStatistics {
	s.InboxRawCount = &v
	return s
}

// SetProjectedInbox sets the ProjectedInbox field's value.
func (s *VolumeStatistics) SetProjectedInbox(v int64) *VolumeStatistics {
	s.ProjectedInbox = &v
	return s
}

// SetProjectedSpam sets the ProjectedSpam field's value.
func (s *VolumeStatistics) SetProjectedSpam(v int64) *VolumeStatistics {
	s.ProjectedSpam = &v
	return s
}

// SetSpamRawCount sets the SpamRawCount field's value.
func (s *VolumeStatistics) SetSpamRawCount(v int64) *VolumeStatistics {
	s.SpamRawCount = &v
	return s
}

// The action that you want to take if the required MX record can't be found
// when you send an email. When you set this value to UseDefaultValue, the mail
// is sent using amazonses.com as the MAIL FROM domain. When you set this value
// to RejectMessage, the Amazon SES API v2 returns a MailFromDomainNotVerified
// error, and doesn't attempt to deliver the email.
//
// These behaviors are taken when the custom MAIL FROM domain configuration
// is in the Pending, Failed, and TemporaryFailure states.
const (
	// BehaviorOnMxFailureUseDefaultValue is a BehaviorOnMxFailure enum value
	BehaviorOnMxFailureUseDefaultValue = "USE_DEFAULT_VALUE"

	// BehaviorOnMxFailureRejectMessage is a BehaviorOnMxFailure enum value
	BehaviorOnMxFailureRejectMessage = "REJECT_MESSAGE"
)

// BehaviorOnMxFailure_Values returns all elements of the BehaviorOnMxFailure enum
func BehaviorOnMxFailure_Values() []string {
	return []string{
		BehaviorOnMxFailureUseDefaultValue,
		BehaviorOnMxFailureRejectMessage,
	}
}

const (
	// BulkEmailStatusSuccess is a BulkEmailStatus enum value
	BulkEmailStatusSuccess = "SUCCESS"

	// BulkEmailStatusMessageRejected is a BulkEmailStatus enum value
	BulkEmailStatusMessageRejected = "MESSAGE_REJECTED"

	// BulkEmailStatusMailFromDomainNotVerified is a BulkEmailStatus enum value
	BulkEmailStatusMailFromDomainNotVerified = "MAIL_FROM_DOMAIN_NOT_VERIFIED"

	// BulkEmailStatusConfigurationSetNotFound is a BulkEmailStatus enum value
	BulkEmailStatusConfigurationSetNotFound = "CONFIGURATION_SET_NOT_FOUND"

	// BulkEmailStatusTemplateNotFound is a BulkEmailStatus enum value
	BulkEmailStatusTemplateNotFound = "TEMPLATE_NOT_FOUND"

	// BulkEmailStatusAccountSuspended is a BulkEmailStatus enum value
	BulkEmailStatusAccountSuspended = "ACCOUNT_SUSPENDED"

	// BulkEmailStatusAccountThrottled is a BulkEmailStatus enum value
	BulkEmailStatusAccountThrottled = "ACCOUNT_THROTTLED"

	// BulkEmailStatusAccountDailyQuotaExceeded is a BulkEmailStatus enum value
	BulkEmailStatusAccountDailyQuotaExceeded = "ACCOUNT_DAILY_QUOTA_EXCEEDED"

	// BulkEmailStatusInvalidSendingPoolName is a BulkEmailStatus enum value
	BulkEmailStatusInvalidSendingPoolName = "INVALID_SENDING_POOL_NAME"

	// BulkEmailStatusAccountSendingPaused is a BulkEmailStatus enum value
	BulkEmailStatusAccountSendingPaused = "ACCOUNT_SENDING_PAUSED"

	// BulkEmailStatusConfigurationSetSendingPaused is a BulkEmailStatus enum value
	BulkEmailStatusConfigurationSetSendingPaused = "CONFIGURATION_SET_SENDING_PAUSED"

	// BulkEmailStatusInvalidParameter is a BulkEmailStatus enum value
	BulkEmailStatusInvalidParameter = "INVALID_PARAMETER"

	// BulkEmailStatusTransientFailure is a BulkEmailStatus enum value
	BulkEmailStatusTransientFailure = "TRANSIENT_FAILURE"

	// BulkEmailStatusFailed is a BulkEmailStatus enum value
	BulkEmailStatusFailed = "FAILED"
)

// BulkEmailStatus_Values returns all elements of the BulkEmailStatus enum
func BulkEmailStatus_Values() []string {
	return []string{
		BulkEmailStatusSuccess,
		BulkEmailStatusMessageRejected,
		BulkEmailStatusMailFromDomainNotVerified,
		BulkEmailStatusConfigurationSetNotFound,
		BulkEmailStatusTemplateNotFound,
		BulkEmailStatusAccountSuspended,
		BulkEmailStatusAccountThrottled,
		BulkEmailStatusAccountDailyQuotaExceeded,
		BulkEmailStatusInvalidSendingPoolName,
		BulkEmailStatusAccountSendingPaused,
		BulkEmailStatusConfigurationSetSendingPaused,
		BulkEmailStatusInvalidParameter,
		BulkEmailStatusTransientFailure,
		BulkEmailStatusFailed,
	}
}

const (
	// ContactLanguageEn is a ContactLanguage enum value
	ContactLanguageEn = "EN"

	// ContactLanguageJa is a ContactLanguage enum value
	ContactLanguageJa = "JA"
)

// ContactLanguage_Values returns all elements of the ContactLanguage enum
func ContactLanguage_Values() []string {
	return []string{
		ContactLanguageEn,
		ContactLanguageJa,
	}
}

// The data format of the import job's data source.
const (
	// DataFormatCsv is a DataFormat enum value
	DataFormatCsv = "CSV"

	// DataFormatJson is a DataFormat enum value
	DataFormatJson = "JSON"
)

// DataFormat_Values returns all elements of the DataFormat enum
func DataFormat_Values() []string {
	return []string{
		DataFormatCsv,
		DataFormatJson,
	}
}

// The current status of your Deliverability dashboard subscription. If this
// value is PENDING_EXPIRATION, your subscription is scheduled to expire at
// the end of the current calendar month.
const (
	// DeliverabilityDashboardAccountStatusActive is a DeliverabilityDashboardAccountStatus enum value
	DeliverabilityDashboardAccountStatusActive = "ACTIVE"

	// DeliverabilityDashboardAccountStatusPendingExpiration is a DeliverabilityDashboardAccountStatus enum value
	DeliverabilityDashboardAccountStatusPendingExpiration = "PENDING_EXPIRATION"

	// DeliverabilityDashboardAccountStatusDisabled is a DeliverabilityDashboardAccountStatus enum value
	DeliverabilityDashboardAccountStatusDisabled = "DISABLED"
)

// DeliverabilityDashboardAccountStatus_Values returns all elements of the DeliverabilityDashboardAccountStatus enum
func DeliverabilityDashboardAccountStatus_Values() []string {
	return []string{
		DeliverabilityDashboardAccountStatusActive,
		DeliverabilityDashboardAccountStatusPendingExpiration,
		DeliverabilityDashboardAccountStatusDisabled,
	}
}

// The status of a predictive inbox placement test. If the status is IN_PROGRESS,
// then the predictive inbox placement test is currently running. Predictive
// inbox placement tests are usually complete within 24 hours of creating the
// test. If the status is COMPLETE, then the test is finished, and you can use
// the GetDeliverabilityTestReport operation to view the results of the test.
const (
	// DeliverabilityTestStatusInProgress is a DeliverabilityTestStatus enum value
	DeliverabilityTestStatusInProgress = "IN_PROGRESS"

	// DeliverabilityTestStatusCompleted is a DeliverabilityTestStatus enum value
	DeliverabilityTestStatusCompleted = "COMPLETED"
)

// DeliverabilityTestStatus_Values returns all elements of the DeliverabilityTestStatus enum
func DeliverabilityTestStatus_Values() []string {
	return []string{
		DeliverabilityTestStatusInProgress,
		DeliverabilityTestStatusCompleted,
	}
}

// The location where the Amazon SES API v2 finds the value of a dimension to
// publish to Amazon CloudWatch. If you want to use the message tags that you
// specify using an X-SES-MESSAGE-TAGS header or a parameter to the SendEmail
// or SendRawEmail API, choose messageTag. If you want to use your own email
// headers, choose emailHeader. If you want to use link tags, choose linkTags.
const (
	// DimensionValueSourceMessageTag is a DimensionValueSource enum value
	DimensionValueSourceMessageTag = "MESSAGE_TAG"

	// DimensionValueSourceEmailHeader is a DimensionValueSource enum value
	DimensionValueSourceEmailHeader = "EMAIL_HEADER"

	// DimensionValueSourceLinkTag is a DimensionValueSource enum value
	DimensionValueSourceLinkTag = "LINK_TAG"
)

// DimensionValueSource_Values returns all elements of the DimensionValueSource enum
func DimensionValueSource_Values() []string {
	return []string{
		DimensionValueSourceMessageTag,
		DimensionValueSourceEmailHeader,
		DimensionValueSourceLinkTag,
	}
}

const (
	// DkimSigningAttributesOriginAwsSes is a DkimSigningAttributesOrigin enum value
	DkimSigningAttributesOriginAwsSes = "AWS_SES"

	// DkimSigningAttributesOriginExternal is a DkimSigningAttributesOrigin enum value
	DkimSigningAttributesOriginExternal = "EXTERNAL"
)

// DkimSigningAttributesOrigin_Values returns all elements of the DkimSigningAttributesOrigin enum
func DkimSigningAttributesOrigin_Values() []string {
	return []string{
		DkimSigningAttributesOriginAwsSes,
		DkimSigningAttributesOriginExternal,
	}
}

// The DKIM authentication status of the identity. The status can be one of
// the following:
//
//    * PENDING – The verification process was initiated, but Amazon SES hasn't
//    yet detected the DKIM records in the DNS configuration for the domain.
//
//    * SUCCESS – The verification process completed successfully.
//
//    * FAILED – The verification process failed. This typically occurs when
//    Amazon SES fails to find the DKIM records in the DNS configuration of
//    the domain.
//
//    * TEMPORARY_FAILURE – A temporary issue is preventing Amazon SES from
//    determining the DKIM authentication status of the domain.
//
//    * NOT_STARTED – The DKIM verification process hasn't been initiated
//    for the domain.
const (
	// DkimStatusPending is a DkimStatus enum value
	DkimStatusPending = "PENDING"

	// DkimStatusSuccess is a DkimStatus enum value
	DkimStatusSuccess = "SUCCESS"

	// DkimStatusFailed is a DkimStatus enum value
	DkimStatusFailed = "FAILED"

	// DkimStatusTemporaryFailure is a DkimStatus enum value
	DkimStatusTemporaryFailure = "TEMPORARY_FAILURE"

	// DkimStatusNotStarted is a DkimStatus enum value
	DkimStatusNotStarted = "NOT_STARTED"
)

// DkimStatus_Values returns all elements of the DkimStatus enum
func DkimStatus_Values() []string {
	return []string{
		DkimStatusPending,
		DkimStatusSuccess,
		DkimStatusFailed,
		DkimStatusTemporaryFailure,
		DkimStatusNotStarted,
	}
}

// An email sending event type. For example, email sends, opens, and bounces
// are all email events.
const (
	// EventTypeSend is a EventType enum value
	EventTypeSend = "SEND"

	// EventTypeReject is a EventType enum value
	EventTypeReject = "REJECT"

	// EventTypeBounce is a EventType enum value
	EventTypeBounce = "BOUNCE"

	// EventTypeComplaint is a EventType enum value
	EventTypeComplaint = "COMPLAINT"

	// EventTypeDelivery is a EventType enum value
	EventTypeDelivery = "DELIVERY"

	// EventTypeOpen is a EventType enum value
	EventTypeOpen = "OPEN"

	// EventTypeClick is a EventType enum value
	EventTypeClick = "CLICK"

	// EventTypeRenderingFailure is a EventType enum value
	EventTypeRenderingFailure = "RENDERING_FAILURE"

	// EventTypeDeliveryDelay is a EventType enum value
	EventTypeDeliveryDelay = "DELIVERY_DELAY"
)

// EventType_Values returns all elements of the EventType enum
func EventType_Values() []string {
	return []string{
		EventTypeSend,
		EventTypeReject,
		EventTypeBounce,
		EventTypeComplaint,
		EventTypeDelivery,
		EventTypeOpen,
		EventTypeClick,
		EventTypeRenderingFailure,
		EventTypeDeliveryDelay,
	}
}

// The email identity type. The identity type can be one of the following:
//
//    * EMAIL_ADDRESS – The identity is an email address.
//
//    * DOMAIN – The identity is a domain.
const (
	// IdentityTypeEmailAddress is a IdentityType enum value
	IdentityTypeEmailAddress = "EMAIL_ADDRESS"

	// IdentityTypeDomain is a IdentityType enum value
	IdentityTypeDomain = "DOMAIN"

	// IdentityTypeManagedDomain is a IdentityType enum value
	IdentityTypeManagedDomain = "MANAGED_DOMAIN"
)

// IdentityType_Values returns all elements of the IdentityType enum
func IdentityType_Values() []string {
	return []string{
		IdentityTypeEmailAddress,
		IdentityTypeDomain,
		IdentityTypeManagedDomain,
	}
}

// The destination of the import job, which can be used to list import jobs
// that have a certain ImportDestinationType.
const (
	// ImportDestinationTypeSuppressionList is a ImportDestinationType enum value
	ImportDestinationTypeSuppressionList = "SUPPRESSION_LIST"
)

// ImportDestinationType_Values returns all elements of the ImportDestinationType enum
func ImportDestinationType_Values() []string {
	return []string{
		ImportDestinationTypeSuppressionList,
	}
}

// The status of the import job.
const (
	// JobStatusCreated is a JobStatus enum value
	JobStatusCreated = "CREATED"

	// JobStatusProcessing is a JobStatus enum value
	JobStatusProcessing = "PROCESSING"

	// JobStatusCompleted is a JobStatus enum value
	JobStatusCompleted = "COMPLETED"

	// JobStatusFailed is a JobStatus enum value
	JobStatusFailed = "FAILED"
)

// JobStatus_Values returns all elements of the JobStatus enum
func JobStatus_Values() []string {
	return []string{
		JobStatusCreated,
		JobStatusProcessing,
		JobStatusCompleted,
		JobStatusFailed,
	}
}

// The status of the MAIL FROM domain. This status can have the following values:
//
//    * PENDING – Amazon SES hasn't started searching for the MX record yet.
//
//    * SUCCESS – Amazon SES detected the required MX record for the MAIL
//    FROM domain.
//
//    * FAILED – Amazon SES can't find the required MX record, or the record
//    no longer exists.
//
//    * TEMPORARY_FAILURE – A temporary issue occurred, which prevented Amazon
//    SES from determining the status of the MAIL FROM domain.
const (
	// MailFromDomainStatusPending is a MailFromDomainStatus enum value
	MailFromDomainStatusPending = "PENDING"

	// MailFromDomainStatusSuccess is a MailFromDomainStatus enum value
	MailFromDomainStatusSuccess = "SUCCESS"

	// MailFromDomainStatusFailed is a MailFromDomainStatus enum value
	MailFromDomainStatusFailed = "FAILED"

	// MailFromDomainStatusTemporaryFailure is a MailFromDomainStatus enum value
	MailFromDomainStatusTemporaryFailure = "TEMPORARY_FAILURE"
)

// MailFromDomainStatus_Values returns all elements of the MailFromDomainStatus enum
func MailFromDomainStatus_Values() []string {
	return []string{
		MailFromDomainStatusPending,
		MailFromDomainStatusSuccess,
		MailFromDomainStatusFailed,
		MailFromDomainStatusTemporaryFailure,
	}
}

const (
	// MailTypeMarketing is a MailType enum value
	MailTypeMarketing = "MARKETING"

	// MailTypeTransactional is a MailType enum value
	MailTypeTransactional = "TRANSACTIONAL"
)

// MailType_Values returns all elements of the MailType enum
func MailType_Values() []string {
	return []string{
		MailTypeMarketing,
		MailTypeTransactional,
	}
}

const (
	// ReviewStatusPending is a ReviewStatus enum value
	ReviewStatusPending = "PENDING"

	// ReviewStatusFailed is a ReviewStatus enum value
	ReviewStatusFailed = "FAILED"

	// ReviewStatusGranted is a ReviewStatus enum value
	ReviewStatusGranted = "GRANTED"

	// ReviewStatusDenied is a ReviewStatus enum value
	ReviewStatusDenied = "DENIED"
)

// ReviewStatus_Values returns all elements of the ReviewStatus enum
func ReviewStatus_Values() []string {
	return []string{
		ReviewStatusPending,
		ReviewStatusFailed,
		ReviewStatusGranted,
		ReviewStatusDenied,
	}
}

// The type of action that you want to perform on the address. Acceptable values:
//
//    * PUT: add the addresses to the suppression list.
//
//    * DELETE: remove the address from the suppression list.
const (
	// SuppressionListImportActionDelete is a SuppressionListImportAction enum value
	SuppressionListImportActionDelete = "DELETE"

	// SuppressionListImportActionPut is a SuppressionListImportAction enum value
	SuppressionListImportActionPut = "PUT"
)

// SuppressionListImportAction_Values returns all elements of the SuppressionListImportAction enum
func SuppressionListImportAction_Values() []string {
	return []string{
		SuppressionListImportActionDelete,
		SuppressionListImportActionPut,
	}
}

// The reason that the address was added to the suppression list for your account.
// The value can be one of the following:
//
//    * COMPLAINT – Amazon SES added an email address to the suppression list
//    for your account because a message sent to that address results in a complaint.
//
//    * BOUNCE – Amazon SES added an email address to the suppression list
//    for your account because a message sent to that address results in a hard
//    bounce.
const (
	// SuppressionListReasonBounce is a SuppressionListReason enum value
	SuppressionListReasonBounce = "BOUNCE"

	// SuppressionListReasonComplaint is a SuppressionListReason enum value
	SuppressionListReasonComplaint = "COMPLAINT"
)

// SuppressionListReason_Values returns all elements of the SuppressionListReason enum
func SuppressionListReason_Values() []string {
	return []string{
		SuppressionListReasonBounce,
		SuppressionListReasonComplaint,
	}
}

// Specifies whether messages that use the configuration set are required to
// use Transport Layer Security (TLS). If the value is Require, messages are
// only delivered if a TLS connection can be established. If the value is Optional,
// messages can be delivered in plain text if a TLS connection can't be established.
const (
	// TlsPolicyRequire is a TlsPolicy enum value
	TlsPolicyRequire = "REQUIRE"

	// TlsPolicyOptional is a TlsPolicy enum value
	TlsPolicyOptional = "OPTIONAL"
)

// TlsPolicy_Values returns all elements of the TlsPolicy enum
func TlsPolicy_Values() []string {
	return []string{
		TlsPolicyRequire,
		TlsPolicyOptional,
	}
}

// The warmup status of a dedicated IP.
const (
	// WarmupStatusInProgress is a WarmupStatus enum value
	WarmupStatusInProgress = "IN_PROGRESS"

	// WarmupStatusDone is a WarmupStatus enum value
	WarmupStatusDone = "DONE"
)

// WarmupStatus_Values returns all elements of the WarmupStatus enum
func WarmupStatus_Values() []string {
	return []string{
		WarmupStatusInProgress,
		WarmupStatusDone,
	}
}
