indexing

	description:

		"Scanners for Eiffel parsers"

	author:     "Eric Bezault <ericb@gobosoft.com>"
	copyright:  "Copyright (c) 1999, Eric Bezault and others"
	license:    "Eiffel Forum Freeware License v1 (see forum.txt)"
	date:       "$Date: 2001/03/18 13:00:29 $"
	revision:   "$Revision: 1.3 $"

class ET_EIFFEL_SCANNER

inherit

	ET_EIFFEL_SCANNER_SKELETON

creation

	make

feature -- Status report

	valid_start_condition (sc: INTEGER): BOOLEAN is
			-- Is `sc' a valid start condition?
		do
			Result := (INITIAL <= sc and sc <= VS)
		end

feature {NONE} -- Implementation

	yy_build_tables is
			-- Build scanner tables.
		do
			yy_nxt ?= yy_nxt_template
			yy_chk ?= yy_chk_template
			yy_base ?= yy_base_template
			yy_def ?= yy_def_template
			yy_ec ?= yy_ec_template
			yy_meta ?= yy_meta_template
			yy_accept ?= yy_accept_template
		end

	yy_execute_action (yy_act: INTEGER) is
			-- Execute semantic action.
		do
if yy_act <= 98 then
if yy_act <= 49 then
if yy_act <= 25 then
if yy_act <= 13 then
if yy_act <= 7 then
if yy_act <= 4 then
if yy_act <= 2 then
if yy_act = 1 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 32
-- Ignore spaces.
else
yy_set_line (0)
--|#line 33
-- Ignore new-lines.
end
else
if yy_act = 3 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 38
-- Ignore comments.
else
	yy_column := yy_column + 1
--|#line 43
process_one_character_symbol (Minus_code)
end
end
else
if yy_act <= 6 then
if yy_act = 5 then
	yy_column := yy_column + 1
--|#line 44
process_one_character_symbol (Plus_code)
else
	yy_column := yy_column + 1
--|#line 45
process_one_character_symbol (Star_code)
end
else
	yy_column := yy_column + 1
--|#line 46
process_one_character_symbol (Slash_code)
end
end
else
if yy_act <= 10 then
if yy_act <= 9 then
if yy_act = 8 then
	yy_column := yy_column + 1
--|#line 47
process_one_character_symbol (Caret_code)
else
	yy_column := yy_column + 1
--|#line 48
process_one_character_symbol (Equal_code)
end
else
	yy_column := yy_column + 1
--|#line 49
process_one_character_symbol (Greater_than_code)
end
else
if yy_act <= 12 then
if yy_act = 11 then
	yy_column := yy_column + 1
--|#line 50
process_one_character_symbol (Less_than_code)
else
	yy_column := yy_column + 1
--|#line 51
process_one_character_symbol (Dot_code)
end
else
	yy_column := yy_column + 1
--|#line 52
process_one_character_symbol (Semicolon_code)
end
end
end
else
if yy_act <= 19 then
if yy_act <= 16 then
if yy_act <= 15 then
if yy_act = 14 then
	yy_column := yy_column + 1
--|#line 53
process_one_character_symbol (Comma_code)
else
	yy_column := yy_column + 1
--|#line 54
process_one_character_symbol (Colon_code)
end
else
	yy_column := yy_column + 1
--|#line 55
process_one_character_symbol (Exclamation_code)
end
else
if yy_act <= 18 then
if yy_act = 17 then
	yy_column := yy_column + 1
--|#line 56
process_one_character_symbol (Left_parenthesis_code)
else
	yy_column := yy_column + 1
--|#line 57
process_one_character_symbol (Right_parenthesis_code)
end
else
	yy_column := yy_column + 1
--|#line 58
process_one_character_symbol (Left_brace_code)
end
end
else
if yy_act <= 22 then
if yy_act <= 21 then
if yy_act = 20 then
	yy_column := yy_column + 1
--|#line 59
process_one_character_symbol (Right_brace_code)
else
	yy_column := yy_column + 1
--|#line 60
process_one_character_symbol (Left_bracket_code)
end
else
	yy_column := yy_column + 1
--|#line 61
process_one_character_symbol (Right_bracket_code)
end
else
if yy_act <= 24 then
if yy_act = 23 then
	yy_column := yy_column + 1
--|#line 62
process_one_character_symbol (Dollar_code)
else
	yy_column := yy_column + 2
--|#line 63
process_two_character_symbol (E_DIV)
end
else
	yy_column := yy_column + 2
--|#line 64
process_two_character_symbol (E_MOD)
end
end
end
end
else
if yy_act <= 37 then
if yy_act <= 31 then
if yy_act <= 28 then
if yy_act <= 27 then
if yy_act = 26 then
	yy_column := yy_column + 2
--|#line 65
process_two_character_symbol (E_NE)
else
	yy_column := yy_column + 2
--|#line 66
process_two_character_symbol (E_GE)
end
else
	yy_column := yy_column + 2
--|#line 67
process_two_character_symbol (E_LE)
end
else
if yy_act <= 30 then
if yy_act = 29 then
	yy_column := yy_column + 2
--|#line 68
process_two_character_symbol (E_BANGBANG)
else
	yy_column := yy_column + 2
--|#line 69
process_two_character_symbol (E_ARROW)
end
else
	yy_column := yy_column + 2
--|#line 70
process_two_character_symbol (E_DOTDOT)
end
end
else
if yy_act <= 34 then
if yy_act <= 33 then
if yy_act = 32 then
	yy_column := yy_column + 2
--|#line 71
process_two_character_symbol (E_LARRAY)
else
	yy_column := yy_column + 2
--|#line 72
process_two_character_symbol (E_RARRAY)
end
else
	yy_column := yy_column + 2
--|#line 73
process_two_character_symbol (E_ASSIGN)
end
else
if yy_act <= 36 then
if yy_act = 35 then
	yy_column := yy_column + 2
--|#line 74
process_two_character_symbol (E_REVERSE)
else
	yy_column := yy_column + 5
--|#line 79

				last_token := E_ALIAS
				last_value := current_position
			
end
else
	yy_column := yy_column + 3
--|#line 83

				last_token := E_ALL
				last_value := current_position
			
end
end
end
else
if yy_act <= 43 then
if yy_act <= 40 then
if yy_act <= 39 then
if yy_act = 38 then
	yy_column := yy_column + 3
--|#line 87

				last_token := E_AND
				last_value := current_position
			
else
	yy_column := yy_column + 2
--|#line 91

				last_token := E_AS
				last_value := current_position
			
end
else
	yy_column := yy_column + 5
--|#line 95

				last_token := E_CHECK
				last_value := current_position
			
end
else
if yy_act <= 42 then
if yy_act = 41 then
	yy_column := yy_column + 5
--|#line 99

				last_token := E_CLASS
				last_value := current_position
			
else
	yy_column := yy_column + 6
--|#line 103

				if create_keyword then
					last_token := E_CREATE
					last_value := current_position
				else
					last_token := E_IDENTIFIER
					last_value := new_identifier (text)
				end
			
end
else
	yy_column := yy_column + 8
--|#line 112

				last_token := E_CREATION
				last_value := current_position
			
end
end
else
if yy_act <= 46 then
if yy_act <= 45 then
if yy_act = 44 then
	yy_column := yy_column + 7
--|#line 116

				last_token := E_CURRENT
				last_value := current_position
			
else
	yy_column := yy_column + 5
--|#line 120

				last_token := E_DEBUG
				last_value := current_position
			
end
else
	yy_column := yy_column + 8
--|#line 124

				last_token := E_DEFERRED
				last_value := current_position
			
end
else
if yy_act <= 48 then
if yy_act = 47 then
	yy_column := yy_column + 2
--|#line 128

				last_token := E_DO
				last_value := current_position
			
else
	yy_column := yy_column + 4
--|#line 132

				last_token := E_ELSE
				last_value := current_position
			
end
else
	yy_column := yy_column + 6
--|#line 136

				last_token := E_ELSEIF
				last_value := current_position
			
end
end
end
end
end
else
if yy_act <= 74 then
if yy_act <= 62 then
if yy_act <= 56 then
if yy_act <= 53 then
if yy_act <= 51 then
if yy_act = 50 then
	yy_column := yy_column + 3
--|#line 140

				last_token := E_END
				last_value := current_position
			
else
	yy_column := yy_column + 6
--|#line 144

				last_token := E_ENSURE
				last_value := current_position
			
end
else
if yy_act = 52 then
	yy_column := yy_column + 8
--|#line 148

				last_token := E_EXPANDED
				last_value := current_position
			
else
	yy_column := yy_column + 6
--|#line 152

				last_token := E_EXPORT
				last_value := current_position
			
end
end
else
if yy_act <= 55 then
if yy_act = 54 then
	yy_column := yy_column + 8
--|#line 156

				last_token := E_EXTERNAL
				last_value := current_position
			
else
	yy_column := yy_column + 5
--|#line 160

				last_token := E_FALSE
				last_value := new_false_constant
			
end
else
	yy_column := yy_column + 7
--|#line 164

				last_token := E_FEATURE
				last_value := current_position
			
end
end
else
if yy_act <= 59 then
if yy_act <= 58 then
if yy_act = 57 then
	yy_column := yy_column + 4
--|#line 168

				last_token := E_FROM
				last_value := current_position
			
else
	yy_column := yy_column + 6
--|#line 172

				last_token := E_FROZEN
				last_value := current_position
			
end
else
	yy_column := yy_column + 2
--|#line 176

				last_token := E_IF
				last_value := current_position
			
end
else
if yy_act <= 61 then
if yy_act = 60 then
	yy_column := yy_column + 7
--|#line 180

				last_token := E_IMPLIES
				last_value := current_position
			
else
	yy_column := yy_column + 8
--|#line 184

				last_token := E_INDEXING
				last_value := current_position
			
end
else
	yy_column := yy_column + 5
--|#line 188

				last_token := E_INFIX
				last_value := current_position
			
end
end
end
else
if yy_act <= 68 then
if yy_act <= 65 then
if yy_act <= 64 then
if yy_act = 63 then
	yy_column := yy_column + 7
--|#line 192

				last_token := E_INHERIT
				last_value := current_position
			
else
	yy_column := yy_column + 7
--|#line 196

				last_token := E_INSPECT
				last_value := current_position
			
end
else
	yy_column := yy_column + 9
--|#line 200

				last_token := E_INVARIANT
				last_value := current_position
			
end
else
if yy_act <= 67 then
if yy_act = 66 then
	yy_column := yy_column + 2
--|#line 204

				last_token := E_IS
				last_value := current_position
			
else
	yy_column := yy_column + 4
--|#line 208

				last_token := E_LIKE
				last_value := current_position
			
end
else
	yy_column := yy_column + 5
--|#line 212

				last_token := E_LOCAL
				last_value := current_position
			
end
end
else
if yy_act <= 71 then
if yy_act <= 70 then
if yy_act = 69 then
	yy_column := yy_column + 4
--|#line 216

				last_token := E_LOOP
				last_value := current_position
			
else
	yy_column := yy_column + 3
--|#line 220

				last_token := E_NOT
				last_value := current_position
			
end
else
	yy_column := yy_column + 8
--|#line 224

				last_token := E_OBSOLETE
				last_value := current_position
			
end
else
if yy_act <= 73 then
if yy_act = 72 then
	yy_column := yy_column + 3
--|#line 228

				last_token := E_OLD
				last_value := current_position
			
else
	yy_column := yy_column + 4
--|#line 232

				last_token := E_ONCE
				last_value := current_position
			
end
else
	yy_column := yy_column + 2
--|#line 236

				last_token := E_OR
				last_value := current_position
			
end
end
end
end
else
if yy_act <= 86 then
if yy_act <= 80 then
if yy_act <= 77 then
if yy_act <= 76 then
if yy_act = 75 then
	yy_column := yy_column + 9
--|#line 240

				last_token := E_PRECURSOR
				last_value := current_position
			
else
	yy_column := yy_column + 6
--|#line 244

				last_token := E_PREFIX
				last_value := current_position
			
end
else
	yy_column := yy_column + 8
--|#line 248

				last_token := E_REDEFINE
				last_value := current_position
			
end
else
if yy_act <= 79 then
if yy_act = 78 then
	yy_column := yy_column + 6
--|#line 252

				last_token := E_RENAME
				last_value := current_position
			
else
	yy_column := yy_column + 7
--|#line 256

				last_token := E_REQUIRE
				last_value := current_position
			
end
else
	yy_column := yy_column + 6
--|#line 260

				last_token := E_RESCUE
				last_value := current_position
			
end
end
else
if yy_act <= 83 then
if yy_act <= 82 then
if yy_act = 81 then
	yy_column := yy_column + 6
--|#line 264

				last_token := E_RESULT
				last_value := current_position
			
else
	yy_column := yy_column + 5
--|#line 268

				last_token := E_RETRY
				last_value := current_position
			
end
else
	yy_column := yy_column + 6
--|#line 272

				last_token := E_SELECT
				last_value := current_position
			
end
else
if yy_act <= 85 then
if yy_act = 84 then
	yy_column := yy_column + 8
--|#line 276

				last_token := E_SEPARATE
				last_value := current_position
			
else
	yy_column := yy_column + 5
--|#line 280

				last_token := E_STRIP
				last_value := current_position
			
end
else
	yy_column := yy_column + 4
--|#line 284

				last_token := E_THEN
				last_value := current_position
			
end
end
end
else
if yy_act <= 92 then
if yy_act <= 89 then
if yy_act <= 88 then
if yy_act = 87 then
	yy_column := yy_column + 4
--|#line 288

				last_token := E_TRUE
				last_value := new_true_constant
			
else
	yy_column := yy_column + 8
--|#line 292

				last_token := E_UNDEFINE
				last_value := current_position
			
end
else
	yy_column := yy_column + 6
--|#line 296

				last_token := E_UNIQUE
				last_value := current_position
			
end
else
if yy_act <= 91 then
if yy_act = 90 then
	yy_column := yy_column + 5
--|#line 300

				last_token := E_UNTIL
				last_value := current_position
			
else
	yy_column := yy_column + 7
--|#line 304

				last_token := E_VARIANT
				last_value := current_position
			
end
else
	yy_column := yy_column + 4
--|#line 308

				last_token := E_WHEN
				last_value := current_position
			
end
end
else
if yy_act <= 95 then
if yy_act <= 94 then
if yy_act = 93 then
	yy_column := yy_column + 3
--|#line 312

				last_token := E_XOR
				last_value := current_position
			
else
	yy_column := yy_column + 3
--|#line 320

				last_token := E_BITTYPE
				last_value := new_identifier (text)
			
end
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 324

				last_token := E_IDENTIFIER
				last_value := new_identifier (text)
			
end
else
if yy_act <= 97 then
if yy_act = 96 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 332

				last_token := E_FREEOP
				last_value := new_token (text)
			
else
	yy_column := yy_column + 3
--|#line 343

				last_token := E_CHARACTER
				last_value := new_character_constant (text_item (2))
			
end
else
	yy_column := yy_column + 3
--|#line 347

					-- Syntax error: character quote should be declared
					-- as '%'' and not as ''' in character constant.
				column := column + 1
				error_handler.report_SCTQ_error (current_position)
				column := column - 1

				last_token := E_CHARACTER
				last_value := new_character_constant ('%'')
			
end
end
end
end
end
end
else
if yy_act <= 147 then
if yy_act <= 123 then
if yy_act <= 111 then
if yy_act <= 105 then
if yy_act <= 102 then
if yy_act <= 100 then
if yy_act = 99 then
	yy_column := yy_column + 4
--|#line 358
process_c2_character_constant ('%A')
else
	yy_column := yy_column + 4
--|#line 359
process_c2_character_constant ('%B')
end
else
if yy_act = 101 then
	yy_column := yy_column + 4
--|#line 360
process_c2_character_constant ('%C')
else
	yy_column := yy_column + 4
--|#line 361
process_c2_character_constant ('%D')
end
end
else
if yy_act <= 104 then
if yy_act = 103 then
	yy_column := yy_column + 4
--|#line 362
process_c2_character_constant ('%F')
else
	yy_column := yy_column + 4
--|#line 363
process_c2_character_constant ('%H')
end
else
	yy_column := yy_column + 4
--|#line 364
process_c2_character_constant ('%L')
end
end
else
if yy_act <= 108 then
if yy_act <= 107 then
if yy_act = 106 then
	yy_column := yy_column + 4
--|#line 365
process_c2_character_constant ('%N')
else
	yy_column := yy_column + 4
--|#line 366
process_c2_character_constant ('%Q')
end
else
	yy_column := yy_column + 4
--|#line 367
process_c2_character_constant ('%R')
end
else
if yy_act <= 110 then
if yy_act = 109 then
	yy_column := yy_column + 4
--|#line 368
process_c2_character_constant ('%S')
else
	yy_column := yy_column + 4
--|#line 369
process_c2_character_constant ('%T')
end
else
	yy_column := yy_column + 4
--|#line 370
process_c2_character_constant ('%U')
end
end
end
else
if yy_act <= 117 then
if yy_act <= 114 then
if yy_act <= 113 then
if yy_act = 112 then
	yy_column := yy_column + 4
--|#line 371
process_c2_character_constant ('%V')
else
	yy_column := yy_column + 4
--|#line 372
process_c2_character_constant ('%%')
end
else
	yy_column := yy_column + 4
--|#line 373
process_c2_character_constant ('%'')
end
else
if yy_act <= 116 then
if yy_act = 115 then
	yy_column := yy_column + 4
--|#line 374
process_c2_character_constant ('%"')
else
	yy_column := yy_column + 4
--|#line 375
process_c2_character_constant ('%(')
end
else
	yy_column := yy_column + 4
--|#line 376
process_c2_character_constant ('%)')
end
end
else
if yy_act <= 120 then
if yy_act <= 119 then
if yy_act = 118 then
	yy_column := yy_column + 4
--|#line 377
process_c2_character_constant ('%<')
else
	yy_column := yy_column + 4
--|#line 378
process_c2_character_constant ('%>')
end
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 380

				last_token := E_CHARACTER
				last_value := new_c3_character_constant (text_substring (4, text_count - 2))
			
end
else
if yy_act <= 122 then
if yy_act = 121 then
	yy_column := yy_column + 1
--|#line 384

else
	yy_column := yy_column + 4
--|#line 385
process_lower_case_c2_character_constant ('%A')
end
else
	yy_column := yy_column + 4
--|#line 386
process_lower_case_c2_character_constant ('%B')
end
end
end
end
else
if yy_act <= 135 then
if yy_act <= 129 then
if yy_act <= 126 then
if yy_act <= 125 then
if yy_act = 124 then
	yy_column := yy_column + 4
--|#line 387
process_lower_case_c2_character_constant ('%C')
else
	yy_column := yy_column + 4
--|#line 388
process_lower_case_c2_character_constant ('%D')
end
else
	yy_column := yy_column + 4
--|#line 389
process_lower_case_c2_character_constant ('%F')
end
else
if yy_act <= 128 then
if yy_act = 127 then
	yy_column := yy_column + 4
--|#line 390
process_lower_case_c2_character_constant ('%H')
else
	yy_column := yy_column + 4
--|#line 391
process_lower_case_c2_character_constant ('%L')
end
else
	yy_column := yy_column + 4
--|#line 392
process_lower_case_c2_character_constant ('%N')
end
end
else
if yy_act <= 132 then
if yy_act <= 131 then
if yy_act = 130 then
	yy_column := yy_column + 4
--|#line 393
process_lower_case_c2_character_constant ('%Q')
else
	yy_column := yy_column + 4
--|#line 394
process_lower_case_c2_character_constant ('%R')
end
else
	yy_column := yy_column + 4
--|#line 395
process_lower_case_c2_character_constant ('%S')
end
else
if yy_act <= 134 then
if yy_act = 133 then
	yy_column := yy_column + 4
--|#line 396
process_lower_case_c2_character_constant ('%T')
else
	yy_column := yy_column + 4
--|#line 397
process_lower_case_c2_character_constant ('%U')
end
else
	yy_column := yy_column + 4
--|#line 398
process_lower_case_c2_character_constant ('%V')
end
end
end
else
if yy_act <= 141 then
if yy_act <= 138 then
if yy_act <= 137 then
if yy_act = 136 then
	yy_column := yy_column + 4
--|#line 400

					-- Syntax error: invalid special character
					-- %l in character constant.
				column := column + 2
				error_handler.report_SCSC_error (current_position)
				column := column - 2

				last_token := E_CHARACTER
				last_value := new_c2_character_constant (text_item (3))
			
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 411

					-- Syntax error: missing character / at end
					-- of special character specification %/code/.
				column := column + text_count
				error_handler.report_SCAS_error (current_position)
				column := column - text_count

				last_token := E_CHARERR
			
end
else
	yy_column := yy_column + 3
--|#line 420

					-- Syntax error: missing ASCII code in
					-- special character specification %/code/.
				column := column + 3
				error_handler.report_SCAC_error (current_position)
				column := column - 3

				last_token := E_CHARERR
			
end
else
if yy_act <= 140 then
if yy_act = 139 then
	yy_column := yy_column + 2
--|#line 429

					-- Syntax error: missing character between quotes.
				column := column + 1
				error_handler.report_SCQQ_error (current_position)
				column := column - 1

				last_token := E_CHARERR
			
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 437

					-- Syntax error: missing quote at
					-- end of character constant.
				column := column + text_count
				error_handler.report_SCEQ_error (current_position)
				column := column - text_count

				last_token := E_CHARERR
			
end
else
	yy_column := yy_column + 3
--|#line 450

				last_token := E_STRPLUS
				last_value := new_manifest_string ("+")
			
end
end
else
if yy_act <= 144 then
if yy_act <= 143 then
if yy_act = 142 then
	yy_column := yy_column + 3
--|#line 454

				last_token := E_STRMINUS
				last_value := new_manifest_string ("-")
			
else
	yy_column := yy_column + 3
--|#line 458

				last_token := E_STRSTAR
				last_value := new_manifest_string ("*")
			
end
else
	yy_column := yy_column + 3
--|#line 462

				last_token := E_STRSLASH
				last_value := new_manifest_string ("/")
			
end
else
if yy_act <= 146 then
if yy_act = 145 then
	yy_column := yy_column + 4
--|#line 466

				last_token := E_STRDIV
				last_value := new_manifest_string ("//")
			
else
	yy_column := yy_column + 4
--|#line 470

				last_token := E_STRMOD
				last_value := new_manifest_string ("\\")
			
end
else
	yy_column := yy_column + 3
--|#line 474

				last_token := E_STRPOWER
				last_value := new_manifest_string ("^")
			
end
end
end
end
end
else
if yy_act <= 171 then
if yy_act <= 159 then
if yy_act <= 153 then
if yy_act <= 150 then
if yy_act <= 149 then
if yy_act = 148 then
	yy_column := yy_column + 3
--|#line 478

				last_token := E_STRLT
				last_value := new_manifest_string ("<")
			
else
	yy_column := yy_column + 4
--|#line 482

				last_token := E_STRLE
				last_value := new_manifest_string ("<=")
			
end
else
	yy_column := yy_column + 3
--|#line 486

				last_token := E_STRGT
				last_value := new_manifest_string (">")
			
end
else
if yy_act <= 152 then
if yy_act = 151 then
	yy_column := yy_column + 4
--|#line 490

				last_token := E_STRGE
				last_value := new_manifest_string (">=")
			
else
	yy_column := yy_column + 5
--|#line 494

				last_token := E_STRNOT
				last_value := new_manifest_string (text_substring (2, 4))
			
end
else
	yy_column := yy_column + 5
--|#line 498

				last_token := E_STRAND
				last_value := new_manifest_string (text_substring (2, 4))
			
end
end
else
if yy_act <= 156 then
if yy_act <= 155 then
if yy_act = 154 then
	yy_column := yy_column + 4
--|#line 502

				last_token := E_STROR
				last_value := new_manifest_string (text_substring (2, 3))
			
else
	yy_column := yy_column + 5
--|#line 506

				last_token := E_STRXOR
				last_value := new_manifest_string (text_substring (2, 4))
			
end
else
	yy_column := yy_column + 10
--|#line 510

				last_token := E_STRANDTHEN
				last_value := new_manifest_string (text_substring (2, 9))
			
end
else
if yy_act <= 158 then
if yy_act = 157 then
	yy_column := yy_column + 9
--|#line 514

				last_token := E_STRORELSE
				last_value := new_manifest_string (text_substring (2, 8))
			
else
	yy_column := yy_column + 9
--|#line 518

				last_token := E_STRIMPLIES
				last_value := new_manifest_string (text_substring (2, 8))
			
end
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 522

				last_token := E_STRFREEOP
				last_value := new_manifest_string (text_substring (2, text_count - 1))
			
end
end
end
else
if yy_act <= 165 then
if yy_act <= 162 then
if yy_act <= 161 then
if yy_act = 160 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 527

					-- Regular manifest string.
				last_token := E_STRING
				last_value := new_manifest_string (text_substring (2, text_count - 1))
			
else
	yy_line := yy_line + 1
	yy_column := 1
--|#line 533

					-- Verbatim string.
				set_start_condition (VS)
			
end
else
	yy_line := yy_line + 1
	yy_column := 1
--|#line 538

					-- Verbatim string.
				set_start_condition (VS)
			
end
else
if yy_act <= 164 then
if yy_act = 163 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 544

				last_token := E_STRING
				set_start_condition (INITIAL)
			
else
yy_set_line_column
--|#line 548

			
end
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 557

					-- Manifest string with special characters.
				last_token := E_STRING
				last_value := new_special_manifest_string (text_substring (2, text_count - 1))
			
end
end
else
if yy_act <= 168 then
if yy_act <= 167 then
if yy_act = 166 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 562

					-- Manifest string with special characters which may be made
					-- up of several lines or may include invalid characters.
					-- Keep track of current line and column.
				ms_line := line
				ms_column := column
				more
				set_start_condition (MS)
			
else
	yy_line := yy_line + 1
	yy_column := 1
--|#line 573

					-- Multi-line manifest string.
				more
				set_start_condition (MSN)
			
end
else
	yy_end := yy_start + yy_more_len + 2
	yy_column := yy_column + 2
--|#line 578

					-- Multi-line manifest string.

					-- Syntax error: no space allowed after character
					-- % at end of line in multi-line manifest strings.
				column := yy_column - 1
				line := yy_line
				error_handler.report_SSNS_error (current_position)
				column := ms_column
				line := ms_line

				more
				set_start_condition (MSN1)
			
end
else
if yy_act <= 170 then
if yy_act = 169 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 592

				more
			
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 595

					-- Syntax error: missing character / at end of special
					-- character specification %/code/ in manifest string.
				column := yy_column
				line := yy_line
				error_handler.report_SSAS_error (current_position)
				column := ms_column
				line := ms_line

				more
			
end
else
	yy_column := yy_column + 2
--|#line 606

					-- Syntax error: missing ASCII code in special character
					-- specification %/code/ in manifest string.
				column := yy_column
				line := yy_line
				error_handler.report_SSAC_error (current_position)
				column := ms_column
				line := ms_line

				more
			
end
end
end
end
else
if yy_act <= 183 then
if yy_act <= 177 then
if yy_act <= 174 then
if yy_act <= 173 then
if yy_act = 172 then
	yy_column := yy_column + 2
--|#line 617

					-- Syntax error: special character specification
					-- %l where l is a letter code should be in
					-- upper-case in manifest strings.
				column := yy_column - 1
				line := yy_line
				error_handler.report_SSCU_error (current_position)
				column := ms_column
				line := ms_line

				more
			
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 629

				more
			
end
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 632

				last_token := E_STRING
				last_value := new_special_manifest_string (text_substring (2, text_count - 1))
				set_start_condition (INITIAL)
			
end
else
if yy_act <= 176 then
if yy_act = 175 then
	yy_column := yy_column + 2
--|#line 637

					-- Syntax error: Invalid special character
					-- in manifest strings.
				column := yy_column - 1
				line := yy_line
				error_handler.report_SSSC_error (current_position)
				column := ms_column
				line := ms_line

				more
			
else
	yy_column := yy_column + 1
--|#line 648

					-- Syntax error: invalid special character
					-- %l in manifest strings.
				column := yy_column
				line := yy_line
				error_handler.report_SSSC_error (current_position)
				column := ms_column
				line := ms_line

				last_token := E_STRERR
				set_start_condition (INITIAL)
			
end
else
	yy_line := yy_line + 1
	yy_column := 1
--|#line 660

					-- Syntax error: Invalid new-line in manifest string.
				column := 1
				line := yy_line
				error_handler.report_SSNL_error (current_position)
				column := ms_column
				line := ms_line

				last_token := E_STRERR
				set_start_condition (INITIAL)
			
end
end
else
if yy_act <= 180 then
if yy_act <= 179 then
if yy_act = 178 then
	yy_line := yy_line + 1
	yy_column := 1
--|#line 686

				more
				set_start_condition (MSN)
			
else
	yy_column := yy_column + 1
--|#line 690

					-- Should never happen.
				last_token := E_STRERR
				set_start_condition (INITIAL)
			
end
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 703

				more
				set_start_condition (MS)
			
end
else
if yy_act <= 182 then
if yy_act = 181 then
	yy_line := yy_line + 1
	yy_column := 1
--|#line 707

					-- Syntax error: empty line in middle of
					-- multi-line manifest string.
				column := 1
				line := yy_line - 1
				error_handler.report_SSEL_error (current_position)
				column := ms_column
				line := ms_line

				more
			
else
	yy_column := yy_column + 1
--|#line 718

					-- Syntax error: missing character % at beginning
					-- of line in multi-line manifest string.
				column := yy_column - 1
				line := yy_line
				error_handler.report_SSNP_error (current_position)
				column := ms_column
				line := ms_line

				last_token := E_STRERR
				set_start_condition (INITIAL)
			
end
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 747

				last_token := E_BIT
				last_value := new_bit_constant (text)
			
end
end
end
else
if yy_act <= 189 then
if yy_act <= 186 then
if yy_act <= 185 then
if yy_act = 184 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 755

				last_token := E_INTEGER
				last_value := new_integer_constant (text)
			
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 759

				last_token := E_INTEGER
				last_value := new_underscored_integer_constant (text)
			
end
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 763

					-- Syntax error: an underscore may not be
					-- the first character of an integer.
				error_handler.report_SIFU_error (current_position)

				last_token := E_INTEGER
				last_value := new_underscored_integer_constant (text)
			
end
else
if yy_act <= 188 then
if yy_act = 187 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 771

					-- Syntax error: an underscore must be followed
					-- by three digits and there must not be any
					-- consecutive group of four digits.
				error_handler.report_SITD_error (current_position)

				last_token := E_INTEGER
				last_value := new_underscored_integer_constant (text)
			
else
	yy_end := yy_end - 1
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 784

				last_token := E_REAL
				last_value := new_real_constant (text)
			
end
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 785

				last_token := E_REAL
				last_value := new_real_constant (text)
			
end
end
else
if yy_act <= 192 then
if yy_act <= 191 then
if yy_act = 190 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 786

				last_token := E_REAL
				last_value := new_real_constant (text)
			
else
	yy_end := yy_end - 1
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 790

				last_token := E_REAL
				last_value := new_underscored_real_constant (text)
			
end
else
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 791

				last_token := E_REAL
				last_value := new_underscored_real_constant (text)
			
end
else
if yy_act <= 194 then
if yy_act = 193 then
	yy_column := yy_column + yy_end - yy_start - yy_more_len
--|#line 792

				last_token := E_REAL
				last_value := new_underscored_real_constant (text)
			
else
	yy_column := yy_column + 1
--|#line 804

				last_token := E_UNKNOWN
				last_value := current_position
			
end
else
yy_set_line_column
--|#line 0
last_token := yyError_token
fatal_error ("scanner jammed")
end
end
end
end
end
end
end
		end

	yy_execute_eof_action (yy_sc: INTEGER) is
			-- Execute EOF semantic action.
		do
			inspect yy_sc
when 0 then
--|#line 0
terminate
when 1 then
--|#line 0

					-- Syntax error: missing double quote at
					-- end of manifest string.
				column := yy_column
				line := yy_line
				error_handler.report_SSEQ_error (current_position)
				column := ms_column
				line := ms_line

				last_token := E_STRERR
				set_start_condition (INITIAL)
			
when 2 then
--|#line 0

					-- Syntax error: missing character % at beginning
					-- of line in multi-line manifest string.
				column := yy_column
				line := yy_line
				error_handler.report_SSNP_error (current_position)
				column := ms_column
				line := ms_line

				last_token := E_STRERR
				set_start_condition (INITIAL)
			
when 3 then
--|#line 0

					-- Should never happen.
				last_token := E_STRERR
				set_start_condition (INITIAL)
			
when 4 then
--|#line 0

					-- Syntax error: 
				last_token := E_STRERR
				set_start_condition (INITIAL)
			
			else
				terminate
			end
		end

feature {NONE} -- Table templates

	yy_nxt_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yy_fixed_array (<<
			    0,   12,   13,   14,   13,   13,   15,   16,   17,   18,
			   12,   19,   20,   21,   22,   23,   24,   25,   26,   27,
			   28,   29,   30,   31,   32,   33,   34,   35,   36,   37,
			   38,   39,   40,   41,   42,   42,   43,   42,   42,   44,
			   42,   45,   46,   47,   42,   48,   49,   50,   51,   52,
			   53,   54,   42,   42,   55,   56,   57,   58,   59,   60,
			   36,   37,   38,   39,   41,   42,   44,   45,   42,   48,
			   49,   50,   51,   52,   61,   62,   64,   64,  102,  103,
			   65,   65,  492,   66,   66,   68,   69,   68,   68,   68,
			   69,   68,   68,   70,  116,  117,  441,   70,   72,   73,

			   72,   72,   72,   73,   72,   72,   75,   76,   75,   75,
			  149,   77,   75,   76,   75,   75,   79,   77,   79,   79,
			  104,  106,  108,  107,  107,  118,  119,  156,  109,  105,
			  122,  260,  123,  110,  149,  111,  112,  124,  110,  130,
			  112,  112,  142,  155,  113,  160,  160,  163,  143,  131,
			  164,   83,  157,  132,   85,  133,  151,  122,  123,  156,
			   78,  124,  434,  260,  273,  134,   78,   83,   84,  155,
			   85,  152,  586,  114,   86,   87,  113,   88,  114,   89,
			  132,  133,  157,  161,   90,  261,   91,  190,   92,  135,
			   85,  273,  138,  136,  126,  152,   93,  392,  127,  139,

			  140,   94,   95,  153,  128,  141,  137,  129,  178,  261,
			  393,   96,  179,  154,   97,   98,   79,   99,   79,   79,
			   92,  135,  145,  138,  126,  127,  140,   94,  128,  141,
			  137,  129,  146,  153,  147,  310,  310,  154,  148,  172,
			  173,  172,  172,  175,  176,  175,  175,  174,   82,  191,
			   82,   82,   85,  187,  145,  192,   85,  585,   85,  146,
			  147,  180,  148,  165,  166,  167,  168,  166,  165,  169,
			  165,  165,  169,  169,  169,  169,  165,  165,  165,  165,
			  165,  170,  165,  165,  165,  165,  169,  165,  169,  165,
			  169,  169,  169,  169,  165,  169,  165,  169,  165,  165,

			  165,  169,  165,  169,  165,  165,  169,  169,  169,  169,
			  169,  169,  165,  165,  165,  165,  165,  165,  165,  165,
			  165,  165,  171,  171,  171,  171,  171,  171,  171,  171,
			  171,  171,  171,  171,  171,  171,  165,  165,  181,  178,
			  181,  181,  178,  179,  178,  584,  184,  193,  186,  195,
			   85,  197,   85,   83,   85,   83,   85,  178,   85,  194,
			   83,   83,  179,   85,   85,   83,  583,  196,   85,  198,
			  204,  205,  206,  204,  208,   83,   83,   85,   85,   85,
			  263,  248,  248,  110,  265,  255,  255,  199,  200,  252,
			  252,  258,  182,  249,  259,  185,  201,  180,  202,  163,

			  203,  253,  164,  268,  307,  308,  307,  307,  265,  582,
			  311,  314,  263,  199,  307,  309,  307,  307,  580,  250,
			  558,  259,  202,  114,  207,  210,  210,  268,  210,  210,
			  210,  211,  210,  210,  212,  213,  214,  215,  210,  210,
			  210,  210,  210,  216,  210,  210,  210,  210,  217,  210,
			  218,  210,  219,  220,  221,  222,  210,  223,  210,  224,
			  210,  210,  210,  225,  210,  226,  210,  210,  227,  228,
			  229,  230,  231,  232,  210,  210,  210,  210,  210,  210,
			  210,  210,  210,  210,  233,  234,  235,  236,  237,  238,
			  239,  240,  241,  242,  243,  244,  245,  246,  210,  210,

			  110,  274,  254,  255,  256,  256,  266,  269,  271,  549,
			  267,  113,  272,  283,  163,  498,  277,  164,  278,  499,
			  279,  287,  270,  285,  288,  284,  547,  286,  297,  178,
			  546,  280,  315,  274,  281,   85,  272,  394,  266,  269,
			  114,  267,  257,  113,  290,  283,  270,  285,  277,  278,
			  279,  286,  297,  287,  291,  280,  288,  292,  281,  293,
			  294,  295,  299,  300,  394,  296,  303,  305,  301,  160,
			  160,  160,  160,  178,  178,  178,  290,  179,  312,  302,
			  291,  292,  313,  293,  294,  178,  299,  544,  295,  186,
			  303,  305,  316,  316,  178,  300,  172,  173,  172,  172,

			  380,  178,  525,  302,  174,  184,  178,  160,  524,  161,
			  175,  176,  175,  175,  181,  178,  181,  181,  317,  179,
			  318,   85,  319,   85,  380,   85,  180,  180,  185,   83,
			   83,   83,   85,   85,   85,  323,   83,  324,  180,   85,
			   85,  204,  326,  204,  204,  328,   83,  311,   85,   85,
			  369,  369,  329,  320,  185,  204,  327,  204,  204,  313,
			   83,  335,  335,   85,  366,  366,  321,  367,  182,  367,
			  520,  322,  368,  368,  325,  378,  249,  370,  370,  377,
			  377,  373,  379,  373,  381,  320,  374,  374,  110,  371,
			  375,  376,  257,  257,  110,  322,  376,  376,  325,  113,

			  382,  383,  250,  386,  387,  390,  399,  378,  391,  401,
			  405,  408,  518,  406,  379,  372,  381,  257,  388,  410,
			  414,  409,  412,  416,  382,  383,  419,  386,  114,  390,
			  257,  113,  391,  422,  114,  179,  387,  411,  399,  423,
			  423,  401,  405,  408,  406,  409,  412,  368,  368,  416,
			  419,  410,  414,  307,  308,  307,  307,   83,  517,  422,
			   85,  411,  424,  310,  310,  188,  316,  316,  425,  428,
			  426,   83,   85,   85,   85,  430,  432,  432,   85,  431,
			  335,  335,  433,  433,  314,  435,  435,  516,  249,  427,
			  436,  436,  437,  444,  437,  514,  429,  438,  438,  439,

			  439,  446,  371,  374,  374,  440,  440,  442,  447,  375,
			  376,  443,  443,  450,  250,  452,  427,  444,  113,  442,
			  434,  376,  376,  513,  454,  446,  453,  455,  372,  457,
			  462,  464,  447,  465,  466,  469,  473,  450,  467,  452,
			  472,  475,  480,  441,  476,  478,  479,  257,  454,  257,
			  113,  455,  453,  457,  462,  464,  481,  487,  487,  257,
			  465,  466,  467,  473,  472,  511,  469,  510,  476,  480,
			  479,  163,   83,  475,  164,   85,  478,  162,  423,  423,
			   83,   83,  500,   85,   85,  432,  432,  509,  481,  488,
			  488,  489,  489,  490,  490,  434,  501,  486,  438,  438,

			  491,  491,  493,  493,  502,  371,  494,  494,  500,  483,
			  495,  495,  482,  484,  490,  490,  497,  504,  257,  257,
			  501,  505,  506,  507,  508,  512,  496,  515,  519,  521,
			  522,  372,  523,  526,   83,  502,  482,   85,  492,   83,
			  484,  545,   85,   83,  441,  505,   85,  507,  506,  504,
			  508,  515,  519,  521,  522,  533,  114,  512,  548,  526,
			  550,  530,  527,  530,  523,  545,  531,  531,  528,  531,
			  531,  532,  532,  490,  490,  535,  535,  551,  529,  536,
			  536,  250,  537,  537,  550,  534,  538,  538,  539,  539,
			  548,  540,  527,  540,  542,  542,  538,  538,  552,  553,

			  554,  555,  529,  551,  556,  557,  543,  434,  560,  559,
			  571,  561,   83,  492,   83,   85,   83,   85,  503,   85,
			  531,  531,  552,  553,  441,  555,  531,  531,  556,  565,
			  565,  557,  554,  559,  560,  561,  372,  562,  566,  576,
			  566,  564,  581,  567,  567,  568,  577,  568,  569,  569,
			  569,  569,  578,  563,  570,  570,  538,  538,  572,  572,
			  538,  538,  573,  573,  574,  576,  574,  579,  581,  575,
			  575,  485,   83,  588,  571,   85,   85,  563,  577,  589,
			  567,  567,   85,  477,  578,  474,  492,  590,  590,  569,
			  569,  569,  569,  595,  579,  591,  591,  592,  596,  592,

			  372,  471,  593,  593,  537,  537,  587,  575,  575,  594,
			  594,  597,  565,  565,   85,  470,  571,  595,  593,  593,
			  598,  598,  596,  572,  572,  434,  591,  591,  468,  463,
			  461,  460,  587,  459,  458,  456,  451,  449,  448,  445,
			  314,  421,  372,  420,  418,  417,  415,  441,  413,  407,
			  434,  404,  403,  402,  400,  398,  397,  396,  492,  395,
			  389,  441,  385,  384,  492,   63,   63,   63,   63,   63,
			   63,   63,   63,   63,   63,   63,   63,   63,   63,   63,
			   63,   63,   63,   63,   63,   63,   63,   63,   67,   67,
			   67,   67,   67,   67,   67,   67,   67,   67,   67,   67,

			   67,   67,   67,   67,   67,   67,   67,   67,   67,   67,
			   67,   71,   71,   71,   71,   71,   71,   71,   71,   71,
			   71,   71,   71,   71,   71,   71,   71,   71,   71,   71,
			   71,   71,   71,   71,   74,   74,   74,   74,   74,   74,
			   74,   74,   74,   74,   74,   74,   74,   74,   74,   74,
			   74,   74,   74,   74,   74,   74,   74,   82,   82,  365,
			   82,   82,   82,   82,   82,   82,   82,   82,   82,   82,
			   82,   82,   82,   82,   82,   82,   82,   82,   82,   82,
			  100,  364,  363,  362,  361,  360,  100,  100,  100,  100,
			  100,  100,  100,  100,  100,  100,  100,  100,  100,  100,

			  100,  100,  100,  101,  101,  359,  101,  101,  101,  101,
			  101,  101,  101,  101,  101,  101,  101,  101,  101,  101,
			  101,  101,  101,  101,  101,  101,  121,  121,  358,  357,
			  121,  121,  121,  121,  121,  121,  121,  121,  121,  121,
			  162,  162,  356,  162,  162,  162,  162,  162,  162,  162,
			  162,  162,  162,  162,  162,  162,  162,  162,  162,  162,
			  162,  162,  162,  177,  177,  177,  177,  177,  177,  177,
			  177,  177,  177,  177,  177,  177,  177,  177,  177,  177,
			  177,  177,  177,  177,  177,  177,  183,  183,  183,  183,
			  183,  183,  183,  183,  183,  183,  183,  183,  183,  183,

			  183,  183,  183,  183,  183,  183,  183,  183,  183,   84,
			   84,  355,   84,   84,   84,   84,   84,   84,   84,   84,
			   84,   84,   84,   84,   84,   84,   84,   84,   84,   84,
			   84,   84,  188,  188,  188,  188,  354,  353,  352,  188,
			  188,  188,  188,  188,  188,  188,  188,  188,  104,  104,
			  351,  104,  104,  104,  104,  104,  104,  104,  104,  104,
			  104,  104,  104,  104,  104,  104,  104,  104,  104,  104,
			  104,  251,  251,  251,  251,  251,  251,  251,  251,  350,
			  251,  251,  251,  251,  251,  251,  251,  251,  251,  251,
			  251,  251,  251,  251,  162,  162,  162,  162,  349,  348,

			  347,  162,  162,  162,  162,  162,  162,  162,  162,  162,
			  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,
			  179,  179,  179,  179,  179,  179,  179,  179,  179,  179,
			  179,  179,  179,  184,  184,  184,  184,  184,  184,  184,
			  184,  184,  184,  184,  184,  184,  184,  184,  184,  184,
			  184,  184,  184,  184,  184,  184,  312,  312,  346,  312,
			  312,  312,  312,  312,  312,  312,  312,  312,  312,  312,
			  312,  312,  312,  312,  312,  312,  312,  312,  312,  188,
			  188,  345,  188,  188,  188,  188,  188,  188,  188,  188,
			  188,  188,  188,  188,  188,  188,  188,  188,  188,  188,

			  188,  188,  541,  541,  541,  541,  541,  541,  541,  541,
			  344,  541,  541,  541,  541,  541,  541,  541,  541,  541,
			  541,  541,  541,  541,  541,  343,  342,  341,  340,  339,
			  338,  337,  336,  334,  333,  332,  331,  330,  329,  306,
			  304,  298,  289,  282,  276,  275,  264,  262,  247,  209,
			  189,   80,  159,  158,  150,  144,  125,  120,  115,   81,
			   80,  599,   11,  599,  599,  599,  599,  599,  599,  599,
			  599,  599,  599,  599,  599,  599,  599,  599,  599,  599,
			  599,  599,  599,  599,  599,  599,  599,  599,  599,  599,
			  599,  599,  599,  599,  599,  599,  599,  599,  599,  599,

			  599,  599,  599,  599,  599,  599,  599,  599,  599,  599,
			  599,  599,  599,  599,  599,  599,  599,  599,  599,  599,
			  599,  599,  599,  599,  599,  599,  599,  599,  599,  599,
			  599,  599,  599,  599,  599,  599,  599,  599>>)
		end

	yy_chk_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yy_fixed_array (<<
			    0,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    3,    4,   19,   19,
			    3,    4,  591,    3,    4,    5,    5,    5,    5,    6,
			    6,    6,    6,    5,   32,   32,  572,    6,    7,    7,

			    7,    7,    8,    8,    8,    8,    9,    9,    9,    9,
			   47,    9,   10,   10,   10,   10,   13,   10,   13,   13,
			   25,   26,   27,   26,   26,   34,   34,   52,   27,   25,
			   36,  123,   36,   28,   47,   28,   28,   36,   29,   39,
			   29,   29,   44,   51,   28,   59,   59,   63,   44,   39,
			   63,   82,   53,   40,   82,   40,   49,   36,   36,   52,
			    9,   36,  565,  123,  135,   40,   10,   16,   16,   51,
			   16,   49,  560,   28,   16,   16,   28,   16,   29,   16,
			   40,   40,   53,   59,   16,  125,   16,   86,   16,   41,
			   86,  135,   43,   41,   38,   49,   16,  275,   38,   43,

			   43,   16,   16,   50,   38,   43,   41,   38,   74,  125,
			  275,   16,   74,   50,   16,   16,   79,   16,   79,   79,
			   16,   41,   46,   43,   38,   38,   43,   16,   38,   43,
			   41,   38,   46,   50,   46,  170,  170,   50,   46,   68,
			   68,   68,   68,   72,   72,   72,   72,   68,   84,   87,
			   84,   84,   87,   84,   46,   88,   84,  559,   88,   46,
			   46,   74,   46,   66,   66,   66,   66,   66,   66,   66,
			   66,   66,   66,   66,   66,   66,   66,   66,   66,   66,
			   66,   66,   66,   66,   66,   66,   66,   66,   66,   66,
			   66,   66,   66,   66,   66,   66,   66,   66,   66,   66,

			   66,   66,   66,   66,   66,   66,   66,   66,   66,   66,
			   66,   66,   66,   66,   66,   66,   66,   66,   66,   66,
			   66,   66,   66,   66,   66,   66,   66,   66,   66,   66,
			   66,   66,   66,   66,   66,   66,   66,   66,   75,   75,
			   75,   75,   77,   75,   78,  557,   77,   89,   78,   90,
			   89,   91,   90,   92,   91,   93,   92,  179,   93,   89,
			   95,   94,  186,   95,   94,   96,  556,   90,   96,   91,
			   97,   97,   97,   97,   99,   97,   98,   99,   97,   98,
			  127,  107,  107,  112,  129,  112,  112,   92,   93,  110,
			  110,  122,   75,  107,  122,   77,   94,   78,   95,  162,

			   96,  110,  162,  132,  166,  166,  166,  166,  129,  555,
			  179,  186,  127,   92,  168,  168,  168,  168,  551,  107,
			  519,  122,   95,  112,   98,  102,  102,  132,  102,  102,
			  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,
			  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,
			  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,
			  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,
			  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,
			  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,
			  102,  102,  102,  102,  102,  102,  102,  102,  102,  102,

			  111,  136,  111,  111,  114,  114,  130,  133,  134,  507,
			  130,  111,  134,  143,  169,  447,  140,  169,  140,  447,
			  140,  146,  133,  144,  147,  143,  504,  145,  152,  184,
			  501,  140,  188,  136,  140,  188,  134,  276,  130,  133,
			  111,  130,  114,  111,  150,  143,  133,  144,  140,  140,
			  140,  145,  152,  146,  150,  140,  147,  150,  140,  150,
			  150,  151,  154,  155,  276,  151,  156,  158,  155,  160,
			  160,  161,  161,  177,  180,  185,  150,  177,  180,  155,
			  150,  150,  184,  150,  150,  182,  154,  499,  151,  182,
			  156,  158,  189,  189,  311,  155,  172,  172,  172,  172,

			  263,  183,  479,  155,  172,  183,  313,  160,  478,  161,
			  175,  175,  175,  175,  181,  181,  181,  181,  194,  181,
			  196,  194,  198,  196,  263,  198,  177,  180,  185,  199,
			  200,  201,  199,  200,  201,  202,  203,  202,  182,  203,
			  202,  204,  204,  204,  204,  207,  204,  311,  207,  204,
			  250,  250,  216,  199,  183,  206,  206,  206,  206,  313,
			  206,  216,  216,  206,  248,  248,  200,  249,  181,  249,
			  472,  201,  249,  249,  203,  258,  248,  252,  252,  256,
			  256,  253,  262,  253,  264,  199,  253,  253,  254,  252,
			  254,  254,  257,  257,  255,  201,  255,  255,  203,  254,

			  265,  266,  248,  270,  271,  273,  281,  258,  274,  283,
			  289,  291,  470,  289,  262,  252,  264,  256,  271,  293,
			  296,  292,  294,  298,  265,  266,  301,  270,  254,  273,
			  257,  254,  274,  304,  255,  312,  271,  293,  281,  306,
			  306,  283,  289,  291,  289,  292,  294,  367,  367,  298,
			  301,  293,  296,  307,  307,  307,  307,  321,  469,  304,
			  321,  293,  310,  310,  310,  316,  316,  316,  320,  322,
			  320,  323,  322,  320,  323,  325,  366,  366,  325,  335,
			  335,  335,  368,  368,  312,  369,  369,  468,  366,  321,
			  370,  370,  371,  378,  371,  466,  323,  371,  371,  372,

			  372,  380,  370,  373,  373,  374,  374,  375,  381,  375,
			  375,  377,  377,  384,  366,  386,  321,  378,  375,  376,
			  368,  376,  376,  464,  388,  380,  387,  389,  370,  391,
			  397,  399,  381,  401,  403,  407,  411,  384,  405,  386,
			  410,  413,  420,  374,  414,  418,  419,  375,  388,  377,
			  375,  389,  387,  391,  397,  399,  421,  433,  433,  376,
			  401,  403,  405,  411,  410,  462,  407,  460,  414,  420,
			  419,  424,  425,  413,  424,  425,  418,  423,  423,  423,
			  427,  429,  448,  427,  429,  432,  432,  459,  421,  434,
			  434,  435,  435,  436,  436,  433,  450,  432,  437,  437,

			  438,  438,  439,  439,  451,  436,  440,  440,  448,  427,
			  441,  441,  425,  429,  442,  442,  443,  453,  443,  443,
			  450,  454,  455,  457,  458,  463,  442,  467,  471,  473,
			  475,  436,  476,  481,  482,  451,  425,  482,  438,  484,
			  429,  500,  484,  483,  440,  454,  483,  457,  455,  453,
			  458,  467,  471,  473,  475,  489,  443,  463,  506,  481,
			  509,  486,  482,  486,  476,  500,  486,  486,  483,  487,
			  487,  488,  488,  490,  490,  491,  491,  510,  484,  492,
			  492,  489,  493,  493,  509,  490,  494,  494,  495,  495,
			  506,  496,  482,  496,  497,  497,  496,  496,  511,  512,

			  513,  514,  484,  510,  515,  517,  497,  487,  524,  523,
			  537,  526,  527,  491,  528,  527,  529,  528,  452,  529,
			  530,  530,  511,  512,  494,  514,  531,  531,  515,  532,
			  532,  517,  513,  523,  524,  526,  537,  527,  533,  544,
			  533,  529,  554,  533,  533,  534,  546,  534,  535,  535,
			  534,  534,  547,  528,  536,  536,  538,  538,  539,  539,
			  540,  540,  542,  542,  543,  544,  543,  548,  554,  543,
			  543,  431,  562,  563,  542,  562,  563,  528,  546,  564,
			  566,  566,  564,  415,  547,  412,  535,  567,  567,  568,
			  568,  569,  569,  581,  548,  570,  570,  571,  583,  571,

			  542,  409,  571,  571,  573,  573,  562,  574,  574,  575,
			  575,  587,  590,  590,  587,  408,  573,  581,  592,  592,
			  593,  593,  583,  594,  594,  567,  598,  598,  406,  398,
			  396,  395,  562,  394,  393,  390,  385,  383,  382,  379,
			  314,  303,  573,  302,  300,  299,  297,  575,  295,  290,
			  590,  288,  286,  284,  282,  280,  279,  278,  593,  277,
			  272,  594,  268,  267,  598,  600,  600,  600,  600,  600,
			  600,  600,  600,  600,  600,  600,  600,  600,  600,  600,
			  600,  600,  600,  600,  600,  600,  600,  600,  601,  601,
			  601,  601,  601,  601,  601,  601,  601,  601,  601,  601,

			  601,  601,  601,  601,  601,  601,  601,  601,  601,  601,
			  601,  602,  602,  602,  602,  602,  602,  602,  602,  602,
			  602,  602,  602,  602,  602,  602,  602,  602,  602,  602,
			  602,  602,  602,  602,  603,  603,  603,  603,  603,  603,
			  603,  603,  603,  603,  603,  603,  603,  603,  603,  603,
			  603,  603,  603,  603,  603,  603,  603,  604,  604,  246,
			  604,  604,  604,  604,  604,  604,  604,  604,  604,  604,
			  604,  604,  604,  604,  604,  604,  604,  604,  604,  604,
			  605,  245,  244,  243,  242,  241,  605,  605,  605,  605,
			  605,  605,  605,  605,  605,  605,  605,  605,  605,  605,

			  605,  605,  605,  606,  606,  240,  606,  606,  606,  606,
			  606,  606,  606,  606,  606,  606,  606,  606,  606,  606,
			  606,  606,  606,  606,  606,  606,  607,  607,  239,  238,
			  607,  607,  607,  607,  607,  607,  607,  607,  607,  607,
			  608,  608,  237,  608,  608,  608,  608,  608,  608,  608,
			  608,  608,  608,  608,  608,  608,  608,  608,  608,  608,
			  608,  608,  608,  609,  609,  609,  609,  609,  609,  609,
			  609,  609,  609,  609,  609,  609,  609,  609,  609,  609,
			  609,  609,  609,  609,  609,  609,  610,  610,  610,  610,
			  610,  610,  610,  610,  610,  610,  610,  610,  610,  610,

			  610,  610,  610,  610,  610,  610,  610,  610,  610,  611,
			  611,  236,  611,  611,  611,  611,  611,  611,  611,  611,
			  611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
			  611,  611,  612,  612,  612,  612,  235,  234,  233,  612,
			  612,  612,  612,  612,  612,  612,  612,  612,  613,  613,
			  232,  613,  613,  613,  613,  613,  613,  613,  613,  613,
			  613,  613,  613,  613,  613,  613,  613,  613,  613,  613,
			  613,  614,  614,  614,  614,  614,  614,  614,  614,  231,
			  614,  614,  614,  614,  614,  614,  614,  614,  614,  614,
			  614,  614,  614,  614,  615,  615,  615,  615,  230,  229,

			  228,  615,  615,  615,  615,  615,  615,  615,  615,  615,
			  616,  616,  616,  616,  616,  616,  616,  616,  616,  616,
			  616,  616,  616,  616,  616,  616,  616,  616,  616,  616,
			  616,  616,  616,  617,  617,  617,  617,  617,  617,  617,
			  617,  617,  617,  617,  617,  617,  617,  617,  617,  617,
			  617,  617,  617,  617,  617,  617,  618,  618,  227,  618,
			  618,  618,  618,  618,  618,  618,  618,  618,  618,  618,
			  618,  618,  618,  618,  618,  618,  618,  618,  618,  619,
			  619,  226,  619,  619,  619,  619,  619,  619,  619,  619,
			  619,  619,  619,  619,  619,  619,  619,  619,  619,  619,

			  619,  619,  620,  620,  620,  620,  620,  620,  620,  620,
			  225,  620,  620,  620,  620,  620,  620,  620,  620,  620,
			  620,  620,  620,  620,  620,  224,  223,  222,  221,  220,
			  219,  218,  217,  215,  214,  213,  212,  211,  210,  164,
			  157,  153,  149,  142,  139,  137,  128,  126,  103,  101,
			   85,   80,   56,   54,   48,   45,   37,   35,   30,   15,
			   14,   11,  599,  599,  599,  599,  599,  599,  599,  599,
			  599,  599,  599,  599,  599,  599,  599,  599,  599,  599,
			  599,  599,  599,  599,  599,  599,  599,  599,  599,  599,
			  599,  599,  599,  599,  599,  599,  599,  599,  599,  599,

			  599,  599,  599,  599,  599,  599,  599,  599,  599,  599,
			  599,  599,  599,  599,  599,  599,  599,  599,  599,  599,
			  599,  599,  599,  599,  599,  599,  599,  599,  599,  599,
			  599,  599,  599,  599,  599,  599,  599,  599>>)
		end

	yy_base_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yy_fixed_array (<<
			    0,    0,    0,   73,   74,   83,   87,   96,  100,  104,
			  110, 1661, 1662,  114, 1657, 1653,  160,    0, 1662,   68,
			 1662, 1662, 1662, 1662, 1662,  103,  103,  103,  115,  120,
			 1633, 1662,   70, 1662,  100, 1632,   91, 1620,  159,  107,
			  114,  161,    0,  159,  106, 1613,  193,   65, 1622,  124,
			  168,  102,   99,  117, 1611, 1662, 1597, 1662, 1662,  125,
			 1662, 1662, 1662,  140, 1662, 1662,  262, 1662,  237, 1662,
			 1662, 1662,  241, 1662,  205,  336, 1662,  339,  341,  214,
			 1648, 1662,  144, 1662,  246, 1631,  180,  242,  248,  340,
			  342,  344,  346,  348,  354,  353,  358,  368,  369,  367,

			    0, 1638,  424, 1637,    0, 1662, 1662,  361, 1662, 1662,
			  369,  482,  365, 1662,  484, 1662, 1662, 1662, 1662, 1662,
			 1662,    0,  355,  100,    0,  138, 1615,  352, 1614,  339,
			  477,    0,  357,  476,  465,  125,  473, 1603,    0, 1601,
			  485,    0, 1605,  483,  476,  481,  490,  494,    0, 1610,
			  513,  522,  483, 1609,  514,  532,  521, 1608,  522, 1662,
			  549,  551,  392, 1662, 1620, 1662,  402, 1662,  412,  507,
			  215, 1662,  594, 1662, 1662,  608, 1662,  570, 1662,  354,
			  571,  612,  582,  598,  526,  572,  355, 1662,  525,  572,
			 1662, 1662, 1662, 1662,  611, 1662,  613, 1662,  615,  622,

			  623,  624,  630,  629,  639, 1662,  653,  638, 1662, 1662,
			 1627, 1626, 1625, 1624, 1623, 1622,  641, 1621, 1620, 1619,
			 1618, 1617, 1616, 1615, 1614, 1599, 1570, 1547, 1489, 1488,
			 1487, 1468, 1439, 1427, 1426, 1425, 1400, 1331, 1318, 1317,
			 1294, 1274, 1273, 1272, 1271, 1270, 1248, 1662,  644,  652,
			  630, 1662,  657,  666,  670,  676,  659,  672,  647,    0,
			    0,    0,  652,  554,  656,  655,  653, 1131, 1130,    0,
			  655,  676, 1128,  659,  661,  157,  498, 1127, 1121, 1124,
			 1112,  678, 1122,  681, 1110,    0, 1110,    0, 1119,  680,
			 1117,  683,  673,  689,  677, 1116,  692, 1110,  682, 1113,

			 1112,  682, 1107, 1105,  692,    0,  719,  751, 1662, 1662,
			  743,  591,  728,  603, 1084, 1662,  746, 1662, 1662, 1662,
			  763,  750,  762,  764, 1662,  768, 1662, 1662, 1662, 1662,
			 1662, 1662, 1662, 1662, 1662,  760, 1662, 1662, 1662, 1662,
			 1662, 1662, 1662, 1662, 1662, 1662, 1662, 1662, 1662, 1662,
			 1662, 1662, 1662, 1662, 1662, 1662, 1662, 1662, 1662, 1662,
			 1662, 1662, 1662, 1662, 1662, 1662,  756,  727,  762,  765,
			  770,  777,  779,  783,  785,  789,  801,  791,  747, 1101,
			  755,  761, 1106, 1103,  768, 1100,  770,  785,  779,  782,
			 1103,  781,    0, 1102, 1097, 1080, 1079,  785, 1097,  786,

			    0,  794,    0,  795,    0,  790, 1092,  802, 1075, 1065,
			  792,  797, 1033,  811,  799, 1040,    0,    0,  812,  798,
			  803,  828,    0,  858,  864,  865, 1662,  873, 1662,  874,
			 1662, 1060,  865,  837,  869,  871,  873,  878,  880,  882,
			  886,  890,  894,  898,    0,    0,    0,  483,  841,    0,
			  851,  871,  986,  886,  874,  881,    0,  878,  883,  855,
			  831,    0,  829,  895,  787,    0,  763,  882,  736,  722,
			  680,  883,  638,  882,    0,  883,  904,    0,  572,  570,
			    0,  892,  927,  936,  932, 1662,  946,  949,  951,  923,
			  953,  955,  959,  962,  966,  968,  976,  974,    0,  545,

			  894,  498,    0,    0,  494,    0,  930,  477,    0,  914,
			  936,  951,  952,  972,  954,  958,    0,  964,    0,  388,
			    0,    0,    0,  962,  967,    0,  964, 1005, 1007, 1009,
			 1000, 1006, 1009, 1023, 1030, 1028, 1034,  978, 1036, 1038,
			 1040, 1662, 1042, 1049,  998,    0, 1015, 1021, 1028,    0,
			    0,  384,    0,    0, 1001,  377,  324,  313,    0,  225,
			  140,    0, 1065, 1066, 1072,  104, 1060, 1067, 1069, 1071,
			 1075, 1082,   38, 1084, 1087, 1089,    0,    0,    0,    0,
			    0, 1046,    0, 1053,    0,    0,    0, 1104, 1662, 1662,
			 1092,   24, 1098, 1100, 1103,    0,    0, 1662, 1106, 1662,

			 1164, 1187, 1210, 1233, 1256, 1279, 1302, 1316, 1339, 1362,
			 1385, 1408, 1427, 1447, 1470, 1489, 1509, 1532, 1555, 1578,
			 1601>>)
		end

	yy_def_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yy_fixed_array (<<
			    0,  599,    1,  600,  600,  601,  601,  602,  602,  603,
			  603,  599,  599,  599,  599,  599,  604,  605,  599,  606,
			  599,  599,  599,  599,  599,  599,  599,  599,  599,  599,
			  599,  599,  599,  599,  599,  599,  607,  607,  607,  607,
			  607,  607,  607,  607,  607,  607,  607,  607,  607,  607,
			  607,  607,  607,  607,  607,  599,  599,  599,  599,  599,
			  599,  599,  599,  608,  599,  599,  599,  599,  599,  599,
			  599,  599,  599,  599,  609,  609,  599,  610,  609,  599,
			  599,  599,  604,  599,  611,  612,  604,  604,  604,  604,
			  604,  604,  604,  604,  604,  604,  604,  604,  604,  604,

			  605,  599,  599,  599,  613,  599,  599,  599,  599,  599,
			  614,  599,  599,  599,  599,  599,  599,  599,  599,  599,
			  599,  607,  607,  607,  607,  607,  607,  607,  607,  607,
			  607,  607,  607,  607,  607,  607,  607,  607,  607,  607,
			  607,  607,  607,  607,  607,  607,  607,  607,  607,  607,
			  607,  607,  607,  607,  607,  607,  607,  607,  607,  599,
			  599,  599,  608,  599,  615,  599,  599,  599,  599,  608,
			  599,  599,  599,  599,  599,  599,  599,  609,  599,  616,
			  609,  609,  609,  610,  617,  610,  618,  599,  619,  599,
			  599,  599,  599,  599,  604,  599,  604,  599,  604,  604,

			  604,  604,  604,  604,  604,  599,  604,  604,  599,  599,
			  599,  599,  599,  599,  599,  599,  599,  599,  599,  599,
			  599,  599,  599,  599,  599,  599,  599,  599,  599,  599,
			  599,  599,  599,  599,  599,  599,  599,  599,  599,  599,
			  599,  599,  599,  599,  599,  599,  599,  599,  599,  599,
			  599,  599,  599,  599,  599,  599,  599,  599,  607,  607,
			  607,  607,  607,  607,  607,  607,  607,  607,  607,  607,
			  607,  607,  607,  607,  607,  607,  607,  607,  607,  607,
			  607,  607,  607,  607,  607,  607,  607,  607,  607,  607,
			  607,  607,  607,  607,  607,  607,  607,  607,  607,  607,

			  607,  607,  607,  607,  607,  607,  599,  599,  599,  599,
			  599,  616,  618,  617,  618,  599,  599,  599,  599,  599,
			  604,  604,  604,  604,  599,  604,  599,  599,  599,  599,
			  599,  599,  599,  599,  599,  599,  599,  599,  599,  599,
			  599,  599,  599,  599,  599,  599,  599,  599,  599,  599,
			  599,  599,  599,  599,  599,  599,  599,  599,  599,  599,
			  599,  599,  599,  599,  599,  599,  599,  599,  599,  599,
			  599,  599,  599,  599,  599,  599,  599,  599,  607,  607,
			  607,  607,  607,  607,  607,  607,  607,  607,  607,  607,
			  607,  607,  607,  607,  607,  607,  607,  607,  607,  607,

			  607,  607,  607,  607,  607,  607,  607,  607,  607,  607,
			  607,  607,  607,  607,  607,  607,  607,  607,  607,  607,
			  607,  607,  607,  599,  608,  604,  599,  604,  599,  604,
			  599,  599,  599,  599,  599,  599,  599,  599,  599,  599,
			  599,  599,  614,  599,  607,  607,  607,  607,  607,  607,
			  607,  607,  607,  607,  607,  607,  607,  607,  607,  607,
			  607,  607,  607,  607,  607,  607,  607,  607,  607,  607,
			  607,  607,  607,  607,  607,  607,  607,  607,  607,  607,
			  607,  607,  604,  604,  604,  599,  599,  599,  599,  599,
			  599,  599,  599,  599,  599,  599,  599,  620,  607,  607,

			  607,  607,  607,  607,  607,  607,  607,  607,  607,  607,
			  607,  607,  607,  607,  607,  607,  607,  607,  607,  607,
			  607,  607,  607,  607,  607,  607,  607,  604,  604,  604,
			  599,  599,  599,  599,  599,  599,  599,  599,  599,  599,
			  599,  599,  599,  599,  607,  607,  607,  607,  607,  607,
			  607,  607,  607,  607,  607,  607,  607,  607,  607,  607,
			  607,  607,  604,  604,  604,  599,  599,  599,  599,  599,
			  599,  599,  599,  599,  599,  599,  607,  607,  607,  607,
			  607,  607,  607,  607,  607,  607,  607,  604,  599,  599,
			  599,  599,  599,  599,  599,  607,  607,  599,  599,    0,

			  599,  599,  599,  599,  599,  599,  599,  599,  599,  599,
			  599,  599,  599,  599,  599,  599,  599,  599,  599,  599,
			  599>>)
		end

	yy_ec_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yy_fixed_array (<<
			    0,    1,    1,    1,    1,    1,    1,    1,    1,    2,
			    3,    1,    1,    4,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    5,    6,    7,    8,    9,   10,    8,   11,
			   12,   13,   14,   15,   16,   17,   18,   19,   20,   20,
			   21,   21,   21,   21,   21,   21,   21,   21,   22,   23,
			   24,   25,   26,   27,    8,   28,   29,   30,   31,   32,
			   33,   34,   35,   36,   37,   38,   39,   40,   41,   42,
			   43,   44,   45,   46,   47,   48,   49,   50,   51,   52,
			   53,   54,   55,   56,   57,   58,   59,   60,   61,   62,

			   63,   32,   64,   34,   65,   36,   37,   38,   66,   40,
			   67,   42,   43,   68,   69,   70,   71,   72,   73,   50,
			   51,   52,   53,   74,    8,   75,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
			    1,    1,    1,    1,    1,    1,    1>>)
		end

	yy_meta_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yy_fixed_array (<<
			    0,    1,    2,    3,    2,    4,    1,    5,    1,    1,
			    6,    7,    7,    8,    1,    1,    1,    1,    9,    7,
			   10,   11,    1,    1,   12,    1,   13,    1,   14,   14,
			   14,   15,   10,   16,   10,   17,   10,   10,   10,   18,
			   10,   19,   10,   10,   14,   14,   14,   14,   14,   20,
			   10,   10,   10,   21,    1,    1,    1,    1,   22,    1,
			   10,   10,   10,   10,   10,   10,   10,   10,   10,   10,
			   10,   10,   10,   23,    1,    1>>)
		end

	yy_accept_template: ANY is
			-- This is supposed to be "like FIXED_INTEGER_ARRAY_TYPE",
			-- but once functions cannot be declared with anchored types.
		once
			Result := yy_fixed_array (<<
			    0,    0,    0,    0,    0,    0,    0,    0,    0,  164,
			  164,  196,  194,    1,    2,   16,  166,   96,   23,  140,
			   17,   18,    6,    5,   14,    4,   12,    7,  184,  184,
			   15,   13,   11,    9,   10,  194,   95,   95,   95,   95,
			   95,   95,   95,   95,   95,   95,   95,   95,   95,   95,
			   95,   95,   95,   95,   95,   21,  194,   22,    8,  194,
			  121,   19,   20,  173,  177,  174,  176,  182,  182,  181,
			  180,  179,  179,  178,  164,  164,  164,  164,  164,    1,
			    2,   29,  166,  160,  166,    0,  166,  166,  166,  166,
			  166,  166,  166,  166,  166,  166,  166,  166,  166,  166,

			   96,  140,  140,  139,    3,   30,   31,  190,   24,   26,
			    0,  184,  184,  183,  187,   34,   32,   28,   27,   33,
			   35,   95,   95,   95,   39,   95,   95,   95,   95,   95,
			   95,   47,   95,   95,   95,   95,   95,   95,   59,   95,
			   95,   66,   95,   95,   95,   95,   95,   95,   74,   95,
			   95,   95,   95,   95,   95,   95,   95,   95,   95,   25,
			  186,  186,  173,  174,    0,  175,  175,  167,  175,  173,
			  171,  172,    0,  181,  180,    0,  178,  164,  164,  164,
			  164,  164,  164,  164,  164,  164,  163,  159,  166,    0,
			  143,  141,  142,  144,  166,  148,  166,  150,  166,  166,

			  166,  166,  166,  166,  166,  161,  166,  166,  147,   97,
			  140,  140,  140,  140,  140,  140,  138,  140,  140,  140,
			  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,
			  140,  140,  140,  140,  140,  140,  140,  140,  140,  140,
			  140,  140,  140,  140,  140,  140,  140,   98,  190,    0,
			    0,  188,  190,  188,  184,  184,  187,  187,   95,   37,
			   38,   94,   95,   95,   95,   95,   95,   95,   95,   50,
			   95,   95,   95,   95,   95,   95,   95,   95,   95,   95,
			   95,   95,   95,   95,   95,   70,   95,   72,   95,   95,
			   95,   95,   95,   95,   95,   95,   95,   95,   95,   95,

			   95,   95,   95,   95,   95,   93,    0,    0,  168,  167,
			  170,  164,    0,  164,    0,  165,    0,  145,  149,  151,
			  166,  166,  166,  166,  154,  166,  162,  161,  146,  136,
			  115,  113,  114,  116,  117,  137,  118,  119,   99,  100,
			  101,  102,  103,  104,  105,  106,  107,  108,  109,  110,
			  111,  112,  122,  123,  124,  125,  126,  127,  128,  129,
			  130,  131,  132,  133,  134,  135,  190,    0,  190,    0,
			  190,    0,    0,    0,  189,  184,  184,  187,   95,   95,
			   95,   95,   95,   95,   95,   48,   95,   95,   95,   95,
			   95,   95,   57,   95,   95,   95,   95,   95,   95,   95,

			   67,   95,   69,   95,   73,   95,   95,   95,   95,   95,
			   95,   95,   95,   95,   95,   95,   86,   87,   95,   95,
			   95,   95,   92,    0,  169,  166,  153,  166,  152,  166,
			  155,  140,  190,  190,    0,    0,  190,    0,  189,    0,
			  189,    0,    0,  185,   36,   40,   41,   95,   95,   45,
			   95,   95,   95,   95,   95,   95,   55,   95,   95,   95,
			   95,   62,   95,   95,   95,   68,   95,   95,   95,   95,
			   95,   95,   95,   95,   82,   95,   95,   85,   95,   95,
			   90,   95,  166,  166,  166,  120,    0,  190,    0,  193,
			  190,  189,    0,    0,  189,    0,  188,    0,   42,   95,

			   95,   95,   49,   51,   95,   53,   95,   95,   58,   95,
			   95,   95,   95,   95,   95,   95,   76,   95,   78,   95,
			   80,   81,   83,   95,   95,   89,   95,  166,  166,  166,
			    0,  190,    0,    0,    0,  189,    0,  193,  189,    0,
			    0,  191,  193,  191,   95,   44,   95,   95,   95,   56,
			   60,   95,   63,   64,   95,   95,   95,   95,   79,   95,
			   95,   91,  166,  166,  166,  193,    0,  193,    0,  189,
			    0,    0,  192,  193,    0,  192,   43,   46,   52,   54,
			   61,   95,   71,   95,   77,   84,   88,  166,  158,  157,
			  193,  192,    0,  192,  192,   65,   75,  156,  192,    0>>)
		end

feature {NONE} -- Constants

	yyJam_base: INTEGER is 1662
			-- Position in `yy_nxt'/`yy_chk' tables
			-- where default jam table starts

	yyJam_state: INTEGER is 599
			-- State id corresponding to jam state

	yyTemplate_mark: INTEGER is 600
			-- Mark between normal states and templates

	yyNull_equiv_class: INTEGER is 1
			-- Equivalence code for NULL character

	yyReject_used: BOOLEAN is false
			-- Is `reject' called?

	yyVariable_trail_context: BOOLEAN is false
			-- Is there a regular expression with
			-- both leading and trailing parts having
			-- variable length?

	yyReject_or_variable_trail_context: BOOLEAN is false
			-- Is `reject' called or is there a
			-- regular expression with both leading
			-- and trailing parts having variable length?

	yyNb_rules: INTEGER is 195
			-- Number of rules

	yyEnd_of_buffer: INTEGER is 196
			-- End of buffer rule code

	yyLine_used: BOOLEAN is true
			-- Are line and column numbers used?

	yyPosition_used: BOOLEAN is false
			-- Is `position' used?

	INITIAL: INTEGER is 0
	MS: INTEGER is 1
	MSN: INTEGER is 2
	MSN1: INTEGER is 3
	VS: INTEGER is 4
			-- Start condition codes

feature -- User-defined features



end -- class ET_EIFFEL_SCANNER
