indexing

	description:

		"Hash tables, implemented with single arrays. %
		%Keys are hashed using `hash_code' from HASHABLE."

	library:    "Gobo Eiffel Structure Library"
	author:     "Eric Bezault <ericb@gobosoft.com>"
	copyright:  "Copyright (c) 2000-2001, Eric Bezault and others"
	license:    "Eiffel Forum Freeware License v1 (see forum.txt)"
	date:       "$Date: 2001/04/06 18:03:00 $"
	revision:   "$Revision: 1.14 $"

class DS_HASH_TABLE [G, K -> HASHABLE]

inherit

	DS_ARRAYED_SPARSE_TABLE [G, K]
		redefine
			new_cursor
		end

creation

	make, make_equal, make_default,
	make_map, make_map_equal, make_map_default

feature -- Access

	new_cursor: DS_HASH_TABLE_CURSOR [G, K] is
			-- New external cursor for traversal
		do
			!! Result.make (Current)
		end

feature {NONE} -- Implementation

	hash_position (k: K): INTEGER is
			-- Hash position of `k' in `slots'
			-- Use `k.hash_code' as hashing function.
		do
			if k /= Void then
				Result := k.hash_code \\ modulus
			else
				Result := modulus
			end
		end

end -- class DS_HASH_TABLE
